; "99 Bottles of Beer on the Wall" sample for ZAPF (V3)

; This demonstration doesn't use globals or the dictionary,
; and we can even get away without defining any objects for
; the status line since we never read input. But we still
; need to define these labels.

GLOBAL::                        ; global vars would go here
OBJECT::                        ; objects would go here
IMPURE::                        ; end of dynamic memory

; Some programs like to have a dictionary even though we
; never use it. This is a minimal dictionary.
VOCAB::
        .BYTE 0                 ; # of breaking punctuation marks
        .BYTE 4                 ; entry length (not that we have any)
        .WORD 0                 ; # of entries

; We will use abbreviations, though. First we define the strings.
        .FSTR FSTR1," of beer on the wall"
        .FSTR FSTR2," bottle"

; Now we put them in the game's abbreviation table.
WORDS::
        FSTR1                   ; .WORD is implied if we just give
        FSTR2                   ; an expression with nothing in front

ENDLOD::                        ; end of low memory

; Execution begins at the START label. We should still
; include a routine header even though this isn't really
; a routine, so local labels will work (if we have any,
; which in this case we don't).
        .FUNCT GO
START::
        CALL SING,99 >STACK     ; call the SING routine
        FSTACK                  ; we don't need its result
        QUIT                    ; game over once it returns

; This routine prints the song. It takes one parameter, the
; number of bottles to start with.
        .FUNCT SING,N
        ; line 1
TOP:    PRINTN N
        PRINTI " bottle"
        EQUAL? N,1 /NO-S-1
        PRINTC 115              ; 's'
NO-S-1: PRINTI " of beer on the wall,
"
        ; line 2 and 3
        PRINTN N
        PRINTI " bottle"
        EQUAL? N,1 /NO-S-2
        PRINTC 115
NO-S-2: PRINTI " of beer,
Take one down, pass it around,
"
        ; line 4, which could be the end
        DLESS? 'N,1 \MORE
        ; song's over, return
        PRINTR "No more bottles of beer on the wall!"
MORE:   PRINTN N
        PRINTI " bottle"
        EQUAL? N,1 /NO-S-3
        PRINTC 115
NO-S-3: PRINTI " of beer on the wall!

"
        ; repeat for the next verse
        JUMP TOP

; And we're done.
        .END
