!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2003.07.19 ORProp [Z, GLULX]
!	This class eases implementation of a generic object which does not need to be 
!	referenced in the game.  
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep :	ORLibraryMessages
!--------------------------------------------------------------------------------------
! Sample use: 
!
!			ORProp -> "butterflies" has pluralname with name 'butterflies';
!
! Used with the OREnglish LDF, this method has the advantage (over specifying words
! in the room's name property) of specifing pluralname and generating a default 
! message similar to "those don't need to be referenced in this game" rather than
! "that doesn't need to be ..."
!
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORProp";					!Constant USE_ORProp; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORProp; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2001.12.01	Initial Creation (Not really, but this is the earliest date I can find 
!				without searching my code archive)
! 2002.02.17	Tested for GLULX support
! 2002.02.18	Modified to not use the standard message (39). Added dependancy to the 
!				ORLibraryMessages module.
! 2002.02.21	Corrected typo in the new message created above 2002.02.18
! 2002.02.26	Fit to new template.
! 2002.05.19	Minor adjustment to "not significant" message.
! 2002.05.22	Added code to the "before" routine to allow props to be containers. (I 
!				know, they're not really props then, but it really can only help)
! 2002.05.24	Suppressed a warning.
! 2002.05.31	Allow props to be examined. Also reconsidered allowing props to be 
!				containers (2002.5.22).  That allows for problems when accessing 
!				other containers within the prop.
! 2003.01.11	Restored default item in before property of ORProp object. (Don't know
!				why it wasn't there.)
! 2003.02.01	Added a new property "message" to the ORProp object giving the 
!				developer the ability to override the default message on an object by 
!				object basis.
! 2003.02.15	Slowly but surely conquering my whole linefeed problem.
!--------------------------------------------------------------------------------------
#ifdef USE_ORProp;message "          Processing library extension ORProp...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- Uncomment for GLULX--- #ifdef TARGET_ZCODE; default WORDSIZE 2; #ifnot;default WORDSIZE 2; #endif; !--for GLULX compatability
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--------------------------------------------------------------------------------------
	#ifndef USE_ORLibraryMessages; Constant USE_ORLibraryMessages; message "          ****Forcing inclusion of ORLibraryMessages****"; #include "ORLibraryMessages"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORProp_DONEREPLACE; constant ORProp_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORProp_DONEMESSAGE; constant ORProp_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORProp requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORProp_DONECODE;constant ORProp_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	Class ORProp	
		has		scenery static
		with	before[;
						Examine: if(self provides description) rfalse;
						default:
							if(self.message~=0) 
								printorrun(self,message);
							else
								L__M(##Miscellany, 54,self); rtrue;]	
		,	message 0
		,	chooseobject[;return 0;] !--Take advantage of OREntryPoints, if included.  This will make the parser prefer other objects with the same name...
	;
	ORLibMessage 
		with body[; 
			Miscellany: if(lm_n==54){
							print (The)lm_o," ",(IsOrAre)lm_o," not significant. (It is not necessary to refer to ",(ig)ItOrThem(lm_o)," in the course of this game.)^";
							rtrue;
						}
		]
	;
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORProp_DONEGRAMMAR; constant ORProp_DONEGRAMMAR; #ifdef ORProp_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;

