!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.11.16 ORDoorInit	[Z, GLULX]
! Automatically fill in the found_in property for ORDoors based upon mapping data 
! giving the ability for the coder to create a working door *WITHOUT ANY* code.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep:	ORDoor
!			ORDynaString
!			ORObjectInitialise
!--------------------------------------------------------------------------------------
! Based upon a post to RAIF requesting a proposed door functionality by Peter Seebach.
! This module will allow an ORDoor object to be created without defining the found_in
! property.  This code is called one time at the game start and attempts to fill in 
! the found_in property based upon mapping information.  Obviously maps that change, 
! and therefore doors that are not connected to at game initialization cannot be 
! programmatically determined.  Using this module, the example code at the begining 
! of the ORDoor module is reduced to :
!
!		ORDoor RedDoor "red door" 
!			with	name "door" "red";
!
! And as a side note, use of the ORRecogName module will eliminate the need for the 
! "name" property as well.
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORDoorInit";					!Constant USE_ORDoorInit; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORDoorInit; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.02.08	Initial Creation
! 2002.02.25	Added code to supress inadvertant text messages from being displayed
! 2002.02.26	Fit to new template code
! 2002.11.16	Modified check of direction return value to discard return value 
!				if it is not an object.
!--------------------------------------------------------------------------------------
#ifdef USE_ORDoorInit;message "          Processing library extension ORDoorInit...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORObjectInitialise; Constant USE_ORObjectInitialise; message "          ****Forcing inclusion of ORObjectInitialise****"; #include "ORObjectInitialise"; #endif; 
	#ifndef USE_ORDoor; Constant USE_ORDoor; message "          ****Forcing inclusion of ORDoor****"; #include "ORDoor"; #endif; 
	#ifndef USE_ORDynaString; Constant USE_ORDynaString; message "          ****Forcing inclusion of ORDynaString****"; #include "ORDynaString"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORDoorInit_DONEREPLACE; constant ORDoorInit_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORDoorInit_DONEMESSAGE; constant ORDoorInit_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORDoorInit requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORDoorInit_DONECODE;constant ORDoorInit_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	ORDynaString __ords;
	object __init_ORDoors 
	  with object_initialise[room dir dest;
			objectloop(room provides	n_to or s_to or e_to or w_to
									or	nw_to or sw_to or ne_to or se_to
									or	u_to or d_to){
				objectloop(dir in compass){
					if(room provides (dir.door_dir)){
						if(metaclass(room.(dir.door_dir))~=object) continue; !--don't do anything with a string...
						__ords.capture(); !--suppress any messages that the direction routines may spit out...
						dest=valueorrun(room,(dir.door_dir));
						__ords.release();
						if(dest ofclass ORDoor && WordInProperty(room,dest,found_in)==false){
							if((dest.&found_in-->0)==0)
								(dest.&found_in-->0)=room;
							else{
								if((dest.&found_in-->1)==0)  
									(dest.&found_in-->1)=room;
								else{
#ifdef DEBUG;
									print "Warning. Inconsistency found with map.  Door ~",(object)dest,"~ has too many found_in entries detected.";
#endif;
								}
							}
						}
					}
				}
			}
#ifdef DEBUG;
									objectloop(dest ofclass ORDoor && dest provides found_in && dest.#found_in>1){
										if(dest.&found_in-->0==0 || dest.&found_in-->1==0) {
											print "^ERROR found.  Door ",(object)dest," does not connect two locations.  An unmodified version of the library routine MoveFloatingObjects() will generate errors.^";
										}
									}
#endif;
		]
	;
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORDoorInit_DONEGRAMMAR; constant ORDoorInit_DONEGRAMMAR; #ifdef ORDoorInit_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;