!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.04.03 ORBracketParserMsgs [Z, GLULX]
! Add brackets, or other wrapping characters to parser generated messaages.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep:	none
!--------------------------------------------------------------------------------------
! ORBracketParserMsgs depends upon the OREnglish LDF, which was coded to leverage this
! entry if present. Simply including this module will wrap all parser generated 
! messages in [brackets].  If, for some reason, the developer would like to turn off 
! bracketing in the middle of a game, the global variable BracketedParserMsgs can be 
! set to false to accomplish this.  Additionally, the global variables BracketOpen, and
! BracketClose have been provided to set what text the messages will be wrapped in.
! For example, if the developer would prefer to wrap the parser messages like HTML tags
! and tab them over, then the following lines of code could be added to the 
! Initialise() routine:
!
!	BracketOpen="@@9<"; !--TAB is @@9
!	BracketClose=">";
!
! Note (about future extensions):
! For the most part, the standard library was coded to allow all desired text changes 
! to be made in the language definition file, or the LibraryMessages object.  Sadly, 
! most is not all.  There are a couple of parser messages that, for some inexplicable 
! reason, are partially generated from the LDF, and partially hard-coded in the parser.  
! Message number 28 ("I only understood you as far as..." ) is one example of a
! troublesome message to try and wrap in brackets without modifying the standard 
! library itself.  Still, I believe that almost all of the player specific text has been
! successfully wrapped with two exceptions: Misc 45 & 46 "Who (or What) do you mean...?"
! These two messages will require relatively simple changes to parser code, but in an 
! extreamly large function.  It is not a viable solution to replace the NounDomain routine
! at this time.  However, there are plans to create on ORNounDomain module which will break 
! the routine up into replacable modules at a later date. OrBracketParserMsgs will leverage 
! this module when it is available.
!
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORBracketParserMsgs";					!Constant USE_ORBracketParserMsgs; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORBracketParserMsgs; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.02.12	Initial Creation (not really, but this is the earlist date I could find 
!				without searching my code archive)
! 2002.02.26	Fit to new template.
! 2002.03.11	Added code to prompt warning message if OREnglish is not used.
! 2002.04.03	modified faulty WORDSIZE definition.
!--------------------------------------------------------------------------------------
#ifdef USE_ORBracketParserMsgs;message "          Processing library extension ORBracketParserMsgs...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORBracketParserMsgs_DONEREPLACE; constant ORBracketParserMsgs_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------
	replace LMode1Sub;
	replace LMode2Sub;
	replace LMode3Sub;
	replace scoresub;
	replace fullscoresub;
	Replace PrintCommand;	
	Replace NotifyTheScore;	

	Global BracketedParserMsgs=true;
	Global BracketOpen="[";
	Global BracketClose="]";

	[bkt_o; if(BracketedParserMsgs==true) print (string)BracketOpen;];
	[bkt_c; if(BracketedParserMsgs==true) print (string)BracketClose;];
	[bkt txt;
		bkt_o();
		print (string)txt;
		bkt_c();
	];

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORBracketParserMsgs_DONEMESSAGE; constant ORBracketParserMsgs_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
	#ifndef OREnglish; message "WARNING!!!! ORBracketParserMsgs requires the OREnglish file to function.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORBracketParserMsgs_DONECODE;constant ORBracketParserMsgs_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	#ifndef PrintRank;
		[ PrintRank; print "."; ];
	#endif;

	[ LMode1Sub; lookmode=1; bkt_o();print (string) Story; L__M(##LMode1); ];  ! Brief
	[ LMode2Sub; lookmode=2; bkt_o();print (string) Story; L__M(##LMode2); ];  ! Verbose
	[ LMode3Sub; lookmode=3; bkt_o();print (string) Story; L__M(##LMode3); ];  ! Superbrief

	[ FullScoreSub i;
	ScoreSub();
	if (score==0 || TASKS_PROVIDED==1) rfalse;
	new_line;
	bkt_o();
	L__M(##FullScore,1);

	for (i=0:i<NUMBER_TASKS:i++)
		if (task_done->i==1)
		{   PANum(task_scores->i);
			PrintTaskName(i);
		}
	  
	if (things_score~=0)
	{   PANum(things_score); L__M(##FullScore,2); }
	if (places_score~=0)
	{   PANum(places_score); L__M(##FullScore,3); }
	new_line; PANum(score); L__M(##FullScore,4);
	bkt_c();
	];
	[ ScoreSub;
	bkt_o();
	L__M(##Score);
	PrintRank();
	bkt_c();
	print "^";
	];
	[ NotifyTheScore;
		new_line;
		bkt_o();
		L__M(##Miscellany, 50, score-last_score);  print ".";
		bkt_c();
		new_line;
	];
	[ PrintCommand from i k spacing_flag;

	if (from==0)
	{   i=verb_word;
		if (LanguageVerb(i) == 0)
			if (PrintVerb(i) == 0)
				print (address) i;
		from++; spacing_flag = true;
	}

	for (k=from:k<pcount:k++)
	{   i=pattern-->k;
		if (i == PATTERN_NULL) continue;
		if (spacing_flag) print (char) ' ';
		if (i==0) { print (string) THOSET__TX; jump TokenPrinted; }
		if (i==1) { print (string) THAT__TX; jump TokenPrinted; }
		if (i>=REPARSE_CODE) print (address) No__Dword(i-REPARSE_CODE);
		else print (the) i;
		.TokenPrinted;
		spacing_flag = true;
	}
	if(_DoEndBracket==true){
		if(BracketedParserMsgs==true) print (string)BracketClose;
		_DoEndBracket=false;
	}
	];
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORBracketParserMsgs_DONEGRAMMAR; constant ORBracketParserMsgs_DONEGRAMMAR; #ifdef ORBracketParserMsgs_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;