!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.10.13 ORAskTellOrder [Z] [GLULX]
! A Wrapping of Irene Callaci's AskTellOrder contribution.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Author: Irene Callaci
! Wrapped by: Jim Fisher
! This is a modified wrapping of Irene Callaci's especially useful AskTellOrder routine.
!
! Note: It is a sad but (un)true fact that I suffer from a medical condition 
! called "transformare logos compellere" and I am compelled to change text where ever
! I see it.  It is, therefore, the case that I have modified this routine in a few places
! here and there where it seemed to me to be desireable to do so.  So it is that
! this version in Irene's fabulous library routine 1) works with the ORRecogName 
! module of the ORLibrary, and 2) works with Glulx.
!
! The original header to this file appears below.  Note that the directions as to 
! where to include this file in your source do not apply to this version (since the 
! ORLib framework takes care of this) and are included only for completeness.  
!--------------------------------------------------------------------------------------
	! AskTellOrder by Irene Callaci (icallaci@csupomona.edu)
	!
	! The BeforeParsing() routine included below reparses the player's input,
	! converting:
	!
	!		ASK/TELL THE NPC TO DO SOMETHING
	! into
	!		NPC, DO SOMETHING
	!
	! so that your NPC's orders routine can handle it. No modification to the
	! grammar for ASK or TELL is required.
	!
	! BeforeParsing() is an Inform entrypoint, so include it after Verblib but
	! before Grammar.
	!
	!	Irene Callaci	 -	icallaci@csupomona.edu
	!	March 12, 1999
	!
	! Updates:
	! 1. Added a switch to allow ASK NPC ABOUT <topic>, where <topic> includes the word 'to',
	!    such as ASK COP ABOUT WITNESSES TO THE ACCIDENT -- January 5, 2000
	! 2. Truncate input before retokenising -- January 5, 2000
!--------------------------------------------------------------------------------------
! AutoDep:	
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#ifdef USE_ORAskTellOrder; #include "ORAskTellOrder"; #endif;
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORAskTellOrder; 
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.07.22	Initial Creation
! 2002.08.31	Modified to reference the new OREntryPoints module.
! 2002.10.13	Changed return value to false so that routine will continue to call other 
!				versions.
!--------------------------------------------------------------------------------------
#ifdef USE_ORAskTellOrder;message "          Processing library extension ORAskTellOrder...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
	#ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORObjectInitialise; Constant USE_ORObjectInitialise; message "          ****Forcing inclusion of ORObjectInitialise****"; #include "ORObjectInitialise"; #endif; 
	#ifndef USE_ORRoutinesList; Constant USE_ORRoutinesList; message "          ****Forcing inclusion of ORRoutinesList****"; #include "ORRoutinesList"; #endif; 
	#ifndef USE_OREntryPoints; Constant USE_OREntryPoints; message "          ****Forcing inclusion of OREntryPoints****"; #include "OREntryPoints"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORAskTellOrder_DONEREPLACE; constant ORAskTellOrder_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORAskTellOrder_DONEMESSAGE; constant ORAskTellOrder_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORAskTellOrder requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORAskTellOrder_DONECODE;constant ORAskTellOrder_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	object with object_initialise[; ORBeforeParsing.add_routine(self.bp);]
	,	bp[i w skip inc bufsize; 
#ifndef TARGET_GLULX;
					bufsize=buffer->1;
#ifnot;
					bufsize=buffer-->0;
#endif;			
		! Find verb_wordnum (usually 1, but not when the command is NPC, VERB THE <OBJECT>)
		while(wn<num_words)
		{	w = NextWord();
			if (w == comma_word) break;
		}
		if (wn >= num_words) wn = 1;

		w = NextWord();
		if(w=='ask' or 'tell'){
			! First, count any blank spaces at the beginning of input
		
			for (i = WORDSIZE : i < bufsize+WORDSIZE : i++) {	
				if (buffer->i == ' ') skip++;
				else break;
			}

			! Next, count the number of letters in the first word (ASK or TELL)
			skip = skip + WordLength(wn - 1) + 1;

			! Now get the next word. If it's an article, count the number of
			! letters it contains so we can overwrite it later. If we don't do
			! this, we end up with invalid input like: THE NPC, VERB
			w = NextWord();
			if (w == 'a//' or 'an' or 'the')
			{	skip = skip + WordLength(wn - 1) + 1;
				w = NextWord();
			}

			! Now we've reached a likely spot for the NPC's name. Because NPCs can
			! have more than one name (CHARLIE SMITH, for example), we loop until
			! we find the word "to" or some other word that signals the start of
			! the actual command.
			while(wn<num_words) !-- (w ~= 0) !--Jim Fisher... Required to support ORRecogName module
			{	! We need to know how long the NPC name is so that we can skip over
				! it later without overwriting it.
				inc = inc + WordLength(wn - 1) + 1;
				w = NextWord();
				switch (w)
				{	'about':
						! Stop reparsing here to avoid problems with ASK COP ABOUT WITNESSES TO THE ACCIDENT (otherwise, the 'to' below will trigger an NPC order)
						rfalse;
					'to':
						! Find the word "to" in the input and replace it with a
						! comma followed by a blank (to erase the "o").

						for (i = skip + inc + 1 : i <= bufsize + 1 : i++){	
							if (buffer->i == ' ' && buffer->(i+1) == 84 or 116 && buffer->(i+2) == 79 or 111 && buffer->(i+3) == ' ')
							{	
								buffer->(i+1) = 44;		! ascii code for comma
								buffer->(i+2) = ' ';
								break;
							}
						}

						! Move the NPC's name and everything following it to the
						! left, overwriting as we go.
						for (i = WORDSIZE : i <= bufsize + WORDSIZE : i++)
							buffer->i = buffer->(i + skip);

						! Truncate the command and retokenise the input.
#ifndef TARGET_GLULX;
						buffer->1 = (buffer->1) - skip;
#ifnot;
						buffer-->0 = (buffer-->0) - skip;
#endif;			
						Tokenise__(buffer, parse);
						rfalse; !-- Jim Fisher: Normally BeforeParsing return values are ignored, but plugging this into the ORRoutineList object to simulate Additive routines looks at the return value to decide whether or not to continue calling other registered BeforeParsing routines. (Like additive properties, true means we've done something so discontinue) We should probably always return false here, so that other registered handlers can have a go at the input as well
				}
			}
		}
		else rfalse;
	];
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORAskTellOrder_DONEGRAMMAR; constant ORAskTellOrder_DONEGRAMMAR; #ifdef ORAskTellOrder_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;