Object Toolbox "toolbox" Scooter
  with
    name "toolbox" "tool" "box",
    description
    [; print "Stencilled on the side of ", (the) Toolbox, " in bright yellow 
              letters are the words ~Property of Maintenance Task Force.~ It
              much have been left by a maintenance technician. ";
       <<SEARCH TOOLBOX>>;
    ],
    before
    [;Break, BreakWith: "You try to break the lock but fail."; 
      Unlock: if ((Player in Couch) && (Toolbox in Scooter))
                 <<TAKE TOOLBOX>>;
              if ((Second == Ram) && (Toolbox has locked))
                "You don't want to damage anything that might be in it, find 
                 a key.";
      Open, Close, Take, Lock: 
      if ((Player in Couch) && (Toolbox in Scooter))
        "You can't reach it from the pilot's couch.";
      Receive: if (noun has huge)
                 "That is too big to put in ", (the) Toolbox,".";
    ],
    add_to_scope Lock3,
    with_key key,
    has huge lockable locked openable ~open container;

Object ->-> Glue "bottle of super glue",
  with
    name "bottle" "of" "super" "glue",
    description
    [; if (Glue.state == stuck)
         "This stuff isn't good for anything now, as the top is glued to the
          bottle.";
       "This stuff is only good for three things: gluing the top to the 
        bottle, gluing your fingers together, and gluing your fingers to the 
        bottle. Of course occasionally you might actually manage to glue   
        something else.";
    ],
    before
    [;use: if (Glue.state == stuck)
             "The top appears to be glued to the bottle.";
           "Nothing needs gluing at the moment."; 
      eat: if (hungry == 0) "Thanks, but you're not hungry."; 
           if (Glue.state == stuck)
             "The top appears to be glued to the bottle.";
    ],
    after
    [;Eat: deadflag=3;
           "Mmmm... one of your favourites... Superglue. [I was going to say
            something else but my mouth seems to be stuck together, so this
            game is going to terminate as you can't have a text adventure
            without text.]"; 
    ],
    state other,
    has transparent edible;

Object ->->-> Top "top"
  with 
    name "top",
    description
    [; if (Glue.state == stuck)
         "It appears to be glued to the bottle.";
      "That has a lot of dryed up glue around it.";
    ],
    before
    [;take, remove: 
        if (Glue.state == stuck)
          "It appears to be glued to the bottle.";
        "You only need to remove that, when you want to glue something."; ],
    has concealed;
               
Object ->-> Bracelet "identity bracelet"
  with
    name "bracelet" "identity-bracelet", article "an",
    description
      "It appears to have a lot of complex electronics and sensors built 
       into it. Perhaps it's triggered by body heat.",
    has clothing; 

Object ->-> Hacksaw "hacksaw"
  with
    name "hacksaw" "saw",
    description 
      "The hacksaw will cut through just about anything.", 
    before
    [;CutWith: if (noun==Hacksaw) <<CUT HACKSAW>>;
      Cut: "That's like trying to touch your elbow with your hand. 
            Impossible!"; ],
    has big; 

Object ->-> Paste "tube of nutrient paste"
  with
    name "tube" "of" "paste" "nutrient" "nutrient-paste",
    description
      "The tube is full of anchovy and peanut butter paste.", 
    before
    [;Empty: "You don't want to make a mess.";
      Drink: "You can't drink ", (the) Paste, ", but I bet you can eat it.";
      Eat: if (hungry == 0) "Thanks, but you're not hungry."; 
      Open: "Best not to open ", (the) Paste, " until you want to eat it.";
      Close: "That's already closed."; 
    ],   
    after
    [;Eat: hungry = 0;
           mt = spacetime + NEXT_MEAL;
           move Tube to Player;
           print "Mmmm... one of your favourites... anchovies and peanut
                  butter.
                  You empty the entire tube, and your hunger dissipates.^";
           rtrue;
    ],
    has edible;

Object Tube "empty tube of nutrient paste"
  with
    name "empty" "tube" "paste" "nutrient" "nutrient-paste", article "an",
    description
      "The tube is empty.",
    before
    [;Empty: "It's already empty.";
      Eat: "There's none left!";
      Open: "No need to open ", (the) Tube, ", it's empty!";
      Close: "That's already closed."; 
    ];   
    
Object Syringe "empty hypodermic syringe" Sickbay
  with
    name "empty" "hypodermic" "syringe", article "an",
    initial 
    [; "Lying discarded on the deck is ", (a) Syringe, "."; ],
    description
    "It has a plunger and a needle, and has ~Sedative~ written on it.",
    before 
    [;receive, use:
      "~Medical equipment may only be used by qualified staff, except
      in extreme emergencies.~^
      STELLAR PATROL REGULATIONS, Paragraph 48, Subsection XII.^
      This isn't an extreme emergency, well not yet anyway. That electric
      shock training at boot camp, really worked, didn't it.";
    ],
    has big transparent;

Object Needle "needle" Syringe
  with
    name "needle" "big",
    description "It's VERY big.",
    before 
    [;use:
      "~Medical equipment may only be used by qualified staff, except
      in extreme emergencies.~^
      STELLAR PATROL REGULATIONS, Paragraph 48, Subsection XII.^
      This isn't an extreme emergency, well not yet anyway. That electric
      shock training at boot camp, really worked, didn't it.";
    ];
 
Object Plunger "plunger" Syringe
  with
    name "plunger",
    description "This allows liquid to be taken into the syringe, so it can
                 later be discharged.",   
    before 
    [;use:
      "~Medical equipment may only be used by qualified staff, except
      in extreme emergencies.~^
      STELLAR PATROL REGULATIONS, Paragraph 48, Subsection XII.^
      This isn't an extreme emergency, well not yet anyway. That electric
      shock training at boot camp, really worked, didn't it.";
    ];
 
Object Ram "hydraulic ram" 
  with
    name 
     "hydraulic" "ram" "wood" "wooden" "board" "boards" "bar" "bars" 
     "syringe" "hose" "hosing" "tubing" "contrapition" "machine" "fluid" 
     "can" "jerry" "built" "jerry-built",
    description 
      "This rather hastily assembled contraption looks like it just might 
       work, once at least. A can holds the hydraulic fluid, which is 
       compressed into the hosing by a syringe, thus allowing enough force 
       to be built up between the two steel bars for it to operate as a 
       ram. The wood holds it all together, just about. It looks like it 
       could open just about anything, except a First Galactic Bank of 
       Nebulon force field safe.",
    before
    [; use: "[Such general commands won't work. To use ", (the) Ram,
              " you must type OPEN <OBJECT> WITH THE HYDRAULIC RAM.]"; ],
    state other,
    has huge; 
