/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.zmpp.base.DefaultMemoryAccess;
import org.zmpp.blorb.BlorbResources;
import org.zmpp.blorb.BlorbStory;
import org.zmpp.iff.DefaultFormChunk;
import org.zmpp.iff.FormChunk;
import org.zmpp.io.IOSystem;
import org.zmpp.io.InputStream;
import org.zmpp.media.Resources;
import org.zmpp.swingui.FileSaveGameDataStore;
import org.zmpp.swingui.ZmppFrame;
import org.zmpp.vm.Machine;
import org.zmpp.vm.MachineFactory;
import org.zmpp.vm.SaveGameDataStore;
import org.zmpp.vm.ScreenModel;
import org.zmpp.vm.StatusLine;
import org.zmpp.vmutil.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationMachineFactory
extends MachineFactory<ZmppFrame> {
    private File storyfile;
    private File blorbfile;
    private ZmppFrame frame;
    private FormChunk blorbchunk;
    private SaveGameDataStore savegamestore;

    public ApplicationMachineFactory(File file, File file2) {
        this.storyfile = file;
        this.blorbfile = file2;
    }

    public ApplicationMachineFactory(File file) {
        this.blorbfile = file;
    }

    @Override
    protected byte[] readStoryData() throws IOException {
        if (this.storyfile != null) {
            return FileUtils.readFileBytes(this.storyfile);
        }
        FormChunk formChunk = this.readBlorb();
        return formChunk != null ? new BlorbStory(formChunk).getStoryData() : null;
    }

    private FormChunk readBlorb() throws IOException {
        byte[] byArray;
        if (this.blorbchunk == null && (byArray = FileUtils.readFileBytes(this.blorbfile)) != null) {
            this.blorbchunk = new DefaultFormChunk(new DefaultMemoryAccess(byArray));
            if (!"IFRS".equals(new String(this.blorbchunk.getSubId()))) {
                throw new IOException("not a valid Blorb file");
            }
        }
        return this.blorbchunk;
    }

    @Override
    protected Resources readResources() throws IOException {
        FormChunk formChunk = this.readBlorb();
        return formChunk != null ? new BlorbResources(formChunk) : null;
    }

    @Override
    protected void reportInvalidStory() {
        JOptionPane.showMessageDialog(null, "Invalid story file.", "Story file read error", 0);
        System.exit(0);
    }

    @Override
    protected ZmppFrame initUI(Machine machine) {
        this.frame = new ZmppFrame(machine);
        this.savegamestore = new FileSaveGameDataStore(this.frame);
        return this.frame;
    }

    @Override
    public ZmppFrame getUI() {
        return this.frame;
    }

    @Override
    protected IOSystem getIOSystem() {
        return this.frame;
    }

    @Override
    protected InputStream getKeyboardInputStream() {
        return this.frame;
    }

    @Override
    protected StatusLine getStatusLine() {
        return this.frame;
    }

    @Override
    protected ScreenModel getScreenModel() {
        return this.frame.getScreenModel();
    }

    @Override
    protected SaveGameDataStore getSaveGameDataStore() {
        return this.savegamestore;
    }
}

