/*
 *   Copyright (c) 1999, 2002 by Michael J. Roberts.  Permission is
 *   granted to anyone to copy and use this file for any purpose.  
 *   
 *   This is a starter TADS source file.  This is a complete TADS game
 *   that you can compile and run.
 *   
 *   To compile this game in TADS Workbench, open the "Build" menu and
 *   select "Compile for Debugging."  To run the game, after compiling it,
 *   open the "Debug" menu and select "Go."
 *   
 *   This is the "advanced" starter game - it has only the minimum set of
 *   definitions needed for a working game.  If you would like some more
 *   examples, create a new game, and choose the "introductory" version
 *   when asked for the type of starter game to create.  
 */
master_room : room
        sdesc = "Boston Commons"
        ldesc = "Boston Commons"
	
        out = startroom
        east = startroom
;

reward: fixeditem
    noun = 'reward'
    adjective = 'more'
    location = nil
    sdesc = "reward"
    ldesc = {"<H1>Fame and Glory</H1>\n
\n
	     What do you want, a cookie?\n
	     <PRE>
\n
\n
\n
	     </PRE>\n



	     <H1>The End The End The End</H1>\n\n

	     <H1>The End The End The End</H1>\n
	     <H1>The End The End The End</H1>\n";
	     incscore(5);
	     quitVerb.action(Me);
	     terminate;
	     quit;
	     abort;
	 }
;
	     
getStick: function(actor)
{
    local i, max;
    max := length(actor.contents);
    for (i := 1; i <= max; i++)
    {
	if (isclass (actor.contents[i],stick_class))
	{
	    return actor.contents[i];
	}
    }
    return nil;
}

master: Actor
	noun =  'master'
	adjective = 'wise' 'noble' 'tall' 
	location = master_room
	adesc = "Your Master"
	sdesc = "Master"
	ldesc = "The wise and noble Master. You are honored to serve such a noble being. He is a tall reagle man, and he has bade you fetch the stick";
;


compoundWord 'get' 'mad' 'getmad';
madVerb: deepverb
	verb = 'getmad'
	action = "<p>You are really really mad. If you weren't colorblind, then you'd probably be seeing red. The old heart starts pumping, blood pressure rises, adrenaline surges, your eyes go bloodshot. You slowly transform from the friendly neighborhood dog to a hellhound of mythological temperament. </p>
<p>Not that it helps any. </p>"
;

wallowVerb: deepverb
	verb = 'wallow'
	action = "<p>You see master now saying Bad dog, bad dog Oh, it is too much to bear. How could you have failed so miserably? How could fate be so cruel? Why can't we all live together in peace and harmony without killing each other in this senseless violence? Why did Elvis have to die of a drug overdose? </p>
<p>You can <b>sink into depression</b> </p>
<p><b>Commit hara-kiri</b></p>
<p>Or just <b>whimper</b> for a while longer <p>"
;

wimperVerb: deepverb
	verb = 'wimper'
	action = "<p>Wimper Sound Effect</p> "
;

compoundWord 'shake' 'it' 'shakeit';
compoundWord 'shakeit' 'off' 'shakeitoff';
shakeOffVerb: deepverb
	verb = 'shakeitoff'
	action = "<p>Doggone it, these are the breaks.</p> "
;

compoundWord 'commit' 'hari' 'commithari';
compoundWord 'commithari' 'kari' 'commitharikari';
commitHariKariVerb: deepverb
	verb = 'commitharikari'
	action = "<p>This type of ritual stems from feudal Japan in which the Shogunate fell upon their swords when dishonored. You have neither a sword or the guts to spill all over the ground.</p> "
;

depression: decoration
	noun = 'depression'
	adjective = 'deep'
	sdesc = "depression"
	location = Me
	verDoSink(actor) = {}
	doSink(actor) = sink_depression()
	verIoSinkIn(actor) = {}
	ioSinkIn (actor, dobj) = sink_depression()
;

sinkVerb: deepverb
	verb = 'sink'
	sdesc = "sink"
	prepDefault = inPrep
	action (actor) = sink_depression()
	doAction = 'Sink'
	ioAction(inPrep) = 'SinkIn'
	doDefault(actor, prep, io) =
	{
        		return [ Me ];
    	}
;

sink_depression: function
{"<p>Well, there is obviously no point in continuing the game if you are going to be that morose. After all, the whole point is to have fun. Why don't you turn off the computer, go outside, get some fresh air and either continue this later or not at all.</p> 
<p>THE END</p>";
		morePrompt;
		quit();
}

fetchVerb: deepverb
	verb = 'fetch'
	doAction = 'Take'
;

kid : fixeditem
	location = startroom
	noun = 'boy' 'child' 'kid' 'kids' 'tyke'
	adjective = 'small'
	sdesc = "little kid"
	ldesc = "This tyke looks about eight years old. He has brownish hair and a few freckles. An oversized Boston Bruins sweat shirt is draped over his small frame.
You feel an intense urge to devour him whole."
;
/* end master */

esplenade : room 
        sdesc = "The Esplenade"
        ldesc = "This would be a cool place to hang out and listen to music. Lots of
college age people are whizzing by on roller blades. A few people
are tossing <b>frisbees</b><p>
You may go <b>north</b> or <b>west</b>
		 <p><img align=top src='artwork/jab9.png'><p>\n"
        west = startroom
        north = harvard_bridge
; 

frisbee : fixeditem
	location = esplenade
	noun = 'frisbee' 'frisbees'
	sdesc = "frisbee"
	ldesc = "
A couple of college kids toss a white frisbee, which is covered with
writing. A closer glance reveals clippings of frisbee poetry. The
words appear in an almost random order due to the difficulty of reading a
spinning frisbee.<P>
\b
    in the spring the weather chase me down\n
       from I can snow to rain to changes sun to warm\n
    the temp hits clouds will cast\n
       they high and low and in\n 
\b
   and on an off chance that I make the fields right cut\n
      the other team different ranges trying to \n
   I can ass catch it in end zone!\n
      then run and yell and \n
\b
    It is great on the time (real fast)\n
       real to play hard of grass, and maybe kick some \n
          but while good times like these go by \n
             and next jump and bound week, who knows what the norm shadows\n
                 so I am glad these things enjoy, and pass.\n
                 so I am glad these things enjoy, and pass.\n
\b

Words (though not in this particular order)\n
by D. Mariott"
;
/* end esplenadeobjects */



harvard_bridge: room
        sdesc = "Harvard Bridge"
        ldesc = "<p>You are on a long bridge, spanning a wide swath of the Charles river. 
A funny looking <b>fellow</b> seems to be causing some commotion.</p> <p><img src='artwork/jab3.png'></p>
<p>You can go <b>north</b> or <b>south</b></p>"
	south = esplenade
        north = mass_ave_77
;

smoot: fixeditem
	location = harvard_bridge
	noun = 'smoot' 'fellow'
	sdesc = 'smoot'
	ldesc = "The is a short fellow here about 5'7\". You notice that his clothes are very clean and new. He is immaculately groomed, is wearing highly polished shoes. The man is not smiling. Something seems strangely familiar about this fellow, but maybe it's just the vague resemblance to Ross Perot. 
He seems to be laying down on the sidewalk at the very end of the bridge. Some college kids with a tape measure and and cans of paint are hovering around him. "
;
/* end harvard bridge */


#include "inside.t"



	
	


