#include "subway.t"

mass_ave_77: room
        sdesc = "77 Mass Ave"
        ldesc = "<p>This is the main entrance to MIT. Huge pillars add the air of a 
<b>Greek temple</b>  to the urban surroundings.</p>
<p>You see a <b>traffic light</b></p>
<p>You can go <b>west</b> to the street or <b>in</b> to the building </p>"
	west = mass_ave_crosswalk
        east =  lobby_7
        in =  lobby_7
;

mass_ave_crosswalk: obstacle
    destination =
    {
	if (time_frequent(0))
	{
	    notify(mass_ave,&start_honking,3);
	    return mass_ave;
	}
	else
	{
	    "<hr>\n
	     If this was any other town, you might have had a chance. But
	     jay walking in front of Boston drivers is just not a good idea.
	     <p>\n
	     Unfortunately, there is no user interface capable of
	     transmitting
	     the intense pain of being struck by a moving car. Therefore we
	     ask that you close your eyes, and imagine yourself as roadkill
	     scattered across the street.<p>\n
	     With this lurid imagery in mind, you have enough sense not to
	     run out into the road.<p>\n
	     <hr>\n";
	    return nil;
	}
    }
;
		   



traffic_light: fixeditem
	location = mass_ave_77
	noun =  'traffic' 'light'
	sdesc = "traffic light"
	ldesc =  "The Massachusetts Avenue traffic light is << self.color >>" 
	color =
	{
	    if (time_frequent(0)) 
		return 'green';
	    else
		return 'red';
	}
;

traffic_light_grassy: fixeditem
	location = grassy_area
	noun =  'traffic' 'light'
	sdesc = "traffic light"
	ldesc =  "The Massachusetts Avenue traffic light is << traffic_light.color >>" 
;

traffic_light_central_sq: fixeditem
	location = central_square
	noun =  'traffic' 'light'
	sdesc = "traffic light"
	ldesc =  "The Massachusetts Avenue traffic light is << traffic_light.color >>" 
;

temple: fixeditem
	location = mass_ave_77
	noun =  'temple' 'entrance' 'building'
	adjective = 'greek'
	sdesc = "The main entrance to MIT"
	ldesc = "It's funny how this revivalist architecture works. Every time they copy the style of another era, the quality goes down. This building seems to be fourth generation. "
;

/* end mass_ave_77*/

mass_ave_shut_up: function (room)
{
    unnotify(mass_ave,&start_honking);
    unnotify(mass_ave,&honk);
    return room;
}

mass_ave: room
	sdesc = "Mass Ave."
	ldesc = "<p>A traffic light keeps pedestrians alive.</p>
<p>You can travel towards the <b>north</b>, <b>south</b>, <b>west</b>, or the <b>east</b></p>"
	honk = "Drivers honk at you to get out of the street!"
	start_honking = {notify(self,&honk,0);}
	north = {return mass_ave_shut_up(central_square);}
	south = {return mass_ave_shut_up(harvard_bridge);}
	east = {return mass_ave_shut_up(mass_ave_77);}
	west = {return mass_ave_shut_up(grassy_area);}
; 

grassy_area: room
	sdesc = "Grassy Area"
	ldesc = "<p>The greenery makes city life a little more bearable. You can see the <b>traffic light</b> from here.</p>
<p> There is a <b>poster</b> here. </p>
<p>You can enter a <b>building</b> to the <b>north</b> or hit the street to the <b>east</b> or go <b>south</b></p>
<img src='artwork/jab6.png'>" 
	north = stud_center
	east = mass_ave_crosswalk
	south = pierce_boathouse
;

student_center_exterior: fixeditem
	location = grassy_area
	noun = 'building' 'center'
	adjective = 'student'
	sdesc = 'Student Center'
	ldesc = "<img src='artwork/jab7.png'>"
;

poster: fixeditem
	location = grassy_area
	noun = 'poster'
	sdesc = "poster"
	ldesc = "Tired of waiting for the light? Hate running to classes. Sick of walking across Mass Ave? Always getting hit by cars? Check out Honest Bob's Alternative Transport, conveniently located in Killian court. "
;

/* end grassy area obj */


hydrant: fixeditem
    noun = 'hydrant'
    adjective = 'fire' 'red'
    sdesc = "Fire Hydrant"
    location = pierce_boathouse
    ldesc = "<p>Multiple peeling layers of red paint cover the fire
    hydrant. Amazingly, there are no cars parked illegally here. A
    less well heeled canine might be tempted to lift their leg. </p>\n
	     <img src='artwork/jab10.png'>"
    verDoPeeOn(actor)={}
    doPeeOn(actor)={ "You give in to the temptation to add your mark to
	       the others on this hydrant.
	       Master had trained you better than that!\n";
	      incscore(-10);
	  }
;

pierce_boathouse: room
	sdesc = "Pierce Boat House"
	ldesc = "<p>The aroma of the Charles River drifts through the air like fertilizer on a farm. There is a <b>fire hydrant</b> here.</p>
<p>You can go <b>north</b> or <b>south</b></p> "
	north=grassy_area
	south=charles_river
;

charles_river: room
	sdesc = "The Charles River"
	ldesc = "<p>The Charles is looking as polluted as ever. You are on a rickety boat dock that is slowly being eaten away by the water. A crew team is docked here.</p> 
<p>Some<b>thing</b> seems to be in the water!</p>
<p>You can go <b>north</b> </p>"
	north=pierce_boathouse
;

something_inwater: fixeditem
	location = charles_river
	noun = 'something' 'thing'
	adjective = 'floating'
	sdesk = "Something in the water"
	ldesc  = "<p>It's funny - nothing could be alive in this water
	except perhaps for some mutant fish. You keep seeing some
	ripples out of the corner of your eye - but nothing seems
	substantial. Must be your hyperactive imagination.</p>
	<img src='artwork/jab16.png'>"
;

crew: fixeditem
	location = charles_river
	noun = 'team'
	adjective = 'crew'
	sdesc = "crew team"
	ldesc = "<p>A bunch of athletic looking people are sitting in an eight, preparing to endure intense pain yet another day. The close knit community must work together to achieve speed and its accompanying prestige. <p>"
;
/* end charles river objects */

central_square: room
	sdesc = "Central Square"
	ldesc = "<p>Everything about this area says, \"city.\" If it's not the
pavement and the buildings, then it is the look on people's faces as they
walk by without really seeing each other. A firehouse awaits further inspection to the <b>north</b>.
</p>
<p>There is a subway here, that you can go <b>in</b>.
 </p>
<p>You can go <b>south</b></p>"
	north = firehouse
	in = red_line
	south = mass_ave_crosswalk
;

firehouse: room
	sdesc = "firehouse"
	ldesc = "<p>A trusty squad of volunteers man the station,
		 ready at any moment to slide down steel poles and hop into a
		 big red truck.</p> 
		 <p>You can step back out to the street to the
		 <b>south</b></p>" 
	south = central_square
;

rubbish: qcontainer
	location = firehouse
	noun = 'rubbish' 'trash' 'remains' 'kite'
	adjective = 'tattered'
	sdesc =
	{
	    "a lot of <b>rubbish</b> is laying about ";
	    if (rubbish_stick.location = self)
		", including the tattered remains of a kite";
	}
	
	ldesc = {
	    if (rubbish_stick.location = self)
	    {
		"<p>At first, it seems to be the usual junk. You've
	got your dead leaves, plastic baggies, a crumpled can, some
	unidentifiable paper items. Upon closer inspection, you see
	that under the pile of shod lies the <b>STICK!</b></p> 
		 <p>This is great! At long last you have found what
	you've been looking for! Master will be so pleased! YES!
	YES!</p>";
	    }
	    else
		"There is a pile of rubbish, containing mostly leaves,
		 plastic bags, a crumpled can, and some unidentifiable paper
		 items.<p>
		 Doggone it, these are the breaks.";
	}
	verDoTake(actor)=
	{ "The rubbish is too large and bulky to pick up all of it\n";}

		 
;

rubbish_stick: stick_class
    location = nil /* later rubbish */
    doTake(actor) =
    {
	inherited.doTakeBase(actor);
	"<hr><p>As soon as you reach out to grab what is rightfully
    yours by all that is fair in the world, a siren goes off! Lights
    start flashing! You see big burly firefighters running to their
    truck.</p>
	 <p>Soon the truck pulls out on its way to an emergency
    situation. A black and white dalmation (wearing a fireman's
    helmet), excitedly runs about. In fact, the little hellhound grabs
    the STICK! right out from under you nose, and then hops on the
    departing firetruck. You are left empty pawed in a swirling vortex
    of dust and truck fumes.</p>
	 <hr><p>You can <b>get mad</b>, <b>wallow</b> in self pity, or
    <b>shake it off</b>. </p>";
	setlevel(2);
    }
;


art_deco: room
	sdesc = "Art deco area"
	ldesc = "So many possibilities! A high tech
		 building to the <b>south</b> 
		 and a funky glass covered
		 structure to the <b>southeast</b>
		 flank the area.<p>
		 Other options include going
		 <b>west</b>
		 and
		 <b>east</b>
		 <P> <img src='artwork/jab5.png'><P>"
	west = green_building
	east =
	    {
		notify(kendall_t,&status,0);
		return kendall_t;
	    }
	south = media_lab
	se = med_center
;


killian_court: room
    sdesc = "Killian Court"
    ldesc = "This is a big grassy courtyard. You have a good view of the water from here.<P>
	     Off to the left students cluster in horrid fascination. A
	     <b>balding person</A> with a big smile and a plaid
	     jacket holds a large crowd in rapt attention.
	     <P>
	     You can go <b>north</b>"
    north = lobby_10
;

bob: fixeditem
    noun = 'man' 'Bob' 'person'
    adjective = 'balding' 'Honest' 'dishonest'
    location = killian_court
    sdesc = "Honest Bob"
    isHim = true
    ldesc = {"This is the center of a demonstration. You notice many
	     interested engineers and several exuberant lawyers mixed
	     in with the student crowd.
	     <P> \"Trust me, this baby is perfectly safe. My 90 year old
	     grandma's done this at least two hundred times, not one
	     cracked hip. There's absolutely nothing to worry about.\"
	     Honest Bob looks shiftily looks around, noticing your arrival.
	     \"Allow me to demonstrate.\" In a
	     condescending falsetto Bob coos \"Come here, poochy poochy,
	     that's it
	     step a little closer, that's it, right there\" You notice that
	     the
	     grass underneath your feet is slightly off color.
	     <P>
	     You may run away immediately or
	     hesitate for an instant.";

	     notify(bob,&fire_catapult,2);
	 }
    fire_catapult = {
	if (Me.location = killian_court)
	{
	    "As Honest Bob continues his sales pitch, you hear a click from
	     underneath your feet. With a huge sproing, the cleverly
	    camouflaged medieval catapult you'd been standing on flings you
	    through the air. 
	    <P>
	    The sensation of free fall is quite pleasant, as the ground
	    rushes by beneath you.  Your lack of fear turns out to be
	    completely unfounded when you crash into the Charles river,
	    about a mile away from where you started.</p>\n";
	    Me.travelTo(charles_river_east);
	    incscore(10);
	}
    }
;

charles_river_east: room
    sdesc = "In the Charles River. (Ewww)"
    ldesc = {
	     if (self.isseen)
		 "You are doggy paddling in the muck that constitutes the
		  Charles River.";
	     "<P>
	    There is really no choice but to doggy
	    paddle to <b>north</b> shore, as drowning here is unthinkable.";
	 }
    north = harvard_bridge
;

