
logan: room
	sdesc = "Logan International Airport"
	ldesc = "<p>Thousands of travelers pass through this busy terminal. It crowded and
busy - exactly as a major transportation hub should be. Logan airport
is one of the ten restricted areas where special permission is required
to land a private plane. There is a <b>sign</b> here, and some
<b>water</b> is puddling about.</p>

<p>You may <b>enter</b>  or take the shuttle bus  <b>south</b> back to the subway"
	in = baggage_claim
	south = blue_line
	north = baggage_claim
;

logan_sign: fixeditem
	location = logan
	noun = 'sign'
	sdesc = "sign"
	ldesc = "When the airlines discover the virtues of the internet, arrival and departure times of actual flights will be posted. Until then, this sign is only good for decoration."
;

logan_puddle: fixeditem
	location = logan
	noun = 'water' 'puddle'
	sdesc = "puddle of water"
	ldesc = "Who is this mangy <<Me.breed>> reflecting off the water? You slurp up some of the water more out out habit than thirst."
;

leave_baggage_claim: function (new_room)
{
	if ((baggage_claim.terror_sequence >  0 ) 
		and (baggage_claim.terror_sequence <  6 )) 
	{
		terrorist_stick.moveInto(nil);
		cat.moveInto(nil);
		bone.moveInto(nil);
		switch (baggage_claim.terror_sequence)
		{
			case 1 : 
				"As you walk out of the room, so does the shady looking character, and
he is going a lot faster. While walking out in the middle of a crisis
situation can be productive from time to time, you can't help
wondering if somehow could have been more heroic - it would have been
fun to get on the TV news. You wonder if, in some odd sort of way, you
will be repaid in kind for this lack of valour.
 <P>
Some loud beeping is coming from the baggage claim area. You poke your
head back in out of curiosity. The man's abandoned satchel is making
alarm clock noises. <P>
<p>You can go <b>south</b> or <b>east</b></p>";
				baggage_claim.terror_sequence := 3;
				satchel.moveInto(baggage_claim);
				terrorist.moveInto(nil);
				return baggage_claim;
				break;
			case 2 : 
"You politely step out of the way and let the shady looking character
make a graceful, if hurried, exit. While this was a very hassle-free
and laid back approach, you can't help wondering if somehow should have
been more heroic - this was, after all, a chance to get your picture in
the newspaper.You wonder if, in some odd sort
of way, you will be repaid in kind for this lack of valour.
 <P>
Meanwhile the abandoned satchel starts making loud beeping sounds. <P>"	;
				baggage_claim.terror_sequence := 3;
				satchel.moveInto(baggage_claim);
				terrorist.moveInto(nil);
				return baggage_claim;
				break;
			case 3:	
"<HR>	 <P><I>
A blast goes off. It is powerful enough to throw you out of the
airport, out of this game, and clear of Boston. You are
blown halfway across the world into some obscure backwater region of
the world wide web. Too bad.<P>
<HR> <P>	</I>
Slowly, you regain consciousness<br>";
				return caltech;
				quit;
				break;
			case 4:
				"<hr><p><I>As you leave there is a huge flash of light - and then the shock
wave hits. You have the vague sensation of flying through the air - but it all seems so hard to remember.  
<P>A wave of pain racks through you not so much from grevious bodily injury but from remembering the stick being
wrenched from your jaws. Lost again!</I>
 <P> <HR>
 <P>You open your eyes, and everything seems blurry. Moving right now
is not an option. The best thing to do is to <b>wait</b> a few minutes for your head to
clear.</p><br>";
				terrorist.moveInto(nil);
				terrorist_stick.moveInto(nil);
				baggage_claim.terror_sequence := 5;

				return infirmary;
				break;
				
		}
	}
	else
	{
		return new_room;
	}
}

baggage_claim: room
	terror_sequence = -1
	sdesc = "Logan Airport"
	ldesc = {
		local d;
		d := '<p>Luggage is zipping around conveyer belts as tired and impatient people crowd around each other. ';
		if (terrorist.location = self)
		    self.terror_sequence := 0;
		else /* no terrorist */
		    d := d + '</p>';
		    		
		if (self.terror_sequence > -1  and self.terror_sequence <  6)
		{
			d :=  d + 'You <b>smell</b> something funny here.</p>';
		}
		else if (self.terror_sequence = 6)
		{
			d :=  d + ' Some of the room is taped off, where the floor is being repaired. A sign reads, "Please excuse our dust"</p>';
		}
		say(d + '<p>You can go <b>south</b> or <b>east</b> </p>');
	}
	smell =  {
		switch (self.terror_sequence ) 
		{
		case -1: return 'It smells like people, motor oil, exhaust fumes, and cigarettes.';
			break;
		 case 0: 
			terrorist.isListed := true;
			terrorist.actorDesc:= 'You see a suspicious looking man standing in the corner';
			return '<p>The smell is a little bit like fertilizer, but has more of a nitrogen aroma. It\'s a little hard to place - oh, yes, it is similar to the smell that bullets and explosives make. You notice that the smell is coming from a <b>person</b> standing quietly in the corner. </p>';
			break;
		case 1:return '<p>The smell of fear is mixed in with gunpowder </p>';
			break;		
		case 2: return '<p>The smell of fear is mixed in with gunpowder </p><p>The air is deliciously thick with the smell of fear - I think a little bit of drool seeps out of the corner of your mouth.</p>';
			break;		
		case 3:return '<p>The smell of fear and gunpowder is starting to get mixed in with body odor.</p>';
			break;
		case 4:return 'The woodsy aroma of the stick covers up the faint smell of gunpowder.</p>';
			break;
		case 5:return 'It smells like concrete dust and death.';
			break;
		}
	}
	east = leave_baggage_claim(rental_desk)
	south = leave_baggage_claim(logan)
;




rental_desk: room
	sdesc = "Rental Car Desk"
	ldesc = "<p>There are big lines of angry people swarming around the rental desks. Each thinks that their petty whims are of paramount importance. And because of the competitive, capitalistic nature of the car rental business, none of the overworked clerks have enough guts to tell the whiners to just shut up. </p>
<p>You can go <b>west</b> </p>"
	west = baggage_claim
;


terrorist: movableActor
	location = baggage_claim
	noun = 'person' 'man' 'terrorist'
	advective = 'smelly' 
	attack_sequence = 0
	sdesc = "a suspicious looking man"
	actorDesc = ""
	isListed = nil
	ldesc =
	{
		baggage_claim.terror_sequence := 1;
		"<p>He's wearing a cheap blue nylon jacket. A pack of
		 cigarettes dangle out of one pocket. The smell of fear is
		 mixed in with gunpowder as this man looks at you anxiously. He
		 has a large satchel which surely contains enough explosives to
		 rip this place apart. </p>\n
		 <p>The man keeps glancing furtively at his watch. </p>
		 \n
		 <p>By now the situation is clear: </p>\n
		 <ul>\n
		 <li>Do what is right and <b>attack the man</b></li>\n
		 <li>Let thousands of innocent people die</li> \n
		 </ul>\n
		 <p>You can go <b>south</b> or <b>east</b> </p>";
	    }
	verDoAttack (actor) ={}
	doAttack(actor) = {
	    switch (baggage_claim.terror_sequence)
	    {
	      case 0: "Why are you biting random strangers?"; break; 
		    case 1: 
		      baggage_claim.terror_sequence := 2;
		      "<p>Nice, doggy. Nice doggy. The man puts down his satchel and would leave the area, held back only by your menacing growls. He seems to be growing more and more excited. You see beads of sweat run down his forehead, and he can't go more than five seconds at time without looking at his watch. The air is deliciously thick with the smell of fear - I think a little bit of drool seeps out of the corner of your mouth. </p>
		       <ul>
		       <li>Hold your ground, and continue to <b>attack the man</b></li>
		       <li>Let the guy go </li></ul>
		       <p>You can go <b>south</b> or <b>east</b> </p>";
		      satchel.moveInto(baggage_claim);
		      break;
		    case 2: 
		      baggage_claim.terror_sequence := 3;
		      "<p>Um, maybe I have a doggy biscuit. Nice doggy, no bite me (You decide to show some more teeth at this point. The man reaches into his pocket. Um, let's see, what do I have here. Want a steak - yum, yum uncooked T-bone, very juicy. Oh and here I've got a kitty cat, declawed and everything, fun to chase around, nice doggy </p>
		       <ul>\n
		       <li><b>Take the T-bone </b></li>\n
		       <li><b>Take the cat </b></li>\n
		       <li>Refuse these petty bribes and continue to <b>attack the man</b></li>\n
		       </ul>\n
		       <p>You can go <b>south</b> or <b>east</b> </p>";
		      cat.moveInto(baggage_claim);
		      bone.moveInto(baggage_claim);
		      break;
		    case 3:
		      "<p>Torrents of sweat are pouring out of this fellow. The smell of fear and gunpowder is starting to get mixed in with body odor. He is visibly shaking as he looks at his watch. You get the feeling that this fellow is seriously stressed. C'mon, mutt, please let me go. Let's see, all of got left is this stick. He pulls a small branch of wood from inside his jacket.</p>
		       <p>And immediately you forget all about the gunpowder and the time and the airport and everything. This man has the stick. Not just any old stick but the stick! He has it. Right here and right now. The end all be all goal of your existence and it is right here, tantalizingly within your grasp! </p>
		       <p>Free will has left you. There is only one thing to do now. </p>
		       <p></p>
		       <p>GET THE STICK </p>";
		      actor.moveInto(baggage_with_stick);
		      terrorist.moveInto(nil);
		      break;		
		  }		
	}
;

satchel: item
	location = terrorist
	noun = 'satchel' 'bag'
	adjective = 'smelly' 'ticking'
	sdesc = "satchel"
	ldesc = "<p>A large satchel which surely contains enough explosives to rip this place apart. </p>"
	doGet(actor) = 
	{
		self.moveInfo(actor);
		terrorist.moveInto(nil);	
		
	}
;


cat: item
	location = terrorist
	noun = 'cat'
	adjective = 'declawed'
	sdesc = "cat"
	ldesc = "A cat, fun to chew on or chase."
	doTake(actor) = 
	{
		self.moveInfo(actor);
		terrorist.moveInto(nil);	
		"<p>You chew on the pitiful bribe as the terrorist makes his escape. While it is nice to feel your teeth working, somewhere deep inside you feel guilty about not being more heroic. You wonder if, in some odd sort of way, you will be repaid in kind for this lack of valour. </p>";
	}
;

bone: item
	location = terrorist
	noun = 'steak' 'T-bone' 'bone'
	adjective = 'juicy' 'raw'
	sdesc = "T-bone"
	ldesc = "A juicy raw T-bone steak. Delicious."
	doTake(actor) = 
	{
		self.moveInfo(actor);
		terrorist.moveInto(nil);	
		"<p>You chew on the pitiful bribe as the terrorist makes his escape. While it is nice to feel your teeth working, somewhere deep inside you feel guilty about not being more heroic. You wonder if, in some odd sort of way, you will be repaid in kind for this lack of valour. </p>";
	}
;


terrorist_stick: stick_class
    location = baggage_with_stick
    doTake(actor) =
    {
	inherited.doTakeBase(actor);
	baggage_claim.terror_sequence := 4;
	"<p>You grab the stick out the strange man's hand. He runs quickly out the door, leaving the satchel behind - but who cares? You have the stick. It is in your mouth. Congratulations! Now all that remains is to return it to master. </p>";
	self.moveInto(actor);
	actor.moveInto(baggage_claim);
    }

;


baggage_with_stick: room
	sdesc = "Logan Airport"
	ldesc = "This man has the stick. Not just any old stick but the stick! He has it. Right here and right now. The end all be all goal of your existence and it is right here, tantalizingly within your grasp! </p>
				<p>Free will has left you. There is only one thing to do now. </p>
				<p></p>
				<p><b>GET THE STICK</b></p>"
	smell = 	"<p>The only thing you can smell is the woody aroma of THE STICK in the man's hand. </p>"
;

	
caltech: room
	sdesc ="some obscure backwater region of the world wide web"
	ldesc = {"
<CENTER>

<IMG SRC='added_images/OliveWalk.png' >
<H1>California Institute of Technology</H1>
<HR>\n

<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR ALIGN=CENTER>
<TD><H2><b>Web Resources at Caltech</b></H2></TD>\t
<TD><H2><b>Specific Groups</b></H2></TD>
</TR>\n

<TR ALIGN=CENTER>
<TD><H2><b>About Caltech</b></H2></TD>\t
<TD><H2><b>About the Caltech Web</b></H2></TD>
</TR>\n

<TR ALIGN=CENTER>
<TD><H2><b>Press Releases</b></H2></TD>\t
<TD><H2><b>Caltech Library System</b></H2></TD>
</TR>\n

<TR ALIGN=CENTER>
<TD><H2><b>Admissions Information</b></H2></TD>\t
<TD><H2><b>Alumni Resources</b></H2></TD>
</TR>\n

<TR ALIGN=CENTER>
<TD COLSPAN=2><H2><b>Search the Caltech Web</b></H2></TD>\t
</TR>\n
</TABLE>

</CENTER>

<HR>\n
<IMG ALIGN=LEFT SRC='added_images/tinycitlogo.png' >
<BR>\nCalifornia Institute of Technology
<BR>\n1201 East California Boulevard
<BR>\nPasadena, California 91125
<BR>\n(818) 395-6811
 ";
morePrompt();
quit();
}
;
