/*
 * The Xylophoniad
 *
 * Special code
 *
 */

GAME_NAME = 'The Xylophoniad'
GAME_ID = 'XYL'
MAX_SCORE = 31;
SCORE_AS_PERCENTAGE = true;

INV_CAP = 999; // number of items in inventory. max out, because inventory limits are annoying.


// list of flag & variable abbreviations
GAME_OVER = 'g0';

JUST_MOVED = 'j0';
TURN_NUMBER = 'f0';

MONEY_LEFT = 'm0';

// temple transportation links
USED_TEMPLE_ERIS = 'T01';
USED_TEMPLE_ARTEMIS = 'T02';
USED_TEMPLE_POSEIDON = 'T03';

// Anachronopolis
GOT_FIGURINE = 'f06';
CONFRONTED_KING = 'f07';

// troy & the war
TRANSPORTED_TO_HORSE = 'f10';
HORSE_MOVING = 'f11';
EVER_NEIGHED = 'f12';
HORSE_PRESSURE = 'f14';
DESTROYED_WALL = 'f15';
CRASHED_INTO_WALL = 'f16';
ACHILLES_ENTERED = 'f17';
ACHILLES_CRYING = 'f18';
FEET_WET = 'f19';
FIGHTING_HAPPENING = 'f1A';
GREEKS_LEAVING = 'f1B';
PALLADIUM_CURED = 'f1C';
HECTOR_HAS_PATROCLUS = 'f1D';
MET_PATROCLUS = 'f1E';
PATROCLUS_UNTIED = 'f1F';
ACHILLES_FOLLOWING = 'f1G';
ACHILLES_BAREFOOT = 'f1H';
ACHILLES_DEAD = 'f1J';
WAR_OVER = 'f1K';
GREECE_WON_WAR = 'f1L';
TOLD_ACHILLES = 'f1M';
HELEN_FOLLOWING = 'f1N';
SHIP_STATUS = 'f1O'; SHIP_ANCHORED = 0; SHIP_BOARDING = 1; SHIP_GONE = 2;
PATROCLUS_DEAD = 'f1P';
BEDCHAMBER_UNLOCKED = 'f1Q';
GOT_CHICKEN = 'f1R';
MET_HELEN = 'f1S';
HECTOR_DEAD = 'f1T';

// medusa
PUT_SOMETHING_ON_HOLE = 'f20';
OBJECT_ON_HOLE = 'f21';
PAID_BARBER = 'f22';
EVER_PAID_BARBER = 'f23';
BARBER_FOLLOWING = 'f24';
MEDUSA_CURED = 'f25';
PERSEUS_CURED = 'f26';
MEDUSAS_FIRE_OUT = 'f27';
SEEN_MEDUSA = 'f28';

//bicyclops' island
MINOTAUR_CHASING = 'f30';
CURED_MINOTAUR = 'f31';
MET_DAEDALUS_IN_WORKSHOP = 'f32';
WHEELS_OFF_HANDCART = 'f33';
GAVE_DAEDALUS_WHEELS = 'f34';
GAVE_DAEDALUS_FRAME = 'f35';
GAVE_DAEDALUS_SADDLE = 'f36';
GAVE_CAT_FISH = 'f37';
BUILT_BICYCLE = 'f38';
FOUND_SADDLE = 'f39';
//DAEDALUS_SAID_GET_ON_BIKE = 'f3A';

// hades
GONE_TO_HELL = 'f40';
RESCUED_TANTALUS = 'f41';
RESCUED_SISYPHUS = 'f42';
TANTALUS_PHASE = 'f44';
SISYPHUS_PHASE = 'f45';


FINISHED_BICYCLOPS = 'f110';
FINISHED_TROY = 'f120';
FINISHED_HADES = 'f140';



function set_gameflags() // if they're initially zero they needn't be set here
{
	sgs(MONEY_LEFT, 20);
	sgs(HECTOR_HAS_PATROCLUS, 1);

}


// words of more than three letters to ignore
WORDS_TO_IGNORE = 'about.with.around.under.over.go.do.through';

Daemons = [];

PARDON = 'Pardon?'

function initialiseGame()
{
	give_hero(sword);
	give_hero(scroll);
	give_hero(money);
	
	give_person(guard, chicken);
	add_to_contents(coldbox, cheese);
	
	// start in verbose mode
	sgs('VRBS', 1);
}


// all 'special command' attempts come this way if they are
// not caught by a specific place. Return true if a command
// is interpreted and obeyed (even if it is to no effect)
function anywhere_special()
{
	// you can create on-the-fly 'dynamic synonyms' this way -
	// it's awkward, but it will work.


	// useless things
	if(Token[1]=='listen')
	{
		say("You listen...");
		return true;
	}
	
	else if(Token[1]=='jump')
	{
		say('You can\'t jump very high.');
		return true;
	}
	else if(Token[1]=='shout')
	{
		say('\"AAAARRRGGGHHH!!!\"')
		return true;
	}
	else if(Token[1]=='sneeze')
	{
		say('Aaaachoooooo!');
		return true;
	}
	else if(Token[1]=='swear'||Token[2]=='swear')
	{
		say('Well, aren\'t you a grown-up.');
		return true;
	}
	else if(Token[1]=='sit')
	{
		say('You sit down.');
		return true;
	} else if(Token[1]=='stand') {
		say("You're standing up.");
		return true;
	}
	else if(Token[1]=='not')
	{
		say('Not done.');
		return true;
	}
	
	else if(Token[1]=='close' && Token[2]=='eyes') {
		say("You wouldn't last long as an adventuress if you walked around with your eyes closed.");
		return true;
	}
	
	else if(Token[1]=='abandon' && Token[2]=='hope') {
		say("That's hardly positive thinking.");
		return true;
	}

	else if(Token[1]=='xyzzy') {
		say("Never gets old, does it?");
		return true;
	}
	
	return(false);
}




INTRO = '"The mercenary adventuress known as Xylophone &ndash;"\n\
"Xy-<i>loph</i>-o-ne," you interrupt. "Four syllables."\n\
"Silence!" King Eurystheus shouts, and resumes his judgement. "The adventuress known as Xylophone" &ndash; \
he pronounces it grudgingly correctly &ndash; "shall be required to \
complete three great labours." He unfurls a scroll, and reads:\n\
&nbsp;&nbsp;"Slay that unnatural beast, the Bicyclops;\n\
&nbsp;&nbsp;"Recover two souls from Hades, the underworld;\n\
&nbsp;&nbsp;"End the Trojan War and rescue the abducted Helen of Troy."\n\
The king settles in his throne with a sadistic smirk on his face. There is laughter from the public gallery.\n\
\n\
Okay, you were hoping to get off with a modest fine or a couple of weeks\' board and lodging &ndash; all you did \
was kill a few guards, for gods\' sake, they knew the risks when they signed up &ndash; but it could be \
worse. You\'ve got as long as you need to do it. And he didn\'t even say which side you had to win the war for.\n\
\n\
"I believe that\'s all for today," says the king, rolling up the scroll and tossing it to you. The crowd disperses.\n\
\n';
MANNER_FREQ = 3;

function score_rating()
{
	var s = sc_percent();
	
	var txt = ('\nDiogenes rates you as ');
	if(s == 100) { txt += ('a demigoddess') }
	else if(s>90) { txt +=('a legend') }
	else if(s>80) { txt +=('a warrior queen') }
	else if(s>70) { txt +=('a warrior princess') }
	else if(s>60) { txt +=('an epic heroine') }
	else if(s>50) { txt +=('a senior heroine') }
	else if(s>40) { txt +=('a heroine') }
	else if(s>30) { txt +=('a junior heroine') }
	else if(s>20) { txt +=('an aspiring heroine') }
	else if(s>10) { txt +=('a tragic heroine') }
	else if(s>0) { txt +=('a pencil-necked Greek') }
	else { txt +=('a nobody') }
	
	return txt + '.';
	
}


START_LOC = courtroom;

function anywhere_do() {
	sgs(TURN_NUMBER, parseInt(gs(TURN_NUMBER),10) + 1);
	
}



function game_help()
{
	window.open('res/xylhelp.html','help',
	  'width=600,height=400,scrollbars=yes,menubar=no,resizable=yes,status=no,toolbar=no');
}

function game_hints()
{
	window.open('res/xylhints.html','help',
	  'width=600,height=400,scrollbars=yes,menubar=no,resizable=yes,status=no,toolbar=no');
}

function anywhere_append()
{
	var txt = '';
	
	return(txt);
}

var anywhere_sights = {
	'self' : "You are Xylophone &ndash; that's Xy-<i>loph</i>-o-ne, four syllables &ndash; heroine, \
	          and adventuress, fighting for truth, justice and a competitive hourly rate.",
	
	'wall' : 'Just an ordinary wall.',
	'roof' : '[[heroloc().isOutdoors ? "You\'re outside!" : "Just an ordinary ceiling."]]',
	'ground' : 'Just [[ heroloc().isOutdoors ? "ordinary ground" : "an ordinary floor" ]].',
	'door' : 'Just an ordinary door.',
};
