/* NPC's for the 701-point game */
/*
 * Polyadventure
 *
 * A remake of the various versions of the classic Adventure game by Don
 * Woods and Willie Crowther, based on their sources.  Currently, the 350,
 * 550, and 551-point versions are implemented.  See the file "ccr-help.t"
 * for more information.
 *
 * Please document all changes in the history so we know who did what.
 *
 * This source code is copylefted under the terms of the GNU Public
 * License.  Essentially, this means that you are free to do whatever
 * you wish with this source code, provided you do not charge any
 * money for it or for any derivative works.
 *
 *
 * Contributors (see history.t for current e-mail addresses)
 *
 *      djp     In real life:   David J. Picton
 *
 * 23-Jul-04    djp     Version 3.00.  Addition of a new game mode (701+).
 *                      * Addition of code for the Green-level Wumpi and
 *                        associated possessions.  A complicated method
 *                        (Wumpi.actioncheck) is responsible for vetting player
 *                        actions and moving the player on during the chase
 *                        scene. 
 *
 * 15-Jan-05    djp     Version 3.01: bugfix release.
 *                      * Dim the Large Circular Room light level in phase 2
 *                        as well as phase 3.
 *                      * (Rev. B, 17 Jan 2005) Corrected the action check
 *                        code to properly disallow \"kata\" from the
 *                        Green-level Large Circular Room, when only 10 Wumpi
 *                        are present.
 *
 * 12-Apr-05    djp     Version 3.10: Bugfixes and enhancements
 *                      * Changes to Wumpi descriptions to accommodate 
 *                        variant gameplay associated with sitting on the
 *                        throne without a crown (a 'throne mishap').
 *                      * Suppressed some messages when Wumpi are transported
 *                        after a throne mishap, and the player character
 *                        knows what to expect!
 *                      * Changed the response when the player has Kata'ed
 *                        the Wumpi to Blue level, then tries to Kata somewhere
 *                        else.  If the player saw the Control Room 
 *                        before a throne mishap, the option of going to the
 *                        Control Room is raised - then rejected.
 *
 * 9-Aug-05     djp     Version 3.12: Enhancements and bugfixes
 *                      * Attempting to wake the Wumpi now gets the correct
 *                        response after a 'throne mishap'.  (If the player
 *                        has been through the chase scene the Wumpi are
 *                        known not to be man-eating).
 *
 * 2-Apr-09     djp     Version 3.20 Rev. D
 *                      * If the player is at Top_of_Blocks following a 
 *                        'throne mishap' and the door has been seen,
 *                        he goes through the door when the Wumpi approach
 *                        (instead of climbing down and going up the stairs,
 *                        which doesn't make sense)
 *
 * 4-Nov-09     djp     Version 3.20 Rev. E
 *                      * Fixed a coding error: due to a missing section
 *                        of code, the player could get stuck in 
 *                        Green_Large_Circular_Room when the Wumpi were 
 *                        approaching.
 */

Wumpi: fixeditem
    rhetoricalturn = -999   // hack -- see yesVerb in ccr-verbs.t
    game701 = true
    sdesc = "Wumpi"
    ldesc = {
        if (self.phase = 2) {
            if(Green_Tight_Crack_2.isseen)
            // from a previous adventure, before sitting on the throne
                "You know that these Wumpi are not man-eating monsters, but
                you also know that they'll be in a very angry mood when they
                wake up.  Which will be happening very soon!";
            else
                "They are renowned for their appetite for Adventurers, and 
                they're particularly dangerous when they wake up.  Most of 
                them are still fast asleep, but a few of them have become 
                restless in the brighter light.  They're beginning to wake 
                up! ";
        }
        else if (self.phase > 4 or Green_Tight_Crack_2.isseen)
            "They are large, hairy creatures, but you now know that these
            Wumpi gave up their taste for human flesh many years ago.  I
            still don't advise you to wake them, though - you know they
            don't take kindly to being disturbed! ";
        else {
            if(Green_Tight_Crack_2.isseen)
                "They are large hairy creatures.  You know that they don't
                eat human flesh any more, but you also know that they don't
                like to be disturbed.  Please don't wake them!  ";
            else
                "They are large, hairy creatures, renowned for their appetite 
                for Adventurers.  Whatever you do, don't wake them!  ";
        }
        if (self.location = Green_Large_Circular_Room and (self.phase = 0)
        and not NoisyDoor.isopen) 
            "You've already made enough noise coming through the door.  I
            suggest that you get out of here now. ";
        if (self.phase < 3) {
            P(); I();
            "You notice that ";
            if (self.location = Green_Large_Circular_Room)
                "most ";
            else
                "all ";
            "of them are wearing gold rings like the one you found on the
            original Wumpus. ";
        }
        else if ((self.phase >= 4) and (not global.seenelves) and
            (not topaz.moved)) {
            P(); I();
            "You notice that they are clutching their rings in their hands,
            but no longer wearing them.  I wonder why? ";
        }
        else if ((self.phase >= 4) and (global.seenelves or topaz.moved)) {
            P(); I();
            "You notice that they no longer have any gold rings.  Then you
            spot a large sheet of parchment in one of the Wumpi's hands. \"Loan
            of 25 teleportation-assistance rings.  Deposit 100 gold 
            pieces.  Signed Ondral - Mountain King. \"";
        }
    }
    noun = 'wumpi' 'wumpuses'
    adjective = 'wumpus' 'beds'
    // adjective so 'gonear wumpus' finds the regular guy
    heredesc = {P(); I();
        // We now set the initial 'discovered' phase here:
        if(self.phase < 0) self.phase := 0;
        if(self.phase = 0)
            "You now realize why all those passages were blocked off! ";
        if((self.phase >= 0) and (self.phase <= 2)) {
            "There must be about ";
            if (self.location = Green_Large_Circular_Room)
                "thirty ";
            else
                "twenty ";
            "Wumpi in this room, all lying on low beds! ";
            if (self.phase = 2)
                "Unfortunately some of them are beginning to wake up, so you'd
                better get out of here and make your escape while you can. ";
            else
                "They are all sleeping peacefully, and I strongly suggest 
                that you keep things this way. ";
            if(self.location = Green_Large_Circular_Room and 
            (greenButton.lightpushes > 0)) {
                P(); I();
                "Your button-pushing (in the control room) seems to have
                paid off! 
                Some of the beds have been rearranged, and you can
                now see a safe path between the stairs and the east passage. ";
            }
        }
        else if (self.phase = 3) {
            say(self.wdesc);
        }
        else if (self.phase = 4) {
            say(self.wdesc);
        }
        else 
            if(global.closed)
                "There are now only twenty Wumpi in this room.  You have a very
                bad feeling about this ... ";
            else
                "There are about thirty Wumpi in this room, all sleeping
                peacefully.  They have rearranged their beds, and it will
                now be possible to walk between the stairway and
                the east passage. ";
    }
    isasleep = true
    dobjGen(a, v, i, p) =
    {
        if ((v <> inspectVerb) and (v <> gonearVerb) and (v <> countVerb))
        {
            if(self.phase < 4) {
                "It's not worth the risk. "; 
                "Please get out of here now!  If these Wumpi get hold of your
                 pendant, we could all be in *very* serious trouble. ";
                 exit;
            }
            else
                "You now know that these Wumpi aren't man-eating monsters, but
                I suggest that you don't annoy them by disturbing their
                sleep once again. ";
            exit;
        }
    }
    iobjGen(a, v, d, p) = {
        if (v = waveVerb or v = askVerb or v = tellVerb) return;
        self.dobjGen(a, v, d, p);
    }        
    verDoWake(actor) = {}
    doWake(actor) = {
        "Are you sure? ";
        self.rhetoricalturn := global.turnsofar;
    }
    disaster = {
        if(self.phase < 5 and (not Green_Tight_Crack_2.isseen))
            "Well, I'm saying no.  The consequences could be disastrous. Do
            you really want your world to be invaded by a horde of man-eating
            Wumpi?  No, don't answer that. ";
        else
            "Well, I'm saying no.  All right, these Wumpi aren't man-eating
            monsters, but they won't be very pleased if you disturb their
            sleep once again!  If they confiscate your pendant we'll all be
            in \(real\) trouble. Best let sleeping Wumpi lie. ";
    }
    location = Green_Large_Circular_Room
//    Wumpi phases:
    
//   -1: Before discovery.
//    0: Discovered in Green_Large_Circular_Room.  (Not to be disturbed due to
//       danger of pendant falling into their hands.)
//    1: In Blue_Large_Circular_Room.  (Danger of Wumpi reaching upper
//       Transindection Chamber and getting into Red level).
//    2: In Large Circular Room (brighter lighting).
//    3: Apparently chasing player after waking up in Large Circular Room
//       (about 10 left in Green_Large_Circular_Room).
//    4: Settling back into Green_Large_Circular_Room, player on staircase or
//       beyond.
//    5: Player has gone through north exit of living room.
//

    phase = -1
    firstmove = {
        Wumpi_remnant.moveInto(Green_Large_Circular_Room);
        self.moveInto(Blue_Large_Circular_Room);
        self.phase := 1;
        P(); I();
        "Oh oh! You've brought most of the Wumpi with you, together
        with the beds they are lying on. ";
        // if this game has been restarted after sitting on the throne,
        // turn off the following messages:
        if(not Green_Tight_Crack_2.isseen) {
            if(kataVerb.hesitated)
                "Unfortunately, it would appear that the Wumpi \(are\) silly 
                enough to wear magic rings in their sleep. ";
            else
                "Your attention is drawn to the rings which the Wumpi are
                wearing.  I suspect they have magic powers ... ";
            P(); I();
            "Anyway, you'd better not leave the Wumpi here.  They have access 
            to the Octagonal Room from here, and with their superior strength 
            it would take them five minutes to unblock the passage to the 
            Upper Transindection Chamber. ";
            P(); I();
            "So unless you \(like\) the idea of having to deal with 20 Wumpi 
            in place of the one you killed, I strongly suggest that another 
            \"Kata\" is called for.  Plus a prayer that all the Wumpi will be
            transported this time. ";
        }
        P();
    }
    moveback = { // only used after sitting on the throne
        Wumpi_remnant.moveInto(nil);
        self.moveInto(Green_Large_Circular_Room);
        self.phase := 0;
        P(); I();
        "You've returned all the Wumpi back to Green level without waking
        them!  However, their beds are still arranged untidily, and you won't
        be able to reach the stairs without disturbing them. ";
    }
    secondmove = {
        self.moveInto(Large_Circular_Room);
        self.phase := 2;
        P(); I();
        "Fortunately, you've brought all the Wumpi with you this time - I
        don't think you've left any behind.  ";
        P(); I();
        "Oh-oh! You have a problem.  For some reason the light in here is   
        much brighter, and the Wumpi are beginning to wake up!  You'd
        better get yourself out of here quickly. ";
        P();
        self.wakingturn := global.turnsofar;
    }
    actioncheck(actor,verb,dobj,prep,iobj) = {
        local toploc := toplocation(actor),turns := 0;
        // ignore system verbs such as save, restore
        if(verb.issysverb) return; 
        if(self.wakingturn)
            turns := global.turnsofar - self.wakingturn;
        // phase 1: Wumpi at Blue level, with access to Upper Transindection
        // Room.  Kata not allowed except at location of Wumpi.
        if(self.phase = 1) {
            if (toploc.analevel <> 1 or toploc = Blue_Trans_Room) 
                return;
            if((verb = kataVerb) and (toploc = Wumpi.location))
                return; 
            else if(verb = kataVerb) {
                if(Control_Room.seenit) {
                    "An image of the Control Room comes into 
                    your mind.  You feel sure that if you go there, you'll
                    be able to send those Wumpi back to Green level! Then
                    you have doubts.  What if the Wumpi wake up while you're
                    away?  You realize that your best option is to repeat
                    what you did earlier - to Kata the Wumpi to Red level and
                    make your escape ... "; P();
                }
                else {
                    "For a moment, you are tempted to go back to
                    Red level, make sure that the Upper Transindection Chamber
                    door is locked, and walk away.  But
                    then you realize that a steel door would be no match for
                    twenty determined Wumpi!   No - the only solution is to
                    transport them through Transindection again, then make your
                    escape as best you can. "; P();
                }
                exit;
                
            }
        }
        if(self.phase = 2) {
            if(turns = 3)
                Large_Circular_Room.lightlevel := 1;
            if((turns > 2) and (toploc = Large_Circular_Room)) {
                "The Wumpi are starting to wake up!  One of them whispers
                a strange word which you don't quite make out, and the 
                lighting dims. But it's too late - several Wumpi are awake 
                now, trying to make sense of their bare surroundings.\b";
                "You slip into the east passage, hoping that you won't be
                noticed.\b";
                actor.travelTo(Large_Circular_Room,&east);
                exit;
            }
            if((verb = anaVerb) and (toploc = Wumpi.location)) {
                "If you did that, you'd transport all the Wumpi back to
                Blue level again, and that's a bad idea because they're now
                waking up.  I suggest that you go east. ";
                exit;
            }
            if((verb = kataVerb) and (toploc = Wumpi.location) and
                (pendant3.location = actor) and pendant3.isworn) {
                "You'd certainly wake the Wumpi if you did that.  I suggest
                that you go east. ";
                exit;
            }
        }
        // Chase phase.  If the player hangs around, the game moves
        // him on.
        //
        if(self.phase = 3) {
            // increase the turn counter if the player is beyond a certain
            // stage
            if(toploc = Green_East_Passage) {
                if (turns < 7) {
                    turns := 7;
                    self.wakingturn := global.turnsofar - 7;
                }
            }           
            if(toploc = Green_Large_Circular_Room) {
                if (turns < 9) {
                    turns := 9;
                    self.wakingturn := global.turnsofar - 9;
                }
            }           
            if(turns < 3)
                Wumpi.wdesc := 'Some of the Wumpi have become restless due
                to the brighter lighting.  It looks as if they are about to
                wake up! ';
            if(turns = 3) {
                Large_Circular_Room.lightlevel := 1;
                Wumpi.wdesc := 'The Wumpi are starting to wake up!  One of them
                whispers a strange word which you don\'t quite make out, and
                the lighting dims.  But several Wumpi are awake now, 
                trying to make sense of their bare surroundings. '; 
            }
            if(turns >= 4 and not NoisyDoor.isopen) {
                NoisyDoor.setIsopen(true);
                doorwedge.moveInto(Green_Large_Circular_Room);
            }
            if(turns = 4) {
                Wumpi.wdesc := 'The Wumpi are now all awake, and are conversing
                in hushed tones, trying to make sense of their surroundings:
                the complete lack of furniture, the blocked-off staircase.
                One of them starts to move towards the passage. ';
            }
            if(turns >= 4) {
                if (toploc = East_Passage) {
                    "Fearing that the Wumpi will spot you, you walk through the
                    passage as quickly and quietly as you can manage, moving 
                    away from the opening so that you won't be seen. \b";
                    actor.travelTo(Red_Trans_Room);
                    exit;
                }
            }
            if(turns = 6) {
                Wumpi2.moveInto(East_Passage);
                Wumpi.wdesc := 'A few of the Wumpi have walked through the
                passage to the east.  You hear excited shouts from the
                passage, and all the Wumpi pick up their beds. ';
                Wumpi2.wdesc := 'A few of the Wumpi have come into the
                passage.  One of them points to the light, then shouts
                something to the Wumpi in the circular room.  From the
                west exit you then hear the sounds of beds being picked
                up and dragged across the floor. ';
            }
            if(turns >= 6) {
                if (toploc = Red_Trans_Room) {
                    "You hear shouts from the Large Circular Room, and sounds
                    of footsteps from the passage.  Fearing that
                    you'll be discovered, you press the green button. \b";
                    greenButton.doPush(actor);
                    exit;
                }
                if((toploc = Blue_Trans_Room) and not ((verb = pushVerb)
                and (dobj = greenButton))) {
                    "You feel a strange awareness that the Wumpi are about
                    to enter this room at Red level!  You're also acutely
                    aware of the lack of exits from this room - except the
                    green button.  So you press it.\b  ";
                    greenButton.doPush(actor);
                    exit;
                }
            }
            if(turns = 7) {
                Wumpi2.moveInto(East_Passage); // needed if turn counter is
                                               // bumped up to 7
                Wumpi.wdesc := 'The Wumpi are making their way through
                the east passage, dragging their beds behind them. ';
                Wumpi2.wdesc := 'The Wumpi are dragging their beds through
                the passage, in the direction of the Transindection
                Chamber. ';
            }
            if(turns = 9) {
                Wumpi.wdesc := Wumpi2.wdesc;
                Wumpi.moveInto(East_Passage);
                Wumpi2.moveInto(Red_Trans_Room);
                Wumpi2.wdesc := 'The Wumpi are making their way into this room
                from the west passage, dragging their beds behind them.';
            }
            if(turns = 11) {
                Wumpi.moveInto(Red_Trans_Room);
                Wumpi2.moveInto(nil);
                Wumpi.wdesc := 'The Wumpi are now all in this room.  One
                of them is standing with his finger on the green button, 
                as if waiting for a signal to press it. ';
            }
            if(turns >= 11) {
                if(toploc = Green_Trans_Room) {
                    "You feel a strange awareness that the Wumpi have now
                    assembled in this room at Red level, and that one of
                    them is standing with his finger on the green button!
                    You slip into 
                    into the passage to the west, making your way towards the 
                    far exit ...\b";
                    actor.travelTo(Green_East_Passage);
                    exit;
                }
            }
            if(turns = 12) {
                Wumpi.moveInto(Green_Trans_Room);
                room_move(Red_Trans_Room,Green_Trans_Room);
                Wumpi.wdesc := 'The Wumpi are here.  They are dragging their
                beds towards the doorway to the west. '; 
            }
            if(turns >= 12) {
                if (toploc = Green_East_Passage) {
                    "You hear a strange \"whooshing\" sound, then feel a rush
                    of cool air from the east.  Then you hear the sounds of
                    beds being dragged across the floor.  You walk through the
                    doorway as quickly as possible, ducking away from the 
                    entrance and making as little noise as you can ... \b";
                    actor.travelTo(Green_East_Passage, &west);
                    exit;
                }
            }
            if(turns = 13) {
                Wumpi.wdesc := 'The Wumpi are dragging their beds through the
                passage to the west. ';
                Wumpi2.moveInto(Green_East_Passage);
                Wumpi2.wdesc := 'The Wumpi are dragging their beds through
                the passage, towards the circular room. ';
            }
            if(turns >= 13) {
                local escaperoom,prop;
                if ((toploc = Green_Large_Circular_Room) or 
                (toploc = Top_Of_Blocks)) {
                    "You hear the Wumpi slowly approaching through the east
                    passage!  They're making an unholy din - shouts,
                    arguments and the sounds of beds being dragged back through
                    the passage.  You ";
                    if((toploc = Top_Of_Blocks) and Top_Of_Blocks.seendoor) {
                        "slip through the door to the east ...";
                        escaperoom := toploc;
                        prop := &east;
                    }
                    else if(toploc = Top_Of_Blocks) {
                        "climb down the blocks then dodge past the sleeping 
                        Wumpi and up the stairs, trying to move both quickly 
                        and quietly at the same time ... \b";
                        escaperoom := Green_Large_Circular_Room;
                        prop := &up;
                    }
                    else {
                        "dodge past the sleeping Wumpi and up the
                        stairs, trying to move both quickly and quietly at the 
                        same time ... \b";
                        escaperoom := Green_Large_Circular_Room;
                        prop := &up;
                    }
                    actor.travelTo(escaperoom,prop);
                    exit;
                }
            }
            //
            // Restrictions to prevent movement back towards the Wumpi are 
            // imposed here and by room travel methods.
            //

            if(((verb = wVerb) or (verb = backVerb)) and 
            ((toploc = Red_Trans_Room) or (toploc = East_Passage))) {
                "The Wumpi are waking up!  I respectfully suggest that you 
                move away from them before they notice your presence. ";
                exit;
            }
            if((verb = outVerb) and (toploc = Red_Trans_Room)) {
                "The Wumpi are waking up!  I respectfully suggest that you
                get out of here.  ";
                exit;
            }
            if(((verb = eVerb) or (verb = backVerb)) and 
            ((toploc = Green_East_Passage) or 
            (toploc = Green_Large_Circular_Room))) {
                "By now the Wumpi will be making their way back to their
                sleeping quarters.  You'll almost certainly run into
                them if you go that way! ";
                exit;
            }
            if((verb = kataVerb) and (toploc = Green_Large_Circular_Room)) {
                "About half of the remaining Wumpi are wearing gold rings.
                I'm not sure why they were left behind, but I have a theory;
                perhaps the rings can't transport more than 20 people at a
                time.  Anyway, it seems likely that you'd bring
                the Wumpi with you if you were to \"Kata\" yourself again,
                so you'd be well advised to use a more conventional exit
                from this room.  The stairs look like a good bet. ";
                exit;
            }
        }

        if (self.phase = 4) {
            if(turns < 14) {
                Wumpi.wdesc := 'The Wumpi are dragging their beds through
                the passage, towards the circular room. ';
                Wumpi.moveInto(Green_East_Passage);
                Wumpi2.moveInto(Green_Large_Circular_Room);
                Wumpi2.wdesc := 'Most of the Wumpi are in here, but a few are
                still coming into the room from the east passage.  Beds are
                being dragged around, and you hear shouts and arguments. ';
                Wumpi_remnant.moveInto(nil);
            }
            if(turns = 14) {
                Wumpi.moveInto(Green_Large_Circular_Room);
                Wumpi2.moveInto(nil);
                Wumpi_remnant.moveInto(nil);
                Wumpi.wdesc := 'The Wumpi appear to be preparing to go to
                sleep again.  You notice that they are rearranging their beds
                into neat rows. ';
            }

        }
        if (self.phase = 5) {
            Wumpi.moveInto(Green_Large_Circular_Room);
            Wumpi2.moveInto(nil);
            Wumpi_remnant.moveInto(nil);
        }
    }
    doCount(actor) = {
        if (self.location = Green_Large_Circular_Room and not
        (global.closed and self.phase > 0)) 
            "There appear to be about thirty Wumpi in here. ";
        else
            "There appear to be about twenty Wumpi in here. ";
    }
    // Determine whether deaths should be prevented and the lamp life
    // frozen.   This is the case in Transindection areas before the
    // Wumpus chase cycle is complete, or the green pendant has been found.
    nodeath(o) = {
        return (pendant.trans_scene(o)
        and (Wumpi.phase < 5) and (not pendant2.obtained));
    }
;

Wumpi_remnant: fixeditem
    game701 = true
    sdesc = "wumpi"
    ldesc = {
        "About ten Wumpi are left in the room, all lying on low beds.  About
        half of them are wearing gold rings, so I suggest that you don't use
        your pendant in here.  You will be able to get past them easily now. ";
    }
    noun = 'wumpi' 'wumpuses'
    adjective = 'wumpus' 'beds'
    // adjective so 'gonear wumpus' finds the regular guy
    heredesc = {
        local turns := 0;
        if(Wumpi.wakingturn)
            turns := global.turnsofar - Wumpi.wakingturn;
        P(); I();
        "About ten Wumpi are left in the room. ";
        if((turns = 3) and not NoisyDoor.isopen) {
            "One of the Wumpi wakes up, and notices that the door is closed.
            He seems unhappy with this, perhaps because the air in here has
            become very stuffy.  He walks over to the door and opens it, making
            a loud creaking sound which wakes some of the Wumpi!  They look
            angry but calm down when he points to the door and wedges it open.
            Strangely, none of them seem to notice the fact that most of the
            Wumpi are missing, and they all go back to sleep. ";
            NoisyDoor.seenopened := true;
        }
    }
    isasleep = true
    dobjGen(a, v, i, p) =
    {
        if ((v <> inspectVerb) and (v <> gonearVerb) and (v <> countVerb))
        {
            "It's not worth the risk. "; 
            "Please get out of here now!  If these Wumpi get hold of your
            pendant, we could all be in *very* serious trouble. ";
            exit;
        }
    }
    iobjGen(a, v, d, p) = {
        if (v = waveVerb or v = askVerb or v = tellVerb) return;
        self.dobjGen(a, v, d, p);
    }        
    verDoWake(actor) = {"Don't be ridiculous. ";}
    doCount(actor) = {
        "There appear to be about ten Wumpi left in here. ";
    }
;

Wumpi2: fixeditem
    sdesc = "Wumpi"
    // advance party, seen only using the sapphire/crystal ball
    heredesc = {
        P(); I();
        say(self.wdesc);
    }
;
WumpiRings: fixeditem, floatingItem
    sdesc = "Wumpi's rings"
    ldesc = "They look similar to the ring you took from the original Wumpus. "
    adjective = 'Wumpi\'s'
    noun = 'ring' 'rings'
    location = {
        local actor := getActor(&currentActor);
        if (actor.isIn(Wumpi_remnant.location))
            return Wumpi_remnant.location;
        else if(global.seenelves or topaz.moved)
            return nil;
        else
            return Wumpi.location;
    }
    doCount(actor) = {
        if(self.location = Wumpi_remnant.location)
            "About 5. ";
        else if(self.location = Green_Large_Circular_Room) 
            "About 25. ";
        else
            "About 20. ";
    }
;

Parchment: fixeditem, floatingItem, readable
    sdesc = "parchment"
    ldesc = 
        "The parchment appears to be a receipt for the rings which the
        Wumpi are no longer wearing.  It reads \"Loan of 25 
        teleportation-rings. Deposit 100 gold pieces.  Signed 
        Ondral - Mountain King.\" You resist the temptation to look for
        the gold pieces, and instead ask yourself the question: what do
        the elves want to do with all those rings? "
    location = {
        if(global.seenelves or topaz.moved)
            return Wumpi.location;
        else
            return nil;
    } 
    noun = 'parchment'
;
