//Pluto

class plutoroom: room
	plroom = true
;



gsuitcheck:function;

gsuitcheck:function
	{
	if(suit.isworn or icesuit.isworn)
		{if(robotbody.isworn)
		global.suitw := true;}
	else
		global.suitw := nil;
	}
;

// Red Section

pluto: plutoroom
	sdesc = "Red Airlock"
	ldesc = "Stepping out of the cylinder you behold a sight more wondrous than you 
		have ever imagined.  A huge city, under a large crystal dome over a mile high, spreads out 
		before you to the south.  Through the dome, which touches the ground to the north here, you can 
		see the vast emptiness of the universe above, 
		dominated by a large moon which covers over a quarter of the sky.\n\t
		The city, which at one time must have been magnificent, is a mass of rubble.  Most of the 
		tall buildings are in shambles and various forms of plant life grows wild, fed 
		by gardening robots that dart back and forth through the greenery and 
		the constant artificial sunlight shining from lamps on the dome above.\n\t
		To the north, next to the cylinder, is some type of airlock in the dome which has been fused shut.  The 
		airlock, which you can tell was once red, is a burnt, foul brackish color.\n\t
		A wide red roadway leads south from here."
	north = {"The airlock is fused shut."; return (nil);}
	south = { rpotholes.moveInto(redroad1); return(redroad1);}
	in = {
		remdaemon(robotcount, nil);
		return(shipin);
		}
	down = {if(uphat.isopen) {"After poking around in the rubble a bit you find the hatch and enter the tunnel 
			below.\b"; remdaemon(robotcount,nil); return(redhat);}
			else "You can't go that way."; return(nil);}
;

pcylin: decoration
	sdesc = "large glowing cylinder"
	isopen = true
	noun = 'cylinder' 'ship' 'craft'
	adjective = 'glowing' 'large'
	location = pluto
	ldesc = "The cylinder is about thirty feet in height and width.  It is very shiny and 
		seems to glow slightly.  There is a passage leading into the interior of it as well."
	verDoGo(actor)={}
	doGo(actor) = {Me.travelTo(shipin);
		remdaemon(robotcount,nil);}
	verDoEnter(actor) = {}
	doEnter(actor) = {Me.travelTo(shipin);}
;

rlocktower: decoration
	sdesc = "tower"
	ldesc = "The central tower far to the south, is very tall, very slender and 
		pale as a full moon.  It looks just like a large needle pointed up towards the top of 
		the dome."
	noun = 'tower ' 'spire'
	adjective = 'central' 'white' 'chalky'
	location = pluto
;

redlock: fixeditem, openable
	isListed = nil
	isopen = nil
	hno = true
	sdesc = "fused airlock"
	ldesc = "The blackened airlock, which you can tell was once been red, looks like it 
		has been sealed for at least a few millenia."
	noun = 'airlock' 'door'
	adjective = 'red' 'fused' ' blackened'
	location = pluto
	doOpen(actor) = {"The airlock is sealed shut and cannot be opened.";
			self.isopen := nil;
			exit;
			}
;

redlockroad:decoration
	sdesc = "red road"
	ldesc = "The red road is about as wide as a major highway back on Earth and is scarred by many potholes.  
		The road terminates here at the red airlock and continues south towards the central 
			tower."
	noun = 'road'
	adjective = 'red'
	location = pluto
;

rpotholes:decoration
	sdesc = "potholes"
	ldesc = "There is nothing special about the potholes."
	noun = 'potholes' 'holes'
	location = pluto
;

redroadtrav:function(parm)
	{
		redtravroad.moveInto(parm);
		rpotholes.moveInto(parm);
	}
;

redroad1: plutoroom
	sdesc = "On the Red Road"
	ldesc = "The potholed north-south road you are walking on is scarlet red and travels through a 
		section of the city dominated by dilapidated buildings and greenery run rampant.  There 
		are many paths through the broken buildings and rubble that flank the street.  Far off to 
		the south, in the center of the city, a huge white tower juts up towards the dome.  To the 
		north you can see the familiar pale glow of the cylinder."
	rt = 1
	north = pluto
	south = {redtower1.moveInto(redroad2);
				redroadtrav(redroad2);
		return(redroad2);}
	east = {rmazetower.moveInto(R10); return(R10);}
	west = {rmazetower.moveInto(R8); return(R8);}
;

redtravroad:decoration
	sdesc = "red road"
	ldesc = "The red road is about as wide as a major highway back on Earth and is scarred by many potholes. 
		The road travels from the north to the south."
	noun = 'road'
	adjective = 'red'
	location = redroad1
;

redtower1:decoration
	sdesc = "tower"
	ldesc = "The central tower far to the south is very tall, slender and pale as the moon.  Its tip almost 
		touches the top of the dome high up above."
	noun = 'tower' 'spire'
	adjective = 'central' 'white' 'chalky' 'snow' 'bone'
	location = redroad1
	doTake(actor) = { "Yeah, right."; return(nil);}
;

redroad2: plutoroom
	sdesc = "On the Red Road"
	ldesc = "The north-south road you are walking on is scarlet red and travels through a 
		section of the city dominated by dilapidated buildings and greenery run rampant.  There 
		are many paths through the broken buildings and rubble that flank the street.  Far off to 
		the south, in the center of the city, a huge white tower juts up towards the dome.  To the 
		north you can see the familiar pale glow of the cylinder."
	rt = 1
	north = {redtower1.moveInto(redroad1);
				redroadtrav(redroad1);
		return(redroad1);}
	south = {redtower1.moveInto(redroad3);
				redroadtrav(redroad3);
		return(redroad3);}
	east = {rmazetower.moveInto(R10); return(R10);}
	west = {rmazetower.moveInto(R8); return(R8);}
;

redroad3:plutoroom
	sdesc = "On the Red Road"
	ldesc = "The north-south road you are walking on is scarlet red and travels through a 
		section of the city dominated by dilapidated buildings and greenery run rampant.  There 
		are many paths through the broken buildings and rubble that flank the street.  Far off to 
		the south, in the center of the city, a huge white tower juts up towards the dome.  To the 
		north you can see the familiar pale glow of the cylinder."
	rt = 1
	north = {redtower1.moveInto(redroad2);
				redroadtrav(redroad2);
		return(redroad2);}
	south = {redroadtrav(redroad4);
			return(redroad4);}
	east = {rmazetower.moveInto(R10); return(R10);}
	west = {rmazetower.moveInto(R8); return(R8);}
;

redroad4:plutoroom
	sdesc = "On the Red Road"
	ldesc = "The north-south road you are walking on is scarlet red and travels through a 
		section of the city dominated by dilapidated buildings and greenery run rampant.  There 
		are many paths through the broken buildings and rubble that flank the street.  Further to 
		the south, in the center of some kind of plaza, a huge white tower juts up towards the dome.  
		From where you stand it is hard to see all of the tower without straining your neck. Far to 
		the north you can see the faint glow of the cylinder."
	rt = 2
	north = {redroadtrav(redroad3);
				return(redroad3);}
	south = {redtower2.moveInto(redroad5);
					redroadtrav(redroad5);
		return(redroad5);}
	east = {rmazetower.moveInto(R6); return(R6);}
	west = {rmazetower.moveInto(R1); return(R1);}
;

redtower2: decoration
	sdesc = "tower"
	ldesc = "The snow white central tower is still a far distance to the south in the center of 
				some type of plaza.  From here it looks like 
				to tip of the tower actually touches the top of the dome far up above.  "
	noun = 'tower' 'spire'
	adjective = 'central' 'white' 'chalky' 'snow' 'bone'
	location = redroad4
	doTake(actor) = { "Yeah, right."; return(nil);}
;

redroad5:plutoroom
	sdesc = "On the Red Road"
	ldesc = "The north-south road you are walking on is scarlet red and travels through a 
		section of the city dominated by dilapidated buildings and greenery run rampant.  There 
		are many paths through the broken buildings and rubble that flank the street.  Further to 
		the south, in the center of some kind of plaza, a huge white tower juts up towards the dome.  
		From where you stand it is hard to see all of the tower without straining your neck. Far to 
		the north you can see the faint glow of the cylinder."
	rt=2
	north = {redtower2.moveInto(redroad4);
				redroadtrav(redroad4);
			return(redroad4);}
	south = {redtower2.moveInto(redroad6);
			redroadtrav(redroad6);
		return(redroad6);}
	east = {rmazetower.moveInto(R6); return(R6);}
	west = {rmazetower.moveInto(R1); return(R1);}
;

redroad6:plutoroom
	sdesc = "On the Red Road"
	ldesc = "The north-south road you are walking on is scarlet red and travels through a 
		section of the city dominated by dilapidated buildings and greenery run rampant.  There 
		are many paths through the broken buildings and rubble that flank the street.  Further to 
		the south, in the center of some kind of plaza, a huge white tower juts up towards the dome.  
		From where you stand it is hard to see all of the tower without straining your neck. Far to 
		the north you can see the faint glow of the cylinder."
	rt=2
	north = {redtower2.moveInto(redroad5);
			redroadtrav(redroad5);
		return(redroad5);}
	south = {redroadtrav(redroad7); return(redroad7);}
	east = {rmazetower.moveInto(R6); return(R6);}
	west = {rmazetower.moveInto(R1); return(R1);}
;

redroad7:plutoroom
	sdesc = "On the Red Road"
	ldesc = "The north-south road you are walking on is scarlet red and travels through a 
		section of the city dominated by dilapidated buildings and greenery run rampant.  There 
		are many paths through the broken buildings and rubble that flank the street. Close to 
		the south, dominating a large plaza, sits an extremely tall white tower that seems to go 
		straight up into the heavens."
	rt=3
	north = {redroadtrav(redroad6); return(redroad6);}
	south = {redtower3.moveInto(redroad8);
					redroadtrav(redroad8);
		return(redroad8);}
	east = {rmazetower.moveInto(R11); return(R11);}
	west = {rmazetower.moveInto(R2); return(R2);}
;

redtower3: decoration
	sdesc = "tower"
	ldesc = "The bone white tower lies in a large plaza to the south of here and seems to 
			go straight up into the heavens."
	noun = 'tower' 'spire'
	adjective = 'central' 'white' 'chalky' 'bone' 'snow'
	location = redroad7
	doTake(actor) = { "Yeah, right."; return(nil);}
;

redroad8:plutoroom
	sdesc = "On the Red Road"
	ldesc = "The north-south road you are walking on is scarlet red and travels through a 
		section of the city dominated by dilapidated buildings and greenery run rampant.  There 
		are many paths through the broken buildings and rubble that flank the street. Close to 
		the south, dominating a large plaza, sits an extremely tall white tower that seems to go 
		straight up into the heavens."
	rt=3
	north = {redtower3.moveInto(redroad7);
				redroadtrav(redroad7);
		return(redroad7);}
	south = {redtower3.moveInto(redroad9);
		redroadtrav(redroad9);
		return(redroad9);}
	east = {rmazetower.moveInto(R11); return(R11);}
	west = {rmazetower.moveInto(R2); return(R2);}
;

redroad9:plutoroom
	sdesc = "On the Red Road"
	ldesc = "The north-south road you are walking on is scarlet red and travels through a 
		section of the city dominated by dilapidated buildings and greenery run rampant.  There 
		are many paths through the broken buildings and rubble that flank the street. Close to 
		the south, dominating a large plaza, sits an extremely tall white tower that seems to go 
		straight up into the heavens."
	rt=3
	north = {redtower3.moveInto(redroad8);
		redroadtrav(redroad8);
		return(redroad8);}
	south = {redroadtrav(redroad10); return(redroad10);}
	east = {rmazetower.moveInto(R11); return(R11);}
	west = {rmazetower.moveInto(R2); return(R2);}
;

redroad10:plutoroom
	sdesc = "On the Red Road"
	ldesc = "The north-south road you are walking on is scarlet red and travels through a 
		section of the city dominated by dilapidated buildings and greenery run rampant.  There 
		are many paths through the broken buildings and rubble that flank the street. Directly to 
		the south is a large plaza with an extremely tall white tower in its center.  You strain your 
		neck trying to see the top of the tower which is close to a mile overhead."
	north = {redroadtrav(redroad9); return(redroad9);}
	south = noftower
	east = {rmazetower.moveInto(R12); return(R12);}
	west = {rmazetower.moveInto(R9); return(R9);}
;

redtower4: decoration
	sdesc = "tower"
	ldesc = "The white tower is directly to the south of here and looks like it goes straight up for 
			about a mile.  From here you can see that the white tower is smooth and with out features."
	noun = 'tower' 'spire'
	adjective = 'central' 'white' 'chalky' 'bone' 'snow'
	location = redroad10
	doTake(actor) = { "Yeah, right."; return(nil);}
;

//Plaza

noftower: plutoroom
	sdesc = "North of Tower"
	ldesc = "You are standing in a circular plaza directly underneath the highest point 	
			of the dome.  To the south is a white tower that reaches to the top of the dome.  
			The tower looks to be featureless and has no obvious entrance.
			The red road you are on terminates here but continues to the north.  To the southwest the plaza becomes 
			yellow.  To the southeast the plaza becomes blue."
	north = redroad10
	south = {
				"There aren't any entrances or exits to the tower here.";
				return(nil);
				}
	se = eoftower
	sw = woftower
;

nplazatower: decoration
	hno = true
	sdesc = "tower"
	ldesc = "The white central tower climbs to the top of the dome, close to a mile 
		above you, and is perfectly smooth.  You can see no obvious entrances or 
		exits to it."
	noun = 'tower' 'spire'
	adjective = 'central' 'white' 'chalky' 'bone' 'snow'
	location = noftower
;

wplazatower: decoration
	hno =true
	sdesc = "tower"
	ldesc = "The white central tower rises to the top of the dome, close to a mile 
		above you, and is perfectly smooth.  You can see no obvious entrances or 
		exits to it from where you stand."
	noun = 'tower' 'spire'
	adjective = 'central' 'white' 'chalky' 'ivory' 'pale' 
	location = woftower
;

splazatower: decoration
	hno = true
	sdesc = "tower"
	ldesc = "The white central tower rises to the top of the dome, close to a mile 
		above you, and is perfectly smooth.  You can see no obvious entrances or 
		exits to it from where you stand."
	noun = 'tower' 'spire'
	adjective = 'central' 'white' 'chalky' 'ivory' 'pale' 
	location = softower
;

eplazatower: decoration
	hno = true
	sdesc = "tower"
	ldesc = "The white central tower rises to the top of the dome, close to a mile 
		above you, and is perfectly smooth.  You can see no obvious entrances or 
		exits to it from where you stand."
	noun = 'tower' 'spire'
	adjective = 'central' 'white' 'chalky' 'ivory' 'pale' 
	location = eoftower
;

woftower: plutoroom
	sdesc = "West of Tower"
	ldesc = "You are standing in a circular plaza directly underneath the highest point 
		of the dome.  To the east is a white tower that rises to the top of the 
		dome.  There is no obvious  entrance to the tower from here.  The yellow 
		road you are on continues to the west, turns red to the northeast and green 
		to the southeast."
	west = yellowroad9
	ne = noftower
	se = softower
	east = {
			"There aren't any entrances or exits to the tower here.";
			return (nil);
			}
;

softower: plutoroom
	sdesc = "South of Tower"
	ldesc = "You are standing in a circular plaza directly underneath the highest point of 
		the dome.  To the north is a white tower that reaches to the top of the 
		dome.  There is no obvious  entrance to the tower from here.  The green 
		road you are on continues to the south, turns yellow to the northwest and	
		blue to the northeast."
	south = greenroad10
	north = {
			"There aren't any entrances or exits to the tower here.";
			return (nil);
				}
	nw = woftower
	ne = eoftower
;

eoftower: plutoroom
	sdesc = "East of Tower"
	ldesc = "You are standing in a circular plaza directly underneath the highest point of 
		the dome.  To the west of here is a white tower that reaches to the top of 
		the dome.  There is no obvious  entrance to the tower from here.  The blue 
		road you are on continues to the east a short way before it enters a razed 
		section of the city.  The road turns red to the northwest and green to the southwest. "
	east = blueroad
	west =
			{
			"There aren't any entrances or exits to the tower here.";
			return(nil);
			}
	nw = noftower
	sw = softower
;

// Yellow Section

yellowroad9:plutoroom
	sdesc = "On the Yellow Road"
	ldesc = "This golden east-west road winds its way from the western city to the central 
		plaza dominated by the tall white central tower to the east.  Various paths lead through 
		the broken buildings and rubble which flank the street to the north and south. Far to the 
		west, two relatively intact buildings lie to the north and south of the road."
	yt = 3
	east = woftower
	west = {yellowtower3.moveInto(yellowroad8);
				yellowbuildfar.moveInto(yellowroad8);
				yroad.moveInto(yellowroad8);
		return(yellowroad8);}
	north = {rmazetower.moveInto(Y5); return(Y5);}
	south = {rmazetower.moveInto(Y10); return(Y10);}
;

yroad:decoration
	sdesc = "yellow road"
	ldesc = "The yellow road travels from the east to the west of here.  Considering the state out the city 
			around you it is surprising that the road is in such good condition."
	noun = 'road'
	adjective = 'yellow'
	location = yellowroad9
;

yellowtower3: decoration
	sdesc = "tower"
	ldesc = "The bone white tower lies in a large plaza to the east of here.  The tower seems to 
			go straight up into the heavens."
	noun = 'tower' 'spire'
	adjective = 'central' 'white' 'chalky' 'bone' 'snow'
	location = yellowroad9
	doTake(actor) = { "Yeah, right."; return(nil);}
;

yellowbuildfar:decoration
	sdesc = "buildings"
	ldesc = "The two buildings far to the west are both over sixty stories tall and appear to 
		be in good shape."
	noun = 'building'
	plural = 'buildings'
	adjective = 'glass' 'intact'
	location = yellowroad9
	doTake(actor) = { "Yeah, right."; return(nil);}
;

yellowroad8:plutoroom
	sdesc = "On the Yellow Road"
	ldesc = "This golden east-west road winds its way from the western city to the central 
		plaza dominated by the tall white central tower to the east.  Various paths lead through 
		the broken buildings and rubble which flank the street to the north and south. Far to the 
		west, two relatively intact buildings lie to the north and south of the road."
	yt = 3
	east = {yellowtower3.moveInto(yellowroad9);
		yellowbuildfar.moveInto(yellowroad9);
		yroad.moveInto(yellowroad9);
		return(yellowroad9);}
	west = {yellowbuildfar.moveInto(yellowroad7);
				yroad.moveInto(yellowroad7);
		return(yellowroad7);}
	north = {rmazetower.moveInto(Y5); return(Y5);}
	south = {rmazetower.moveInto(Y10); return(Y10);}
;

yellowroad7:plutoroom
	sdesc = "On the Yellow Road"
	ldesc = "This golden east-west road winds its way from the western city to the central 
		plaza dominated by the tall white central tower a distance to the east.  Various paths lead through 
		the broken buildings and rubble which flank the street to the north and south. Ahead, to the 
		west, two relatively intact glass buildings lie to the north and south of the road."
	yt = 2
	east = {yellowbuildfar.moveInto(yellowroad8);
		yroad.moveInto(yellowroad8);
		return(yellowroad8);}
	west = {yellowtower2.moveInto(yellowroad6);
		yroad.moveInto(yellowroad6);
		yellowbuildfar.moveInto(yellowroad6);
		return(yellowroad6);}
	north = {rmazetower.moveInto(Y9); return(Y9);}
	south = {rmazetower.moveInto(Y7); return(Y7);}
;

yellowroad6:plutoroom
	sdesc = "On the Yellow Road"
	ldesc = "This golden east-west road winds its way from the western city to the central 
		plaza dominated by the tall white central tower a distance to the east.  Various paths lead through 
		the broken buildings and rubble which flank the street to the north and south. Ahead, to the 
		west, two relatively intact glass buildings lie to the north and south of the road."
	yt = 2
	east = {yellowtower2.moveInto(yellowroad7);
		yellowbuildfar.moveInto(yellowroad7);
		yroad.moveInto(yellowroad7);
		return(yellowroad7);}
	west = {yellowtower2.moveInto(yellowroad5);
		yroad.moveInto(yellowroad5);
		return(yellowroad5);}
	north = {rmazetower.moveInto(Y5); return(Y5);}
	south = {rmazetower.moveInto(Y10); return(Y10);}
;

yellowroad5:plutoroom
	sdesc = "On the Yellow Road"
	ldesc = "This golden east-west road winds its way from the western city to the central 
		plaza dominated by the tall white central tower a distance to the east.  Various paths lead through 
		the broken buildings and rubble which flank the street to the north and south. Just to the 
		west two relatively intact glass buildings lie to the north and south of the road."
	yt = 2
	yel5 = true
	east = {yellowtower2.moveInto(yellowroad6);
		yroad.moveInto(yellowroad6);
		return(yellowroad6);}
	west = yplaza
	north = {rmazetower.moveInto(Y5); return(Y5);}
	south = {rmazetower.moveInto(Y10); return(Y10);}
;

yellowtower2: decoration
	sdesc = "tower"
	ldesc = "The snow white central tower is still a far distance to the east in the center of 
				some type of plaza.  From here it looks like 
				to tip of the tower actually touches the top of the dome far up above.  "
	noun = 'tower' 'spire'
	adjective = 'central' 'white' 'chalky' 'snow' 'bone'
	location = yellowroad7
	doTake(actor) = { "Yeah, right."; return(nil);}
;

yellowbuildnear:decoration
	sdesc = "buildings"
	ldesc = "The two buildings to the west are both over sixty stories tall 
			are made of glass and appear to 
		be in good shape."
	noun = 'building'
	plural = 'buildings'
	adjective = 'glass' 'intact'
	location = yellowroad5
	doTake(actor) = { "Yeah, right."; return(nil);}
;

yplaza: plutoroom
	sdesc = "Yellow Plaza"
	ldesc = "The yellow road widens slightly here to form a small plaza.  The area surrounding 
		here, while dilapidated, is still in much better condition than the rest of the city.  There are 
		two glass buildings, one to the north and one to the south, that look to be in good shape and safe 
		to enter."
	north = nbuild
	south = sbuild
	east = {yellowtower2.moveInto(yellowroad5);
		yroad.moveInto(yellowroad5);
		return(yellowroad5);}
	west = {yellowtower1.moveInto(yellowroad4);
		yroad.moveInto(yellowroad4);
		return(yellowroad4);}
;

northbuild: decoration
	pbuld = true
	sdesc = "northern glass building"
	ldesc = "The northern building is over sixty stories tall and made entirely of some type 
		of dark tinted glass.  The building, while a wreck, appears to be in good condition compared 
		to the buildings around it.  There is an entrance into the building to the north."
	noun = 'building'
	adjective = 'northern' 'glass'
	location = yplaza
;

southbuild: decoration
	pbuild = true
	sdesc = "southern glass building"
	ldesc = "The southern building is over sixty stories tall and made entirely of some type of 
		dark tinted glass.  The building seems to be in good condition compared to the rest of the 
		city.  There is an entrance into the building to the south."
	noun = 'building'
	adjective = 'southern' 'glass'
	location = yplaza
;

yellowroad4:plutoroom
	sdesc = "On the Yellow Road"
	ldesc = "This golden east-west road winds its way from the western city to the central 
		plaza dominated by the tall white central tower a far distance to the east.  Various paths lead through 
		the broken buildings and rubble which flank the street to the north and south. Just to the 
		east two relatively intact glass buildings lie to the north and south of the road."
	yt = 1
	yel4 = true
	east = yplaza
	west = {yellowtower1.moveInto(yellowroad3);
		yroad.moveInto(yellowroad3);
		return(yellowroad3);}
	north = {rmazetower.moveInto(Y1); return(Y1);}
	south = {rmazetower.moveInto(Y6); return(Y6);}
;
	
yellowtower1:decoration
	sdesc = "tower"
	ldesc = "The central tower far to the south is very tall, slender and pale as the moon.  Its tip almost 
		touches the top of the dome high up above."
	noun = 'tower' 'spire'
	adjective = 'central' 'white' 'chalky' 'snow' 'bone'
	location = yellowroad4
	doTake(actor) = { "Yeah, right."; return(nil);}
;

yellowbuildneara:decoration
	sdesc = "buildings"
	ldesc = "The two buildings to the east are both over sixty stories tall 
			are made of glass and appear to 
		be in good shape."
	noun = 'building'
	plural = 'buildings'
	adjective = 'glass' 'intact'
	location = yellowroad4
	doTake(actor) = { "Yeah, right."; return(nil);}
;

yellowbuildfara:decoration
	sdesc = "buildings"
	ldesc = "The two buildings far to the east are both over sixty stories tall and appear to 
		be in good shape."
	noun = 'building'
	plural = 'buildings'
	adjective = 'glass' 'intact'
	location = yellowroad3
	doTake(actor) = { "Yeah, right."; return(nil);}
;

yellowroad3:plutoroom
	sdesc = "On the Yellow Road"
	ldesc = "This golden east-west road winds its way from the western city to the central 
		plaza dominated by the tall white central tower a far distance to the east.  Various paths lead through 
		the broken buildings and rubble which flank the street to the north and south. To the 
		east two relatively intact glass buildings lie to the north and south of the road."
	yt =1
	east = {yellowtower1.moveInto(yellowroad4);
		yroad.moveInto(yellowroad4);
		return(yellowroad4);}
	west = {yellowtower1.moveInto(yellowroad2);
		yroad.moveInto(yellowroad2);
		yellowbuildfara.moveInto(yellowroad2);
		return(yellowroad2);}
	north = {rmazetower.moveInto(Y1); return(Y1);}
	south = {rmazetower.moveInto(Y6); return(Y6);}
;

yellowroad2:plutoroom
	sdesc = "On the Yellow Road"
	ldesc = "This golden east-west road winds its way from the western city to the central 
		plaza dominated by the tall white central tower a far distance to the east.  Various paths lead through 
		the broken buildings and rubble which flank the street to the north and south. To the 
		east two relatively intact glass buildings lie to the north and south of the road."
	yt = 1
	east = {yellowtower1.moveInto(yellowroad3);
		yellowbuildfara.moveInto(yellowroad3);
		yroad.moveInto(yellowroad3);
		return(yellowroad3);}
	west = {yellowtower1.moveInto(yellowroad1);
		yroad.moveInto(yellowroad1);
		yellowbuildfara.moveInto(yellowroad1);
		return(yellowroad1);}
	north = {rmazetower.moveInto(Y1); return(Y1);}
	south = {rmazetower.moveInto(Y6); return(Y6);}
;

yellowroad1:plutoroom
	sdesc = "On the Yellow Road"
	ldesc = "This golden east-west road winds its way from the western city to the central 
		plaza dominated by the tall white central tower a far distance to the east.  Various paths lead through 
		the broken buildings and rubble which flank the street to the north and south. Far to the 
		east two relatively intact glass buildings lie to the north and south of the road."
	yt = 1
	east = {yellowtower1.moveInto(yellowroad2);
		yellowbuildfara.moveInto(yellowroad2);
		yroad.moveInto(yellowroad2);
		return(yellowroad2);}
	west = yairlock
	north = {rmazetower.moveInto(Y1); return(Y1);}
	south = {rmazetower.moveInto(Y6); return(Y6);}
;

yairlock:plutoroom
	sdesc = "Yellow Airlock"
	ldesc = "You are standing at the western edge of the city where the dome touches the surface.  
		There is a yellow door embedded in the dome.  The door, which at one time must have been some sort of 
		airlock, is sealed shut with some kind of opaque material.  A wide yellow road leads away 
		from here toward the tall central tower to the east."
	east = {yroad.moveInto(yellowroad1); return(yellowroad1);}
	west = {"The door is sealed shut.";
		return(nil);}
;

ylockroad: decoration
	ldesc = "The east-west yellow road terminates here at the edge of the city."
	sdesc = "yellow road"
	noun = 'road'
	adjective = 'yellow'
	location = yairlock
;
	

ylocktower: decoration
	sdesc = "tower"
	ldesc = "The ivory central tower far to the east looms high above the city."
	noun = 'tower'
	adjective = 'central' 'white' 'ivory' 'pale'
	location = yairlock
;

yellowlock:decoration, openable
	hno = true
	isopen = nil
	isListed = nil
	sdesc = "sealed airlock"
	ldesc = "The yellow airlock is sealed shut with some type of hard opaque material."
	noun = 'airlock' 'door'
	adjective = 'yellow' 'sealed'
	location = yairlock
	doOpen(actor) = {"The airlock is sealed shut with some type of hard opaque material.  
			It cannot be opened.";
			self.isopen := nil;
			exit;
			}
;

ydoormat:decoration
	hno = true
	sdesc = "hard opaque material"
	ldesc = "The opaque material sealing the door looks like some kind of super plastic.  All 
		attempts to remove or scratch it prove unsuccessful."
	noun = 'material'
	adjective = 'clear'
	location = yellowlock
;

nbuild: plutoroom
	sdesc = "Burned Building"
	ldesc = "You are in the lobby of a tall glass building.  From the outside the building 
		looked fairly undamaged.  Now that you are inside, you see this isn't so.  The entire 
		interior of the building is charred and burnt wreckage covers the floor. 
		The roof far up above is missing, leaving the 
		building open to the outside.  The only exit is back out to the south."
	south = yplaza
	out = yplaza
	down = {if(burtwreck.active = nil) return(nil);
			else
				{"You carefully step down through the opening in the rubble.\b";
				remdaemon(robotcount,nil);
				return(punder);
				}
			}
;

burtwreck: decoration
	sdesc = "burnt wreckage"
	ldesc = "The wreckage has been charred to a crisp."
	noun = 'wreckage' 'rubble'
	adjective = 'burnt' 'charred'
	active = nil
	location = nbuild
	count = 1
	verDoClear(actor) = {}
	doClear(actor) = {
			if(self.count <=2)
				{"You sift through a small portion of the wreckage and find nothing.";
				self.count := self.count +1;
				exit;
				}
			if(self.count =3)
				{"You sift through a small portion of the rubble and find a card which you pocket.";
					thingy.moveInto(Me);
					self.count := self.count +1;
					exit;
				}
			if(self.count >3 and self.count <6)
				{
				"You sift through a small portion of the wreckage and find nothing.";
				self.count := self.count+1;
				exit;
				}
			if(self.count = 6)
				{
				"With a grunt you move a large piece an wreckage and uncover a sloping 
					passage leading down.";
				self.active := true;
				self.count := self.count +1;
				incscore(10);		//10 for finding passage to the 
				exit;
				}
			if(self.count >6)
				{"You sift through the remaining wreckage and find nothing more of value."; 
				exit;
				}
		}
	verDoSearch(actor) ={}
	doSearch(actor) = {
			if(self.count <=2)
				{"You sift through a small portion of the wreckage and find nothing.";
				self.count := self.count +1;
				exit;
				}
			if(self.count =3)
				{"You sift through a small portion of the rubble and find a card which you pocket.";
					thingy.moveInto(Me);
					self.count := self.count +1;
					exit;
				}
			if(self.count >3 and self.count <6)
				{
				"You sift through a small portion of the wreckage and find nothing.";
				self.count := self.count+1;
				exit;
				}
			if(self.count = 6)
				{
				"With a grunt you move a large piece an wreckage and uncover a sloping 
					passage leading down.";
				self.active := true;
				self.count := self.count +1;
				incscore(10);		//10 for finding passage to the 
				exit;
				}
			if(self.count >6)
				{"You sift through the remaining wreckage and find nothing more of value."; 
				exit;
				}
		}
;
				
			

sbuild: plutoroom
	sdesc = "Lobby"
	ldesc = "Somehow this building has been left relatively untouched from whatever ravished the 
		rest of the city.  A think layer of dust covers the carpeted floor of the building indicating that 
		nobody has been here for quit a long time.  Soft lights in the ceiling light the room without 
		casting shadows.  There is one area by the far wall that has remained free of dust.  The only 
		exit is back out to the north."
	north = yplaza
	out = yplaza
;

lteleporter: fixeditem, surface
	sdesc = "clean spot"
	ldesc = "This is very odd.  The entire room is covered in thick dust except for this three foot 
		circular area."
	noun = 'area' 'spot' 'teleporter' 'circle'
	adjective = 'bare' 'clean' 'circular'
	location = sbuild
	verDoStepon(actor) ={}
	verDoGo(actor) = {}
	verDoWalkinto(actor) = {}
	verDoEnter(actor)={}
	doEnter(actor) = {
		"As you step on the clean area your stomach jumps up into your throat and you blackout.  When you regain your 
			senses you find yourself someplace 
			else.\b";
 		Me.travelTo(observation);
		}
	doStepon(actor) = {
		"As you step on the clean area your stomach jumps up into your throat and you blackout.  When you regain your 
			senses you find yourself someplace 
			else.\b";
		Me.travelTo(observation);
		}
	doGo(actor) = {
		"As you step on the clean area your stomach jumps up into your throat and you blackout.  When you regain your 
			senses you find yourself someplace 
			else.\b";
		Me.travelTo(observation);
		}
	doWalkinto(actor) = {
		"As you step on the clean area your stomach jumps up into your throat and you blackout.  When you regain your 
			senses you find yourself someplace 
			else.\b";
		Me.travelTo(observation);
		}
	ioPutOn(actor, dobj) = {
		"You drop the <<dobj.sdesc>> onto the clean area and it disappears with a faint \"pop.\"";
		dobj.moveInto(observation);
		}
;

ldust: fixeditem
	sdesc = "layer of dust"
	ldesc = "The dust looks like it has been collecting for millenia and is several inches thick."
	noun = 'dust'
	adjective = 'layer of' 'thick'
	location = sbuild
	verDoClean(actor) = {}
	doClean(actor) = {"It would take many lifetimes to clean up the amount of dust here.";}
	verDoClear(actor) = {}
	doClear(actor) = {"It would take many lifetimes to clean up the amount of dust here.";}
;

odust:fixeditem
	sdesc = "layer of dust"
	ldesc = "The dust looks like it has been collecting for millenia and is several inches thick."
	noun = 'dust'
	adjective = 'layer of' 'thick'
	location = observation
	verDoClean(actor) = {}
	doClean(actor) = {"It would take many lifetimes to clean up the amount of dust here.";}
	verDoClear(actor) = {}
	doClear(actor) = {"It would take many lifetimes to clean up the amount of dust here.";}
;

observation: plutoroom
	istower = true
	sdesc = "Room With a View"
	ldesc = "This dusty room high up in the southern building offer an excellent view of the city.  A thick 
		layer of dust covers the entire floor except for a clean sport in the center of the room.  You can see 
		no exits."
;

pcity: fixeditem
	sdesc = "city"
	ldesc = {
		"\tThe ruined city spread around you for miles and miles.  Buildings have long since collapsed to 
		rubble and plants grow out of control over almost everything.  The only sign of movement is from 
		the occasional light from a gardening robot trying to keep the plants in check.  The city is illuminated 
		by lights on the dome which protects the city from the vacuum outside.\n\t
		The center of the city is dominated by a tall, slender ivory tower that almost touches the ceiling of 
		the dome.  The tower looks completely featureless, lacking even windows and doors.\n\t
		On the ground, radiating out from the tower in each of the cardinal directions, are four long and wide 
		roads colored red, yellow, green and blue.\n\t
		The yellow road runs westwards from the tower and goes trough the least damaged part of the 
		city.\n\t
		The red road winds its way north from the tower through a section of the city that has been 
		almost completely devastated.  In the northwestern corner of the city there appears to be a small building.  
		While not in fantastic shape, it is still standing.  At the terminus of the read road, far to the north, the 
		faint glow of the cylinder shines like a beacon.\n\t
		The blue road travels eastwards from the central tower into a region covered in darkness.  
		The only light that falls on this area is from dim emergency lights on the dome which illuminates 
		just enough to see the eastern region is totally razed except for a lonely building far, far to the 
		east.";
		if ((glowstick.location).bmaze) "  In addition to the dim light from above, there is a strange 
		greenish glow in one section of the eastern ruins.";
		"\n\tThe green road, which runs south from the tower, enters a jungle of plant life a fair distance about 
		a third of the way between the tower and the southern wall of the dome.  The plant life in this region 
		completely covers the city, hiding everything from view.\n";
		}
	noun = 'city'
	location = observation
;

oteleporter: fixeditem, surface
	sdesc = "clean spot"
	ldesc = "This is very odd.  The entire room is covered in thick dust except for this three foot 
		circular area."
	noun = 'area' 'spot' 'teleporter' 'circle'
	adjective = 'bare' 'clean' 'circular'
	location = observation
	verDoStepon(actor) ={}
	verDoGo(actor) = {}
	verDoWalkinto(actor) = {}
	verDoEnter(actor) ={}
	doStepon(actor) = {
		"As you step on the clean area your stomach jumps up into your throat and you blackout.  When you regain your  
			senses you find yourself someplace 
			else.\b";
 		Me.travelTo(sbuild);
		}
	doEnter(actor) = {
		"As you step on the clean area your stomach jumps up into your throat and you blackout.  When you regain your  
			senses you find yourself someplace 
			else.\b";
 		Me.travelTo(sbuild);
		}
	doGo(actor) =  {
		"As you step on the clean area your stomach jumps up into your throat and you blackout.  When you regain your 
			senses you find yourself someplace 
			else.\b";
		Me.travelTo(sbuild);
		}
	doWalkinto(actor) =  {
		"As you step on the clean area your stomach jumps up into your throat and you blackout.  When you regain your 
			senses you find yourself someplace 
			else.\b";
		Me.travelTo(sbuild);
		}
	ioPutOn(actor, dobj) = {
		"You drop the <<dobj.sdesc>> onto the clean area and it disappears with a faint \"pop.\"";
		dobj.moveInto(sbuild);
		}
;

//Yellow Underground

punder: plutoroom, darkroom
	istower = true
	sdesc = " Tunnel"
	ldesc = "This abandoned tunnel must have once been used for maintenance of the city.  
		The only exist are above to the surface and down the tunnel to the northeast and southwest."
	ne = neunder
	sw = swunder
	up = {setdaemon(robotcount, nil); return(nbuild);}
;

swunder:plutoroom, darkroom
	istower = true
	sdesc = "By Hatch"
	ldesc = "The tunnel ends here by a large hatch to the east.  Over the hatch is a sign. 
			The only exit is back to the northeast."
	ne = punder
	east = { "The hatch is in the way."; return (nil);}
;

uhatch:decoration, openable
	sdesc = "hatch"
	ldesc = "The hatch is roughly man-sized and closed."
	noun = 'hatch'
	location = swunder
	isopen = nil
	count = 0
	doOpen(actor) = { 
			"You grab hold of the hatch and swing it open, which reveals another hatch!  When you let go of the 
				hatch you juts opened, it disappears with a \"pop.\"\b";
			if(self.count = 3)
				"My, aren't we persistent.\b";
			if(self.count = 6)
				"Monotonous, isn't it?\b";
			if(self.count = 9)
				"Shouldn't you be giving up by now?\b";
			if(self.count = 12)
				"Someone definitely has a sick sense of humor.\b";
			if(self.count = 15)
				"Look, even though I am enjoying this, take my word for it,  there is nothing behind the hatch.\b";
			if(self.count = 18)
				"Sigh.....  Look read the sign.  The hatch is a sick joke the author came up with at four in 
				the morning while writing this game.  Go do something more productive 
				like trying to find your way home.  After all that is what you are trying to do.\b";
			if(self.count =21)
				"That's it.  I give up....\b";
			if(self.count = 24)
				{
				"While your persistence (or should I say stubbornness) is well noted.  In fact, you are so persistent 
				with the hatch that you do not notice the maintenance robot coming up behind you.  
				Before you can react to its presence
				the bot, thinking you are another robot and most likely damaged, tries to shock you into 
				sanity by discharging a bolt of electricity into you.  Needless to say, it didn't work.\b";
				die();
				}
			self.count := self.count + 1;
		}
;  

hsign:decoration, readable
	sdesc = "sign"
	ldesc = "The sign says \"Zeno's Hatch.\""
	noun = 'sign'
	location = swunder
;
	
neunder:plutoroom, darkroom
	istower = true
	sdesc = "Fork in the Tunnel"
	ldesc = "The tunnel forks here to the north, east and southwest.  Every once in a while you see a flash 
			of blue light to the north"
	north = pntunnel
	east = petunnel
	sw = punder
;

pntunnel:plutoroom, darkroom
	istower = true
	sdesc = "Spike Room"
	ldesc = {"The smell of electricity hangs in the air here.  The walls of the tunnel to north of here 
				are covered in coppery spikes.  Every so often a bolt of electricity erupts between the spikes. 
				The tunnel continues back to the south, or between the spikes to the north into a small room. ";
				if (greenzapper.location = ucloset) "In the room past the spikes you can see some type of air horn.";
				}
	south = neunder
	north = {"Confidently you step forward between the spikes and right into a bolt of electricity.";
					die();
				}
;

pnobject:fixeditem
	sdesc = "object"
	ldesc = "You have to get closer to examine the horn."
	noun = 'object' 'horn'
	adjective = 'air'
	location = pntunnel
	verDoTake(actor) = {}
	doTake(actor) = {"The horn is in the room beyond the spikes.  You cannot take it.";}
;

petunnel:plutoroom, darkroom
	istower = true
	sdesc = "Tunnel Junction"
	ldesc = "Four tunnels join here to form a small junction.  The tunnels least to the north, east, south and west."
	north = nufork
	south = uguard
	east = {"You walk a few yards  down the eastern tunnel, but turn back when you see the tunnel has caved 
			in."; return(nil);}
	west = neunder
;

nufork:plutoroom, darkroom
	istower = true
	sdesc = "Another Fork"
	ldesc = "You are at another for in the tunnel.  Paths lead to the south, north and northwest."
	north = redhat
	nw = uside
	south = petunnel
;

redhat:plutoroom, darkroom
	istower = true
	sdesc = "By Hatch"
	ldesc = "The slopes up here to <<uphat.isopen ? "an open" : "a closed">> hatch in the ceiling.  
			The tunnel continues away from here to the south."
	south = nufork
	up = {setdaemon(robotcount, nil); return(uphat);}
;

uphat:doorway
	ldesc = "The hatch is about man-sized and currently is <<self.isopen ? "open" : "closed">>."
	sdesc = "hatch"
	noun = 'hatch'
	location = redhat
	doordest  = pluto
;

uside:plutoroom, darkroom
	istower = true
	sdesc = "Side Room"
	ldesc = "This small room juts off from the main tunnel to the southeast. Scattered about the room are 
				many smashed 
				robot parts."
	se = nufork
;

robparts: fixeditem
	sdesc = "collection of broken parts"
	ldesc = "The large group of robot parts are broken beyond repair."
	noun = 'parts'
	adjective = 'broken' 'robot' 'collection'
	preposition = 'of'
	location = uside
	donce = nil
	verDoTake(actor) = {}
	verDoClear(actor) = {}
	doClear(actor) = {
			"You clear away some of the parts to reveal.... more parts!!!";
				}
	verDoSearch(actor) ={}
	doSearch(actor) = {if(self.donce = nil)
				{
				"Searching through the parts you manage to salvage the head to a human sized robot.";
					robothead.moveInto(Me);
				self.donce := nil;
				}
				else "All of the robot parts are broken beyond repair.  You do not find anything of interest.";
			}
	doTake(actor) = {"You grab a few of the smaller parts."; trobparts.moveInto(Me);}
;

trobparts:vulnerable
	sdesc = "group of small robot parts"
	ldesc = "There is nothing remarkable about the broken robot parts."
	noun = 'parts'
	adjective = 'broken' 'robot' 'small' 'group'
	preposition = 'of'
	location = nil
	weight = 5
	bulk = 3
;

robothead: clothingItem, vulnerable
	sdesc = "robot head"
	ldesc = "The robot head is just a shell.  However, it does look like you can wear it."
	noun = 'head' 'helmet' 'helm'
	adjective = 'robot'
	location = nil
	doWear(actor) = {
		if(self.location = Me)
			{
			if(suit.isworn or icesuit.isworn) 
				{
				"You cannot fit the <<self.sdesc>> over the ";
				if(suit.isworn) "<<suit.sdesc>>";
				else "<<icesuit.sdesc>>";
				".";
				}
			else
				{
				"It is a tight fit, but you manage to stuff your head into the robot head.";
				robothead.isworn := true;
				} 
			}
		else
		{"You don't have the robot head!"; self.isworn := nil;}
	}
;

robotbody:clothingItem, vulnerable
	sdesc = "robot body"
	ldesc = "The robot body has been gutted and is missing a head.  
			Though slightly dented you do think you can wear it."
	noun = 'body' 'suit'
	adjective = 'robot'
	location = observation
	bulk = 3
	doWear(actor)={
		if(self.location = Me)
			{
			local melist, lmelist, i ,obj, h;
			h := true;
			melist := Me.contents;
			lmelist := length(melist);
			i := 1;
			while (i<= lmelist)
				{
				obj := melist[i];
				if(obj.isworn)
					{
					"The <<self.sdesc>> doesn't fit over the <<obj.sdesc>>.";
					h := nil;
					exit;
					}
				i := i+1;
				}
			if(h)
				{
				self.isworn := true;
				"Ok, you are now wearing <<self.thedesc>>.";
				}
			else
				self.isworn := nil;
			}
		else "I don't see what you are talking about.";
		}
;

uguard:plutoroom, darkroom
	enterRoom(actor) = {
		notify(guardrobo, &actorDaemon, 0);
		pass enterRoom;
		}
	sdesc = "Robot Room"
	ldesc = {"The tunnel widens a bit here to form a small room.  A path to the south is blocked by a 
			large robot pacing back and forth across the tunnel.  
		To the north, the tunnel intersects with others to form a junction.\b\t";
		if(uguard.hereonce = nil and (robothead.isworn = nil or robotbody.isworn = nil))
			{"The robot notices your intrusion and yells \"Halt!  Organic lifeforms not permitted beyond this 
				point!\"\b";
				self.hereonce := true;
			}
		}
	doneonce = nil
	hereonce = nil
	north = petunnel
	south = {
			if(robothead.isworn)
				{
				if(robotbody.isworn)
					{
					"As you approach the guard robot looks you over.  After a moment it moves aside and lets you by.\b";
						if (not self.doneonce)
							{
								incscore(15);		//15 for getting past the robot the first time.
								self.doneonce := true;
							}
					return(shatch);
					}
				else
					{"As you approach the guard robot looks you over.  In a split second it  
						moves to block your path booming \"Organic lifeforms not permitted beyond this 
					point!  Organic lifeforms not permitted beyond this point!\"\b";
					return(nil);
					}
				}
			else
				{
				"As you approach the guard robot looks you over.  In a split second it  
						moves to block your path booming \"Organic lifeforms not permitted beyond this 
					point!  Organic lifeforms not permitted beyond this point!\"\b";
				return(nil);
			}
		}
;


guardrobo: Actor
	noun = 'robot'
	adjective = 'guard'
	ldesc = "The guard robot is very big and is pacing back and forth across the tunnel."
	location = uguard
	sdesc = "guard robot"
	adesc = " the guard robot"
	donce = nil
	actorDesc = "The guard robot is here pacing back and forth across the tunnel. "
	actorDaemon =
		{
		if(self.location <> Me.location) return;
		switch(rand(6))
			{
			case 1:
			{"\bThe robot starts humming an old marshal tune.";
			break;}
			case 2:
			{"\bThe robot stalls for a second, lets out of puff of smoke and starts up again.";
			break;}
			case 3:
			{"\bThe robot increases its rate of pacing.";
			break;}
			case 4:
			{"\bTurning around, the robot takes a hunk out of the wall.";
			break;}
			case 5:
			{"\bThe robot slows down a bit.";
			break;}
			}
	}
	verDoAskAbout(actor,iobj) = {}
	doAskAbout(actor,iobj) = {
		"\"Organic lifeforms are not allowed beyond this point!\"";
		}
;

shatch: plutoroom, darkroom
	sdesc = "By Hole"
	ldesc = "There tunnel dead ends here at a hole in the floor.  To the north you see the 
		guard robot merrily pacing back and forth.  You can see the hole in the floor 
		leads down into some subtunnels."
	north = {
			if(robothead.isworn = nil or robotbody.isworn = nil)
				{"As you walk past the guard robot it turns to you can looks you over.  
				In a split second the robot determines you are an organic lifeform and 
				proceeds to turn you into fertilizer.";
				die();
				}
			else
				{
				"As you walk pas the guard robot it turn to you and looks you over.  
				Satisfied you are not organic it lets you by.\b";
				return (uguard);
				}
			}
		down = {
				"You enter the mess of subtunnels and emerge in the...\b";
				return(ucloset);
				}
;

ucloset:plutoroom, darkroom
	sdesc = "Alcove"
	ldesc = "You are in a small alcove at the end of a corridor.  To the south the tunnel 
			is lined with coppery spikes which are spewing bolts of electricity.  In the 
			floor is a hole leading into the subtunnels."
	down = {
				"You enter the mess of subtunnels and emerge in the...\b";
				return(shatch);
				}
	south = {"Confidently you step forward between the spikes and right into a bolt of electricity.";
					die();
				}
;




// Green Section

greentower: decoration
	sdesc = "tower"
	ldesc = "The bone white tower lies in a large plaza to the north of here.  The tower seems to 
			go straight up into the heavens."
	noun = 'tower' 'spire'
	adjective = 'central' 'white' 'chalky' 'bone' 'snow'
	location = greenroad10
	doTake(actor) = { "Yeah, right."; return(nil);}
;

farplants: decoration
	sdesc = "overgrown plants"
	ldesc = "The overgrown plants completely encase the area far to the south in darkness."
	noun = 'plants' 'vegetation' 'shrubbery'
	adjective = 'overgrown' 'wild'
	location = greenroad10
;

groad:decoration
	sdesc = "green road"
	ldesc = "The north-south green road is in terrible condition.  It looks like someone just picked up the road and 
			scattered it about the place."
	noun = 'road'
	adjective = 'green'
	location = greenroad10
;

greenroad10: plutoroom
	sdesc = "On the Green Road"
	ldesc = "You are on the remains of a lime green road that runs north-south from central tower area 
			to the north to a dark area far to 
		the south overgrown with plant life.  Various paths lead through the broken buildings and rubble which 
		flank the street to the east and west.  The paths to the east and west are very dark, it might not be a good 
		idea to go that way without some light."
	gt = true
	south = {greentower.moveInto(greenroad9);
			farplants.moveInto(greenroad9);
			groad.moveInto(greenroad9);
			return(greenroad9);}
	north = softower
	east = {
				gsuitcheck();
				if(not global.suitw)
					{
					setdaemon(vinecount, nil);
					return(G8);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	west = {
				gsuitcheck();
				if(not global.suitw)
					{
					setdaemon(vinecount, nil);
					return(G2);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	se = {
				gsuitcheck();
				if(not global.suitw)
					{
					setdaemon(vinecount, nil);
					return(G10);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	sw =  {
				gsuitcheck();
				if(not global.suitw)
					{
					setdaemon(vinecount, nil);
					return(G2);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
;

greenroad9: plutoroom
	sdesc = "On the Green Road"
	ldesc = "You are on the remains of a lime green road that runs north-south from the 
		central tower area to the north to a dark area far to 
		the south overgrown with plant life.  Various paths lead through the broken buildings and rubble which 
		flank the street to the east and west.  The paths to the east and west are very dark, it might not be a good 
		idea to go that way without some light."
	gt = true
	south = {greentower.moveInto(greenroad8);
			groad.moveInto(greenroad8);
			return(greenroad8);}
	north = {greentower.moveInto(greenroad10);
			groad.moveInto(greenroad10);
			farplants.moveInto(greenroad10);
			return(greenroad10);}
	east = {
				gsuitcheck();
				if(not global.suitw)
					{
					setdaemon(vinecount, nil);
					return(G8);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	west = {
				gsuitcheck();
				if(not global.suitw)
					{
					setdaemon(vinecount, nil);
					return(G2);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	se = {
				gsuitcheck();
				if(not global.suitw)
					{
					setdaemon(vinecount, nil);
					return(G10);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	sw =  {
				gsuitcheck();
				if(not global.suitw)
					{
					setdaemon(vinecount, nil);
					return(G2);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
;

greenroad8:plutoroom
	sdesc = "Mouth of Vines"
	ldesc = "Before you to the south is the border of the area of the city completely covered by 
		wild vegetation.  The various plants and vines form what almost looks like a mouth with the 
		green road you are standing on its tongue.  The wreckage of the green road continues towards 
		the central tower area 
		to the north, but vanishes under all the plant life to the south. Various paths lead through the 
			broken buildings and rubble 
		which flank the street to the east and west and into the jungle.   The paths to the east, south and 
		west are very dark, it might not be 
		a good 
		idea to go that way without some light."
	gt = true
	south = {
				gsuitcheck();
				if(not global.suitw)
					{
					setdaemon(vinecount, nil);
					return(greenroad7);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	north = {greentower.moveInto(greenroad9);
			groad.moveInto(greenroad9);
			return(greenroad9);}
	east = {
				gsuitcheck();
				if(not global.suitw)
					{
					setdaemon(vinecount, nil);
					return(G8);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	west = {
				gsuitcheck();
				if(not global.suitw)
					{
					setdaemon(vinecount, nil);
					return(G2);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	se = {
				gsuitcheck();
				if(not global.suitw)
					{
					setdaemon(vinecount, nil);
					return(G10);
					}
				else
					{
					"You are wearing to much to fit through all the vines..";
					return(nil);
					}
				}
	sw = {
				gsuitcheck();
				if(not global.suitw)
					{
					setdaemon(vinecount, nil);
					return(G2);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
;

mvines: fixeditem
	sdesc = "canopy of vines and leaves"
	ldesc = "The canopy of vines and leaves to the south form what looks like a mouth full of food.  Just looking 
		at it gives you the creeps.  You turn away just as you see movement out of the corner of your eye.  
		Turning back, you notice that some of the vines are in a different place from where they were a second 
		ago."
	noun = 'vines' 'vegetation' 'canopy' 'mouth' 'leaves'
	adjective = 'canopy of'
	location = greenroad8
;

class jungleroom: plutoroom, darkroom
	jungle = true
;


greenroad7:jungleroom
	sdesc = "In the Jungle"
	ldesc = "The plant life about you covers everything in this area blocking out all outside light and 
		giving you the impression that you 
		are walking among the branches of some giant bush.  Vines that seem to taunt you 
		dangle from the canopy of greenery far above.   The path you are on continues out of the jungle to 
		the north or deeper into the vegetation to the south.  To the east, west, southeast and southwest you 
		can see well worn paths through the surrounding rubble."
	north = {remdaemon(vinecount,nil);
		"You step out of the jungle and into the light.\b";
		groad.moveInto(greenroad8);
		return(greenroad8);
		}
	south = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(greenroad6);
					return(greenroad6);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	east = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G11);
					return(G11);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	west = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G3);
					return(G3);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	se = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G16);
					return(G16);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	sw = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G5);
					return(G5);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
;

jungleplants: decoration
	sdesc = "mesh of vines and plants"
	ldesc = "The vines and plants form a thick mesh of greenery about you.  You can swear 
		that you see some of the plants moving out of the corner of your eye.  Naaaa... that's silly."
	noun = 'vine' 'plant' 'canopy'
	plural = 'vines' 'plants'
	adjective = 'mesh of'
	location = greenroad7
	verDoClimb(actor) ={}
	doClimb (actor) = {
		"The vines are not thick enough to support your weight.  You cannot climb them.";
		}
;

greenroad6: jungleroom
	sdesc = "In the Jungle"
	ldesc = "The plant life about you covers everything in this area blocking out all outside light and 
		giving you the impression that you 
		are walking among the branches of some giant bush.  Vines that seem to taunt you 
		dangle from the canopy of greenery far above.   The path you are on continues into the 
		jungle to the north and south.  To the east, west, southeast and southwest you 
		can see well worn 
		paths through the surrounding rubble."
	north = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(greenroad7);
					return(greenroad7);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	south = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(greenroad5);
					return(greenroad5);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	east = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G11);
					return(G11);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	west = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G3);
					return(G3);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	se = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G16);
					return(G16);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	sw = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G5);
					return(G5);
					}
				else
					{
					"You are wearing to much to fit through all the vines..";
					return(nil);
					}
				}
;

greenroad5: jungleroom
	sdesc = "In the Jungle"
	ldesc = "The plant life about you covers everything in this area blocking out all outside light and 
		giving you the impression that you 
		are walking among the branches of some giant bush.  Vines that seem to taunt you 
		dangle from the canopy of greenery far above.   The path you are on continues into the 
		jungle to the north and south.  To the east, west, southeast and southwest you 
		can see well worn 
		paths into the surrounding rubble."
	north = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(greenroad6);
					return(greenroad6);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	south = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(greenroad4);
					return(greenroad4);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	east = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G11);
					return(G6);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	west = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G3);
					return(G3);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	se = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G16);
					return(G16);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	sw = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G5);
					return(G5);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
;
	
greenroad4: jungleroom
	sdesc = "Deep in the Jungle"
	ldesc = "The plant life here is thick to the point of oppressive.  You get the definite feeling that you 
			are not welcome in this area, but the question is welcome by what?  Though overgrown, you can 
			make out paths through the jungle 
			to the north, east, south and west."
	north = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(greenroad5);
					return(greenroad5);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	south = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(greenroad3);
					return(greenroad3);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	east = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G16);
					return(G16);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	west = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G6);
					return(G6);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
;

greenroad3: jungleroom
	sdesc = "Deep in the Jungle"
	ldesc = "The plant life here is thick to the point of oppressive.  You get the definite feeling that you 
			are not welcome in this area, but the question is welcome by what?  Though overgrown, you can 
			make out paths through the jungle  
			to the north, east, south and west."
	north = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(greenroad4);
					return(greenroad4);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	south = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(greenroad2);
					return(greenroad2);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	east = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G16);
					return(G16);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	west = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G6);
					return(G6);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
;

greenroad2: jungleroom
	sdesc = "Deep in the Jungle"
	ldesc = "The plant life here is thick to the point of oppressive.  You get the definite feeling that you 
			are not welcome in this area, but the question is welcome by what?  Though overgrown, you can 
			make out paths through the jungle 
			to the north, east, south and west."
	north = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(greenroad3);
					return(greenroad3);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	south = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(greenroad1);
					return(greenroad1);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	east = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G16);
					return(G16);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	west = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G6);
					return(G6);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
;

greenroad1: jungleroom
	gheart = true
	sdesc = "Heart of the Jungle"
	ldesc = {
			"This entire area is literally covered in plant life and is very quiet.  As you walk, the vines seem 
		to reach out and grab for you.  There are clear paths through the jungle to the north, east and west.  ";
		if(vcurtain.location = greenroad1) 
		"There is another path leading to the south 
		but is blocked by a curtain of red, sticky vines.";
		else
		"There is also another path leading to the south.";
		}
	vinecnt = 0
	north = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(greenroad2);
					return(greenroad2);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	south = 
		{
				gsuitcheck();
				if(not global.suitw)
					{
					if(vcurtain.active) {
						if (vcurtain.vinecnt <=4)
							{
							"As you approach a single vine whips you across the face stinging where it touched.";
							vcurtain.vinecnt := vcurtain.vinecnt +1;
							return(nil);
								}
							else
							{
							"Annoyed with your presence, the vines grab you as you approach.  The thick sap burns and stings 
							to the touch.  As you struggle to free yourself the vines pull you apart piece by piece.";
							die();
							}
					}
					else
					{
					if (not vcurtain.uponce) {incscore(15); //15 for getting past the vines the first time
									vcurtain.uponce := true;
									}
					jungleplants.moveInto(gairlock);
					return(gairlock);
					remdaemon(vinecount,nil);
					}
			}
			else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
		}
	east = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G12);
					return(G12);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
	west = {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G15);
					return(G15);
					}
				else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
				}
;

vcurtain: decoration
	sdesc = "curtain of vines"
	ldesc = "The vines seem to move in response to your proximity as you approach to examine them.  
			The vines are long, red and look to be covered in some type of sap.  They form a solid 
			curtain completely blocking the path to the south."
	noun = 'vine' 'curtain'
	plural = 'vines'
	adjective = 'curtain of'
	location = greenroad1
	active = true
	uponce = nil
	vinecnt = 0
;

greenzapper: item, readable
	fragile = true
	vol = true
	sdesc = "hand held air horn"
	ldesc = "The air horn looks much like those you have seen used by people who sail.  There is a pink 
		button on the top of the horn and some 
		writing on the horn's side."
	readdesc = "Warning: Do not activate close to ears.  Horn produces a high volume blast at an 
		inaudible frequency."
	noun = 'horn'
	adjective = 'air'
	location = ucloset
	doTake(actor) = {pnobject.moveInto(void); pass doTake;}
;

plantpaper: item, readable
	sdesc = "old notebook"
	ldesc = "The notebook looks very old and its pages agre made out of some type of plastic.  
			Some of the writing on the pages is still legible."
	readdesc = "Not much of the writing is legible but you do make out the following\b
			\"...spores discovered in ice pack today seem to be some type of...\n\tSap contains a type of 
			contact venom which ... lyzes animal matter... Life forms incompatible...\n\t
			Plants have taken over half of the city and spread to other domes... only option is abandoning of 
			colony.\n\t ...low freq. audio signals repel... ay prove to b... rmful to plants...\"\b"
	noun = 'notebook'
	adjective = 'old'
	location = observation
;

nbkwrt:decoration
	sdesc = "notebook pages"
	ldesc = "The pages are made out of some type of plastic.  A few of the pages are still legible."
	readdesc = "Not much of the writing is legible but you do make out the following\b
			\"...spores discovered in ice pack today seem to be some type of...\n\tSap contains a type of 
			contact venom which ... lyzes animal matter... Life forms incompatible...\n\t
			Plants have taken over half of the city and spread to other domes... only option is abandoning of 
			colony.\n\t ...low freq. audio signals repel... ay prove to b... rmful to plants...\"\b"
	noun = 'pages' 'writing'
	adjective = 'notebook' 'plastic'
	location = plantpaper
;

hornbut:buttonitem
	fragile = true
	vol = true
	sdesc = "pink button"
	ldesc = "There is nothing special about the pink button"
	adjective = 'pink'
	location = greenzapper
	butcount = 0
	vbutcount = 0
	doPush(actor) ={
		if ((Me.location).gheart)
			{
			if(self.vbutcount <= 3)
			{
			"With an evil smirk you aim the horn at the curtain of vines and push the button.  You hear nothing 
			from the air horn but the vines sure seem to.  The vines quiver and retract up into the canopy 
			away from the sound clearing the path before you.";
			vcurtain.active := nil;
			vcurtain.vinecnt := 0;
			vcurtain.moveInto(nil);
			setdaemon(curtaincount, nil);
			self.vbutcount := self.vbutcount +1;
			exit;
			}
			else
			{
			"With an evil smirk you aim the horn at the curtain of vines and push the button.  The vines, annoyed 
			with your continued harassment, reach forward and grab you.  The sap that covers the vines stings 
			your body.  This, however, is pleasant compared to the feeling of the various vines ripping 
			you to shreds.";
			die();
			}
			}
		if((Me.location).jungle)
			{
			"You push the button but hear nothing.  Suddenly some of plants and vines ";
			if (self.butcount >= 3)
				{
				"annoyed with your continued taunting grab you with malevolence.  
				The sap on the vines sting your body as they quickly wrap around your body.  You 
				try to scream in pain but a vine wraps itself around your neck and squeezes so 
				tight your head 
				pops off your body like a cork out of a champagne bottle.";
				die();
				}
			else
				{
				"move away from the sound with a definite feeling a hatred towards you.";
				self.butcount := self.butcount +1;
				}
			exit;
			}
		else
			"You push the button but you hear nothing.  It maybe broken.";
			exit;
		}
;
			
			
gairlock: jungleroom
	gheart = true
	sdesc = "Heart of the Jungle, by Green Airlock"
	ldesc = {
		"The jungle thins a bit here, but not much.  Plant life exists in every direction and even climbs up 
		the walls of the dome to the south.  In the dome wall, covered in some kind of hardened amber sap is a 
		large green door.  Stuck firmly in a pool of hardened sap by the foot of the door is a smashed 
		gardening robot.  There is a path that leads deeper into the jungle to the north";
		if (vcurtain.isactive)
			" which is blocked by a curtain of vines.";
		else
		".";
		}
	north = {
				gsuitcheck();
				if(not global.suitw)
					{
					if(vcurtain.active) {
						if (vcurtain.vinecnt <=4)
							{
							"As you approach a single vine whips you across the face stinging where it touched.";
							vcurtain.vinecnt := vcurtain.vinecnt +1;
							return(nil);
								}
							else
							{
							"Annoyed with your presence, the vines grab you as you approach.  The thick sap burns and stings 
							to the touch.  As you struggle to free yourself the vines pull you apart piece by piece.";
							die();
							}
					}
					else
					{
					jungleplants.moveInto(greenroad1);
					return(greenroad1);
					setdaemon(vinecount,nil);
					}
			}
			else
					{
					"You are wearing to much to fit through all the vines.";
					return(nil);
					}
		}
;

greenlock:decoration, openable
	isopen = nil
	isListed = nil
	hno = true
	sdesc = "sealed green door"
	ldesc = "The green door, which at one time must have been an airlock, is sealed shut with a hard, amber 
		sap."
	noun = 'airlock' 'door'
	adjective = 'sealed' 'green'
	location = gairlock
	doOpen(actor) = {"The airlock is sealed shut with a hard, amber sap.   
			It cannot be opened.";
			self.isopen := nil;
			exit;
			}
;

sap: decoration
	hno = true
	sdesc = "amber sap"
	ldesc = "The amber sap looks like fossilized residue from the surrounding plants.  The sap must have 
		been building up over millenia because the sap is extremely hard.  All attempts to scratch or remove the 
		sap proves futile."
	noun = 'sap' 'residue'
	adjective = 'hard' 'amber'
	location = greenlock
;

brokenrobot: fixeditem
	fragile = true
	sdesc = "broken gardening robot"
	ldesc = {
			"This robot must have broken down a very long time ago to be stuck in the fossilized sap.  Most of 
			the robot has been smashed beyond repair. ";
			if(robotkey.location = brokenrobot)
				"One of the robot's free claws is grasping a thin crystalline rod that, for lack of a better word, looks 
				like a type of key.";
			}
	noun = 'robot'
	adjective = 'broken' 'gardening'
	location = gairlock
	doTake(actor) = {"The gardening robot is stuck fast in the hardened sap.  It will take more than you got to 
			get it free.";
			self.moveInto(gairlock);
		}
;

robotkey:keyItem
	fragile = true
	sdesc = "square crystal rod"
	ldesc = "The square crystal rod is thin and clear.  There are some notches at the end of the rod which give 
			you the impression that it is a key to something."
	noun = 'rod' 'key'
	adjective = 'thin' 'crystal' 'square'
	location = brokenrobot
;

// Blue Section

blueroad: plutoroom
	sdesc = "On the Blue Road"
	ldesc = "This sapphire blue road travels east away from the central tower area.  The city to the east has 
		been totally destroyed and is covered in shadowy darkness.  
		The blue road ends at this point being totally destroyed  
		to the east of here."
	east = B1
	west = eoftower
	isbroad = true
;

btower: decoration
	hno = true
	sdesc = "tower"
	ldesc = "The pale central tower stretches up from the plaza to the west to the dome high above.  The 
		tower appears completely smooth with no apparent exits or entrances."
	noun = 'tower' 'spire'
	adjective = 'central' 'white' 'chalky' 'ivory' 'pale'
	location = blueroad
;

islip: item, readable
	sdesc = "invoice slip"
	ldesc = "It is an invoice slip for the following items\b
		\tThree (3) boxes of Glowsticks\n
		\tOne (1) box of Trazstuff\n
		\tEight (8) boxes of Rubber-latex Gloves\n
		\tOne (1) set of low temperature microcircuts\b
		There is an addendum on the bottom of the invoice saying that these items were delivered 
		someplace in \"Blue Quadrant\" a few millenia ago.\b"
	noun = 'slip' 'invoice'
	adjective = 'invoice'
	location = blueroad
;

//Mazes



//Red Maze

class rmazeroom: plutoroom
	sdesc = "Amid the Ruins"
	ldesc = {
		"You are walking among the ruins of a once great city.  Paths lead away to the ";
			{
			local cnt, tot,i;
			tot := 0;
			i := 1;
			while (i<=8)
			{
			if(self.dirlist[i]) tot := tot +1;
			i := i+1;
			}
			i:=1;
			cnt := 0;
			while (i<=8)
			{
			if(self.dirlist[i])
				{
				if(cnt>0)
				{
				if(tot=2) " and ";
				else if(tot = cnt+1) ", and ";
				else ", ";
				}
				cnt:= cnt+1;
				say(['north' 'northeast' 'east' 'southeast' 'south' 'southwest' 'west' 'northwest'] [i]);
				}
				i:=i+1;
			}
		}
		". ";
		{
		if(self.towerloc = 1) "Far to the southeast, above the wreckage, you can see the white central 
			tower.  ";
		if(self.towerloc = 2) "Far to the northeast, above the wreckage, you can see the white central 
			tower. ";
		if(self.towerloc = 3) "Far to the southwest, above the wreckage, you can see the white central 
			tower. ";
		}
	}
	outside = true
	mazetravel(rm) =
		{
		if(rm)
		{
		"You wander through the vines and rubble and find yourself...\b";
		if(rm.outside) rmazetower.moveInto(rm);
		if(rm.green) {
				gsuitcheck();
				if(not global.suitw)
					{
					jungleplants.moveInto(G7);
					setdaemon(vinecount,nil);
					return(G7);
					exit;
					}
				else
					{
					"You cannot fit through all the vines wearing the suit.";
					return(nil);
					exit;
					}
				}
		if(rm.side = 3)
				{
				local fix;
				randomize();
				fix := rand(3);
				if (fix =1) rm:=((Me.location).sidelist[1]);
				if (fix =2) rm:=((Me.location).sidelist[2]);
				if(fix = 3) rm:=((Me.location).sidelist[3]);
				}
		if(rm.side = 4)
				{
				local fix;
				randomize();
				fix := rand(4);
				if (fix =1) rm:=((Me.location).sidelist[1]);
				if (fix =2) rm:=((Me.location).sidelist[2]);
				if(fix = 3) rm:=((Me.location).sidelist[3]);
				if(fix = 4) rm:=((Me.location).sidelist[4]);
				}
		if(rm.side = 2)
				{
				local fix;
				randomize();
				fix := rand(2);
				if (fix =1) rm:=((Me.location).sidelist[1]);
				if (fix =2) rm:=((Me.location).sidelist[2]);
				}
		{
		if (rm.rt)
			{
			if(rm.rt =1) redtower1.moveInto(rm);
			if(rm.rt =2) redtower2.moveInto(rm);
			if(rm.rt = 3) redtower3.moveInto(rm);
			redroadtrav(rm);
			}
		if (rm.yt)
			{
			if(rm.yt = 1)
				{
				yellowtower1.moveInto(rm);
				if(not rm.yel4) yellowbuildfara.moveInto(rm);
				}
			if(rm.yt =2)
				{
				yellowtower2.moveInto(rm);
				if(not rm.yel5) yellowbuildfar.moveInto(rm);
				}
			if(rm.yt = 3)
				{
				yellowtower3.moveInto(rm);
				yellowbuildfar.moveInto(rm);
				}
			yroad.moveInto(rm);
			}
			}
		return(rm);
		}
		else
			{
			"You cannot go that way.";
			return(nil);
			}
	}
	north = (self.mazetravel(self.dirlist[1]))
	ne = (self.mazetravel(self.dirlist[2]))
	east = (self.mazetravel(self.dirlist[3]))
	se = (self.mazetravel(self.dirlist[4]))
	south = (self.mazetravel(self.dirlist[5]))
	sw = (self.mazetravel(self.dirlist[6]))
	west = (self.mazetravel(self.dirlist[7]))
	nw = (self.mazetravel(self.dirlist[8]))
	in = (self.mazetravel(nil))
	out = (self.mazetravel(nil))
	up = (self.mazetravel(nil))
	down = (self.mazetravel(nil))
;
		
side2:room
	sdesc = "side2"
	down = pluto
	side = 2
;

side3:room					// Technical maze rooms, down is an emergency exit
	sdesc = "side3"
	down = pluto
	side = 3
;

side4:room
	sdesc = "side4"
	down = pluto
	side = 4
;

rmazetower: decoration
	sdesc = "tower"
	ldesc= { "Over the rubble, far to the ";
		if((Me.location).towerloc = 1) "southeast ";
		if((Me.location).towerloc = 2) "northeast ";
		if((Me.location).towerloc = 3) "southwest ";
		"of here, you can see the pale central tower.";
		}
	noun = 'tower' 'spire'
	adjective = 'central' 'white' 'chalky' 'ivory' 'pale'
;

R1:rmazeroom
	towerloc = 1
	dirlist = [R1 nil R1 nil nil R2 nil R3]
;

R2:rmazeroom
	towerloc = 1
	dirlist = [R1 side3 nil R9 nil Y4 nil R4]
	sidelist = [redroad4 redroad5 redroad6]	
;
	
R3:rmazeroom
	towerloc = 1
	dirlist = [R8 R3 R8 R1 R1 nil R4 nil]
;

R4: rmazeroom
	towerloc = 1
	dirlist = [nil nil R3 nil R2 nil R5 nil]
;

R5:rmazeroom
	towerloc = 1
	ldesc = "You are walking among the ruins of a once great city.  Paths lead away to the north, 
		southeast, and northwest.  To the west is an entrance to a building that looks to be intact.  Far to 
		the southeast, above the wreckage, you can see the white central tower.  "
	dirlist = [R4 nil nil R2 nil nil rbuild R5]
;

rbuild: plutoroom
	sdesc = "In a Ruined Building"
	ldesc = "The structure around you is in an advanced state of disrepair.  There is no ceiling above you 
		and the floor is a covered in a large amount of rubble.  The only exit is back out to the east."
	east = R5
;

brubble:fixeditem
	hno = true
	sdesc = "pile of rubble"
	ldesc = "The rubble must have been the remains of the upper levels of the building. By the position of the 
		entrance to the building you can tell the rubble is at least ten feet deep."
	noun = 'rubble'
	adjective = 'pile'
	preposition = 'of'
	searched = nil
	location = rbuild
	verDoSearch(actor)={}
	doSearch(actor) = {
		if(not self.searched)
		{
		"You poke through the rubble and find a small silver wand, which you take.";
		self.searched := true;
		gadget.moveInto(Me);
		}
		else
		"You poke around through the rubble for a few moments but find nothing of value.";
		}
	verDoMove(actor) = {}
	doMove(actor) = {
		"Even with heavy machinery you couldn't move all the rubble that is in here.";
		}
	verDoClear(actor) = {}
	doClear(actor) = {
		"Even with heavy machinery you couldn't move all the rubble that is in here.";
		}
;

R6: rmazeroom
	towerloc = 3
	dirlist = [nil R7 R7 R11 side3 R6 R6 nil]
	sidelist = [redroad4 redroad5 redroad6]
;

R7:rmazeroom
	towerloc = 3
	dirlist = [R7 nil B6 R11 R6 R6 nil R10]
;

R8:rmazeroom
	towerloc = 1
	dirlist = [nil side3 nil nil nil R3 R3 nil]
	sidelist = [redroad1 redroad2 redroad3]
;

R9:rmazeroom
	towerloc = 1
	dirlist = [R2 nil nil noftower nil nil Y9 nil]
;

R10:rmazeroom
	towerloc = 3
	dirlist = [R10 R10 nil R7 side3 nil nil nil]
	sidelist = [redroad1 redroad2 redroad3]
;

R11:rmazeroom
	towerloc = 3
	dirlist = [R6 R7 R12 B3 nil R12 nil nil]
;

R12:rmazeroom
	towerloc = 3
	dirlist = [R11 R11 R12 nil blueroad R12 nil side3]
	sidelist = [redroad7 redroad8 redroad9]
;

//Yellow maze

Y1:rmazeroom
	towerloc = 1
	dirlist = [nil Y2 Y2 nil nil side4 nil Y1]
	sidelist = [yellowroad1 yellowroad2 yellowroad3 yellowroad4]
;

Y2:rmazeroom
	towerloc = 1
	dirlist = [Y2 R5 Y3 nil Y3 Y1 Y1 nil]
;

Y3:rmazeroom
	towerloc = 1
	dirlist = [Y2 nil Y4 Y3 nil nil Y2 nil]
;

Y4:rmazeroom
	towerloc = 1
	dirlist = [nil R2 nil Y5 Y9 Y4 Y3 nil]
;

Y5:rmazeroom
	towerloc = 1
	dirlist = [nil nil woftower side2 nil Y5 nil Y4]
	sidelist = [yellowroad8 yellowroad9]
;

Y6:rmazeroom
	towerloc = 2
	dirlist = [nil Y6 Y7 Y7 Y8 nil side4 nil]
	sidelist = [yellowroad1 yellowroad2 yellowroad3 yellowroad4]
;

Y7:rmazeroom
	towerloc = 2
	dirlist = [Y6 nil nil Y10 Y8 Y7 nil Y6]
;

Y8:rmazeroom
	towerloc = 2
	ldesc = "You are walking among the ruins of a once great city.  Paths lead away to the north, northeast, 
		east, south and southwest.  The path to the south leads under a large, dark
		 canopy of greenery.  In is probably 
		not a good idea to go there without some light."
	dirlist = [Y6 Y8 Y7 nil G7 ychamber nil nil]
;

Y9:rmazeroom
	towerloc = 1
	dirlist = [Y4 R9 nil nil nil nil side3 nil]
	sidelist = [yellowroad5 yellowroad6 yellowroad7]
;

Y10:rmazeroom
	towerloc = 2
	dirlist = [nil side2 woftower nil Y10 Y7 Y10 nil]
	sidelist = [yellowroad8 yellowroad9]
;

ychamber:plutoroom
	sdesc = "Ruined Lab"
	ldesc = "This building looks like it once was some kind of scientific lab.  There are various smashed 
		machines scattered throughout the room.  The only exit is to the north."
	hereonce = nil
	ych = true
	north = Y8
;

labstuff: fixeditem
	sdesc = "scientific equipment"
	lookcount = 0
	ldesc = {
		if(self.lookcount = 0) "You examine some of the equipment.  It is all smashed beyond repair.";
		if(self.lookcount = 1) "Searching the equipment further, you find more smashed machinery.";
		if(self.lookcount=2) {"You search deeper into the mess of broken machinery and find 
			a cubical machine that seems to be in working order near the back of the room.";
			cubemach.moveInto(ychamber);
			incscore(10);			//10 for finding cube machine
			}
		if(self.lookcount > 2) 
			{
			if(cubemach.location = ychamber)
				"Most of the equipment here looks smashed beyond repair.  Only a cubical machine near the 
				back of the lab seems to be in working order.";
			else
				"All of the equipment is smashed beyond repair.";
			}
		self.lookcount := self.lookcount+1;
		}
	verDoSearch(actor)={}
	doSearch(actor) ={
		if(self.lookcount = 0) "You examine some of the equipment.  It is all smashed beyond repair.";
		if(self.lookcount = 1) "Searching the equipment further, you find more smashed machinery.";
		if(self.lookcount=2) {"You search deeper into the mess of broken machinery and find 
			a cubical machine that seems to be in working order near the back of the room.";
			cubemach.moveInto(ychamber);
			incscore(10);			//10 for finding cube machine
			}
		if(self.lookcount > 2) 
			{
			if(cubemach.location = ychamber)
				"Most of the equipment here looks smashed beyond repair.  Only a cubical machine near the 
				back of the lab seems to be in working order.";
			else
				"All of the equipment is smashed beyond repair.";
			}
		self.lookcount := self.lookcount+1;
		}
	noun = 'equipment' 'machine'
	plural = 'machines'
	adjective = 'lab' 'scientific'
	location = ychamber
;

cubemach:fixeditem, container
	fragile = true
	vol = true
	sdesc = "cubical machine"
	ldesc = "This machine is a black cube over size feet a side.  The only feature on the cube is a 
		spherical cavity on one side."
	noun = 'machine'
	adjective = 'cubical' 'black'
	location = nil
	ioPutIn(actor, dobj) = {
		if(dobj = contsphere)
			{
			"The <<contsphere.sdesc>> fits perfectly into the cavity.  As the sphere come to rest in the cube, the
			entire cube starts to distort.  Slowly, the large cubical machine shrinks until it is only a cube with sides 
			no large than an inch. ";
			cubemach.moveInto(dvoid);
		    contsphere.moveInto(dvoid);
			chrcry.moveInto(ychamber);
			}
		else
			"A strong force prevents the <<dobj.sdesc>> from entering the cavity.";
	}
;

spherecav: fixeditem, container
	hno = true
	sdesc = "spherical cavity"
	ldesc = "The spherical cavity is a foot in diameter."
	noun = 'cavity'
	adjective = 'spherical'
	location = cubemach
	ioPutIn(actor, dobj) = {
		if(dobj = contsphere)
			{
			"The <<contsphere.sdesc>> fits perfectly into the cavity.  As the sphere come to rest in the cube, the
			entire cube starts to distort.  Slowly, the large cubical machine shrinks until it is only a cube with sides 
			no large than an inch. ";
			cubemach.moveInto(dvoid);
		    contsphere.moveInto(dvoid);
			chrcry.moveInto(ychamber);
			}
		else
			"A strong force prevents the <<dobj.sdesc>> from entering the cavity.";
	}
;


// Green Maze
	

class gmazeroom: jungleroom
	sdesc = "Deep in the Jungle"
	ldesc = {
		"You are walking among a jungle a greenery.  Plants cover the ruins of city around you and 
		block out all light from above.  Paths lead through the brambles to the ";
		{
			local cnt, tot,i;
			tot := 0;
			i := 1;
			while (i<=8)
			{
			if(self.dirlist[i]) tot := tot +1;
			i := i+1;
			}
			i:=1;
			cnt := 0;
			while (i<=8)
			{
			if(self.dirlist[i])
				{
				if(cnt>0)
				{
				if(tot=2) " and ";
				else if(cnt+1 = tot) ", and ";
				else ", ";
				}
				cnt:= cnt+1;
				say(['north' 'northeast' 'east' 'southeast' 'south' 'southwest' 'west' 'northwest'] [i]);
				}
				i:=i+1;
			}
		}
		". ";
	}
	mazetravel(rm) =
		{
		if(self.islit)
		{
		if(rm)
		{
		gsuitcheck();
		if (global.suitw) {"You are wearing to much to fit through all the vines."; return(nil); exit;}
		if(rm.side= 3)
				{
				local fix;
				randomize();
				fix := rand(3);
				if (fix =1) rm := ((Me.location).sidelist[1]);
				if (fix =2) rm := ((Me.location).sidelist[2]);
				if(fix = 3) rm := ((Me.location).sidelist[3]);
				}
		if(not rm.jungle)
			{
			"You wander confused through the jungle of plant life and stumble upon a path out 
			of the canopy.\b";
			remdaemon(vinecount,nil);
			if(rm.gt) {greentower.moveInto(rm); groad.moveInto(rm);}
			}
	else
		{"You wander through the dense greenery and find yourself...\b";
		jungleplants.moveInto(rm);}
		return(rm);
		exit;
		}
		else
			{
			"You cannot go  that way.";
			return(nil);
			}
		}
	else
		{
		"You stumble around the jungle in the dark.  As you walk you feel something slide over your feet and 
			across your back.  Panicked, you start to run but you tip over a piece of rubble and fall expecting 
			to feel the hard ground any moment.  To your surprise something catches you and wraps itself around 
			your arm.  Whatever is holding you, it is covered in some sticky material with burns your skin.  As 
			you struggle you feel more things grab hold of you and start to pull.  You last words are a scream as 
			you're arms and legs are pulled out of their sockets.";
		die();
		}
	}
	north = (self.mazetravel(self.dirlist[1]))
	ne = (self.mazetravel(self.dirlist[2]))
	east = (self.mazetravel(self.dirlist[3]))
	se = (self.mazetravel(self.dirlist[4]))
	south = (self.mazetravel(self.dirlist[5]))
	sw = (self.mazetravel(self.dirlist[6]))
	west = (self.mazetravel(self.dirlist[7]))
	nw = (self.mazetravel(self.dirlist[8]))
	in = (self.mazetravel(nil))
	out = (self.mazetravel(nil))
	up = (self.mazetravel(nil))
	down = (self.mazetravel(nil))
;	

G1:gmazeroom
	dirlist = [G1 nil nil side3 G2 G2 nil nil]
	sidelist = [greenroad10 greenroad9 greenroad8]
;

G2:gmazeroom
	dirlist = [G1 nil G2 G2 G3 G3 nil G1]
;

G3:gmazeroom
	dirlist = [G2 nil G2 G3 nil G4 nil G3]
;

G4:gmazeroom
	dirlist = [G3 G5 G6 side3 G6 G7 nil nil]
	sidelist = [greenroad4 greenroad3 greenroad2]
;

G5:gmazeroom
	dirlist = [G4 side3 nil G5 nil G5 nil nil]
	sidelist = [greenroad7 greenroad6 greenroad5]
;

G6:gmazeroom
	dirlist = [G4 nil nil kitchen nil G7 G4 G6]
;

G7:gmazeroom
	dirlist = [G4 G6 G15 nil G15 G7 Y8 nil]
	green = true
;

G8:gmazeroom
	dirlist = [G8 G9 G9 G10 G10 side3 nil nil]
	sidelist = [greenroad10 greenroad9 greenroad8]
;

G9:gmazeroom
	dirlist = [G10 B4 nil nil nil nil G8 nil]
;

G10:gmazeroom
	dirlist = [nil G10 G9 G13 G11 nil G8 nil]
;

G11:gmazeroom
	dirlist = [G10 G11 G12 G13 G14 G16 nil nil]
;

G12:gmazeroom
	dirlist = [G11 G12 nil G12 G13 nil nil nil]
;

G13:gmazeroom
	dirlist = [G12 nil G10 G13 nil G14 G14 G11]
;

G14:gmazeroom
	dirlist = [G11 G14 G13 G14 G13 nil greenroad1 side3]
	sidelist = [greenroad4 greenroad3 greenroad2]
;

G15:gmazeroom
	dirlist = [G7 nil nil nil nil G7 nil nil]
;

G16:gmazeroom
	dirlist = [side3 G11 G16 nil nil nil nil nil]
	sidelist = [greenroad7 greenroad6 greenroad5]
;

kitchen:darkroom
	sdesc = "Small Building"
	ldesc = "This building looks like it should have collapsed a long time ago.  Upon examination 
		you see that only thing holding up the building is the vines that cover the walls and ceiling.  The only 
		exit is back out to the northwest."
	nw = G6
;
 
box:  openable
	fragile = true
	sdesc = "grey container"
	ldesc = "The container is thin and rectangular.  On the cover, in faded letters, are the words 
		\"SURVIVAL KIT.\""
	noun = 'box' 'container' 'kit'
	adjective = 'grey' 'survival'
	location = kitchen
	isopen = nil
;

rgoop:fooditem
	sdesc = "hunk of red goop."
	ldesc = "It looks like a hunk of red goop.  It has an odor reminiscent of cherries."
	noun = 'goop'
	adjective = 'red' 'hunk'
	preposition = 'of'
	location = box
;

mgoop: fooditem
	sdesc = "splotch of mauve goop"
	ldesc = "It looks like splotch of mauve goop.  It has an odor reminiscent of cinnamon."
	noun = 'goop'
	adjective = 'mauve' 'splotch' 
	preposition = 'of'
	location = box
;

bgoop:fooditem
	sdesc = "smattering of blue goop"
	ldesc = "It looks like a smattering of blue goop.  It has and odor reminiscent of muffins."
	noun = 'goop'
	adjective = 'blue' 'smattering'
	preposition = 'of'
	location = box
;

cgoop:fooditem
	sdesc = "dollop of chartreuse goop"
	ldesc = "It looks like <<self.adesc>>.  It has an odor reminiscent of apples."
	noun = 'goop'
	adjective = 'chartreuse' 'dollop'
	preposition = 'of'
	location = box
;

// Blue Maze


stickloc: function
	{
	local   j;
	j := 1;
	while(j <= 8)
		{
		if(glowstick.location = (Me.location).dirlist[j])
			{
			"There is a eerie green glow coming from the ";
			say(['north' 'northeast' 'east' 'southeast' 'south' 'southwest' 'west' 'northwest'] [j]);
			".";
			}
		j := j+1;
		}
	}
;
		
class bmazeroom: darkroom
	plroom = true
	towerloc = 4
	isbmaze = true
	sdesc = "Lost in the Wreckage"
	ldesc = {
		"You are walking among a maze of ruins that was once the eastern part of the city.  The dome lights 
		above have long since ceased to function.  Above the wreckage, far to the west, you can see the 
		central tower. Paths lead through the rubble to the ";
			{
			local ct, tota, j;
			tota := 0;
			j := 1;
			while (j<=8)
			{
			if(self.dirlist[j]) tota := tota +1;
			j := j+1;
			}
			j :=1;
			ct := 0;
			while (j<=8)
			{
			if(self.dirlist[j])
				{
				if(ct>0)
				{
				if(tota = 2) " and ";
				else if(ct+1 = tota) ", and ";
				else ", ";
				}
				ct := ct+1;
				say(['north' 'northeast' 'east' 'southeast' 'south' 'southwest' 'west' 'northwest'] [j]);
				}
				j:=j+1;
			}
		}
		".  ";
		stickloc();
		if(Me.location = B21) "Just to the east there is a entrance to a dark, squat building.";
		}
	mazetravel(rm) =
		{
		if(self.islit)
			{
			if(rm)
				{
					if(gadget.location = Me)
						{
						if(not rm.isbroad)
						{
						"You walk a crooked path through the wreckage.  When you stop the wand starts to pull 
						you towards the ";
						if(rm.muse) "north.\b";
						else "<<rm.dirlist[9]>>.\b";
						}
						else
							"You walk a crooked path through the wreckage and find yourself...\b";
						}
					else {
						if(rm.muse)
							{
							"You step over the rubble and enter the dark building.\b";
							}
						else
						"You walk a crooked path through the wreckage and find yourself...\b";
						}
					if(rm.muse)
						{
						if(not bbuild.hereonce)
							{incscore(20);			//20 for reaching museum
							bbuild.hereonce := true;}
						}
					return(rm);
					}
				else {"You cannot go that way."; return(nil);}
				}
			else
				{
				"You stumble aimlessly through the dark trying to find your way through the rubble.  Eventually 
				you find your way back to a lit section of the city.\b";
					{
					local set;
					randomize();
					set := rand(10);
					if (set=1) return(blueroad);
					if(set=2) return(eoftower);
					if(set=3) return(noftower);
					if(set=4) return(redroad10);
					if(set=5) return(greenroad10);
					if(set=6) return(R12);
					if(set =7) return(R7);
					if(set=8) return(softower);
					if(set=9) return(redroad3);
					if(set=10) return(R6);
					exit;
					}
				}
			}
	north = (self.mazetravel(self.dirlist[1]))
	ne = (self.mazetravel(self.dirlist[2]))
	east = (self.mazetravel(self.dirlist[3]))
	se = (self.mazetravel(self.dirlist[4]))
	south = (self.mazetravel(self.dirlist[5]))
	sw = (self.mazetravel(self.dirlist[6]))
	west = (self.mazetravel(self.dirlist[7]))
	nw = (self.mazetravel(self.dirlist[8]))
	in = (self.mazetravel(nil))
	out = (self.mazetravel(nil))
	up = (self.mazetravel(nil))
	down = (self.mazetravel(nil))
;	
	

B1:bmazeroom
	dirlist = [B1 B2 B2 B4 nil nil blueroad nil 'east']
;

B2: bmazeroom
	dirlist = [B3 B7 B8 nil B1 B1 nil B2 'east' ]
;

B3: bmazeroom
	dirlist = [B3 nil B5 nil B4 nil B2 nil 'south' ]
;

B4: bmazeroom
	dirlist = [B3 B5 B9 nil B9 B1 B2 nil 'east']
;

B5: bmazeroom
	dirlist = [B6 B6 B6 nil B4 nil B3 nil 'south']
;

B6: bmazeroom
	dirlist = [nil nil B7 nil B5 B5 B5 nil 'east' ]
;

B7: bmazeroom
	dirlist = [B6 B10 B10 nil B8 B7 B2 nil 'south' ]
;

B8: bmazeroom
	dirlist = [B7 B11 B11 nil B12 B9 nil B2 'east' ]
;

B9: bmazeroom
	dirlist = [B8 nil B9 B14 B4 B9 B4 nil 'north' ]
;

B10: bmazeroom
	dirlist = [B10 nil B13 B14 B7 B10 B7 nil 'east' ]
;

B11: bmazeroom
	dirlist = [B8 B13 nil nil nil B12 B8 nil 'northeast' ]
;

B12: bmazeroom
	dirlist = [nil nil nil nil deadend nil B8 nil 'west' ]
;

B13: bmazeroom
	dirlist = [B10 nil nil nil B14 B11 nil nil 'south']
;

B14: bmazeroom
	dirlist = [B10 B17 B17 B16 B9 B12 B13 B14 'southeast']
;

B15: bmazeroom
	dirlist = [B16 nil nil nil B1 nil deadend nil 'north' ]
;

B16: bmazeroom
	dirlist = [B17 B18 nil B16 nil nil B15 B14 'northeast' ]
;

B17: bmazeroom
	dirlist = [nil B14 nil B16 B14 B17 nil nil 'south' ]
;

B18: bmazeroom
	dirlist = [B21 nil nil nil nil  nil B17 B20 'north' ]
;

B19: bmazeroom
	dirlist = [nil B19 nil nil nil B20 B20 nil 'southwest']
;

B20: bmazeroom
	dirlist = [B19 B19 B21 nil B18 nil B20 nil 'east']
;

B21: bmazeroom
	dirlist = [B21 nil bbuild nil B18 nil B20 nil 'east']
;

sqbuild:decoration
	sdesc = "squat building"
	ldesc = "The squat building is about the size of a large ballroom and is darkly colored.  There 
			is an entrance into it through the rubble to the east."
	location = B21
	noun = 'building'
	adjective = 'squat' 'dark'
;

deadend: bmazeroom
	sdesc = "Dead End"
	ldesc = {
					"You have reached a dead end.  The only exit is to the north.";
				}
	dirlist = [B12 nil nil nil nil nil nil nil 'north']
;

//  MUSEUM

bbuild: darkroom
	muse = true
	isbmaze = true
	hereonce = nil
	sdesc = "Museum"
	ldesc = {
				"From the number of broken artifacts and pieces of artwork you deduce that this building 
					must have once been some sort of museum.  There are many broken white pedestals 
					and shattered plaques scattered about the room.  One pedestal is still standing in the far
					corner of the room.";
				if (length(pedestal.contents) <> 0)
					{
						" On the pedestal";
						{
					if (secbut.active)
						", surrounded by some sort of bluish halo, ";
						}
					" is <<listcont(pedestal)>>.";
					}
				else
					{
					if (secbut.active)
						" The pedestal is surrounded by some sort of bluish halo. ";
					}
				" Exits from the museum lie to the west and down a stairway
					to the southeast.  To the north is a metal door which is currently <<modoor.isopen ? 
				"open.": "closed.">>";
				}
	north = {
					if (self.islit) return (modoor);
					else
						{
						"Without a light source you stumble around blindly in the darkness.
						Normally this wouldn't be a problem, however, the floor is just cluttered enough and
						you are just disoriented enough that you trip over, what you assume to be, one of
						the broken pillars.  While trying to regain your balance you manage to fall down 
						the steps to the basement and break you neck.";
						die();
						}
				}
	down = {
					if (self.islit) return (mucont);
					else
						{
						"Without a light source you stumble around blindly in the darkness.
						Normally this wouldn't be a problem, however, the floor is just cluttered enough and
						you are just disoriented enough that you trip over, what you assume to be, one of
						the broken pillars. While trying to regain your balance tumble down the 
						steps into the basement and break you neck.";
						die();
						}
				}
	se = {
					if (self.islit) return (mucont);
					else
						{
						"Without a light source you stumble around blindly in the darkness.
						Normally this wouldn't be a problem, however, the floor is just cluttered enough and
						you are just disoriented enough that you trip over, what you assume to be, one of
						the broken pillars. While trying to regain your balance you manage to fall down the 
						steps to the basement and break you neck.";
						die();
						}
				}
	west = {
					if (self.islit) return (B21);
					else
						{
						"With some difficulty you find your way to the door and outside.  You wander around
							in the dark a while before you stumble across a lighted area of the city.\n";
						return (blueroad);
						}
				}
;

pedestal: fixeditem, qsurface, readable
	hmol = true
	sdesc = "white pedestal"
	ldesc = "The pedestal is white, about two feet tall and is a foot and a half in diameter. 
					There is a plaque on it that reads\b
					<<plaque.ldesc>>"
	noun = 'pedestal'
	adjective = 'white' 'wide'
	location = bbuild
	readdesc = { "<<plaque.ldesc>>";}
;

plaque: fixeditem, readable
	hmol = true
	sdesc = "small plaque"
	ldesc = "\t\t\tWANKLE ROTARY ENGINE	\b
				  \t\t\t\tc. 2220 AD\b"
	noun = 'plaque'
	adjective = 'small'
	location = pedestal
;



halo: decoration
	sdesc = "blue halo"
	ldesc =  {
					if (secbut.active)
						{
						if (itemcnt( pedestal.contents ))
							{
								"The blue halo emanates from the ceiling the pedestal and completely covers everything
									on the pedestal;.";
							}
						else
							"The blue halo emanates from the ceiling above and completely encloses the top
									of the pedestal.";
						}
					else
						"I don't see what you are talking about.";
					}
	noun = 'halo'
	adjective = 'blue'
	location = bbuild
					
;

mucont: darkroom
	sdesc = "Basement"
	ldesc = "You are in the basement of the museum.  On the far wall
					there is a single red button. The only exit from here is back up a wet and slippery
					 stairway behind you."
	up = {
			if (self.islit) return (bbuild);
			else
				{
					"You  grope around trying to find the stairway in the inky blackness.  With some difficulty
						you manage to find it and start climbing up the slippery steps. 
						 At the fourth step you slip, loose your footing and fall backwards
						down the steps, breaking you neck.";
					die();
				}
			}
;

secbut: buttonitem
	hmol = true
	active = true
	pushedonce = nil
	sdesc = "red button"
	ldesc = "It looks like and ordinary red button. "		
	adjective = 'red'
	location = mucont
	doPush(actor) = {
									{
									if (self.active)
									{
									"Click.";
									self.active := nil;
										if (not self.pushedonce)
											{
												incscore(5);						// 5 for deactivating halo
												self.pushedonce := true;
											}
									}
									else
									{
									"Click.";
									self.active := true;
									}
								}
							}
;

modoor: lockableDoorway
	hmol = true
	sdesc = "metal door"
	ldesc = "The door is more like a recessed panel than a proper door.  
		There is a small hole next to the door which 
		looks like a keyhole.  The door is currently <<self.isopen ? "open.": "closed.">>"
	mykey = robotkey
	noun = 'door' 'panel'
	adjective = 'metal' 'recessed'
	otherside = midoor
	location = bbuild
	doordest = {
		if(tproom.honce) return(tproom);
		else
			{
			incscore(5);		// 5 for reaching model room
			tproom.honce := true;
			return(tproom);
			}
		}
;

mkeyhole:fixeditem, qcontainer
	sdesc = "small hole"
	ldesc = "The small is square shaped."
	noun = 'hole'
	adjective = 'square' 'small'
	location = modoor
	ioPutIn(actor,dobj) = {
		if(dobj = robotkey) 
			{"You stick the crystal rod into the hole and with a resounding \"click\" the door unlocks. 
				You take the rod from the hole and pocket it.";
			modoor.islocked := nil;
			robotkey.moveInto(Me);
			}
		else
			{"The <<dobj.sdesc>> doesn't fit in the small hole.";
				dobj.moveInto(Me);
			}
		}
;

midoor:doorway
	hmol = true
	sdesc = "metal door"
	ldesc = "The door is more like a recessed panel than a proper door.  The door is currently 
		<<self.isopen ? "open.": "closed.">>"
	otherside = modoor
	location = tproom
	noun = 'door' 'panel'
	adjective = 'recessed' 'metal'
	doordest = bbuild
;

tproom: darkroom
	sdesc = "Model Room"
	ldesc ={
		 "This well lit, but cluttered, room contains a large model of the surrounding city.  By your feet
					is inscribed\b
					\ \ \ \ \ \ \ DOME ZETA
					\ \ \ \ \ PLUTO COLONY
					\ \ \ \ \ \ \ c. 10,234 SK\b
				The only exit is to the south through a metal door.";
				self.seen := true;
			}
	seen = nil
	honce = nil
	south = 
		{
		if (self.islit) return (midoor);
		else
			{
			"You stumble in the darkness trying to find the exit.  In your search you manage to trip over
				something.  A thrusting pain assaults your chest when you fall.  As you slip into unconsciousness you
				realize that you must have impaled yourself on";
			if(self.seen) " the central tower of the model. ";
			else "something.";
			die();
			}
		}
;

model: fixeditem
	hmol = true
	sdesc = "model of the city"
	ldesc = "Looking at this model you can see that the city was once indeed marvelous. The tall
					central tower stands over the city like a watchful guardian.
					You can't help feel saddened by the loss of, what must have been, a wondrous place
						to live."
	noun = 'model' 'city'
	adjective = 'large'
	location = tproom
;

mdtower: fixeditem
	hmol = true
	sdesc = "model of the central tower"
	ldesc = {"Examining the central tower you see that toward the top of the
					tower there is a small white button."; whtbut.moveInto(mdtower);}
	noun = 'tower'
	adjective = 'central'
	location = model
;

whtbut: buttonitem
	hmol = true
	sdesc = "white button"
	ldesc = "It looks like a plain white button"
	adjective = 'white' 'tower'
	location = nil
	pushed = nil
	doPush(actor) = {
								"You press the button and the world turns upside down.  A sinking feeling
									assaults your stomach and you black out.\b\b
									You awaken to find yourself someplace else.\b";
								if (not self.pushed)
									{
									incscore(10);		// 10 for getting to tower
									self.pushed := true;
									}
								Me.travelTo(tower);
								}
;


// The Tower

tower: plutoroom
	istower = true
	dopen = nil
	sdesc = "In the Tower"
	ldesc = {
				"From you vantage point you surmise you must in the central tower.  You
					can see the entire city below you through the walls.  Yes, through the walls.
					In the center of the room there is a multicolored circular table. ";
				if (self.dopen)
					"There is one exit leading down from here.";
				else
					"You don't see any exits.";
					}
	down = {
					if (self.dopen)
							return (progroom);
					else
						return(nil);
					}
					
;

walls: decoration
	hno = true
	sdesc = "walls"
	ldesc = "The walls must be made of some material that is only transparent from the inside.
					Definitely strange."
	noun = 'walls'
	location = tower
;

tcity: decoration
	sdesc = "city"
	ldesc = {" From your vantage point you can see the entire city far, far, far below you.  The four main 
				roads radiate away from the
				the plaza below in each of the cardinal directions like the spokes of a wheel.
				\n The northern (red) section of the
				city is mostly a ruin.  Far, far to the north you can see the faint glow of the cylinder.
				\n The western (yellow) section of the city is in fairly good condition.  Halfway
				along the road two tall buildings flank the street.\n
				 The southern (green) section is completely covered with a canopy of dense
				vegetation.\n
				 The eastern (blue) section of the city is covered in shadows, the only light being spill over from
				the other sections of the city.   Far to the east you can see the museum. ";
				if (glowstick.location = isbmaze)
				"A soft, strange green glow radiates quietly from the southern part
					of the eastern ruins.";
				}
	noun = 'city'
	location = tower
;

tcont: fixeditem, surface
	hno = true
	active = nil
	sdesc = "circular table"
	ldesc = {
				"The table is about three feet in diameter and is divided into five different colored regions.
					Red to the north, yellow to the west, green to the south, blue to the east and white in the
					center. Each region has a small pad of the like color on it. ";
					{
					if (self.active)
					" Every region except the central one has a small hole in it just below the pad. ";
					}
					{
					if (self.active)
						{
							local crylist, cnt, tot, i;
							crylist := [rcry ycry gcry bcry];
							i := 1;
							tot := 0;
							while (i<=4)
								{
									if ((crylist[i]).location = tcont) tot := tot +1;
									i := i +1;
								}
							if (tot <> 0)
							{
								"In the central white region of the table ";
									{
										if (tot =1 ) "is ";
										else "are ";
									}
								i := 1;
								cnt := 0;
								while (i <= 4)
									{
									{
									if (cnt >0)
										{
											if (tot = 2) " and ";
												else if (cnt +1 = tot) ", and ";
											else ", ";
										}
										cnt := cnt +1;
									"<<(crylist[i]).adesc>>";
									}
									i := i +1;
									}
								". ";
							}
						}
					}
				}
	noun = 'table'
	adjective = 'circular' 'colored' 'multi-colored'
	location = tower
;

redtpad: touchitem
	hno = true
	sdesc = "red pad"
	ldesc = "The red pad is located at the far northern edge of the table."
	noun = 'pad'
	adjective = 'red' 'northern'
	location = tcont
	doTouch(actor) = {
									if (tcont.active)
									{
									" You press the button and the world turns upside down. 
										 A sinking feeling
										assaults your stomach and you black out.\b\b
										You awaken to find yourself someplace else.\b";
									Me.travelTo(pluto);
									}
									else
										"Nothing happens.\b";
								}
;

yellowtpad: touchitem
	hno = true
	sdesc = "yellow pad"
	ldesc = "The yellow pad is located at the far western edge of the table."
	noun = 'pad'
	adjective = 'yellow' 'western'
	location = tcont
	doTouch(actor) = {
									if (tcont.active)
									{
									" You press the button and the world turns upside down. 
 									  A sinking feeling
										assaults your stomach and you black out.\b\b
										You awaken to find yourself someplace else.\b";
										Me.travelTo(yairlock);
									}
									else
										"Nothing happens.\b";
								}
;

greentpad: touchitem
	hno = true
	sdesc = "green pad"
	ldesc = "The green pad is located at the far southern edge of the table."
	noun = 'pad'
	adjective = 'green' 'southern'
	location = tcont
	doTouch(actor) = {
									if (tcont.active)
									{
									" You press the button and the world seems to turn up side down.  
									A sinking feeling
									assaults your stomach and you black out.\b\b
									You awaken to find yourself someplace else.\b";
									Me.travelTo(gairlock);
									}
									else  "Nothing happens.\b";
								}
;

bluetpad: touchitem
	hno = true
	sdesc = "blue pad"
	ldesc = "The blue pad is located at the far eastern edge of the table."
	noun = 'pad'
	adjective = 'blue' 'eastern'
	location = tcont
	doTouch(actor) = {
								if (tcont.active)
									{
									" You press the button and the world turns upside down.  A sinking feeling
									assaults your stomach and you black out.\b\b
									You awaken to find yourself someplace else.\b";
									Me.travelTo(B21);
									}
								else
									"Nothing happens.\b";
								}
;

whitetpad: touchitem
	hno = true
	sdesc = "white pad"
	ldesc = "The white pad is located in the exact center of the table."
	noun = 'pad'
	adjective = 'white' 'central' 'center'
	location = tcont
	doTouch(actor) ={
								if (not tcont.active)
									{
										"Four crystals, colored red, yellow, green and blue respectively, 
											rise out of the white region of the table.  At the same time
											a hole appears in each of the four outlying regions, each one colored to
											match the region it is in.\b";
									       rhole.moveInto(tcont);
											yhole.moveInto(tcont);
											ghole.moveInto(tcont);
											bhole.moveInto(tcont);
											rcry.moveInto(tcont);
											ycry.moveInto(tcont);
											gcry.moveInto(tcont);
											bcry.moveInto(tcont);
											tcont.active := true;
									}
								else
									"Nothing happens.\b";
								}
;

hglobal: object
	holeopen = 0
;

rhole: container, fixeditem
	sdesc = "red hole"
	noun = 'hole'
	adjective = 'red' 'northern'
	location = nil
	ioPutIn(actor, dobj) = 
		{
			if (dobj.iscrys)
				{
				if (dobj = rcry)
					{ "The hole closes silently as you drop the crystal into it. ";
						rcry.moveInto(void);
						rhole.moveInto(void);
						hglobal.holeopen :=hglobal.holeopen +1;
							if (hglobal.holeopen = 4)
								{
									" As the last crystal slides into its hole a deep voice intones\b
										REQUEST FOR CHRONOPROGRAM CRYSTAL ACCEPTED\b
										A purple cube rises up from inside the table and hovers in midair.\b";
									fchrcry.moveInto(tower);
								}
					}
				else
					{
						"You drop  <<dobj.thedesc>> into the hole and it just sits there.";
						dobj.moveInto(self);	
					}
				}
			else
				"That won't fit in the hole.";
			}
;

yhole: container, fixeditem
	sdesc = "yellow hole"
	noun = 'hole'
	adjective = 'yellow' 'western'
	location = nil
	ioPutIn(actor, dobj) = 
		{
			if (dobj.iscrys)
				{
				if (dobj = ycry)
					{ "The hole closes silently as you drop the crystal into it. ";
						ycry.moveInto(void);
						yhole.moveInto(void);
						hglobal.holeopen := hglobal.holeopen + 1;
							if (hglobal.holeopen = 4)
								{
									" As the last crystal slides into its hole a deep voice intones\b
										REQUEST FOR CHRONOPROGRAM CRYSTAL ACCEPTED\b
										A purple cube rises up from inside the table and hovers in midair.\b";
									fchrcry.moveInto(tower);
								}
					}
				else
					{
						"You drop  <<dobj.thedesc>> into the hole and it just sits there.";	
						dobj.moveInto(self);
					}
				}
			else
				"That won't fit into the hole.";
			}
;

ghole: container, fixeditem
	sdesc = "green hole"
	noun = 'hole'
	adjective = 'green' 'southern'
	location = nil
	ioPutIn(actor, dobj) = 
		{
			if (dobj.iscrys)
				{
				if (dobj = gcry) 
					{ "The hole closes silently as you drop the crystal into it. ";
						gcry.moveInto(void);
						ghole.moveInto(void);
						hglobal.holeopen := hglobal.holeopen +1;
							if (hglobal.holeopen = 4)
								{
									" As the last crystal slides into its hole a deep voice intones\b
										REQUEST FOR CHRONOPROGRAM CRYSTAL ACCEPTED\b
										A purple cube rises up from inside the table and hovers in midair.\b";
									fchrcry.moveInto(tower);
								}
					}
				else
					{
						"You drop  <<dobj.thedesc>> into the hole and it just sits there.";	
						dobj.moveInto(self);
					}
				}
			else
				"That won't fit in the hole.";
			}
;

bhole: container, fixeditem
	sdesc = "blue hole"
	noun = 'hole'
	adjective = 'blue' 'northern'
	location = nil
	ioPutIn(actor, dobj) = 
		{
			if (dobj.iscrys)
				{
				if (dobj = bcry)
					{ 
						"The hole closes silently as you drop the crystal into it. ";
						bcry.moveInto(void);
						bhole.moveInto(void);
						hglobal.holeopen := hglobal.holeopen +1;
							if (hglobal.holeopen = 4)
								{
									" As the last crystal slides into its hole a deep voice intones\b
										REQUEST FOR CHRONOPROGRAM CRYSTAL ACCEPTED\b
										A purple cube rises up from inside the table and hovers in midair.\b";
									fchrcry.moveInto(tower);
								}
					}
				else
					{
						"You drop  <<dobj.thedesc>> into the hole and it just sits there.";	
						dobj.moveInto(self);
					}
				}
			else
				"That won't fit in the hole.";
			}
;



progroom: room
	istower = true
	sdesc = "Device Room"
	ldesc = {
				"This room is located somewhere in the depths of the tower.  The only
					exit is up a stairway at this end of the room. ";
					if (device.location = progroom) "There is a very large and very strange looking
					device here.";
				}
	up = tower
;

device: fixeditem
	fragile = true
	vol = true
	sdesc = "strange device"
	ldesc = "The device looks like a large purple boulder.  Written on the device in large white letters
						is the phrase \"CHRONOPROGRAM CRYSTAL PROGRAMER\". 
					The only things on the cylinder that you comprehend are two dials, 
					a small slot and a black button next to the left dial.  The dial
					on your right is labeled \"DESTINATION\" while the one on the left is labeled
					\"TIME\". "
	noun = 'device' 'programer'
	adjective = 'strange' 'chronoprogram' 'crystal'
	location = progroom
;

rtdial: dialItem
	fragile = true
	vol = true
	maxsetting = 7
	setting = 7
	deslist = ['Pluto' 'Zoltar' 'Terra' 'Mars' 'Neptune' 'Titan' 'Neo-Trilliozaptiofilliocoozbilliarth']
	sdesc = "right dial"
	ldesc = {
        			caps(); self.thedesc; " can be turned to settings
        			numbered from 1 to << self.maxsetting >>. It's
       				currently set to << self.setting >>.   A display above the dial reads\b
					--- <<self.deslist[self.setting]>> ---\b";
   				}
	noun = 'dial'
	adjective = 'right' 'destination'
	location = device
	doTurnTo( actor, iobj ) =
    {
        if ( iobj = numObj )
        {
            if ( numObj.value < 1 or numObj.value > self.maxsetting )
            {
                "There's no such setting! ";
            }
            else if ( numObj.value <> self.setting )
            {
                self.setting := numObj.value;
                "The display now reads\b
					--- <<self.deslist[self.setting]>> ---\b";
            }
            else
            {
                "It's already set to "; say( self.setting ); "! ";
            }
        }
        else
        {
            "I don't know how to turn "; self.thedesc;
            " to that. ";
        }
    }
;

lftdial: dialItem
	fragile = true
	vol = true
	maxsetting = 205043
	setting = 75342
	sdesc = "left dial"
	ldesc = {
       				 caps(); self.thedesc; " can be turned to settings
       				 numbered from 1 to << self.maxsetting >>. It's
        			currently set to << self.setting >>. A display above the dial reads 
					--- <<self.setting>> <<blbutton.tlist[blbutton.npress]>> --- .";
    			}
	noun = 'dial'
	adjective = 'left' 'time'
	location = device
;

blbutton: buttonitem
	fragile = true
	vol = true
	npress = 1
	tlist = [ 'SK' 'TQ' 'RG' 'BC' 'AD' 'LX']
	sdesc = "black button"
	ldesc = "It is an ordinary black button."
	noun = 'button'
	adjective = 'black'
	location = device
	doPush(actor) = {
									self.npress := self.npress +1;
									if (self.npress >6) self.npress := 1;
									"The display above the left dial now reads
										\"<<lftdial.setting>> <<self.tlist[self.npress]>>\". ";
								}
;

dslot: container, fixeditem
	sdesc = "slot"
	ldesc = "The slot is one inch square."
	noun = 'slot'
	location = device
	ioPutIn (actor, dobj) =
		{
			if (dobj = chrcry or dobj = fchrcry)
					{
						"When the crystal drops into the slot and disappears into the device.  
							A white button labeled \"START\" appears 
						above the slot.";
						dobj.moveInto(tslot);
						whbutton.moveInto(device);
						exit;
					}
			if(isclass(dobj, bodyitem))
				{
				machbodydie(dobj);
				}
			{
			"That doesn't fit in the slot.";
			dobj.moveInto(Me);
			}
		}
;

tslot: room				// slot room
;

whbutton: buttonitem
	fragile = true
	vol = true
	sdesc = "white button"
	ldesc = "The button is labeled \"START\" "
	noun = 'button'
	adjective = 'white' 'start'
	location = nil
	doPush(actor) = 
		{
		if (chrcry.location = tslot)
			{
			"The device rattles and hums methodically for about a minute. When it stops a door opens up and the 
				black chronoprogram
				crystal drops at your feet.  Just as the crystal lands on the floor a horrible din 
				echoes from the device as the device dissolves away into nothing. ";
				chrcry.destset := rtdial.deslist[rtdial.setting];
				chrcry.tmset := lftdial.setting;
				chrcry.eraset := blbutton.tlist[blbutton.npress];
				chrcry.moveInto(progroom);
				device.moveInto(void);
				if((chrcry.destset = 'Terra') and (chrcry.tmset = 1995) and 
					(chrcry.eraset = 'AD'))
						{
						chrcry.good := true;
						}
				else
					chrcry.good := nil;
			}
		else
			{
			"The device rattles and hums in increasing volume for over a minute.  When it stops, a door opens up in the
				machine.  After a quick pause the purple chronoprogram crystal, vibrating with energy, drops out of the
				door and onto the floor.  The door closes and a horrible din echoes from the device as it dissolves
				away to nothing. ";
				fchrcry.lethal := true;
				device.moveInto(void);
				fchrcry.moveInto(progroom);
				}
		}
;
