/* Perdition's Flames - Introductory Boat section */
// copyright (c) 1993, 2002 by Michael J. Roberts.

// a fake object for the boat, which appears in every room on the boat
theBoat: fixeditem, floatingItem
    location =
    {
        if (isclass(Me.location, boatroom))
            return(Me.location);
        else
            return(nil);
    }
    locationOK = true
    noun = 'boat' 'yacht' 'ship'
    sdesc = "boat"
    ldesc = { Me.location.lookAround(true); }
;

class boatroom: room
;

class boatpeopleItem: fixeditem
    sdesc = "passenger"
    noun = 'people' 'person' 'passenger' 'passengers'
    verDoAskAbout(actor, iobj) = {}
    doAskAbout(actor, iobj) =
    {
        "They seem too distracted to talk to you.";
    }
    doSynonym('AskAbout') = 'TellAbout'
    verIoGiveTo(actor) = {}
    ioGiveTo(actor, dobj) = { "They ignore you.  They seem distracted."; }
    ioSynonym('GiveTo') = 'ShowTo'
;

boatpeople2: boatpeopleItem
    ldesc = "The other passengers are gradually making their
        way, a few at a time, onto the pier."
    actorAction(v, d, p, i) =
    {
        "They seem more interested in leaving for the pier than
        entering into a conversation just now.";
        exit;
    }
;

dock_the_boat: function(parm)
{
    gangway.moveInto(boatdeck);
    boatpeople2.moveInto(boatdeck);
    gangway.isopen := true;

    switch(Me.location)
    {
    case boatcontrol:
        "\b\tThe captain starts fiddling with the controls. \"We're
        there,\" he says.  Outside, you can see a pier come into
        view on the western bank; the captain guides the boat
        silently alongside the
        pier and brings it to a halt.  As the boat comes to rest against
        the pier, a gangway extends toward the boat, and
        settles on the deck.
        \n\t\"Attention, passengers,\" the captain says into a
        microphone. \"We have arrived.  You may disembark at your
        leisure.\"  You see a few passengers start to disembark.";
        break;

    case boatdeck:
        "\b\tYou see a pier suddenly come into view along the bank.
        The boat slows down and starts to maneuver toward the pier,
        and finally comes to rest alongside it.  Someone below extends a
        gangway onto the boat.";
        goto hear_announce;

    case boatmain:
        "\b\tThrough the window, you see a pier suddenly come into view
        along the bank.  The boat slows down and starts to maneuver
        toward the pier, and finally comes to rest alongside it.";
        goto hear_announce;

    case boatbar:
        "You feel the boat slow down and start maneuvering, then you
        realize the boat has come to a stop.";

    hear_announce:
        "\n\tThrough a speaker, you hear the captain's voice announce,
        \"Attention passengers.  We have arrived.  You may disembark
        at your leisure.\"  The other passengers start making their
        way out onto the pier.";
        break;
    }
}
    

gangway: fixeditem
    isopen = nil
    noun = 'gangway'
    sdesc = "gangway"
    ldesc = "It leads west onto the pier."
;

boatmain: boatroom
    sdesc = "Boat"
    ldesc = "You're in the main passenger compartment of a large luxury
        yacht.  Your seat, J-33, is a
        large, plush seat next to a window that occupies most of
        the wall.  The boat is about half-filled with
        people of various ages and races, most dressed in casual clothes.
        A stairway leads up, and another compartment lies to the south."
    up = boatdeck
    south = boatbar
;

shore1: distantItem
    noun = 'shore' 'shores' 'bank' 'banks' 'river'
    adjective = 'river'
    sdesc = "shore"
    location = boatmain
    ldesc = "You can barely make out the shores in the darkness."
;

rope: item
    sdesc = "rope"
    noun = 'rope' 'loop'
    ldesc = "It's a thick rope, about ten feet long,
        for securing boats at the pier.
        One end of the rope is tied into a loop, so it can
        be slipped over posts on the pier."
    location = pier
    verIoLassoWith(actor) = {}
    ioLassoWith(actor, dobj) = { dobj.ioThrowAt(actor, self); }
    verDoTieTo(actor, iobj) = {}
    doTieTo(actor, iobj) =
    {
        "The rope is too thick; you can't make a good knot.";
    }
    doSynonym('TieTo') = 'FastenTo' 'AttachTo'
    verIoTakeWith(actor) = {}
    ioTakeWith(actor, dobj) = { dobj.doTakeWith(actor, self); }
;

boatpeople4: boatpeopleItem
    location = pier
    ldesc = "They're wandering into the building to the north."
    actorAction(v, d, p, i) =
    {
        "They seem more intereted in heading into the building
        than talking.";
        exit;
    }
;

pierDetail: fixeditem
    sdesc = "pier"
    noun = 'pier' 'walkway' 'handrail' 'handrails' 'rails'
    location = pier
    ldesc = "There's nothing important about it."
;

pierBuilding: fixeditem
    sdesc = "building"
    noun = 'building'
    location = pier
    verDoEnter(actor) = {}
    doEnter(actor) = { actor.travelTo(building); }
    ldesc = "The building has the look of a high school
        or a post office -- that sort of simple, utilitarian style
        of a government building."
;

pierYacht: fixeditem
    noun = 'yacht' 'boat' 'ship'
    adjective = 'large' 'white' 'luxury'
    sdesc = "yacht"
    location = pier
    ldesc = "It's the boat that brought you here."
;

pier: room
    sdesc = "Pier"
    ldesc = "You're on a large, brightly-lit pier.  The pier is
        obviously quite new; it's constructed from steel, and the
        walkway has a rubbery surface and attractive wooden handrails
        to make it safer.  The large white yacht which brought you
        here is docked alongside; a gangway leads east onto the boat's
        deck.  To the north lies the entrance to a large one-story
        brick building.  The building has the look of a high school
        or a post office -- that sort of simple, utilitarian style
        of a government building."
    east = boatdeck
    north = building
    enterRoom(actor) =
    {
        inherited.enterRoom(actor);
        awardPoints(13, self);
    }
;

gangway2: fixeditem
    sdesc = "gangway"
    ldesc = "It leads east onto the boat."
    noun = 'gangway'
    location = pier
;

buildingLights: decoration
    sdesc = "light"
    noun = 'light' 'lights'
    adjective = 'fluorescent' 'bright'
    location = building
;

building: room
    sdesc = "Briefing Room"
    south = pier
    north = courtyard
    ldesc = "This is a large room with a high ceiling, brightly
        illuminated with fluorescent lights.  Most of your fellow
        passengers are here, sitting in folding chairs facing a
        podium; many empty chairs are available.  An exit leads
        to the south, and another passage leads north."
;

boatpeople3: boatpeopleItem
    location = building
    ldesc =
    {
        if (lecturer.location = building)
            "The other passengers are listening attentively to
            the lecturer.";
        else
            "The other passengers are straggling in, taking seats.";
    }
    actorAction(v, d, p, i) =
    {
        "They don't seem interested in talking.";
        exit;
    }
;

lecturer: Actor
    isHer = true
    noun = 'woman'
    sdesc = "woman"
    ldesc = "She's a middle-aged woman, with light brown hair and
        large round glasses, dressed in a dark business suit.  She's
        busy fielding questions from your fellow passengers."
    question_num = 0
    show_question(num) =
    {
    try_again:
        switch(num)
        {
        case 1:
            "Is this heaven or hell?";
            break;
        case 2:
            "You know what they say -- if you have to ask --\" she chuckles.
            \"It is technically hell, although that's such a loaded word
            that we don't like to use it.  Most ideas people have about
            hell are very outdated.
            Ever since the deregulation of the afterlife industry,
            we've had to compete with Heaven for eternal souls --
            because you're free to switch to Heaven at any time.
            So, we've been modernizing!
            There really isn't much eternal torment these days, for example.
            And, thanks to the Environmental Clean-up Superfund,
            we have the brimstone problem mostly under control at this
            point.";
            break;

        case 3:
            "Can I go back to earth as a ghost and haunt people?";
            break;
        case 4:
            "No, unfortunately not.  However, our top scientists are working
            on this problem, and the latest reports indicate that it may
            be possible in the near future.  Those of you with scientific
            backgrounds, in particular those of you who went to Caltech and
            really understand what makes a good prank, may want to look into
            joining the project.";
            break;

        case 5:
            "I was wondering, where is the famous 'All hope abandon, ye
            who enter here' sign?  I want to get some pictures with it.";
            break;
        case 6:
            "Actually, the sign said 'Lasciate ogni speranza,
            voi ch'entrate,'
            and I'm afraid it's been taken down.  People found it too
            depressing. But there are several very nice vista points that
            you can find in the tour book.";
            break;

        case 7:
            "Which circle of hell are we doomed to?";
            break;
        case 8:
            "We abolished the circle system shortly after the middle ages
            after the 'separate and unequal' principle was ruled
            illegal.  You're free to go wherever you'd like -- even up
            to Heaven.";
            break;

        case 9:
            "Why did I end up here?  What did I do wrong?";
            break;
        case 10:
            "Really, you must shed your outdated notions of hell.
            You don't have to do anything wrong to end up here.  New
            souls are randomly assigned to Heaven or Hell based on
            the last four digits of your Celestial Security Number.
            The Heaven-Hell border was opened a long time ago, though,
            so your initial assignment is not permanent.";
            break;

        case 11:
            "You said we can go to Heaven.  How do we get there?";
            break;
        case 12:
            "The easiest way is to use the HadesCorp Space Needle.
            It's impossible to miss -- it's the tallest free-standing
            structure in hell. The view from the elevator is
            fantastic.";
            break;

        case 13:
            "You mentioned jobs.  What if I don't want to work?";
            break;
        case 14:
            "That's up to you.  Dead people have no material
            needs.  And, unlike in real life, you'll find that you won't
            need to eat or sleep every forty or fifty turns, which is a
            real convenience.  However, most people like to feel useful,
            and derive a sense of purpose from their employment here.";
            break;

        case 15:
            "I used to work as a lobbyist.  Are similar positions
            available here?";
            break;
        case 16:
            "Absolutely!  However, you may find that there are quite
            a few lobbyists in Hell, which will probably not surprise
            anyone.  Incidentally, anyone interested in public affairs
            should tune in to H-SPAN, which broadcasts programs that
            cover a wide array of current events.  I believe the
            station number is 319.";
            break;

        case 17:
            "I'm a very rich individual and I refuse to be treated in this
            manner.  I've made charitable contributions all my life,
            and we've never beaten the help -- not when they didn't
            deserve it, anyway, the lazy bastards.  This is an
            outrage!  You can be sure you will be hearing from my
            lawyer!  What do you have to say for yourself?";
            break;
        case 18:
            "I'm sure you have a very good case.  However, I'm
            afraid that the legal system in Hell is based on the
            United States judicial system.  So, as you must know,
            the courts are so overloaded with frivolous lawsuits
            that legitimate claims, such as yours undoubtedly is,
            cannot be accepted.  Any lawsuit found to have merit
            is immediately and summarily dismissed.  There are some
            very good personal injury lawyers that you might wish
            to contact, though.";
            break;

        case 19:
            "I used to drive nitro-burning ground-pounding
            six-second funny cars.  Is there any chance that
            I'll be able to shake hands with the devil while
            I scream through the gates of Hell?";
            break;
        case 20:
            "I'm afraid that, due to the volume of new immigrants,
            the devil is unable to personally greet each new arrival.";
            break;

        default:
            num := question_num := 1;
            goto try_again;
        }
    }
    nextquestion =
    {
        local loc;
        local gender;

        loc := ['at the rear' 'near the center' 'at the front'
                'in the middle' 'at the left' 'at the right'][rand(6)];
        gender := (rand(100) > 50 ? 1 : 2);

        if (Me.location <> building and Me.location <> bldgchair) return;

        "\b\tSomeone << loc >> of the room raises
        << ['his' 'her'][gender] >> hand.
        \"Yes, you << loc >>,\" the woman says, pointing to
        << ['him' 'her'][gender] >>.
        \n\t\""; self.show_question(question_num);

        "\" << ['he' 'she'][gender] >> asks.\n\tThe woman responds, \"";
        self.show_question(question_num+1); "\"";

        question_num += 2;
    }   
    verDoAskAbout(actor, iobj) = {}
    doAskAbout(actor, iobj) =
    {
        "Try as you might, you can't seem to attract her attention --
        someone always gets in with a question first.";
    }
    doSynonym('AskAbout') = 'TellAbout'
    verIoShowTo(actor) = {}
    ioShowTo(actor, dobj) = { self.doAskAbout(actor, dobj); }
    ioSynonym('ShowTo') = 'GiveTo'
;

foldVerb: deepverb
    verb = 'fold'
    sdesc = "fold"
    doAction = 'Fold'
;

buildingPodium: decoration
    noun = 'podium' 'lectern'
    location = building
    sdesc = "podium"
;

bldgchair: chairitem
    reachable = ([lecturer] + self)
    noun = 'chair' 'chairs' 'seat' 'seats'
    adjective = 'empty' 'folding'
    location = building
    sdesc = "folding chair"
    ldesc = "It's a simple metal folding chair."
    verDoFold(actor) = {}
    doFold(actor) = { "It would be best to just leave it as it is."; }
    doSiton(actor) =
    {
        "As you sit down, a middle-aged woman enters the room and
        walks to the podium.  \"Good afternoon, everyone,\" she
        says, addressing the assembled group of passengers.  \"Welcome
        to the afterlife.  I'm here to help you get started, give you
        basic information about the underworld, and answer any questions
        you have.
        \n\t\"Let me start by saying that we're very glad to have you
        here.  Just take your time getting acquainted with your surroundings.
        There's no hurry -- you're going to be here for a long time!\"
        She chuckles and smiles.  \"Seriously, though, I think you'll
        find that being dead isn't very hard once you find your way
        around.
        \n\t\"Now, once you've had a chance to explore for a while,
        you'll probably want to find a job.  There are many very
        interesting positions available, and we'll be happy to help
        you find something that's right for you.
        \n\t\"I'm sure you all have many questions, so don't be shy.
        Who's first?\"";
        
        lecturer.moveInto(building);
        notify(lecturer, &nextquestion, 0);
        actor.travelTo(self);
    }
;

boatdeckPlants: distantItem
    sdesc = "plant"
    noun = 'plant' 'plants'
    adjective = 'twisted' 'short' 'leafless'
    location = boatdeck
    ldesc = "The plants are all leafless and dead-looking."
;

boatdeck: boatroom
    sdesc = "Deck"
    ldesc =
    {
        if (gangway.isopen)
            "You're on the deck of the yacht, which is docked at
            a large, brightly-lit pier.  A gangway leads west onto
            the pier.  A stairway leads down, and a doorway leads
            east.  Other passengers gradually are making their
            way out onto the pier.";
        else
            "You're on the deck of the yacht.  You have a clearer
            view of the river and the shores from here.  The river is
            very wide; the shores are rocky and desolate, with only a few
            short, leafless, twisted plants growing along the riverbank.
            The sky is densely clouded, but not dark; the clouds reflect
            the red glow that seems to come from the horizon in all
            directions.  It strikes you that it is exceedingly quiet;
            you hear no noise from the boat's engines, and even the
            boat's rapid slicing through the still waters seems to make
            no sound.  It is so quiet that you hear only your own
            breathing -- you realize that it's surprising that you're
            breathing at all, given that you're dead.  A stairway leads
            down, and a doorway leads east.";
    }
    down = boatmain
    east = boatcontrol
    west =
    {
        if (gangway.isopen) return(pier);
        "You can't go that way.";
        return(nil);
    }
;

introNote: readable
    sdesc = "printed note"
    location = boatdeck
    noun = 'note'
    adjective = 'printed'
    ldesc = "\b\b\b
        << version.sdesc >>
        \b\b
        This game is freeware.  You may use and copy it free of charge,
        subject to certain restrictions.  Please see the included readme
        file for details.
        \b
        This game was implemented with TADS, the Text Adventure Development
        System, also available from High Energy Software.  TADS is a
        tool that lets you write your own adventure games using a high-level
        C-like object-oriented language.  TADS is available as freeware,
        so you can probably obtain a copy from the same place you obtained
        this game.
        \b
        The source code to this game is available, and, like the game,
        is free.  If you're a TADS programmer, you may be interested
        in getting a copy as an example of a full-scale game.
        \b
        If you need instructions for playing this game, type INSTRUCTIONS
        at the > prompt.\n"     
;

shore2: distantItem
    noun = 'shore' 'shores' 'bank' 'banks' 'river' 'riverbank' 'rock' 'rocks'
           'water'
    adjective = 'river'
    sdesc = "shore"
    location = boatdeck
    ldesc = "The shores are rocky and desolate, with only a few
        short, leafless, twisted plants growing along the riverbank."
;

boatcontrolWindow: fixeditem
    sdesc = "window"
    noun = 'window' 'river'
    adjective = 'large'
    location = boatcontrol
    ldesc = "Through the window, you see the broad, calm river.
        You had a somewhat clearer view out on the deck."
    verDoLookthru(actor) = {}
    doLookthru(actor) = { self.ldesc; }
    verDoClose(actor) = { "It's already closed."; }
    verDoOpen(actor) = { "It can't be opened."; }
;

boatcontrols: decoration
    noun = 'controls' 'control' 'panel' 'microphone' 'mic'
    location = boatcontrol
    sdesc = "controls"
;

boatcontrol: boatroom
    sdesc = "Control Room"
    west = boatdeck
    out = boatdeck
    ldesc = "You're in the boat's control room.  A large window
        looks out onto the river.  A doorway leads west, back
        out onto the deck."
    enterRoom(actor) =
    {
        if (not isseen) setfuse(dock_the_boat, 5, nil);
        pass enterRoom;
    }
;

boatpilot: Actor
    isHim = true
    sdesc = "pilot"
    noun = 'captain' 'pilot' 'himself'
    location = boatcontrol
    actorAction(v, d, p, i) =
    {
        if (v = helloVerb)
            "\"Hello.\"";
        else
            "\"I'm sorry, but I'm busy with the controls.\"";
        exit;
    }
    ldesc = { self.actorDesc; }
    disavow = "\"There's not much to tell about it.\""
    askWord(word, lst) =
    {
        switch(word)
        {
        case 'pilot':
        case 'captain':
        case 'himself':
            "\"I was a programmer before I got here.  But there's
            not much need for programming skills here, so I do
            this instead.\"";
            break;

        case 'bartender':
        case 'barkeep':
        case 'bar':
            "\"The drinks at the bar are free.  Help yourself!
            Just ask the bartender for a beer, liquor, what have you.
            But let me know if you see any of those Infernolab
            guys down there -- they always come running when they
            hear there's an open bar somewhere.\"";
            break;

        case 'lab':
        case 'infernolab':
            "\"They're just a bunch of drunkards, if you ask me.\"";
            break;

        case 'boat':
        case 'yacht':
        case 'ship':
            "\"This is a very nice boat, don't you think?  We used
            to use a small rowboat, but lots of people complained
            that the passage to the afterlife should be a little
            nicer.  Besides, with more people dying these days,
            it was getting crowded.\"";
            break;

        case 'afterlife':
        case 'hell':
        case 'death':
            "\"It's a little strange at first, but you'll get used
            to it.\"";
            break;

        default:
            return(nil);
        }
        return(true);
    }
    actorDesc = "The boat's pilot is here, operating the controls."
    verIoGiveTo(actor) = {}
    ioGiveTo(actor, dobj) =
    {
        "\"No, thanks, I'm busy with the boat.\"";
    }
;

boatbar: boatroom
    north = boatmain
    sdesc = "Bar"
    ldesc = "You're in the yacht's wet bar.  The only exit is north,
        back into the main cabin."
;

boatbarbar: fixeditem
    location = boatbar
    noun = 'bar'
    adjective = 'wet'
    sdesc = "bar"
    ldesc = "The bar is large and well-stocked.  Several types of
        beer are on tap (all imported, you assume, given the
        circumstances), and an enormous variety of 
        liquors fills the shelves behind the bar."
;

class fixeddrink: fixeditem
    location = boatbar
    sdesc = "drinks"
    ldesc = "The bar looks well stocked."
    noun = 'drinks'
    isdrink = true
    verDoTake(actor) =
    {
        "You'll have to ask the bartender for that.";
    }
    doSynonym('Take') = 'Drink'
    verIoAskFor(actor) =
    {
        if (self.glass and self.glass.location <> nil)
            "You'll have to drink the one you already have first.";
        else
            pass verIoAskFor;
    }
    pourIt =
    {
        self.pourmsg;  " He hands you the glass.";
        self.glass.moveInto(Me);
        setit(self.glass);
        //self.moveInto(nil);
    }
;

drink: item
    verDoLookin(actor) = {}
    verDoDrink(actor) = {}
    doDrink(actor) =
    {
        "You drink << thedesc >> all at once.  It's very good.
        You notice a slight alcoholic buzz, but it clears fairly
        quickly.  After you finish, the glass vanishes into thin air.";
        self.moveInto(nil);
    }
    verDoPourIn(actor, iobj) = {}
    doPourIn(actor, iobj) =
    {
        "You pour the fluid, and it evaporates on contact.
        (It must be very arid in Hell.)  The glass vanishes
        into thin air.";
        self.moveInto(nil);
    }
    doSynonym('PourIn') = 'PourOn' 'PutIn' 'PutOn'
;

beermug: drink
    doLookin(actor) = { "It's full of beer."; }
    sdesc = "mug of beer"
    noun = 'mug' 'beer' 'glass' 'drink'
    unglass = fixedbeer
;

fixedbeer: fixeddrink
    sdesc = "bar's stock of beer"
    noun = 'beer' 'ale' 'drink' 'brew' 'brewski' 'stock'
    adjective = 'bar\'s'
    pourmsg = "He gets out a large mug and fills it with beer from
        the tap."
    glass = beermug
;

fixedwater: fixeddrink
    sdesc = "water"
    noun = 'water' 'glass'
;

liquorglass: drink
    doLookin(actor) = { "It's full of some sort of liquor."; }
    sdesc = "glass of liquor"
    noun = 'liquor' 'liquors' 'vodka' 'whiskey' 'scotch' 'bourbon' 'tequilla'
           'glass' 'drink' 'martini'
    unglass = fixedliquor
;

fixedliquor: fixeddrink
    sdesc = "bar's stock of liquor"
    noun = 'liquor' 'vodka' 'whiskey' 'scotch' 'bourbon' 'tequilla' 'drink'
           'martini' 'stock' 'liquors'
    adjective = 'bar\'s'
    pourmsg = "He gets out a small glass and pours you a drink."
    glass = liquorglass
;

class barVerb: deepverb
    action(actor) =
    {
        if (actor.location = boatbar)
            bartender.actorAction(self, nil, nil, nil);
        else
            "I think you've already had one too many.";
    }
;

liquorVerb: barVerb
    verb = 'liquor' 'vodka' 'whiskey' 'scotch' 'bourbon' 'tequilla'
           'martini' 'liquors'
    barVerbDobj = fixedliquor
    action(actor) = { inherited.action(actor); }
;

beerVerb: barVerb
    verb = 'beer' 'ale' 'brew' 'brewski'
    barVerbDobj = fixedbeer
    action(actor) = { inherited.action(actor); }
;

waterVerb: barVerb
    verb = 'water'
    barVerbDobj = fixedwater
    action(actor) = { inherited.action(actor); }
;

bartender: Actor
    isHim = true
    sdesc = "bartender"
    noun = 'bartender' 'barkeep' 'himself' 'man'
    adjective = 'middle-aged' 'middle-age'
    location = boatbar
    ldesc = "He's a middle-aged man with slightly graying hair."
    verDoAskFor(actor, io) = {}
    doAskFor(actor, iobj) =
    {
        if (iobj.unglass) iobj := iobj.unglass;
        self.actorAction(giveVerb, iobj, toPrep, Me);
    }
    disavow = "\"You probably know as much as I do.\""
    askWord(word, lst) =
    {
        switch(word)
        {
        case 'beer':
        case 'mug':
            "\"I have a good selection of beers.  Naturally,
            everything's imported.\"";
            break;

        case 'liquor':
        case 'liquors':
        case 'vodka':
        case 'whiskey':
        case 'scotch':
        case 'bourbon':
        case 'tequilla':
        case 'martini':
            "\"I have a very nice selection of liquors.\"";
            break;

        case 'drink':
        case 'drinks':
        case 'bar':
            "\"The drinks are all free.  Beer, liquor -- we have
            a wide selection.\"";
            break;

        case 'water':
            "\"Water?  Come on!  Live a little!\"";
            break;

        case 'captain':
        case 'pilot':
            "\"You can't go ask him yourself.  He's happy
            to talk to passengers.\"";
            break;

        case 'bartender':
        case 'barkeep':
        case 'himself':
            "\"There's not much to tell, really.\"";
            break;

        case 'lab':
        case 'infernolab':
            "\"They're some of my best customers.\"";
            break; 

        case 'boat':
        case 'yacht':
        case 'ship':
            "\"The captain knows more about it than I do.\"";
            break;

        case 'afterlife':
        case 'death':
        case 'hell':
            "\"I kind of like it here.\"";
            break;

        default:
            return(nil);
        }
        return(true);
    }
    actorAction(v, dobj, p, iobj) =
    {
        if (isclass(v, barVerb))
        {
            iobj := Me;
            p := toPrep;
            dobj := v.barVerbDobj;
            v := giveVerb;
        }
        if (v = helloVerb)
            "\"Hello!  What can I get you?  Beer, liquor, you name it.\"";
        else if (((v = giveVerb or v = takeVerb)
                  and iobj = Me and p = toPrep)
                 or (v = pourVerb and (iobj = nil or iobj = Me)))
        {
            if (not dobj.isdrink)
                "\"Sorry, only what you see here.\"";
            else if (dobj = fixedwater)
                "\"Water?  Come on, live a little!\"";
            else if (dobj.glass.location <> nil)
                "\"You could at least finish the one I already gave you.\"";
            else
            {
                "\"Right away!\" ";
                dobj.pourIt;
            }
        }
        else
            "\"Sorry, I'm busy tending the bar.\"";
        exit;
    }
    verDoTellAbout(actor, iobj) = {}
    doTellAbout(actor, iobj) =
    {
        "He listens attentively, and nods from time to time.";
    }
;

boatpeople: boatpeopleItem
    location = boatmain
    ldesc =
    {
        if (gangway.isopen)
            "The other passengers are slowly making their way, a
            few at a time, up onto the deck and out onto the pier.";
        else
            "The other passengers are doing pretty much what
            you're doing:  trying to get their bearings, looking
            around, quietly examining their surroundings.  You don't
            recognize anyone, and no one seems too interested in
            interacting with others.";
    }
    actorAction(v, d, p, i) =
    {
        "They seem too disoriented to make conversation.";
        exit;
    }
    disavow = "They seem too disoriented to answer any questions."
;

boatseat: chairitem
    reachable = (inherited.reachable + self.location.contents)
    noun = 'seat' 'j-33' 'j33' 'chair'
    adjective = 'my' 'seat'
    location = boatmain
    thedesc = "seat J-33"
    adesc = "seat J-33"
    sdesc = "seat J-33"
    ldesc = "It's a large, plush seat, labeled J-33.  It's a window
        seat."
;

windowItem: item
    verDoLookthru(actor) = {}
    doLookthru(actor) = { self.thrudesc; }
    thrudesc = { self.ldesc; }
;

boatwindow: windowItem, fixeditem
    noun = 'window'
    location = boatmain
    sdesc = "window"
    ldesc =
    {
        if (gangway.isopen)
            "The boat appears to be docked at a large, brightly-lit
            pier.  You can see other passengers gradually disembarking onto
            the pier.";
        else
            "It's quite dark outside, but a red glow on the horizon
            provides enough light to see that the boat is traveling rapidly
            down a wide river.  You can't make out any detail on the
            banks.  The waters
            of the river are dark and still below a thin film of mist,
            which the boat seems barely to upset.";
    }
    verDoOpen(actor) =
    {
        "For safety reasons, the window cannot be opened.";
    }
;

