/* $Id: intro.t 1.14 2001/08/16 19:18:52 mol Exp $
 * --------------------------------------------------------------
 * Intro texts for Aayela 1.2
 *
 * This file is a part of the source distribution of
 *
 * Aaylea - an Interactive Vision, release 1.2
 *
 * Copyright 1996-2001 by Magnus Olsson (mol@pobox.com).
 * All rights reserved.
 *
 * THIS CODE MAY BE DISTRIBUTED FREELY AS LONG AS IT IS NOT MODIFIED
 * IN ANY WAY, NO FEE IS CHARGED EXCEPT FOR DISTRIBUTION COST, AND
 * THIS COPYRIGHT NOTICE IS NOT ALTERED OR DELETED.
 * You may use the code, classes and algorithms as part of your
 * own programs as long as the following conditions are met:
 *
 * 1) No use of the characters, plot or text of the game
 *    "Aayela" are used in the derivative work (i.e. you may
 *    write another game set in darkness using this code, but
 *    you may not publish an "improved" version of Aayela)
 *    without the author's permission.
 * 2) The use of this code, and its origin, are acknowledged in 
 *    the derivative work.
 *
 * This version is tested with the Linux TADS compiler v2.5.5
 * --------------------------------------------------------------
 */

/*
 * The following function prints the introductory text and starts
 * the darkdaemon. 
 */
intro : function
{
    local reply;
    "<< version.name >> by Magnus Olsson (mol@pobox.com)\b";
    "Skip introduction (y/N)?\ >";
    if (yorn() <> 1) {
 	introtext.txt1;
        more();
    }
    "\b";
}

introtext : object
    txt1 = "\bIn the forty-seventh year of the reign of King Dargon, 
	twelve years after the battle of Cyr-Dhool, and five
	years after his third marriage, disaster struck the Realm.\b

	Queen Dahra became ill; at first just a cold, but the fever
	rose and she became delirious; then she fell into a coma.
	King Dargon, never much of a ruler, seemed to lose all
	sense of the world outside, spending all his time watching
	over his young wife.\b

	State business was neglected. The barons, never very loyal
	to the Crown, saw their chance to power; only their mutual
	distrust kept them from open revolt, but civil war was
	approaching. And the Queen's health kept deteriorating. The
	court buzzed with rumours of poison, a curse, an enchantment;
	doctors came and went, shaking their heads; the King remained
	at her side, oblivious to the world outside.\b

	When old Grodrig, the court magician, first mentioned the Stone of
	Aayela, the courtiers just laughed at him. A myth, an old
	fairytale - how could he talk such nonsense? But he kept
	retelling what he had read in his dusty old tomes: how Heliax
	the Wizard had captured a spirit of light, Aayela, in a
	perfect crystal, bending her power to his will; how the Stone
	lay hidden, deep below the roots of the mountains, waiting for
	a hero to retrieve it.\b

	And as the Queen got steadily worse, all conventional cures
	failing, people started believing him. Perhaps the Stone was
	the only cure for her illness? Finally the King himself, in
	one of his few lucid moments, decreed that the stone was to be
	found and brought back. As the youngest and most dispensable
	of the King's knights, you are the natural choice for a fool's
	errand like this.\b

	And what are you to do, but obey?"

    txt2 = "Your voyage has been long and perilous. You have been
	robbed, attacked by wild animals, almost drowned in a river 
	(losing your sword in the process), but you have 
	pressed on, through forests, across lakes, over hills,
	down through endless tunnels under the Dark Mountains. 
	Your lamp is running out of oil and the last of your food is
	eaten, but at last you feel that you are close to your goal. Or
	at least you hope so.\b";
;
