#charset "us-ascii"
#include <advlite.h>


class StairwellStairwayUp: StairwayUp 'stairs; (up) upward concrete flight (of); stairway steps; it them'
    desc = "The flight of concrete stairs is quite ordinary. "
;
class StairwellStairwayDown: StairwayDown 'stairs; (down) downward concrete flight (of); stairway steps; them'
    desc = "The flight of concrete stairs is quite ordinary. "
;

//----------------------------------------------------------------------------
// The roof level of the stairwell:
//----------------------------------------------------------------------------

Doer 'go north'
    execAction(c) {
        stairwellTopExitDoorInterior.makeLocked(nil);
        stairwellTopExitDoorInterior.makeOpen(true);
        "You push the exit door open and pass through the doorway. Behind you, the
        door closes with a solid <i>thump.</i> ";
        doInstead(Go, northDir);
        stairwellTopExitDoorInterior.makeOpen(nil);
        stairwellTopExitDoorInterior.makeLocked(true);
    }
    where = stairwellTop
;

Doer 'open stairwellTopExitDoorInterior'
    execAction(c) {
        "You push the exit door open, but as soon as you let go of it, it closes again. ";
    }
    where = stairwellTop
;

Doer 'push stairwellTopExitDoorInterior'
    execAction(c) {
        "You push the exit door open, but as soon as you let go of it, it closes again. ";
    }
    where = stairwellTop
;


stairwellTop: Room 'At the Top of the Stairs'
    "From this drab landing the concrete stairs lead downward. A closed door with a crash bar stands to the
    north. "
    
    down: TravelConnector {
        destination = topStairsDown
        travelBarriers = [wagonBarrier]
    }
    north = stairwellTopExitDoorInterior
;

+ topStairsDown: StairwellStairwayDown '+'
    destination = stairwellUpper
;

+ stairwellTopExitDoorInterior: Door 'closed door'
    "The door looks rather sturdy. "
    isOpen = nil
    otherSide = stairwellTopExitDoorExterior
;

++ Component, Decoration 'crash bar'
    "The crash bar is the usual sort of thing. "
;

//----------------------------------------------------------------------------
// The stairwell 2nd floor:
//----------------------------------------------------------------------------

stairwellUpper: Room 'A Stairwell Landing'
    "The concrete stairs continue both up and down here. A door leads off to the west. "
    
    up: TravelConnector {
        destination = upperStairsUp
        travelBarriers = [wagonBarrier]
    }
    down: TravelConnector {
        destination = upperStairsDown
        travelBarriers = [wagonBarrier]
    }
    west = grapeNotionExitDoorExterior
;

+ upperStairsUp: StairwellStairwayUp '+'
    destination = stairwellTop
;

+ upperStairsDown: StairwellStairwayDown '+'
    destination = stairwellMain
;
+ grapeNotionExitDoorExterior: Door 'door'
    "It's a solid-looking door. "
    isLocked = true
    otherSide = grapeNotionExitDoorInterior
    isOpen = nil
    lockability = indirectLockable
    checkPushTravel()
    {
        checkTravelBarriers(gActor);
    }
;

//------------------------------------------------------------------
// The main floor:
//------------------------------------------------------------------

stairwellMain: Room 'A Stairwell Landing'
    "The concrete stairs continue both up and down here. Doors lead both east and west. "

    up: TravelConnector {
        destination = mainStairsUp
        travelBarriers = [wagonBarrier]
    }
    down: TravelConnector {
        destination = mainStairsDown
        travelBarriers = [wagonBarrier]
    }
    east = broomCloset
    west = printeryExitDoorExterior
;

+ mainStairsUp: StairwellStairwayUp '+'
    destination = stairwellUpper
;

+ mainStairsDown: StairwellStairwayDown '+'
    destination = stairwellLower
;

+ printeryExitDoorExterior: Door 'door'
    "It's a solid-looking door. "
    isLocked = true
    otherSide = printeryExitDoorInterior
    isOpen = nil
    lockability = indirectLockable
    autoUnlock = nil
    checkPushTravel()
    {
        checkTravelBarriers(gActor);
    }
;

//------------------------------------------------------------------
// The lower floor:
//------------------------------------------------------------------

stairwellLower: Room 'A Stairwell Landing'
    "The concrete stairs continue both up and down here. Doors lead off to
    the west and north. The stairs leading downward, however, appear to have
    been badly damaged. There would seem to be no way to descend any further. "
    
    up: TravelConnector {
        destination = lowerStairsUp
        travelBarriers = [wagonBarrier]
    }
    down = lowerStairsDown
    north = litteredHallwayExitDoorExterior
    west = asteroidExitDoorExterior
;

+ lowerStairsUp: StairwellStairwayUp '+'
    destination = stairwellMain
;

+ lowerStairsDown: StairwellStairwayDown '+; damaged broken'
    "The concrete stairs leading downward would be quite ordinary in appearance, if they
    weren't broken off just a couple of steps below the landing. "
    canTravelerPass (traveler) { return nil; }
    explainTravelBarrier (traveler) {
        "The stairs descending from this point are so badly damaged --- broken, really ---
        that trying to use them would be dangerous. ";
    }
;

+ litteredHallwayExitDoorExterior: Door 'door'
    "It's a solid-looking door. "
    isLocked = true
    otherSide = litteredHallwayExitDoorInterior
    isOpen = nil
    lockability = indirectLockable
    checkPushTravel()
    {
        checkTravelBarriers(gActor);
    }
;

+ asteroidExitDoorExterior: Door 'door'
    "It's a solid-looking door. "
    isLocked = true
    otherSide = asteroidStairwellDoorInterior
    isOpen = nil
    lockability = indirectLockable
    checkPushTravel()
    {
        checkTravelBarriers(gActor);
    }
;

//----------------------------------------------------------------------------
// broomCloset:
//----------------------------------------------------------------------------

broomCloset: Room 'Broom Closet'
    "This cramped and cheerless little room smells strongly of disinfectant. The exit is
    to the west. "
    west = stairwellMain
    out asExit(west)
;

+ Unthing 'broom; ; brooms mop mops bucket buckets'
    'There are no brooms in the broom closet. Also no mops or buckets. '
;

+ Odor 'smell of disinfectant; cleaning; fluid fluids odor fragrance'
    "The redolence of ammonia, or possibly something more caustic. Don't breathe too deeply,
    you might sneeze. "
    smellDesc = "The broom closet fairly reeks of assorted cleaning fluids. "
;