#charset "us-ascii"

/*
 *   Copyright (c) 2002 by Joao Mendes.
 *   ConvActn.t: Conversation Library - Action Definitions.
 */

#include <adv3.h>
#include <en_us.h>

#include <JmmmConv.h>

/******************************************************************************
 *
 *   Conversation Preconditions
 *   talkingToObj - Actor is talking to object
 *   notTalkingToObj - Actor is not talking to object
 */

notTalkingToObj: PreCondition
    verifyPreCondition(obj)
    {
        if ( obj != nil && obj.ofKind(JmmmPerson) && obj.isTalking )
            illogicalNow('{You/he} {are} already talking to {the dobj/him}.');
    }
;

talkingToObj: PreCondition
    checkPreCondition(obj, allowImplicit)
    {
        if (obj == nil )
            return nil;

        if ( !obj.ofKind(JmmmPerson) || obj.isTalking || obj.canAskNoGreet )
            return nil;

        if ( allowImplicit && obj.canImplicitGreet && tryImplicitAction(Greet, obj) )
        {
            if ( !obj.isTalking )
                exit;
            "\b";
            return true;
        }

        reportFailure(obj.notTalking);
        exit;
    }

    verifyPreCondition(obj)
    {
        if (obj != nil && obj.ofKind(JmmmPerson) && !obj.isTalking )
            logicalRankOrd(80, 'is not talking', 150);
    }
;

/******************************************************************************
 *
 *   Greet Transitive Action
 *   Defined as Talk To with no topic
 */

DefineTAction(Greet)
;

VerbRule(Greet)
    'greet' singleDobj
    : GreetAction
    verbPhrase = 'greet/greeting (whom)'
;

modify Thing
    dobjFor(Greet) asDobjFor(TalkTo)
;
