/* Copyright (C) 1992 Pete Chown.

   Here is my latest adventure game, Napoleon (see the documentation
   if you don't know why it's called that).  Have fun... (don't cheat,
   even though you've got the source :-) ).

   This game is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The game is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   675 Mass Ave, Cambridge, MA 02139, USA. */

#include "adv.h"

extern int main(int,char *[]);

bool dead,finished = FALSE,descr,looked,hacker = FALSE;
int player,score = 0;

static void write_disclaimer(void)
{
  format("%s, version %s, copyright (c) Pete Chown 1992\n\n",NAME,VERSION);
  format("Napoleon is free software and you are welcome to distribute copies"
" of it under certain conditions; read the scroll (in the office where you st"
"art) to see them.  There is absolutely no warranty for Napoleon; again detai"
"ls are on the scroll.\n\n");
}

extern int main(int argc,char *argv [])
{
  bool quitting,gotinput;
  char *line;

  write_disclaimer();
  initialise();

  do {
    dead = FALSE;
    descr = TRUE;
    for(;;)
    {
      if(descr) {
	describe_room(player,looked);
	descr = FALSE;
	looked = FALSE;
      }
      precommand();
      if(dead || finished) break;
      line = getline("(napoleon) ",LINE_HISTORY);
      command(player,line);
      if(dead || finished) break;
    }
    quitting = gotinput = FALSE;
    do {
      format("Enter 'R' to restart, 'L' to load a saved game or 'Q' to quit:");
      line = getline(">",LINE_NO_HISTORY);
      switch(tolower(*line))
      {
      case 'r':
	initialise();
	gotinput = TRUE;
	break;
      case 'l':
	loadgame();
	gotinput = TRUE;
	break;
      case 'q':
	quitting = gotinput = TRUE;
	break;
      }
    } while(! gotinput);
  } while(! quitting);

  return 0;
}
