/* Copyright (C) 1992 Pete Chown.

   Here is my latest adventure game, Napoleon (see the documentation
   if you don't know why it's called that).  Have fun... (don't cheat,
   even though you've got the source :-) ).

   This game is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The game is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   675 Mass Ave, Cambridge, MA 02139, USA. */

/* Define PURE_ANSI if you are building Napoleon on a system which is not
   Unix compatible.  Then the result will be ANSI conforming, but will
   have no command history and will not be able to detect the size of the
   screen.  Otherwise define UNIX.

   Define HAS_XMALLOC if your system has xmalloc() built into the C library.
   It will not then be defined again by this program.
*/

#if (!defined(PURE_ANSI) && !defined(UNIX)) || (defined(PURE_ANSI) && defined(UNIX))
#error You must define one of PURE_ANSI and UNIX.
#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>
#include <signal.h>
#include <time.h>

#ifdef HAS_STDLIB
#include <stdlib.h>
#endif

#ifndef PURE_ANSI

#include "readline/readline.h"
#include "readline/history.h"

#endif

#define VERSION "1.02 (" __DATE__ ")"
#define NAME "Napoleon"
#define bool int
#define TRUE 1
#define FALSE 0
#define LINE_NO_HISTORY 5
#define LINE_HISTORY 6
#ifdef CHECKING_CONSISTENCY
#define fail() { fprintf(stderr,"Internal inconsistency detected\n"); exit(4); }
#else
#define fail() { fprintf(stderr,"Internal inconsistency detected, fail point is " __FILE__ ":%d\n",__LINE__); exit(4); }
#endif

struct objtype {
  unsigned int room:1,player:1,alive:1,luminous:1,opaque:1,virtual:1,visited:1,container:1;
};

typedef struct tagobject {
  int above,below,inside,next,parent,n,s,w,e,nw,ne,sw,se,u,d;
  char *examine,*longname,*shortname;
  struct objtype objtype;
} object;

extern void format(char *,...);
extern char *getline(char *,int);
extern void loadgame(void);
extern void initialise(void);
extern void describe_room(int,bool);
extern void command(int,char *);
extern int getroom(int);
extern void detachfromchain(int);
extern int yyparse(void);
extern bool strcmp_ci(char *,char *);
extern void addtochain(int,int,int *);
extern bool ancestor(int,int);
extern void savegame(void);
extern void addfirstdescendants(int);
extern void inventory(int);
extern int yylex(void);
extern void moveplayer(void);
extern int rnd(int);
extern void yyerror(char *);
extern void addadjective(char *);
extern void addobject(int);
extern int getobject(char *);
extern bool ispresent(int,int);
extern void examine(void);
extern void do_read(void);
extern void get(void);
extern void drop(void);
extern void put(int,int *);
extern int premove(int,int);
extern void postmove(void);
extern void postdescription(int);
extern void speech(int,int);
extern bool dogreeting(int);
extern bool dofarewell(int);
extern void doyes(int);
extern void dono(int);
extern void twirl(void);
extern void turn(void);
extern void examineobject(int,int);
extern int playnoughts(void);
extern void more(void);
extern void hack(void);
extern bool illuminated(int);
extern void justput(int,int,int *);
extern void play(int);
extern char *quickname(char *,int);
extern void playnandc(int);
extern void give(int);
extern bool wantsit(int,int);
extern void destroy(int);
extern void throw(int);
extern void jump(int);
extern void touch(int);
extern void unlock(int,int);
extern void resumscore(void);
extern bool referred_to(int);
extern int getbeastie(void);
extern void record(int,int);
extern void drink(int);
extern void precommand(void);
extern void do_wait(void);
extern void kiss(int);
extern bool quadruples(void);
extern void search(int);
extern void climb(int);

extern void *xmalloc(int);

extern bool descr,looked,dead,all,hacker,finished,speechflag;
extern object *objects,intobjects [];
extern int player,direction,score,yaccplayer,listedobjects,objectlist [200],subject,said,delay;
extern char *yaccstring;
extern unsigned char flags [128];
