/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.border.Border;
import org.zmpp.swingui.DisplaySettings;

public class PreferencesDialog
extends JDialog
implements ActionListener {
    private ColorItem[] colors = new ColorItem[]{new ColorItem(-1000, ""), new ColorItem(2, "Black"), new ColorItem(3, "Red"), new ColorItem(4, "Green"), new ColorItem(5, "Yellow"), new ColorItem(6, "Blue"), new ColorItem(7, "Magenta"), new ColorItem(8, "Cyan"), new ColorItem(9, "White"), new ColorItem(10, "Dark Gray")};
    private static final long serialVersionUID = 1L;
    private JSpinner stdfontSpinner;
    private JSpinner fixedfontSpinner;
    private JComboBox foregroundCB;
    private JComboBox backgroundCB;
    private Preferences preferences;

    public PreferencesDialog(JFrame jFrame, Preferences preferences, DisplaySettings displaySettings) {
        super(jFrame, "Preferences...", true);
        this.preferences = preferences;
        GridLayout gridLayout = new GridLayout(4, 2);
        gridLayout.setVgap(3);
        gridLayout.setHgap(3);
        JPanel jPanel = new JPanel(gridLayout);
        JLabel jLabel = new JLabel("Size of standard font: ");
        jPanel.add(jLabel);
        this.stdfontSpinner = new JSpinner();
        this.stdfontSpinner.setValue(displaySettings.getStdFontSize());
        jPanel.add(this.stdfontSpinner);
        JLabel jLabel2 = new JLabel("Size of fixed font: ");
        jPanel.add(jLabel2);
        this.fixedfontSpinner = new JSpinner();
        this.fixedfontSpinner.setValue(displaySettings.getFixedFontSize());
        jPanel.add(this.fixedfontSpinner);
        JLabel jLabel3 = new JLabel("Default background: ");
        jPanel.add(jLabel3);
        this.backgroundCB = new JComboBox<ColorItem>(this.colors);
        jPanel.add(this.backgroundCB);
        this.preselect(this.backgroundCB, displaySettings.getDefaultBackground());
        JLabel jLabel4 = new JLabel("Default foreground: ");
        jPanel.add(jLabel4);
        this.foregroundCB = new JComboBox<ColorItem>(this.colors);
        jPanel.add(this.foregroundCB);
        this.preselect(this.foregroundCB, displaySettings.getDefaultForeground());
        Box box = new Box(1);
        box.add(new JSeparator());
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        box.add(jPanel2);
        JButton jButton = new JButton("Ok");
        JButton jButton2 = new JButton("Cancel");
        this.getRootPane().setDefaultButton(jButton);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)new JLabel("<html><body><i>(Note: Changes only take effect after a restart)</i></body></html>"), "Center");
        this.getContentPane().add((Component)box, "South");
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 3);
        ((JPanel)this.getContentPane()).setBorder(border);
        ((BorderLayout)this.getContentPane().getLayout()).setVgap(5);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Ok")) {
            System.out.println("Std font: " + this.stdfontSpinner.getValue());
            System.out.println("Fixed font: " + this.fixedfontSpinner.getValue());
            System.out.println("Foreground: " + this.foregroundCB.getSelectedItem());
            System.out.println("Background: " + this.backgroundCB.getSelectedItem());
            this.preferences.put("stdfontsize", this.stdfontSpinner.getValue().toString());
            this.preferences.put("fixedfontsize", this.fixedfontSpinner.getValue().toString());
            this.preferences.put("defaultbackground", String.valueOf(((ColorItem)this.backgroundCB.getSelectedItem()).color));
            this.preferences.put("defaultforeground", String.valueOf(((ColorItem)this.foregroundCB.getSelectedItem()).color));
            try {
                this.preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
            }
        }
        this.dispose();
    }

    private void preselect(JComboBox jComboBox, int n) {
        for (int i = 0; i < this.colors.length; ++i) {
            if (this.colors[i].color != n) continue;
            jComboBox.setSelectedItem(this.colors[i]);
            break;
        }
    }

    class ColorItem {
        int color;
        String name;

        public ColorItem(int n, String string) {
            this.color = n;
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

