/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.media;

import java.awt.Toolkit;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.zmpp.base.Interruptable;
import org.zmpp.media.MediaCollection;
import org.zmpp.media.PlaySoundTask;
import org.zmpp.media.SoundEffect;
import org.zmpp.media.SoundSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoundSystemImpl
implements SoundSystem {
    private MediaCollection<SoundEffect> sounds;
    private ExecutorService executor;
    private Interruptable interruptable;
    protected PlaySoundTask currentTask;

    public SoundSystemImpl(MediaCollection<SoundEffect> mediaCollection) {
        this.sounds = mediaCollection;
        this.executor = Executors.newSingleThreadExecutor();
    }

    protected void handlePreviousNotFinished() {
        this.currentTask.stop();
    }

    @Override
    public void reset() {
    }

    @Override
    public void play(int n, int n2, int n3, int n4, int n5) {
        SoundEffect soundEffect = null;
        if (n == 0) {
            return;
        }
        if (this.sounds != null) {
            soundEffect = this.sounds.getResource(n);
        }
        if (soundEffect == null) {
            Toolkit.getDefaultToolkit().beep();
        } else if (n2 == 2) {
            this.startSound(n, soundEffect, n3, n4, n5);
        } else if (n2 == 3) {
            this.stopSound(n);
        } else if (n2 == 1) {
            this.sounds.loadResource(n);
        } else if (n2 == 4) {
            this.stopSound(n);
            this.sounds.unloadResource(n);
        }
    }

    private void startSound(int n, SoundEffect soundEffect, int n2, int n3, int n4) {
        if (this.currentTask != null && !this.currentTask.wasPlayed()) {
            this.handlePreviousNotFinished();
        }
        this.currentTask = n4 <= 0 ? new PlaySoundTask(n, soundEffect, n2, n3) : new PlaySoundTask(n, soundEffect, n2, n3, this.interruptable, n4);
        this.executor.submit(this.currentTask);
    }

    private void stopSound(int n) {
        if (this.currentTask != null && this.currentTask.getResourceNumber() == n) {
            this.currentTask.stop();
        }
    }
}

