/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

import java.awt.Font;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.zmpp.swingui.Canvas;

public class WordWrapper {
    private Font font;
    private Canvas canvas;
    private int lineLength;
    private boolean buffered;

    public WordWrapper(int n, Canvas canvas, Font font, boolean bl) {
        this.lineLength = n;
        this.font = font;
        this.buffered = bl;
        this.canvas = canvas;
    }

    public String[] wrap(int n, String string) {
        if (this.buffered) {
            return this.wrapBuffered(n, string);
        }
        return this.wrapUnbuffered(n, string);
    }

    private String[] wrapBuffered(int n, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r", true);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2++] = stringTokenizer.nextToken();
        }
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        while (n5 < stringArray.length) {
            StringBuilder stringBuilder = new StringBuilder();
            while (n5 < stringArray.length) {
                n4 = this.canvas.getStringWidth(this.font, stringArray[n5]);
                if (stringArray[n5].charAt(0) == '\n') {
                    ++n5;
                    break;
                }
                if (n3 + n4 <= this.lineLength) {
                    stringBuilder.append(stringArray[n5]);
                    n3 += n4;
                } else {
                    if (stringArray[n5].charAt(0) != ' ') break;
                    ++n5;
                    break;
                }
                ++n5;
            }
            stringBuilder.append('\n');
            arrayList.add(stringBuilder.toString());
            n3 = 0;
        }
        if (string.charAt(string.length() - 1) != '\n') {
            String string2 = (String)arrayList.get(arrayList.size() - 1);
            string2 = string2.substring(0, string2.length() - 1);
            arrayList.remove(arrayList.size() - 1);
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[0]);
    }

    private String[] wrapUnbuffered(int n, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n3 = this.canvas.getCharWidth(this.font, c);
            if (n2 + n3 > this.lineLength || c == '\n') {
                if (c == '\n') {
                    stringBuilder.append('\n');
                }
                arrayList.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                n2 = 0;
            }
            if (c == '\n') continue;
            stringBuilder.append(c);
            n2 += n3;
            if (i != string.length() - 1) continue;
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[0]);
    }
}

