array hextable -> '0' '1' '2' '3' '4' '5' '6' '7' '8' '9' 'A' 'B' 'C' 'D' 'E' 'F';

! Fills a chunk of memory.

[ memset ptr i size;
	while (size--)
		(ptr++)->0 = i;
];

! Copies a chunk of memory.

[ memcpy dest src len;
	if (dest > src)
	{
		! Copy down.
		dest = dest + len;
		src = src + len;
		while (len--)
			(--dest)->0 = (--src)->0;
	}
	else
	{
		! Copy up.
		while (len--)
			(dest++)->0 = (src++)->0;
	}
];

! Emits a string.

[ astring s;
	while (s->0)
		print (char) (s++)->0;
];

! Duplicates a string.

[ strdup s  s1 i;
	i = strlen(s);
	s1 = mem_alloc(i+1);
	strcpy(s1, s);
	return s1;
];

! Compares two strings.

[ strcmp s1 s2;
	while (s1->0 == s2->0)
	{
		if (s1->0 == 0)
			return 0;
		s1++;
		s2++;
	}
	return 1;
];

! Counts the length of a string.

[ strlen s  i;
	i = 0;
	while ((s++)->0)
		i++;
	return i;
];

! Copies a string from one place to another.

[ strcpy dest src;
	do {
		(dest++)->0 = (src++)->0;
	} until (src->0 == 0);
	dest->0 = 0;
];

! Outputs a hex number.

[ phex i digits;
	if (digits == 4)
	{
		print (char) hextable->((i / 4096) & 15);
		print (char) hextable->((i / 256) & 15);
	}
	print (char) hextable->((i / 16) & 15);
	print (char) hextable->(i & 15);
];
	
! Dumps some memory in hex.

[ hexdump p size;
	while (size)
	{
		phex(p->0, 2);
		print " ";
		size--;
		p++;
	}
	print "^";
];

