C SAVE- SAVE GAME STATE
C
C COPYRIGHT 1980, INFOCOM COMPUTERS AND COMMUNICATIONS, CAMBRIDGE MA. 02142
C ALL RIGHTS RESERVED, COMMERCIAL USAGE STRICTLY PROHIBITED
C WRITTEN BY R. M. SUPNIK
C
C DECLARATIONS
C
      SUBROUTINE SAVEGM
      IMPLICIT INTEGER (A-Z)
C
C PARSER OUTPUT
C
      LOGICAL PRSWON
      COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
C
C GAME STATE
C
      LOGICAL TELFLG
      COMMON /PLAY/ WINNER,HERE,TELFLG
      COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
     *	LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
C
C SCREEN OF LIGHT
C
      COMMON /SCREEN/ FROMDR,SCOLRM,SCOLAC
C
C PUZZLE ROOM
C
      COMMON /PUZZLE/ CPDR(16),CPWL(8),CPVEC(64)
C
C MISCELLANEOUS VARIABLES
C
      COMMON /VERS/ VMAJ,VMIN,VEDIT
      COMMON /TIME/ PLTIME,SHOUR,SMIN,SSEC
C
C ROOMS
C
      COMMON /ROOMS/ RLNT,RDESC2,RDESC1(200),REXIT(200),
     *	RACTIO(200),RVAL(200),RFLAG(200)
      INTEGER RRAND(200)
      EQUIVALENCE (RVAL,RRAND)
C
C EXITS
C
      COMMON /EXITS/ XLNT,TRAVEL(900)
C
C OBJECTS
C
      COMMON /OBJCTS/ OLNT,ODESC1(220),ODESC2(220),ODESCO(220),
     *	OACTIO(220),OFLAG1(220),OFLAG2(220),OFVAL(220),
     *	OTVAL(220),OSIZE(220),OCAPAC(220),OROOM(220),
     *	OADV(220),OCAN(220),OREAD(220)
C
C
C CLOCK INTERRUPTS
C
      LOGICAL*1 CFLAG
      COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
C
C
C VILLAINS AND DEMONS
C
      LOGICAL THFFLG,SWDACT,THFACT
      COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT,SWDSTA
      COMMON /VILL/ VLNT,VILLNS(4),VPROB(4),VOPPS(4),VBEST(4),VMELEE(4)
C
C ADVENTURERS
C
      COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
     *	AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
C
C IOSTAT
C
      INTEGER*4 IOSTAT
C
C FLAGS
C
      LOGICAL*1 FLAGS(46)
      INTEGER SWITCH(22)
      COMMON /FINDEX/ FLAGS,SWITCH
C
      COMMON /CHAN/ INPCH,OUTCH,DBCH
C
      CHARACTER*80 SFILE
      CHARACTER*78 ANS
      INTEGER*1 IANS(78)
      EQUIVALENCE (ANS,IANS)
      LOGICAL*4 EXISTS
C
C DISABLE GAME SO THAT SAVE HAS NO EFFECT ON THE GAME
C
      PRSWON=.FALSE.				!DISABLE GAME.
      TELFLG=.TRUE.				!SAID SOMETHING.
C
C ASK WHAT FILE THE GAME SHOULD BE SAVED IN
C
10    WRITE(OUTCH,1000)
1000  FORMAT(
     *' What is the name of the file you wish to save the game in?',/)
      READ(INPCH,2000,END=9000,IOSTAT=IOSTAT)SFILE
2000  FORMAT(A80)
      IF(IOSTAT.NE.0)GOTO 10
C
C IF THE USER HAS ENTERED A NULL STRING THEN NO SAVE
C
      IF(LENBA(SFILE,80).EQ.0)THEN
         WRITE(OUTCH,1015)
1015  FORMAT(' No save performed.')
         GOTO 8000
      ENDIF
C
C SEE IF THAT FILE ALREADY EXISTS
C
      INQUIRE(FILE=SFILE,EXIST=EXISTS)
      IF(EXISTS)THEN
20       WRITE(OUTCH,1020)
1020  FORMAT(' That file already exists, do you wish to replace it?',/)
         CALL RDLINE(IANS,IL,0)
         IF(ANS(:IL).EQ.'N'.OR.ANS(:IL).EQ.'NO')THEN
            WRITE(OUTCH,1015)
            GOTO 8000
         ENDIF
         IF(ANS(:IL).NE.'Y'.AND.ANS(:IL).NE.'YES')THEN
            WRITE(OUTCH,1030)
1030  FORMAT(' Please answer the question.')
            GOTO 20
         ENDIF
      ELSE IF(IOSTAT.NE.0)THEN
              WRITE(OUTCH,1040)
1040  FORMAT(' Sorry, but I can not open that file.')
              GOTO 8000
           ENDIF
C
C OPEN THE FILE
C
      OPEN(UNIT=1,
     *     FILE=SFILE,STATUS='UNKNOWN',
     *     FORM='UNFORMATTED')
C
      CALL GTTIME(I)				!GET TIME.
      WRITE(1,IOSTAT=IOSTAT) VMAJ,VMIN,VEDIT
      IF(IOstaT.EQ.0)WRITE(1,IOSTAT=IOSTAT)
     *	WINNER,HERE,THFPOS,TELFLG,THFFLG,THFACT,
     *	SWDACT,SWDSTA,CPVEC
      IF(IOstaT.EQ.0)WRITE(1,IOSTAT=IOSTAT)
     *	I,MOVES,DEATHS,RWSCOR,EGSCOR,MXLOAD,
     *	LTSHFT,BLOC,MUNGRM,HS,FROMDR,SCOLRM,SCOLAC
      IF(IOstaT.EQ.0)WRITE(1,IOSTAT=IOSTAT)
     *	ODESC1,ODESC2,OFLAG1,OFLAG2,OFVAL,OTVAL,
     *	OSIZE,OCAPAC,OROOM,OADV,OCAN
      IF(IOstaT.EQ.0)WRITE(1,IOSTAT=IOSTAT) RVAL,RFLAG
      IF(IOstaT.EQ.0)WRITE(1,IOSTAT=IOSTAT)
     *	AROOM,ASCORE,AVEHIC,ASTREN,AFLAG
      IF(IOstaT.EQ.0)WRITE(1,IOSTAT=IOSTAT)
     *	FLAGS,SWITCH,VPROB,CFLAG,CTICK
C
C ALL DONE AND OKAY?
C
      IF(IOSTAT.EQ.0)CLOSE(UNIT=1,IOSTAT=IOSTAT)
      IF(IOSTAT.NE.0)THEN
         CLOSE(UNIT=1,IOSTAT=IOSTAT)
         WRITE(OUTCH,1050)
1050  FORMAT(' Sorry, but the save failed.')
      ELSE
         CALL RSPEAK(597)
      ENDIF
C
C THAT IS IT
C
8000  RETURN
C
C USER EOFed THE TERMINAL INPUT STREAM
C
9000  CLOSE(UNIT=INPCH)
      OPEN(UNIT=INPCH,FILE='CON',STATUS='NEW')
      GOTO 10
      END
C RESTORE- RESTORE GAME STATE
C
C DECLARATIONS
C
      SUBROUTINE RSTRGM
      IMPLICIT INTEGER (A-Z)
C
C PARSER OUTPUT
C
      LOGICAL PRSWON
      COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
C
C GAME STATE
C
      LOGICAL TELFLG
      COMMON /PLAY/ WINNER,HERE,TELFLG
      COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
     *	LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
C
C SCREEN OF LIGHT
C
      COMMON /SCREEN/ FROMDR,SCOLRM,SCOLAC
C
C PUZZLE ROOM
C
      COMMON /PUZZLE/ CPDR(16),CPWL(8),CPVEC(64)
C
C MISCELLANEOUS VARIABLES
C
      COMMON /VERS/ VMAJ,VMIN,VEDIT
      COMMON /TIME/ PLTIME,SHOUR,SMIN,SSEC
C
C ROOMS
C
      COMMON /ROOMS/ RLNT,RDESC2,RDESC1(200),REXIT(200),
     *	RACTIO(200),RVAL(200),RFLAG(200)
      INTEGER RRAND(200)
      EQUIVALENCE (RVAL,RRAND)
C
C EXITS
C
      COMMON /EXITS/ XLNT,TRAVEL(900)
C
C OBJECTS
C
      COMMON /OBJCTS/ OLNT,ODESC1(220),ODESC2(220),ODESCO(220),
     *	OACTIO(220),OFLAG1(220),OFLAG2(220),OFVAL(220),
     *	OTVAL(220),OSIZE(220),OCAPAC(220),OROOM(220),
     *	OADV(220),OCAN(220),OREAD(220)
C
C
C CLOCK INTERRUPTS
C
      LOGICAL*1 CFLAG
      COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
C
C
C VILLAINS AND DEMONS
C
      LOGICAL THFFLG,SWDACT,THFACT
      COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT,SWDSTA
      COMMON /VILL/ VLNT,VILLNS(4),VPROB(4),VOPPS(4),VBEST(4),VMELEE(4)
C
C ADVENTURERS
C
      COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
     *	AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
C
C IOSTAT
C
      INTEGER*4 IOSTAT
C
C FLAGS
C
      LOGICAL*1 FLAGS(46)
      INTEGER SWITCH(22)
      COMMON /FINDEX/ FLAGS,SWITCH
C
      COMMON /CHAN/ INPCH,OUTCH,DBCH
C
      LOGICAL*4 EXISTS
      CHARACTER*80 SFILE
C
C DISABLE GAME SO THAT RESTORE HAS NO EFFECT ON THE GAME
C
      PRSWON=.FALSE.			!DISABLE GAME.
      TELFLG=.TRUE.				!SAID SOMETHING.
C
C ASK FOR THE NAME OF THE FILE IN WHICH THE GAME HAS BEEN SAVED
C
10    WRITE(OUTCH,1000)
1000  FORMAT(
     *' What is the name of the file in which the game',
     *' has been saved?',/)
      READ(INPCH,2000,END=9000,IOSTAT=IOSTAT)SFILE
2000  FORMAT(A80)
      IF(IOSTAT.NE.0)GOTO 10
C
C IF THE USER HAS ENTERED A NULL STRING THEN NO RESTORE
C
      IF(LENBA(SFILE,80).EQ.0)THEN
         WRITE(OUTCH,1015)
1015  FORMAT(' No restore performed.')
         RETURN
      ENDIF
C
C SEE IF THIS FILE EXISTS
C
      INQUIRE(FILE=SFILE,EXIST=EXISTS)
      IF(.NOT.EXISTS)THEN
         WRITE(OUTCH,1020)
1020  FORMAT(' That file does not exist, no restore performed.')
         RETURN
      ENDIF
C
C OPEN THE FILE
      OPEN(UNIT=1,FILE=SFILE,STATUS='OLD',
     *     FORM='UNFORMATTED')
C
      IF(IOSTAT.NE.0)GOTO 100
C
      READ(1) I,J,K
      IF((I.NE.VMAJ).OR.(J.NE.VMIN)) GO TO 200
C
      READ(1) WINNER,HERE,THFPOS,TELFLG,THFFLG,THFACT,
     *	SWDACT,SWDSTA,CPVEC
      READ(1) PLTIME,MOVES,DEATHS,RWSCOR,EGSCOR,MXLOAD,
     *	LTSHFT,BLOC,MUNGRM,HS,FROMDR,SCOLRM,SCOLAC
      READ(1) ODESC1,ODESC2,OFLAG1,OFLAG2,OFVAL,OTVAL,
     *	OSIZE,OCAPAC,OROOM,OADV,OCAN
      READ(1) RVAL,RFLAG
      READ(1) AROOM,ASCORE,AVEHIC,ASTREN,AFLAG
      READ(1) FLAGS,SWITCH,VPROB,CFLAG,CTICK
C
      CLOSE(UNIT=1)
      CALL RSPEAK(599)
      RETURN
C
100	CALL RSPEAK(598)			!CANT DO IT.
      RETURN
C
200	CALL RSPEAK(600)			!OBSOLETE VERSION
      CLOSE (UNIT=1)
      RETURN
C
C USER EOFed THE TERMINAL INPUT STREAM
C
9000  CLOSE(UNIT=INPCH)
      OPEN(UNIT=INPCH,FILE='CON',STATUS='NEW')
      GOTO 10
      END
C WALK- MOVE IN SPECIFIED DIRECTION
C
C DECLARATIONS
C
      LOGICAL FUNCTION WALK(X)
      IMPLICIT INTEGER(A-Z)
      LOGICAL FINDXT,QOPEN,LIT,PROB,MOVETO,RMDESC
C
C PARSER OUTPUT
C
      LOGICAL PRSWON
      COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
C
C GAME STATE
C
      LOGICAL TELFLG
      COMMON /PLAY/ WINNER,HERE,TELFLG
C
C ROOMS
C
      COMMON /ROOMS/ RLNT,RDESC2,RDESC1(200),REXIT(200),
     *	RACTIO(200),RVAL(200),RFLAG(200)
      INTEGER RRAND(200)
      EQUIVALENCE (RVAL,RRAND)
C
      COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
     *	RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
C
C EXITS
C
      COMMON /CURXT/ XTYPE,XROOM1,XSTRNG,XACTIO,XOBJ
      EQUIVALENCE (XFLAG,XOBJ)
C
      COMMON /XSRCH/ XMIN,XMAX,XDOWN,XUP,
     *	XNORTH,XSOUTH,XENTER,XEXIT,XEAST,XWEST
C
C OBJECTS
C
      COMMON /OBJCTS/ OLNT,ODESC1(220),ODESC2(220),ODESCO(220),
     *	OACTIO(220),OFLAG1(220),OFLAG2(220),OFVAL(220),
     *	OTVAL(220),OSIZE(220),OCAPAC(220),OROOM(220),
     *	OADV(220),OCAN(220),OREAD(220)
C
      COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
     *	NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
     *	TOOLBT,TURNBT,ONBT
      COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
     *	WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
     *	TCHBT,VEHBT,SCHBT
C
      LOGICAL*1 CFLAG
      COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
C
      COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
     *	CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
     *	CEVGNO,CEVBUC,CEVSPH,CEVEGH,
     *	CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
     *	CEVMRS,CEVPIN,CEVINQ,CEVFOL
C
C VILLAINS AND DEMONS
C
      LOGICAL THFFLG,SWDACT,THFACT
      COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT
      COMMON /VILL/ VLNT,VILLNS(4),VPROB(4),VOPPS(4),VBEST(4),VMELEE(4)
C
C ADVENTURERS
C
      COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
C
C FLAGS
C
      LOGICAL*1 FLAGS(46)
      EQUIVALENCE (FLAGS(1),TROLLF)
      LOGICAL*1 TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
      LOGICAL*1 DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
      LOGICAL*1 MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
      LOGICAL*1 EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
      LOGICAL*1 GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
      LOGICAL*1 GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
      LOGICAL*1 MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
      LOGICAL*1 FOLLWF,SPELLF,CPOUTF,CPUSHF
      COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
     *	DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
     *	MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
     *	EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
     *	GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
     *	GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
     *	MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
     *	FOLLWF,SPELLF,CPOUTF,CPUSHF
      COMMON /FINDEX/ BTIEF,BINFF
      COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
      COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
      COMMON /FINDEX/ MDIR,MLOC,POLEUF
      COMMON /FINDEX/ QUESNO,NQATT,CORRCT
      COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL,CPHERE
C
C FUNCTIONS AND DATA
C
      QOPEN(O)=(OFLAG2(O).AND.OPENBT).NE.0
C WALK, PAGE 2
C
      WALK=.TRUE.				!ASSUME WINS.
      IF((WINNER.NE.PLAYER).OR.LIT(HERE).OR.PROB(25,25))
     *	GO TO 500
      IF(.NOT.FINDXT(PRSO,HERE)) GO TO 450	!INVALID EXIT? GRUE!
      GO TO (400,200,100,300),XTYPE		!DECODE EXIT TYPE.
      CALL BUG(9,XTYPE)
C
100	IF(CXAPPL(XACTIO).NE.0) GO TO 400	!CEXIT... RETURNED ROOM?
      IF(FLAGS(XFLAG)) GO TO 400		!NO, FLAG ON?
200	CALL JIGSUP(523)			!BAD EXIT, GRUE!
      RETURN
C
300	IF(CXAPPL(XACTIO).NE.0) GO TO 400	!DOOR... RETURNED ROOM?
      IF(QOPEN(XOBJ)) GO TO 400		!NO, DOOR OPEN?
      CALL JIGSUP(523)			!BAD EXIT, GRUE!
      RETURN
C
400	IF(LIT(XROOM1)) GO TO 900		!VALID ROOM, IS IT LIT?
450	CALL JIGSUP(522)			!NO, GRUE!
      RETURN
C
C ROOM IS LIT, OR WINNER IS NOT PLAYER (NO GRUE).
C
500	IF(FINDXT(PRSO,HERE)) GO TO 550		!EXIT EXIST?
525	XSTRNG=678				!ASSUME WALL.
      IF(PRSO.EQ.XUP) XSTRNG=679		!IF UP, CANT.
      IF(PRSO.EQ.XDOWN) XSTRNG=680		!IF DOWN, CANT.
      IF((RFLAG(HERE).AND.RNWALL).NE.0) XSTRNG=524
      CALL RSPEAK(XSTRNG)
      PRSCON=1				!STOP CMD STREAM.
      RETURN
C
550	GO TO (900,600,700,800),XTYPE	!BRANCH ON EXIT TYPE.
      CALL BUG(9,XTYPE)
C
700	IF(CXAPPL(XACTIO).NE.0) GO TO 900	!CEXIT... RETURNED ROOM?
      IF(FLAGS(XFLAG)) GO TO 900		!NO, FLAG ON?
600	IF(XSTRNG.EQ.0) GO TO 525		!IF NO REASON, USE STD.
      CALL RSPEAK(XSTRNG)			!DENY EXIT.
      PRSCON=1				!STOP CMD STREAM.
      RETURN
C
800	IF(CXAPPL(XACTIO).NE.0) GO TO 900	!DOOR... RETURNED ROOM?
      IF(QOPEN(XOBJ)) GO TO 900		!NO, DOOR OPEN?
      IF(XSTRNG.EQ.0) XSTRNG=525		!IF NO REASON, USE STD.
      CALL RSPSUB(XSTRNG,ODESC2(XOBJ))
      PRSCON=1				!STOP CMD STREAM.
      RETURN
C
900	WALK=MOVETO(XROOM1,WINNER)		!MOVE TO ROOM.
      IF(WALK) WALK=RMDESC(0)			!DESCRIBE ROOM.
      RETURN
      END
C CXAPPL- CONDITIONAL EXIT PROCESSORS
C
C DECLARATIONS
C
      INTEGER FUNCTION CXAPPL(RI)
      IMPLICIT INTEGER (A-Z)
C
C GAME STATE
C
      LOGICAL TELFLG
      COMMON /PLAY/ WINNER,HERE,TELFLG
C
C PARSER OUTPUT
C
      LOGICAL PRSWON
      COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
C
C PUZZLE ROOM
C
      COMMON /PUZZLE/ CPDR(16),CPWL(8),CPVEC(64)
C
C ROOMS
C
      COMMON /ROOMS/ RLNT,RDESC2,RDESC1(200),REXIT(200),
     *	RACTIO(200),RVAL(200),RFLAG(200)
      INTEGER RRAND(200)
      EQUIVALENCE (RVAL,RRAND)
C
      COMMON /RINDEX/ WHOUS,LROOM,CELLA
      COMMON /RINDEX/ MTROL,MAZE1	
      COMMON /RINDEX/ MGRAT,MAZ15	
      COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
      COMMON /RINDEX/ STREA,EGYPT,ECHOR
      COMMON /RINDEX/ TSHAF	
      COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
      COMMON /RINDEX/ CAROU	
      COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
      COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
      COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
      COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
      COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
      COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
      COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
      COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
      COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
      COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
      COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
      COMMON /RINDEX/ CPANT,CPOUT,CPUZZ
C
C EXITS
C
      COMMON /EXITS/ XLNT,TRAVEL(900)
C
      COMMON /CURXT/ XTYPE,XROOM1,XSTRNG,XACTIO,XOBJ
      EQUIVALENCE (XFLAG,XOBJ)
C
      COMMON /XPARS/ XRMASK,XDMASK,XFMASK,XFSHFT,XASHFT,
     *	XELNT(4),XNORM,XNO,XCOND,XDOOR,XLFLAG
C
      COMMON /XSRCH/ XMIN,XMAX,XDOWN,XUP,
     *	XNORTH,XSOUTH,XENTER,XEXIT,XEAST,XWEST
C
C OBJECTS
C
      COMMON /OBJCTS/ OLNT,ODESC1(220),ODESC2(220),ODESCO(220),
     *	OACTIO(220),OFLAG1(220),OFLAG2(220),OFVAL(220),
     *	OTVAL(220),OSIZE(220),OCAPAC(220),OROOM(220),
     *	OADV(220),OCAN(220),OREAD(220)
C
      COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
     *	NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
     *	TOOLBT,TURNBT,ONBT
      COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
     *	WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
     *	TCHBT,VEHBT,SCHBT
C
      COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
      COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
      COMMON /OINDEX/	LEAVE,TROLL,AXE
      COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
      COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
      COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
      COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
      COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
      COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
      COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
      COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
      COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
      COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
      COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
      COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
      COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
      COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
      COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
      COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
      COMMON /OINDEX/ WARNI,CSLIT,GCARD,STLDR
      COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
      COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
C
      COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
C
C FLAGS
C
      LOGICAL*1 TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
      LOGICAL*1 DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
      LOGICAL*1 MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
      LOGICAL*1 EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
      LOGICAL*1 GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
      LOGICAL*1 GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
      LOGICAL*1 MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
      LOGICAL*1 FOLLWF,SPELLF,CPOUTF,CPUSHF
      COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
     *	DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
     *	MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
     *	EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
     *	GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
     *	GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
     *	MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
     *	FOLLWF,SPELLF,CPOUTF,CPUSHF
      COMMON /FINDEX/ BTIEF,BINFF
      COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
      COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
      COMMON /FINDEX/ MDIR,MLOC,POLEUF
      COMMON /FINDEX/ QUESNO,NQATT,CORRCT
      COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL,CPHERE
C CXAPPL, PAGE 2
C
      CXAPPL=0				!NO RETURN.
      IF(RI.EQ.0) RETURN			!IF NO ACTION, DONE.
      GO TO (1000,2000,3000,4000,5000,6000,7000,
     *	8000,9000,10000,11000,12000,13000,14000),RI
      CALL BUG(5,RI)
C
C C1- COFFIN-CURE
C
1000	EGYPTF=OADV(COFFI).NE.WINNER		!T IF NO COFFIN.
      RETURN
C
C C2- CAROUSEL EXIT
C C5- CAROUSEL OUT
C
2000	IF(CAROFF) RETURN			!IF FLIPPED, NOTHING.
2500	CALL RSPEAK(121)			!SPIN THE COMPASS.
5000	I=XELNT(XCOND)*RND(8)			!CHOOSE RANDOM EXIT.
      XROOM1=(TRAVEL(REXIT(HERE)+I)).AND.XRMASK
      CXAPPL=XROOM1				!RETURN EXIT.
      RETURN
C
C C3- CHIMNEY FUNCTION
C
3000	LITLDF=.FALSE.			!ASSUME HEAVY LOAD.
      J=0
      DO 3100 I=1,OLNT			!COUNT OBJECTS.
        IF(OADV(I).EQ.WINNER) J=J+1
3100	CONTINUE
C
      IF(J.GT.2) RETURN			!CARRYING TOO MUCH?
      XSTRNG=446				!ASSUME NO LAMP.
      IF(OADV(LAMP).NE.WINNER) RETURN		!NO LAMP?
      LITLDF=.TRUE.				!HE CAN DO IT.
      IF((OFLAG2(DOOR).AND.OPENBT).EQ.0)
     *	OFLAG2(DOOR)=OFLAG2(DOOR).AND. .NOT.TCHBT
      RETURN
C
C C4-	FROBOZZ FLAG (MAGNET ROOM, FAKE EXIT)
C C6-	FROBOZZ FLAG (MAGNET ROOM, REAL EXIT)
C
4000	IF(CAROFF) GO TO 2500			!IF FLIPPED, GO SPIN.
      FROBZF=.FALSE.				!OTHERWISE, NOT AN EXIT.
      RETURN
C
6000	IF(CAROFF) GO TO 2500			!IF FLIPPED, GO SPIN.
      FROBZF=.TRUE.				!OTHERWISE, AN EXIT.
      RETURN
C
C C7-	FROBOZZ FLAG (BANK ALARM)
C
7000	FROBZF=(OROOM(BILLS).NE.0).AND.(OROOM(PORTR).NE.0)
      RETURN
C CXAPPL, PAGE 3
C
C C8-	FROBOZZ FLAG (MRGO)
C
8000	FROBZF=.FALSE.				!ASSUME CANT MOVE.
      IF(MLOC.NE.XROOM1) GO TO 8100		!MIRROR IN WAY?
      IF((PRSO.EQ.XNORTH).OR.(PRSO.EQ.XSOUTH)) GO TO 8200
      IF(MOD(MDIR,180).NE.0) GO TO 8300	!MIRROR MUST BE N-S.
      XROOM1=((XROOM1-MRA)*2)+MRAE		!CALC EAST ROOM.
      IF(PRSO.GT.XSOUTH) XROOM1=XROOM1+1	!IF SW/NW, CALC WEST.
8100	CXAPPL=XROOM1
      RETURN
C
8200	XSTRNG=814				!ASSUME STRUC BLOCKS.
      IF(MOD(MDIR,180).EQ.0) RETURN		!IF MIRROR N-S, DONE.
8300	LDIR=MDIR				!SEE WHICH MIRROR.
      IF(PRSO.EQ.XSOUTH) LDIR=180
      XSTRNG=815				!MIRROR BLOCKS.
      IF(((LDIR.GT.180).AND..NOT.MR1F).OR.
     *  ((LDIR.LT.180).AND..NOT.MR2F)) XSTRNG=816 !MIRROR BROKEN.
      RETURN
C
C C9-	FROBOZZ FLAG (MIRIN)
C
9000	IF(MRHERE(HERE).NE.1) GO TO 9100	!MIRROR 1 HERE?
      IF(MR1F) XSTRNG=805			!SEE IF BROKEN.
      FROBZF=MROPNF				!ENTER IF OPEN.
      RETURN
C
9100	FROBZF=.FALSE.				!NOT HERE,
      XSTRNG=817				!LOSE.
      RETURN
C CXAPPL, PAGE 4
C
C C10-	FROBOZZ FLAG (MIRROR EXIT)
C
10000	FROBZF=.FALSE.				!ASSUME CANT.
      LDIR=((PRSO-XNORTH)/XNORTH)*45		!XLATE DIR TO DEGREES.
      IF(.NOT.MROPNF .OR.
     *	((MOD(MDIR+270,360).NE.LDIR).AND.(PRSO.NE.XEXIT)))
     *	GO TO 10200			!EXIT VIA MIRROR?
      XROOM1=((MLOC-MRA)*2)+MRAE+1-(MDIR/180)	!ASSUME E-W EXIT.
      IF(MOD(MDIR,180).EQ.0) GO TO 10100	!IF N-S, OK.
      XROOM1=MLOC+1				!ASSUME N EXIT.
      IF(MDIR.GT.180) XROOM1=MLOC-1		!IF SOUTH.
10100	CXAPPL=XROOM1
      RETURN
C
10200	IF(.NOT.WDOPNF .OR.
     *	((MOD(MDIR+180,360).NE.LDIR).AND.(PRSO.NE.XEXIT)))
     *	RETURN				!EXIT VIA OPEN DOOR?
      XROOM1=MLOC+1				!ASSUME N.
      IF(MDIR.EQ.0) XROOM1=MLOC-1		!IF S.
      CALL RSPEAK(818)			!CLOSE DOOR.
      WDOPNF=.FALSE.
      CXAPPL=XROOM1
      RETURN
C
C C11-	MAYBE DOOR.  NORMAL MESSAGE IS THAT DOOR IS CLOSED.
C	BUT IF LCELL.NE.4, DOOR ISNT THERE.
C
11000	IF(LCELL.NE.4) XSTRNG=678		!SET UP MSG.
      RETURN
C
C C12-	FROBZF (PUZZLE ROOM MAIN ENTRANCE)
C
12000	FROBZF=.TRUE.				!ALWAYS ENTER.
      CPHERE=10				!SET SUBSTATE.
      RETURN
C
C C13-	CPOUTF (PUZZLE ROOM SIZE ENTRANCE)
C
13000	CPHERE=52				!SET SUBSTATE.
      RETURN
C CXAPPL, PAGE 5
C
C C14-	FROBZF (PUZZLE ROOM TRANSITIONS)
C
14000	FROBZF=.FALSE.				!ASSSUME LOSE.
      IF(PRSO.NE.XUP) GO TO 14100		!UP?
      IF(CPHERE.NE.10) RETURN			!AT EXIT?
      XSTRNG=881				!ASSUME NO LADDER.
      IF(CPVEC(CPHERE+1).NE.-2) RETURN	!LADDER HERE?
      CALL RSPEAK(882)			!YOU WIN.
      FROBZF=.TRUE.				!LET HIM OUT.
      RETURN
C
14100	IF((CPHERE.NE.52).OR.(PRSO.NE.XWEST).OR..NOT.CPOUTF)
     *	GO TO 14200			!W EXIT AT DOOR?
      FROBZF=.TRUE.				!YES, LET HIM OUT.
      RETURN
C
14200	DO 14300 I=1,16,2			!LOCATE EXIT.
        IF(PRSO.EQ.CPDR(I)) GO TO 14400
14300	CONTINUE
      RETURN					!NO SUCH EXIT.
C
14400	J=CPDR(I+1)				!GET DIRECTIONAL OFFSET.
      NXT=CPHERE+J				!GET NEXT STATE.
      K=8					!GET ORTHOGONAL DIR.
      IF(J.LT.0) K=-8
      IF((((IABS(J).EQ.1).OR.(IABS(J).EQ.8)).OR.
     *   ((CPVEC(CPHERE+K).EQ.0).OR.(CPVEC(NXT-K).EQ.0))).AND.
     *    (CPVEC(NXT).EQ.0)) GO TO 14500	!CANT DO IT?
      RETURN
C
14500	CALL CPGOTO(NXT)			!MOVE TO STATE.
      XROOM1=CPUZZ				!STAY IN ROOM.
      CXAPPL=XROOM1
      RETURN
C
      END
