/* Object processors for DUNGEON */

/* COPYRIGHT 1980, 1990, INFOCOM COMPUTERS AND COMMUNICATIONS, CAMBRIDGE MA. */
/* ALL RIGHTS RESERVED, COMMERCIAL USAGE STRICTLY PROHIBITED */
/* WRITTEN BY R. M. SUPNIK */
/* Translated from Fortran to C by Andrew Plotkin <erkyrath@netcom.com>
   on 10/4/98. */

/* 29-Sep-94     RMS     Fixed bugs in KILL MASTER, palantir, dial button, */
/*                       well, slide, bat, global brochure, granite wall, */
/*                       bottle, leaves, broken lamp, beam, robot, thief, */
/*                       troll, me, subscripting, object substitution. */
/*                       Added features to heads, coke bottles, balloon, */
/*                       bucket, stove. */
/* 30-Jan-94     RMS     Fixed bugs from MS-DOS port. */
/* 25-Jan-94     RMS     Added ground = sand at sandy beach. */
/* 30-Jun-92     RMS     Changed file names to lower case. */

#include "glk.h"
#include "miscfort.h"
#include "funcs.h"
#include "commons.h"

/* OAPPLI- Object action routines */

/* Declarations */

logical oappli_(integer *ri, integer *arg)
{
    /* System generated locals */
    integer i__1;
    logical ret_val;

    /* Local variables */
    logical waslit;
    logical f;
    integer av, flobts;
    integer i__;
    integer nloc, j, x;
    integer odo2, odi2;


/* Functions and data */


    if (*ri == 0) {
        goto L10;
    }
/* zero is false app. */
    if (*ri <= 99) {
        goto L100;
    }
/* simple object? */
    odo2 = 0;
    odi2 = 0;
    if (prsvec_1.prso != 0 && prsvec_1.prso <= 300) {
        odo2 = objcts_1.odesc2[prsvec_1.prso - 1];
    }
    if (prsvec_1.prsi != 0) {
        odi2 = objcts_1.odesc2[prsvec_1.prsi - 1];
    }
    av = advs_1.avehic[play_1.winner - 1];
    flobts = 73;
    ret_val = TRUE_;
    waslit = lit_(&play_1.here);

    switch (*ri - 99) {
        case 1:  goto L2000;
        case 2:  goto L5000;
        case 3:  goto L10000;
        case 4:  goto L11000;
        case 5:  goto L12000;
        case 6:  goto L15000;
        case 7:  goto L18000;
        case 8:  goto L19000;
        case 9:  goto L20000;
        case 10:  goto L22000;
        case 11:  goto L25000;
        case 12:  goto L26000;
        case 13:  goto L32000;
        case 14:  goto L35000;
        case 15:  goto L39000;
        case 16:  goto L40000;
        case 17:  goto L45000;
        case 18:  goto L47000;
        case 19:  goto L48000;
        case 20:  goto L49000;
        case 21:  goto L50000;
        case 22:  goto L51000;
        case 23:  goto L52000;
        case 24:  goto L54000;
        case 25:  goto L55000;
        case 26:  goto L56000;
        case 27:  goto L57000;
        case 28:  goto L58000;
        case 29:  goto L59000;
        case 30:  goto L60000;
        case 31:  goto L61000;
        case 32:  goto L62000;
    }
    bug_(&c__6, ri);

/* Return here to declare false result. */

L10:
    ret_val = FALSE_;
    return ret_val;

/* Return here to test for light source change. */

L50:
    if (waslit && ! lit_(&play_1.here)) {
        rspeak_(&c__406);
    }
    return ret_val;

/* Simple objects, processed externally. */

L100:
    if (*ri < 32) {
        ret_val = sobjs_(ri, arg);
    }
    if (*ri >= 32) {
        ret_val = nobjs_(ri, arg);
    }
    return ret_val;
/* OAPPLI, PAGE 3 */

/* O100--        Machine */

L2000:
    if (play_1.here != 77) {
        goto L10;
    }
/* not here? f */
    ret_val = opncls_(&c__7, &c__123, &c__124);
/* handle opn/cls. */
    return ret_val;

/* O101--        Water */

L5000:
    if (prsvec_1.prsa != 86) {
        goto L5025;
    }
/* go through? */
    i__1 = rnd_(&c__3) + 331;
    rspeak_(&i__1);
/* joke. */
    return ret_val;

L5025:
    if (prsvec_1.prso == 11 || prsvec_1.prso == 273) {
        goto L5100;
    }
    rspeak_(&c__561);
/* water is ind obj, */
    return ret_val;

/* punt. */
L5100:
    if (prsvec_1.prsa != 132) {
        goto L5400;
    }
/* take water? */
    if (prsvec_1.prsi != 0) {
        goto L5200;
    }
/* from x? */
    if (objcts_1.oadv[9] == play_1.winner && objcts_1.ocan[prsvec_1.prso - 1] 
            != 10) {
        goto L5500;
    }
/* take, have bottle -> p */
    if (objcts_1.ocan[prsvec_1.prso - 1] != 10) {
        goto L5150;
    }
/* water in bottle? */
    if (objcts_1.oadv[9] != play_1.winner) {
        goto L5125;
    }
/* already have bottle? */
    rspeak_(&c__103);
/* yes, already have wate */
    return ret_val;

L5125:
    prsvec_1.prso = 10;
/* take bottle. */
    goto L10;

/* do normal take. */
L5150:
    if (objcts_1.ocan[prsvec_1.prso - 1] == 0) {
        goto L5300;
    }
/* if not inside, take. */
    prsvec_1.prsi = objcts_1.ocan[prsvec_1.prso - 1];
/* make into take from. */
    goto L5250;

/* check for open. */
L5200:
    if (objcts_1.ocan[prsvec_1.prso - 1] != prsvec_1.prsi) {
        goto L5250;
    }
/* is it inside? */
    rspeak_(&c__1038);
/* not in that. */
    return ret_val;

L5250:
    if ((objcts_1.oflag2[prsvec_1.prsi - 1] & 8) != 0) {
        goto L5300;
    }
/* is it open? */
    rspsub_(&c__525, &odi2);
/* no, not open. */
    return ret_val;

L5300:
    if (av != 0) {
        goto L5800;
    }
/* if in vehicle, put the */
    i__ = 615;
/* assume player. */
    if (play_1.winner != 1) {
        i__ = 1081;
    }
    rspeak_(&i__);
/* slips thru fingers. */
    return ret_val;

L5400:
    if (prsvec_1.prsa != 144) {
        goto L5700;
    }
/* put water in x? */
    if (prsvec_1.prsi == 10) {
        goto L5500;
    }
/* in bottle? */
    if ((objcts_1.oflag2[prsvec_1.prsi - 1] & 2) != 0 || (av != 0 && 
            prsvec_1.prsi == av)) {
        goto L5450;
    }
/* in veh? */
    rspsub_(&c__297, &odi2);
/* wont go elsewhere. */
    newsta_(&prsvec_1.prso, &c__0, &c__0, &c__0, &c__0);
/* vanish water. */
    return ret_val;

L5450:
    newsta_(&c__11, &c__0, &c__0, &prsvec_1.prsi, &c__0);
/* water into vehicle. */
    rspsub_(&c__296, &objcts_1.odesc2[prsvec_1.prsi - 1]);
/* describe. */
    return ret_val;

L5500:
    if ((objcts_1.oflag2[c__10 - 1] & 8) != 0) {
        goto L5550;
    }
/* bottle open? */
    rspeak_(&c__612);
/* no, lose. */
    return ret_val;

L5550:
    if (qempty_(&c__10)) {
        goto L5600;
    }
/* open, empty? */
    rspeak_(&c__613);
/* no, already full. */
    return ret_val;

L5600:
    newsta_(&c__11, &c__614, &c__0, &c__10, &c__0);
/* take water to bottle. */
    return ret_val;

L5700:
    if (prsvec_1.prsa != 145 && prsvec_1.prsa != 147) {
        goto L5900;
    }
/* drop, pour? */
    if (av != 0) {
        goto L5800;
    }
/* into vehicle? */
    newsta_(&prsvec_1.prso, &c__133, &c__0, &c__0, &c__0);
/* no, vanishes. */
    return ret_val;

L5800:
    newsta_(&c__11, &c__0, &c__0, &av, &c__0);
/* water into his vehicle */
    rspsub_(&c__296, &objcts_1.odesc2[av - 1]);
/* describe. */
    return ret_val;

L5900:
    if (prsvec_1.prsa != 148) {
        goto L10;
    }
/* last chance, throw? */
    newsta_(&prsvec_1.prso, &c__132, &c__0, &c__0, &c__0);
/* vanishes. */
    return ret_val;
/* OAPPLI, PAGE 4 */

/* O102--        Leaf pile */

L10000:
    if (prsvec_1.prsa != 137) {
        goto L10500;
    }
/* burn? */
    if ((objcts_1.oflag2[c__65 - 1] & 8) != 0 || findex_1.rvclr != 0) {
        goto L10050;
    }
    findex_1.rvclr = 1;
/* leaves moved. */
    newsta_(&c__65, &c__30, &play_1.here, &c__0, &c__0);
/* grating appears. */
L10050:
    if (objcts_1.oadv[prsvec_1.prso - 1] == 1) {
        goto L10100;
    }
/* was he carrying? */
    newsta_(&c__18, &c__158, &c__0, &c__0, &c__0);
/* no, burn leaves. */
    return ret_val;

L10100:
    newsta_(&c__18, &c__0, &play_1.here, &c__0, &c__0);
/* drop leaves. */
    if (play_1.here == 147) {
        newsta_(&c__18, &c__0, &c__33, &c__0, &c__0);
    }
    jigsup_(&c__159);
/* burn him. */
    return ret_val;

L10500:
    if (prsvec_1.prsa != 122) {
        goto L10600;
    }
/* move? */
    rspeak_(&c__2);
/* done. */
L10550:
    if ((objcts_1.oflag2[c__65 - 1] & 8) != 0 || findex_1.rvclr != 0) {
        return ret_val;
    }
/* done before? */
    findex_1.rvclr = 1;
/* leaves moved. */
    newsta_(&c__65, &c__30, &play_1.here, &c__0, &c__0);
/* grating appears. */
    return ret_val;

L10600:
    if (prsvec_1.prsa != 132) {
        goto L10700;
    }
/* take? */
    ret_val = FALSE_;
/* don't handle here. */
    goto L10550;

/* make grate visible. */
L10700:
    if (prsvec_1.prsa != 153 || (objcts_1.oflag2[c__65 - 1] & 8) != 0 || 
            findex_1.rvclr != 0) {
        goto L10;
    }
    rspeak_(&c__344);
/* look under? */
    return ret_val;

/* O103--        Troll, done externally. */

L11000:
    ret_val = trollp_(arg);
/* troll processor. */
    goto L50;

/* O104--        Rusty knife. */

/* go see if now dark. */
L12000:
    if (prsvec_1.prsa != 132) {
        goto L12100;
    }
/* take? */
    if (objcts_1.oadv[13] == play_1.winner) {
        rspeak_(&c__160);
    }
/* pulse sword. */
    goto L10;

L12100:
    if (((prsvec_1.prsa != 141 && prsvec_1.prsa != 139) || prsvec_1.prsi != 
            24) && ((prsvec_1.prsa != 140 && prsvec_1.prsa != 148) || 
            prsvec_1.prso != 24)) {
        goto L10;
    }
    newsta_(&c__24, &c__0, &c__0, &c__0, &c__0);
/* kill knife. */
    jigsup_(&c__161);
/* kill him. */
    return ret_val;
/* OAPPLI, PAGE 5 */

/* O105--        Glacier */

L15000:
    if (prsvec_1.prsa != 148) {
        goto L15500;
    }
/* throw? */
    if (prsvec_1.prso != 34) {
        goto L15400;
    }
/* torch? */
    newsta_(&c__30, &c__169, &c__0, &c__0, &c__0);
/* melt ice. */
    objcts_1.odesc1[33] = 174;
/* mung torch. */
    objcts_1.odesc2[33] = 173;
    objcts_1.oflag1[33] = objcts_1.oflag1[33] & ~ flobts;
    newsta_(&c__34, &c__0, &c__42, &c__0, &c__0);
/* move torch. */
    findex_1.glacrf = TRUE_;
/* glacier gone. */
    if (! lit_(&play_1.here)) {
        rspeak_(&c__170);
    }
/* in dark? */
    return ret_val;

L15400:
    rspeak_(&c__171);
/* joke if not torch. */
    goto L10;

/* don't handle. */
L15500:
    if (prsvec_1.prsa != 101 || prsvec_1.prso != 30) {
        goto L10;
    }
    if ((objcts_1.oflag1[prsvec_1.prsi - 1] & flobts) == flobts) {
        goto L15600;
    }
    rspsub_(&c__298, &odi2);
/* cant melt with that. */
    return ret_val;

L15600:
    findex_1.glacmf = TRUE_;
/* partial melt. */
    if (prsvec_1.prsi != 34) {
        goto L15700;
    }
/* melt with torch? */
    objcts_1.odesc1[33] = 174;
/* mung torch. */
    objcts_1.odesc2[33] = 173;
    objcts_1.oflag1[33] = objcts_1.oflag1[33] & ~ flobts;
L15700:
    jigsup_(&c__172);
/* drown. */
    return ret_val;

/* O106--        Black book */

L18000:
    if (prsvec_1.prsa != 125 || prsvec_1.prso != 47) {
        goto L18100;
    }
/* open book? */
    rspeak_(&c__180);
/* joke. */
    return ret_val;

L18100:
    if (prsvec_1.prsa != 126) {
        goto L18200;
    }
/* close? */
    rspeak_(&c__181);
    return ret_val;

L18200:
    if (prsvec_1.prsa != 137) {
        goto L10;
    }
/* burn? */
    newsta_(&c__47, &c__0, &c__0, &c__0, &c__0);
/* vanish book. */
    jigsup_(&c__182);
/* fatal joke. */
    return ret_val;
/* OAPPLI, PAGE 6 */

/* O107--        Candles */

L19000:
    if (findex_1.orcand != 0) {
        goto L19100;
    }
/* first ref? */
    findex_1.orcand = 1;
/* yes, candles are */
    cevent_1.cflag[4] = TRUE_;
    cevent_1.ctick[4] = 50;

/* burning when seen. */
L19100:
    if (prsvec_1.prsi == 48) {
        goto L10;
    }
/* ignore ind refs. */
    if (prsvec_1.prsa != 124) {
        goto L19200;
    }
/* turn off? */
    i__ = 513;
/* assume off. */
    if ((objcts_1.oflag1[c__48 - 1] & 1) != 0) {
        i__ = 514;
    }
/* if on, different. */
    cevent_1.cflag[4] = FALSE_;
/* disable countdown. */
    objcts_1.oflag1[47] = objcts_1.oflag1[47] & -2;
    rspeak_(&i__);
    goto L50;

/* go see if now dark. */
L19200:
    if (prsvec_1.prsa != 137 && prsvec_1.prsa != 123) {
        goto L10;
    }
    if ((objcts_1.oflag1[47] & 64) != 0) {
        goto L19300;
    }
    rspeak_(&c__515);
/* candles too short. */
    return ret_val;

L19300:
    if (prsvec_1.prsi != 0) {
        goto L19400;
    }
/* any flame? */
    rspeak_(&c__516);
/* no, lose. */
    orphan_(&c_n1, &prssta_1.act, &prssta_1.prep1, &c__48, &c__2, " ", &c__0, 
            &c__0, 1L);
/* orphan "light candle w */
    prsvec_1.prswon = FALSE_;
    prsvec_1.prscon = 0;
    return ret_val;

L19400:
    if (prsvec_1.prsi != 51 || ! ((objcts_1.oflag1[c__51 - 1] & 1) != 0)) {
        goto L19500;
    }
    i__ = 517;
/* assume off. */
    if ((objcts_1.oflag1[c__48 - 1] & 1) != 0) {
        i__ = 518;
    }
/* if on, joke. */
    objcts_1.oflag1[47] = objcts_1.oflag1[47] | 1;
/* lite candles. */
    cevent_1.cflag[4] = TRUE_;
/* resume countdown. */
    rspeak_(&i__);
    return ret_val;

L19500:
    if (prsvec_1.prsi != 34 || ! ((objcts_1.oflag1[c__34 - 1] & 1) != 0)) {
        goto L19600;
    }
    if ((objcts_1.oflag1[c__48 - 1] & 1) != 0) {
        goto L19700;
    }
/* already on? */
    newsta_(&c__48, &c__521, &c__0, &c__0, &c__0);
/* no, vaporize. */
    return ret_val;

L19600:
    rspeak_(&c__519);
/* cant light with that. */
    return ret_val;

L19700:
    rspeak_(&c__520);
/* already on. */
    return ret_val;

/* O108--        Matches */

L20000:
    if (prsvec_1.prsa != 123 || prsvec_1.prso != 51) {
        goto L20500;
    }
    if (findex_1.ormtch != 0) {
        goto L20100;
    }
/* any matches left? */
    rspeak_(&c__183);
/* no, lose. */
    return ret_val;

L20100:
    --findex_1.ormtch;
/* decrement no matches. */
    objcts_1.oflag1[50] = objcts_1.oflag1[50] | flobts;
    cevent_1.cflag[3] = TRUE_;
    cevent_1.ctick[3] = 2;
/* countdown. */
    rspeak_(&c__184);
    return ret_val;

L20500:
    if (prsvec_1.prsa != 124 || (objcts_1.oflag1[50] & 1) == 0) {
        goto L10;
    }
/* extinguish? */
    objcts_1.oflag1[50] = objcts_1.oflag1[50] & ~ flobts;
    cevent_1.ctick[3] = 0;
    rspeak_(&c__185);
    goto L50;

/* O109--        Cyclops, processed externally. */

/* go see if now dark. */
L22000:
    ret_val = cyclop_(arg);
/* cyclops */
    goto L50;

/* O110--        Thief, processed externally. */

/* go see if now dark. */
L25000:
    ret_val = thiefp_(arg);
    goto L50;

/* O111--        Window */

/* go see if now dark. */
L26000:
    ret_val = opncls_(&c__63, &c__208, &c__209);
/* open/cls window. */
    return ret_val;

/* O112--        Pile of bodies */

L32000:
    if (prsvec_1.prsa != 132) {
        goto L32500;
    }
/* take? */
    rspeak_(&c__228);
/* cant. */
    return ret_val;

L32500:
    if (prsvec_1.prsa != 137 && prsvec_1.prsa != 138) {
        goto L10;
    }
    if (findex_1.onpolf) {
        return ret_val;
    }
/* burn or mung? */
    findex_1.onpolf = TRUE_;
/* set head on pole. */
    newsta_(&c__71, &c__0, &c__94, &c__0, &c__0);
    jigsup_(&c__229);
/* beheaded. */
    return ret_val;

/* O113--        Vampire bat */

L35000:
    rspeak_(&c__50);
/* time to fly, jack. */
    f = moveto_(&misc_1.batdrp[rnd_(&c__9)], &play_1.winner);
/* select random dest. */
    f = rmdesc_(&c__0);
    prsvec_1.prscon = 0;
/* disable parser. */
    return ret_val;
/* OAPPLI, PAGE 7 */

/* O114--        Stick */

L39000:
    if (prsvec_1.prsa != 108) {
        goto L10;
    }
/* wave? */
    if (play_1.here == 121) {
        goto L39500;
    }
/* on rainbow? */
    if (play_1.here == 122 || play_1.here == 120) {
        goto L39200;
    }
    rspeak_(&c__244);
/* nothing happens. */
    return ret_val;

L39200:
    objcts_1.oflag1[84] = objcts_1.oflag1[84] | 32768;
/* make gold visible. */
    findex_1.rainbf = ! findex_1.rainbf;
/* complement rainbow. */
    i__ = 245;
/* assume off. */
    if (findex_1.rainbf) {
        i__ = 246;
    }
/* if on, solid. */
    rspeak_(&i__);
/* describe. */
    return ret_val;

L39500:
    findex_1.rainbf = FALSE_;
/* on rainbow, */
    jigsup_(&c__247);
/* take a fall. */
    return ret_val;

/* O115--        Balloon, handled externally. */

L40000:
    ret_val = ballop_(arg);
    return ret_val;

/* O116--        Heads */

L45000:
    if (prsvec_1.prsa != 151) {
        goto L45100;
    }
/* hello heads? */
    rspeak_(&c__633);
/* truly bizarre. */
    return ret_val;

L45100:
    if (prsvec_1.prsa != 139 && prsvec_1.prsa != 138 && prsvec_1.prsa != 111 
            && prsvec_1.prsa != 125 && prsvec_1.prsa != 132 && prsvec_1.prsa 
            != 137 && prsvec_1.prsa != 129 && prsvec_1.prsa != 141 && 
            prsvec_1.prsa != 107) {
        goto L10;
    }
    rspeak_(&c__260);
/* bad news for player */
    i__ = robadv_(&play_1.winner, &c__0, &c__123, &c__0) + robrm_(&
            play_1.here, &c__100, &c__0, &c__123, &c__0);
    if (i__ != 0) {
        newsta_(&c__123, &c__0, &c__8, &c__0, &c__0);
    }
/* if robbed, make large */
    jigsup_(&c__261);
/* kill him. */
    return ret_val;
/* OAPPLI, PAGE 8 */

/* O117--        Sphere */

L47000:
    if (findex_1.cagesf || prsvec_1.prsa != 132) {
        goto L47600;
    }
/* take? */
    if (play_1.winner != 1) {
        goto L47500;
    }
/* robot take? */
    rspeak_(&c__263);
/* no, drop cage. */
    if (objcts_1.oroom[141] != play_1.here) {
        goto L47200;
    }
/* robot here? */
    f = moveto_(&c__141, &play_1.winner);
/* yes, move into cage. */
    newsta_(&c__142, &c__0, &c__141, &c__0, &c__0);
/* move robot. */
    advs_1.aroom[1] = 141;
    objcts_1.oflag1[141] = objcts_1.oflag1[141] | 512;
/* don't describe robot. */
    cevent_1.cflag[13] = TRUE_;
    cevent_1.ctick[13] = 10;
/* get out in 10 or else. */
    return ret_val;

L47200:
    newsta_(&c__126, &c__0, &c__0, &c__0, &c__0);
/* you're dead. */
    rooms_1.rflag[139] = rooms_1.rflag[139] | 256;
/* mung cage room. */
    rooms_1.rdesc1[139] = 147;
    jigsup_(&c__148);
/* mung player. */
    return ret_val;

L47500:
    newsta_(&c__126, &c__0, &c__0, &c__0, &c__0);
/* robot tried, */
    newsta_(&c__142, &c__264, &c__0, &c__0, &c__0);
/* kill him. */
    newsta_(&c__124, &c__0, &play_1.here, &c__0, &c__0);
/* insert mangled cage. */
    goto L50;

/* go see if now dark. */
L47600:
    if (prsvec_1.prsa != 152) {
        goto L10;
    }
/* look in? */
    ret_val = nobjs_(&objcts_1.oactio[205], arg);
/* do palantir function. */
    return ret_val;

/* O118--        Geometrical buttons */

L48000:
    if (prsvec_1.prsa != 112) {
        goto L10;
    }
/* push? */
    i__ = prsvec_1.prso - 126;
/* get button index. */
    if (i__ <= 0 || i__ >= 4) {
        goto L10;
    }
/* a button? */
    if (play_1.winner != 1) {
        switch (i__) {
            case 1:  goto L48100;
            case 2:  goto L48200;
            case 3:  goto L48300;
        }
    }
    jigsup_(&c__265);
/* you pushed, you die. */
    return ret_val;

L48100:
    i__ = 267;
/* square, speed up. */
    if (findex_1.carozf) {
        i__ = 266;
    }
    findex_1.carozf = TRUE_;
    rspeak_(&i__);
    return ret_val;

L48200:
    i__ = 266;
/* round, slow down. */
    if (findex_1.carozf) {
        i__ = 268;
    }
    findex_1.carozf = FALSE_;
    rspeak_(&i__);
    return ret_val;

L48300:
    findex_1.caroff = ! findex_1.caroff;
/* triangle, flip carouse */
    if (objcts_1.oroom[38] != 83) {
        goto L48400;
    }
/* iron box in carousel? */
    rspeak_(&c__269);
/* yes, thump. */
    objcts_1.oflag1[38] ^= 32768;
/* complement visibility. */
    if (findex_1.caroff) {
        rooms_1.rflag[82] = rooms_1.rflag[82] & -32769;
    }
    return ret_val;

L48400:
    rspeak_(&c__232);
/* click. */
    return ret_val;

/* O119--        Flask function */

L49000:
    if (prsvec_1.prsa == 125) {
        goto L49100;
    }
/* open? */
    if (prsvec_1.prsa != 138 && prsvec_1.prsa != 148) {
        goto L10;
    }
    newsta_(&c__132, &c__270, &c__0, &c__0, &c__0);
/* kill flask. */
L49100:
    rooms_1.rflag[play_1.here - 1] = rooms_1.rflag[play_1.here - 1] | 256;
/* mung room. */
    rooms_1.rdesc1[play_1.here - 1] = 271;
    jigsup_(&c__272);
/* poisoned. */
    return ret_val;

/* O120--        Bucket function */

L50000:
    if (*arg == 1) {
        goto L10;
    }
/* read in? */
    if (*arg == 2) {
        goto L50400;
    }
/* read out? */
    if (prsvec_1.prsa != 137) {
        goto L50100;
    }
/* burn? */
    rspeak_(&c__928);
/* can't. */
    return ret_val;

L50100:
    if (prsvec_1.prsa != 107) {
        goto L10;
    }
/* kick? */
    jigsup_(&c__1067);
/* dead. */
    return ret_val;

L50400:
    if (objcts_1.ocan[10] != 137 || findex_1.bucktf) {
        goto L50500;
    }
    findex_1.bucktf = TRUE_;
/* bucket at top. */
    cevent_1.cflag[12] = TRUE_;
    cevent_1.ctick[12] = 100;
/* start countdown. */
    newsta_(&c__137, &c__290, &c__142, &c__0, &c__0);
/* reposition bucket. */
    goto L50900;

/* finish up. */
L50500:
    if (objcts_1.ocan[10] == 137 || ! findex_1.bucktf) {
        goto L10;
    }
    findex_1.bucktf = FALSE_;
    newsta_(&c__137, &c__291, &c__143, &c__0, &c__0);
/* bucket at bottom. */
L50900:
    if (av != 137) {
        return ret_val;
    }
/* not in bucket? */
    f = moveto_(&objcts_1.oroom[136], &play_1.winner);
/* move adventurer. */
    f = rmdesc_(&c__0);
/* describe room. */
    return ret_val;
/* OAPPLI, PAGE 9 */

/* O121--        Eatme cake */

L51000:
    if (prsvec_1.prsa != 135 || prsvec_1.prso != 138 || play_1.here != 144) {
        goto L10;
    }
/* eat cake in aliceroom? */
    newsta_(&c__138, &c__273, &c__0, &c__0, &c__0);
/* vanish cake. */
    objcts_1.oflag1[141] = objcts_1.oflag1[141] & -32769;
/* vanish robot. */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* make objects big. */
        if (objcts_1.oroom[i__ - 1] != 144 || objcts_1.osize[i__ - 1] == 
                10000) {
            goto L51100;
        }
        objcts_1.osize[i__ - 1] <<= 6;
        objcts_1.oroom[i__ - 1] = 145;
L51100:
        ;
    }
    ret_val = moveto_(&c__145, &play_1.winner);
/* move to alice small. */
    return ret_val;

/* O122--        Icings */

L52000:
    if (prsvec_1.prsa != 100) {
        goto L52200;
    }
/* read? */
    i__ = 274;
/* cant read. */
    if (prsvec_1.prsi != 0) {
        i__ = 275;
    }
/* through something? */
    if (prsvec_1.prsi == 10) {
        i__ = 276;
    }
/* through bottle? */
    if (prsvec_1.prsi == 132) {
        i__ = prsvec_1.prso + 138;
    }
/* through flask? */
    rspeak_(&i__);
/* read flask. */
    return ret_val;

L52200:
    if (prsvec_1.prsa != 148 || prsvec_1.prso != 140 || prsvec_1.prsi != 133) 
            {
        goto L52300;
    }
/* throw rdice at pool? */
    newsta_(&c__133, &c__280, &c__0, &c__0, &c__0);
/* vanish pool. */
    objcts_1.oflag1[133] = objcts_1.oflag1[133] | 32768;
/* materialize spices. */
    return ret_val;

L52300:
    if (play_1.here != 144 && play_1.here != 145 && play_1.here != 146) {
        goto L10;
    }
/* in wonderland? */
    if ((prsvec_1.prsa != 135 && prsvec_1.prsa != 148) || prsvec_1.prso != 
            139) {
        goto L52400;
    }
/* throw orange ice? */
    newsta_(&c__139, &c__0, &c__0, &c__0, &c__0);
/* vanish orange ice. */
    rooms_1.rflag[play_1.here - 1] = rooms_1.rflag[play_1.here - 1] | 256;
/* vanish room. */
    rooms_1.rdesc1[play_1.here - 1] = 281;
    jigsup_(&c__282);
/* vanish adventurer. */
    return ret_val;

L52400:
    if (prsvec_1.prsa != 135 || prsvec_1.prso != 141) {
        goto L10;
    }
/* eat blue ice? */
    newsta_(&c__141, &c__283, &c__0, &c__0, &c__0);
/* vanish blue ice. */
    if (play_1.here != 145) {
        goto L52500;
    }
/* in reduced room? */
    objcts_1.oflag1[141] = objcts_1.oflag1[141] | 32768;
/* materialize robot. */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* enlarge world. */
        if (objcts_1.oroom[i__ - 1] != play_1.here || objcts_1.osize[i__ - 1] 
                == 10000) {
            goto L52450;
        }
        objcts_1.oroom[i__ - 1] = 144;
        objcts_1.osize[i__ - 1] /= 64;
L52450:
        ;
    }
    ret_val = moveto_(&c__144, &play_1.winner);
/* return */
    return ret_val;

L52500:
    jigsup_(&c__284);
/* enlarged in wrong room */
    return ret_val;

/* O123--        Brick */

L54000:
    if (prsvec_1.prsa != 137) {
        goto L10;
    }
/* burn? */
    newsta_(&c__109, &c__0, &c__0, &c__0, &c__0);
/* vanish brick. */
    jigsup_(&c__150);
/* boom! */
    return ret_val;

/* O124--        Myself */

L55000:
    if (prsvec_1.prsa != 146 || (objcts_1.oflag2[prsvec_1.prso - 1] & 16) != 
            0) {
        goto L55100;
    }
/* give? */
    if (prsvec_1.prso != 11) {
        goto L55050;
    }
/* water? */
    newsta_(&c__11, &c__615, &c__0, &c__0, &c__0);
/* slips through fingers. */
    return ret_val;

L55050:
    newsta_(&prsvec_1.prso, &c__2, &c__0, &c__0, &c__1);
/* done. */
    return ret_val;

L55100:
    if (prsvec_1.prsa != 132) {
        goto L55200;
    }
/* take? */
    rspeak_(&c__286);
/* joke. */
    return ret_val;

L55200:
    if ((prsvec_1.prsa != 139 && prsvec_1.prsa != 138) || prsvec_1.prso != 
            251) {
        goto L10;
    }
    play_1.winner = 1;
/* can't kill someone els */
    jigsup_(&c__287);
/* kill, no joke. */
    return ret_val;
/* OAPPLI, PAGE 10 */

/* O125--        Panels inside mirror */

L56000:
    if (prsvec_1.prsa != 112) {
        goto L10;
    }
/* push? */
    if (findex_1.poleuf != 0) {
        goto L56100;
    }
/* short pole up? */
    i__ = 731;
/* no, wont budge. */
    if (findex_1.mdir % 180 == 0) {
        i__ = 732;
    }
/* diff msg if n-s. */
    rspeak_(&i__);
/* tell wont move. */
    return ret_val;

L56100:
    if (findex_1.mloc != 164) {
        goto L56200;
    }
/* in gdn room? */
    rspeak_(&c__733);
/* you lose. */
    jigsup_(&c__685);
    return ret_val;

L56200:
    i__ = 831;
/* rotate l or r. */
    if (prsvec_1.prso == 161 || prsvec_1.prso == 159) {
        i__ = 830;
    }
    rspeak_(&i__);
/* tell direction. */
    findex_1.mdir = (findex_1.mdir + 45 + (i__ - 830) * 270) % 360;
/* calculate new dir. */
    i__1 = findex_1.mdir / 45 + 695;
    rspsub_(&c__734, &i__1);
/* tell new dir. */
    if (findex_1.wdopnf) {
        rspeak_(&c__730);
    }
/* if panel open, close. */
    findex_1.wdopnf = FALSE_;
    return ret_val;

/* O126--        Ends inside mirror */

/* done. */
L57000:
    if (prsvec_1.prsa != 112) {
        goto L10;
    }
/* push? */
    if (findex_1.mdir % 180 == 0) {
        goto L57100;
    }
/* mirror n-s? */
    rspeak_(&c__735);
/* no, wont budge. */
    return ret_val;

L57100:
    if (prsvec_1.prso != 164) {
        goto L57300;
    }
/* push pine wall? */
    if ((findex_1.mloc == 163 && findex_1.mdir == 180) || (findex_1.mloc == 
            165 && findex_1.mdir == 0) || findex_1.mloc == 164) {
        goto L57200;
    }
/* in view of gdn? */
    rspeak_(&c__736);
/* no, opens. */
    findex_1.wdopnf = TRUE_;
/* indicate open. */
    cevent_1.cflag[21] = TRUE_;
/* time opening. */
    cevent_1.ctick[21] = 5;
    return ret_val;

L57200:
    rspeak_(&c__737);
/* gdn sees you, die. */
    jigsup_(&c__685);
    return ret_val;

L57300:
    nloc = findex_1.mloc - 1;
/* new loc if south. */
    if (findex_1.mdir == 0) {
        nloc = findex_1.mloc + 1;
    }
/* new loc if north. */
    if (nloc >= 161 && nloc <= 165) {
        goto L57400;
    }
    rspeak_(&c__738);
/* have reached end. */
    return ret_val;

L57400:
    i__ = 699;
/* assume south. */
    if (findex_1.mdir == 0) {
        i__ = 695;
    }
/* north. */
    j = 739;
/* assume smooth. */
    if (findex_1.poleuf != 0) {
        j = 740;
    }
/* pole up, wobbles. */
    rspsub_(&j, &i__);
/* describe. */
    findex_1.mloc = nloc;
    if (findex_1.mloc != 164) {
        return ret_val;
    }

/* now in gdn room? */
    if (findex_1.poleuf != 0) {
        goto L57500;
    }
/* pole up, gdn sees. */
    if (findex_1.mropnf || findex_1.wdopnf) {
        goto L57600;
    }
/* door open, gdn sees. */
    if (findex_1.mr1f && findex_1.mr2f) {
        return ret_val;
    }
/* mirrors intact, ok. */
    rspeak_(&c__742);
/* mirrors broken, die. */
    jigsup_(&c__743);
    return ret_val;

L57500:
    rspeak_(&c__741);
/* pole up, die. */
    jigsup_(&c__743);
    return ret_val;

L57600:
    rspeak_(&c__744);
/* door open, die. */
    jigsup_(&c__743);
    return ret_val;
/* OAPPLI, PAGE 11 */

/* O127--        Global guardians */

L58000:
    if (prsvec_1.prsa != 141 && prsvec_1.prsa != 139 && prsvec_1.prsa != 138) 
            {
        goto L58100;
    }
/* aggressive? */
    jigsup_(&c__745);
/* lose. */
    return ret_val;

L58100:
    if (prsvec_1.prsa != 151) {
        goto L10;
    }
/* hello? */
    rspeak_(&c__746);
/* no reply. */
    return ret_val;

/* O128--        Global master */

L59000:
    if ((prsvec_1.prsa != 141 && prsvec_1.prsa != 139 && prsvec_1.prsa != 138)
             || prsvec_1.prso != 279 || prsvec_1.prsi == 279) {
        goto L59100;
    }
/* kill master? */
    play_1.winner = 1;
/* rebounds on player. */
    jigsup_(&c__747);
/* bad idea. */
    return ret_val;

L59100:
    if (prsvec_1.prsa != 132) {
        goto L10;
    }
/* take? */
    rspeak_(&c__748);
/* joke. */
    return ret_val;

/* O129--        Numeral five */

L60000:
    if (prsvec_1.prsa != 132) {
        goto L10;
    }
/* take five? */
    rspeak_(&c__419);
/* time passes. */
    for (i__ = 1; i__ <= 3; ++i__) {
/* wait a while. */
        if (clockd_(&x)) {
            return ret_val;
        }
/* L60100: */
    }
    return ret_val;

/* O130--        Crypt function */

L61000:
    if (! findex_1.endgmf) {
        goto L45000;
    }
/* if not eg, die. */
    if (prsvec_1.prsa != 125) {
        goto L61100;
    }
/* open? */
    i__ = 793;
    if ((objcts_1.oflag2[c__119 - 1] & 8) != 0) {
        i__ = 794;
    }
    rspeak_(&i__);
    objcts_1.oflag2[118] = objcts_1.oflag2[118] | 8;
/* now tomb with view. */
    return ret_val;

L61100:
    if (prsvec_1.prsa != 126) {
        goto L45000;
    }
/* close? */
    i__ = 795;
    if ((objcts_1.oflag2[c__119 - 1] & 8) != 0) {
        i__ = 796;
    }
    rspeak_(&i__);
    objcts_1.oflag2[118] = objcts_1.oflag2[118] & -9;
    if (play_1.here != 157) {
        return ret_val;
    }
    cevent_1.cflag[19] = TRUE_;
    cevent_1.ctick[19] = 3;
/* if in crypt, start eg. */
    return ret_val;
/* OAPPLI, PAGE 12 */

/* O131--        Global ladder */

L62000:
    if (puzzle_1.cpvec[findex_1.cphere] == -2 || puzzle_1.cpvec[
            findex_1.cphere - 2] == -3) {
        goto L62100;
    }
/* ladder here? */
    rspeak_(&c__865);
/* no, lose. */
    return ret_val;

L62100:
    if (prsvec_1.prsa == 156 || prsvec_1.prsa == 157) {
        goto L62200;
    }
    rspeak_(&c__866);
/* climb it? */
    return ret_val;

L62200:
    if (findex_1.cphere == 10 && puzzle_1.cpvec[findex_1.cphere] == -2) {
        goto L62300;
    }
/* at exit? */
    rspeak_(&c__867);
/* no, hit your head. */
    return ret_val;

L62300:
    f = moveto_(&c__188, &play_1.winner);
/* to anteroom. */
    f = rmdesc_(&c__3);
/* describe. */
    return ret_val;

} /* oappli_ */



/* SOBJS-        Simple objects processor */

/* Declarations */

logical sobjs_(integer *ri, integer *arg)
{
    /* System generated locals */
    integer i__1;
    logical ret_val;

    /* Local variables */
    logical waslit, f;
    integer av;
    integer i__;
    integer mroom;
    integer odo2, odi2;


/* Functions and data */


    odo2 = 0;
    odi2 = 0;
    if (prsvec_1.prso != 0 && prsvec_1.prso <= 300) {
        odo2 = objcts_1.odesc2[prsvec_1.prso - 1];
    }
    if (prsvec_1.prsi != 0) {
        odi2 = objcts_1.odesc2[prsvec_1.prsi - 1];
    }
    av = advs_1.avehic[play_1.winner - 1];
    ret_val = TRUE_;
    waslit = lit_(&play_1.here);

    switch (*ri) {
        case 1:  goto L1000;
        case 2:  goto L3000;
        case 3:  goto L4000;
        case 4:  goto L6000;
        case 5:  goto L7000;
        case 6:  goto L8000;
        case 7:  goto L9000;
        case 8:  goto L13000;
        case 9:  goto L14000;
        case 10:  goto L16000;
        case 11:  goto L17000;
        case 12:  goto L21000;
        case 13:  goto L23000;
        case 14:  goto L24000;
        case 15:  goto L27000;
        case 16:  goto L28000;
        case 17:  goto L29000;
        case 18:  goto L30000;
        case 19:  goto L31000;
        case 20:  goto L33000;
        case 21:  goto L34000;
        case 22:  goto L36000;
        case 23:  goto L37000;
        case 24:  goto L38000;
        case 25:  goto L41000;
        case 26:  goto L42000;
        case 27:  goto L43000;
        case 28:  goto L44000;
        case 29:  goto L46000;
        case 30:  goto L53000;
        case 31:  goto L56000;
    }
    bug_(&c__6, ri);

/* Return here to declare false result. */

L10:
    ret_val = FALSE_;
    return ret_val;

/* Return here to test for light source change. */

L50:
    if (waslit && ! lit_(&play_1.here)) {
        rspeak_(&c__406);
    }
    return ret_val;
/* SOBJS, PAGE 3 */

/* O1--  Gunk */

L1000:
    if (objcts_1.ocan[3] == 0) {
        goto L10;
    }
/* not inside? f */
    newsta_(&c__4, &c__122, &c__0, &c__0, &c__0);
/* falls apart. */
    return ret_val;

/* O2--  Trophy case */

L3000:
    if (prsvec_1.prsa != 132) {
        goto L10;
    }
/* take? */
    rspeak_(&c__128);
/* cant. */
    return ret_val;

/* O3--  Bottle */

L4000:
    if (prsvec_1.prsa != 148 || prsvec_1.prso != 10) {
        goto L4100;
    }
/* throw? */
    newsta_(&c__10, &c__129, &c__0, &c__0, &c__0);
/* breaks. */
    return ret_val;

L4100:
    if (prsvec_1.prsa != 138) {
        goto L10;
    }
/* mung? */
    newsta_(&c__10, &c__131, &c__0, &c__0, &c__0);
/* breaks. */
    return ret_val;
/* SOBJS, PAGE 4 */

/* O4--  Rope */

L6000:
    if (play_1.here == 79 || play_1.here == 58 || prsvec_1.prsi == 0 || 
            prsvec_1.prsi == 38 || prsvec_1.prsi == 33) {
        goto L6100;
    }
    if (prsvec_1.prsa == 114) {
        rspeak_(&c__135);
    }
/* tie, cant do it. */
L6050:
    findex_1.domef = FALSE_;
/* not tied in dome. */
    findex_1.ttie = 0;
/* not tied to timber. */
    objcts_1.oflag1[37] = objcts_1.oflag1[37] & -513;
    objcts_1.oflag1[32] = objcts_1.oflag1[32] & -513;
    objcts_1.odesc1[37] = 1032;
/* restore timber, coffin */
    objcts_1.odesc1[32] = 1033;
    objcts_1.oflag1[11] = objcts_1.oflag1[11] & -513;
    objcts_1.oflag2[11] = objcts_1.oflag2[11] & -2049;
    return ret_val;

/* rope not climbable */
L6100:
    if (prsvec_1.prsa != 158 || play_1.here != 188) {
        goto L6200;
    }
    if (findex_1.ttie == 0) {
        goto L6150;
    }
/* climb down, tied? */
    if (objcts_1.oroom[findex_1.ttie - 1] != play_1.here) {
        goto L6150;
    }
/* tied here? */
    rspsub_(&c__1028, &objcts_1.odesc2[findex_1.ttie - 1]);
/* yes, tumbles after you */
    newsta_(&c__12, &c__0, &c__190, &c__0, &c__0);
/* now in puzzle room. */
    newsta_(&findex_1.ttie, &c__0, &c__190, &c__0, &c__0);
    goto L10;

/* not handled here. */
L6150:
    rspeak_(&c__1029);
/* not tied. */
    goto L10;

/* not handled here. */
L6200:
    if (prsvec_1.prsa != 114) {
        goto L6400;
    }
/* tie rope? */
    if (prsvec_1.prsi != 75) {
        goto L6300;
    }
/* to railing? */
    if (findex_1.domef || findex_1.ttie != 0) {
        goto L6250;
    }
/* already tied? */
    findex_1.domef = TRUE_;
/* no, now tied. */
    newsta_(&c__12, &c__137, &c__79, &c__0, &c__0);
/* put in dome room. */
L6225:
    objcts_1.oflag1[11] = objcts_1.oflag1[11] | 512;
    objcts_1.oflag2[11] = objcts_1.oflag2[11] | 2048;
/* now climbable */
    return ret_val;

L6250:
    rspeak_(&c__136);
/* already tied. */
    return ret_val;

L6300:
    if (prsvec_1.prsi != 38 && prsvec_1.prsi != 33) {
        goto L10;
    }
    if (findex_1.domef || findex_1.ttie != 0) {
        goto L6250;
    }
/* already done? */
    if (objcts_1.oroom[prsvec_1.prsi - 1] != 0) {
        goto L6350;
    }
/* target on ground? */
    rspeak_(&c__1025);
/* too clumsy. */
    return ret_val;

L6350:
    rspsub_(&c__961, &odi2);
/* now tied to object. */
    findex_1.ttie = prsvec_1.prsi;
    if (prsvec_1.prsi == 38) {
        objcts_1.odesc1[37] = 1030;
    }
/* change description */
    if (prsvec_1.prsi == 33) {
        objcts_1.odesc1[32] = 1031;
    }
/* of target. */
    if (play_1.here == 188) {
        rspeak_(&c__1056);
    }
/* room-specific words. */
    if (play_1.here == 58) {
        rspeak_(&c__339);
    }
    if (play_1.here == 58) {
        objcts_1.oflag1[prsvec_1.prsi - 1] = objcts_1.oflag1[prsvec_1.prsi - 
                1] | 512;
    }
    newsta_(&c__12, &c__0, &play_1.here, &c__0, &c__0);
/* put rope in room. */
    goto L6225;

/* rope now climbable. */
L6400:
    if (prsvec_1.prsa != 113) {
        goto L6600;
    }
/* untie rope? */
    if (! findex_1.domef && findex_1.ttie == 0) {
        goto L6500;
    }
/* tied to obj or railing */
    rspeak_(&c__139);
/* report and then */
    goto L6050;

/* clean up all status. */
L6500:
    rspeak_(&c__134);
/* not tied to anything. */
    return ret_val;

L6600:
    if (findex_1.domef || prsvec_1.prsa != 145 || play_1.here != 79) {
        goto L6700;
    }
/* drop & untied from dom */
    newsta_(&c__12, &c__140, &c__80, &c__0, &c__0);
/* yes, drop. */
    return ret_val;

L6700:
    if (prsvec_1.prsa != 132 || ! findex_1.domef) {
        goto L6800;
    }
    rspeak_(&c__141);
/* take & tied. */
    return ret_val;

L6800:
    if (prsvec_1.prsa != 132 || findex_1.ttie == 0) {
        goto L10;
    }
    rspsub_(&c__926, &objcts_1.odesc2[findex_1.ttie - 1]);
/* take & tied. */
    return ret_val;

/* O5--  Sword */

L7000:
    if (prsvec_1.prsa == 132 && play_1.winner == 1) {
        hack_1.swdact = TRUE_;
    }
/* turn on demon. */
    goto L10;

/* O6--  Lantern */

L8000:
    if (prsvec_1.prsa != 148 || prsvec_1.prso != 15) {
        goto L8100;
    }
/* throw? */
    newsta_(&c__15, &c__0, &c__0, &c__0, &c__0);
/* kill lamp, */
    newsta_(&c__16, &c__142, &play_1.here, &c__0, &c__0);
/* replace with broken. */
    if (play_1.here == 147) {
        newsta_(&c__16, &c__0, &c__33, &c__0, &c__0);
    }
    if (prssta_1.lastit == 15) {
        prssta_1.lastit = 16;
    }
/* fix last it reference. */
    cevent_1.cflag[2] = FALSE_;
/* turn off timer. */
    goto L50;

/* go see if now dark. */
L8100:
    if (prsvec_1.prsa == 123) {
        cevent_1.cflag[2] = TRUE_;
    }
    if (prsvec_1.prsa == 124) {
        cevent_1.cflag[2] = FALSE_;
    }
    goto L10;

/* O7--  Rug */

L9000:
    if (prsvec_1.prsa != 109) {
        goto L9100;
    }
/* raise? */
    rspeak_(&c__143);
/* cant */
    return ret_val;

L9100:
    if (prsvec_1.prsa != 132) {
        goto L9200;
    }
/* take? */
    rspeak_(&c__144);
/* cant */
    return ret_val;

L9200:
    if (prsvec_1.prsa != 122) {
        goto L9300;
    }
/* move? */
    i__1 = findex_1.orrug + 145;
    rspeak_(&i__1);
    findex_1.orrug = 1;
    objcts_1.oflag1[65] = objcts_1.oflag1[65] | 32768;
/* reveal door. */
    return ret_val;

L9300:
    if (prsvec_1.prsa != 153 || findex_1.orrug != 0 || (objcts_1.oflag2[c__66 
            - 1] & 8) != 0) {
        goto L10;
    }
/* look under rug? */
    rspeak_(&c__345);
    return ret_val;
/* SOBJS, PAGE 5 */

/* O8--  Skeleton */

L13000:
    i__ = robrm_(&play_1.here, &c__100, &c__94, &c__0, &c__0) + robadv_(&
            play_1.winner, &c__94, &c__0, &c__0);
    rspeak_(&c__162);
/* curses. */
    return ret_val;

/* O9--  Mirror */

L14000:
    if (findex_1.mirrmf || prsvec_1.prsa != 111) {
        goto L14500;
    }
    mroom = play_1.here ^ 1;
/* calculate new rm. */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* interchange objs. */
        if (objcts_1.oroom[i__ - 1] == play_1.here) {
            objcts_1.oroom[i__ - 1] = -1;
        }
        if (objcts_1.oroom[i__ - 1] == mroom) {
            objcts_1.oroom[i__ - 1] = play_1.here;
        }
        if (objcts_1.oroom[i__ - 1] == -1) {
            objcts_1.oroom[i__ - 1] = mroom;
        }
/* L14100: */
    }
    f = moveto_(&mroom, &play_1.winner);
    rspeak_(&c__163);
/* shake world. */
    return ret_val;

L14500:
    if (prsvec_1.prsa != 119 && prsvec_1.prsa != 152 && prsvec_1.prsa != 120) 
            {
        goto L14600;
    }
    i__ = 164;
/* mirror ok. */
    if (findex_1.mirrmf) {
        i__ = 165;
    }
/* mirror dead. */
    rspeak_(&i__);
    return ret_val;

L14600:
    if (prsvec_1.prsa != 132) {
        goto L14700;
    }
/* take? */
    rspeak_(&c__166);
/* joke. */
    return ret_val;

L14700:
    if (prsvec_1.prsa != 138 && prsvec_1.prsa != 148) {
        goto L10;
    }
    i__ = 167;
/* mirror breaks. */
    if (findex_1.mirrmf) {
        i__ = 168;
    }
/* mirror already broken. */
    findex_1.mirrmf = TRUE_;
    findex_1.badlkf = TRUE_;
    rspeak_(&i__);
    return ret_val;
/* SOBJS, PAGE 6 */

/* O10-- Dumbwaiter */

L16000:
    if (prsvec_1.prsa != 109) {
        goto L16100;
    }
/* raise? */
    if (findex_1.cagetf) {
        goto L16400;
    }
/* already at top? */
    newsta_(&c__35, &c__175, &c__61, &c__0, &c__0);
/* no, raise basket. */
    newsta_(&c__36, &c__0, &c__76, &c__0, &c__0);
    if (play_1.here == 61) {
        prssta_1.lastit = 35;
    }
/* fix last it reference. */
    if (play_1.here == 76) {
        prssta_1.lastit = 36;
    }
    findex_1.cagetf = TRUE_;
/* at top. */
    return ret_val;

L16100:
    if (prsvec_1.prsa != 110) {
        goto L16200;
    }
/* lower? */
    if (! findex_1.cagetf) {
        goto L16400;
    }
/* already at bottom? */
    newsta_(&c__35, &c__176, &c__76, &c__0, &c__0);
/* no, lower basket. */
    newsta_(&c__36, &c__0, &c__61, &c__0, &c__0);
    if (play_1.here == 61) {
        prssta_1.lastit = 36;
    }
/* fix last it reference. */
    if (play_1.here == 76) {
        prssta_1.lastit = 35;
    }
    findex_1.cagetf = FALSE_;
    goto L50;

/* go see if now dark. */
L16200:
    if (prsvec_1.prso != 36 && prsvec_1.prsi != 36) {
        goto L16300;
    }
    rspeak_(&c__130);
/* wrong basket. */
    return ret_val;

L16300:
    if (prsvec_1.prsa != 132) {
        goto L10;
    }
/* take? */
    rspeak_(&c__177);
/* joke. */
    return ret_val;

L16400:
    i__1 = rnd_(&c__3) + 125;
    rspeak_(&i__1);
/* dummy. */
    return ret_val;

/* O11-- Ghost */

L17000:
    if (prsvec_1.prso != 42) {
        goto L17100;
    }
/* direct object? */
    rspeak_(&c__178);
/* joke. */
    return ret_val;

L17100:
    rspeak_(&c__179);
/* joke. */
    goto L10;
/* SOBJS, PAGE 7 */

/* O12-- Tube */

/* don't handle. */
L21000:
    if (prsvec_1.prsa != 144 || prsvec_1.prsi != 54) {
        goto L21100;
    }
    rspeak_(&c__186);
/* cant put back in. */
    return ret_val;

L21100:
    if (prsvec_1.prsa != 68) {
        goto L10;
    }
/* squeeze? */
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 8) != 0) {
        goto L21200;
    }
/* tube open? */
    rspeak_(&c__909);
/* no, can't do it. */
    return ret_val;

L21200:
    if (objcts_1.ocan[54] == prsvec_1.prso) {
        goto L21300;
    }
/* putty inside? */
    rspeak_(&c__910);
/* no, doesn't work. */
    return ret_val;

L21300:
    newsta_(&c__55, &c__911, &c__0, &c__0, &play_1.winner);
/* putty now in hand. */
    return ret_val;

/* O13-- Chalice */

L23000:
    if (prsvec_1.prsa != 132 || objcts_1.ocan[prsvec_1.prso - 1] != 0 || 
            objcts_1.oroom[prsvec_1.prso - 1] != 103 || objcts_1.oroom[60] != 
            103 || (objcts_1.oflag2[60] & 256) == 0 || ! hack_1.thfact) {
        goto L10;
    }
    rspeak_(&c__204);
/* cant take. */
    return ret_val;

/* O14-- Painting */

L24000:
    if (prsvec_1.prsa != 138) {
        goto L10;
    }
/* mung? */
    rspeak_(&c__205);
/* destroy painting. */
    objcts_1.ofval[prsvec_1.prso - 1] = 0;
    objcts_1.otval[prsvec_1.prso - 1] = 0;
    objcts_1.odesc1[prsvec_1.prso - 1] = 207;
    objcts_1.odesc2[prsvec_1.prso - 1] = 206;
    return ret_val;
/* SOBJS, PAGE 8 */

/* O15-- Bolt */

L27000:
    if (prsvec_1.prsa != 116) {
        goto L27600;
    }
/* turn bolt? */
    if (prsvec_1.prsi != 56) {
        goto L27500;
    }
/* with wrench? */
    if (findex_1.gatef) {
        goto L27100;
    }
/* proper button pushed? */
    rspeak_(&c__210);
/* no, lose. */
    return ret_val;

L27100:
    if (findex_1.lwtidf) {
        goto L27200;
    }
/* low tide now? */
    findex_1.lwtidf = TRUE_;
/* no, empty dam. */
    rspeak_(&c__211);
    objcts_1.oflag2[32] = objcts_1.oflag2[32] & -8193;
    objcts_1.oflag1[44] = objcts_1.oflag1[44] | 32768;
/* materialize trunk. */
    rooms_1.rflag[39] = (rooms_1.rflag[39] | 8192) & -36865;
/* keep thief away. */
    return ret_val;

L27200:
    findex_1.lwtidf = FALSE_;
/* yes, fill dam. */
    rspeak_(&c__212);
    if (objcts_1.oroom[44] == 40) {
        objcts_1.oflag1[44] = objcts_1.oflag1[44] & -32769;
    }
    rooms_1.rflag[39] = (rooms_1.rflag[39] | 4096) & -8193;
    return ret_val;

L27500:
    rspsub_(&c__299, &odi2);
/* not with that. */
    return ret_val;

L27600:
    if (prsvec_1.prsa != 164) {
        goto L10;
    }
/* oil? */
    rspeak_(&c__906);
/* trouble. */
    return ret_val;

/* O16-- Grating */

L28000:
    if (prsvec_1.prsa != 125 && prsvec_1.prsa != 126) {
        goto L10;
    }
    if (findex_1.grunlf) {
        goto L28100;
    }
/* unlocked? */
    rspeak_(&c__214);
/* no, locked. */
    return ret_val;

L28100:
    i__ = 215;
/* unlocked, view frm bel */
    if (play_1.here == 36) {
        i__ = 216;
    }
/* view from clearing */
    ret_val = opncls_(&c__65, &i__, &c__885);
/* open/close. */
    rooms_1.rflag[24] = rooms_1.rflag[24] & -16385;
/* set light/dark. */
    if (! ((objcts_1.oflag2[c__65 - 1] & 8) != 0)) {
        goto L50;
    }
/* if not open, done. */
    rooms_1.rflag[24] = rooms_1.rflag[24] | 16384;
/* now lit. */
    findex_1.rvclr = 1;
/* leaves shoved aside. */
    newsta_(&c__65, &c__0, &c__36, &c__0, &c__0);
/* grating in clearing. */
    return ret_val;

/* O17-- Trap door */

L29000:
    if (play_1.here != 8) {
        goto L29100;
    }
/* from living room? */
    ret_val = opncls_(&c__66, &c__218, &c__219);
/* open/close. */
    return ret_val;

L29100:
    if (play_1.here != 9) {
        goto L10;
    }
/* from cellar? */
    if (prsvec_1.prsa != 125 || (objcts_1.oflag2[c__66 - 1] & 8) != 0) {
        goto L29200;
    }
    rspeak_(&c__220);
/* cant open closed door. */
    return ret_val;

L29200:
    ret_val = opncls_(&c__66, &c__0, &c__22);
/* normal open/close. */
    return ret_val;

/* O18-- Durable door */

L30000:
    i__ = 0;
/* assume no appl. */
    if (prsvec_1.prsa == 125) {
        i__ = 221;
    }
/* open? */
    if (prsvec_1.prsa == 137) {
        i__ = 222;
    }
/* burn? */
    if (prsvec_1.prsa == 138) {
        i__ = rnd_(&c__3) + 223;
    }
/* mung? */
    if (i__ == 0) {
        goto L10;
    }
    rspeak_(&i__);
    return ret_val;

/* O19-- Master switch */

L31000:
    if (prsvec_1.prsa != 116) {
        goto L10;
    }
/* turn? */
    if (prsvec_1.prsi != 57) {
        goto L31500;
    }
/* with screwdriver? */
    if ((objcts_1.oflag2[c__7 - 1] & 8) != 0) {
        goto L31600;
    }
/* lid up? */
    rspeak_(&c__226);
/* no, activate. */
    if (objcts_1.ocan[4] != 7) {
        goto L31400;
    }
/* coal inside? */
    newsta_(&c__5, &c__0, &c__0, &c__0, &c__0);
/* kill coal, */
    newsta_(&c__8, &c__0, &c__0, &c__7, &c__0);
/* replace with diamond. */
    return ret_val;

L31400:
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* kill noncoal objects. */
        if (objcts_1.ocan[i__ - 1] != 7) {
            goto L31450;
        }
/* inside machine? */
        newsta_(&i__, &c__0, &c__0, &c__0, &c__0);
/* kill object and conten */
        newsta_(&c__4, &c__0, &c__0, &c__7, &c__0);
/* reduce to gunk. */
L31450:
        ;
    }
    return ret_val;

L31500:
    rspsub_(&c__300, &odi2);
/* cant turn with that. */
    return ret_val;

L31600:
    rspeak_(&c__227);
/* lid is up. */
    return ret_val;
/* SOBJS, PAGE 9 */

/* O20-- Leak */

L33000:
    if (prsvec_1.prso != 78 || prsvec_1.prsa != 106 || findex_1.rvmnt <= 0) {
        goto L10;
    }
/* plug active leak? */
    if (prsvec_1.prsi != 55) {
        goto L33100;
    }
/* with putty? */
    findex_1.rvmnt = -1;
/* disable leak. */
    cevent_1.ctick[1] = 0;
    rspeak_(&c__577);
    return ret_val;

L33100:
    rspsub_(&c__301, &odi2);
/* cant with that. */
    return ret_val;

/* O21-- Drowning buttons */

L34000:
    if (prsvec_1.prsa != 112) {
        goto L10;
    }
/* push? */
    switch (prsvec_1.prso - 78) {
        case 1:  goto L34100;
        case 2:  goto L34200;
        case 3:  goto L34300;
        case 4:  goto L34400;
    }
    goto L10;

/* not a button. */
L34100:
    rooms_1.rflag[play_1.here - 1] ^= 16384;
/* red, zap lights. */
    i__ = 230;
    if ((rooms_1.rflag[play_1.here - 1] & 16384) != 0) {
        i__ = 231;
    }
    rspeak_(&i__);
    goto L50;

/* go see if now dark. */
L34200:
    findex_1.gatef = TRUE_;
/* yellow, release gate. */
    rspeak_(&c__232);
    return ret_val;

L34300:
    findex_1.gatef = FALSE_;
/* brown, interlock gate. */
    rspeak_(&c__232);
    return ret_val;

L34400:
    if (findex_1.rvmnt != 0) {
        goto L34500;
    }
/* blue, leak already sta */
    rspeak_(&c__233);
/* no, start leak. */
    findex_1.rvmnt = 1;
    cevent_1.cflag[1] = TRUE_;
    cevent_1.ctick[1] = -1;
    rooms_1.rflag[play_1.here - 1] = rooms_1.rflag[play_1.here - 1] | 512;
/* water present. */
    objcts_1.oflag1[77] = objcts_1.oflag1[77] | 32768;
/* bring on the leak. */
    return ret_val;

L34500:
    rspeak_(&c__234);
/* button jammed. */
    return ret_val;

/* O22-- Inflatable boat */

L36000:
    if (prsvec_1.prsa != 102) {
        goto L10;
    }
/* inflate? */
    if (objcts_1.oroom[86] != 0) {
        goto L36100;
    }
/* in room? */
    rspeak_(&c__235);
/* no, joke. */
    return ret_val;

L36100:
    if (prsvec_1.prsi != 89) {
        goto L36200;
    }
/* with pump? */
    newsta_(&c__87, &c__0, &c__0, &c__0, &c__0);
/* kill defl boat, */
    newsta_(&c__90, &c__236, &play_1.here, &c__0, &c__0);
/* repl with inf. */
    if (prssta_1.lastit == 87) {
        prssta_1.lastit = 90;
    }
/* fix last it reference. */
    findex_1.deflaf = FALSE_;
    return ret_val;

L36200:
    i__ = 237;
/* jokes. */
    if (prsvec_1.prsi != 260) {
        i__ = 303;
    }
    rspsub_(&i__, &odi2);
    return ret_val;

/* O23-- Deflated boat */

L37000:
    if (prsvec_1.prsa != 102) {
        goto L37100;
    }
/* inflate? */
    rspeak_(&c__238);
/* joke. */
    return ret_val;

L37100:
    if (prsvec_1.prsa != 106) {
        goto L10;
    }
/* plug? */
    if (prsvec_1.prsi != 55) {
        goto L33100;
    }
/* with putty? */
    newsta_(&c__87, &c__239, &objcts_1.oroom[87], &objcts_1.ocan[87], &
            objcts_1.oadv[87]);
    newsta_(&c__88, &c__0, &c__0, &c__0, &c__0);
/* kill defl boat, repl. */
    if (prssta_1.lastit == 88) {
        prssta_1.lastit = 87;
    }
/* fix last it reference. */
    return ret_val;
/* SOBJS, PAGE 10 */

/* O24-- Rubber boat */

L38000:
    if (*arg != 0) {
        goto L10;
    }
/* dismiss readin, out. */
    if (prsvec_1.prsa != 130 || objcts_1.oadv[91] != play_1.winner) {
        goto L38100;
    }
    newsta_(&c__90, &c__0, &c__0, &c__0, &c__0);
/* kill infl boat, */
    newsta_(&c__88, &c__240, &play_1.here, &c__0, &c__0);
/* repl with dead. */
    if (prssta_1.lastit == 90) {
        prssta_1.lastit = 88;
    }
/* fix last it reference. */
    findex_1.deflaf = TRUE_;
    goto L50;

/* go see if now dark. */
L38100:
    if (prsvec_1.prsa != 102) {
        goto L38200;
    }
/* inflate? */
    rspeak_(&c__367);
/* yes, joke. */
    return ret_val;

L38200:
    if (prsvec_1.prsa != 103) {
        goto L10;
    }
/* deflate? */
    if (av == 90) {
        goto L38300;
    }
/* in boat? */
    if (objcts_1.oroom[89] == 0) {
        goto L38400;
    }
/* on ground? */
    newsta_(&c__90, &c__0, &c__0, &c__0, &c__0);
/* kill infl boat, */
    newsta_(&c__87, &c__241, &play_1.here, &c__0, &c__0);
/* repl with defl. */
    if (prssta_1.lastit == 90) {
        prssta_1.lastit = 87;
    }
/* fix last it reference. */
    findex_1.deflaf = TRUE_;
    goto L50;

/* go see if now dark. */
L38300:
    rspeak_(&c__242);
/* in boat. */
    return ret_val;

L38400:
    rspeak_(&c__243);
/* not on ground. */
    return ret_val;

/* O25-- Braided rope (also balloon receptacle, cloth bag) */

L41000:
    if (prsvec_1.prsa != 114 || prsvec_1.prso != 101 || (prsvec_1.prsi != 102 
            && prsvec_1.prsi != 103)) {
        goto L41100;
    }
/* tie to hook? */
    findex_1.btief = prsvec_1.prsi;
/* record location. */
    objcts_1.odesc1[findex_1.btief - 1] = 1072;
/* change description. */
    cevent_1.cflag[5] = FALSE_;
/* stall ascent. */
    rspeak_(&c__248);
    return ret_val;

L41100:
    if (prsvec_1.prsa != 113 || prsvec_1.prso != 101) {
        goto L41300;
    }
    if (findex_1.btief != 0) {
        goto L41200;
    }
/* tied up? */
    rspeak_(&c__249);
/* no, joke. */
    return ret_val;

L41200:
    rspeak_(&c__250);
    objcts_1.odesc1[findex_1.btief - 1] = 1073;
/* restore description. */
    findex_1.btief = 0;
/* untie. */
    cevent_1.cflag[5] = TRUE_;
    cevent_1.ctick[5] = 3;
/* restart clock. */
    return ret_val;

L41300:
    if (prsvec_1.prsa != 127 && prsvec_1.prsa != 120) {
        goto L41400;
    }
    rspsub_(&c__1063, &odo2);
/* describe. */
    return ret_val;

L41400:
    if (prsvec_1.prsa != 132) {
        goto L10;
    }
/* take? */
    rspsub_(&c__1064, &odo2);
/* can't. */
    if (prsvec_1.prso == 101) {
        rspeak_(&c__1065);
    }
/* rope can be tied. */
    return ret_val;

/* O26-- Safe */

L42000:
    i__ = 0;
/* assume unprocessed. */
    if (prsvec_1.prsa == 132) {
        i__ = 251;
    }
/* take? */
    if (prsvec_1.prsa == 125 && findex_1.safef) {
        i__ = 253;
    }
/* open after blast? */
    if (prsvec_1.prsa == 125 && ! findex_1.safef) {
        i__ = 254;
    }
/* open before blast? */
    if (prsvec_1.prsa == 126 && findex_1.safef) {
        i__ = 253;
    }
/* close after? */
    if (prsvec_1.prsa == 126 && ! findex_1.safef) {
        i__ = 255;
    }
    if (i__ == 0) {
        goto L10;
    }
    rspeak_(&i__);
    return ret_val;

/* O27-- Fuse */

L43000:
    if (prsvec_1.prsa != 137) {
        goto L10;
    }
/* burn? */
    rspeak_(&c__256);
    cevent_1.cflag[7] = TRUE_;
    cevent_1.ctick[7] = 2;
/* start countdown. */
    return ret_val;

/* O28-- Gnome */

L44000:
    if (prsvec_1.prsa != 146 && prsvec_1.prsa != 148) {
        goto L44500;
    }
    if (objcts_1.otval[prsvec_1.prso - 1] == 0) {
        goto L44100;
    }
/* treasure? */
    rspsub_(&c__257, &odo2);
/* yes, get door. */
    newsta_(&prsvec_1.prso, &c__0, &c__0, &c__0, &c__0);
    newsta_(&c__111, &c__0, &c__0, &c__0, &c__0);
/* vanish gnome. */
    findex_1.gnodrf = TRUE_;
    goto L50;

/* go see if now dark. */
L44100:
    if (prsvec_1.prso != 109 || objcts_1.ocan[109] != 109 || cevent_1.ctick[7]
             == 0) {
        goto L44200;
    }
/* a bomb? */
    newsta_(&c__111, &c__927, &c__0, &c__0, &c__0);
/* gnome leaves. */
    newsta_(&c__109, &c__0, &play_1.here, &c__0, &c__0);
/* brick on floor. */
    cevent_1.cflag[10] = FALSE_;
/* turn off gnome clocks. */
    cevent_1.cflag[11] = FALSE_;
    return ret_val;

L44200:
    rspsub_(&c__258, &odo2);
/* no, lose object. */
    newsta_(&prsvec_1.prso, &c__0, &c__0, &c__0, &c__0);
    goto L50;

/* go see if now dark. */
L44500:
    rspeak_(&c__259);
/* nervous gnome. */
    if (findex_1.gnomef) {
        return ret_val;
    }
    cevent_1.cflag[11] = TRUE_;
    cevent_1.ctick[11] = 5;
/* schedule byebye. */
    findex_1.gnomef = TRUE_;
    return ret_val;

/* O29-- Coke bottles */

L46000:
    if (prsvec_1.prsa != 148 && prsvec_1.prsa != 138) {
        goto L10;
    }
    newsta_(&c__121, &c__262, &c__0, &c__0, &c__0);
/* mung bottles. */
    if (prsvec_1.prsi != 121) {
        return ret_val;
    }
/* with cokes? */
    rspsub_(&c__1066, &odo2);
/* kill direct object, to */
    newsta_(&prsvec_1.prso, &c__0, &c__0, &c__0, &c__0);
    return ret_val;
/* SOBJS, PAGE 11 */

/* O30-- Robot */

L53000:
    if (prsvec_1.prsa != 146) {
        goto L53200;
    }
/* give? */
    if (prsvec_1.prso != 11) {
        goto L53100;
    }
/* water? */
    newsta_(&c__11, &c__1081, &c__0, &c__0, &c__0);
/* slips through fingers. */
    return ret_val;

L53100:
    newsta_(&prsvec_1.prso, &c__0, &c__0, &c__0, &c__2);
/* put on robot. */
    rspsub_(&c__302, &odo2);
    return ret_val;

L53200:
    if ((prsvec_1.prsa != 138 && prsvec_1.prsa != 148) || (prsvec_1.prso != 
            142 && prsvec_1.prsi != 142)) {
        goto L10;
    }
    newsta_(&c__142, &c__285, &c__0, &c__0, &c__0);
/* kill robot. */
    goto L50;

/* O31-- Grue */

/* go see if now dark. */
L56000:
    if (prsvec_1.prsa != 120) {
        goto L56100;
    }
/* examine? */
    rspeak_(&c__288);
    return ret_val;

L56100:
    if (prsvec_1.prsa != 127) {
        goto L10;
    }
/* find? */
    rspeak_(&c__289);
    return ret_val;

} /* sobjs_ */



/* NOBJS-        New objects processor */

/* Declarations */

logical nobjs_(integer *ri, integer *arg)
{
    /* System generated locals */
    integer i__1, i__2;
    logical ret_val;

    /* Local variables */
    logical f;
    logical waslit;
    integer av;
    integer target;
    integer i__;
    integer j, wl;
    integer svflag, k, svhere, obj;
    integer nxt, odo2, odi2;


/* Functions and data */


    odo2 = 0;
    odi2 = 0;
    if (prsvec_1.prso != 0 && prsvec_1.prso <= 300) {
        odo2 = objcts_1.odesc2[prsvec_1.prso - 1];
    }
    if (prsvec_1.prsi != 0) {
        odi2 = objcts_1.odesc2[prsvec_1.prsi - 1];
    }
    av = advs_1.avehic[play_1.winner - 1];
    ret_val = TRUE_;
    waslit = lit_(&play_1.here);

    switch (*ri - 31) {
        case 1:  goto L1000;
        case 2:  goto L2000;
        case 3:  goto L3000;
        case 4:  goto L4000;
        case 5:  goto L5000;
        case 6:  goto L6000;
        case 7:  goto L7000;
        case 8:  goto L8000;
        case 9:  goto L9000;
        case 10:  goto L10000;
        case 11:  goto L11000;
        case 12:  goto L12000;
        case 13:  goto L13000;
        case 14:  goto L14000;
        case 15:  goto L15000;
        case 16:  goto L16000;
        case 17:  goto L17000;
        case 18:  goto L18000;
        case 19:  goto L19000;
        case 20:  goto L20000;
        case 21:  goto L21000;
        case 22:  goto L22000;
        case 23:  goto L23000;
        case 24:  goto L24000;
        case 25:  goto L25000;
        case 26:  goto L26000;
        case 27:  goto L27000;
        case 28:  goto L28000;
        case 29:  goto L29000;
        case 30:  goto L30000;
        case 31:  goto L31000;
        case 32:  goto L32000;
        case 33:  goto L33000;
        case 34:  goto L34000;
        case 35:  goto L35000;
        case 36:  goto L36000;
        case 37:  goto L37000;
        case 38:  goto L38000;
        case 39:  goto L39000;
        case 40:  goto L40000;
        case 41:  goto L41000;
        case 42:  goto L42000;
        case 43:  goto L43000;
        case 44:  goto L44000;
        case 45:  goto L45000;
        case 46:  goto L46000;
    }
    bug_(&c__6, ri);

/* Return here to declare false result. */

L10:
    ret_val = FALSE_;
    return ret_val;

/* Return here to test for light source change. */

L50:
    if (waslit && ! lit_(&play_1.here)) {
        rspeak_(&c__406);
    }
    return ret_val;
/* NOBJS, PAGE 3 */

/* O32-- Bills */

L1000:
    if (prsvec_1.prsa != 135) {
        goto L1100;
    }
/* eat? */
    rspeak_(&c__639);
/* joke. */
    return ret_val;

L1100:
    if (prsvec_1.prsa == 137) {
        rspeak_(&c__640);
    }
/* burn?  joke. */
    goto L10;

/* O33-- Screen of light */

/* let it be handled. */
L2000:
    target = 151;
/* target is scol. */
L2100:
    if (prsvec_1.prso != target) {
        goto L2400;
    }
/* prso eq target? */
    if (prsvec_1.prsa != 112 && prsvec_1.prsa != 122 && prsvec_1.prsa != 132 
            && prsvec_1.prsa != 111) {
        goto L2200;
    }
    rspeak_(&c__673);
/* hand passes thru. */
    return ret_val;

L2200:
    if (prsvec_1.prsa != 139 && prsvec_1.prsa != 141 && prsvec_1.prsa != 138) 
            {
        goto L2400;
    }
/* aggressive? */
    rspsub_(&c__674, &odi2);
/* passes thru. */
    return ret_val;

L2400:
    if (prsvec_1.prsa != 148 || prsvec_1.prsi != target) {
        goto L10;
    }
    if (play_1.here == 155) {
        goto L2600;
    }
/* thru scol? */
    newsta_(&prsvec_1.prso, &c__0, &c__155, &c__0, &c__0);
/* no, thru wall. */
    rspsub_(&c__675, &odo2);
/* ends up in box room. */
    cevent_1.ctick[16] = 0;
/* cancel alarm. */
    screen_1.scolrm = 0;
/* reset scol room. */
    goto L50;

/* go see if now dark. */
L2600:
    if (screen_1.scolrm == 0) {
        goto L2900;
    }
/* tried to go thru? */
    newsta_(&prsvec_1.prso, &c__0, &screen_1.scolrm, &c__0, &c__0);
/* success. */
    rspsub_(&c__676, &odo2);
/* ends up somewhere. */
    cevent_1.ctick[16] = 0;
/* cancel alarm. */
    screen_1.scolrm = 0;
/* reset scol room. */
    goto L50;

/* go see if now dark. */
L2900:
    rspeak_(&c__213);
/* cant do it. */
    return ret_val;
/* NOBJS, PAGE 4 */

/* O34-- Gnome of Zurich */

L3000:
    if (prsvec_1.prsa != 146 && prsvec_1.prsa != 148) {
        goto L3200;
    }
    if (objcts_1.otval[prsvec_1.prso - 1] != 0) {
        goto L3100;
    }
/* throw a treasure? */
    if (prsvec_1.prso != 109 || objcts_1.ocan[109] != 109 || cevent_1.ctick[7]
             == 0) {
        goto L3050;
    }
/* a bomb? */
    newsta_(&c__152, &c__931, &c__0, &c__0, &c__0);
/* gnome leaves. */
    newsta_(&c__109, &c__0, &play_1.here, &c__0, &c__0);
/* brick on floor. */
    cevent_1.cflag[18] = FALSE_;
/* stop gnome timers. */
    cevent_1.cflag[17] = FALSE_;
    return ret_val;

L3050:
    newsta_(&prsvec_1.prso, &c__641, &c__0, &c__0, &c__0);
/* no, go pop. */
    return ret_val;

L3100:
    newsta_(&prsvec_1.prso, &c__0, &c__0, &c__0, &c__0);
/* yes, bye bye treasure. */
    rspsub_(&c__642, &odo2);
    newsta_(&c__152, &c__0, &c__0, &c__0, &c__0);
/* bye bye gnome. */
    cevent_1.cflag[18] = FALSE_;
/* cancel exit. */
    f = moveto_(&c__148, &play_1.winner);
/* now in bank entrance. */
    return ret_val;

L3200:
    if (prsvec_1.prsa != 141 && prsvec_1.prsa != 139 && prsvec_1.prsa != 138) 
            {
        goto L3300;
    }
/* aggressive? */
    newsta_(&c__152, &c__643, &c__0, &c__0, &c__0);
/* vanish gnome. */
    cevent_1.cflag[18] = FALSE_;
/* cancel exit. */
    return ret_val;

L3300:
    rspeak_(&c__644);
/* gnome is impatient. */
    return ret_val;

/* O35-- Egg */

L4000:
    if (prsvec_1.prsa != 125 || prsvec_1.prso != 154) {
        goto L4500;
    }
    if (! ((objcts_1.oflag2[c__154 - 1] & 8) != 0)) {
        goto L4100;
    }
/* open already? */
    rspeak_(&c__649);
/* yes. */
    return ret_val;

L4100:
    if (prsvec_1.prsi != 0) {
        goto L4200;
    }
/* with something? */
    rspeak_(&c__650);
/* no, cant. */
    return ret_val;

L4200:
    if (prsvec_1.prsi != 259) {
        goto L4300;
    }
/* with hands? */
    rspeak_(&c__651);
/* not recommended. */
    return ret_val;

L4300:
    i__ = 652;
/* mung message. */
    if ((objcts_1.oflag1[prsvec_1.prsi - 1] & 4) != 0 || (objcts_1.oflag2[
            prsvec_1.prsi - 1] & 512) != 0) {
        goto L4600;
    }
    i__ = 653;
/* novelty 1. */
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 256) != 0) {
        i__ = 654;
    }
/* novelty 2. */
    objcts_1.oflag2[prsvec_1.prso - 1] = objcts_1.oflag2[prsvec_1.prso - 1] | 
            256;
    rspsub_(&i__, &odi2);
    return ret_val;

L4500:
    if (prsvec_1.prsa != 138) {
        goto L10;
    }
/* mung? */
    i__ = 655;
/* you blew it. */
L4600:
    newsta_(&c__155, &i__, &objcts_1.oroom[153], &objcts_1.ocan[153], &
            objcts_1.oadv[153]);
    newsta_(&c__154, &c__0, &c__0, &c__0, &c__0);
/* vanish egg. */
    if (prssta_1.lastit == 154) {
        prssta_1.lastit = 155;
    }
/* fix last it reference. */
    objcts_1.otval[154] = 2;
/* bad egg has value. */
    if (objcts_1.ocan[156] != 154) {
        goto L4700;
    }
/* was canary inside? */
    rspeak_(&objcts_1.odesco[157]);
/* yes, describe result. */
    objcts_1.otval[157] = 1;
    return ret_val;

L4700:
    newsta_(&c__158, &c__0, &c__0, &c__0, &c__0);
/* no, vanish it. */
    return ret_val;
/* NOBJS, PAGE 5 */

/* O36-- Canaries, good and bad */

L5000:
    if (prsvec_1.prsa != 155) {
        goto L10;
    }
/* wind em up? */
    if (prsvec_1.prso == 157) {
        goto L5100;
    }
/* right one? */
    rspeak_(&c__645);
/* no, bad news. */
    return ret_val;

L5100:
    if (! findex_1.singsf && (play_1.here == 147 || (play_1.here >= 31 && 
            play_1.here < 36))) {
        goto L5200;
    }
/* first song in for? */
    rspeak_(&c__646);
/* no, mediocre news. */
    return ret_val;

L5200:
    findex_1.singsf = TRUE_;
/* sang song. */
    newsta_(&c__156, &c__647, &play_1.here, &c__0, &c__0);
/* place bauble. */
    if (play_1.here == 147) {
        newsta_(&c__156, &c__0, &c__33, &c__0, &c__0);
    }
    return ret_val;

/* O37-- White cliffs */

L6000:
    if (prsvec_1.prsa != 156 && prsvec_1.prsa != 157 && prsvec_1.prsa != 158) 
            {
        goto L10;
    }
/* climb? */
    rspeak_(&c__648);
/* oh yeah? */
    return ret_val;

/* O38-- Wall */

L7000:
    if ((i__1 = play_1.here - findex_1.mloc, abs(i__1)) != 1 || mrhere_(&
            play_1.here) != 0 || ! findex_1.endgmf) {
        goto L7100;
    }
/* mirror wall in endgame */
    if (prsvec_1.prsa != 112) {
        goto L10;
    }
/* pushed? */
    rspeak_(&c__860);
/* pushed mirror wall. */
    return ret_val;

L7100:
    if ((rooms_1.rflag[play_1.here - 1] & 32) == 0) {
        goto L10;
    }
    rspeak_(&c__662);
/* no wall. */
    return ret_val;
/* NOBJS, PAGE 6 */

/* O39-- Global bird */

L8000:
    if (prsvec_1.prsa != 127) {
        goto L8100;
    }
/* find? */
    rspeak_(&c__666);
    return ret_val;

L8100:
    if (prsvec_1.prsa != 120) {
        goto L10;
    }
/* examine? */
    rspeak_(&c__667);
    return ret_val;

/* O40-- Puzzle/Scol walls */

L9000:
    if (play_1.here != 190) {
        goto L9500;
    }
/* puzzle walls? */
    if (prsvec_1.prsa != 112) {
        goto L10;
    }
/* push? */
    for (i__ = 1; i__ <= 8; i__ += 2) {
/* locate wall. */
        if (prsvec_1.prso == puzzle_1.cpwl[i__ - 1]) {
            goto L9200;
        }
/* L9100: */
    }
    bug_(&c__80, &prsvec_1.prso);

/* what? */
L9200:
    j = puzzle_1.cpwl[i__];
/* get directional offset */
    nxt = findex_1.cphere + j;
/* get next state. */
    wl = puzzle_1.cpvec[nxt - 1];
/* get c(next state). */
    switch (wl + 4) {
        case 1:  goto L9300;
        case 2:  goto L9300;
        case 3:  goto L9300;
        case 4:  goto L9250;
        case 5:  goto L9350;
    }

/* process. */
L9250:
    rspeak_(&c__876);
/* clear corridor. */
    return ret_val;

L9300:
    if (puzzle_1.cpvec[nxt + j - 1] == 0) {
        goto L9400;
    }
/* movable, room to move? */
L9350:
    rspeak_(&c__877);
/* immovable, no room. */
    return ret_val;

L9400:
    i__ = 878;
/* assume first push. */
    if (findex_1.cpushf) {
        i__ = 879;
    }
/* not? */
    findex_1.cpushf = TRUE_;
    puzzle_1.cpvec[nxt + j - 1] = wl;
/* move wall. */
    puzzle_1.cpvec[nxt - 1] = 0;
/* vacate next state. */
    cpgoto_(&nxt);
/* onward. */
    cpinfo_(&i__, &nxt);
/* describe. */
    princr_(&c_true, &play_1.here);
/* print rooms contents. */
    return ret_val;

L9500:
    if (play_1.here != screen_1.scolac) {
        goto L9700;
    }
/* in scol active room? */
    for (i__ = 1; i__ <= 12; i__ += 3) {
        target = screen_1.scolwl[i__];
/* assume target. */
        if (screen_1.scolwl[i__ - 1] == play_1.here) {
            goto L2100;
        }
/* treat if found. */
/* L9600: */
    }

L9700:
    if (play_1.here != 155) {
        goto L10;
    }
/* in box room? */
    target = 269;
    goto L2100;
/* NOBJS, PAGE 7 */

/* O41-- Short pole */

L10000:
    if (prsvec_1.prsa != 109) {
        goto L10100;
    }
/* lift? */
    i__ = 749;
/* assume up. */
    if (findex_1.poleuf == 2) {
        i__ = 750;
    }
/* already up? */
    rspeak_(&i__);
    findex_1.poleuf = 2;
/* pole is raised. */
    return ret_val;

L10100:
    if (prsvec_1.prsa != 110 && prsvec_1.prsa != 112) {
        goto L10;
    }
    if (findex_1.poleuf != 0) {
        goto L10200;
    }
/* already lowered? */
    rspeak_(&c__751);
/* cant do it. */
    return ret_val;

L10200:
    if (findex_1.mdir % 180 != 0) {
        goto L10300;
    }
/* mirror n-s? */
    findex_1.poleuf = 0;
/* yes, lower into */
    rspeak_(&c__752);
/* channel. */
    return ret_val;

L10300:
    if (findex_1.mdir != 270 || findex_1.mloc != 162) {
        goto L10400;
    }
    findex_1.poleuf = 0;
/* lower into hole. */
    rspeak_(&c__753);
    return ret_val;

L10400:
    i__1 = findex_1.poleuf + 753;
    rspeak_(&i__1);
/* poleuf = 1 or 2. */
    findex_1.poleuf = 1;
/* now on floor. */
    return ret_val;

/* O42-- Mirror switch */

L11000:
    if (prsvec_1.prsa != 112) {
        goto L10;
    }
/* push? */
    if (findex_1.mrpshf) {
        goto L11300;
    }
/* already pushed? */
    rspeak_(&c__756);
/* button goes in. */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* blocked? */
        if (qhere_(&i__, &c__160) && i__ != 171) {
            goto L11200;
        }
/* L11100: */
    }
    rspeak_(&c__757);
/* nothing in beam. */
    return ret_val;

L11200:
    cevent_1.cflag[20] = TRUE_;
/* mirror opens. */
    cevent_1.ctick[20] = 7;
    findex_1.mrpshf = TRUE_;
    findex_1.mropnf = TRUE_;
    return ret_val;

L11300:
    rspeak_(&c__758);
/* mirror already open. */
    return ret_val;
/* NOBJS, PAGE 8 */

/* O43-- Beam function */

L12000:
    if (prsvec_1.prsa != 132 || prsvec_1.prso != 171) {
        goto L12100;
    }
    rspeak_(&c__759);
/* take beam, joke. */
    return ret_val;

L12100:
    i__ = prsvec_1.prso;
/* assume blk with dirobj */
    if (prsvec_1.prsa == 144 && prsvec_1.prsi == 171) {
        goto L12200;
    }
    if (prsvec_1.prsa != 138 || prsvec_1.prso != 171 || prsvec_1.prsi == 0) {
        goto L10;
    }
/* break beam with x? */
    i__ = prsvec_1.prsi;
L12200:
    if (objcts_1.oadv[i__ - 1] != play_1.winner) {
        goto L12300;
    }
/* carrying? */
    newsta_(&i__, &c__0, &play_1.here, &c__0, &c__0);
/* drop obj. */
    rspsub_(&c__760, &objcts_1.odesc2[i__ - 1]);
    return ret_val;

L12300:
    j = 761;
/* assume not in room. */
    if (qhere_(&i__, &play_1.here)) {
        j = 762;
    }
/* in room? */
    rspsub_(&j, &objcts_1.odesc2[i__ - 1]);
/* describe. */
    return ret_val;

/* O44-- Bronze door */

L13000:
    if (play_1.here == 186 || (findex_1.lcell == 4 && (play_1.here == 184 || 
            play_1.here == 179))) {
        goto L13100;
    }
    rspeak_(&c__763);
/* door not there. */
    return ret_val;

L13100:
    if (! opncls_(&c__172, &c__764, &c__765)) {
        goto L10;
    }
/* open/close? */
    if (play_1.here == 186 && (objcts_1.oflag2[c__172 - 1] & 8) != 0) {
        rspeak_(&c__766);
    }
/* descr view. */
    return ret_val;

/* O45-- Quiz door */

L14000:
    if (prsvec_1.prsa != 125 && prsvec_1.prsa != 126) {
        goto L14100;
    }
    rspeak_(&c__767);
/* door wont move. */
    return ret_val;

L14100:
    if (prsvec_1.prsa != 118) {
        goto L10;
    }
/* knock? */
    if (findex_1.inqstf) {
        goto L14200;
    }
/* tried it already? */
    findex_1.inqstf = TRUE_;
/* start inquisition. */
    cevent_1.cflag[22] = TRUE_;
    cevent_1.ctick[22] = 2;
    findex_1.quesno = rnd_(&c__8);
/* select question. */
    findex_1.nqatt = 0;
    findex_1.corrct = 0;
    rspeak_(&c__768);
/* announce rules. */
    rspeak_(&c__769);
    i__1 = findex_1.quesno + 770;
    rspeak_(&i__1);
/* ask question. */
    return ret_val;

L14200:
    rspeak_(&c__798);
/* no reply. */
    return ret_val;

/* O46-- Locked door */

L15000:
    if (prsvec_1.prsa != 125) {
        goto L10;
    }
/* open? */
    rspeak_(&c__778);
/* cant. */
    return ret_val;

/* O47-- Cell door */

L16000:
    ret_val = opncls_(&c__175, &c__779, &c__780);
/* open/close? */
    return ret_val;
/* NOBJS, PAGE 9 */

/* O48-- Dialbutton */

L17000:
    if (prsvec_1.prsa != 112) {
        goto L10;
    }
/* push? */
    rspeak_(&c__809);
/* click. */
    if ((objcts_1.oflag2[c__175 - 1] & 8) != 0) {
        rspeak_(&c__810);
    }
/* close cell door. */
    objcts_1.oflag2[174] = objcts_1.oflag2[174] & -9;
    objcts_1.oflag2[171] = objcts_1.oflag2[171] & -9;
    if (findex_1.lcell == findex_1.pnumb) {
        return ret_val;
    }

/* any change? */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* relocate old to hyper. */
        if (objcts_1.oroom[i__ - 1] == 184 && (objcts_1.oflag1[i__ - 1] & 
                4096) == 0) {
            i__2 = findex_1.lcell * 500;
            newsta_(&i__, &c__0, &i__2, &c__0, &c__0);
        }
        if (objcts_1.oroom[i__ - 1] == findex_1.pnumb * 500) {
            newsta_(&i__, &c__0, &c__184, &c__0, &c__0);
        }
/* move in new hyper. */
/* L17100: */
    }

    objcts_1.oflag1[171] = objcts_1.oflag1[171] & -32769;
    if (findex_1.pnumb == 4) {
        objcts_1.oflag1[171] = objcts_1.oflag1[171] | 32768;
    }

    if (advs_1.aroom[0] != 184) {
        goto L17400;
    }
/* player in cell? */
    if (findex_1.lcell != 4) {
        goto L17200;
    }
/* in right cell? */
    objcts_1.oflag1[171] = objcts_1.oflag1[171] | 32768;
    f = moveto_(&c__186, &c__1);
/* yes, moveto ncell. */
    goto L17400;
L17200:
    f = moveto_(&c__185, &c__1);

/* no, moveto pcell. */
L17400:
    findex_1.lcell = findex_1.pnumb;
    return ret_val;
/* NOBJS, PAGE 10 */

/* O49-- Dial indicator */

L18000:
    if (prsvec_1.prsa != 129) {
        goto L18100;
    }
/* spin? */
    findex_1.pnumb = rnd_(&c__8) + 1;
/* whee! */
    i__1 = findex_1.pnumb + 712;
    rspsub_(&c__797, &i__1);
    return ret_val;

L18100:
    if (prsvec_1.prsa != 122 && prsvec_1.prsa != 144 && prsvec_1.prsa != 159) 
            {
        goto L10;
    }
    if (prsvec_1.prsi != 0) {
        goto L18200;
    }
/* turn dial to x? */
    rspeak_(&c__806);
/* must specify. */
    return ret_val;

L18200:
    if (prsvec_1.prsi >= 178 && prsvec_1.prsi <= 185) {
        goto L18300;
    }
    rspeak_(&c__807);
/* must be digit. */
    return ret_val;

L18300:
    findex_1.pnumb = prsvec_1.prsi - 177;
/* set up new. */
    i__1 = findex_1.pnumb + 712;
    rspsub_(&c__808, &i__1);
    return ret_val;

/* O50-- Global mirror */

L19000:
    ret_val = mirpan_(&c__832, &c_false);
    return ret_val;

/* O51-- Global panel */

L20000:
    if (play_1.here != 166) {
        goto L20100;
    }
/* at front door? */
    if (prsvec_1.prsa != 125 && prsvec_1.prsa != 126) {
        goto L10;
    }
    rspeak_(&c__843);
/* panel in door, nogo. */
    return ret_val;

L20100:
    ret_val = mirpan_(&c__838, &c_true);
    return ret_val;

/* O52-- Puzzle Room slit */

L21000:
    if (prsvec_1.prsa != 144 || prsvec_1.prsi != 187) {
        goto L10;
    }
    if (prsvec_1.prso != 188) {
        goto L21100;
    }
/* put card in slit? */
    newsta_(&prsvec_1.prso, &c__863, &c__0, &c__0, &c__0);
/* kill card. */
    findex_1.cpoutf = TRUE_;
/* open door. */
    return ret_val;

L21100:
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 32) == 0 && (objcts_1.oflag2[
            prsvec_1.prso - 1] & 128) == 0) {
        goto L21200;
    }
    i__1 = rnd_(&c__6) + 552;
    rspeak_(&i__1);
/* joke for vill, vict. */
    return ret_val;

L21200:
    newsta_(&prsvec_1.prso, &c__0, &c__0, &c__0, &c__0);
/* kill object. */
    rspsub_(&c__864, &odo2);
/* describe. */
    return ret_val;
/* NOBJS, PAGE 11 */

/* O53-- Global brochure or stamp */

L22000:
    if (prsvec_1.prso != 196) {
        goto L22100;
    }
/* stamp? */
    if (prsvec_1.prsa == 132) {
        objcts_1.oflag1[194] = objcts_1.oflag1[194] & -129;
    }
    goto L10;

/* do normal take. */
L22100:
    if (prsvec_1.prso != 195 || (prsvec_1.prsa != 120 && prsvec_1.prsa != 100)
            ) {
        goto L22200;
    }
/* examine brochure? */
    rspeak_(&c__942);
/* describe. */
    if (objcts_1.ocan[195] == 195) {
        rspeak_(&c__943);
    }
    return ret_val;

L22200:
    if (prsvec_1.prsa != 127 || ! findex_1.broc1f) {
        goto L22300;
    }
    rspeak_(&c__944);
/* on the way. */
    return ret_val;

L22300:
    if (prsvec_1.prsa != 166) {
        goto L22400;
    }
/* send? */
    if (findex_1.broc2f) {
        rspeak_(&c__945);
    }
/* already got it. */
    if (findex_1.broc1f && ! findex_1.broc2f) {
        rspeak_(&c__944);
    }
/* on the way. */
    if (! findex_1.broc1f) {
        rspeak_(&c__947);
    }
/* postal service. */
    findex_1.broc1f = TRUE_;
/* send for brochure. */
    return ret_val;

L22400:
    if (prsvec_1.prso != 262) {
        goto L10;
    }
/* global brochure? */
    rspeak_(&c__1071);
/* pretend it's not there */
    return ret_val;

/* O54-- Global ground */

L23000:
    if (play_1.here == 116) {
        goto L36000;
    }
/* at sandy beach? then s */
    if (prsvec_1.prsa != 89) {
        goto L10;
    }
/* dig? */
    rspeak_(&c__924);
/* can't do it. */
    return ret_val;

/* O55-- Global granite wall */

L24000:
    i__ = 916;
/* joke for take. */
    if (prsvec_1.prsa == 132) {
        goto L24100;
    }
/* take? */
    i__ = 918;
/* temple, treasure find. */
    if (play_1.here == 58) {
        i__ = 917;
    }
/* slide find. */
    if (prsvec_1.prsa != 127) {
        goto L10;
    }
/* find? */
L24100:
    rspeak_(&i__);
/* tell all. */
    return ret_val;
/* NOBJS, PAGE 12 */

/* O56-- Global house */

L25000:
    if (play_1.here >= 2 && play_1.here <= 5) {
        goto L25200;
    }
    if (prsvec_1.prsa != 127) {
        goto L25100;
    }
/* find, not at house? */
    i__ = 892;
/* joke 1. */
    if (play_1.here == 36) {
        i__ = 893;
    }
/* joke 2 for clearing. */
    rspeak_(&i__);
    return ret_val;

L25100:
    rspeak_(&c__894);
/* not there. */
    return ret_val;

L25200:
    if (prsvec_1.prsa != 127) {
        goto L25300;
    }
/* find, at house? */
    rspeak_(&c__895);
/* right there. */
    return ret_val;

L25300:
    if (prsvec_1.prsa != 120) {
        goto L25400;
    }
/* look at? */
    rspeak_(&c__896);
/* a nice house. */
    return ret_val;

L25400:
    if (prsvec_1.prsa != 137) {
        goto L25500;
    }
/* burn? */
    rspeak_(&c__897);
/* bad boy. */
    return ret_val;

L25500:
    if (prsvec_1.prsa != 86) {
        goto L10;
    }
/* go through? */
    if (play_1.here == 5) {
        goto L25600;
    }
/* at east side? */
    rspeak_(&c__898);
/* can't do it */
    return ret_val;

L25600:
    if ((objcts_1.oflag2[c__63 - 1] & 8) != 0) {
        goto L25700;
    }
/* window open? */
    rspeak_(&c__899);
/* no, shut */
    return ret_val;

L25700:
    f = moveto_(&c__6, &play_1.winner);
/* move into kitchen. */
    f = rmdesc_(&c__0);
/* describe room */
    return ret_val;

/* O57-- Barred window in white house */

L26000:
    if (prsvec_1.prsa != 125 && prsvec_1.prsa != 152 && prsvec_1.prsa != 86) {
        goto L26100;
    }
/* open, look in, enter? */
    rspeak_(&c__1039);
/* window barred. */
    return ret_val;

L26100:
    if (prsvec_1.prsa != 126) {
        goto L10;
    }
/* close? */
    rspeak_(&c__1040);
/* already closed and loc */
    return ret_val;
/* NOBJS, PAGE 13 */

/* O58-- Global well */

L27000:
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 8192) == 0 || prsvec_1.prso == 
            11 || (prsvec_1.prsa != 148 && prsvec_1.prsa != 144 && 
            prsvec_1.prsa != 145)) {
        goto L10;
    }
/* throw, put, drop x in */
    rspsub_(&c__939, &odo2);
    newsta_(&prsvec_1.prso, &c__0, &c__143, &c__0, &c__0);
/* put in well bottom. */
    goto L50;

/* O59-- Global rope */

/* go see if now dark. */
L28000:
    if (prsvec_1.prsa != 132) {
        goto L28100;
    }
/* take? */
    rspeak_(&c__1006);
/* not a good idea. */
    return ret_val;

L28100:
    if (prsvec_1.prsa != 145) {
        goto L28300;
    }
/* drop? */
    rspeak_(&c__1007);
/* you lose. */
L28200:
    f = moveto_(&c__9, &play_1.winner);
/* drop into cellar. */
    f = rmdesc_(&c__3);
/* describe. */
    return ret_val;

L28300:
    if (prsvec_1.prsa == 156 || prsvec_1.prsa == 157 || prsvec_1.prsa == 158) 
            {
        goto L10;
    }
/* normal climb. */
    rspeak_(&c__1008);
/* not a good idea. */
    return ret_val;

/* O60-- Global slide */

L29000:
    if (prsvec_1.prsa != 86 && (prsvec_1.prsa != 144 || prsvec_1.prso != 
            advs_1.aobj[0])) {
        goto L29100;
    }
    rspeak_(&c__1010);
/* down the slide. */
    goto L28200;

L29100:
    if (prsvec_1.prsa != 144) {
        goto L10;
    }
/* put in slide? */
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 8192) != 0) {
        goto L29200;
    }
    i__1 = rnd_(&c__6) + 552;
    rspeak_(&i__1);
/* can't take it. */
    return ret_val;

L29200:
    if (prsvec_1.prso != findex_1.ttie) {
        goto L29300;
    }
/* tied object? */
    objcts_1.oflag1[findex_1.ttie - 1] = objcts_1.oflag1[findex_1.ttie - 1] & 
            -513;
    objcts_1.oflag1[11] = objcts_1.oflag1[11] & -513;
    objcts_1.oflag2[11] = objcts_1.oflag2[11] & -2049;
    objcts_1.odesc1[37] = 1032;
/* restored untied desc. */
    objcts_1.odesc1[32] = 1033;
    findex_1.ttie = 0;
/* not tied any more. */
    newsta_(&c__12, &c__0, &c__9, &c__0, &c__0);
/* rope is now here. */
L29300:
    rspsub_(&c__1011, &odo2);
    newsta_(&prsvec_1.prso, &c__0, &c__9, &c__0, &c__0);
/* put in cellar, */
    if (prsvec_1.prso == 11) {
        newsta_(&prsvec_1.prso, &c__0, &c__0, &c__0, &c__0);
    }
/* unless water. */
    goto L50;
/* NOBJS, PAGE 14 */

/* O61-- Barrel */

/* go see if now dark. */
L30000:
    if (*arg != 1) {
        goto L10;
    }
/* read in? */
    i__ = 0;
/* default. */
    if (prsvec_1.prsa == 142) {
        i__ = 920;
    }
/* walk? */
    if (prsvec_1.prsa == 119) {
        i__ = 921;
    }
/* look? */
    if (prsvec_1.prsa == 137) {
        i__ = 922;
    }
/* burn? */
    if (prsvec_1.prsa == 132) {
        i__ = rnd_(&c__6) + 552;
    }
/* take? */
    rspeak_(&i__);
    ret_val = i__ != 0;
/* handled? */
    return ret_val;

/* O62-- Hot bell */

L31000:
    if (prsvec_1.prsa != 132) {
        goto L31100;
    }
/* take? */
    rspeak_(&c__972);
/* too hot. */
    return ret_val;

L31100:
    if (prsvec_1.prsa != 87) {
        goto L31400;
    }
/* ring? */
    if (prsvec_1.prsi != 0) {
        goto L31200;
    }
/* with something? */
    rspeak_(&c__973);
/* too hot. */
    return ret_val;

L31200:
    if ((objcts_1.oflag1[prsvec_1.prsi - 1] & 16) == 0) {
        goto L31300;
    }
    rspsub_(&c__974, &odi2);
/* burnable is consumed. */
    newsta_(&prsvec_1.prsi, &c__0, &c__0, &c__0, &c__0);
/* vanish it. */
    return ret_val;

L31300:
    i__ = 975;
/* joke 1. */
    if (prsvec_1.prsi == 259) {
        i__ = 973;
    }
/* joke for hands. */
    rspeak_(&i__);
    return ret_val;

L31400:
    if (prsvec_1.prsa != 160) {
        goto L10;
    }
/* pour on? */
    newsta_(&c__190, &c__0, &c__0, &c__0, &c__0);
/* vanish bell. */
    newsta_(&c__46, &c__976, &c__93, &c__0, &c__0);
/* insert real bell. */
    if (prssta_1.lastit == 190) {
        prssta_1.lastit = 46;
    }
/* fix last it reference. */
    newsta_(&prsvec_1.prso, &c__0, &c__0, &c__0, &c__0);
/* vanish water. */
    cevent_1.ctick[29] = 0;
/* cancel cooling. */
    return ret_val;

/* O63-- Axe */

L32000:
    if (prsvec_1.prsa != 132) {
        goto L10;
    }
/* take? */
    rspeak_(&c__891);
/* too hot. */
    return ret_val;
/* NOBJS, PAGE 15 */

/* O64-- Timber (also coffin) */

L33000:
    if (prsvec_1.prsa != 132 || prsvec_1.prso != findex_1.ttie) {
        goto L10;
    }
    rspsub_(&c__1009, &odo2);
/* rope becomes untied. */
    objcts_1.oflag1[findex_1.ttie - 1] = objcts_1.oflag1[findex_1.ttie - 1] & 
            -513;
    objcts_1.oflag1[11] = objcts_1.oflag1[11] & -513;
    objcts_1.oflag2[11] = objcts_1.oflag2[11] & -2049;
    objcts_1.odesc1[37] = 1032;
/* restored untied desc. */
    objcts_1.odesc1[32] = 1033;
    findex_1.ttie = 0;
/* not tied any more. */
    newsta_(&c__12, &c__0, &play_1.here, &c__0, &c__0);
/* rope is now here. */
    goto L10;

/* O65-- Guano */

/* don't handle. */
L34000:
    if (prsvec_1.prsa != 89) {
        goto L10;
    }
/* dig? */
/* Computing MIN */
    i__1 = 4, i__2 = findex_1.rvgua + 1;
    findex_1.rvgua = min(i__1,i__2);
/* go to next state. */
    i__1 = findex_1.rvgua + 91;
    rspeak_(&i__1);
/* describe. */
    return ret_val;

/* O66-- Alice room leak */

L35000:
    if (prsvec_1.prsa != 132) {
        goto L35100;
    }
/* take? */
    i__1 = rnd_(&c__6) + 552;
    rspeak_(&i__1);
/* joke. */
    return ret_val;

L35100:
    if (prsvec_1.prsa != 106 || prsvec_1.prso != 191) {
        goto L10;
    }
/* plug leak? */
    rspeak_(&c__929);
/* can't reach. */
    return ret_val;
/* NOBJS, PAGE 16 */

/* O67-- Sand */

L36000:
    if (prsvec_1.prsa != 89) {
        goto L10;
    }
/* dig? */
    ++findex_1.rvsnd;
/* go to next state. */
    switch (findex_1.rvsnd) {
        case 1:  goto L36100;
        case 2:  goto L36100;
        case 3:  goto L36100;
        case 4:  goto L36400;
        case 5:  goto L36500;
    }
/* process */
    bug_(&c__2, &findex_1.rvsnd);

L36100:
    i__1 = findex_1.rvsnd + 85;
    rspeak_(&i__1);
/* 1..3, describe. */
    return ret_val;

L36400:
    if ((objcts_1.oflag1[85] & 32768) == 0) {
        rspeak_(&c__89);
    }
    objcts_1.oflag1[85] = objcts_1.oflag1[85] | 32768;
/* 4, statue appears. */
    return ret_val;

L36500:
    findex_1.rvsnd = 0;
/* 5, sand collapses. */
    if (objcts_1.oroom[85] == play_1.here) {
        objcts_1.oflag1[85] = objcts_1.oflag1[85] & -32769;
    }
    jigsup_(&c__90);
/* gonzo. */
    return ret_val;

/* O68-- Torch */

L37000:
    if (prsvec_1.prsa != 124) {
        goto L10;
    }
/* extinguish? */
    rspeak_(&c__900);
/* can't do it. */
    return ret_val;

/* O69-- Tool chests */

L38000:
    if (prsvec_1.prsa != 120) {
        goto L38100;
    }
/* examine? */
    rspeak_(&c__907);
/* describe. */
    return ret_val;

L38100:
    if (prsvec_1.prsa != 132) {
        goto L10;
    }
/* take? */
    rspeak_(&c__908);
/* can't do it. */
    return ret_val;
/* NOBJS, PAGE 17 */

/* O70-- Palantir door */

L39000:
    if (prsvec_1.prsa != 153 || ! findex_1.matf) {
        goto L39100;
    }
    rspeak_(&c__995);
/* mat under door. */
    return ret_val;

L39100:
    if (prsvec_1.prsa != 93) {
        goto L39500;
    }
/* unlock? */
    if (prsvec_1.prsi != 205) {
        goto L39400;
    }
/* with rusty key? */
L39200:
    i__1 = play_1.here + 10;
    if (objcts_1.ocan[204] == play_1.here + 10 || qempty_(&i__1)) {
        goto L39300;
    }
/* keyhole empty? */
L39250:
    rspeak_(&c__991);
/* no */
    return ret_val;

L39300:
    rspeak_(&c__996);
/* now unlocked. */
    findex_1.punlkf = TRUE_;
    return ret_val;

L39400:
    i__ = 997;
/* joke 1. */
    if (prsvec_1.prsi == 23) {
        i__ = 998;
    }
/* joke 2 for keys. */
    rspeak_(&i__);
    return ret_val;

L39500:
    if (prsvec_1.prsa != 92) {
        goto L39700;
    }
/* lock? */
    if (prsvec_1.prsi == 205) {
        goto L39600;
    }
/* with rusty key? */
    rspeak_(&c__999);
/* no */
    return ret_val;

L39600:
    i__1 = play_1.here + 10;
    if (objcts_1.ocan[204] != play_1.here + 10 && ! qempty_(&i__1)) {
        goto L39250;
    }
    rspeak_(&c__1000);
/* now locked. */
    findex_1.punlkf = FALSE_;
    return ret_val;

L39700:
    if (prsvec_1.prsa != 161 || (prsvec_1.prso != 112 && prsvec_1.prso != 91 
            && prsvec_1.prso != 106 && prsvec_1.prso != 186 && prsvec_1.prso 
            != 143 && prsvec_1.prso != 49)) {
        goto L39800;
    }
/* put small paper? */
    i__1 = play_1.here ^ 1;
    newsta_(&prsvec_1.prso, &c__1001, &i__1, &c__0, &c__0);
/* put in other room. */
    return ret_val;

L39800:
    if (prsvec_1.prsa != 125 && prsvec_1.prsa != 126) {
        goto L10;
    }
    if (! findex_1.punlkf) {
        goto L39900;
    }
/* open or close, unlocke */
    ret_val = opncls_(&prsvec_1.prso, &c__1002, &c__1003);
/* open or close. */
    return ret_val;

L39900:
    rspeak_(&c__1000);
/* door locked. */
    return ret_val;

/* O71-- Palantir window */

L40000:
    if (prsvec_1.prsa != 86) {
        goto L40100;
    }
/* go through? */
    rspeak_(&c__1004);
/* can't do it. */
    return ret_val;

L40100:
    if (prsvec_1.prsa != 152) {
        goto L10;
    }
/* look in? */
    if ((objcts_1.oflag2[c__197 - 1] & 8) != 0) {
        goto L40200;
    }
/* door open? */
    findex_1.plookf = TRUE_;
/* set window flag. */
    svflag = rooms_1.rflag[(play_1.here ^ 1) - 1];
/* save room flags from o */
    i__1 = play_1.here ^ 1;
    f = moveto_(&i__1, &play_1.winner);
/* go to other room. */
    f = rmdesc_(&c__3);
/* describe it. */
    i__1 = play_1.here ^ 1;
    f = moveto_(&i__1, &play_1.winner);
/* come back. */
    rooms_1.rflag[(play_1.here ^ 1) - 1] = svflag;
/* restore flags. */
    return ret_val;

L40200:
    rspeak_(&c__1005);
/* door open, dummy. */
    return ret_val;
/* NOBJS, PAGE 18 */

/* O72-- Keyhole lids */

L41000:
    if (prsvec_1.prsa != 125 && prsvec_1.prsa != 109) {
        goto L41100;
    }
    rspeak_(&c__985);
/* open lid. */
    objcts_1.oflag2[prsvec_1.prso - 1] = objcts_1.oflag2[prsvec_1.prso - 1] | 
            8;
    return ret_val;

L41100:
    if (prsvec_1.prsa != 126 && prsvec_1.prsa != 110) {
        goto L10;
    }
    i__1 = prsvec_1.prso + 2;
    if (qempty_(&i__1)) {
        goto L41200;
    }
/* keyhole empty? */
    rspeak_(&c__986);
/* can't do it. */
    return ret_val;

L41200:
    rspeak_(&c__987);
/* close lid. */
    objcts_1.oflag2[prsvec_1.prso - 1] = objcts_1.oflag2[prsvec_1.prso - 1] & 
            -9;
    return ret_val;

/* O73-- Keyholes */

L42000:
    if (prsvec_1.prsa != 152) {
        goto L42200;
    }
/* look in? */
    i__ = 988;
/* doesn't work. */
    i__1 = play_1.here ^ 1;
    if ((objcts_1.oflag2[c__200 - 1] & 8) != 0 && (objcts_1.oflag2[c__201 - 1]
             & 8) != 0 && qempty_(&c__202) && qempty_(&c__203) && lit_(&i__1))
             {
        i__ = 989;
    }
/* does work */
    rspeak_(&i__);
    return ret_val;

L42200:
    if (prsvec_1.prsa != 144) {
        goto L10;
    }
/* put? */
    i__1 = prsvec_1.prsi - 2;
    if ((objcts_1.oflag2[i__1 - 1] & 8) != 0) {
        goto L42300;
    }
/* lid open? */
    rspeak_(&c__990);
/* no. */
    return ret_val;

L42300:
    if (qempty_(&prsvec_1.prsi)) {
        goto L42400;
    }
/* keyhole empty? */
    rspeak_(&c__991);
/* no. */
    return ret_val;

L42400:
    if (prsvec_1.prso != 57 && prsvec_1.prso != 23 && prsvec_1.prso != 92 && 
            prsvec_1.prso != 205) {
        goto L42700;
    }
    i__1 = prsvec_1.prsi ^ 1;
    if (qempty_(&i__1)) {
        goto L10;
    }
/* nothing to shove. */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
        if (objcts_1.ocan[i__ - 1] == (prsvec_1.prsi ^ 1)) {
            goto L42600;
        }
/* find obj in keyhole. */
/* L42500: */
    }
    i__1 = prsvec_1.prsi ^ 1;
    bug_(&c__67, &i__1);

L42600:
    i__1 = play_1.here ^ 1;
    newsta_(&i__, &c__992, &i__1, &c__0, &c__0);
/* obj falls to floor. */
    if (findex_1.matf) {
        findex_1.matobj = i__;
    }
/* if mat, falls on that. */
    goto L10;

/* finish put. */
L42700:
    rspsub_(&c__993, &odo2);
/* doesn't fit. */
    return ret_val;
/* NOBJS, PAGE 19 */

/* O74-- Rusty key */

L43000:
    if (prsvec_1.prsa != 116) {
        goto L10;
    }
/* turn? */
    if (findex_1.punlkf) {
        goto L39600;
    }
/* unlock? */
    goto L39200;

/* O75-- Palantirs */

/* otherwise lock. */
L44000:
    if (prsvec_1.prsa != 152) {
        goto L10;
    }
/* look in? */
    obj = 206;
/* assume dest = palan. */
    if (prsvec_1.prso == 206) {
        obj = 209;
    }
/* if palan, then pal3. */
    if (prsvec_1.prso == 209) {
        obj = 126;
    }
/* if pal3, then sphere. */
    j = play_1.here;
/* save here. */
    k = objcts_1.ocan[obj - 1];
/* get dest container. */
    if (objcts_1.oroom[obj - 1] != 0) {
        j = objcts_1.oroom[obj - 1];
    }
/* if dest in room, use. */
    if (k != 0) {
        j = objcts_1.oroom[k - 1];
    }
/* if cont, use cont room */
    if (j == 0 || objcts_1.oadv[obj - 1] == -61) {
        goto L44200;
    }
    if (! lit_(&j)) {
        goto L44200;
    }
/* see destination? */
    if (k == 0) {
        goto L44100;
    }
/* contained? */
    if ((objcts_1.oflag1[k - 1] & 2048) == 0 && ! ((objcts_1.oflag2[k - 1] & 
            8) != 0)) {
        goto L44200;
    }
/* see out of it? */
L44100:
    rspeak_(&c__1024);
/* start vision. */
    objcts_1.oflag1[obj - 1] = objcts_1.oflag1[obj - 1] & -32769;
/* object not visible. */
    svhere = play_1.here;
/* save state. */
    svflag = rooms_1.rflag[j - 1];
    f = moveto_(&j, &play_1.winner);
/* move to new room. */
    f = rmdesc_(&c__3);
/* describe. */
    if (j == svhere) {
        rspeak_(&c__1026);
    }
/* was it here? */
    f = moveto_(&svhere, &play_1.winner);
/* come back. */
    rooms_1.rflag[j - 1] = svflag;
/* restore flags. */
    objcts_1.oflag1[obj - 1] = objcts_1.oflag1[obj - 1] | 32768;
/* restore object. */
    return ret_val;

L44200:
    rspeak_(&c__1023);
/* nothing to see. */
    return ret_val;

/* O76-- Mat */

L45000:
    if (prsvec_1.prsa != 161 || prsvec_1.prsi != 197) {
        goto L45100;
    }
    findex_1.matf = TRUE_;
/* put under right door. */
    newsta_(&prsvec_1.prso, &c__983, &play_1.here, &c__0, &c__0);
    return ret_val;

L45100:
    if ((prsvec_1.prsa != 132 && prsvec_1.prsa != 122) || findex_1.matobj == 
            0) {
        goto L10;
    }
/* take or move? */
    newsta_(&findex_1.matobj, &c__0, &play_1.here, &c__0, &c__0);
/* materialize mat object */
    rspsub_(&c__984, &objcts_1.odesc2[findex_1.matobj - 1]);
    findex_1.matobj = 0;
    findex_1.matf = FALSE_;
    if (prsvec_1.prsa == 132) {
        goto L10;
    }
/* do normal take. */
    return ret_val;

/* O77-- Stove */

/* move is done. */
L46000:
    if (prsvec_1.prsa != 132 && prsvec_1.prsa != 111 && prsvec_1.prsa != 141 
            && prsvec_1.prsa != 138) {
        goto L46100;
    }
/* take, feel, attack, mu */
    rspeak_(&c__994);
/* too hot. */
    return ret_val;

L46100:
    if (prsvec_1.prsa != 148) {
        goto L10;
    }
/* throw at stove? */
    if (prsvec_1.prso != 11) {
        goto L46200;
    }
/* water? */
    newsta_(&c__11, &c__978, &c__0, &c__0, &c__0);
/* evaporates. */
    return ret_val;

L46200:
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 16) == 0) {
        goto L10;
    }
/* burnable? */
    rspsub_(&c__974, &odo2);
/* burns up. */
    newsta_(&prsvec_1.prso, &c__0, &c__0, &c__0, &c__0);
/* vanishes. */
    return ret_val;

} /* nobjs_ */



/* MIRPAN--      Processor for global mirror/panel */

/* Declarations */

logical mirpan_(integer *st, logical *pnf)
{
    /* System generated locals */
    integer i__1;
    logical ret_val;

    /* Local variables */
    integer mrbf, num;


    ret_val = TRUE_;
    num = mrhere_(&play_1.here);
/* get mirror num. */
    if (num != 0) {
        goto L100;
    }
/* any here? */
    rspeak_(st);
/* no, lose. */
    return ret_val;

L100:
    if (prsvec_1.prsa != 122 && prsvec_1.prsa != 125) {
        goto L200;
    }
    i__1 = *st + 1;
    rspeak_(&i__1);
/* cant open or move. */
    return ret_val;

L200:
    mrbf = 0;
/* assume mirror ok. */
    if ((num == 1 && ! findex_1.mr1f) || (num == 2 && ! findex_1.mr2f)) {
        mrbf = 1;
    }
    if (*pnf || (prsvec_1.prsa != 152 && prsvec_1.prsa != 120 && 
            prsvec_1.prsa != 119)) {
        goto L300;
    }
    i__1 = mrbf + 844;
    rspeak_(&i__1);
/* look in mirror. */
    return ret_val;

L300:
    if (prsvec_1.prsa != 138) {
        goto L400;
    }
/* break? */
    i__1 = *st + 2 + mrbf;
    rspeak_(&i__1);
/* do it. */
    if (num == 1 && ! (*pnf)) {
        findex_1.mr1f = FALSE_;
    }
    if (num == 2 && ! (*pnf)) {
        findex_1.mr2f = FALSE_;
    }
    return ret_val;

L400:
    if (*pnf || mrbf == 0) {
        goto L500;
    }
/* broken mirror? */
    rspeak_(&c__846);
    return ret_val;

L500:
    if (prsvec_1.prsa != 112) {
        goto L600;
    }
/* push? */
    i__1 = *st + 3 + num;
    rspeak_(&i__1);
    return ret_val;

L600:
    ret_val = FALSE_;
/* cant handle it. */
    return ret_val;

} /* mirpan_ */



/* BALLOP-       Balloon function */

/* Declarations */

logical ballop_(integer *arg)
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */


    ret_val = TRUE_;
/* assume wins. */
    if (*arg != 2) {
        goto L200;
    }
/* readout? */
    if (prsvec_1.prsa != 119) {
        goto L10;
    }
/* only process look. */
    if (findex_1.binff != 0) {
        goto L50;
    }
/* inflated? */
    rspeak_(&c__543);
/* no. */
    goto L100;
L50:
    rspsub_(&c__544, &objcts_1.odesc2[findex_1.binff - 1]);
/* yes. */
L100:
    if (findex_1.btief != 0) {
        rspeak_(&c__545);
    }
/* hooked? */
    goto L10;

L200:
    if (*arg != 1) {
        goto L500;
    }
/* readin? */
    if (prsvec_1.prsa != 142) {
        goto L300;
    }
/* walk? */
    if (findxt_(&prsvec_1.prso, &play_1.here)) {
        goto L250;
    }
/* valid exit? */
    rspeak_(&c__546);
/* no, joke. */
    return ret_val;

L250:
    if (findex_1.btief == 0) {
        goto L275;
    }
/* tied up? */
    rspeak_(&c__547);
/* yes, joke. */
    return ret_val;

L275:
    if (curxt_1.xtype != 1) {
        goto L10;
    }
/* normal exit? */
    if ((rooms_1.rflag[curxt_1.xroom1 - 1] & 256) != 0) {
        goto L10;
    }
    play_1.bloc = curxt_1.xroom1;
    cevent_1.cflag[5] = TRUE_;
    cevent_1.ctick[5] = 3;
L10:
    ret_val = FALSE_;
    return ret_val;

L300:
    if (prsvec_1.prsa != 132 || prsvec_1.prso != findex_1.binff) {
        goto L350;
    }
    rspsub_(&c__548, &objcts_1.odesc2[findex_1.binff - 1]);
/* recep cont too hot. */
    return ret_val;

L350:
    if (prsvec_1.prsa != 144 || prsvec_1.prsi != 99 || qempty_(&c__99)) {
        goto L10;
    }
/* recep already full. */
    rspeak_(&c__549);
    return ret_val;

L500:
    if (prsvec_1.prsa != 137 || objcts_1.ocan[prsvec_1.prso - 1] != 99) {
        goto L10;
    }
    rspsub_(&c__550, &objcts_1.odesc2[prsvec_1.prso - 1]);
/* light fire in recep. */
    cevent_1.cflag[6] = TRUE_;
    cevent_1.ctick[6] = objcts_1.osize[prsvec_1.prso - 1] * 20;
    objcts_1.oflag1[prsvec_1.prso - 1] = (objcts_1.oflag1[prsvec_1.prso - 1] |
             73) & -24577;
/* burn it. */
    if (findex_1.binff != 0) {
        return ret_val;
    }
/* already inflated? */
    if (! findex_1.blabf) {
        newsta_(&c__112, &c__0, &c__0, &c__98, &c__0);
    }
/* insert label. */
    findex_1.blabf = TRUE_;
/* only once. */
    findex_1.binff = prsvec_1.prso;
    cevent_1.cflag[5] = TRUE_;
    cevent_1.ctick[5] = 3;
/* start countdown. */
    rspeak_(&c__551);
    return ret_val;

} /* ballop_ */



/* TROLLP-       Troll function */

/* Declarations */

logical trollp_(integer *arg)
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */
    integer i__;


    ret_val = TRUE_;
/* assume wins. */
    if (prsvec_1.prsa != 7) {
        goto L1100;
    }
/* fight? */
    if (objcts_1.ocan[19] == 19) {
        goto L10;
    }
/* got axe?  nothing. */
    i__ = 433;
/* assume cant get. */
    if (! qhere_(&c__20, &play_1.here) || prob_(&c__25, &c__10)) {
        goto L1050;
    }
/* here? */
    i__ = 434;
/* yes, recover. */
    newsta_(&c__20, &c__0, &c__0, &c__19, &c__0);
L1050:
    if (qhere_(&c__19, &play_1.here)) {
        rspeak_(&i__);
    }
/* if player here. */
    return ret_val;

L1100:
    if (prsvec_1.prsa != 2) {
        goto L1200;
    }
/* dead? */
    findex_1.trollf = TRUE_;
/* permit exits. */
    return ret_val;

L1200:
    if (prsvec_1.prsa != 5) {
        goto L1300;
    }
/* out? */
    findex_1.trollf = TRUE_;
/* permit exits. */
    objcts_1.oflag1[19] = objcts_1.oflag1[19] & -32769;
    objcts_1.odesc1[18] = 435;
/* troll out. */
    return ret_val;

L1300:
    if (prsvec_1.prsa != 4 && ((prsvec_1.prsa != 104 && prsvec_1.prsa != 107) 
            || objcts_1.ocapac[18] >= 0)) {
        goto L1400;
    }
/* wake from fight demon? */
/* wake, kick while out? */
    objcts_1.ocapac[18] = abs(objcts_1.ocapac[18]);
/* yes, wake him. */
    objcts_1.oflag1[19] = objcts_1.oflag1[19] | 32768;
    findex_1.trollf = FALSE_;
/* forbid exits. */
    objcts_1.odesc1[18] = 436;
/* troll in. */
    if (qhere_(&c__19, &play_1.here)) {
        rspeak_(&c__437);
    }
    return ret_val;

L1400:
    if (prsvec_1.prsa != 3) {
        goto L1500;
    }
/* first encounter? */
    ret_val = prob_(&c__33, &c__66);
/* 33% true unless badlk. */
    return ret_val;

L1500:
    if (prsvec_1.prsa != 122 && prsvec_1.prsa != 132 && prsvec_1.prsa != 138 
            && prsvec_1.prsa != 148 && prsvec_1.prsa != 146) {
        goto L2000;
    }
    if (objcts_1.ocapac[18] >= 0) {
        goto L1550;
    }
/* troll out? */
    objcts_1.ocapac[18] = abs(objcts_1.ocapac[18]);
/* yes, wake him. */
    objcts_1.oflag1[19] = objcts_1.oflag1[19] | 32768;
    findex_1.trollf = FALSE_;
/* forbid exits. */
    objcts_1.odesc1[18] = 436;
/* troll in. */
    rspeak_(&c__437);

L1550:
    if (prsvec_1.prsa != 132 && prsvec_1.prsa != 122) {
        goto L1600;
    }
    rspeak_(&c__438);
/* joke. */
    return ret_val;

L1600:
    if (prsvec_1.prsa != 138) {
        goto L1700;
    }
/* mung? */
    rspeak_(&c__439);
/* joke. */
    return ret_val;

L1700:
    if (prsvec_1.prso == 0) {
        goto L10;
    }
/* no object? */
    i__ = 440;
/* assume throw. */
    if (prsvec_1.prsa == 146) {
        i__ = 441;
    }
/* give? */
    rspsub_(&i__, &objcts_1.odesc2[prsvec_1.prso - 1]);
/* troll takes. */
    if (prsvec_1.prso == 13) {
        goto L1900;
    }
/* obj knife? */
    newsta_(&prsvec_1.prso, &c__442, &c__0, &c__0, &c__0);
/* no, eats it. */
    return ret_val;

L1900:
    rspeak_(&c__443);
/* knife, throws it back */
    objcts_1.oflag2[18] = objcts_1.oflag2[18] | 256;
/* and gets mad. */
    return ret_val;

L2000:
    if (! findex_1.trollf || prsvec_1.prsa != 151) {
        goto L10;
    }
    rspeak_(&c__366);
/* troll out. */
    return ret_val;

L10:
    ret_val = FALSE_;
/* couldnt handle it. */
    return ret_val;

} /* trollp_ */



/* CYCLOP-       Cyclops function */

/* Declarations */

logical cyclop_(integer *arg)
{
    /* System generated locals */
    integer i__1, i__2;
    logical ret_val;

    /* Local variables */
    integer i__;


    ret_val = TRUE_;
/* assume wins. */
    if (! findex_1.cyclof) {
        goto L100;
    }
/* asleep? */
    if (prsvec_1.prsa != 104 && prsvec_1.prsa != 138 && prsvec_1.prsa != 107 
            && prsvec_1.prsa != 137 && prsvec_1.prsa != 139 && prsvec_1.prsa 
            != 141) {
        goto L10;
    }
    findex_1.cyclof = FALSE_;
/* wake cyclops. */
    rspeak_(&c__187);
/* describe. */
    findex_1.rvcyc = abs(findex_1.rvcyc);
    objcts_1.oflag2[57] = objcts_1.oflag2[57] | 256;
    return ret_val;

L100:
    if (prsvec_1.prsa != 146) {
        goto L500;
    }
/* give? */
    if (prsvec_1.prso != 3) {
        goto L300;
    }
/* food? */
    if (findex_1.rvcyc < 0) {
        goto L200;
    }
/* already eaten? */
    newsta_(&c__3, &c__189, &c__0, &c__0, &c__0);
/* eats peppers. */
/* Computing MIN */
    i__1 = -1, i__2 = -findex_1.rvcyc;
    findex_1.rvcyc = min(i__1,i__2);
/* gets thirsty. */
L200:
    cevent_1.cflag[25] = TRUE_;
/* turn on cyclops timer. */
    cevent_1.ctick[25] = -1;
    return ret_val;

L300:
    if (prsvec_1.prso != 11) {
        goto L400;
    }
/* drink when thirsty? */
    if (findex_1.rvcyc >= 0) {
        goto L350;
    }
    newsta_(&prsvec_1.prso, &c__190, &c__0, &c__0, &c__0);
/* drinks and */
    findex_1.cyclof = TRUE_;
/* falls asleep. */
    objcts_1.oflag2[57] = objcts_1.oflag2[57] & -257;
    cevent_1.cflag[25] = FALSE_;
/* turn off cyclops timer */
    return ret_val;

L350:
    rspeak_(&c__191);
/* not thirsty. */
L10:
    ret_val = FALSE_;
/* fails. */
    return ret_val;

L400:
    i__ = 192;
/* assume inedible. */
    if (prsvec_1.prso == 2) {
        i__ = 193;
    }
/* garlic is joke. */
L450:
    rspeak_(&i__);
/* disdain it. */
    return ret_val;

L500:
    if (prsvec_1.prsa != 139 && prsvec_1.prsa != 141 && prsvec_1.prsa != 138 
            && prsvec_1.prsa != 148) {
        goto L600;
    }
    cevent_1.cflag[25] = TRUE_;
/* turn on cyclops timer. */
    cevent_1.ctick[25] = -1;
    i__ = 201;
/* assume not poke. */
    if (prsvec_1.prsa == 138) {
        i__ = 912;
    }
/* poke joke. */
    goto L450;

/* go remark and return. */
L600:
    i__ = 202;
/* assume take. */
    if (prsvec_1.prsa == 132) {
        goto L450;
    }
    i__ = 203;
/* assume tie. */
    if (prsvec_1.prsa == 114) {
        goto L450;
    }
    ret_val = FALSE_;
    return ret_val;

} /* cyclop_ */



/* THIEFP-       Thief function */

/* Declarations */

logical thiefp_(integer *arg)
{
    /* System generated locals */
    integer i__1;
    logical ret_val;

    /* Local variables */
    integer j, i__;


    ret_val = TRUE_;
/* assume wins. */
    if (prsvec_1.prsa != 7) {
        goto L100;
    }
/* fight? */
    if (objcts_1.ocan[61] == 61) {
        goto L10;
    }
/* got stilletto?  f. */
    if (qhere_(&c__62, &hack_1.thfpos)) {
        goto L50;
    }
/* can he recover it? */
    newsta_(&c__61, &c__0, &c__0, &c__0, &c__0);
/* no, vanish. */
    if (qhere_(&c__61, &play_1.here)) {
        rspeak_(&c__498);
    }
/* if hero, tell. */
    return ret_val;

L50:
    newsta_(&c__62, &c__0, &c__0, &c__61, &c__0);
/* yes, recover. */
    if (qhere_(&c__61, &play_1.here)) {
        rspeak_(&c__499);
    }
/* if hero, tell. */
    return ret_val;

L100:
    if (prsvec_1.prsa != 2) {
        goto L200;
    }
/* dead? */
    hack_1.thfact = FALSE_;
/* disable demon. */
    if (play_1.here != 103) {
        goto L150;
    }
/* in treasure room? */
    j = 501;
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* loop. */
        if (i__ == 59 || i__ == 61 || ! qhere_(&i__, &play_1.here)) {
            goto L125;
        }
/* is it here? */
        objcts_1.oflag1[i__ - 1] = objcts_1.oflag1[i__ - 1] | 32768;
/* rematerialize objects. */
        rspsub_(&j, &objcts_1.odesc2[i__ - 1]);
/* describe. */
        j = 502;
        if (! qempty_(&i__) && ((objcts_1.oflag1[i__ - 1] & 2048) != 0 || (
                objcts_1.oflag2[i__ - 1] & 8) != 0)) {
            princo_(&i__, &c__573, &c_true);
        }
L125:
        ;
    }

L150:
    j = 500;
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
/* carrying anything? */
        if (objcts_1.oadv[i__ - 1] != -61) {
            goto L175;
        }
        newsta_(&i__, &c__0, &play_1.here, &c__0, &c__0);
/* drop in room. */
        rspsub_(&j, &objcts_1.odesc2[i__ - 1]);
/* describe. */
        j = 502;
        if (! qempty_(&i__) && ((objcts_1.oflag1[i__ - 1] & 2048) != 0 || (
                objcts_1.oflag2[i__ - 1] & 8) != 0)) {
            princo_(&i__, &c__573, &c_true);
        }
L175:
        ;
    }
    return ret_val;

L200:
    if (prsvec_1.prsa != 3) {
        goto L250;
    }
/* first encounter? */
    ret_val = prob_(&c__20, &c__75);
    return ret_val;

L250:
    if (prsvec_1.prsa != 151 || objcts_1.ocapac[60] >= 0) {
        goto L300;
    }
    rspeak_(&c__626);
/* hello to out thief? */
    return ret_val;

L300:
    if (prsvec_1.prsa != 5) {
        goto L400;
    }
/* out? */
    hack_1.thfact = FALSE_;
/* disable demon. */
    objcts_1.odesc1[60] = 504;
/* change description. */
    objcts_1.oflag1[61] = objcts_1.oflag1[61] & -32769;
    return ret_val;

L400:
    if (prsvec_1.prsa != 4 && ((prsvec_1.prsa != 104 && prsvec_1.prsa != 107) 
            || objcts_1.ocapac[60] >= 0)) {
        goto L500;
    }
/* wake from fight demon? */
/* wake, kick while out? */
    objcts_1.ocapac[60] = abs(objcts_1.ocapac[60]);
/* wake him up. */
    if (qhere_(&c__61, &play_1.here)) {
        rspeak_(&c__505);
    }
/* can hero see? */
    hack_1.thfact = TRUE_;
/* enable demon. */
    objcts_1.odesc1[60] = 503;
/* change description. */
    objcts_1.oflag1[61] = objcts_1.oflag1[61] | 32768;
    return ret_val;

L500:
    if (prsvec_1.prsa != 132) {
        goto L600;
    }
/* take? */
    rspeak_(&c__506);
/* joke. */
    return ret_val;

L600:
    if (prsvec_1.prsa != 148 || prsvec_1.prso != 13 || (objcts_1.oflag2[60] & 
            256) != 0) {
        goto L700;
    }
    if (prob_(&c__10, &c__10)) {
        goto L650;
    }
/* threw knife, 10%? */
    rspeak_(&c__507);
/* no, just makes */
    objcts_1.oflag2[60] = objcts_1.oflag2[60] | 256;
/* thief mad. */
    return ret_val;

L650:
    j = 508;
/* thief drops stuff. */
    i__1 = objcts_1.olnt;
    for (i__ = 1; i__ <= i__1; ++i__) {
        if (objcts_1.oadv[i__ - 1] != -61) {
            goto L675;
        }
/* thief carrying? */
        j = 509;
        newsta_(&i__, &c__0, &play_1.here, &c__0, &c__0);
L675:
        ;
    }
    newsta_(&c__61, &j, &c__0, &c__0, &c__0);
/* thief vanishes. */
    return ret_val;

L700:
    if ((prsvec_1.prsa != 148 && prsvec_1.prsa != 146) || prsvec_1.prso == 0 
            || prsvec_1.prso == 61) {
        goto L10;
    }
/* throw/give to thief? */
    if (objcts_1.ocapac[60] >= 0) {
        goto L750;
    }
    objcts_1.ocapac[60] = abs(objcts_1.ocapac[60]);
/* wake him up. */
    hack_1.thfact = TRUE_;
/* enable demon. */
    objcts_1.odesc1[60] = 503;
/* change description. */
    objcts_1.oflag1[61] = objcts_1.oflag1[61] | 32768;
    rspeak_(&c__510);

L750:
    if (prsvec_1.prso != 109 || objcts_1.ocan[109] != 109 || cevent_1.ctick[7]
             == 0) {
        goto L800;
    }
    rspeak_(&c__511);
/* thief refuses bomb. */
    return ret_val;

L800:
    if (prsvec_1.prso != 11) {
        goto L850;
    }
/* water? */
    newsta_(&c__11, &c__1081, &c__0, &c__0, &c__0);
/* slips through fingers. */
    return ret_val;

L850:
    newsta_(&prsvec_1.prso, &c__0, &c__0, &c__0, &c_n61);
/* thief takes gift. */
    if (objcts_1.otval[prsvec_1.prso - 1] > 0) {
        goto L900;
    }
/* a treasure? */
    rspsub_(&c__512, &objcts_1.odesc2[prsvec_1.prso - 1]);
    return ret_val;

L900:
    rspsub_(&c__627, &objcts_1.odesc2[prsvec_1.prso - 1]);
/* thief engrossed. */
    findex_1.thfenf = TRUE_;
    return ret_val;

L10:
    ret_val = FALSE_;
    return ret_val;
} /* thiefp_ */



