/* Command loop, initialization for DUNGEON */

/* COPYRIGHT 1980, 1990, INFOCOM COMPUTERS AND COMMUNICATIONS, CAMBRIDGE MA. */
/* ALL RIGHTS RESERVED, COMMERCIAL USAGE STRICTLY PROHIBITED */
/* WRITTEN BY R. M. SUPNIK */
/* Translated from Fortran to C by Andrew Plotkin <erkyrath@netcom.com>
   on 10/4/98. */

/* 17-Sep-94     RMS     Fixed TELL/parse fail bug.  Fixed VMS/UNIX */
/*                       compatibility problem. */
/* 30-Jan-94     RMS     Fixed bugs from MS DOS port. */
/* 30-Jun-92     RMS     Changed file names to lower case. */

#include "glk.h"
#include "miscfort.h"
#include "funcs.h"
#include "commons.h"

/* GAME- Main command loop */

/* Declarations */

/* Subroutine */ int game_(void)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    logical f;
    logical prvlit;
    integer prvher;
    integer x, i__, svprsc, svprso;

/* GAME, PAGE 2 */

/* Start up, describe current location. */

    rspeak_(&c__1);
/* welcome aboard. */
    f = rmdesc_(&c__3);

/* Now loop, reading and executing commands. */

/* start game. */
L100:
    play_1.winner = 1;
/* player moving. */
    play_1.telflg = FALSE_;
/* assume nothing told. */
    if (prsvec_1.prscon <= 1) {
        rdline_(input_1.inbuf, &input_1.inlnt, &c__1, 76L);
    }

/* read command. */
    if (s_cmp(input_1.inbuf + (prsvec_1.prscon - 1), "GDT", input_1.inlnt - (
            prsvec_1.prscon - 1), 3L) != 0) {
        goto L200;
    }
/* call on gdt? */
    gdt_();
/* yes, invoke. */
    prsvec_1.prscon = 1;
/* force restart. */
    goto L100;

/* onward. */
L200:
    ++play_1.moves;
    input_1.sublnt = 0;
/* no substrings. */
    prvher = play_1.here;
/* save current location. */
    prvlit = lit_(&play_1.here);
/* save current lighting. */
    prsvec_1.prswon = parse_(input_1.inbuf, &input_1.inlnt, &c_true, 76L);
/* parse input, normal mo */
    if (! prsvec_1.prswon) {
        goto L400;
    }
/* parse lose? */
    if (aappli_(&advs_1.aactio[play_1.winner - 1])) {
        goto L400;
    }
/* player handle? */
    if (xvehic_(&c__1)) {
        goto L400;
    }

/* vehicle handle? */
    if (prsvec_1.prsa == 143) {
        goto L2000;
    }
/* tell? */
L300:
    if (prsvec_1.prso == 253 || prsvec_1.prso == 252 || prsvec_1.prso == 254 
            || prsvec_1.prso == 284) {
        goto L900;
    }
/* collective object? */
    if (! vappli_(&prsvec_1.prsa)) {
        goto L400;
    }
/* verb ok? */
    if (! prvlit && play_1.here == prvher && lit_(&play_1.here)) {
        f = rmdesc_(&c__0);
    }
/* now lit */
L350:
    if (! (findex_1.echof || findex_1.deadf) && play_1.here == 49) {
        goto L1000;
    }
    rappli_(&rooms_1.ractio[play_1.here - 1]);

/* room action? */
L400:
    xendmv_(&play_1.telflg);
/* do end of move. */
    if (! lit_(&play_1.here)) {
        prsvec_1.prscon = 1;
    }
/* if not lit, restart. */
    goto L100;

L900:
    valuac_(&prsvec_1.prso);
/* collective object. */
    goto L350;
/* GAME, PAGE 3 */

/* Special case-- Echo Room. */
/* If input is not 'ECHO' or a direction, just echo. */

L1000:
    rdline_(input_1.inbuf, &input_1.inlnt, &c__1, 76L);
    /* read line. */
    /* I am hesitantly changing this to use the normal command
       prompt, because it suits my sense of aesthetics. --Z */
    ++play_1.moves;
/* charge for moves. */
    if (s_cmp(input_1.inbuf, "ECHO", 76L, 4L) != 0) {
        goto L1100;
    }

/* input = echo? */
    rspeak_(&c__571);
/* kill the echo. */
    findex_1.echof = TRUE_;
    objcts_1.oflag2[25] = objcts_1.oflag2[25] & -8193;
/* let thief steal bar. */
    prsvec_1.prswon = TRUE_;
/* fake out parser. */
    prsvec_1.prscon = 1;
/* force new input. */
    goto L400;

L1100:
    if (s_cmp(input_1.inbuf, "BUG", 76L, 3L) != 0) {
        goto L1200;
    }
/* bug request? */
    rspeak_(&c__913);
/* wrong, jack. */
    goto L1000;

/* try again. */
L1200:
    if (s_cmp(input_1.inbuf, "FEATURE", 76L, 7L) != 0) {
        goto L1300;
    }
/* feature request? */
    rspeak_(&c__914);
/* right, jack. */
    goto L1000;

/* try again */
L1300:
    prsvec_1.prswon = parse_(input_1.inbuf, &input_1.inlnt, &c_false, 76L);
/* parse input, echo mode */
    if (! prsvec_1.prswon || prsvec_1.prsa != 142) {
        goto L1400;
    }
/* walk? */
    if (findxt_(&prsvec_1.prso, &play_1.here)) {
        goto L300;
    }

/* valid exit? */
L1400:
    glk_put_buffer(input_1.inbuf, input_1.inlnt); 
    glk_put_string("\n");
/* echo input. */
    play_1.telflg = TRUE_;
/* indicate output. */
    goto L1000;
/* GAME, PAGE 4 */

/* Special case-- TELL <ACTOR> "NEW COMMAND". */
/* Note that we cannot be in the Echo Room. */

/* more echo room. */
L2000:
    if (input_1.sublnt != 0) {
        goto L2050;
    }
/* any substring? */
    rspsub_(&c__946, &objcts_1.odesc2[prsvec_1.prso - 1]);
/* no, joke. */
    goto L2150;

/* done. */
L2050:
    if (prsvec_1.prso != 251) {
        goto L2100;
    }
/* to self? */
    glk_put_string("Ok: \"");
    glk_put_buffer(input_1.subbuf, input_1.sublnt); 
    glk_put_string("\".\n");
/* ok, tell it. */
    play_1.telflg = TRUE_;
    goto L2150;

L2100:
    if (objact_(&x)) {
        goto L350;
    }
/* object handle? */
    if ((objcts_1.oflag2[prsvec_1.prso - 1] & 1024) != 0) {
        goto L2200;
    }
/* actor? */
    i__ = 602;
    if ((objcts_1.oflag1[prsvec_1.prso - 1] & 32) != 0) {
        i__ = 888;
    }
    rspsub_(&i__, &objcts_1.odesc2[prsvec_1.prso - 1]);
/* no, joke. */
L2150:
    prsvec_1.prscon = 0;
/* disable cmd stream. */
    goto L350;

L2200:
    svprsc = prsvec_1.prscon;
/* save prscon. */
    svprso = prsvec_1.prso;
/* save prso. */
    prsvec_1.prscon = 1;
/* start of substring. */
L2300:
    play_1.winner = oactor_(&svprso);
/* new player. */
    play_1.here = advs_1.aroom[play_1.winner - 1];
/* new location. */
    prsvec_1.prswon = parse_(input_1.subbuf, &input_1.sublnt, &c_true, 76L);
/* parse command. */
    if (! prsvec_1.prswon) {
        goto L2600;
    }

/* parse succeed? */
    if (aappli_(&advs_1.aactio[play_1.winner - 1])) {
        goto L2400;
    }
/* actor handle? */
    if (xvehic_(&c__1)) {
        goto L2400;
    }
/* vehicle handle? */
    if (prsvec_1.prso == 253 || prsvec_1.prso == 252 || prsvec_1.prso == 254 
            || prsvec_1.prso == 284) {
        goto L2900;
    }
/* collective object? */
    if (! vappli_(&prsvec_1.prsa)) {
        goto L2400;
    }
/* verb handle? */
L2350:
    rappli_(&rooms_1.ractio[play_1.here - 1]);
/* room action? */
L2400:
    if ((i__1 = prsvec_1.prscon - 1) < 0) {
        goto L2700;
    } else if (i__1 == 0) {
        goto L2550;
    } else {
        goto L2500;
    }
/* parser reset? */
L2500:
    xendmv_(&play_1.telflg);
/* more to do, end of mov */
    goto L2300;

/* do next command. */
L2550:
    prsvec_1.prscon = svprsc;
/* substring exhausted. */
    goto L2700;

/* restore state. */
L2600:
    if (prssta_1.oflag != 0) {
        rspeak_(&c__604);
    }
/* parse fails, orphans? */
    prssta_1.oflag = 0;
/* invalidate orphans. */
L2700:
    play_1.winner = 1;
/* restore state. */
    play_1.here = advs_1.aroom[play_1.winner - 1];
    goto L400;

/* rejoin main loop. */
L2900:
    valuac_(&prsvec_1.prso);
/* collective object. */
    goto L2350;

} /* game_ */



/* XENDMV-       Execute end of move functions. */

/* Declarations */

/* Subroutine */ int xendmv_(logical *flag__)
{
    /* Local variables */
    logical f;
    integer x;


    if (! (*flag__)) {
        rspeak_(&c__341);
    }
/* default remark. */
    if (hack_1.thfact) {
        thiefd_();
    }
/* thief demon. */
    if (prsvec_1.prswon && ! findex_1.deadf) {
        fightd_();
    }
/* fight demon. */
    if (hack_1.swdact) {
        swordd_();
    }
/* sword demon. */
    if (prsvec_1.prswon) {
        f = clockd_(&x);
    }
/* clock demon. */
    if (prsvec_1.prswon) {
        f = xvehic_(&c__2);
    }
/* vehicle readout. */
    return 0;
} /* xendmv_ */



/* XVEHIC- Execute vehicle function */

/* Declarations */

logical xvehic_(integer *n)
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */
    integer av;


    ret_val = FALSE_;
/* assume loses. */
    av = advs_1.avehic[play_1.winner - 1];
/* get vehicle. */
    if (av != 0) {
        ret_val = oappli_(&objcts_1.oactio[av - 1], n);
    }
    return ret_val;
} /* xvehic_ */



/* INITFL-- DUNGEON file initialization subroutine */

/* Declarations */

logical initfl_(integer *x)
{
    /* Format strings */
    static char fmt_980[] = "Suddenly a sinister, wraithlike figure "
      "appears before you seeming to float in the air. In a low"
      ", sorrowful voice he says, \"Alas, the very nature of "
      "the world has changed, and the dungeon cannot be found. "
      "All must now pass away.\" Raising his oaken staff in "
      "farewell, he fades into the spreading darkness. In his "
      "place appears a tastefully lettered sign reading:\n\n"
      "    INITIALIZATION FAILURE\n\nThe darkness becomes "
      "all encompassing, and your vision fails.\n";

    /* System generated locals */
    integer i__1;
    logical ret_val;
    frefid_t fref;

    /* Local variables */
    char kedit[1];
    integer i__, j, knum;

/* INITFL, PAGE 2 */

/* First check for protection violation. */

    ret_val = FALSE_;
/* assume init fails. */
    if (protct_(x)) {
        goto L10000;
    }
/* protection violation? */
    glk_put_string("There appears before you a threatening "
      "figure clad all over in heavy black armor. His legs seem "
      "like the massive trunk of the oak tree. His broad "
      "shoulders and helmeted head loom high over your own puny "
      "frame, and you realize that his powerful arms could easily "
      "crush the very life from your body. There hangs "
      "from his belt a veritable arsenal of deadly weapons: "
      "sword, mace, ball and chain dagger, lance, and trident. "
      "He speaks with a commanding voice:\n\n    \"You "
      "shall not pass.\"\n\nAs he grabs you by the neck all grows "
      "dim about you.\n");
/* yes, throw him off. */
    return ret_val;

L10000:
    /* Load in data from the data file, which is named "dundat". 
        Note: this is not the best way to do this in a Glk program.
        It would be much better to have the platform-dependent startup code
        open this file. That way the Mac port could store the data in a resource,
        and so on. But I haven't finished hashing out the startup code system
        for the various libraries. So I'll leave this here for now. --Z */
    
    fref = glk_fileref_create_by_name(fileusage_Data|fileusage_BinaryMode,
        "dundat", 0);
    if (!fref) {
      weeprintf("I can't find \"%s\".\n", "dundat"); 
      goto L1900;
    }
    datafile = glk_stream_open_file(fref, filemode_Read, 0);
    glk_fileref_destroy(fref);
    if (!datafile) {
      weeprintf("I can't open \"%s\".\n", "dundat");
      goto L1900;
    }
    
    f_get_ints(datafile, &i__, 1);
    f_get_ints(datafile, &j, 1);
    if (i__ != DATAFILE_LEN1 || j != DATAFILE_LEN2) {
      goto L1950;
    }
    
    f_get_ints(datafile, &i__, 1);
    f_get_ints(datafile, &j, 1);
    f_get_ints(datafile, &knum, 1); /* ascii code of patchlevel char. */
    kedit[0] = knum;
/* get version. */
    if (i__ != misc_1.vmaj || j != misc_1.vmin) {
      goto L1925;
    }
/* match to ours? */

    f_get_ints(datafile, &play_1.mxscor, 1);
    f_get_ints(datafile, &misc_1.strbit, 1);
    f_get_ints(datafile, &play_1.egmxsc, 1);

    f_get_ints(datafile, &rooms_1.rlnt, 1);
    f_get_ints(datafile, &rooms_1.rdesc2, 1);
    f_get_ints(datafile, &rooms_1.rdesc1[0], 200);
    f_get_ints(datafile, &rooms_1.rexit[0], 200);
    f_get_ints(datafile, &rooms_1.ractio[0], 200);
    f_get_ints(datafile, &rooms_1.rval[0], 200);
    f_get_ints(datafile, &rooms_1.rflag[0], 200);

    f_get_ints(datafile, &exits_1.xlnt, 1);
    f_get_ints(datafile, &exits_1.travel[0], 1000);

    f_get_ints(datafile, &objcts_1.olnt, 1);
    f_get_ints(datafile, &objcts_1.odesc1[0], 300);
    f_get_ints(datafile, &objcts_1.odesc2[0], 300);
    f_get_ints(datafile, &objcts_1.odesco[0], 300);
    f_get_ints(datafile, &objcts_1.oactio[0], 300);
    f_get_ints(datafile, &objcts_1.oflag1[0], 300);
    f_get_ints(datafile, &objcts_1.oflag2[0], 300);
    f_get_ints(datafile, &objcts_1.ofval[0], 300);
    f_get_ints(datafile, &objcts_1.otval[0], 300);
    f_get_ints(datafile, &objcts_1.osize[0], 300);
    f_get_ints(datafile, &objcts_1.ocapac[0], 300);
    f_get_ints(datafile, &objcts_1.oroom[0], 300);
    f_get_ints(datafile, &objcts_1.oadv[0], 300);
    f_get_ints(datafile, &objcts_1.ocan[0], 300);
    f_get_ints(datafile, &objcts_1.oread[0], 300);

    f_get_ints(datafile, &oroom2_1.r2lnt, 1);
    f_get_ints(datafile, &oroom2_1.o2[0], 20);
    f_get_ints(datafile, &oroom2_1.r2[0], 20);

    f_get_ints(datafile, &cevent_1.clnt, 1);
    f_get_ints(datafile, &cevent_1.ctick[0], 30);
    f_get_ints(datafile, &cevent_1.cactio[0], 30);

    f_get_llogicals(datafile, &cevent_1.cflag[0], 30);
    f_get_llogicals(datafile, &cevent_1.ccncel[0], 30);

    f_get_ints(datafile, &vill_1.vlnt, 1);
    f_get_ints(datafile, &vill_1.villns[0], 4);
    f_get_ints(datafile, &vill_1.vprob[0], 4);
    f_get_ints(datafile, &vill_1.vopps[0], 4);
    f_get_ints(datafile, &vill_1.vbest[0], 4);
    f_get_ints(datafile, &vill_1.vmelee[0], 4);

    f_get_ints(datafile, &advs_1.alnt, 1);
    f_get_ints(datafile, &advs_1.aroom[0], 4);
    f_get_ints(datafile, &advs_1.ascore[0], 4);
    f_get_ints(datafile, &advs_1.avehic[0], 4);
    f_get_ints(datafile, &advs_1.aobj[0], 4);
    f_get_ints(datafile, &advs_1.aactio[0], 4);
    f_get_ints(datafile, &advs_1.astren[0], 4);
    f_get_ints(datafile, &advs_1.aflag[0], 4);

    f_get_ints(datafile, &misc_1.mbase, 1);
    f_get_ints(datafile, &rmsg_1.mlnt, 1);
    f_get_ints(datafile, &rmsg_1.rtext[0], 1500);

    f_get_ints(datafile, datafile_strindex, DATAFILE_LEN2);
    datafile_strings = 4 * (2 + DATAFILE_LEN1 + DATAFILE_LEN2);

    goto L1025;

/* init done. */
/* INITFL, PAGE 3 */

/* The internal data base is now established. */
/* Set up to play the game-- INITFL succeeds. */

L1025:
    idate_(&misc_1.shour, &misc_1.smin, &misc_1.ssec);
/* get date (and toss). */
    i__ = (misc_1.shour << 6) + (misc_1.smin << 3) + misc_1.ssec;
/* first seed */
    itime_(&misc_1.shour, &misc_1.smin, &misc_1.ssec);
/* get time. */
    j = (misc_1.shour << 6) + (misc_1.smin << 3) + misc_1.ssec;
/* second seed */
    inirnd_(&i__, &j);

/* init random number gen */
    play_1.winner = 1;
    hack_1.thfpos = objcts_1.oroom[60];
    play_1.bloc = objcts_1.oroom[97];
    play_1.here = advs_1.aroom[play_1.winner - 1];
    prssta_1.lastit = advs_1.aobj[0];

    ret_val = TRUE_;
    return ret_val;

/* Errors-- INITFL fails. */

L1900:
    glk_put_string(fmt_980);
    return ret_val;
L1925:
    weeprintf("\"dundat\" is version %d.%d%c. I require "
      "version %d.%d%c.\n\n", i__, j, kedit[0], 
      misc_1.vmaj, misc_1.vmin, misc_1.vedit[0]);
/* wrong dindx.dat ver */
    glk_put_string(fmt_980);
    return ret_val;
L1950:
    glk_put_string(fmt_980);
    return ret_val;

} /* initfl_ */



/* PROTCT-- Check for user violation */

/* This routine should be modified if you wish to add system */
/* dependant protection against abuse. */

/* At the moment, play is permitted under all circumstances. */

logical protct_(integer *x)
{
    /* System generated locals */
    logical ret_val;


    ret_val = TRUE_;
    return ret_val;
} /* protct_ */

