/* cvocab.c
 *    the crystal cave vocabulary
 ************************************************************************/

#include "cvocab.h"

/*************************************************************************
 * action defaults:
 *	each line contains the message number of the default error
 *	message for one of the action verbs.
 *************************************************************************/
int actspk[] =
{
    0,
    24,				/* carry */
    29,				/* drop */
    38,				/* on */
    38,				/* off */
    28,				/* open */
    28,				/* lock */
    0,				/* say */
    75,				/* rub */
    59,				/* find */
    59,				/* inventory */
    13,				/* quit */
    13,				/* score */
    0,				/* nothing */
    13,				/* suspend */
    155,			/* brief */
    13,				/* hours */
    29,				/* throw */
    43,				/* go */
    8,				/* pay */
    146,			/* break */
    110,			/* drink */
    110,			/* eat */
    195,			/* read */
    12,				/* tie */
    147,			/* untie */
    174,			/* feed */
    29,				/* pour */
    110,			/* kill/attack */
    110,			/* rig */
    207,			/* cut */
    109,			/* fill */
    38,				/* test */
    67,				/* blast */
    42,				/* wave */
    191,			/* sit */
    14,				/* calm */
    14,				/* fly */
    110,			/* wake */
    0,				/* describe */
    0,				/* touch */
    221,			/* play */
    0,				/* restore */
    13};			/* help */

/*************************************************************************
 * vocabulary:
 *	each entry contains a code and a word.  The codes in uppercase
 *	are defined in cvocab.h, and are used in common with other
 *	parts of the program.  The thousands-position of the code
 *	indicates what "part of speech" we have here:
 *	0:	the word is a motion verb or location reference for
 *		use in travelling.  See cvlocs.c.
 *	1:	the word is an object.
 *	2:	the word is an action verb (such as "carry", "attack")
 *	3:	the word is a special case verb (such as "dig") and
 *		the low-order part of the code is an index into the
 *		message array.  These words may duplicate objects.
 *************************************************************************/
struct cvocab vtab[] =
{
    {NORTH, "north"},
    {NORTH, "n"},
    {NE, "northeast"},
    {NE, "ne"},
    {EAST, "east"},
    {EAST, "e"},
    {SE, "southeast"},
    {SE, "se"},
    {SOUTH, "south"},
    {SOUTH, "s"},
    {SW, "southwest"},
    {SW, "sw"},
    {WEST, "west"},
    {WEST, "w"},
    {NW, "northwest"},
    {NW, "nw"},
    {UP, "up"},
    {UP, "upward"},
    {UP, "u"},
    {UP, "above"},
    {UP, "ascend"},
    {DOWN, "down"},
    {DOWN, "downward"},
    {DOWN, "d"},
    {DOWN, "descend"},
    {OUT, "out"},
    {OUT, "outside"},
    {OUT, "exit"},
    {OUT, "leave"},
    {IN, "in"},
    {ENTER, "enter"},
    {JUMP, "jump"},
    {BARN, "barn"},
    {BARN, "building"},
    {PRIVY, "privy"},
    {PRIVY, "outhouse"},
    {SHAFT, "shaft"},
    {SINKH, "sink"},
    {SINKH, "sinkhole"},
    {PIGPE, "pig"},
    {PIGPE, "pigs"},
    {PIGPE, "pigpen"},
    {BLUFF, "bluff"},
    {HEADQ, "park"},
    {HEADQ, "headquarters"},
    {M_GATE, "gate"},		/* also appears as an object word as a ranger
				   synonym 1060 */
    {M_GATE, "mouth"},
    {M_GATE, "entrance"},
    {LAKE, "lake"},
    {LAKE, "rapids"},
    {FIELD, "field"},
    {FIELD, "pasture"},
    {FIELD, "meadow"},
    {BACK, "back"},
    {BACK, "return"},
    {BACK, "retreat"},
    {WAIT, "null"},
    {WAIT, "wait"},
    {WAIT, "nowhere"},
    {CROSS, "cross"},
    {HOPE, "hope"},
    {UPSTR, "upstream"},
    {DOWNS, "downstream"},
    {CLIMB, "climb"},
    {CLIMB, "scale"},
    {PATH, "path"},
    {PAST, "p"},
    {PAST, "past"},
    {FUTUR, "f"},
    {FUTUR, "future"},
    {BANIS, "banish"},
    {MISFO, "misfortune"},

/* start of object section */

    {1001, "diamonds"},
    {1002, "silver"},
    {1002, "sack"},
    {_JEWLRY, "jewelry"},
    {1004, "coins"},
    {_CHEST, "chest"},
    {_CHEST, "box"},
    {_CHEST, "treasure"},
    {_CAPE, "ermine"},
    {_CAPE, "cape"},
    {_CAPE, "cloak"},
    {_CROWN, "crown"},
    {_SCEPT, "scepter"},
    {1009, "sapphire"},
    {_ORB, "platinum"},
    {_ORB, "orb"},
    {_IDOL, "jade"},
    {_IDOL, "idol"},
    {_RUG, "rug"},
    {_RUG, "persian"},
    {_RUG, "carpet"},
    {_UNICRN, "unicorn"},	/* also as special verb, 3226 */
    {_UNICRN, "collar"},	/* also as special verb, 3226 */
    {_CHAIN, "chain"},
    {_RING, "ring"},
    {_RING, "adamant"},
    {_HELM, "helm"},
    {_HELM, "helmet"},
    {_HELM, "mithril"},
    {1017, "gold"},
    {1017, "nugget"},
    {_THRONE, "throne"},
    {_THRONE, "seat"},
    {_THRONE, "chair"},
    {_SWORD, "sword"},
    {_HAMMER, "hammer"},
    {_CUP, "cup"},
    {_MEDAL, "ruby"},
    {_MEDAL, "medallion"},
    {_SCROLL, "parchment"},	/* also so special verb, 3126 */
    {_SCROLL, "scroll"},	/* also as special verb, 3126 */
    {_HARP, "harp"},
    {_HARP, "ivory"},
    {_STONE, "arkenstone"},
    {_STONE, "stone"},
    {_KEG, "keg"},
    {_KEG, "beer"},
    {1027, "long"},
    {1027, "longsword"},
    {1028, "broad"},
    {1028, "broadsword"},
    {1029, "spear"},
    {1030, "short"},
    {1030, "shortsword"},
    {1031, "bow"},
    {1032, "dagger"},
    {1033, "quarterstaff"},
    {1033, "staff"},
    {1034, "halberd"},
    {1035, "armor"},
    {1035, "armour"},
    {1036, "heater"},
    {1037, "round shield"},
    {1038, "tall"},
    {1039, "cuirass"},
    {_COLUMN, "column"},
    {1041, "pearls"},
    {1042, "helictites"},
    {1043, "gypsum"},
    {1043, "flowers"},
    {1044, "bat"},
    {1044, "bats"},
    /* BUGFIX - butterfly word nos. *were* 1046 (same as soda straws) */
    {1045, "crystal"},
    {1045, "butterfly"},
    {1045, "butterflies"},
    {1046, "soda-straws"},
    {1046, "soda"},
    {1046, "sodastraws"},
    {1046, "straw"},
    {1046, "straws"},
    {1046, "stalactites"},
    {1047, "indian"},
    {1047, "pot"},

    {_COMPASS, "compass"},
    {_KEY, "key"},
    {_KEY, "keys"},
    {_LAMP, "lamp"},
    {_LAMP, "headlamp"},
    {_RICK, "rick"},		/* the ranger? */
    {_SEARS, "sears"},
    {_SEARS, "catalog"},
    {_WALLET, "change"},
    {_WALLET, "wallet"},
    {_DOOR, "door"},
    {_BRIDGE, "bridge"},
    {_BOAT, "boat"},
    {_DAM, "rimstone"},
    {_DAM, "dam"},
    {_O_GATE, "gate"},		/* name of location -- only available to
			program -- see word 23 */
    {_O_GATE, "ranger"},
    {_ROPE, "rope"},		/* objects 61 to 64 are various rope parts */
    {_ROPE, "knot"},

    {1065, "guano"},

    {_SPICE, "spices"},
    {_KNIFE, "knife"},
    {_KNIFE, "knives"},
    {_FOOD, "food"},
    {_FOOD, "rations"},
    {_BOTTLE, "bottle"},
    {_BOTTLE, "jar"},
    {_WATER, "water"},
    {_WATER, "h2o"},
    {_WINE, "wine"},
    {_COLA, "coke"},
    {_COLA, "cola"},
    {_COLA, "orca"},
    {_MIRROR, "mirror"},
    {_GIANT, "priest"},
    {_GIANT, "giant"},
    {_GIANT, "orc"},
    {_ORCS, "orcs"},
    {_TOMB, "tomb"},
    {_TOMB, "figure"},
    {_AXE, "axe"},
    {_TOAD, "toad"},
    {_SAND, "sand"},
    {_SAND, "turquoise"},
    {_SHELF, "shelf"},
    {_HANG, "hangings"},
    {_HANG, "silk"},

    {_CRAP, "droppings"},
    {_CRAP, "shit"},
    {_CRAP, "crap"},
    {_CRAP, "poo"},
    {_SHOWER, "shower"},
    {_VEND, "machine"},
    {_VEND, "vending"},
    {_BATTER, "batteries"},
    {_DWARF, "dwarf"},
    {_DWARF, "dwarves"},
    {_BEAR, "bear"},		/* also action word 3095 */
    {_BEAR, "bugbear"},		/* also action word 3095 */
    {_BEAR, "bug"},		/* also action word 3095 */
    {_SKELTN, "skeleton"},
    {_SPIDER, "spider"},
    {_SPIDER, "grendl"},
    {_DRAGON, "dragon"},
    {_DJINN, "djinni"},		/* also action word 3193 */
    {_KOBOLD, "cobol"},		/* also action word 3194 */
    {_KOBOLD, "kobold"},	/* also action word 3194 */
    {_BALROG, "balrog"},	/* also action word 3160 */
    {_SELF, "*you*"},
    {_SELF, "*yourself*"},
    {_SELF, "self"},
    {_SELF, "me"},

/* verb section */

    {TAKE, "carry"},
    {TAKE, "take"},
    {TAKE, "keep"},
    {TAKE, "catch"},
    {TAKE, "steal"},
    {TAKE, "capture"},
    {TAKE, "get"},
    {TAKE, "tote"},
    {DROP, "drop"},
    {DROP, "release"},
    {DROP, "free"},
    {DROP, "discard"},
    {DROP, "dump"},
    {DROP, "offer"},
    {DROP, "abandon"},
    {ON, "light"},
    {ON, "on"},
    {OFF, "off"},
    {OFF, "extinguish"},
    {UNLOC, "open"},
    {UNLOC, "unlock"},
    {LOCK, "close"},
    {LOCK, "lock"},
    {SAY, "say"},
    {SAY, "chant"},
    {SAY, "sing"},
    {SAY, "utter"},
    {SAY, "mumble"},
    {RUB, "rub"},
    {FIND, "find"},
    {INVENT, "i"},
    {INVENT, "inventory"},
    {QUIT, "quit"},
    {QUIT, "qui"},
    {QUIT, "qu"},
    {QUIT, "q"},
    {SCORE, "score"},
    {NOTHI, "nothing"},
    {SAVE, "save"},
    {BRIEF, "brief"},
    {THROW, "throw"},
    {THROW, "toss"},
    {THROW, "fling"},
    {WALK, "walk"},
    {WALK, "run"},
    {WALK, "travel"},
    {WALK, "go"},
    {WALK, "proceed"},
    {WALK, "continue"},
    {WALK, "explore"},
    {WALK, "goto"},
    {WALK, "follow"},
    {WALK, "turn"},
    {PAY, "pay"},
    {BREAK, "break"},
    {BREAK, "smash"},
    {BREAK, "destroy"},
    {DRINK, "drink"},
    {EAT, "eat"},
    {READ, "read"},
    {TIE, "tie"},
    {UNTIE, "untie"},
    {FEED, "feed"},
    {POUR, "pour"},
    {KILL, "kill"},
    {KILL, "fight"},
    {KILL, "hit"},
    {KILL, "strike"},
    {KILL, "attack"},
    {RIG, "rig"},
    {RIG, "anchor"},
    {CUT, "cut"},
    {CUT, "divide"},
    {FILL, "fill"},
    {TEST, "test"},
    {BLAST, "blast"},
    {WAVE, "wave"},
    {WAVE, "shake"},
    {WAVE, "swing"},
    {SIT, "sit"},
    {CALM, "calm"},
    {CALM, "placate"},
    {CALM, "tame"},
    {FLY, "fly"},
    {FLY, "rise"},
    {WAKE, "wake"},
    {WAKE, "disturb"},
    {DESCRB, "l"},
    {DESCRB, "look"},
    {DESCRB, "examine"},
    {DESCRB, "describe"},
    {TOUCH, "touch"},
    {PLAY, "play"},
    {PLAY, "strum"},
    {PLAY, "finger"},
    {PLAY, "tune"},
    {RESTOR, "restore"},
    {RESTOR, "resume"},
    {HELP, "help"},
    {HELP, "?"},

/* special action words */

    {3010, "left"},
    {3010, "right"},
    {3010, "forward"},
    {3010, "backward"},

    {3050, "fee"},
    {3050, "fie"},
    {3050, "foe"},
    {3050, "foo"},
    {3050, "fum"},
    {3050, "xyzzy"},
    {3050, "plugh"},
    {3050, "sesame"},
    {3050, "opensesame"},
    {3050, "abra"},
    {3050, "abracadabra"},
    {3050, "shazam"},
    {3050, "hocus"},
    {3050, "pocus"},

    {3064, "tree"},
    {3064, "trees"},
    {3064, "wood"},
    {3064, "woods"},
    {3064, "forest"},

    {3066, "dig"},
    {3066, "excavate"},
    {3068, "lost"},

    {3069, "mist"},

    {3095, "bugbear"},		/* also object 1091 */
    {3095, "bug"},		/* also object 1091 */
    {3095, "bear"},		/* also object 1091 */

    {3123, "time"},
    {3123, "timemaze"},

    {3126, "parchment"},	/* also object 1023 */
    {3126, "scroll"},		/* also object 1023 */

    {3139, "stop"},

    {3142, "info"},
    {3142, "information"},

    {3147, "swim"},

    {3152, "y"},
    {3152, "yes"},
    {3152, "ye"},
    {3152, "no"},
    {3152, "okay"},
    {3152, "ok"},

    {3160, "balrog"},		/* also object 1097 */

    {3190, "siege"},
    {3190, "perilous"},

    {3193, "djinni"},		/* also object 1095 */
    {3194, "kobold"},		/* also object 1096 */
    {3194, "cobol"},		/* also object 1096 */

    {3225, "fuck"},

    {3226, "unicorn"},		/* also object 1013 */


    {0}				/************* mark the end ***************/
};
