/*
 * cvlocs.c
 *    - data files for CAVE game program
 *************************************************************************/

#include <stdio.h>
#include "cvobj.h"
#include "cvlocs.h"
#include "cvocab.h"

struct hint hints[] =
{
    {0},
    {0},
    {9999, 10},			/* clue in repository */
    {9999, 5},			/* did he get instructions */
    {5, 2, 62, 63, HINT1},	/* gate */
    {6, 20, 121, 122, HINT2},	/* dam */
    {75, 10, 176, 177, HINT3},	/* drop things */
    {20, 30, 144, 145, HINT4},	/* time maze */
    {10, 2, 179, 178, HINT5},	/* woods */
    {20, 10, 172, 173, HINT6},	/* rope hint */
    {-1}};

struct rtr rtrav[] =
{
    {14, 0, 45, 0, -1},		/* cliff to domepit window */
    {80, 81, 0, 81, 0},		/* torture chamber to dungeon */
    {81, 82, 0, 82, 0},		/* dungeon to corridor */
    {85, 0, 56, 56, 0},		/* window to magnificent chamber */
    {120, 121, 0, 121, 0},	/* throne to bottom of throne pit */
    {129, 130, 131, 131, -1},	/* windshaft to ledge to bottom */
    {-1}};

static struct cvtrav tr000[] =
{
    {-1}},			/* placeholder */
 tr001[] =
{
    {IN},
    {ENTER},
    {BARN, 2},
    {SW},
    {PRIVY},
    {PATH, 3},
    {EAST},
    {FIELD, 5},
    {NW},
    {SHAFT, 6},
    {NE, 11},
    {NORTH, 12},
    {WEST, 13},
    {SOUTH, 17},
    {SE, 18},
    {-1}}, tr002[] =
{
    {OUT, 617, 12, 1, IF_PROP},	/* can't fly there */
    {OUT, 1},
    {M_GATE, 617, 12, 1, IF_PROP},	/* can't fly there */
    {M_GATE, 30},
    {HOPE, 78},
    {BANIS, 130, 81, 2, IF_NPROP},	/* there's a shelf */
    {BANIS, 661, 81, 2, IF_PROP, 1},	/* tell bad news */
    {BANIS, 25},		/* and wind up dead */
    {MISFO, 301},		/* special code */
    {-1}}, tr003[] =
{
    {NE},
    {BARN},
    {PATH, 1},
    {IN},
    {ENTER},
    {PRIVY, 4},
    {NORTH, 13},
    {WEST},
    {NW, 14},
    {SW, 15},
    {SE},
    {SOUTH},
    {BLUFF, 16},
    {EAST, 17},
    {-1}}, tr004[] =
{
    {OUT, 3},
    {M_GATE, 30},
    {-1}}, tr005[] =
{
    {WEST},
    {BARN, 1},
    {NORTH, 11},
    {NW, 12},
    {SW, 17},
    {SOUTH, 18},
    {SE, 19},
    {EAST},
    {NE, 26, 33},		/* get lost */
    {NE, 27, 50},
    {NE, 29, 100},
    {-1}}, tr006[] =
{
    {SE},
    {BARN, 1},
    {DOWN},
    {CLIMB, 7},
    {EAST, 12},
    {SOUTH, 13},
    {SW},
    {WEST, 14},
    {NORTH},
    {NW},
    {NE, 26, 33},		/* get lost */
    {NE, 27, 50},
    {NE, 29, 100},
    {JUMP, 25},			/* really dumb */
    {-1}}, tr007[] =
{
    {EAST},
    {IN},
    {ENTER, 8},
    {-1}}, tr008[] =
{
    {WEST},
    {SHAFT},
    {UP, 7},
    {EAST},
    {DOWN},
    {SINKH, 9},
    {-1}}, tr009[] =
{
    {WEST},
    {IN},
    {ENTER, 8},
    {UP, 10},
    {-1}}, tr010[] =
{
    {DOWN},
    {JUMP},
    {SINKH, 9},
    {NORTH},
    {NE},
    {EAST},
    {SE},
    {SOUTH},
    {SW},
    {WEST},
    {NW},
    {OUT, 11},
    {-1}}, tr011[] =
{
    {SW},
    {BARN},
    {PATH, 1},
    {SOUTH},
    {FIELD, 5},
    {IN},
    {ENTER},
    {SINKH},
    {PIGPE, 10},
    {NORTH},
    {NW},
    {WEST, 12},
    {EAST},
    {NE},
    {SE, 26, 33},		/* get lost */
    {SE, 27, 33},
    {SE, 29, 100},
    {-1}}, tr012[] =
{
    {SOUTH},
    {BARN, 1},
    {SE},
    {FIELD, 5},
    {WEST},
    {SHAFT, 6},
    {SW, 13},
    {EAST},
    {NE, 11},
    {NORTH},
    {NW, 26, 33},		/* get lost */
    {NW, 27, 50},
    {NW, 29, 100},
    {-1}}, tr013[] =
{
    {EAST},
    {BARN, 1},
    {SOUTH},
    {PRIVY, 3},
    {NORTH},
    {SHAFT, 6},
    {NE, 12},
    {SW},
    {NW},
    {WEST, 14},
    {SE, 17},
    {-1}}, tr014[] =
{
    {SE},
    {PRIVY, 3},
    {NE},
    {SHAFT, 6},
    {EAST, 13},
    {SOUTH, 15},
    {NORTH, 26, 33},		/* get lost */
    {NORTH, 27, 50},
    {NORTH, 29, 100},
    {JUMP, 24},			/* real dumb */
    {-1}}, tr015[] =
{
    {NE},
    {PRIVY, 3},
    {NORTH, 14},
    {EAST},
    {BLUFF, 16},
    {JUMP, 24},			/* real dumb */
    {-1}}, tr016[] =
{
    {NW},
    {PRIVY, 3},
    {WEST},
    {UP, 15},
    {NORTH, 17},
    {NE, 18},
    {EAST},
    {SE},
    {HEADQ, 20},
    {DOWN},
    {SOUTH},
    {SW, 22},
    {-1}}, tr017[] =
{
    {NORTH},
    {BARN, 1},
    {WEST},
    {PRIVY},
    {PATH, 3},
    {NE},
    {FIELD, 5},
    {NW, 13},
    {SE},
    {SOUTH},
    {SW},
    {BLUFF, 16},
    {EAST, 18},
    {-1}}, tr018[] =
{
    {NW},
    {BARN, 1},
    {NORTH},
    {FIELD, 5},
    {SW},
    {BLUFF, 16},
    {WEST, 17},
    {EAST, 19},
    {SOUTH},
    {SE},
    {HEADQ, 20},
    {NE},
    {DOWN, 26, 33},		/* get lost */
    {DOWN, 27, 50},
    {DOWN, 29, 100},
    {-1}}, tr019[] =
{
    {NW},
    {FIELD, 5},
    {WEST, 18},
    {SOUTH},
    {SW},
    {DOWN},
    {HEADQ, 20},
    {EAST, 24},
    {NORTH},
    {NE},
    {SE},
    {UP, 26, 33},		/* get lost */
    {UP, 27, 50},
    {UP, 29, 100},
    {-1}}, tr020[] =
{
    {NORTH},
    {NW, 18},
    {UP},
    {NE, 19},
    {IN},
    {ENTER, 21},
    {SOUTH},
    {SW},
    {DOWN, 22},
    {WEST},
    {BLUFF, 16},
    {EAST, 26, 33},
    {EAST, 27, 33},
    {EAST, 29, 100},
    {-1}}, tr021[] =
{
    {OUT, 20, 56, 0, IF_NPROP},	/* is cell open? */
    {OUT, 21},			/* SOL, aren't you */
    {-1}}, tr022[] =
{
    {NORTH},
    {NW},
    {UP},
    {BLUFF, 16},
    {EAST},
    {HEADQ},
    {NE, 20},
    {WEST},
    {UPSTR, 23},
    {SW, 26, 33},
    {SW, 27, 50},
    {SW, 29, 100},
    {-1}}, tr023[] =
{
    {EAST},
    {DOWNS, 22},
    {NORTH},
    {M_GATE},
    {UPSTR},
    {PATH, 30},
    {SOUTH},
    {SE},
    {SW, 26, 33},
    {SW, 27, 50},
    {SW, 29, 100},
    {-1}}, tr024[] =
{
    {1, 0},
    {-1}}, tr025[] =
{
    {1, 0},
    {-1}}, tr026[] =
{
    {DOWN, 22, 30},		/* this works sometimes */
    {NORTH},
    {SOUTH},
    {EAST},
    {WEST},
    {NE},
    {SE},
    {NW},
    {SW},
    {UP, 27, 45},		/* but nothing else works at all */
    {UP, 29, 82},
    {UP, 5, 10},		/* well, on rare occasions . . . */
    {UP, 6, 11},
    {UP, 11, 12},
    {UP, 12, 14},
    {UP, 14, 17},
    {UP, 18, 20},
    {UP, 19, 25},
    {UP, 20, 33},
    {UP, 22, 50},
    {UP, 23, 100},
    {-1}}, tr027[] =
{
    {DOWN, 22, 30},		/* this works sometimes */
    {NORTH},
    {SOUTH},
    {EAST},
    {WEST},
    {NE},
    {SE},
    {NW},
    {SW},
    {UP, 26, 45},		/* but nothing else works at all */
    {UP, 29, 82},
    {UP, 5, 10},		/* well, on rare occasions . . . */
    {UP, 6, 11},
    {UP, 11, 12},
    {UP, 12, 14},
    {UP, 14, 17},
    {UP, 18, 20},
    {UP, 19, 25},
    {UP, 20, 33},
    {UP, 22, 50},
    {UP, 23, 100},
    {-1}}, tr028[] =
{
    {1, 0},
    {-1}}, tr029[] =
{
    {DOWN, 22, 30},		/* this works sometimes */
    {NORTH},
    {SOUTH},
    {EAST},
    {WEST},
    {NE},
    {SE},
    {NW},
    {SW},
    {UP, 26, 45},		/* but nothing else works at all */
    {UP, 27, 82},
    {UP, 5, 10},		/* well, on rare occasions . . . */
    {UP, 6, 11},
    {UP, 11, 12},
    {UP, 12, 14},
    {UP, 14, 17},
    {UP, 18, 20},
    {UP, 19, 25},
    {UP, 20, 33},
    {UP, 22, 50},
    {UP, 23, 100},
    {-1}}, tr030[] =
{
    {BARN, 2},
    {PRIVY, 4},
    {SOUTH},
    {DOWN},
    {PATH},
    {DOWNS, 23},
    {UP},
    {NORTH},
    {IN},
    {ENTER},
    {M_GATE},
    {CROSS},
    {UPSTR},
    {CLIMB, 546, 60, 2, IF_PROP},	/* can't get in if you trash the gate */
    {CLIMB, 615},		/* and you can't do it that way anyhow */
    {-1}}, tr031[] =
{
    {OUT},
    {DOWNS, 30, 60, 2, IF_NPROP},	/* can you get out? */
    {DOWNS, 31},
    {NORTH},
    {IN},
    {ENTER},
    {UPSTR, 32},
    {LAKE, 33},
    {-1}}, tr032[] =
{
    {SOUTH},
    {OUT},
    {DOWNS, 31},
    {NORTH},
    {IN},
    {ENTER},
    {LAKE},
    {UPSTR, 33},
    {UP},			/* GET IN TROUBLE */
    {CLIMB, 40},
    {-1}}, tr033[] =
{
    {SE},
    {DOWNS},
    {OUT, 32, 58, 0, IF_NHAVE},
    {EAST, 34, 58, 0, IF_NHAVE},
    {EAST, 619},
    {NE, 34, 58, 3, IF_PROP},
    {NORTH},
    {UPSTR, 38, 58, 3, IF_PROP},
    {UPSTR, 618, 58, 0, IF_HAVE},
    {UPSTR, 614},
    {WEST},
    {NW, 519, 58, 0, IF_HAVE},
    {CROSS, 0, 57, 1, IF_NPROP, 1},
    {CROSS, 35, 58, 0, IF_NHAVE},
    {CROSS, 519, 58, 0, IF_HAVE},
    {CROSS, 614},
    {-1}}, tr034[] =
{
    {WEST, 38, 58, 3, IF_PROP},
    {NW},
    {NORTH, 39, 58, 3, IF_PROP},
    {SW, 33, 58, 3, IF_PROP},
    {SW, 618, 58, 0, IF_HAVE},
    {SW, 614},
    {SOUTH, 33, 58, 0, IF_NHAVE},
    {SOUTH, 619},
    {-1}}, tr035[] =
{
    {EAST, 519, 58, 0, IF_HAVE},
    {CROSS, 0, 57, 1, IF_NPROP, 1},
    {CROSS, 33, 58, 0, IF_NHAVE},
    {CROSS, 519, 58, 0, IF_HAVE},
    {CROSS, 614},
    {NE, 38, 58, 3, IF_PROP},
    {NE, 618, 58, 0, IF_HAVE},
    {NE, 614},
    {WEST, 42, 58, 0, IF_NHAVE},
    {ENTER},
    {IN},
    {NW, 58, 58, 0, IF_NHAVE},
    {NW, 619},
    {-1}}, tr036[] =
{
    {NE, 37, 58, 3, IF_PROP},
    {EAST},
    {SE, 39, 58, 3, IF_PROP},
    {SE, 618, 58, 0, IF_HAVE},
    {SE, 614},
    {NORTH, 37, 58, 0, IF_NHAVE},
    {NW},
    {IN},
    {ENTER, 59, 58, 0, IF_NHAVE},
    {ENTER, 619},
    {-1}}, tr037[] =
{
    {SW, 36, 58, 3, IF_PROP},
    {SE},
    {SOUTH},
    {DOWN, 39, 58, 3, IF_PROP},
    {DOWN, 618, 58, 0, IF_HAVE},
    {DOWN, 614},
    {WEST, 36, 59, 0, IF_NHAVE},
    {WEST, 619},
    {NORTH},
    {CROSS, 0, 59, 0, IF_NPROP, 1},
    {CROSS, 60, 58, 3, IF_PROP},
    {CROSS, 618, 58, 2, IF_PROP},
    {CROSS, 514},
    {-1}}, tr038[] =
{
    {SOUTH, 33, 58, 3, IF_PROP},
    {EAST},
    {SE, 34, 58, 3, IF_PROP},
    {WEST},
    {SW, 35, 58, 3, IF_PROP},
    {NE},
    {NW},
    {UP},
    {NORTH, 39, 58, 3, IF_PROP},
    {NORTH, 618},		/* IF ANY OF THE ABOVE FAIL */
    {-1}}, tr039[] =
{
    {WEST},
    {NW, 36, 58, 3, IF_PROP},
    {NE},
    {UP},
    {NORTH, 37, 58, 3, IF_PROP},
    {SE},
    {SOUTH},
    {SW},
    {DOWN, 38, 58, 3, IF_PROP},
    {DOWN, 618},		/* IF ANY OF THE ABOVE FAIL */
    {-1}}, tr040[] =
{
    {DOWN},
    {CLIMB, 302, 40, 1, IF_NPROP},
    {CLIMB, 32},
    {UP},
    {IN},
    {ENTER, 41},
    {-1}}, tr041[] =
{
    {JUMP, 28},
    {DOWN, 40},
    {-1}}, tr042[] =
{
    {EAST},
    {LAKE, 35},
    {WEST},
    {UP, 43},
    {NW},
    {DOWN, 47},
    {-1}}, tr043[] =
{
    {EAST, 42},
    {WEST},
    {CROSS, 44, 15},
    {DOWN, 611, 0, 0, 0, 1},
    {DOWN, 46, 80},
    {JUMP, 28},			/* IF ALL CHANCES FAIL */
    {-1}}, tr044[] =
{
    {EAST},
    {CROSS, 43, 20},
    {DOWN, 611, 0, 0, 0, 1},
    {DOWN, 46, 90},
    {JUMP, 28},
    {NW, 45},
    {-1}}, tr045[] =
{
    {EAST},
    {IN, 44},
    {JUMP, 24},
    {-1}}, tr046[] =
{
    {DOWN, 47},
    {NE, 48},
    {-1}}, tr047[] =
{
    {SE},
    {UP, 42},
    {NW},
    {DOWN, 49},
    {-1}}, tr048[] =
{
    {WEST, 46},
    {NORTH, 50},
    {-1}}, tr049[] =
{
    {SOUTH, 47},
    {NE},
    {DOWN, 50},
    {NW},
    {UP, 53},
    {-1}}, tr050[] =
{
    {EAST, 48},
    {SW},
    {UP, 49},
    {NE},
    {DOWN, 51},
    {-1}}, tr051[] =
{
    {SOUTH},
    {UP, 50},
    {DOWN},
    {NORTH, 52},
    {-1}}, tr052[] =
{
    {WEST, 51},
    {-1}}, tr053[] =
{
    {SOUTH},
    {DOWN, 49},
    {UP},
    {NORTH, 54},
    {-1}}, tr054[] =
{
    {SE},
    {DOWN, 53},
    {EAST},
    {UP, 55},
    {-1}}, tr055[] =
{
    {DOWN, 51},
    {WEST, 54},
    {EAST, 56},
    {-1}}, tr056[] =
{
    {WEST, 617, 12, 1, IF_PROP},
    {WEST, 55},
    {SE, 617, 12, 1, IF_PROP},
    {SE, 57},
    {-1}}, tr057[] =
{
    {NORTH, 56},
    {SE, 58},
    {-1}}, tr058[] =
{
    {NW, 57},
    {SE, 35},
    {-1}}, tr059[] =
{
    {EAST},
    {OUT, 36},
    {-1}}, tr060[] =
{
    {SOUTH},
    {CROSS},
    {DOWNS, 37, 58, 3, IF_PROP},
    {DOWNS, 618, 58, 0, IF_HAVE},
    {DOWNS, 614},
    {NORTH},
    {IN},
    {ENTER},
    {UPSTR, 61, 58, 3, IF_PROP},
    {UPSTR, 618, 58, 0, IF_HAVE},
    {UPSTR, 614},
    {-1}}, tr061[] =
{
    {SW},
    {OUT},
    {DOWNS, 60, 58, 3, IF_PROP},
    {DOWNS, 618, 58, 0, IF_HAVE},
    {DOWNS, 614},
    {NW},
    {UP},
    {UPSTR, 62, 58, 3, IF_PROP},
    {UPSTR, 618, 58, 0, IF_HAVE},
    {UPSTR, 614},
    {-1}}, tr062[] =
{
    {EAST},
    {DOWNS, 61, 58, 3, IF_PROP},
    {DOWNS, 618, 58, 0, IF_HAVE},
    {DOWNS, 614},
    {WEST},
    {ENTER, 63, 58, 0, IF_NHAVE},
    {ENTER, 619},
    {-1}}, tr063[] =
{
    {EAST},
    {ENTER, 617, 12, 1, IF_PROP},
    {ENTER, 62},
    {SOUTH, 64},
    {SW, 65},
    {WEST, 71},
    {NW, 69},
    {NORTH, 70},
    {-1}}, tr064[] =
{
    {NE},
    {NORTH, 63},
    {NW, 71},
    {WEST, 65},
    {SE},
    {IN},
    {ENTER, 90},
    {-1}}, tr065[] =
{
    {EAST, 64},
    {NE, 63},
    {NORTH, 71},
    {WEST, 66},
    {NW, 67},
    {SOUTH},
    {ENTER, 79},
    {-1}}, tr066[] =
{
    {EAST, 65},
    {NORTH, 67},
    {NE, 71},
    {SW},
    {ENTER, 80},
    {-1}}, tr067[] =
{
    {SE, 65},
    {SOUTH, 66},
    {NORTH, 68},
    {NE, 69},
    {EAST, 71},
    {WEST},
    {ENTER},
    {PRIVY},
    {IN, 78},
    {-1}}, tr068[] =
{
    {SOUTH, 67},
    {EAST, 69},
    {SE, 71},
    {NW},
    {ENTER, 76},
    {-1}}, tr069[] =
{
    {SW, 67},
    {WEST, 68},
    {NORTH},
    {ENTER, 75},
    {EAST, 70},
    {SE, 63},
    {SOUTH, 71},
    {-1}}, tr070[] =
{
    {WEST, 69},
    {SOUTH, 63},
    {SW, 71},
    {NE},
    {ENTER, 72},
    {-1}}, tr071[] =
{
    {EAST, 63},
    {SE, 64},
    {SOUTH, 65},
    {SW, 66},
    {WEST, 67},
    {NW, 68},
    {NORTH, 69},
    {NE, 70},
    {DOWN, 120, 18, 0, IF_PROP},
    {DOWN, 509},
    {-1}}, tr072[] =
{
    {SW},
    {OUT, 70},
    {EAST, 73},
    {NORTH, 74},
    {SOUTH, 89, 22, 0, IF_HAVE},
    {SOUTH, 509},
    {-1}}, tr073[] =
{
    {WEST, 72},
    {NORTH, 74},
    {UP, 88, 22, 0, IF_HAVE},
    {UP, 509},
    {-1}}, tr074[] =
{
    {SOUTH, 72},
    {EAST, 73},
    {WEST, 75},
    {-1}}, tr075[] =
{
    {SOUTH},
    {OUT, 69},
    {EAST},
    {IN, 74},
    {-1}}, tr076[] =
{
    {SE},
    {OUT, 68},
    {NW},
    {IN},
    {ENTER, 77, 91, 0, IF_PROP},
    {ENTER, 696, 0, 0, 0, 1},
    {ENTER, 0, 100},
    {-1}}, tr077[] =
{
    {SE},
    {OUT, 76},
    {-1}}, tr078[] =
{
    {HOPE, 2},
    {EAST},
    {OUT, 67},
    {-1}}, tr079[] =
{
    {NORTH},
    {OUT, 65},
    {-1}}, tr080[] =
{
    {NE},
    {OUT, 66},
    {OUT, 81, 1},		/* ROPE FUDGE */
    {-1}}, tr081[] =
{
    {IN},
    {ENTER},
    {NORTH},
    {NE},
    {EAST},
    {SE},
    {SOUTH},
    {SW},
    {WEST},
    {NW, 556},
    {NW, 80, 1},		/* rope fudge */
    {NW, 82, 1},		/* ROPE FUDGE */
    {-1}}, tr082[] =
{
    {SW},
    {ENTER, 83, 0, 1},		/* NO DWARVES HERE */
    {NW},
    {IN, 84, 22, 0, IF_PROP},
    {IN, 646},
    {IN, 81, 1},		/* ROPE FUDGE */
    {-1}}, tr083[] =
{
    {NE},
    {OUT, 557, 22, 0, IF_WITH, 1},
    {OUT, 82, 22, 0, IF_WITH},
    {OUT, 82},
    {-1}}, tr084[] =
{
    {SE, 557, 22, 0, IF_WITH, 1},
    {SE, 82, 22, 0, IF_WITH},
    {SE, 82},
    {SW, 85},
    {NW, 86},
    {-1}}, tr085[] =
{
    {EAST},
    {OUT, 84},
    {JUMP, 25},
    {-1}}, tr086[] =
{
    {SE, 84},
    {NORTH},
    {OUT, 87},
    {-1}}, tr087[] =
{
    {SOUTH, 600, 92, 1, IF_PROP},
    {SOUTH, 86},
    {-1}}, tr088[] =
{
    {DOWN, 73},
    {-1}}, tr089[] =
{
    {NORTH, 72},
    {-1}}, tr090[] =
{
    {NW},
    {OUT, 64},
    {UP},
    {CLIMB, 91, 23, 0, IF_HAVE},
    {CLIMB, 625, 23, 0, IF_WITH},
    {CLIMB, 624},
    {-1}}, tr091[] =
{
    {DOWN, 90},
    {EAST, 92, 23, 0, IF_HAVE},
    {EAST, 92, 20},
    {EAST, 624},
    {-1}}, tr092[] =
{
    {NW, 0, 10, 0, IF_HAVE, 1},
    {NW, 303, 93, 2, IF_PROP},
    {NW, 91, 100},
    {NE},
    {SE},
    {SW},
    {SOUTH, 92},
    {EAST, 93},
    {UP, 97},
    {NORTH, 99},
    {PAST, 102},
    {DOWN, 108},
    {FUTUR},
    {WEST, 109},
    {SOUTH, 116},
    {-1}}, tr093[] =
{
    {WEST, 92},
    {NE},
    {SE},
    {SOUTH},
    {SW},
    {NW},
    {DOWN},
    {PAST, 93},			/* CONFUSE YOU PRETTY GOOD THIS WAY */
    {NORTH, 94},
    {UP, 98},
    {FUTUR, 105},
    {EAST, 110},
    {-1}}, tr094[] =
{
    {SOUTH, 93},
    {NE},
    {EAST},
    {SE},
    {SW},
    {NW},
    {DOWN},
    {NORTH, 94},
    {UP, 95},
    {WEST, 99},
    {FUTUR, 104},
    {PAST, 109},
    {-1}}, tr095[] =
{
    {DOWN, 94},
    {NE},
    {EAST},
    {SE},
    {SW},
    {NW},
    {UP},
    {NORTH, 95},
    {WEST, 96},
    {SOUTH, 98},
    {FUTUR, 107},
    {PAST, 111},
    {-1}}, tr096[] =
{
    {EAST, 95},
    {NE},
    {SE},
    {SW},
    {WEST},
    {NW},
    {UP},
    {NORTH, 96},
    {SOUTH, 97},
    {DOWN, 99},
    {PAST, 110},
    {FUTUR, 112},
    {-1}}, tr097[] =
{
    {DOWN, 92},
    {NORTH, 96},
    {NE},
    {SE},
    {SOUTH},
    {SW},
    {WEST},
    {NW},
    {UP, 97},
    {EAST, 98},
    {PAST, 101},
    {FUTUR, 113},
    {-1}}, tr098[] =
{
    {DOWN, 93},
    {NORTH, 95},
    {WEST, 97},
    {NE},
    {EAST},
    {SE},
    {SOUTH},
    {SW},
    {NW, 98},
    {FUTUR, 106},
    {PAST, 114},
    {-1}}, tr099[] =
{
    {SOUTH, 92},
    {EAST, 94},
    {UP, 96},
    {NE},
    {SE},
    {SW},
    {WEST},
    {NW},
    {DOWN},
    {FUTUR, 99},
    {PAST, 103},
    {NORTH, 117},
    {-1}}, tr100[] =
{
    {FUTUR, 96},
    {EAST},
    {SE},
    {SOUTH},
    {SW},
    {WEST},
    {DOWN},
    {NORTH, 100},
    {NE, 101},
    {NW, 103},
    {UP, 107},
    {PAST, 116},
    {-1}}, tr101[] =
{
    {FUTUR, 97},
    {SW, 100},
    {NE},
    {EAST},
    {SE},
    {SOUTH},
    {WEST},
    {DOWN},
    {NORTH},
    {PAST, 101},
    {NW, 102},
    {UP, 106},
    {-1}}, tr102[] =
{
    {FUTUR, 92},
    {SE, 101},
    {NE},
    {EAST},
    {SOUTH},
    {WEST},
    {NW},
    {DOWN},
    {NORTH, 102},
    {SW, 103},
    {UP, 105},
    {PAST, 119},
    {-1}}, tr103[] =
{
    {FUTUR, 99},
    {SE, 100},
    {NE, 102},
    {EAST},
    {SOUTH},
    {SW},
    {WEST},
    {NW},
    {DOWN},
    {NORTH, 103},
    {UP, 104},
    {PAST, 114},
    {-1}}, tr104[] =
{
    {PAST, 94},
    {DOWN, 103},
    {EAST},
    {SOUTH},
    {SW},
    {WEST},
    {NW},
    {UP},
    {NORTH},
    {FUTUR, 104},
    {NE, 105},
    {SE, 107},
    {-1}}, tr105[] =
{
    {PAST, 93},
    {DOWN, 102},
    {SW, 104},
    {NE},
    {EAST},
    {SOUTH},
    {WEST},
    {NW},
    {UP},
    {NORTH},
    {FUTUR, 105},
    {SE, 106},
    {-1}}, tr106[] =
{
    {PAST, 98},
    {DOWN, 101},
    {NW, 105},
    {NE},
    {EAST},
    {SE},
    {SOUTH},
    {WEST},
    {UP},
    {NORTH, 106},
    {SW, 107},
    {FUTUR, 118},
    {-1}}, tr107[] =
{
    {PAST, 95},
    {DOWN, 100},
    {NW, 104},
    {NE, 106},
    {EAST},
    {SE},
    {SOUTH},
    {SW},
    {WEST},
    {UP},
    {NORTH},
    {FUTUR, 107},
    {-1}}, tr108[] =
{
    {WEST, 92},
    {-1}}, tr109[] =
{
    {PAST, 92, 100},		/* WHY 100% ? */
    {EAST, 94},
    {-1}}, tr110[] =
{
    {FUTUR, 93, 100},
    {-1}}, tr111[] =
{
    {FUTUR, 95, 100},
    {-1}}, tr112[] =
{
    {PAST, 96, 100},
    {-1}}, tr113[] =
{
    {FUTUR, 97},
    {-1}}, tr114[] =
{
    {FUTUR, 98, 100},
    {-1}}, tr115[] =
{
    {PAST, 103, 100},
    {-1}}, tr116[] =
{
    {PAST, 100, 100},
    {-1}}, tr117[] =
{
    {PAST, 99, 100},
    {-1}}, tr118[] =
{
    {PAST, 106, 100},
    {-1}}, tr119[] =
{
    {PAST, 102, 100},
    {-1}}, tr120[] =
{
    {UP, 71},
    {-1}}, tr121[] =
{
    {EAST, 122},
    {-1}}, tr122[] =
{
    {WEST, 121},
    {SE, 123},
    {EAST, 124},
    {NE, 125},
    {-1}}, tr123[] =
{
    {NW, 122},
    {NE, 124},
    {NORTH, 125},
    {-1}}, tr124[] =
{
    {WEST, 122},
    {SW, 123},
    {NW, 125},
    {EAST, 127},
    {-1}}, tr125[] =
{
    {SW, 122},
    {SOUTH, 123},
    {SE, 124},
    {NORTH},
    {IN},
    {ENTER, 126},
    {-1}}, tr126[] =
{
    {SOUTH},
    {OUT, 125},
    {-1}}, tr127[] =
{
    {WEST, 124},
    {EAST},
    {IN},
    {ENTER, 128},
    {NORTH},
    {SHAFT, 129},
    {-1}}, tr128[] =
{
    {WEST},
    {OUT, 127},
    {-1}}, tr129[] =
{
    {EAST},
    {OUT, 127},
    {JUMP, 25},
    {JUMP, 131, 1},		/* ??? */
    {-1}}, tr130[] =
{
    {JUMP, 25},
    {MISFO, 2},
    {BANIS, 301},
    {JUMP, 129, 1},		/* ??? */
    {JUMP, 131, 1},
    {-1}}, tr131[] =
{
    {WEST},
    {IN},
    {ENTER, 132},
    {BANIS},
    {MISFO, 714, 81, 0, IF_PROP, 1},
    {MISFO, 301},
    {MISFO, 663, 81, 1, IF_PROP, 1},
    {MISFO, 301},
    {MISFO, 42},
    {MISFO, 129, 1},		/* ??? */
    {-1}}, tr132[] =
{
    {EAST},
    {SHAFT, 131},
    {WEST, 711, 11, 0, IF_NPROP},
    {WEST, 133},
    {-1}}, tr133[] =
{
    {EAST, 132},
    {WEST, 0, 12, 1, IF_PROP, 1},
    {WEST, 134, 0, 1},		/* NO DWARVES */
    {WEST, 698, 12, 0, IF_WITH},
    {WEST, 614},
    {-1}}, tr134[] =
{
    {EAST, 133, 0, 1},		/* NO DWARVES */
    {WEST, 135, 0, 1},		/* NO DWARVES */
    {-1}}, tr135[] =
{
    {EAST, 0, 12, 1, IF_PROP, 1},
    {EAST, 134, 0, 1},		/* NO DWARVES */
    {EAST, 698, 12, 0, IF_WITH},
    {WEST, 136},
    {-1}}, tr136[] =
{
    {EAST, 135},
    {NORTH},
    {IN},
    {ENTER, 137},
    {WEST, 617, 12, 1, IF_PROP},
    {WEST, 138},
    {-1}}, tr137[] =
{
    {SOUTH},
    {OUT, 136},
    {-1}}, tr138[] =
{
    {EAST, 136},
    {WEST},
    {CROSS, 139},
    {JUMP, 305},
    {-1}}, tr139[] =
{
    {EAST},
    {CROSS, 138},
    {JUMP, 715, 10},
    {JUMP, 716, 0, 0, 0, 1},
    {JUMP, 140},
    {-1}}, tr140[] =
{
    {EAST},
    {CROSS, 139},
    {DOWN},
    {IN},
    {ENTER, 141, 0, 1},		/* NO DWARVES */
    {JUMP, 305},
    {-1}}, tr141[] =
{
    {DOWN, 142},
    {JUMP, 305},
    {-1}}, tr142[] =
{
    {UP},
    {CLIMB, 141},
    {DOWN, 143},
    {JUMP, 305},
    {-1}}, tr143[] =
{
    {UP},
    {CLIMB, 142},
    {DOWN, 144, 0, 1},		/* NO DWARVES */
    {JUMP, 305},
    {-1}}, tr144[] =
{
    {UP},
    {CLIMB, 143},
    {JUMP, 719, 0, 0, 0, 1},
    {JUMP, 91},
    {-1}}, tr145[] =
{
    {DOWN},
    {JUMP, 720},
    {EAST, 146},
    {SOUTH, 147},
    {WEST, 148},
    {NORTH, 149},
    {-1}}, tr146[] =
{
    {WEST},
    {UP},
    {CLIMB, 145},
    {SW, 147},
    {NW, 149},
    {EAST},
    {IN},
    {ENTER, 150},
    {-1}}, tr147[] =
{
    {UP},
    {NORTH},
    {CLIMB, 145},
    {NE, 146},
    {NW, 148},
    {SOUTH},
    {IN},
    {ENTER, 713, 0, 0, 0, 1},
    {ENTER, 0, 100},		/* ??? */
    {-1}}, tr148[] =
{
    {EAST},
    {UP},
    {CLIMB, 145},
    {SE, 147},
    {NE, 149},
    {WEST},
    {IN},
    {ENTER, 710, 0, 0, 0, 1},
    {ENTER, 0, 100},		/* ??? */
    {-1}}, tr149[] =
{
    {UP},
    {CLIMB},
    {SOUTH, 145},
    {SW, 148},
    {SE, 146},
    {NORTH},
    {IN},
    {ENTER, 712, 0, 0, 0, 1},
    {ENTER, 0, 100},		/* ??? */
    {-1}}, tr150[] =
{
    {WEST},
    {OUT, 306},
    {WEST, 146},
    {-1}};

struct cvloc cvloc[] =
{

    {				/* 0: no location number zero,
				   but this is used for FIXED and TAKEN */
	0,			/* flags */
	tr000,			/* travel not NULL to avoid flagging the end */
	"",			/* sdesc not null (for loop terminations) */
	""
    },
    {				/* 1: */
	LIGHT,			/* flags */
	tr001,
	"You're at the end of road again.\n",
	"You are standing before a barn at the northern end of a road.\n\
To the east is a pasture.  To the west and north are woods.\n\
There are well-worn paths in several directions.\n"
    },
    {				/* 2: */
	LIGHT | C_WATER,	/* flags */
	tr002,
	"You're inside barn.\n",
	"You're in the barn.  It has been converted to quarters for spelunkers.\n\
There are electric lights, and a number of mattresses strewn about.\n"
    },
    {				/* 3: */
	LIGHT,			/* flags */
	tr003,
	"You're at privvy.\n",
  "You are in the woods at the end of a path.  Before you is a privvy.\n"
    },
    {				/* 4: */
	LIGHT,			/* flags */
	tr004,
	"You're in privvy.\n",
	"You're in the privvy.\n"
    },
    {				/* 5: */
	LIGHT,			/* flags */
	tr005,
	"You're in pasture.\n",
	"You are in a pasture.  On the east are woods.  There's a building to the\n\
west.  A fence and a road border the pasture to the north and the south.\n"
    },
    {				/* 6: */
	LIGHT,			/* flags */
	tr006,
	"You're at shaft in woods.\n",
	"You are in the woods.  Before you is a wide shaft.  You could climb down\n\
here, but you could not get back up.\n"
    },
    {				/* 7: */
	LIGHT,			/* flags */
	tr007,
	"You're at bottom of forest shaft.\n",
	"You are at the bottom of a wide shaft.  A dimly lit, muddy crawl leads\n\
to the east.\n"
    },
    {				/* 8: */
	LIGHT,			/* flags */
	tr008,
	"You're in muddy crawl.\n",
	"You are in a muddy, sloping east-west crawlway.  Faint light is visible\n\
in either direction.\n"
    },
    {				/* 9: */
	LIGHT,			/* flags */
	tr009,
	"You're at bottom of sinkhole.\n",
	"You are in the bottom of a smelly sinkhole.  A dimly lit, muddy crawlway\n\
leads west.\n"
    },
    {				/* 10: */
	LIGHT,			/* flags */
	tr010,
	"You're in pigpen.\n",
	"You are inside a fenced pen.  There is a sinkhole here.  There are\n\
several pigs wandering about.\n"
    },
    {				/* 11: */
	LIGHT,			/* flags */
	tr011,
	"You're at fence.\n",
	"You are at a fence surrounding a sinkhole.  There are woods all around\n\
you except to the south, where there is a field.  There is a path to the\n\
southwest.\n"
    },
    {				/* 12: */
	LIGHT,			/* flags */
	tr012,
	NULL,
	"You are in dense woods.\n"
    },
    {				/* 13: */
	LIGHT,			/* flags */
	tr013,
	NULL,
	"You are in open woods.\n"
    },
    {				/* 14: */
	LIGHT,			/* flags */
	tr014,
	"You're at top of cliff.\n",
	"You are at the top of a north-south cliff.  To the north and east are\n\
woods.  Below you is a river.  A sign reads,\n\
    \"SCALING CLIFF FACE IS HAZARDOUS.  USE PROPER EQUIPMENT.\"\n"
    },
    {				/* 15: */
	LIGHT,			/* flags */
	tr015,
	"You're at bend of cliff.\n",
	"You are at a bend along the edge of a cliff.  There is a river below.\n\
To the east the cliffs become lower.\n"
    },
    {				/* 16: */
	LIGHT,			/* flags */
	tr016,
	"You're at top of bluff.\n",
	"You are at the top of an east-west bluff.\n"
    },
    {				/* 17: */
	LIGHT,			/* flags */
	tr017,
	"You're at bend in road.\n",
	"You are at a bend in the road.  To the north the road leads toward a\n\
building.  A path leads west through brambles.\n"
    },
    {				/* 18: */
	LIGHT,			/* flags */
	tr018,
	"You're on road near meadow.\n",
	"You are on a road bordering the south edge of a meadow.\n"
    },
    {				/* 19: */
	LIGHT,			/* flags */
	tr019,
	"You're at road junction.\n",
	"You are at a junction of an east-west road and a road to the southwest.\n\
There is a \"ROAD CLOSED\" sign on the east fork.\n"
    },
    {				/* 20: */
	LIGHT,			/* flags */
	tr020,
	"You're at park headquarters.\n",
	"You are on a road leading down to the river.  A building nearby says\n\
    \"CRYSTAL CAVE PARK HEADQUARTERS\"\n"
    },
    {				/* 21: */
	LIGHT,			/* flags */
	tr021,
	NULL,
	"You are inside the park detention center.\n"
    },
    {				/* 22: */
	LIGHT | C_WATER,	/* flags */
	tr022,
	NULL,
	"You are on the road by the river.  The road bends westward following a\n\
small stream that enters the river here.\n"
    },
    {				/* 23: */
	LIGHT | C_WATER,	/* flags */
	tr023,
	"You're at parking lot.\n",
	"You are at a stream exiting from a cliff.  A sign says:\n\
        \"CRYSTAL CAVE PARKING LOT.\n\
     PLEASE FOLLOW PATH BESIDE STREAM\n\
          NORTH TO CAVE ENTRANCE.\"\n"
    },
    {				/* 24: */
	LIGHT,			/* flags */
	tr024,
	NULL,
	"You are at the bottom of a cliff with a broken neck.\n"
    },
    {				/* 25: */
	LIGHT,			/* flags */
	tr025,
	NULL,
	"You are at the bottom of a shaft with a broken neck.\n"
    },
    {				/* 26: */
	LIGHT | HINT5,		/* flags */
	tr026,
	"You are in a tangled, thick maze of woods.\n",
	"You are in a thick maze of tangled woods.\n"
    },
    {				/* 27: */
	LIGHT | HINT5,		/* flags */
	tr027,
	"You are in a maze of tangled, thick woods.\n",
	"You are in a maze of thick, tangled woods.\n"
    },
    {				/* 28: */
	0,			/* flags */
	tr028,
	NULL,
	"You are at the bottom of a pit with a broken neck.\n"
    },
    {				/* 29: */
	LIGHT | HINT5,		/* flags */
	tr029,
	"You are in a thickly tangled maze of woods.\n",
	"You are in a tangled maze of thick woods.\n"
    },
    {				/* 30: */
	LIGHT | HINT1,		/* flags */
	tr030,
	"You're at cave mouth.\n",
	"You are at the mouth of the cave.\n"
    },
    {				/* 31: */
	LIGHT,			/* flags */
	tr031,
	"You're inside entrance.\n",
	"You are inside the entrance.  A stream exits here.  A path runs beside\n\
the stream.\n"
    },
    {				/* 32: */
	LIGHT | C_WATER | RANGER,	/* flags */
	tr032,
	"You're in stream passage.\n",
	"You are in a passage, beside a swiftly flowing stream.  A dark hole is\n\
visible at the top of a nearby column.\n"
    },
    {				/* 33: */
	LIGHT | C_WATER | RANGER,	/* flags */
	tr033,
	"You're at south end of lake.\n",
	"You are at a large, misty underground lake.  A stream flows south over\n\
rapids.  Across the stream, a large passage heads west.\n"
    },
    {				/* 34: */
	LIGHT | C_WATER,	/* flags */
	tr034,
	NULL,
	"You are on the east side of the misty lake.\n"
    },
    {				/* 35: */
	LIGHT | C_WATER | RANGER,	/* flags */
	tr035,
	"You're at west side of lake.\n",
	"You are on the beach on the west side of the misty lake.  A large\n\
passage leads west.  There is a stony crawl here leading northwest.\n"
    },
    {				/* 36: */
	LIGHT | C_WATER,	/* flags */
	tr036,
	"You're at northwest side of lake.\n",
	"You are on the northwest side of the misty lake.  There is a broken\n\
crawl here.\n"
    },
    {				/* 37: */
	LIGHT | C_WATER | HINT2,/* flags */
	tr037,
	NULL,
	"You are at the upper end of the misty lake.\n"
    },
    {				/* 38: */
	LIGHT | C_WATER | DROWN,/* flags */
	tr038,
	NULL,
	"You are in the middle of the lower end of the misty lake.\n"
    },
    {				/* 39: */
	LIGHT | C_WATER | DROWN,/* flags */
	tr039,
	NULL,
	"You are in the middle of the upper end of the misty lake.\n"
    },
    {				/* 40: */
	LIGHT,			/* flags */
	tr040,
	"You're at top of column.\n",
	"You are at the top of the column.  A hole leads up.\n"
    },
    {				/* 41: */
	0,			/* flags */
	tr041,
	NULL,
	"Dead end.\n"
    },
    {				/* 42: */
	LIGHT | RANGER,		/* flags */
	tr042,
	"You're at junction of 3 passages.\n",
	"You are at the junction of three passages.  One rises steeply, one is\n\
large and level, and one descends slightly.\n"
    },
    {				/* 43: */
	LIGHT | RANGER,		/* flags */
	tr043,
	"You're at east edge of domepit.\n",
	"You are at the east edge of a domepit.  You probably can't cross safely.\n"
    },
    {				/* 44: */
	RANGER,			/* flags */
	tr044,
	"You're at west edge of domepit.\n",
	"You are at the west edge of a domepit.  You probably can't cross safely.\n"
    },
    {				/* 45: */
	LIGHT,			/* flags */
	tr045,
	"You're at window.\n",
	"You are at a small window at the end of a passage.  The window looks out\n\
over a beautiful view of the countryside, and is located in the side of\n\
an immense cliff, above a river.\n"
    },
    {				/* 46: */
	LIGHT | RANGER,		/* flags */
	tr046,
	"You're at bottom of high dome.\n",
	"You are at the bottom of a high dome.  There seems to be a passage near\n\
the top, but you have no way to get to it.  There is a passage to the\n\
northeast, and a hole leading to a lower level.  If you go down, you\n\
won't be able to get back up.\n"
    },
    {				/* 47: */
	LIGHT,			/* flags */
	tr047,
	"You're in trench room.\n",
	"You are in a long flat room, sloping along a trench in the floor.  There\n\
is a hole in the ceiling, but you can't reach it.\n"
    },
    {				/* 48: */
	LIGHT | C_WATER | RANGER,	/* flags */
	tr048,
	"You're at clock shop.\n",
	"You are at the end of a long passage.  Water drips from a thicket of\n\
stalagtites overhead, into a small stone cup under each stalagtite.  The\n\
acoustics are such that each drip sounds like a clock ticking, and the\n\
general effect is that of being in a clock shop.  A small, muddy crawlway\n\
leads off from here.\n"
    },
    {				/* 49: */
	LIGHT | RANGER,		/* flags */
	tr049,
	"You're at intersection of 3 passages.\n",
	"You are at the intersection of three passages.  One rises slightly, one\n\
drops rapidly.\n"
    },
    {				/* 50: */
	LIGHT | RANGER,		/* flags */
	tr050,
	"You're in sloping passage with crawl.\n",
   "You are in a long, sloping passage.  A crawl enters from the east.\n"
    },
    {				/* 51: */
	LIGHT,			/* flags */
	tr051,
	"You're in sloping passage.\n",
	"You are in a long, sloping passage.  There is an opening above, but you\n\
can't climb to it.\n"
    },
    {				/* 52: */
	RANGER,			/* flags */
	tr052,
	"You're in large chamber.\n",
	"You are in a large chamber.  A passage leads to the west.\n"
    },
    {				/* 53: */
	LIGHT | RANGER,		/* flags */
	tr053,
	NULL,
	"You are in a steeply sloping passage.\n"
    },
    {				/* 54: */
	LIGHT | RANGER,		/* flags */
	tr054,
	NULL,
	"You are in a curving, steeply sloping passage.\n"
    },
    {				/* 55: */
	LIGHT | RANGER,		/* flags */
	tr055,
	"You're in high passage.\n",
	"You are in a high passage.  There is a hole in the floor here, but if\n\
you go down, you will not be able to get back up.\n"
    },
    {				/* 56: */
	LIGHT,			/* flags */
	tr056,
	"You're in magnificent chamber.\n",
	"You are in a magnificent chamber.  A narrow passage lies to the west,\n\
and a small crawl leads off the the southeast.  Overhead, far out of\n\
reach, you can dimly make out another passage.\n"
    },
    {				/* 57: */
	RANGER,			/* flags */
	tr057,
	NULL,
	"You are crawling over sharp, broken, chert.\n"
    },
    {				/* 58: */
	RANGER,			/* flags */
	tr058,
	NULL,
	"You are crawling over sharp, broken, chert.\n"
    },
    {				/* 59: */
	0,			/* flags */
	tr059,
	"Dead end.\n",
	"The crawlway has collapsed ahead...dead end.\n"
    },
    {				/* 60: */
	C_WATER,		/* flags */
	tr060,
	"You're in a low, water-filled passage.\n",
	"You are in a low, water-filled passage.  Water drips from the ceiling\n\
here.  It is very low, but you can get the boat through.\n"
    },
    {				/* 61: */
	C_WATER,		/* flags */
	tr061,
	"You're in sinuous passage.\n",
 "You are in a long, sinuous passage, the water lapping at both walls.\n"
    },
    {				/* 62: */
	C_WATER,		/* flags */
	tr062,
	"You're in pool hall.\n",
	"You are in a large hall with a pool of water.  To the south, a waterfall\n\
thunders into the pool, and flows out through a passage to the east.  To\n\
the west, a hole in the wall looms beyond a small beach.\n"
    },
    {				/* 63: */
	0,			/* flags */
	tr063,
	"You're at the east side of the Hall of the Mountain King.\n",
	"You are at the east side of the Hall of the Mountain King.  There is a\n\
passage here.\n"
    },
    {				/* 64: */
	0,			/* flags */
	tr064,
	"You're at the SE side of the Hall of the Mountain King.\n",
	"You are at the southeast side of the Hall of the Mountain King.  There\n\
is a passage here.\n"
    },
    {				/* 65: */
	0,			/* flags */
	tr065,
	"You're at the south side of the Hall of the Mountain King.\n",
	"You are at the south side of the Hall of the Mountain King.  There is a\n\
passage here.\n"
    },
    {				/* 66: */
	0,			/* flags */
	tr066,
	"You're at the SW side of the Hall of the Mountain King.\n",
	"You are at the southwest side of the Hall of the Mountain King.  There\n\
is a passage here.\n"
    },
    {				/* 67: */
	0,			/* flags */
	tr067,
	"You're at the west side of the Hall of the Mountain King.\n",
	"You are at the west side of the Hall of the Mountain King.  Inscribed\n\
above a passageway are the words:\n\
     \"ABANDON HOPE, ALL YE WHO ENTER HERE\".\n"
    },
    {				/* 68: */
	0,			/* flags */
	tr068,
	"You're at the NW side of the Hall of the Mountain King.\n",
	"You are at the northwest side of the Hall of the Mountain King.  There\n\
is a passage here.\n"
    },
    {				/* 69: */
	0,			/* flags */
	tr069,
	"You're at the north side of the Hall of the Mountain King.\n",
	"You are at the north side of the Hall of the Mountain King.  There is a\n\
passage here.\n"
    },
    {				/* 70: */
	0,			/* flags */
	tr070,
	"You're at the NE side of the Hall of the Mountain King.\n",
	"You are at the northeast side of the Hall of the Mountain King.  There\n\
is a passage here.\n"
    },
    {				/* 71: */
	SECRET,			/* flags */
	tr071,
	"You're at the center of the Hall of the Mountain King.\n",
	"You are in the center of the Hall of the Mountain King, a large\n\
octagonal room.  There are passages on all sides!\n"
    },
    {				/* 72: */
	SECRET,			/* flags */
	tr072,
	"You're in the Banquet Hall.\n",
	"You are in the Banquet Hall, with a long table running to the head of\n\
the room.  The moldy remains of a meal are on the table.\n"
    },
    {				/* 73: */
	C_WINE | SECRET,	/* flags */
	tr073,
	"You're in the King's Storeroom.\n",
 "You are in the King's Storeroom.  It is filled with barrels of wine.\n"
    },
    {				/* 74: */
	0,			/* flags */
	tr074,
	NULL,
	"You are in the King's Kitchen.\n"
    },
    {				/* 75: */
	0,			/* flags */
	tr075,
	NULL,
	"You are in the King's Library.\n"
    },
    {				/* 76: */
	0,			/* flags */
	tr076,
	NULL,
	"You are in the King's Guard Room.\n"
    },
    {				/* 77: */
	0,			/* flags */
	tr077,
	NULL,
	"You are in the King's Counting Room.\n"
    },
    {				/* 78: */
	LIGHT,			/* flags */
	tr078,
	"You're in the Privy Chamber.\n",
	"You are in the Privy Chamber.  There is a row of six thrones here.\n\
Faint light comes from two holes in the ceiling at one corner of the\n\
chamber.  On the wall are written the words:\n\
    \"LIVES THERE A KING WITH SOUL SO DEAD . . .\"\n\
The rest is illegible.\n"
    },
    {				/* 79: */
	LIGHT,			/* flags */
	tr079,
	"You're in the armory.\n",
	"You are in the armory.  A glow comes from the coals in the smith's\n\
forge.  There are many tools hanging here.\n"
    },
    {				/* 80: */
	0,			/* flags */
	tr080,
	"You're in the Torture Chamber.\n",
	"You are in the Torture Chamber.  There is a doorway to the northeast\n\
and a deep hole chiseled in the rock floor at the other end of the\n\
chamber.  A metal ring has been hammered into the rock at the top of the\n\
hole.  There are rusted, useless instruments strewn about.  The remains\n\
of something, which are best not to dwell upon, are on the rack.\n"
    },
    {				/* 81: */
	HINT6,			/* flags */
	tr081,
	"You're in Dungeon.\n",
	"You are in the King's Dungeon.  To the northeast, there is a hole in the\n\
ceiling above.  At the southwestern end is another deep pit in the floor\n\
with a metal anchor ring.  Around the walls are openings, each sealed\n\
with a huge boulder preventing any access to the cells within.  From the\n\
look of this place, I'm not sure you want to know what's in them anyway.\n"
    },
    {				/* 82: */
	SECRET,			/* flags */
	tr082,
	"You're in corridor.\n",
	"You are in a narrow, northeast trending corridor.\n"
    },
    {				/* 83: */
	ESCAPE,			/* flags */
	tr083,
	"You're in crypt.\n",
	"You are in the crypt.\n"
    },
    {				/* 84: */
	0,			/* flags */
	tr084,
	"You're in secret passage.\n",
	"You are in a secret passage running southeast.  A second passage enters\n\
from the southwest.\n"
    },
    {				/* 85: */
	0,			/* flags */
	tr085,
	NULL,
	"You are at a low window, overlooking a magnificent chamber.\n"
    },
    {				/* 86: */
	LIGHT | C_WATER,	/* flags */
	tr086,
	"You're at south end of grotto.\n",
	"You are at the south end of a grotto.  The floor is sand, sloping off to\n\
a beach, and a lake to the west.  Faint light is visible to the north.\n\
There is evidence of a former passage to the west, but it has collapsed,\n\
and there is no way to go in that direction now.  At one time in the far\n\
distant past, the grotto was obviously used by pirates, and there is the\n\
tattered remains of a \"Jolly Roger\" hanging from the ceiling.\n"
    },
    {				/* 87: */
	LIGHT | C_WATER,	/* flags */
	tr087,
	"You're at north end of grotto.\n",
	"You are at the north end of a grotto with a sand floor and a lake.\n\
Light filters up from the lake, and you can faintly see an opening to the\n\
outside world under water, but it is inaccessible.\n"
    },
    {				/* 88: */
	0,			/* flags */
	tr088,
	NULL,
	"You're in the King's Cupboard.\n"
    },
    {				/* 89: */
	0,			/* flags */
	tr089,
	NULL,
	"You're in the King's Cloakroom.\n"
    },
    {				/* 90: */
	0,			/* flags */
	tr090,
	"You're at bottom of Wizard's Tower.\n",
	"You are at the bottom of the Wizard's Tower.  Finely carved stone steps\n\
spiral upward.\n"
    },
    {				/* 91: */
	0,			/* flags */
	tr091,
	"You're at top of Wizard's Tower.\n",
	"You are at the top of the Wizard's Tower.  Finely carved stone steps\n\
spiral downward.  This chamber has a door on the east side, with the\n\
words\n\
     \"CAUTION: THE TIME MAZE LIES BEYOND\"\n\
chiseled above.\n"
    },
    {				/* 92: */
	HINT3,			/* flags */
	tr092,
	NULL,
	"You're in the Timemaze.\n"
    },
    {				/* 93: */
	HINT3,			/* flags */
	tr093,
	NULL,
	"You're in the Timemaze.\n"
    },
    {				/* 94: */
	HINT3,			/* flags */
	tr094,
	NULL,
	"You're in the Timemaze.\n"
    },
    {				/* 95: */
	HINT3,			/* flags */
	tr095,
	NULL,
	"You're in the Timemaze.\n"
    },
    {				/* 96: */
	HINT3,			/* flags */
	tr096,
	NULL,
	"You're in the Timemaze.\n"
    },
    {				/* 97: */
	HINT3,			/* flags */
	tr097,
	NULL,
	"You're in the Timemaze.\n"
    },
    {				/* 98: */
	HINT3,			/* flags */
	tr098,
	NULL,
	"You're in the Timemaze.\n"
    },
    {				/* 99: */
	HINT3,			/* flags */
	tr099,
	NULL,
	"You're in the Timemaze.\n"
    },
    {				/* 100: */
	HINT3,			/* flags */
	tr100,
	NULL,
	"You're in the Timemaze.\n"
    },
    {				/* 101: */
	HINT3,			/* flags */
	tr101,
	NULL,
	"You're in the Timemaze.\n"
    },
    {				/* 102: */
	HINT3,			/* flags */
	tr102,
	NULL,
	"You're in the Timemaze.\n"
    },
    {				/* 103: */
	HINT3,			/* flags */
	tr103,
	NULL,
	"You're in the Timemaze.\n"
    },
    {				/* 104: */
	HINT3,			/* flags */
	tr104,
	NULL,
	"You're in the Timemaze.\n"
    },
    {				/* 105: */
	HINT3,			/* flags */
	tr105,
	NULL,
	"You're in the Timemaze.\n"
    },
    {				/* 106: */
	HINT3,			/* flags */
	tr106,
	NULL,
	"You're in the Timemaze.\n"
    },
    {				/* 107: */
	HINT3,			/* flags */
	tr107,
	NULL,
	"You're in the Timemaze.\n"
    },
    {				/* 108: */
	HINT4,			/* flags */
	tr108,
	NULL,
	"Dead end.\n"
    },
    {				/* 109: */
	HINT4,			/* flags */
	tr109,
	NULL,
	"Dead end.\n"
    },
    {				/* 110: */
	ESCAPE,			/* flags */
	tr110,
	NULL,
	"Dead end.\n"
    },
    {				/* 111: */
	HINT4,			/* flags */
	tr111,
	NULL,
	"Dead end.\n"
    },
    {				/* 112: */
	HINT4,			/* flags */
	tr112,
	NULL,
	"Dead end.\n"
    },
    {				/* 113: */
	HINT4,			/* flags */
	tr113,
	"Dead end.\n",
	"Dead end.  A scrap of a work order has been left behind by the Crystal\n\
Cave Maintenance Engineer.  It reads:\n\
     \"MOVE SILVER TO WEST OF THE MAZE ENTRANCE.\"\n"
    },
    {				/* 114: */
	HINT4,			/* flags */
	tr114,
	NULL,
	"Dead end.\n"
    },
    {				/* 115: */
	HINT4,			/* flags */
	tr115,
	NULL,
	"Dead end.\n"
    },
    {				/* 116: */
	HINT4,			/* flags */
	tr116,
	NULL,
	"Dead end.\n"
    },
    {				/* 117: */
	HINT4,			/* flags */
	tr117,
	NULL,
	"Dead end.\n"
    },
    {				/* 118: */
	HINT4,			/* flags */
	tr118,
	NULL,
	"Dead end.\n"
    },
    {				/* 119: */
	HINT4,			/* flags */
	tr119,
	NULL,
	"Dead end.\n"
    },
    {				/* 120: */
	ESCAPE,			/* flags */
	tr120,
	"You're at top of throne pit.\n",
	"You are in a small chamber beneath the throne.  There is a deep pit in\n\
the floor.\n"
    },
    {				/* 121: */
	LIGHT,			/* flags */
	tr121,
	"You're at bottom of throne pit.\n",
	"You are at the bottom of the throne pit.  Light enters through a passage\n\
to the east.\n"
    },
    {				/* 122: */
	LIGHT,			/* flags */
	tr122,
	"You're at west side of garden.\n",
	"You are at the west side of a garden.  There is a murmuring sound to the\n\
southeast.\n"
    },
    {				/* 123: */
	LIGHT | C_WATER,	/* flags */
	tr123,
	"You're at south side of garden.\n",
	"You are at the south side of a garden.  There is a sparkling pool of\n\
water here, which overflows and flows northeast as a murmuring stream.\n"
    },
    {				/* 124: */
	LIGHT | C_WATER,	/* flags */
	tr124,
	"You're at east side of garden.\n",
	"You are at the east side of a garden.  A murmuring stream enters from\n\
the southeast, and exits through a passage to the east.\n"
    },
    {				/* 125: */
	LIGHT,			/* flags */
	tr125,
	"You're at north side of garden.\n",
	"You are at the north side of a garden.  A murmuring sound can be heard,\n\
both to the south, and to the southeast.  There is a doorway here.\n"
    },
    {				/* 126: */
	LIGHT,			/* flags */
	tr126,
	"You're in the harem.\n",
	"You are in the harem which is, alas, empty.  The room has been decorated\nwith delicate silken hangings on the walls, except over the doorway to\n\
the south.\n"
    },
    {				/* 127: */
	LIGHT | C_WATER,	/* flags */
	tr127,
	"You're at junction of three corridors.\n",
	"You are at the junction of three corridors.  One corridor leads east.\n\
A murmuring stream enters from the west, through a corridor with light at\n\
the far end.  The stream exits to the north, and occasional shreds of\n\
mist drift from this corridor, whence can be heard a distant roar.\n"
    },
    {				/* 128: */
	C_WATER,		/* flags */
	tr128,
	"You're in strongroom.\n",
	"You are in a strongroom, lined with empty shelves.  The only exit is to\n\
the west.\n"
    },
    {				/* 129: */
	C_WATER,		/* flags */
	tr129,
	"You're at edge of windshaft.\n",
	"You are at the edge of an immense shaft in the rock.  A murmuring stream\n\
enters from the east, flows over the edge, and is immediately whipped\n\
into mist by a mighty wind rising up the shaft.\n"
    },
    {				/* 130: */
	0,			/* flags */
	tr130,
	"You're halfway down the windshaft.\n",
	"You are halfway down the windshaft.  \"BANISH MISFORTUNE\" is scrawled\n\
almost illegibly on the wall.  The wind blows strongly from below.\n"
    },
    {				/* 131: */
	ESCAPE,			/* flags */
	tr131,
	"You're at bottom of windshaft.\n",
	"You are at the bottom of the windshaft, which is filled with needle-\n\
sharp rocks.  There is a passage to the west although the air is still\n\
at the passage entrance.  There is no hint as to the origin of the wind.\n"
    },
    {				/* 132: */
	0,			/* flags */
	tr132,
	"You're in smoky chamber.\n",
	"You are in an immense chamber, exiting to the east and west.  It is lit\n\
by flickering, smoky torches, each of which gives off a vile, greasy,\n\
black smoke.  Indistinctly visible through the smoke, the walls are seen\n\
to be lined with galleries.\n"
    },
    {				/* 133: */
	0,			/* flags */
	tr133,
	"You're at east edge of sulfurous sea.\n",
	"You are at the edge of a silent, sulfurous sea.  A passage lies to the\n\
east.\n"
    },
    {				/* 134: */
	ESCAPE | DROWN,		/* flags */
	tr134,
	"You're in middle of sulfurous sea.\n",
	"You are surrounded by the silent, sulfurous sea, which fills the passage\n\
from side to side.  Beaches are faintly visible to the east and west.\n"
    },
    {				/* 135: */
	0,			/* flags */
	tr135,
	"You're at west edge of sulfurous sea.\n",
	"You are at the edge of a silent, sulfurous sea.  A passage lies to the\n\
west.\n"
    },
    {				/* 136: */
	0,			/* flags */
	tr136,
	"You're at rune doorway.\n",
	"You are at the end of an immense passage.  In the north wall is a\n\
doorway, framed by great ebony logs, and cleverly carved all over in\n\
exquisite runes.  To the west, a tiny passage continues.\n"
    },
    {				/* 137: */
	0,			/* flags */
	tr137,
	"You're in Rune Room.\n",
	"This is the Rune Room.  It is also covered with exquisite runes,\n\
delicately chased into the golden walls!\n"
    },
    {				/* 138: */
	0,			/* flags */
	tr138,
	"You're at east side of fissure.\n",
	"You are in a colossal chamber at the east edge of a bottomless fissure.\n\
A small tunnel leads east.  A spidery stone bridge leads over the fissure\n\
into the darkness.\n"
    },
    {				/* 139: */
	0,			/* flags */
	tr139,
	"You're at break in bridge.\n",
	"The bridge is broken here!  Above you, the other side of the break looms\n\
out of the darkness . . .  Or is it something else?\n"
    },
    {				/* 140: */
	0,			/* flags */
	tr140,
	"You're at west side of fissure.\n",
	"You are at the west side of the broken bridge, which quickly leads down\n\
to the west side of the fissure, and thence to the west side of the\n\
colossal chamber.  There seems to be a faint, ominous gleam at the bottom\n\
of the fissure.  Below you, on the side of the fissure, you can see a\n\
small ledge.  You can get down to it, but you cannot see a way to get\n\
back up.\n"
    },
    {				/* 141: */
	ESCAPE,			/* flags */
	tr141,
	"You're on anchor ledge.\n",
	"You are stuck on a ledge on the west side of the fissure.  You cannot go\n\
up.  A strand of Grendl's web, leading downward, is attached here.\n"
    },
    {				/* 142: */
	ESCAPE,			/* flags */
	tr142,
	"You're on high, lonely ledge.\n",
	"You are on a high, lonely ledge on the side of the fissure.  Grendl's\n\
strand passes here and continues.\n"
    },
    {				/* 143: */
	ESCAPE,			/* flags */
	tr143,
	"You're on lonely, high ledge.\n",
	"You are on a lonely high ledge on the side of the fissure.  Grendl's\n\
strand passes here and continues.\n"
    },
    {				/* 144: */
	ESCAPE,			/* flags */
	tr144,
	"You're at end of strand.\n",
	"You are hanging at the end of Grendl's strand.  You cannot see any\n\
details of the murky gloom below you.\n"
    },
    {				/* 145: */
	LIGHT,			/* flags */
	tr145,
	"You're on top of idol.\n",
	"You are at the top of the idol!  You still cannot see over the walls\n\
surrounding you.\n"
    },
    {				/* 146: */
	LIGHT,			/* flags */
	tr146,
	"You're at east side of arena.\n",
	"You are at the east side of an immense, high-walled arena.  The center\n\
of the arena is occupied by a colossal jade idol, facing you.  In the\n\
east wall, behind you, is a door.\n"
    },
    {				/* 147: */
	LIGHT,			/* flags */
	tr147,
	"You're at south side of arena.\n",
	"You are at the south side of an immense, high-walled arena.  The center\n\
of the arena is occupied by a colossal jade idol.  In the south wall,\n\
behind you, is a door.\n"
    },
    {				/* 148: */
	LIGHT,			/* flags */
	tr148,
	"You're at west side of arena.\n",
	"You are at the west side of an immense, high-walled arena.  The center\n\
of the arena is occupied by a colossal jade idol, whose back is toward\n\
you.  In the west wall, behind you, is a door.\n"
    },
    {				/* 149: */
	LIGHT,			/* flags */
	tr149,
	"You're at north side of arena.\n",
	"You are at the north side of an immense, high-walled arena.  The center\n\
of the arena is occupied by a colossal jade idol.  In the north wall,\n\
behind you, is a door.\n"
    },
    {				/* 150: */
	LIGHT,			/* flags */
	tr150,
	"You're in repository.\n",
	"You are in the repository, where all of the implements and paraphernalia\n\
of the cave expedition are stored!  The only exit is to the west.\n"
    },
    {				/* 151: the last location, flagged by null travel pointer */
	0,
	NULL,			/* THE END-FLAG */
	NULL,
	NULL
    }
};

int maxloc = 150;
