' "Attempted Assassination"
' Created with QDK 3.53 - UNREGISTERED VERSION

!include <net.lib>

define game <Attempted Assassination>
	asl-version <350>
	gametype singleplayer
	start <Your House>
	game author <Matt Slotnick>
	game version <3.15>
	game copyright <2005 Matt Slotnick>
	game info <Created with QDK 3.53 - UNREGISTERED EVALUATION VERSION.>
	startscript {
		msg <|jc|b|s20Welcome to Attempted Assassination|xb|s00|n---------------------------------------------------------------------------->
		msg <|jlWelcome to my first attempt at a text-based adventure game. Before you begin to play this game, please make sure you read the entire text file named AA - Read Me. If you don't, this game could be a little more confusing than you might want it to be.|n|nIf at any time you feel that you are stuck and there is possibly no way out of your situation, don't worry, there is. At any time in the game you can type in |ihelp|xi to go to the help room. Here, you can find what you need to do to finish the game completely. Only do this if you do not want to complete the game by yourself.|n|nIf you have any other questions or comments about this game, then you can contact me through e-mail at mslot722@yahoo.com.|n>
		wait <|bPress a key|xb>
		clear
		msg <You awake one sunny morning. You look at the time and notice that it is already 8:05! You are late to work again! This is the third time this month, your boss is definitly going to fire you now. You quickly change into your work clothes and jump into your car. Upon getting into your car, you notice a note lying on the passenger side seat. "How did that get there?" You open it up and read the note:|n>
		wait <|bPress a key|xb>
		msg <|n|b"Your car will detonate at 8:08 this morning. Have a nice day!"|xb|n|nWoah! You quickly jump out of the car, and not a minute too soon. You hear a giant explosion and a rush of wind wooshes by you. You turn around to see only bits of metal that is left of your car. Thankfully, you only got minor bruises from the jump out of the car.|n>
		wait <|bPress a key|xb>
		msg <|nYou get up and walk back into your house. You tell yourself that you should call your boss and tell him what happened, but then again, he will probably never believe you. So much for that idea.|n>
		wait <|bPress a key|xb>
		clear
	}
	command <help> goto <Help room>
end define

define synonyms
end define

define room <Your House>
	look <A table and chairs sit in the dining room infront of the hallway to the door. A stairway leads to the second floor. Also, a kitchen lies to your west.>
	south <front yard>
	west <kitchen>
	up <bedroom>
end define

define room <bedroom>
	look <You see a bed and a chair with a table next to it. On the table is a light that is currently turned off. Also on the table is your trusty pocket knife.>

	define object <pocket knife>
		alt <trusty pocket knife>
		look msg <A hand-crafted pocket knife. This could come in handy>
		take
		speak msg <Speaking to a pocket knife? Come on.>
		examine msg <A hand-crafted pocket knife. This could come in handy>
		properties <size=3; weight=2>
	end define

	down <Your House>
end define

define room <kitchen>
	look <A normal counter top with cabinets over hanging them. A sink is in the middle of the table filled with dishes. You must make a mental note to wash those later today.>
	command <open cabinets> {
		reveal <gun>
		msg <You open the cabinets to find a gun lying under some paper plates.>
	}

	define object <cabinets>
		look <Regular cabinets.>
		speak <Can you speak to your cabinets? Exactly.>
		examine <Something may be inside of them.>
		article <them>
		gender <it>
		action <open> reveal <gun>
	end define

	define object <gun>
		look <A gun, good for shooting.>
		take <You pick up the gun for safe keeping.>
		speak <Guns don't talk buddy.>
		examine <A gun, good for shooting>
		article <it>
		gender <it>
		invisible
	end define

	east <Your House>
end define

define room <front yard>
	look <You stand in your front yard. Infront of the yard, you can see what little remains of your car.>
	north <Your House>
	west <corner store>
end define

define room <corner store>
	look <You step inside of a corner store. Five rows of food and other accessories lie infront of you. A counter is also on your left.|n|nThe man behind the counter says, "|clCan I help you?|cb">
	command <use key on car> {
		msg <The car starts up!>
		create exit north <corner store; Mysterious Building>
	}

	define object <Man>
		look <A mean looking man behind the counter.>
		speak {
			clear
			msg <You say, "|crDid you see anyone around my car this morning?|cb"|n|n>
			wait <|bPress a key|xb>
			msg <|nThe man says, "|clActually, I did. But I could not figure out who it was, he was dressed in dark clothes, and he probably came around at about 8:00 or so, and left a couple minutes later.|cb"|n>
			wait <|bPress a key|xb>
			msg <|nYou say, "|crCould you tell what he was doing with my car?|cb"|n>
			wait <|bPress a key|xb>
			msg <|nThe man says, "|clSorry, I'm too far away to tell. But here, take this key. It leads to a room on the second floor of this building. Up in the room, is a telescope. See if that will help you detect anything funny.|cb"|n>
			wait <|bPress a key|xb>
			msg <|nYou say, "|crThanks for your help, I'll see if the telescope can help.|cb" as the man puts the key on the table.>
			reveal <Key>
		}
		examine <He is scary looking.>
		article <it>
		gender <he>
	end define

	define object <Key>
		look <A Key to all sorts of things...>
		take
		speak <Keys can't speak.>
		examine <A Key to all sorts of things...>
		article <it>
		gender <it>
		invisible
		use on <Door> goto <telescope room>
		use on <Car> goto <Mysterious Building>
	end define

	define object <Car>
		look <A car sitting out front.>
		speak <This car is not voice activated.>
		examine <A car sitting out front.>
		article <it>
		gender <it>
	end define

	east <front yard>
	up <2nd floor>
end define

define room <work>
	look <You walk into work and the first person you see is your boss. Good, now to settle things for trying to kill you this morning.>
	command <use pocket knife on boss> {
		msg <You challange your boss to a duel, and you both walk outside to behind the work place.>
		pause <500>
		goto <Behind Work>
	}
	command <use gun on boss> {
		msg <You challange your boss to a duel, and you both walk outside to behind the work place.>
		pause <500>
		goto <Behind Work>
	}

	define object <Boss>
		look <Your boss, not in a good mood right now>
		speak {
			clear
			msg <You say, "|crYOU! You were the one who tried to kill me this morning. You were the one who has put me through this whole mess of trying to find out who tried to kill me. You are going to pay big time now.|cb"|n>
			wait <|bPress a key|xb>
			msg <|nYour boss says, "|clOh ya? So what if it was me who tried to kill you. I am sick and tired of you being late to work. So I knew you would be late again so I placed a bomb in your car. But unfortunatly, it didn't kill you. But what are you gonna do about it?|cb"|n>
		}
		examine <Your boss, not in a good mood right now>
		article <it>
		gender <he>
	end define

	south <side door>
end define

define room <2nd floor>
	look <All that is up here is a door that is locked. If only you had the key...>
	command <use key on door> {
		msg <The door is unlocked by the key.>
		create exit north <2nd floor; telescope room>
	}

	define object <Door>
		look <A firmly locked door.>
		speak <Doors can't speak.>
		examine <A firmly locked door.>
		article <it>
		gender <it>
		use <Key> goto <telescope room>
	end define

	down <corner store>
end define

define room <telescope room>
	look <A room with a table that has some papers cluttered around on it. A telescope sits on the left window looking out into the city.>
	out <2nd floor>
	command <use telescope> msg <You look through the telescope and adjust the lenses so it comes in much clearer. You scan the town to see if anything seems out of the ordinary. You then come across a building that you do not recognize. At the same time, a man with dark clothes gets out of a taxi.>

	define object <Telescope>
		look <A telescope to see things from a far.>
		speak <Telescopes can't talk.>
		examine <A telescope to see things from a far.>
		article <it>
		gender <it>
		use msg <You look into the telescope and adjust the view to see things cleary. As you look across the city, you notice a building that you have never seen before. You also notice a taxi pull up to it and a man with dark clothes on get out and go into the building.>
	end define

end define

define room <Mysterious Building>
	look <You pull up to the mysterious building that you spotted through the microscope. It is painted in a grey color, and it is wierd that you have never noticed it before. The taxi that you spotted here earlier is long gone, and the man in the dark clothing is no where in site.>
	north <1 Floor>
	south <corner store>
end define

define room <1 Floor>
	look <You arrive inside the building into a wide room that is completely empty besides the desk sitting infront of you. Behind the desk is a woman sitting down staring into a computer screen.>
	command <use pocket knife on woman> {
		create exit up <1 Floor; 2 Floor>
		msg <You jump over the desk and quickly cut the throat of the woman sitting behind the desk. You quickly scan the computer monitor to discover that it is a security camera. It is currently scanning the second floor, and a man in dark clothes rushes by the camera!>
	}
	south <Mysterious Building>
end define

define room <2 Floor>
	look <You come out of the elevator shaft and find yourself in a hallway. On each side of the hallway are two doors. The dark clothed man is no where in side.>
	east <room02>
	west <room01>
	southwest <room03>
	southeast <room04>
end define

define room <room01>
	look <A small room, nothing interesting going on in here. Looks like you picked the wrong room.>
	east <2 Floor>
end define

define room <room02>
	look <A small room, nothing interesting going on in here. Looks like you picked the wrong room.>
	west <2 Floor>
end define

define room <room03>
	look <As you enter in the room, you see a another door as it closes instantly. The dark clothed man must have gone into that door. You quickly run over there, but the door is locked. He must have locked it when he closed it behind him. There must be some way to open it.>
	command <use gun on door> {
		msg <The door is now open because you shot the door handle off.>
		create exit north <room03; Mysterious Room>
	}

	define object <Door2>
		alias <Door>
		alt <Door>
		look <The door is locked, you must find the key.>
		speak <This door needs a real key, it is not voice-activated.>
		examine <The door is locked, you must find the key.>
		article <it>
		gender <it>
	end define

	northeast <2 Floor>
end define

define room <room04>
	look <A small room, nothing interesting going on in here. Looks like you picked the wrong room.>
	northwest <2 Floor>
end define

define room <Mysterious Room>
	look <You shoot out the door handle and quickly open up the door, only to see the dark clothed man jump out of the window! You can't believe your eyes. You run over to the window and look down. The man is no where in sight. There is a trash can below the window, just big enough for someone to jump into.>
	out <room03>
	north <Side Exit>
end define

define room <Side Exit>
	look <You jump out the window and land in the trash can. Luckily it was under you or you would have been done foor. You get up to see the dark clothed man crouched down on the ground.>

	define object <Dark Clothed Man>
		look <The dark clothed man, who is possibly behind your car being bombed.>
		speak {
			clear
			msg <As you approach the man, he looks up at you and seems frightened to see you. He shouts out, "|clDon't come any closer! I'm warning you|cb"|n>
			wait <|bPress a key|xb>
			msg <|nYou reply back, "|crI know what you have done. Don't think you can get away with what you have done to me this morning. Of course you would have had to know that I would discover that it was you who put the car bomb in my car.|cb"|n>
			wait <|bPress a key|xb>
			msg <|nThe man looks back up at you and says, "|clWhat are you talking about? I have never seen you in my life.|cb"|n>
			wait <|bPress a key|xb>
			msg <|nYou say, "|crWhat? Didn't you try to kill me this morning when you put a bomb in my car?|cb"|n>
			wait <|bPress a key|xb>
			msg <|nThe man says, "|clI don't know of any bombing on your car. I jumped out of that window because I dropped my watch.|cb">
			wait <|bPress a key|xb>
			clear
			msg <You reply back, "|crOh, sorry to have bothered you then. But out of curiosity, did you see anyone around the apartment building this morning that was messing around with my car?|cb"|n>
			wait <|bPress a key|xb>
			msg <|nThe man says, "|clYes I did, he had a kind of grey colored mustache, and he was wearing a hat that was tilted to the side a little bit, and a pair of blue jeans. Thats all I could see.|cb"|n>
			wait <|bPress a key|xb>
			msg <|nYou say, "|crThat's my boss! How could he do such a thing! Thanks for the information man.|cb">
			create exit west <Side Exit; Back Alley>
			reveal <Bobby Pin>
		}
		examine <The dark clothed man, who is possibly behind your car being bombed.>
		article <it>
		gender <he>
	end define

	define object <Bobby Pin>
		look <A bobby pin, good for picking locks.>
		take
		speak <Bobby pins can't talk.>
		examine <A bobby pin, good for picking locks.>
		article <it>
		gender <it>
		invisible
	end define

	east <Mysterious Building>
	west <Back Alley>
end define

define room <Back Alley>
	look <You run out into a back alley. Good thing you know this town like the back of your hand. You know very well that this back alley leads to the back entrance of your workplace.>
	east <Side Exit>
	west <side door>
end define

define room <side door>
	look <You come upon the side door of your work place. But the door is locked, if only you had something to use against the door.>
	command <use bobby pin on door> {
		msg <The door is now unlocked!>
		create exit north <side door; work>
	}

	define object <Door3>
		alias <Door>
		look <Another door, and yet again, locked.>
		speak <Once again, this door is not voice-activated.>
		examine <Another door, and yet again, locked.>
		article <it>
		gender <it>
	end define

	east <Back Alley>
end define

define room <Help room>
	prefix <the>
	look <Welcome to the help room. Here are some books to help you finish the game completely. If you try to leave this room with the books, they will be removed. When you leave, you will return to Your House. WARNING: If you do not want to cheat and win the game by yourself, leave now.>
	out <Your House> {
		lose <Book 1>
		lose <Book 2>
		move <Book 1; Help room>
		move <Book 2; Help room>
		goto <Your House>
	}
	command <read book 1> {
		clear
		msg <This is the first book. You must follow these directions before the other books.|n>
		wait <|bPress a key|xb>
		msg <|nFirst go upstairs and |itake pocket knife|xi. Then go downstairs and west into the kitchen to |iopen cabinets|xi. Now |itake gun|xi that is revealed.|n>
		wait <|bPress a key|xb>
		msg <|nGo south then west to end up in a corner shop. |iSpeak to man|xi to run through a conversation. He will drop a key, |ipick up key|xi. Then go upstairs and |iuse key on door|xi to go into the telescope room.|n>
		wait <|bPress a key|xb>
		msg <|nThen |iuse telescope|xi to get the description of a building. Get out of the room and go back downstairs. |iUse key on car|xi and go north.>
	}
	command <read book 2> {
		clear
		msg <Go north into the building. |iUse pocket knife on woman|xi to kill the woman. You will then be able to go up. You will find 4 doors, take the one southwest. |iUse gun on door|xi to open that door. Go north into the room.|n>
		wait <|bPress a key|xb>
		msg <|nGo north out the window. |iTalk to dark clothed man|xi to reveal the conversation. He will drop an object, |ipick up bobby pin|xi. Then go west, and west again.|n>
		wait <|bPress a key|xb>
		msg <|nThen |iuse bobby pin on door|xi to pick the lock and go north to meet your boss. |iTalk to boss|xi to get the reason behind the "accident". Now |iuse gun on boss|xi or |iuse pocket knife on boss|xi to start the dual.|n>
		wait <|bPress a key|xb>
		msg <|n|iTalk to boss|xi again to reveal the dual menu. Select either the first or the second choices to win the game. If you select the third choice, you will automatically lose.>
	}

	define object <Book 1>
		look <The first book.>
		take
		speak <This book does not speak.>
		examine <The first book.>
		article <it>
		gender <it>
	end define

	define object <Book 2>
		look <The second book.>
		take
		speak <This book does not speak.>
		examine <The second book.>
		article <it>
		gender <it>
	end define

end define

define room <Behind Work>
	look <You walk outside behind your boss. Since you have challanged him to a dual, you need to decide how you are going to do this.>
	indescription <You are behind the workplace.>

	define object <Boss2>
		alias <Boss>
		look <Not in a good mood.>
		speak {
			clear
			msg <Your boss says to you, "|clOk, its 5 paces away from each other, turn and fire. Pretty easy, at least for me it is.|cb">
			pause <500>
			choose <Duel>
		}
		examine <Not in a good mood.>
	end define

end define

define text <win>
You quickly kill your boss so you don't have to hear his nasty voice anymore. After what has gone on today, you are glad it is finally over. Now you can get back to your normal, everyday life.

|bGAME OVER - YOU WIN|xb
end define

define text <lose>
Are you serious? You stand in the middle looking dumbfounded, and your boss turns around and kills you instantly. Try again when you have better luck...or at least some common sense.

|bGAME OVER - YOU LOSE|xb
end define

define text <intro>

end define

define text <lose>
Are you serious? You stand in the middle looking dumbfounded, and your boss turns around and kills you instantly. Try again when you have better luck...or at least some common sense.

|bGAME OVER - YOU LOSE|xb
end define

define selection <Duel>
	info <What move shall you do?>
	choice <Jump to left for the kill.> playerwin
	choice <Jump to right for the kill.> playerwin
	choice <Stay in middle for the kill.> playerlose
end define

