/* toaster.t

This is the main code for my game, "Masters of Toasting".
It should compile under TADS 2.4.0 with the standard libraries,
adv.t and std.t.

This code is copyright (C) 2000 by Leon Lin, but feel free to
use any code you find here that you might find useful in your
own projects.

The following code is not likely to represent the best way of
doing what the game does, and it probably has some bugs still
in it. Future versions will hopefully resolve any outstanding
problems.

Please direct all comments, questions, and bug reports to:
leonlin@ix.netcom.com

Change History
--------------
8/31/2000 (LWL) -- First release
9/2/2000  (LWL) -- Added more comments for public source release. Also
                   fixed countdown bug.

*/

#include <adv.t>
#include <std.t>
#include <background.t>

// Initialization function. This is based on the init function
// in std.t
replace init: function
{
#ifdef USE_HTML_STATUS
    /* 
     *   We're using the adv.t HTML-style status line - make sure the
     *   run-time version is recent enough to support this code.  (The
     *   status line code uses systemInfo to detect whether the run-time
     *   is HTML-enabled or not, which doesn't work properly before
     *   version 2.2.4.)  
     */
    if (systemInfo(__SYSINFO_SYSINFO) != true
        || systemInfo(__SYSINFO_VERSION) < '2.2.4')
    {
        "\b\b\(WARNING! This game requires the TADS run-time version
        2.2.4 or higher.  You appear to be using an older version of the
        TADS run-time.  You can still attempt to run this game, but the
        game's screen display may not work properly.  If you experience
        any problems, you should try upgrading to the latest version of
        the TADS run-time.\)\b\b";
    }
#endif

    /* perform common initializations */
    commonInit();

   	randomize();

	"There's no rest for a member of the Toaster Repair Corps at Advanced
	Appliances, Inc. Why, just now you've been summoned on a Level Three
	Repair alert to the TV studios where the hit show \"Monday Night Cookoff\"
	is being broadcast, live. It appears that Biff Backowicz,
	Master Chef of the Chicago White Toques, is having difficulty with his
	toaster which he needs to complete his team's main entree.\n\b";
	
	"Fortunately, the malfunction occurred early enough in the competition
	that you should have plenty of time to effect repairs. Nevertheless,
	the set \"Monday Night Cookoff\" is probably the highest pressure
	situation you've ever stepped into! If you can pull this off, you'll
	truly be one of the \n\b";
	
    version.sdesc;                // display the game's name and version number

	"(First time players should type INFO for information about 
	this release.)\n\b";

    setdaemon( turncount, nil );               // start the turn counter daemon
  	parserGetMe().location := startroom;     // move player to initial location
    startroom.lookAround(true);                      // show player where he is
    startroom.isseen := true;                  // note that we've seen the room
    scoreStatus(0, 0);                          // initialize the score display

	// Set the maximum score for the game to three points.
	global.maxscore := 3;
	
	// Generate the three plain bread objects.
	(new untoastedbread).moveInto(toolbelt);
	(new untoastedbread).moveInto(toolbelt);
	(new untoastedbread).moveInto(toolbelt);

	// Start the background noise.
	notify(kitchen, &runEvents, 0);
	
	// Start the timer.
	notify(kitchen, &fiveMinutes, 50);

	// Pick a main ingredient, for the benefit of the commentators.
	pantry.main_ingredient :=
	   pantry.theme_ingredients[rand(length(pantry.theme_ingredients))];
}

// The object which contains the game's version information.
replace version: object
    sdesc = "\(Masters of Toasting\)\n
             A ToasterComp Mini-Romp\n
             Version 1 (Aug. 31, 2000)\n
             Developed with TADS, the Text Adventure Development System.\n
             Copyright (C) 2000 by Leon Lin\n\b"
;

// This function, adapted from std.t's scoreRank function,
// reports the player's score.
replace scoreRank: function
{
    "In a total of "; say(global.turnsofar);
    " turns, you have achieved a score of ";
    say(global.score); " points out of a possible ";
    say(global.maxscore); ". ";
    
    "Based on your performance ";
    switch (global.score)
    {
    	case 0:
    	"the leader of the Toaster Repair Corps will probably make
    	you do push-ups until you puke.";
    	break;
    	
    	case 1:
    	"you will be laughed at by the other toast repairpersons, 
    	but at least this will happen behind your back.";
    	break;

    	case 2:
    	"you seem to be getting the hang of this toaster repair gig.";
    	break;

    	case 3:
    	"you will be hailed as a Master Toaster.";
    	break;
    	
    	default:
    	"you have achieved the rank of Toasted.";
    	break;
    }
}

// The usual retort to swear words.
expletiveVerb: deepverb
	sdesc = "(expletive)"
	verb = 'damn' 'fuck' 'shit' 'crap' 'hell' 'krip' 'trot'
	doAction = 'Expletive'
	action(actor) =
	{
		"Real toaster repairpersons don't use such language.";
	}
;

// And of course, a response to magic words of power.
xyzzyVerb: deepverb
	sdesc = "magic verb"
	verb = 'xyzzy' 'plugh' 'plover' 'bunyan'
	action(actor) =
	{
		"Ancient words of power may cut it in some other profession,
		but not in the exciting world of toaster repair!";
	}
;

// This verb provides the player with information about the game.
infoVerb: sysverb
	sdesc = "info"
	verb = 'info'
	action(actor) =
	{
		version.sdesc;
		
		"This little game was written for Mark Musante's 
		\"ToasterComp\" in August 2000. It's been a long time 
		since I wrote any interactive fiction, and I figured 
		it would be fun	to write a short, quick game.\n\b";

		"Since I wrote this mini-game in less than two weeks, there
		are probably some bugs in it I didn't catch. If you find any
		bugs, or want to send me any other comments or questions, feel
		free to write me at \(leonlin@ix.netcom.com\).\n\b";

		"Enjoy!";
	}
;

// I prefer to type "set dial to <setting>" when using dials
// instead of the already implemented "turn dial to <setting>,
// so I added this verb.
setVerb: deepverb
    verb = 'set'
    sdesc = "set"
    ioAction(toPrep) = 'TurnTo'
    doAction = 'Set'
;

// This verb is just in case players try to get clever
// and type "fix toaster".
fixVerb: deepverb
	sdesc = "fix"
	verb = 'fix'
	doAction = 'Fix'
;

// Debugging verbs. Originally, I implemented toasting
// bread by changing the attributes of the bread object,
// including vocabulary words. To check whether the
// vocabulary words were being added, I implemented
// a "vocab" debugging verb which would print out
// the direct object's nouns and adjectives.
//
// I changed the way bread was toasted and didn't
// need the verb after all, but if you find this
// debugging verb useful, feel free to borrow it.
#ifdef _DEBUG
vocabVerb: sysverb
	sdesc = "vocab"
	verb = 'vocab'
	doAction = 'Vocab'
;

// I also wanted to be able to add the word "toast"
// to any object. Any resemblance to other magic
// verbs is, er, strictly coincidental.
addToastVerb: sysverb
	sdesc = "frotz"
	verb = 'frotz'
	doAction = 'Frotz'
;
#endif // _DEBUG

modify class thing
#ifdef _DEBUG
	// When an object is "frotz"ed, the vocabulary word
	// "toast" is added to the object.
	verDoFrotz(actor) = {}
	doFrotz(actor) =
	{
		"(The word 'toast' has been added to this item's vocabulary.)\n";
		addword(self, &noun, 'toast');
	}
	
	// Grab the lists of nouns and adjectives for an
	// object, then print them out in a table.
	verDoVocab(actor) = {}
	doVocab(actor) =
	{
		local i;
		local nounList := getwords(self, &noun);
		local adjList := getwords(self, &adjective);
		
		"Noun List:\n";
		"----------\n";
		for (i := 1; i <= length(nounList); i++)
		{
			say(nounList[i]);
			"\n";
		}

		"\n";
		
		"Adjective List:\n";
		"---------------\n";
		for (i := 1; i <= length(adjList); i++)
		{
			say(adjList[i]);
			"\n";
		}
	}
#endif // _DEBUG
	verDoFix(actor) =
	{
		"You can't fix that, especially as it's not a toaster.";
	}
;

// Just for fun, we'll mess with the error strings.
// I had fun with this is "Kissing the Buddha's Feet",
// where characters would respond to the user's typos.
parseError: function(num, str)
{
	if (num < 100)
	{
		switch(num)
		{
			case 1:
			break;
			
			case 2:
			return('I don\'t know the word \'%s\', but I wish I did.');
			break;
								
			case 24:
			break;
				
			case 27:
			break;
				
			case 31:
			break;
				
				
			default:
			return('(' + str + ')');
			break;
		}
	}
	else
	return nil;
}

// The function that runs when the game ends, one way or another.
// This is based on the "die" function in std.t. The main difference
// is that the "You have died" message isn't printed, though
// death is a possible outcome in this game.
endgame: function
{
	scoreRank();

    "\bYou may restore a saved game, start over, quit, or undo
    the current command.\n\b";
    while ( 1 )
    {
        local resp;

	"\nPlease enter (R)ESTORE, RE(S)TART, (Q)UIT, or (U)NDO: >";
        resp := upper(input());
        if ( resp = 'RESTORE' or resp = 'R')
	{
	    resp := askfile( 'File to restore' );
	    if ( resp = nil ) "Restore failed. ";
	    else if ( restore( resp )) "Restore failed. ";
	    else
	    {
	        Me.location.lookAround(true);
	        scoreStatus(0,0);
		abort;
	    }
	}
        else if ( resp = 'RESTART' or resp = 'S')
	{
	    scoreStatus(0,0);
            restart();
	}
	else if ( resp = 'QUIT' or resp = 'Q')
        {
	    terminate();
            quit();
	    abort;
        }
	else if (resp = 'UNDO' or resp = 'U')
	{
	    if (undo())
	    {
		"(Undoing one command)\b";
		Me.location.lookAround(true);
	        scoreStatus(0,0);
		abort;
	    }
	    else
		"Sorry, no undo information is available. ";
	}
    }
}

// I normally let the player see a list of amusing things to
// do at the end of the game, but I didn't think the list
// was long enough for "Masters of Toasting" to warrant it.
// I didn't take out the function, though. The list below,
// though, is incomplete.
secrets: function
{
	"\bHave you tried:\n\b";
	"...swearing?\n";
	"...XYZZY?\n";
	"..taking off your uniform and doing the repairs?\n";
}

// The best ending of the game.
goodending: function
{	
	clearscreen();
	
	"\n\b\n\b\(NEW YORK (ASSOCIATION PRESS)\) Biff Backowicz and his
	Chicago	White Toques cooking team beat the New York 
	Burgermeisters 42 - 36 in a close cookoff last night. 
	The White Toques came close to a loss because of a toaster 
	malfunction, but a daring repairperson from Advanced Appliances 
	came in to save the day. ";
	
	if (not worksuit.isworn)
	{
		"Despite the fact that this repairperson was totally naked, the
		repairs were effected with speed and efficiency. ";
	}
	
	"\"We kicked booty, but we couldn't have done it without the help 
	of that brave toaster repairperson. Thanks, Mr. or Ms. ";
	
	if (not worksuit.isworn)
	{
		"Naked ";
	}
	
	"Toaster Repairperson!\"\n\b";
	
	endgame();
}

// The first bad ending, when you run out of time.
badending: function
{	
	clearscreen();
	
	"\n\b\n\b\(NEW YORK (ASSOCIATION PRESS)\) Biff Backowicz and his 
	Chicago	White Toques cooking team lost to the New York 
	Burgermeisters 34 - 36 last night in a close cookoff. 
	Unfortunately the toaster repairperson dispatched to fix the 
	White Toques' faulty toaster failed to complete the repairs 
	in time. \"We tried our hardest, but we wuz robbed,\" said 
	Biff Backowicz. \"From now on, we're doing our
	toasting with an acetylene torch! It's more reliable, and imparts
	a unique flavor to the bread!\"\n\b";
	
	endgame();
}

// The second bad ending, when you burn down the studio.
badending2: function
{	
	clearscreen();
	
	"\n\b\n\b\(NEW YORK (ASSOCIATION PRESS)\) The set of the hit
	TV show \"Monday Night Cookoff\" burned down before a live
	audience of millions last night. While this lead to the program's
	highest ratings yet, \"Cookoff\" cannot afford to torch
	a multi-million dollar TV studio every week in its quest
	for ratings gold, said a program spokesperson. 
	Next week's show is scheduled to be
	broadcast live from the Home Ec classroom at P.S. 239.\n\b";
	
	"\tFortunately, no one was killed or injured by the fire, except
	for a valiant toaster repairperson who attempted to put out the
	fire. \"That toaster repairperson gave his or her life for us,\"
	said a visibly moved Biff Backowicz, leader of the Chicago White
	Toques.\n\b";

	incscore(-101);
	endgame();
}

// The third bad ending, when you stick metal tools in a working
// toaster.
badending3: function
{	
	clearscreen();
	
	"\n\b\n\b\(NEW YORK (ASSOCIATION PRESS)\) Biff Backowicz and his
	Chicago	White Toques cooking team lost to the New York 
	Burgermeisters 34 - 36 in a close cookoff last night,. This loss was
	attributed to the electrocution of a toaster repairperson who
	attempted to fix the White Toques' broken toaster. \"No one's life
	is worth a cookoff win,\" said White Toques' leader Biff Backowicz.
	\"So I hope the New York Burgermeisters will do the classy thing
	and forfeit their game.\"\n\b";

	incscore(-101);
	endgame();
}

// Backstage
startroom: room
	sdesc = "\(Backstage\)"
	ldesc =
	{
	   "Grimy, dusty, dark and chaotic, the backstage of this TV
	   studio exposes the seemy underbelly of TV production. You 
	   can leave the studio by going west (you were born with
	   a good sense of direction) or enter the Kitchen Arena by going
	   east.";
	}
	east = kitchen
	west =
	{
		// It used to be that I required the player, after fixing
		// the toaster, to leave the studio to win the game. However,
		// I later thought it would be cleaner to just end the game
		// when it was confirmed the toaster was working. The following
		// code implemented the old condition, but leaving it in doesn't
		// affect the game flow.
		if (toaster.testedToast)
		{
			"You stride proudly out of the TV studio, secure in
			the knowledge that you have proved your toaster
			repairperson skills. The outcome of the struggle going
			on within the Kitchen Arena is no longer of your concern;
			you are satisfied that the result will not be affected by
			any mistake of yours.\n\b";
			
			"[Press any key to continue]";
			inputkey();

			goodending();
		}
		else
		{
			"You can't leave yet! You haven't fixed the toaster!
			Leaving would be a breach of the toast repairperson
			code!";
		}
	}
;

// The Kitchen Arena
kitchen: room
	finalTimer = 10 // The number of turns in the countdown.
	sdesc = "\(Kitchen Arena\)"
	ldesc = 
	{
		"This is the Kitchen Arena, and if you weren't told it was a TV studio
		you'd have never guessed. Bathed in brilliant light,
		the Arena's serene granite walls appear to extend up to 
		infinity. Kitchen equipment and ingredients of every kind are 
		arranged on a curved marble counter upon which the opposing 
		cooking teams work, though most of it is irrelevant to you.";
	}
	west = startroom

	// Five minute warning. This, and every other routine dealing
	// with the countdown to the end of the game, uses notify
	// to trigger the next stage of the countdown.
	// Now that I think of it, I don't think the unnotify
	// calls were necessary...
	fiveMinutes =
	{
		"\b\"Five minutes to go,\" a voice booms from a loudspeaker
		in the kitchen.";
		notify(self, &threeMinutes, 10);
		unnotify(self, &fiveMinutes);
	}
	
	threeMinutes =
	{
		"\b\"Three minutes to go,\" a voice booms from the loudspeaker.";
		notify(self, &twoMinutes, 10);
		unnotify(self, &threeMinutes);
	}
	
	twoMinutes =
	{
		"\bA horn blows: the signal for the two minute warning.";
		notify(self, &lastMinute, 10);
		unnotify(self, &twoMinutes);
	}
	
	lastMinute =
	{
		"\b\"One minute to go,\" a voice booms from the loudspeaker.";
		notify(self, &thirtySeconds, 5);
		unnotify(self, &lastMinute);
	}

	thirtySeconds =
	{
		"\b\"Thirty seconds to go,\" a voice booms from the loudspeaker.";
		notify(self, &startcountdown, 6);
		unnotify(self, &thirtySeconds);
	}
	
	startcountdown =
	{
		notify(self, &countdown, 0);
	}
	
	countdown =
	{
		if (self.finalTimer = 0)
		{
			"\b\"Time's up!\" You slump your shoulders in defeat, as does
			Biff Backowicz. You failed to fix the toaster in time, and
			you will bear the stigma of that shame until the end of your
			days...\n\b";

			"[Press any key to continue]";
			inputkey();

			badending();
		}
		else
		{
			"\b\"<<self.finalTimer>>...\"";
			self.finalTimer--;
		}
	}

	// This daemon prints background messages at
	// random.	
	runEvents =
	{
		local whichActor := rand(2);

		if (parserGetMe().location = self)
		{
			switch (whichActor)
			{				
				case 1:
				{
					assistants.event;
					break;
				}

				case 2:
				default:
				{
					commentators.event;
					break;
				}
			}
		}
	}
;

// Personal effects

// Your outfit. Before implementing the "nude" ending
// I prevented the player from taking off the outfit.
worksuit: clothingItem
	sdesc = "work outfit"
	ldesc = "This is the standard Advanced Appliances repairperson working
			outfit. It's a flat periwinkle color and stained with oil."
	noun = 'outfit' 'suit' 'uniform'
	adjective = 'work'
	location = Me
	isworn = true
	verDoUnwear(actor) = 
	{ 
//		"Modesty (and company policy) forbids."; 
	}
	
	doUnwear(actor) =
	{
		"On some crazy impulse, you decide to doff your
		uniform, thinking you would be more comfortable
		repairing a toaster in the buff.\n\b";
		pass doUnwear;
	}
/*	
	verDoDrop(actor) = 
	{ 
		"Modesty (and company policy) forbids."; 
	}
*/
;

// The toolbelt, a simple wearable container.
toolbelt: clothingItem, openable
	sdesc = "tool belt"
	noun = 'belt'
	adjective = 'tool' 'leather' 'rugged'
	location = Me
	isworn = true
;

// The manual explaining how to use the toaster.
manual: readable
	sdesc = "toaster manual"
	ldesc = "This is the manual for the TX-255 'Toastmaster' Toaster."
	readdesc =
	{
		"MANUAL FOR TX-255 'TOASTMASTER' TOASTER\n\b";
		
		"Congratulations! You are the proud owner of the award-winning
		TX-255 \(Toastmaster (TM)\) Toaster. The Toastmaster (TM) can
		toast all kinds of food, from bread to bagels to frozen waffles.
		With a patented \(EASY-SET\) dial, you can toast your food to
		any degree from barely toasted to totally charred!\n\b";
		
		"EASY TO USE OPERATION!\n\b";
		
		"To toast something in your TX-255 Toastmaster (TM), follow
		the following steps:\n\b";
		
		"1) \(Put\) the food you want to toast in the \(left\) or 
		\(right slot\) of the toaster. \(WARNING:\) Do \(not\) put 
		more than one object in	the slots. Do \(not\) put non-food 
		items in the slots.\n\b";
		
		"2) \(Set\) the \(dial\) on the toaster to the desired level
		of toasting. The dial's range is from 1 to 10, higher numbers
		signifying higher levels of toasting. Do \(not\) try to set
		the dial to a number higher than 10. It just isn't possible.\n\b";
		
		"3) \(Push\) the \(lever\) on the front of the toaster. \(Wait.\) At
		the completion of the toasting process, the food will pop up. Remove.
		Eat. Enjoy!\n\b";
	}
	noun = 'manual'
	adjective = 'service'
	location = toolbelt
;

// The tools, which are needed to open and fix the toaster.
worktools: item
	sdesc = "repair tools"
	adesc = "some repair tools"
	ldesc = "These rugged metal tools can be used to effect repairs to any Advanced
			Appliances toaster. They are a mark of pride and losing a tool is
			considered a disgrace to any Advanced Appliances repairperson."
	noun = 'tools' 'tool'
	adjective = 'repair' 'rugged' 'metal'
	location = toolbelt
;

// The base bread class, from which all other bread, toasted
// or otherwise, is derived.
class bread: fooditem
	sdesc = "<<self.describe>> slice of bread"
	ldesc = "This is a <<self.describe>> slice of bread"
	pluraldesc = "<<self.describe>> slices of bread"
	noun = 'bread' 'slice'
	adjective = 'bread'
	isEquivalent = true
	verDoEat(actor) = {}
	doEat(actor) =
	{
		"The bread is suitably bland but edible.";
		self.moveInto(nil);
	}
	verDoTake(actor) =
	{
		if (self.location = leftslot or self.location = rightslot)
		{
			if (toaster.istoasting)
			{
				"Ouch! You burn your fingers trying to extract the
				bread from the toaster, and dance about a bit, waving
				your injured digit in the air. \"Must be a fan,\"
				remarks a commentator.";
			}
		}
	}
;

// Most of the bread in this game was actually toast,
// so to save from defining the noun 'toast' in
// all these objects, another class for toast
// was derived from the base bread class.
class toast: bread
	noun = 'toast'
;

// Untoasted bread, which is what you start with.
untoastedbread: bread
	ldesc = "This is an untoasted slice of bread."
	adesc = "an untoasted slice of bread"
	adjective = 'untoasted'
	describe = "untoasted"
;

// Different objects for the various stages
// of toastiness.
// Originally, I just had one type of bread,
// and as it toasted I changed its description
// and properties. This proved to be unwieldy,
// (particularly in combining like objects)
// so I opted to use many different objects.
// As the bread toasts, new, more toasted bread
// is created (and the old bread destroyed).
barelybread: toast
	adjective = 'barely' 'toasted'
	describe = "barely toasted"
;

slightlybread: toast
	adjective = 'slightly' 'toasted'
	describe = "slightly toasted"
;

lightgoldbread: toast
	adjective = 'light' 'golden'
	describe = "light golden"
;

goldbread: toast
	adjective = 'golden'
	describe = "golden"
;

darkgoldbread: toast
	adjective = 'dark' 'golden'
	describe = "dark golden"
;

lightbrownbread: toast
	adjective = 'light' 'brown'
	describe = "light brown"
;

brownbread: toast
	adjective = 'light' 'brown'
	describe = "brown"
;

darkbrownbread: toast
	adjective = 'dark' 'brown'
	describe = "dark brown"
;

halfburntbread: toast
	adjective = 'half-burnt'
	describe = "half-burnt"
;

burntbread: toast
	adjective = 'burnt'
	describe = "burnt"
;

charcoalbread: toast
	adjective = 'totally' 'charred'
	describe = "totally charred"
;

// The counter. A simple surface.
marblecounter: surface, fixeditem
	sdesc = "curved marble counter"
	noun = 'counter'
	adjective = 'surface' 'curved'
	location = kitchen
;

// For completeness, the walls.
granitewalls: fixeditem
	sdesc = "granite walls"
	ldesc = "They appear to be granite, though for all you know they're
			cardboard with a granite texture painted on. They look
			impressive though."
	noun = 'walls'
	adjective = 'granite'
	location = kitchen
;

// Kitchen equipment, also included for completeness.
equipment: fixeditem
	sdesc = "kitchen equipment"
	ldesc = "This set of kitchen equipment is actually the set of all
			possible kitchen equipment minus toasters."
	noun = 'kitchen'
	adjective = 'equipment'
	location = kitchen
;

// The following items comprise the toaster and its various
// parts.

// The toaster is an interesting item.
toaster: item
	isopen = nil         // is the toaster opened?
	istoasting = nil     // is the toaster currently toasting something?
	newinside = nil      // is the new heating element inside?
	oldinside = true     // is the old, broken heating element inside?
	toastcounter = 0     // how long has the toaster been toasting?

	openedOnce = nil     // flag for scoring the player opening the toaster
	heaterReplaced = nil // flag for scoring the player replacing the heating 
	                     // element
	testedToast = nil    // flag for scoring the player testing the toaster
	
	sdesc = "toaster"
	ldesc = 
	{
		"This seemingly innocuous device, the TX-255 \"Toastmaster\"
		toaster, highlights the fact that toaster
		design hasn't changed much over the years. Visually, it
		resembles the TX-336 \"Big Jam\" Institutional Use Toaster, 
		except instead of having twelve slots, it only has two, the 
		usual left and right ones. ";
		
		self.showSlotContents; // show what's in the slots
		
		" There is also the usual lever which 
		can be pushed down to start the toasting process, and a
		dial which you can turn to from 1 to 10 to set the darkness of the
		toast, with higher numbers corresponding to darker toast. It is
		currently set to <<toasterdial.setting>>.";
		
		// Show the internals if the cover is off
		if (isopen)
		{
			self.showInternalContents;
		}
		else
		{
			"\n\bA fact which Advanced Appliances doesn't advertise to its
			customers is that the cover of the toaster can be removed to
			provide access to its internals. As a certified Advanced Appliances
			toaster repairperson, you are trained to easily open the toaster.";
		}
	}
	noun = 'toaster'
	adjective = 'tx-255' 'toastmaster'
	location = marblecounter
	
	// When toasting, increment the toastcounter. If the counter reaches the
	// same or greater number as the dial setting, pop the toast up. (If the
	// player sets the dial to a lower setting while in the middle of toasting,
	// this allows the toast to pop up quicker.)
	// When the counter has not reached the desired number, tell the slots
	// to cook what's inside.

	toastBread =
	{
		if (toastcounter >= toasterdial.setting)
		{
			self.popup;
		}
		else
		{
			// Cook the contents of each slot
			leftslot.cook;
			rightslot.cook;

			// Increment the toast counter
			toastcounter++;
		}
	}

	// Pop the toast up, report the results, and reset the toaster.
	// Originally I wanted to let the player mess around with the
	// toaster a bit, allowing multiple uses, but in the interests
	// of saving time I changed that.

	popup =
	{
		"\n\bThe toast pops up! ";
		if (not leftslot.isempty)
		{
			"The bread in the left slot 
			appears <<leftslot.contents[1].describe>>. ";
		}
		
		if (not rightslot.isempty)
		{
			"The bread in the right slot 
			appears <<rightslot.contents[1].describe>>.";
		}
				
		istoasting := nil; // no longer toasting
		toastcounter := 0; // reset for another attempt
		unnotify(self, &toastBread); // stop toasting daemon
		
		// If you just successfully used the toaster once, you win.
		// This code can be taken out if you want to let the player
		// use the toaster multiple times.

		if (testedToast = nil)
		{
			"\n\bCongratulations! It looks like the toaster is
			in working order. It's probably best that you
			leave now, so as not to get in the way of Biff
			Backowicz and his team of chefs...";

			testedToast := true;
			incscore(1);
			"\b(Your score has just gone up by 1 point.)";
			
			"\n\bYou stride proudly out of the TV studio, secure in
			the knowledge that you have proved your toaster
			repairperson skills. The outcome of the struggle going
			on within the Kitchen Arena is no longer of your concern;
			you are satisfied that the result will not be affected by
			any mistake of yours.\n\b";
			
			"[Press any key to continue]";
			inputkey();

			goodending();
		}
	}
	
	// The player can put bread in slots. The player can also
	// put heating elements in the toaster. We need to distinguish
	// the two cases.
	verIoPutIn (actor) = {}
	ioPutIn (actor, dobj) =
	{
		// If putting a heating element in the toaster...	
		if (dobj = brokenheater or dobj = newheater)
		{
			if (isopen) // only if toaster open
			{
				if (worktools.isReachable(parserGetMe())) // only with tools
				{
					// Don't allow a heater to be put in toaster if one is
					// already inside.
					if (dobj = brokenheater)
					{
						if (newinside)
						{
							"There's already a heating element in
							the toaster!";
						}
						else
						{
							"You install the broken heating element
							in the toaster (though there's no
							reason to do so).";
							oldinside := true;
							fixedbrokenheater.moveInto(toaster);
							brokenheater.moveInto(nil);
						}
						
					}
					else if (dobj = newheater)
					{
						if (oldinside)
						{
							"There's already a heating element in
							the toaster!";
						}
						else
						{
							"You install the new heating element
							in the toaster. That should fix the
							toaster, but you should test it to make
							sure.";
							newinside := true;
							fixednewheater.moveInto(toaster);
							newheater.moveInto(nil);
							
							// Score for repair
							if (not toaster.heaterReplaced)
							{
								toaster.heaterReplaced := true;		
								incscore(1);
								"\b(Your score has just gone up by 1 point.)";
							}
						}
					}
				}
				else
				{
					"You need your tools before you can put a
					heating element.";
				}
			}
			else
			{
				"You can't put a heating element in a toaster
				without removing the cover first.";
			}
		}
		else
		{
			// For all other items, only allow one in each slot.
			if (leftslot.isempty)
			{
				leftslot.ioPutIn(actor, dobj);
			}
			else if (rightslot.isempty)
			{
				rightslot.ioPutIn(actor, dobj);
			}
			else
			{
				"There's no room left in the toaster for <<dobj.thedesc>>.";
			}
		}
	}

	// Display contents of toaster slots, and internals if cover is off.
	verDoLookin(actor) = {}
	doLookin(actor) =
	{
		self.showSlotContents;

		if (self.isopen)
		{
			self.showInternalContents;
		}
	}

	// Display contents of slots	
	showSlotContents =
	{
		if (leftslot.isempty && rightslot.isempty)
		{
			"There's nothing in the toaster slots.";
		}
		else if (not leftslot.isempty && rightslot.isempty)
		{
			"There's <<leftslot.contents[1].adesc>> in the left slot.";
		}
		else if (leftslot.isempty && not rightslot.isempty)
		{
			"There's <<rightslot.contents[1].adesc>> in the right slot.";
		}
		else
		{
			"There's <<leftslot.contents[1].adesc>> in the left slot,
			and <<rightslot.contents[1].adesc>> in the right slot.";
		}
	}

	// Display internals of toaster
	showInternalContents =
	{
		"\n\bYou also note that the cover of the toaster is off. ";
		if (newinside)
		{
			"There is a new heating element in the toaster.";
		}
		else if (oldinside)
		{
			"There is a broken heating element in the toaster.";
		}
	}
		
	// Player can only open toaster with tools.
	// When opening the toaster, the fixeditem cover is
	// removed from the toaster and a carryable version is moved to the
	// player. The opposite happens when closing the toaster.
	verDoOpen(actor) = 
	{
		if (not worktools.isReachable(parserGetMe()))
		{
			"You need your tools to open the toaster!";
		}
	}
	doOpen(actor) =
	{
		"Using your tools and finely honed skills, you remove the cover of the
		toaster. ";
		
		fixedcover.moveInto(nil);
		cover.moveInto(parserGetMe());
		toaster.isopen := true;
		
		if (oldinside)
		{
			"Inside, you see a broken heating element.";
			fixedbrokenheater.moveInto(self);
		}
		if (newinside)
		{
			"Inside, you see a new heating element.";
			fixednewheater.moveInto(self);
		}
		
		if (not self.openedOnce)
		{
			self.openedOnce := true;
			incscore(1);
			"\b(Your score has just gone up by 1 point.)";
		}
	}
	verDoClose(actor) =
	{
		if (not worktools.isReachable(parserGetMe()))
		{
			"You need your tools to close the toaster!";
		}
		if (not cover.isReachable(parserGetMe()))
		{
			"You need the cover before you can close up the toaster!";
		}
	}
	doClose(actor) =
	{
		"Using your tools and finely honed skills, you replace the cover of the
		toaster.";
		cover.moveInto(nil);
		fixedcover.moveInto(self);
		toaster.isopen := nil;

		if (oldinside)
		{
			fixedbrokenheater.moveInto(nil);
		}
		if (newinside)
		{
			fixednewheater.moveInto(nil);
		}
	}
	verDoTake(actor) =
	{
		"As much as you'd like to take the toaster into the shop
		for repairs, right now you're obligated to try to fix it
		right here.";
	}
	verDoBreak(actor) =
	{
		if (toaster.heaterReplaced)
		{
			"If it's fixed, don't break it. That's the Second Law
			of the Toaster Repairperson.";
		}
		else
		{
			"If it ain't fixed, don't break it, because that
			would be redundant.";
		}
	}
	verDoAttack(actor) =
	{
		"That sort of thing may have worked in your grandfather's
		day, but not today.";
	}
    verIoAttackWith(actor) =
    {
		"That sort of thing may have worked in your grandfather's
		day, but not today.";    	
	}
	verIoPutOn(actor) = {}
	ioPutOn(actor, dobj) =
	{
		if (dobj = cover)
		{
			self.doClose(actor);
		}
		else
		{
			"You can't put <<dobj.thedesc>> on the toaster!";
		}
	}
	verDoFix(actor) =
	{
		"Unfortunately, you'll need to be more specific as to the
		exact actions you need to do this.";
	}
	verDoUnplug(actor) =
	{
		"You can't unplug the toaster, as it's solar
		powered.";
	}
;

// The cover (fixed version, before player removes it)
fixedcover: fixeditem
	sdesc = "toaster cover"
	ldesc = "This removable metal cover protects the insides of the toaster."
	noun = 'cover'
	adjective = 'toaster' 'removable' 'metal'
	location = toaster
	verDoTake(actor) = 
	{
		if (not worktools.isReachable(parserGetMe()))
		{
			"You need your tools to open the toaster!";
		}
	}
	// When removing the cover of the toaster, the fixeditem cover is
	// removed from the toaster and a carryable version is moved to the
	// player. The opposite happens when replacing the cover.
	doTake(actor) =
	{
		"Using your tools and finely honed skills, you remove the cover of the
		toaster. ";

		fixedcover.moveInto(nil);
		cover.moveInto(parserGetMe());
		toaster.isopen := true;

		if (toaster.oldinside)
		{
			"Inside, you see a broken heating element.";
			fixedbrokenheater.moveInto(toaster);
		}
		if (toaster.newinside)
		{
			"Inside, you see a new heating element.";
			fixednewheater.moveInto(toaster);
		}
	}
	verDoOpen(actor) = {}
	doOpen(actor) =
	{
		toaster.doOpen(actor);
	}
;

// The toaster cover (movable version, after it is removed from toaster).
cover: item
	sdesc = "toaster cover"
	ldesc = "This removable metal cover protects the insides of the toaster."
	noun = 'cover'
	adjective = 'toaster' 'removable' 'metal'
	verDoOpen(actor) = 
	{
		"You've already opened the toaster!";
	}
;

// The lever which the player pushes down to start the toasting process.
lever: fixeditem
	sdesc = "lever"
	ldesc = 
	{
		"This is the lever on the toaster which you push down 
		to start the toasting process. It is currently ";
		if (toaster.istoasting = nil)
		{
			"up.";
		}
		else
		{
			"down.";
		}
	}
	noun = 'lever'
	location = toaster
	verDoPush(actor) = 
	{		
		if (toaster.istoasting)
		{
			"You've already pushed down the lever!";
		}

		// Don't toast if nothing's in either slot		
		if (rightslot.isempty and leftslot.isempty)
		{
			"You push down the lever, but since there is nothing in
			either slot, the lever pops back up after a second.";
		}
	}
	doPush(actor) =
	{
		// Don't toast unless new heating element is inside.
		if (toaster.newinside)
		{
			"The lever goes down with a satisfying click, and you see the
			slots glow with heat.";

			// Do the toasting routine
			toaster.istoasting := true;
			notify(toaster, &toastBread, 0);
		}
		else
		{
			"Hmmm. Even though there's bread in the slots the toaster
			won't work. Must be a busted heating element. You'll have
			to open up the toaster to replace it.";
		}
	}
	
	verDoPull(actor) =
	{
		if (not toaster.istoasting)
		{
			"The lever is already up!";
		}
	}
	doPull(actor) =
	{
		// User can pop up lever to stop toasting.
		toaster.popup;
	}
;

// Fixed versions of the heating elements, which are used when they're
// still in the toaster.
fixednewheater: fixeditem
	sdesc = "new heating element"
	ldesc = "This is a new heating element designed to work with
	         the TX-255 'Toastmaster' Toaster."
	noun = 'element'
	adjective = 'heating' 'new'
	verDoTake(actor) = 
	{
		if (not worktools.isReachable(parserGetMe()))
		{
			"You need your tools to remove the heating element!";
		}
	}
	doTake(actor) =
	{
		"Using your tools and finely honed skills, you remove the new 
		heating element. ";

		self.moveInto(nil);
		newheater.moveInto(parserGetMe());
		toaster.newinside := nil;
	}
;

fixedbrokenheater: fixeditem
	sdesc = "broken heating element"
	ldesc = "This is a heating element designed to work with
	         the TX-255 'Toastmaster' Toaster. It looks like
	         it's burnt out."
	noun = 'element'
	adjective = 'heating' 'broken' 'old'
	verDoTake(actor) = 
	{
		if (not worktools.isReachable(parserGetMe()))
		{
			"You need your tools to remove the broken heating element!";
		}
	}
	doTake(actor) =
	{
		"Using your tools and finely honed skills, you remove the broken 
		heating element. ";

		self.moveInto(nil);
		brokenheater.moveInto(parserGetMe());
		toaster.oldinside := nil;
	}
;

// Mobile versions of the heating elements, which you get when they're
// removed from the toaster.
newheater: item
	sdesc = "new heating element"
	ldesc = "This is a new heating element designed to work with
	         the TX-255 'Toastmaster' Toaster."
	noun = 'element'
	adjective = 'heating' 'new'
	location = toolbelt
;

brokenheater: item
	sdesc = "broken heating element"
	ldesc = "This is a broken heating element designed to work with
	         the TX-255 'Toastmaster' Toaster. It looks like
	         it's burnt out."
	noun = 'element'
	adjective = 'heating' 'broken' 'old'
;

class toasterslot: fixeditem, container
	noun = 'slot'
	
	// Checks whether the slot is empty or not.
	isempty =
	{
		if (length(contents) = 0)
		{
			return true;
		}
		else
		{
			return nil;
		}
	}

	// This code handles putting objects in the toaster slots
	verIoPutIn (actor) = {}
	ioPutIn (actor, dobj) =
	{
		// Only one object at a time can be in the slot
		if (not isempty)
		{
			"There's already something in the slot.";
		}
		else if (dobj = worktools) // putting tools in slot = bad
		{
			if (toaster.istoasting)
			{
				"\bUnfortunately, you stuck a metal object
				into a toaster while it was operating. This,
				as you should know, has serious consequences...\n\b";
				
				"[Press any key to continue]";
				inputkey();

				badending3();
			}
			else
			{
				if (toaster.isopen)
				{
					"You poke around a bit in the toaster's
					innards, to little effect. Perhaps removing
					or putting in a component is the best course
					of action.";
				}
				else
				{
					"You poke around a bit in the toaster slots,
					to little effect. You should probably remove
					the toaster cover to do any serious work.";
				}
			}
		}
		else if ((dobj != manual) and (not isclass(dobj, bread)))
		{
			// Only bread and the manual fit in the slot.
			"\^<<dobj.thedesc>> won't fit in the toaster.";
		}
		else
		{
			"You put <<dobj.thedesc>> in <<self.thedesc>>.";
			dobj.moveInto(self);
		}
	}

	// This routine cooks whatever is in the slot	
	cook =
	{
		if (not isempty)
		{
			local toastObj := contents[1];

			// At every step of the toasting process, delete the current
			// toast object and replace it with the next toast object.
			// This, of course, is not done when the toast reaches
			// maximum toastiness.			
			if (isclass(toastObj, untoastedbread))
			{
				(new barelybread).moveInto(self);
				toastObj.moveInto(nil);
				delete toastObj;				
			}
			else if (isclass(toastObj, barelybread))
			{
				(new slightlybread).moveInto(self);
				toastObj.moveInto(nil);
				delete toastObj;
			}
			else if (isclass(toastObj, slightlybread))
			{
				(new lightgoldbread).moveInto(self);
				toastObj.moveInto(nil);
				delete toastObj;
			}
			else if (isclass(toastObj, lightgoldbread))
			{
				(new goldbread).moveInto(self);
				toastObj.moveInto(nil);
				delete toastObj;
			}
			else if (isclass(toastObj, goldbread))
			{
				(new darkgoldbread).moveInto(self);
				toastObj.moveInto(nil);
				delete toastObj;
			}
			else if (isclass(toastObj, darkgoldbread))
			{
				(new lightbrownbread).moveInto(self);
				toastObj.moveInto(nil);
				delete toastObj;
			}
			else if (isclass(toastObj, lightbrownbread))
			{
				(new brownbread).moveInto(self);
				toastObj.moveInto(nil);
				delete toastObj;
			}
			else if (isclass(toastObj, brownbread))
			{
				(new darkbrownbread).moveInto(self);
				toastObj.moveInto(nil);
				delete toastObj;
			}
			else if (isclass(toastObj, darkbrownbread))
			{
				(new halfburntbread).moveInto(self);
				toastObj.moveInto(nil);
				delete toastObj;
			}
			else if (isclass(toastObj, halfburntbread))
			{
				(new burntbread).moveInto(self);
				toastObj.moveInto(nil);
				delete toastObj;
			}
			else if (isclass(toastObj, burntbread))
			{
				(new charcoalbread).moveInto(self);
				toastObj.moveInto(nil);
				delete toastObj;
			}
			else if (isclass(toastObj, charcoalbread))
			{
				// do nothing
			}
			else if (toastObj = manual) // toasting a manual?
			{
				// Burn, baby, burn
				"\bUnfortunately, the toaster manual was made of a highly
				flammable material. In fact, the material is so flammable
				that it catches fire immediately. You try to put out 
				the flames,	but alas, you're a toaster repairperson, 
				not a fireman...\n\b";
				
				"[Press any key to continue]";
				inputkey();

				badending2();
			}
		}
	}
;

// The two toaster slots, derived from toaster slot to avoid repetitive
// code.
leftslot: toasterslot
	sdesc = "left slot"
	noun = 'slot'
	adjective = 'left'
	location = toaster
;

rightslot: toasterslot
	sdesc = "right slot"
	noun = 'slot'
	adjective = 'right'
	location = toaster
;

// The dial which allows the player to set the "toastiness". A stock
// adv.t dialitem, except I allowed "set dial to <value>".
toasterdial: dialItem
	sdesc = "slider"
	ldesc =
	{
		"This is a dial which can be set to any value from 1 to 10,
		with larger values corresponding to darker toast. It is currently
		set to <<self.setting>>.";
	}
	noun = 'dial'
	location = toaster
	
	// Let the user use the verb "set" to turn the dial
    verDoSet(actor) = {}
    doSet(actor) =
    {
        askio(toPrep);
    }
    verDoSetTo(actor, io) = {}
    doSetTo(actor, io) =
    {
    	self.doTurnTo(actor, io);
    }
;
hhF		used for levels and statistics

"FF"		for "255"		used for statistics

"E7 03"		for "999"		used for HP/MP, Max HP, Max MP

"3F 42 0F"	for "999,999"		used for money or experience



----------------------------------------------------------H	Monaco,pR)V)V1  R*chHH@	R*(,,g	`d'	Monaco		HelveticaConfidentialHhhFl,pFMPSRBBSTL
