#include <adv.t>
#include <std.t>

#pragma C+

modify version
    sdesc = "\(Danger School\)\n
	     by Dan Shiovitz\n
	     Developed with TADS, the Text Adventure Development System.\n"
;

startroom: room
  sdesc = "Your bedroom"
  ldesc =
    {
      "Like the room description says, this is your bedroom. It has, um,
       a bed. Also a desk, at which you were so-recently sitting. ";
      if (trapdoor.location == self)
	"And don't forget the trapdoor under the bed.";
      }
  east =
  {
    if (robot.location == self)
    {
      "The robot roars and blocks your path!\n";
      return;
    }
    else
    {
      "You step out into the hallway, and are immediately killed as
       an enormous saw bursts through the floor. Nuts.\n";
      die();
    }
  }
  down =
  {
    if (trapdoor.location == self)
    {
      "You slip through the trapdoor, dropping and then rolling to your
       feet, ready to flee or fight.  \"So glad you could make it\",
       sneers a voice from the darkness. \"Such a pity you won't be
       leaving ever again! Muha muha muha!\"\b
      The light flicks on, and you gasp at the scene that is revealed.\b";
      notify(speaker, &speak, 0);
      return lab;
    }
    else
      "You can't go that way.\n";
  }
;

desk: qsurface, fixeditem
  sdesc = "desk"
  ldesc =
  {
    "It's the desk at which you do your schoolwork, unless interrupted
    by killer robots. ";
    pass ldesc;
  }
  noun = 'desk'
  location = startroom
;

monkey_text: item
  sdesc = "\"Learn Monkey Butlering in 30 Seconds\""
  ldesc = "Just what the title suggests, presumably. You haven't gotten
           around to reading it yet."
  noun = 'seconds' 
  adjective = '30' 'thirty' 'in' 'monkey' 'butlering' 'learn'
  verDoRead(actor) = {}
  doRead(actor) =
  {
    Me.butler = true;
    "Using your best study habits, you commit <<self.thedesc>> to memory, then
     tear up and swallow the document.\n";
    self.moveInto(nil);
  }
  location = desk
;

pluck_text: item
  sdesc = "\"Learn Chicken Plucking in 30 Seconds\""
  ldesc = "Just what the title suggests, presumably. You haven't gotten
           around to reading it yet."
  noun = 'seconds' 
  adjective = '30' 'thirty' 'in' 'chicken' 'plucking' 'learn'
  verDoRead(actor) = {}
  doRead(actor) =
  {
    Me.pluck = true;
    "Using your best study habits, you commit <<self.thedesc>> to memory, then
     tear up and swallow the document.\n";
    self.moveInto(nil);
  }
  location = desk
;

basket_text: item
  sdesc = "\"Learn Basket Weaving in 30 Seconds\""
  ldesc = "Just what the title suggests, presumably. You haven't gotten
           around to reading it yet."
  noun = 'seconds' 
  adjective = '30' 'thirty' 'in' 'basket' 'weaving' 'learn'
  verDoRead(actor) = {}
  doRead(actor) =
  {
    Me.weave = true;
    "Using your best study habits, you commit <<self.thedesc>> to memory, then
     tear up and swallow the document.\n";
    self.moveInto(nil);
  }
  location = desk
;


vacuum_text: item
  sdesc = "\"Learn Vacuum Repair in 30 Seconds\""
  ldesc = "Just what the title suggests, presumably. You haven't gotten
           around to reading it yet."
  noun = 'seconds' 
  adjective = '30' 'thirty' 'in' 'vacuum' 'repair' 'repairing' 'learn'
  verDoRead(actor) = {}
  doRead(actor) =
  {
    Me.vacuum = true;
    "Using your best study habits, you commit <<self.thedesc>> to memory, then
     tear up and swallow the document.\n";
    self.moveInto(nil);    
  }
  location = desk
;


bed: beditem
  sdesc = "bed"
  ldesc = "It's a bed.  There is of course the bell to summon Arthur on
	   the bedside table."
  noun = 'bed'
  location = startroom

  verDoLookunder(actor) = {}
  doLookunder(actor) =
  {
    "Kneeling to look under the bed, you accidentally strike a hidden tripwire.
     A hail of poison darts flies out at you! ";
    if (arthur.location <> startroom)
    {
      "As is so often the case in these situations (well, not more than
       once per person, but you know), the poison is fatal.\n";
      die();
    }
    else if (!Me.butler)
    {
      "Arthur loyally flings himself in front of the darts! His cute,
       furry body collapses to the floor, twitching slightly.\n";
      arthur.dead = true;
      die();
    }
    else
    {
      "The darts are all deflected by the snazzy brass buttons on Arthur's
       uniform. Yay! Arthur ooks happily and scurries out of the room.\b
       The trap now disarmed, you feel safer in looking under the bed. Sure
       enough -- a trapdoor.\n";
      trapdoor.moveInto(startroom);
      arthur.moveInto(nil);
      incscore(1);
    }
  }
;

trapdoor: fixeditem
  sdesc = "trapdoor"
  ldesc = "A trapdoor gapes underneath the bed, leading into darkness."
  noun = 'trapdoor' 'door'
  adjective = 'trap'
  verDoEnter(actor) = {}
  doEnter(actor) =
  {
    Me.travelTo(startroom.down);
  }
;


ringVerb: deepverb
  sdesc = "ring"
  verb = 'ring'
  doAction = 'Ring'
;

modify thing
  verDoRing(actor) =
  {
    "Ding, dong, ding, dong / if you think you can ring this / you are wrong.";
  }
;

bell: fixeditem
  sdesc = "bell"
  ldesc = "It's the bell that you ring when you want your trained monkey
           servant, Arthur, to bring you something."
  noun = 'bell'
  location = startroom
  doSynonym('Ring') = 'Push' 'Pull'
  verDoRing(actor) = {}
  doRing(actor) =
  {
    "You ring the bell. ";
    if (arthur.location == startroom)
    {
      "Dismissed, Arthur leaves the room.\n";
      arthur.moveInto(nil);
    }
    else if (trapdoor.location == startroom)
    {
      "Arthur is apparently taking a much-deserved vacation. No doubt he's
       sitting on a beach, sipping banana daquiris that he bought on your
       credit card. That ape'll never get a butler job in this town again!\n";
    }
    else if (robot.location == startroom)
    {
      "Arthur appears briefly behind the robot, and shrugs his shoulders in
       a way intended to signify regret, distress, and that muscling past
       killer robots is not in his contract. ";
    }
    else if (arthur.butler)
    {
      "Arthur comes into the room in a thoroughly butlerine way.\n";
      arthur.moveInto(startroom);
    }
    else
    {
      "Arthur stumbles into the room, ooking.\n";
      arthur.moveInto(startroom);
      if (!self.nfy)
      {
	notify(arthur, &ook, 0);
	nfy = true;
      }
      
      if (Me.butler)
      {
	"\"No, no, Arthur,\" you say. \"That's not right at all.\" You spend
	 some time instructing him in the Way of the Monkey Butler, before
	 sending him out to come in again.\bAnd come in he does -- dressed in
	 a cute little red jacket with lovingly-polished brass buttons.\n";
	arthur.butler = true;
      }
    }
  }
;

arthur: Actor
  sdesc = "Arthur"
  adesc = "Arthur"
  thedesc = "Arthur"
  butler = nil
  ldesc =
  {
    if (self.butler)
      "Arthur is standing with back straight, his eyes alert, and dressed
       in a cute little red jacket with brass buttons.";
    else
      "Arthur is standing at ease, scratching himself idly.";
  }
  actorDesc =
  {
    if (self.butler)
      "Arthur is standing here at attention.";
    else
      "Arthur stands there, quietly ooking.";
  }
  noun = 'arthur' 'butler' 'jacket' 'buttons' 'button'
  adjective = 'monkey' 'brass' 'red'


  ook =
  {
    if (self.location == startroom)
    {
      local x = rand(1000);
      if (x < 250)
      {
	"\bArthur ooks.\n";
      }
      else if (x < 500)
      {
	"\bArthur watches you alertly.\n";
      }
      else if (x < 600)
      {
	"\bArthur pulls a banana from a hidden pocket, peels it, drops the peel
	 on the floor, eats the banana, pulls out a little dustpan and broom
	 and sweeps up the peel, then puts the dustpan and broom back away
	 in the same (or perhaps a different) hidden pocket.\n";
      }
    }
  }
;

robot: Actor
  sdesc = "giant killer robot"
  ldesc =
  {
    "The robot is at least seven feet tall and built from polished black
     metal, inset with scattered LEDs that blink in sinister fashion.
     In one hand it wields a mysterious huge black rod. ";
    if (Me.vacuum)
      "Something about the rod nags at you -- but what? ";
  }
  noun = 'robot'
  adjective = 'giant' 'killer'
  location = startroom
  actorDesc = "\^<<self.adesc>> is here, <<rod.sdesc>> in hand."
  counter = 0
  roar =
  {
    if (self.location != startroom)
    {
      unnotify(self, &roar);
      return;
    }
    
    switch (counter++)
    {
    case 0:
      "\bThe robot roars!\n";
      break;
    case 2:
      "\bThe robot points its black rod at you in a menacing fashion.\n";
      break;
    case 4:
      "\bThe robot both roars and waves the black rod.\n";
      break;
    case 5:
      "\bThe robot touches the side of the black rod and it immediately begins to
       hum, as if gathering power.\n";
      break;
    case 6:
      "\bThe robot again points the now-humming black rod at you.\n";
      break;
    case 7:
      "\bApparently reaching the end of its patience, the robot hurls the rod
       to the ground. Unfortunately, this causes the casing to crack and deadly
       ration to escape, killing you and every other living thing within
       a few blocks.\n";
      die();
      break;
    }
  }
;
  
rod: fixeditem
  sdesc =
  {
    if (robot.counter < 4)
      "mysterious black rod";
    else
      "angrily-humming black rod";
  }
  ldesc =
  {
    if (Me.vacuum == true)
    {
      "You recognize the rod immediately as a Mark-4 Nuclear Cybernetic
       Dust-Collection Apparatus, painted a pretty black.  Your trained
       diagnostic skills enable you to instantly realize that the safety
       is on, preventing full operation of the device.\n";
      addword(self, &noun, 'cleaner');
      addword(self, &adjective, 'vacuum');
    }
    else
      "\^<<self.thedesc>> is dark, sleek, and (presumably) deadly.";
  }
  verDoTake(actor) =
  {
    "That seems to belong to <<robot.thedesc>>.\n";
  }
  location = startroom
  noun = 'rod' 'apparatus'
  adjective = 'mysterious' 'black' 'mark-4' 'nuclear' 'cybernetic'
              'dust-collection' 'humming' 'angrily'
;

safety: fixeditem
  sdesc = "safety"
  ldesc = "The safety is on, preventing proper operation of the vacuum."
  noun = 'safety'
  verDoTurnon(actor) = { "The safety is already on.\n"; }
  verDoTurnoff(actor) = {}
  doTurnoff(actor) =
  {
    "Moving swiftly as a striking serpent slithering softly some saturday,
     you reach forward and flip off the safety. The Mark-4 immediately hums
     into full operating mode, complete with ice cream. The robot salutes,
     engages his rocket pants, and soars out of the room. Now, you must
     escape the room! And quickly! But where could the exit be hidden?";
    robot.moveInto(nil);
    rod.moveInto(nil);
    safety.moveInto(nil);
    incscore(1);
  }
  location = startroom
;
  
lab: room
  sdesc = "Secret Underground Lab"
  ldesc =
  {
    "This is the secret underground lab. It is filled with bizarre
     equipment, chickens, test tubes, chickens, bunsen burners, chickens,
     and chickens. ";
    if (haystack.location == self)
      "The above all being covered by a thick layer of straw, of course.";
  }
    
  up = { "The trapdoor is, regrettably, out of reach.\n"; }
;

pluckVerb: deepverb
  sdesc = "pluck"
  verb = 'pluck'
  doAction = 'Pluck'
;

modify thing
  verDoPluck(actor) =
  {
    "This is where I make a \"PLUCK YOU\" joke, I guess.";
  }
;

chickens: fixeditem
  sdesc = "chickens"
  plucked = nil
  ldesc =
  {
    if (plucked)
      "The chickens are shivering slightly. \"One day,\" you swear to yourself,
       \"one day I will get you all sweaters!\"";
    else
      "A thousand chickens. One traitor. Who knows which of the many has the
       dark heart beneath its feathers?";
  }
  noun = 'chicken' 'chickens' 'feather' 'feathers'
  location = lab

  verDoPluck(actor) =
  {
    if (!Me.pluck)
      "Sadly, you are untrained in the art of chicken-plucking, just when
       you need it most!";
  }
  
  doPluck(actor) =
  {
    "Using all your training, you quickly remove each and every feather from
     the chickens in the room, hurling the feathers behind you in a snowy
     cloud. Finally, the last chicken's feathers are shorn, and beneath them
     you see not pink flesh but shiny metal -- ANDROID CHICKEN. Luckily the
     chicken-plucking course included \"disable android chickens\" on its
     suggestion list for what to do with the extraneous feathers, so you have
     little trouble dealing with this de-downy dastard.";
    incscore(1);
    speaker.counter = 3;
  } 
;

speaker: fixeditem
  sdesc = "hidden speaker"
  ldesc = "The speaker is hidden."
  noun = 'speaker'
  dobjGen(a, v, i, p) =
  {
    if (v <> askVerb and v <> tellVerb and v <> inspectVerb)
    {
      "\^<<self.itisdesc>> is too well-hidden.";
      exit;
    }
  }
  iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }

  counter = -1
  speak =
  {
    counter++;
    if (counter == 0)
    {
      "\b\"So glad you could join me,\" continues the voice (which you now
       realize must be coming from a well-hidden speaker. \"I thought perhaps
       we could play a little game. I call it .. exploding chicken. Muha muha
       muha! One of these chickens, and only one, is actually a
       cunningly-designed android of my own invention. In addition to its
       electronic brain it contains enough high explosives to blow this entire
       building to Smithers, my butler. No, wait, I mean, to smithereens,
       which are the very small bits of Smithers remaining after my robotic
       hard-boiled-egg-slicer got loose last week.\" The voice abruptly
       stops speaking, leaving you chilled to the bone.\nAnd then you hear the
       clucking.\n";
    }
    else if (counter == 1)
    {
      "\bThe grim clucking continues. It must be coming from around here -- but
       where?\n";
    }
    else if (counter == 2)
    {
      "\bThe clucking halts ominously.\n";
    }
    else if (counter == 3)
    {
      "\bA small egg-shaped bomb drops from one chicken, rolls towards you, and
       explodes.\n";
      die();
    }
    else if (counter == 4)
    {
      "\b\"But -- but --\" the loudspeaker crackles into life again. \"You may
       have survived my chicken armada somehow, but you will never be able
       to do anything with ALL THIS STRAW!\" A second hidden trapdoor in the
       ceiling abruptly opens, dropping more or less an entire haystack onto
       you.";
      haystack.moveInto(lab);
    }
    else if (counter == 5)
    {
      "\b\"How do you like that straw, eh? I've foxed you this time!\"\n";
    }
    else if (counter == 6)
    {
      "\b\"Your kind is all the same -- prepared for missiles, giant octopuses,
       razor-edged frisbees -- but helpless when confronted with straw. Muha
       muha muha!\"\n";
    }
    else if (counter == 7)
    {
      "\b\"Sorry, you'll have to excuse me, it's time for my nap.\"\n";
    }
    else if (counter > 7)
    {
      "\bThe sound of gentle snoring is all that filters out through the
       speaker.\n";
    }
  }
;

weaveVerb: deepverb
  sdesc = "weave"
  verb = 'weave'
  doAction = 'Weave'
;

modify thing
  verDoWeave(actor) =
  {
    "You can't weave that! Well, not without signing up for the advanced
     basket-weaving course.\n";
  }
;

haystack: fixeditem
  sdesc = "straw"
  ldesc = "There is a lot of straw here, alrighty."
  noun = 'stack' 'straw' 'haystack' 'basket'
  adjective = 'hay'

  verDoWeave(actor) =
  {
    if (!Me.weave)
      "Sadly, you are untrained in the art of basket-weaving, just when
       you need it most!";
  }
  doWeave(actor) =
  {
    "Thinking quickly, you start grabbing handfuls of straw and weaving
     them with lightning speed into a scale-model replica of Paris (c. 1938).
     \"A scale-model replica of Paris? Circa 1938? Made out of straw baskets?
     My only weakness! Aieeeeeee!\"\nThere is a sudden scream from behind
     the speaker, then silence. ";
    incscore(1);
    win();
  }
;

replace init: function
{
#ifdef USE_HTML_STATUS
    /* 
     *   We're using the adv.t HTML-style status line - make sure the
     *   run-time version is recent enough to support this code.  (The
     *   status line code uses systemInfo to detect whether the run-time
     *   is HTML-enabled or not, which doesn't work properly before
     *   version 2.2.4.)  
     */
    if (systemInfo(__SYSINFO_SYSINFO) != true
        || systemInfo(__SYSINFO_VERSION) < '2.2.4')
    {
        "\b\b\(WARNING! This game requires the TADS run-time version
        2.2.4 or higher.  You appear to be using an older version of the
        TADS run-time.  You can still attempt to run this game, but the
        game's screen display may not work properly.  If you experience
        any problems, you should try upgrading to the latest version of
        the TADS run-time.\)\b\b";
    }
#endif

    /* perform common initializations */
    commonInit();
    
    // put introductory text here
    "You're sitting at your desk working busily away on your homework for
     tomorrow, when suddenly a giant killer robot bursts through the wall!
     Oh no!\b";
     
    version.sdesc;                // display the game's name and version number

    setdaemon(turncount, nil);                 // start the turn counter daemon
    notify(robot, &roar, 0);
    parserGetMe().location = startroom;     // move player to initial location
    startroom.lookAround(true);                      // show player where he is
    startroom.isseen = true;                  // note that we've seen the room
    scoreStatus(0, 0);                          // initialize the score display
}

modify global
  maxscore = 4
;

win: function
{
  "\b*** Good has triumphed once again, although admittedly while being still
   trapped in an underground laboratory ***\b";
  scoreRank();
  "\bYou may restore a saved game, start over, quit, or undo
   the current command.\n";
  while (true)
  {
    local resp;
    
    "\nPlease enter RESTORE, RESTART, QUIT, or UNDO: >";
    resp = upper(input());
    if (resp == 'RESTORE')
    {
      resp = askfile('File to restore',
		      ASKFILE_PROMPT_OPEN, FILE_TYPE_SAVE);
      if (resp == nil)
	"Restore failed. ";
      else if (restore(resp))
	"Restore failed. ";
      else
      {
	parserGetMe().location.lookAround(true);
	scoreStatus(global.score, global.turnsofar);
	abort;
      }
    }
    else if (resp == 'RESTART')
    {
      scoreStatus(0, 0);
      restart();
    }
    else if (resp == 'QUIT')
    {
      terminate();
      quit();
      abort;
    }
    else if (resp == 'UNDO')
    {
      if (undo())
      {
	"(Undoing one command)\b";
	parserGetMe().location.lookAround(true);
	scoreStatus(global.score, global.turnsofar);
	abort;
      }
      else
	"Sorry, no undo information is available. ";
    }
  }
}

replace die: function
{
  if (arthur.dead)
    "\b*** An innocent monkey has died ***\b";
  else
    "\b*** You have died ***\b";
  scoreRank();
  "\bYou may restore a saved game, start over, quit, or undo
   the current command.\n";
  while (true)
  {
    local resp;
    
    "\nPlease enter RESTORE, RESTART, QUIT, or UNDO: >";
    resp = upper(input());
    if (resp == 'RESTORE')
    {
      resp = askfile('File to restore',
		      ASKFILE_PROMPT_OPEN, FILE_TYPE_SAVE);
      if (resp == nil)
	"Restore failed. ";
      else if (restore(resp))
	"Restore failed. ";
      else
      {
	parserGetMe().location.lookAround(true);
	scoreStatus(global.score, global.turnsofar);
	abort;
      }
    }
    else if (resp == 'RESTART')
    {
      scoreStatus(0, 0);
      restart();
    }
    else if (resp == 'QUIT')
    {
      terminate();
      quit();
      abort;
    }
    else if (resp == 'UNDO')
    {
      if (undo())
      {
	"(Undoing one command)\b";
	parserGetMe().location.lookAround(true);
	scoreStatus(global.score, global.turnsofar);
	abort;
      }
      else
	"Sorry, no undo information is available. ";
    }
  }
}

replace scoreRank: function
{
  "In a total of "; say(global.turnsofar);
  " turns, you have achieved a score of ";
  say(global.score); " points out of a possible ";
  say(global.maxscore); ".\nThis gives you the rank of ";


  if (global.score == 0)
    "meek and mild-mannered student";
  else if (global.score == 1)
    "Master of the Suctive Forces";
  else if (global.score == 2)
    "Avatar of Social Graces";
  else if (global.score == 3)
    "Keen-Eyed Explosive Avian Locator and Disabler";
  else if (global.score == 4)
    "Well-Nigh-Omnipotent Utilizer of Seemingly Extraneous Materials";
  ".\n";
}
