/*
 * Decompiled with CFR 0.152.
 */
package jigsaw;

import java.util.Hashtable;
import java.util.ResourceBundle;
import jigsaw.Command;
import jigsaw.CommandHandler;
import jigsaw.Exit;
import jigsaw.Item;
import jigsaw.JigState;
import jigsaw.LightedLocation;
import jigsaw.Location;
import jigsaw.Protagonist;
import jigsaw.Util;

public class GenericCommandHandler
implements CommandHandler {
    public Hashtable locations;
    public Protagonist player;
    public Util util;
    public Location loc;
    public String verb = null;
    public String direct_object = null;
    private ResourceBundle res = null;

    public boolean commandHandled(Command command, JigState jigState) {
        this.locations = jigState.getLocations();
        this.player = jigState.getPlayer();
        this.util = jigState.getUtil();
        this.loc = this.player.getLocation();
        this.verb = command.getVerb();
        this.direct_object = command.getDirect_object();
        if (this.falseQuit()) {
            command.setVerb("");
            return true;
        }
        if (this.handleSpecial()) {
            return true;
        }
        if (this.handleInventory()) {
            return true;
        }
        if (this.handleGet()) {
            return true;
        }
        if (this.handlePut()) {
            return true;
        }
        if (this.handleLook()) {
            return true;
        }
        if (this.handleXyzzy()) {
            return true;
        }
        if (this.handleMovement()) {
            return true;
        }
        if (this.handleGeneric()) {
            return true;
        }
        return this.handleUnhandled();
    }

    public boolean falseQuit() {
        if (!this.verb.equals(this.res.getString("quit"))) {
            return false;
        }
        this.util.print(this.res.getString("quit.msg"));
        String string = this.util.readInput();
        if (string == null) {
            return false;
        }
        return !string.equals(this.res.getString("yes"));
    }

    public boolean handleSpecial() {
        return this.verb.equals(this.res.getString("quit"));
    }

    public boolean handleInventory() {
        if (this.verb.equals(this.res.getString("inventory")) || this.verb.equals(this.res.getString("inventory.1")) || this.verb.equals(this.res.getString("inventory.2"))) {
            String string = this.res.getString("carrying.msg");
            String string2 = this.player.getInventoryListing();
            string = string2.equals("") ? string + this.res.getString("nothing") : string + string2 + ".";
            this.util.println(string);
            return true;
        }
        return false;
    }

    public boolean handleMovement() {
        if (this.move(this.player, this.verb)) {
            this.loc = this.player.getLocation();
            if (!this.player.getLocationChanged()) {
                return true;
            }
            if (this.player.getLocationChanged() && this.player.isNewLocation()) {
                this.player.addLocationToVisited();
                this.player.resetLocationChanged();
                this.displayLocation(this.loc);
            } else {
                this.util.println();
                this.util.println(this.loc.getName());
            }
            return true;
        }
        return false;
    }

    public boolean handleGet() {
        if (this.verb.equals(this.res.getString("get")) || this.verb.equals(this.res.getString("take"))) {
            if (this.loc instanceof LightedLocation && !((LightedLocation)this.loc).isVisible()) {
                this.util.println(this.res.getString("get.dark.msg"));
                return true;
            }
            Item item = this.direct_object == null ? null : this.loc.getItemMatchingAlias(this.direct_object);
            if (this.direct_object == null) {
                this.util.println(this.res.getString("get.what"));
            } else if (item == null) {
                this.util.println(this.res.getString("get.not.here"));
            } else if (!item.isPortable()) {
                this.util.println(this.res.getString("get.not.portable"));
            } else {
                this.player.addItem(item);
                this.loc.removeItem(item);
                this.util.println(this.res.getString("get.taken"));
            }
            return true;
        }
        return false;
    }

    public boolean handlePut() {
        if (this.verb.equals(this.res.getString("put")) || this.verb.equals(this.res.getString("drop"))) {
            Item item = this.direct_object == null ? null : this.player.getItemMatchingAlias(this.direct_object);
            if (this.direct_object == null) {
                this.util.println(this.res.getString("put.what"));
            } else if (item == null) {
                this.util.println(this.res.getString("put.not.have"));
            } else {
                this.loc.addItem(item);
                this.player.removeItem(item);
                this.util.println(this.res.getString("put.dropped"));
            }
            return true;
        }
        return false;
    }

    public boolean handleLook() {
        if ((this.verb.equals(this.res.getString("look")) || this.verb.equals(this.res.getString("look.1"))) && this.direct_object == null) {
            this.displayLocation(this.loc);
            return true;
        }
        if ((this.verb.equals(this.res.getString("examine")) || this.verb.equals(this.res.getString("examine.1"))) && this.direct_object == null) {
            this.util.println(this.res.getString("examine.what"));
            return true;
        }
        if (this.verb.equals(this.res.getString("search")) && this.direct_object == null) {
            this.util.println(this.res.getString("search.nothing"));
            return true;
        }
        if (this.verb.equals(this.res.getString("look")) || this.verb.equals(this.res.getString("look.1")) || this.verb.equals(this.res.getString("examine")) || this.verb.equals(this.res.getString("examine.1")) || this.verb.equals(this.res.getString("search"))) {
            if (this.loc instanceof LightedLocation && !((LightedLocation)this.loc).isVisible()) {
                this.util.println(this.res.getString("look.dark"));
                return true;
            }
            Item item = this.loc.getItemMatchingAlias(this.direct_object);
            if (item == null) {
                item = this.player.getItemMatchingAlias(this.direct_object);
            }
            if (item == null) {
                this.util.println(this.res.getString("look.not.here"));
            } else {
                this.util.println(item.getDescription());
            }
            return true;
        }
        return false;
    }

    public boolean handleXyzzy() {
        if (this.util.isVerbInList(this.verb, this.res.getString("xyzzy.commands"))) {
            this.util.println(this.res.getString("xyzzy.fool"));
            return true;
        }
        return false;
    }

    public boolean handleGeneric() {
        if (this.verb.equals(this.res.getString("wait"))) {
            this.util.println(this.res.getString("wait.msg"));
            return true;
        }
        if (this.util.isVerbInList(this.verb, this.res.getString("movement.commands"))) {
            this.util.println(this.res.getString("move.fail"));
            return true;
        }
        return false;
    }

    public boolean handleUnhandled() {
        this.util.println(this.res.getString("i.dont.understand"));
        return true;
    }

    public boolean move(Protagonist protagonist, String string) {
        Exit exit = protagonist.getLocation().getExitMatchingAlias(string);
        if (exit == null) {
            return false;
        }
        if (!exit.canPass()) {
            this.util.println(this.res.getString(exit.getCannotPassMessageKey()));
            protagonist.setLocationChanged(false);
            return true;
        }
        Location location = exit.getLocation();
        if (location == null) {
            return false;
        }
        protagonist.setLocation(location);
        protagonist.setLocationChanged(true);
        return true;
    }

    public void displayLocation(Location location) {
        this.util.println();
        this.util.println(location.getName());
        this.util.println("     " + location.getLong());
        String string = location.getItemListing();
        if (!string.equals("")) {
            this.util.println(this.res.getString("items.here") + string + ".");
        }
    }

    public GenericCommandHandler(ResourceBundle resourceBundle) {
        this.res = resourceBundle;
    }
}

