/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jigsaw.CloseableExit;
import jigsaw.Command;
import jigsaw.CommandHandler;
import jigsaw.Exit;
import jigsaw.GenericCommandHandler;
import jigsaw.JigState;
import jigsaw.Location;
import jigsaw.Protagonist;
import jigsaw.Util;

public class Ophelia {
    static final int QUIT = -1;
    static final int NOTHING = 0;
    Hashtable rooms;
    Protagonist player;
    Util util;
    CommandHandler ch;
    CommandHandler ch1;
    JigState js;
    int score = 0;
    final int MAX_SCORE;
    ResourceBundle res;

    public static void main(String[] stringArray) {
        Locale locale = stringArray.length == 1 ? new Locale(stringArray[0], "") : Locale.getDefault();
        Ophelia ophelia = new Ophelia(locale);
        ophelia.doInit();
        ophelia.doLoop();
        ophelia.doFinalize();
    }

    public void doInit() {
        String string = this.res.getString("intro");
        this.util.println();
        this.util.println(this.res.getString("intro"));
        this.util.println();
        this.util.println(this.res.getString("title"));
        this.player.addLocationToVisited();
        Command command = new Command();
        command.setVerb(this.util.getRes().getString("look"));
        this.ch.commandHandled(command, this.js);
    }

    public void setupRooms() {
        this.createRoom("ophelia's_room");
        this.createRoom("sewing_closet");
        this.createRoom("end_of_hallway_west");
        this.createRoom("hallway_west");
        this.createRoom("linen_closet");
        this.createRoom("hallway_central");
        this.createRoom("hallway_east");
        this.createRoom("end_of_hallway_east");
        this.createRoom("hallway_north");
        this.createRoom("hallway_south");
        this.createRoom("end_of_hallway_south");
        this.createRoom("privy");
        this.createRoom("broom_closet");
        this.createRoom("3to4_stairs");
        this.createRoom("2to3_stairs");
        this.createRoom("nowhere");
        this.createRoom("plot_room");
        this.createRoom("setting_room");
        this.createRoom("theme_room");
        this.createRoom("story_arc_room");
        this.createRoom("character_room");
        this.createExit("ophelia's_room_to_sewing_closet", "east");
        this.createExit("ophelia's_room_to_end_of_hallway_west", "south");
        this.createExit("sewing_closet_to_ophelia's_room", "west");
        this.createExit("end_of_hallway_west_to_ophelia's_room", "north");
        this.createExit("end_of_hallway_west_to_hallway_west", "east");
        this.createExit("end_of_hallway_west_to_linen_closet", "south");
        this.createFalseExit("end_of_hallway_west_to_nowhere", "west");
        this.createExit("linen_closet_to_end_of_hallway_west", "north");
        this.createFalseExit("hallway_west_to_nowhere", "north");
        this.createExit("hallway_west_to_hallway_central", "east");
        this.createFalseExit("hallway_west_to_nowhere", "south");
        this.createExit("hallway_west_to_end_of_hallway_west", "west");
        this.createExit("hallway_central_to_hallway_north", "north");
        this.createExit("hallway_central_to_hallway_east", "east");
        this.createCloseableExit("hallway_central_to_hallway_south", "south");
        this.createExit("hallway_central_to_hallway_west", "west");
        this.createFalseExit("hallway_north_to_nowhere", "north");
        this.createFalseExit("hallway_north_to_nowhere", "east");
        this.createExit("hallway_north_to_hallway_central", "south");
        this.createExit("hallway_north_to_privy", "west");
        this.createExit("privy_to_hallway_north", "east");
        this.createFalseExit("hallway_east_to_nowhere", "north");
        this.createExit("hallway_east_to_end_of_hallway_east", "east");
        this.createExit("hallway_east_to_broom_closet", "south");
        this.createExit("hallway_east_to_hallway_central", "west");
        this.createExit("broom_closet_to_hallway_east", "north");
        this.createFalseExit("end_of_hallway_east_to_nowhere", "north");
        this.createFalseExit("end_of_hallway_east_to_nowhere", "east");
        this.createFalseExit("end_of_hallway_east_to_nowhere", "south");
        this.createExit("end_of_hallway_east_to_hallway_east", "west");
        this.createExit("hallway_south_to_hallway_central", "north");
        this.createExit("hallway_south_to_plot_room", "east");
        this.createExit("hallway_south_to_end_of_hallway_south", "south");
        this.createExit("hallway_south_to_setting_room", "west");
        this.createExit("hallway_south_to_2to3_stairs", "down");
        this.createExit("hallway_south_to_3to4_stairs", "up");
        this.createExit("plot_room_to_hallway_south", "west");
        this.createExit("setting_room_to_hallway_south", "east");
        this.createExit("2to3_stairs_to_hallway_south", "up");
        this.createFalseExit("2to3_stairs_to_nowhere", "down");
        this.createFalseExit("3to4_stairs_to_nowhere", "up");
        this.createExit("3to4_stairs_to_hallway_south", "down");
        this.createExit("end_of_hallway_south_to_hallway_south", "north");
        this.createExit("end_of_hallway_south_to_theme_room", "east");
        this.createExit("end_of_hallway_south_to_character_room", "south");
        this.createExit("end_of_hallway_south_to_story_arc_room", "west");
        this.createExit("character_room_to_end_of_hallway_south", "north");
        this.createExit("theme_room_to_end_of_hallway_south", "west");
        this.createExit("story_arc_room_to_end_of_hallway_south", "east");
    }

    public void setupProtagonist() {
        this.player = new Protagonist();
        this.player.setLocation((Location)this.rooms.get("ophelia's_room"));
    }

    public void doLoop() {
        int n = 0;
        while (n != -1) {
            this.util.println();
            this.util.print("> ");
            String string = this.util.readInput();
            Command command = this.util.parseInput(string);
            n = this.processInput(command);
            if (this.score < 1) continue;
            n = -1;
        }
    }

    private void createRoom(String string) {
        Location location = new Location(string, this.res.getString(string + ".name"), this.res.getString(string + ".desc"));
        this.rooms.put(string, location);
    }

    private void createExit(String string, String string2) {
        int n = 0;
        int n2 = string.indexOf("_to_");
        int n3 = n2 + 4;
        int n4 = string.length();
        String string3 = string.substring(n, n2);
        String string4 = string.substring(n3, n4);
        Location location = (Location)this.rooms.get(string3);
        Location location2 = (Location)this.rooms.get(string4);
        String string5 = this.util.getRes().getString(string2);
        String string6 = this.util.getRes().getString(string2 + ".1");
        location.addExit(new Exit(location2, string, string5, string6));
    }

    private void createFalseExit(String string, String string2) {
        int n = 0;
        int n2 = string.indexOf("_to_");
        int n3 = n2 + 4;
        int n4 = string.length();
        String string3 = string.substring(n, n2);
        String string4 = string.substring(n3, n4);
        Location location = (Location)this.rooms.get(string3);
        Location location2 = (Location)this.rooms.get(string4);
        String string5 = this.util.getRes().getString(string2);
        String string6 = this.util.getRes().getString(string2 + ".1");
        Exit exit = new Exit(location2, string, string5, string6);
        exit.setPassable(false);
        location.addExit(exit);
    }

    private void createCloseableExit(String string, String string2) {
        int n = 0;
        int n2 = string.indexOf("_to_");
        int n3 = n2 + 4;
        int n4 = string.length();
        String string3 = string.substring(n, n2);
        String string4 = string.substring(n3, n4);
        Location location = (Location)this.rooms.get(string3);
        Location location2 = (Location)this.rooms.get(string4);
        String string5 = this.util.getRes().getString(string2);
        String string6 = this.util.getRes().getString(string2 + ".1");
        CloseableExit closeableExit = new CloseableExit(location2, string, string5, string6);
        location.addExit(closeableExit);
    }

    public int processInput(Command command) {
        if (command.getVerb() == null) {
            return 0;
        }
        if (!this.ch1.commandHandled(command, this.js)) {
            this.ch.commandHandled(command, this.js);
        }
        if (command.getVerb().equals(this.util.getRes().getString("quit"))) {
            return -1;
        }
        return 0;
    }

    public void incrementScore(int n) {
        this.score += n;
        String string = n == 1 ? this.res.getString("point") : this.res.getString("points");
        this.util.println("(" + this.res.getString("score.increment.msg") + n + " " + string + ".)");
    }

    public void doFinalize() {
        if (this.score == 1) {
            String string = this.res.getString("point");
        } else {
            String string = this.res.getString("points");
        }
        this.util.println();
        this.util.println(this.res.getString("thankyou"));
    }

    private Ophelia(Locale locale) {
        this.MAX_SCORE = 1;
        try {
            this.res = ResourceBundle.getBundle("game.Ophelia", locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("ERROR: Could not open the resource file for the given locale.");
            System.exit(1);
        }
        this.util = new Util(80, locale);
        this.rooms = new Hashtable();
        this.setupRooms();
        this.setupProtagonist();
        this.js = new JigState(this.rooms, this.player, this.util);
        this.ch = new GenericCommandHandler(this.util.getRes());
        Ophelia ophelia = this;
        if (ophelia == null) {
            throw null;
        }
        this.ch1 = ophelia.new GameCommandHandler();
    }

    class GameCommandHandler
    implements CommandHandler {
        public Hashtable locations;
        public Protagonist player;
        public Util util;
        public Location loc;
        public String verb = null;
        public String direct_object = null;

        public boolean commandHandled(Command command, JigState jigState) {
            this.locations = jigState.getLocations();
            this.player = jigState.getPlayer();
            this.util = jigState.getUtil();
            this.loc = this.player.getLocation();
            this.verb = command.getVerb();
            this.direct_object = command.getDirect_object();
            return this.handleGame();
        }

        public boolean handleGame() {
            String string = this.loc.getId();
            String string2 = "";
            if (string.indexOf("_room") != -1) {
                string2 = string.substring(0, string.length() - 5);
            }
            if (this.verb.equals("open") && string.equals("hallway_central")) {
                CloseableExit closeableExit = (CloseableExit)this.loc.getExitMatchingAlias("south");
                if (!closeableExit.open()) {
                    System.out.println("ERROR: could not open");
                } else {
                    this.util.println(Ophelia.this.res.getString("open.succeed"));
                }
                return true;
            }
            if (string.equals("plot_room") && (this.verb.equals("escape") || this.verb.equals("explore") || this.verb.equals("investigate") || this.verb.equals("live")) || string.equals("setting_room") && (this.verb.equals("elsinore") || this.verb.equals("castle") || this.verb.equals("brook")) || string.equals("character_room") && (this.verb.equals("ophelia") || this.verb.equals("gertrude") || this.verb.equals("hamlet") || this.verb.equals("polonius") || this.verb.equals("claudius") || this.verb.equals("laertes") || this.verb.equals("portnoy") || this.verb.equals("fuchsia")) || string.equals("theme_room") && (this.verb.equals("death") || this.verb.equals("disapproving") || this.verb.equals("empowerment") || this.verb.equals("disappointing")) || string.equals("story_arc_room") && (this.verb.equals("portnoy") || this.verb.equals("despair") || this.verb.equals("diary") || this.verb.equals("penpal"))) {
                String string3 = string2 + "." + this.verb;
                this.util.println(Ophelia.this.res.getString(string3));
                return true;
            }
            return false;
        }
    }
}

