
function procgenerate(context, nodename)
{
    var nod = context.proctext[nodename];

    if (nod === null) {
        return;
    }
    if (nod === undefined) {
        context.procaccum.push('(undefined:'+nodename+')');
        return;
    }
    if (typeof(nod) == 'string') {
        context.procaccum.push(nod);
        return;
    }
    nod.generate(context);
}

function procassemble(context, accum, skipstop)
{
    var priority = {
        'BEGIN': 9,
        'PARA': 8,
        'STOP': 7,
        'SEMI': 6,
        'COMMA': 5,
        'JOIN': 4
    }

    var curstate = 'BEGIN';
    var res = [];

    for (var ix=0; ix<accum.length; ix++) {
        var val = accum[ix];
        if (!val) {
        }
        else if (val == 'JOIN' || val == 'COMMA' || val == 'SEMI' || val == 'STOP' || val == 'PARA') {
            valpri = priority[val];
            if (!valpri)
                valpri = 0;
            curpri = priority[curstate];
            if (!curpri)
                curpri = 0;
            if (curpri < valpri) {
                curstate = val;
            }
        }
        else {
            var docap = false;
            if (curstate == 'BEGIN' || curstate == 'STOP' || curstate == 'PARA') {
                if (curstate == 'STOP') 
                    res.push('. ');
                else if (curstate == 'PARA')
                    res.push('.\n');
                docap = true;
            }
            else if (curstate == 'SEMI') {
                res.push('; ');
            }
            else if (curstate == 'COMMA') {
                res.push(', ');
            }
            else if (curstate == 'JOIN') {
            }
            else if (curstate == 'JOINCAP') {
                docap = true;
            }
            else if (curstate == 'A') {
                if (val == 'ANFORM' || (val != 'AFORM' && val.match(/^[aeiou]/i)))
                    res.push('n ');
                else
                    res.push(' ');
            }
            else {
                res.push(' ');
            }

            if (val == 'A') {
                if (docap)
                    res.push('A');
                else
                    res.push('a');
                curstate = 'A';
            }
            else if (val == 'AFORM' || val == 'ANFORM') {
                if (docap)
                    curstate = 'JOINCAP';
                else
                    curstate = 'JOIN';
            }
            else {
                if (docap) {
                    res.push(val.slice(0, 1).toUpperCase());
                    res.push(val.slice(1));
                }
                else {
                    res.push(val);
                }
                curstate = 'WORD';
            }
        }
    }

    if (!skipstop) {
        if (curstate != 'BEGIN')
            res.push('.');
    }

    return res.join('');
}


/* ProcText nodes */

function SeqPTNode(nodes) {
    this.nodes = nodes;
}
SeqPTNode.prototype = {
    generate : function(context) {
        for (var ix=0; ix<this.nodes.length; ix++) {
            procgenerate(context, this.nodes[ix]);
        }
    }
};

function AltPTNode(nodes) {
    this.nodes = nodes;
}
AltPTNode.prototype = {
    generate : function(context) {
        var ix = Math.floor(this.nodes.length * Math.random());
        procgenerate(context, this.nodes[ix]);
    }
};

function ShufflePTNode(name, nodes) {
    this.name = name;
    this.nodes = nodes;
}
ShufflePTNode.prototype = {
    generate : function(context) {
        var lastval = context.procshufflelast[this.name];
        var ls = context.procshufflelist[this.name];
        if (ls === undefined || ls.length == 0) {
            ls = [];
            for (var ix=0; ix<this.nodes.length; ix++)
                ls.push(ix);
            context.procshufflelist[this.name] = ls;
        }
        var val = undefined;
        var pos = undefined;
        while (val === undefined || (ls.length > 1 && val == lastval)) {
            pos = Math.floor(ls.length * Math.random());
            val = ls[pos];
        }
        ls.splice(pos, 1);
        context.procshufflelast[this.name] = val;
        procgenerate(context, this.nodes[val]);
    }
};

function AltWeightPTNode(total, pairs) {
    this.total = total;
    this.pairs = pairs;
}
AltWeightPTNode.prototype = {
    generate : function(context) {
        var val = Math.random() * this.total;
        var total = 0.0;
        var pair;
        for (var ix=0; ix<this.pairs.length; ix++) {
            pair = this.pairs[ix];
            if (val < total + pair.weight) {
                procgenerate(context, pair.node);
                return;
            }
            total = total + pair.weight;
        }
        procgenerate(context, pair.node);
    }
};

function OptPTNode(chance, node) {
    this.chance = chance;
    this.node = node;
}
OptPTNode.prototype = {
    generate : function(context) {
        if (Math.random() < this.chance) {
            procgenerate(context, this.node);
        }
    }
};

function SetKeyPTNode(key, val) {
    this.key = key;
    this.val = val;
}
SetKeyPTNode.prototype = {
    generate : function(context) {
        context.store[this.key] = this.val;
    }
};

function IfKeyPTNode(key, val, truenode, falsenode) {
    this.key = key;
    this.val = val;
    this.truenode = truenode;
    this.falsenode = falsenode;
}
IfKeyPTNode.prototype = {
    generate : function(context) {
        var val = context.store[this.key];
        if (val == this.val)
            procgenerate(context, this.truenode);
        else
            procgenerate(context, this.falsenode);
    }
};

function SwitchKeyPTNode(key, map, elsenode) {
    this.key = key;
    this.map = map;
    this.elsenode = elsenode;
}
SwitchKeyPTNode.prototype = {
    generate : function(context) {
        var val = context.store[this.key];
        var nod = this.map[val];
        if (nod !== undefined)
            procgenerate(context, nod);
        else
            procgenerate(context, this.elsenode);
    }
};
