/*
 * Decompiled with CFR 0.152.
 */
package micromod.resamplers;

import micromod.resamplers.Resampler;

public class LinearResampler
implements Resampler {
    public LinearResampler() {
        System.out.println(" Linear Resampler 0.2 initialised.");
    }

    public void resample(short[] inputBuf, int samplePos, int subSamplePos, int step, int subStep, short[] outputBuf, int position, int length) {
        int end = position + length - 1;
        step = (step << 16) + subStep;
        int gradient = inputBuf[samplePos + 1] - inputBuf[samplePos];
        int yintercept = inputBuf[samplePos] << 16;
        while (position <= end) {
            outputBuf[position++] = (short)(gradient * subSamplePos + yintercept >> 16);
            if ((subSamplePos += step) <= 65535) continue;
            samplePos += subSamplePos >> 16;
            subSamplePos &= 0xFFFF;
            short temp = inputBuf[samplePos];
            gradient = inputBuf[samplePos + 1] - temp;
            yintercept = temp << 16;
        }
    }

    public int getCushionSize() {
        return 1;
    }
}

