/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age.swing;

import eu.irreality.age.swing.PromptDocumentFilter;
import eu.irreality.age.swing.PromptNavigationFilter;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class FancyJTextField
extends JTextField {
    private static final long serialVersionUID = 2248223696068023706L;
    private String leftPrompt = "";
    private String rightPrompt = "";
    private PromptDocumentFilter theDocFilter = new PromptDocumentFilter(this.leftPrompt, this.rightPrompt);
    private PromptNavigationFilter theNavFilter;
    private boolean promptsEnabled = true;
    private String storedLeftPrompt = "";
    private String storedRightPrompt = "";

    public void setPrompts(String l, String r) {
        String left = l;
        String right = r;
        if (left == null) {
            left = "";
        }
        if (right == null) {
            right = "";
        }
        this.setLeftPrompt(left);
        this.setRightPrompt(right);
    }

    private void setLeftPrompt(String newLeftPrompt) {
        AbstractDocument ad = (AbstractDocument)this.getDocument();
        ad.setDocumentFilter(null);
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setItalic(attributes, true);
        try {
            ad.remove(0, this.leftPrompt.length());
            ad.insertString(0, newLeftPrompt, attributes);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        this.leftPrompt = newLeftPrompt;
        this.theDocFilter.setLeftPrompt(newLeftPrompt);
        this.theNavFilter.setLeftPrompt(newLeftPrompt);
        this.setCaretPosition(this.leftPrompt.length());
        ad.setDocumentFilter(this.theDocFilter);
    }

    private void setRightPrompt(String newRightPrompt) {
        AbstractDocument ad = (AbstractDocument)this.getDocument();
        ad.setDocumentFilter(null);
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setItalic(attributes, true);
        try {
            ad.remove(ad.getLength() - this.rightPrompt.length(), this.rightPrompt.length());
            ad.insertString(ad.getLength(), newRightPrompt, attributes);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        this.rightPrompt = newRightPrompt;
        this.theDocFilter.setRightPrompt(newRightPrompt);
        this.theNavFilter.setRightPrompt(newRightPrompt);
        this.setCaretPosition(this.leftPrompt.length());
        ad.setDocumentFilter(this.theDocFilter);
    }

    public FancyJTextField(int columns) {
        super(columns);
        AbstractDocument ad = (AbstractDocument)this.getDocument();
        ad.setDocumentFilter(this.theDocFilter);
        this.theNavFilter = new PromptNavigationFilter(this.leftPrompt, this.rightPrompt, ad);
        this.setNavigationFilter(this.theNavFilter);
    }

    public String getText() {
        try {
            return this.getDocument().getText(this.leftPrompt.length(), this.getDocument().getLength() - this.rightPrompt.length() - this.leftPrompt.length());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setPromptsEnabled(boolean enable) {
        if (this.promptsEnabled && !enable) {
            this.storedLeftPrompt = this.leftPrompt;
            this.storedRightPrompt = this.rightPrompt;
            this.setPrompts("", "");
            this.promptsEnabled = false;
        } else if (!this.promptsEnabled && enable) {
            this.setPrompts(this.storedLeftPrompt, this.storedRightPrompt);
            this.storedLeftPrompt = "";
            this.storedRightPrompt = "";
            this.promptsEnabled = true;
        }
    }
}

