/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age.spell;

import eu.irreality.age.NaturalLanguage;
import eu.irreality.age.World;
import eu.irreality.age.spell.Correction;
import eu.irreality.age.spell.ReferenceNameCorrector;
import eu.irreality.age.spell.SimpleReverseCorrector;
import eu.irreality.age.spell.SpellingCorrector;
import java.util.StringTokenizer;

public class AGESpellChecker {
    World w;
    NaturalLanguage lang;
    SpellingCorrector verbCorrector;
    SpellingCorrector nameCorrector;
    private static int MINLENGTH = 3;

    public AGESpellChecker(World w, NaturalLanguage lang) {
        this.w = w;
        this.lang = lang;
        this.verbCorrector = lang.getVerbSpellingCorrector();
        this.nameCorrector = new ReferenceNameCorrector(w, new SimpleReverseCorrector());
    }

    public String correctVerbOrName(String w, boolean useVerbs, boolean useNames, boolean caseInsensitive) {
        String word = w;
        if (caseInsensitive) {
            word = w.toLowerCase();
        }
        String corrected = w;
        if (word.length() >= MINLENGTH) {
            Correction verbCorrection = this.verbCorrector.getBestCorrection(word);
            Correction nameCorrection = this.nameCorrector.getBestCorrection(word);
            if (useVerbs && verbCorrection != null && verbCorrection.getDistance() < 0.01) {
                corrected = verbCorrection.getWord();
            } else if (useNames && nameCorrection != null && nameCorrection.getDistance() < 0.01) {
                corrected = nameCorrection.getWord();
            } else if (useVerbs && verbCorrection != null && verbCorrection.getDistance() < 1.01) {
                corrected = verbCorrection.getWord();
            } else if (useNames && nameCorrection != null && nameCorrection.getDistance() < 1.01) {
                corrected = nameCorrection.getWord();
            }
        }
        return corrected;
    }

    public String correctCommandString(String s) {
        StringTokenizer st = new StringTokenizer(s);
        StringBuffer result = new StringBuffer();
        if (!st.hasMoreTokens()) {
            return s;
        }
        String firstWord = st.nextToken();
        String correctedFirstWord = this.correctVerbOrName(firstWord, true, true, true);
        result.append(correctedFirstWord);
        while (st.hasMoreTokens()) {
            String nextWord = st.nextToken();
            String correctedNextWord = this.correctVerbOrName(nextWord, false, true, true);
            result.append(" ");
            result.append(correctedNextWord);
        }
        return result.toString();
    }
}

