/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import bsh.TargetError;
import eu.irreality.age.AGESoundClient;
import eu.irreality.age.Description;
import eu.irreality.age.EVASemanticException;
import eu.irreality.age.Entity;
import eu.irreality.age.EntityList;
import eu.irreality.age.GameEngineThread;
import eu.irreality.age.Informador;
import eu.irreality.age.InputOutputClient;
import eu.irreality.age.Inventory;
import eu.irreality.age.Item;
import eu.irreality.age.Mobile;
import eu.irreality.age.MobileList;
import eu.irreality.age.MultimediaInputOutputClient;
import eu.irreality.age.ParserMethods;
import eu.irreality.age.Path;
import eu.irreality.age.PropertyEntry;
import eu.irreality.age.ReturnValue;
import eu.irreality.age.Room;
import eu.irreality.age.SentenceInfo;
import eu.irreality.age.SoundClient;
import eu.irreality.age.Spell;
import eu.irreality.age.SpellList;
import eu.irreality.age.StringMethods;
import eu.irreality.age.SupportingCode;
import eu.irreality.age.Utility;
import eu.irreality.age.Weapon;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import eu.irreality.age.debug.Debug;
import eu.irreality.age.debug.ExceptionPrinter;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Node;

public class Player
extends Mobile
implements Informador {
    protected String commandstring;
    protected String command;
    protected String arguments;
    protected Vector commandQueue = new Vector();
    protected String ZR_verbo = "mirar";
    protected String ZR_objeto_masculino_singular = "";
    protected String ZR_objeto_femenino_singular = "";
    protected String ZR_objeto_singular = "";
    protected String ZR_objeto_masculino_plural = "";
    protected String ZR_objeto_femenino_plural = "";
    protected String ZR_objeto_plural = "";
    protected boolean from_log;
    protected Vector logfile;
    protected boolean forced;
    protected String force_string;
    protected boolean secondChance;
    protected boolean nextCommandSecondChance;
    BufferedReader logReader;
    Vector finalExecutedCommandLog = new Vector();
    Weapon lastAttackWeapon = null;
    Mobile lastAttackedEnemy = null;
    Weapon lastBlockWeapon = null;
    Mobile lastBlockedEnemy = null;
    private boolean matchedOneEntity = false;
    private boolean matchedTwoEntities = false;
    private boolean matchedOneEntityPermissive = false;
    private boolean matchedTwoEntitiesPermissive = false;
    private EntityList mobilesCache;

    public void setPlayerName(String nombre) {
        this.title = nombre;
        this.properName = true;
        this.respondToSing = nombre + "$" + this.respondToSing;
        this.respondToPlur = nombre + "$" + this.respondToPlur;
        this.singNames = new Description[1];
        this.singNames[0] = new Description(nombre, 0L, 0L);
        this.plurNames = new Description[1];
        this.plurNames[0] = new Description(nombre, 0L, 0L);
    }

    public Player(World mundo, InputOutputClient io, Node n) throws XMLtoWorldException {
        super(mundo, n);
        this.io = io;
        this.setNewState(1, 1L);
    }

    public Player(World mundo, InputOutputClient io) throws IOException {
        super(mundo, Utility.playerFile(mundo));
        this.io = io;
        this.setRoom(mundo.getRoom(1));
        this.setRoom(mundo.getRoom(1));
        this.setNewState(1, 1L);
    }

    public void prepareLog(BufferedReader br) {
        Debug.println("Preparing log input on " + this);
        this.logReader = br;
        this.from_log = true;
    }

    public void endOfLog() {
        MultimediaInputOutputClient mioc;
        SoundClient sc;
        this.from_log = false;
        if (this.getIO() instanceof MultimediaInputOutputClient && (sc = (mioc = (MultimediaInputOutputClient)this.getIO()).getSoundClient()) instanceof AGESoundClient) {
            AGESoundClient asc = (AGESoundClient)sc;
            asc.activate();
        }
    }

    public void forceCommand(String s) {
        this.forced = true;
        this.force_string = s;
    }

    public void enqueueCommand(String s) {
        this.commandQueue.add(s);
    }

    public void setCommandString(String s) {
        this.commandstring = s;
    }

    public synchronized void resumeExecution() {
        this.notify();
    }

    private void escribirDenegacionComando(String s) {
        if (this.secondChance) {
            this.escribirErrorNoEntiendo();
        } else {
            this.write(s);
        }
    }

    public boolean update(PropertyEntry pe, World mundo) {
        String theProp = pe.getName();
        if (theProp.equals("custom_parsing")) {
            boolean value = pe.getValueAsBoolean();
            if (value) {
                try {
                    return this.customParse();
                }
                catch (IOException ioe) {
                    this.write(this.io.getColorCode("error") + "Excepci\u00f3n E/S en update() para propiedad custom_parsing" + this.io.getColorCode("reset"));
                    return false;
                }
            }
            return true;
        }
        if (theProp.equals("state") && pe.getTimeLeft() < 0L) {
            pe.setTime(0L);
        }
        return super.update(pe, mundo);
    }

    public void setParseRoutine(Entity holdingTheRoutine, String routineName) {
        this.setProperty("custom_parsing", true, 0L);
        this.pushPropertyToFront("custom_parsing");
        this.setRelationshipProperty(holdingTheRoutine, "custom_parser", routineName);
    }

    public synchronized boolean customParse() throws IOException {
        String theCommand;
        if (this.from_log) {
            String newCommand = this.logReader.readLine();
            if (newCommand == null) {
                this.from_log = false;
                this.mundo.endOfLog();
                return this.customParse();
            }
            this.io.forceInput(newCommand, true);
            theCommand = newCommand;
        } else {
            GameEngineThread gte = (GameEngineThread)Thread.currentThread();
            if (gte.isRealTimeEnabled()) {
                theCommand = this.io.getRealTimeInput(this);
                if (theCommand == null) {
                    this.setPropertyTimeLeft("custom_parsing", 1L);
                    return false;
                }
            } else {
                theCommand = this.io.getInput(this);
                if (theCommand == null && this.io.isDisconnected()) {
                    this.disconnect();
                    return true;
                }
            }
        }
        List ofEntities = this.getRelatedEntities("custom_parser");
        if (ofEntities.size() < 1) {
            this.write(this.io.getColorCode("error") + "Error: llamada a customParse() sin entidades con parsers activos para \u00e9sta." + this.io.getColorCode("reset"));
            return false;
        }
        Entity ourEntity = null;
        String routineName = null;
        for (int i = 0; i < ofEntities.size() && (routineName = this.getRelationshipPropertyValueAsString(ourEntity = (Entity)ofEntities.get(i), "custom_parser")) == null; ++i) {
        }
        if (ourEntity instanceof SupportingCode) {
            ReturnValue retVal = new ReturnValue(null);
            try {
                ((SupportingCode)((Object)ourEntity)).execCode(routineName, new Object[]{this, theCommand}, retVal);
            }
            catch (TargetError bshte) {
                this.write(this.io.getColorCode("error") + "bsh.TargetError found at customParse(), execcing from ID " + this.getID() + " the routine " + routineName + " of " + ourEntity.getID());
                bshte.printStackTrace();
                this.writeError(ExceptionPrinter.getExceptionReport(bshte));
            }
            if (retVal.getRetVal() == null || !(retVal.getRetVal() instanceof Boolean)) {
                this.setProperty("custom_parsing", false, 0L);
                this.setRelationshipProperty(ourEntity, "custom_parser", null);
                return false;
            }
            Boolean ret = (Boolean)retVal.getRetVal();
            if (!ret.booleanValue()) {
                return this.customParse();
            }
            this.setProperty("custom_parsing", false, 0L);
            this.setRelationshipProperty(ourEntity, "custom_parser", null);
            return ret;
        }
        this.write(this.io.getColorCode("error") + "Error: llamada a customParse() para clase que no lo soporta: " + ourEntity.getClass());
        return false;
    }

    private EntityList getAllWorldMobiles() {
        if (this.mobilesCache == null) {
            this.mobilesCache = this.mundo.getAllMobiles();
        }
        return this.mobilesCache;
    }

    public void cancelPending() {
        this.commandQueue.removeAllElements();
    }

    public synchronized boolean execCommand(World mundo) throws IOException {
        this.secondChance = false;
        String originalTrimmedCommandString = null;
        if (!this.commandQueue.isEmpty() && !this.forced) {
            if (this.nextCommandSecondChance) {
                this.secondChance = true;
                this.nextCommandSecondChance = false;
            }
            for (int i = 0; i < this.commandQueue.size(); ++i) {
            }
            originalTrimmedCommandString = this.commandstring = ((String)this.commandQueue.elementAt(0)).trim();
            this.commandQueue.removeElementAt(0);
            if (!this.separateSentences()) {
                return false;
            }
        } else {
            if (this.forced) {
                this.forced = false;
                this.io.forceInput(this.force_string, false);
                this.commandstring = this.force_string;
            } else if (this.from_log) {
                String newCommand = this.logReader.readLine();
                if (newCommand == null) {
                    this.from_log = false;
                    mundo.endOfLog();
                    return this.execCommand(mundo);
                }
                this.io.forceInput(newCommand, true);
                this.commandstring = newCommand;
            } else {
                GameEngineThread gte = (GameEngineThread)Thread.currentThread();
                if (gte.isRealTimeEnabled()) {
                    this.commandstring = this.io.getRealTimeInput(this);
                    if (this.commandstring == null) {
                        this.commandstring = "";
                        if (this.io.isDisconnected()) {
                            this.disconnect();
                            return true;
                        }
                    }
                } else {
                    this.commandstring = this.io.getInput(this);
                    if (this.commandstring == null && this.io.isDisconnected()) {
                        this.disconnect();
                        return true;
                    }
                }
            }
            if (this.commandstring != null) {
                this.commandstring = this.commandstring.trim();
            }
            boolean executed = false;
            try {
                ReturnValue retval = new ReturnValue(null);
                executed = mundo.execCode("preprocessCommand", new Object[]{this, this.commandstring}, retval);
                if (retval.getRetVal() != null) {
                    this.commandstring = (String)retval.getRetVal();
                    this.command = StringMethods.getTok(this.commandstring, 1, ' ').trim();
                    this.arguments = StringMethods.getToks(this.commandstring, 2, StringMethods.numToks(this.commandstring, ' '), ' ').trim();
                }
            }
            catch (TargetError te) {
                this.write(this.io.getColorCode("error") + "bsh.TargetError found at preprocessCommand, raw command was " + this.commandstring + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                this.writeError(ExceptionPrinter.getExceptionReport(te));
            }
            if (executed) {
                this.setNewState(1, 1L);
                this.ZR_verbo = this.command;
                return true;
            }
            if (this.commandstring == null || this.commandstring.equals("")) {
                return false;
            }
            if (this.commandstring.startsWith("eval ") && Debug.isEvalEnabled()) {
                ReturnValue retVal = new ReturnValue(null);
                this.arguments = StringMethods.getToks(this.commandstring, 2, StringMethods.numToks(this.commandstring, ' '), ' ').trim();
                try {
                    mundo.getAssociatedCode().evaluate(this.arguments, this, retVal);
                }
                catch (TargetError e) {
                    this.writeError(ExceptionPrinter.getExceptionReport(e));
                }
                this.write("" + retVal.getRetVal() + "\n");
                return false;
            }
            originalTrimmedCommandString = this.commandstring;
            if (!this.separateSentences()) {
                return false;
            }
        }
        if (this.commandstring.isEmpty()) {
            return false;
        }
        return this.execCommand(this.commandstring);
    }

    public boolean execCommand(String commandstring) {
        if (this.getPropertyValueAsBoolean("noPronounDisambiguation") && this.matchedTwoEntitiesPermissive && (Player.firstWord(commandstring).toLowerCase().endsWith("las") && Player.firstWord(commandstring).length() > 3 || Player.firstWord(commandstring).toLowerCase().endsWith("los") && Player.firstWord(commandstring).length() > 3 || Player.firstWord(commandstring).toLowerCase().endsWith("la") && Player.firstWord(commandstring).length() > 2 || Player.firstWord(commandstring).toLowerCase().endsWith("lo") && Player.firstWord(commandstring).length() > 2)) {
            commandstring = this.substitutePronounsInSentence(commandstring);
            commandstring = this.lenguaje.sustituirVerbo(commandstring);
            commandstring = this.lenguaje.sustituirAlias(commandstring);
            commandstring = commandstring.trim();
            this.command = StringMethods.getTok(commandstring, 1, ' ').trim();
            this.write(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("ambiguous.pronoun", "$command", this.command, new Object[]{this, commandstring}) + this.io.getColorCode("reset"));
            this.ZR_verbo = Player.firstWord(this.substitutePronounsInSentence(commandstring));
            this.cancelPending();
            return false;
        }
        String originalTrimmedCommandString = commandstring;
        commandstring = this.substitutePronounsInSentence(commandstring);
        commandstring = this.lenguaje.sustituirVerbo(commandstring);
        commandstring = this.lenguaje.sustituirAlias(commandstring);
        commandstring = commandstring.trim();
        this.command = StringMethods.getTok(commandstring, 1, ' ').trim();
        if ("decir".equalsIgnoreCase(this.command)) {
            commandstring = originalTrimmedCommandString;
        }
        this.arguments = StringMethods.getToks(commandstring, 2, StringMethods.numToks(commandstring, ' '), ' ').trim();
        this.finalExecutedCommandLog.addElement(commandstring);
        String actionName = "";
        Object[] actionArgs = null;
        boolean ejecutado = false;
        try {
            ReturnValue retval = new ReturnValue(null);
            boolean bl = ejecutado = ejecutado || this.execCode("parseCommand", new Object[]{this.command, this.arguments}, retval);
            if (retval.getRetVal() != null) {
                commandstring = (String)retval.getRetVal();
                this.command = StringMethods.getTok(commandstring, 1, ' ').trim();
                this.arguments = StringMethods.getToks(commandstring, 2, StringMethods.numToks(commandstring, ' '), ' ').trim();
            }
        }
        catch (TargetError te) {
            this.write(this.io.getColorCode("error") + "bsh.TargetError found at player's parseCommand, command was " + this.command + this.arguments + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
            this.writeError(ExceptionPrinter.getExceptionReport(te));
        }
        if (ejecutado) {
            this.setNewState(1, 1L);
            this.ZR_verbo = this.command;
            return true;
        }
        ejecutado = false;
        this.matchedOneEntity = false;
        this.matchedTwoEntities = false;
        this.matchedOneEntityPermissive = false;
        this.matchedTwoEntitiesPermissive = false;
        EntityList posiblesObjetivos = this.getReachableEntities();
        EntityList posiblesObjetivosPermissive = this.getReachableEntities(true);
        List matches_ss = ParserMethods.parseReferencesToEntitiesIn(this.arguments, posiblesObjetivos, posiblesObjetivos, false, false);
        List matches_sp = ParserMethods.parseReferencesToEntitiesIn(this.arguments, posiblesObjetivos, posiblesObjetivos, false, true);
        List matches_ps = ParserMethods.parseReferencesToEntitiesIn(this.arguments, posiblesObjetivos, posiblesObjetivos, true, false);
        List matches_pp = ParserMethods.parseReferencesToEntitiesIn(this.arguments, posiblesObjetivos, posiblesObjetivos, true, true);
        ArrayList allMatches = new ArrayList();
        allMatches.addAll(matches_ss);
        allMatches.addAll(matches_sp);
        allMatches.addAll(matches_ps);
        allMatches.addAll(matches_pp);
        this.matchedTwoEntities = allMatches.size() > 0;
        Vector matches_s = ParserMethods.refersToEntityInRecursive(this.arguments, posiblesObjetivos, false);
        Vector matches_p = ParserMethods.refersToEntityInRecursive(this.arguments, posiblesObjetivos, true);
        this.matchedOneEntity = matches_s.size() > 0 || matches_p.size() > 0;
        ejecutado = this.resolveParseCommandForTwoEntities(posiblesObjetivos, this.arguments, this.arguments, false);
        if (ejecutado) {
            this.setNewState(1, 1L);
            this.ZR_verbo = this.command;
            return true;
        }
        ejecutado = this.resolveParseCommandForOneEntity(posiblesObjetivos, this.arguments, this.arguments, false);
        if (ejecutado) {
            this.setNewState(1, 1L);
            this.ZR_verbo = this.command;
            return true;
        }
        if (!this.matchedOneEntity && !this.matchedTwoEntities && this.lenguaje.isVerb(this.command)) {
            EntityList posiblesObjetivosForComponents = (EntityList)posiblesObjetivos.clone();
            posiblesObjetivosForComponents.addEntity(this.getRoom());
            ejecutado = this.resolveParseCommandForOneComponent(posiblesObjetivosForComponents, this.arguments);
            if (ejecutado) {
                this.setNewState(1, 1L);
                this.ZR_verbo = this.command;
                return true;
            }
        }
        Vector patternMatchVectorSing = ParserMethods.refersToEntityIn(this.arguments, posiblesObjetivos, false);
        Vector patternMatchVectorPlur = ParserMethods.refersToEntityIn(this.arguments, posiblesObjetivos, true);
        ejecutado = false;
        try {
            ejecutado = this.habitacionActual.execCode("command_" + this.command + "_" + this.arguments.replace(' ', '_'), "this: " + this.habitacionActual.getID() + "\n" + "player: " + this.getID());
            if (!ejecutado) {
                if (this.arguments != null) {
                    ejecutado = this.habitacionActual.execCode("command_" + this.command, "this: " + this.habitacionActual.getID() + "\nargs: " + this.arguments + "\n" + "player: " + this.getID());
                } else if (this.arguments == null) {
                    ejecutado = this.habitacionActual.execCode("command_" + this.command, "this: " + this.habitacionActual.getID() + "\n" + "player: " + this.getID());
                }
            }
        }
        catch (EVASemanticException exc) {
            this.write(this.io.getColorCode("error") + "EVASemanticException found at room command , room number " + this.habitacionActual.getID() + this.io.getColorCode("reset"));
        }
        try {
            ejecutado = ejecutado || this.habitacionActual.execCode("parseCommand", new Object[]{this, this.command, this.arguments});
        }
        catch (TargetError te) {
            te.printStackTrace();
            this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommand(), command was " + this.command + this.arguments + ", room number " + this.habitacionActual.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
            this.writeError(ExceptionPrinter.getExceptionReport(te));
        }
        if (ejecutado) {
            this.ZR_verbo = this.command;
            return true;
        }
        ejecutado = this.resolveParseCommandForTwoEntities(posiblesObjetivos, this.arguments, this.arguments, true);
        if (ejecutado) {
            this.setNewState(1, 1L);
            this.ZR_verbo = this.command;
            return true;
        }
        ejecutado = this.resolveParseCommandForOneEntity(posiblesObjetivos, this.arguments, this.arguments, true);
        if (ejecutado) {
            this.setNewState(1, 1L);
            this.ZR_verbo = this.command;
            return true;
        }
        try {
            ReturnValue retval = new ReturnValue(null);
            boolean bl = ejecutado = ejecutado || this.mundo.execCode("parseCommand", new Object[]{this, this.command, this.arguments}, retval);
            if (retval.getRetVal() != null) {
                commandstring = (String)retval.getRetVal();
                this.command = StringMethods.getTok(commandstring, 1, ' ').trim();
                this.arguments = StringMethods.getToks(commandstring, 2, StringMethods.numToks(commandstring, ' '), ' ').trim();
            }
        }
        catch (TargetError te) {
            this.write(this.io.getColorCode("error") + "bsh.TargetError found at world's parseCommand, command was " + this.command + this.arguments + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
            this.writeError(ExceptionPrinter.getExceptionReport(te));
        }
        if (ejecutado) {
            this.setNewState(1, 1L);
            this.ZR_verbo = this.command;
            return true;
        }
        if (this.command.equalsIgnoreCase("ir")) {
            actionName = "go";
            actionArgs = new Object[1];
            if (StringMethods.numToks(commandstring, ' ') < 2) {
                this.write(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("go.nowhere", new Object[]{this}) + this.io.getColorCode("reset"));
                this.ZR_verbo = this.command;
                this.cancelPending();
                return false;
            }
            if (StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("norte") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("n")) {
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, 0);
            } else if (StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("sur") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("s")) {
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, 1);
            } else if (StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("oeste") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("e")) {
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, 2);
            } else if (StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("este") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("o")) {
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, 3);
            } else if (StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("sudeste") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("se") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("sureste")) {
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, 7);
            } else if (StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("sudoeste") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("so") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("suroeste")) {
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, 6);
            } else if (StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("nordeste") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("noreste") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("ne")) {
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, 5);
            } else if (StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("noroeste") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("no")) {
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, 4);
            } else if (StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("arriba") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("ar")) {
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, 8);
            } else if (StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("abajo") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("ab")) {
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, 9);
            } else {
                for (int i = 0; i < this.habitacionActual.otherExits.length; ++i) {
                    if (!this.habitacionActual.isValidExit(false, i) || !this.habitacionActual.getExit(false, i).matchExitCommand(this.arguments)) continue;
                    this.ZR_verbo = this.command;
                    actionArgs[0] = this.habitacionActual.getExit(false, i);
                }
                if (actionArgs[0] == null) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("go.where", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.cancelPending();
                    return false;
                }
            }
        } else if (this.command.equalsIgnoreCase("volver")) {
            int i;
            actionName = "go";
            actionArgs = new Object[1];
            for (i = 0; i < this.habitacionActual.standardExits.length; ++i) {
                if (!this.habitacionActual.isValidExit(true, i) || this.mundo.getRoom(this.habitacionActual.getExit(true, i).getDestinationID()) != this.habitacionAnterior) continue;
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, i);
                break;
            }
            if (actionArgs[0] == null) {
                for (i = 0; i < this.habitacionActual.otherExits.length; ++i) {
                    if (!this.habitacionActual.isValidExit(false, i) || this.mundo.getRoom(this.habitacionActual.getExit(false, i).getDestinationID()) != this.habitacionAnterior) continue;
                    this.ZR_verbo = this.command;
                    actionArgs[0] = this.habitacionActual.getExit(false, i);
                    break;
                }
            }
            if (actionArgs[0] == null) {
                this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("cant.go.back", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                this.ZR_verbo = this.command;
                this.cancelPending();
                return false;
            }
        } else {
            if (this.command.equalsIgnoreCase("mirar")) {
                if (StringMethods.numToks(commandstring, ' ') < 2) {
                    this.show_room(this.mundo);
                    this.setNewState(1, 1L);
                    this.ZR_verbo = this.command;
                    return true;
                }
                String s = this.habitacionActual.getExtraDescription(this.arguments, this);
                if (s != null) {
                    this.write(this.io.getColorCode("description") + s + this.io.getColorCode("reset") + "\n");
                    this.setNewState(1, 1L);
                    this.ZR_verbo = this.command;
                    return true;
                }
                boolean mirado = false;
                Debug.println("Mirado init");
                if (!mirado) {
                    mirado = this.mirarExtrasItems(this.arguments, this.habitacionActual.itemsInRoom);
                }
                Debug.println("Mirado=" + mirado);
                if (!mirado) {
                    mirado = this.mirarExtrasItems(this.arguments, this.inventory);
                }
                Debug.println("Mirado=" + mirado);
                if (!mirado) {
                    mirado = this.mirarItem(this.arguments, this.habitacionActual.itemsInRoom);
                }
                Debug.println("Mirado=" + mirado);
                if (!mirado) {
                    mirado = this.mirarContenido(this.arguments, this.habitacionActual.itemsInRoom);
                }
                Debug.println("Mirado=" + mirado);
                if (!mirado) {
                    mirado = this.mirarItem(this.arguments, this.inventory);
                }
                Debug.println("Mirado=" + mirado);
                if (!mirado) {
                    mirado = this.mirarContenido(this.arguments, this.inventory);
                }
                Debug.println("Mirado=" + mirado);
                if (!mirado) {
                    mirado = this.mirarBicho(this.arguments, this.habitacionActual.mobsInRoom);
                }
                Debug.println("Mirado=" + mirado);
                if (!mirado) {
                    mirado = this.mirarItem(this.arguments, this.getFlattenedPartsInventory());
                }
                Debug.println("Mirado=" + mirado);
                MobileList yo = new MobileList();
                yo.addElement(this);
                if (!mirado) {
                    mirado = this.mirarExtrasBichos(this.arguments, this.getRoom().getMobiles());
                }
                if (!mirado) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("look.what", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.cancelPending();
                    return false;
                }
                this.ZR_verbo = this.command;
                this.setNewState(1, 1L);
                return true;
            }
            if (this.command.equalsIgnoreCase("atacar")) {
                boolean mirado = false;
                mirado = this.atacarBichoConArma(this.habitacionActual.mobsInRoom, this.getUsableWeapons());
                if (!mirado) {
                    if (this.inventory.patternMatch(this.arguments, false) != null && this.inventory.patternMatch(this.arguments, false).size() > 0) {
                        this.escribirDenegacionComando(this.io.getColorCode("denial") + "Para atacar con un arma, primero has de blandirla.\n" + this.io.getColorCode("reset"));
                    }
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("attack.what", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.cancelPending();
                    return false;
                }
                this.ZR_verbo = this.command;
                return true;
            }
            if (this.command.equalsIgnoreCase("bloquear") || this.command.equalsIgnoreCase("defender")) {
                boolean mirado = false;
                mirado = this.bloquearBichoConArma(this.habitacionActual.mobsInRoom, this.getUsableWeapons());
                if (!mirado) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("block.what", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.cancelPending();
                    return false;
                }
                this.ZR_verbo = this.command;
                return true;
            }
            if (this.command.equalsIgnoreCase("esquivar")) {
                boolean mirado = false;
                mirado = this.esquivar();
                if (!mirado) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("dodge.what", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.cancelPending();
                    return false;
                }
                this.ZR_verbo = this.command;
                return true;
            }
            if (this.command.equalsIgnoreCase("abrir")) {
                boolean mirado = false;
                Object patternMatchVectorSingSing = null;
                Object patternMatchVectorSingPlur = null;
                Object patternMatchVectorPlurSing = null;
                Object patternMatchVectorPlurPlur = null;
                mirado = this.abrirPuertaConLlave(this.habitacionActual.itemsInRoom, this.inventory);
                if (!mirado) {
                    mirado = this.abrirPuertaConLlave(this.inventory, this.inventory);
                }
                if (!mirado) {
                    int i;
                    Item ourItem;
                    if (this.habitacionActual.itemsInRoom != null && !this.habitacionActual.itemsInRoom.isEmpty()) {
                        patternMatchVectorSing = new Vector();
                        patternMatchVectorPlur = new Vector();
                        if (this.habitacionActual.itemsInRoom != null) {
                            patternMatchVectorSing = this.habitacionActual.itemsInRoom.patternMatch(this.arguments, false);
                            patternMatchVectorPlur = this.habitacionActual.itemsInRoom.patternMatch(this.arguments, true);
                        }
                        if (patternMatchVectorSing.size() > 0) {
                            ourItem = (Item)patternMatchVectorSing.elementAt(0);
                            this.write(this.io.getColorCode("action") + ((Item)patternMatchVectorSing.elementAt(0)).abrir() + this.io.getColorCode("reset") + "\n");
                            this.habitacionActual.reportAction(this, ourItem, null, "$1 intenta abrir $2.\n", "$1 intenta abrirte.\n", "Intentas abrir $2.\n", false);
                            mirado = true;
                        } else if (patternMatchVectorPlur.size() > 0) {
                            mirado = true;
                            for (i = 0; i < patternMatchVectorPlur.size(); ++i) {
                                ourItem = (Item)patternMatchVectorPlur.elementAt(i);
                                this.write(this.mundo.getMessages().getMessage("you.try.open.from.floor", "$item", ourItem.constructName2True(1, this), new Object[]{this, this.arguments}));
                                this.habitacionActual.reportAction(this, ourItem, null, "$1 intenta abrir $2.\n", "$1 intenta abrirte.\n", "Intentas abrir $2.\n", false);
                                this.write(this.io.getColorCode("action") + ourItem.abrir() + this.io.getColorCode("reset") + "\n");
                            }
                        }
                    }
                    if (this.inventory != null && !this.inventory.isEmpty()) {
                        patternMatchVectorSing = new Vector();
                        patternMatchVectorPlur = new Vector();
                        if (this.inventory != null) {
                            patternMatchVectorSing = this.inventory.patternMatch(this.arguments, false);
                            patternMatchVectorPlur = this.inventory.patternMatch(this.arguments, true);
                        }
                        if (patternMatchVectorSing.size() > 0) {
                            ourItem = (Item)patternMatchVectorSing.elementAt(0);
                            mirado = true;
                            this.habitacionActual.reportAction(this, ourItem, null, "$1 intenta abrir $2.\n", "$1 intenta abrirte.\n", "Intentas abrir $2.\n", false);
                            this.write(this.io.getColorCode("action") + ((Item)patternMatchVectorSing.elementAt(0)).abrir() + this.io.getColorCode("reset") + "\n");
                        } else if (patternMatchVectorPlur.size() > 0) {
                            mirado = true;
                            for (i = 0; i < patternMatchVectorPlur.size(); ++i) {
                                ourItem = (Item)patternMatchVectorPlur.elementAt(i);
                                this.write(this.mundo.getMessages().getMessage("you.try.open.from.inventory", "$item", ourItem.constructName2True(1, this), new Object[]{this, this.arguments}));
                                this.habitacionActual.reportAction(this, ourItem, null, "$1 intenta abrir $2 que lleva.\n", "$1 intenta abrirte.\n", "Intentas abrir $2 que llevas.\n", false);
                                this.write(this.io.getColorCode("action") + ourItem.abrir() + this.io.getColorCode("reset") + "\n");
                            }
                        }
                    }
                }
                if (!mirado) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("open.what", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.cancelPending();
                    return false;
                }
                this.ZR_verbo = this.command;
                this.setNewState(1, 1L);
                return true;
            }
            if (this.command.equalsIgnoreCase("cerrar")) {
                boolean mirado = false;
                mirado = this.cerrarPuertaConLlave(this.habitacionActual.itemsInRoom, this.inventory);
                if (!mirado) {
                    mirado = this.cerrarPuertaConLlave(this.inventory, this.inventory);
                }
                if (!mirado) {
                    int i;
                    Item ourItem;
                    if (this.habitacionActual.itemsInRoom != null && !this.habitacionActual.itemsInRoom.isEmpty()) {
                        patternMatchVectorSing = new Vector();
                        patternMatchVectorPlur = new Vector();
                        if (this.habitacionActual.itemsInRoom != null) {
                            patternMatchVectorSing = this.habitacionActual.itemsInRoom.patternMatch(this.arguments, false);
                            patternMatchVectorPlur = this.habitacionActual.itemsInRoom.patternMatch(this.arguments, true);
                        }
                        if (patternMatchVectorSing.size() > 0) {
                            ourItem = (Item)patternMatchVectorSing.elementAt(0);
                            this.write(this.io.getColorCode("action") + ((Item)patternMatchVectorSing.elementAt(0)).cerrar() + this.io.getColorCode("reset") + "\n");
                            this.habitacionActual.reportAction(this, ourItem, null, "$1 intenta cerrar $2.\n", "$1 intenta cerrarte.\n", "Intentas cerrar $2.\n", false);
                            mirado = true;
                        } else if (patternMatchVectorPlur.size() > 0) {
                            mirado = true;
                            for (i = 0; i < patternMatchVectorPlur.size(); ++i) {
                                ourItem = (Item)patternMatchVectorPlur.elementAt(i);
                                this.write(this.mundo.getMessages().getMessage("you.try.close.from.floor", "$item", ourItem.constructName2True(1, this), new Object[]{this, this.arguments}));
                                this.habitacionActual.reportAction(this, ourItem, null, "$1 intenta cerrar $2.\n", "$1 intenta cerrarte.\n", "Intentas cerrar $2.\n", false);
                                this.write(this.io.getColorCode("action") + ourItem.cerrar() + this.io.getColorCode("reset") + "\n");
                            }
                        }
                    }
                    if (this.inventory != null && !this.inventory.isEmpty()) {
                        patternMatchVectorSing = new Vector();
                        patternMatchVectorPlur = new Vector();
                        if (this.inventory != null) {
                            patternMatchVectorSing = this.inventory.patternMatch(this.arguments, false);
                            patternMatchVectorPlur = this.inventory.patternMatch(this.arguments, true);
                        }
                        if (patternMatchVectorSing.size() > 0) {
                            mirado = true;
                            this.write(this.io.getColorCode("action") + ((Item)patternMatchVectorSing.elementAt(0)).cerrar() + this.io.getColorCode("reset") + "\n");
                        } else if (patternMatchVectorPlur.size() > 0) {
                            mirado = true;
                            for (i = 0; i < patternMatchVectorPlur.size(); ++i) {
                                ourItem = (Item)patternMatchVectorPlur.elementAt(i);
                                if (ourItem.constructName2(1, this).equals("")) continue;
                                this.write(this.mundo.getMessages().getMessage("you.try.close.from.inventory", "$item", ourItem.constructName2True(1, this), new Object[]{this, this.arguments}));
                                this.habitacionActual.reportAction(this, ourItem, null, "$1 intenta cerrar $2 que lleva.\n", "$1 intenta cerrarte.\n", "Intentas cerrar $2 que llevas.\n", false);
                                this.write(this.io.getColorCode("action") + ourItem.cerrar() + this.io.getColorCode("reset") + "\n");
                            }
                        }
                    }
                }
                if (!mirado) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("close.what", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.cancelPending();
                    return false;
                }
                this.ZR_verbo = this.command;
                this.setNewState(1, 1L);
                return true;
            }
            if (this.command.equalsIgnoreCase("poner") || this.command.equalsIgnoreCase("meter")) {
                boolean mirado = false;
                if (this.command.equalsIgnoreCase("poner") && ParserMethods.refersToEntity(this.arguments, this, false)) {
                    if (!this.oneTargetAction("wear", this.arguments, this.inventory)) {
                        this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("wear.what", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                        this.ZR_verbo = this.command;
                        this.cancelPending();
                        return false;
                    }
                    this.ZR_verbo = this.command;
                    return true;
                }
                if (!(mirado || this.habitacionActual.itemsInRoom == null || this.habitacionActual.itemsInRoom.isEmpty() || this.inventory == null || this.inventory.isEmpty())) {
                    mirado = this.putInside(this.inventory, this.habitacionActual.itemsInRoom, this.arguments);
                }
                if (!mirado && this.inventory != null && !this.inventory.isEmpty()) {
                    mirado = this.putInside(this.inventory, this.inventory, this.arguments);
                }
                if (!mirado) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("put.what.where", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.cancelPending();
                    return false;
                }
                this.ZR_verbo = this.command;
                return true;
            }
            if (this.command.equalsIgnoreCase("coger")) {
                boolean mirado = false;
                if (ParserMethods.refersToEntity(this.arguments, this, false)) {
                    if (!this.oneTargetAction("unwear", this.arguments, this.getWornItems())) {
                        this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("unwear.what", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                        this.ZR_verbo = this.command;
                        this.cancelPending();
                        return false;
                    }
                    this.ZR_verbo = this.command;
                    return true;
                }
                if (!mirado) {
                    mirado = this.cogerContenidoEspecificandoContenedor(this.arguments, this.habitacionActual.itemsInRoom, "");
                }
                if (!mirado) {
                    mirado = this.cogerItem(this.habitacionActual.itemsInRoom, null);
                }
                if (!mirado) {
                    mirado = this.cogerContenido(this.habitacionActual.itemsInRoom, "");
                }
                if (!mirado) {
                    mirado = this.cogerContenidoEspecificandoContenedor(this.arguments, this.inventory, "");
                }
                if (!mirado) {
                    mirado = this.cogerContenido(this.inventory, "");
                }
                if (mirado) {
                    this.setNewState(1, 1L);
                    this.ZR_verbo = this.command;
                    return true;
                }
                this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("get.what", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                this.ZR_verbo = this.command;
                this.cancelPending();
                return false;
            }
            if (this.command.equalsIgnoreCase("dejar")) {
                if (!this.oneTargetAction("drop", this.arguments, this.inventory)) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("drop.what", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.cancelPending();
                    return false;
                }
            } else {
                if (this.command.equalsIgnoreCase("inventario") && this.arguments.trim().length() < 1) {
                    this.showInventory();
                    this.setNewState(1, 1L);
                    this.ZR_verbo = this.command;
                    return true;
                }
                if (this.command.equalsIgnoreCase("hechizos") && this.arguments.trim().length() < 1) {
                    if (this.spellRefs != null) {
                        this.write(this.io.getColorCode("information") + "Hechizos conocidos:\n" + this.io.getColorCode("reset"));
                        for (int i = 0; i < this.spellRefs.size(); ++i) {
                            Spell current = (Spell)this.spellRefs.get(i);
                            this.write(this.io.getColorCode("information") + current.getTitle() + this.io.getColorCode("reset") + "\n");
                        }
                    } else {
                        this.write(this.io.getColorCode("information") + "No sabes hacer magia.\n");
                    }
                    this.setNewState(1, 1L);
                    this.ZR_verbo = this.command;
                    return true;
                }
                if (this.command.equalsIgnoreCase("suicidar") || this.command.equalsIgnoreCase("suicidarse")) {
                    this.suicide();
                    return true;
                }
                if (this.command.equalsIgnoreCase("desvestir")) {
                    if (!this.oneTargetAction("unwear", this.arguments, this.getWornItems())) {
                        this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("unwear.what", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                        this.ZR_verbo = this.command;
                        this.cancelPending();
                        return false;
                    }
                } else if (this.command.equalsIgnoreCase("vestir")) {
                    if (!this.oneTargetAction("wear", this.arguments, this.inventory)) {
                        this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("wear.what", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                        this.ZR_verbo = this.command;
                        this.cancelPending();
                        return false;
                    }
                } else if (this.command.equalsIgnoreCase("blandir")) {
                    if (!this.oneTargetAction("wield", this.arguments, this.inventory)) {
                        this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("wield.what", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                        this.ZR_verbo = this.command;
                        this.cancelPending();
                        return false;
                    }
                } else if (this.command.equalsIgnoreCase("enfundar")) {
                    if (!this.oneTargetAction("unwield", this.arguments, this.wieldedWeapons)) {
                        this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("unwield.what", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                        this.ZR_verbo = this.command;
                        this.cancelPending();
                        return false;
                    }
                } else {
                    if (this.command.equalsIgnoreCase("decir")) {
                        this.comandoDecir(this.arguments);
                        this.setNewState(1, 1L);
                        this.ZR_verbo = this.command;
                        return true;
                    }
                    if (this.command.equalsIgnoreCase("salir")) {
                        System.exit(0);
                    } else {
                        if (this.command.equalsIgnoreCase("esperar")) {
                            if (StringMethods.numToks(commandstring, ' ') < 2) {
                                this.setNewState(1, 1L);
                                this.ZR_verbo = this.command;
                                return true;
                            }
                            int nsecs = 1;
                            try {
                                nsecs = Integer.valueOf(this.arguments);
                            }
                            catch (NumberFormatException nfe) {
                                // empty catch block
                            }
                            this.setNewState(1, nsecs);
                            this.ZR_verbo = this.command;
                            return true;
                        }
                        if (this.command.equalsIgnoreCase("hablar")) {
                            this.escribirDenegacionComando(this.io.getColorCode("denial") + "La mejor forma de hablar es decir algo.\n" + this.io.getColorCode("reset"));
                            this.ZR_verbo = this.command;
                            this.cancelPending();
                            return false;
                        }
                        if (this.command.equalsIgnoreCase("salvar") || this.command.equalsIgnoreCase("save") || this.command.equalsIgnoreCase("cargar") || this.command.equalsIgnoreCase("load") || this.command.equalsIgnoreCase("grabar") || this.command.equalsIgnoreCase("restaurar")) {
                            this.escribirDenegacionComando(this.io.getColorCode("error") + "De momento, las opciones de salvar y cargar no est\u00e1n disponibles por texto en este interfaz. Puedes usar los men\u00fas para ello.\n" + this.io.getColorCode("reset"));
                            this.cancelPending();
                            return false;
                        }
                        if (this.command.equalsIgnoreCase("invocar") || this.command.equalsIgnoreCase("convocar") || this.command.equalsIgnoreCase("hacer") || this.command.equalsIgnoreCase("realizar") || this.command.equalsIgnoreCase("usar") || this.command.equalsIgnoreCase("utilizar") || this.command.equalsIgnoreCase("crear") || this.command.equalsIgnoreCase("ejecutar") || this.command.equalsIgnoreCase("pronunciar") || this.command.equalsIgnoreCase("conjurar")) {
                            int i;
                            boolean mirado = false;
                            EntityList possibleSpellTargets = new EntityList();
                            for (i = 0; i < this.habitacionActual.mobsInRoom.size(); ++i) {
                                possibleSpellTargets.addEntity(this.habitacionActual.mobsInRoom.elementAt(i));
                            }
                            for (i = 0; i < this.inventory.size(); ++i) {
                                possibleSpellTargets.addEntity(this.inventory.elementAt(i));
                            }
                            for (i = 0; i < this.habitacionActual.getInventory().size(); ++i) {
                                possibleSpellTargets.addEntity(this.habitacionActual.getInventory().elementAt(i));
                            }
                            mirado = this.hacerHechizo(possibleSpellTargets, this.getSpells());
                            if (!mirado) {
                                this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("cast.no.spell", new Object[]{this, this.arguments}) + this.io.getColorCode("reset"));
                                this.ZR_verbo = this.command;
                                this.cancelPending();
                                return false;
                            }
                            this.ZR_verbo = this.command;
                            return true;
                        }
                        if (this.lenguaje.isVerb(this.command, true)) {
                            String origCommand = "";
                            if (originalTrimmedCommandString != null) {
                                origCommand = StringMethods.getTok(originalTrimmedCommandString, 1, ' ').trim();
                            }
                            if (!(origCommand.endsWith("me") || origCommand.endsWith("te") || origCommand.endsWith("se"))) {
                                this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("undefined.action", "$command", commandstring, new Object[]{this, commandstring}) + this.io.getColorCode("reset"));
                            } else {
                                this.escribirDenegacionComando(this.io.getColorCode("denial") + this.mundo.getMessages().getMessage("undefined.action", "$command", originalTrimmedCommandString, new Object[]{this, originalTrimmedCommandString}) + this.io.getColorCode("reset"));
                            }
                            this.ZR_verbo = this.command;
                            this.cancelPending();
                            return false;
                        }
                        if (!this.commandQueue.isEmpty() && ParserMethods.refersToEntityIn(this.command, this.getAllWorldMobiles(), false).size() > 0) {
                            String whatToSay = ((String)this.commandQueue.elementAt(0)).trim();
                            this.commandQueue.removeElementAt(0);
                            Mobile whomToSayItTo = (Mobile)ParserMethods.refersToEntityIn(this.command, this.getAllWorldMobiles(), false).get(0);
                            return this.execCommand("decir a " + whomToSayItTo.getBestReferenceName(false) + "\"" + whatToSay + "\"");
                        }
                        if (!this.ZR_verbo.equalsIgnoreCase(this.command) && this.lenguaje.isGuessable(this.ZR_verbo)) {
                            this.secondChance = true;
                            return this.execCommand(this.ZR_verbo + " " + commandstring);
                        }
                        this.escribirErrorNoEntiendo();
                    }
                }
            }
        }
        if (!actionName.equals("")) {
            return this.executeAction(actionName, actionArgs);
        }
        return false;
    }

    public void die() {
        super.die();
        this.setRoom(this.mundo.getLimbo());
    }

    public void changeState(World mundo) {
        Debug.println("Player state " + this.getState() + ", target " + this.getTarget() + ", tu's " + this.getPropertyTimeLeft("state"));
        try {
            this.characterChangeState(mundo);
        }
        catch (IOException nopuidorl) {
            this.write(this.io.getColorCode("error") + "Excepci\u00f3n E/S en characterChangeState()" + this.io.getColorCode("reset"));
        }
    }

    public void characterChangeState(World mundo) throws IOException {
        switch (this.getState()) {
            case 1: {
                break;
            }
            case 2: {
                if (this.movingState_Path != null) {
                    this.write(this.io.getColorCode("action") + this.movingState_Path.getDescription(this) + "\n" + this.io.getColorCode("reset"));
                }
                try {
                    this.habitacionActual.execCode("event_exitroom", "this: " + this.habitacionActual.getID() + "\n" + "player: " + this.getID() + "\n" + "dest: " + this.getTarget());
                    this.habitacionActual.execCode("onExitRoom", new Object[]{this});
                }
                catch (EVASemanticException exc) {
                    this.write(this.io.getColorCode("error") + "EVASemanticException found at event_exitroom , room number " + this.habitacionActual.getID() + this.io.getColorCode("reset"));
                }
                catch (TargetError bshte) {
                    this.write(this.io.getColorCode("error") + "bsh.TargetError found onExitRoom , room number " + this.habitacionActual.getID() + ": " + (Object)((Object)bshte) + this.io.getColorCode("reset"));
                    this.writeError(ExceptionPrinter.getExceptionReport(bshte));
                }
                this.habitacionActual.reportAction(this, null, "$1 se va hacia " + this.exitname + ".\n", null, null, false);
                this.setRoom(mundo.getRoom(this.getTarget()));
                this.habitacionActual.reportAction(this, null, "$1 llega desde " + Path.invert(this.exitname) + ".\n", null, null, false);
                try {
                    this.habitacionActual.execCode("event_enterroom", "this: " + this.habitacionActual.getID() + "\n" + "player: " + this.getID() + "\n" + "orig: " + this.habitacionAnterior);
                    this.habitacionActual.execCode("onEnterRoom", new Object[]{this});
                }
                catch (EVASemanticException exc) {
                    this.write(this.io.getColorCode("error") + "EVASemanticException found at event_enterroom , room number " + this.habitacionActual.getID() + this.io.getColorCode("reset"));
                }
                catch (TargetError bshte) {
                    this.write(this.io.getColorCode("error") + "bsh.TargetError found onEnterRoom , room number " + this.habitacionActual.getID() + ": " + (Object)((Object)bshte) + this.io.getColorCode("reset"));
                    this.writeError(ExceptionPrinter.getExceptionReport(bshte));
                }
                MobileList ml = this.habitacionActual.getMobiles();
                if (ml != null) {
                    for (int i = 0; i < ml.size(); ++i) {
                        Mobile bichoActual = ml.elementAt(i);
                        try {
                            bichoActual.execCode("onEnterRoom", new Object[]{this});
                            continue;
                        }
                        catch (TargetError bshte) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found onEnterRoom , mobile number " + bichoActual.getID() + ": " + (Object)((Object)bshte) + "\n" + bshte.getMessage() + this.io.getColorCode("reset"));
                            this.writeError(ExceptionPrinter.getExceptionReport(bshte));
                            bshte.printStackTrace();
                        }
                    }
                }
                if (this.getPropertyValueAsBoolean("describeRoomsOnArrival")) {
                    this.show_room(mundo);
                }
                this.setNewState(1, 0L);
                break;
            }
            case 3: {
                this.manageEndOfAttackState();
                return;
            }
            case 16: {
                this.manageEndOfCastState();
                return;
            }
            case 8: {
                this.write("Te recuperas de tu movimiento de ataque.\n");
                this.setNewState(1, 0L);
                this.showCombatReport();
                break;
            }
            case 10: {
                this.write("Te recuperas del golpe recibido.\n");
                this.setNewState(1, 0L);
                this.showCombatReport();
                break;
            }
            case 9: {
                this.write("Te recuperas de tu movimiento defensivo.\n");
                this.setNewState(1, 0L);
                this.showCombatReport();
                break;
            }
            case 14: {
                this.setNewState(1, 0L);
                this.showCombatReport();
                break;
            }
            case 4: {
                this.write("Est\u00e1s preparado para bloquear...\n");
                this.setNewState(5, 0L);
                return;
            }
            case 6: {
                this.setNewState(7, 0L);
                return;
            }
            case 5: {
                this.setNewState(5, 0L);
                return;
            }
            case 7: {
                this.setNewState(7, 0L);
                return;
            }
            case 12: {
                this.die();
                break;
            }
            case 13: {
                this.setNewState(1, 1L);
                return;
            }
            case 15: {
                this.setNewState(15, 1L);
                return;
            }
        }
        if (!this.execCommand(mundo)) {
            this.setNewState(1, 1L);
        }
    }

    public boolean resolveParseCommandForTwoEntities(EntityList posiblesObjetivos, String arguments, String fullArguments, boolean onWorld) {
        boolean ejecutado = false;
        List matches_ss = ParserMethods.parseReferencesToEntitiesInRecursive(arguments, posiblesObjetivos, posiblesObjetivos, false, false);
        List matches_sp = ParserMethods.parseReferencesToEntitiesInRecursive(arguments, posiblesObjetivos, posiblesObjetivos, false, true);
        List matches_ps = ParserMethods.parseReferencesToEntitiesInRecursive(arguments, posiblesObjetivos, posiblesObjetivos, true, false);
        List matches_pp = ParserMethods.parseReferencesToEntitiesInRecursive(arguments, posiblesObjetivos, posiblesObjetivos, true, true);
        ArrayList allMatches = new ArrayList();
        allMatches.addAll(matches_ss);
        allMatches.addAll(matches_sp);
        allMatches.addAll(matches_ps);
        allMatches.addAll(matches_pp);
        this.matchedTwoEntitiesPermissive = allMatches.size() > 0;
        for (int i = 0; i < allMatches.size(); ++i) {
            SentenceInfo si = (SentenceInfo)allMatches.get(i);
            String args1 = si.getArgs1();
            String args2 = si.getArgs2();
            Entity obj1 = si.getObj1();
            Entity obj2 = si.getObj2();
            List path1 = si.getPath1();
            List path2 = si.getPath2();
            for (int ip1 = path1.size() - 1; ip1 >= 0; --ip1) {
                for (int jp1 = path2.size() - 1; jp1 >= 0; --jp1) {
                    Entity currentObject1 = (Entity)path1.get(ip1);
                    Entity currentObject2 = (Entity)path2.get(jp1);
                    if (!onWorld && currentObject1 instanceof SupportingCode) {
                        try {
                            ejecutado = ejecutado || ((SupportingCode)((Object)currentObject1)).execCode("parseCommandOnContentsObj1", new Object[]{this, this.command, args1, args2, path1, path2, currentObject2});
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandOnContentsObj1(), command was " + this.command + fullArguments + ", entity " + currentObject1 + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                            this.writeError(ExceptionPrinter.getExceptionReport(te));
                        }
                        if (!ejecutado) {
                            try {
                                ejecutado = ejecutado || ((SupportingCode)((Object)currentObject1)).execCode("parseCommandOnContentsTwoObjects", new Object[]{this, this.command, args1, args2, path1, path2, currentObject2});
                            }
                            catch (TargetError te) {
                                this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandOnContentsTwoObjects(), command was " + this.command + fullArguments + ", entity " + currentObject1 + ", second object was " + currentObject2 + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                                this.writeError(ExceptionPrinter.getExceptionReport(te));
                            }
                        }
                        if (!ejecutado) {
                            try {
                                ejecutado = ejecutado || ((SupportingCode)((Object)currentObject1)).execCode("parseCommandOnContentsGeneric", new Object[]{this, this.command, args1, args2, path1, path2, currentObject1, currentObject2, new Boolean(true)});
                            }
                            catch (TargetError te) {
                                this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandOnContentsGeneric(), command was " + this.command + fullArguments + ", entity " + currentObject1 + ", second object was " + currentObject2 + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                                this.writeError(ExceptionPrinter.getExceptionReport(te));
                            }
                        }
                    }
                    if (!onWorld && currentObject2 instanceof SupportingCode) {
                        try {
                            ejecutado = ejecutado || ((SupportingCode)((Object)currentObject2)).execCode("parseCommandOnContentsObj2", new Object[]{this, this.command, args1, args2, path1, path2, currentObject1});
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandOnContentsObj2(), command was " + this.command + fullArguments + ", entity " + currentObject2 + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                            this.writeError(ExceptionPrinter.getExceptionReport(te));
                        }
                        if (!ejecutado) {
                            try {
                                ejecutado = ejecutado || ((SupportingCode)((Object)currentObject2)).execCode("parseCommandOnContentsTwoObjects", new Object[]{this, this.command, args1, args2, path1, path2, currentObject1});
                            }
                            catch (TargetError te) {
                                this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandOnContentsTwoObjects(), command was " + this.command + fullArguments + ", entity " + currentObject1 + ", second object was " + currentObject2 + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                                this.writeError(ExceptionPrinter.getExceptionReport(te));
                            }
                        }
                        if (!ejecutado) {
                            try {
                                ejecutado = ejecutado || ((SupportingCode)((Object)currentObject2)).execCode("parseCommandOnContentsGeneric", new Object[]{this, this.command, args1, args2, path1, path2, currentObject1, currentObject2, new Boolean(false)});
                            }
                            catch (TargetError te) {
                                this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandOnContentsGeneric(), command was " + this.command + fullArguments + ", first object was " + currentObject1 + ", second object was " + currentObject2 + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                                this.writeError(ExceptionPrinter.getExceptionReport(te));
                            }
                        }
                    }
                    if (!onWorld) continue;
                    if (!ejecutado) {
                        try {
                            ejecutado = ejecutado || this.mundo.execCode("parseCommandOnContentsTwoObjects", new Object[]{this, this.command, args1, args2, path1, path2, currentObject1, currentObject2});
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandOnContentsTwoObjects() executed from world, command was " + this.command + fullArguments + ", entity " + currentObject1 + ", second object was " + currentObject2 + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                            this.writeError(ExceptionPrinter.getExceptionReport(te));
                        }
                    }
                    if (ejecutado) continue;
                    try {
                        ejecutado = ejecutado || this.mundo.execCode("parseCommandOnContentsGeneric", new Object[]{this, this.command, args1, args2, path1, path2, currentObject1, currentObject2});
                        continue;
                    }
                    catch (TargetError te) {
                        this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandOnContentsGeneric() executed from world, command was " + this.command + fullArguments + ", first object was " + currentObject1 + ", second object was " + currentObject2 + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                        this.writeError(ExceptionPrinter.getExceptionReport(te));
                    }
                }
            }
            if (path1.size() == 1 && path2.size() == 1 || this.getPropertyValueAsBoolean("containedItemsInScope")) {
                if (!onWorld && obj1 instanceof SupportingCode) {
                    if (!ejecutado) {
                        try {
                            ejecutado = ejecutado || ((SupportingCode)((Object)obj1)).execCode("parseCommandObj1", new Object[]{this, this.command, args1, args2, obj2});
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandObj1(), command was " + this.command + args1 + args2 + ", entity number " + obj1.getID() + ", second object was " + obj2.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                            this.writeError(ExceptionPrinter.getExceptionReport(te));
                        }
                    }
                    if (!ejecutado) {
                        try {
                            ejecutado = ejecutado || ((SupportingCode)((Object)obj1)).execCode("parseCommandTwoObjects", new Object[]{this, this.command, args1, args2, obj2});
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandTwoObjects(), command was " + this.command + args1 + args2 + ", entity number " + obj1.getID() + ", second object was " + obj2.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                            this.writeError(ExceptionPrinter.getExceptionReport(te));
                        }
                    }
                    if (!ejecutado) {
                        try {
                            ejecutado = ejecutado || ((SupportingCode)((Object)obj1)).execCode("parseCommandGeneric", new Object[]{this, this.command, args1, args2, obj1, obj2, new Boolean(true)});
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandGeneric(), command was " + this.command + args1 + args2 + ", entity number " + obj1 + ", second object was " + obj2 + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                            this.writeError(ExceptionPrinter.getExceptionReport(te));
                        }
                    }
                }
                if (ejecutado) {
                    this.setNewState(1, 1L);
                    this.ZR_verbo = this.command;
                    return true;
                }
                if (!onWorld && obj2 instanceof SupportingCode) {
                    if (!ejecutado) {
                        try {
                            ejecutado = ejecutado || ((SupportingCode)((Object)obj2)).execCode("parseCommandObj2", new Object[]{this, this.command, args1, args2, obj1});
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandObj2(), command was " + this.command + args1 + args2 + ", entity number " + obj2.getID() + ", first object was " + obj1.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                            this.writeError(ExceptionPrinter.getExceptionReport(te));
                        }
                    }
                    if (!ejecutado) {
                        try {
                            ejecutado = ejecutado || ((SupportingCode)((Object)obj2)).execCode("parseCommandTwoObjects", new Object[]{this, this.command, args1, args2, obj1});
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandTwoObjects(), command was " + this.command + args1 + args2 + ", entity number " + obj2.getID() + ", first object was " + obj1.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                            this.writeError(ExceptionPrinter.getExceptionReport(te));
                        }
                    }
                    if (!ejecutado) {
                        try {
                            ejecutado = ejecutado || ((SupportingCode)((Object)obj2)).execCode("parseCommandGeneric", new Object[]{this, this.command, args1, args2, obj1, obj2, new Boolean(false)});
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandGeneric(), command was " + this.command + args1 + args2 + ", entity number " + obj1 + ", second object was " + obj2 + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                            this.writeError(ExceptionPrinter.getExceptionReport(te));
                        }
                    }
                }
                if (onWorld) {
                    if (!ejecutado) {
                        try {
                            ejecutado = ejecutado || this.mundo.execCode("parseCommandTwoObjects", new Object[]{this, this.command, args1, args2, obj1, obj2});
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandTwoObjects() executed from world, command was " + this.command + args1 + args2 + ", entity number " + obj2.getID() + ", first object was " + obj1.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                            this.writeError(ExceptionPrinter.getExceptionReport(te));
                        }
                    }
                    if (!ejecutado) {
                        try {
                            ejecutado = ejecutado || this.mundo.execCode("parseCommandGeneric", new Object[]{this, this.command, args1, args2, obj1, obj2});
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandGeneric() executed from world, command was " + this.command + args1 + args2 + ", entity number " + obj1 + ", second object was " + obj2 + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                            this.writeError(ExceptionPrinter.getExceptionReport(te));
                        }
                    }
                }
            }
            if (!ejecutado) continue;
            this.setNewState(1, 1L);
            this.ZR_verbo = this.command;
            return true;
        }
        return false;
    }

    public boolean resolveParseCommandForOneComponent(EntityList posiblesObjetivos, String arguments) {
        boolean ejecutado = false;
        for (int i = 0; i < posiblesObjetivos.size() && !ejecutado; ++i) {
            Entity currentEntity = posiblesObjetivos.get(i);
            if (ejecutado || !(currentEntity instanceof Room && ((Room)currentEntity).getExtraDescription(arguments, this) != null || currentEntity instanceof Item && ((Item)currentEntity).getExtraDescription(arguments, this) != null) && (!(currentEntity instanceof Mobile) || ((Mobile)currentEntity).getExtraDescription(arguments, this) == null)) continue;
            try {
                ejecutado = ejecutado || ((SupportingCode)((Object)currentEntity)).execCode("parseCommandOnComponent", new Object[]{this, this.command, arguments});
                continue;
            }
            catch (TargetError te) {
                this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandOnComponent(), command was " + this.command + arguments + ", entity " + currentEntity + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                this.writeError(ExceptionPrinter.getExceptionReport(te));
            }
        }
        if (ejecutado) {
            this.setNewState(1, 1L);
            this.ZR_verbo = this.command;
        }
        return ejecutado;
    }

    public boolean resolveParseCommandForOneEntity(EntityList posiblesObjetivos, String arguments, String fullArguments, boolean onWorld) {
        boolean ejecutado = false;
        Vector objetivos_s = ParserMethods.refersToEntityInRecursive(arguments, posiblesObjetivos, false);
        Vector objetivos_p = ParserMethods.refersToEntityInRecursive(arguments, posiblesObjetivos, true);
        boolean bl = this.matchedOneEntityPermissive = objetivos_s.size() + objetivos_p.size() > 0;
        if (objetivos_s.size() > 0) {
            Vector objetivoVector = (Vector)objetivos_s.get(0);
            for (int i = objetivoVector.size() - 1; i >= 0; --i) {
                Entity currentObject = (Entity)objetivoVector.get(i);
                if (!onWorld && currentObject instanceof SupportingCode) {
                    try {
                        ejecutado = ejecutado || ((SupportingCode)((Object)currentObject)).execCode("parseCommandOnContents", new Object[]{this, this.command, fullArguments, objetivoVector});
                    }
                    catch (TargetError te) {
                        this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandOnContents(), command was " + this.command + fullArguments + ", entity " + currentObject + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                        this.writeError(ExceptionPrinter.getExceptionReport(te));
                    }
                    if (!ejecutado) {
                        try {
                            ejecutado = ejecutado || ((SupportingCode)((Object)currentObject)).execCode("parseCommandOnContentsGeneric", new Object[]{this, this.command, fullArguments, "", objetivoVector, null, currentObject, null, new Boolean(true)});
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandOnContentsGeneric(), command was " + this.command + fullArguments + ", entity number " + currentObject + ", second object was " + null + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                            this.writeError(ExceptionPrinter.getExceptionReport(te));
                        }
                    }
                }
                if (!onWorld) continue;
                try {
                    ejecutado = ejecutado || this.mundo.execCode("parseCommandOnContents", new Object[]{this, this.command, fullArguments, objetivoVector, currentObject});
                }
                catch (TargetError te) {
                    this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandOnContents() executed from world, command was " + this.command + fullArguments + ", entity " + currentObject + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                    this.writeError(ExceptionPrinter.getExceptionReport(te));
                }
                if (ejecutado) continue;
                try {
                    ejecutado = ejecutado || this.mundo.execCode("parseCommandOnContentsGeneric", new Object[]{this, this.command, fullArguments, "", objetivoVector, null, currentObject, null});
                    continue;
                }
                catch (TargetError te) {
                    this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandOnContentsGeneric() executed from world, command was " + this.command + fullArguments + ", entity number " + currentObject + ", second object was " + null + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                    this.writeError(ExceptionPrinter.getExceptionReport(te));
                }
            }
            Entity objetivo = (Entity)objetivoVector.get(0);
            if (objetivo instanceof Item) {
                this.meterObjetoEnZRSingular((Item)objetivo);
            }
            for (int i = 0; i <= StringMethods.numToks(arguments, ' ') && !ejecutado; ++i) {
                if (!(objetivo instanceof Item)) continue;
                Item ourItem = (Item)objetivo;
                try {
                    if (i == 0) {
                        ejecutado = ejecutado || ourItem.execCode("command_" + this.command, "this: " + ourItem.getID() + "\n" + "room: " + this.habitacionActual.getID() + "\n" + "location: inventory" + "\n" + "player: " + this.getID());
                        continue;
                    }
                    ejecutado = ejecutado || ourItem.execCode(("command_" + this.command + "_" + StringMethods.getToks(arguments, 1, i, ' ')).replace(' ', '_'), "this: " + ourItem.getID() + "\n" + "room: " + this.habitacionActual.getID() + "\n" + "location: inventory" + "\n" + "player: " + this.getID());
                    continue;
                }
                catch (EVASemanticException exc) {
                    this.write(this.io.getColorCode("error") + "EVASemanticException found at command " + (this.command + StringMethods.getToks(arguments, 1, i, ' ')).replace(' ', '_') + ", item number " + ourItem.getID() + this.io.getColorCode("reset"));
                }
            }
            if (!onWorld && objetivo instanceof SupportingCode && (objetivoVector.size() == 1 || this.getPropertyValueAsBoolean("containedItemsInScope"))) {
                if (!ejecutado) {
                    try {
                        ejecutado = ejecutado || ((SupportingCode)((Object)objetivo)).execCode("parseCommand", new Object[]{this, this.command, fullArguments});
                    }
                    catch (TargetError te) {
                        this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommand(), command was " + this.command + fullArguments + ", item number " + objetivo.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                        this.writeError(ExceptionPrinter.getExceptionReport(te));
                    }
                }
                if (!ejecutado) {
                    try {
                        ejecutado = ejecutado || ((SupportingCode)((Object)objetivo)).execCode("parseCommandGeneric", new Object[]{this, this.command, fullArguments, "", objetivo, null, new Boolean(true)});
                    }
                    catch (TargetError te) {
                        this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandGeneric(), command was " + this.command + fullArguments + ", entity number " + objetivo + ", second object was " + objetivo + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                        this.writeError(ExceptionPrinter.getExceptionReport(te));
                    }
                }
            }
            if (onWorld) {
                if (!ejecutado) {
                    try {
                        ejecutado = ejecutado || this.mundo.execCode("parseCommand", new Object[]{this, this.command, fullArguments, objetivo});
                    }
                    catch (TargetError te) {
                        this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommand() executed from world, command was " + this.command + fullArguments + ", item number " + objetivo.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                        this.writeError(ExceptionPrinter.getExceptionReport(te));
                    }
                }
                if (!ejecutado) {
                    try {
                        ejecutado = ejecutado || this.mundo.execCode("parseCommandGeneric", new Object[]{this, this.command, fullArguments, "", objetivo, null});
                    }
                    catch (TargetError te) {
                        this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandGeneric() executed from world, command was " + this.command + fullArguments + ", entity number " + objetivo + ", second object was " + objetivo + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                        this.writeError(ExceptionPrinter.getExceptionReport(te));
                    }
                }
            }
            if (ejecutado) {
                this.setNewState(1, 1L);
                this.ZR_verbo = this.command;
                return true;
            }
        } else if (objetivos_p.size() > 0) {
            this.resetZRPlural();
            for (int w = 0; w < objetivos_p.size(); ++w) {
                Entity objetivo;
                Vector objetivoVector = (Vector)objetivos_p.get(w);
                if (objetivoVector.size() > 1) {
                    for (int i = objetivoVector.size() - 1; i >= 0; --i) {
                        Entity currentObject = (Entity)objetivoVector.get(i);
                        if (!onWorld && currentObject instanceof SupportingCode) {
                            if (!ejecutado) {
                                try {
                                    ejecutado = ejecutado || ((SupportingCode)((Object)currentObject)).execCode("parseCommandOnContents", new Object[]{this, this.command, fullArguments, objetivoVector});
                                }
                                catch (TargetError te) {
                                    this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandOnContents(), command was " + this.command + fullArguments + ", entity " + currentObject + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                                    this.writeError(ExceptionPrinter.getExceptionReport(te));
                                }
                            }
                            if (!ejecutado) {
                                try {
                                    ejecutado = ejecutado || ((SupportingCode)((Object)currentObject)).execCode("parseCommandOnContentsGeneric", new Object[]{this, this.command, fullArguments, "", objetivoVector, null, currentObject, null, new Boolean(true)});
                                }
                                catch (TargetError te) {
                                    this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandOnContentsGeneric(), command was " + this.command + fullArguments + ", entity number " + currentObject + ", second object was " + null + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                                    this.writeError(ExceptionPrinter.getExceptionReport(te));
                                }
                            }
                        }
                        if (!onWorld) continue;
                        if (!ejecutado) {
                            try {
                                ejecutado = ejecutado || this.mundo.execCode("parseCommandOnContents", new Object[]{this, this.command, fullArguments, objetivoVector, currentObject});
                            }
                            catch (TargetError te) {
                                this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandOnContents() executed from world, command was " + this.command + fullArguments + ", entity " + currentObject + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                                this.writeError(ExceptionPrinter.getExceptionReport(te));
                            }
                        }
                        if (ejecutado) continue;
                        try {
                            ejecutado = ejecutado || this.mundo.execCode("parseCommandOnContentsGeneric", new Object[]{this, this.command, fullArguments, "", objetivoVector, null, currentObject, null});
                            continue;
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandOnContentsGeneric() executed from world, command was " + this.command + fullArguments + ", entity number " + currentObject + ", second object was " + null + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                            this.writeError(ExceptionPrinter.getExceptionReport(te));
                        }
                    }
                }
                if ((objetivo = (Entity)objetivoVector.get(0)) instanceof Item) {
                    this.meterObjetoEnZRPlural((Item)objetivo);
                }
                for (int j = 0; j <= StringMethods.numToks(arguments, ' ') && !ejecutado; ++j) {
                    if (!(objetivo instanceof Item)) continue;
                    Item ourItem = (Item)objetivo;
                    try {
                        if (j == 0) {
                            ejecutado = ejecutado || ourItem.execCode("command_" + this.command, "this: " + ourItem.getID() + "\n" + "room: " + this.habitacionActual.getID() + "\n" + "location: inventory" + "\n" + "player: " + this.getID());
                            continue;
                        }
                        ejecutado = ejecutado || ourItem.execCode(("command_" + this.command + "_" + StringMethods.getToks(arguments, 1, j, ' ')).replace(' ', '_'), "this: " + ourItem.getID() + "\n" + "room: " + this.habitacionActual.getID() + "\n" + "location: inventory" + "\n" + "player: " + this.getID());
                        continue;
                    }
                    catch (EVASemanticException exc) {
                        this.write(this.io.getColorCode("error") + "EVASemanticException found at command " + (this.command + StringMethods.getToks(arguments, 1, j, ' ')).replace(' ', '_') + ", item number " + ourItem.getID() + this.io.getColorCode("reset"));
                    }
                }
                if (!onWorld && objetivo instanceof SupportingCode) {
                    if (!ejecutado) {
                        try {
                            ejecutado = ejecutado || ((SupportingCode)((Object)objetivo)).execCode("parseCommand", new Object[]{this, this.command, fullArguments});
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommand(), command was " + this.command + fullArguments + ", item number " + objetivo.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                            this.writeError(ExceptionPrinter.getExceptionReport(te));
                        }
                    }
                    if (!ejecutado) {
                        try {
                            ejecutado = ejecutado || ((SupportingCode)((Object)objetivo)).execCode("parseCommandGeneric", new Object[]{this, this.command, fullArguments, "", objetivo, null, new Boolean(true)});
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandGeneric(), command was " + this.command + fullArguments + ", entity number " + objetivo + ", second object was " + objetivo + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                            this.writeError(ExceptionPrinter.getExceptionReport(te));
                        }
                    }
                }
                if (!onWorld || ejecutado) continue;
                try {
                    ejecutado = ejecutado || this.mundo.execCode("parseCommand", new Object[]{this, this.command, fullArguments, objetivo});
                    continue;
                }
                catch (TargetError te) {
                    this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommand() executed from world, command was " + this.command + fullArguments + ", item number " + objetivo.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                    this.writeError(ExceptionPrinter.getExceptionReport(te));
                }
            }
            if (ejecutado) {
                this.setNewState(1, 1L);
                this.ZR_verbo = this.command;
                return true;
            }
        }
        return false;
    }

    public boolean resolveParseCommandForOneEntity_old(EntityList posiblesObjetivos, String arguments, String fullArguments) {
        boolean ejecutado = false;
        Vector objetivos_s = ParserMethods.refersToEntityIn(arguments, posiblesObjetivos, false);
        Vector objetivos_p = ParserMethods.refersToEntityIn(arguments, posiblesObjetivos, true);
        if (objetivos_s.size() > 0) {
            Entity objetivo = (Entity)objetivos_s.get(0);
            if (objetivo instanceof Item) {
                this.meterObjetoEnZRSingular((Item)objetivo);
            }
            for (int i = 0; i <= StringMethods.numToks(arguments, ' ') && !ejecutado; ++i) {
                if (!(objetivo instanceof Item)) continue;
                Item ourItem = (Item)objetivo;
                try {
                    if (i == 0) {
                        ejecutado = ejecutado || ourItem.execCode("command_" + this.command, "this: " + ourItem.getID() + "\n" + "room: " + this.habitacionActual.getID() + "\n" + "location: inventory" + "\n" + "player: " + this.getID());
                        continue;
                    }
                    ejecutado = ejecutado || ourItem.execCode(("command_" + this.command + "_" + StringMethods.getToks(arguments, 1, i, ' ')).replace(' ', '_'), "this: " + ourItem.getID() + "\n" + "room: " + this.habitacionActual.getID() + "\n" + "location: inventory" + "\n" + "player: " + this.getID());
                    continue;
                }
                catch (EVASemanticException exc) {
                    this.write(this.io.getColorCode("error") + "EVASemanticException found at command " + (this.command + StringMethods.getToks(arguments, 1, i, ' ')).replace(' ', '_') + ", item number " + ourItem.getID() + this.io.getColorCode("reset"));
                }
            }
            if (objetivo instanceof SupportingCode) {
                try {
                    ejecutado = ejecutado || ((SupportingCode)((Object)objetivo)).execCode("parseCommand", new Object[]{this, this.command, fullArguments});
                }
                catch (TargetError te) {
                    this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommand(), command was " + this.command + fullArguments + ", item number " + objetivo.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                    this.writeError(ExceptionPrinter.getExceptionReport(te));
                }
                if (!ejecutado) {
                    try {
                        ejecutado = ejecutado || ((SupportingCode)((Object)objetivo)).execCode("parseCommandGeneric", new Object[]{this, this.command, fullArguments, "", objetivo, null, new Boolean(true)});
                    }
                    catch (TargetError te) {
                        this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandGeneric(), command was " + this.command + fullArguments + ", entity number " + objetivo + ", second object was " + objetivo + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                        this.writeError(ExceptionPrinter.getExceptionReport(te));
                    }
                }
            }
            if (ejecutado) {
                this.setNewState(1, 1L);
                this.ZR_verbo = this.command;
                return true;
            }
        } else if (objetivos_p.size() > 0) {
            this.resetZRPlural();
            for (int i = 0; i < objetivos_p.size(); ++i) {
                Entity objetivo = (Entity)objetivos_p.get(i);
                if (objetivo instanceof Item) {
                    this.meterObjetoEnZRPlural((Item)objetivo);
                }
                for (int j = 0; j <= StringMethods.numToks(arguments, ' ') && !ejecutado; ++j) {
                    if (!(objetivo instanceof Item)) continue;
                    Item ourItem = (Item)objetivo;
                    try {
                        if (j == 0) {
                            ejecutado = ejecutado || ourItem.execCode("command_" + this.command, "this: " + ourItem.getID() + "\n" + "room: " + this.habitacionActual.getID() + "\n" + "location: inventory" + "\n" + "player: " + this.getID());
                            continue;
                        }
                        ejecutado = ejecutado || ourItem.execCode(("command_" + this.command + "_" + StringMethods.getToks(arguments, 1, i, ' ')).replace(' ', '_'), "this: " + ourItem.getID() + "\n" + "room: " + this.habitacionActual.getID() + "\n" + "location: inventory" + "\n" + "player: " + this.getID());
                        continue;
                    }
                    catch (EVASemanticException exc) {
                        this.write(this.io.getColorCode("error") + "EVASemanticException found at command " + (this.command + StringMethods.getToks(arguments, 1, i, ' ')).replace(' ', '_') + ", item number " + ourItem.getID() + this.io.getColorCode("reset"));
                    }
                }
                if (!(objetivo instanceof SupportingCode)) continue;
                try {
                    ejecutado = ejecutado || ((SupportingCode)((Object)objetivo)).execCode("parseCommand", new Object[]{this, this.command, fullArguments});
                }
                catch (TargetError te) {
                    this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommand(), command was " + this.command + fullArguments + ", item number " + objetivo.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                    this.writeError(ExceptionPrinter.getExceptionReport(te));
                }
                if (ejecutado) continue;
                try {
                    ejecutado = ejecutado || ((SupportingCode)((Object)objetivo)).execCode("parseCommandGeneric", new Object[]{this, this.command, fullArguments, "", objetivo, null, new Boolean(true)});
                    continue;
                }
                catch (TargetError te) {
                    this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommandGeneric(), command was " + this.command + fullArguments + ", entity number " + objetivo + ", second object was " + objetivo + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                    this.writeError(ExceptionPrinter.getExceptionReport(te));
                }
            }
            if (ejecutado) {
                this.setNewState(1, 1L);
                this.ZR_verbo = this.command;
                return true;
            }
        }
        return false;
    }

    public void showCombatReport() {
        if (this.getEnemies() == null) {
            return;
        }
        for (int i = 0; i < this.getEnemies().size(); ++i) {
            Mobile enemigo = this.getEnemies().elementAt(i);
            if (enemigo.getState() != 3 || enemigo.getTarget() != this.getID()) continue;
            long tiempo = enemigo.getPropertyTimeLeft("state");
            int nSimulations = this.getStat("INT");
            this.wieldedWeapons = this.getWieldedWeapons();
            for (int j = 0; j < this.wieldedWeapons.size(); ++j) {
                Weapon w = (Weapon)this.wieldedWeapons.elementAt(j);
                if (w == null) continue;
                int blocksInTime = 0;
                for (int s = 0; s < nSimulations; ++s) {
                    int t = this.generateBlockTime(w);
                    if ((long)t > tiempo) continue;
                    ++blocksInTime;
                }
                double inTimeProb = (double)blocksInTime / (double)nSimulations;
                if (inTimeProb >= 0.9) {
                    String string = "Seguramente te dar\u00eda tiempo a bloquear el golpe de $2 con " + w.constructName2OneItem(this) + ".";
                }
                String toInform = inTimeProb >= 0.7 ? "Crees que te dar\u00eda tiempo a bloquear el golpe de $2 con " + w.constructName2OneItem(this) + "." : (inTimeProb >= 0.5 ? "Es posible que te d\u00e9 tiempo a bloquear el golpe de $2 con " + w.constructName2OneItem(this) + "." : (inTimeProb >= 0.3 ? "Ser\u00e1 bastante dif\u00edcil bloquear a tiempo el golpe de $2 con " + w.constructName2OneItem(this) + "." : (inTimeProb >= 0.1 ? "Ser\u00e1 muy dif\u00edcil bloquear a tiempo el golpe de $2 con " + w.constructName2OneItem(this) + "." : "No crees que puedas bloquear a tiempo el golpe de $2 con " + w.constructName2OneItem(this) + ".")));
                this.habitacionActual.reportAction(this, enemigo, null, null, toInform + "\n", true);
            }
            int dodgesInTime = 0;
            for (int s = 0; s < nSimulations; ++s) {
                int t = this.generateDodgeTime();
                if ((long)t > tiempo) continue;
                ++dodgesInTime;
            }
            double dodgeInTimeProb = (double)dodgesInTime / (double)nSimulations;
            String toInform = dodgeInTimeProb >= 0.8 ? "Seguramente podr\u00edas esquivar el ataque de $2 a tiempo." : (dodgeInTimeProb >= 0.6 ? "Probablemente podr\u00edas esquivar a tiempo el ataque de $2." : (dodgeInTimeProb >= 0.4 ? enemigo.getCurrentWeapon().constructName2OneItem(this) + " de $2 est\u00e1 cerca, ser\u00e1 dif\u00edcil esquivar su ataque." : (dodgeInTimeProb >= 0.2 ? enemigo.getCurrentWeapon().constructName2OneItem(this) + " de $2 est\u00e1 casi encima , ser\u00e1 muy dif\u00edcil esquivar su ataque." : enemigo.getCurrentWeapon().constructName2OneItem(this) + " de $2 est\u00e1 encima, no crees que puedas esquivar el ataque.")));
            this.habitacionActual.reportAction(this, enemigo, null, null, toInform + "\n", true);
        }
    }

    public void show_room(World mundo) {
        long comparand = (long)this.getRelationshipState(this.habitacionActual) * (long)Math.pow(2.0, 32.0) + (long)this.habitacionActual.getState();
        this.write(this.io.getColorCode("description") + this.habitacionActual.getDescription(this) + this.io.getColorCode("reset") + "\n");
        try {
            this.habitacionActual.execCode("event_showroom", "this: " + this.habitacionActual.getID() + "\n" + "player: " + this.getID() + "\n" + "orig: " + this.habitacionAnterior);
            this.habitacionActual.execCode("onShowRoom", new Object[]{this});
        }
        catch (EVASemanticException exc) {
            this.write(this.io.getColorCode("error") + "EVASemanticException found at event_showroom , room number " + this.habitacionActual.getID() + this.io.getColorCode("reset"));
        }
        catch (TargetError bshte) {
            this.write(this.io.getColorCode("error") + "bsh.TargetError found onShowRoom , room number " + this.habitacionActual.getID() + ": " + (Object)((Object)bshte) + this.io.getColorCode("reset"));
            this.writeError(ExceptionPrinter.getExceptionReport(bshte));
        }
    }

    public synchronized void waitKeyPress() {
        if (!this.from_log) {
            GameEngineThread gte;
            Thread th = Thread.currentThread();
            if (th instanceof GameEngineThread && (gte = (GameEngineThread)th).isRealTimeEnabled() && this.mundo.getPlayerList().size() > 1) {
                this.io.write("--\n");
                return;
            }
            Debug.println("WKP Call: " + this.io.getClass());
            this.io.waitKeyPress();
        }
    }

    public void borrarPantalla() {
        this.clearScreen();
    }

    public void clearScreen() {
        this.io.clearScreen();
    }

    public void escribir(String s) {
        this.write(s);
    }

    public void write(String s) {
        this.io.write(s);
    }

    public void setIO(InputOutputClient es) {
        this.io = es;
    }

    public void meterObjetoEnZRSingular(Item obj) {
        if (obj.getGender()) {
            this.ZR_objeto_masculino_singular = obj.getBestReferenceName(false);
        } else {
            this.ZR_objeto_femenino_singular = obj.getBestReferenceName(false);
        }
        this.ZR_objeto_singular = obj.getBestReferenceName(false);
    }

    public void resetZRPlural() {
        this.ZR_objeto_masculino_plural = "";
        this.ZR_objeto_femenino_plural = "";
        this.ZR_objeto_plural = "";
    }

    public void meterObjetoEnZRPlural(Item obj) {
        if (obj.getGender()) {
            if (!this.ZR_objeto_masculino_plural.equals("")) {
                this.ZR_objeto_masculino_plural = this.ZR_objeto_masculino_plural + ", ";
            }
            this.ZR_objeto_masculino_plural = this.ZR_objeto_masculino_plural + obj.getBestReferenceName(true);
        } else {
            if (!this.ZR_objeto_femenino_plural.equals("")) {
                this.ZR_objeto_femenino_plural = this.ZR_objeto_femenino_plural + ", ";
            }
            this.ZR_objeto_femenino_plural = this.ZR_objeto_femenino_plural + obj.getBestReferenceName(true);
        }
        if (!this.ZR_objeto_plural.equals("")) {
            this.ZR_objeto_plural = this.ZR_objeto_plural + ", ";
        }
        this.ZR_objeto_plural = this.ZR_objeto_plural + obj.getBestReferenceName(true);
    }

    private static String firstWord(String s) {
        StringTokenizer st = new StringTokenizer(s);
        if (st.hasMoreTokens()) {
            return st.nextToken();
        }
        return "";
    }

    private static String restWords(String s) {
        StringTokenizer st = new StringTokenizer(s);
        if (!st.hasMoreTokens()) {
            return "";
        }
        st.nextToken();
        if (!st.hasMoreTokens()) {
            return "";
        }
        return st.nextToken("");
    }

    public String substitutePronouns(String command) {
        String cut;
        String thestring = command;
        boolean doneSomething = false;
        if (Player.firstWord(thestring).toLowerCase().endsWith("las") && Player.firstWord(thestring).length() > 3) {
            doneSomething = true;
            cut = Player.firstWord(thestring).substring(0, Player.firstWord(thestring).length() - 3);
            thestring = cut + " " + this.ZR_objeto_femenino_plural + " " + Player.restWords(thestring);
            doneSomething = true;
        } else if (Player.firstWord(thestring).toLowerCase().endsWith("los") && Player.firstWord(thestring).length() > 3) {
            doneSomething = true;
            cut = Player.firstWord(thestring).substring(0, Player.firstWord(thestring).length() - 3);
            thestring = cut + " " + this.ZR_objeto_plural + " " + Player.restWords(thestring);
        } else if (Player.firstWord(thestring).toLowerCase().endsWith("lo") && Player.firstWord(thestring).length() > 2) {
            doneSomething = true;
            cut = Player.firstWord(thestring).substring(0, Player.firstWord(thestring).length() - 2);
            thestring = cut + " " + this.ZR_objeto_masculino_singular + " " + Player.restWords(thestring);
        } else if (Player.firstWord(thestring).toLowerCase().endsWith("la") && Player.firstWord(thestring).length() > 2) {
            doneSomething = true;
            cut = Player.firstWord(thestring).substring(0, Player.firstWord(thestring).length() - 2);
            thestring = cut + " " + this.ZR_objeto_femenino_singular + " " + Player.restWords(thestring);
        }
        if ((Player.firstWord(thestring).toLowerCase().endsWith("me") || Player.firstWord(thestring).toLowerCase().endsWith("te") || Player.firstWord(thestring).toLowerCase().endsWith("se")) && !Player.firstWord(thestring).toLowerCase().endsWith("este") && !Player.firstWord(thestring).toLowerCase().endsWith("norte")) {
            doneSomething = true;
            cut = Player.firstWord(thestring).substring(0, Player.firstWord(thestring).length() - 2);
            String playerRefName = this.getBestReferenceName(false);
            if (playerRefName == null) {
                this.writeError("Error in player " + this + ": cannot apply pronoun substitution to \"" + Player.firstWord(thestring) + "\" because player has no reference name. Add a singular reference name to fix this.\n");
                return command;
            }
            thestring = cut + " " + playerRefName + " " + Player.restWords(thestring);
        }
        if (!doneSomething) {
            return command;
        }
        StringTokenizer st = new StringTokenizer(thestring.toLowerCase());
        String newVerb = st.nextToken().trim();
        String unaccentedVerb = this.lenguaje.removeAccents(newVerb);
        return unaccentedVerb + st.nextToken("");
    }

    public String substitutePronounsIfVerb(String command) {
        String correctedVerbWithoutPronouns;
        StringTokenizer st = new StringTokenizer(command);
        String origVerb = st.nextToken();
        String newCommand = this.substitutePronouns(command);
        newCommand = newCommand.trim();
        st = new StringTokenizer(newCommand);
        String uncorrectedVerbWithoutPronouns = st.nextToken();
        if (!this.getPropertyValueAsBoolean("noVerbSpellChecking")) {
            newCommand = this.lenguaje.correctVerb(newCommand);
        }
        if (!this.lenguaje.isVerb(correctedVerbWithoutPronouns = (st = new StringTokenizer(newCommand)).nextToken())) {
            return command;
        }
        if (this.lenguaje.isVerb(correctedVerbWithoutPronouns) && !this.lenguaje.isVerb(uncorrectedVerbWithoutPronouns) && !uncorrectedVerbWithoutPronouns.equals(origVerb)) {
            return command;
        }
        return newCommand;
    }

    public boolean separateSentences() {
        Vector tokensYSeparadores = StringMethods.tokenizeWithComplexSeparators(this.commandstring, StringMethods.STANDARD_SENTENCE_SEPARATORS(), true);
        Vector<String> tempCommandQueue = new Vector<String>();
        int nComillas = 0;
        String acum = "";
        for (int i = 0; i < tokensYSeparadores.size(); ++i) {
            String cur = (String)tokensYSeparadores.elementAt(i);
            acum = acum + cur;
            for (int k = 0; k < cur.length(); ++k) {
                if (cur.charAt(k) != '\"') continue;
                ++nComillas;
            }
            if (!StringMethods.STANDARD_SENTENCE_SEPARATORS().contains(cur)) {
                if (nComillas % 2 != 0 && i != tokensYSeparadores.size() - 1) continue;
                tempCommandQueue.add(acum);
                Debug.println("ADDED: " + acum);
                acum = "";
                continue;
            }
            if (nComillas % 2 != 0) continue;
            acum = "";
        }
        tempCommandQueue.addAll(this.commandQueue);
        this.commandQueue = (Vector)tempCommandQueue.clone();
        if (this.commandQueue.isEmpty()) {
            return false;
        }
        this.commandstring = (String)this.commandQueue.elementAt(0);
        this.commandQueue.removeElementAt(0);
        return true;
    }

    public String substitutePronounsInSentence(String commandstring) {
        StringTokenizer st = new StringTokenizer(commandstring);
        String originalVerb = st.nextToken();
        String expandedVerb = this.substitutePronouns(originalVerb);
        String expandedVerbWithoutPronoun = Player.firstWord(expandedVerb);
        String expandedString = expandedVerb + " " + Player.restWords(commandstring);
        String workingString = !this.lenguaje.isVerb(originalVerb) && this.lenguaje.isVerb(Player.firstWord(expandedVerbWithoutPronoun)) ? expandedString : commandstring;
        if (!this.getPropertyValueAsBoolean("noVerbSpellChecking")) {
            return this.mundo.getSpellChecker().correctCommandString(workingString);
        }
        return workingString;
    }

    private boolean abrirPuertaConLlave(Inventory i1, Inventory i2) {
        boolean mirado = false;
        List[] pairsVector = this.patternMatchPairs(i1, i2, this.arguments);
        List puertas = pairsVector[0];
        List llaves = pairsVector[1];
        if (puertas.size() == 0) {
            return false;
        }
        for (int i = 0; i < puertas.size(); ++i) {
            Item ourDoor = (Item)puertas.get(i);
            Item ourKey = (Item)llaves.get(i);
            this.habitacionActual.reportAction(this, ourDoor, new Entity[]{ourKey}, "$1 intenta abrir $2 con $3.\n", "$1 intenta abrirte con $3.\n", "Intentas abrir $2 con $3.\n", false);
            this.write(this.io.getColorCode("action") + ourDoor.unlock(ourKey) + this.io.getColorCode("reset") + "\n");
        }
        return true;
    }

    private boolean bloquearBichoConArma(MobileList ml, Inventory i) {
        if (i == null || i.isEmpty() || ml == null || ml.isEmpty()) {
            return false;
        }
        boolean mirado = false;
        Vector[] patternMatchVectorSingSing = ml.patternMatchTwo(i, this.arguments, false, false);
        Vector[] patternMatchVectorSingPlur = ml.patternMatchTwo(i, this.arguments, false, true);
        Vector[] patternMatchVectorPlurSing = ml.patternMatchTwo(i, this.arguments, true, false);
        Vector[] patternMatchVectorPlurPlur = ml.patternMatchTwo(i, this.arguments, true, true);
        if (patternMatchVectorSingSing != null && patternMatchVectorSingSing[0].size() > 0) {
            mirado = true;
            Vector[] theVectors = patternMatchVectorSingSing;
            Mobile objetivo = (Mobile)theVectors[0].elementAt(0);
            if (!this.hasEnemy(objetivo)) {
                return false;
            }
            this.lastBlockWeapon = (Weapon)theVectors[1].elementAt(0);
            this.lastBlockedEnemy = objetivo;
            this.block(objetivo, (Weapon)theVectors[1].elementAt(0));
        } else {
            Vector patternMatchVectorSingBicho = ml.patternMatch(this.arguments, false);
            Vector patternMatchVectorSingArma = i.patternMatch(this.arguments, false);
            if (patternMatchVectorSingBicho != null && patternMatchVectorSingBicho.size() > 0) {
                Mobile objetivo = (Mobile)patternMatchVectorSingBicho.elementAt(0);
                Weapon usada = null;
                if (this.lastAttackWeapon != null && this.wieldedWeapons.contains(this.lastAttackWeapon)) {
                    usada = this.lastAttackWeapon;
                } else if (this.wieldedWeapons != null && this.wieldedWeapons.size() > 0) {
                    usada = (Weapon)this.wieldedWeapons.elementAt(0);
                }
                if (usada == null) {
                    mirado = false;
                } else {
                    mirado = true;
                    if (!this.hasEnemy(objetivo)) {
                        return false;
                    }
                    this.lastBlockWeapon = usada;
                    this.lastBlockedEnemy = objetivo;
                    this.block(objetivo, usada);
                }
            } else if (patternMatchVectorSingArma != null && patternMatchVectorSingArma.size() > 0) {
                Mobile objetivo = null;
                Weapon usada = (Weapon)patternMatchVectorSingArma.elementAt(0);
                if (this.lastAttackedEnemy != null && this.habitacionActual.hasMobile(this.lastAttackedEnemy)) {
                    objetivo = this.lastAttackedEnemy;
                }
                if (objetivo == null) {
                    mirado = false;
                } else {
                    mirado = true;
                    if (!this.hasEnemy(objetivo)) {
                        return false;
                    }
                    this.lastBlockWeapon = usada;
                    this.lastBlockedEnemy = objetivo;
                    this.block(objetivo, usada);
                }
            } else {
                Mobile objetivo = null;
                Weapon usada = null;
                if (this.lastAttackWeapon != null && this.wieldedWeapons.contains(this.lastAttackWeapon)) {
                    usada = this.lastAttackWeapon;
                } else if (this.wieldedWeapons != null && this.wieldedWeapons.size() > 0) {
                    usada = (Weapon)this.wieldedWeapons.elementAt(0);
                }
                if (this.lastAttackedEnemy != null && this.habitacionActual.hasMobile(this.lastAttackedEnemy)) {
                    objetivo = this.lastAttackedEnemy;
                }
                if (objetivo == null || usada == null) {
                    mirado = false;
                } else {
                    mirado = true;
                    if (!this.hasEnemy(objetivo)) {
                        return false;
                    }
                    this.lastBlockWeapon = usada;
                    this.lastBlockedEnemy = objetivo;
                    this.block(objetivo, usada);
                }
            }
        }
        return mirado;
    }

    private boolean atacarBichoConArma(MobileList ml, Inventory i) {
        if (i == null || i.isEmpty() || ml == null || ml.isEmpty()) {
            return false;
        }
        boolean mirado = false;
        Vector[] patternMatchVectorSingSing = ml.patternMatchTwo(i, this.arguments, false, false);
        Vector[] patternMatchVectorSingPlur = ml.patternMatchTwo(i, this.arguments, false, true);
        Vector[] patternMatchVectorPlurSing = ml.patternMatchTwo(i, this.arguments, true, false);
        Vector[] patternMatchVectorPlurPlur = ml.patternMatchTwo(i, this.arguments, true, true);
        if (patternMatchVectorSingSing != null && patternMatchVectorSingSing[0].size() > 0) {
            mirado = true;
            Vector[] theVectors = patternMatchVectorSingSing;
            Mobile objetivo = (Mobile)theVectors[0].elementAt(0);
            if (!this.hasEnemy(objetivo)) {
                this.addEnemy(objetivo);
            }
            if (!objetivo.hasEnemy(this)) {
                objetivo.addEnemy(this);
            }
            this.lastAttackWeapon = (Weapon)theVectors[1].elementAt(0);
            this.lastAttackedEnemy = objetivo;
            this.attack(objetivo, (Weapon)theVectors[1].elementAt(0));
        } else {
            Vector patternMatchVectorSingBicho = ml.patternMatch(this.arguments, false);
            Vector patternMatchVectorSingArma = i.patternMatch(this.arguments, false);
            if (patternMatchVectorSingBicho != null && patternMatchVectorSingBicho.size() > 0) {
                Mobile objetivo = (Mobile)patternMatchVectorSingBicho.elementAt(0);
                Weapon usada = null;
                Debug.println("Wielded Weapons Size " + this.wieldedWeapons.size());
                Inventory usableWeapons = this.getUsableWeapons();
                if (this.lastAttackWeapon != null && usableWeapons.contains(this.lastAttackWeapon)) {
                    usada = this.lastAttackWeapon;
                } else if (usableWeapons != null && usableWeapons.size() > 0) {
                    Debug.println("Setting first weapon as used");
                    for (int k = usableWeapons.size() - 1; k >= 0; --k) {
                        if (usableWeapons.elementAt(k) == null) continue;
                        usada = (Weapon)usableWeapons.elementAt(k);
                    }
                }
                if (usada == null) {
                    mirado = false;
                } else {
                    mirado = true;
                    if (!this.hasEnemy(objetivo)) {
                        this.addEnemy(objetivo);
                    }
                    if (!objetivo.hasEnemy(this)) {
                        objetivo.addEnemy(this);
                    }
                    this.lastAttackWeapon = usada;
                    this.lastAttackedEnemy = objetivo;
                    this.attack(objetivo, usada);
                }
            } else if (patternMatchVectorSingArma != null && patternMatchVectorSingArma.size() > 0) {
                Mobile objetivo = null;
                Weapon usada = (Weapon)patternMatchVectorSingArma.elementAt(0);
                if (this.lastAttackedEnemy != null && this.habitacionActual.hasMobile(this.lastAttackedEnemy)) {
                    objetivo = this.lastAttackedEnemy;
                } else if (this.getEnemies() != null && this.getEnemies().size() > 0 && this.habitacionActual.hasMobile(this.getEnemies().elementAt(0))) {
                    objetivo = this.getEnemies().elementAt(0);
                }
                if (objetivo == null) {
                    mirado = false;
                } else {
                    mirado = true;
                    if (!this.hasEnemy(objetivo)) {
                        this.addEnemy(objetivo);
                    }
                    if (!objetivo.hasEnemy(this)) {
                        objetivo.addEnemy(this);
                    }
                    this.lastAttackWeapon = usada;
                    this.lastAttackedEnemy = objetivo;
                    this.attack(objetivo, usada);
                }
            } else {
                Mobile objetivo = null;
                Weapon usada = null;
                Inventory usableWeapons = this.getUsableWeapons();
                if (this.lastAttackWeapon != null && usableWeapons.contains(this.lastAttackWeapon)) {
                    usada = this.lastAttackWeapon;
                } else if (usableWeapons != null && usableWeapons.size() > 0) {
                    for (int k = usableWeapons.size() - 1; k >= 0; --k) {
                        if (usableWeapons.elementAt(k) == null) continue;
                        usada = (Weapon)usableWeapons.elementAt(k);
                    }
                }
                if (this.lastAttackedEnemy != null && this.habitacionActual.hasMobile(this.lastAttackedEnemy)) {
                    objetivo = this.lastAttackedEnemy;
                } else if (this.getEnemies() != null && this.getEnemies().size() > 0 && this.habitacionActual.hasMobile(this.getEnemies().elementAt(0))) {
                    objetivo = this.getEnemies().elementAt(0);
                }
                if (objetivo == null || usada == null) {
                    mirado = false;
                } else {
                    mirado = true;
                    if (!this.hasEnemy(objetivo)) {
                        this.addEnemy(objetivo);
                    }
                    if (!objetivo.hasEnemy(this)) {
                        objetivo.addEnemy(this);
                    }
                    this.lastAttackWeapon = usada;
                    this.lastAttackedEnemy = objetivo;
                    this.attack(objetivo, usada);
                }
            }
        }
        return mirado;
    }

    private boolean cerrarPuertaConLlave(Inventory i1, Inventory i2) {
        boolean mirado = false;
        List[] pairsVector = this.patternMatchPairs(i1, i2, this.arguments);
        List puertas = pairsVector[0];
        List llaves = pairsVector[1];
        if (puertas.size() == 0) {
            return false;
        }
        for (int i = 0; i < puertas.size(); ++i) {
            Item ourDoor = (Item)puertas.get(i);
            Item ourKey = (Item)llaves.get(i);
            this.habitacionActual.reportAction(this, ourDoor, new Entity[]{ourKey}, "$1 intenta cerrar $2 con $3.\n", "$1 intenta cerrarte con $3.\n", "Intentas cerrar $2 con $3.\n", false);
            this.write(this.io.getColorCode("action") + ourDoor.lock(ourKey) + this.io.getColorCode("reset") + "\n");
        }
        return true;
    }

    private boolean cogerContenidoEspecificandoContenedor(String args, Inventory inv, String infoString) {
        boolean mirado = false;
        Vector patternMatchVectorSing = null;
        if (inv != null && !inv.isEmpty() && (patternMatchVectorSing = inv.patternMatch(args, false)) != null && patternMatchVectorSing.size() > 0) {
            for (int i = 0; i < patternMatchVectorSing.size(); ++i) {
                Item ourContainer = (Item)patternMatchVectorSing.elementAt(i);
                if (!ourContainer.isContainer() || ourContainer.isCloseable() && !ourContainer.isOpen()) continue;
                int ntokens = StringMethods.numToks(args, ' ');
                for (int punto_division = ntokens - 1; punto_division >= 1; --punto_division) {
                    boolean bl = mirado = mirado || this.cogerItem(StringMethods.getToks(args, 1, punto_division, ' '), ourContainer.getContents(), " de " + ourContainer.constructName2True(1, this) + infoString);
                    if (mirado) break;
                }
                if (mirado) break;
            }
        }
        return mirado;
    }

    private boolean cogerContenido(String args, Inventory inv, String infoString) {
        String tempstring;
        int i;
        boolean mirado = false;
        if (inv == null || inv.isEmpty()) {
            return false;
        }
        for (i = 0; i < inv.size(); ++i) {
            if (!inv.elementAt(i).isContainer() || inv.elementAt(i).isCloseable() && !inv.elementAt(i).isOpen()) continue;
            tempstring = infoString;
            infoString = infoString + " en ";
            infoString = infoString + inv.elementAt(i).constructName2True(1, this);
            mirado = this.cogerItem(args, inv.elementAt(i).getContents(), infoString);
            if (mirado) break;
            infoString = tempstring;
        }
        if (!mirado) {
            for (i = 0; i < inv.size(); ++i) {
                if (!inv.elementAt(i).isContainer() || inv.elementAt(i).isCloseable() && !inv.elementAt(i).isOpen()) continue;
                tempstring = infoString;
                infoString = infoString + " en ";
                infoString = infoString + inv.elementAt(i).constructName2True(1, this);
                mirado = this.cogerContenido(args, inv.elementAt(i).getContents(), infoString);
                if (mirado) break;
                infoString = tempstring;
            }
        }
        return mirado;
    }

    private boolean cogerContenido(Inventory inv, String infoString) {
        String tempstring;
        int i;
        boolean mirado = false;
        if (inv == null || inv.isEmpty()) {
            return false;
        }
        for (i = 0; i < inv.size(); ++i) {
            if (!inv.elementAt(i).isContainer() || inv.elementAt(i).isCloseable() && !inv.elementAt(i).isOpen()) continue;
            tempstring = infoString;
            infoString = infoString + " en ";
            infoString = infoString + inv.elementAt(i).constructName2True(1, this);
            mirado = this.cogerItem(inv.elementAt(i).getContents(), infoString);
            if (mirado) break;
            infoString = tempstring;
        }
        if (!mirado) {
            for (i = 0; i < inv.size(); ++i) {
                if (!inv.elementAt(i).isContainer() || inv.elementAt(i).isCloseable() && !inv.elementAt(i).isOpen()) continue;
                tempstring = infoString;
                infoString = infoString + " en ";
                infoString = infoString + inv.elementAt(i).constructName2True(1, this);
                mirado = this.cogerContenido(inv.elementAt(i).getContents(), infoString);
                if (mirado) break;
                infoString = tempstring;
            }
        }
        return mirado;
    }

    private boolean cogerItem(Inventory inv, String extraInfo) {
        return this.cogerItem(this.arguments, inv, extraInfo);
    }

    public InputOutputClient getIO() {
        return this.io;
    }

    public Vector getFinalCommandLog() {
        return this.finalExecutedCommandLog;
    }

    public void disconnect() {
        this.setProperty("disconnected", true);
        this.setNewState(15, 1L);
        this.setProperty("room", this.habitacionActual.getID());
        this.habitacionActual.removeMob(this);
        this.habitacionActual.reportActionAuto(this, null, "$1 desaparece en un mar de irrealidad.\n", true);
    }

    public void reconnect(InputOutputClient io) {
        if (!this.getPropertyValueAsBoolean("disconnected")) {
            this.write("Hmm. \u00bfNo est\u00e1s conectado ya?\n");
            return;
        }
        this.setProperty("disconnected", false);
        this.setNewState(1, 1L);
        Room enQueEstaba = this.mundo.getRoom(this.getPropertyValueAsInteger("room"));
        enQueEstaba.addMob(this);
        this.getIO().write("Has sido a\u00f1adido al mundo.\n");
        this.getRoom().reportActionAuto(this, null, "De repente, $1 aparece de la nada.\n", false);
        this.write("Old player rejoined the game.\n");
        this.setIO(io);
    }

    private boolean hacerHechizo(EntityList possibleTargets, SpellList possibleSpells) {
        if (possibleTargets == null || possibleTargets.isEmpty()) {
            return false;
        }
        boolean mirado = false;
        Vector[] patternMatchVectorSingSing = possibleSpells.patternMatchTwo(possibleTargets, this.arguments, false, false);
        Vector[] patternMatchVectorSingPlur = possibleSpells.patternMatchTwo(possibleTargets, this.arguments, false, true);
        Vector[] patternMatchVectorPlurSing = possibleSpells.patternMatchTwo(possibleTargets, this.arguments, true, false);
        Vector[] patternMatchVectorPlurPlur = possibleSpells.patternMatchTwo(possibleTargets, this.arguments, true, true);
        if (patternMatchVectorSingSing != null && patternMatchVectorSingSing[0].size() > 0) {
            mirado = true;
            Vector[] theVectors = patternMatchVectorSingSing;
            Entity objetivo = (Entity)theVectors[1].elementAt(0);
            this.cast((Spell)theVectors[0].elementAt(0), objetivo);
        } else {
            Vector patternMatchSpellOnly = possibleSpells.patternMatch(this.arguments, false);
            if (patternMatchSpellOnly != null && patternMatchSpellOnly.size() > 0) {
                mirado = true;
                this.cast((Spell)patternMatchSpellOnly.elementAt(0), null);
            }
        }
        return mirado;
    }

    public boolean oneTargetAction(String action, String arguments, EntityList posiblesObjetivos) {
        Vector patternMatchVectorSing = new Vector();
        Vector patternMatchVectorPlur = new Vector();
        if (posiblesObjetivos != null) {
            patternMatchVectorSing = posiblesObjetivos.patternMatch(arguments, false);
            patternMatchVectorPlur = posiblesObjetivos.patternMatch(arguments, true);
        }
        if (patternMatchVectorSing.size() > 0) {
            Entity ourEntity = (Entity)patternMatchVectorSing.elementAt(0);
            boolean hecho = this.executeAction(action, new Object[]{ourEntity});
            if (!hecho) {
                this.ZR_verbo = this.command;
                this.cancelPending();
                return true;
            }
            this.ZR_verbo = this.command;
            return true;
        }
        if (patternMatchVectorPlur.size() > 0) {
            for (int i = 0; i < patternMatchVectorPlur.size(); ++i) {
                Entity ourEntity = (Entity)patternMatchVectorPlur.elementAt(i);
                boolean hecho = this.executeAction(action, new Object[]{ourEntity});
                if (hecho) continue;
                this.ZR_verbo = this.command;
                this.cancelPending();
                return true;
            }
            this.ZR_verbo = this.command;
            return true;
        }
        this.ZR_verbo = this.command;
        this.cancelPending();
        return false;
    }
}

