/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.IrcBot;
import eu.irreality.age.IrcDccChatClientProxy;
import eu.irreality.age.IrcDccChatGameSelector;
import eu.irreality.age.IrcDccChatSocket;
import eu.irreality.age.World;
import eu.irreality.age.debug.Debug;
import eu.irreality.age.server.ServerHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;

public class IrcAgeBot
extends IrcBot {
    public IrcAgeBot(String server, int port, String nick) throws Exception {
        super(server, port, nick, "Bot del Aetheria Game Engine");
    }

    public void privateMsg(String sender, String message) {
        if (message.equalsIgnoreCase("DCC")) {
            IrcDccChatGameSelector idcsh = new IrcDccChatGameSelector();
            try {
                IrcDccChatSocket idcs = this.ircSocket.sendDccChatRequest(sender, (short)0, idcsh);
                idcs.setPriority(1);
                idcsh.setSocket(idcs);
                this.launchGame(idcsh);
            }
            catch (IOException ioe) {
                System.err.println("IO Exc.");
            }
        } else if (!(sender.equals("NiCK") | sender.equals("agenda") | sender.equals("MeMo") | sender.equalsIgnoreCase("information"))) {
            this.ircSocket.sendPrivate(sender, "Soy un servidor del Aetheria Game Engine.");
            this.ircSocket.sendPrivate(sender, "Para jugar una partida, \u00e1breme un DCC chat.");
            this.ircSocket.sendPrivate(sender, "Para m\u00e1s informaci\u00f3n, visita http://www.irreality.org/aetheria/conv.htm y http://absurdum.f2o.org/aetheria");
        }
        System.out.println(sender + ": " + message);
    }

    public void dccChatRequest(String nick, InetAddress ip, short port) {
        IrcDccChatGameSelector idcsh = new IrcDccChatGameSelector();
        try {
            IrcDccChatSocket idcs = this.ircSocket.acceptDccChatRequest(nick, ip, port, idcsh);
            idcs.setPriority(1);
            this.ircSocket.sendPrivate(nick, "Aceptando la conexi\u00f3n DCC Chat (si la conexi\u00f3n no se establece correctamente, pruebe a ponerme en privado la palabra DCC");
            idcsh.setSocket(idcs);
            this.launchGame(idcsh);
        }
        catch (Exception e) {
            this.ircSocket.sendPrivate(nick, "No se ha podido aceptar la conexi\u00f3n DCC Chat. Pruebe a poner en este privado la palabra DCC.");
        }
    }

    public void launchGame(final IrcDccChatGameSelector idcgs) {
        Thread th = new Thread(){

            public void run() {
                Debug.println("Game launchin'");
                World mundo = idcgs.getPartidaSelection(IrcAgeBot.this.getPartidasEnCurso()).getMundo();
                new IrcDccChatClientProxy(idcgs.getSocket(), mundo);
            }
        };
        th.start();
    }

    public List getPartidasEnCurso() {
        return ServerHandler.getInstance().getPartidasIrc();
    }
}

