/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.GameChoosingInternalFrame;
import eu.irreality.age.GameInfo;
import eu.irreality.age.PartidaEntry;
import eu.irreality.age.server.ServerHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;

class GameChoosingPanel
extends JPanel {
    JDesktopPane thePanel;
    JTextPane gameInfoArea = new JTextPane();
    MutableAttributeSet atributos = new SimpleAttributeSet();
    GameInfo informacionJuego = new GameInfo();

    private void updateGameInfoArea() {
        this.gameInfoArea.setText(this.informacionJuego.toLongString());
    }

    public GameChoosingPanel(JDesktopPane p, final JInternalFrame madre) {
        this.thePanel = p;
        final JList<GameInfo> lista = new JList<GameInfo>(GameInfo.getListOfGames());
        lista.setFont(new Font("Serif", 2, 24));
        lista.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                GameChoosingPanel.this.informacionJuego = (GameInfo)lista.getSelectedValue();
                GameChoosingPanel.this.updateGameInfoArea();
            }
        });
        this.setBackground(GameChoosingInternalFrame.BACKGROUND_COLOR);
        this.setLayout(new GridLayout(1, 2));
        lista.setBorder(BorderFactory.createTitledBorder("Selecciona un juego:"));
        this.add(lista);
        lista.setBackground(GameChoosingInternalFrame.BACKGROUND_COLOR);
        lista.setForeground(GameChoosingInternalFrame.FOREGROUND_COLOR);
        this.gameInfoArea.setBackground(GameChoosingInternalFrame.BACKGROUND_COLOR);
        this.gameInfoArea.setForeground(GameChoosingInternalFrame.FOREGROUND_COLOR);
        JPanel subp = new JPanel();
        JButton botonJugar = new JButton("Jugar");
        JButton botonCancelar = new JButton("Cerrar");
        subp.setLayout(new BorderLayout());
        subp.add((Component)this.gameInfoArea, "Center");
        JPanel pBotones = new JPanel();
        pBotones.add(botonJugar);
        pBotones.add(botonCancelar);
        pBotones.setBackground(GameChoosingInternalFrame.BACKGROUND_COLOR);
        pBotones.setForeground(GameChoosingInternalFrame.FOREGROUND_COLOR);
        subp.add((Component)pBotones, "South");
        this.add(subp);
        this.setVisible(true);
        botonCancelar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                madre.dispose();
            }
        });
        botonJugar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if ((GameInfo)lista.getSelectedValue() == null) {
                    return;
                }
                Thread thr = new Thread(){

                    public void run() {
                        PartidaEntry pe = new PartidaEntry((GameInfo)lista.getSelectedValue(), "noname", 200, null, ((GameChoosingInternalFrame)madre).getOptionChoosingPanel().servirAGE(), ((GameChoosingInternalFrame)madre).getOptionChoosingPanel().servirTelnet(), ((GameChoosingInternalFrame)madre).getOptionChoosingPanel().servirIRC());
                        ServerHandler.getInstance().initPartidaLocal(pe, ServerHandler.getInstance().getLogWindow(), null, null, (this).GameChoosingPanel.this.thePanel);
                    }
                };
                thr.start();
            }
        });
        lista.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    Thread thr = new Thread(){

                        public void run() {
                            PartidaEntry pe = new PartidaEntry((GameInfo)lista.getSelectedValue(), "noname", 200, null, ((GameChoosingInternalFrame)madre).getOptionChoosingPanel().servirAGE(), ((GameChoosingInternalFrame)madre).getOptionChoosingPanel().servirTelnet(), ((GameChoosingInternalFrame)madre).getOptionChoosingPanel().servirIRC());
                            ServerHandler.getInstance().initPartidaLocal(pe, ServerHandler.getInstance().getLogWindow(), null, null, (this).GameChoosingPanel.this.thePanel);
                        }
                    };
                    thr.start();
                }
            }
        });
    }
}

