/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import bsh.TargetError;
import eu.irreality.age.AbstractEntity;
import eu.irreality.age.Entity;
import eu.irreality.age.Mobile;
import eu.irreality.age.PropertyEntry;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import eu.irreality.age.debug.Debug;
import org.w3c.dom.Node;

public class Effect
extends AbstractEntity {
    public Effect(World mundo, Node n) throws XMLtoWorldException {
        this.constructAbstractEntity(mundo, n, true, "effect");
    }

    public void readEffectSpecifics(World mundo, Node n) {
    }

    public void enable(Entity caster, Entity target, int intensity, int duration) {
        if (duration == 0) {
            Debug.println("Zero duration.");
            this.cast(caster, target, intensity);
        } else {
            Debug.println("Duration is " + duration);
            this.cast(caster, target, intensity);
            if (target == null) {
                target = ((Mobile)caster).getRoom();
            }
            if (target != null) {
                target.setRelationshipProperty((Entity)this, "cast", true);
                this.setRelationshipProperty(target, "cast", true);
                target.setRelationshipPropertyTimeLeft(this, "cast", duration);
                this.setRelationshipPropertyTimeLeft(target, "cast", duration);
            }
        }
    }

    public void disable(Entity target) {
        if (target != null) {
            target.setRelationshipProperty((Entity)this, "cast", false);
            this.setRelationshipProperty(target, "cast", false);
        }
        this.fade(target);
    }

    public boolean cast(Entity caster, Entity target, int intensity) {
        boolean ejecutado = false;
        try {
            ejecutado = this.execCode("cast", new Object[]{caster, target, new Integer(intensity)});
        }
        catch (TargetError bshte) {
            // empty catch block
        }
        return ejecutado;
    }

    public boolean fade(Entity target) {
        boolean ejecutado = false;
        try {
            ejecutado = this.execCode("fade", new Object[]{target});
        }
        catch (TargetError targetError) {
            // empty catch block
        }
        return ejecutado;
    }

    public boolean fail(Entity caster, Entity target, int intensity) {
        boolean ejecutado = false;
        try {
            ejecutado = this.execCode("fail", new Object[]{caster, target});
        }
        catch (TargetError bshte) {
            // empty catch block
        }
        return ejecutado;
    }

    public boolean updateRelationship(Entity e, PropertyEntry pe, World mundo) {
        if (pe.getName().equalsIgnoreCase("cast") && pe.getValueAsBoolean()) {
            this.disable(e);
        }
        return true;
    }
}

