/*
 * Portcullis
 *
 * Vocabulary
 *
 */

var Synonyms = new Object;
NUM_SYNS = 0;

function words(string)
{
	if(string.indexOf('.')==-1)  // er... I have no idea why this should be
		string += '.' + string;  // necessary, but nothing works without it!
	
	Synonyms[++NUM_SYNS] = string.substring(0,string.indexOf('.')) +
	  '.' + string + '.';
}

// All recognised words, and their synonyms
// Names of persons, places and things need not be listed here,
// unless they have synonyms

// directions come first...
words('north.n');
words('northeast.north-east.ne');
words('northwest.north-west.nw');
words('south.s');
words('southeast.south-east.se');
words('southwest.south-west.sw');
words('east.e');
words('west.w');
words('down.d.descend.downward');
words('up.u.ascend.upstair.upward.climb');
words('out.exit.exeunt.outward.outside');
words('in.enter.inward.inside');
// ...so that we can do this
DIRECTIONS='';
for(var i=1;i<=NUM_SYNS;++i)
	DIRECTIONS+=Synonyms[i];
// all other words come now.


// added for engine v0.4
words('undo');
words('transcript');
words('terse.unverbose');
words('verbose.unterse');
words('wait.z');

words('all.everything');
words('dir');
words('it.them');
words('him');
words('her');
words('help');
words('hint');
words('score');
words('inventory.inv.invent.i.list.carrying.stuff.possession');
words('game');
words('restart.restart');
words('save');
words('load.restore');
words('delete');
words('take.get.pick.grab.lift');
words('drop.put');
words('throw.fling.chuck.lob');
words('talk.tell.chat.ask.speak.say.question');
words('give.show.present.bequeathe.offer.proffer.feed');
words('wake.awake.awaken');
words('painting.portrait.picture.canvas.rectangle.surrealist');
words('poster.propaganda');
words('hang');
words('table.desk');
words('look.l.x.lookat.lookit.looky.examine.exam.see.view.read.peruse.search.describe');
words('fight.hit.kill.smite.punch.kick.stab.attack.batter.bash.beat.duff');
words('knock');
words('loosen');
words('break.smash.destroy');
words('wear.puton.don');
words('remove.takeoff.unwear.doff.disrobe');
words('on');
words('off');
words('push.press.touch');
words('button.switch');
words('kiss.snog.smooch');
words('self.me.you.myself.yourself');

words('listen.hear');

words('start.begin');
words('make');
words('bed');
words('door.doorway.entrance');
words('gate.gateway');
words('open.unzip.unlock');
words('close.shut');
words('window');
words('lake.pond.pool');
words('stair.staircase.step.stairway.stairwell.ladder.stepladder');
words('shovel.spade');
words('pirate.buccaneer');
words('handkerchief.hanky.napkin');
words('sea.ocean');
words('water.holy.holywater.phial');
words('spill.pour');
words('jetty.pier.mooring');
words('swim.paddle');
words('sit');
words('stand');
words('sleep');
words('chair.throne.armchair.wingback');
words('boat.ship.ferry.fishing.fishingboat.fishing-boat');
words('cut.snip.chop');
words('eat.munch.chew.swallow');
words('drink.quaff.beer.ale.lager.pint.tankard.mug.foaming.booze');
words('brewing.brew.brewery.yeast');
words('jump.leap');
words('move');
words('smell.sniff.inhale.breathe');
words('chest.treasure');
words('money.zorkmid.coins.coin.groat.copper.doubloon.cash.dosh.moolah');
words('buy.purchase');
words('wall');
words('ground.floor');
words('roof.ceiling');
words('cupboard.cabinet');
words('shout.scream.yell');
words('sneeze');
words('bat.fruitbat');
words('wave.flap.shake');
words('swear.' + rot13('shpx.sneg.phag.nefr.pbpx.jnax.fuvg.fuvgr.funt.obyybpxf'));
words('themself.themselves.himself.herself.itself');
words('sign.signpost.notice.noticeboard');
words('paper.scrap.note.notepaper');
words('scroll.page');

words('huts.hut.house.shed.shack.hovel');
words('hall.townhall.cityhall');
words('inn.pub.boozer.hotel.tavern.rampart');
words('hall');
words('barrel.cask');
words('pay.bribe');
words('adventurer.professional');

words('temple.church.cathedral.kirk');
words('god.divine.theology.goddess.goddesses.deity.deities.religion.religious');

words('portcullis.town.city');

words('scorchmark.scorch.mark.burn');
words('oven.cooker.cooking.cookingrange.range.stove');
words('chef.cook.bake.fry.boil');
words('saucepan.pan.pot.frying');

words('not.don\'t.dont');

words('count');

words('stage');

words('robin.johnson');

words('minion.skeletal.skeleton.skellington.skull.undead');
words('calcaneus');
words('spear.pike');
words('zombie');
words('zapdorf.overlord.sorcerer.sorceror');

words('lara.landlady.innkeeper.landlord.barmaid');
words('maynard.merchant.stallkeeper.seller.salesman.salesperson.stallholder.marketseller');
words('stall.market');
words('helmut.mayor.burgomeister.burgomaster');
words('job.work.employment.unemployed.employed.kitchen.assistant');
words('whisky.whiskey.bottle');
words('jar.glass.powder');
words('skipper.captain.sailor.capn');
words('alchemist.chemist.alchemical.scientist.physicist');

words('ariane.elf.elven.elvish.elfin.elfish');
words('staunton.wizard.mage.magician');
words('miranda.priestess.priest.cleric');
//words('twig.thief.rogue.burglar');
words('fraf.barbarian.fighter');

words('staff.wand.magic.rod.stick');
words('spectacle.spec.glasses.lenses');

words('elves.elfland.elfkind.elvenkind');
words('human.humanity.people.mankind');
words('bow.arrow.longbow.quiver');
words('shoot.fire.twang');
words('rope.string.cord');

words('furnace.fireplace');

words('surrender.surrendered.surrendering');
words('poor.poverty.destitute');

words('chicken');
words('tomato');
words('cheese');
words('broccoli.brocolli.broccolli.brocoli.broc');
words('cabbage');
words('sugar.cube.sugarcube.sugarlump');
words('banana.nana');
words('bananaskin.bananaskin.bananapeel.peel.skin.banana-skin.banana-peel');
words('artichoke');

words('castle.palace.fortress.tower');
words('drawbridge.bridge');
words('archway.arch');
words('gargoyle.grotesque.statue.figurine.figure');
words('moat.river.stream.brook');
words('pantry.larder');
words('pyramid.triangle');
words('trip');
words('hieroglyphic.hieroglyph.rune.glyph');
words('gem.jewel.gemstone.stone');
words('white.diamond');
words('red.ruby');
words('green.emerald');
words('blue.sapphire');
words('purple.violet.magenta.amethyst');

words('pull.yank.tug');
words('lever');

words('dwarf.dwarves.dwarven.dwarfish.dwarvish.gnome.gnomish');
words('waybread.lembas.wafer.biscuit.bread');
words('ears.lugs');
words('cage.enclosure.trap');

words('lead.pb');
words('gold.au');
words('tile.rooftile.slate.plate');

words('blackboard.chalkboard.board.whiteboard.formula.formulae');
words('vat.cauldron.liquid');

words('tshirt.shirt.teeshirt.tee.t-shirt');
words('snowglobe.snow.globe');

words('hellhound.hound.dog.canis.tartarus.doggy.doggie.pup.puppy.mutt')
words('fetch.retrieve');
words('bath.vet.cat'); // words dogs don't like, that aren't used elsewhere
words('stroke.pet.scratch.tickle');

words('book.leatherbound.textbook.tome');
words('library');
words('bookcase.case.bookshelf.bookshelves.shelf.shelves');
words('spyhole.spy.hole.eye.eyehole');
words('back');

words('robot.android.automaton.droid');
words('bloop.bleep.beep');
words('slab.marble');

words('kite');
words('fly');

words('point.aim');

words('helmet.helm.hat');

function rot13(txt)
{
	var rot_alpha = 'abcdefghijklmnopqrstuvwxyzabcdefghijklmABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLM';
	var op = '';
	for(var i=0;i<txt.length;++i)
	{
		var c = txt.charAt(i);
		if(rot_alpha.indexOf(c)!=-1)
			op += rot_alpha.charAt(rot_alpha.indexOf(c)+13)
		else
			op += c;
	}
	return(op);
}

