window.game={compiled:'{"title":"Pageant","author":"Autumn Chen","content":"Your name is Karen Zhao, and you’ve just been signed up by your parents for a beauty pageant. You’re not ready, not even close, but you don’t have a choice. But perhaps you can make the best of it. Maybe it’s the one opportunity to make a “hook” for your college application. Maybe you can reinvent yourself, get rid your anxiety and become someone new. Or maybe you can find true love (or some approximation thereof).","scenes":{"1":{"id":"1","type":"scene","title":"Home","subtitle":"Sunday, Week 1","newPage":true,"viewIf":{"$code":"return ((Q[\'week\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'week\'] = 1;\\nQ[\'gpa\'] = 3.95;\\nQ[\'loneliness\'] = 1;\\nQ[\'growth_points\'] = 0;\\nQ[\'trauma_points\'] = 0;\\nQ[\'first_name\'] = \\"Karen\\";"}],"tags":["top","pageant_prep"],"options":[{"id":"@1.c","title":"Continue"}],"content":{"type":"paragraph","content":["Note: spoken dialogue is a mix of Mandarin and English. Mandarin dialogue will be in italics, like ",{"type":"emphasis-1","content":"\\"this\\""},"."]}},"1.c":{"id":"1.c","options":[{"id":"@1.c2","title":"Continue"}],"content":{"content":"It starts with a command from your mother. These sorts of things usually do.","type":"paragraph"}},"aubrey_final.date_beginning":{"id":"aubrey_final.date_beginning","options":[{"id":"@aubrey_final.sitting_on_train","title":"It felt so mundane..."}],"content":[{"type":"paragraph","content":"The two of you had met at the T station in your town. You only live a few blocks away, while Aubrey lives quite a ways away. She was smiling as she approached you, wearing a puffy green jacket and black pants. You waved back."},{"type":"paragraph","content":"\\"Ready to go?,\\" she asked. You nodded, and boarded the next train."}]},"achievements.credits_debug":{"id":"achievements.credits_debug","title":"Credits","viewIf":{"$code":"return ((Q[\'week\'] || 0)===0);"},"goTo":[{"id":"credits_and_notes"}],"content":{"content":"","type":"paragraph"}},"birthday.invite_miri":{"id":"birthday.invite_miri","viewIf":{"$code":"return ((Q[\'birthday_miri_invited\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'birthday_miri_invited\'] = 1;\\nQ[\'miri\'] = (Q[\'miri\'] || 0) + 1;"}],"goTo":[{"id":"birthday.prepare"}],"content":[{"type":"paragraph","content":"If you invite anyone to your birthday party, it should be Miri. After all, she\'s probably your best friend, or something like that."},{"type":"paragraph","content":"You text Miri asking if she wants to come to your birthday celebration thing."},{"type":"paragraph","content":"\\"anyone else\\", she replies."},{"type":"paragraph","content":"\\"Potentially\\" you reply back."},{"type":"paragraph","content":"\\"sure ill come\\"."}]},"christmas_break.practice_pageant":{"id":"christmas_break.practice_pageant","goTo":[{"id":"pageant_prep_self_2"}],"content":{"content":"","type":"paragraph"}},"christmas_party.not_long":{"id":"christmas_party.not_long","options":[{"id":"@christmas_party.freeze_1","title":"...Emily Chen?"}],"content":[{"type":"paragraph","content":"It\'s not a long drive, seeing as how you live in the same town, even though the Gaos live in the supposedly \\"nice\\" part of town. It\'s just not that large of a municipality."},{"type":"paragraph","content":"Your family is one of the last ones to arrive. Cars line the sides of the streets, and Christmas lights shine bright from the houses all around. Aubrey greets you as you enter."},{"type":"paragraph","content":"\\"We\'re playing Scrabble upstairs,\\" she says, as you place the pot of soup on the counter. \\"Right now it\'s just me and --- Chen. You should really join us!\\""}]},"church_1.acq":{"id":"church_1.acq","options":[{"id":"@church_1.love","title":"And worst of all, you used to be in love with her."}],"content":{"content":"That acquaintance is named Aubrey Gao. She\'s a competitor in the sense that she\'s demographically similar to you and also aiming to get into the same universities. Everyone knows that the top universities have a fixed number of slots for Chinese girls from Massachussetts who are interested in science. And she\'s better than you in every way - GPA, test scores, ECs, and so on, with the same course load. Your parents make sure you know that.","type":"paragraph"}},"church_2.listen":{"id":"church_2.listen","options":[{"id":"@church_2.aubrey","title":"Talk to her?"},{"id":"@church_2.ignore","title":"Ignore her?"}],"content":[{"type":"paragraph","content":["Wang ",{"type":"emphasis-1","content":"Laoshi"}," gives thanks for the meal, for everyone being able to come together here in the Gao family\'s house. He says that amidst the troubles of the modern world, all the corruption and sickness, the church and the community are sanctuaries of faith. He prays for the well-being of everyone here, for everyone to be healthy and prosperous, for their parents to be well, for their children to be obedient."]},{"type":"paragraph","content":"His American wife recently left him for another woman. It\'s become the gossip topic of the month in this little community. You\'ve tried to tune it out."},{"type":"paragraph","content":"After the group separates, you follow the line for the potluck. Then you and Aubrey end up in the basement again. No Spencer this time; as a senior he\'s busy with college apps."}]},"church_3.join_singing":{"id":"church_3.join_singing","options":[{"id":"@church_3.bible_study","title":"After the singing comes the Bible study."}],"content":[{"type":"paragraph","content":"Mom lays the book with lyrics on her lap, as you look on. They start with a Mandarin rendition of Amazing Grace. You don\'t know the words, so you just hum along. Mom claps her hands with the beat. Even though no one else can sing either, it doesn\'t sound so bad. Their lack of vocal skills are made up for by their passion and emotion. Someone starts to cry. You glance at Aubrey. She\'s enthralled, it seems."},{"type":"paragraph","content":"Soon it\'s over, and they move on to other songs. People call out names of songs that you don\'t recognize. They start, and you keep humming. At the end, they come back to Amazing Grace."}]},"classes_1.prep":{"id":"classes_1.prep","options":[{"id":"@classes_1.miri","title":"And so..."}],"content":[{"type":"paragraph","content":"Last night you looked up some details about the pageant. First of all, the pageant is only for teens aged 14 to 18. There are a few different \\"events\\" or something like that: evening gown, athletic wear, the interview, a talent show, and the platform. Each of these events is 20% of the final score. The top two scorers in the regional pageant in January get sent to the state pageant in March, and the winner of the state pageant gets to go to the national pageant, a live televised event in New York. Regional winners get scholarships of $500, and state winners get $2000 (you didn\'t bother to look at national prizes), which is at most two weeks of tuition at MIT. Still, you\'re doing this for the college application points, not the money, and it\'s not like any of your other ECs are tossing out unrestricted scholarships."},{"type":"paragraph","content":["It all sounds simple enough, except for the fact that, well, you\'re ",{"type":"emphasis-1","content":"you"},", and pageants are just not something you do..."]}]},"credits_and_notes.end":{"id":"credits_and_notes.end","gameOver":true,"content":{"content":"","type":"paragraph"}},"credits_and_notes":{"id":"credits_and_notes","type":"scene","title":"Credits and notes","newPage":true,"viewIf":{"$code":"return ((Q[\'week\'] || 0)===100);"},"tags":["epilogue"],"maxVisits":1,"onArrival":[{"$code":"Q[\'var1\'] = \\"abc\\";"}],"options":[{"id":"@credits_and_notes.end","title":"To be continued...?"}],"content":[{"type":"heading","content":"Credits"},{"type":"paragraph","content":[{"type":"emphasis-1","content":"Pageant"}," was written between 2016 and 2020 by Autumn Chen."]},{"type":"paragraph","content":"Developed using dendry by Ian D. Millington."},{"type":"paragraph","content":["I had started a prototype using Raconteur by Bruno Dias, but transitioned to dendry. A remnant of the original Raconteur story can be found at ",{"type":"emphasis-1","content":"A Christmas Party"},", which is an alternate version of one of the key events in this game."]},{"type":"paragraph","content":"Thanks to everyone who has provided feedback at any time in the development process, even if it was only a few words of encouragement. Special thanks to brushmen for Chinese suggestions."},{"type":"heading","content":"Inspirations:"},{"type":"paragraph","content":"(in no particular order)"},{"type":"paragraph","content":[{"type":"emphasis-1","content":"Bee"}," by Emily Short, for the storylet-based structure, coming-of-age story about a competition, and incidentally introducing me to dendry. This game would not exist if ",{"type":"emphasis-1","content":"Bee"}," did not exist."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"Spy Intrigue"}," by furkle, for being amazing. Along those lines, ",{"type":"emphasis-1","content":"Venus Meets Venus"}," by kaleidofish and ",{"type":"emphasis-1","content":"Birdland"}," by Brandon Patrick Hennessy."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"Enter Title Here"}," by Rahul Kanakia, for being a novel about the extent to which children of immigrants will go to make it in America."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"Ivy Dreams"},", a documentary about Asian-American students in the college applications process."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"Butterfly Soup"}," by Brianna Lei, for being one of the very few stories about Asian-American lesbian teens. ",{"type":"emphasis-1","content":"Pageant"}," is a lot like ",{"type":"emphasis-1","content":"Butterfly Soup"},", but not as funny."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"Beauty Queens"}," by Libba Bray, for being a novel about beauty pageant contestants, some of whom are lesbian or trans (I only finished it after writing most of ",{"type":"emphasis-1","content":"Pageant"},", though)."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"Black Closet"},", ",{"type":"emphasis-1","content":"Magical Diaries"},", and ",{"type":"emphasis-1","content":"Long Live the Queen"}," by Hanako Games, for the stat-raising gameplay and character development. More generally, ",{"type":"emphasis-1","content":"Pageant"}," was influenced by the \\"raising sim\\" gameplay style which has a long history in visual novels."]},{"type":"paragraph","content":"Choice of Games in general, for showing what interactive fiction can do."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"Life is Strange"},", for filling me with spite. Along those lines, yuri manga and anime in general."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"Love Nikki Dress-Up Queen"},", for influencing the way in which Emily Chen theorized about fashion."]},{"type":"paragraph","content":"Personal experiences."},{"type":"heading","content":"Thank you for playing!"},{"type":"paragraph","content":["For one possible sequel, see ",{"type":"emphasis-1","content":"A Christmas Party, Part 2"},". In addition, a direct sequel to ",{"type":"emphasis-1","content":"Pageant"}," is in progress, hopefully coming in late 2021."]}],"countVisitsMax":1},"emily_1.background":{"id":"emily_1.background","options":[{"id":"@emily_1.stare","title":"Stare at Emily."},{"id":"@emily_1.emily_2","title":"Sure."},{"id":"@emily_1.emily_why","title":"Why are you even here?"}],"content":[{"type":"paragraph","content":"The two of you had friended each other on the abhorrent social media platform known as f@cebook. She lives in a suburban town about thirty minutes from you, a bastion of rich academics with a \\"good\\" school district. She says that her parents don\'t approve of her doing stuff like the pageant. Kind of the opposite situation from yours, or something like that."},{"type":"paragraph","content":"You\'ve also done research on the meeting location. Since there are very few suburb-to-suburb public transit routes, the best place to meet would be downtown. She had suggested this store; you would have picked a less expensive place. But it\'s not like you have anything better to spend your allowance on."},{"type":"paragraph","content":"She comes decked out in shades of black, in what might be the same outfit that she wore at the meeting. She takes a furtive glance around before sitting down at your table."},{"type":"paragraph","content":"\\"Hi. Not sure what you expected but I\'m Emily.\\" Her voice is deep but soft, barely above a whisper, and carefully controlled, enunciating every word. \\"So you wanted to discuss the pageant stuff?\\""}]},"emily_3_online.no":{"id":"emily_3_online.no","options":[{"id":"@emily_3_online.go_on","title":"\\"It\'s alright...?\\""}],"content":[{"type":"paragraph","content":"You: Um, no... how?"},{"type":"paragraph","content":"Emily is typing for a while now."},{"type":"paragraph","content":"Emily: Sorry but this is easier to talk about online than in person"},{"type":"paragraph","content":"Emily is typing again."}]},"emily_2.try":{"id":"emily_2.try","options":[{"id":"@emily_2.thanks","title":"Let her buy the clothes for you."},{"id":"@emily_2.thanks_2","title":"Buy them yourself."},{"id":"@emily_2.thanks_3","title":"Don\'t buy anything."}],"content":[{"type":"paragraph","content":"You have never enjoyed wearing dresses. But maybe just this one time, it\'s going to be fine. The dress is a deep blue color, and reveals far too much of your body. It\'s a pain to put on by yourself."},{"type":"paragraph","content":"Emily smiles when she sees you leave the dressing room. \\"You look nice. I mean, really nice.\\""},{"type":"paragraph","content":"You would have blushed if you could. \\"Um, thanks.\\""},{"type":"paragraph","content":"\\"Yeah, no problem. I mean, not like in a weird way or anything but...\\""},{"type":"paragraph","content":"An awkward pause."},{"type":"paragraph","content":"\\"So, um, I can buy these things if you want?\\", she asks."}]},"emily_4.what":{"id":"emily_4.what","options":[{"id":"@emily_4.no_idea","title":"You have no idea what to say."}],"content":[{"type":"paragraph","content":"Emily takes a sip from her coffee, sighs, and rests her face against her palm."},{"type":"paragraph","content":"\\"Sorry. I was just wondering, like, why are you still coming to these, like, meetings or whatever?\\" Her eyes are trained away from you, somewhere in the distance. As you stare at her face she turns to look at you. You look away."},{"type":"paragraph","content":"\\"I mean, are you still looking for help with the pageant? It\'s pretty obvious I can\'t give you any more.\\" Emily sighs again. \\"Sorry if this is, like, weird.\\""}]},"emily_6.right":{"id":"emily_6.right","options":[{"id":"@emily_6.anyway","title":"Anyway..."}],"content":{"content":{"type":"paragraph","content":["Yes, that\'s right. ",{"type":"conditional","content":"Even though you didn\'t really know her before the party. ","predicate":0},{"type":"conditional","content":"Especially after the party. ","predicate":1}," Or is it?"]},"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'meet_emily\'] || 0)===0);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'meet_emily\'] || 0)===1);"}}]}},"emily_7.wait_1":{"id":"emily_7.wait_1","viewIf":{"$code":"return ((Q[\'emily_date\'] || 0)===0);"},"options":[{"id":"@emily_7.idk_1","title":"\\"I don\'t know?\\""}],"content":[{"type":"paragraph","content":"\\"So like, you know how trans women\'s social acceptance is contingent on how well they perform femininity?\\""},{"type":"paragraph","content":"\\"Um...\\""},{"type":"paragraph","content":"\\"Would you still want to interact me if I were a lot more non-passing? If I looked more like a boy than I already do?\\""},{"type":"paragraph","content":"\\"Um...\\" You have no idea how to parse her question."}]},"ending_pageant_success":{"id":"ending_pageant_success","type":"scene","title":"An end","newPage":true,"viewIf":{"$code":"return ((Q[\'pageant_success\'] || 0)===1);"},"onArrival":[{"$code":"Q[\'week\'] = 100;"}],"tags":["ending","top"],"content":{"content":"","type":"paragraph"}},"ending_pageant_failure":{"id":"ending_pageant_failure","type":"scene","title":"An end","newPage":true,"viewIf":{"$code":"return ((Q[\'pageant_success\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'week\'] = 100;"}],"tags":["ending","top"],"gameOver":true,"content":{"content":"It\'s over. Your parents pick you up. You\'ve lost.","type":"paragraph"}},"family_1.wash_dishes":{"id":"family_1.wash_dishes","content":[{"type":"paragraph","content":"After finishing the rice on your plate, and waiting for everyone else to finish, you place plastic wrap over the leftovers and gather them in the refrigerator. Then you wash the dishes, or rather just rinse them before putting them in the dishwasher."},{"type":"paragraph","content":"Your family disperses. Mom and Dad watch CCTV dramas on dad\'s laptop. Kevin plays games on his ipad. And you head into your room, the one you supposedly share with Kevin (he usually prefers to sleep in the room with your parents). You have a load of homework tonight, like every other night. You\'d better get to it."}]},"family_1":{"id":"family_1","type":"scene","title":"Family Dinner","subtitle":"Home, Evening","newPage":true,"viewIf":{"$code":"return ((((((Q[\'week\'] || 0) >= 1) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'family\'] || 0)===0)) && ((Q[\'class_visited\'] || 0)===1)) && ((Q[\'week\'] || 0) < 10));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'family\'] = (Q[\'family\'] || 0) + 1;"}],"tags":["top","family"],"options":[{"id":"@family_1.wash_dishes","title":"Afterwards, it\'s your responsibility to clean up."}],"content":[{"type":"paragraph","content":["Obviously in Chinese culture food is very important, blah blah blah. Which is why you\'re eating dinner with your parents and your ",{"type":"emphasis-1","content":"didi"}," (younger brother), Chun-chun (Kevin, also called Chunyi but he doesn\'t like that). Or something like that."]},{"type":"paragraph","content":"In China you and your family would be considered northerners. What people usually think of as \\"typical\\" Chinese food is usually southern food, with rice and stir fries drenched in sauces. Northern cuisine is a bit different: you eat steamed buns, noodle soups with thickly cut slabs of noodles, and simple vegetable and meat dishes stir-fried in oil and nothing else. It\'s blander than the Chinese food in restaurants, but to you it\'s the beautiful taste of home and culture. Or something like that. But really, you do like eating your parents\' cooking. Most of the time."},{"type":"paragraph","content":["Anyway as usual your parents question you about the school day, and you give one or two word responses. ",{"type":"emphasis-1","content":"\\"How were the classes?\\""}," ",{"type":"emphasis-1","content":"\\"Okay.\\""}," ",{"type":"emphasis-1","content":"\\"Did you have any tests?\\""}," ",{"type":"emphasis-1","content":"\\"No.\\""}," ",{"type":"emphasis-1","content":"\\"Have you started preparing for the "},"pageant?\\" \\"Sort of.\\" And so on."]}]},"emily_final.what":{"id":"emily_final.what","options":[{"id":"@emily_final.why","title":"\\"Why do you want to run away?\\""},{"id":"@emily_final.where","title":"\\"Where would you go?\\""}],"content":[{"type":"paragraph","content":"You: Wait, what? Is this a serious question?"},{"type":"paragraph","content":"Emily: About 15 percent serious. But it\'s a thought."}]},"epilogue.all_epilogues":{"id":"epilogue.all_epilogues","options":[{"id":"@epilogue.ep_pageant_win","title":"The Pageant"},{"id":"@epilogue.ep_pageant_lose","title":"The Pageant"},{"id":"@epilogue.ep_school","title":"School"},{"id":"@epilogue.ep_scioly_good","title":"Science Olympiad"},{"id":"@epilogue.ep_scioly_neutral","title":"Science Olympiad"},{"id":"@epilogue.ep_research_good","title":"Research"},{"id":"@epilogue.ep_family_good","title":"Family"},{"id":"@epilogue.ep_family_bad","title":"Family"},{"id":"@epilogue.ep_emily_date","title":"Emily"},{"id":"@epilogue.ep_emily_friends","title":"Emily"},{"id":"@epilogue.ep_miri_date_done","title":"Miri"},{"id":"@epilogue.ep_miri_friends","title":"Miri"},{"id":"@epilogue.ep_miri_uncertain","title":"Miri"},{"id":"@epilogue.ep_miri_neutral","title":"Miri"},{"id":"@epilogue.ep_miri_bad","title":"Miri"},{"id":"@epilogue.ep_aubrey_date","title":"Aubrey"},{"id":"@epilogue.ep_aubrey_friends","title":"Aubrey"},{"id":"@achievements","title":"Achievements (exit game)"}],"content":{"content":"","type":"paragraph"}},"family_3.note":{"id":"family_3.note","options":[{"id":"@family_3.listen","title":"Try to focus on eating. Don\'t listen."}],"content":[{"type":"paragraph","content":"\\"Hey, does everyone have a mom and dad?\\" Kevin asks this innocuous question which causes your heartbeat to rise and you\'re afraid you\'ve already started shaking and-"},{"type":"paragraph","content":"\\"Yes. Everyone has a mom and dad,\\" dad says in English."},{"type":"paragraph","content":"\\"But what about Carl? He only has a mom.\\""},{"type":"paragraph","content":"\\"He must have had a dad. Maybe his parents are divorced.\\""},{"type":"paragraph","content":"\\"Oh. Yeah.\\" Kevin is so innocent. \\"I forgot. Carl told me that.\\""},{"type":"paragraph","content":"\\"See? That\'s right.\\""},{"type":"paragraph","content":"\\"But can anyone have two moms?\\""}]},"family_5.god":{"id":"family_5.god","options":[{"id":"@family_5.freeze","title":"Freeze."}],"content":[{"type":"paragraph","content":"Mom keeps telling him to look for a job, saying her research associate salary isn\'t enough to support the family. But it\'s worked out so far. None of you have particularly expensive needs, and your family\'s two-bedroom apartment is one of the cheapest in the area. It\'s obvious that dad isn\'t even looking for a job anymore, and you don\'t know what he\'s doing during the days."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"I know you like girls.\\""},""]},{"type":"paragraph","content":"Fuck."}]},"family_2.dad_1":{"id":"family_2.dad_1","options":[{"id":"@family_2.mom_2","title":"Mom chimes in."},{"id":"@family_2.dad_2","title":"Dad continues."}],"content":{"content":"Your father starts telling the stories of the cold and starving winters of Jilin Province in northeastern China. On the day Chairman Mao died, he remembered crying and hugging his brothers. The younger children were too young to understand, and their parents quickly shushed them when they asked what was the big deal, who was this Chairman Mao anyways, because children\'s loose lips were what got their parents arrested.","type":"paragraph"}},"family_6.so_yeah":{"id":"family_6.so_yeah","options":[{"id":"@family_6.keep_happening","title":"It keeps happening."}],"content":[{"type":"paragraph","content":"So you\'re on an impromptu family day trip. In the evening in winter, when it\'s dark outside already. On a school day."},{"type":"paragraph","content":"Dad\'s driving north, towards New Hampshire."},{"type":"paragraph","content":["\\"我们去哪儿？ ",{"type":"emphasis-1","content":"Where are we going?"},"\\", mom asks."]},{"type":"paragraph","content":["\\"谁知道。 ",{"type":"emphasis-1","content":"Who knows"},",\\" dad replies. You\'ve just passed the New Hampshire state line. The sky is a deep shade of navy blue."]},{"type":"paragraph","content":["\\"你不知道怎么还开车？ ",{"type":"emphasis-1","content":"If you dont know how are you still driving?"},"\\", mom says."]},{"type":"paragraph","content":["Dad sighs. \\"你们总是这样子。总不信我。 ",{"type":"emphasis-1","content":"You all are always like this. Always questioning me. Never trusting what I do."},"\\""]},{"type":"paragraph","content":["\\"我们不能在附近待着吗？ ",{"type":"emphasis-1","content":"We couldn\'t have just stayed nearby?"},"\\", mom says, her voice becoming shrill. \\"没有必要去这么老远地方！ ",{"type":"emphasis-1","content":"You didn\'t need to bring us to the middle of nowhere!"},"\\""]},{"type":"paragraph","content":["\\"要是你会收拾屋子我们就可以在家带着。 ",{"type":"emphasis-1","content":"If you knew how to clean, we wouldn\'t have to do this"},",\\" dad fires back. \\"我们家多脏阿？不会收拾屋子的媳妇儿有什么用啊？ ",{"type":"emphasis-1","content":"How messy is our house? A wife who doesn\'t know how to organize, what\'s the use?"},"\\""]}]},"family_final.dad_1":{"id":"family_final.dad_1","options":[{"id":"@family_final.dad_2","title":"Dad talks about his time at school."},{"id":"@family_final.mom_2","title":"Mom talks about her English classes at school."}],"content":[{"type":"paragraph","content":"Dad talks about his parents, your grandparents. Both of them were factory workers who worked 8-hour shifts, apparently in the clothing or textiles industry. Their shifts would change each week; the factory had to keep going for 24 hours, so sometimes they would be working the night shift. Grandma (nai-nai) retired at age 50. An impossibility in America today, of course. You don\'t even have to hope."},{"type":"paragraph","content":"The conversation moves on."}]},"family_4.watch":{"id":"family_4.watch","goTo":[{"id":"family_4.leave"}],"options":[{"id":"@family_4.leave","title":"You can\'t stand this anymore."}],"content":[{"type":"paragraph","content":["Dad sighs again. ",{"type":"emphasis-1","content":"\\"I hate it when you\'re like this,\\""}," he says, his voice almost becoming a shout."]},{"type":"paragraph","content":{"type":"emphasis-1","content":"\\"Like what?\\""}}]},"introspect_1.not_karen":{"id":"introspect_1.not_karen","options":[{"id":"@introspect_1.still_karen","title":"It is Karen, actually."},{"id":"@introspect_1.amy","title":"Amy"},{"id":"@introspect_1.christina","title":"Christina"},{"id":"@introspect_1.erica","title":"Erica"},{"id":"@introspect_1.grace","title":"Grace"},{"id":"@introspect_1.jenny","title":"Jenny"},{"id":"@introspect_1.rachel","title":"Rachel"},{"id":"@introspect_1.sarah","title":"Sarah"},{"id":"@introspect_1.stephanie","title":"Stephanie"},{"id":"@introspect_1.vivian","title":"Vivian"}],"content":{"content":"Your name as assigned at elementary school English class in China is...","type":"paragraph"}},"introspect_2.pageant":{"id":"introspect_2.pageant","viewIf":{"$code":"return (((Q[\'pageant_prep\'] || 0) >= 2) && ((Q[\'seen_pageant_introspect_2\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'seen_pageant_introspect_2\'] = 1;\\nQ[\'temp_pageant_score\'] = ((((2.25 * (Q[\'pageant_appearance\'] || 0)) + (1.5 * (Q[\'pageant_interview\'] || 0))) + (3 * (Q[\'pageant_talent\'] || 0))) + (2 * (Q[\'pageant_platform\'] || 0)));"}],"options":[{"id":"@introspect_2.research","title":"Think about research."},{"id":"@introspect_2.scioly","title":"Think about science olympiad."},{"id":"@introspect_2.people","title":"Think about the people you know."},{"id":"@introspect_2.self","title":"Think about yourself."},{"id":"@introspect_2.stop","title":"Stop thinking about stuff."}],"content":{"content":[{"type":"paragraph","content":"The pageant is getting closer and closer every day, and you\'ve started your preparations. Somewhat."},{"type":"paragraph","content":[{"type":"conditional","content":"You\'ve been working on the physical aspects of the pageant: styling, makeup, and so on. You\'ve learned more than you ever thought you would. It\'s a domain of knowledge like any other, is the angle you\'re going with this. ","predicate":0},""]},{"type":"paragraph","content":[{"type":"conditional","content":"You\'ve been practicing for the interview. Hopefully you won\'t cry on stage. ","predicate":1},""]},{"type":"paragraph","content":["As for your actual chances for winning the pageant... based on some formula that you found on the internet, it appears that ",{"type":"conditional","content":"you have no chance of winning the pageant. But that\'s what you expected, right? ","predicate":2},{"type":"conditional","content":"you might be able to get a respectable placement, but you won\'t win. But, that\'s better than you expected, right? ","predicate":3},{"type":"conditional","content":"... well, you have some hope. Not a great deal of hope, but hope nevertheless. You\'ll still need more practice, though. ","predicate":4},""]},{"type":"paragraph","content":[{"type":"conditional","content":"You still haven\'t picked out a ball gown yet. In order to do well on the pageant, you have to pick out a ball gown and try it on. ","predicate":5}," ",{"type":"conditional","content":"You\'ve picked out a ball gown, but you haven\'t tried it on yet. You should try it on if you\'d like to do well at the pageant.","predicate":6}]}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_appearance\'] || 0) >= 2);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_interview\'] || 0) >= 2);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'temp_pageant_score\'] || 0) <= 20);"}},{"type":"predicate","fn":{"$code":"return (((Q[\'temp_pageant_score\'] || 0) > 20) && ((Q[\'temp_pageant_score\'] || 0) <= 40));"}},{"type":"predicate","fn":{"$code":"return ((Q[\'temp_score\'] || 0) > 40);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'ball_gown\'] || 0)===0);"}},{"type":"predicate","fn":{"$code":"return (((Q[\'ball_gown\'] || 0)===1) && ((Q[\'try_on_ball_gown\'] || 0)===0));"}}]}},"introspect_3.pageant":{"id":"introspect_3.pageant","onArrival":[{"$code":"Q[\'temp_pageant_score\'] = ((((2.25 * (Q[\'pageant_appearance\'] || 0)) + (1.5 * (Q[\'pageant_interview\'] || 0))) + (3 * (Q[\'pageant_talent\'] || 0))) + (2 * (Q[\'pageant_platform\'] || 0)));"}],"maxVisits":1,"options":[{"id":"@introspect_3.scioly","title":"Think about science olympiad."},{"id":"@introspect_3.research","title":"Think about your extracurriculars."},{"id":"@introspect_3.people","title":"Think about people you know."},{"id":"@introspect_3.stop","title":"Enough thinking for now."}],"content":{"content":[{"type":"paragraph","content":[{"type":"conditional","content":"Your progress with the actual \\"beauty\\" parts of the pageant have been somewhat decent. You feel like you have a better grasp of the basics of appearance-enhancing technique than you did before the start of this ordeal. ","predicate":0},""]},{"type":"paragraph","content":[{"type":"conditional","content":"You feel like you\'ve made progress regarding the interview. Not that you\'ve \\"cured\\" your social anxiety or anything like that, but for the very specific context of the pageant interview, you have established a nonzero amount of preparation. ","predicate":1},""]},{"type":"paragraph","content":["As for your actual chances for winning the pageant... based on some formula that you found on the internet, it appears that ",{"type":"conditional","content":"you have no chance of winning the pageant. But that\'s what you expected, right? ","predicate":2},{"type":"conditional","content":"you might be able to get a respectable placement, but you won\'t win. But, that\'s better than you expected, right? ","predicate":3},{"type":"conditional","content":"... well, you have some hope. Not a great deal of hope, but hope nevertheless. You\'ll still need more practice, though. ","predicate":4},""]},{"type":"paragraph","content":[{"type":"conditional","content":"You still haven\'t picked out a ball gown yet. In order to do well on the pageant, you have to pick out a ball gown and try it on. ","predicate":5}," ",{"type":"conditional","content":"You\'ve picked out a ball gown, but you haven\'t tried it on yet. You should try it on if you\'d like to do well at the pageant.","predicate":6}]}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_appearance\'] || 0) >= 8);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_interview\'] || 0) >= 5);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'temp_pageant_score\'] || 0) <= 20);"}},{"type":"predicate","fn":{"$code":"return (((Q[\'temp_pageant_score\'] || 0) > 20) && ((Q[\'temp_pageant_score\'] || 0) <= 40));"}},{"type":"predicate","fn":{"$code":"return ((Q[\'temp_score\'] || 0) > 40);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'ball_gown\'] || 0)===0);"}},{"type":"predicate","fn":{"$code":"return (((Q[\'ball_gown\'] || 0)===1) && ((Q[\'try_on_ball_gown\'] || 0)===0));"}}]},"countVisitsMax":1},"loneliness_1.options":{"id":"loneliness_1.options","options":[{"id":"@loneliness_1.wikipedia","title":"Go on Wikipedia."},{"id":"@loneliness_1.social_media","title":"Go on social media."},{"id":"@loneliness_1.webcomic","title":"Read the webcomic."},{"id":"@loneliness_1.fanfic","title":"Read fanfiction."},{"id":"@loneliness_1.homework","title":"Do your homework."},{"id":"@loneliness_1.homework_real","title":"Do your homework (for real this time)."}],"content":{"content":"","type":"paragraph"}},"loneliness_2.contact_miri":{"id":"loneliness_2.contact_miri","viewIf":{"$code":"return ((Q[\'miri\'] || 0) >= 2);"},"options":[{"id":"@loneliness_2.contact_miri_2","title":"Just message her."},{"id":"@loneliness_2.sleep","title":"Forget it."}],"content":{"content":"First of all, she might be asleep. Wait, no, she has an even later sleeping schedule than you do. But then, what could you talk about? You don\'t have anything to say... And if you bother her with your problems, will she still be your friend? What if you\'re being a toxic influence on her life? Will she be justfied in cutting you out if you\'re nothing but a constant source of negativity?","type":"paragraph"}},"miri_date.stare_at_miri":{"id":"miri_date.stare_at_miri","options":[{"id":"@miri_date.um","title":"Take a deep breath..."}],"content":[{"type":"paragraph","content":"Before the past few weeks, you\'ve never realized how pretty Miri was. She has a round face framed by ringlets of curly hair falling to about shoulder length, smiling like she always does. She is shorter than you, her eyes just reaching your lips. Today she is wearing a nice purple dress and cardigan over tights; she almost never wears dresses so she must have picked it out for this occasion. Your outfit is banal compared to hers, with jeans and flannel; you regret not putting your pageantry skills to use. You\'ve taken her for granted too for too long."},{"type":"paragraph","content":"\\"You\'re staring,\\" she says. Oh. Right."}]},"miri_pageant_prep.gym_1":{"id":"miri_pageant_prep.gym_1","viewIf":{"$code":"return ((Q[\'gym\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'gym\'] = (Q[\'gym\'] || 0) + 1;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 1;"}],"options":[{"id":"@miri_pageant_prep.gym_2","title":"Enter the gym."},{"id":"@miri_pageant_prep.back_out","title":"Back out."}],"content":[{"type":"paragraph","content":"\\"Okay, what do we do now?\\", you ask, hoping Miri knows something you don\'t."},{"type":"paragraph","content":"\\"I don\'t know.\\" Your hopes are immediately dashed. \\"I mean, you asked to come here. I\'m just along for the ride.\\""},{"type":"paragraph","content":"The two of you are in the community center gym, which Miri suggested attending because the pageant has an \\"athletic wear\\" section (in lieu of swimsuits) and having some modicum of athleticism is a precondition for performing well in that section. Or something like that."},{"type":"paragraph","content":"Right now you\'re standing in the entryway wearing utterly inappropriate clothes gawking at all the regulars who look like they belong."}]},"pageant_prep_pick_ball_gown.dress_1":{"id":"pageant_prep_pick_ball_gown.dress_1","onArrival":[{"$code":"Q[\'ball_gown\'] = 1;"}],"goTo":[{"id":"pageant_prep_pick_ball_gown.done"}],"content":[{"type":"paragraph","content":"The black dress has an elegant simplicity to it, which fits your persona, or something like that."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"It looks like going to a funeral\\""},", mom says. ",{"type":"emphasis-1","content":"\\"But if you think it\'s good then it\'s good.\\""}]}]},"pageant_prep_self_2.pageant_chances":{"id":"pageant_prep_self_2.pageant_chances","onArrival":[{"$code":"Q[\'temp_pageant_score\'] = ((((2.25 * (Q[\'pageant_appearance\'] || 0)) + (1.5 * (Q[\'pageant_interview\'] || 0))) + (3 * (Q[\'pageant_talent\'] || 0))) + (2 * (Q[\'pageant_platform\'] || 0)));"}],"options":[{"id":"@pageant_prep_self_2.details_2","title":"Paperwork. There\'s always paperwork."},{"id":"@pageant_prep_self_2.details","title":"Look up details about the pageant."},{"id":"@pageant_prep_self_2.clothes","title":"Find clothes and figure out your appearance."},{"id":"@pageant_prep_self_2.social","title":"Interview practice."},{"id":"@pageant_prep_self_2.platform","title":"Platform preparation."},{"id":"@pageant_prep_talent_1","title":"Talent practice."}],"content":{"content":[{"type":"paragraph","content":["Let\'s be honest: you\'ve never expected to win the pageant. The hope was to have an ",{"type":"emphasis-1","content":"interesting"}," experience, so that you would be able to write about it in your college application, so you would seem like a well-rounded student and not an Asian-American Academic Automaton."]},{"type":"paragraph","content":"Nevertheless, you still desire to win, right? It\'s a human thing, the competitive instinct. The chance to prove your detractors wrong."},{"type":"paragraph","content":["Based on your current preparation, and on some formula you found on the internet, it appears that ",{"type":"conditional","content":"you have no chance of winning the pageant. But that\'s what you expected, right? ","predicate":0},{"type":"conditional","content":"you might be able to get a respectable placement, but you won\'t win. But, that\'s better than you expected, right? ","predicate":1},{"type":"conditional","content":"... well, you have some hope. Not a great deal of hope, but hope nevertheless. You\'ll still need more practice, though.","predicate":2}]}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'temp_pageant_score\'] || 0) <= 20);"}},{"type":"predicate","fn":{"$code":"return (((Q[\'temp_pageant_score\'] || 0) > 20) && ((Q[\'temp_pageant_score\'] || 0) <= 40));"}},{"type":"predicate","fn":{"$code":"return ((Q[\'temp_score\'] || 0) > 40);"}}]}},"pageant_final.stress_full":{"id":"pageant_final.stress_full","viewIf":{"$code":"return ((Q[\'stress\'] || 0) >= 15);"},"options":[{"id":"@pageant_final.get_up","title":"Try to get up."},{"id":"@pageant_final.cant_get_up","title":"No. You can\'t."}],"content":[{"type":"paragraph","content":"It\'s 8AM. You haven\'t slept at all last night. You\'ve been awake for at least 24 hours. This isn\'t the first time, but now, your body and mind are breaking apart. Mom opens the door to your room without knocking."},{"type":"paragraph","content":{"type":"emphasis-1","content":"\\"Qiuyi, today is your contest. Are you ready to go?\\""}}]},"pageant_prep_self_final.paperwork_prep":{"id":"pageant_prep_self_final.paperwork_prep","viewIf":{"$code":"return ((Q[\'paperwork_prep_seen\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'paperwork_prep_seen\'] = 1;\\nQ[\'pageant_paperwork\'] = (Q[\'pageant_paperwork\'] || 0) + 1;\\nQ[\'pageant_platform\'] = (Q[\'pageant_platform\'] || 0) + 1;\\nQ[\'resume_completed\'] = 1;\\nQ[\'platform_doc_completed\'] = 1;"}],"options":[{"id":"@pageant_prep_self_final.interview_prep","title":"Prep for the interview"},{"id":"@pageant_prep_self_final.appearance_prep","title":"Focus on your appearance"},{"id":"@pageant_prep_self_final.do_nothing","title":"You might as well be done."},{"id":"@pageant_prep_pick_ball_gown","title":"Pick a ball gown."},{"id":"@pageant_prep_try_ball_gown","title":"Try on your ball gown."}],"content":{"content":"You double-check your forms, resume, platform statement, and all the rest. Eventually, it seems to be all in order, submitted online or printed.","type":"paragraph"}},"pageant_prep_talent_1.remember":{"id":"pageant_prep_talent_1.remember","options":[{"id":"@pageant_prep_talent_1.regard","title":"Look over the erhu."},{"id":"@pageant_prep_talent_1.play","title":"Play a simple piece."},{"id":"@pageant_prep_talent_1.away","title":"Put it away."}],"content":[{"type":"paragraph","content":"You took lessons back when you still went to Chinese school, freshman year or thereabouts. Only a month after coming to Massachussetts, your parents enrolled you in Chinese classes on Saturdays (that was when your dad had his job). Erhu lessons started not long after. The teacher was an old man from Hong Kong with a long white beard, like one of those stereotypical characters from movies. He didn\'t speak English, and barely spoke Mandarin, so there was no chance of verbal communication. Instead, he communicated through the language of the soul."},{"type":"paragraph","content":"In truth he communicated by alternatively holding your hand and slapping it. Still, it worked, and now you have at least a basic level of erhu skill."}]},"pageant_prep_try_ball_gown.try_it_on":{"id":"pageant_prep_try_ball_gown.try_it_on","options":[{"id":"@pageant_prep_try_ball_gown.okay_1","title":"\\"Okay.\\""}],"content":[{"type":"paragraph","content":"It\'s a bit awkward, but you manage to put on the dress. Unfortunately it really is a two-person endeavor, with mom helping to zip up the back."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"How beautiful!\\""}," mom says. ",{"type":"emphasis-1","content":"\\"I\'ve never seen you wear a dress like this.\\""},""]},{"type":"paragraph","content":["\\"Oh. ",{"type":"emphasis-1","content":"Thanks."},"\\""]},{"type":"paragraph","content":{"type":"emphasis-1","content":"\\"Really! After this is over you should try wearing more dresses.\\""}}]},"research_2.listen":{"id":"research_2.listen","options":[{"id":"@research_2.fine","title":"(partial lie) It was fine."},{"id":"@research_2.notfine","title":"It was not fine at all."}],"content":[{"type":"paragraph","content":"Of course it turns out to be basically incomprehensible. Half of the words you don\'t understand, and the half you do are used in ways you\'ve never heard before. Stella had sent links to the papers as well as some background articles that she said were \\"helpful\\", but it\'s not like any of that helped. You had tried reading the papers, but you stopped after even the abstracts were too dense for you."},{"type":"paragraph","content":"\\"So? How was it?\\", Stella asks you after the lab meeting, smiling as if nothing is wrong."}]},"pageant_meetup.starting":{"id":"pageant_meetup.starting","options":[{"id":"@pageant_meetup.calm","title":"Breathe."}],"content":[{"type":"paragraph","content":"You went by yourself, of course, down to a not-so-fancy hotel in Cambridge. You stand at the door. You don\'t see anyone else who looks like a contestant. Will there be parents there? What will all the people look like? What if you see someone you recognize? What if they recognize you? What if you have to do something to prove that you\'re ready to be a contestant? And what if your parents were supposed to come but you told mom that she didn\'t have to come because it would just make it more awkward and for some reason she listened to you (actually she\'s just busy at work and didn\'t want to come) but..."},{"type":"paragraph","content":"Your heart pounds in your chest. Your hands are trembling. Oh God you\'re not ready for this."}]},"research_3.code":{"id":"research_3.code","options":[{"id":"@research_3.not_really","title":"\\"Not really...\\""},{"id":"@research_3.thanks","title":"\\"Oh, thanks...\\""}],"content":[{"type":"paragraph","content":"It\'s as if you enter a trance state, with nothing on your mind but Python. Stella stops talking. You stop talking. It\'s as if the world outside doesn\'t exist, except the white and green characters on the 25% transparent black screen and the reassuring theme of StackOverflow."},{"type":"paragraph","content":"And slowly but surely, something comes together. You run the script, and the output files are there, the neat bar plots with the error bars in the right place, and how can you tell that they\'re correct? Because Stella tells you so?"},{"type":"paragraph","content":"You\'re disappointed at the end of the day when she tells you that you\'ve just replicated something she did last year."},{"type":"paragraph","content":"\\"But don\'t worry! You did great!\\""}]},"research_4.what":{"id":"research_4.what","options":[{"id":"@research_4.present","title":"And now it\'s time for you to present."}],"content":[{"type":"paragraph","content":"You can\'t succinctly describe it. Actually, you can\'t describe it at all. You\'re using computers. You\'re working with RNA sequencing data. And, like, somewhere along the way, there\'s alignment, and calling a bunch of software packages, and stringing together it all with python, and..."},{"type":"paragraph","content":"This is kind of a problem, if you\'re going to do a presentation."},{"type":"paragraph","content":"So you stayed up last night, trying to pull together some slides and some words."}]},"research_5.oh":{"id":"research_5.oh","options":[{"id":"@research_5.work","title":"And that just means more work."},{"id":"@research_5.empty","title":"So why do you feel so empty?"}],"content":[{"type":"paragraph","content":"\\"Oh... I mean, this is good, right?\\""},{"type":"paragraph","content":"\\"Yeah!\\" Stella beams. \\"Very few high school students get to do this. I certainly didn\'t.\\""},{"type":"paragraph","content":"Your heart rises. This is what you\'ve always dreamed of, right? What you\'ve always wanted? Your first step to becoming a true scientist."}]},"research_6.ready":{"id":"research_6.ready","options":[{"id":"@research_6.stella","title":"Talk to Stella?"}],"content":[{"type":"paragraph","content":"Of course you\'re ready to enter the world of science for real now. You\'ve been ready since birth (okay perhaps an exaggeration, but given your mom\'s career and to a lesser extent your dad\'s, not much of one)."},{"type":"paragraph","content":"Besides, even if you fail, you are not essential and can be replaced. Always a comforting thought."}]},"research_final.ips":{"id":"research_final.ips","options":[{"id":"@research_final.stella_walks_in","title":"You see a shadow."}],"content":[{"type":"paragraph","content":"Sure, the potential applications of induced pluripotent stem cells are incredible, but the real benefit to the technology is the ability to create gametes typically associated with different chromosomal configurations."},{"type":"paragraph","content":"More specifically, you are reading a paper by (...) et al. on pubmed detailing an experiment in which a mouse with three fathers was created. You wonder if technology would allow for two people with XX chromosomes to have biological children together. Or rather, you wonder if you would ever be the one to invent such a technology. Is your current research/educational career leading to such a path? Probably not; all of the stuff being done here seems so ordinary."},{"type":"paragraph","content":"That sounds weird."}]},"research_pass.dont_want":{"id":"research_pass.dont_want","onArrival":[{"$code":"Q[\'research\'] = -1;"}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"I just... don\'t want to go.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Why?\\""}," Her voice turns accusatory."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"I don\'t know.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"You certainly do know.\\""},""]},{"type":"paragraph","content":"You look around. Look away. Play with your pencil. Toss your phone from one hand to the other. Mom sighs."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"I\'ll tell him you don\'t want to go. Okay?\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Okay.\\""},""]},{"type":"paragraph","content":"She leaves the room, leaving the door open."}]},"root.game_start":{"id":"root.game_start","newPage":true,"options":[{"id":"@1","title":"Start game"},{"id":"@root.debug_credits"},{"id":"#debug"}],"content":{"type":"heading","content":"Pageant"}},"scioly_1.okay":{"id":"scioly_1.okay","goTo":[{"id":"scioly_1.alright"}],"content":{"content":"\\"Sure, that\'s fine.\\"","type":"paragraph"}},"scioly_invitational.not_ready":{"id":"scioly_invitational.not_ready","options":[{"id":"@scioly_invitational.disease_detectives","title":"The first event is Disease Detectives."}],"content":{"content":[{"type":"paragraph","content":"\\"No. Not at all.\\""},{"type":"paragraph","content":["\\"Ha. Ha. Ha. Very funny. I know you\'ll do well ",{"type":"insert","insert":0},". Just don\'t stress yourself too much.\\""]},{"type":"paragraph","content":"\\"Yeah. Okay.\\""}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"scioly_pass.go":{"id":"scioly_pass.go","onArrival":[{"$code":"Q[\'scioly\'] = (Q[\'scioly\'] || 0) + 3;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 3;"}],"content":[{"type":"paragraph","content":"\\"Sorry. I\'ll start going to the meetings. I\'ll catch up on... stuff...\\""},{"type":"paragraph","content":"He smiles. \\"Okay. You\'ll have to talk to a bunch of people and catch up on a lot of studying, but I know you can do it!\\""},{"type":"paragraph","content":"\\"Uh, thanks...\\""},{"type":"paragraph","content":"\\"And don\'t forget, you\'re better than you think you are.\\""},{"type":"paragraph","content":"He hands you a packet. You have to catch up. More work, more stress, but you want to do this, right?"}]},"shopping_with_mom.at_least_one":{"id":"shopping_with_mom.at_least_one","options":[{"id":"@shopping_with_mom.red_dress","title":"A red lace dress with ruffles at the waist."},{"id":"@shopping_with_mom.purple_dress","title":"A purple strapless dress with a black stripe."},{"id":"@shopping_with_mom.green_dress","title":"A shimmery pleated green dress."}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"At least one\\""},", you reply. Mom makes a tsk tsk sound."]},{"type":"paragraph","content":"You enter the women\'s formal wear section. The first step is apparently to pick an interview dress, which is going to be the main dress that you\'ll wear throughout the day."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"What do you like?\\""},", mom asks, and it appears to be an actual question. There is a plethora of options, none of which are particularly appealing, at least for now. However, you have no choice but to pick one, so you just look through the cheapest ones."]}]},"research_1.downtown":{"id":"research_1.downtown","options":[{"id":"@research_1.breathe","title":"Breathe."}],"content":{"content":"Professor Song Chen\'s office is at a medical school downtown, a straight ride down the Orange Line. You\'re scared to go in. Actually scared is an understatement. Terrified. On the verge of a panic attack. What if you ran away and disappeared forever? It wouldn\'t be as bad as the embarrassment you\'ll feel if everything goes wrong. What is everything? Well, everything basically, if you let yourself go, if you say the wrong thing, if you are too curt or too loquacious or ruin your reputation with this man forever which could obviously happen no matter what you do and then you\'ll have to explain to your parents and then there will be a web of complications and your science career will be ruined forever before you even get to college and-","type":"paragraph"}},"skip.skip_5":{"id":"skip.skip_5","onArrival":[{"$code":"Q[\'week\'] = 5;\\nQ[\'class_visited\'] = 1;"}],"options":[{"id":"@skip.w5_pageant_1","title":"You\'re doing well in preparing for the pageant."},{"id":"@skip.w5_pageant_2","title":"You haven\'t really prepared."}],"content":[{"type":"paragraph","content":"Skipping to week 5..."},{"type":"paragraph","content":"Pageant prep status:"}]},"scioly_study_party.knock":{"id":"scioly_study_party.knock","options":[{"id":"@scioly_study_party.go_in","title":"Go in."}],"content":{"content":[{"type":"paragraph","content":["It\'s after knocking that you realize that you have no idea what you\'re doing here. It\'s cold outside. You\'re underdressed. Why are you wearing the same outfit you wore for the past five days? Why are you imposing yourself upon a group of people who obviously had no desire for your presence? What is ",{"type":"emphasis-1","content":"you"},", even? Why are you even ",{"type":"emphasis-1","content":"here"}," in any sense? You close your eyes and try to take deep breaths, but it doesn\'t work. You feel as if you\'re viewing life passing by through a body that isn\'t yours. Does that even make sense?"]},{"type":"paragraph","content":"The captain opens the door to greet you, breaking you out of your mental loop, at least for a moment."},{"type":"paragraph","content":["\\"Hey ",{"type":"insert","insert":0},"! Welcome!"]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"stress_1.sleep":{"id":"stress_1.sleep","onArrival":[{"$code":"Q[\'gpa\'] = (Q[\'gpa\'] || 0) - 0.02;\\nQ[\'loneliness\'] = (Q[\'loneliness\'] || 0) + 1;"}],"content":[{"type":"paragraph","content":"You\'re going numb. You can\'t focus on anything anymore. But you can\'t fall asleep either, with so many thoughts racing through your brain. So instead you lie in bed with your eyes closed until mom opens the door an indeterminate time later."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Why is the light closed?\\""},", she asks, and turns on the light. Your eyes burn."]}]},"stress_full.apoptosis":{"id":"stress_full.apoptosis","options":[{"id":"@stress_full.wake_up","title":"You wake up in the nurse\'s office."}],"content":[{"type":"paragraph","content":"Apoptosis is the process of programmed cell death. It arises from many causes: natural growth, cell stress, DNA damage. If it did not happen, you would still have webbed fingers. The prevalence of cancer would become much greater. And you would not be able to become a functional multicellular organism."},{"type":"paragraph","content":"Out of death and destruction comes life, like a forest growing back out of a fire. Out of apoptosis comes the growth and differentiation of all human organs."},{"type":"paragraph","content":"You have no idea why these thoughts appear in your head."}]},"thanksgiving_party.know_prof":{"id":"thanksgiving_party.know_prof","viewIf":{"$code":"return ((Q[\'research\'] || 0) >= 1);"},"goTo":[{"id":"thanksgiving_party.hate"}],"content":{"content":"Of course, Professor Chen is your research advisor at the university. Beyond that, you know next to nothing about him. He\'s relatively rich, with a big house. He apparently has a son about your age.","type":"paragraph"}},"stress_2.start_hw":{"id":"stress_2.start_hw","options":[{"id":"@stress_2.put_it_off","title":"Put it off."},{"id":"@stress_2.work","title":"Work."}],"content":{"content":"It\'s not even 4pm yet. You have ample time, as long as you start before... 8pm or so? So you have at least a few hours to slack off.","type":"paragraph"}},"weekend_1":{"id":"weekend_1","type":"scene","title":"Weekend","subtitle":"Time to relax, maybe","newPage":true,"viewIf":{"$code":"return (((Q[\'week_progress\'] || 0) >= 2) && ((Q[\'week\'] || 0) < 8));"},"onArrival":[{"$code":"Q[\'loneliness\'] = (Q[\'loneliness\'] || 0) + (3 - (Q[\'week_progress\'] || 0));\\nQ[\'week\'] = (Q[\'week\'] || 0) + 1;\\nQ[\'week_progress\'] = 0;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) - 1;\\nQ[\'weekly_family\'] = 0;\\nQ[\'weekly_scioly\'] = 0;\\nQ[\'weekly_research\'] = 0;\\nQ[\'weekly_social\'] = 0;\\nQ[\'weekly_pageant\'] = 0;\\nQ[\'weekly_miri\'] = 0;\\nQ[\'loneliness_1_week_seen\'] = 0;\\nQ[\'weekly_emily\'] = 0;"}],"tags":["top","enter_weekend"],"options":[{"id":"#weekend"}],"content":{"content":"You have some free time this weekend, time that you probably don\'t have to spend on homework or ECs or whatever. What would you like to do?","type":"paragraph"}},"weekend_after_christmas":{"id":"weekend_after_christmas","type":"scene","title":"The Last Weekend","subtitle":"It\'s almost here.","newPage":true,"viewIf":{"$code":"return (((Q[\'week_progress\'] || 0) >= 3) && ((Q[\'week\'] || 0)===10));"},"onArrival":[{"$code":"Q[\'week\'] = (Q[\'week\'] || 0) + 1;\\nQ[\'week_progress\'] = 0;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) - 1;\\nQ[\'weekly_family\'] = 0;\\nQ[\'weekly_scioly\'] = 0;\\nQ[\'weekly_research\'] = 0;\\nQ[\'weekly_social\'] = 0;\\nQ[\'weekly_pageant\'] = 0;\\nQ[\'weekly_miri\'] = 0;\\nQ[\'weekly_emily\'] = 0;"}],"tags":["top","enter_weekend"],"options":[{"id":"#weekend"}],"content":{"content":"Break is almost officially over. Next weekend is the pageant.","type":"paragraph"}},"weekend_alone.get_up":{"id":"weekend_alone.get_up","onArrival":[{"$code":"Q[\'stay_in_count\'] = (Q[\'stay_in_count\'] || 0) + 1;"}],"viewIf":{"$code":"return ((Q[\'stay_in_count\'] || 0) < 3);"},"options":[{"id":"@weekend_alone.get_up","title":"Get up."},{"id":"@weekend_alone.get_up_for_real","title":"Get up for real."},{"id":"@weekend_alone.stay_in","title":"Stay in bed."}],"content":{"content":"It\'s hard. You\'re tired. It\'s hard to open your eyes, and even harder to move.","type":"paragraph"}},"weekend_final":{"id":"weekend_final","type":"scene","title":"The Weekend of the Pageant...","subtitle":"It\'s here.","newPage":true,"viewIf":{"$code":"return (((Q[\'week_progress\'] || 0) >= 2) && ((Q[\'week\'] || 0)===11));"},"onArrival":[{"$code":"Q[\'week\'] = (Q[\'week\'] || 0) + 1;\\nQ[\'week_progress\'] = 0;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) - 1;\\nQ[\'weekly_family\'] = 0;\\nQ[\'weekly_scioly\'] = 0;\\nQ[\'weekly_research\'] = 0;\\nQ[\'weekly_social\'] = 0;\\nQ[\'weekly_pageant\'] = 0;\\nQ[\'weekly_miri\'] = 0;"}],"tags":["top","enter_weekend"],"options":[{"id":"#weekend"}],"content":{"content":"","type":"paragraph"}},"weekend_pre_christmas":{"id":"weekend_pre_christmas","type":"scene","title":"Weekend","subtitle":"Time to relax, maybe","newPage":true,"viewIf":{"$code":"return ((((Q[\'week_progress\'] || 0) >= 2) && ((Q[\'week\'] || 0) >= 8)) && ((Q[\'week\'] || 0) <= 9));"},"onArrival":[{"$code":"Q[\'loneliness\'] = (Q[\'loneliness\'] || 0) + (3 - (Q[\'week_progress\'] || 0));\\nQ[\'week\'] = (Q[\'week\'] || 0) + 1;\\nQ[\'week_progress\'] = 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) - 1;\\nQ[\'weekly_family\'] = 0;\\nQ[\'weekly_scioly\'] = 0;\\nQ[\'weekly_research\'] = 0;\\nQ[\'weekly_social\'] = 0;\\nQ[\'weekly_pageant\'] = 0;\\nQ[\'weekly_miri\'] = 0;"}],"tags":["top","enter_weekend"],"options":[{"id":"#weekend"}],"content":{"content":"You have some free time this weekend, time that you probably don\'t have to spend on homework or ECs or whatever. What would you like to do?","type":"paragraph"}},"scioly_2.aubrey":{"id":"scioly_2.aubrey","viewIf":{"$code":"return ((Q[\'aubrey_scioly\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'aubrey_scioly\'] = (Q[\'aubrey_scioly\'] || 0) + 1;\\nQ[\'aubrey\'] = (Q[\'aubrey\'] || 0) + 1;\\nQ[\'protein_modeling\'] = (Q[\'protein_modeling\'] || 0) + 1;"}],"options":[{"id":"@scioly_2.aubrey_scioly_2","title":"An awkward pause ensues..."}],"content":[{"type":"paragraph","content":"Aubrey is sitting in front of her open laptop. She does not stop typing as you sit across from her."},{"type":"paragraph","content":"\\"Um, like, what is protein modeling?\\", you ask, even though you know full well what protein modeling is, just to break the awkward silence. This event wasn\'t around the last two years, but it is being re-introduced this year."},{"type":"paragraph","content":"\\"Well, it\'s a combination study and building event. First of all you have to build a model of the protein, like a physical model out of plastic parts. The second part is building a protein model from scratch at the exam. And then there\'s a knowledge-based test on proteins.\\""},{"type":"paragraph","content":"\\"Oh.\\""}]},"scioly_final.no":{"id":"scioly_final.no","goTo":[{"id":"scioly_final.captain_continues"}],"content":{"content":"Of course you can\'t be captain; you have approximately zero social skills, much less leadership capability.","type":"paragraph"}},"1.c2":{"id":"1.c2","options":[{"id":"@1.c3","title":"Mom is here."}],"content":{"content":"It\'s Sunday afternoon in Massachussetts, a cool late October day that other people might call beautiful, and you\'re doing AP Chemistry homework in your room. You hear a knock on the door, before it opens without waiting for a response.","type":"paragraph"}},"aubrey_final.sitting_on_train":{"id":"aubrey_final.sitting_on_train","options":[{"id":"@aubrey_final.introspect_date","title":"But you were going on a date..."}],"content":[{"type":"paragraph","content":"You make an attempt to initiate conversation. \\"So, um..., did you tell... ?\\""},{"type":"paragraph","content":"\\"No, I dont tell everything to my parents!\\" She laughed. \\"I told them I was meeting a friend. Which is true, isn\'t it?\\""},{"type":"paragraph","content":"You were gratified by the fact that she thought of you as a friend."}]},"achievements.continue":{"id":"achievements.continue","title":"Back to start","viewIf":{"$code":"return ((Q[\'week\'] || 0)===0);"},"goTo":[{"id":"root"}],"content":{"content":"","type":"paragraph"}},"achievements":{"id":"achievements","type":"scene","title":"Achievements","newPage":true,"viewIf":{"$code":"return ((Q[\'week\'] || 0)===100);"},"tags":["epilogue"],"maxVisits":1,"options":[{"id":"@credits_and_notes"},{"id":"@achievements.credits_debug"},{"id":"@achievements.continue"}],"content":{"content":[{"type":"heading","content":"Your Achievements:"},{"type":"paragraph","content":[{"type":"conditional","content":"Win the pageant. ","predicate":0},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Win a consolation prize at the pageant. ","predicate":1},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Quit the pageant before it finishes. ","predicate":2},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Go on a date with Miri. ","predicate":3},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Miri confesses to you, but you reject her. ","predicate":4},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Ruin your relationship with Miri. ","predicate":5},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Go on a date with Aubrey. ","predicate":6},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Confess to Emily. ","predicate":7},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Save Emily\'s life (maybe). ","predicate":8},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Become Science Olympiad co-captain. ","predicate":9},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Listen to your parents\' stories. ","predicate":10},""]},{"type":"heading","content":"Locked Achievements:"},{"type":"paragraph","content":[{"type":"conditional","content":"Win the pageant. ","predicate":11},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Win a consolation prize at the pageant. ","predicate":12},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Quit the pageant before it finishes. ","predicate":13},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Go on a date with Miri. ","predicate":14},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Miri confesses to you, but you reject her. ","predicate":15},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Ruin your relationship with Miri. ","predicate":16},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Go on a date with Aubrey. ","predicate":17},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Confess to Emily. ","predicate":18},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Save Emily\'s life (maybe). ","predicate":19},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Become Science Olympiad co-captain. ","predicate":20},""]},{"type":"paragraph","content":{"type":"conditional","content":"Listen to your parents\' stories.","predicate":21}}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_success\'] || 0)===1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'special_award\'] || 0)===1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_total_failure\'] || 0)===1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'miri_date\'] || 0)===3);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'miri_date\'] || 0)===-1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'miri_escape\'] || 0)===1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'aubrey_date\'] || 0)===2);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'emily_date\'] || 0)===1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'emily\'] || 0)===9);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'scioly_final_scene\'] || 0)===1);"}},{"type":"predicate","fn":{"$code":"return (((Q[\'stories_viewed\'] || 0) >= 1) && ((Q[\'stories_2_viewed\'] || 0) >= 1));"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_success\'] || 0)===0);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'special_award\'] || 0)===0);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_total_failure\'] || 0)===0);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'miri_date\'] || 0) < 3);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'miri_date\'] || 0) != -1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'miri_escape\'] || 0) != 1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'aubrey_date\'] || 0) < 2);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'emily_date\'] || 0)===0);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'emily\'] || 0) < 9);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'scioly_final_scene\'] || 0)===0);"}},{"type":"predicate","fn":{"$code":"return (((Q[\'stories_viewed\'] || 0)===0) || ((Q[\'stories_2_viewed\'] || 0)===0));"}}]},"countVisitsMax":1},"birthday.invite_aubrey":{"id":"birthday.invite_aubrey","viewIf":{"$code":"return ((Q[\'birthday_aubrey_invited\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'birthday_aubrey_invited\'] = 1;\\nQ[\'aubrey\'] = (Q[\'aubrey\'] || 0) + 1;\\nQ[\'aubrey_interact\'] = (Q[\'aubrey_interact\'] || 0) + 1;"}],"goTo":[{"id":"birthday.prepare"}],"content":[{"type":"paragraph","content":"Aubrey... well, she\'s probably your friend. She\'ll want to come to this thing."},{"type":"paragraph","content":"You can text Aubrey asking if she wants to come to your birthday party. Should you though? What would you say? Okay. Just send the message and it\'ll be fine."},{"type":"paragraph","content":"\\"My parents said that your parents told them about this\\", she replies, and you cringe. \\"Sure, I\'ll come,\\" she texts next."}]},"christmas_break.homework":{"id":"christmas_break.homework","maxVisits":1,"options":[{"id":"@christmas_break.read","title":"Read."}],"content":[{"type":"paragraph","content":"Yes, of course there is homework over Christmas break. Who do you think you are? The first semester isn\'t technically over until the end of January, so you still have finals to contend with."},{"type":"paragraph","content":"It feels too early to be doing homework, but you get started anyway. There\'s a book that you\'re supposed to be reading for AP Lit, so why not just start on that."}],"countVisitsMax":1},"christmas_party.freeze_1":{"id":"christmas_party.freeze_1","options":[{"id":"@christmas_party.see_her","title":"It\'s Emily for sure."}],"content":[{"type":"paragraph","content":"You freeze for a moment. Is Emily here? It could be just a coincidence. You try to run the probability calculations; how many teenagers have that name in the area? It can\'t be that many; there are only tens of thousands of Chinese people around here. How likely are they to be acquainted with the Gao family? How many Chinese Christmas parties are going on in the Boston area at this time?"},{"type":"paragraph","content":"\\"Hey, are you coming?\\", Aubrey says, breaking your attempt at a Fermi calculation."},{"type":"paragraph","content":"\\"Um, yeah. Sure.\\""}]},"church_1.love":{"id":"church_1.love","options":[{"id":"@church_1.stop","title":"The car stops."}],"content":{"content":"She was probably your first crush, before you knew what a crush was, before you even knew you \\"liked girls\\". You\'ve known her since you first moved here, right before middle school. She goes to the same school, and her dad was your dad\'s coworker back when he had a job, so naturally you became playmates. And you were sort of obsessed with her. You always wanted to hang out with her, and felt strange when you saw her with her other friends. But of course it never consciously occurred that...","type":"paragraph"}},"church_2.aubrey":{"id":"church_2.aubrey","onArrival":[{"$code":"Q[\'aubrey_interact\'] = (Q[\'aubrey_interact\'] || 0) + 1;"}],"options":[{"id":"@church_2.homework","title":"Ask her about homework."},{"id":"@church_2.wang","title":"Ask her about Wang Laoshi."}],"content":{"content":"What are you going to say, though? You sit next to her, and hope that she talks to you first. Why does this always happen.","type":"paragraph"}},"church_3.bible_study":{"id":"church_3.bible_study","options":[{"id":"@church_3.bible_study_over","title":"Thankfully, the Bible reading session ends."}],"content":{"type":"paragraph","content":["You try to follow along as the adults read some verses. Not well, given that you\'re semi-literate at best. But Aubrey apparently can read Chinese far better than you, just like with everything else. When it\'s your turn to read, you say, ",{"type":"emphasis-1","content":"\\"Sorry, I don\'t know how to read.\\""}," The adults laugh. Mom takes the turn to read instead. You look over at Aubrey, and she grins at you."]}},"classes_1.miri":{"id":"classes_1.miri","options":[{"id":"@classes_1.meet_miri","title":"You asked Miri to meet you in one of the music practice rooms."}],"content":[{"type":"paragraph","content":"If you\'re going to do this pageant thing, you need friends to help you prepare. Well, friend, rather. Her name is Miriam Brooks, but everyone calls her Miri. She\'s not someone your parents exactly approve of, but she is your one friend. Probably."},{"type":"paragraph","content":"You still don\'t know how the two of you became friends, since she and you have nothing in common. She\'s loud, rambunctious, and outgoing, while you have to be dragged out of your personal alcoves. She\'s into anime and video games, and you\'re into molecular biology and 19th century Russian literature (and anime and video games too, unfortunately). She has plenty of other friends, but somehow she sticks with you. Opposites attract, maybe? Well, not that way, probably."}]},"emily_1.stare":{"id":"emily_1.stare","options":[{"id":"@emily_1.emily_2","title":"Sure."}],"content":[{"type":"paragraph","content":"Emily is still Emily, the girl you met at the pageant pre-meeting. She\'s Asian, skinny, and about your height. Her attire is still entirely black, a black dress and black coat and black tights and black shoes. She has tussled shoulder-length hair, worn loosely this time, and what looks like loads of makeup, not that you really know anything about that. Her expression is guarded, and she\'s constantly looking around the room, as if scanning for dangers."},{"type":"paragraph","content":"She looks you in the eye. You must have been staring, so you look away. \\"So, uh, did you want to talk about the pageant?\\""}]},"emily_3_online.go_on":{"id":"emily_3_online.go_on","options":[{"id":"@emily_3_online.sure","title":"\\"Um, sure...?\\""}],"content":[{"type":"paragraph","content":"You: It\'s alright... you don\'t have to talk about it if you don\'t want to?"},{"type":"paragraph","content":"Emily: No I kind of have to. It\'s now or never."},{"type":"paragraph","content":"Emily: Okay. I\'m trans."},{"type":"paragraph","content":"Emily: Do you know what that means?"}]},"emily_2.else":{"id":"emily_2.else","options":[{"id":"@emily_2.thanks","title":"Let her buy the clothes for you."},{"id":"@emily_2.thanks_2","title":"Buy them yourself."},{"id":"@emily_2.thanks_3","title":"Don\'t buy anything."}],"content":[{"type":"paragraph","content":"You\'ve never liked shopping, and liked wearing dresses even less."},{"type":"paragraph","content":"\\"Um... how will this help me in the pageant? Maybe we could go somewhere else?\\""},{"type":"paragraph","content":"\\"Oh. Sorry.\\" Emily takes the pile back. \\"God, I\'m just always thinking about myself. So what do you want to do?\\""},{"type":"paragraph","content":"\\"Um, I don\'t know. Maybe... go somewhere else?\\""},{"type":"paragraph","content":"\\"Okay. I\'ll buy these for you and let\'s go, uh, somewhere else.\\""}]},"emily_4.no_idea":{"id":"emily_4.no_idea","options":[{"id":"@emily_4.omniscient","title":"An omniscient deity is compelling you to talk to her."},{"id":"@emily_4.like","title":"You like Emily. Like, like her."},{"id":"@emily_4.pageant","title":"You really actually do care about the pageant."},{"id":"@emily_4.more","title":"Two or more of the above."}],"content":[{"type":"paragraph","content":"The meeting this week has been infected with a strange miasma, a reminder of the previous online conversation."},{"type":"paragraph","content":"What are you supposed to say to that?"}]},"emily_6.or":{"id":"emily_6.or","options":[{"id":"@emily_6.anyway","title":"Anyway..."}],"content":{"content":"No, that\'s not right. Or is it?","type":"paragraph"}},"emily_7.idk_1":{"id":"emily_7.idk_1","options":[{"id":"@emily_7.confess_emily","title":"Confess your (potential?) feelings for Emily."},{"id":"@emily_7.silence","title":"Revel in the silence."}],"content":[{"type":"paragraph","content":"\\"Um, I don\'t know?\\""},{"type":"paragraph","content":"Emily sighs. \\"Sorry I kind of unloaded there. Forget about it.\\""},{"type":"paragraph","content":"Her voice trails away. You don\'t know how to fill the silence. Or..."}]},"emily_final.why":{"id":"emily_final.why","viewIf":{"$code":"return ((Q[\'emily_why_seen\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'emily_why_seen\'] = 1;"}],"options":[{"id":"@emily_final.where","title":"\\"Where would you go?\\""},{"id":"@emily_final.convince_me_no","title":"\\"Do you want me to tell you not to go?\\""}],"content":[{"type":"paragraph","content":"You: Why do you want to run away?"},{"type":"paragraph","content":"Emily: It\'s getting kind of bad."},{"type":"paragraph","content":"You: What is?"},{"type":"paragraph","content":"Emily: Many things."},{"type":"paragraph","content":"Emily: Just, living in this space makes me want to, idk, engage in potentially self-destructive behaviors."},{"type":"paragraph","content":"Emily: God it\'s so fucking hard to talk about this without sounding like some cringy emo loser."},{"type":"paragraph","content":"Emily: And of course my parents feed and clothe me and let me live in this house that\'s way too big and therefore I\'m an ungrateful b8tch."},{"type":"paragraph","content":"Emily: But it\'s becoming difficult to handle it."},{"type":"paragraph","content":"You: You\'re not a loser or anything like that..."},{"type":"paragraph","content":"Emily: Thanks."}]},"epilogue.ep_pageant_win":{"id":"epilogue.ep_pageant_win","viewIf":{"$code":"return ((Q[\'pageant_success\'] || 0)===1);"},"maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"content":[{"type":"paragraph","content":"Winning the regional pageant gives you new opportunities and responsibilities. But before anything else, mom doesn\'t stop. She heaps more praise upon you than she ever has in the past. She makes hour-long WeChat calls to relatives back in Xi\'an and Changchun, often talking about how surprising that her daughter succeeded in an American beauty competition. You try to avoid listening to her talk about you, but it\'s difficult."},{"type":"paragraph","content":"As the winner of the regional pageant, you\'ve qualified for the state pageant, and if you win that, you go all the way to nationals. Even as just the regional pageant winner, you still have some responsibilities, like showing up to various social functions and community gatherings and the like. It\'s anxiety-inducing as usual, and you have to pretend to be someone you\'re not, but it gets better over time. Now it\'s mostly just boring."},{"type":"paragraph","content":"Of course you don\'t end up winning the state pageant. But that\'s a different story."}],"countVisitsMax":1},"family_3.listen":{"id":"family_3.listen","options":[{"id":"@family_3.ivf","title":"What about sperm donation and IVF and stuff like that?"},{"id":"@family_3.trans","title":"What about trans people?"},{"id":"@family_3.ips","title":"What about, uh, new stem cell technologies?"},{"id":"@family_3.nothing","title":"Say nothing."}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Why did you think of that?\\""}," your mother says in Chinese. Kevin knows Chinese, but doesn\'t speak it."]},{"type":"paragraph","content":"\\"I was just wondering.\\" You think about why he would be wondering. Did you mention anything to him anytime? You hope to God he doesn\'t implicate you."},{"type":"paragraph","content":"\\"No. That\'s impossible, of course.\\""},{"type":"paragraph","content":"You imagine that your father is addressing you as he says this, even though you\'re pretty sure no one in your family knows. You imagine that it\'s an attack against you, against your \\"chosen lifestyle.\\" You\'re not sure if it\'s a good thing or bad thing that your brother doesn\'t know anyone with two moms."}]},"family_5.freeze":{"id":"family_5.freeze","options":[{"id":"@family_5.freeze_2","title":"Wait."},{"id":"@family_5.leave","title":"Try to get out of here."}],"content":[{"type":"paragraph","content":"You freeze. Your mind empties. It\'s as if your brain is encased in ice."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"I looked at the books you borrowed.\\""}," He lets out a breath, and shakes his head."]},{"type":"paragraph","content":"Fuck, why\'d you leave your Sarah Waters books at home? It wasn\'t worth it."}]},"family_2.mom_1":{"id":"family_2.mom_1","options":[{"id":"@family_2.mom_3","title":"Mom continues."},{"id":"@family_2.dad_3","title":"Dad chimes in."}],"content":{"content":"In those days there was no paper or pencil. Instead they wrote on stone tablets. The first characters they learned to write were Chairman Mao\'s name. They practiced writing it on their stone tablets until their hands were sore. Your mom tells you of how she learned to write the character \\"Mao\\" (毛): the hook points at the door, the teacher yelled while hitting her hand with a ruler. Somehow she always remembered that. Dad asks if you know how to write Mao Zedong. You don’t, and he smiles.","type":"paragraph"}},"family_6.keep_happening":{"id":"family_6.keep_happening","options":[{"id":"@family_6.be_careful","title":"”小心开车“"}],"content":[{"type":"paragraph","content":"Kevin glances at you with a knowing look on his face. There\'s no escaping this one. Part of you is glad that dad\'s ire isn\'t directed at you this time. The other part is ashamed for being glad."},{"type":"paragraph","content":["\\"你怎么没想收拾屋子？ ",{"type":"emphasis-1","content":"Why didn\'t you think of cleaning?"},"\\", mom responds."]},{"type":"paragraph","content":["\\"在我们老家谁有这样的媳妇儿？ ",{"type":"emphasis-1","content":"In our old home who would have this kind of wife?"},"\\", dad fires back"]},{"type":"paragraph","content":["\\"我每天上班赚钱，你干什么阿？你每天家里蹲，看电视。 ",{"type":"emphasis-1","content":"Everyday I go to work and make money, and what do you do? You sit at home, watch TV."},"\\""]},{"type":"paragraph","content":["Mom continues on her argument. \\"家里谁赚钱阿？房租，饭钱从哪儿来的阿？你真觉得你自己了不起吗？ ",{"type":"emphasis-1","content":"Who makes money in our family? Where does the rent and money for food come from? Do you really think you\'re all that?"},"\\""]},{"type":"paragraph","content":["Mom shoves dad\'s shoulders. Dad slams the steering wheel. ”我在开车！",{"type":"emphasis-1","content":"I\'m driving!"},"“ He pumps the brakes. Honks come from behind."]}]},"family_final.mom_1":{"id":"family_final.mom_1","options":[{"id":"@family_final.dad_2","title":"Dad talks about his time at school."},{"id":"@family_final.mom_2","title":"Mom talks about her English classes at school."}],"content":[{"type":"paragraph","content":["Mom tells a story about collecting pine needles. At her village school, the teachers would require the students to collect 5 ",{"type":"emphasis-1","content":"jin"}," of pine needles and pine cones from the surrounding woods, in order to burn for heat in the winter. The forest floors would be scraped bare by groups of youth. Now, leaves and needles are allowed to litter the streets and sidewalks. What a waste, mom says."]},{"type":"paragraph","content":"The conversation moves on."}]},"family_4.leave":{"id":"family_4.leave","options":[{"id":"@family_4.dad_1","title":"Dad: \\"没有她我该早有博士了!\\""},{"id":"@family_4.mom_1","title":"Mom: \\"你真得找不着电脑的工作吗?\\""}],"content":{"content":"You get up. Kevin looks at you, with what must be a knowing look. He follows you to your room. They noticed you leaving, but no one stops you. Of course they only get worse from here. There\'s more shouting.","type":"paragraph"}},"introspect_1.still_karen":{"id":"introspect_1.still_karen","goTo":[{"id":"introspect_1.name"}],"onArrival":[{"$code":"Q[\'first_name\'] = \\"Karen\\";"}],"content":{"content":"","type":"paragraph"}},"introspect_2.research":{"id":"introspect_2.research","viewIf":{"$code":"return (((Q[\'research\'] || 0) >= 2) && ((Q[\'seen_research_introspect_2\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'seen_research_introspect_2\'] = 1;"}],"options":[{"id":"@introspect_2.pageant","title":"Think about the pageant."},{"id":"@introspect_2.scioly","title":"Think about science olympiad."},{"id":"@introspect_2.people","title":"Think about the people you know."},{"id":"@introspect_2.self","title":"Think about yourself."},{"id":"@introspect_2.stop","title":"Stop thinking about stuff."}],"content":{"content":"Your research is... progressing? It\'s hard to tell; you\'re not sure what\'s progress and what isn\'t. Stella is nice and so is Professor Chen, for the most part..","type":"paragraph"}},"introspect_3.scioly":{"id":"introspect_3.scioly","maxVisits":1,"viewIf":{"$code":"return ((Q[\'invitational\'] || 0)===1);"},"options":[{"id":"@introspect_3.pageant","title":"Think about the pageant."},{"id":"@introspect_3.research","title":"Think about your research."},{"id":"@introspect_3.people","title":"Think about people you know."},{"id":"@introspect_3.stop","title":"Enough thinking for now."}],"content":{"content":{"type":"paragraph","content":["Well, you attended the invitational, and got ",{"type":"insert","insert":0}," medals. That\'s a somewhat respectable count. However, you still need to do more practice and preparation; the team as a whole is not good enough for the regional or state competitions."]},"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'medal_count\'] || 0);"}}]},"countVisitsMax":1},"loneliness_1.wikipedia":{"id":"loneliness_1.wikipedia","viewIf":{"$code":"return ((Q[\'wiki_seen\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'loneliness\'] = (Q[\'loneliness\'] || 0) - 1;\\nQ[\'wiki_seen\'] = 1;"}],"goTo":[{"id":"loneliness_1.options"}],"content":{"content":"You like starting out at the homepage, click one of the links, and seeing where you end up. Your critical brain shuts down as you absorb knowledge about the populations and political distributions of various UK locales. The UK apparently has a ridiculously convoluted system of local government with a bunch of different layers and uneven administrative divisions that change every few decades. You made it your goal to understand what exactly is a \\"county\\".","type":"paragraph"}},"loneliness_2.contact_miri_2":{"id":"loneliness_2.contact_miri_2","onArrival":[{"$code":"Q[\'loneliness\'] = (Q[\'loneliness\'] || 0) - 1;"}],"options":[{"id":"@loneliness_2.hey","title":"\\"Hello...\\""},{"id":"@loneliness_2.imlonely","title":"\\"I\'m feeling lonely do you want to talk\\""},{"id":"@loneliness_2.forget_about_it","title":"Forget about it."}],"content":{"content":"What should you say? You agonize for minutes over what you could possibly say at this hour.","type":"paragraph"}},"miri_date.um":{"id":"miri_date.um","options":[{"id":"@miri_date.a1","title":"\\"Um...\\""},{"id":"@miri_date.a2","title":"\\"So, how about that upd8?\\""},{"id":"@miri_date.a3","title":"Have a long and meaningful discussion about life, the universe, and everything."}],"content":[{"type":"paragraph","content":"You close your eyes and take several deep breaths, while holding your hands together. There. Your heart is not exploding anymore. Miri does not notice, or does not care."},{"type":"paragraph","content":"This is your first \\"date\\" with Miri, insofar that the previous friendly gatherings could not be considered \\"dates\\" despite the now-recognizeable subtext. Nevertheless, it feels like any of the other encounters you have had with her; the fact that you are apparently in a \\"romantic\\" relationship now still must have not entirely percolated through your mind."},{"type":"paragraph","content":"Her house is within walking distance of yours, a duplex on a side street with a small garden out front. Usually, at least one of her older siblings or parents would be home, but this time, apparently she is alone."},{"type":"paragraph","content":"Oh yeah, what do you want to do with Miri?"}]},"miri_pageant_prep.back_out":{"id":"miri_pageant_prep.back_out","options":[{"id":"@miri_pageant_prep.gym_2","title":"Follow Miri inside."}],"content":[{"type":"paragraph","content":"\\"No, you can\'t just leave now!\\", Miri says, grabbing your arm. \\"You have to do this. I mean, I have to do this too. Just look at my physical manifestation.\\""},{"type":"paragraph","content":"\\"I think you\'re fine the way you are.\\""},{"type":"paragraph","content":"Miri rolls her eyes. \\"Whatever. Let\'s just get it over with.\\""}]},"pageant_prep_pick_ball_gown.dress_2":{"id":"pageant_prep_pick_ball_gown.dress_2","onArrival":[{"$code":"Q[\'ball_gown\'] = 2;"}],"goTo":[{"id":"pageant_prep_pick_ball_gown.done"}],"content":[{"type":"paragraph","content":"The green dress is simple and elegant, and you like the color."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"It looks too simple,\\""}," mom says. ",{"type":"emphasis-1","content":"\\"But if you think it\'s good then it\'s good.\\""}]}]},"pageant_prep_self_2.details":{"id":"pageant_prep_self_2.details","subtitle":"Look up details about the pageant.","viewIf":{"$code":"return ((Q[\'pageant_details\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'pageant_details\'] = (Q[\'pageant_details\'] || 0) + 1;"}],"options":[{"id":"@pageant_prep_self_2.nationals","title":"Go to the nationals website, mabye?"},{"id":"@pageant_prep_self_2.details_2","title":"Look through the paperwork you already have."}],"content":[{"type":"paragraph","content":"The website for the state pageant is very pink. And sparse. So sparse that it barely has any information; where are the forms? Where are the scoring sheets? All the webpage has are some pictures from last year."},{"type":"paragraph","content":["How are people supposed to know anything about the pageant? Do you have to actually ",{"type":"emphasis-1","content":"contact"}," people, like a barbarian?"]}]},"pageant_final.get_up":{"id":"pageant_final.get_up","goTo":[{"id":"pageant_final.cant_get_up"}],"content":{"content":"But you can\'t.","type":"paragraph"}},"pageant_prep_self_final.interview_prep":{"id":"pageant_prep_self_final.interview_prep","viewIf":{"$code":"return ((Q[\'interview_prep_seen\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'interview_prep_seen\'] = 1;\\nQ[\'pageant_interview\'] = (Q[\'pageant_interview\'] || 0) + 1;"}],"options":[{"id":"@pageant_prep_self_final.paperwork_prep","title":"Check the last of the paperwork"},{"id":"@pageant_prep_self_final.appearance_prep","title":"Focus on your appearance"},{"id":"@pageant_prep_self_final.do_nothing","title":"You might as well be done."},{"id":"@pageant_prep_pick_ball_gown","title":"Pick a ball gown."},{"id":"@pageant_prep_try_ball_gown","title":"Try on your ball gown."}],"content":[{"type":"paragraph","content":"There are some last-minute things you could do to prepare for the interview. Read more example questions, practice talking to yourself in the mirror, watch videos of pageant interviews past..."},{"type":"paragraph","content":"You start to despise your voice slightly less. An improvement."}]},"pageant_prep_talent_1.regard":{"id":"pageant_prep_talent_1.regard","options":[{"id":"@pageant_prep_talent_1.remember","title":"Remember your lessons."},{"id":"@pageant_prep_talent_1.play","title":"Play a simple piece."},{"id":"@pageant_prep_talent_1.away","title":"Put it away."}],"content":{"content":"The erhu looks the same as it always had. Two strings, a long neck, a sound box that looks like a drum. It\'s at least 10 years old, a gift from relatives before your family left China. Your parents always guilt-tripped you after you stopped taking lessons. How could you forget your heritage like that, they said, or something like that.","type":"paragraph"}},"pageant_prep_try_ball_gown.okay_1":{"id":"pageant_prep_try_ball_gown.okay_1","options":[{"id":"@pageant_prep_try_ball_gown.okay_2","title":"\\"Okay.\\""}],"content":[{"type":"paragraph","content":"\\"Oh. Okay.\\""},{"type":"paragraph","content":{"type":"emphasis-1","content":"\\"You have to learn how to walk in this. You need good posture.\\""}}]},"research_2.fine":{"id":"research_2.fine","options":[{"id":"@research_2.ok","title":"Sure."}],"content":[{"type":"paragraph","content":"\\"It was fine. I think I understood, um, some of it? And yeah...\\""},{"type":"paragraph","content":"Stella smiles at you and says, \\"Don\'t worry too much. It\'ll take some time. Do you want to talk about some things now?\\""}]},"pageant_meetup.calm":{"id":"pageant_meetup.calm","viewIf":{"$code":"return ((Q[\'mandatory_meeting_calm\'] || 0) < 3);"},"onArrival":[{"$code":"Q[\'mandatory_meeting_calm\'] = (Q[\'mandatory_meeting_calm\'] || 0) + 1;"}],"options":[{"id":"@pageant_meetup.calm","title":"Breathe."},{"id":"@pageant_meetup.next","title":"Just enter."}],"content":{"content":{"type":"paragraph","content":[{"type":"insert","insert":0},"..."]},"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'mandatory_meeting_calm\'] || 0);"}}]}},"research_3.not_really":{"id":"research_3.not_really","goTo":[{"id":"research_3.thanks"}],"content":[{"type":"paragraph","content":"\\"Um, not really... it must have been easy...\\""},{"type":"paragraph","content":"\\"No, that\'s not true. I certainly couldn\'t have done this when I was in high school.\\""}]},"research_4.present":{"id":"research_4.present","options":[{"id":"@research_4.present_1","title":"And now what?"}],"content":{"content":"The room is centered around a big oval table, with a projector screen on the opposite side from the door. You walk to the front. Professor Chen\'s laptop has your first slide projected.","type":"paragraph"}},"research_5.work":{"id":"research_5.work","onArrival":[{"$code":"Q[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"options":[{"id":"@research_5.thanks","title":"\\"Thanks?\\""}],"content":{"content":[{"type":"paragraph","content":"Always more work. As if you didn\'t have enough to do already. Along with school, more school, scioly, and the pageant. Oh God the pageant. That\'s something that you have to do. The thought petrifies you even right now, even as you\'re supposed to be doing science..."},{"type":"paragraph","content":["\\"Hey ",{"type":"insert","insert":0},"?\\", you hear Stella say. You remember that you\'re supposed to talk right now. Or something like that."]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"research_6.not_ready":{"id":"research_6.not_ready","options":[{"id":"@research_6.stella","title":"Talk to Stella?"}],"content":[{"type":"paragraph","content":"For whatever reason, you\'re having second thoughts. It\'s a step into the unknown, a foray into a new place in the world that you have no control over."},{"type":"paragraph","content":"On the other hand, even if you fail, you are not essential to the project and can always be replaced. Always a comforting thought."}]},"research_final.quantum":{"id":"research_final.quantum","options":[{"id":"@research_final.stella_walks_in","title":"You see a shadow."}],"content":{"content":"You\'ve been reading popular articles about some of the more unintuitive implications of quantum mechanics. Schroedinger\'s cat, yes. And quantum immortality (the whole concept throws you for a loop; the more you read, the less you are sure of anything in reality). And the fact that you are far more likely to be a Boltzmann brain than anything else, based on certain thermodynamic assumptions or something like that. And there\'s quantum computing which can break various forms of encryption! Who can forget that?","type":"paragraph"}},"research_pass.forgot":{"id":"research_pass.forgot","content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"I just forgot.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Is that really true?\\""},""]},{"type":"paragraph","content":["\\"Yeah. ",{"type":"emphasis-1","content":"It is."},"\\""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"You\'re going to meet him soon?\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Okay.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Good.\\""},""]},{"type":"paragraph","content":"She leaves the room, leaving the door open."}]},"research_pass":{"id":"research_pass","type":"scene","title":"Research","subtitle":"A reminder or warning","viewIf":{"$code":"return ((((Q[\'week\'] || 0) > 5) && ((Q[\'week\'] || 0) < 10)) && ((Q[\'research\'] || 0)===0));"},"tags":["research","top"],"priority":2,"options":[{"id":"@research_pass.dont_want","title":"\\"I don\'t want to.\\""},{"id":"@research_pass.forgot","title":"\\"I just forgot.\\""}],"content":[{"type":"paragraph","content":"You hear a knock on the door. It opens. Mom is there."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Professor Chen says you still haven\'t met him.\\""},""]},{"type":"paragraph","content":"\\"Oh. Sorry.\\""},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Why haven\'t you talked to him? I told him you would meet him. I don\'t want to be a liar. Is it too far away? I can drive you if I have time.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"It\'s not because...\\""},""]},{"type":"paragraph","content":{"type":"emphasis-1","content":"\\"Then why?\\""}}]},"root.debug_credits":{"id":"root.debug_credits","title":"Achievements and Credits","subtitle":"Go to ending","viewIf":{"$code":"return ((Q[\'week\'] || 0)===0);"},"goTo":[{"id":"achievements"}],"content":{"content":"","type":"paragraph"}},"root":{"id":"root","type":"scene","onArrival":[{"$code":"Q[\'debug_mode\'] = 1;"}],"minChoices":3,"maxChoices":8,"goTo":[{"id":"root.game_start","predicate":{"$code":"return ((Q[\'week\'] || 0)===0);"}}],"newPage":true,"options":[{"id":"#debug"},{"id":"#enter_weekend"},{"id":"#loneliness"},{"id":"#stress"},{"id":"#introspect"},{"id":"#pageant_prep"},{"id":"#social"},{"id":"#research"},{"id":"#scioly"},{"id":"#family"},{"id":"#christmas"},{"id":"#epilogue"}],"content":{"content":[{"type":"heading","content":"Weekly Activities"},{"type":"paragraph","content":["Week: ",{"type":"insert","insert":0},""]},{"type":"paragraph","content":["Activities remaining: ",{"type":"insert","insert":1},""]},{"type":"paragraph","content":[{"type":"conditional","content":"The pageant can\'t be the only thing you spend your time on. As a top university-bound student you need to have, in addition to a full load of AP classes, a full portfolio of extracurricular activities and leadership opportunities filling up every moment of every waking hour. Okay, that was an exaggeration. But not by much. You\'re a part of the science olympiad team, and everyone\'s counting on you to help carry the team or something. Also, you\'re supposed to be working with a professor (whom your mom set you up with) on a research project. And somewhere along the way your parents and brother want to see you at home for dinner. And don\'t forget more pageant prep. ","predicate":2},""]},{"type":"paragraph","content":[{"type":"conditional","content":"There\'s a quiz in AP Calc on differentiation techniques. Obviously you\'re already prepared. There\'s also a lab in AP Chem, like there is every week. ","predicate":3},""]},{"type":"paragraph","content":[{"type":"conditional","content":["In AP Lit, you\'ve been reading ",{"type":"emphasis-1","content":"Oryx and Crake"}," by Margaret Atwood. You seem to be enjoying the book more than most people in the class. Maybe because you have a thing for morally ambiguous biologists. "],"predicate":4},""]},{"type":"paragraph","content":[{"type":"conditional","content":"In AP Lit, you have to write an essay about how symbolism is used to illustrate the themes present in the book. Did the book even have any symbolism? It was all rather straightforward. ","predicate":5},""]},{"type":"paragraph","content":[{"type":"conditional","content":"AP World is starting on the middle ages in Asia. Given that half the class is Asian, you\'re almost surprised the teacher didn\'t make any snide remarks. ","predicate":6},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Mom asks you why you haven\'t met with Professor Chen for research yet. You didn\'t have a good answer. ","predicate":7},""]},{"type":"paragraph","content":[{"type":"conditional","content":"You\'ve made approximately zero progress on pageant preparations. Maybe you should get started? ","predicate":8},""]},{"type":"paragraph","content":[{"type":"conditional","content":"This is the week of Thanksgiving break. Your AP teachers aren\'t letting you out easy, though. ","predicate":9},""]},{"type":"paragraph","content":[{"type":"conditional","content":["This week there\'s an exam in AP Chem on thermodynamics. And in AP Lit, you\'re starting to read Hemingway\'s ",{"type":"emphasis-1","content":"A Farewell to Arms"},". "],"predicate":10},""]},{"type":"paragraph","content":[{"type":"conditional","content":"AP Calc is starting to talk about integrals now. It\'s about time, some of the super math nerds say. You have no opinion one way or the other. ","predicate":11},""]},{"type":"paragraph","content":[{"type":"conditional","content":"The science olympiad invitational is this weekend. You should probably get ready, or something like that. ","predicate":12},""]},{"type":"paragraph","content":[{"type":"conditional","content":"AP Chem has a memorize-the-periodic-table quiz, somehow going along with all the quantum stuff that\'s also being covered. ","predicate":13},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Winter break is almost here. The teachers are more anxious if anything; there\'s an essay in AP Lit, a quiz in Calc, and one last pre-Christmas lab in Chem. ","predicate":14},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Winter break is here. There\'s no more school, but that doesn\'t mean that you have any shortage of responsibilities. ","predicate":15},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Winter break is over, and the pageant is next weekend. You should probably get ready if you haven\'t already. ","predicate":16},""]},{"type":"paragraph","content":{"type":"conditional","content":"The pageant is over. What happens next?","predicate":17}}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'week\'] || 0);"}},{"type":"insert","fn":{"$code":"return (3 - (Q[\'week_progress\'] || 0));"}},{"type":"predicate","fn":{"$code":"return ((Q[\'week\'] || 0)===1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'week\'] || 0)===1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'week\'] || 0)===2);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'week\'] || 0)===3);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'week\'] || 0)===4);"}},{"type":"predicate","fn":{"$code":"return (((Q[\'week\'] || 0)===4) && ((Q[\'research\'] || 0)===0));"}},{"type":"predicate","fn":{"$code":"return (((Q[\'week\'] || 0) >= 4) && ((Q[\'pageant_prep\'] || 0) <= 2));"}},{"type":"predicate","fn":{"$code":"return ((Q[\'week\'] || 0)===5);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'week\'] || 0)===6);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'week\'] || 0)===7);"}},{"type":"predicate","fn":{"$code":"return (((Q[\'week\'] || 0)===7) && ((Q[\'scioly\'] || 0) >= 2));"}},{"type":"predicate","fn":{"$code":"return ((Q[\'week\'] || 0)===8);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'week\'] || 0)===9);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'week\'] || 0)===10);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'week\'] || 0)===11);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'week\'] || 0)===100);"}}]}},"scioly_1.maybe":{"id":"scioly_1.maybe","goTo":[{"id":"scioly_1.alright"}],"content":{"content":"\\"Um...\\"","type":"paragraph"}},"scioly_invitational.disease_detectives":{"id":"scioly_invitational.disease_detectives","options":[{"id":"@scioly_invitational.disease_good","title":"Well."},{"id":"@scioly_invitational.disease_okay","title":"Fine."},{"id":"@scioly_invitational.disease_bad","title":"Poorly."}],"content":[{"type":"paragraph","content":"You and the captain head towards the first event, at 9AM in a nondescript classroom. Soon other students from other schools fill in. The other schools are mostly rich suburban schools with far more resources than yours;"},{"type":"paragraph","content":"The test goes..."}]},"scioly_pass.dont_go":{"id":"scioly_pass.dont_go","options":[{"id":"@scioly_pass.go","title":"Actually, you change your mind."},{"id":"@scioly_pass.tell_pageant","title":"Tell him about the pageant."},{"id":"@scioly_pass.excuse","title":"Make up an excuse."}],"content":[{"type":"paragraph","content":"\\"Actually, I\'m don\'t know if I\'m doing SciOly this year...\\""},{"type":"paragraph","content":"\\"What? Why not?\\" He looks surprised and disappointed."}]},"shopping_with_mom.red_dress":{"id":"shopping_with_mom.red_dress","options":[{"id":"@shopping_with_mom.buy_red_dress","title":"Buy it."},{"id":"@shopping_with_mom.pick_dress","title":"Look at others."}],"content":[{"type":"paragraph","content":"This is by far the cheapest, at only $15. It\'s pretty, but it feels too short for comfort, like it\'s revealing too much of your legs. As you put it on, it feels kind of uncomfortable, the fabric chafing against your skin."},{"type":"paragraph","content":"But maybe that\'s not so bad..."}]},"research_1.breathe":{"id":"research_1.breathe","onArrival":[{"$code":"Q[\'research_1_breathe\'] = (Q[\'research_1_breathe\'] || 0) + 1;"}],"viewIf":{"$code":"return ((Q[\'research_1_breathe\'] || 0) <= 2);"},"options":[{"id":"@research_1.breathe","title":"Breathe."},{"id":"@research_1.knock","title":"Just knock."}],"content":{"content":[{"type":"paragraph","content":"It\'ll be okay..."},{"type":"paragraph","content":[{"type":"insert","insert":0},"..."]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'research_1_breathe\'] || 0);"}}]}},"skip.w5_pageant_1":{"id":"skip.w5_pageant_1","onArrival":[{"$code":"Q[\'pageant_prep\'] = 4;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 2;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 2;\\nQ[\'pageant_details\'] = (Q[\'pageant_details\'] || 0) + 1;\\nQ[\'pageant_paperwork\'] = (Q[\'pageant_paperwork\'] || 0) + 1;\\nQ[\'pageant_platform\'] = (Q[\'pageant_platform\'] || 0) + 1;\\nQ[\'platform_doc_completed\'] = (Q[\'platform_doc_completed\'] || 0) + 1;"}],"goTo":[{"id":"skip.w5_scioly_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.go_in":{"id":"scioly_study_party.go_in","options":[{"id":"@scioly_study_party.get_food1","title":"Get some food?"},{"id":"@scioly_study_party.get_food2","title":"Food is good."},{"id":"@scioly_study_party.get_food3","title":"Food is necessary for human homeostasis."}],"content":[{"type":"paragraph","content":"The captain waits for you to enter before closing the door."},{"type":"paragraph","content":"\\"So, food is here, and groups are already studying. Most of us are in the basement. Have fun!\\" He then runs off to appease another group of students."},{"type":"paragraph","content":"You stand in the living room, alone now. There is the kitchen, with a post-it note with an arrow labeled \\"free food!!!\\"."}]},"stress_1.work":{"id":"stress_1.work","onArrival":[{"$code":"Q[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"content":[{"type":"paragraph","content":"You can barely move your body. But you try anyway, shifting this way and that until you\'re out of bed. The homework looks like a jumble of letters, the text undiscernable. But still, you manage to focus, and read a couple of pages before collapsing, lying on your desk with your eyes closed until mom opens the door."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Why is the light closed?\\""},", she asks, and turns on the light. Your eyes burn."]}]},"stress_1":{"id":"stress_1","type":"scene","title":"Feeling tired","subtitle":"Home, Afternoon","newPage":true,"viewIf":{"$code":"return ((((Q[\'stress\'] || 0) > 6) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'week\'] || 0) < 100));"},"onArrival":[{"$code":"Q[\'stress\'] = (Q[\'stress\'] || 0) - 3;\\nQ[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;"}],"maxVisits":3,"priority":3,"tags":["top","stress"],"options":[{"id":"@stress_1.sleep","title":"Sleep."},{"id":"@stress_1.work","title":"Go back to work."}],"content":{"content":"It\'s a rare afternoon that you have to yourself, staying in your room while Kevin is playing with your parents. You\'re barely awake, and your brain is racing. Maybe it\'s better to take a nap. But you have stuff to do: readings in AP World, AP Lit, a test on friday in AP Calc... not to mention research, science olympiad, pageant prep,...","type":"paragraph"},"countVisitsMax":3},"stress_full.wake_up":{"id":"stress_full.wake_up","options":[{"id":"@stress_full.excused","title":"Sure, a break would be nice."},{"id":"@stress_full.no_excuse","title":"School is more important."}],"content":{"content":[{"type":"paragraph","content":"Perhaps you should have expected this, after having spent the last weeks sleeping only a few hours each night. With everything that\'s been going on, you haven\'t had much time to sleep. And the insomnia has been overwhelming; as you get more tired, more busy, more stressed, you become less able to sleep. It\'s a vicious cycle."},{"type":"paragraph","content":["\\"",{"type":"insert","insert":0},"? Are you okay?\\" Some voice calls to you."]},{"type":"paragraph","content":"Your eyes finally open. The school nurse, with whom you only had a passing acquaintance, comes into your view."},{"type":"paragraph","content":"\\"Sorry, I wasn\'t feeling very well,\\" is what you manage to say."},{"type":"paragraph","content":"\\"Well you certainly weren\'t! You know you passed out, right?\\""},{"type":"paragraph","content":"The nurse fusses over you, offers to call your parents. You decline."},{"type":"paragraph","content":"\\"You should get something nice to eat,\\" she says. \\"Plus some rest. We can get you excused from classes for the rest of the day, if that\'s okay? It\'s fourth period. You can go bac home to rest.\\""}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"thanksgiving_party.someone":{"id":"thanksgiving_party.someone","viewIf":{"$code":"return ((Q[\'research\'] || 0)===0);"},"goTo":[{"id":"thanksgiving_party.hate"}],"content":{"content":"He was your parents\' classmate at Jilin University. He left for his PhD in the US, while your parents stayed in China. Beyond that, you know next to nothing about him. He\'s relatively rich, with a big house. He apparently has a son about your age.","type":"paragraph"}},"stress_2.put_it_off":{"id":"stress_2.put_it_off","options":[{"id":"@stress_2.browse_internet","title":"Browse the internet."},{"id":"@stress_2.nap","title":"Take a nap."}],"content":{"content":"You\'ll have time later in the day, right? You can relax for a little bit right now.","type":"paragraph"}},"weekend_alone.stay_in":{"id":"weekend_alone.stay_in","viewIf":{"$code":"return ((Q[\'stay_in_count\'] || 0) < 3);"},"onArrival":[{"$code":"Q[\'stay_in_count\'] = (Q[\'stay_in_count\'] || 0) + 1;"}],"options":[{"id":"@weekend_alone.stay_in","title":"Stay in bed."},{"id":"@weekend_alone.get_up","title":"Get up."},{"id":"@weekend_alone.get_up_for_real","title":"Get up for real."}],"content":{"content":"It\'s so easy to stay in bed. To lie in, doing nothing. To run through fictional scenarios in your mind. Alternate universes where everything is either much better or much worse. Think about how things could be if you were someone else, someone altogether different living in a place where the physical laws do not necessitate that you have to feel so tired all the time.","type":"paragraph"}},"scioly_2.aubrey_scioly_2":{"id":"scioly_2.aubrey_scioly_2","options":[{"id":"@scioly_2.protein_study","title":"\\"I can do the knowledge thing...\\""},{"id":"@scioly_2.protein_either","title":"\\"Either is fine...\\""}],"content":{"content":"\\"So, how do you want to split this?\\", Aubrey asks, breaking the silence.","type":"paragraph"}},"scioly_final.maybe":{"id":"scioly_final.maybe","goTo":[{"id":"scioly_final.captain_continues"}],"content":{"content":"Maybe you could be captain? You would have to take much greater responsibility than before, and actually talk to people, but it could be done...","type":"paragraph"}},"1.c3":{"id":"1.c3","options":[{"id":"@1.um","title":"\\"Um...\\""},{"id":"@1.okay","title":"\\"Okay?\\""},{"id":"@1.not","title":"\\"Not really...\\""}],"content":[{"type":"paragraph","content":["\\"秋怡，快点出来。有一件事。",{"type":"emphasis-1","content":"Qiuyi, come out. I have something to tell you."},"\\" A pretty usual command in mom\'s sharp Mandarin. You\'ve never been able to parse the tone of her voice. There\'s no way to tell if she\'s going to yell at you or congratulate you or if she\'s just telling you that dinner is ready. Whatever it is, she\'ll only chew you out more if you stay on your computer. So you head to the living room, where she\'s standing behind the table, across from your dad."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Do you want to join a"}," beauty pageant?\\", she asks, except it\'s not really a question."]}]},"aubrey_final.introspect_date":{"id":"aubrey_final.introspect_date","options":[{"id":"@aubrey_final.getting_off","title":"You disembarked at Downtown Crossing..."}],"content":[{"type":"paragraph","content":"You were going on a date with your long term crush? This should have been a moment of supreme happiness and supreme nervousness. However you only felt moderate happiness and moderate nervousness."},{"type":"paragraph","content":"It didn\'t feel like you were embarking on a date. You weren\'t nervous enough. Your heart was not pounding its way through your chest. Your stomach was not twisting itself into knots. So it was fine. Too fine."},{"type":"paragraph","content":"You did not talk much more on the train. You do not particularly enjoy talking on trains given the level of noise present, and it seemed that Aubrey agreed."}]},"birthday.no_invite":{"id":"birthday.no_invite","options":[{"id":"@birthday.no_celebrate","title":"Don\'t have any celebration."},{"id":"@birthday.family","title":"Let your parents decide on something."}],"content":{"content":"So you\'ll celebrate your birthday with your family? And no one else? Or not have a birthday celebration at all?","type":"paragraph"}},"christmas_break.read":{"id":"christmas_break.read","goTo":[{"id":"christmas_break.end_homework"}],"onArrival":[{"$code":"Q[\'gpa\'] = (Q[\'gpa\'] || 0) + 0.01;"}],"content":{"content":"You spend some time reading the novel. It\'s supposedly a classic, a great work of American literature from the 19th century, so it\'s rather difficult to get into. It takes an hour just to read through the first few chapters, while taking notes.","type":"paragraph"}},"christmas_party.see_her":{"id":"christmas_party.see_her","options":[{"id":"@christmas_party.feeling_good","title":"Feeling good?"},{"id":"@christmas_party.feeling_bad","title":"Feeling bad?"},{"id":"@christmas_party.feeling_neutral","title":"I don\'t know?"}],"content":[{"type":"paragraph","content":"You see Emily Chen sitting on the floor in Aubrey\'s room. She looks at you. You look at her. She has no reaction. You hope you\'re having no reaction."},{"type":"paragraph","content":"Your parents never told you about them coming; you\'d think that mom would have known, and would have told you, so at least you could prepare. You didn\'t see Professor Chen downstairs. The Chens aren\'t even Christian, as far as you know. So why are they here? Are you feeling good or bad about it?"}]},"church_1.stop":{"id":"church_1.stop","options":[{"id":"@church_1.look","title":"Stare at Aubrey."},{"id":"@church_1.hi","title":"\\"Um, hi.\\""}],"content":{"content":[{"type":"paragraph","content":["You get off, helping mom carry a pot of soup. She presses the doorbell. Out comes Aubrey\'s mom to take the pot from your hands. ",{"type":"emphasis-1","content":"\\"进来，进来！Come in, come in!\\""},""]},{"type":"paragraph","content":"The \\"children\\" are in the basement, \\"children\\" referring to anyone young enough to prefer English to Chinese. You and your younger brother Kevin go downstairs."},{"type":"paragraph","content":"Downstairs you find Spencer Zhang and Aubrey Gao. Spencer also goes to your high school, but he\'s a senior. They\'re watching over the younger kids, who are watching some Japanese cartoon. Your brother joins them."},{"type":"paragraph","content":["\\"Hi, ",{"type":"insert","insert":0},".\\" Aubrey waves to you."]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"church_2.homework":{"id":"church_2.homework","goTo":[{"id":"church_2.aubrey_start"}],"content":[{"type":"paragraph","content":"\\"So, uh, how\'s the chem homework?\\""},{"type":"paragraph","content":"\\"I just finished before coming here. It\'s really not that bad.\\""},{"type":"paragraph","content":"\\"Oh. Uh, thanks.\\""},{"type":"paragraph","content":"\\"Yeah. If you have any questions just ask me.\\""},{"type":"paragraph","content":"\\"Thanks.\\""},{"type":"paragraph","content":"You go back to eating silently. The silence lasts for a few minutes, until Aubrey starts talking to you again."}]},"church_3.bible_study_over":{"id":"church_3.bible_study_over","options":[{"id":"@church_3.scream_2","title":"And after it ends, you hear your brother\'s screaming from the basement."}],"content":{"content":"It seems like forever before it ends, but it does.","type":"paragraph"}},"classes_1.meet_miri":{"id":"classes_1.meet_miri","options":[{"id":"@classes_1.look","title":"Stare at Miri."},{"id":"@classes_1.attractive","title":"Pageant step 1: appearance."}],"content":[{"type":"paragraph","content":"It was an emergency text at around 1AM last night/morning, while you were high on sleep deprivation and internet browsing and generalized loneliness. She responded not long after (maybe that\'s why you\'re friends; she\'s the only person with the same circadian rhythm as you), and agreed to meet today."},{"type":"paragraph","content":"The two of you are in a tiny soundproof room, she sitting at a piano bench, you leaning against the door."},{"type":"paragraph","content":"\\"I still can\'t believe you\'re serious about this pageant thing,\\" she says. \\"And why are you asking me for help of all people? You do know that I\'m like, the antithesis of the kind of people who do pageants, right?\\""},{"type":"paragraph","content":"You shrug. \\"You\'re better than me at that sort of thing, at least.\\""},{"type":"paragraph","content":"Miri laughs. \\"Fine, if you say so.\\""}]},"emily_1.emily_why":{"id":"emily_1.emily_why","options":[{"id":"@emily_1.emily_2","title":"Sure..."}],"content":[{"type":"paragraph","content":"Suddenly you wonder why you\'re here. Why did you accept Emily\'s invitation? Because you were interested in what she had to say regarding the pageant? Or for another reason entirely?"},{"type":"paragraph","content":"She looks you in the eye. You must have been staring, so you look away. \\"So, uh, did you want to talk about the pageant?\\""}]},"emily_3_online.sure":{"id":"emily_3_online.sure","options":[{"id":"@emily_3_online.what","title":"\\"What were we doing, anyway?\\""}],"content":[{"type":"paragraph","content":"You: Um, sure...?"},{"type":"paragraph","content":"Emily: Okay, so, like, I was coercively assigned male at birth..."},{"type":"paragraph","content":"Emily: And now I definitively am not..."},{"type":"paragraph","content":"You: I know."},{"type":"paragraph","content":"Emily: Oh."},{"type":"paragraph","content":"You: Wait, I didn\'t know, I mean, like"},{"type":"paragraph","content":"Emily: No, it\'s okay."},{"type":"paragraph","content":"Emily: Sorry, let\'s get back to, like, whatever we were doing."}]},"emily_2.thanks":{"id":"emily_2.thanks","onArrival":[{"$code":"Q[\'has_emily_goodwill_dress\'] = 1;"}],"options":[{"id":"@emily_2.library","title":"Next..."}],"content":[{"type":"paragraph","content":"\\"Um, thanks.\\""},{"type":"paragraph","content":"\\"Yeah, sorry for dragging you here.\\""},{"type":"paragraph","content":"Wait. Why did you just let her buy your clothes? Why did she offer to pay for your clothes in the first place? What kind of a relationship do you have? You ponder these thoughts as she pays for your clothes with cash. Though it\'s only ten dollars total for both you and Emily\'s items."}]},"emily_4.omniscient":{"id":"emily_4.omniscient","goTo":[{"id":"emily_4.so_what"}],"content":{"content":"That\'s literally impossible.","type":"paragraph"}},"emily_6.anyway":{"id":"emily_6.anyway","options":[{"id":"@emily_6.wait","title":"Wait."}],"content":{"content":"Anyway, somehow, in a flurry of facebook messages after the party, the two of you decided that you would meet. Emily initiated it, as usual. Now you\'re sitting on a bench at Copley Square, waiting for her to arrive. Her bus is late, she texted you. It\'s still a bit remarkable how she manages to get here by transit all the way from Lexington.","type":"paragraph"}},"emily_7.confess_emily":{"id":"emily_7.confess_emily","options":[{"id":"@emily_7.confess_emily_2","title":"You\'ve thought about it..."},{"id":"@emily_7.silence","title":"On second thought..."}],"content":{"content":"What. What would you even say?","type":"paragraph"}},"emily_final.where":{"id":"emily_final.where","viewIf":{"$code":"return ((Q[\'emily_where_seen\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'emily_where_seen\'] = 1;"}],"options":[{"id":"@emily_final.why","title":"\\"Why do you want to run away?\\""},{"id":"@emily_final.convince_me_no","title":"\\"Do you want me to tell you not to go?\\""}],"content":[{"type":"paragraph","content":"You: Where would you go?"},{"type":"paragraph","content":"Emily: New York, probably."},{"type":"paragraph","content":"Emily: For now."},{"type":"paragraph","content":"You: For how long?"},{"type":"paragraph","content":"Emily: However long it needs be."}]},"epilogue.ep_pageant_lose":{"id":"epilogue.ep_pageant_lose","viewIf":{"$code":"return ((Q[\'pageant_success\'] || 0)===0);"},"maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"content":{"content":[{"type":"paragraph","content":["With the pageant over, this chapter of your life is definitively concluded. The gown was returned. Speeches, interviews, platforms, all forgotten soon enough. Mom still tells you that it was a good experience, that she\'s glad you participated in the pageant. ",{"type":"conditional","content":"And there is the STEM special award, which comes with a small scholarship. ","predicate":0},""]},{"type":"paragraph","content":"Overall, was it worth it? It\'s too early to tell."}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'special_award\'] || 0)===1);"}}]},"countVisitsMax":1},"family_3.assisted_reproduction":{"id":"family_3.assisted_reproduction","options":[{"id":"@family_3.ivf","title":"What about sperm donation and IVF and stuff like that?"},{"id":"@family_3.trans","title":"What about trans people?"},{"id":"@family_3.ips","title":"What about, uh, new stem cell technologies?"},{"id":"@family_3.nothing","title":"Say nothing."}],"content":{"content":"What other methods of assisted reproduction are there?","type":"paragraph"}},"family_5.leave":{"id":"family_5.leave","goTo":[{"id":"family_5.freeze_2"}],"content":{"content":"Try as you might, you can\'t move.","type":"paragraph"}},"family_2.mom_2":{"id":"family_2.mom_2","options":[{"id":"@family_2.mom_1","title":"Mom tells a story about school."},{"id":"@family_2.self_doubt","title":"You think about the stories."},{"id":"@family_2.nothing","title":"You\'re tired of this talk."}],"content":{"content":"Mom chimes in. In Shaanxi during the Cultural Revolution the Red Guards went to her family\'s house and beat her father until he admitted to being an illegitimate son of a minor landlord. Back then family was everything. You could be sent to the back of the rations queue if you had landlord blood. Your father makes some joke you don\'t understand about capitalists or something like that. This grandpa is still alive, living on the sixth floor of an elevator-less building in Xi\'an. Climbing the stairs made you tired. You liked him, you think. He\'s a nice person, and he wants to live to see his great-grandchildren (you tried to smile, to make your face neutral. you were good at that).","type":"paragraph"}},"family_6.be_careful":{"id":"family_6.be_careful","options":[{"id":"@family_6.wait_1","title":"Wait."}],"content":[{"type":"paragraph","content":["”小心开车“, you say. \\"",{"type":"emphasis-1","content":"Be careful driving."},"\\""]},{"type":"paragraph","content":"Your words seems to have diffused some of the tension. Dad sighs deeply. Then mom and dad are both quiet. It\'s an uncomfortable silence, a respite rather than a peace."}]},"family_final.dad_2":{"id":"family_final.dad_2","options":[{"id":"@family_final.dad_3","title":"Dad talks about the place where you were born."},{"id":"@family_final.mom_3","title":"Mom talks about the place where you grew up."}],"content":[{"type":"paragraph","content":"Dad talks about reading books in middle or high school. For all its poverty, the school had a decent library. There were Chinese translations of Soviet and some Western science fiction, which he voraciously devoured. He talked about a story where a man wakes up in the future after being frozen for a thousand years. You mention that you\'ve read similar stories."},{"type":"paragraph","content":"What kinds of books do you like, he asks. You like science fiction too, and give brief and non-incriminating descriptions of the books you\'ve read. Your parents don\'t really read English literature so they don\'t have much to say."}]},"family_4.dad_1":{"id":"family_4.dad_1","options":[{"id":"@family_4.mom_2","title":"Mom says something indistinct, yet sharp."}],"content":[{"type":"paragraph","content":["\\"没有她我该早有博士了! ",{"type":"emphasis-1","content":"If it weren\'t for her, I\'d already have my doctorate!"},"\\""]},{"type":"paragraph","content":"You close your eyes. It doesn\'t matter. You\'ll be fine. He doesn\'t mean it."}]},"introspect_1.amy":{"id":"introspect_1.amy","goTo":[{"id":"introspect_1.name"}],"onArrival":[{"$code":"Q[\'first_name\'] = \\"Amy\\";"}],"content":{"content":"","type":"paragraph"}},"introspect_2.scioly":{"id":"introspect_2.scioly","viewIf":{"$code":"return (((Q[\'scioly\'] || 0) >= 2) && ((Q[\'seen_scioly_introspect_2\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'seen_scioly_introspect_2\'] = 1;"}],"options":[{"id":"@introspect_2.pageant","title":"Think about the pageant."},{"id":"@introspect_2.research","title":"Think about research."},{"id":"@introspect_2.scioly","title":"Think about science olympiad."},{"id":"@introspect_2.people","title":"Think about the people you know."},{"id":"@introspect_2.self","title":"Think about yourself."},{"id":"@introspect_2.stop","title":"Stop thinking about stuff."}],"content":{"content":[{"type":"paragraph","content":"You\'ve gotten into science olympiad this year, like the past two years. Beyond the college app benefits, it\'s something you enjoy doing. Probably. Besides, it\'s an opportunity to spend time with Aubrey (and also Krishna and David and the captain and all your other friends/acquaintances)."},{"type":"paragraph","content":"The invitational is coming up soon. You\'re doing four events: Protein Modeling, Fossils, Cell Biology, and Disease Detectives."},{"type":"paragraph","content":["If you want to do well at the invitational, you still need to study these events: ",{"type":"conditional","content":"proteins, ","predicate":0}," ",{"type":"conditional","content":"fossils, ","predicate":1}," ",{"type":"conditional","content":"cell, ","predicate":2}," ",{"type":"conditional","content":"disease ","predicate":3},"."]}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'protein_modeling\'] || 0) < 2);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'fossils\'] || 0) < 1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'cell\'] || 0) < 2);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'disease\'] || 0) < 1);"}}]}},"introspect_3.research":{"id":"introspect_3.research","maxVisits":1,"viewIf":{"$code":"return ((Q[\'research\'] || 0) >= 4);"},"options":[{"id":"@introspect_3.scioly","title":"Think about science olympiad."},{"id":"@introspect_3.pageant","title":"Think about the pageant."},{"id":"@introspect_3.people","title":"Think about people you know."},{"id":"@introspect_3.stop","title":"Enough thinking for now."}],"content":{"content":"Your work at Professor Chen\'s lab is... continuing? You don\'t really know how to assess your progress for something like that.","type":"paragraph"},"countVisitsMax":1},"loneliness_1.social_media":{"id":"loneliness_1.social_media","viewIf":{"$code":"return ((Q[\'social_media_seen\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'social_media_seen\'] = 1;"}],"goTo":[{"id":"loneliness_1.options"}],"content":{"content":"You have twitter and tumblr accounts, but they are almost entirely used for lurking. You have never posted on your twitter account, and very rarely post on tumblr. The act of scrolling through your dashes is not particularly therapeutic; the opposite in fact. But still, it\'s something to do, something to make you feel a little less isolated, as if you are in fact not alone.","type":"paragraph"}},"loneliness_2.contact_emily":{"id":"loneliness_2.contact_emily","viewIf":{"$code":"return ((Q[\'emily\'] || 0) >= 7);"},"onArrival":[{"$code":"Q[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"content":[{"type":"paragraph","content":"The hour is beyond midnight, but you have the impression that Emily is the type of person whose circadian rhythm is even more nocturnal than yours."},{"type":"paragraph","content":"But what would you say? She\'s usually the one who initiates your conversations and meetings. You have no idea how to compose a basic one-sentence message; in order to put it off, you browse Wikipedia and various other internet sites. Soon it is three hours until school starts. You\'ll have two hours to sleep. It\'s fine. It really is."}]},"miri_date.a1":{"id":"miri_date.a1","options":[{"id":"@miri_date.future_1","title":"The future?"}],"content":[{"type":"paragraph","content":"\\"Um...\\""},{"type":"paragraph","content":"Miri sits on her living room couch. You sit down next to her, close but not touching."},{"type":"paragraph","content":"\\"Let\'s talk about...\\" Miri makes a spinning gesture with her hand. \\"The future.\\""}]},"miri_pageant_prep.gym_2":{"id":"miri_pageant_prep.gym_2","options":[{"id":"@miri_pageant_prep.run","title":"Just run or whatever."}],"content":[{"type":"paragraph","content":"\\"Wait. What do we actually do here?\\", Miri asks. \\"You know I\'ve never been here before, right?\\""},{"type":"paragraph","content":"\\"I think we, um, just... use one of these things.\\""},{"type":"paragraph","content":"\\"What?\\""},{"type":"paragraph","content":"\\"Treadmill. For running.\\""},{"type":"paragraph","content":"\\"Oh. Okay.\\""},{"type":"paragraph","content":"There are two empty treadmills next to each other. You take one and Miri takes the other. Your eyes are trained to the ground. If you don\'t see them, they won\'t see you, right? Right?"}]},"pageant_prep_pick_ball_gown.dress_3":{"id":"pageant_prep_pick_ball_gown.dress_3","onArrival":[{"$code":"Q[\'ball_gown\'] = 3;"}],"goTo":[{"id":"pageant_prep_pick_ball_gown.done"}],"content":[{"type":"paragraph","content":"The blue dress looks... alright."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"It looks too childish,\\" mom says. "},"\\"But if you think it\'s good then it\'s good.\\""]}]},"pageant_prep_self_2.nationals":{"id":"pageant_prep_self_2.nationals","options":[{"id":"@pageant_prep_self_2.details_2","title":"But there are still details about the pageant to work through."}],"content":[{"type":"paragraph","content":"Anyway, the national website has scoring sheets and all that stuff. But apparently the relationship between the state and national pageants are sort of complicated. Then you go on Wikipedia, and browse through the list of all pageant winners from all 50 states for both the adult and teen pageants of your selected franchise. One of the adult state winners last year was openly gay; you bookmark her Wikipedia page and read it a few times, and go down a few hundred posts through her Twitter. It\'s all quite boring. Which would make it easy to emulate if you would be placed in that situation, or something like that."},{"type":"paragraph","content":"After some time, the lights in the hallway go dark. You\'ve already tabbed over from Wikipedia to TVTropes to look through the pages of video games you\'ll never play, and then from there to your long-open webcomic and fanfiction tabs. It\'s fascinating stuff but you should go to sleep."}]},"pageant_final.cant_get_up":{"id":"pageant_final.cant_get_up","options":[{"id":"@pageant_final.cry","title":"Cry."}],"content":{"content":"You lie on the bed, mind racing. Your thoughts are barely coherent, but all you know is that you can\'t do this.","type":"paragraph"}},"pageant_prep_self_final.appearance_prep":{"id":"pageant_prep_self_final.appearance_prep","viewIf":{"$code":"return ((Q[\'appearance_prep_seen\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'appearance_prep_seen\'] = 1;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 1;"}],"options":[{"id":"@pageant_prep_self_final.paperwork_prep","title":"Check the last of the paperwork"},{"id":"@pageant_prep_self_final.interview_prep","title":"Prep for the interview"},{"id":"@pageant_prep_self_final.do_nothing","title":"You might as well be done."},{"id":"@pageant_prep_pick_ball_gown","title":"Pick a ball gown."},{"id":"@pageant_prep_try_ball_gown","title":"Try on your ball gown."}],"content":[{"type":"paragraph","content":"Clothing choices, jewelry, hairstyle, makeup... God, this is all so overwhelming. Wikihow is somewhat helpful, as usual. There\'s no opportunity to buy clothes anymore, but you still have an opportunity to design appropriate outfits for the various pageant events, as well as learn more about how to do makeup."},{"type":"paragraph","content":"Hairstyle is one of the few things that you still have time to adjust. According to various websites you have type 1C hair; this means that your hair is basically straight but has bends near the ends. You could either try to straighten it, or accentuate the waviness and increase the volume. But you\'ll probably have to decide when the time comes, not exactly right now."},{"type":"paragraph","content":"And you need to practice your posture, facial expressions, body language, and things like that. You can\'t be doing bizarre gesticulation during the interview. You have to smile. You have to stand up straight, do that thing where you put your hands on your hips and lean backwards. So you practice in the bathroom until someone knocks on the door."}]},"pageant_prep_talent_1.play":{"id":"pageant_prep_talent_1.play","onArrival":[{"$code":"Q[\'pageant_talent\'] = (Q[\'pageant_talent\'] || 0) + 1;"}],"content":{"type":"paragraph","content":["You take the instrument out of its case, and start to play a simple piece. It\'s been a while since you\'ve had lessons, but muscle memory remains. The familiar melody rises through the squeaks and strains. By the time you finish, the door to your room is open, and mom and ",{"type":"emphasis-1","content":"didi"}," are clapping. You can\'t help but smile."]}},"pageant_prep_try_ball_gown.okay_2":{"id":"pageant_prep_try_ball_gown.okay_2","options":[{"id":"@pageant_prep_try_ball_gown.okay_3","title":"\\"Okay.\\""}],"content":[{"type":"paragraph","content":"\\"Okay.\\""},{"type":"paragraph","content":{"type":"emphasis-1","content":"\\"You have to learn how to smile.\\""}}]},"research_2.notfine":{"id":"research_2.notfine","options":[{"id":"@research_2.ok","title":"Sure."}],"content":[{"type":"paragraph","content":"\\"Um, I don\'t know...\\""},{"type":"paragraph","content":"\\"It\'s okay!\\", Stella says, smiling. \\"Science is hard. This is something you\'ve never done before. Do you want to talk about the meeting now?\\""}]},"pageant_meetup.next":{"id":"pageant_meetup.next","viewIf":{"$code":"return ((Q[\'mandatory_meeting_calm\'] || 0)===3);"},"options":[{"id":"@pageant_meetup.yeah","title":"\\"Yeah...\\""},{"id":"@pageant_meetup.stare","title":"Stare at her."}],"content":[{"type":"paragraph","content":"Okay. It\'s going to be alright. And if it isn\'t you\'ll never see any of these people ever again. Hopefully."},{"type":"paragraph","content":"You open the door to the hotel, and follow the signs to the pageant meeting room. When you finally reach the marked door, someone approaches you from behind. You almost jump as she taps your shoulder."},{"type":"paragraph","content":"\\"Oh, um, hi,\\" she says. \\"Are you here for the pageant thing?\\""},{"type":"paragraph","content":"Her voice sounds strange, but perhaps you\'re just imagining things."}]},"research_3.thanks":{"id":"research_3.thanks","options":[{"id":"@research_3.fun","title":"Fun?"},{"id":"@research_3.interesting","title":"Interesting?"},{"id":"@research_3.none_of_the_above","title":"Neither?"}],"content":[{"type":"paragraph","content":"\\"Oh, um, thanks.\\""},{"type":"paragraph","content":"\\"Yeah! Maybe we\'ll have to do just one more practice project before you can work on cutting-edge stuff.\\""},{"type":"paragraph","content":"You leave the lab with more work, this time for you to do at home. Your netbook can\'t exactly run data analysis, but you\'ve finally gotten SSH access to the lab server. Research is..."}]},"research_4.present_1":{"id":"research_4.present_1","options":[{"id":"@research_4.um","title":"\\"Um...\\""}],"content":{"content":"You take a deep breath, and glance around the room. It\'s going to be fine. It\'s going to be fine. It\'s going to be fine.","type":"paragraph"}},"research_5.empty":{"id":"research_5.empty","onArrival":[{"$code":"Q[\'loneliness\'] = (Q[\'loneliness\'] || 0) + 1;"}],"options":[{"id":"@research_5.thanks","title":"\\"Thanks?\\""}],"content":{"content":[{"type":"paragraph","content":"No... is that it? Is that what you\'re feeling? You have no rational reason to feel this way. The only rational response is to be happy, to be grateful for all you\'ve been given. But you\'re not. For some reason this doesn\'t feel real. Nothing really does."},{"type":"paragraph","content":["\\"Hey ",{"type":"insert","insert":0},"?\\", you hear Stella say. You remember that you\'re supposed to talk right now. Or something like that."]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"research_6.stella":{"id":"research_6.stella","options":[{"id":"@research_6.see_emily","title":"Emily is here."}],"content":[{"type":"paragraph","content":"Stella and Professor Chen are having some sort of impromptu interaction, chatting in the meeting room. Both of them wave as you approach."},{"type":"paragraph","content":"\\"We were just talking about you,\\" says Professor Chen. \\"My son is working here too. I want you to work with him, teach him about bioinformatics and science.\\""},{"type":"paragraph","content":"You have a sinking feeling in your gut. \\"Oh, um, that\'s fine,\\" you manage to say."},{"type":"paragraph","content":"\\"He should learn from you,\\" he says. \\"Learn from how hard-working you are, how dedicated you are.\\""},{"type":"paragraph","content":"\\"Oh. Okay.\\""},{"type":"paragraph","content":"He smiles, unaware of your discomfort, perhaps purposefully so but more likely simply out of ignorance."},{"type":"paragraph","content":"\\"You can teach him right now. He\'s here.\\""}]},"research_final.climate":{"id":"research_final.climate","options":[{"id":"@research_final.stella_walks_in","title":"You see a shadow."}],"content":{"content":"You have been reading about the associations between diet patterns and CO2 emissions. The research into this area is still in its infancy, for the most part, but it seems abundantly clear that meat consumption is responsible for a disproportionate share of CO2 emissions, especially with industrial agriculture in the US. There are the changes due to land use, due to the fact that the animal feed usually comes from plant agriculture in some capacity, and just the methane emissions from ruminant... farts or something like that. You\'re not ready to go vegetarian yet but it seems like the ethical choice.","type":"paragraph"}},"scioly_1.stare_captain":{"id":"scioly_1.stare_captain","goTo":[{"id":"scioly_1.alright"}],"content":[{"type":"paragraph","content":"Why would you stare at him? Right, because he\'s staring at you. He\'s slightly shorter than you, skinny, half-Korean/half-Iranian, with a perpetually expressive face, and yeah."},{"type":"paragraph","content":"\\"So, can you do it?\\", he asks again."},{"type":"paragraph","content":"\\"Um, sure.\\""}]},"scioly_invitational.disease_good":{"id":"scioly_invitational.disease_good","viewIf":{"$code":"return ((Q[\'disease\'] || 0) >= 2);"},"onArrival":[{"$code":"Q[\'disease_medal\'] = 2;"}],"goTo":[{"id":"scioly_invitational.protein_modeling"}],"content":{"content":"You\'ve prepared somewhat adequately for this event, and the captain has prepared even more. The questions didn\'t end up too difficult given your preparations. Therefore, it seems like the event went well.","type":"paragraph"}},"scioly_pass.tell_pageant":{"id":"scioly_pass.tell_pageant","content":[{"type":"paragraph","content":"\\"Okay. Um, this is going to sound ridiculous but...\\""},{"type":"paragraph","content":"\\"What is it?\\""},{"type":"paragraph","content":"\\"It\'s... um... I\'m doing a beauty pageant and I sort of want to do well in it because it\'s going to be my hook for college apps which will be a better hook than scioly because so few Asians do that stuff so I\'ll be better off and...\\""},{"type":"paragraph","content":"He laughs. \\"Woah, seriously? You? In a beauty pageant? No offense, but, like, that\'s not you.\\""},{"type":"paragraph","content":"\\"Yeah. My parents signed me up.\\""},{"type":"paragraph","content":"\\"Okay. Uh, you don\'t have to do SciOly if you don\'t want to then. Thanks for telling me.\\""}]},"shopping_with_mom.green_dress":{"id":"shopping_with_mom.green_dress","options":[{"id":"@shopping_with_mom.buy_green_dress","title":"Buy it."},{"id":"@shopping_with_mom.pick_dress","title":"Look at others."}],"content":{"content":"This dress costs $25. It looks kind of boring, without any real distinguishing features, but perhaps that\'s what fits you best, as a boring person yourself. It fits okay, only slightly uncomfortable, coming down just above the knees.","type":"paragraph"}},"research_1.knock":{"id":"research_1.knock","viewIf":{"$code":"return ((Q[\'research_1_breathe\'] || 0) > 2);"},"options":[{"id":"@research_1.stare","title":"Stare at the professor."},{"id":"@research_1.research","title":"\\"Um... yeah. Could you tell me more about what you do?\\""}],"content":[{"type":"paragraph","content":"His office door is half open. You knock, trying to control your trembling."},{"type":"paragraph","content":"\\"Come in,\\" he says, in the accented English you expect."},{"type":"paragraph","content":"You go in, trying to not let your eyes wander too freely. He sits at his desk, and turns away from his desktop monitor to meet you. You vacillate between meeting his gaze and averting it."},{"type":"paragraph","content":"\\"Sit down.\\" You sit down on the chair he points to. \\"I heard you were interested in research!\\" His voice is punctuated with an enthusiasm you can\'t tell is genuine."}]},"skip.w5_pageant_2":{"id":"skip.w5_pageant_2","onArrival":[{"$code":"Q[\'pageant_prep\'] = 2;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 2;"}],"goTo":[{"id":"skip.w5_scioly_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.get_food1":{"id":"scioly_study_party.get_food1","goTo":[{"id":"scioly_study_party.get_food3"}],"content":{"content":"","type":"paragraph"}},"stress_full.excused":{"id":"stress_full.excused","onArrival":[{"$code":"Q[\'stress\'] = (Q[\'stress\'] || 0) - 2;"}],"content":{"content":"You nod, and the nurse smiles. Soon you fall back asleep.","type":"paragraph"}},"thanksgiving_party.hate":{"id":"thanksgiving_party.hate","options":[{"id":"@thanksgiving_party.drive","title":"The drive is filled with the monotone drone of NPR."}],"content":{"content":"You\'re not much of a fan of parties, especially parties thrown by your parents\' Chinese friends. You usually stand in a corner by yourself while your parents tell other parents about how your 3.9 unweighted GPA will never be good enough to get into MIT and how you have zero leadership or social skills. At least the food is usually not bad.","type":"paragraph"}},"stress_2.browse_internet":{"id":"stress_2.browse_internet","options":[{"id":"@stress_2.nap","title":"Take a nap."}],"content":[{"type":"paragraph","content":"You cycle through your usual internet haunts: social media sites, webcomics, fanfiction archives, wikipedia..."},{"type":"paragraph","content":"Not much is going on in any of these domains. At least not much different from usual. Nevertheless, you get sucked into one brief Wikipedia loop before you back out and realize that you are incredibly tired right now."}]},"weekend_alone.get_up_for_real":{"id":"weekend_alone.get_up_for_real","viewIf":{"$code":"return ((Q[\'stay_in_count\'] || 0) >= 3);"},"content":[{"type":"paragraph","content":"You finally get up for real. You put on pants. You leave your room. There\'s food left for you on the kitchen table: soy milk, a banana, and some slices of bread. There\'s a post-it note on the table. They\'ve gone shopping."},{"type":"paragraph","content":"After eating the laid-out breakfast, you microwave some leftovers for lunch. Then mom opens the door, with Kevin close behind."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Why did you get up so late?\\""},", mom admonishes. ",{"type":"emphasis-1","content":"\\"You should have more energy. You\'re so young.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Sorry,\\""}," you reply. ",{"type":"emphasis-1","content":"\\"I didn\'t sleep well.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Aiya, this child.\\""}," She drops her purse on the floor. Dad isn\'t here. You know better than to ask."]}]},"weekend_alone":{"id":"weekend_alone","type":"scene","title":"A Lonely Weekend","subtitle":"A typical weekend","viewIf":{"$code":"return ((((Q[\'week\'] || 0) <= 10) && ((Q[\'week\'] || 0) != 6)) && ((Q[\'a_lonely_weekend_seen\'] || 0) <= 2));"},"onArrival":[{"$code":"Q[\'loneliness\'] = (Q[\'loneliness\'] || 0) + 1;\\nQ[\'stay_in_count\'] = 0;\\nQ[\'a_lonely_weekend_seen\'] = 1;"}],"tags":["weekend"],"maxVisits":2,"options":[{"id":"@weekend_alone.get_up","title":"Get up."},{"id":"@weekend_alone.stay_in","title":"Stay in bed."}],"content":{"content":"You are alone in your room. Kevin and your parents have left for some errand or another. It is 2pm. You are barely awake. You have not eaten.","type":"paragraph"},"countVisitsMax":2},"scioly_2.protein_study":{"id":"scioly_2.protein_study","goTo":[{"id":"scioly_2.protein_else"}],"content":[{"type":"paragraph","content":"\\"Um, I can do the knowledge part.\\""},{"type":"paragraph","content":"\\"Great,\\" Aubrey says. \\"Then I\'ll do the building part.\\""}]},"scioly_final.yes":{"id":"scioly_final.yes","goTo":[{"id":"scioly_final.captain_continues"}],"content":{"content":"Well, you don\'t think you would be much worse than Krishna or Daniel, and it would be a good display of leadership for college apps...","type":"paragraph"}},"1.um":{"id":"1.um","goTo":[{"id":"1.intro2"}],"content":{"content":"","type":"paragraph"}},"aubrey_final.getting_off":{"id":"aubrey_final.getting_off","options":[{"id":"@aubrey_final.hold_hands","title":"You asked her if you could hold hands."},{"id":"@aubrey_final.no_hold_hands","title":"You followed her path."}],"content":[{"type":"paragraph","content":"\\"Do you want to just, like, walk around for a bit?,\\" Aubrey asked after you disembarked."},{"type":"paragraph","content":"\\"Sure.\\""}]},"birthday.no_celebrate":{"id":"birthday.no_celebrate","onArrival":[{"$code":"Q[\'loneliness\'] = (Q[\'loneliness\'] || 0) + 2;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) - 2;"}],"options":[{"id":"@birthday.do_homework","title":"As usual, it\'s time for homework."}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"You really don\'t want to celebrate your birthday?\\""},", mom says."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"I have to do homework,\\""}," you say. It\'s an excuse that always works."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Alright. We\'re still going to leave. We\'re going to the museum. Be careful at home.\\""},""]},{"type":"paragraph","content":"And now you\'re home alone on your birthday. You shouldn\'t feel lonely. You should be used to this. But you never are, not completely."}]},"christmas_break.end_homework":{"id":"christmas_break.end_homework","options":[{"id":"@christmas_break.practice_pageant","title":"Prepare for the pageant."},{"id":"@christmas_break.homework","title":"Do your homework."},{"id":"@christmas_break.videogames","title":"Play video games."},{"id":"@christmas_break.do_nothing","title":"Just sit around doing nothing."}],"content":{"content":"","type":"paragraph"}},"christmas_party.feeling_good":{"id":"christmas_party.feeling_good","goTo":[{"id":"christmas_party.feeling_neutral"}],"content":{"content":"","type":"paragraph"}},"church_1.look":{"id":"church_1.look","goTo":[{"id":"church_1.hi_2"}],"content":{"content":[{"type":"paragraph","content":"Aubrey sits on the couch, wearing a green sweater and light blue jeans, her long black hair brushed to one side. You stare into her eyes for what seem like an eternity."},{"type":"paragraph","content":["\\"Staring at people usually makes them uncomfortable, ",{"type":"insert","insert":0},".\\""]},{"type":"paragraph","content":"\\"Oh. Sorry,\\" and you look away."}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"church_2.wang":{"id":"church_2.wang","goTo":[{"id":"church_2.aubrey_start"}],"content":{"content":"Wait, why? Why would you ask her about that? What would you say? \'What do you think of Wang Laoshi\'s ex-wife?\' And what would be the point of that exactly? Are you hoping to learn something from her, as a probe into her psyche/sexuality by her reaction to...","type":"paragraph"}},"church_3.scream":{"id":"church_3.scream","options":[{"id":"@church_3.comfort_brother","title":"Comfort him."},{"id":"@church_3.get_parents","title":"Get your parents."}],"content":{"content":"He\'s hurt himself by falling down. He\'s bawling, crying his eyes out. The other children circle around, looking on with vaguely guilty expressions.","type":"paragraph"}},"classes_1.look":{"id":"classes_1.look","onArrival":[{"$code":"Q[\'stare\'] = (Q[\'stare\'] || 0) + 1;"}],"options":[{"id":"@classes_1.attractive","title":"Right."}],"content":[{"type":"paragraph","content":"Miri has a round face and brown skin, with curly black hair brushed to one side. She\'s around five feet two, quite a bit shorter than you, and chubby. She\'s half-Black, half-Vietnamese. Also she\'s bisexual, not that it matters."},{"type":"paragraph","content":"\\"You okay? You wanted to talk about the pageant, right?\\""}]},"emily_1.emily_2":{"id":"emily_1.emily_2","options":[{"id":"@emily_1.are_you","title":"\\"What about you?\\""}],"content":{"content":[{"type":"paragraph","content":"\\"Um, yeah. That\'s what I want...\\""},{"type":"paragraph","content":["\\"No offense but you don\'t look like the sort to be into pageants,\\" Emily says. ",{"type":"conditional","content":"You look down at your gray MIT sweatshirt and old jeans and the frayed ends of hair. Of course you don\'t. ","predicate":0},{"type":"conditional","content":"You wonder whether or not to be offended at this insinuation, given how much you\'ve prepared.","predicate":1}]}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_appearance\'] || 0) < 10);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_appearance\'] || 0) >= 10);"}}]}},"emily_3_online.what":{"id":"emily_3_online.what","options":[{"id":"@emily_3_online.okay","title":"\\"It\'s okay...\\""},{"id":"@emily_3_online.go","title":"Leave the conversation right now."}],"content":[{"type":"paragraph","content":"You: Um, what were we doing again?"},{"type":"paragraph","content":"Emily: God, I guess..."},{"type":"paragraph","content":"Emily: I don\'t know anymore. Sorry that was so awkward. But you\'re okay with it?"},{"type":"paragraph","content":"You: With what?"},{"type":"paragraph","content":"Emily: Never mind."},{"type":"paragraph","content":"Emily is still typing, and has been for a while, but she says no more. Somehow the moment that follows seems more awkward than usual. You feel your pulse rise. You\'ve anticipated a conversation much like this one, but never thought to come up with a script."}]},"emily_2.thanks_2":{"id":"emily_2.thanks_2","onArrival":[{"$code":"Q[\'has_emily_goodwill_dress\'] = 1;"}],"options":[{"id":"@emily_2.library","title":"Next..."}],"content":[{"type":"paragraph","content":"\\"Um, I can, um, pay for these myself.\\" It uses up the entirety of your bi-weekly allowance of ten dollars, but that\'s fine, since you\'ve been saving."},{"type":"paragraph","content":"\\"Oh, uh, sorry. I mean, go ahead.\\""},{"type":"paragraph","content":"You each pay for your own pile and leave the store."}]},"emily_4.like":{"id":"emily_4.like","goTo":[{"id":"emily_4.so_what"}],"content":{"content":"What does that even mean? You banish that thought from your head.","type":"paragraph"}},"emily_6.wait":{"id":"emily_6.wait","options":[{"id":"@emily_6.hi","title":"\\"Hi.\\""}],"content":[{"type":"paragraph","content":"What more can you do? You take out some homework that you always carry with you. And just as you\'re starting to get involved in the AP World textbook, Emily appears in the corner of your eyes, with her usual all-black attire, thick scarf and long jacket and leggings and a hat."},{"type":"paragraph","content":"\\"Um, hi,\\" she says, with a wave."}]},"emily_7.confess_emily_2":{"id":"emily_7.confess_emily_2","options":[{"id":"@emily_7.like_you","title":"\\"Um, I like you.\\""}],"content":[{"type":"paragraph","content":"You run a dozen Monte Carlo simulations of this situation in your head. In fact you\'ve already run them, over and over again in the depths of night when you had nothing better to do but ruminate. There are copious possibilities for words to say, phrases to use, to best express the multitudes of feelings that you presumably hold."},{"type":"paragraph","content":"But of course you will use the most generic and awkward phrase. That\'s just the kind of person you are."}]},"emily_final.convince_me_no":{"id":"emily_final.convince_me_no","viewIf":{"$code":"return (((Q[\'emily_where_seen\'] || 0)===1) && ((Q[\'emily_why_seen\'] || 0)===1));"},"options":[{"id":"@emily_final.science_future","title":"What about science? What about your future?"},{"id":"@emily_final.how","title":"How would you survive?"}],"content":[{"type":"paragraph","content":"You: Do you want me to tell you not to go?"},{"type":"paragraph","content":"Emily: That would be helpful."}]},"epilogue.ep_school":{"id":"epilogue.ep_school","maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"content":[{"type":"paragraph","content":"School continues on, as usual. College applications loom in the distance, less than one year away. You should take the SATs and maybe ACTs. And APs. And SAT subject tests. You might even need to take the TOEFL because of some arcane legalistic requirement for non-US citizens, despite English being your only literate language."},{"type":"paragraph","content":"You need to write essays, too. Maybe the pageant really will be helpful."}],"countVisitsMax":1},"family_3.ivf":{"id":"family_3.ivf","viewIf":{"$code":"return ((Q[\'seen_ivf\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'seen_ivf\'] = 1;"}],"options":[{"id":"@family_3.end","title":"The rice is getting cold."}],"content":[{"type":"paragraph","content":"Of course you don\'t say anything. You\'ve simulated this conversation enough times that you already have a good idea of what your father would say, and what you would say in response. At some point you know that either he or your mother would say that it\'s a shame for those children that don\'t have a real father and then you\'re going to want to cry again because you want to have children and your parents will tell you that your children will grow up hating themselves and why can\'t you just marry a man and do it the proper way and so on. Of course you would start crying; the one time you had this argument before you cried and your parents still never suspected that you were actually gay yourself. Hopefully."},{"type":"paragraph","content":"God, why do you suddenly start to feel like crying? From literally nothing more than your reminiscing? Why does this happen? You start to hate yourself, a bit more than usual. What\'s worse is that you hate yourself for your self-pity, so much that your mind becomes an ouroborous of despair. It\'s not a very pleasant feeling."}]},"family_5.freeze_2":{"id":"family_5.freeze_2","options":[{"id":"@family_5.youre_drunk","title":"\\"You\'re drunk.\\""},{"id":"@family_5.no_but","title":"Hide."},{"id":"@family_5.kill_self","title":"Kill yourself right now."}],"content":[{"type":"paragraph","content":"Your body is still frozen in place. Your heart is about to explode inside your chest."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Your mama doesn\'t know. If she knew, she would have a heart attack. Hmph.\\""},""]},{"type":"paragraph","content":"He continues on. Oblivious. Probability that he\'s drunk: >50%."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"We shouldn\'t have moved to America. How good would it have been to stay in China? In China you wouldn\'t have been like this. We could have watched you closer. There wouldn\'t be this so-called \'"},"privacy",{"type":"emphasis-1","content":"\', this so-called human rights.\\""},""]},{"type":"paragraph","content":["He sighs again. ",{"type":"emphasis-1","content":"\\"Cry, right? You always cry. You haven\'t worked. You haven\'t starved. Knows nothing else, just how to cry. I\'ll watch you cry, fine?\\""}]}]},"family_2.dad_2":{"id":"family_2.dad_2","options":[{"id":"@family_2.mom_1","title":"Mom tells a story about school."},{"id":"@family_2.self_doubt","title":"You think about the stories."},{"id":"@family_2.nothing","title":"You\'re tired of this talk."}],"content":{"content":"Dad continues. Your father\'s father was a Communist, like his father before him. He had fought in the People\'s Volunteer Army against the Americans in Korea, and he was a member of the Communist Party\'s village committee or something like that. During the Cultural Revolution he somehow escaped being purged. Probably too minor of a figure to bother with. He died of lung cancer a few years ago. Was always a smoker. You have no memory of him but you still feel bad when your parents stare at you, expecting you to have some emotional reaction.","type":"paragraph"}},"family_6.wait_1":{"id":"family_6.wait_1","options":[{"id":"@family_6.go_bathroom","title":"Go to the bathroom."}],"content":[{"type":"paragraph","content":"The car ride is silent until you arrive at a restaurant somewhere in a rural part of New Hampshire. It\'s a little past 7. It\'s cold and the sky is black."},{"type":"paragraph","content":["\\"我们在这儿吃。",{"type":"emphasis-1","content":"We\'re eating here"},",\\" dad commands. You know better than to talk back."]},{"type":"paragraph","content":"It\'s an American restaurant in approximately the middle of nowhere, a place where your family seems out of place for obvious reasons."}]},"family_final.mom_2":{"id":"family_final.mom_2","options":[{"id":"@family_final.dad_3","title":"Dad talks about the place where you were born."},{"id":"@family_final.mom_3","title":"Mom talks about the place where you grew up."}],"content":[{"type":"paragraph","content":["Mom talks about learning English for the first time. It was in high school, and only recently had China switched from teaching Russian as the main second language to teaching English. The teacher had spent a year in the UK, but the curriculum was based on American English, the ",{"type":"emphasis-1","content":"English for Today"}," books or something like that. The teacher had a horrible accent and was all in all a bad teacher, in retrospect. Mom and dad both say that they learned English by listening to Voice of America and BBC broadcasts."]},{"type":"paragraph","content":"In the books, they learned all about the beautiful green fields of Wisconsin, the rural landscapes of gently rolling hills and neat cornrows, dotted with isolated farmhouses and silos. Dad had the same curriculum, and when you lived in the Midwest, they always mentioned it when driving through."}]},"family_4.mom_2":{"id":"family_4.mom_2","options":[{"id":"@family_4.kevin","title":"Kevin plays Minecraft on the iPad."}],"content":[{"type":"paragraph","content":"You don\'t hear (or don\'t want to hear?) mom\'s exact words, just some snippets, and her anger."},{"type":"paragraph","content":["Then there\'s dad\'s reply. ",{"type":"emphasis-1","content":"\\"Why did you have to keep her?\\""}," Mom replies quietly. Then, banging on the table or the wall."]},{"type":"paragraph","content":"Then more shouting interspersed with moments of calm."}]},"introspect_1.christina":{"id":"introspect_1.christina","goTo":[{"id":"introspect_1.name"}],"onArrival":[{"$code":"Q[\'first_name\'] = \\"Christina\\";"}],"content":{"content":"","type":"paragraph"}},"introspect_2.people":{"id":"introspect_2.people","options":[{"id":"@introspect_2.emily","title":"Think about Emily."},{"id":"@introspect_2.miri","title":"Think about Miri."},{"id":"@introspect_2.aubrey","title":"Think about Aubrey."},{"id":"@introspect_2.parents","title":"Think about your parents."},{"id":"@introspect_2.brother","title":"Think about Kevin."},{"id":"@introspect_2.self","title":"Think about yourself."},{"id":"@introspect_2.stop","title":"Stop thinking about stuff."}],"content":{"content":"","type":"paragraph"}},"introspect_3.people":{"id":"introspect_3.people","maxVisits":1,"options":[{"id":"@introspect_3.emily","title":"Think about Emily."},{"id":"@introspect_3.miri","title":"Think about Miri."},{"id":"@introspect_3.aubrey","title":"Think about Aubrey."},{"id":"@introspect_3.parents","title":"Think about mom and dad."},{"id":"@introspect_3.kevin","title":"Think about Kevin."},{"id":"@introspect_3.stop","title":"Enough thinking for now."}],"content":{"content":"","type":"paragraph"},"countVisitsMax":1},"loneliness_1.webcomic":{"id":"loneliness_1.webcomic","viewIf":{"$code":"return ((Q[\'caught_up\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'caught_up\'] = 1;"}],"goTo":[{"id":"loneliness_1.options"}],"content":[{"type":"paragraph","content":"It was Miri who introduced you to the webcomic, which is somewhat strange as she seemed to despise said webcomic despite following each of its \\"upd8s\\" like an eagle. The comic had been on hiatus for approximately a year; only recently did it start again, with a poorly conceived metatexual segment that is thankfully soon over."},{"type":"paragraph","content":"You have not caught up to the latest developments yet, so you might as well do so. A lot of major characters have just died in a major incident; apparently one of the surviving characters is going back in time to fix things, but not before a lot of seemingly irrelevant but probably crucial content. It\'s moderately clever."}]},"loneliness_2.hey":{"id":"loneliness_2.hey","options":[{"id":"@loneliness_2.up","title":"You wake up."}],"content":{"content":"You feel your heart pound as you send the message. You lie in bed, eyes closed but not able to fall asleep, waiting for the vibration that would signal a response. The reply doesn\'t come before you finally fall asleep.","type":"paragraph"}},"miri_date.a2":{"id":"miri_date.a2","options":[{"id":"@miri_date.hs_good","title":"\\"Well I think it\'s good...\\""},{"id":"@miri_date.hs_okay","title":"\\"It might not be good, but I want to finish it...\\""}],"content":[{"type":"paragraph","content":"\\"So, uh, how about that upd8?\\""},{"type":"paragraph","content":"Miri laughs. \\"I stopped reading after the gigapause. Game Over just sounded so bleak. It\'s not even interesting, and the other stuff just seems like more trolling.\\""},{"type":"paragraph","content":"\\"Oh. Well...\\""}]},"miri_pageant_prep.run":{"id":"miri_pageant_prep.run","options":[{"id":"@miri_pageant_prep.follow","title":"Follow Miri."}],"content":[{"type":"paragraph","content":"You turn on the treadmill and start running. Of course, you get tired and go back to walking after five minutes. And it looks like Miri isn\'t doing any better; she\'s at the water fountain."},{"type":"paragraph","content":"\\"Wait, aren\'t you in gym?\\", Miri asks as she returns."},{"type":"paragraph","content":"\\"Well, technically it\'s not exactly gym. It\'s more of a, uh, health class. PE plus health.\\""},{"type":"paragraph","content":"\\"Of course.\\" She\'s panting. \\"Hey. Let\'s do something else.\\" You\'re tired too; maybe it\'s time to take a break from the treadmill."}]},"pageant_prep_pick_ball_gown.dress_4":{"id":"pageant_prep_pick_ball_gown.dress_4","onArrival":[{"$code":"Q[\'ball_gown\'] = 4;"}],"goTo":[{"id":"pageant_prep_pick_ball_gown.done"}],"content":[{"type":"paragraph","content":"The red dress seems like the fanciest one, and it\'s beautiful, probably."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"For you, it\'s too exaggerated,\\""}," mom says. ",{"type":"emphasis-1","content":"\\"But if you think it\'s good then it\'s good.\\""}]}]},"pageant_prep_self_2.details_2":{"id":"pageant_prep_self_2.details_2","viewIf":{"$code":"return ((Q[\'pageant_paperwork\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'pageant_paperwork\'] = (Q[\'pageant_paperwork\'] || 0) + 1;"}],"subtitle":"Forms. Lots of forms. This is probably important.","options":[{"id":"@pageant_prep_self_2.resume","title":"First of all, there\'s the resume."},{"id":"@pageant_prep_self_2.platform_doc","title":"There\'s a platform statement too."}],"content":[{"type":"paragraph","content":"This is quite important. In fact this is so important that if you don\'t complete this part, you\'ll probably be disqualified for the pageant before you can even start."},{"type":"paragraph","content":"There are approximately 20 forms that you must fill out. Several of which were completed by your parents and sent in as the registration. Then the the organizers emailed you the rest of the forms that must be filled out."}]},"pageant_final.cry":{"id":"pageant_final.cry","options":[{"id":"@ending_pageant_failure","title":"It\'s over."}],"content":[{"type":"paragraph","content":"You begin to cry. Quietly. Mom is still watching. It\'s a while before she notices."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"It\'s really not fine? Okay. Then you don\'t have to go. Is that good?\\""},""]},{"type":"paragraph","content":"She closes the door, and leaves. She says something to dad; you don\'t hear the words but he sounds angry. Your tears continue for no apparent reason. You still can\'t fall sleep."}]},"pageant_prep_self_final.do_nothing":{"id":"pageant_prep_self_final.do_nothing","content":{"content":"There\'s nothing else you really want to do regarding the pageant, for now. It\'s getting late; all you can do is wait until the fated day arrives.","type":"paragraph"}},"pageant_prep_self_final":{"id":"pageant_prep_self_final","type":"scene","title":"Pageant Prep","subtitle":"One last time...","newPage":true,"viewIf":{"$code":"return ((((((Q[\'week\'] || 0)===11) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'pageant_prep\'] || 0) >= 2)) && ((Q[\'stress\'] || 0) < 15)) && ((((((Q[\'pageant_talent\'] || 0) < 10) || ((Q[\'pageant_appearance\'] || 0) < 10)) || ((Q[\'pageant_interview\'] || 0) < 10)) || ((Q[\'pageant_platform\'] || 0) < 10))));"},"onArrival":[{"$code":"Q[\'pageant_prep\'] = (Q[\'pageant_prep\'] || 0) + 1;\\nQ[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"tags":["top","pageant_prep"],"options":[{"id":"@pageant_prep_self_final.paperwork_prep","title":"Check the last of the paperwork"},{"id":"@pageant_prep_self_final.interview_prep","title":"Prep for the interview"},{"id":"@pageant_prep_self_final.appearance_prep","title":"Focus on your appearance"},{"id":"@pageant_prep_pick_ball_gown","title":"Pick a ball gown."},{"id":"@pageant_prep_try_ball_gown","title":"Try on your ball gown."}],"content":{"content":"It\'s the week before the actual pageant. You still have time to prepare, at least a few hours\' worth of uninterrupted computer time, which should be enough, right? It\'s just like any other test, right?","type":"paragraph"}},"pageant_prep_talent_1.away":{"id":"pageant_prep_talent_1.away","content":{"content":"You place the erhu back in its case. Maybe later.","type":"paragraph"}},"pageant_prep_talent_1":{"id":"pageant_prep_talent_1","type":"scene","title":"Pageant Prep","subtitle":"Playing the erhu","newPage":false,"viewIf":{"$code":"return ((((Q[\'week_progress\'] || 0) < 3) && ((Q[\'pageant_prep\'] || 0) >= 1)) && ((Q[\'stress\'] || 0) < 15));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"maxVisits":3,"options":[{"id":"@pageant_prep_talent_1.remember","title":"Remember your lessons."},{"id":"@pageant_prep_talent_1.regard","title":"Look over the erhu."},{"id":"@pageant_prep_talent_1.play","title":"Play a simple piece."}],"content":{"content":{"type":"paragraph","content":[{"type":"conditional","content":["What can you do for the talent portion? It should be something unique, but not so unique as to make the judges feel uncomfortable. You can play the ",{"type":"emphasis-1","content":"erhu"},". That has to be unique, and it\'ll play up your \\"oriental\\" persona, if you go that route. "],"predicate":0}," ",{"type":"conditional","content":["You\'re playing the ",{"type":"emphasis-1","content":"erhu"}," for the talent portion of the pageant. You should practice."],"predicate":1}]},"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_talent\'] || 0)===0);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_talent\'] || 0) > 0);"}}]},"countVisitsMax":3},"pageant_prep_try_ball_gown.okay_3":{"id":"pageant_prep_try_ball_gown.okay_3","options":[{"id":"@pageant_prep_try_ball_gown.okay_4","title":{"type":"emphasis-1","content":"\\"Okay.\\""}}],"content":[{"type":"paragraph","content":"\\"Okay.\\" You try to avoid visibly rolling your eyes."},{"type":"paragraph","content":{"type":"emphasis-1","content":"\\"And, you can\'t do that with your eyes. And you can\'t sigh.\\""}}]},"research_2.ok":{"id":"research_2.ok","content":[{"type":"paragraph","content":"\\"So, what don\'t you understand?\\""},{"type":"paragraph","content":"\\"Uh, everything?\\""},{"type":"paragraph","content":"Stella laughs. \\"Well, let\'s start from the beginning. You\'ve printed out the papers, right?\\""},{"type":"paragraph","content":"She sits next to you and goes over the papers, word by word, starting from the abstract. And it helps, you think. At the end you\'re still confused, but not quite as confused as before."},{"type":"paragraph","content":"\\"Okay, we can start writing code next week. Make sure to read all the Python docs.\\""},{"type":"paragraph","content":"Soon it\'s 6PM. It\'s time to go home. Stella stays in the lab, saying that she still has work to do. You leave holding a new sense of possibility."}]},"research_2":{"id":"research_2","type":"scene","title":"Research","subtitle":"Lab meeting","newPage":true,"viewIf":{"$code":"return (((((((Q[\'week\'] || 0) >= 1) && ((Q[\'week\'] || 0) < 10)) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'research\'] || 0)===1)) && ((Q[\'weekly_research\'] || 0)===0)) && ((Q[\'stress\'] || 0) < 15));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'research\'] = (Q[\'research\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'weekly_research\'] = 1;"}],"tags":["top","research"],"options":[{"id":"@research_2.listen","title":"Listen to the presentations."}],"content":[{"type":"paragraph","content":"It\'s time for your first lab meeting."},{"type":"paragraph","content":"Fortunately you are just listening in, with no expectations. Today is what they call a \\"journal club\\", where a couple of the students present different papers that have been published in the field recently."},{"type":"paragraph","content":"To be honest, you hadn\'t done much since your last meeting except create your computer account. Which was hard enough to be honest. Now, Professor Chen wants you to listen in on the lab meeting \\"in order to understand what our work is really about\\"."}]},"pageant_meetup.yeah":{"id":"pageant_meetup.yeah","options":[{"id":"@pageant_meetup.sit_emily","title":"Sit next to her."},{"id":"@pageant_meetup.sit_random","title":"Sit somewhere else."}],"content":[{"type":"paragraph","content":"\\"Um, y-yeah...\\""},{"type":"paragraph","content":"\\"Great,\\" she replies, and opens the door, letting you enter first."},{"type":"paragraph","content":"The two of you are greeted with stares. You look at the floor. She\'s already moving, and sits near the back. She waves at you."}]},"research_3.fun":{"id":"research_3.fun","goTo":[{"id":"research_3.output"}],"content":{"content":"Yeah. It\'s fun. Or something like that.","type":"paragraph"}},"research_4.um":{"id":"research_4.um","options":[{"id":"@research_4.freeze","title":"You freeze."}],"content":{"content":"\\"Um...\\"","type":"paragraph"}},"research_5.thanks":{"id":"research_5.thanks","options":[{"id":"@research_5.meeting","title":"\\"Sure...\\""}],"content":[{"type":"paragraph","content":"\\"Huh? Oh. Uh, thanks. Uh, for this opportunity.\\""},{"type":"paragraph","content":"\\"Yeah... are you okay?\\""},{"type":"paragraph","content":"\\"Yeah. I\'m fine. I should, uh, continue?\\""},{"type":"paragraph","content":"\\"Let\'s talk about the project. Is now okay?\\""}]},"research_6.see_emily":{"id":"research_6.see_emily","options":[{"id":"@research_6.drama","title":"There has to be something deeper here."},{"id":"@research_6.dont_think","title":"Don\'t think. Do."}],"content":{"content":[{"type":"paragraph","content":"Emily is here. She isn\'t looking at you, and you\'re not looking at her. She sits completely still, hands on the table, not moving in any way."},{"type":"paragraph","content":["Professor Chen is not leaving. \\"Take out your computers,\\" he commands. \\"We are going to learn today. ",{"type":"insert","insert":0},", can you present your work for ---? He has to learn how to be a scientist.\\""]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"research_final.stella_walks_in":{"id":"research_final.stella_walks_in","options":[{"id":"@research_final.close_window","title":"Close the window."},{"id":"@research_final.tab_out","title":"Tab out."},{"id":"@research_final.stella_sees","title":"Don\'t bother."}],"content":{"content":"It is then that you notice Stella the grad student standing behind you.","type":"paragraph"}},"scioly_1.alright":{"id":"scioly_1.alright","options":[{"id":"@scioly_1.what","title":"What does he know."}],"content":{"content":"\\"Alright, you can do it? Great!\\" He gives you a thumbs up. \\"Make sure to meet your teammates and attend the weekly meeting. I know you\'re busy but they\'re very important! Make sure to come!\\"","type":"paragraph"}},"scioly_invitational.disease_okay":{"id":"scioly_invitational.disease_okay","viewIf":{"$code":"return ((Q[\'disease\'] || 0)===1);"},"onArrival":[{"$code":"Q[\'disease_medal\'] = 1;"}],"goTo":[{"id":"scioly_invitational.protein_modeling"}],"content":{"content":"You\'ve prepared a little, but not nearly adequately. Fortunately the captain has been more on top of things than you have, so things will likely turn out alright. He answered the majority of the questions with some help from you.","type":"paragraph"}},"scioly_pass.excuse":{"id":"scioly_pass.excuse","options":[{"id":"@scioly_pass.go","title":"Actually, you change your mind."},{"id":"@scioly_pass.persist","title":"Persist in leaving SciOly."}],"content":[{"type":"paragraph","content":"\\"Sorry. It\'s just... that, um, I have too much stuff this year, and, um...\\""},{"type":"paragraph","content":"\\"Look, it\'s okay. But I think you\'re being too hard on yourself. Believe it or not, you make a really positive contribution to the team. You\'re really talented at science, one of the best we have, one of the top five at least. Besides, we\'re all nice people here, aren\'t we? You don\'t want to let the rest of us down, right?\\""}]},"shopping_with_mom.purple_dress":{"id":"shopping_with_mom.purple_dress","options":[{"id":"@shopping_with_mom.buy_purple_dress","title":"Buy it."},{"id":"@shopping_with_mom.pick_dress","title":"Look at others."}],"content":{"content":"This dress is the most expensive of the three, at $40, but mom said it was fine. You kind of like the colors; it looks like something a cartoon character would wear. As you try it on, it feels nice but leaves the top of your body feeling exposed. You would wear it with a scarf probably, if you weren\'t at the pageant.","type":"paragraph"}},"research_1.stare":{"id":"research_1.stare","options":[{"id":"@research_1.yes","title":"Yes"},{"id":"@research_1.maybe","title":"Sort of."},{"id":"@research_1.no","title":"Not really."}],"content":[{"type":"paragraph","content":"There is an approximately 95% chance that you have seen him somewhere before at one of the various familial Chinese gatherings. Although you cannot claim to have ever spoken with him in the past. That places him within the uncanny valley, or rather atop the awkwardness hill, of social interaction: familiar enough to recognize, but not familiar enough to understand."},{"type":"paragraph","content":"\\"What do you know about biology?,\\" he asks, but it\'s not really as a question. \\"I work on single-cell gene expression. Have you ever heard of RNAseq?\\""},{"type":"paragraph","content":"\\"Anyway,\\" he continues, \\"I study how stem cells differentiate into somatic and germ line cells through the lens, of gene expression. We develop techniques, sequencing techniques, and computational techniques, for identifying the changes in gene expression that are associated with cell differentiation. Does this make sense?\\""}]},"skip.w5_scioly_status":{"id":"skip.w5_scioly_status","options":[{"id":"@skip.w5_scioly_1","title":"You\'ve been heavily involved in science olympiad."},{"id":"@skip.w5_scioly_3","title":"You have not been involved in science olympiad."}],"content":{"content":"Science olympiad status:","type":"paragraph"}},"scioly_study_party.get_food2":{"id":"scioly_study_party.get_food2","goTo":[{"id":"scioly_study_party.get_food3"}],"content":{"content":"","type":"paragraph"}},"stress_full.no_excuse":{"id":"stress_full.no_excuse","onArrival":[{"$code":"Q[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"options":[{"id":"@stress_full.excused_2","title":"No..."},{"id":"@stress_full.no_excuse_2","title":"Yes..."}],"content":[{"type":"paragraph","content":"You shake your head."},{"type":"paragraph","content":"\\"Are you sure?\\", she asks, her voice dripping with incredulous concern."}]},"thanksgiving_party.drive":{"id":"thanksgiving_party.drive","options":[{"id":"@thanksgiving_party.inside","title":"Inside..."}],"content":[{"type":"paragraph","content":"The drive is filled with the monotone voices of NPR that always put you to sleep. You think about your AP World and AP Chem homework. You always take your homework to these parties, not that you ever get much done."},{"type":"paragraph","content":"Professor Chen\'s house is strewn with lights, and the road in front is already full of cars, all newer than your parents\' last century Camry. You help your parents carry their pot of soup up the icy driveway. It\'s a lamb soup, a specialty of Shaanxi province where your mother is from. Kevin rings the doorbell. The door opens, and you\'re greeted by a Chinese man smiling widely as he beckons your family inside."}]},"stress_2.nap":{"id":"stress_2.nap","options":[{"id":"@stress_2.mom","title":"Mom opens the door."}],"content":{"content":"You\'re feeling so tired you could fall asleep right now. And you do, collapsing on the couch with your netbook still open. Your thoughts fade away for a moment...","type":"paragraph"}},"scioly_2.protein_either":{"id":"scioly_2.protein_either","goTo":[{"id":"scioly_2.protein_else"}],"content":[{"type":"paragraph","content":"\\"Um, either one is fine, I guess.\\""},{"type":"paragraph","content":"\\"Alright,\\" Aubrey says. \\"Then you should focus on the knowledge test and I\'ll do the building part.\\""}]},"scioly_final.captain_continues":{"id":"scioly_final.captain_continues","options":[{"id":"@scioly_final.best_player","title":"Are you really one of the best \\"players\\"?"},{"id":"@scioly_final.empathetic","title":"The only reason he calls you \\"empathetic\\" is because it is a feminine-coded trait."},{"id":"@scioly_final.getting_along","title":"How are you good at getting along with people?"}],"content":[{"type":"paragraph","content":"\\"The current field isn\'t so great,\\" the captain says. \\"No offense to Krishna or Daniel, but they wouldn\'t be the best at motivating the team. Maybe you and Aubrey should enter the contest. Or David even.\\""},{"type":"paragraph","content":"Before you can speak up, the captain continues. \\"I know you might think that you don\'t have the people skills, but I have confidence in you. You\'re one of the best players we have. Besides, I think you\'re an empathetic and caring person. Even if you don\'t think so, you\'re good at getting along with people.\\""}]},"1.okay":{"id":"1.okay","goTo":[{"id":"1.intro2"}],"content":{"content":"","type":"paragraph"}},"aubrey_final.hold_hands":{"id":"aubrey_final.hold_hands","goTo":[{"id":"aubrey_final.walk_path"}],"content":[{"type":"paragraph","content":["Would that be too forward? Would you come off as aggressive for pursuing this? She\'s probably not even attracted to you in ",{"type":"emphasis-1","content":"that"}," way; why ruin it?"]},{"type":"paragraph","content":"But then again, women hold hands as friends all the time, right? In China all the women held hands with each other without thinking that it\'s gay."},{"type":"paragraph","content":"Either way, the very thought was so anxiety-inducing that you put it off."}]},"birthday.do_homework":{"id":"birthday.do_homework","content":[{"type":"paragraph","content":"In the end you manage to finish a lab report for AP Chem, but not before wasting a couple of hours on the internet. A couple of precious hours thrown away on useless trivialities, a couple of hours that you\'ll never get back."},{"type":"paragraph","content":"\\"Happy birthday!\\", read all the messages on Facebook. You don\'t reply to any of them. You never reply to your wall posts on Facebook. It might be a bad habit."},{"type":"paragraph","content":"\\"happy bday\\", read Miri\'s text. \\"sorry we didn\'t do anything today?\\""},{"type":"paragraph","content":"\\"We\'ll make it up later?\\", you replied."},{"type":"paragraph","content":"It\'s around 7 in the evening when your family returns. Your brother can\'t wait to tell you about his adventures at the museum."}]},"christmas_break.videogames":{"id":"christmas_break.videogames","maxVisits":1,"options":[{"id":"@christmas_break.practice_pageant","title":"Prepare for the pageant."},{"id":"@christmas_break.homework","title":"Do your homework."},{"id":"@christmas_break.videogames","title":"Play video games."},{"id":"@christmas_break.do_nothing","title":"Just sit around doing nothing."}],"content":[{"type":"paragraph","content":"You don\'t have a computer that can play video games. In fact, there is no computer in this house that can play recent-ish video games. Kevin sometimes wonders if you would play Minecraft with him, but your computer is too weak to even run Minecraft without killing its memory. On social media you see that Miri is getting into the third Dragon Age game."},{"type":"paragraph","content":"You could always play text-based games, though. Or just browse the internet and stuff."}],"countVisitsMax":1},"christmas_party.feeling_bad":{"id":"christmas_party.feeling_bad","goTo":[{"id":"christmas_party.feeling_neutral"}],"content":{"content":"","type":"paragraph"}},"church_1.hi":{"id":"church_1.hi","goTo":[{"id":"church_1.hi_2"}],"content":{"content":"\\"Um, hi,\\" you manage to reply.","type":"paragraph"}},"church_2.ignore":{"id":"church_2.ignore","goTo":[{"id":"church_2.aubrey_start"}],"content":[{"type":"paragraph","content":"You don\'t have anything to say to Aubrey, so you don\'t say anything. Of course you\'d only be lying to yourself if you thought that this is companionable silence rather than an awkward gap or something like that."},{"type":"paragraph","content":"Aubrey looks at you and speaks first."}]},"church_3.get_parents":{"id":"church_3.get_parents","options":[{"id":"@church_3.talk_aubrey","title":"You didn\'t even get to talk to Aubrey"},{"id":"@church_3.no_homework","title":"You didn\'t even get to do your homework."}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Mama, Baba, Chunchun fell!\\""},""]},{"type":"paragraph","content":"Your parents come rushing downstairs. Mom pulls him upstairs."},{"type":"paragraph","content":"After scolding the other children, she tells you that you\'re all leaving early."}]},"classes_1.attractive":{"id":"classes_1.attractive","options":[{"id":"@classes_1.thanks","title":"\\"Um, thanks?\\""},{"id":"@classes_1.flaws","title":"\\"What about my flaws, though?\\""}],"content":[{"type":"paragraph","content":"The most important part of the pageant is your physical appearance, despite all the propaganda about building a well-rounded woman with good character or whatever. There\'s the evening gown and the athletic wear portions, plus the fact that all the judges will be looking at you all the time. You hate being looked at. But hopefully it could be a learning experience? Or something like that."},{"type":"paragraph","content":"\\"So, uh, first question. Um, am I physically attractive?\\""},{"type":"paragraph","content":"\\"That\'s kind of a loaded question.\\""},{"type":"paragraph","content":"\\"Oh. Sorry. But, um, yeah. It is an awkward question, isn\'t it.\\""},{"type":"paragraph","content":"Miri shrugs, and looks into your eyes. You look away."},{"type":"paragraph","content":"\\"Eh. I think you\'ll do alright.\\""},{"type":"paragraph","content":"\\"What does that mean?\\""},{"type":"paragraph","content":"Miri stifles a chuckle. \\"Dude, you\'re skinny. That\'s enough. That\'s like 95% of the hegemonic definition of female attractiveness right there.\\""}]},"emily_1.are_you":{"id":"emily_1.are_you","options":[{"id":"@emily_1.weird","title":"This is weird."},{"id":"@emily_1.hear_her_out","title":"But maybe you should hear her out."},{"id":"@emily_1.appreciate","title":"She clearly has a logical approach; maybe that\'ll be helpful."}],"content":[{"type":"paragraph","content":"\\"So what about you?\\", you ask."},{"type":"paragraph","content":"\\"What do you mean?\\""},{"type":"paragraph","content":"\\"I mean, like, why are you doing the pageant?\\" Interlaced with the question is the insinuation that, since Emily is obviously a nerdy Asian girl like you, she should not be the one questioning you for your choices."},{"type":"paragraph","content":"Emily sighs. \\"I\'m not, probably.\\" A pause. She takes a sip from her caffeinated beverage. \\"Parents don\'t really approve. I just thought it would be an interesting topic to study as if I were participating.\\""},{"type":"paragraph","content":"\\"Oh... Why?\\""},{"type":"paragraph","content":"\\"It kind of presents an interesting challenge. Like a dress-up game but in real life.\\""},{"type":"paragraph","content":"\\"Oh.\\""}]},"emily_3_online.okay":{"id":"emily_3_online.okay","options":[{"id":"@emily_3_online.not","title":"\\"I don\'t think of you any lesser as a human being.\\""},{"id":"@emily_3_online.still","title":"\\"You\'re still Emily Chen, right?\\""}],"content":[{"type":"paragraph","content":"You: It\'s okay..."},{"type":"paragraph","content":"Emily: What?"},{"type":"paragraph","content":"You: The, um, trans thing. I don\'t know how to say it, but, um..."}]},"emily_2.thanks_3":{"id":"emily_2.thanks_3","options":[{"id":"@emily_2.library","title":"Next..."}],"content":[{"type":"paragraph","content":"\\"Um, I actually didn\'t want to buy anything...\\""},{"type":"paragraph","content":"\\"Oh, uh, sorry.\\""},{"type":"paragraph","content":"You stand around awkwardly as she pays for her own items with cash (five dollars total), and you\'re glad when you finally leave the store."}]},"emily_4.pageant":{"id":"emily_4.pageant","goTo":[{"id":"emily_4.so_what"}],"content":{"content":"Really? Do you really though?","type":"paragraph"}},"emily_6.hi":{"id":"emily_6.hi","options":[{"id":"@emily_6.speak","title":"Break the silence."},{"id":"@emily_6.wait_emily","title":"Wait for Emily to break the silence."}],"content":[{"type":"paragraph","content":"\\"Hi,\\" you manage to say, as Emily sits down on the bench next to you."},{"type":"paragraph","content":"\\"Sorry about my parents.\\""},{"type":"paragraph","content":"\\"Um, no problem?...\\""},{"type":"paragraph","content":"Then it\'s quiet. Now you\'re back at that awkward moment in every social interaction where you want to say something but you have no idea what words to speak, and neither does she. This is an impasse that one of you will have to break."}]},"emily_7.like_you":{"id":"emily_7.like_you","options":[{"id":"@emily_7.not_say","title":"No."},{"id":"@emily_7.say_out_loud","title":"Yes."},{"id":"@emily_7.inaudible","title":"Yes, but it was inaudible."}],"content":[{"type":"paragraph","content":"\\"Um, I, um, I kind of like you, or something like that.\\""},{"type":"paragraph","content":"Did you say that out loud?"}]},"emily_final.how":{"id":"emily_final.how","options":[{"id":"@emily_final.science_future","title":"What about science? What about your future?"},{"id":"@emily_final.dont_be_morbid","title":"Don\'t be morbid?"}],"content":[{"type":"paragraph","content":"You: How would you survive?"},{"type":"paragraph","content":"Emily: I can survive via sex work."},{"type":"paragraph","content":"You: Sorry, but like... people who say things like \\"I can survive via sex work\\" are probably not going to survive via sex work."},{"type":"paragraph","content":"Emily: Lol you\'re right. I won\'t. I would probably die either way; it\'s just a matter of when."}]},"epilogue.ep_scioly_good":{"id":"epilogue.ep_scioly_good","maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"viewIf":{"$code":"return ((Q[\'scioly_final_seen\'] || 0)===1);"},"content":[{"type":"paragraph","content":"Science Olympiad continued with the regional competition, which your school passed, and the state competition, where your school placed seventh out of 20-something. Despite the mediocre placement, the captain considered it a success."},{"type":"paragraph","content":"Speaking of which, elections for the new captain have come up. You ended up running, as the captain essentially ordered you to. And surprisingly enough, you won one of the captain slots, along with Krishna. That was a great moment. He\'s been nicer to you than usual lately."}],"countVisitsMax":1},"family_3.trans":{"id":"family_3.trans","viewIf":{"$code":"return ((Q[\'seen_trans\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'seen_trans\'] = 1;"}],"options":[{"id":"@family_3.assisted_reproduction","title":"There are other ways of having children, though..."},{"id":"@family_3.end","title":"The rice is getting cold."}],"content":{"content":[{"type":"paragraph","content":"You wouldn\'t even dare talking about that. You doubt that your parents even know about the existence of trans people, much less trans gay men and trans lesbians. Just bringing up the topic would be a way to start an argument that you had no chance of winning. Whatever your father or mother would say, you know it would make you feel like shit."},{"type":"paragraph","content":[{"type":"conditional","content":"You think about Emily (she\'s probably the trans person you know best irl). What does she think about... and you snap out of it. God, why are you like this. And if you and her were to... God. Stop thinking about this. ","predicate":0},""]},{"type":"paragraph","content":"Instead you try to eat your rice and vegetables, and stay silent and stay out of the conversation. Someday it will be your time to speak up. But not today. When will that someday come? You thought that you would not speak of the matter until you were financially independent. That\'s a long ways away, but you have patience aplenty."}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return (((Q[\'emily\'] || 0) >= 3) && ((Q[\'emily_ship\'] || 0)===0));"}}]}},"family_5.no_but":{"id":"family_5.no_but","options":[{"id":"@family_5.ignore","title":"Ignore him."}],"content":[{"type":"paragraph","content":"You force your muscles to move. Retreat into your room. Walk away without taking a look back. Shut the door behind you, but don\'t slam it."},{"type":"paragraph","content":{"type":"emphasis-1","content":"\\"Come back. I want to talk to you.\\""}}]},"family_2.mom_3":{"id":"family_2.mom_3","options":[{"id":"@family_2.dad_1","title":"Dad tells stories about growing up."},{"id":"@family_2.self_doubt","title":"You think about the stories."},{"id":"@family_2.nothing","title":"You\'re tired of this talk."}],"content":{"content":{"type":"paragraph","content":["Mom tells you about the first time they got a television, in the 1980s. The first program they watched was some Russian program, an adaptation of Anna ",{"type":"insert","insert":0},"ina. She and her three sisters glued themselves to the screen, probably looking at the first white people they had ever seen, probably the first time they had a live view of anything outside their province or maybe even their county. They were enthralled with the glamor of it all, the beautiful dresses, the lights and crystals that were so far away from their house carved out of dirt."]},"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"family_6.go_bathroom":{"id":"family_6.go_bathroom","options":[{"id":"@family_6.oh_okay","title":"Oh."}],"content":[{"type":"paragraph","content":["You get up and say you\'re going to the bathroom. Mom follows. \\"去吧，去吧。",{"type":"emphasis-1","content":"Go, go"},",\\" dad says brusquely."]},{"type":"paragraph","content":["\\"对不起。",{"type":"emphasis-1","content":"Sorry"},",\\" she whispers on the way. She holds your hand. \\"我们不应该在车里吵架。",{"type":"emphasis-1","content":"We shouldn\'t argue in the car."},"\\""]}]},"family_final.dad_3":{"id":"family_final.dad_3","options":[{"id":"@family_final.history","title":"You wish you could learn more."},{"id":"@family_final.tired","title":"You\'re tired of the stories."},{"id":"@family_final.no_matter","title":"It doesn\'t matter; you don\'t care about their stories."}],"content":{"content":"Dad talks about the place where you were brought up. Your parents were students when you were born, living in a tiny student apartment with a bunk bed and a single desk, where every household on the floor shared a kitchen and a bathroom. The kitchen walls were blackened from the cooking soot. There were fights, sometimes with people brandishing knives. You lived there for two months, before they sent you to your grandparents in Xi\'an. They speak as if you are somehow supposed to remember this.","type":"paragraph"}},"family_4.mom_1":{"id":"family_4.mom_1","options":[{"id":"@family_4.kevin","title":"Kevin plays Minecraft on the iPad."}],"content":[{"type":"paragraph","content":["\\"你真的找不着电脑的工作吗? ",{"type":"emphasis-1","content":"You really can\'t find a job in computers?"},"\\""]},{"type":"paragraph","content":"Even through the door you can hear dad sigh."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Who needs a masters in geography these days?\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"You can\'t learn something new?\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Aiya. You can\'t lay it off for one moment? You always have to nag me!\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"If the American government found out they\'d get you for sure!\\""},""]},{"type":"paragraph","content":"The voices and sounds become indistinct."}]},"introspect_1.erica":{"id":"introspect_1.erica","goTo":[{"id":"introspect_1.name"}],"onArrival":[{"$code":"Q[\'first_name\'] = \\"Erica\\";"}],"content":{"content":"","type":"paragraph"}},"introspect_2.emily":{"id":"introspect_2.emily","viewIf":{"$code":"return (((Q[\'emily\'] || 0) > 1) && ((Q[\'seen_emily_introspect_2\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'seen_emily_introspect_2\'] = 1;"}],"goTo":[{"id":"introspect_2.people"}],"content":{"content":"Emily is... not much more than a stranger, objectively speaking, yet you feel as if you understand her already. She\'s ... similar to you in some important ways, and completely different from you in other but probably less important ways. You should probably get to know her better, or something like that.","type":"paragraph"}},"introspect_3.emily":{"id":"introspect_3.emily","maxVisits":1,"options":[{"id":"@introspect_3.emily","title":"Think about Emily."},{"id":"@introspect_3.miri","title":"Think about Miri."},{"id":"@introspect_3.aubrey","title":"Think about Aubrey."},{"id":"@introspect_3.parents","title":"Think about mom and dad."},{"id":"@introspect_3.kevin","title":"Think about Kevin."},{"id":"@introspect_3.stop","title":"Enough thinking for now."}],"content":{"content":[{"type":"paragraph","content":[{"type":"conditional","content":"You\'re... well, you kind of made a very vague agreement with Emily that you could start dating... eventually. Besides that, though, you feel like you know her better than before? Like even if you don\'t end up dating or it doesn\'t work out, which is highly likely, you\'ll still be friends? Or something like that. But you want to go out with her sometime, right? ","predicate":0},""]},{"type":"paragraph","content":{"type":"conditional","content":"You kind of got to know Emily better at the Thanksgiving party. She feels like a friend now, despite only having known of her for a couple of months. Or something like that.","predicate":1}}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'emily_date\'] || 0) > 0);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'emily_date\'] || 0)===0);"}}]},"countVisitsMax":1},"loneliness_1.fanfic":{"id":"loneliness_1.fanfic","viewIf":{"$code":"return (((Q[\'caught_up\'] || 0)===1) && ((Q[\'fanfic_seen\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'fanfic_seen\'] = 1;"}],"goTo":[{"id":"loneliness_1.options"}],"content":[{"type":"paragraph","content":"There is a plethora of fanfiction for the webcomic. You like reading the ones about the romantic relationship between two of the girls, one a human and the other a vaguely insectoid alien. They are both canonically deceased now, but that is expected to be fixed, as the webcomic works on the principle of \\"all who die come back again.\\" Or they\'ll end up as ghosts or something like that."},{"type":"paragraph","content":"Anyway, none of that matters for fanfiction. There are so many stories taking place in the interstices of the primary narrative, in the places the original author failed to elaborate. And there are the alternate universes, the stories where everyone is a high school student, where one is a vampire, and the stories in which the two girls are working as caretakers in a retirement home on Earth (you might be misremembering)."}]},"loneliness_2.imlonely":{"id":"loneliness_2.imlonely","options":[{"id":"@loneliness_2.up","title":"You wake up."}],"content":{"content":"You feel your heart pound as you send the message. You lie in bed, eyes closed but not able to fall asleep, waiting for the vibration that would signal a response. The reply doesn\'t come before you finally fall asleep.","type":"paragraph"}},"miri_date.hs_good":{"id":"miri_date.hs_good","options":[{"id":"@miri_date.webcomics","title":"Have a long and scintillating conversation about internet media."},{"id":"@miri_date.a3","title":"Have a long and meaningful conversation about literally anything else."}],"content":[{"type":"paragraph","content":"\\"Um, I think it\'s good... I mean there\'s still hope for something good to come out of it.\\""},{"type":"paragraph","content":"\\"Yeah? Maybe. If it ever does get good again, tell me.\\""},{"type":"paragraph","content":"A lull. Miri seems to be not so interested in the topic."}]},"miri_pageant_prep.follow":{"id":"miri_pageant_prep.follow","options":[{"id":"@miri_pageant_prep.help_gym","title":"\\"Um, help?\\""}],"content":[{"type":"paragraph","content":"The two of you walk around the gym. There are weight machines. And people using them. Scary people, somewhat scarier than people in general."},{"type":"paragraph","content":"\\"Um, what do we do?\\", you ask."},{"type":"paragraph","content":"\\"Act like we belong,\\" Miri replies. \\"And we do belong here, right?\\""},{"type":"paragraph","content":"You sit at some strange machine and try to move the bar. It doesn\'t budge."}]},"pageant_prep_pick_ball_gown.done":{"id":"pageant_prep_pick_ball_gown.done","content":{"content":"Okay, that\'s done. You\'ll still have to try it on sometime, though.","type":"paragraph"}},"pageant_prep_pick_ball_gown":{"id":"pageant_prep_pick_ball_gown","type":"scene","title":"Pick a ball gown","onArrival":[{"$code":"Q[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 1;"}],"viewIf":{"$code":"return ((Q[\'ball_gown\'] || 0)===0);"},"maxVisits":1,"options":[{"id":"@pageant_prep_pick_ball_gown.dress_1","title":"The first (black) dress."},{"id":"@pageant_prep_pick_ball_gown.dress_2","title":"The second (green) dress."},{"id":"@pageant_prep_pick_ball_gown.dress_3","title":"The third (blue) dress."},{"id":"@pageant_prep_pick_ball_gown.dress_4","title":"The fourth (red) dress."}],"content":[{"type":"paragraph","content":"You need to find a ball gown for the evening dress portion of the pageant; it is an absolute necessity. Or is it an evening gown? What\'s the difference, anyway? If there even is a difference?"},{"type":"paragraph","content":"Mom has pictures of the ball gowns that she\'s able to borrow from... someone or somewhere (you don\'t know exactly). Even though you don\'t have an opportunity to try it out, she asserts that they will all fit you, since her friends\' daughter have basically the same body type as you (you doubt that, but still). You\'re supposed to pick from among one of them."},{"type":"paragraph","content":"First is a long black dress with stringy shoulder straps, with a white bow tied like a belt around the waist. It looks featureless and flat except for the white belt, with a soft but slightly imposing texture."},{"type":"paragraph","content":"Next is a deep green strapless dress with a pleated bottom. It has a simple look, with something like a belt gathered at the waist, and seems like it would be soft."},{"type":"paragraph","content":"Then, there is a light blue dress with a V-shaped neck and thin straps, and a belt of shiny stones just below the breast. Below the belt, it is solid light blue without much texture."},{"type":"paragraph","content":"Finally, there is a shiny blood-red strapless dress. It looks kind of fancy, with texture that drapes like a layer cake, and glittery stuff covering the breasts and scattered down the dress."},{"type":"paragraph","content":"Which one would you like?"}],"countVisitsMax":1},"pageant_prep_self_2.resume":{"id":"pageant_prep_self_2.resume","viewIf":{"$code":"return ((Q[\'resume_completed\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'resume_completed\'] = 1;"}],"options":[{"id":"@pageant_prep_self_2.spin_resume","title":"But, isn\'t this like a college app?"}],"content":[{"type":"paragraph","content":["First of all, there\'s the resume. You have not had an actual job before (no, the nepotistic way in which mom got you a research opportunity does not count), so you do not have an actual resume. When you asked your parents if you could get a job, mom just said \\"孩子们不应该打工,应该学习 ",{"type":"emphasis-1","content":"children shouldn\'t work, they should study"},"\\" and left it at that. You didn\'t push it. But the experience would have been helpful right now. What is a resume, anyway? What would it involve?"]},{"type":"paragraph","content":"The good thing is that there is a template, and some examples online. The fields are deceptively simple: leadership roles, academic honors, accomplishments, interesting facts, marketing plan. Have you ever had any leadership roles? Or accomplishments for that matter? Or interesting facts? You might be the most boring human being to ever exist."}]},"pageant_final.preparation":{"id":"pageant_final.preparation","viewIf":{"$code":"return ((Q[\'stress\'] || 0) <= 15);"},"options":[{"id":"@pageant_final.paperwork","title":"Step 0: Paperwork."}],"content":{"content":"There are potentially an infinite number of tasks that you could have done to prepare. By definition you have not done most of them. But maybe it\'s time to start.","type":"paragraph"}},"pageant_prep_try_ball_gown.okay_4":{"id":"pageant_prep_try_ball_gown.okay_4","options":[{"id":"@pageant_prep_try_ball_gown.okay_5","title":"\\"Okay.\\""}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Okay,\\""}," you say in Chinese this time. ",{"type":"emphasis-1","content":"\\"I know.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"It\'s not enough to know. It needs practice.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Should have given me this earlier,\\""}," you say."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Aiya, I know!\\""},", mom shouts, surprising you. ",{"type":"emphasis-1","content":"\\"I didn\'t have a way to get it! Should have practiced earlier, wearing other clothes is fine. You just need to practice more.\\""}]}]},"pageant_meetup.stare":{"id":"pageant_meetup.stare","goTo":[{"id":"pageant_meetup.yeah"}],"onArrival":[{"$code":"Q[\'emily_stared\'] = 1;"}],"content":[{"type":"paragraph","content":"Well, she\'s... a person..."},{"type":"paragraph","content":"She\'s Asian, skinny, and about your height, with messy shoulder-length hair tied up in a loose ponytail, and what looks like loads of makeup. She wears layers of black, a black skirt with black leggings and black shoes and a black sweater and thick black-framed glasses. Is this a pageant contestant? Someone you\'ll compete with and have to eventually defeat but probably won\'t?"}]},"research_3.interesting":{"id":"research_3.interesting","goTo":[{"id":"research_3.output"}],"content":{"content":"Yeah. Maybe it\'s interesting. Or something like that?","type":"paragraph"}},"research_4.freeze":{"id":"research_4.freeze","options":[{"id":"@research_4.um_2","title":"\\"Um...\\""}],"content":{"content":"You freeze. Glance around the room again. Take rapid, shallow breaths. It\'s going to be fine.","type":"paragraph"}},"research_5.meeting":{"id":"research_5.meeting","content":[{"type":"paragraph","content":"And you have another meeting with Stella, where she talks and you listen. Your new project is a continuation with the old project, RNA-seq analysis of the cells of some zebrafish embryonic stage. Your mom\'s lab is also on this project as a collaborator, so she\'ll probably be a co-author as well. You feel a little bad about this bit of nepotism, but Stella says that it\'ll be okay, since it\'s not like mom\'s your actual boss here."},{"type":"paragraph","content":"Then you\'re back at your computer, facing away from her. You have to work."}]},"research_5":{"id":"research_5","type":"scene","title":"Research","subtitle":"A new project","newPage":true,"viewIf":{"$code":"return (((((((Q[\'week\'] || 0) >= 1) && ((Q[\'week\'] || 0) < 10)) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'research\'] || 0)===4)) && ((Q[\'weekly_research\'] || 0)===0)) && ((Q[\'stress\'] || 0) < 15));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'research\'] = (Q[\'research\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'weekly_research\'] = 1;"}],"tags":["top","research"],"options":[{"id":"@research_5.oh","title":"\\"Oh.\\""}],"content":[{"type":"paragraph","content":"You show up at the lab after school, as you\'ve been doing for the past few weeks. It\'s become a routine by now, just one more part of your daily existence. You don\'t even feel the nervousness within your heart anymore."},{"type":"paragraph","content":"\\"Hey, I have something to tell you,\\" Stella says as you enter. \\"The project we\'re working on, Professor Chen things it can get published. Of course it\'s going to take a while, but you might be an author eventually.\\""}]},"research_6.drama":{"id":"research_6.drama","options":[{"id":"@research_6.not_complicit","title":"And you will not be complicit."},{"id":"@research_6.dont_think","title":"Better to ignore it."}],"content":{"content":{"type":"paragraph","content":["There has to be some drama between them that led to this situation, that led to Professor Chen bringing Emily here for this humiliation. You know their family situation is not the best. And that Professor Chen uses you in their arguments, why can\'t you be like ",{"type":"insert","insert":0},", you can imagine him saying. You are being used as a weapon in their internal war, against ",{"type":"conditional","content":"your potential future girlfriend ","predicate":1},{"type":"conditional","content":"your friend ","predicate":2},"."]},"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'emily_date\'] || 0) >= 1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'emily_date\'] || 0)===0);"}}]}},"research_final.close_window":{"id":"research_final.close_window","goTo":[{"id":"research_final.stella_sees"}],"content":{"content":"It doesn\'t matter. Stella has already seen what you\'re looking at.","type":"paragraph"}},"scioly_1.what":{"id":"scioly_1.what","content":[{"type":"paragraph","content":"Your four events are Cell Biology, Fossils, Protein Modeling, and Disease Detectives. You have partners for each of these events: Krishna Rao for Cell Biology, the captain for Disease Detectives, David Nguyen for Fossils, and Aubrey Gao for Protein Modeling."},{"type":"paragraph","content":"The meeting is beginning to wrap up. There\'s nothing more you have to do today, but you\'re only getting started.."}]},"scioly_1":{"id":"scioly_1","type":"scene","title":"Science Olympiad","subtitle":"After school","newPage":true,"viewIf":{"$code":"return ((((((((Q[\'week\'] || 0) >= 1) && ((Q[\'week\'] || 0) < 6)) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'scioly\'] || 0)===0)) && ((Q[\'weekly_scioly\'] || 0)===0)) && ((Q[\'stress\'] || 0) < 15)) && ((Q[\'class_visited\'] || 0)===1));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'scioly\'] = (Q[\'scioly\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'weekly_scioly\'] = 1;"}],"tags":["top","scioly"],"options":[{"id":"@scioly_1.okay","title":"It\'s fine."},{"id":"@scioly_1.maybe","title":"Um..."},{"id":"@scioly_1.stare_captain","title":"Stare at the captain."}],"content":{"content":[{"type":"paragraph","content":"After the last period you head to the Science Olympiad club. It\'s a national competition where students work in teams on a bunch of different science events. To be honest your school usually doesn\'t do too well at these things, but you\'re trying to change that, right? Last year your school placed fourth at states; hopefully this year will turn out better."},{"type":"paragraph","content":"Not to mention, this is the most significant extracurricular that you partake in, which will become the cornerstone of the EC section of your college applications next year. And you enjoy it well enough, the thrill of victory, the agony of defeat, the camraderie of your squad, and so on. Or something like that."},{"type":"paragraph","content":["\\"",{"type":"insert","insert":0},"! Good of you to finally show up!\\" The captain, smiling and overly enthusiastic as usual, shouts as he walks up to you. \\"We have the schedule for the regional competition. How do you feel about doing four events this time?\\""]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"scioly_invitational.disease_bad":{"id":"scioly_invitational.disease_bad","viewIf":{"$code":"return ((Q[\'disease\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'disease_medal\'] = 0;"}],"goTo":[{"id":"scioly_invitational.protein_modeling"}],"content":[{"type":"paragraph","content":"As the test begins, it soon dawns on you that you have had virtually zero preparation for this event."},{"type":"paragraph","content":"Fortunately, the captain is much more on top of things than you are. He answered about 95% of the questions by himself, without any of your input."}]},"scioly_pass.persist":{"id":"scioly_pass.persist","onArrival":[{"$code":"Q[\'scioly\'] = 0;\\nQ[\'loneliness\'] = (Q[\'loneliness\'] || 0) + 1;\\nQ[\'scioly_pass_viewed\'] = 1;"}],"content":[{"type":"paragraph","content":"\\"Um, sorry but...\\""},{"type":"paragraph","content":"\\"It\'s okay. I won\'t force you to stay. Look, just do your own thing, if that\'s what you want.\\""},{"type":"paragraph","content":"He turns and walks away, leaving you a mess of confused feelings."}]},"scioly_pass":{"id":"scioly_pass","type":"scene","title":"Science Olympiad","subtitle":"A reminder or warning","viewIf":{"$code":"return ((((((Q[\'week\'] || 0) > 5) && ((Q[\'week\'] || 0) < 10)) && ((Q[\'scioly\'] || 0) < 2)) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'scioly_pass_viewed\'] || 0)===0));"},"tags":["scioly","top"],"priority":2,"options":[{"id":"@scioly_pass.go","title":"Tell him that you\'ll catch up."},{"id":"@scioly_pass.dont_go","title":"Actually, you\'re not doing SciOly this year."}],"content":{"content":[{"type":"paragraph","content":"Right after classes end, the science olympiad captain calls out to you as he passes by in the hallway."},{"type":"paragraph","content":"\\"Hey, I\'ve barely seen you at SciOly all this year. What happened?\\""},{"type":"paragraph","content":[{"type":"conditional","content":"SciOly, or science Olympiad, probably has been your number one EC in high school. It\'s a national competition where students work in teams on a bunch of different science events. ","predicate":0},""]},{"type":"paragraph","content":"\\"Um, sorry...\\""},{"type":"paragraph","content":"\\"We have an invitational in less than a month. If you want to be on the team then you\'d better start going to meetings.\\""}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'scioly\'] || 0)===0);"}}]}},"shopping_with_mom.pick_dress":{"id":"shopping_with_mom.pick_dress","options":[{"id":"@shopping_with_mom.red_dress","title":"A red lace dress with ruffles at the waist."},{"id":"@shopping_with_mom.purple_dress","title":"A purple strapless dress with a black stripe."},{"id":"@shopping_with_mom.green_dress","title":"A shimmery pleated green dress."}],"content":[{"type":"paragraph","content":"Mom is insisting that you pick one out."},{"type":"paragraph","content":"Some of the dresses that caught your eye are..."}]},"research_1.research":{"id":"research_1.research","options":[{"id":"@research_1.yes","title":"Yes"},{"id":"@research_1.maybe","title":"Sort of."},{"id":"@research_1.no","title":"Not really."}],"content":[{"type":"paragraph","content":"The words come out of your mouth with a fluidity that surprises you."},{"type":"paragraph","content":"\\"I\'m glad you asked! What do you know about biology? I work on single-cell gene expression. Have you ever heard of RNAseq?\\""},{"type":"paragraph","content":"\\"Anyway,\\" he continues, \\"I study how stem cells differentiate into somatic and germ line cells through the lens, of gene expression. We develop techniques, sequencing techniques, and computational techniques, for identifying the changes in gene expression that are associated with cell differentiation. Does this make sense?\\""}]},"skip.w5_scioly_1":{"id":"skip.w5_scioly_1","onArrival":[{"$code":"Q[\'scioly\'] = 4;\\nQ[\'david_scioly\'] = (Q[\'david_scioly\'] || 0) + 1;\\nQ[\'fossils\'] = (Q[\'fossils\'] || 0) + 1;\\nQ[\'aubrey_scioly\'] = (Q[\'aubrey_scioly\'] || 0) + 1;\\nQ[\'protein_modeling\'] = (Q[\'protein_modeling\'] || 0) + 1;\\nQ[\'krishna_scioly\'] = (Q[\'krishna_scioly\'] || 0) + 1;\\nQ[\'cell\'] = (Q[\'cell\'] || 0) + 1;\\nQ[\'edwin_scioly\'] = (Q[\'edwin_scioly\'] || 0) + 1;\\nQ[\'disease\'] = (Q[\'disease\'] || 0) + 1;"}],"goTo":[{"id":"skip.w5_research_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.get_food3":{"id":"scioly_study_party.get_food3","options":[{"id":"@scioly_study_party.conversation","title":"Go downstairs."},{"id":"@scioly_study_party.stay_alone","title":"Stay here, alone."}],"content":[{"type":"paragraph","content":"The counters in the kitchen are loaded with open bags of nachos and salsa, various brands of chips and soda, and so on. You take a paper plate and help yourself."},{"type":"paragraph","content":"Food is always good at social gatherings because it gives you a cover, a way to not talk to anyone and still not look too awkward. Or would they notice you anyway, would they notice the fact that you\'re standig in a corner by yourself even though you have a plate of food with you?"},{"type":"paragraph","content":"Anyway, you should probably join the rest of the team downstairs."}]},"stress_full.excused_2":{"id":"stress_full.excused_2","onArrival":[{"$code":"Q[\'stress\'] = (Q[\'stress\'] || 0) - 3;"}],"content":[{"type":"paragraph","content":"You shake your head. After the nurse watches you for a moment, you finally open your mouth. \\"No. I mean, I want to get excused.\\""},{"type":"paragraph","content":"\\"That\'s more like it.\\""},{"type":"paragraph","content":"The nurse leaves. Soon you fall back asleep."}]},"thanksgiving_party.inside":{"id":"thanksgiving_party.inside","options":[{"id":"@thanksgiving_party.meet_emily1","title":"The door opens..."},{"id":"@thanksgiving_party.meet_emily2","title":"The door opens..."},{"id":"@thanksgiving_party.meet_emily3","title":"The door opens..."}],"content":[{"type":"paragraph","content":"The house is big, much bigger than your parents\' apartment, and permeated with warmth and gregarious Chinese voices."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Ai-you, Ai-you, it\'s too heavy, I\'ll help you carry this"},",\\" Professor Chen\'s wife yells, and she takes the pot from your hands. Professor Chen takes your coat and hangs it up. ",{"type":"emphasis-1","content":"\\"She doesn\'t need help, she can do it herself,\\""}," your mother says out of obligation. You remain silent."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Sorry there aren\'t many children your age here,\\""}," Professor Chen says. ",{"type":"emphasis-1","content":"\\"My son is in his room. He\'s also a junior. Maybe you can play with him.\\""},""]},{"type":"paragraph","content":["He takes you upstairs and knocks on a door. ",{"type":"emphasis-1","content":"\\"---, open the door,\\""}," he says. You hear the shuffling of feet and a click of the doorknob."]}]},"stress_2.work":{"id":"stress_2.work","options":[{"id":"@stress_2.browse_internet","title":"Browse the internet."},{"id":"@stress_2.nap","title":"Take a nap."}],"content":[{"type":"paragraph","content":"You try to start, but it seems as if you\'re too tired to work. Your brain still feels fried from all the hours spent in school and at your extracurriculars. Not just from today. From all the days of living on three to five hours of sleep."},{"type":"paragraph","content":"Since you can\'t concentrate, why not try doing something else for now?"}]},"scioly_2.protein_else":{"id":"scioly_2.protein_else","options":[{"id":"@scioly_2.proteins_what_do_you_know","title":"You do know a lot about proteins."}],"content":[{"type":"paragraph","content":"\\"Okay.\\""},{"type":"paragraph","content":"\\"So, let\'s start. What do you know about proteins?\\""}]},"scioly_final.best_player":{"id":"scioly_final.best_player","goTo":[{"id":"scioly_final.what_do_you_think"}],"content":{"content":"In terms of getting medals, you might have done well, but your partners worked harder than you every step of the way. You were just along for the ride.","type":"paragraph"}},"1.not":{"id":"1.not","goTo":[{"id":"1.intro2"}],"content":{"content":"","type":"paragraph"}},"aubrey_final.no_hold_hands":{"id":"aubrey_final.no_hold_hands","goTo":[{"id":"aubrey_final.walk_path"}],"content":{"content":"You thought about holding hands, but quickly backed off on the idea; it would have been too forward and rather inappropriate for the situation, in your opinion.","type":"paragraph"}},"birthday.family":{"id":"birthday.family","options":[{"id":"@birthday.no_celebrate","title":"Stay home and do homework."},{"id":"@birthday.family_celebrate","title":"Go with them to the museum."}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"You really don\'t want to invite anyone?\\""},", mom asks. ",{"type":"emphasis-1","content":"\\"You have friends at school, right?\\""}," You shrug."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Okay,\\""}," she continues. ",{"type":"emphasis-1","content":"\\"It\'s your birthday. What do you want to do?\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"I don\'t know,\\""}," you say."]},{"type":"paragraph","content":["\\"哎呀！你真烦人。你从来没有自己的注意。\\" ",{"type":"emphasis-1","content":"\\"Aiya! You\'re really annoying me. You never have any ideas of your own. This is your problem.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Okay,\\""}," you try to respond. ",{"type":"emphasis-1","content":"\\"I\'m just going to do homework.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"You don\'t want to come with us to the museum?\\""},""]},{"type":"paragraph","content":"This isn\'t the first time mom\'s capriciousness confused you like this. Maybe she\'s doing it on purpose. Probably."}]},"christmas_break.do_nothing":{"id":"christmas_break.do_nothing","content":{"content":"","type":"paragraph"}},"christmas_break":{"id":"christmas_break","type":"scene","title":"Christmas Break","subtitle":"An opportunity...?","newPage":true,"viewIf":{"$code":"return ((((Q[\'week\'] || 0)===10) && ((Q[\'christmas_break\'] || 0) <= 2)) && ((Q[\'week_progress\'] || 0) < 3));"},"onArrival":[{"$code":"Q[\'christmas_break\'] = (Q[\'christmas_break\'] || 0) + 1;\\nQ[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"tags":["top","christmas"],"options":[{"id":"@christmas_break.practice_pageant","title":"Prepare for the pageant."},{"id":"@christmas_break.homework","title":"Do your homework."},{"id":"@christmas_break.videogames","title":"Play video games."}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"This winter break,\\""}," mom says in the opening to one of her lectures, ",{"type":"emphasis-1","content":"\\"is a very good opportunity. You have so much free time, you can do your science, your "},"pageant",{"type":"emphasis-1","content":", your anything is fine. Also don\'t forget to do your homework. You shouldn\'t wait until January 1st to do it.\\""},""]},{"type":"paragraph","content":"Mom has a point, sort of, as with all of her lectures. You can do anything, but there are some things you should do during this break."}]},"christmas_party.feeling_neutral":{"id":"christmas_party.feeling_neutral","options":[{"id":"@christmas_party.join_scrabble","title":"Of course you would join."}],"content":[{"type":"paragraph","content":"Whatever. It doesn\'t matter anyway. The important thing is, Emily is here. Right now."},{"type":"paragraph","content":"It must have been a long moment, as Aubrey interrupts your reverie. \\"So, do you two know each other?\\", she asks."},{"type":"paragraph","content":"\\"Kind of,\\" Emily says, not turning her head."},{"type":"paragraph","content":"\\"Anyway, we\'re playing Scrabble here,\\" Aubrey says. \\"It\'d be great if you joined us.\\""}]},"church_1.hi_2":{"id":"church_1.hi_2","options":[{"id":"@church_1.home","title":"You want to go home."},{"id":"@church_1.stay","title":"Maybe staying here with Aubrey isn\'t too bad."}],"content":{"content":"You stand awkwardly next to Spencer and Aubrey. Spencer laughs at something ridiculous going on on the screen. You can\'t pay attention. You glance at Aubrey, and quickly look away. There\'s no good reason why you should be still attracted to her in any way, yet of course you still are. Does she know anything? Hopefully not.","type":"paragraph"}},"church_2.aubrey_start":{"id":"church_2.aubrey_start","options":[{"id":"@church_2.um","title":"Um......"},{"id":"@church_2.okay","title":"No you never heard."}],"content":[{"type":"paragraph","content":"\\"So, what do you think of Wang Laoshi\'s situation? Did you hear about his wife?\\""},{"type":"paragraph","content":"Oh God."}]},"church_3.scream_2":{"id":"church_3.scream_2","options":[{"id":"@church_3.talk_aubrey","title":"You didn\'t even get to talk to Aubrey"},{"id":"@church_3.no_homework","title":"You didn\'t even get to do your homework."}],"content":[{"type":"paragraph","content":"He\'s hurt himself by falling down. He\'s bawling, crying his eyes out. The other children circle around, looking on with vaguely guilty expressions."},{"type":"paragraph","content":"Your parents are already here, and mom carries him upstairs. After scolding the other children, she tells you that you\'re all leaving early."}]},"classes_1.flaws":{"id":"classes_1.flaws","options":[{"id":"@classes_1.thanks","title":"\\"Um, thanks?\\""}],"content":[{"type":"paragraph","content":"\\"What about my flaws, though?\\""},{"type":"paragraph","content":"\\"That\'s an awkward question.\\""},{"type":"paragraph","content":"\\"Oh. But, uh, it\'s important. Right?\\""},{"type":"paragraph","content":"\\"Okay, how do I say this?\\" She laughs, as if to herself. \\"Just in terms of physical stuff... Fashion choices. Shitty skincare. Facial expressions. Lack of body tone. And, like, that\'s all I can think of right now. But don\'t worry about it. You\'re skinny. That\'s all that matters.\\""}]},"emily_1.weird":{"id":"emily_1.weird","goTo":[{"id":"emily_1.emily_weird"}],"content":{"content":"Yeah. It is strange that she would take part in the pageant meeting without doing the pageant. Old PSAs about not trusting strangers come to mind. But you don\'t have a real reason to distrust her, and you know how Asian parents can be.","type":"paragraph"}},"emily_3_online.not":{"id":"emily_3_online.not","goTo":[{"id":"emily_3_online.what_to_do"}],"content":[{"type":"paragraph","content":"You: I don\'t think of you any lesser as a human being."},{"type":"paragraph","content":"That was a good line, right? You have no idea."},{"type":"paragraph","content":"Emily: Thanks :)"}]},"emily_2.library":{"id":"emily_2.library","options":[{"id":"@emily_2.study","title":"Study. Or at least try to."}],"content":[{"type":"paragraph","content":"Emily said that she wanted to go to the library to study, so the two of you take a train to Copley. You\'ve always held some affection for the Central Library, with its vast rows of books that you could get lost in for days."},{"type":"paragraph","content":"\\"I like studying here because people I know don\'t usually show up,\\" she says."},{"type":"paragraph","content":"\\"Same.\\" She smiles at your answer. Maybe you have more similarities than you thought. You\'re still watching her hands when she takes out some papers with what looks like complicated math on them."},{"type":"paragraph","content":"\\"Oh, this is multivariable calculus,\\" she says, enounciating the sylables with a bit of pride. \\"It\'s an advanced program through my school.\\""},{"type":"paragraph","content":"\\"Oh. So, like, is math your favorite subject?\\" (what kind of a question is that?)"},{"type":"paragraph","content":"\\"Probably. I think so.\\""}]},"emily_4.more":{"id":"emily_4.more","goTo":[{"id":"emily_4.so_what"}],"content":{"content":"","type":"paragraph"}},"emily_6.speak":{"id":"emily_6.speak","goTo":[{"id":"emily_6.speak_2"}],"content":{"content":"What are you supposed to do at a time like this? You try to run mental simulations for this situation. Enumerate all of the possible sequences of words you could say at the moment, and imagine what it would be like if you uttered those words, how Emily would react. Or how she wouldn\'t react.","type":"paragraph"}},"emily_7.say_out_loud":{"id":"emily_7.say_out_loud","options":[{"id":"@emily_7.ohgod","title":"Oh God..."}],"content":[{"type":"paragraph","content":"\\"Um, hey, I, um, I really kind of like you. Yeah.\\""},{"type":"paragraph","content":"Emily turns and catches your eye. You glance away."}]},"emily_final.science_future":{"id":"emily_final.science_future","options":[{"id":"@emily_final.dont_be_morbid","title":"Don\'t be morbid?"}],"content":[{"type":"paragraph","content":"You: What about science? What about your future?"},{"type":"paragraph","content":"Emily: I don\'t know if I have a future."},{"type":"paragraph","content":"You: I thought you were interested in studying science?"},{"type":"paragraph","content":"Emily: Yeah, well."},{"type":"paragraph","content":"Emily: It\'s kind of hard to think that far ahead."},{"type":"paragraph","content":"Emily: All I can do is imagine the ways in which I\'ll die."},{"type":"paragraph","content":"You: Sorry..."}]},"epilogue.ep_scioly_neutral":{"id":"epilogue.ep_scioly_neutral","maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"viewIf":{"$code":"return (((Q[\'invitational\'] || 0)===1) && ((Q[\'scioly_final_seen\'] || 0)===0));"},"content":[{"type":"paragraph","content":"Science Olympiad continued with the regional competition, which your school passed, and the state competition, where your school placed ninth out of 20-something. Despite the mediocre placement, the captain considered it a success."},{"type":"paragraph","content":"Speaking of which, elections for the new captain have come up. The winner was the slate of Krishna and his friend Daniel. Krishna has been slightly nicer than usual lately."}],"countVisitsMax":1},"family_3.ips":{"id":"family_3.ips","viewIf":{"$code":"return ((Q[\'seen_ips\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'seen_ips\'] = 1;"}],"options":[{"id":"@family_3.oh","title":"\\"Nothing.\\""}],"content":{"content":[{"type":"paragraph","content":["That\'s a science fiction joke, and you know it. Although, you\'ve been thinking about how you would implement this ever since you took AP Bio. First you need to de-program existing somatic cells to produce induced pluripotent stem cells (iPSCs); that\'s already been done. If you could decipher the signaling and regulatory pathways associated with gamete development, you could provide your reprogrammed cells with the right signaling molecules and environment, and the gametes would develop. However, sperm development requires some genes only present on the Y-chromosome (the SRY gene in particular, maybe others?), which is troublesome. The good thing is that there aren\'t too many of these genes so you could just make an artificial chromosome with just the genes you need, but that\'s hard, and you\'d have to express those genes in the correct amounts too which probably involves epigenetic modification not that you know anything about that. Does that mean you\'d have to work on DNA synthesis too? Add that to the list of \\"",{"type":"insert","insert":0},"\'s research goals\\". That list has to be getting longer and longer."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"你笑什么？What are you smiling about?\\""},", mother asks you."]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"family_5.ignore":{"id":"family_5.ignore","options":[{"id":"@family_5.hide","title":"Hide."}],"content":[{"type":"paragraph","content":"You ignore him. Pretend he isn\'t here. You hear footsteps approaching. Knocks on the door. It opens."},{"type":"paragraph","content":{"type":"emphasis-1","content":"\\"I just want to talk. Why did you run away? 世界怎么成这样子？\\""}}]},"family_2.dad_3":{"id":"family_2.dad_3","options":[{"id":"@family_2.dad_1","title":"Dad tells stories about growing up."},{"id":"@family_2.self_doubt","title":"You think about the stories."},{"id":"@family_2.nothing","title":"You\'re tired of this talk."}],"content":{"content":"The meal is potatoes, so of course dad has to chime in. When he was young, during winter all they had to eat were potatoes and yams and maybe a few grains of millet and sorghum. That\'s why he doesn\'t like potatoes, dad says. Meat was once a year. Cabbage was once a week. Or was meat once a month? Either way, they had half their yearly meat at Chinese New Year’s when they made dumplings filled with fatty pork. It was the most delicious thing dad ever ate. You stare at the pieces of fatty meat left uneaten on your plate.","type":"paragraph"}},"family_6.oh_okay":{"id":"family_6.oh_okay","options":[{"id":"@family_6.its_fine","title":"It\'s fine. I\'m okay."},{"id":"@family_6.why_apologize","title":"Why are you apologizing right now?"}],"content":[{"type":"paragraph","content":"\\"Oh. Okay.\\""},{"type":"paragraph","content":["Mom continues. \\"不只是爸爸的错。也是我的错。我们真的没有给你们一个好的环境。",{"type":"emphasis-1","content":"It\'s not only dad\'s fault. It\'s my fault too. We really didn\'t give you a good environment growing up."},"\\""]}]},"family_final.mom_3":{"id":"family_final.mom_3","options":[{"id":"@family_final.history","title":"You wish you could learn more."},{"id":"@family_final.tired","title":"You\'re tired of the stories."},{"id":"@family_final.no_matter","title":"It doesn\'t matter; you don\'t care about their stories."}],"content":{"content":"Mom talks about the apartment that you moved to, after you returned to your parents from your grandparents after you were four. It was a fifth-story unit in a six-story building without any elevators. It was a good place, with its own bathroom and kitchen, but every week dad had to carry a tank of natural gas upstairs for cooking. You never liked to take baths in the bathroom because you were afraid of falling down the squatting toilet. Eventually there was even an air conditioner, carried upstairs and installed by two very strong men, one of whom hung outside with nothing more than a loop of rope. It was a different time back then, dad says, not like now. It was a hard time, not like now.","type":"paragraph"}},"family_4.kevin":{"id":"family_4.kevin","options":[{"id":"@family_4.answer","title":"Answer it."}],"content":[{"type":"paragraph","content":"Your parents got the iPad for you for Christmas. You gave it to Kevin. He proceeded to become a Minecraft addict."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"How\'s it going?\\""},", you ask."]},{"type":"paragraph","content":"\\"Uh. Good,\\" he says. He doesn\'t pay attention to you or anything else. You start on some homework. It\'s hard to concentrate."},{"type":"paragraph","content":"It\'s quiet outside now. How long has it been? An hour? Two? Three? There\'s a knock on the door."}]},"introspect_1.grace":{"id":"introspect_1.grace","goTo":[{"id":"introspect_1.name"}],"onArrival":[{"$code":"Q[\'first_name\'] = \\"Grace\\";"}],"content":{"content":"","type":"paragraph"}},"introspect_2.miri":{"id":"introspect_2.miri","viewIf":{"$code":"return (((Q[\'miri\'] || 0) > 0) && ((Q[\'seen_miri_introspect_2\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'seen_miri_introspect_2\'] = 1;"}],"goTo":[{"id":"introspect_2.people"}],"content":{"content":"Miri is... your friend. Probably. She\'s probably the person you\'re closest to in the whole world, barring immediate family. And you like her, and enjoy being in a close vicinity to her. But you can\'t help but feel as if there\'s a lot that you\'re keeping from each other.","type":"paragraph"}},"introspect_3.miri":{"id":"introspect_3.miri","maxVisits":1,"options":[{"id":"@introspect_3.emily","title":"Think about Emily."},{"id":"@introspect_3.miri","title":"Think about Miri."},{"id":"@introspect_3.aubrey","title":"Think about Aubrey."},{"id":"@introspect_3.parents","title":"Think about mom and dad."},{"id":"@introspect_3.kevin","title":"Think about Kevin."},{"id":"@introspect_3.stop","title":"Enough thinking for now."}],"content":{"content":[{"type":"paragraph","content":[{"type":"conditional","content":"You\'re... well, she asked you out, and you said yes. So you\'re... girlfriends now? Or something like that? It\'s hard to think about, but it feels good, and it\'s what you want. Probably. ","predicate":0},""]},{"type":"paragraph","content":[{"type":"conditional","content":"You haven\'t interacted much with Miri recently. Are you still friends? Do you still have any kind of relationship? ","predicate":1},""]},{"type":"paragraph","content":[{"type":"conditional","content":"You\'ve been asking Miri for help on the pageant somewhat. ","predicate":2},""]},{"type":"paragraph","content":{"type":"conditional","content":"You\'ve been working with Miri on preparing for the pageant. She\'s been pretty helpful.","predicate":3}}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'miri_date\'] || 0) > 0);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'miri\'] || 0) < 2);"}},{"type":"predicate","fn":{"$code":"return (((Q[\'miri\'] || 0)===2) || ((Q[\'miri\'] || 0)===3));"}},{"type":"predicate","fn":{"$code":"return ((Q[\'miri\'] || 0) > 3);"}}]},"countVisitsMax":1},"loneliness_1.homework":{"id":"loneliness_1.homework","goTo":[{"id":"loneliness_1.options"}],"content":{"content":"It\'s hard to bring yourself to start writing the literature essay. You can\'t give a reason why. It\'s as if there\'s a mental block preventing you from putting words on the screen.","type":"paragraph"}},"loneliness_2.forget_about_it":{"id":"loneliness_2.forget_about_it","onArrival":[{"$code":"Q[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"content":[{"type":"paragraph","content":"Why would you contact Miri at this hour? Why would you contact anyone at this hour? Why would you contact anyone, at any time? Why anything?"},{"type":"paragraph","content":"Threads of thoughts wind into knots, twisting inside your mind. You turn around. You can\'t fall asleep, until you eventually do."},{"type":"paragraph","content":"It\'s 6:30 AM, time for you to get up, and you\'re not sure if you were actually asleep at any time last night/morning."}]},"miri_date.hs_okay":{"id":"miri_date.hs_okay","options":[{"id":"@miri_date.webcomics","title":"Have a long and scintillating conversation about internet media."},{"id":"@miri_date.a3","title":"Have a long and meaningful conversation about literally anything else."}],"content":[{"type":"paragraph","content":"\\"I mean, it might not be good, but we\'ve already gotten this far...\\""},{"type":"paragraph","content":"\\"What do they call that? The sunk cost fallacy?\\""},{"type":"paragraph","content":"A lull. Miri seems to be not so interested in the topic."}]},"miri_pageant_prep.help_gym":{"id":"miri_pageant_prep.help_gym","options":[{"id":"@miri_pageant_prep.lift","title":"Finally you can start lifting."}],"content":[{"type":"paragraph","content":"Miri sighs. \\"You have to move the pin to a different level, to lower the weight. Here. I\'ll show you.\\""},{"type":"paragraph","content":"\\"How do you know how to do that?\\""},{"type":"paragraph","content":"\\"Gym. This might be my only memory of that class.\\""},{"type":"paragraph","content":"\\"Oh. Well. Thanks.\\""}]},"pageant_prep_self_2.spin_resume":{"id":"pageant_prep_self_2.spin_resume","options":[{"id":"@pageant_prep_self_2.platform_doc","title":"There\'s also the platform doc."},{"id":"@pageant_prep_self_2.docs_done","title":"You\'re done with the documents...?"}],"content":{"content":"So basically this is like a college app. Once your mind enters that frame, things start to fall into place. Soon enough, it\'s adequately completed, or something like that.","type":"paragraph"}},"pageant_final.paperwork":{"id":"pageant_final.paperwork","options":[{"id":"@pageant_final.hair_1","title":"Step 1: Hair."}],"content":{"content":"Fortunately you\'re already mostly done with paperwork. You have the resume, the platform statement, and the miscellaneous forms all in order.","type":"paragraph"}},"pageant_prep_try_ball_gown.okay_5":{"id":"pageant_prep_try_ball_gown.okay_5","options":[{"id":"@pageant_prep_try_ball_gown.shes_right","title":"You know she\'s right."},{"id":"@pageant_prep_try_ball_gown.but_not","title":"But that doesn\'t make you feel better."},{"id":"@pageant_prep_try_ball_gown.screw_pageant","title":"Screw the pageant."}],"content":[{"type":"paragraph","content":"\\"Okay.\\" You look away."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Walk around a little. How does it feel.\\""},""]},{"type":"paragraph","content":["You do so. You walk around the living room. Kevin barely looks up from his tablet. ",{"type":"emphasis-1","content":"\\"Really beautiful,\\""}," dad says before going back to his phone."]},{"type":"paragraph","content":"Anyway, you practice walking around, not tripping, standing up straight, making pageant poses, pretending to smile, and so on, until mom is almost satisfied, or something like that."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Good,\\""}," mom says finally, as she helps to undo the back. ",{"type":"emphasis-1","content":"\\"You should practice more. Not much time left.\\""},""]},{"type":"paragraph","content":"You don\'t bother responding this time."}]},"pageant_meetup.sit_emily":{"id":"pageant_meetup.sit_emily","onArrival":[{"$code":"Q[\'sit_emily\'] = 1;"}],"options":[{"id":"@pageant_meetup.start_meeting","title":"The meeting begins."}],"content":{"content":[{"type":"paragraph","content":"You sit down next to the girl you just met."},{"type":"paragraph","content":"\\"I\'m Emily,\\" she says."},{"type":"paragraph","content":["\\"Oh, uh, I\'m ",{"type":"insert","insert":0},".\\""]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"research_3.none_of_the_above":{"id":"research_3.none_of_the_above","goTo":[{"id":"research_3.output"}],"content":{"content":"If it\'s not fun or interesting, then what is it? Meaningful preparation for a future career in science? Sure, let\'s go with that.","type":"paragraph"}},"research_4.um_2":{"id":"research_4.um_2","options":[{"id":"@research_4.so","title":"\\"So...\\""}],"content":{"content":"\\"Um...\\"","type":"paragraph"}},"research_6.dont_think":{"id":"research_6.dont_think","options":[{"id":"@research_6.continue_presentation","title":"And so on."}],"content":[{"type":"paragraph","content":"Okay. You know how to deal with these situations. Just tune out and act as if nothing is special. Focus on the work and you\'ll be fine."},{"type":"paragraph","content":"You take out your laptop and open up to Google Docs. \\"So what I\'ve been working on is...\\""}]},"research_final.tab_out":{"id":"research_final.tab_out","goTo":[{"id":"research_final.stella_sees"}],"content":{"content":"It doesn\'t matter. Stella has already seen what you\'re looking at.","type":"paragraph"}},"scioly_invitational.protein_modeling":{"id":"scioly_invitational.protein_modeling","options":[{"id":"@scioly_invitational.protein_good","title":"Well."},{"id":"@scioly_invitational.protein_okay","title":"Fine."},{"id":"@scioly_invitational.protein_bad","title":"Semi-adequately."}],"content":[{"type":"paragraph","content":"Next is Protein Modeling. This is the event you\'re doing with Aubrey. You rush over to the classroom, fortunately in the same building."},{"type":"paragraph","content":"The event has two portions, a building part and a knowledge test. Aubrey has already built the protein model and submitted it, so there\'s not much for you to do there. She says that she thinks it\'s going to be alright, and she\'s usually right about such things."},{"type":"paragraph","content":"The written test goes..."}]},"shopping_with_mom.buy_red_dress":{"id":"shopping_with_mom.buy_red_dress","onArrival":[{"$code":"Q[\'red_dress\'] = 1;"}],"goTo":[{"id":"shopping_with_mom.shoes"}],"content":{"content":"Okay, you put the red dress in your shopping bag.","type":"paragraph"}},"research_1.yes":{"id":"research_1.yes","goTo":[{"id":"research_1.no"}],"content":{"content":"","type":"paragraph"}},"skip.w5_scioly_3":{"id":"skip.w5_scioly_3","onArrival":[{"$code":"Q[\'scioly\'] = 0;"}],"goTo":[{"id":"skip.w5_research_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.stay_alone":{"id":"scioly_study_party.stay_alone","goTo":[{"id":"scioly_study_party.conversation"}],"content":{"content":"That does not seem to be the best strategy. After all, this is supposed to be a study party, not a party party. And the whole purpose of a study party is to interact with your teammates in order to prepare for the competition.","type":"paragraph"}},"stress_full.no_excuse_2":{"id":"stress_full.no_excuse_2","content":[{"type":"paragraph","content":"You shake your head. After the nurse watches you for a moment, you finally open your mouth. \\"Yes. I mean, I don\'t need to be excused.\\""},{"type":"paragraph","content":"\\"Well, alright then.\\""},{"type":"paragraph","content":"You get up. You can still walk. It\'s going to be fine."}]},"stress_full":{"id":"stress_full","type":"scene","title":"Stress","subtitle":"A fall","newPage":true,"viewIf":{"$code":"return ((Q[\'stress\'] || 0) >= 15);"},"onArrival":[{"$code":"Q[\'stress\'] = (Q[\'stress\'] || 0) - 7;\\nQ[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'gpa\'] = (Q[\'gpa\'] || 0) - 0.1;"}],"tags":["top","stress"],"options":[{"id":"@stress_full.apoptosis","title":"..."}],"content":[{"type":"paragraph","content":"It\'s not as if you\'ve never slept in class before. What harm could it do? And this is AP World; there\'s nothing you couldn\'t learn by yourself through reading the textbook and/or Wikipedia."},{"type":"paragraph","content":"You fall down."}]},"thanksgiving_party.meet_emily1":{"id":"thanksgiving_party.meet_emily1","viewIf":{"$code":"return ((Q[\'emily\'] || 0) <= 1);"},"onArrival":[{"$code":"Q[\'meet_emily\'] = 0;"}],"goTo":[{"id":"thanksgiving_party.play_nicely"}],"content":{"content":"The person that emerges is about your height, with unruly shoulder-length hair, wearing a t-shirt and pajamas.","type":"paragraph"}},"stress_2.mom":{"id":"stress_2.mom","content":[{"type":"paragraph","content":"The door opens. There is no other source of light; the window is dark."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"What are you doing? Come eat,\\""}," mom says, and opens the light."]},{"type":"paragraph","content":"Your eyes burn."}]},"stress_2":{"id":"stress_2","type":"scene","title":"Feeling tired","subtitle":"Home, Afternoon","newPage":true,"viewIf":{"$code":"return (((((Q[\'stress\'] || 0) > 6) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'stress_1_seen\'] || 0) >= 1)) && ((Q[\'week\'] || 0) < 100));"},"onArrival":[{"$code":"Q[\'stress\'] = (Q[\'stress\'] || 0) - 3;\\nQ[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;"}],"maxVisits":3,"priority":3,"tags":["top","stress"],"options":[{"id":"@stress_2.start_hw","title":"Time to get started, or something like that."}],"content":{"content":"Today has been another difficult day. The homework piles up: AP Calc and AP Chem are the largest offenders as usual, but AP World and AP Lit are also part of the struggle. You would estimate that there is a total of four hours of homework today, and that\'s only if you manage to avoid all distractions and procrastination.","type":"paragraph"},"countVisitsMax":3},"scioly_2.proteins_what_do_you_know":{"id":"scioly_2.proteins_what_do_you_know","options":[{"id":"@scioly_2.protein_20_amino_acids","title":"20?"}],"content":[{"type":"paragraph","content":"\\"Proteins are, um, one of the basic building blocks of life. Along with carbohydrates, lipids, and nucleic acids. They are, um, made of long chains of various amino acids.\\""},{"type":"paragraph","content":"Aubrey nods. \\"Sure. Tell me about protein structure.\\""},{"type":"paragraph","content":"\\"Um, there\'s primary structure which is just the amino acid chain. Then secondary structure is repeated structural elements like the sheets and helices and stuff, and then tertiary structure which is how these elements are assembled together. And there\'s quaternary structure, which is like, multiple proteins interacting together?\\""},{"type":"paragraph","content":"\\"That works. How many amino acids are there, that make up proteins?\\", Aubrey asks, starting off with the basics."}]},"scioly_final.empathetic":{"id":"scioly_final.empathetic","goTo":[{"id":"scioly_final.what_do_you_think"}],"content":{"content":"The captain called you \\"empathetic\\" because it is a feminine-coded trait, and you are apparently a feminine-coded person. In truth you have no idea if you are particularly empathetic or not.","type":"paragraph"}},"1.intro2":{"id":"1.intro2","options":[{"id":"@1.really","title":{"type":"emphasis-1","content":"\\"Really? Do I have to?\\""}}],"content":[{"type":"paragraph","content":["Mom smiles. ",{"type":"emphasis-1","content":"\\"We\'ve already signed you up.\\""}," She tosses a folder of printed forms in front of you. ",{"type":"emphasis-1","content":"\\"It\'s a good opportunity.\\""},""]},{"type":"paragraph","content":"\\"Oh.\\" It takes a moment to register."}]},"aubrey_final.walk_path":{"id":"aubrey_final.walk_path","options":[{"id":"@aubrey_final.no_date","title":"No..."},{"id":"@aubrey_final.yes_date","title":"(lie) Yes, of course!"}],"content":{"content":"\\"Just wondering, have you ever done anything like this before?\\", Aubrey asked. \\"Like, a date or anything like that?\\"","type":"paragraph"}},"birthday.family_celebrate":{"id":"birthday.family_celebrate","onArrival":[{"$code":"Q[\'loneliness\'] = (Q[\'loneliness\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) - 1;"}],"options":[{"id":"@birthday.family_celebrate_2","title":"It\'s time to leave."}],"content":[{"type":"paragraph","content":"The four of you take the T to the Museum of Science. You used to enjoy this place when you were younger and more innocent, with its interactive exhibits that made you feel like you could understand anything. Now it\'s your brother\'s turn. His eyes glow as he plays with glowing buttons and touch-screen displays, and he runs from dinosaurs to planets and everything in between."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Boys just like these scientific things,\\""}," dad says."]},{"type":"paragraph","content":"You stand a ways back, look down at the floor, hoping no one you know will see you there. Of course no one you know is there. High schoolers don\'t go to science museums for fun."}]},"christmas_party.join_scrabble":{"id":"christmas_party.join_scrabble","options":[{"id":"@christmas_party.stare_emily","title":"Stare at Emily?"},{"id":"@christmas_party.ignore_emily","title":"Ignore emily for now?"}],"content":[{"type":"paragraph","content":"Of course you would join. You love contests of wit and knowledge such as this game of Scrabble right here, and it is here that your prolific lexicon would provide you with an advantage."},{"type":"paragraph","content":"But it\'s a bit hard to concentrate with Emily here, glancing at you every once in a while."}]},"church_1.home":{"id":"church_1.home","options":[{"id":"@church_1.endure","title":"Endure."}],"content":[{"type":"paragraph","content":"Right now there\'s nothing you would like more than to go home. Back where you can be alone and free and not have to face the eyes of all these people. You probably have homework to do; that always works as an excuse."},{"type":"paragraph","content":"But then Aubrey looks at you, and you melt away. You can\'t deal with this."},{"type":"paragraph","content":"\\"Hey, do you want to sit down?\\", she says."},{"type":"paragraph","content":["You sit next to her. Why is she leaning against you. The probability that this ",{"type":"emphasis-1","content":"means"}," anything is approximately zero. But it\'s a pleasant feeling. Sort of. Maybe. Insofar that any feelings are pleasant."]}]},"church_2.um":{"id":"church_2.um","options":[{"id":"@church_2.say_nothing","title":"Finish eating."}],"content":[{"type":"paragraph","content":"You close your eyes. Fall backwards on the couch in a vaguely dramatic pose."},{"type":"paragraph","content":"\\"Hey, are you alright?\\", Aubrey asks."},{"type":"paragraph","content":"\\"Yeah. I mean no. Maybe.\\""},{"type":"paragraph","content":"\\"Are you sure?\\""},{"type":"paragraph","content":"You open your eyes again. Aubrey is looking over you. Inexplicably your face starts to feel hot. You close your eyes again."},{"type":"paragraph","content":"Well, maybe that worked."}]},"church_3.comfort_brother":{"id":"church_3.comfort_brother","options":[{"id":"@church_3.talk_aubrey","title":"You didn\'t even get to talk to Aubrey"},{"id":"@church_3.no_homework","title":"You didn\'t even get to do your homework."}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Where were you hit?\\""},", you say, as you try to comfort him with a hug."]},{"type":"paragraph","content":"But then mom comes downstairs and takes him away from you. She carries him upstairs. After scolding the other children, she tells you that you\'re all leaving early."}]},"classes_1.thanks":{"id":"classes_1.thanks","options":[{"id":"@classes_1.platform","title":"Step 2: platform"}],"content":[{"type":"paragraph","content":"\\"Um, thanks?\\""},{"type":"paragraph","content":"\\"No problem,\\" Miri says. \\"So what\'s next on your pageant to-do list?\\""}]},"emily_1.hear_her_out":{"id":"emily_1.hear_her_out","goTo":[{"id":"emily_1.emily_weird"}],"content":{"content":"Strange as she may be, she is probably not acting maliciously. And you kind of appreciate her logical approach.","type":"paragraph"}},"emily_3_online.still":{"id":"emily_3_online.still","goTo":[{"id":"emily_3_online.what_to_do"}],"content":[{"type":"paragraph","content":"You: You\'re still Emily Chen, right? Nothing\'s changed then. I don\'t think any differently of you I guess."},{"type":"paragraph","content":"That was a good line, right? You have no idea but you probably should not have added \\"I guess\\" at the end."},{"type":"paragraph","content":"Emily: Yes, I guess so."}]},"emily_2.study":{"id":"emily_2.study","options":[{"id":"@emily_2.keep_studying","title":"Keep studying."},{"id":"@emily_2.stare_em","title":"Stare at Emily"}],"content":[{"type":"paragraph","content":["Wait, why are you here? With this Emily Chen person? Weren\'t you going to do pageant-related stuff? Has she become a ",{"type":"emphasis-1","content":"friend"},"? Or something like that? Would it be too awkward to ask?"]},{"type":"paragraph","content":"And this is just the second time you\'ve met this person. She seems... nice? Weird? Trying to put your feelings into words is like trying to fit a linear regression onto an exponential dataset without a log-transform. Meanwhile you actually do have to fit some exponential curves for your chemistry homework."}]},"emily_4.so_what":{"id":"emily_4.so_what","options":[{"id":"@emily_4.hate","title":"You hate questions like that."}],"content":[{"type":"paragraph","content":"\\"Does it matter?\\", you say. \\"I\'m here because, um, I want to be?\\""},{"type":"paragraph","content":"Emily gives you a strange look. Actually all her looks are at least a little strange, but this one slightly more so. She turns to the floor again, and plays with her hair, sometimes sipping from her coffee. It\'s a few awkward minutes before she speaks again."},{"type":"paragraph","content":"\\"So, like, what do you want to do now?\\""}]},"emily_6.wait_emily":{"id":"emily_6.wait_emily","goTo":[{"id":"emily_6.speak_2"}],"content":{"content":"You stay silent, and surprise, so does Emily, neither of you looking at the other. It stays like this for who knows how long. Is this companiable silence or awkward silence? You\'ve never been good at judging that distinction.","type":"paragraph"}},"emily_7.ohgod":{"id":"emily_7.ohgod","options":[{"id":"@emily_7.fucked_up","title":"You completely fucked this up."}],"content":[{"type":"paragraph","content":"Emily laughs all of a sudden. \\"God, this is right where I was about to say something about basically any positive social interaction I have is contingent on my success in the optimization problem that is womanhood. And you just made my point for me.\\""},{"type":"paragraph","content":"Oh God oh god oh god oh god oh god...."}]},"emily_final.dont_be_morbid":{"id":"emily_final.dont_be_morbid","options":[{"id":"@emily_final.i_care","title":"\\"I care...\\""},{"id":"@emily_final.where_now","title":"\\"Where are you now?\\""}],"content":[{"type":"paragraph","content":"You: Don\'t be morbid?"},{"type":"paragraph","content":"You: In all likelihood you\'re not going to die anytime soon."},{"type":"paragraph","content":"Emily: The rational part of me wants to understand. But it\'s not that easy."},{"type":"paragraph","content":"Emily: Like sometimes I feel like I don\'t have much time left. Will I live until 20? 30? It feels like a toss-up."},{"type":"paragraph","content":"Emily: I know multiple trans girls on the internet who have died. Even communicated with a couple of them."},{"type":"paragraph","content":"Emily: Rationally speaking I know that some people would care if I died or disappeared."},{"type":"paragraph","content":["Emily: But they care about the image of me that they have manufactured in their minds, not ",{"type":"emphasis-1","content":"me"},"."]},{"type":"paragraph","content":"Emily: God this is so selfish."}]},"epilogue.ep_research_good":{"id":"epilogue.ep_research_good","maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"viewIf":{"$code":"return ((Q[\'research\'] || 0) >= 5);"},"content":{"content":"You\'re continuing on with your research work with Professor Chen and Stella. It\'s become a part of your routine. The work is generally pretty interesting, and you\'re learning a little about how science works, which might become useful in your future career. You\'re not going to change the world, not yet anyway, but it\'s a start.","type":"paragraph"},"countVisitsMax":1},"family_3.oh":{"id":"family_3.oh","options":[{"id":"@family_3.end","title":"The rice is getting cold."}],"content":[{"type":"paragraph","content":["Your face contorts back to a safe neutral. ",{"type":"emphasis-1","content":"\\"I\'m not smiling about anything.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Oh really?\\""},", father asks. ",{"type":"emphasis-1","content":"\\"What are you hiding?\\""},""]},{"type":"paragraph","content":["You just shake your head. ",{"type":"emphasis-1","content":"\\"I\'m not hiding anything.\\""},""]},{"type":"paragraph","content":"And that was that. You remember years ago when in church you said that you never remembered telling any lies. It must have been a lie then, and it\'s even more of a lie now. You\'re just one big sack of secrets."},{"type":"paragraph","content":"But, science will solve this. Science is always the answer, right? Somehow you feel your hope becoming ever more hollow."}]},"family_5.hide":{"id":"family_5.hide","options":[{"id":"@family_5.alive","title":"You\'re alive."}],"content":[{"type":"paragraph","content":"There\'s nowhere for you to go. You sit on your bed. Not moving. Not looking."},{"type":"paragraph","content":"He stands in the doorway. He sighs."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"I just wanted to talk and you run away. This really is a bad child. Can\'t even talk to baba for one moment. What is wrong with the children?\\""},""]},{"type":"paragraph","content":"He leaves, slamming the door."}]},"family_2.self_doubt":{"id":"family_2.self_doubt","onArrival":[{"$code":"Q[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'loneliness\'] = (Q[\'loneliness\'] || 0) + 1;"}],"options":[{"id":"@family_2.continue","title":"You start to hate yourself, a bit more than usual."}],"content":{"content":"You think about yourself. How the fuck does being a fucking closeted queer matter compare to this? How the fuck can you say that you\'ve ever suffered a day in your life? How can you say that you know anything about suffering when you\'ve never even been malnourished? How can you be so ungrateful, so ungrateful as to even think about not perpetuating your parents\' wishes when they\'ve suffered so much for you?","type":"paragraph"}},"family_6.why_apologize":{"id":"family_6.why_apologize","options":[{"id":"@family_6.dotdotdot","title":"..."}],"content":[{"type":"paragraph","content":"That\'s what you would like to say. Is this more games in the power struggle your parents are playing? Is she attempting to ingratiate herself with you to gain your support in their eventual divorce? On the other hand, she\'s probably objectively better than dad right now. But you can\'t say that. Part of you wishes you knew your parents better, and that you could let them know you better."},{"type":"paragraph","content":["But you don\'t say that. Instead you say, \\"我没事儿。",{"type":"emphasis-1","content":"I\'m fine."},"\\""]}]},"family_final.history":{"id":"family_final.history","content":[{"type":"paragraph","content":["Hearing your parents\' stories makes you feel nostalgic for a world that you never experienced. Part of you wishes that you could preserve the memories for the future, that the memories and histories contained therein ",{"type":"emphasis-1","content":"must"}," be saved somehow. Your parents are products of a time long gone, of a generation raised in trauma and change, whose memories are inconvenient to the powers-that-be in the country of your birth. That\'s why these stories are precious."]},{"type":"paragraph","content":"Mom sometimes says that she wants to write a novel about your family history. It would be in Chinese, of course. She asks if you would help. You don\'t know how."}]},"family_4.answer":{"id":"family_4.answer","options":[{"id":"@family_4.hug","title":"Accept her hug."},{"id":"@family_4.retreat","title":"Back away from her."}],"content":[{"type":"paragraph","content":["\\"对不起“, mom says. ",{"type":"emphasis-1","content":"\\"I\'m sorry.\\""},""]},{"type":"paragraph","content":"\\"Oh. Okay.\\" You look at the floor."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"We\'re really sorry. It\'s really unimaginable, how we acted. Remember that we always love you.\\""}," Her eyes are bloodshot, with marks of tears. She reaches towards you."]}]},"introspect_1.jenny":{"id":"introspect_1.jenny","goTo":[{"id":"introspect_1.name"}],"onArrival":[{"$code":"Q[\'first_name\'] = \\"Jenny\\";"}],"content":{"content":"","type":"paragraph"}},"introspect_2.aubrey":{"id":"introspect_2.aubrey","viewIf":{"$code":"return (((Q[\'aubrey\'] || 0) > 0) && ((Q[\'seen_aubrey_introspect_2\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'seen_aubrey_introspect_2\'] = 1;"}],"goTo":[{"id":"introspect_2.people"}],"content":{"content":"Aubrey is... Aubrey, or something like that. She\'s your friend, probably, or something like that. She\'s like the better version of you, at least according to parents. You used to have a vague crush on her and to be honest you still kind of do, even though you\'re trying to get better.","type":"paragraph"}},"introspect_3.aubrey":{"id":"introspect_3.aubrey","maxVisits":1,"options":[{"id":"@introspect_3.emily","title":"Think about Emily."},{"id":"@introspect_3.miri","title":"Think about Miri."},{"id":"@introspect_3.aubrey","title":"Think about Aubrey."},{"id":"@introspect_3.parents","title":"Think about mom and dad."},{"id":"@introspect_3.kevin","title":"Think about Kevin."},{"id":"@introspect_3.stop","title":"Enough thinking for now."}],"content":{"content":{"type":"paragraph","content":["Aubrey is pretty much the same as usual. ",{"type":"conditional","content":"You worked with her on science olympiad stuff.","predicate":0}]},"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'aubrey_scioly\'] || 0) > 0);"}}]},"countVisitsMax":1},"loneliness_1.homework_real":{"id":"loneliness_1.homework_real","viewIf":{"$code":"return ((((Q[\'wiki_seen\'] || 0)===1) && ((Q[\'social_media_seen\'] || 0)===1)) && ((Q[\'caught_up\'] || 0)===1));"},"onArrival":[{"$code":"Q[\'wiki_seen\'] = 0;\\nQ[\'social_media_seen\'] = 0;\\nQ[\'fanfic_seen\'] = 0;\\nQ[\'loneliness\'] = (Q[\'loneliness\'] || 0) - 1;"}],"content":{"content":"Okay. You\'ve procrastinated long enough. Time to start on the essay, or something like that. You open the gdocs tab that\'s been open for days. It\'s blank. Start with a header. You might as well continue while you\'re at it, starting the intro and an outline. Good enough for now?","type":"paragraph"}},"loneliness_1":{"id":"loneliness_1","type":"scene","title":"Loneliness","subtitle":"A normal evening","newPage":true,"viewIf":{"$code":"return ((((Q[\'loneliness\'] || 0) > 2) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'week\'] || 0) < 100));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'trauma_points\'] = (Q[\'trauma_points\'] || 0) + 1;\\nQ[\'loneliness_1_week_seen\'] = (Q[\'loneliness_1_week_seen\'] || 0) + 1;"}],"priority":3,"maxVisits":3,"tags":["loneliness"],"options":[{"id":"@loneliness_1.wikipedia","title":"Go on Wikipedia."},{"id":"@loneliness_1.social_media","title":"Go on social media."},{"id":"@loneliness_1.webcomic","title":"Read the webcomic."},{"id":"@loneliness_1.homework","title":"Do your homework."},{"id":"@loneliness_1.homework_real","title":"Do your homework (for real this time)."}],"content":[{"type":"paragraph","content":"As usual, you are alone in your room. As usual, Kevin is sleeping in the same room as your parents, leaving his bed empty. As usual, you have had minimal social contact all day. As usual, you are on the computer, homework approximately 40% completed for the next few days, with some inkling of continuing for tonight."},{"type":"paragraph","content":"You do not particularly feel like doing homework right now. Thus, you engage in your perhaps most frequently engaged activity, browsing through your usual collection of tabs like a scripted security guard."}],"countVisitsMax":3},"loneliness_2.sleep":{"id":"loneliness_2.sleep","onArrival":[{"$code":"Q[\'loneliness\'] = (Q[\'loneliness\'] || 0) - 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 2;"}],"content":[{"type":"paragraph","content":"You try to sleep, but it doesn\'t work. Too many things on your mind. But you can\'t think of anything in particular. Your brain is a mess, a jumble of images and feelings and bizarre ideas and noise and words and God knows what else."},{"type":"paragraph","content":"It\'s 6:30 AM, time for you to get up, and you\'re not sure if you were actually asleep at any time last night/morning."}]},"miri_date.webcomics":{"id":"miri_date.webcomics","options":[{"id":"@miri_date.a3","title":"Have a long and meaningful conversation about literally anything else."},{"id":"@miri_date.awkwardness","title":"Sit in awkward silence."}],"content":[{"type":"paragraph","content":"\\"Yeah, I haven\'t been following ever since the gigapause,\\" she says. \\"I just kind of lost interest. From what I heard Game Over kind of sucked.\\""},{"type":"paragraph","content":"\\"Um, I think there\'s going to be a way to fix it. He\'s not going to be that mean...\\""},{"type":"paragraph","content":"\\"Yeah, well, it doesn\'t really matter.\\""}]},"miri_pageant_prep.lift":{"id":"miri_pageant_prep.lift","options":[{"id":"@miri_pageant_prep.waste_of_time","title":"Waste of time?"},{"id":"@miri_pageant_prep.but_it_was_fun","title":"But, it was fun spending time with Miri... Right?"}],"content":[{"type":"paragraph","content":"You lift weights on the machine (you never find out its name) for a while. And then your arms get sore."},{"type":"paragraph","content":"After a total of perhaps 30 minutes in the community center, Miri and you decide to go home. You\'re still not sure how that prepared you for the pageant, and you have quite a few assignments left to do, so..."}]},"pageant_prep_self_2.platform_doc":{"id":"pageant_prep_self_2.platform_doc","viewIf":{"$code":"return ((Q[\'platform_doc_completed\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'platform_doc_completed\'] = 1;\\nQ[\'pageant_platform\'] = (Q[\'pageant_platform\'] || 0) + 1;"}],"options":[{"id":"@pageant_prep_self_2.resume","title":"There\'s also the resume."},{"id":"@pageant_prep_self_2.docs_done","title":"You\'re done with the documents...?"}],"content":[{"type":"paragraph","content":"This document is supposed to describe your platform. The platform, in the context of the pageant, is supposed to be something that you are \\"advocating\\". In your case, it\'s something to do with cancer research or science or whatever."},{"type":"paragraph","content":"Alright. You just have to write an essay about why you care about science, and why other people should care too. There. That\'s it."}]},"pageant_final.hair_1":{"id":"pageant_final.hair_1","options":[{"id":"@pageant_final.straight_hair","title":"Straight hair"},{"id":"@pageant_final.curly_hair","title":"Curled hair"}],"content":{"content":"Step 1: hair. Should you have straight hair or curled hair? Straight hair would be more \\"natural\\". Either way, your normal bird\'s nest of tangles is inappropriate.","type":"paragraph"}},"pageant_prep_try_ball_gown.shes_right":{"id":"pageant_prep_try_ball_gown.shes_right","content":[{"type":"paragraph","content":"You should have practiced more. Practiced earlier. If you really wanted to win. It\'s simply unfortunate that she only became attached to your pageant practice this late in the game."},{"type":"paragraph","content":"Well, it\'s too late now. You\'ll just have to hope for the best."}]},"pageant_meetup.sit_random":{"id":"pageant_meetup.sit_random","options":[{"id":"@pageant_meetup.really","title":"Really? Maybe you\'d rather sit with her..."},{"id":"@pageant_meetup.yeah_really","title":"Yeah, really."}],"content":{"content":"Instead of sitting next to the girl you just met, you find a random spot far from anyone else.","type":"paragraph"}},"research_3.output":{"id":"research_3.output","options":[{"id":"@research_3.train","title":"It\'s your train stop."}],"content":[{"type":"paragraph","content":["Still, you can\'t help but think about why you\'re ",{"type":"emphasis-1","content":"really"}," doing this. Here at the lab, they work on stem cells, and stem cells are what you need to induce the production of gametes so that two people of the supposedly incompatible chromosomal configurations could produce compatible gametes and thus gay people can have biological children with their partners and thus homophobia solved. But no. Instead you\'re working on combining numbers into bigger numbers."]},{"type":"paragraph","content":["Nevertheless, in order to do what you ",{"type":"emphasis-1","content":"really"}," want to do, the research training would help, right? You\'ll need a top-tier PhD, and in order to get a PhD, you\'ll have to get into a good grad school, and in order to get into a good grad school, you\'ll need a good undergrad, and in order to get a good undergrad, you need to do the fricking beauty pageant to stand out among all the other Asians who want to go to MIT only because their parents say it\'s good and not because they really need it like you do."]}]},"research_4.so":{"id":"research_4.so","options":[{"id":"@research_4.present_2","title":"\\"I\'ll be presenting on...\\""}],"content":{"content":{"type":"paragraph","content":["\\"So... I\'m ",{"type":"insert","insert":0},", and, I\'m a high school student, and um...\\" You close your eyes. It\'s going to be fine."]},"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"research_6.continue_presentation":{"id":"research_6.continue_presentation","options":[{"id":"@research_6.text_sorry","title":"Text Emily, saying that you\'re sorry."},{"id":"@research_6.dont_text","title":"Don\'t text Emily."}],"content":[{"type":"paragraph","content":"You sleepwalk through your presentation. Professor Chen rarely asks questions and Emily is silent, eerily still. Most of your words probably made zero sense."},{"type":"paragraph","content":"But soon enough it\'s over. The professor smiles at you. Emily makes no expression, as usual. You wonder how much you\'re revealing by your glances. They leave. You leave. You get home."}]},"research_final.stella_sees":{"id":"research_final.stella_sees","options":[{"id":"@research_final.apply_mit","title":"Your top choice is MIT."},{"id":"@research_final.top_colleges","title":"You\'re applying to the \\"top\\" ones, of course."},{"id":"@research_final.too_early","title":"It\'s too early to say."}],"content":[{"type":"paragraph","content":"\\"That doesn\'t look like your project,\\" she says."},{"type":"paragraph","content":"\\"Sorry...\\""},{"type":"paragraph","content":"\\"No, it\'s fine! I\'m glad you\'re interested in science beyond what we\'re doing in the lab right now.\\""},{"type":"paragraph","content":"She grabs a chair and sits next to you."},{"type":"paragraph","content":"\\"So, you\'re getting ready to apply to college next year, right?\\""},{"type":"paragraph","content":"\\"Um, yeah...\\""},{"type":"paragraph","content":"\\"Do you know which colleges you\'re applying to?\\""}]},"scioly_invitational.protein_good":{"id":"scioly_invitational.protein_good","viewIf":{"$code":"return ((Q[\'protein\'] || 0) >= 2);"},"options":[{"id":"@scioly_invitational.fossils","title":"Next is Fossils."},{"id":"@scioly_invitational.fossils_roxana","title":"Next is Fossils."}],"content":{"content":"You know what you\'re doing here, given all that you\'ve studied. Between Aubrey and you, it seems like all of the questions were covered.","type":"paragraph"}},"shopping_with_mom.buy_green_dress":{"id":"shopping_with_mom.buy_green_dress","onArrival":[{"$code":"Q[\'green_dress\'] = 1;"}],"goTo":[{"id":"shopping_with_mom.shoes"}],"content":{"content":"Okay, you put the green dress in your shopping bag.","type":"paragraph"}},"research_1.maybe":{"id":"research_1.maybe","goTo":[{"id":"research_1.no"}],"content":{"content":"","type":"paragraph"}},"skip.w5_research_status":{"id":"skip.w5_research_status","options":[{"id":"@skip.w5_research_2","title":"You\'ve started on research."},{"id":"@skip.w5_research_3","title":"You haven\'t been involved in research."}],"content":{"content":"Research status:","type":"paragraph"}},"scioly_study_party.conversation":{"id":"scioly_study_party.conversation","options":[{"id":"@scioly_study_party.krishna","title":"Join Krishna\'s group."},{"id":"@scioly_study_party.aubrey","title":"Join Aubrey\'s circle."},{"id":"@scioly_study_party.captain","title":"Join the captain\'s clique."},{"id":"@scioly_study_party.corner","title":"Sit in a corner by yourself."}],"content":[{"type":"paragraph","content":"The real, actual, verified study party is occurring as of this moment in the basement."},{"type":"paragraph","content":"There are groups of people lounging around on couches, while other groups are intent at work going over books or discussing topics potentially related to science."}]},"thanksgiving_party.meet_emily2":{"id":"thanksgiving_party.meet_emily2","viewIf":{"$code":"return (((Q[\'emily\'] || 0) > 1) && ((Q[\'emily\'] || 0) < 4));"},"onArrival":[{"$code":"Q[\'meet_emily\'] = 0;"}],"goTo":[{"id":"thanksgiving_party.play_nicely"}],"content":{"content":"When you see the person who emerges, you almost do a double take. You can almost place it; you\'ve met this person before.","type":"paragraph"}},"scioly_2.protein_20_amino_acids":{"id":"scioly_2.protein_20_amino_acids","options":[{"id":"@scioly_2.protein_bonds","title":"You kind of know this."}],"content":[{"type":"paragraph","content":"\\"20, I guess?\\""},{"type":"paragraph","content":"\\"21 in eukaryotes. 22 total. There are 20 unique codons in eukaryote DNA, but there\'s also selenocystein, which is coded for in a more complex way.\\""},{"type":"paragraph","content":"\\"Oh. Right.\\" You had read that on Wikipedia sometime."},{"type":"paragraph","content":"\\"Next up. Define peptide bond, disulfide bond, hydrogen bond, phosphodiester bond, hydrophobic, hydrophilic.\\""}]},"scioly_final.getting_along":{"id":"scioly_final.getting_along","goTo":[{"id":"scioly_final.what_do_you_think"}],"content":{"content":"The idea that you are good at \\"getting along with people\\" seems to be a near-total lie. Is this another instance of being arbitrarily assigned a feminine-coded trait?","type":"paragraph"}},"1.really":{"id":"1.really","options":[{"id":"@1.point","title":"Unfortunately, they make a good case..."}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Really? Do I have to? I think if I join I\'ll just lose-\\""},""]},{"type":"paragraph","content":"Your father silences you with a sigh."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"You\'re always spending time on the computer,\\""}," he says, looking up from his laptop. ",{"type":"emphasis-1","content":"\\"You should go out more, make new friends. You need to learn how to communicate. You\'re still this young and you haven\'t had any real life experiences.\\""},""]},{"type":"paragraph","content":"You want to argue with him, but it will be futile."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Besides,\\""}," mom continues, ",{"type":"emphasis-1","content":"\\"you want to go to MIT, right? How many Chinese girls who want to go go to MIT have done a beauty pageant? It\'ll make you special.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"It will show"}," leadership,\\" dad agrees. ",{"type":"emphasis-1","content":"\\"You need more"}," leadership. ",{"type":"emphasis-1","content":"If you just have good grades it won\'t be enough to get into a good university. If you want to go to a good university, you need"}," leadership.\\""]}]},"aubrey_final.yes_date":{"id":"aubrey_final.yes_date","goTo":[{"id":"aubrey_final.no_date"}],"content":{"content":"There\'s no reason for you to lie about this. None whatsoever.","type":"paragraph"}},"birthday.family_celebrate_2":{"id":"birthday.family_celebrate_2","content":[{"type":"paragraph","content":"Eventually the four of you leave to have dinner in Chinatown. It\'s a Peking Duck dinner, which must have been incredibly expensive. You try to avoid thinking about the cost."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Congratulations, congratulations!\\""},", dad says."]},{"type":"paragraph","content":"\\"For what?\\", you say."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Passing birthday! Let\'s sing!\\""},""]},{"type":"paragraph","content":"You shrink from the attention as the servers sing. There\'s a cake. You scrape off the frosting (never liked that much). Your brother Chun-chun plays Minecraft on the iPad."},{"type":"paragraph","content":"The food isn\'t bad, but you can\'t stop thinking. About what? You don\'t even know."}]},"christmas_party.stare_emily":{"id":"christmas_party.stare_emily","onArrival":[{"$code":"Q[\'stared_emily\'] = 1;"}],"options":[{"id":"@christmas_party.continue_game","title":"Continue the game."}],"content":[{"type":"paragraph","content":"She does not return your gaze, looking away as soon as you make eye contact."},{"type":"paragraph","content":"Emily is wearing gray sweatpants and a Tufts sweatshirt, all loose fitting."},{"type":"paragraph","content":"You are wearing a dress, a rare occasion. It\'s a simple red and black dress that once belonged to mom, which you\'re wearing under a cardigan. So is Aubrey. Her dress is green. She doesn\'t comment on your outfit (she\'s far too nice for that), but some of the adults do. 她长得真漂亮, you hear more than once. Ugh. It\'s not even worth translating. 不得不得, mom obligatorily says."}]},"church_1.endure":{"id":"church_1.endure","options":[{"id":"@church_1.dinner","title":"The call for dinner comes up soon."}],"content":{"content":"The bible study meeting proceeds as usual: the adults talk loudly in Chinese, while you and the children downstairs watch anime or whatever Spencer decides to show. All the while you sit next to Aubrey, not really saying anything, just... being there, like you always do.","type":"paragraph"}},"church_2.okay":{"id":"church_2.okay","options":[{"id":"@church_2.say_something","title":"Say something."},{"id":"@church_2.say_nothing","title":"Don\'t say anything."}],"content":[{"type":"paragraph","content":"\\"No, I\'ve never heard,\\" you lie. \\"What happened?\\""},{"type":"paragraph","content":"\\"His wife left him for another woman. Like, really? They\'ve been married for twenty years. How do these things just happen?\\""}]},"church_3.talk_aubrey":{"id":"church_3.talk_aubrey","content":{"content":"","type":"paragraph"}},"classes_1.platform":{"id":"classes_1.platform","onArrival":[{"$code":"Q[\'platform\'] = 0;"}],"options":[{"id":"@classes_1.gayplatform","title":"\\"What about... uh, LGBT stuff?\\""},{"id":"@classes_1.stemplatform","title":"\\"What about STEM education?\\""},{"id":"@classes_1.scienceplatform","title":"\\"Science is good. I guess.\\""}],"content":[{"type":"paragraph","content":"The platform is apparently a community service or advocacy project that pageant contestants have to do. It\'s part of showing that pageants have moved on beyond chauvinism, that they care about something besides women\'s appearances. In practice, no matter how wonderful your platform is, appearance still matters the most. But having a good platform won\'t hurt."},{"type":"paragraph","content":"You tell Miri about the platform and ask what you can do."},{"type":"paragraph","content":"\\"Cancer.\\""},{"type":"paragraph","content":"\\"That\'s it? Like, what about cancer?\\""},{"type":"paragraph","content":"\\"You\'re a scientist, right? So can\'t you talk about how you want to support research and stuff?\\""},{"type":"paragraph","content":"\\"But I need a compelling hook... Like, why does this matter to me? My grandfather died of lung cancer but... it doesn\'t feel right. So maybe I should just do something like... supporting basic science research. Maybe science can be the big thing and cancer is just a small part of it. Or something like that.\\""},{"type":"paragraph","content":"\\"Sounds fine to me,\\" Miri says with a shrug."}]},"emily_1.appreciate":{"id":"emily_1.appreciate","goTo":[{"id":"emily_1.emily_weird"}],"content":{"content":"You appreciate the fact that she is approaching the pageant in a logical manner. It is an approach agreeable to yours; you might even be able to learn something from her. Even if she is a bit strange for attending the meeting without doing the pageant.","type":"paragraph"}},"emily_3_online.go":{"id":"emily_3_online.go","options":[{"id":"@emily_3_online.not","title":"\\"I don\'t think of you any lesser as a human being.\\""},{"id":"@emily_3_online.still","title":"\\"You\'re still Emily Chen, right?\\""}],"content":[{"type":"paragraph","content":"You: Um, sorry, but, um..."},{"type":"paragraph","content":"Should you go right now? Should you really? Wouldn\'t that make everything worse? Wouldn\'t that make her think that you think lesser of her because of her confession? And is that really what you want? You close your eyes and think of what to say."},{"type":"paragraph","content":"You: It\'s okay."},{"type":"paragraph","content":"Emily: what?"},{"type":"paragraph","content":"You: the, um, trans thing. I don\'t know how to say it, but, um..."}]},"emily_2.keep_studying":{"id":"emily_2.keep_studying","options":[{"id":"@emily_2.goodbye","title":"Keep on trying to study."}],"content":{"content":"AP Chem cannot wait. Neither can AP World, AP Calc, and all of your other best friends.","type":"paragraph"}},"emily_4.hate":{"id":"emily_4.hate","options":[{"id":"@emily_4.yes_friends","title":"\\"Yeah, I guess.\\""},{"id":"@emily_4.idk","title":"\\"Um, I don\'t know...\\""}],"content":[{"type":"paragraph","content":"You never know how to answer open ended questions like that. There\'s obviously something the other party wants to hear, even though they never say such, and you\'ve never been particularly adept at reading people\'s thoughts."},{"type":"paragraph","content":"But you don\'t have to. Emily looks at you again."},{"type":"paragraph","content":"\\"So, I guess, are we friends now?\\""}]},"emily_6.speak_2":{"id":"emily_6.speak_2","options":[{"id":"@emily_6.what","title":"\\"What?\\""}],"content":[{"type":"paragraph","content":"It ends up being Emily who speaks first."},{"type":"paragraph","content":"\\"Okay. Tell me about your life.\\""}]},"emily_7.fucked_up":{"id":"emily_7.fucked_up","options":[{"id":"@emily_7.oh_really","title":"Really...?"}],"content":[{"type":"paragraph","content":"You fucked this up horribly by \\"asking her out\\" at an extremely inopportune time and thus completely breaking any mood that was about to happen and thus dooming your friendship and potentially other kinds of relationships with Emily forever. Yeah. Also your line was terrible. You certainly are accomplished at the art of completely fucking up every interpersonal moment."},{"type":"paragraph","content":"\\"Hey, are you crying? It\'s fine. So, like, are you, uh, asking me out or something?\\""},{"type":"paragraph","content":"Oh God you\'re crying. \\"Um, I mean, yeah, I guess. Sorry.\\""},{"type":"paragraph","content":"\\"It\'s okay. I\'m not going to say no.\\""}]},"emily_final.i_care":{"id":"emily_final.i_care","options":[{"id":"@emily_final.where_now","title":"\\"Where are you now?\\""}],"content":[{"type":"paragraph","content":"You: I care..."},{"type":"paragraph","content":"You: Well I don\'t know the \\"actual you\\" as well as maybe I should..."},{"type":"paragraph","content":"You: But I\'ll try..."},{"type":"paragraph","content":"Emily: Thanks."}]},"epilogue.ep_family_good":{"id":"epilogue.ep_family_good","maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"viewIf":{"$code":"return ((Q[\'family\'] || 0) >= 5);"},"content":{"content":"Recently, with the pageant and all, you\'ve grown a bit closer with your family, spending more time with them and so on. There are good times and there are bad times. Recently, mom and dad haven\'t been getting along too well. Part of you wonders if they could separate, or divorce.","type":"paragraph"},"countVisitsMax":1},"family_3.nothing":{"id":"family_3.nothing","options":[{"id":"@family_3.end","title":"The rice is getting cold."}],"content":[{"type":"paragraph","content":"Of course you don\'t say anything. This isn\'t an argument you could ever win. Your hands feel cold. Your chopsticks are bent. The vegetables are getting soggy. Your head grows heavier. You close your eyes. It doesn\'t matter."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Are you zoning out?\\""},", mother asks."]},{"type":"paragraph","content":"You shake your head and pick up your chopsticks again. It doesn\'t matter."}]},"family_5.alive":{"id":"family_5.alive","options":[{"id":"@family_5.fine","title":"It\'s going to be fine"}],"content":[{"type":"paragraph","content":"You\'re alive. That\'s all you could ask for right now."},{"type":"paragraph","content":"Finally you manage to breathe. It\'s fine. He didn\'t hurt you. He\'s not that kind of person. He\'ll have forgotten about this entire incident by tomorrow. And if this were a rational argument as to whether or not you liked girls or whatever, you would be able to bring up rational reasons to defend yourself, and it\'s not as if he actually has hard evidence."}]},"family_2.nothing":{"id":"family_2.nothing","onArrival":[{"$code":"Q[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'loneliness\'] = (Q[\'loneliness\'] || 0) + 1;"}],"options":[{"id":"@family_2.continue","title":"And the worst part is, they\'ve succeeded."}],"content":{"content":"You\'re becoming inured to these stories. Always the same, always about hardships that happened worlds away from you. The subtext behind it all is clear: you have to work hard, study in school, find a husband and give them grandchildren, so that all your parents\' suffering wouldn\'t be in vain. You know all that, yet your parents continue to use guilt to manipulate you into aligning your goals and views to theirs.","type":"paragraph"}},"family_6.its_fine":{"id":"family_6.its_fine","options":[{"id":"@family_6.dotdotdot","title":"..."}],"content":{"type":"paragraph","content":["\\"我没事儿。",{"type":"emphasis-1","content":"I\'m fine."},"\\""]}},"family_final.tired":{"id":"family_final.tired","content":[{"type":"paragraph","content":"You\'re tired of the stories. You\'re tired of the implications that you are an ungrateful child, that your parents went though so much hardship only to end up with a spoiled waste of a daughter like yourself. They ate so much bitterness to give the next generation a better life and what did they end up with? A self-centered lesbian loser who can\'t even talk to someone without getting a panic attack?"},{"type":"paragraph","content":"Does this subtext really exist, though? Or is it a product of your imagination and paranoia? Of course you can\'t ask. All you can do is learn their lessons and start to hate yourself, somewhat more than usual."}]},"family_4.hug":{"id":"family_4.hug","content":[{"type":"paragraph","content":"You let mom put her arms around you."},{"type":"paragraph","content":"\\"Love you,\\" she says, and she starts crying again. You hug her back. The lights in the kitchen are out."},{"type":"paragraph","content":"Kevin leaves, sneaking past the two of you. Eventually mom lets go. You close the door. Suddenly you feel tired, more so than usual."}]},"introspect_1.rachel":{"id":"introspect_1.rachel","goTo":[{"id":"introspect_1.name"}],"onArrival":[{"$code":"Q[\'first_name\'] = \\"Rachel\\";"}],"content":{"content":"","type":"paragraph"}},"introspect_2.parents":{"id":"introspect_2.parents","viewIf":{"$code":"return (((Q[\'family\'] || 0) >= 2) && ((Q[\'seen_parents_introspect_2\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'seen_parents_introspect_2\'] = 1;"}],"goTo":[{"id":"introspect_2.people"}],"content":{"content":"Despite everything, your parents love you. Probably. And you love them, too. Probably.","type":"paragraph"}},"introspect_3.parents":{"id":"introspect_3.parents","maxVisits":1,"options":[{"id":"@introspect_3.emily","title":"Think about Emily."},{"id":"@introspect_3.miri","title":"Think about Miri."},{"id":"@introspect_3.aubrey","title":"Think about Aubrey."},{"id":"@introspect_3.parents","title":"Think about mom and dad."},{"id":"@introspect_3.kevin","title":"Think about Kevin."},{"id":"@introspect_3.stop","title":"Enough thinking for now."}],"content":{"content":[{"type":"paragraph","content":["You love your parents, of course, but... ",{"type":"conditional","content":"they kind of argue a lot, especially recently... ","predicate":0},""]},{"type":"paragraph","content":{"type":"conditional","content":"They\'ve been telling stories of the past, seemingly more so recently. You\'re not sure how to feel about that.","predicate":1}}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'argument_viewed\'] || 0)===1);"}},{"type":"predicate","fn":{"$code":"return (((Q[\'stories_2_viewed\'] || 0)) !== 0);"}}]},"countVisitsMax":1},"loneliness_2.up":{"id":"loneliness_2.up","onArrival":[{"$code":"Q[\'loneliness\'] = (Q[\'loneliness\'] || 0) - 2;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"options":[{"id":"@loneliness_2.end","title":"Everything will be fine."}],"content":[{"type":"paragraph","content":"You wake up and remember to check your phone."},{"type":"paragraph","content":"Of course Miri replied."},{"type":"paragraph","content":"Miri: are you alright?"},{"type":"paragraph","content":"You read the message over and over, trying to come up with something to say, but your mind blanks. Your heart beats faster as you close your eyes, come up with something how hard could it be? How hard can it be to just talk to people why can\'t you be normal why did you even send that message in the first place isn\'t she your best friend this isn\'t the first time this has happened why..."},{"type":"paragraph","content":"It\'s time to go to school. Oh well. Everything will be fine."}]},"miri_date.a3":{"id":"miri_date.a3","options":[{"id":"@miri_date.future_1","title":"The future?"}],"content":[{"type":"paragraph","content":"\\"Can we have a long and meaningful discussion about, um,\\" you start, not knowing what exactly you would like to have a long and meaningful conversation about."},{"type":"paragraph","content":"\\"Sure, I\'m always up for long and meaningful discussions. Let\'s talk about...\\" She makes a spinning motion with her hand. \\"The future.\\""}]},"miri_pageant_prep.waste_of_time":{"id":"miri_pageant_prep.waste_of_time","content":{"content":"Maybe, maybe not...","type":"paragraph"}},"pageant_prep_self_2.docs_done":{"id":"pageant_prep_self_2.docs_done","viewIf":{"$code":"return (((Q[\'resume_completed\'] || 0)===1) && ((Q[\'platform_completed\'] || 0)===1));"},"content":{"content":"You\'re done with the first drafts of the documents now, and it\'s only 1AM. You\'re tired, but what else is new. Five hours is enough sleep, right?","type":"paragraph"}},"pageant_final.straight_hair":{"id":"pageant_final.straight_hair","options":[{"id":"@pageant_final.makeup","title":"Next is makeup."}],"content":[{"type":"paragraph","content":"Okay. This is closer to your natural hairstyle. All you really need is a ton of conditioner, and a ton of brushing to undo the knots that have formed. Every time you brush, a handful of hairs come loose; that\'s part of why you\'re not such a fan of brushing your hair."},{"type":"paragraph","content":"In the end, it\'s not entirely straight, still kind of wavy in a fluffy way at the ends, but that\'s fine."}]},"pageant_prep_try_ball_gown.but_not":{"id":"pageant_prep_try_ball_gown.but_not","content":[{"type":"paragraph","content":"You start to feel terrible about yourself, somewhat more than usual. Mom was right about everything. She\'s going to blame you for not listening to her if you lose."},{"type":"paragraph","content":"Your parents have the talent of making you feel terrible about yourself whenever they want. And you have the talent of letting them."}]},"pageant_meetup.really":{"id":"pageant_meetup.really","onArrival":[{"$code":"Q[\'sit_emily\'] = 1;"}],"options":[{"id":"@pageant_meetup.start_meeting","title":"The meeting begins."}],"content":{"content":[{"type":"paragraph","content":"Maybe it\'s better to have at least one ally in this place, so you move next to her."},{"type":"paragraph","content":"\\"Hi! I\'m Emily,\\" she says. \\"Emily Chen.\\""},{"type":"paragraph","content":["\\"Oh, uh, I\'m ",{"type":"insert","insert":0},". Zhao.\\""]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"research_3.train":{"id":"research_3.train","content":{"content":"You get off the train, your chain of thought interrupted. Doing research will help in your college applications, maybe more so than the pageant. And it\'s fun, and makes your mom happy. Not many kids your age get the opportunity to do scientific research.","type":"paragraph"}},"research_3":{"id":"research_3","type":"scene","title":"Research","subtitle":"Progress?","newPage":true,"viewIf":{"$code":"return (((((((Q[\'week\'] || 0) >= 1) && ((Q[\'week\'] || 0) < 10)) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'research\'] || 0)===2)) && ((Q[\'weekly_research\'] || 0)===0)) && ((Q[\'stress\'] || 0) < 15));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'research\'] = (Q[\'research\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'weekly_research\'] = 1;"}],"tags":["top","research"],"options":[{"id":"@research_3.code","title":"Code."}],"content":[{"type":"paragraph","content":"You start your project in earnest when you\'re at the lab, with the lab\'s computer open and Stella Zhang watching over your shoulder. It\'s awkward being around her, but for some reason she puts you at ease."},{"type":"paragraph","content":"You\'ve done a little bit of programming before, but nothing like this. Still, you manage. Sort of. \\"No, don\'t do this,\\" she says. Or, \\"Why don\'t you google that instead of asking me?\\""}]},"research_4.present_2":{"id":"research_4.present_2","options":[{"id":"@research_4.present_3","title":"You\'re on a roll. Keep going."}],"content":{"content":"\\"I\'ll be presenting on... the work that I\'ve done so far.\\" Click.","type":"paragraph"}},"research_6.text_sorry":{"id":"research_6.text_sorry","content":[{"type":"paragraph","content":"Okay. What do you say, exactly? That you\'re sorry for what your did or didn\'t do?"},{"type":"paragraph","content":"Anyway, you spend approximately one hour composing a text before sending it. Emily replies soon after despite it being after midnight, \\"it\'s fine. dad\'s just like that.\\""},{"type":"paragraph","content":"You breathe a sigh of relief."},{"type":"paragraph","content":"It\'s fine. It\'ll be fine."}]},"research_final.apply_mit":{"id":"research_final.apply_mit","options":[{"id":"@research_final.thats_a_lie","title":"Objectively speaking, that\'s not true."},{"id":"@research_final.you_wish","title":"You wish, though..."}],"content":[{"type":"paragraph","content":"Can you just say that you want to go to MIT? Would that make you seem like too arrogant?"},{"type":"paragraph","content":"\\"Um, probably like... well my top choice is MIT but I don\'t think I\'ll get in. Haha.\\""},{"type":"paragraph","content":"\\"Well, I wouldn\'t be so sure! You\'d make a great scientist!\\" Stella beams."}]},"scioly_invitational.protein_okay":{"id":"scioly_invitational.protein_okay","viewIf":{"$code":"return ((Q[\'protein\'] || 0) >= 1);"},"options":[{"id":"@scioly_invitational.fossils","title":"Next is Fossils."},{"id":"@scioly_invitational.fossils_roxana","title":"Next is Fossils."}],"content":{"content":"You\'ve studied a little for this event, but it\'s hardly enough. Fortunately, you have plenty of background knowledge of biology, so you manage to get through somewhat adequately.","type":"paragraph"}},"shopping_with_mom.buy_purple_dress":{"id":"shopping_with_mom.buy_purple_dress","onArrival":[{"$code":"Q[\'purple_dress\'] = 1;"}],"goTo":[{"id":"shopping_with_mom.shoes"}],"content":{"content":"Okay, you put the purple dress in your shopping bag.","type":"paragraph"}},"research_1.no":{"id":"research_1.no","options":[{"id":"@research_1.leave","title":"Follow him."}],"content":[{"type":"paragraph","content":"\\"Okay, good,\\" he says, nodding and not even looking at you."},{"type":"paragraph","content":"He continues, and you start to get a better sense of what the work will entail. He\'s looking for people who can do stuff on the computer, basically, because biologists can\'t do computer stuff. Your mom must have told him that you were good with computers."},{"type":"paragraph","content":"\\"You can talk to my graduate student Stella. She\'ll work with you and tell you what to do. Follow me.\\""}]},"skip.w5_research_2":{"id":"skip.w5_research_2","onArrival":[{"$code":"Q[\'research\'] = 2;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"goTo":[{"id":"skip.w5_emily_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.corner":{"id":"scioly_study_party.corner","options":[{"id":"@scioly_study_party.krishna","title":"Join Krishna\'s group."},{"id":"@scioly_study_party.aubrey","title":"Join Aubrey\'s circle."},{"id":"@scioly_study_party.captain","title":"Join the captain\'s clique."},{"id":"@scioly_study_party.corner_2","title":"Continue to sit in a corner by yourself."}],"content":[{"type":"paragraph","content":"Ah yes, why not engage in your typical strategy for coping with social situations, the strategy of \\"sit in a corner and hope everyone else ignores you but also sort of hope someone would bother you by initiating conversation\\"."},{"type":"paragraph","content":"What are you even doing here? What did you think you would get done here?"}]},"thanksgiving_party.meet_emily3":{"id":"thanksgiving_party.meet_emily3","viewIf":{"$code":"return ((Q[\'emily\'] || 0) >= 4);"},"onArrival":[{"$code":"Q[\'meet_emily\'] = 1;"}],"goTo":[{"id":"thanksgiving_party.play_nicely"}],"content":{"content":"When you see the person who emerges, you almost do a double take. It\'s Emily Chen. Undeniably. Her face shifts in recognition. Neither of you make a sound.","type":"paragraph"}},"scioly_2.protein_bonds":{"id":"scioly_2.protein_bonds","content":[{"type":"paragraph","content":"\\"Peptide bonds are the bonds that hold together polypeptide chains, or proteins. Disulfide bonds are, uh, bonds between two sulfur atoms? Hydrogen bonds are weak bonds between a hydrogen atom and a more negatively charged atom, like an oxygen in H2O. A phosphodiester bond is what connects chains of nucleic acids together, like DNA. Hydrophobic and hydrophilic mean, um, afraid of water and attracted to water; they\'re properties of different molecules.\\""},{"type":"paragraph","content":"\\"This is alright, but you should do more studying.\\" Aubrey smiles before closing the computer. \\"We\'re gonna do great,\\" she says, before waving you goodbye and doing one of her other club activities, most likely student council or something like that. So there\'s nothing left for you to do here, besides studying by reading Wikipedia in the computer lab. You read about proteins for a while, only occasionally getting distracted by tangents into 14th century European feudal wars."}]},"scioly_final.what_do_you_think":{"id":"scioly_final.what_do_you_think","options":[{"id":"@scioly_final.sure_why_not","title":"Sure, why not?"},{"id":"@scioly_final.take_time","title":"Maybe? Or maybe not?"},{"id":"@scioly_final.of_course_not","title":"Of course not."}],"content":[{"type":"paragraph","content":"\\"So what do you think? Do you think you can do it?\\""},{"type":"paragraph","content":"He smiles at you, waiting for an answer."}]},"1.point":{"id":"1.point","options":[{"id":"@1.beauty","title":"You\'re not beautiful, so how..."},{"id":"@1.school","title":"Maybe this really will be good for college apps..."}],"content":[{"type":"paragraph","content":"Yes. Leadership (whatever that means). College apps. Important for both your future and your parents. Comprising approximately 90% of your existence."},{"type":"paragraph","content":"You sit down at the dining table and look at the pageant website, sparse and pink and filled with cursive fonts."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"There are no Chinese girls,\\""}," you notice."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"You can be the first.\\""},""]},{"type":"paragraph","content":"Mom passes you the registration forms, all filled out, just a blank for you to sign. Your parents\' eyes are watching. There\'s no backing out now."}]},"aubrey_final.no_date":{"id":"aubrey_final.no_date","options":[{"id":"@aubrey_final.why_ruin_date","title":"\\"Why?\\""}],"content":[{"type":"paragraph","content":"\\"Um, no...\\""},{"type":"paragraph","content":"\\"Haha. Yeah, that\'s what I thought.\\" She didn\'t say this in a mocking way, probably, more in a total matter-of-fact manner, as if you were exactly the kind of person that she thought you would be. And to be fair, you are, probably."},{"type":"paragraph","content":"After a pause, she continued. \\"I\'m sorry I\'m ruining your first date, then. Haha.\\""}]},"birthday.prepare":{"id":"birthday.prepare","options":[{"id":"@birthday.invite_miri","title":"Invite Miri."},{"id":"@birthday.invite_aubrey","title":"Invite Aubrey."},{"id":"@birthday.done","title":"Done inviting people."}],"content":{"content":"So what\'s next?","type":"paragraph"}},"christmas_party.ignore_emily":{"id":"christmas_party.ignore_emily","viewIf":{"$code":"return (((Q[\'emily\'] || 0) <= 7) && ((Q[\'emily_date\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'stared_emily\'] = 0;"}],"options":[{"id":"@christmas_party.continue_game","title":"Continue the game."}],"content":[{"type":"paragraph","content":"You ignore Emily to the best of your ability, instead making sure to concentrate on assembling words on the board using your copious classical literature-inflected vocabulary. It\'s all fine for a while, even if you do feel kind of bad about it."},{"type":"paragraph","content":"She gradually decreases the frequency of her awkward glances, it seems. That\'s slightly less awkward."}]},"church_1.dinner":{"id":"church_1.dinner","options":[{"id":"@church_1.family","title":"Eat with your family."},{"id":"@church_1.downstairs","title":"Eat downstairs with Aubrey and Spencer."}],"content":[{"type":"paragraph","content":["The dinner is a potluck with contributions from all the families. Wang ",{"type":"emphasis-1","content":"laoshi"}," says a brief prayer. The children get their food first, then the young people, which means the three of you. An array of plates and bowls lie on the table: steamed rice, ",{"type":"emphasis-1","content":"bing"},", various forms of stir-fries and fatty meats, and your mom\'s famous lamb noodle soup. You take a paper plate and plastic fork and pile on the food."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Do you want to eat with us?\\""},", mom says. ",{"type":"emphasis-1","content":"\\"Didi eat with us too.\\""}]}]},"church_2.say_something":{"id":"church_2.say_something","options":[{"id":"@church_2.continue_eating","title":"As quickly as it began, your conversation with Aubrey died."}],"content":[{"type":"paragraph","content":"\\"Um...\\" You want to say something. But what? What are you supposed to say? What is the intersection of the things you want to say and the set of things that would not alienate Aubrey? You imagine what Wang Laoshi\'s wife feels right now. What\'s her new wife like? What was her old relationship with her husband? Did she love him all these years, or just stay out of obligation? Does she identify as lesbian, bisexual, something else? And how could you even begin to know? Could you contact her? Do you know how?"},{"type":"paragraph","content":"\\"Oh, um, that\'s interesting,\\" you say instead."},{"type":"paragraph","content":"\\"Yeah. It\'s weird,\\" Aubrey says. \\"And I feel really bad for Wang Laoshi. I can\'t imagine how he feels right now.\\""}]},"church_3.no_homework":{"id":"church_3.no_homework","content":{"content":"","type":"paragraph"}},"classes_1.gayplatform":{"id":"classes_1.gayplatform","options":[{"id":"@classes_1.step3","title":"Step 3: ???"}],"content":[{"type":"paragraph","content":"\\"What about... uh, LGBT stuff?\\""},{"type":"paragraph","content":"\\"Aren\'t you closeted to most people? Especially your parents?\\""},{"type":"paragraph","content":"\\"Right. So, science it is?\\""},{"type":"paragraph","content":"\\"Yeah. Wouldn\'t that be for the best?\\""}]},"emily_1.emily_weird":{"id":"emily_1.emily_weird","options":[{"id":"@emily_1.a_little_weird","title":"\\"It\'s a little weird, but...\\""},{"id":"@emily_1.not_weird","title":"\\"It\'s okay...\\""},{"id":"@emily_1.too_weird","title":"Maybe it\'s time to leave?"}],"content":{"content":"\\"Sorry if that was weird,\\" she says, and takes another sip. \\"I just... don\'t have much of an opportunity to get into this sort of thing. If you think I\'m weird or creepy feel free to leave now. Or if you don\'t. Feel free to leave for any reason whatsoever.\\"","type":"paragraph"}},"emily_3_online.what_to_do":{"id":"emily_3_online.what_to_do","options":[{"id":"@emily_3_online.look_forward","title":"You look forward to seeing Emily again."},{"id":"@emily_3_online.maybe_not","title":"You\'re not sure if you still want to have these meetings."}],"content":[{"type":"paragraph","content":"There is a long pause where Emily is typing. You imagine what she\'s doing now. Is she feeling as nervous and awkward as you are? Probably much more so. Or maybe she\'s in the bathroom, or maybe it isn\'t such a big deal at all for her."},{"type":"paragraph","content":"Emily: Okay, let\'s call it a day for now."},{"type":"paragraph","content":"Emily: Sorry but I have to go do now."},{"type":"paragraph","content":"You: Okay..."},{"type":"paragraph","content":"Emily: Oh yeah, thanks for listening to me."},{"type":"paragraph","content":"Emily: I really appreciate it. I really do."},{"type":"paragraph","content":"Emily: Bye."},{"type":"paragraph","content":"Her status changes to offline. You let out a sigh."}]},"emily_2.stare_em":{"id":"emily_2.stare_em","options":[{"id":"@emily_2.goodbye","title":"Yeah..."}],"content":[{"type":"paragraph","content":"This is the third time you have met Emily, and you have already moved on to the \'awkward staring\' phase of your relationship. She is, again, attired nearly entirely in black: a black blazer over a black sweater and purple skirt and black jeans. Again, her face is caked in thick layers of makeup (probably; you\'re still not too good with makeup)."},{"type":"paragraph","content":"\\"Why are you staring at me?,\\" she eventually says, after an undeterminate amount of staring. You immediately look away."},{"type":"paragraph","content":"\\"Um, sorry...\\""},{"type":"paragraph","content":"\\"Do I look weird?\\""},{"type":"paragraph","content":"\\"Um, no... the opposite, actually...\\""},{"type":"paragraph","content":"\\"What does that mean?\\""},{"type":"paragraph","content":"\\"Sorry...\\""},{"type":"paragraph","content":"Emily goes back to her homework, and you try the same. But you can\'t help but feel as if you\'ve caused a permanent black mark on your relationship, as if your relationship stats have irreparably lowered. That\'s not how this sort of thing works, though, or is it?"}]},"emily_4.yes_friends":{"id":"emily_4.yes_friends","onArrival":[{"$code":"Q[\'emily\'] = 6;"}],"options":[{"id":"@emily_4.walk","title":"Okay..."}],"content":[{"type":"paragraph","content":"\\"Yeah.\\" You try to smile, or something like that. \\"We\'re friends. Right?\\""},{"type":"paragraph","content":"\\"Yeah,\\" Emily says. There\'s yet another awkward pause, as Emily shrinks into herself, glancing at everything in the room besides you. Meanwhile you finish your strawberry drink."},{"type":"paragraph","content":"\\"Let\'s take a walk,\\" Emily says, breaking the silence."}]},"emily_6.what":{"id":"emily_6.what","options":[{"id":"@emily_6.im_gay","title":"\\"I\'m gay?\\""}],"content":[{"type":"paragraph","content":"\\"What? I mean, why?\\""},{"type":"paragraph","content":"\\"We\'re friends now, right? And let\'s be honest, you know more about me than basically anyone else IRL. So let\'s make it even. Tell me something no one else knows.\\""}]},"emily_7.oh_really":{"id":"emily_7.oh_really","options":[{"id":"@emily_7.yes_date","title":"Yeah..."}],"content":[{"type":"paragraph","content":"\\"Oh. Really?\\" Don\'t get your hopes up, don\'t get your hopes up..."},{"type":"paragraph","content":"\\"It\'ll be a long process. Can we hold off until... at the very least after graduating from high school?\\" Her voice is barely above a whisper. \\"I mean, ... It\'s that I want to be independent first, like, from my parents. And I want to be able to be more, like, actually out. And able to do more physical transitioning than now. Is that coherent?\\""}]},"emily_final.where_now":{"id":"emily_final.where_now","options":[{"id":"@emily_final.go_to_emily","title":"Can I head over?"},{"id":"@emily_final.stay_here","title":"Can you make it back home?"}],"content":[{"type":"paragraph","content":"You: Where are you right now?"},{"type":"paragraph","content":"Emily: South Station."}]},"epilogue.ep_family_bad":{"id":"epilogue.ep_family_bad","maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"viewIf":{"$code":"return ((Q[\'family\'] || 0) < 5);"},"content":{"content":"Recently, you haven\'t had so much time to spend with your family. Mom sometimes wishes you would spend time with them rather than sequester yourself in your tiny room. Isn\'t it better with more people, she would say. But you mostly ignore her. Dad ignores you, for the most part.","type":"paragraph"},"countVisitsMax":1},"family_3.end":{"id":"family_3.end","content":{"content":"","type":"paragraph"}},"family_3":{"id":"family_3","type":"scene","title":"Family Dinner","subtitle":"A normal conversation","newPage":true,"viewIf":{"$code":"return ((((((((Q[\'week\'] || 0) > 1) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'family\'] || 0) > 1)) && ((Q[\'family\'] || 0) < 5)) && ((Q[\'weekly_family\'] || 0)===0)) && ((Q[\'bravery_viewed\'] || 0)===0)) && ((Q[\'week\'] || 0) < 10));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'family\'] = (Q[\'family\'] || 0) + 1;\\nQ[\'weekly_family\'] = 1;\\nQ[\'bravery_viewed\'] = 1;\\nQ[\'loneliness\'] = (Q[\'loneliness\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"maxVisits":1,"tags":["top","family"],"options":[{"id":"@family_3.note","title":"In Chinese, \\"fat\\" doesn\'t really have the negative connotation it does in English and in fact sometimes has a positive connotation especially among older people, due to experiences with hunger and so on..."}],"content":[{"type":"paragraph","content":["You\'re at dinner with your parents and your brother Kevin as usual. You push around the white rice on the plate; you\'re not feeling particularly hungry tonight. ",{"type":"emphasis-1","content":"\\"Why aren\'t you eating?\\""},", mom asks. ",{"type":"emphasis-1","content":"\\"Is the food I made not good?\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"No... I\'m fine.\\""}," You pick at some pieces of celery with your chopsticks. Honestly, the food isn\'t bad, but you\'re not in the appetite to eat a lot tonight."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Are you trying to lose weight?\\""}," Your mom sounds worried, like she always does. ",{"type":"emphasis-1","content":"\\"You don\'t have to loose weight. You\'re already skinny enough. You really need to get fatter, that\'s what would be good.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Girls don\'t need to grow fat,\\""}," dad says."]}],"countVisitsMax":1},"family_5.fine":{"id":"family_5.fine","content":{"content":"It\'s going to be fine, you repeat to yourself. It\'s going to be fine.","type":"paragraph"}},"family_2.continue":{"id":"family_2.continue","content":{"content":"","type":"paragraph"}},"family_2":{"id":"family_2","type":"scene","title":"Family Dinner","subtitle":"Stories of China","newPage":true,"viewIf":{"$code":"return (((((((Q[\'week\'] || 0) > 1) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'family\'] || 0) >= 1)) && ((Q[\'weekly_family\'] || 0)===0)) && ((Q[\'stories_viewed\'] || 0) < 2)) && ((Q[\'week\'] || 0) < 10));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'family\'] = (Q[\'family\'] || 0) + 1;\\nQ[\'weekly_family\'] = 1;\\nQ[\'stories_viewed\'] = (Q[\'stories_viewed\'] || 0) + 1;"}],"tags":["top","family"],"options":[{"id":"@family_2.dad_1","title":"Dad tells stories about growing up."},{"id":"@family_2.mom_1","title":"Mom tells a story about school."}],"content":{"content":"At dinner, in between bites of steamed rice and stir-fried vegetables and meat, your parents like to tell stories of the past. They say that they want you, and your brother especially since he was born in America, to understand your culture and heritage or something like that. The stories are repeated over and over, sometimes with new variations.","type":"paragraph"}},"family_6.dotdotdot":{"id":"family_6.dotdotdot","options":[{"id":"@family_6.oh_2","title":"Oh."}],"content":[{"type":"paragraph","content":"You\'re washing your hands. Mom is next to you, looking at you in the mirror. Mom\'s eyes are red, her face streaked with tears."},{"type":"paragraph","content":["\\"秋怡阿, 我好久没有看你了。你长得真漂亮了。 ",{"type":"emphasis-1","content":"Qiuyi, I haven\'t seen you in a long time. You look beautiful."},"\\""]}]},"family_final.no_matter":{"id":"family_final.no_matter","content":[{"type":"paragraph","content":"There are a lot of things that happen to you without you being particularly conscious of. It feels as if your parents\' words pass through your ears without making a stop in your brain. It is like so many other things that you experience, as if you are not here, like everything is just a movie that you are viewing through someone else\'s perspective."},{"type":"paragraph","content":"\\"Oh, okay,\\" you would say after a long story. And it would go on."}]},"family_final":{"id":"family_final","type":"scene","title":"Family","subtitle":"More stories of China","newPage":true,"viewIf":{"$code":"return ((((((Q[\'week\'] || 0)===11) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'family\'] || 0) >= 5)) && ((Q[\'weekly_family\'] || 0)===0)) && ((Q[\'argument_viewed\'] || 0)===1));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'family\'] = (Q[\'family\'] || 0) + 1;\\nQ[\'weekly_family\'] = 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'loneliness\'] = (Q[\'loneliness\'] || 0) + 1;\\nQ[\'stories_2_viewed\'] = (Q[\'stories_2_viewed\'] || 0) + 1;"}],"tags":["top","family"],"maxVisits":2,"options":[{"id":"@family_final.dad_1","title":"Dad talks about his parents."},{"id":"@family_final.mom_1","title":"Mom talks about growing up in the village."}],"content":{"content":"At dinner, in between bites of stir-fried tofu and steamed rice, your parents tell you stories of the past. They enjoy reminiscing about their old lives, all the places and things that your brother and you have not and will not experience. They like to remind you of all that they went through so that they are able to provide you with a good life in America.","type":"paragraph"},"countVisitsMax":2},"family_4.retreat":{"id":"family_4.retreat","content":[{"type":"paragraph","content":"Almost without thinking, you back away into your room. Mom frowns. But she\'s used to it. She knows the way you act. Hopefully."},{"type":"paragraph","content":["\\"Sorry,\\" you say, looking away. ",{"type":"emphasis-1","content":"\\"I\'ll wash the dishes later.\\""},""]},{"type":"paragraph","content":"Mom leaves. You don\'t look at her face. Kevin sneaks away after her. You close the door. Suddenly you feel tired, more so than usual."}]},"family_4":{"id":"family_4","type":"scene","title":"Family Dinner","subtitle":"A parental incident","newPage":true,"viewIf":{"$code":"return (((((((Q[\'week\'] || 0) > 1) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'family\'] || 0) > 2)) && ((Q[\'weekly_family\'] || 0)===0)) && ((Q[\'argument_viewed\'] || 0)===0)) && ((Q[\'week\'] || 0) < 10));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'family\'] = (Q[\'family\'] || 0) + 1;\\nQ[\'weekly_family\'] = 1;\\nQ[\'argument_viewed\'] = 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'trauma_points\'] = (Q[\'trauma_points\'] || 0) + 1;"}],"maxVisits":1,"tags":["top","family"],"options":[{"id":"@family_4.watch","title":"Watch."},{"id":"@family_4.leave","title":"Leave."}],"content":[{"type":"paragraph","content":"It\'s leftovers for dinner tonight: 西红柿炒鸡蛋 (tomato stir-fried with eggs) and a rice 粥 from last night. The family is seated around the table. Mom and dad are both reading on their cell phones. The microwave chimes."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"You go get it,\\""}," mom says to dad."]},{"type":"paragraph","content":"Dad sets down his phone with a thud, and sighs loudly. He kicks his chair. It clatters to the floor."},{"type":"paragraph","content":["\\"你干什么？",{"type":"emphasis-1","content":"What are you doing?"},"\\" Mom gets up, pushing her chair to the side."]}],"countVisitsMax":1},"introspect_1.sarah":{"id":"introspect_1.sarah","goTo":[{"id":"introspect_1.name"}],"onArrival":[{"$code":"Q[\'first_name\'] = \\"Sarah\\";"}],"content":{"content":"","type":"paragraph"}},"introspect_2.brother":{"id":"introspect_2.brother","viewIf":{"$code":"return (((Q[\'family\'] || 0) >= 2) && ((Q[\'seen_brother_introspect_2\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'seen_brother_introspect_2\'] = 1;"}],"goTo":[{"id":"introspect_2.people"}],"content":{"content":"He\'s the only person you can trust in this household. No, not really, since he won\'t keep secrets from your parents.","type":"paragraph"}},"introspect_3.kevin":{"id":"introspect_3.kevin","maxVisits":1,"options":[{"id":"@introspect_3.emily","title":"Think about Emily."},{"id":"@introspect_3.miri","title":"Think about Miri."},{"id":"@introspect_3.aubrey","title":"Think about Aubrey."},{"id":"@introspect_3.parents","title":"Think about mom and dad."},{"id":"@introspect_3.kevin","title":"Think about Kevin."},{"id":"@introspect_3.stop","title":"Enough thinking for now."}],"content":{"content":"Kevin is your brother, who is supposed to sleep in your room but usually sleep in your parents\' room. That\'s good for you. But it makes you feel selfish for wanting a space to yourself when no one else in the family has their own room.","type":"paragraph"},"countVisitsMax":1},"loneliness_2.end":{"id":"loneliness_2.end","content":{"content":"","type":"paragraph"}},"loneliness_2":{"id":"loneliness_2","type":"scene","title":"Loneliness","subtitle":"Another normal evening","newPage":true,"viewIf":{"$code":"return (((((Q[\'loneliness\'] || 0) > 2) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'loneliness_1_week_seen\'] || 0) >= 1)) && ((Q[\'week\'] || 0) < 100));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'trauma_points\'] = (Q[\'trauma_points\'] || 0) + 1;\\nQ[\'loneliness_2_week_seen\'] = (Q[\'loneliness_2_week_seen\'] || 0) + 1;"}],"priority":3,"maxVisits":2,"tags":["loneliness"],"options":[{"id":"@loneliness_2.contact_miri","title":"Talk to Miri"},{"id":"@loneliness_2.contact_emily","title":"Talk to Emily"},{"id":"@loneliness_2.sleep","title":"Try to sleep"}],"content":[{"type":"paragraph","content":"Your parents are asleep, and tonight Kevin sleeps in the room with your parents. And you\'re at your desk. You flip through your regular internet haunts. Nothing interesting. Do you have anything to do? Any homework? Of course you do. And EC stuff. And even pageant stuff probably. But you don\'t feel like any of that. You wish you could talk to another human being. But it\'s like 12AM and, well..."},{"type":"paragraph","content":"God, you feel so lonely and don\'t even know why."}],"countVisitsMax":2},"miri_date.future_1":{"id":"miri_date.future_1","options":[{"id":"@miri_date.future_what","title":"\\"What do you mean, better or worse?\\""},{"id":"@miri_date.future_why","title":"\\"Why are you asking?\\""}],"content":[{"type":"paragraph","content":"\\"What do you mean by \'future\'?\\", you say. \\"Do you mean like, tomorrow future, or in a year future, or fifty years future? Or like, a million years?\\""},{"type":"paragraph","content":"\\"Hmm, let\'s say, five years,\\" she says. \\"Do you think the world will be a better or worse place than it is today?\\""}]},"miri_pageant_prep.but_it_was_fun":{"id":"miri_pageant_prep.but_it_was_fun","content":{"content":"Yeah...","type":"paragraph"}},"pageant_prep_self_2.clothes":{"id":"pageant_prep_self_2.clothes","subtitle":"Look for tips on fashion and makeup.","options":[{"id":"@pageant_prep_self_2.makeup","title":"Look up makeup tips."},{"id":"@pageant_prep_self_2.fashion","title":"Look up tips on clothes."},{"id":"@pageant_prep_self_2.body_language","title":"Look up tips on body language."},{"id":"@pageant_prep_pick_ball_gown","title":"Find a ball gown."},{"id":"@pageant_prep_try_ball_gown","title":"Try on the ball gown."}],"content":{"content":"You browse through pictures of past pageant contestants. What do they have that you don\'t? Light skin, for one. Makeup. Styled hair that\'s not black. And dresses. And you\'re supposed to learn from them somehow.","type":"paragraph"}},"pageant_final.curly_hair":{"id":"pageant_final.curly_hair","options":[{"id":"@pageant_final.makeup","title":"Next is makeup."}],"content":[{"type":"paragraph","content":"This is somewhat difficult. Mom has a curling thingy saved for this type of extremely rare occasion, even though dad was utterly against her buying it, which led to an argument inside Target a year back. Now mom has her comeuppance, or something like that."},{"type":"paragraph","content":"In the end, your hair looks kind of weird, but mom said it looked good."}]},"pageant_prep_try_ball_gown.screw_pageant":{"id":"pageant_prep_try_ball_gown.screw_pageant","content":[{"type":"paragraph","content":"There are more important things to your current existence than the pageant. You\'re not going to feel bad about yourself, no matter how you end up ranking."},{"type":"paragraph","content":"Oh, who are you kidding, you\'re going to feel bad about yourself no matter what happens. You\'ll just have to deal with it."}]},"pageant_prep_try_ball_gown":{"id":"pageant_prep_try_ball_gown","type":"scene","title":"Try on the ball gown.","viewIf":{"$code":"return ((Q[\'ball_gown\'] || 0) > 0);"},"onArrival":[{"$code":"Q[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 2;\\nQ[\'try_on_ball_gown\'] = 1;"}],"maxVisits":1,"options":[{"id":"@pageant_prep_try_ball_gown.try_it_on","title":"Try it on."}],"content":{"content":[{"type":"paragraph","content":"The ball gown that you discussed with mom earlier has been delivered. She enters your room and lays it out on the bed."},{"type":"paragraph","content":[{"type":"conditional","content":"It is a black gown with a white bowtie belt. ","predicate":0}," ",{"type":"conditional","content":"It is a simple deep green strapless pleated dress. ","predicate":1}," ",{"type":"conditional","content":"It is a light blue V-neck dress. ","predicate":2}," ",{"type":"conditional","content":"It is a shiny blood-red strapless dress. ","predicate":3},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Try it on,\\""}," she tells you. ",{"type":"emphasis-1","content":"\\"I\'ll help you.\\""}]}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'ball_gown\'] || 0)===1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'ball_gown\'] || 0)===2);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'ball_gown\'] || 0)===3);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'ball_gown\'] || 0)===4);"}}]},"countVisitsMax":1},"pageant_meetup.yeah_really":{"id":"pageant_meetup.yeah_really","onArrival":[{"$code":"Q[\'sit_emily\'] = 0;"}],"options":[{"id":"@pageant_meetup.start_meeting","title":"The meeting begins."}],"content":{"content":"You sit by yourself, looking downward as you try to avoid accidental eye contact.","type":"paragraph"}},"research_4.present_3":{"id":"research_4.present_3","options":[{"id":"@research_4.present_4","title":"Keep going."}],"content":{"content":"\\"I\'ve only been here for a few weeks, and I\'ve been working on... understanding the developmental processes of stem cells using...\\"","type":"paragraph"}},"research_6.dont_text":{"id":"research_6.dont_text","content":[{"type":"paragraph","content":"She doesn\'t text you either. It was probably not a big deal, you tell yourself. It isn\'t that great of a moral failing compared to everything else you\'ve been complicit in, just from living in a society. Right?"},{"type":"paragraph","content":"It\'s fine. It\'ll be fine."}]},"research_final.top_colleges":{"id":"research_final.top_colleges","options":[{"id":"@research_final.thats_a_lie","title":"Objectively speaking, that\'s not true."},{"id":"@research_final.you_wish","title":"You wish, though..."}],"content":[{"type":"paragraph","content":"Can you just say that you\'re applying to HYPMS etc.? Would that make you seem like an arrogant and fundamentally unpleasant person?"},{"type":"paragraph","content":"\\"Um, probably like... well my top choice is MIT but I don\'t think I\'ll get in. Haha.\\""},{"type":"paragraph","content":"\\"Well, I wouldn\'t be so sure! You\'d make a great scientist!\\" Stella beams."}]},"scioly_invitational.protein_bad":{"id":"scioly_invitational.protein_bad","viewIf":{"$code":"return ((Q[\'protein\'] || 0)===0);"},"options":[{"id":"@scioly_invitational.fossils","title":"Next is Fossils."},{"id":"@scioly_invitational.fossils_roxana","title":"Next is Fossils."}],"content":{"content":"You did not adequately prepare for this event. In fact, you did not prepare for this event at all. Still, your background knowledge about biology comes in handly here.","type":"paragraph"}},"shopping_with_mom.shoes":{"id":"shopping_with_mom.shoes","options":[{"id":"@shopping_with_mom.buy_high_heels","title":"Buy high heels."},{"id":"@shopping_with_mom.dont_buy_high_heels","title":"Don\'t buy high heels."}],"content":[{"type":"paragraph","content":"Next is shoes. Unfortunately the pageant de facto necessitates high-heel shoes, according to all the websites you\'ve seen. However, you could try to get away with wearing flats, in which case you needn\'t buy anything here at all. But then you\'ll run the risk of being exposed as someone who is clearly not fit for the pageant."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"I should have taught you how to wear high heel shoes,\\""}," mom says. You instantly think of how footbinding was often performed by mothers, but resist making that analogy. So you don\'t say anything at all."]}]},"research_1.leave":{"id":"research_1.leave","options":[{"id":"@research_1.like","title":"You\'re happy to be doing this."},{"id":"@research_1.other","title":"You wish you\'re doing actual lab work."},{"id":"@research_1.reconsider","title":"You\'re reconsidering research as a career."}],"content":{"content":[{"type":"paragraph","content":["You follow him out of the office and into the lab space. \\"Hi, Stella, this is ",{"type":"insert","insert":0},",\\" he says, to the Asian woman sitting at a stool. \\"She is the high schooler I told you about. She\'ll be working with us on the cell profiling project.\\""]},{"type":"paragraph","content":["She looks up from her laptop and extends her hand. \\"Hi ",{"type":"insert","insert":1},". Nice to meet you.\\" You shake her hand, awkwardly of course."]},{"type":"paragraph","content":"\\"Now, Stella will give you the details. Good luck.\\" With that Professor Chen returned to his office, leaving you alone with Stella."},{"type":"paragraph","content":"\\"Don\'t worry, I won\'t bite. You can sit down.\\""},{"type":"paragraph","content":"She seems nice and patient enough as she explains the details. They have the data already, and they just need someone to help analyze it. That is, you. This is apparently their first project that has any computational component, and you\'re their first programmer. Not that you\'re much of a programmer, but you can learn, right?"},{"type":"paragraph","content":"\\"So, what do you think?\\""}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}},{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"skip.w5_research_3":{"id":"skip.w5_research_3","onArrival":[{"$code":"Q[\'research\'] = 0;"}],"goTo":[{"id":"skip.w5_emily_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.corner_2":{"id":"scioly_study_party.corner_2","options":[{"id":"@scioly_study_party.productive","title":"Do something productive."},{"id":"@scioly_study_party.wallow","title":"Wallow in your misery."}],"content":{"content":"While you\'re in this alcove, you might as well do something productive... or not?","type":"paragraph"}},"thanksgiving_party.play_nicely":{"id":"thanksgiving_party.play_nicely","options":[{"id":"@thanksgiving_party.talk_emily","title":"..."},{"id":"@thanksgiving_party.say_hi","title":"\\"Um. Hi.\\""}],"content":{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Play nicely with Qiuyi-jiejie, okay?\\""},", Professor Chen says. He leaves, leaving the two of you alone."]}},"scioly_2.aubrey2":{"id":"scioly_2.aubrey2","viewIf":{"$code":"return ((Q[\'aubrey_scioly\'] || 0) > 0);"},"onArrival":[{"$code":"Q[\'aubrey_scioly\'] = (Q[\'aubrey_scioly\'] || 0) + 1;\\nQ[\'protein_modeling\'] = (Q[\'protein_modeling\'] || 0) + 1;\\nQ[\'aubrey\'] = (Q[\'aubrey\'] || 0) + 1;"}],"options":[{"id":"@scioly_2.a1","title":"1"},{"id":"@scioly_2.a2","title":"2"},{"id":"@scioly_2.a3","title":"3"},{"id":"@scioly_2.a4","title":"4"},{"id":"@scioly_2.dont_know","title":"You have no idea."}],"content":{"content":[{"type":"paragraph","content":"Aubrey is sitting by herself in a corner of the classroom. She waves at you as you approach and sit next to her."},{"type":"paragraph","content":"\\"Ready to prepare?\\", she asks."},{"type":"paragraph","content":"\\"Um, yeah, I guess.\\""},{"type":"paragraph","content":[{"type":"conditional","content":"\\"Alright. You\'re doing the studying part of the event, so I\'m going to quiz you on one of the past exams. Question 1: How many nitrogen atoms are found in the backbone of each amino acid?\\" ","predicate":0},""]},{"type":"paragraph","content":[{"type":"conditional","content":"\\"Alright. I\'m going to ask the same questions as last time, just to see what you\'ve remembered. Question 1: How many nitrogen atoms are found in the backbone of each amino acid?\\" ","predicate":1},""]},{"type":"paragraph","content":"You should know this, but you\'re still not sure..."}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'aubrey_scioly\'] || 0)===2);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'aubrey_scioly\'] || 0) > 2);"}}]}},"scioly_final.sure_why_not":{"id":"scioly_final.sure_why_not","options":[{"id":"@scioly_final.conversation_dies","title":"Anyway the conversation dies."}],"content":{"content":[{"type":"paragraph","content":"\\"Um, sure, I can do it, I guess.\\""},{"type":"paragraph","content":"\\"Great!\\", the captain says. \\"We\'ll talk to Aubrey and try to get her to join with you.\\""},{"type":"paragraph","content":"Aubrey is still sitting around in the science olympiad room with her friends. \\"Hey, Aubrey, how are you doing these days?\\", he begins."},{"type":"paragraph","content":"\\"What\'s the deal?\\", she replies curtly. There is definitely subtext between the two, given their somewhat recent breakup."},{"type":"paragraph","content":"\\"Straight to business as usual. Have you considered running for captain?\\""},{"type":"paragraph","content":"\\"Actually, I was just talking about that. Diana and I were thinking about entering together.\\""},{"type":"paragraph","content":"Diana Choi is sitting next to Aubrey. She waves at you. You sort of wave back."},{"type":"paragraph","content":["\\"Well, I was just talking to ",{"type":"insert","insert":0}," here, to see if she would run for captain. But hey, the more the merrier, right?\\""]},{"type":"paragraph","content":"\\"Right. Yeah...\\" Aubrey smiles at you with what you imagine as some sort of pity or condescension. She is probably considering all the ways in which you would be terrible as a captain. You can\'t entirely disagree with her."}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"1.beauty":{"id":"1.beauty","options":[{"id":"@1.intro3","title":"What\'s next?"}],"content":[{"type":"paragraph","content":"But how could you compete in a beauty pageant if you\'re not beautiful? Of course you\'re not beautiful. You never were. You walk to the bathroom and take a look at yourself in the mirror. The face that stares back looks gross to say the least. It\'s acne-riddled, with bags under the eyes barely covered by your crooked wire-frame glasses. The hair is unkempt, and maybe really does look like a bird\'s nest. At least your body is skinny, but it\'s the bad kind of skinny, more like bone papered with skin. You\'ve never put on makeup by yourself, too much effort for someone who acts as if their body doesn\'t exist."},{"type":"paragraph","content":"If you\'re really going to do this pageant thing, you\'d better start now."}]},"aubrey_final.why_ruin_date":{"id":"aubrey_final.why_ruin_date","options":[{"id":"@aubrey_final.no_expectations","title":"\\"To be fair, I expected nothing.\\""},{"id":"@aubrey_final.sorry","title":"\\"Sorry...\\""}],"content":[{"type":"paragraph","content":"\\"Why?\\", you ask."},{"type":"paragraph","content":"\\"You know, because I\'m not like, you know.\\""},{"type":"paragraph","content":"\\"Yeah. Sorry.\\""},{"type":"paragraph","content":"\\"No. I should be sorry. I should have thought about your feelings before setting this up.\\""},{"type":"paragraph","content":"\\"What do you mean?\\""},{"type":"paragraph","content":"\\"Oh man.\\" Aubrey laughed before glancing at you. \\"Isn\'t it obvious that I\'m just stringing you along? This isn\'t like, going to be a thing.\\""}]},"birthday.done":{"id":"birthday.done","options":[{"id":"@birthday.aubrey_party","title":"Aubrey shows up not long after."},{"id":"@birthday.miri_party","title":"Miri shows up not long after."},{"id":"@birthday.both_party","title":"Eventually both Miri and Aubrey arrive."}],"content":[{"type":"paragraph","content":"Okay. There\'s that."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"We\'re going to leave,\\""}," mom says. ",{"type":"emphasis-1","content":"\\"Be careful here.\\""},""]},{"type":"paragraph","content":"Now you\'re left alone in the apartment. Waiting for the party to start. Or something like that."}]},"christmas_party.continue_game":{"id":"christmas_party.continue_game","options":[{"id":"@christmas_party.stare_back","title":"Emily is staring at you more now."},{"id":"@christmas_party.continue_game_1","title":"The game continues."}],"content":{"content":[{"type":"paragraph","content":["\\"You have an excellent poker face,\\" Aubrey tells Emily. \\"Its like totally blank. Not like ",{"type":"insert","insert":0},". I can always tell what she\'s thinking.\\""]},{"type":"paragraph","content":"You must have frowned, because Aubrey says, \\"She\'s thinking \'no you can\'t\' right now. I can tell, see?\\""},{"type":"paragraph","content":"\\"Why dont you just call me an inscrutable oriental already?\\" Emily says. \\"That was a joke,\\" she adds as Aubrey looks confused."},{"type":"paragraph","content":"\\"See, poker face,\\" Aubrey says."}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"church_1.family":{"id":"church_1.family","onArrival":[{"$code":"Q[\'family_interact\'] = (Q[\'family_interact\'] || 0) + 1;"}],"options":[{"id":"@church_1.bible_study","title":"Afterwards, you\'re roped into bible study."}],"content":[{"type":"paragraph","content":"You join your mom and Kevin in the living room, while your dad eats with the men in the kitchen."},{"type":"paragraph","content":"The moms eat dinner on the living room couches, with the youngest children sitting around the coffee table in the middle of the room. You listen to the adults talk about housing prices, their kids\' extracurriculars, whatever. Aubrey (Liyun is her Chinese name) is doing well in school, apparently. Your mom wishes you could be more like her, make friends and do lots of ECs. But you\'re doing ECs already, you say. Well, Aubrey\'s doing all those and then some."}]},"church_2.say_nothing":{"id":"church_2.say_nothing","options":[{"id":"@church_2.continue_eating","title":"Soon you\'re done eating."}],"content":[{"type":"paragraph","content":"You go back to eating. The food has gone cold. Aubrey must have sensed that you ignored her. Is she hurt? What have you just implied by ignoring her question? Are you implying that you don\'t care about her opinions, or that you dislike her somehow? Perhaps you should have just said some boring platitudes? Is it too late to make up for it?"},{"type":"paragraph","content":"\\"Sorry,\\" you say."},{"type":"paragraph","content":"\\"For what?\\", Aubrey says with a chuckle."},{"type":"paragraph","content":"\\"Oh. Um, never mind.\\""}]},"church_3.no_sing":{"id":"church_3.no_sing","options":[{"id":"@church_3.silence","title":"Just do your homework."},{"id":"@church_3.continue_talk","title":"Try to talk to Spencer?"}],"content":[{"type":"paragraph","content":"Downstairs is where all the children except for Aubrey stay during these gatherings, as usual. Spencer Zhang is here too, doing something on his laptop."},{"type":"paragraph","content":"\\"What are you doing?\\", you ask, not knowing what else to say."},{"type":"paragraph","content":"\\"Oh. College apps,\\" he says, without looking up at you. \\"Guess what. You should be glad you\'re still a junior.\\""},{"type":"paragraph","content":"\\"Oh. How\'s that?\\", you ask, wondering if you should attempt to make conversation."},{"type":"paragraph","content":"\\"Man, what do you think?\\" He sighs. \\"Like, there\'s no way I\'m getting into MIT. But my parents are still making me apply.\\""},{"type":"paragraph","content":"\\"Oh. Sorry.\\""}]},"classes_1.stemplatform":{"id":"classes_1.stemplatform","onArrival":[{"$code":"Q[\'platform\'] = 1;"}],"options":[{"id":"@classes_1.step3","title":"Step 3: ???"}],"content":[{"type":"paragraph","content":"\\"What about STEM education? Like, my platform could be, um, like, being a role model for girls in STEM?\\""},{"type":"paragraph","content":"\\"Sure, that sort of thing\'s in vogue these days, isn\'t it?\\""},{"type":"paragraph","content":"\\"Probably.\\""},{"type":"paragraph","content":"\\"So go for it then.\\""},{"type":"paragraph","content":"Right. Now that\'s decided."}]},"emily_1.a_little_weird":{"id":"emily_1.a_little_weird","goTo":[{"id":"emily_1.emily_thanks"}],"content":{"content":"\\"Um, it\'s... a little weird, but...\\" You shrug. \\"It\'s not a big deal.\\"","type":"paragraph"}},"emily_3_online.look_forward":{"id":"emily_3_online.look_forward","content":{"content":"For some reason you\'ve grown attached to these meetings with Emily. They\'ve become a part of your routine, and you enjoy these sorts of conversations. Despite the awkwardness.","type":"paragraph"}},"emily_2.goodbye":{"id":"emily_2.goodbye","options":[{"id":"@emily_2.bye","title":"Say goodbye."}],"content":{"content":"\\"Sorry, I have to go now,\\" says Emily after what must have been between 30 and 90 minutes of \'studying\', and you try to pretend that you were staring at the wall rather than at her. \\"God, I forgot we were trying to do pageant stuff. I\'ll make up for it next time.\\"","type":"paragraph"}},"emily_4.idk":{"id":"emily_4.idk","options":[{"id":"@emily_4.what_was_wrong","title":"What\'s wrong with you?"},{"id":"@emily_4.do_not_want","title":"Actually, maybe you didn\'t like her anyway."}],"content":[{"type":"paragraph","content":"\\"Um... I don\'t know, um,...\\""},{"type":"paragraph","content":"\\"No, it\'s fine.\\" Emily sighs. \\"Alright. I should go now. Bye.\\""},{"type":"paragraph","content":"You wave as she leaves, coffee still unfinished. You finish the rest of your strawberry drink by yourself."}]},"emily_6.im_gay":{"id":"emily_6.im_gay","onArrival":[{"$code":"Q[\'pageant_interview\'] = (Q[\'pageant_interview\'] || 0) + 1;"}],"options":[{"id":"@emily_6.science","title":"\\"So, you know I like science and...\\""},{"id":"@emily_6.girl_1","title":"\\"So, there\'s this girl...\\""},{"id":"@emily_6.worries_1","title":"\\"So, I\'m worried about a lot of things...\\""},{"id":"@emily_6.no_secret","title":"\\"So, can I not tell a secret?\\""}],"content":[{"type":"paragraph","content":"\\"Um... I\'m gay. Actually a few people know that so, uh, I don\'t know if that counts.\\""},{"type":"paragraph","content":"Emily makes a soft laugh. \\"I knew that already. Sorry. You don\'t have to if you don\'t want to.\\""},{"type":"paragraph","content":"\\"No, it\'s okay. Um, I have a bunch of secrets so...\\""},{"type":"paragraph","content":"You think about what else to say..."}]},"emily_7.yes_date":{"id":"emily_7.yes_date","onArrival":[{"$code":"Q[\'emily_date\'] = 1;"}],"options":[{"id":"@emily_7.hug","title":"Hug?"}],"content":[{"type":"paragraph","content":"\\"Yeah...\\""},{"type":"paragraph","content":"Emily takes off her glasses and rubs her eyes. \\"God, I need to stop smearing my eyeliner. Anyway, so my answer is yes. In one and a half years, if we\'re still alive, and the world still exists, I\'ll be your, um, official girlfriend. If that\'s what you still want at that time. I\'m not going to date anyone else until at least then. Probably forever. Think of this as a contract if you would like.\\""},{"type":"paragraph","content":"You smile, or make some facial gestures towards that effect. Emily reciprocates, or something like that."}]},"emily_final.go_to_emily":{"id":"emily_final.go_to_emily","options":[{"id":"@emily_final.go_to_emily_2","title":"Head to the T station."}],"content":[{"type":"paragraph","content":"You: Can I head over?"},{"type":"paragraph","content":"Emily: You don\'t have to."},{"type":"paragraph","content":"Emily: I\'ll head back by myself."},{"type":"paragraph","content":"You: Are you sure?"},{"type":"paragraph","content":"Emily: Unfortunately I\'m not so idiotic as to actually carry out the \\"running away from home\\" plan."},{"type":"paragraph","content":"Emily: But I would prefer if you would come over anyway, only if it\'s possible and convenient."},{"type":"paragraph","content":"You: I\'m heading over."}]},"epilogue.ep_emily_date":{"id":"epilogue.ep_emily_date","maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"viewIf":{"$code":"return ((Q[\'emily_date\'] || 0)===1);"},"content":{"type":"paragraph","content":["You sort of obliquely confessed to Emily, and she said that you could date after graduating, or something like that. In the meantime, you\'ve become friends, of a sort. You\'ve been keeping in touch via the despicable platform known as facebook. She complains about her parents, and you complain about your parents. She talks about obscure internet jokes and gender, and you talk about webcomics (apparently she\'s also a fan of ",{"type":"emphasis-1","content":"the webcomic"},")."]},"countVisitsMax":1},"family_5.youre_drunk":{"id":"family_5.youre_drunk","options":[{"id":"@family_5.no_but","title":"Leave."}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"You\'re drunk,\\""}," you say. ",{"type":"emphasis-1","content":"\\"You should drink less during the daytime.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"I\'m fine,\\""}," he says. As if the bottle of baijiu on the table wasn\'t obvious. ",{"type":"emphasis-1","content":"\\"You haven\'t drank, and you still don\'t know how to talk to me.\\""},""]},{"type":"paragraph","content":"He stares at you, as if expecting some response."}]},"family_6.oh_2":{"id":"family_6.oh_2","onArrival":[{"$code":"Q[\'trauma_points\'] = (Q[\'trauma_points\'] || 0) + 1;"}],"options":[{"id":"@family_6.eat_1","title":"Wait."}],"content":[{"type":"paragraph","content":"You have no idea what to say after that."},{"type":"paragraph","content":"Dad and Kevin are sitting at the table in silence, across from each other, staring sideways. Mom sits next to Kevin, leaving you to sit next to Dad. Mom pats Kevin\'s hair. He shrinks away. Dad ruffles your hair. You try to avoid shrinking away. No one talks. The menus are here. Dad unfolds it and buries his face in it. The waiter arrives with water. Are your orders ready? Yes they are you suppose. Dad orders a burger. Mom orders a salad. You want to chuckle at the heteronormativity of this but you can\'t allow yourself to react. Kevin points out a mac and cheese from the kids\' menu. Finally you order the cheapest sandwich on the menu."}]},"introspect_1.stephanie":{"id":"introspect_1.stephanie","goTo":[{"id":"introspect_1.name"}],"onArrival":[{"$code":"Q[\'first_name\'] = \\"Stephanie\\";"}],"content":{"content":"","type":"paragraph"}},"introspect_2.self":{"id":"introspect_2.self","options":[{"id":"@introspect_2.end","title":"This is all pointless."}],"content":[{"type":"paragraph","content":"Let\'s talk about your personal inconsistencies:"},{"type":"paragraph","content":"Things that give you anxiety: talking to more than one person at once. Speaking to someone on the internet. Meeting someone new. Talking in an unfamiliar context to someone of higher social status than you (which includes all adults)."},{"type":"paragraph","content":"Things that don\'t give you anxiety: public transportation, commercial transactions, academic interactions for the most part except when they do."},{"type":"paragraph","content":"Anyway, maybe you should go to therapy. But that would have to involve your parents and you do not want to aggravate them more than you already have, not to mention your mom\'s insurance probably doesn\'t cover that stuff. Maybe you could get SSRIs somewhere. Those are supposed to help with the sort of mental condition that you have, right? But what if you don\'t actually have problems that can be solved via neurological means? Or what if they completely mess you up even more than you are already?"}]},"introspect_3.stop":{"id":"introspect_3.stop","content":{"content":"Thinking about things just makes you feel bad. Unfortunately, it\'s rather difficult to stop thinking. Thus, you distract yourself with internet browsing. It works in getting your mind off whatever it was you were thinking about.","type":"paragraph"}},"introspect_3":{"id":"introspect_3","type":"scene","title":"Introspection","subtitle":"Nearing the end","newPage":true,"viewIf":{"$code":"return (((((((Q[\'week\'] || 0)===9) || ((Q[\'week\'] || 0)===11))) && ((Q[\'introspection\'] || 0) >= 1)) && ((((((Q[\'pageant_prep\'] || 0) >= 2) || ((Q[\'scioly\'] || 0) >= 2)) || ((Q[\'research\'] || 0) >= 2)) || ((Q[\'family\'] || 0) >= 2)))) && ((Q[\'week_progress\'] || 0) < 3));"},"onArrival":[{"$code":"Q[\'introspection\'] = (Q[\'introspection\'] || 0) + 1;"}],"tags":["top","introspect"],"maxVisits":1,"options":[{"id":"@introspect_3.pageant","title":"Think about the pageant."},{"id":"@introspect_3.scioly","title":"Think about science olympiad."},{"id":"@introspect_3.research","title":"Think about your research."},{"id":"@introspect_3.people","title":"Think about people you know."}],"content":{"content":"It\'s getting close to the pageant. The hour of reckoning. Or something like that. How\'s your progress been?","type":"paragraph"},"countVisitsMax":1},"miri_date.future_what":{"id":"miri_date.future_what","goTo":[{"id":"miri_date.miri_thinking"}],"content":[{"type":"paragraph","content":"\\"Um, what do you mean by \'better or worse\'? By what metric?\\""},{"type":"paragraph","content":"\\"Ha. Should have expected you would have said something like that.\\" Miri sighs."}]},"miri_pageant_prep.gym_visit_2":{"id":"miri_pageant_prep.gym_visit_2","viewIf":{"$code":"return ((Q[\'gym\'] || 0) > 0);"},"onArrival":[{"$code":"Q[\'gym\'] = (Q[\'gym\'] || 0) + 1;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 1;"}],"options":[{"id":"@miri_pageant_prep.gym_continue","title":"Hit the gym."}],"content":[{"type":"paragraph","content":"Now that you\'ve been to the gym at least once in your lifetime, you feel slightly more prepared. And from the looks of it, so does Miri. She\'s wearing athletic clothes this time, and so are you."},{"type":"paragraph","content":"\\"Wow, you look better than usual,\\" Miri says."}]},"pageant_prep_self_2.makeup":{"id":"pageant_prep_self_2.makeup","onArrival":[{"$code":"Q[\'pageant_makeup\'] = (Q[\'pageant_makeup\'] || 0) + 1;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 1;"}],"maxVisits":1,"options":[{"id":"@pageant_prep_self_2.makeup","title":"Look up makeup tips."},{"id":"@pageant_prep_self_2.fashion","title":"Look up tips on clothes."},{"id":"@pageant_prep_self_2.body_language","title":"Look up tips on body language."},{"id":"@pageant_prep_pick_ball_gown","title":"Find a ball gown."},{"id":"@pageant_prep_try_ball_gown","title":"Try on the ball gown."},{"id":"@pageant_prep_self_2.pageant_prep_done","title":"That\'s enough for tonight."}],"content":[{"type":"paragraph","content":"The last time you put on makeup was... perhaps the memory was so traumatic you\'ve excised it from your brain. But you need to do this. It\'s s just a skill like any other, nothiing more to it."},{"type":"paragraph","content":"Wikihow is where you end up at, of course. You write out the list of ingredients: moisturizer, primer, foundation, concealer,... God, that\'s a lot of money that could probably be put to better use. The videos all look so effortless. But in reality of course it\'s going to be anything but."}],"countVisitsMax":1},"pageant_final.makeup":{"id":"pageant_final.makeup","options":[{"id":"@pageant_final.dress","title":"Now, you have to pick a dress."}],"content":{"content":[{"type":"paragraph","content":["Next is makeup. Well then. It\'s not as if you have much practice with makeup. Mom has offered to help you. ",{"type":"conditional","content":"So has Emily Chen, but she\'s not exactly able to come right now. ","predicate":0},{"type":"conditional","content":"So has Miri, and she also isn\'t able to come right now. ","predicate":1},""]},{"type":"paragraph","content":"You do need help with makeup, so help from mom it is. Her style is different from the videos you watched online. Different, but hopefully no worse. More \\"naturalistic\\", no contouring, less visible eyeshadow. Red lipstick."}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'emily\'] || 0) >= 2);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'miri\'] || 0) >= 3);"}}]}},"pageant_meetup.start_meeting":{"id":"pageant_meetup.start_meeting","options":[{"id":"@pageant_meetup.listen","title":"Listen."},{"id":"@pageant_meetup.tune_out","title":"Tune out."},{"id":"@pageant_meetup.look_at_emily","title":"Look at Emily."}],"content":{"content":"The first speaker is one of the organizers of the pageant. She starts with the formalities, like congratulating everyone on being here, and so on. Then comes the important part: the fees and paperwork. Your parents took care of most of those, but there\'s still some personal forms that you\'ll have to fill out yourself. Finally there\'s some information about the pageant.","type":"paragraph"}},"research_4.present_4":{"id":"research_4.present_4","options":[{"id":"@research_4.smile","title":"You can\'t help but crack a smile."}],"content":{"content":[{"type":"paragraph","content":"And you continue. Stumbling more than a few times, but mentioning all the correct points. Or did you? You aren\'t sure."},{"type":"paragraph","content":"At the end comes the questions, except there aren\'t any. Instead, Professor Chen congratulates you."},{"type":"paragraph","content":["\\"",{"type":"insert","insert":0}," did a very good job! She is only a high school student, and already she is doing science with us!\\""]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"research_6.not_complicit":{"id":"research_6.not_complicit","onArrival":[{"$code":"Q[\'growth_points\'] = (Q[\'growth_points\'] || 0) + 1;"}],"options":[{"id":"@research_6.emily_call","title":"Emily texts you later that night."}],"content":{"content":[{"type":"paragraph","content":"\\"--- is waiting,\\" Professor Chen says. He crosses his arms. Emily makes no motion."},{"type":"paragraph","content":[{"type":"conditional","content":"As a lesbian, you have long imagined a moment in which you would rescue your hypothetical girlfriend from their hostile parents. You never imagined that such a moment would be as asinine as this. ","predicate":0},{"type":"conditional","content":"You have long imagined a moment when you could finally be a hero, to protect someone you care about. You never imagined that such a moment would be as asinine as this. ","predicate":1},""]},{"type":"paragraph","content":"\\"Sorry, I don\'t have anything prepared today,\\" you say. \\"I would have to get ready. The two of us can talk about this later. I don\'t want to waste your time.\\""},{"type":"paragraph","content":["Professor Chen frowns. \\"That\'s fine,\\" he says. \\"---, let\'s go. ",{"type":"insert","insert":2},", we will talk later.\\""]},{"type":"paragraph","content":"You\'re not sure if you did the right thing here, or if it even matters."}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'emily_date\'] || 0) >= 1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'emily_date\'] || 0)===0);"}},{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"research_final.too_early":{"id":"research_final.too_early","options":[{"id":"@research_final.thats_a_lie","title":"Objectively speaking, that\'s not true."},{"id":"@research_final.you_wish","title":"You wish, though..."}],"content":[{"type":"paragraph","content":"\\"Um, I don\'t know yet...\\" That\'s partly but not exactly true. You already know some of your top choices, but you don\'t know how you\'ll round out the list."},{"type":"paragraph","content":"\\"Not here, right? Haha. You could probably go to MIT if you wanted to.\\""},{"type":"paragraph","content":"\\"Um, but that\'s really hard...\\""},{"type":"paragraph","content":"\\"Hey, don\'t be so humble! You\'d make a great scientist!\\""}]},"scioly_invitational.fossils":{"id":"scioly_invitational.fossils","viewIf":{"$code":"return ((Q[\'roxana_seen\'] || 0)===0);"},"options":[{"id":"@scioly_invitational.fossils_good","title":"Well."},{"id":"@scioly_invitational.fossils_okay","title":"Fine."},{"id":"@scioly_invitational.fossils_bad","title":"Semi-adequately."}],"content":[{"type":"paragraph","content":"Fossils is a test-only event, where you rotate around various stations that involve fossil identification as well as background questions."},{"type":"paragraph","content":"David arrives shortly after you, sitting next to you without a word."},{"type":"paragraph","content":"The test goes..."}]},"shopping_with_mom.buy_high_heels":{"id":"shopping_with_mom.buy_high_heels","onArrival":[{"$code":"Q[\'has_high_heels\'] = 1;"}],"goTo":[{"id":"shopping_with_mom.ball_gown"}],"content":{"type":"paragraph","content":["You take the cheapest pair that fit you and look kind of fancy, and place it in your shopping bag. ",{"type":"emphasis-1","content":"\\"How fast,\\""}," mom says."]}},"research_1.like":{"id":"research_1.like","goTo":[{"id":"research_1.end"}],"content":[{"type":"paragraph","content":"\\"Um, this sounds interesting!\\" You muster as much enthusiasm in your voice as you can, but it falls flat."},{"type":"paragraph","content":"Stella smiles. \\"Okay. Good to know.\\""}]},"skip.w5_emily_status":{"id":"skip.w5_emily_status","options":[{"id":"@skip.w5_emily_1","title":"You\'re friends with Emily."},{"id":"@skip.w5_emily_3","title":"You have not interacted much."}],"content":{"content":"Relationship with Emily:","type":"paragraph"}},"scioly_study_party.productive":{"id":"scioly_study_party.productive","options":[{"id":"@scioly_study_party.wallow","title":"Wallow in your misery."},{"id":"@scioly_study_party.breakdown","title":"Have a mental breakdown."}],"content":[{"type":"paragraph","content":"You\'ve brought your notes and your computer, making you all too prepared to partake in quasi-academic exercises even in the invariable occasion that you end up alone in a corner. You have past exams with solutions, various compiled notes for all of your events, and the wi-fi password."},{"type":"paragraph","content":"You glance over the previous exams, and the words melt together on the page. You try to read notes on your laptop, and the text becomes a blur. It\'s too loud here, but that isn\'t the problem."},{"type":"paragraph","content":"Why can\'t you focus?"}]},"thanksgiving_party.talk_emily":{"id":"thanksgiving_party.talk_emily","viewIf":{"$code":"return ((Q[\'emily\'] || 0) >= 4);"},"options":[{"id":"@thanksgiving_party.homework_emily","title":"Do homework."}],"content":[{"type":"paragraph","content":"\\"Um...\\", you begin, but you can\'t find any words. You look away. Feel your pulse. You don\'t know what to say. You don\'t even know what to think; your mind\'s gone blank."},{"type":"paragraph","content":"Here are the facts. This is Emily. She\'s trans. Her father must not know. And you do."},{"type":"paragraph","content":"Emily sighs, breaking you out of your reverie. \\"Just don\'t tell anyone, okay? God, I\'m so sorry.\\""},{"type":"paragraph","content":"\\"No. It\'s fine. I\'m sorry.\\" You let out a long breath."},{"type":"paragraph","content":"\\"Anyway, uh, I have to do homework.\\""},{"type":"paragraph","content":"\\"Yeah. Me too.\\""}]},"scioly_2.a1":{"id":"scioly_2.a1","goTo":[{"id":"scioly_2.protein_question_2"}],"content":{"content":{"type":"paragraph","content":["\\"Yes, that\'s right!\\", Aubrey says. ",{"type":"conditional","content":"\\"Just making sure you remembered.\\"","predicate":0}]},"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'aubrey_scioly\'] || 0) >= 2);"}}]}},"scioly_final.conversation_dies":{"id":"scioly_final.conversation_dies","options":[{"id":"@scioly_final.want_to_be_captain","title":"You sort of like the idea of being captain."},{"id":"@scioly_final.dont_want_to_be_captain","title":"To be honest... you don\'t really want to to be captain anymore."}],"content":{"content":"The meeting is soon dismissed, and you go home.","type":"paragraph"}},"1.school":{"id":"1.school","options":[{"id":"@1.intro3","title":"What\'s next?"}],"content":[{"type":"paragraph","content":"The only thing you might get out of this is a personal essay for your college apps. It would be a great Common App personal essay! Talk about how you got persuaded to do something beyond your comfort zone. Talk about how you managed to integrate your interests in science, how you wanted to make yourself a role model for young girls and used the pageant as a platform to do so. Even if you fail (which, let\'s be honest, you will), play up how you learned from it. Distinguish yourself from the masses of other Asian girls with perfect GPAs and 10 AP classes who don\'t do beauty pageants."},{"type":"paragraph","content":"And now you have a plan for the whole pageant thing. It could be worse."}]},"aubrey_final.no_expectations":{"id":"aubrey_final.no_expectations","options":[{"id":"@aubrey_final.back_to_present","title":"Back to the present..."}],"content":[{"type":"paragraph","content":"You didn\'t have any expectations that this was going to be a \'thing\', so to speak."},{"type":"paragraph","content":"\\"It\'s fine,\\" you said. \\"I didn\'t really expect that.\\""},{"type":"paragraph","content":"\\"Then let\'s just try to enjoy this time,\\" Aubrey replied, her voice sounding... resigned? Or something like that."}]},"birthday.aubrey_party":{"id":"birthday.aubrey_party","viewIf":{"$code":"return (((Q[\'birthday_aubrey_invited\'] || 0)===1) && ((Q[\'birthday_miri_invited\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'aubrey\'] = (Q[\'aubrey\'] || 0) + 1;"}],"options":[{"id":"@birthday.aubrey_party_2","title":"Um..."}],"content":[{"type":"paragraph","content":"\\"So, um, this is your birthday party?\\""},{"type":"paragraph","content":"You feel your heart beat faster. This is a pathetic excuse for a party."},{"type":"paragraph","content":"\\"Congratulations. Uh, you\'re the only one here. Haha.\\" You try to make some sort of joke but nothing comes of it."},{"type":"paragraph","content":"\\"Oh. Um, that\'s fine. Don\'t worry about it. What do you want to do?\\""},{"type":"paragraph","content":"You can\'t move, and you\'re trembling."}]},"christmas_party.continue_game_1":{"id":"christmas_party.continue_game_1","viewIf":{"$code":"return ((Q[\'stared_emily\'] || 0)===0);"},"goTo":[{"id":"christmas_party.continue_game_2"}],"content":{"content":"","type":"paragraph"}},"church_1.bible_study":{"id":"church_1.bible_study","options":[{"id":"@church_1.bible_study_2","title":"The reading continues around the room."}],"content":[{"type":"paragraph","content":["The adults sit in a circle, their Chinese bibles open on their laps. The leader, Wang ",{"type":"emphasis-1","content":"laoshi"},", invites everyone to read, one passage at a time around the circle. You sit next to mom, as she follows along with full attention. Kevin\'s already gone downstairs."]},{"type":"paragraph","content":"When it\'s your turn, mom reads for you. She points to the characters with her fingers, leading you to follow along, but you\'re not even sure which book they\'re reading. Even though you were in Chinese school, the Bible is in traditional while all the Chinese you were taught was in simplified, not to mention the entirely different formal lexicon. You understand a few words here and there, but any Chinese out of everyday speech sounds strange."}]},"church_2.continue_eating":{"id":"church_2.continue_eating","content":[{"type":"paragraph","content":"After you finish eating, it\'s time to start working on your homework. Of course Aubrey is way ahead of you on this front; she\'s almost done with her homework for Monday, and you\'ve barely started."},{"type":"paragraph","content":"There\'s a problem set in calc, plus some readings for World and Lit, and some vocab in Spanish. It feels as if you\'re never going to get it all done, but you will. Of course you will."},{"type":"paragraph","content":"You work on homework until mom sends your brother to tell you that they\'re going home. Aubrey smiles at you as she waves you goodbye. You try to smile as you wave back."}]},"church_2":{"id":"church_2","type":"scene","title":"Bible Study","subtitle":"Teacher Wang","viewIf":{"$code":"return (((Q[\'church\'] || 0)===1) && ((Q[\'week\'] || 0)===4));"},"onArrival":[{"$code":"Q[\'church\'] = (Q[\'church\'] || 0) + 1;\\nQ[\'aubrey\'] = (Q[\'aubrey\'] || 0) + 1;"}],"tags":["weekend"],"options":[{"id":"@church_2.listen","title":"Listen and wait."}],"content":[{"type":"paragraph","content":["In Chinese they call him ",{"type":"emphasis-1","content":"Wang Laoshi"},", or Teacher Wang. His name is James Wang, and he is the unofficial leader of this bible study group. He\'s older than most of this group, with gray hair and children already grown. He says the ",{"type":"emphasis-1","content":"daogao"},", or prayers, with his eyes closed tight, hands held together. When he speaks, in his soft and breathy Mandarin, his bushy eyebrows move, giving him a wise appearance."]},{"type":"paragraph","content":["\\"今天，我们感谢主... ",{"type":"emphasis-1","content":"Today, we give thanks to the Lord..."},"\\""]}]},"church_3.continue_talk":{"id":"church_3.continue_talk","goTo":[{"id":"church_3.silence"}],"options":[{"id":"@church_3.silence","title":"So maybe you should do homework instead."}],"content":{"content":"But, there\'s nowhere for the conversation to go after that. Your parents have a standing order for you to get advice about college apps from anyone who\'s been through the process, which means Spencer. But, honestly, you don\'t really feel like it.","type":"paragraph"}},"classes_1.scienceplatform":{"id":"classes_1.scienceplatform","options":[{"id":"@classes_1.step3","title":"Step 3: ???"}],"content":[{"type":"paragraph","content":"\\"Yeah, science is good, I guess.\\""},{"type":"paragraph","content":"\\"Yeah. You can\'t go wrong with science. They\'re all into STEM girls these days.\\""},{"type":"paragraph","content":"\\"Plus it helps my mom keep her job funding.\\""}]},"emily_1.not_weird":{"id":"emily_1.not_weird","goTo":[{"id":"emily_1.emily_thanks"}],"content":{"content":"\\"Um, it\'s really okay that...\\" You shrug. \\"It\'s cool that you\'re um, kind of logical about the pageant thing.\\"","type":"paragraph"}},"emily_3_online.maybe_not":{"id":"emily_3_online.maybe_not","content":{"content":"Weren\'t you supposed to be doing practice for the pageant? How much practice are you actually getting done? Wouldn\'t there be activities that are more productive?","type":"paragraph"}},"emily_3_online":{"id":"emily_3_online","type":"scene","title":"Meeting with Emily","subtitle":"A personal conversation","newPage":true,"viewIf":{"$code":"return (((((Q[\'emily\'] || 0)===3) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'stress\'] || 0) < 15)) && ((Q[\'thanksgiving\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'emily\'] = (Q[\'emily\'] || 0) + 1;\\nQ[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'emily_3_seen\'] = 1;"}],"tags":["top","social"],"options":[{"id":"@emily_3_online.no","title":"\\"Um, no, how?\\""}],"content":[{"type":"paragraph","content":"It is past 11PM, and you are conversing with Emily via the vile platform known as Facebook Messenger. The discussion has been productive so far; she has been sending photographs of every item in her makeup kit and describing their usage in excruciating detail. You have not assimilated much from the conversation, but at least now you have a reference regarding makeup."},{"type":"paragraph","content":"Emily: Do you know how I know so much about makeup and shit?"}]},"emily_2.bye":{"id":"emily_2.bye","options":[{"id":"@emily_2.looking_forward","title":"You\'re looking forward to next time."},{"id":"@emily_2.not_looking_forward","title":"Will there even be a next time?"}],"content":[{"type":"paragraph","content":"\\"Sorry. I mean, bye. See you, um, later. Next time.\\""},{"type":"paragraph","content":"You wave at her as she leaves."}]},"emily_4.what_was_wrong":{"id":"emily_4.what_was_wrong","content":[{"type":"paragraph","content":"Can\'t you be normal just once? Will you ever stop being a freak when you\'re around other people? She wanted to be your friend, too; what\'s wrong with you?"},{"type":"paragraph","content":"You messed this one up, just like you\'ve messed up everything else."},{"type":"paragraph","content":"Whatever. You have homework to do."}]},"emily_6.worries_1":{"id":"emily_6.worries_1","onArrival":[{"$code":"Q[\'emily\'] = 7;"}],"options":[{"id":"@emily_6.worries_2","title":"I\'m..."}],"content":[{"type":"paragraph","content":"\\"So, you know I have like, really severe anxiety, right? Especially, like, social anxiety?\\""},{"type":"paragraph","content":"Emily grins to herself. \\"Yeah. That\'s hardly a secret.\\""},{"type":"paragraph","content":"\\"Okay. There\'s more. Every time I talk to someone, I\'m imagining all the ways I could... mess up, I guess. Like, it\'s some sort of visual novel or something where if I make the wrong choice, the person I\'m talking to will hate me forever. Except it\'s not a visual novel, it\'s something worse, like... like...\\""},{"type":"paragraph","content":"\\"It\'s okay,\\" says Emily as she puts a hand on your back."}]},"emily_7.hug":{"id":"emily_7.hug","options":[{"id":"@emily_7.wipe_away","title":"Just make sure to hide it."}],"content":[{"type":"paragraph","content":"\\"Um, would physical contact be appropriate in this situation?\\""},{"type":"paragraph","content":"\\"Of course.\\""},{"type":"paragraph","content":"The two of you make some sort of awkward but affectionate physical contact. It\'s a good feeling while it lasts."},{"type":"paragraph","content":"Besides, you have a sort-of girlfriend now. You can\'t help but smile to yourself on the walk home."}]},"emily_final.go_to_emily_2":{"id":"emily_final.go_to_emily_2","options":[{"id":"@emily_final.wait","title":"Wait."}],"content":[{"type":"paragraph","content":"You quietly leave the house, hopefully not alerting anyone that you are gone. The trains are only running for two more hours; there aren\'t many people heading downtown at this time so you have a car almost entirely to yourself."},{"type":"paragraph","content":"Emily: Sorry I\'m like this."},{"type":"paragraph","content":"You: I\'ll be there in 20 minutes hopefully."},{"type":"paragraph","content":"Emily: I\'ll just stay here at the station."},{"type":"paragraph","content":"Emily: Don\'t worry about me. I\'m fine."}]},"epilogue.ep_emily_friends":{"id":"epilogue.ep_emily_friends","maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"viewIf":{"$code":"return (((Q[\'emily\'] || 0) >= 8) && ((Q[\'emily_date\'] || 0)===0));"},"content":{"type":"paragraph","content":["Emily Chen is your friend now. Probably. You\'ve been keeping in touch via the despicable platform known as facebook. She complains about her parents, and you complain about your parents. She talks about obscure internet jokes and gender, and you talk about webcomics (apparently she\'s also a fan of ",{"type":"emphasis-1","content":"the webcomic"},")."]},"countVisitsMax":1},"family_5.kill_self":{"id":"family_5.kill_self","goTo":[{"id":"family_5.no_but"}],"content":{"content":"No. You\'re not going to listen to the first voice inside your head. But the impetus to action is there. That part works. You can\'t stay here any longer.","type":"paragraph"}},"family_5":{"id":"family_5","type":"scene","title":"Family","subtitle":"Dad\'s time","newPage":true,"viewIf":{"$code":"return ((((((((Q[\'week\'] || 0) > 1) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'family\'] || 0)===5)) && ((Q[\'weekly_family\'] || 0)===0)) && ((Q[\'argument_viewed\'] || 0)===1)) && ((Q[\'dad_viewed\'] || 0)===0)) && ((Q[\'week\'] || 0) < 10));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'family\'] = (Q[\'family\'] || 0) + 1;\\nQ[\'weekly_family\'] = 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 2;\\nQ[\'loneliness\'] = (Q[\'loneliness\'] || 0) + 2;\\nQ[\'dad_viewed\'] = 1;\\nQ[\'trauma_points\'] = (Q[\'trauma_points\'] || 0) + 1;"}],"maxVisits":1,"tags":["top","family"],"options":[{"id":"@family_5.god","title":"Oh God."}],"content":[{"type":"paragraph","content":"You instantly regret coming home when you see the pair of shoes behind the door."},{"type":"paragraph","content":"Your father is sitting at the dinner table, watching some CCTV drama on his laptop and smelling vaguely of alcohol. He likes to talk to you for some reason, because according to him you don\'t get enough opportunities to talk."},{"type":"paragraph","content":["\\"姑娘阿... ",{"type":"emphasis-1","content":"Daughter"},"...\\", he begins."]}],"countVisitsMax":1},"family_6.eat_1":{"id":"family_6.eat_1","options":[{"id":"@family_6.eat_2","title":"Wait."}],"content":[{"type":"paragraph","content":"The waiter leaves."},{"type":"paragraph","content":"The tension among the four of you dissipates ever so slightly. But it\'s still there, still filling the spaces among the table. It\'s in the conspicuous silence. It\'s in the glances mom gives you, the knowing smiles. It\'s in dad\'s sighs, and mom\'s attempts to not react. It\'s in Kevin\'s eyes, constantly downcast."},{"type":"paragraph","content":"Or, at least that\'s how you feel. It\'s not impossible that this whole \\"conflict\\" or whatever was entirely of your imagination. It\'s not impossible that in reality, mom and dad are getting along perfectly right now. Maybe you\'re just getting anxious for no reason, like you usually do, getting worried about some remote possibilities."},{"type":"paragraph","content":"Or maybe not. You can\'t really tell."}]},"introspect_1.tina":{"id":"introspect_1.tina","goTo":[{"id":"introspect_1.name"}],"onArrival":[{"$code":"Q[\'first_name\'] = \\"Tina\\";"}],"content":{"content":"","type":"paragraph"}},"introspect_2.stop":{"id":"introspect_2.stop","content":{"content":"This is all a pointless exercise. You should be doing something productive with your time.","type":"paragraph"}},"miri_date.future_why":{"id":"miri_date.future_why","goTo":[{"id":"miri_date.miri_thinking"}],"content":[{"type":"paragraph","content":"\\"Um, why are you asking?\\""},{"type":"paragraph","content":"\\"I don\'t know...\\" Miri sighs. \\"It\'s... kind of weird. Sorry.\\""}]},"miri_pageant_prep.gym_continue":{"id":"miri_pageant_prep.gym_continue","content":[{"type":"paragraph","content":"You run on the treadmill for a while, then lift some weights at the machines, all the while not looking at anyone else, and acting confident, as if no one is looking at you, as if you\'re the only one here (and Miri of course)."},{"type":"paragraph","content":"You\'re not sure if you feel stronger at the end of thirty minutes. But based on most studies, your life expectancy, metabolism, mental health, and just about everything else should be improving given your exercise. Which is supposed to help with the pageant. Is that why you\'re here?"}]},"pageant_prep_self_2.fashion":{"id":"pageant_prep_self_2.fashion","onArrival":[{"$code":"Q[\'pageant_fashion\'] = (Q[\'pageant_fashion\'] || 0) + 1;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 1;"}],"maxVisits":1,"options":[{"id":"@pageant_prep_self_2.makeup","title":"Look up makeup tips."},{"id":"@pageant_prep_self_2.fashion","title":"Look up tips on clothes."},{"id":"@pageant_prep_self_2.body_language","title":"Look up tips on body language."},{"id":"@pageant_prep_pick_ball_gown","title":"Find a ball gown."},{"id":"@pageant_prep_try_ball_gown","title":"Try on the ball gown."},{"id":"@pageant_prep_self_2.pageant_prep_done","title":"That\'s enough for tonight."}],"content":{"content":[{"type":"paragraph","content":"Thank god there\'s no swimsuit competition. But it\'s bad enough as it is. There\'s an evening gown contest, an athletic wear portion, in addition to the dress you have to wear for the interview, and the talent outfit."},{"type":"paragraph","content":"You spend a couple of hours paging through Wikihow. How to pick your best color. How to choose dresses for a beauty pageant. And so on. The first thing you learn is how much you\'ve failed to learn. You read about undertones and color theory and how to match your skin tone and hair color and so on. Do all \\"normal\\" girls know this?"},{"type":"paragraph","content":{"type":"conditional","content":"Maybe Emily was right. Maybe fashion really is a science.","predicate":0}}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'emily\'] || 0) > 1);"}}]},"countVisitsMax":1},"pageant_final.dress":{"id":"pageant_final.dress","options":[{"id":"@pageant_final.emilys_dress","title":"Wear a dress you borrowed from Emily."},{"id":"@pageant_final.emilys_goodwill_dress","title":"Wear the dress that you bought with Emily at Goodwill."},{"id":"@pageant_final.moms_dress","title":"Wear one of mom\'s dresses."},{"id":"@pageant_final.bought_dress_red","title":"Wear the dress that you bought with mom."},{"id":"@pageant_final.bought_dress_green","title":"Wear the dress that you bought with mom."},{"id":"@pageant_final.bought_dress_purple","title":"Wear the dress that you bought with mom."}],"content":{"content":[{"type":"paragraph","content":"First of all, what are you wearing exactly? You have to be wearing a dress to show up. Not a ball gown, that\'s for a later stage, but a shorter dress. A normal dress, for the interview and everything besides the evening gown phase. What exactly is a normal dress, anyway?"},{"type":"paragraph","content":{"type":"conditional","content":"Maybe you should have actually bought a new dress for this occasion. Far too late for that now.","predicate":0}}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'shopping\'] || 0)===0);"}}]}},"pageant_meetup.listen":{"id":"pageant_meetup.listen","options":[{"id":"@pageant_meetup.ashley_speech","title":"The next speech..."}],"content":[{"type":"paragraph","content":"The regional pageant will take place on Saturday, January 17th. The winner and runner-up will get to compete at the state pageant in March, and the winner of that will compete at the national pageant in June."},{"type":"paragraph","content":"Next comes the discussion of the pageant mechanics. There are several components: evening gown, athletic wear, the interview, a talent show, and the platform. Each of these events is 20% of the final score."},{"type":"paragraph","content":"You know all of this already."}]},"research_4.smile":{"id":"research_4.smile","content":[{"type":"paragraph","content":"You can\'t help but crack a smile, before going back down to your seat."},{"type":"paragraph","content":"\\"Hey, that was good,\\" Stella says, patting you on the back."},{"type":"paragraph","content":"\\"Thanks.\\""},{"type":"paragraph","content":"The meeting continues: a couple of grad students are presenting on their research, which you don\'t really understand. You almost fall asleep, tired from last night. And then it\'s over and it\'s time for you to go home."},{"type":"paragraph","content":"But the positive feelings you\'ve gotten today could probably sustain you for a while. That\'s good, right?"}]},"research_4":{"id":"research_4","type":"scene","title":"Research","subtitle":"Your lab meeting","newPage":true,"viewIf":{"$code":"return (((((((Q[\'week\'] || 0) >= 1) && ((Q[\'week\'] || 0) < 10)) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'research\'] || 0)===3)) && ((Q[\'weekly_research\'] || 0)===0)) && ((Q[\'stress\'] || 0) < 15));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'research\'] = (Q[\'research\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'weekly_research\'] = 1;"}],"tags":["top","research"],"options":[{"id":"@research_4.what","title":"What even is your work, though?"}],"content":{"content":"Today is the lab meeting. Professor Chen has asked you to make a presentation, talking about your work.","type":"paragraph"}},"research_6.emily_call":{"id":"research_6.emily_call","options":[{"id":"@research_6.youre_welcome","title":"\\"Um... You\'re welcome?\\""}],"content":{"content":"Emily: \\"Thanks. You saved my life.\\"","type":"paragraph"}},"research_final.thats_a_lie":{"id":"research_final.thats_a_lie","options":[{"id":"@research_final.nice_thought","title":"That\'s a nice thought..."},{"id":"@research_final.unrealistic","title":"It\'s still unrealistic..."},{"id":"@research_final.jobs_in_science","title":"Are there even jobs in science?"}],"content":[{"type":"paragraph","content":"\\"I mean, the admissions rates are so low and there are so many amazing people applying so...\\" You shrug. \\"And I haven\'t even taken my SATs yet.\\""},{"type":"paragraph","content":"\\"I think you could be a great scientist no matter where you go,\\" Stella says. \\"As long as you keep your focus.\\""}]},"scioly_invitational.fossils_roxana":{"id":"scioly_invitational.fossils_roxana","viewIf":{"$code":"return ((Q[\'roxana_seen\'] || 0)===1);"},"options":[{"id":"@scioly_invitational.fossils_good","title":"Well."},{"id":"@scioly_invitational.fossils_okay","title":"Fine."},{"id":"@scioly_invitational.fossils_bad","title":"Semi-adequately."}],"content":[{"type":"paragraph","content":"Fossils is a test-only event, where you rotate around various stations that involve fossil identification as well as background questions."},{"type":"paragraph","content":"Roxana arrives shortly after you, sitting next to you with a brief wave and a barely noticeable smile. \\"Are you ready?\\", they ask. All you can really do is shrug."},{"type":"paragraph","content":"The test goes..."}]},"shopping_with_mom.dont_buy_high_heels":{"id":"shopping_with_mom.dont_buy_high_heels","goTo":[{"id":"shopping_with_mom.ball_gown"}],"content":[{"type":"paragraph","content":"You have some fancy-looking flats at home. They\'ll be fine. Right?"},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Do you really not want high-heel shoes? After the"}," pageant ",{"type":"emphasis-1","content":"you might still need them.\\""},""]},{"type":"paragraph","content":{"type":"emphasis-1","content":"\\"Really.\\""}}]},"research_1.other":{"id":"research_1.other","goTo":[{"id":"research_1.end"}],"content":[{"type":"paragraph","content":"\\"Um, I sort of want to, you know, do more wet lab type stuff.\\""},{"type":"paragraph","content":"Stella chuckles. \\"Yeah, everyone does. If you do well on this project we\'ll see what you can do next.\\""}]},"skip.w5_emily_1":{"id":"skip.w5_emily_1","onArrival":[{"$code":"Q[\'emily\'] = 4;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 2;"}],"goTo":[{"id":"skip.w5_miri_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.wallow":{"id":"scioly_study_party.wallow","options":[{"id":"@scioly_study_party.breakdown","title":"Have a mental breakdown."}],"content":[{"type":"paragraph","content":"There is no better place to wallow than the corner of a basement in a quasi-acquaintance\'s house. This is your pigsty. Your pool of mud. And you\'re gonna roll in it like... whatever a pig is like when it rolls in a pool of mud."},{"type":"paragraph","content":"And there is no better time to wallow than during a Science Olympiad study party. You can\'t focus. You can\'t concentrate on studying, and you can\'t bring yourself to join any of the groups that are engrossed in their studying/non-studying activities."},{"type":"paragraph","content":"You never feel more alone than when you\'re at a party."}]},"thanksgiving_party.say_hi":{"id":"thanksgiving_party.say_hi","viewIf":{"$code":"return ((Q[\'emily\'] || 0) < 4);"},"onArrival":[{"$code":"Q[\'meet_emily\'] = 0;"}],"options":[{"id":"@thanksgiving_party.wait","title":"You\'re sure you know this person."},{"id":"@thanksgiving_party.homework","title":"\\"Can I do my homework here?\\""},{"id":"@thanksgiving_party.just_do_homework","title":"Just start doing your homework."}],"content":[{"type":"paragraph","content":"\\"Um. Hi,\\" you manage to say."},{"type":"paragraph","content":"He stares at you for a second before turning around and sitting back at his chair, fiddling with his computer. \\"Sorry for the mess. Sit down anywhere.\\""},{"type":"paragraph","content":"You sit down on the carpet. A long moment of silence passes between the two of you, punctuated only by the tapping of the keyboard."}]},"scioly_2.a2":{"id":"scioly_2.a2","goTo":[{"id":"scioly_2.wrong_study"}],"content":{"content":"","type":"paragraph"}},"scioly_final.take_time":{"id":"scioly_final.take_time","goTo":[{"id":"scioly_final.scioly_end"}],"content":[{"type":"paragraph","content":"\\"Um, can I think about it for a bit?\\""},{"type":"paragraph","content":"\\"Sure, you have a week to think about it,\\" the captain says. \\"I\'ll ask you again then.\\""}]},"1.intro3":{"id":"1.intro3","content":[{"type":"paragraph","content":"There\'s not a long time to prepare, just three months. In that time you\'ll have to become a new person, become the metaphorical butterfly breaking out of its cocoon, the metaphorical ugly duckling transformed into the beautiful swan. Or something like that."},{"type":"paragraph","content":"You sign the documents. Maybe part of you hopes that they\'ll forget to send the letter, that the post office would lose it, that the registration deadline\'s already passed. But you know that your fate is sealed."},{"type":"paragraph","content":"Tomorrow is a school day. There\'s no time to rest: go back to your room, do as much of your homework as you can, and hope for the best."}]},"aubrey_final.sorry":{"id":"aubrey_final.sorry","options":[{"id":"@aubrey_final.back_to_present","title":"Back to the present..."}],"content":[{"type":"paragraph","content":"\\"Um, sorry...\\""},{"type":"paragraph","content":"\\"No, what are you sorry for? Stop saying sorry.\\" Her voice sounded exasperated."},{"type":"paragraph","content":"\\"Um, okay...\\""},{"type":"paragraph","content":"\\"Let\'s just, like, have fun,\\" Aubrey said, as if she did not know what \'fun\' meant at that particular time."}]},"birthday.aubrey_party_2":{"id":"birthday.aubrey_party_2","options":[{"id":"@birthday.aubrey_party_3","title":"...What?"}],"content":[{"type":"paragraph","content":"\\"Um...\\""},{"type":"paragraph","content":"Aubrey sits down on the couch. \\"Sorry. Is this awkward?\\""},{"type":"paragraph","content":"\\"Yeah...\\""},{"type":"paragraph","content":"\\"Did your parents force you to invite me?\\""},{"type":"paragraph","content":"\\"Not really... sort of...\\""},{"type":"paragraph","content":"\\"Ugh. Well, if you want me to leave,-\\""},{"type":"paragraph","content":"\\"No! I, uh, enjoy your company and appreciate you as a human being. Or like... yeah.\\" You can\'t help but cringe a little. God, you sound like such a failure."},{"type":"paragraph","content":"Aubrey smiles. \\"So you like me after all?\\""}]},"christmas_party.stare_back":{"id":"christmas_party.stare_back","viewIf":{"$code":"return ((Q[\'stared_emily\'] || 0)===1);"},"options":[{"id":"@christmas_party.follow_emily","title":"Follow Emily?"}],"content":[{"type":"paragraph","content":"You return her look, with what you imagine is a conspiratorial expression. She keeps her usual blank look, but says, \\"Could we take a break and talk for a bit?\\""},{"type":"paragraph","content":"Aubrey looks at the two of you. \\"Uh, okay,\\" she says."}]},"church_1.bible_study_2":{"id":"church_1.bible_study_2","content":[{"type":"paragraph","content":"It seems like forever before the meeting adjurns. The adults go back to chatting and gossiping. Some of them start to filter out of the house. Mom calls your brother up from downstairs, and you to pick up the empty pot. Her soup is always welcomed at these meetings. Dad comes back from a porchside conversation/cigarette-smoking session with some of the other dads. Mom glares at him. She coughs at the smell of smoke. Dad sighs. Aubrey comes back upstairs and waves at you as she leaves. You wave back. She smiles at you. You smile back, or at least try to."},{"type":"paragraph","content":"Soon your family decides to leave. The four of you get back into the 1999 Toyota Camry and drive home."}]},"church_3.silence":{"id":"church_3.silence","options":[{"id":"@church_3.scream","title":"Suddenly you hear your brother\'s scream."}],"content":{"content":"You sit down on some couch. You have homework. You should do your homework. That\'s important or urgent or something like that. The easiest part of your homework is a Calc problem set. So you get started. It\'s hard to work, with all the children running around. The basement is large enough that they can play hide and go seek. Some adults shout that it\'s dangerous, but the children don\'t listen.","type":"paragraph"}},"church_3":{"id":"church_3","type":"scene","title":"Bible Study","subtitle":"The Zhou household","viewIf":{"$code":"return (((Q[\'church\'] || 0)===2) && ((Q[\'week\'] || 0)===5));"},"onArrival":[{"$code":"Q[\'church\'] = (Q[\'church\'] || 0) + 1;\\nQ[\'aubrey\'] = (Q[\'aubrey\'] || 0) + 1;"}],"tags":["weekend"],"options":[{"id":"@church_3.join_singing","title":"Join the singing."},{"id":"@church_3.no_sing","title":"Go back downstairs."}],"content":[{"type":"paragraph","content":"The gathering this week is at the Zhou household. The mom is an engineer, and the dad works in biomedical research. They have two young children, one girl your brother\'s age, and another girl barely a year old."},{"type":"paragraph","content":"Like every other week, there\'s a potluck meal, and with the other children (and Aubrey and Spencer), you grab your food and eat in the basement. After you finish eating, you carry your empty plate back upstairs. Aubrey follows. The adults are starting to sing church songs, as Aubrey\'s dad plays the piano. Your brother is sitting with mom."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Sing with us!\\""}," one of the adults calls out to the two of you."]},{"type":"paragraph","content":"Aubrey looks at you and shrugs. \\"Alright. Fine.\\" She goes to join them."}]},"classes_1.step3":{"id":"classes_1.step3","options":[{"id":"@classes_1.appearance","title":"Appearance"},{"id":"@classes_1.interview","title":"Interview"},{"id":"@classes_1.platform_1","title":"Platform"}],"content":[{"type":"paragraph","content":"\\"Okay, so, um, what\'s next?\\", you ask."},{"type":"paragraph","content":"\\"I don\'t know.\\" Miri looks into your eyes again (why does she do that?), and you look away again. \\"What more do you want to do? Like, out of all the things that you need for the pageant, what\'s the most important to improve?\\""}]},"emily_1.too_weird":{"id":"emily_1.too_weird","options":[{"id":"@emily_1.a_little_weird","title":"\\"It\'s a little weird, but...\\""},{"id":"@emily_1.not_weird","title":"\\"It\'s okay...\\""},{"id":"@emily_1.leave_for_real","title":"\\"Sorry but I have to go...\\""}],"content":{"content":"Maybe it\'s time for you to leave. Not so much because Emily is weird, but because of the awkwardness of the interaction. But is it really much more awkward than usual, and wouldn\'t you be making things more awkward by packing up and leaving before your pageant discussion has really begun?","type":"paragraph"}},"emily_2.looking_forward":{"id":"emily_2.looking_forward","content":[{"type":"paragraph","content":"Oh god is she your friend now?"},{"type":"paragraph","content":"You\'re not sure, and you\'re not sure whether you want her to be."}]},"emily_4.do_not_want":{"id":"emily_4.do_not_want","content":[{"type":"paragraph","content":"If you put your mind to it, you could think of a multitude of reasons why you shouldn\'t like Emily Chen. But do you really want to do that? Do you actually dislike Emily or... or are you just afraid of getting closer to her? But why would you be afraid of that?"},{"type":"paragraph","content":"Anyway it\'s pointless to think about these things. You have homework to do."}]},"emily_6.worries_2":{"id":"emily_6.worries_2","options":[{"id":"@emily_6.yeah_secret","title":"Yeah..."}],"content":[{"type":"paragraph","content":"You want to say something, but you don\'t know what to say. Story of your life, really."},{"type":"paragraph","content":"You wish that you had the words to make sense of yourself, to be able to communicate the tangled mess of cognition that you experience during the sequence of awkward moments that comprise your life. But you can\'t. Not even with Emily."},{"type":"paragraph","content":"\\"I won\'t hate you,\\" Emily says in a voice barely above a whisper. \\"No matter what you say.\\""},{"type":"paragraph","content":"\\"Seriously? No matter what I say? So if I say that...\\""},{"type":"paragraph","content":"Emily derails your train of thought with a chuckle. \\"Don\'t take that completely literally.\\" A pause. \\"So was that your secret?\\""}]},"emily_7.wipe_away":{"id":"emily_7.wipe_away","content":{"content":"At home, you make a conscious effort to avoid presenting any gesture of what has transpired. It seems to work. No one says a thing.","type":"paragraph"}},"emily_final.wait":{"id":"emily_final.wait","options":[{"id":"@emily_final.say_something","title":"Say something?"},{"id":"@emily_final.stay_silent","title":"Stay silent?"}],"content":[{"type":"paragraph","content":"You watch the lights go by before the train plunges underground."},{"type":"paragraph","content":"Emily is in the train station, sitting alone on a bench with her head bowed. She wears her usual all-black outfit with a black overcoat, and carries a stuffed backpack."},{"type":"paragraph","content":"\\"Hey, um, Emily?\\", you manage to say, barely aloud. She somehow hears you."},{"type":"paragraph","content":"\\"Yeah. That\'s me. Sorry I made you come all the way out here.\\" She lifts her head and glances at you. You sit down next to her, not too close, but not too far. She is silent for a while. When you glance at her face, you see a few streaks of tears. She covers her face with her hands."}]},"epilogue.ep_emily_acquaintance":{"id":"epilogue.ep_emily_acquaintance","maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"viewIf":{"$code":"return (((Q[\'emily\'] || 0) < 8) && ((Q[\'emily_date\'] || 0)===0));"},"content":{"content":{"type":"paragraph","content":["Ever since the pageant ended, there hasn\'t been much of an excuse for Emily and you to connect. And so you\'re slowly but surely drifting apart. ",{"type":"conditional","content":"Even though she could probably help you prepare for the state pageant, it\'s been difficult to bring yourself to reach out to her, and she\'s been more reticent about reaching out to you.","predicate":0}]},"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_success\'] || 0)===1);"}}]},"countVisitsMax":1},"family_6.eat_2":{"id":"family_6.eat_2","options":[{"id":"@family_6.home_eventually","title":"Eventually you end up back home."}],"content":[{"type":"paragraph","content":"Anyway, waiting is all you can do."},{"type":"paragraph","content":"The waiter returns with all four dishes. The sandwich is okay, not the best but not the worst. A little soggy but that\'s fine. You\'ll be fine. One bite after another. The silence continues."},{"type":"paragraph","content":"Everything is fine. Everything is going to be fine."}]},"introspect_1.vivian":{"id":"introspect_1.vivian","goTo":[{"id":"introspect_1.name"}],"onArrival":[{"$code":"Q[\'first_name\'] = \\"Vivian\\";"}],"content":{"content":"","type":"paragraph"}},"introspect_2.end":{"id":"introspect_2.end","content":{"content":"You should be doing something productive with your time, not wasting it on self-centered introspection.","type":"paragraph"}},"introspect_2":{"id":"introspect_2","type":"scene","title":"Introspection","subtitle":"Progress check","newPage":true,"viewIf":{"$code":"return ((((((Q[\'week\'] || 0) >= 4) && ((Q[\'week\'] || 0) <= 6)) && ((Q[\'introspection\'] || 0)===1)) && ((((((Q[\'pageant_prep\'] || 0) >= 2) || ((Q[\'scioly\'] || 0) >= 2)) || ((Q[\'research\'] || 0) >= 2)) || ((Q[\'family\'] || 0) >= 2)))) && ((Q[\'week_progress\'] || 0) < 3));"},"onArrival":[{"$code":"Q[\'introspection\'] = (Q[\'introspection\'] || 0) + 1;"}],"priority":2,"tags":["top","introspect"],"maxVisits":1,"options":[{"id":"@introspect_2.pageant","title":"Think about the pageant."},{"id":"@introspect_2.research","title":"Think about research."},{"id":"@introspect_2.scioly","title":"Think about science olympiad."},{"id":"@introspect_2.people","title":"Think about the people you know."},{"id":"@introspect_2.self","title":"Think about yourself."}],"content":{"content":"","type":"paragraph"},"countVisitsMax":1},"miri_date.miri_thinking":{"id":"miri_date.miri_thinking","options":[{"id":"@miri_date.unable_to_provide","title":"You are unable to comfort anyone..."},{"id":"@miri_date.can_try","title":"But you can try...?"},{"id":"@miri_date.sorry","title":"\\"Um, sorry...\\""}],"content":[{"type":"paragraph","content":"\\"There\'s a part of me that\'s terrified of the future,\\" she continues. \\"Like, I just feel like everything\'s getting more and more horrible. Like, there\'s all the suffering going on in the world, with climate change and wars and people dying for no reason and... And what am I supposed to do? Like, God, I just don\'t know and that\'s terrifying.\\""},{"type":"paragraph","content":"She turns to you, as if expecting something. \\"God, this is a terrible way to start a first date. This is a first date, right?\\""},{"type":"paragraph","content":"Does she want to be comforted right now? Or..."}]},"miri_pageant_prep.practice":{"id":"miri_pageant_prep.practice","viewIf":{"$code":"return ((Q[\'miri_practice\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'miri_practice\'] = (Q[\'miri_practice\'] || 0) + 1;"}],"options":[{"id":"@miri_pageant_prep.oh_god","title":"\\"Oh God. Uh...\\""},{"id":"@miri_pageant_prep.good_answer","title":"\\"Well, that\'s a good question...\\""},{"id":"@miri_pageant_prep.perfect_answer","title":"\\"Both academics and extracurriculars are important to me...\\""}],"content":{"content":[{"type":"paragraph","content":["The score sheet says that interviews count for exactly 20% of the final score. ",{"type":"conditional","content":"Based on your current condition, you might be able to get... maybe 1%. ","predicate":0},{"type":"conditional","content":"You\'ve done a little bit of practicing, but probably not enough. ","predicate":1},""]},{"type":"paragraph","content":"Miri sits at a park bench, while you pace around. She reads from her phone."},{"type":"paragraph","content":"\\"Question 1: How would you balance academics and extracurricular activities if you were to win this title?\\""}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_interview\'] || 0)===0);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_interview\'] || 0) > 0);"}}]}},"pageant_prep_self_2.body_language":{"id":"pageant_prep_self_2.body_language","maxVisits":1,"onArrival":[{"$code":"Q[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 1;\\nQ[\'pageant_body_language\'] = (Q[\'pageant_body_language\'] || 0) + 1;"}],"options":[{"id":"@pageant_prep_self_2.makeup","title":"Look up makeup tips."},{"id":"@pageant_prep_self_2.fashion","title":"Look up tips on clothes."},{"id":"@pageant_prep_self_2.body_language","title":"Look up body language."},{"id":"@pageant_prep_pick_ball_gown","title":"Find a ball gown."},{"id":"@pageant_prep_try_ball_gown","title":"Try on the ball gown."},{"id":"@pageant_prep_self_2.pageant_prep_done","title":"That\'s enough for tonight."}],"content":[{"type":"paragraph","content":"There is an unsourced internet statistic going around stating that 70 to 90 percent of human communications is nonverbal. Nonverbal communication is, unfortunately, one of the primary determinants of your success or failure on the pageant. And you\'re terrible at it."},{"type":"paragraph","content":"There are video tutorials on this, women telling you how to look at the judges, how to smile, how to comport and contort yourself on stage. There are wikihow tutorials on this, presenting the same information but in textual format."},{"type":"paragraph","content":"You try to absorb this information. It\'s hard without practice, and it\'s hard to practice while sitting at your desk in your cramped room."}],"countVisitsMax":1},"pageant_final.emilys_dress":{"id":"pageant_final.emilys_dress","onArrival":[{"$code":"Q[\'pageant_dress\'] = 1;"}],"goTo":[{"id":"pageant_final.pick_evening_dress"}],"content":{"content":"Emily has lent you a black cocktail dress for the interview. You\'re not sure if it works with your aesthetic, but at least it fits surprisingly well.","type":"paragraph"}},"pageant_meetup.tune_out":{"id":"pageant_meetup.tune_out","options":[{"id":"@pageant_meetup.ashley_speech","title":"The next speech..."}],"content":{"content":"From the sound of it, you know everything she\'s going to say already. So why bother listening? After all, you\'re much better at assimilating information when it comes in the form of written words, and all this information should be online anyways.","type":"paragraph"}},"research_6.youre_welcome":{"id":"research_6.youre_welcome","options":[{"id":"@research_6.smiley_face","title":"smiley face?"}],"content":[{"type":"paragraph","content":"You: \\"Um... You\'re welcome?\\""},{"type":"paragraph","content":"Emily: \\"He\'s been talking forever about how I should be more like you. Be more tinghua and guai and all that shit.\\""},{"type":"paragraph","content":"Emily: \\"Basically don\'t be a f-word but in a lot more words and also in Chinese.\\""},{"type":"paragraph","content":"Emily: \\"I mean you kinda threw him off a little. So I had a reprieve. Briefly. Thanks.\\""},{"type":"paragraph","content":"You have no idea how to reply."}]},"research_final.you_wish":{"id":"research_final.you_wish","options":[{"id":"@research_final.nice_thought","title":"That\'s a nice thought, but..."},{"id":"@research_final.unrealistic","title":"It\'s rather unrealistic..."},{"id":"@research_final.jobs_in_science","title":"Are there even jobs in science?"}],"content":[{"type":"paragraph","content":"\\"Really? You think so?\\""},{"type":"paragraph","content":"\\"Yeah, I think so! But even if you don\'t, I think you could be a great scientist no matter where you end up.\\""}]},"scioly_invitational.fossils_good":{"id":"scioly_invitational.fossils_good","viewIf":{"$code":"return ((Q[\'fossils\'] || 0) >= 2);"},"options":[{"id":"@scioly_invitational.lunch","title":"Next is lunch break."}],"content":{"content":"It went well, you think. Your partner turns out to be quite the expert at fossil identification as well as a lot of the background questions, but you managed to fill in all the gaps. You were adequately prepared and all that.","type":"paragraph"}},"shopping_with_mom.ball_gown":{"id":"shopping_with_mom.ball_gown","options":[{"id":"@shopping_with_mom.makeup","title":"Next is makeup."},{"id":"@shopping_with_mom.makeup_emily","title":"Next is makeup."}],"content":[{"type":"paragraph","content":"Next, you need to find a ball gown. This is kind of the centerpiece of the pageant, so it\'s kind of a big deal."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Could we borrow one?\\""},", you ask."]},{"type":"paragraph","content":["Mom looks contemplative for a moment. ",{"type":"emphasis-1","content":"\\"Fine. I\'ll ask my friends. Some of them will have one for sure.\\""},""]},{"type":"paragraph","content":"You meant borrowing one from a store, like the ones that rent prom dresses or whatever. But that works too, and is way cheaper."},{"type":"paragraph","content":"Now all of the big clothing items are out of the way..."}]},"research_1.reconsider":{"id":"research_1.reconsider","goTo":[{"id":"research_1.end"}],"content":[{"type":"paragraph","content":"\\"Um, I don\'t know...\\""},{"type":"paragraph","content":"Stella smiles, somehow sensing your nervousness. \\"It\'s fine. Everyone has a rough start in science. But we\'ll make it though, okay?\\""}]},"skip.w5_emily_3":{"id":"skip.w5_emily_3","onArrival":[{"$code":"Q[\'emily\'] = 1;"}],"goTo":[{"id":"skip.w5_miri_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.breakdown":{"id":"scioly_study_party.breakdown","onArrival":[{"$code":"Q[\'trauma_points\'] = (Q[\'trauma_points\'] || 0) + 1;"}],"options":[{"id":"@scioly_study_party.shouldnt_have_come","title":"You shouldn\'t have come."}],"content":[{"type":"paragraph","content":"You should have known this moment was coming."},{"type":"paragraph","content":"It\'s as if the energy of the party is becoming a miasma, choking the air out of you. The voices grow more obnoxious, the shuffling and laughter turn to poison within your brain. You try to shut it out. It doesn\'t work. The miasma pervades you, invades your mind, stifles your thoughts, turns everything you perceive against yourself."}]},"thanksgiving_party.homework_emily":{"id":"thanksgiving_party.homework_emily","options":[{"id":"@thanksgiving_party.do_homework","title":"Do your homework."},{"id":"@thanksgiving_party.talk_emily_2","title":"Talk to Emily."}],"content":[{"type":"paragraph","content":"You sit down on the carpet, as Emily sits at her desk. Her computer is on, and it looks like she\'s typing some sort of essay."},{"type":"paragraph","content":"\\"Don\'t tell anyone, okay?\\", she reiterates."},{"type":"paragraph","content":"\\"Of course.\\""},{"type":"paragraph","content":"You unzip your backpack and take out your textbook. The assignment is just to read the relevant chapters of the textbook and answer a few basic questions on them. Maybe you\'ll get something done after all."}]},"scioly_2.a3":{"id":"scioly_2.a3","goTo":[{"id":"scioly_2.wrong_study"}],"content":{"content":"","type":"paragraph"}},"scioly_final.of_course_not":{"id":"scioly_final.of_course_not","goTo":[{"id":"scioly_final.scioly_end"}],"content":[{"type":"paragraph","content":"\\"Um, is it okay if I don\'t run for captain?\\""},{"type":"paragraph","content":"\\"It\'s okay, but I want you to think about it,\\" the captain says. \\"The deadline for entering is in a week. I\'ll ask you again then.\\""}]},"aubrey_final.back_to_present":{"id":"aubrey_final.back_to_present","options":[{"id":"@aubrey_final.date_good","title":"\\"It was... good?\\""},{"id":"@aubrey_final.date_alright","title":"\\"It was... okay?\\""},{"id":"@aubrey_final.date_um","title":"\\"Umm...\\""}],"content":[{"type":"paragraph","content":"So the two of you wandered around downtown, dodging crowds of tourists and workers. There was no direction or goal. She led, and you followed, for the most part. You bumped into each other a few times. There was not much in the way of conversation. Just small talk, or something like that."},{"type":"paragraph","content":"And now she\'s sitting with you on a concrete bench in a Brutalist plaza. The sun is disappearing behind the buildings, and people walk all around you, most paying you no mind."},{"type":"paragraph","content":"So, how was the date, Aubrey asked. How was it?"}]},"birthday.aubrey_party_3":{"id":"birthday.aubrey_party_3","options":[{"id":"@birthday.aubrey_party_4","title":"It\'s an AP Chem study book."}],"content":[{"type":"paragraph","content":"\\"What?\\""},{"type":"paragraph","content":"\\"\\"Never mind,\\" she says. \\"Let\'s just hang out here. A study birthday party?\\" She laughs. \\"I brought my chem homework. Do you want to work on that?\\""},{"type":"paragraph","content":"\\"Uh, sure.\\" This has to be the most Asian thing you\'ve ever done."},{"type":"paragraph","content":"So the two of you work on AP chem homework. It might be the best way of interhuman bonding for people like you. Or something like that."},{"type":"paragraph","content":"\\"Before I forget, happy birthday! Believe it or not, I got a present before I came here. Actually my mom bought it, but hey!\\""}]},"christmas_party.follow_emily":{"id":"christmas_party.follow_emily","options":[{"id":"@christmas_party.why_come_out","title":"\\"Why?\\""}],"content":[{"type":"paragraph","content":"\\"I\'m feeling inclined to do something foolish and potentially dangerous,\\" she says once you\'re in an abandoned alcove. \\"In other words, help me out here.\\""},{"type":"paragraph","content":"\\"What are you about to do?\\""},{"type":"paragraph","content":"\\"Come out to Aubrey.\\""},{"type":"paragraph","content":"\\"Oh.\\""}]},"church_1.downstairs":{"id":"church_1.downstairs","options":[{"id":"@church_1.talk","title":"Talk to Aubrey?"},{"id":"@church_1.wait","title":"Just eat? And wait?"}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"I\'ll eat downstairs,\\""}," you say, and head back to the basement."]},{"type":"paragraph","content":"You, Aubrey, and Spencer eat in silence, while some of the kids play around. Spencer looks at his cell phone. All the while you\'re next to Aubrey, but you don\'t say much. As usual. But..."}]},"classes_1.appearance":{"id":"classes_1.appearance","onArrival":[{"$code":"Q[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 1;"}],"goTo":[{"id":"classes_1.next"}],"content":[{"type":"paragraph","content":"\\"Like everyone says it\'s about character, but obviously the beauty parts are most important. Like even if I were the most eloquent girl in the world there\'d be no chance if I came in looking like this.\\""},{"type":"paragraph","content":"Miri smiles. \\"Good for being realistic. Though, um, you\'ll probably have to talk to someone other than me if you want help with that.\\""}]},"emily_1.leave_for_real":{"id":"emily_1.leave_for_real","onArrival":[{"$code":"Q[\'emily_left_1\'] = 1;"}],"content":[{"type":"paragraph","content":"\\"Um, sorry but,... I have to go right now,\\" you say."},{"type":"paragraph","content":"Emily barely looks up from her drink. \\"Oh. Alright then. Sorry if I was being kind of weird.\\""},{"type":"paragraph","content":"You wave and take your leave."}]},"emily_2.not_looking_forward":{"id":"emily_2.not_looking_forward","content":[{"type":"paragraph","content":"She\'s not exactly your friend, barely an acquaintance."},{"type":"paragraph","content":"But still..."}]},"emily_2":{"id":"emily_2","type":"scene","title":"Meeting with Emily","subtitle":"Goodwill, Afternoon","newPage":true,"viewIf":{"$code":"return (((((Q[\'emily\'] || 0)===2) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'stress\'] || 0) < 15)) && ((Q[\'thanksgiving\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'emily\'] = (Q[\'emily\'] || 0) + 1;\\nQ[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 2;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'emily_2_seen\'] = 1;"}],"tags":["top","social"],"options":[{"id":"@emily_2.try","title":"Try them on."},{"id":"@emily_2.else","title":"Do something else."}],"content":{"content":[{"type":"paragraph","content":"\\"Okay, so, you need at least two dresses just for the pageant, but it would be better if you had more. Dresses are nice. I like dresses.\\""},{"type":"paragraph","content":[{"type":"conditional","content":"Despite your awkward departure last time, you responded when she asked if you could meet again. And now you\'re here, shopping for dresses that you could use at the pageant. ","predicate":0},""]},{"type":"paragraph","content":"Emily says that she buys all her clothes at Goodwill, which is why she wanted to meet you here. She looks like she\'s within her element, as she flits from dingy aisle to dingy aisle, brushing her hand against clothes and adding them to the pile on her arm."},{"type":"paragraph","content":"\\"Here. Try these on.\\" She shoves a few dresses at you."}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'emily_left_1\'] || 0)===1);"}}]}},"emily_4.walk":{"id":"emily_4.walk","options":[{"id":"@emily_4.respond","title":"Respond."},{"id":"@emily_4.silent","title":"Stay silent."}],"content":[{"type":"paragraph","content":"The sun is still out, just barely, peaking over the buildings to the west. You have homework to do, but being around Emily feels more important right now."},{"type":"paragraph","content":"She walks quickly, head held high, staring straight ahead. Meanwhile you try to avoid slouching, and walk faster to keep up with her. She must have noticed, and slows down."},{"type":"paragraph","content":"\\"Did you know that I practiced walking?\\", Emily says."},{"type":"paragraph","content":"\\"Oh.\\""},{"type":"paragraph","content":"\\"It\'s all an act. Everything I do is fake. Did you know that?\\""},{"type":"paragraph","content":"\\"No...\\""},{"type":"paragraph","content":"\\"Well, it\'s true.\\""}]},"emily_6.yeah_secret":{"id":"emily_6.yeah_secret","options":[{"id":"@emily_6.emily_parents","title":"Sit and wait."}],"content":[{"type":"paragraph","content":"\\"Um, yeah, I guess. Sorry, I didn\'t know what I was going to say.\\""},{"type":"paragraph","content":"\\"No, that\'s fine...\\""},{"type":"paragraph","content":"The conversation is dead, and you have killed it. Now Emily sits in silence, watching the cars go by. You do much the same, sometimes taking passing looks at her."}]},"emily_7.not_say":{"id":"emily_7.not_say","options":[{"id":"@emily_7.silence","title":"No."},{"id":"@emily_7.say_out_loud","title":"Yes."}],"content":{"content":"Do you want to actually say that out loud?","type":"paragraph"}},"emily_final.say_something":{"id":"emily_final.say_something","goTo":[{"id":"emily_final.stay_silent"}],"content":{"content":"You have no idea what to say.","type":"paragraph"}},"epilogue.ep_miri_date_done":{"id":"epilogue.ep_miri_date_done","maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"viewIf":{"$code":"return ((Q[\'miri_date\'] || 0) >= 2);"},"content":{"content":"You\'re now officially dating Miri Brooks. She\'s your girlfriend, and you\'re hers. It\'s still a little weird to think of your relationship like that. You\'ve become more comfortable around her, physically as well as emotionally. Sometimes you even hold hands in school, or while walking ouside during the day. You\'re still scared when she does that, and you haven\'t told your parents, but things are going good. Probably.","type":"paragraph"},"countVisitsMax":1},"family_6.home_eventually":{"id":"family_6.home_eventually","options":[{"id":"@family_6.finally_alone","title":"Finally you\'re alone."}],"content":[{"type":"paragraph","content":"And then, after approximately an hour of awkwardness, it\'s over. Pack back into the car. Drive home."},{"type":"paragraph","content":"No conversations. Everyone\'s tired (you think; you can\'t really tell). It\'s after 9pm when you end up back in the apartment."},{"type":"paragraph","content":["\\"睡觉吧。 ",{"type":"emphasis-1","content":"Go to sleep"},"\\", mom tells you and Kevin. Then mom and dad retreat into their room. Kevin is sleeping in yours again tonight. You turn off the lights, and take out your laptop under the sheets. Kevin turns away."]}]},"introspect_1.name":{"id":"introspect_1.name","options":[{"id":"@introspect_1.gay","title":"And by the way, you\'re gay."}],"content":{"content":[{"type":"paragraph","content":[{"type":"conditional","content":["Right, your English name is ",{"type":"insert","insert":1}],"predicate":0},"."]},{"type":"paragraph","content":["Your name was assigned back in Changchun, Jilin Province, People\'s Republic of China, the city where you were born. On the first day of English class, the teacher had each kid pick out a name from a box. Yours was ",{"type":"insert","insert":2},"."]},{"type":"paragraph","content":"And somehow that name stuck as your family moved to America. First, it was to Los Angeles, when you were 7. Then, a couple of years later, your family moved to Illinois in pursuit of dad\'s career. A couple of years after that, you moved to Massachussetts, where you are now. You\'re 16 years old, a junior in high school, finally rooted in the same place after four different elementary schools, and a top 10-ranked AP student, wanting to but probably never going to MIT, and putative hypothetical beauty queen."}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return (Q[\'first_name\'] != \\"Karen\\");"}},{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}},{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"miri_date.unable_to_provide":{"id":"miri_date.unable_to_provide","options":[{"id":"@miri_date.wait","title":"Wait. You don\'t know what to do."},{"id":"@miri_date.can_try","title":"But you can try...?"}],"content":{"content":"You\'ve never been good at the whole \\"showing compassion\\" thing. At least visibly. You always come off as somewhat insincere, regardless of your actual feelings.","type":"paragraph"}},"miri_pageant_prep.practice_2":{"id":"miri_pageant_prep.practice_2","viewIf":{"$code":"return ((Q[\'miri_practice\'] || 0) > 0);"},"onArrival":[{"$code":"Q[\'miri_practice\'] = (Q[\'miri_practice\'] || 0) + 1;"}],"options":[{"id":"@miri_pageant_prep.good_answer","title":"\\"Well, that\'s a good question...\\""},{"id":"@miri_pageant_prep.perfect_answer","title":"\\"Both academics and extracurriculars are important to me...\\""}],"content":[{"type":"paragraph","content":"\\"Question 1: How would you balance academics and extracurricular activities if you were to win this title?\\""},{"type":"paragraph","content":"\\"Didn\'t you ask this question last time?\\""},{"type":"paragraph","content":"\\"Yeah. Answer it again.\\""}]},"pageant_prep_self_2.social":{"id":"pageant_prep_self_2.social","subtitle":"Search for interview questions to practice.","onArrival":[{"$code":"Q[\'pageant_interview\'] = (Q[\'pageant_interview\'] || 0) + 1;"}],"options":[{"id":"@pageant_prep_self_2.social_practice","title":"Practice."}],"content":[{"type":"paragraph","content":"You start watching videos of \\"epic fails\\" in the interviews: women tripping over their words, repeating themselves, making vaguely banal remarks. You skip the homophobic ones because you wouldn\'t be able to resist looking at the comments."},{"type":"paragraph","content":"Unfortunately, it\'s obvious that you\'d do worse than any of them, if you were able to come up with words at all."}]},"pageant_final.emilys_goodwill_dress":{"id":"pageant_final.emilys_goodwill_dress","onArrival":[{"$code":"Q[\'pageant_dress\'] = 2;"}],"viewIf":{"$code":"return ((Q[\'has_emily_goodwill_dress\'] || 0)===1);"},"goTo":[{"id":"pageant_final.pick_evening_dress"}],"content":{"content":"At Goodwill with Emily, you acquired a deep blue dress. It seems a bit plain, but it\'ll have to do.","type":"paragraph"}},"pageant_meetup.look_at_emily":{"id":"pageant_meetup.look_at_emily","viewIf":{"$code":"return ((Q[\'sit_emily\'] || 0)===1);"},"options":[{"id":"@pageant_meetup.ashley_speech","title":"The next speech..."}],"content":[{"type":"paragraph","content":"You glance over at Emily. She has a notebook in hand, scribbling furiously. But she doesn\'t seem to be listening to the speech. And her notebook doesn\'t seem to be filled with notes, but math equations and diagrams."},{"type":"paragraph","content":"She notices you, and puts down her notebook, smiling sheepishly. Then she at least pretends to listen. But it seems like the speech is already over. Hopefully it wasn\'t too important."}]},"research_6.smiley_face":{"id":"research_6.smiley_face","content":[{"type":"paragraph","content":"You: \\":)\\""},{"type":"paragraph","content":"It\'s almost midnight. You can imagine that Emily\'s lack of response within an hour was due to her going to bed. And so do you."}]},"research_6":{"id":"research_6","type":"scene","title":"Research","subtitle":"Emily and the Professor","newPage":true,"viewIf":{"$code":"return (((((((Q[\'week\'] || 0) > 6) && ((Q[\'week\'] || 0) < 10)) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'research\'] || 0)===5)) && ((Q[\'weekly_research\'] || 0)===0)) && ((Q[\'stress\'] || 0) < 15));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'research\'] = (Q[\'research\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'weekly_research\'] = 1;"}],"tags":["top","research"],"options":[{"id":"@research_6.ready","title":"But you\'re ready for this..."},{"id":"@research_6.not_ready","title":"Maybe you\'re not ready..."}],"content":[{"type":"paragraph","content":"Your next research project, the one that Stella described in such a tantalizing fashion, happens to be a collaboration that involves mom\'s lab. It\'s supposed to be a comprehensive and complex collaboration, involving at least five different wet lab groups and three computational data analysis teams. You\'re just one part of this vast machine, a new cog in the research-industrial complex that defines biomedical science in America today."},{"type":"paragraph","content":"It\'s a commitment, for sure."}]},"research_final.nice_thought":{"id":"research_final.nice_thought","goTo":[{"id":"research_final.said_too_much"}],"content":[{"type":"paragraph","content":"\\"Um, thanks but... I feel like it\'s going to be really hard...\\""},{"type":"paragraph","content":"\\"It is,\\" Stella replies. \\"But I think you can work hard enough to do well.\\""},{"type":"paragraph","content":"\\"What about my mom?\\" Did she not work hard enough, you wanted to add. Mom has told you that she didn\'t want you to end up like her, working as a permanent technician with a biology Master\'s degree."},{"type":"paragraph","content":"\\"You could probably do better than she did, especially if you get a PhD. Even she could probably do better if she wanted. There are other career paths out there.\\""},{"type":"paragraph","content":"\\"Oh.\\""},{"type":"paragraph","content":"\\"I\'m pretty sure your mom could find a better job. There\'s plenty of positions using similar skills in industry that pay better. But maybe she\'s worried about health insurance or something. I mean, I\'d be sad to see her go, but I want to see her do better.\\""},{"type":"paragraph","content":"\\"Oh.\\""}]},"scioly_invitational.fossils_okay":{"id":"scioly_invitational.fossils_okay","viewIf":{"$code":"return ((Q[\'fossils\'] || 0)===1);"},"options":[{"id":"@scioly_invitational.lunch","title":"Next is lunch break."}],"content":{"content":"The test went okay. Your partner turns out to be quite the expert at fossil identification as well as a lot of the background questions, but there were a few places where you could help.","type":"paragraph"}},"shopping_with_mom.makeup":{"id":"shopping_with_mom.makeup","viewIf":{"$code":"return ((Q[\'emily\'] || 0) <= 3);"},"options":[{"id":"@shopping_with_mom.makeup_2","title":"And that\'s what happens."}],"content":[{"type":"paragraph","content":"According to mom, you also need some makeup. The emotion that such a suggestion evokes in you is one of dismay."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"I really should have taught you when you were younger,\\""}," she says. ",{"type":"emphasis-1","content":"\\"I\'m always regretful I never taught you.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Can we just buy something quickly?\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"We have to buy something high quality. In an event like this you can\'t have the simplest things.\\""},""]},{"type":"paragraph","content":"Whatever. She\'s going to be shocked at the sticker price and just end up buying the cheapest things anyway."}]},"research_1.end":{"id":"research_1.end","content":[{"type":"paragraph","content":"She continues, \\"I\'ll email you with instructions on how to access the data and the compute clusters. Let\'s have regular meetings at this time every week. Is that fine?\\""},{"type":"paragraph","content":"\\"Okay. Yeah.\\""},{"type":"paragraph","content":"That wasn\'t so bad, was it? You feel almost like a real scientist now."}]},"research_1":{"id":"research_1","type":"scene","title":"Research","subtitle":"Downtown, after school","newPage":true,"viewIf":{"$code":"return (((((((Q[\'week\'] || 0) >= 1) && ((Q[\'week\'] || 0) < 7)) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'research\'] || 0)===0)) && ((Q[\'stress\'] || 0) < 15)) && ((Q[\'class_visited\'] || 0)===1));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'research\'] = (Q[\'research\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'weekly_research\'] = 1;"}],"tags":["top","research"],"options":[{"id":"@research_1.downtown","title":"You can meet him after school today, your mother told you."}],"content":{"content":[{"type":"paragraph","content":["You\'ve always wanted to do actual science, hands-on research, advancing the scope of human knowledge. Dr. Professor ",{"type":"insert","insert":0}," Zhao, creator of some miraculous scientific breakthrough. Like technology to allow two people of the same chromosomal configuration to biologically reproduce, for example. A dream, of course, but you would do whatever you can to make it reality. Now you might be one tiny step closer."]},{"type":"paragraph","content":"You try to dismiss these thoughts. Impossible. Pointless. Can\'t let anyone else know, can\'t start your meeting by being weird to the professor."},{"type":"paragraph","content":"Especially since nepotism is how you got to this position. This professor is someone who worked in a office in the same building where your mother worked."}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"skip.w5_miri_status":{"id":"skip.w5_miri_status","options":[{"id":"@skip.w5_miri_1","title":"You\'ve spent some time with Miri."},{"id":"@skip.w5_miri_3","title":"You have not interacted much."}],"content":{"content":"Relationship with Miri:","type":"paragraph"}},"scioly_study_party.shouldnt_have_come":{"id":"scioly_study_party.shouldnt_have_come","options":[{"id":"@scioly_study_party.oh","title":"Oh."}],"content":{"content":[{"type":"paragraph","content":"A semblance of rational thought returns to your brain. You\'d rather it didn\'t."},{"type":"paragraph","content":"You\'re always like this. You shouldn\'t have come. You\'re just making everyone else feel uncomfortable. You\'re a social vampire, draining the energy from your companions by your very presence. You\'re too angsty, so fucking all the time, an overflowing bucket of negative emotion. It\'s only right that your friends cut their ties with you. If you don\'t love yourself, how can anyone else love you? All these cliches that you read on the internet somewhere are coursing through your mind."},{"type":"paragraph","content":"God, you\'re so fucking lonely."},{"type":"paragraph","content":"You\'re sitting alone and entirely unnoticed in an alcove, and you feel like you\'re about to cry. Everyone here should be your friend, right? Aubrey\'s your friend, right? And she\'s here? So why? Why are you acting like this? There\'s no reason for you to be like this and yet..."},{"type":"paragraph","content":["\\"Hey ",{"type":"insert","insert":0},", are you alright?\\""]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"thanksgiving_party.do_homework":{"id":"thanksgiving_party.do_homework","options":[{"id":"@thanksgiving_party.off_track","title":"Of course, your mind goes off track."}],"content":[{"type":"paragraph","content":"You try to work on your AP World reading. The assignment is just to read the relevant chapters of the textbook and answer a few basic questions on them. Maybe you\'ll get something done after all."},{"type":"paragraph","content":"Occasionally you take glances at Emily. She\'s typing on her laptop, apparently writing some sort of essay or another."}]},"scioly_2.a4":{"id":"scioly_2.a4","goTo":[{"id":"scioly_2.wrong_study"}],"content":{"content":"","type":"paragraph"}},"scioly_final.scioly_end":{"id":"scioly_final.scioly_end","options":[{"id":"@scioly_final.want_to_be_captain","title":"To be honest... you sort of like the idea of being captain."},{"id":"@scioly_final.dont_want_to_be_captain","title":"To be honest... you don\'t really want to to be captain."}],"content":[{"type":"paragraph","content":"Now, the captain moves on to talk to Aubrey. There is some weird subtext going on there since they were apparently dating at one point. You overhear that Aubrey is apparently already running for captain with her friend Diana Choi. So apparently you don\'t really need to run for captain anymore? There\'s no way you would beat them in a vote."},{"type":"paragraph","content":"But the captain goes back to you. \\"You might think that you can\'t beat Aubrey,\\" he says, \\"but I think you should at least try. For the sake of the team.\\""},{"type":"paragraph","content":"\\"But how would I be better than Aubrey?\\", you can\'t help but say."},{"type":"paragraph","content":"\\"Because you care about science! It\'s not just a college apps game for you; you really have passion for this sort of thing. Anyway, give it some thought this week.\\""},{"type":"paragraph","content":"You have no comment about the veracity of his comments."}]},"aubrey_final.date_good":{"id":"aubrey_final.date_good","goTo":[{"id":"aubrey_final.aubrey_hold_hand"}],"content":[{"type":"paragraph","content":"\\"It was... um, good?\\""},{"type":"paragraph","content":"\\"Really? Well, I\'m glad.\\""}]},"birthday.aubrey_party_4":{"id":"birthday.aubrey_party_4","content":[{"type":"paragraph","content":"\\"Uh, thanks.\\" You laugh. Of course her mom would give you an AP prep book."},{"type":"paragraph","content":"\\"Yeah, no problem!\\""},{"type":"paragraph","content":"You spend your birthday doing homework together. It\'s better than doing homework by yourself, or doing whatever your parents would have you do. Academics might be the one way in which you can relate to other people, but if that person is Aubrey, then it might work out. Or something like that."}]},"christmas_party.why_come_out":{"id":"christmas_party.why_come_out","options":[{"id":"@christmas_party.yes_come_out","title":"Yes?"},{"id":"@christmas_party.no_come_out","title":"No?"},{"id":"@christmas_party.maybe_come_out","title":"I don\'t know?"}],"content":[{"type":"paragraph","content":"\\"Why?\\""},{"type":"paragraph","content":"\\"Social experiment, I guess,\\" she says. \\"Hey, it worked with you. Plus I kind of read some not-straight vibes from her.\\""},{"type":"paragraph","content":"\\"Wait seriously?\\""},{"type":"paragraph","content":"\\"55% serious. Anyway, should I do it?\\""}]},"church_1.talk":{"id":"church_1.talk","onArrival":[{"$code":"Q[\'aubrey_interact\'] = (Q[\'aubrey_interact\'] || 0) + 1;"}],"options":[{"id":"@church_1.school","title":"Talk about school stuff?"},{"id":"@church_1.scioly","title":"Talk about science olympiad?"},{"id":"@church_1.pageant","title":"Talk about the pageant?"},{"id":"@church_1.wait","title":"Never mind."}],"content":{"content":"Talk about what?","type":"paragraph"}},"classes_1.interview":{"id":"classes_1.interview","onArrival":[{"$code":"Q[\'pageant_interview\'] = (Q[\'pageant_interview\'] || 0) + 1;"}],"goTo":[{"id":"classes_1.next"}],"content":[{"type":"paragraph","content":"\\"Maybe like, generally having to talk to people without dying or something like that.\\" As much as you hate to admit it, your parents might just be right about that part of you."},{"type":"paragraph","content":"Miri smiles. \\"I guess, if that\'s what you want.\\""}]},"emily_1.emily_thanks":{"id":"emily_1.emily_thanks","options":[{"id":"@emily_1.listen","title":"Emily quickly begins an explanation."}],"content":[{"type":"paragraph","content":"\\"Oh, um, thanks,\\" she says, almost smiling. \\"So anyway, should we talk about the pageant?\\""},{"type":"paragraph","content":"\\"Um, sure...?\\""}]},"emily_4.respond":{"id":"emily_4.respond","options":[{"id":"@emily_4.end","title":"Eventually you have to separate."}],"content":[{"type":"paragraph","content":"\\"Didn\'t you say that everything you do is fake? So, like, isn\'t that fake as well?\\""},{"type":"paragraph","content":"\\"What is?\\""},{"type":"paragraph","content":"\\"That last sentence where you say \'it\'s true\'.\\""},{"type":"paragraph","content":"Emily makes a slight chuckle. \\"I just made a contradiction then. Nerd.\\""},{"type":"paragraph","content":"\\"Hey. You\'re a nerd since you... like, know the word contradiction. And like that time when we first met when you talked about, like, optimization and stuff.\\""},{"type":"paragraph","content":"Emily makes some hand gesture. \\"Hey. Was I wrong though?\\""},{"type":"paragraph","content":"\\"Yeah I think you were.\\" You try to say this in a joking way. (are you bantering now? is this how banter works?)"}]},"emily_6.science":{"id":"emily_6.science","onArrival":[{"$code":"Q[\'emily\'] = 7;"}],"options":[{"id":"@emily_6.sorry","title":"\\"Sorry...\\""}],"content":[{"type":"paragraph","content":"\\"So, you know I like science and biology in particular, but, um, do you know why?\\""},{"type":"paragraph","content":"\\"Because it\'s interesting?\\""},{"type":"paragraph","content":"\\"That too. But, um, I\'ve always wanted... God, it\'s gonna sound so ridiculous, but I\'ve always wanted to develop something so that two women can reproduce. I mean, people with XX chromosomes.\\""},{"type":"paragraph","content":"Emily makes a strange noise."}]},"emily_7.inaudible":{"id":"emily_7.inaudible","options":[{"id":"@emily_7.say_out_loud","title":"Yes."},{"id":"@emily_7.silence","title":"No."}],"content":{"content":"She didn\'t seem to have heard you. Do you want to say that again?","type":"paragraph"}},"emily_final.stay_silent":{"id":"emily_final.stay_silent","content":[{"type":"paragraph","content":"\\"Alright. I\'ll go home,\\" she says. \\"Sorry I made you come here. I\'ll get a taxi.\\""},{"type":"paragraph","content":"\\"I can stay until you, um, go,\\" you say."},{"type":"paragraph","content":"\\"Do you want a taxi too?\\""},{"type":"paragraph","content":"\\"No, it\'s fine. I can take the T.\\""},{"type":"paragraph","content":"Emily\'s taxi is waiting. She waves, and gets in. You wave back. The car drives off. You go back into the subway. There is no reception. Home is still 30 minutes away."}]},"epilogue.ep_miri_friends":{"id":"epilogue.ep_miri_friends","maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"viewIf":{"$code":"return ((Q[\'miri_date\'] || 0)===-1);"},"content":{"content":"Miri confessed to you, and you rejected her. But your friendship survived, much as it did before.","type":"paragraph"},"countVisitsMax":1},"family_6.finally_alone":{"id":"family_6.finally_alone","content":[{"type":"paragraph","content":"Finally you\'re alone. Maybe if you were a more emotionally in-tune individual you would be talking with someone about the events of tonight. But really, you don\'t care. It doesn\'t matter anymore. You\'re just going to keep on following the same paths you\'ve always followed; what else can you do?"},{"type":"paragraph","content":"So what happens is, you browse Wikipedia until you fall asleep."}]},"family_6":{"id":"family_6","type":"scene","title":"Family Dinner","subtitle":"An impromptu road trip","newPage":true,"viewIf":{"$code":"return (((((((Q[\'week\'] || 0) > 6) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'family\'] || 0)===6)) && ((Q[\'weekly_family\'] || 0)===0)) && ((Q[\'argument_viewed\'] || 0)===1)) && ((Q[\'week\'] || 0) < 10));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'weekly_family\'] = (Q[\'weekly_family\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 2;\\nQ[\'trauma_points\'] = (Q[\'trauma_points\'] || 0) + 1;"}],"maxVisits":1,"tags":["top","family"],"options":[{"id":"@family_6.so_yeah","title":"So yeah."}],"content":{"content":"The mold in the bathroom is proliferating again, since the fan isn\'t working properly. Bob the superintendent came by with a bottle of bleach and nothing else. Unfortunately the bathroom doesn\'t have any windows, so spraying toxic chemicals on the walls essentially means that you\'ll have to evacuate the whole house. So that\'s what you did: your family left your apartment, and now you\'re all in the old Camry, driving on some family expedition to only dad knows where.","type":"paragraph"},"countVisitsMax":1},"introspect_1.gay":{"id":"introspect_1.gay","content":{"content":"Or something like that.","type":"paragraph"}},"introspect_1":{"id":"introspect_1","type":"scene","title":"Introspection","subtitle":"Who are you, really?","newPage":true,"viewIf":{"$code":"return (((((Q[\'week\'] || 0) >= 1) && ((Q[\'week\'] || 0) < 5)) && ((Q[\'introspection\'] || 0)===0)) && ((Q[\'week_progress\'] || 0) < 3));"},"onArrival":[{"$code":"Q[\'introspection\'] = (Q[\'introspection\'] || 0) + 1;\\nQ[\'first_name\'] = \\"Karen\\";"}],"priority":2,"tags":["top","introspect"],"options":[{"id":"@introspect_1.name","title":"The name \\"Karen\\" originated from 1st grade English class."},{"id":"@introspect_1.not_karen","title":"Actually, my English name isn\'t Karen."}],"content":{"type":"paragraph","content":["Who are you, really? Your legal name is Qiuyi Zhao, but people who aren\'t your parents usually call you Karen, since no one can pronounce Qiuyi. Hence at school your name is \\"Qiuyi (Karen) Zhao\\", with the parentheses indicating that \\"Karen\\" isn\'t officially your name. And technically, Qiuyi Zhao isn\'t your ",{"type":"emphasis-1","content":"real"}," name either; it\'s 赵秋怡, or Zhào Qiūyí."]}},"miri_date.wait":{"id":"miri_date.wait","options":[{"id":"@miri_date.sorry","title":"\\"Sorry...\\""},{"id":"@miri_date.wait_2","title":"Sit in silence."}],"content":[{"type":"paragraph","content":"You sit on the couch, not knowing exactly what to do. You\'re supposed to comfort her, right? You want to comfort her, right? Because you care about her, right?"},{"type":"paragraph","content":"What\'s the point of this train of thought? Are you attempting to craft a transactional framework for your relationship?"}]},"miri_pageant_prep.oh_god":{"id":"miri_pageant_prep.oh_god","onArrival":[{"$code":"Q[\'pageant_interview\'] = (Q[\'pageant_interview\'] || 0) + 1;"}],"options":[{"id":"@miri_pageant_prep.wtf","title":"\\"What the heck?\\""}],"content":[{"type":"paragraph","content":"\\"Oh God. Uh...\\""},{"type":"paragraph","content":"\\"\'Oh God\', she says. Next question: Oh wow.\\" Miri can\'t keep a straight face. \\"Do you have a boyfriend? What does he think about you competing in pageants?\\""}]},"pageant_prep_self_2.social_practice":{"id":"pageant_prep_self_2.social_practice","content":[{"type":"paragraph","content":"You look over the questions that have been asked, and imagine how you would answer them. And there are some tips they tell you to always remember. Practice, but don\'t practice too much, don\'t bother memorizing the questions because the judges can always tell what a canned answer sounds like. Even if your answer is canned, make it sound natural, as if you\'re coming up with it on the spot. But don\'t actually come up with it on the spot unless you\'re a charismatic social genius."},{"type":"paragraph","content":"The questions themselves are annoyingly vague and open-ended, like \\"What do you think the youth of today need to do better?\\" and stuff like that. If you were asked that you would either go blank or ask them what they mean by \\"youth\\" and \\"today\\" and \\"better\\"."}]},"pageant_final.moms_dress":{"id":"pageant_final.moms_dress","onArrival":[{"$code":"Q[\'pageant_dress\'] = 3;"}],"goTo":[{"id":"pageant_final.pick_evening_dress"}],"content":{"content":"Mom has a black dress that looks too middle-aged for you, but it\'ll have to do.","type":"paragraph"}},"pageant_meetup.ashley_speech":{"id":"pageant_meetup.ashley_speech","options":[{"id":"@pageant_meetup.stare_ashley","title":"Stare at Ashley."},{"id":"@pageant_meetup.listen_ashley","title":"Listen."},{"id":"@pageant_meetup.zone_out_ashley","title":"Zone out."}],"content":[{"type":"paragraph","content":"The next speech is by last year\'s winner in this region."},{"type":"paragraph","content":"Wait... this is someone you know. She attends your high school, and she was one of the first people you knew in Massachusetts. But you\'ve grown apart in the past few years, as she increasingly traveled in different different social circles. So it\'s strange that she\'s also into pageants. Or maybe not strange, considering how pretty and popular she is."}]},"research_final.unrealistic":{"id":"research_final.unrealistic","goTo":[{"id":"research_final.said_too_much"}],"content":[{"type":"paragraph","content":"\\"I mean, so many people want to be scientists but, like, it\'s hard...\\""},{"type":"paragraph","content":"Stella laughs. \\"Yeah? If you want to be an R1 professor, that\'s hard, but there are a lot of jobs in science, depending on what you want to do.\\""},{"type":"paragraph","content":"\\"Like my mom\'s?\\" Mom has told you that she didn\'t want you to end up like her, working as a permanent technician with a biology Master\'s degree."},{"type":"paragraph","content":"\\"You could probably do better, especially if you get a PhD. Even she could probably do better if she wanted. There are other career paths out there.\\""},{"type":"paragraph","content":"\\"Oh.\\""},{"type":"paragraph","content":"\\"I\'m pretty sure your mom could find a better job. There\'s plenty of positions using similar skills in industry that pay better. But maybe she\'s worried about health insurance or something. I mean, I\'d be sad to see her go, but I want to see her do better.\\""},{"type":"paragraph","content":"\\"Oh.\\""}]},"scioly_invitational.fossils_bad":{"id":"scioly_invitational.fossils_bad","viewIf":{"$code":"return ((Q[\'fossils\'] || 0)===0);"},"options":[{"id":"@scioly_invitational.lunch","title":"Next is lunch break."}],"content":{"content":"The test did not go so well. You were extremely underprepared, letting your partner handle basically everything.","type":"paragraph"}},"shopping_with_mom.makeup_2":{"id":"shopping_with_mom.makeup_2","goTo":[{"id":"shopping_with_mom.jewelry"}],"content":{"content":"So there\'s primer, foundation, concealer (actually a three-in-one for these), blush, eyeshadow, eyeliner, powder, mascara, lipstick, probably some other stuff you forgot. You\'ll use most of this stuff at most a few times before the expiration date. In total, selecting basically the cheapest items, it comes out to almost $100. You almost beg mom to leave some of them behind, but she insists that you can share, and she also needs makeup for various events. Like what? You don\'t really know.","type":"paragraph"}},"skip.w5_miri_1":{"id":"skip.w5_miri_1","onArrival":[{"$code":"Q[\'miri\'] = 4;\\nQ[\'gym\'] = 1;\\nQ[\'miri_practice\'] = 1;\\nQ[\'miri_hang\'] = 1;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 1;\\nQ[\'pageant_interview\'] = (Q[\'pageant_interview\'] || 0) + 1;"}],"goTo":[{"id":"skip.w5_parents_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.oh":{"id":"scioly_study_party.oh","options":[{"id":"@scioly_study_party.yeah_okay","title":"\\"Yeah. Okay.\\""}],"content":[{"type":"paragraph","content":"That was Aubrey. You concentrate just long enough to suppress the rising bile. Close your eyes for a moment (like a long blink). It\'s going to be fine. It\'s going to be okay."},{"type":"paragraph","content":"\\"Um, hi. Yeah. Of course.\\""},{"type":"paragraph","content":"\\"Hey. We\'re having an apples-to-apples game. Would you like to join us?\\""},{"type":"paragraph","content":"You cough, for no reason in particular."}]},"thanksgiving_party.talk_emily_2":{"id":"thanksgiving_party.talk_emily_2","options":[{"id":"@thanksgiving_party.dinner_known","title":"It\'s time for dinner."}],"content":{"content":[{"type":"paragraph","content":"\\"Sorry,\\" you say, for lack of anything else to say."},{"type":"paragraph","content":"\\"No, it\'s... just, I\'m so sorry,\\" Emily says."},{"type":"paragraph","content":"\\"No, I\'m sorry,\\" you say."},{"type":"paragraph","content":"For some reason Emily starts chuckling to herself. \\"It\'s fine,\\" she says. \\"Just, like, take it easy here. I\'m literally closeted to like everyone I know IRL.\\""},{"type":"paragraph","content":"\\"Except me?\\""},{"type":"paragraph","content":"\\"Yeah I guess?\\" Emily makes a little chortle."},{"type":"paragraph","content":"You and Emily stare at each other awkwardly for a few moments or minutes; you can\'t tell, until sounds from downstairs break your reverie."},{"type":"paragraph","content":["\\"",{"type":"insert","insert":0},", ---, ",{"type":"emphasis-1","content":"food is ready!"},"\\", your mom shouts."]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"scioly_2.wrong_study":{"id":"scioly_2.wrong_study","goTo":[{"id":"scioly_2.protein_question_2"}],"content":[{"type":"paragraph","content":"\\"Sorry, that\'s wrong,\\" Aubrey says. \\"You\'d better study some more. The answer is 1, by the way. It\'s part of the amine group, which is NH3.\\""},{"type":"paragraph","content":"\\"Oh. Sorry.\\" You should have known this question. It was literally the easiest one there was. Oh well. Time to do some more studying."}]},"scioly_final.want_to_be_captain":{"id":"scioly_final.want_to_be_captain","onArrival":[{"$code":"Q[\'growth_points\'] = (Q[\'growth_points\'] || 0) + 1;"}],"content":[{"type":"paragraph","content":"It wouldn\'t be so bad, wouldn\'t it?"},{"type":"paragraph","content":"However, there are currently two sets of candidates: Aubrey and Diana, and Krishna and Daniel. All of them are more popular than you are, and just as talented in the science. So despite what the captain has said, there is no rational reason for you to enter into the race."},{"type":"paragraph","content":"But you might enter the election anyway, for no reason in particular."}]},"aubrey_final.date_alright":{"id":"aubrey_final.date_alright","goTo":[{"id":"aubrey_final.aubrey_hold_hand"}],"content":[{"type":"paragraph","content":"\\"It was... um, okay?\\""},{"type":"paragraph","content":"\\"Just okay? Haha. Figures.\\""}]},"birthday.miri_party":{"id":"birthday.miri_party","viewIf":{"$code":"return (((Q[\'birthday_aubrey_invited\'] || 0)===0) && ((Q[\'birthday_miri_invited\'] || 0)===1));"},"onArrival":[{"$code":"Q[\'miri\'] = (Q[\'miri\'] || 0) + 1;\\nQ[\'loneliness\'] = (Q[\'loneliness\'] || 0) - 1;"}],"options":[{"id":"@birthday.dont_get","title":"You don\'t really get it but..."}],"content":[{"type":"paragraph","content":"\\"Where is everyone?\\""},{"type":"paragraph","content":"You feel your heart beat faster. This is a pathetic excuse for a party."},{"type":"paragraph","content":"\\"Sorry, um...\\" You look away. Your hand starts to tremble."},{"type":"paragraph","content":"\\"Haha, no, it\'s fine! This is like, what do you call it, an intimate moment.\\""},{"type":"paragraph","content":"\\"Um...\\""},{"type":"paragraph","content":"\\"Come on, laugh! It was a joke!\\""}]},"christmas_party.yes_come_out":{"id":"christmas_party.yes_come_out","goTo":[{"id":"christmas_party.come_out_to_aubrey"}],"content":[{"type":"paragraph","content":"\\"Um, sure?\\""},{"type":"paragraph","content":"\\"Okay. I\'m going to do it.\\""}]},"church_1.school":{"id":"church_1.school","goTo":[{"id":"church_1.karen_talk"}],"content":{"content":"What would you even talk about? Well, you have three classes together, and you\'ve always been secretly competing with her over grades (you\'ve usually lost). Sometimes you ask her for homework help. Sometimes she asks you. In fact, perhaps the majority of your conversations in the past have been about homework. Or something like that?","type":"paragraph"}},"classes_1.platform_1":{"id":"classes_1.platform_1","onArrival":[{"$code":"Q[\'pageant_platform\'] = (Q[\'pageant_platform\'] || 0) + 1;"}],"goTo":[{"id":"classes_1.next"}],"content":[{"type":"paragraph","content":"\\"You know, I think the platform is the only thing that could help me out even if I lose. So, even if I lose I can still put it on my college apps as volunteer work and write my essay about how I became a role model for young science people and talk about stuff like that. Or something like that.\\""},{"type":"paragraph","content":"Miri smiles. \\"I guess that\'s as good a plan as any.\\""}]},"emily_1.listen":{"id":"emily_1.listen","options":[{"id":"@emily_1.listen_2","title":"\\"Okay...\\""}],"content":[{"type":"paragraph","content":"\\"So there are a few different components to the pageant: the interview, the platform, the talent, and the most important part, the beauty competition. You know this already, right?\\""},{"type":"paragraph","content":"You nod."},{"type":"paragraph","content":"\\"Sorry. So I can\'t do much to help you on the interview or platform or talent, but I can help out with the beauty part, and that\'s the most important axis of the competition overall. Is that okay?\\""}]},"emily_4.silent":{"id":"emily_4.silent","options":[{"id":"@emily_4.end","title":"Eventually you have to separate."}],"content":[{"type":"paragraph","content":"You stay quiet. What can you even say?"},{"type":"paragraph","content":"Emily doesn\'t say much after that. The two of you walk around the boring light commercial streets of your town. There aren\'t that many people outside, and Emily purposefully ignores the few who are."},{"type":"paragraph","content":"Is your silence companiable or awkward? You\'ve never been able to tell."}]},"emily_6.sorry":{"id":"emily_6.sorry","options":[{"id":"@emily_6.geek_out","title":"\\"Yes, in fact...\\""}],"content":[{"type":"paragraph","content":"\\"Um, sorry,\\" you manage to say."},{"type":"paragraph","content":"\\"No, it\'s pretty cool!\\" Emily laughs and glances at you. \\"I mean, I never want biological children, but it\'s a pretty interesting idea. Have you thought about how you would, uh, actualize that?\\""}]},"emily_7.silence":{"id":"emily_7.silence","options":[{"id":"@emily_7.yes_rambling","title":"\\"Yeah...\\""},{"id":"@emily_7.its_fine","title":"\\"It\'s fine...\\""}],"content":[{"type":"paragraph","content":["You\'re not even sure if you ",{"type":"emphasis-1","content":"like"}," like Emily. Besides, there are so many complicating factors here, not least of which is the whole \'parents\' issue."]},{"type":"paragraph","content":"So you\'re okay with not declaring your love or doing anything ridiculous like that."},{"type":"paragraph","content":"Meanwhile, Emily restarts speaking. \\"Like, the whole pageant thing, that\'s kind of an encapsulation of the whole idea that womanhood is an optimization problem in which the only path to success is to reverse-engineer the desires that society places upon... sorry, am I rambling?\\""}]},"emily_final.stay_here":{"id":"emily_final.stay_here","options":[{"id":"@emily_final.stay_here_2","title":"There is a lull..."}],"content":[{"type":"paragraph","content":"You: Okay. Can you make it back home?"},{"type":"paragraph","content":"Emily: Yes. I can."},{"type":"paragraph","content":"Emily: Unfortunately I\'m not so idiotic as to actually carry out the \\"running away from home\\" plan."},{"type":"paragraph","content":"Emily: But can you stay online?"},{"type":"paragraph","content":"You: Of course..."}]},"epilogue.ep_miri_neutral":{"id":"epilogue.ep_miri_neutral","maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"viewIf":{"$code":"return ((((Q[\'miri_date\'] || 0)===0) && ((Q[\'miri_escape\'] || 0)===0)) && ((Q[\'miri\'] || 0) >= 2));"},"content":{"content":"You\'re still friends with Miri, and your friendship continues on much as it did before. The pageant and all it involved changed nothing in that regard.","type":"paragraph"},"countVisitsMax":1},"miri_date.wait_2":{"id":"miri_date.wait_2","options":[{"id":"@miri_date.sorry","title":"\\"Sorry...?\\""},{"id":"@miri_date.wait_3","title":"Keep sitting in silence."}],"content":{"content":"Miri is just sitting there in silence, so you might as well do so as well. You don\'t have a good sense of time; it could have been seconds or minutes for all you know.","type":"paragraph"}},"miri_pageant_prep.good_answer":{"id":"miri_pageant_prep.good_answer","viewIf":{"$code":"return ((Q[\'pageant_interview\'] || 0) > 0);"},"onArrival":[{"$code":"Q[\'pageant_interview\'] = (Q[\'pageant_interview\'] || 0) + 1;"}],"options":[{"id":"@miri_pageant_prep.next_question","title":"\\"Anyway, what\'s next?\\""},{"id":"@miri_pageant_prep.next_question_3","title":"\\"Anyway, next question?\\""}],"content":[{"type":"paragraph","content":"\\"Well, that\'s a good question.\\" A pause. \\"Academics are very important to me, as are extracurriculars. And uh...\\""},{"type":"paragraph","content":"\\"But to be a balanced student I need more than coursework.\\" Miri answers for you. \\"Participating in the pageant would allow me to better allocate my time away from all the unimportant stuff in life, and focus on what\'s really important to me.\\""},{"type":"paragraph","content":"\\"Did you read that or just make it up?\\""},{"type":"paragraph","content":"\\"Just made it up.\\""},{"type":"paragraph","content":"\\"Oh. That was good.\\""},{"type":"paragraph","content":"\\"Well, thanks. You\'d better memorize that for next time.\\""}]},"pageant_prep_self_2.platform":{"id":"pageant_prep_self_2.platform","subtitle":"Work on your platform.","viewIf":{"$code":"return ((Q[\'pageant_platform\'] || 0) < 2);"},"onArrival":[{"$code":"Q[\'pageant_platform\'] = (Q[\'pageant_platform\'] || 0) + 1;"}],"options":[{"id":"@pageant_prep_self_2.cancer","title":"Your platform is something to do with science research?"},{"id":"@pageant_prep_self_2.ed","title":"Your platform is something to do with science education?"}],"content":{"content":"What does the platform exactly entail, anyway? Do you actually have to go out and raise money? Or is \\"advocacy\\" enough?","type":"paragraph"}},"pageant_final.bought_dress_red":{"id":"pageant_final.bought_dress_red","onArrival":[{"$code":"Q[\'pageant_dress\'] = 4;"}],"viewIf":{"$code":"return ((Q[\'red_dress\'] || 0)===1);"},"goTo":[{"id":"pageant_final.pick_evening_dress"}],"content":{"content":"This is a red lace dress with ruffles at the waist, and rather uncomfortable fabric. It\'ll have to do.","type":"paragraph"}},"pageant_meetup.stare_ashley":{"id":"pageant_meetup.stare_ashley","goTo":[{"id":"pageant_meetup.listen_ashley"}],"onArrival":[{"$code":"Q[\'ashley_stared\'] = 1;"}],"content":{"content":"Ashley stands quite a bit taller than you, with an athletic body and wavy light brown hair that cascades down her back. Ashley is pretty, attractive in a conventional way or something like that, which is probably how she got into pageant stuff. Not to mention the string of boyfriends you\'ve seen her walking the halls with. She\'s also an AP student with a higher GPA than you.","type":"paragraph"}},"research_final.jobs_in_science":{"id":"research_final.jobs_in_science","goTo":[{"id":"research_final.said_too_much"}],"content":[{"type":"paragraph","content":"\\"Are there still any jobs in science?\\" Mom has told you that she didn\'t want you to end up like her, working as a permanent technician with a biology Master\'s degree."},{"type":"paragraph","content":"\\"Ouch. That\'s a tough one.\\" Stella pretends to wince. \\"Finding jobs in academia is... pretty difficult. If you want to be a professor like Dr. Chen, well, that\'s basically impossible. But there are industry jobs, which is probably what I\'ll end up doing since I don\'t want to be a postdoc forever.\\""},{"type":"paragraph","content":"\\"Oh...\\""},{"type":"paragraph","content":"\\"But I don\'t know! Maybe things will change when you get older. Or maybe they\'ll get worse. You\'ll just have to be flexible.\\""},{"type":"paragraph","content":"\\"Oh...\\""}]},"scioly_invitational.lunch":{"id":"scioly_invitational.lunch","options":[{"id":"@scioly_invitational.cell_biology","title":"Next is Cell Biology."}],"content":[{"type":"paragraph","content":"The captain has ordered pizza for everyone. \\"How\'s it going?,\\" he asks you. \\"You know you\'re one of our most important members, right?\\""},{"type":"paragraph","content":"\\"Um, yeah. I guess.\\""},{"type":"paragraph","content":"\\"Good. I just want to let you know that we\'re all counting on you.\\" He pats you on the back and moves to give similarly inspirational speeches to other members."},{"type":"paragraph","content":"You eat two pineapple and ham slices, your favorite. The next event is coming up soon."}]},"shopping_with_mom.makeup_emily":{"id":"shopping_with_mom.makeup_emily","viewIf":{"$code":"return ((Q[\'emily\'] || 0) > 3);"},"goTo":[{"id":"shopping_with_mom.jewelry"}],"content":{"content":"According to mom, you also need some makeup. Fortunately, Emily Chen has already given you some of hers. You tell mom that you already have some from a friend. She asks who it is; you say it\'s someone she doesn\'t know. She doesn\'t push on that.","type":"paragraph"}},"skip.w5_miri_3":{"id":"skip.w5_miri_3","onArrival":[{"$code":"Q[\'miri\'] = 1;"}],"goTo":[{"id":"skip.w5_parents_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.yeah_okay":{"id":"scioly_study_party.yeah_okay","options":[{"id":"@scioly_study_party.contingent","title":"\\"I love having value as long as I can perform well...\\""},{"id":"@scioly_study_party.captain_thanks","title":"\\"Thanks...\\""}],"content":[{"type":"paragraph","content":"\\"Yeah. Okay.\\""},{"type":"paragraph","content":"You check your face to make sure that you\'re not crying. And you were. Maybe you still are. You aren\'t sure if she noticed, or if she was too kind to say anything. You don\'t know which you would prefer."},{"type":"paragraph","content":"\\"You should hang out with us more,\\" says the captain after you join the game circle (did he notice you cry?). \\"You know you\'re one of the most valuable members of our team, right?\\""}]},"thanksgiving_party.off_track":{"id":"thanksgiving_party.off_track","options":[{"id":"@thanksgiving_party.dinner_known","title":"It\'s time for dinner."}],"content":{"content":[{"type":"paragraph","content":["You try to focus on the homework, but you can\'t. You think about ",{"type":"emphasis-1","content":"things"},", but mostly about how awkward the current moment is. You feel as if you should say something to break the silence because it\'s awkward but you don\'t know if it\'s actually a good idea and maybe Emily really wants to be doing whatever her computer thing is and probably doesn\'t even want you to be here and honestly maybe you don\'t even want to be here and you\'re all only here because of the machinations of your parents and..."]},{"type":"paragraph","content":["\\"",{"type":"insert","insert":0},", ---, ",{"type":"emphasis-1","content":"food is ready!"},"\\", your mom shouts."]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"scioly_2.dont_know":{"id":"scioly_2.dont_know","goTo":[{"id":"scioly_2.protein_question_2"}],"content":[{"type":"paragraph","content":"\\"Um... I have no idea...\\""},{"type":"paragraph","content":"Aubrey sighs. \\"This is like the most basic question there is. The answer is 1, by the way. It\'s part of the amine group, which is NH3.\\""},{"type":"paragraph","content":"\\"Sorry.\\""},{"type":"paragraph","content":"\\"No, it\'s fine. Just... do more studying.\\""},{"type":"paragraph","content":"\\"Right...\\""}]},"scioly_final.dont_want_to_be_captain":{"id":"scioly_final.dont_want_to_be_captain","onArrival":[{"$code":"Q[\'growth_points\'] = (Q[\'growth_points\'] || 0) + 1;"}],"content":[{"type":"paragraph","content":"You aren\'t really temperamentally fit for a leadership position at this point."},{"type":"paragraph","content":"There are currently two sets of candidates: Aubrey and Diana, and Krishna and Daniel. All of them are more popular than you are, and just as talented in the science. So despite what the captain has said, there is no rational reason for you to enter into the race."},{"type":"paragraph","content":"But you might enter the election anyway, for no reason in particular."}]},"scioly_final":{"id":"scioly_final","type":"scene","title":"Science Olympiad","subtitle":"The race for captain","newPage":true,"viewIf":{"$code":"return ((((((Q[\'week\'] || 0)===11) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'weekly_scioly\'] || 0)===0)) && ((Q[\'invitational\'] || 0)===1)) && (((((Q[\'gold_count\'] || 0) > 0) || ((Q[\'silver_count\'] || 0) > 0)) || ((Q[\'bronze_count\'] || 0) > 2))));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'scioly\'] = (Q[\'scioly\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'weekly_scioly\'] = 1;\\nQ[\'scioly_final_seen\'] = 1;"}],"tags":["top","scioly"],"options":[{"id":"@scioly_final.no","title":"Um... no?"},{"id":"@scioly_final.maybe","title":"Um... maybe?"},{"id":"@scioly_final.yes","title":"It could be a good idea..."}],"content":[{"type":"paragraph","content":"The old captain is graduating. A new captain has yet to be chosen. Now, science olympiad is a time of monsters."},{"type":"paragraph","content":"\\"As usual, we want to choose the new captains before the regionals,\\" says the advisor, \\"so that they can grow into their new role over the spring semester.\\""},{"type":"paragraph","content":"There is going to be a vote. It has been decided that there will probably be co-captains. There are only two candidates that you know of so far: Krishna and his friend Daniel Salas."},{"type":"paragraph","content":"The old captain pulls you aside to talk immediately after the meeting officially ends."},{"type":"paragraph","content":"\\"I want you to run,\\" he says. \\"I think you would be great as captain.\\""}]},"aubrey_final.date_um":{"id":"aubrey_final.date_um","goTo":[{"id":"aubrey_final.aubrey_hold_hand"}],"content":[{"type":"paragraph","content":"\\"Um... I...\\""},{"type":"paragraph","content":"\\"You don\'t want to say? Haha. Figures.\\""}]},"birthday.dont_get":{"id":"birthday.dont_get","options":[{"id":"@birthday.miri_party_2","title":"Take a deep breath."}],"content":[{"type":"paragraph","content":"\\"Oh, um, haha...\\" Wait, is she implying- no, that\'s not possible of course it was a joke..."},{"type":"paragraph","content":"\\"So like, your parents aren\'t home? What do you want to do?\\" Then she notices the look on your face, and says, \\"Actually, bad question. Would you be interested in the gift of Japanimation?\\""}]},"christmas_party.no_come_out":{"id":"christmas_party.no_come_out","goTo":[{"id":"christmas_party.go_back_to_game"}],"content":[{"type":"paragraph","content":"\\"No, probably not. She\'s like... I don\'t think she\'ll take it well.\\""},{"type":"paragraph","content":"\\"Oh. Well. Let\'s go back.\\""}]},"church_1.scioly":{"id":"church_1.scioly","viewIf":{"$code":"return ((Q[\'scioly\'] || 0) > 0);"},"goTo":[{"id":"church_1.karen_talk"}],"content":{"content":"What would you even talk about? You\'re doing Protein Modeling with her. That\'s a sensible choice; both Aubrey and you are biology-focused people. She got the highest grade in the class in AP Bio last year, and you got... somewhere in the top five maybe? Anyway, that\'s water under the bridge. As for the science olympiad event itself, would she really want to talk about it at a time like this?","type":"paragraph"}},"classes_1.next":{"id":"classes_1.next","content":[{"type":"paragraph","content":"The pageant can\'t be the only thing you spend your time on. As a top university-bound student you need to have a full portfolio of extracurricular activities and leadership opportunities filling up every moment of every waking hour. Okay, that was an exaggeration. But not by much. You\'re a part of the science olympiad team, and everyone\'s counting on you to help carry the team or something. Also, you\'re supposed to be working with a professor (whom your mom set you up with) on a research project. Somewhere along the way, your parents and brother want to see you at home for dinner. And don\'t forget, it\'s best if you interact with other humans in a non-academic, non-family capacity once in a while."},{"type":"paragraph","content":"So, best to get started."}]},"classes_1":{"id":"classes_1","type":"scene","title":"Classes","subtitle":"School, Monday morning","newPage":true,"viewIf":{"$code":"return ((((((Q[\'week\'] || 0) >= 1) && ((Q[\'week\'] || 0) < 6)) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'pageant_prep\'] || 0)===0)) && ((Q[\'stress\'] || 0) < 15));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'pageant_prep\'] = 1;\\nQ[\'miri\'] = 1;\\nQ[\'class_visited\'] = -1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"priority":2,"tags":["top","pageant_prep"],"options":[{"id":"@classes_1.prep","title":"But before that..."}],"content":[{"type":"paragraph","content":"Your class schedule for first semester:"},{"type":"paragraph","content":"1. AP English Literature"},{"type":"paragraph","content":"2. AP World History"},{"type":"paragraph","content":"3. AP Calculus BC"},{"type":"paragraph","content":"4. AP Chemistry"},{"type":"paragraph","content":"5. AP Spanish"},{"type":"paragraph","content":"6. Health & PE"},{"type":"paragraph","content":"For most people this would be a rather difficult courseload, to put it mildly. For you, well, you can\'t afford to be \'most people\'. You\'ve maintained a top-10 weighted class rank, even if your unweighted GPA could be better thanks to a few A-minuses in 10th grade."},{"type":"paragraph","content":"The important thing is that you\'re going to start preparing for the pageant this afternoon."}]},"emily_1.listen_2":{"id":"emily_1.listen_2","options":[{"id":"@emily_1.listen_3","title":"Just listen."}],"content":[{"type":"paragraph","content":"\\"Um, okay...\\""},{"type":"paragraph","content":"\\"Alright. The first thing to know is that it\'s all just an optimization game. People say that fashion is an art and shit like that, but what they really mean is that they want you to play by their rules. In reality it\'s a system like any other. So let\'s see what we can do better.\\""},{"type":"paragraph","content":"Emily proceeds to tell you all about her fashion theories, and to be honest you have no way to tell whether she\'s actually giving good advice or just making stuff up. She mentions color theory, which is supposedly about which colors go well together. Then comes talk of body type (in which you\'re pretty similar), skin tone (again, pretty similar), and hair (God it\'s like you\'re sisters, or just both Asian, except her hair is a bit shorter and surprisingly neater than your tangled mess that you refuse to have cut)."}]},"emily_4.end":{"id":"emily_4.end","content":[{"type":"paragraph","content":"Emily has to take the bus home to her distant suburb. And your parents are probably awaiting you for dinner. So you wave goodbye."},{"type":"paragraph","content":"You walk home feeling unusually pleasant, with a light feeling in your heart. Or something like that?"}]},"emily_4":{"id":"emily_4","type":"scene","title":"Meeting with Emily","subtitle":"Reconfiguration","newPage":true,"viewIf":{"$code":"return (((((Q[\'emily\'] || 0)===4) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'stress\'] || 0) < 15)) && ((Q[\'thanksgiving\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'emily_4_seen\'] = 1;"}],"maxVisits":1,"tags":["top","social"],"options":[{"id":"@emily_4.what","title":"\\"What?\\""}],"content":{"content":"\\"Why are you still here?\\"","type":"paragraph"},"countVisitsMax":1},"emily_6.geek_out":{"id":"emily_6.geek_out","goTo":[{"id":"emily_6.emily_science"}],"content":[{"type":"paragraph","content":"\\"Yes, actually. So, we first have induced pluripotent stem cells, which is quickly becoming a technology thanks to Yamanaka et al. and others I guess. Then, we just need to find the correct triggers to induce spermatogenesis. It shouldn\'t require too many Y-chromosome genes, since there aren\'t a lot of Y-chromosome genes to begin with, but some epigenetic and signalling modifications we should be able to do it. I mean I haven\'t looked at the full regulatory pathway and we probably don\'t know the complete regulatory pathways yet, but,... um,...\\""},{"type":"paragraph","content":"You glance over at Emily. She has some kind of smile on her face."}]},"emily_7.yes_rambling":{"id":"emily_7.yes_rambling","goTo":[{"id":"emily_7.okay_ramble"}],"content":{"content":"\\"Yeah but... it\'s fine.\\"","type":"paragraph"}},"emily_final.stay_here_2":{"id":"emily_final.stay_here_2","options":[{"id":"@emily_final.encourage","title":"Say something encouraging???"}],"content":[{"type":"paragraph","content":"Emily is typing for a while."},{"type":"paragraph","content":"Emily: Okay I\'ve got a taxi now. I would take a train/bus if it were still running but transit in the suburbs sucks."},{"type":"paragraph","content":"Emily: God my parents are going to kill me once they see the bills."},{"type":"paragraph","content":"You: Do you need any help?"},{"type":"paragraph","content":"Emily: No. I\'m in the taxi now."},{"type":"paragraph","content":"Emily: I\'m doing fine. I\'m going to live. For now."}]},"epilogue.ep_miri_uncertain":{"id":"epilogue.ep_miri_uncertain","maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"viewIf":{"$code":"return ((Q[\'miri_date\'] || 0)===1);"},"content":{"content":"Miri Brooks confessed to you, but you never gave a certain answer. And perhaps you never will. She acts as if she never asked. Still, your friendship survived, much as it did before.","type":"paragraph"},"countVisitsMax":1},"miri_date.wait_3":{"id":"miri_date.wait_3","goTo":[{"id":"miri_date.awkwardness"}],"content":[{"type":"paragraph","content":"\\"Okay, so...\\" Miri breaks the silence. \\"Sorry I acted all weird. Do you want to try doing something else?\\" She glances at you, her brown eyes gleaming."},{"type":"paragraph","content":"\\"God, I\'m so sorry,\\" she continues. \\"This is supposed to be a first date and I\'m acting all like this. It fucking sucks.\\""}]},"miri_pageant_prep.perfect_answer":{"id":"miri_pageant_prep.perfect_answer","viewIf":{"$code":"return ((Q[\'pageant_interview\'] || 0) > 2);"},"onArrival":[{"$code":"Q[\'pageant_interview\'] = (Q[\'pageant_interview\'] || 0) + 1;"}],"options":[{"id":"@miri_pageant_prep.next_question","title":"\\"I know. Next question?\\""},{"id":"@miri_pageant_prep.next_question_3","title":"\\"I know. Next question?\\""}],"content":[{"type":"paragraph","content":"You\'re finally prepared for this question, and take a breath."},{"type":"paragraph","content":"\\"Both academics and extracurriculars are very important to me, but sometimes there\'s only enough time in the day for so much. I care about the pageant a great deal, and I don\'t need to get 100% on everything at school or take all the hardest classes all the time.\\""},{"type":"paragraph","content":"\\"Was that true?\\""},{"type":"paragraph","content":"\\"Of course not. How else would I get into MIT?\\""},{"type":"paragraph","content":"Miri makes some weird expression. \\"Anyway, it\'s clear you memorized the answer. And that\'s okay, but you\'ll have to pretend that you didn\'t memorize it.\\""}]},"pageant_prep_self_2.cancer":{"id":"pageant_prep_self_2.cancer","viewIf":{"$code":"return ((Q[\'platform\'] || 0)===0);"},"goTo":[{"id":"pageant_prep_self_2.cause"}],"content":{"content":"Yes, something to do with scientific research, using cancer research in particular as a focal point. What, exactly? Raise funds for a research foundation?","type":"paragraph"}},"pageant_final.bought_dress_green":{"id":"pageant_final.bought_dress_green","onArrival":[{"$code":"Q[\'pageant_dress\'] = 5;"}],"viewIf":{"$code":"return ((Q[\'green_dress\'] || 0)===1);"},"goTo":[{"id":"pageant_final.pick_evening_dress"}],"content":{"content":"This is a shimmery green pleated dress. It looks decent enough, in your admittedly untrained opinion.","type":"paragraph"}},"pageant_meetup.listen_ashley":{"id":"pageant_meetup.listen_ashley","options":[{"id":"@pageant_meetup.social","title":"The speech ends."}],"content":{"content":"Ashley\'s speech is about nothing in particular, like student council speeches or any of the principal\'s motivational speeches. You try to listen, but the words fail to reach your brain.","type":"paragraph"}},"research_final.said_too_much":{"id":"research_final.said_too_much","options":[{"id":"@research_final.taking_interest","title":"She seems to be taking an uncomfortable amount of interest in you..."},{"id":"@research_final.could_use_help","title":"You could use her help..."},{"id":"@research_final.what_help","title":"Or is she just being nice and making a socially required offer not expecting you to actually accept?"}],"content":{"content":"\\"Haha. I\'ve probably said too much.\\" Stella takes out her laptop and opens it next to you. \\"We were talking about college apps, right? Do you need any help with that? God, it feels like so long ago.\\"","type":"paragraph"}},"scioly_invitational.cell_biology":{"id":"scioly_invitational.cell_biology","options":[{"id":"@scioly_invitational.cell_good","title":"Fine."},{"id":"@scioly_invitational.cell_okay","title":"Alright."},{"id":"@scioly_invitational.cell_bad","title":"Poorly."}],"content":[{"type":"paragraph","content":"Krishna is already waiting for you."},{"type":"paragraph","content":"As you take the test, it\'s going..."}]},"shopping_with_mom.jewelry":{"id":"shopping_with_mom.jewelry","options":[{"id":"@shopping_with_mom.leave","title":"Finally, the ordeal is over."}],"content":[{"type":"paragraph","content":"Finally, there\'s jewelry. You have a few bracelets and necklaces that have accumulated as gifts over the years, like that jade pendant with an ox carving (your zodiac animal)."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Can I just wear that?\\""},", you ask."]},{"type":"paragraph","content":["Mom waves her hand. ",{"type":"emphasis-1","content":"\\"With your dress, it doesn\'t match. You need western-style jewelry.\\""},""]},{"type":"paragraph","content":"She picks out a fake diamond necklace, some fake pearl earrings (even though your ear piercings have already closed), and some silver bracelets."}]},"skip.w5_parents_status":{"id":"skip.w5_parents_status","options":[{"id":"@skip.w5_parents_1","title":"You\'ve interacted somewhat with your parents."},{"id":"@skip.w5_parents_3","title":"You\'ve been avoiding them."}],"content":{"content":"Relationship with parents:","type":"paragraph"}},"scioly_study_party.contingent":{"id":"scioly_study_party.contingent","goTo":[{"id":"scioly_study_party.captain_thanks"}],"content":{"content":"You love how your entire worth is contingent upon your academic/extracurricular performance. But you\'re not going to vocalize your bitterness.","type":"paragraph"}},"thanksgiving_party.dinner_known":{"id":"thanksgiving_party.dinner_known","options":[{"id":"@thanksgiving_party.eat_research_known","title":"You fill your plate and sit next to her."},{"id":"@thanksgiving_party.eat_research_unknown","title":"You fill your plate and sit next to her."}],"content":[{"type":"paragraph","content":"The two of you head downstairs, following the fragrance of steamed rice and myriad oils and sauces. Some of the younger children have already started filling their plates. Emily fills her plate first, and then starts to head upstairs before his father calls after her."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"---, come eat with us down here.\\""}," She turns around with a sigh and heads to the living room sofas, but not before giving you a knowing look."]}]},"scioly_2.protein_question_2":{"id":"scioly_2.protein_question_2","options":[{"id":"@scioly_2.protein_question_2_correct","title":"Cuts up nucleic acids like DNA or RNA"}],"content":[{"type":"paragraph","content":"\\"Okay, next question. What does a nuclease do?\\""},{"type":"paragraph","content":"This one\'s easy."}]},"aubrey_final.aubrey_hold_hand":{"id":"aubrey_final.aubrey_hold_hand","options":[{"id":"@aubrey_final.why_hold_hand","title":"\\"...Why?\\""},{"id":"@aubrey_final.okay_hold_hand","title":"\\"...Okay?\\""},{"id":"@aubrey_final.sorry_hold_hand","title":"\\"...Sorry, but...\\""}],"content":[{"type":"paragraph","content":"A pause. Aubrey slowly glances around the surroundings, and you follow her gaze. The sun has mostly set; the sky is a gradient of orange and red. The crowds are starting to thin. No one is looking in your direction."},{"type":"paragraph","content":"\\"Can you hold my hand?\\", she says, looking at you with a smile."},{"type":"paragraph","content":{"type":"emphasis-1","content":"What."}}]},"birthday.miri_party_2":{"id":"birthday.miri_party_2","options":[{"id":"@birthday.miri_party_3","title":"Watch whatever Miri has prepared."}],"content":[{"type":"paragraph","content":"Everything will be fine. Miri is your friend."},{"type":"paragraph","content":"\\"Sure,\\" you say with an awkward smile. \\"I await whatever nefarious, uh, production you have prepared.\\""},{"type":"paragraph","content":"\\"Hey, don\'t doubt me.\\""},{"type":"paragraph","content":"\\"Oh yeah, and, uh, thanks for being here.\\""},{"type":"paragraph","content":"\\"Hey, thanks for inviting me! Like, we\'re friends. This is what humans do.\\""},{"type":"paragraph","content":"\\"Yeah. Humans.\\""},{"type":"paragraph","content":"\\"Humans.\\""}]},"christmas_party.maybe_come_out":{"id":"christmas_party.maybe_come_out","goTo":[{"id":"christmas_party.go_back_to_game"}],"content":[{"type":"paragraph","content":"\\"I don\'t know... um, what do you want to do?\\""},{"type":"paragraph","content":"\\"I don\'t know. That\'s the problem.\\" She sighs. \\"I guess I won\'t. It\'s probably more likely to have negative consequences. Let\'s go back.\\""}]},"church_1.pageant":{"id":"church_1.pageant","goTo":[{"id":"church_1.karen_talk"}],"content":{"content":"Oh God. No. It\'s too embarrassing. How could you just talk about something like that? And what would you say? Hey Aubrey, I\'m doing a beauty pageant? Could you just say something like that? And what would she say to that? Well, she could probably help you since she probably knows more about makeup and fashion or whatever than you but...","type":"paragraph"}},"emily_1.listen_3":{"id":"emily_1.listen_3","options":[{"id":"@emily_1.meet_again","title":"You hope to meet again."},{"id":"@emily_1.maybe_not_meet_again","title":"You\'re not sure if you would ever meet again."}],"content":[{"type":"paragraph","content":"You don\'t talk much, just making vague gestures of assent."},{"type":"paragraph","content":"At some point she makes up some equations (those were definitely fake), and something about spreadsheets and algorithms (which might unfortunately be real). So you just smile and nod through her explanations, acting like you\'re listening and understanding."},{"type":"paragraph","content":"\\"We should meet again sometime,\\" she says. \\"Sorry I\'ve just been talking all this time. I should go back home now.\\""}]},"emily_6.emily_science":{"id":"emily_6.emily_science","options":[{"id":"@emily_6.gratified","title":"You feel... gratified? Or something like that..."}],"content":[{"type":"paragraph","content":"\\"Wow, that sounds really interesting,\\" says Emily. \\"I know that sounds insincere but I really mean it.\\""},{"type":"paragraph","content":"\\"Seriously...?\\""},{"type":"paragraph","content":["\\"Yeah! I mean, if we\'re going into genetic engineering, I would focus on other priorities, but I\'m glad that ",{"type":"emphasis-1","content":"someone"}," is thinking about that stuff! God, you\'re worth more than every cis dude tenured professor.\\""]}]},"emily_7.its_fine":{"id":"emily_7.its_fine","goTo":[{"id":"emily_7.okay_ramble"}],"content":{"content":"\\"No, it\'s fine...\\"","type":"paragraph"}},"emily_final.encourage":{"id":"emily_final.encourage","options":[{"id":"@emily_final.ask_picture","title":"Ask for a picture, to make sure she\'s okay..."}],"content":[{"type":"paragraph","content":"You have no idea what you could say that would be appropriate."},{"type":"paragraph","content":"You: Um... Good luck..."},{"type":"paragraph","content":"Emily: Thanks."},{"type":"paragraph","content":"She is online but not typing for 20 minutes. You do not know what to say."},{"type":"paragraph","content":"Emily: I\'m home now. Lights still on. Ready for fucked up shit to start happening."},{"type":"paragraph","content":"You: Sorry..."},{"type":"paragraph","content":"Emily: It\'s my fault lol."},{"type":"paragraph","content":"Emily: Anyway I\'m logging off."},{"type":"paragraph","content":"You: Wait..."}]},"epilogue.ep_miri_bad":{"id":"epilogue.ep_miri_bad","maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"viewIf":{"$code":"return ((Q[\'miri_escape\'] || 0)===1);"},"content":{"content":"You\'ve ruined your friendship with Miri. Or something like that. She doesn\'t actively avoid you at school, but it does feel as if something has changed between the two of you.","type":"paragraph"},"countVisitsMax":1},"miri_date.can_try":{"id":"miri_date.can_try","options":[{"id":"@miri_date.sorry","title":"\\"Sorry...?\\""},{"id":"@miri_date.wait","title":"Just wait. You don\'t know what to say."}],"content":{"content":"Okay. You take a deep breath and think of what to say. \'Things will be fine?\' No, that\'s a lie. \'Don\'t worry?\' No, that\'s a command. \'Actually the state of the world is improving in ways x, y, and z?\' No, that\'s probably insensitive or something like that, and you\'re skeptical of such panglossian thinking in the first place.","type":"paragraph"}},"miri_pageant_prep.next_question":{"id":"miri_pageant_prep.next_question","viewIf":{"$code":"return ((Q[\'miri_practice\'] || 0)===0);"},"options":[{"id":"@miri_pageant_prep.wtf","title":"\\"What the heck?\\""}],"content":{"content":"\\"Next question: Oh wow.\\" Miri can\'t keep a straight face. \\"Do you have a boyfriend? What does he think about you competing in pageants?\\"","type":"paragraph"}},"pageant_prep_self_2.ed":{"id":"pageant_prep_self_2.ed","viewIf":{"$code":"return ((Q[\'platform\'] || 0)===1);"},"goTo":[{"id":"pageant_prep_self_2.cause"}],"content":{"content":"Yes, something about science education. What, exactly? What do other people do? Do you raise funds for a foundation?","type":"paragraph"}},"pageant_final.bought_dress_purple":{"id":"pageant_final.bought_dress_purple","onArrival":[{"$code":"Q[\'pageant_dress\'] = 6;"}],"viewIf":{"$code":"return ((Q[\'purple_dress\'] || 0)===1);"},"goTo":[{"id":"pageant_final.pick_evening_dress"}],"content":{"content":"This is a frilly purple strapless dress with a black stripe around the waist. It looks decent enough, in your admittedly untrained opinion.","type":"paragraph"}},"pageant_meetup.zone_out_ashley":{"id":"pageant_meetup.zone_out_ashley","options":[{"id":"@pageant_meetup.social","title":"The speech ends."}],"content":{"content":"You can\'t really focus on her speech, for some reason. It\'s as if the words bounce off your brain.","type":"paragraph"}},"research_final.taking_interest":{"id":"research_final.taking_interest","options":[{"id":"@research_final.back_to_work","title":"You get back to work."}],"content":[{"type":"paragraph","content":"\\"Um... why?\\""},{"type":"paragraph","content":"\\"Why what?\\""},{"type":"paragraph","content":"\\"Why do you want to help me?\\" You immediately feel like you\'ve said something wrong."},{"type":"paragraph","content":"\\"Ha! Is there anything wrong with wanting to help?\\""},{"type":"paragraph","content":"\\"No...\\""},{"type":"paragraph","content":"\\"It\'s just that I was in a similar place not long ago... actually quite long ago. But I see you a similar situation as me, and I think you can do better than I did.\\""},{"type":"paragraph","content":"\\"Oh. Um, thanks.\\""},{"type":"paragraph","content":"\\"Yeah, no problem!\\""}]},"scioly_invitational.cell_good":{"id":"scioly_invitational.cell_good","viewIf":{"$code":"return ((Q[\'cell\'] || 0) >= 2);"},"options":[{"id":"@scioly_invitational.waiting","title":"Now you have to wait."}],"content":{"content":"It\'s all pretty easy, and Krishna seems to agree.","type":"paragraph"}},"shopping_with_mom.leave":{"id":"shopping_with_mom.leave","content":[{"type":"paragraph","content":"Mom and you leave several bags heavier and over $200 poorer."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"We have to hide, don\'t let dad see it,\\""},", she says as you near home. You tentatively agree. And in the end he doesn\'t."]}]},"shopping_with_mom":{"id":"shopping_with_mom","type":"scene","title":"Shopping with Mom","subtitle":"An option of last resort","newPage":true,"viewIf":{"$code":"return ((((((Q[\'week\'] || 0) >= 4) && ((Q[\'week\'] || 0) <= 10)) && ((Q[\'week\'] || 0) != 6))) && ((Q[\'shopping\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'shopping\'] = 1;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 2;"}],"tags":["weekend"],"options":[{"id":"@shopping_with_mom.at_least_one","title":"At least one."}],"content":[{"type":"paragraph","content":"Historically, going shopping with mom has been one of your least favorite activities. This is true presently as well. However, this excursion is a necessary evil; you have a minimal number of clothing items that are fitting for the pageant. you need at least three and possibly four outfits: a dress for the interview (it has to be a dress), an evening gown, and athletic wear (no swimsuit thank God), plus something for the talent show (thankfully you already have a qipao for that). Unfortunately you own a negligible number of dresses, none of them appropriate for any of these situations."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"How many girls don\'t like to go shopping?\\""},", mom says as you enter the department store."]}]},"skip.w5_parents_1":{"id":"skip.w5_parents_1","onArrival":[{"$code":"Q[\'family\'] = 3;"}],"goTo":[{"id":"skip.end_skip"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.captain_thanks":{"id":"scioly_study_party.captain_thanks","options":[{"id":"@scioly_study_party.fuck_off","title":"\\"Fuck off.\\""},{"id":"@scioly_study_party.sigh_loudly","title":"Sigh loudly."}],"content":{"content":[{"type":"paragraph","content":"\\"Um, okay,\\" is what you manage to say."},{"type":"paragraph","content":"So you end up entering an ongoing game of apples to apples. You rub your eyes and look down at your cards. It\'s hard to have the presence of mind to even read the words."},{"type":"paragraph","content":["\\"Is ",{"type":"insert","insert":0}," having one of her episodes again?\\" It was Krishna, talking to no one in particular."]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"thanksgiving_party.wait":{"id":"thanksgiving_party.wait","viewIf":{"$code":"return ((Q[\'emily\'] || 0) >= 1);"},"options":[{"id":"@thanksgiving_party.know_you","title":"\\"Do I know you?\\""}],"content":[{"type":"paragraph","content":"Yes. You definitely know this person before. But it\'s not going to be a big deal because you must have met every Chinese kid who lives in this area at some point in your life."},{"type":"paragraph","content":"But somehow you feel like he\'s acting sort of strange around you. Something different from the usual awkwardness."}]},"scioly_2.protein_question_2_correct":{"id":"scioly_2.protein_question_2_correct","options":[{"id":"@scioly_2.pq2_a1","title":"Tryptophan"},{"id":"@scioly_2.pq2_a2","title":"Glutamic acid"},{"id":"@scioly_2.pq2_a3","title":"Methionine"},{"id":"@scioly_2.pq2_a4","title":"Histidine"}],"content":[{"type":"paragraph","content":"\\"It cuts up nucleic acids, like DNA or RNA.\\""},{"type":"paragraph","content":"\\"Right. Which of the following amino acids contains sulfur: tryptophan, glutamic acid, methionine, or histidine?\\""}]},"aubrey_final.why_hold_hand":{"id":"aubrey_final.why_hold_hand","options":[{"id":"@aubrey_final.okay_hold_hand","title":"\\"...Okay?\\""},{"id":"@aubrey_final.sorry_hold_hand","title":"\\"...Sorry, but...\\""}],"content":[{"type":"paragraph","content":"\\"Um..., why?\\""},{"type":"paragraph","content":"\\"I just felt like it, I guess. Why not?\\""}]},"birthday.miri_party_3":{"id":"birthday.miri_party_3","options":[{"id":"@birthday.success","title":"This party was... a success?"}],"content":[{"type":"paragraph","content":"The two of you spend the way watching Miri\'s latest yuri series, this one about Japanese high school girls who play mahjong. Girls with improbable bodies and short skirts who play mahjong and are supposedly gay but not really. It\'s horrible, of course, but so what? She laughs. You laugh. Maybe she does care about you after all. Or something like that?"},{"type":"paragraph","content":"\\"Oh yeah, and here\'s your present. It\'s another, uh, Japanimation product. Hope you\'ll keep it.\\" It\'s a Madoka Magica DVD set. That was one of the first anime series the two of you watched together, and probably the first anime you really enjoyed."},{"type":"paragraph","content":"\\"Oh, uh, thanks.\\""},{"type":"paragraph","content":"\\"There\'s a gift card too.\\" Miri looks almost bashful."},{"type":"paragraph","content":"The two of you spend time just... hanging out or whatever. But it\'s fine; you aren\'t physically hurting anymore, and you\'re feeling better after hanging out with miri."}]},"christmas_party.come_out_to_aubrey":{"id":"christmas_party.come_out_to_aubrey","onArrival":[{"$code":"Q[\'come_out_christmas_party\'] = 1;"}],"options":[{"id":"@christmas_party.watch_it_unfold","title":"Watch it unfold."}],"content":[{"type":"paragraph","content":"The two of you reenter Aubrey\'s room. No one else is there. You take a peek at Emily\'s face. No expression, as usual."},{"type":"paragraph","content":"\\"What took you guys so long?\\", Aubrey asks."},{"type":"paragraph","content":"\\"Hey, um,\\" you begin."},{"type":"paragraph","content":"\\"I\'m trans. I\'m a girl,\\" Emily says, ripping the bandaid right off."},{"type":"paragraph","content":"\\"What? Wait, what?\\""}]},"church_1.karen_talk":{"id":"church_1.karen_talk","options":[{"id":"@church_1.huh","title":"\\"Huh?\\""}],"content":{"content":{"type":"paragraph","content":["\\"Hey ",{"type":"insert","insert":0},", are you thinking about something?\\", Aubrey asks you out of the blue."]},"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"emily_1.meet_again":{"id":"emily_1.meet_again","goTo":[{"id":"emily_1.emily_goodbye"}],"content":{"content":"\\"Um, see you later?\\", you say. You kind of want to see her again. Well, that depends on what she wants.","type":"paragraph"}},"emily_6.gratified":{"id":"emily_6.gratified","options":[{"id":"@emily_6.emily_parents","title":"Sit and wait."}],"content":[{"type":"paragraph","content":"\\"Um, thanks...\\" is all you can say."},{"type":"paragraph","content":"\\"I think that drug production is what I would study, if I were doing genetic engineering. We could engineer yeast or E. coli to produce essential drugs. Do you think that\'s feasible?\\""},{"type":"paragraph","content":"\\"Yeah... well, biosynthesis is kind of hard because every chemical is going to have a radically different synthesis pathway so you have to focus on one drug, and even after that, it\'s hard to get the microbe to produce a useful quantity of the substance in question, because there\'s no selective advantage to producing the stuff that you want it to produce is not going to help the organism survive and reproduce and may in fact be detrimental, so there\'s just, so many variables that you would have to optimize, and you\'re messing with a system that\'s already had billions of years to develop, and like with all in-vitro systems it\'s just... like...\\""},{"type":"paragraph","content":"You take a break from your science-induced rant to glance at Emily. For some reason she\'s still smiling and nodding."},{"type":"paragraph","content":"\\"That\'s fascinating. No really, it is.\\""},{"type":"paragraph","content":"It feels like there\'s nothing more to talk about here, so you both stay silent for a while."}]},"emily_7.okay_ramble":{"id":"emily_7.okay_ramble","content":[{"type":"paragraph","content":"\\"Okay...\\" Emily stares off into the distance. It is a while before she restarts speaking."},{"type":"paragraph","content":"\\"I... sorry. Sometimes I get carried away with weird ideas and stuff.\\""},{"type":"paragraph","content":"\\"It\'s fine.\\""},{"type":"paragraph","content":"\\"Yeah... well okay.\\""},{"type":"paragraph","content":"Emily doesn\'t seem to want to talk anymore. And to be honest, neither do you."}]},"emily_final.ask_picture":{"id":"emily_final.ask_picture","content":[{"type":"paragraph","content":"You: Can you send me a picture of your current situation? I just want to know that you\'re really home..."},{"type":"paragraph","content":"Is this attempting to do a good deed? Or paranoia? Or...?"},{"type":"paragraph","content":"Emily: Lol alright. I wouldn\'t lie to you even if I were more self-destructive, by the way."},{"type":"paragraph","content":"She sends a selfie of her infront of her house. Her face is totally obscured by the darkness, but the house is lit."},{"type":"paragraph","content":"You: Thanks... sorry about that..."},{"type":"paragraph","content":"Emily: It\'s okay."},{"type":"paragraph","content":"She is logged off. It is almost midnight. You are alone in your room, with no sounds save the apartment\'s heating. You still have homework to do, and the pageant less than a week away. You are not going to sleep, for now."}]},"emily_final":{"id":"emily_final","type":"scene","title":"Emily","subtitle":"Escape","newPage":true,"viewIf":{"$code":"return ((((((Q[\'emily\'] || 0)===8) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'stress\'] || 0) < 15)) && ((Q[\'week\'] || 0)===11)) && ((Q[\'weekly_emily\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'emily\'] = (Q[\'emily\'] || 0) + 1;\\nQ[\'pageant_interview\'] = (Q[\'pageant_interview\'] || 0) + 1;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 1;"}],"tags":["top","social"],"options":[{"id":"@emily_final.what","title":"\\"Wait, what?\\""}],"content":[{"type":"paragraph","content":"It is late in the evening, and you are in your room alone. You are using the abominable internet platform known as \\"Facebook Messenger\\" in order to communicate with Emily. You\'ve been talking with her more and more, almost becoming habituated to her presence online."},{"type":"paragraph","content":"Emily: I\'m about to do something very drastic and self-destructive. Can you tell me not to do it?"},{"type":"paragraph","content":"You: What?"},{"type":"paragraph","content":"Emily: I\'m considering running away from home."}]},"epilogue.ep_aubrey_date":{"id":"epilogue.ep_aubrey_date","maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"viewIf":{"$code":"return ((Q[\'aubrey_date\'] || 0)===2);"},"content":{"type":"paragraph","content":["After your date with Aubrey, she asked if you could do something like that again, but as friends. Friend-dates or something like that. Apparently it\'s an actual ritual that a lot of women partake in. Sure, why not, you said. It can\'t be that bad. And it isn\'t. But part of you still has ",{"type":"emphasis-1","content":"feelings"}," for her, and you still wonder..."]},"countVisitsMax":1},"miri_date.sorry":{"id":"miri_date.sorry","options":[{"id":"@miri_date.preemptive","title":"\\"Actually I am preemptively apologizing for my failure to be a good friend/girlfriend by being unable to emotionally assist you in a moment of need...\\""},{"id":"@miri_date.actually_2","title":"\\"Actually I am sorry about the state of the world today...\\""}],"content":[{"type":"paragraph","content":"\\"Um, sorry...?\\", you say, not knowing what else to say exactly."},{"type":"paragraph","content":"\\"Yeah, I mean, it\'s not your fault. You don\'t have to say sorry.\\""}]},"miri_pageant_prep.wtf":{"id":"miri_pageant_prep.wtf","options":[{"id":"@miri_pageant_prep.next_question_2","title":"\\"Next question.\\""},{"id":"@miri_pageant_prep.followup","title":"\\"What\'s the followup?\\""}],"content":[{"type":"paragraph","content":"\\"What the heck? Wait, where are you getting these questions?\\""},{"type":"paragraph","content":"\\"Second google result for \'beauty pageant questions\'. thepageantplanet dot com. You can look it up yourself.\\""},{"type":"paragraph","content":"You do just that, and there it is. \\"Like, what the heck am I supposed to say here? That I\'m gay, or something like that?\\""},{"type":"paragraph","content":"\\"You could just say that you don\'t have a boyfriend. But then there\'s the follow up.\\""}]},"pageant_prep_self_2.cause":{"id":"pageant_prep_self_2.cause","onArrival":[{"$code":"Q[\'platform_doc_completed\'] = 1;"}],"content":[{"type":"paragraph","content":"But how the heck are you going to do that? Looking online, it turns out that for the pageant, you don\'t actually have to do anything concrete; you just have to advocate for your cause. Which means writing an essay and giving a short speech. And that\'s it."},{"type":"paragraph","content":"Well, that won\'t be too bad, would it? You won\'t have to go door to door, begging people for money. You\'ve never even gone trick-or-treating; how the heck would you beg for money for a \\"good cause\\"? Anyway, it\'s good that you don\'t need to do that."},{"type":"paragraph","content":"But you do have to write that speech, and essay."},{"type":"paragraph","content":"Thus, eventually you get some writing and editing done. Whatever."}]},"pageant_final.pick_evening_dress":{"id":"pageant_final.pick_evening_dress","options":[{"id":"@pageant_final.already_picked_dress","title":"You\'ve already picked out your outfit."},{"id":"@pageant_final.havent_picked_dress","title":"Mom picked an outfit for you."}],"content":{"content":"Now, you have to pick your outfit for the evening dress.","type":"paragraph"}},"pageant_meetup.social":{"id":"pageant_meetup.social","options":[{"id":"@pageant_meetup.socialize_emily","title":"Socialize with Emily."},{"id":"@pageant_meetup.socialize_new_girl","title":"Socialize with the girl you saw earlier."},{"id":"@pageant_meetup.socialize_ashley","title":"Socialize with Ashley."},{"id":"@pageant_meetup.socialize_none","title":"Leave early."},{"id":"@pageant_meetup.socialize_none_emily","title":"Leave early."}],"content":{"content":"After the speeches, there\'s a period for the pageant contestants to socialize. You\'re supposed to get to know each other, or something like that.","type":"paragraph"}},"research_final.could_use_help":{"id":"research_final.could_use_help","options":[{"id":"@research_final.back_to_work","title":"You get back to work."}],"content":[{"type":"paragraph","content":"\\"Um... okay, thanks? But like, I\'m not even close to starting that.\\""},{"type":"paragraph","content":"\\"Well, okay! When you get to that point feel free to ask me questions at any time, even if you\'re not working here anymore.\\""},{"type":"paragraph","content":"\\"Thanks...\\""},{"type":"paragraph","content":"\\"Yeah, no problem!\\""}]},"scioly_invitational.cell_okay":{"id":"scioly_invitational.cell_okay","viewIf":{"$code":"return ((Q[\'cell\'] || 0)===1);"},"options":[{"id":"@scioly_invitational.waiting","title":"Now you have to wait."}],"content":{"content":"It\'s more difficult than you had hoped, and Krishna seems to agree.","type":"paragraph"}},"skip.w5_parents_3":{"id":"skip.w5_parents_3","onArrival":[{"$code":"Q[\'family\'] = 0;"}],"goTo":[{"id":"skip.end_skip"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.fuck_off":{"id":"scioly_study_party.fuck_off","goTo":[{"id":"scioly_study_party.having_a_moment"}],"content":{"content":"You glare at him, your eyes still a bit puffy. \\"Fuck off,\\" you whisper.","type":"paragraph"}},"thanksgiving_party.know_you":{"id":"thanksgiving_party.know_you","onArrival":[{"$code":"Q[\'meet_emily\'] = 1;"}],"options":[{"id":"@thanksgiving_party.okay","title":"Okay..."}],"content":[{"type":"paragraph","content":"\\"Um...\\" You\'re not sure how to phrase it without being rather awkward. \\"Do I, um, know you or something?\\""},{"type":"paragraph","content":"He stares at you for a moment, as if thinking about something."},{"type":"paragraph","content":"\\"I\'m Emily Chen.\\""},{"type":"paragraph","content":"\\"Oh. Wait, what?\\""},{"type":"paragraph","content":"He (no, she?) coughs a few times. \\"God, fuck.\\" Her voice sounds different, somehow. \\"I fucking hate this. Sorry by the way. I\'m trans. I\'m a trans girl. God it sounds so fucking ridiculous to say this. If you didn\'t know that before. Still 90% closeted. My parents hate me.\\""}]},"scioly_2.pq2_a1":{"id":"scioly_2.pq2_a1","goTo":[{"id":"scioly_2.pq2_wrong"}],"content":{"content":"\\"Tryptophan?\\"","type":"paragraph"}},"aubrey_final.okay_hold_hand":{"id":"aubrey_final.okay_hold_hand","onArrival":[{"$code":"Q[\'aubrey_hold_hand\'] = 1;"}],"options":[{"id":"@aubrey_final.am_i_someone","title":"\\"Am I someone you care about?\\""},{"id":"@aubrey_final.is_she_someone","title":"Is she someone you care about?"}],"content":[{"type":"paragraph","content":"\\"Um..., okay?\\""},{"type":"paragraph","content":"She reaches towards your lap, and lays her gloved hand on top of your bare hand. You place your other hand on top of hers."},{"type":"paragraph","content":"\\"Hey, this is nice!\\", she says."},{"type":"paragraph","content":"\\"Yeah. It is.\\""},{"type":"paragraph","content":"Now Aubrey leans her body against you. \\"Isn\'t it nice to just sit close to someone you care about like this?\\""}]},"birthday.success":{"id":"birthday.success","content":{"content":"","type":"paragraph"}},"christmas_party.watch_it_unfold":{"id":"christmas_party.watch_it_unfold","options":[{"id":"@christmas_party.dinner","title":"The call to dinner saves you."}],"content":{"content":[{"type":"paragraph","content":"Emily coughs. \\"I\'m a trans girl,\\" she says. \\"So like, I was assigned male at birth, see, and now I\'m a girl.\\""},{"type":"paragraph","content":["\\"Oh. So...\\" Aubrey looks at Emily, and then at you. \\"",{"type":"insert","insert":0},", did you know this already?\\""]},{"type":"paragraph","content":"\\"She does,\\" Emily says."},{"type":"paragraph","content":"\\"But you\'re like, genetically male, right?\\""},{"type":"paragraph","content":"You cringe. Emily visibly rolls her eyes. \\"Human biology is more complicated than that,\\" she says. \\"There are things more important than chromosomal configuration. Life finds a way, with the help of technology.\\""},{"type":"paragraph","content":"\\"Oh, uh. Okay. What do you want me to do?\\""},{"type":"paragraph","content":"Emily sighs. \\"Sorry. This wasn\'t a good idea. Forget I said anything.\\""},{"type":"paragraph","content":"\\"I can\'t just forget that, can I?\\""},{"type":"paragraph","content":"\\"Yes. You can.\\""}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"church_1.huh":{"id":"church_1.huh","options":[{"id":"@church_1.relax","title":"Try to relax."}],"content":[{"type":"paragraph","content":"\\"Huh? Oh. Why?\\""},{"type":"paragraph","content":"\\"You look like you\'re smiling to yourself.\\""},{"type":"paragraph","content":"\\"Really?\\""},{"type":"paragraph","content":"\\"Yeah. It\'s really noticeable.\\""}]},"emily_1.maybe_not_meet_again":{"id":"emily_1.maybe_not_meet_again","goTo":[{"id":"emily_1.emily_goodbye"}],"content":{"content":"\\"Um, goodbye?\\", you say. You\'re not sure if you would ever see her again. Well, that depends on what she wants.","type":"paragraph"}},"emily_6.no_secret":{"id":"emily_6.no_secret","onArrival":[{"$code":"Q[\'emily\'] = 7;"}],"options":[{"id":"@emily_6.emily_parents","title":"Sit and wait."}],"content":[{"type":"paragraph","content":"\\"My secret is that, uh, I don\'t want to tell you. Sorry.\\" That came off as more brusque than you had intended."},{"type":"paragraph","content":"\\"Well, that\'s fine. That\'s okay.\\" Emily looks back down at her lap. \\"Sorry if I\'m being weird.\\""},{"type":"paragraph","content":"\\"No, it\'s not weird...\\""},{"type":"paragraph","content":"Emily stays silent for a while."}]},"emily_7.real_question":{"id":"emily_7.real_question","viewIf":{"$code":"return ((Q[\'emily_date\'] || 0)===1);"},"options":[{"id":"@emily_7.answer_no","title":"No."},{"id":"@emily_7.answer_yes","title":"(lie) Yes."}],"content":[{"type":"paragraph","content":"\\"So the real question is, would you still be interested in dating me if I were a boy?\\""},{"type":"paragraph","content":"More logic bombs from Emily tonight. What does she want to say? There are potential reasons that she would desire either answer but... What do you think, actually? Do you actually have an idea distinct from your interpolation of her desires for your answer?"}]},"epilogue.ep_aubrey_friends":{"id":"epilogue.ep_aubrey_friends","maxVisits":1,"goTo":[{"id":"epilogue.all_epilogues"}],"viewIf":{"$code":"return ((Q[\'aubrey_date\'] || 0) < 2);"},"content":{"content":"Your \\"relationship\\" with Aubrey hasn\'t changed much. Perhaps your one-time crush on her has diminished. You still spend time with her at the Saturday bible study gatherings that you attend with your family, and at science olympiad, but not much besides.","type":"paragraph"},"countVisitsMax":1},"epilogue":{"id":"epilogue","type":"scene","title":"Epilogue","newPage":true,"onArrival":[{"$code":"Q[\'week\'] = 100;"}],"tags":["ending","top"],"goTo":[{"id":"epilogue.all_epilogues"}],"content":{"type":"heading","content":"Epilogues"}},"miri_date.preemptive":{"id":"miri_date.preemptive","goTo":[{"id":"miri_date.inches_closer"}],"content":[{"type":"paragraph","content":"You have a weird thought, but can you actually say something like that? You take time putting the words together in your mind. Then you take deep breaths."},{"type":"paragraph","content":"\\"Um, I\'m sorry that I\'m not really good at, like, being comforting...\\""},{"type":"paragraph","content":"Miri laughs. \\"It\'s fine!\\""}]},"miri_pageant_prep.followup":{"id":"miri_pageant_prep.followup","goTo":[{"id":"miri_pageant_prep.next_question_2"}],"options":[{"id":"@miri_pageant_prep.next_question_2","title":"\\"Next question.\\""}],"content":[{"type":"paragraph","content":"\\"What\'s the followup? I hope it\'s not something like... why don\'t you have a boyfriend.\\""},{"type":"paragraph","content":"\\"If your boyfriend didn\'t want you to compete in pageants, what would you say?\\""},{"type":"paragraph","content":"You grimace."}]},"pageant_prep_self_2.pageant_prep_done":{"id":"pageant_prep_self_2.pageant_prep_done","content":{"content":"Anyway, you\'re done with this for tonight. No point in spending more time.","type":"paragraph"}},"pageant_prep_self_2":{"id":"pageant_prep_self_2","type":"scene","title":"Pageant Prep","subtitle":"Home, on the internet","newPage":true,"viewIf":{"$code":"return (((((((Q[\'week\'] || 0) >= 1) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'pageant_prep\'] || 0) >= 2)) && ((Q[\'stress\'] || 0) < 15)) && ((((((Q[\'pageant_talent\'] || 0) < 3) || ((Q[\'pageant_appearance\'] || 0) < 3)) || ((Q[\'pageant_interview\'] || 0) < 3)) || ((Q[\'pageant_platform\'] || 0) < 3)))) && ((Q[\'week\'] || 0) < 10));"},"onArrival":[{"$code":"Q[\'pageant_prep\'] = (Q[\'pageant_prep\'] || 0) + 1;\\nQ[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"tags":["top","pageant_prep"],"options":[{"id":"@pageant_prep_self_2.pageant_chances","title":"What are your current chances?"},{"id":"@pageant_prep_self_2.details_2","title":"Paperwork. There\'s always paperwork."},{"id":"@pageant_prep_self_2.details","title":"Look up details about the pageant."},{"id":"@pageant_prep_self_2.clothes","title":"Find clothes and figure out your appearance."},{"id":"@pageant_prep_self_2.social","title":"Interview practice."},{"id":"@pageant_prep_self_2.platform","title":"Platform preparation."},{"id":"@pageant_prep_talent_1","title":"Talent practice."}],"content":{"content":"You find yourself at home in the evening, on the internet, as usual. And instead of browsing Wikipedia, perhaps you could take this opportunity to prepare for the pageant.","type":"paragraph"}},"pageant_final.already_picked_dress":{"id":"pageant_final.already_picked_dress","viewIf":{"$code":"return ((Q[\'ball_gown\'] || 0) > 0);"},"goTo":[{"id":"pageant_final.going_to_pageant"}],"content":{"content":[{"type":"paragraph","content":["Yes, you had a ball gown that mom borrowed earlier. ",{"type":"conditional","content":"It is a black gown with a white bowtie belt. ","predicate":0}," ",{"type":"conditional","content":"It is a simple deep green strapless pleated dress. ","predicate":1}," ",{"type":"conditional","content":"It is a light blue V-neck dress. ","predicate":2}," ",{"type":"conditional","content":"It is a shiny blood-red strapless dress. ","predicate":3},""]},{"type":"paragraph","content":["It is already neatly packed. ",{"type":"conditional","content":"Unfortunately, you never got a chance to try it on, but mom assures you that it will fit.","predicate":4}]}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'ball_gown\'] || 0)===1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'ball_gown\'] || 0)===2);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'ball_gown\'] || 0)===3);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'ball_gown\'] || 0)===4);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'try_on_ball_gown\'] || 0)===0);"}}]}},"pageant_meetup.social_continue":{"id":"pageant_meetup.social_continue","options":[{"id":"@pageant_meetup.socialize_emily","title":"Socialize with Emily."},{"id":"@pageant_meetup.socialize_new_girl","title":"Socialize with the girl you saw earlier."},{"id":"@pageant_meetup.socialize_ashley","title":"Socialize with Ashley."},{"id":"@pageant_meetup.socialize_end","title":"Leave."}],"content":{"content":"","type":"paragraph"}},"research_final.what_help":{"id":"research_final.what_help","options":[{"id":"@research_final.back_to_work","title":"You get back to work."}],"content":[{"type":"paragraph","content":"\\"Um, thanks but I\'ve got it.\\""},{"type":"paragraph","content":"\\"Are you sure? Well, when you get to that point feel free to ask me questions at any time, even if you\'re not working here anymore.\\""},{"type":"paragraph","content":"\\"Thanks...\\""},{"type":"paragraph","content":"\\"Yeah, no problem!\\""}]},"scioly_invitational.cell_bad":{"id":"scioly_invitational.cell_bad","viewIf":{"$code":"return ((Q[\'cell\'] || 0)===0);"},"options":[{"id":"@scioly_invitational.waiting","title":"Now you have to wait."}],"content":{"content":"It\'s more difficult than you had hoped, and Krishna seems to agree.","type":"paragraph"}},"skip.skip_9":{"id":"skip.skip_9","onArrival":[{"$code":"Q[\'week\'] = 9;\\nQ[\'class_visited\'] = 1;"}],"options":[{"id":"@skip.w9_pageant_1","title":"You\'re doing well in preparing for the pageant."},{"id":"@skip.w9_pageant_2","title":"You haven\'t really prepared."}],"content":[{"type":"paragraph","content":"Skipping to week 9..."},{"type":"paragraph","content":"Pageant prep status:"}]},"scioly_study_party.sigh_loudly":{"id":"scioly_study_party.sigh_loudly","goTo":[{"id":"scioly_study_party.having_a_moment"}],"content":{"content":"You sigh loudly. Too loudly, you soon realize.","type":"paragraph"}},"thanksgiving_party.okay":{"id":"thanksgiving_party.okay","options":[{"id":"@thanksgiving_party.um_sure","title":"\\"Um, sure.\\""}],"content":[{"type":"paragraph","content":["You have no idea how to react. (You guess that she ",{"type":"emphasis-1","content":"did"}," look kinda feminine-ish??? And from her face, she did look like the Emily Chen you met before, minus a ton of makeup? You\'re curious about her but at the same time you feel super awkward so ...)"]},{"type":"paragraph","content":"\\"Whatever,\\" she says. \\"Don\'t fucking talk about this to anyone. Or else...\\""}]},"scioly_2.pq2_a2":{"id":"scioly_2.pq2_a2","goTo":[{"id":"scioly_2.pq2_wrong"}],"content":{"content":"\\"Glutamic acid?\\"","type":"paragraph"}},"aubrey_final.am_i_someone":{"id":"aubrey_final.am_i_someone","options":[{"id":"@aubrey_final.aubrey_silence_2","title":"She is silent."}],"content":[{"type":"paragraph","content":"\\"Um, am I someone you care about?\\""},{"type":"paragraph","content":["\\"I should be asking you that. Am ",{"type":"emphasis-1","content":"I"}," someone ",{"type":"emphasis-1","content":"you"}," care about?\\" She has a wide smile, perhaps a bit too wide."]},{"type":"paragraph","content":"\\"Um... yes? I guess?\\""},{"type":"paragraph","content":"\\"You don\'t sound very confident.\\""},{"type":"paragraph","content":"\\"Do I ever sound confident?\\""},{"type":"paragraph","content":"\\"Honestly, no, outside of like, class and science olympiad.\\""}]},"birthday.both_party":{"id":"birthday.both_party","viewIf":{"$code":"return (((Q[\'birthday_aubrey_invited\'] || 0)===1) && ((Q[\'birthday_miri_invited\'] || 0)===1));"},"onArrival":[{"$code":"Q[\'miri\'] = (Q[\'miri\'] || 0) + 1;\\nQ[\'aubrey\'] = (Q[\'aubrey\'] || 0) + 1;\\nQ[\'loneliness\'] = (Q[\'loneliness\'] || 0) - 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"options":[{"id":"@birthday.both_party_2","title":"Try to say something."}],"content":{"content":[{"type":"paragraph","content":"\\"So, this is a party!\\" Miri laughs. \\"I thought it would be just the two of us.\\""},{"type":"paragraph","content":["\\"Oh, hi, Miri, right?\\", Aubrey says with a quick wave. \\"I know your name but I don\'t really, like, know you. Do you know ",{"type":"insert","insert":0}," well?\\""]},{"type":"paragraph","content":"\\"Yeah! I\'m pretty sure I know her better than most other humans. Anyway, what are you doing here?\\""},{"type":"paragraph","content":"This is going to be an awkward day."}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"christmas_party.go_back_to_game":{"id":"christmas_party.go_back_to_game","options":[{"id":"@christmas_party.continue_game_2","title":"The game continues as before."}],"content":[{"type":"paragraph","content":"\\"What took you guys so long?\\", Aubrey asks as the two of you return."},{"type":"paragraph","content":"Emily shrugs. \\"Not much. We just knew each other from before.\\""},{"type":"paragraph","content":"\\"Huh.\\" Aubrey looks over to you, a little puzzled. \\"Okay.\\""}]},"church_1.relax":{"id":"church_1.relax","options":[{"id":"@church_1.no_talk","title":"And so on..."}],"content":[{"type":"paragraph","content":"\\"Oh. Um.\\" You try to shift your facial muscles, to look neutral. \\"Sorry.\\""},{"type":"paragraph","content":"\\"It\'s fine. But I\'m sort of curious now.\\" She laughs, and gently pats your arm. Oh God why."},{"type":"paragraph","content":"\\"It\'s nothing. I promise.\\""},{"type":"paragraph","content":"Aubrey laughs again. You imagine some awkwardness in the way she pulls away from you, as she carries her empty dish upstairs. Great. Your food is cold, but you finish it anyway. It tastes as usual. The kids are engrossed by Spencer as he tells them about some cartoon\'s backstory. Your brother Kevin has come downstairs, to join the other kids. Bible study must be boring."}]},"emily_1.emily_goodbye":{"id":"emily_1.emily_goodbye","content":[{"type":"paragraph","content":"\\"We\'ll meet again,\\" she says. \\"Next time we should go shopping or something.\\""},{"type":"paragraph","content":"She waves at you, and you wave back."}]},"emily_1":{"id":"emily_1","type":"scene","title":"Meeting with Emily","subtitle":"Downtown, Afternoon","newPage":true,"viewIf":{"$code":"return (((((Q[\'emily\'] || 0)===1) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'stress\'] || 0) < 15)) && ((Q[\'thanksgiving\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'emily\'] = (Q[\'emily\'] || 0) + 1;\\nQ[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 2;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 1;\\nQ[\'emily_1_seen\'] = 1;"}],"tags":["top","social"],"options":[{"id":"@emily_1.background","title":"You\'ve done your background research."}],"content":{"content":"Emily told you to wait for her at a downtown Starbucks. It was she who initiated this meeting; she asked you when you could meet, and you replied. But she\'s running late. You sip on your sugary strawberry drink; you don\'t drink coffee since your heart is beating fast enough as it is.","type":"paragraph"}},"emily_6.emily_parents":{"id":"emily_6.emily_parents","content":[{"type":"paragraph","content":"\\"I guess that\'s it for today?\\", Emily says. \\"My parents expect me at home. Before that I have to go change. And before that I have to take the bus to Lexington. So...\\""},{"type":"paragraph","content":"She gets up and glances at you. \\"Bye.\\""},{"type":"paragraph","content":"\\"Goodbye...\\" You wave as she walks away."}]},"emily_7.answer_no":{"id":"emily_7.answer_no","goTo":[{"id":"emily_7.performance"}],"content":[{"type":"paragraph","content":"\\"Um, probably not, I guess. Sorry.\\""},{"type":"paragraph","content":"Emily sighs. \\"That is the correct answer, yes. That was the answer I was looking for.\\" She glances at you, a small smile on her face. \\"God, I\'m honestly just... kind of terrified of being seen as a boy in any context. And maybe this is irrational but, like,... it\'s validating in a way. That you see me, like...\\""},{"type":"paragraph","content":"Her voice trails away. You don\'t know how to fill the silence. But then Emily continues."}]},"miri_date.actually_2":{"id":"miri_date.actually_2","goTo":[{"id":"miri_date.inches_closer"}],"content":[{"type":"paragraph","content":"\\"Actually I\'m, um, sorry about the state of the world today...\\""},{"type":"paragraph","content":"Miri laughs. \\"Hey, it\'s not your fault! You are like, literally the person least responsible for the shittinesss of the world.\\""}]},"miri_pageant_prep.next_question_2":{"id":"miri_pageant_prep.next_question_2","options":[{"id":"@miri_pageant_prep.needlessly_complicated","title":"That seems needlessly complicated"}],"content":[{"type":"paragraph","content":"\\"Next question.\\""},{"type":"paragraph","content":"\\"What would you say to people who don\'t believe that pageants are a good influence on women?\\""},{"type":"paragraph","content":"\\"Oh no. I\'d, uh, agree with them?\\""},{"type":"paragraph","content":"\\"No, see, that\'s the wrong answer. You can\'t answer these things honestly, well unless you\'re honestly a total loser. You have to think from the perspective of the pageant organizers. What answers would they want to hear? But you can\'t answer exactly what they want to hear, because then they\'ll know that you\'re cheating, or preparing too much. You have to say almost what they want to hear, but change it up just enough to make it seem like that\'s your actual opinion. And you have to make it sound like you\'re coming up with the answer on the spot.\\""}]},"pageant_final.havent_picked_dress":{"id":"pageant_final.havent_picked_dress","onArrival":[{"$code":"Q[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) - 2;\\nQ[\'ball_gown\'] = 2;"}],"goTo":[{"id":"pageant_final.going_to_pageant"}],"content":{"content":"Mom borrowed a ball gown without consultation on your part. It\'s a dark green strapless dress, looking somewhat formal and somber. Unfortunately you don\'t even have time to try it on; mom assures you that it will fit.","type":"paragraph"}},"pageant_meetup.socialize_emily":{"id":"pageant_meetup.socialize_emily","viewIf":{"$code":"return (((Q[\'sit_emily\'] || 0)===1) && ((Q[\'emily\'] || 0)===0));"},"options":[{"id":"@pageant_meetup.socialize_emily_2","title":"\\"Yeah...\\""}],"content":[{"type":"paragraph","content":"You close your eyes, and feel your heartbeat rise. You can do this; just talk to her, how hard can it be?"},{"type":"paragraph","content":"\\"Um, hi,\\" you manage to say."},{"type":"paragraph","content":"\\"Hi,\\" she replies. \\"I guess we\'re supposed to socialize or whatever. Haha.\\""},{"type":"paragraph","content":"\\"Um, yeah.\\" This is awkward, not that you expect any different."},{"type":"paragraph","content":"\\"So, are you doing the pageant?\\", she asks after a pause."}]},"research_final.back_to_work":{"id":"research_final.back_to_work","content":{"content":"Stella is on her laptop, writing her thesis and making presentations or something like that. You\'re back to coding, only taking occasional glances at the unrelated papers from before she came. The two of you don\'t talk much, only glancing at each others\' screens in a semi-futile attempt at keeping yourselves on task.","type":"paragraph"}},"research_final":{"id":"research_final","type":"scene","title":"Research","subtitle":"Future plans","newPage":true,"viewIf":{"$code":"return ((((((Q[\'week\'] || 0)===11) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'research\'] || 0) >= 4)) && ((Q[\'weekly_research\'] || 0)===0)) && ((Q[\'stress\'] || 0) < 15));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'research\'] = (Q[\'research\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'weekly_research\'] = 1;"}],"tags":["top","research"],"options":[{"id":"@research_final.ips","title":"Assisted reproduction"},{"id":"@research_final.quantum","title":"Quantum mechanics"},{"id":"@research_final.climate","title":"Climate change"}],"content":[{"type":"paragraph","content":"Physically you are in the lab, but mentally you are elsewhere."},{"type":"paragraph","content":"Granted, you are still reading about science, but not the kind of science that you are supposed to be working on. Instead you are investigating the far more interesting science of..."}]},"scioly_invitational.waiting":{"id":"scioly_invitational.waiting","goTo":[{"id":"scioly_invitational.medal_ceremony_disease"}],"content":{"content":"There\'s about 30 minutes between your final event and the start of the medal ceremony. You have some time to go outside and wander around campus for a bit, by yourself. The cold is invigorating, and you need some time away from the others.","type":"paragraph"}},"skip.w9_pageant_1":{"id":"skip.w9_pageant_1","onArrival":[{"$code":"Q[\'pageant_prep\'] = 8;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 4;\\nQ[\'pageant_talent\'] = (Q[\'pageant_talent\'] || 0) + 2;\\nQ[\'pageant_platform\'] = (Q[\'pageant_platform\'] || 0) + 2;\\nQ[\'pageant_interview\'] = (Q[\'pageant_interview\'] || 0) + 2;\\nQ[\'pageant_details\'] = (Q[\'pageant_details\'] || 0) + 1;\\nQ[\'pageant_paperwork\'] = (Q[\'pageant_paperwork\'] || 0) + 1;\\nQ[\'resume_completed\'] = (Q[\'resume_completed\'] || 0) + 1;\\nQ[\'platform_doc_completed\'] = 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 2;"}],"goTo":[{"id":"skip.w9_scioly_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.having_a_moment":{"id":"scioly_study_party.having_a_moment","options":[{"id":"@scioly_study_party.eye_contact_david","title":"Make eye contact with David Nguyen."},{"id":"@scioly_study_party.cry_again","title":"Make eye contact with Aubrey Gao."},{"id":"@scioly_study_party.eye_contact_none","title":"Keep to yourself."}],"content":{"content":[{"type":"paragraph","content":"\\"Yep, she\'s definitely having one of those episodes,\\" Krishna continues. \\"Just one of those days, huh?\\""},{"type":"paragraph","content":["\\"Hey, stop it,\\" the captain snaps at Krishna. Then to you, \\"",{"type":"insert","insert":0},", are you alright? Do you need anything?\\""]},{"type":"paragraph","content":"\\"No. I mean, I don\'t need anything...\\""},{"type":"paragraph","content":"You feel as if you\'re about to cry again, but you try to force the feeling away. You take a glance around the circle. Everyone is acting as if you don\'t exist, as is usual. Except..."}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"thanksgiving_party.um_sure":{"id":"thanksgiving_party.um_sure","options":[{"id":"@thanksgiving_party.special","title":"\\"Oh.\\""}],"content":[{"type":"paragraph","content":"\\"Um, sure. Of course,\\" you say, or something like that. You look away. You should do your homework. It\'s the safe option. \\"Sorry,\\" you say, for lack of anything else to say."},{"type":"paragraph","content":"\\"No, it\'s... just, I\'m so sorry,\\" Emily says."},{"type":"paragraph","content":"\\"No, I\'m sorry,\\" you say."},{"type":"paragraph","content":"For some reason Emily starts chuckling to herself. \\"It\'s fine,\\" she says. \\"Just, like, take it easy here. I\'m literally closeted to like everyone I know IRL.\\""},{"type":"paragraph","content":"\\"Except me?\\""},{"type":"paragraph","content":"\\"Yeah I guess?\\""}]},"scioly_2.pq2_a3":{"id":"scioly_2.pq2_a3","goTo":[{"id":"scioly_2.pq3"}],"content":[{"type":"paragraph","content":"\\"Methionine?\\""},{"type":"paragraph","content":"\\"Correct. The other amino acid that contains sulfur is cysteine.\\""}]},"aubrey_final.is_she_someone":{"id":"aubrey_final.is_she_someone","options":[{"id":"@aubrey_final.aubrey_silence_2","title":"She is silent."}],"content":[{"type":"paragraph","content":"Is Aubrey someone you care about? Yes, of course. Otherwise, why would you be sitting here with her?"},{"type":"paragraph","content":"\\"So, am I someone you care about?\\", she asks. She has a wide smile, perhaps a bit too wide."},{"type":"paragraph","content":"\\"Um... yes? I guess?\\""},{"type":"paragraph","content":"\\"You don\'t sound very confident.\\""},{"type":"paragraph","content":"\\"Do I ever sound confident?\\""},{"type":"paragraph","content":"\\"Honestly, no, outside of like, class and science olympiad.\\""}]},"birthday.both_party_2":{"id":"birthday.both_party_2","options":[{"id":"@birthday.both_party_3","title":"Say something."},{"id":"@birthday.hug_miri","title":"Hug Miri."},{"id":"@birthday.hug_aubrey","title":"Hug Aubrey."}],"content":[{"type":"paragraph","content":"You\'re frozen in place. Aubrey and Miri have started to hit it off. They\'re talking to each other. Their words are coherent but you don\'t hear them. You\'re alone, staring awkwardly, tossing your phone from one hand to the other. Your brain can\'t focus. Your hand is trembling. You drop the phone."},{"type":"paragraph","content":"\\"Oh, sorry!\\", Miri says. \\"I can\'t believe we were ignoring you on your birthday!\\""},{"type":"paragraph","content":"She walks closer to you and puts her arm around your shoulder. Aubrey watches. \\"What do you want to do?\\", she asks."},{"type":"paragraph","content":"\\"Um...\\" Your eyes dart, to Miri, to Aubrey, to the stain on the carpet, to the ceiling, averting their gazes. You try to say something."}]},"christmas_party.continue_game_2":{"id":"christmas_party.continue_game_2","options":[{"id":"@christmas_party.you_win","title":"You win the first round of Scrabble."},{"id":"@christmas_party.you_win_emily_leaves","title":"You win the first round of Scrabble."}],"content":[{"type":"paragraph","content":"One of the younger kids comes in. \\"Can you help us with the TV?\\", he says to Aubrey. Then to Emily, \\"You sit like a girl\\". Emily is sitting with her legs tucked to the side."},{"type":"paragraph","content":"\\"Thanks,\\" Emily replies, her face blank as usual. You almost feel like snickering, and you can\'t help but grin a little. Hopefully no one notices."},{"type":"paragraph","content":"\\"Sorry about that,\\" Aubrey says."},{"type":"paragraph","content":"\\"I took it as a compliment,\\" Emily says."}]},"church_1.no_talk":{"id":"church_1.no_talk","content":{"content":"It\'s almost 10 when your mom calls you to leave. By that time, you\'re thinking about all the homework that still has to be done, and how you messed everything up once more.","type":"paragraph"}},"emily_6.girl_1":{"id":"emily_6.girl_1","viewIf":{"$code":"return ((Q[\'miri_date\'] || 0)===0);"},"options":[{"id":"@emily_6.know_well","title":"\\"I\'ve known her for a while, but...\\""},{"id":"@emily_6.dont_know_well","title":"\\"I don\'t know her very well, but...\\""}],"content":{"content":"\\"So, there\'s this girl...\\"","type":"paragraph"}},"emily_7.answer_yes":{"id":"emily_7.answer_yes","options":[{"id":"@emily_7.yes_sorry","title":"\\"Sorry...\\""}],"content":[{"type":"paragraph","content":"\\"Um... yes? I guess?\\""},{"type":"paragraph","content":"Emily stares at you for a moment. \\"You\'re lying,\\" she says. \\"And you gave the wrong answer. Did you think that would be the more socially acceptable answer? Really?\\""},{"type":"paragraph","content":"Oh no. You fucked up. You were always bad at lying. The probability that you\'ve irreparably damaged your nascent relationship with Emily is rising exponentially and there\'s absolutely nothing you can do about it and..."},{"type":"paragraph","content":"\\"Sorry...\\" you mutter."},{"type":"paragraph","content":"\\"It\'s fine.\\" She sighs. \\"On the one hand, I\'m glad that you were thinking the correct answer even if you didn\'t say it. On the other hand I\'m kind of disappointed that you didn\'t understand the situation well enough to just say what you really thought. And that you would lie about it.\\""}]},"miri_date.inches_closer":{"id":"miri_date.inches_closer","options":[{"id":"@miri_date.stop_saying_sorry","title":"\\"You don\'t have to say sorry.\\""},{"id":"@miri_date.sure_go_ahead","title":"\\"Sure, go ahead...\\""},{"id":"@miri_date.please_dont","title":"\\"Please don\'t...\\""}],"content":[{"type":"paragraph","content":"She inches closer towards you. Her hand is on top of yours. It\'s warm."},{"type":"paragraph","content":"\\"Sorry, is it okay if I hold your hand right now?\\""}]},"miri_pageant_prep.needlessly_complicated":{"id":"miri_pageant_prep.needlessly_complicated","options":[{"id":"@miri_pageant_prep.waste_of_time","title":"Waste of time?"},{"id":"@miri_pageant_prep.but_it_was_fun","title":"But, it was fun spending time with Miri. Right?"}],"content":[{"type":"paragraph","content":"\\"That seems... needlessly complicated. And cynical. Like, I mean, I thought they would grade on how well you answer, not what you say.\\""},{"type":"paragraph","content":"\\"It\'s obviously both. They care about how you answer it, and what your answer is. For the basic questions it\'s more how you answer them.\\" Miri smirks as she stares at her phone. \\"It\'s just like college application essays, isn\'t it? And you should be plenty familiar with those.\\""},{"type":"paragraph","content":"You can\'t help but sigh. \\"I should be, but, like, I guess I\'m not.\\""},{"type":"paragraph","content":"The two of you keep up this pageant interview game until dusk. She always picks the weird questions, and you dodge them. In the end, you\'re not sure if you actually learned anything that would help in the pageant. And you missed out on time you could have spent chipping away at your copious quantity of homework."}]},"pageant_final.going_to_pageant":{"id":"pageant_final.going_to_pageant","options":[{"id":"@pageant_final.high_heel_shoes","title":"High-heel shoes?"},{"id":"@pageant_final.shoes","title":"Shoes?"}],"content":{"type":"paragraph","content":["What else do you need? Athletic wear? Your ",{"type":"emphasis-1","content":"erhu"}," and a ",{"type":"emphasis-1","content":"qipao"}," to wear for the talent show? Got it."]}},"pageant_meetup.socialize_new_girl":{"id":"pageant_meetup.socialize_new_girl","viewIf":{"$code":"return (((Q[\'sit_emily\'] || 0)===0) && ((Q[\'emily\'] || 0)===0));"},"options":[{"id":"@pageant_meetup.socialize_emily_2","title":"\\"Yeah...\\""}],"content":{"content":[{"type":"paragraph","content":"You find the girl you met on the way in, still sitting in the back corner. She\'s one of the very few Asians in this room, and while she looks intimidating, she\'s somehow less so than any of the others here. You close your eyes, and feel your heartbeat rise. You can do this; just talk to her, how hard can it be?"},{"type":"paragraph","content":"\\"Um, hi,\\" you say."},{"type":"paragraph","content":"\\"Hi. I think I saw you earlier? My name\'s Emily. Emily Chen.\\""},{"type":"paragraph","content":["\\"I\'m ",{"type":"insert","insert":0}," Zhao...\\" An awkward pause. \\"So, um, are you doing the pageant?\\""]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"scioly_invitational.medal_ceremony_disease":{"id":"scioly_invitational.medal_ceremony_disease","options":[{"id":"@scioly_invitational.medal_ceremony_disease_gold","title":"Gold!"},{"id":"@scioly_invitational.medal_ceremony_disease_bronze","title":"Bronze!"},{"id":"@scioly_invitational.medal_ceremony_disease_none","title":"No medal :("}],"content":[{"type":"paragraph","content":"The medal ceremony takes place in a dark and cavernous auditorium. Its primary attribute is that it involves even more waiting. There has been a lot of waiting today. You find a seat between Aubrey and the captain."},{"type":"paragraph","content":"\\"How did it go?\\", the captain asks."},{"type":"paragraph","content":"You shrug. \\"Okay, I guess.\\""},{"type":"paragraph","content":"\\"Hey, don\'t worry! I\'m sure you did great!\\""},{"type":"paragraph","content":"Your school is not one of the \\"good\\" ones, not compared to the rich suburban schools, so despite the captain\'s words no one is expecting to do particularly well."},{"type":"paragraph","content":"The first event of yours to be announced is Disease Detectives."}]},"skip.w9_pageant_2":{"id":"skip.w9_pageant_2","onArrival":[{"$code":"Q[\'pageant_prep\'] = 4;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 2;\\nQ[\'pageant_paperwork\'] = (Q[\'pageant_paperwork\'] || 0) + 1;\\nQ[\'pageant_details\'] = (Q[\'pageant_details\'] || 0) + 1;\\nQ[\'pageant_paperwork\'] = (Q[\'pageant_paperwork\'] || 0) + 1;"}],"goTo":[{"id":"skip.w9_scioly_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.eye_contact_david":{"id":"scioly_study_party.eye_contact_david","viewIf":{"$code":"return ((Q[\'david_scioly\'] || 0) > 0);"},"options":[{"id":"@scioly_study_party.follow_david","title":"\\"Okay?\\""}],"content":[{"type":"paragraph","content":"You haven\'t talked to David today, but for some reason he makes eye contact with you. And for some unknown reason, you maintain it longer than is necessary."},{"type":"paragraph","content":"\\"Would you like to talk?\\", he says, in the same barely audible monotone as always. It\'s a moment before you realize that he\'s actually talking to you."},{"type":"paragraph","content":"\\"Oh, um...\\""}]},"thanksgiving_party.special":{"id":"thanksgiving_party.special","options":[{"id":"@thanksgiving_party.dinner_known","title":"It\'s time for dinner."}],"content":{"content":[{"type":"paragraph","content":"\\"Oh. Does that make me, like, um, special?\\" (that was awkward)."},{"type":"paragraph","content":"\\"Yeah I guess?\\""},{"type":"paragraph","content":"You and Emily stare at each other awkwardly for a few moments or minutes; you can\'t tell, until sounds from downstairs break your reverie."},{"type":"paragraph","content":["\\"",{"type":"insert","insert":0},", ---, ",{"type":"emphasis-1","content":"food is ready!"},"\\", your mom shouts."]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"scioly_2.pq2_a4":{"id":"scioly_2.pq2_a4","goTo":[{"id":"scioly_2.pq2_wrong"}],"content":{"content":"\\"Histidine?\\"","type":"paragraph"}},"aubrey_final.aubrey_silence_2":{"id":"aubrey_final.aubrey_silence_2","options":[{"id":"@aubrey_final.not_bad","title":"It\'s not a bad feeling..."},{"id":"@aubrey_final.wont_last","title":"But it won\'t last..."}],"content":{"content":"There is a long moment of silence. Her head rests on your shoulder, her fingers intertwined with yours.","type":"paragraph"}},"birthday.hug_miri":{"id":"birthday.hug_miri","goTo":[{"id":"birthday.both_party_3"}],"content":[{"type":"paragraph","content":"Why the fuck would you want to do that?"},{"type":"paragraph","content":"Okay. Time for words."}]},"christmas_party.you_win":{"id":"christmas_party.you_win","viewIf":{"$code":"return ((Q[\'stared_emily\'] || 0)===1);"},"options":[{"id":"@christmas_party.dinner","title":"The call to dinner saves you."}],"content":[{"type":"paragraph","content":"It\'s close, but you managed to use Q and Z, which made the difference in the end."},{"type":"paragraph","content":"\\"Okay, the two of you are definitely staring at each other, right?\\", Aubrey says. \\"Is there something going on that I\'m not aware of?\\""},{"type":"paragraph","content":"\\"No, nothing\'s going on,\\" Emily says. \\"We\'ve just known each other before. Our parents work together. That\'s all.\\""},{"type":"paragraph","content":"\\"Is that really all?\\""},{"type":"paragraph","content":"Emily stares at Aubrey, as if she were in a one-sided staring contest. It continues for half a minute."},{"type":"paragraph","content":"\\"Um, sorry,\\" Aubrey says. \\"Forget I ever said anything.\\" But then she glances at you with a slight smile. You try to contort your expression back to a safe neutral, but it probably doesn\'t work."}]},"church_1.wait":{"id":"church_1.wait","goTo":[{"id":"church_1.karen_talk"}],"content":{"content":"You eat and sit in silence, not having any words to say. Except you can\'t help but glance at Aubrey sometimes. Sometimes you imagine the future that the two of you have together. Obviously she\'s straight, but whatever, the two of you will realize your feelings for each other and start dating and maybe even get married and realize all your dreams and...","type":"paragraph"}},"emily_6.know_well":{"id":"emily_6.know_well","options":[{"id":"@emily_6.beautiful","title":"\\"Beautiful ...\\""},{"id":"@emily_6.kind","title":"\\"Kind...\\""},{"id":"@emily_6.talented","title":"\\"Talented...\\""}],"content":{"type":"paragraph","content":["\\"I\'ve known her for a while, but I sort of feel like I still dont really, well, ",{"type":"emphasis-1","content":"know"}," know her. All I know is that she seems...\\""]}},"emily_7.yes_sorry":{"id":"emily_7.yes_sorry","goTo":[{"id":"emily_7.performance"}],"content":[{"type":"paragraph","content":"\\"Oh. Sorry,\\" you say a second time, because what else can you say?"},{"type":"paragraph","content":"\\"You\'re not a good liar, you know.\\" She offers a small smile. \\"It\'s fine. Don\'t worry about it. Our deal is still on. You know.\\""},{"type":"paragraph","content":"\\"Oh. Uh, thanks.\\""}]},"miri_date.stop_saying_sorry":{"id":"miri_date.stop_saying_sorry","goTo":[{"id":"miri_date.touching"}],"content":{"content":"\\"Um, you don\'t have to say sorry...\\"","type":"paragraph"}},"miri_pageant_prep.next_question_3":{"id":"miri_pageant_prep.next_question_3","viewIf":{"$code":"return ((Q[\'miri_practice\'] || 0) > 1);"},"options":[{"id":"@miri_pageant_prep.why_basic","title":"Make up a basic but honest answer."},{"id":"@miri_pageant_prep.why_good","title":"Give the answer you think they\'re looking for."}],"content":{"content":"\\"Here\'s a basic question. Why do you want to participate in the pageant?\\"","type":"paragraph"}},"pageant_final.high_heel_shoes":{"id":"pageant_final.high_heel_shoes","viewIf":{"$code":"return ((Q[\'has_high_heels\'] || 0)===1);"},"goTo":[{"id":"pageant_final.jewelry"}],"content":{"content":"High heel shoes? Ugh. Unfortunately you purchased a pair.","type":"paragraph"}},"pageant_meetup.socialize_emily_2":{"id":"pageant_meetup.socialize_emily_2","onArrival":[{"$code":"Q[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"options":[{"id":"@pageant_meetup.socialize_emily_3","title":"\\"Yeah...\\""}],"content":[{"type":"paragraph","content":"\\"Yeah...\\""},{"type":"paragraph","content":"\\"Great! Well, uh, no offense but you don\'t look like the sort to be into pageants. I mean, same here.\\""},{"type":"paragraph","content":"Emily glances around. No one else is near. You don\'t know how to continue the conversation, or even if Emily wants you to be around or if she\'s just waiting for you to leave. Her voice sounds strange. She\'s sort of pretty (why are you thinking about that?). You\'re stuck, mind blank, not knowing what to say or what to do or where to place your hands or..."},{"type":"paragraph","content":"Emily continues, \\"Do you, I mean, would you like some, uh, assistance? With the pageant, I mean?\\""}]},"scioly_invitational.medal_ceremony_disease_gold":{"id":"scioly_invitational.medal_ceremony_disease_gold","viewIf":{"$code":"return ((Q[\'disease\'] || 0) >= 2);"},"onArrival":[{"$code":"Q[\'medal_count\'] = (Q[\'medal_count\'] || 0) + 1;\\nQ[\'gold_count\'] = (Q[\'gold_count\'] || 0) + 1;"}],"goTo":[{"id":"scioly_invitational.medal_ceremony_protein"}],"content":{"content":"You won the gold medal in Disease Detectives! It\'s the first medal of the day. The captain\'s smile is broad.","type":"paragraph"}},"skip.w9_scioly_status":{"id":"skip.w9_scioly_status","options":[{"id":"@skip.w9_scioly_1","title":"You attended the study party and the invitational, and got a lot of medals."},{"id":"@skip.w9_scioly_2","title":"You attended the study party and the invitational, but did not do as well as you hoped."},{"id":"@skip.w9_scioly_3","title":"You have not been involved in science olympiad."}],"content":{"content":"Science olympiad status:","type":"paragraph"}},"scioly_study_party.follow_david":{"id":"scioly_study_party.follow_david","options":[{"id":"@scioly_study_party.nothing_wrong","title":"\\"Nothing\'s wrong.\\""}],"content":[{"type":"paragraph","content":"He goes over to an empty couch and sits down. You follow, keeping a distance."},{"type":"paragraph","content":"\\"Sorry that Krishna was being a jerk,\\" he says. You\'ve heard rumors that they were dating or at least liked each other or something like that. Not that that\'s particularly relevant now."},{"type":"paragraph","content":"\\"Oh, um, that\'s okay. Thanks.\\""},{"type":"paragraph","content":"\\"Is it okay if I ask you what\'s wrong?\\""}]},"thanksgiving_party.just_do_homework":{"id":"thanksgiving_party.just_do_homework","viewIf":{"$code":"return ((Q[\'emily\'] || 0) < 4);"},"options":[{"id":"@thanksgiving_party.drift","title":"Your mind drifts..."}],"content":[{"type":"paragraph","content":"You sit down, not bothering to talk to your host. It doesn\'t matter anyway, unlike your AP World homework. So you unzip your backpack and take out your textbook. The assignment is just to read the relevant chapters of the textbook and answer a few basic questions on them. Maybe you\'ll get something done after all."},{"type":"paragraph","content":"As you do the reading, you hear tapping on the keyboard. Your host is writing some essay or another."}]},"scioly_2.pq2_wrong":{"id":"scioly_2.pq2_wrong","goTo":[{"id":"scioly_2.pq3"}],"content":{"content":"\\"Wrong. The correct answer is methionine. The only two amino acids that contain sulfur are methionine and cysteine.\\"","type":"paragraph"}},"aubrey_final.not_bad":{"id":"aubrey_final.not_bad","options":[{"id":"@aubrey_final.have_to_leave","title":"It\'s time to leave."}],"content":{"type":"paragraph","content":["Honestly you\'re kind of enjoying this moment. It\'s a pleasant feeling, the soft skin of her face leaning so close to yours. It\'s easy to become lost in yourself, to imagine that there is something else going on here, that the two of you are really ",{"type":"emphasis-1","content":"in love"}," or something like that. But even so, you\'re friends, right? She cares about you, right? Right?"]}},"birthday.hug_aubrey":{"id":"birthday.hug_aubrey","goTo":[{"id":"birthday.both_party_3"}],"content":[{"type":"paragraph","content":"No. No. No."},{"type":"paragraph","content":"Okay. Time for words."}]},"christmas_party.you_win_emily_leaves":{"id":"christmas_party.you_win_emily_leaves","viewIf":{"$code":"return ((Q[\'stared_emily\'] || 0)===0);"},"options":[{"id":"@christmas_party.emily_leaves_2","title":"\\"What?\\""}],"content":{"content":[{"type":"paragraph","content":"It\'s close, but you managed to use Q and Z, which made the difference in the end."},{"type":"paragraph","content":"\\"I have to use the bathroom,\\" Emily says, and presumably leaves to do just that, but not before shooting a strange glance in your direction. You look away. Did she want something from you? Was she looking for some kind of reassurance that you failed to provide her?"},{"type":"paragraph","content":"You start to feel worse about yourself, somewhat more than usual."},{"type":"paragraph","content":["\\"Hey ",{"type":"insert","insert":0},"?\\""]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"church_1.stay":{"id":"church_1.stay","onArrival":[{"$code":"Q[\'aubrey_interact\'] = (Q[\'aubrey_interact\'] || 0) + 1;"}],"options":[{"id":"@church_1.endure","title":"Endure."}],"content":[{"type":"paragraph","content":"It\'s awkward being here (as if anything\'s not), but being around Aubrey doesn\'t feel so bad. She\'s a nice person, unlike you. Why is she even here, though? Doesn\'t she have homework to do? She never seems busy, but she must have the same amound of homework as you, plus ECs and stuff so... maybe you should ask her?"},{"type":"paragraph","content":"\\"Hey, do you want to sit down?\\", she says."},{"type":"paragraph","content":"\\"Oh. Um, okay.\\""},{"type":"paragraph","content":["You sit next to her. Why is she leaning against you. The probability that this ",{"type":"emphasis-1","content":"means"}," anything is approximately zero. But it\'s a pleasant feeling. Sort of. Maybe."]}]},"church_1":{"id":"church_1","type":"scene","title":"Bible Study","subtitle":"Saturday evening","viewIf":{"$code":"return (((Q[\'church\'] || 0)===0) && ((Q[\'week\'] || 0) < 3));"},"onArrival":[{"$code":"Q[\'church\'] = (Q[\'church\'] || 0) + 1;\\nQ[\'aubrey\'] = (Q[\'aubrey\'] || 0) + 1;\\nQ[\'aubrey_interact\'] = 0;"}],"tags":["weekend"],"options":[{"id":"@church_1.acq","title":"That acquaintance..."}],"content":{"content":"The bible study meetings happen every Saturday evening. More than any theological relevance, they\'re gatherings of the local Chinese community, or at least your small slice of it. It takes place at a different house each week (though never yours, since your apartment is way too small). This week it\'s at the house of a vague acquaintance.","type":"paragraph"}},"emily_6.dont_know_well":{"id":"emily_6.dont_know_well","options":[{"id":"@emily_6.beautiful","title":"\\"Beautiful...\\""},{"id":"@emily_6.kind","title":"\\"Kind...\\""},{"id":"@emily_6.talented","title":"\\"Talented...\\""}],"content":{"content":"\\"I feel like I don\'t know her very well, but I really wish I could get to know her better, because she\'s like...\\"","type":"paragraph"}},"emily_7.performance":{"id":"emily_7.performance","options":[{"id":"@emily_7.what_to_say","title":"You have no idea what to say."}],"content":{"content":"\\"God, like, trans women\'s social acceptance is totally contingent on how well we perform femininity. Like, that\'s why you\'re here now, isn\'t it?\\"","type":"paragraph"}},"miri_date.sure_go_ahead":{"id":"miri_date.sure_go_ahead","goTo":[{"id":"miri_date.touching"}],"content":{"content":"\\"Um, sure, go ahead...\\"","type":"paragraph"}},"miri_pageant_prep.why_basic":{"id":"miri_pageant_prep.why_basic","options":[{"id":"@miri_pageant_prep.miri_interview_practice_final","title":"Miri moves on."}],"content":[{"type":"paragraph","content":"\\"Um, because my parents made me do it?\\""},{"type":"paragraph","content":"\\"That\'s a terrible answer.\\""},{"type":"paragraph","content":"You shrug. \\"What else am I supposed to say?"},{"type":"paragraph","content":"\\"Do you really have no other reason for doing this? Are you really only doing this to satisfy your parents?\\""},{"type":"paragraph","content":"\\"Yeah. Basically.\\""},{"type":"paragraph","content":"Miri rolls her eyes. \\"Well, then at least you have to come up with a better answer.\\""},{"type":"paragraph","content":"\\"Okay... I\'ll try...\\""}]},"pageant_final.shoes":{"id":"pageant_final.shoes","goTo":[{"id":"pageant_final.jewelry"}],"content":{"content":"Shoes? Ugh. Fortunately you don\'t actually have any high heel shoes, and mom\'s size does not fit you at all, so she reluctantly agrees to you wearing flats.","type":"paragraph"}},"pageant_meetup.socialize_emily_3":{"id":"pageant_meetup.socialize_emily_3","onArrival":[{"$code":"Q[\'emily\'] = 1;"}],"options":[{"id":"@pageant_meetup.social_continue","title":"That was better than expected."}],"content":[{"type":"paragraph","content":"\\"Yeah...\\""},{"type":"paragraph","content":"Emily smiles. Maybe? \\"Okay, great! Um, do you want my phone number or something? If that\'s not too weird?\\""},{"type":"paragraph","content":"\\"It\'s, uh, fine, I guess.\\""},{"type":"paragraph","content":"\\"Great!\\" You exchange cell phone numbers, and she says she\'ll add you on facebook or something. She suggests meeting up later somewhere, but she has to leave soon, and now you\'re left alone again."}]},"scioly_invitational.medal_ceremony_disease_bronze":{"id":"scioly_invitational.medal_ceremony_disease_bronze","viewIf":{"$code":"return ((Q[\'disease\'] || 0)===1);"},"onArrival":[{"$code":"Q[\'medal_count\'] = (Q[\'medal_count\'] || 0) + 1;\\nQ[\'bronze_count\'] = (Q[\'bronze_count\'] || 0) + 1;"}],"goTo":[{"id":"scioly_invitational.medal_ceremony_protein"}],"content":{"content":"You won the bronze medal in Disease Detectives! It\'s the first medal of the day.","type":"paragraph"}},"skip.w9_scioly_1":{"id":"skip.w9_scioly_1","onArrival":[{"$code":"Q[\'scioly\'] = 7;\\nQ[\'medal_count\'] = 4;\\nQ[\'invitational\'] = 1;\\nQ[\'study_party\'] = 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 4;\\nQ[\'david_scioly\'] = (Q[\'david_scioly\'] || 0) + 2;\\nQ[\'fossils\'] = (Q[\'fossils\'] || 0) + 2;\\nQ[\'aubrey_scioly\'] = (Q[\'aubrey_scioly\'] || 0) + 2;\\nQ[\'protein_modeling\'] = (Q[\'protein_modeling\'] || 0) + 2;\\nQ[\'krishna_scioly\'] = (Q[\'krishna_scioly\'] || 0) + 1;\\nQ[\'cell\'] = (Q[\'cell\'] || 0) + 1;\\nQ[\'edwin_scioly\'] = (Q[\'edwin_scioly\'] || 0) + 1;\\nQ[\'disease\'] = (Q[\'disease\'] || 0) + 1;\\nQ[\'roxana_seen\'] = 1;"}],"goTo":[{"id":"skip.w9_research_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.nothing_wrong":{"id":"scioly_study_party.nothing_wrong","options":[{"id":"@scioly_study_party.seems_right","title":"That seems... right?"},{"id":"@scioly_study_party.seems_wrong","title":"That\'s wrong."}],"content":[{"type":"paragraph","content":"\\"Nothing\'s wrong. I\'m fine. I am a one hundred percent functional human being.\\""},{"type":"paragraph","content":"A long pause. You stare at the carpet."},{"type":"paragraph","content":"\\"Can I guess what\'s wrong?\\", he says. You shrug."},{"type":"paragraph","content":"\\"People are here having fun or whatever, without you, like you don\'t exist, and you just feel, kind of dejected I guess. Feeling unnecessary, unneeded, unwanted, like... It\'s like, the realization that you could disappear and nobody would notice or care.\\""}]},"thanksgiving_party.homework":{"id":"thanksgiving_party.homework","viewIf":{"$code":"return ((Q[\'emily\'] || 0)===0);"},"options":[{"id":"@thanksgiving_party.homework_2","title":"You\'re taking..."}],"content":[{"type":"paragraph","content":"\\"Can I do my homework here?\\", you say."},{"type":"paragraph","content":"\\"Oh, sure. What is it?\\""},{"type":"paragraph","content":"\\"Oh, AP World.\\""},{"type":"paragraph","content":"\\"Oh. I\'m taking AP Euro right now. My school doesn\'t have AP World.\\""},{"type":"paragraph","content":"You unzip your backpack and take out your textbook. The assignment is just to read the relevant chapters of the textbook and answer a few basic questions on them. Maybe you\'ll get something done after all."},{"type":"paragraph","content":"\\"Hey, what classes are you taking?\\", he asks, breaking your focus."}]},"scioly_2.pq3":{"id":"scioly_2.pq3","options":[{"id":"@scioly_2.pq3_correct","title":"Binds to specific DNA sequences."},{"id":"@scioly_2.pq3_no_idea","title":"You have no idea."}],"content":{"content":"She continues. \\"Alright. Next question. What does a zinc finger motif do?\\"","type":"paragraph"}},"aubrey_final.wont_last":{"id":"aubrey_final.wont_last","options":[{"id":"@aubrey_final.have_to_leave","title":"It\'s time to leave."}],"content":[{"type":"paragraph","content":["She doesn\'t ",{"type":"emphasis-1","content":"like you"}," in ",{"type":"emphasis-1","content":"that way"},", you have to remind yourself. It\'s easy to get caught up in the moment, to imagine that the two of you are ",{"type":"emphasis-1","content":"a thing"},", but of course it\'s not like that. It\'ll never be like that."]},{"type":"paragraph","content":"But even so, you\'re friends, right? She cares about you, right? Right?"}]},"birthday.both_party_3":{"id":"birthday.both_party_3","options":[{"id":"@birthday.both_party_4","title":"Try to stop crying."}],"content":[{"type":"paragraph","content":"\\"Humans. Too many. Uh, in vicinity. Here. Sorry.\\" Aubrey looks confused. Miri smiles."},{"type":"paragraph","content":"\\"Let\'s just sit down here,\\" Miri says."},{"type":"paragraph","content":"\\"Oh god.\\" Your eyes dart between the two of them. Three humans too many. Miri puts her arm around your shoulder. Aubrey waits a second and does the same."},{"type":"paragraph","content":"Tears. You\'re crying. Why are you crying? Oh God. Your heart is beating in all sorts of directions. You close your eyes, and you can barely open them afterwards."}]},"christmas_party.emily_leaves_2":{"id":"christmas_party.emily_leaves_2","options":[{"id":"@christmas_party.dinner","title":"The call to dinner saves you."}],"content":[{"type":"paragraph","content":"\\"Oh. Um, what?\\""},{"type":"paragraph","content":"\\"You\'re zoning out.\\""},{"type":"paragraph","content":"\\"Oh. Sorry.\\""}]},"emily_6.kind":{"id":"emily_6.kind","goTo":[{"id":"emily_6.beautiful"}],"content":{"content":"","type":"paragraph"}},"emily_7.what_to_say":{"id":"emily_7.what_to_say","options":[{"id":"@emily_7.an_optimization_problem","title":"Maybe conversation is also an optimization problem."}],"content":{"content":"Emily continues. \\"So like, being a woman might as well be an optimization problem, especially with something like the pageant itself where you\'re essentially trying to reverse-engineer the judges\' expectations of you... and you probably don\'t want to hear my rants right now. Or ever.\\"","type":"paragraph"}},"miri_date.please_dont":{"id":"miri_date.please_dont","options":[{"id":"@miri_date.awkwardness","title":"There is an awkward silence."}],"content":[{"type":"paragraph","content":"\\"Um... please don\'t...\\""},{"type":"paragraph","content":"\\"Oh. Sorry.\\" Miri pulls away."}]},"miri_pageant_prep.why_good":{"id":"miri_pageant_prep.why_good","options":[{"id":"@miri_pageant_prep.miri_interview_practice_final","title":"Miri moves on."}],"content":[{"type":"paragraph","content":"\\"Um, because I want to improve myself by, um...\\""},{"type":"paragraph","content":"Miri looks at you, waiting. \\"How do you want to improve yourself?\\""},{"type":"paragraph","content":"\\"By getting out of my comfort zone? Or, um, something like that.\\""},{"type":"paragraph","content":"\\"That works, I guess,\\" she says. \\"But you\'re going to need to say that with confidence at the actual pageant. You can\'t just say \'um\' all the time.\\""},{"type":"paragraph","content":"\\"Yeah...\\""}]},"pageant_final.jewelry":{"id":"pageant_final.jewelry","options":[{"id":"@pageant_final.piercings_yes","title":"You got your ears pierced."},{"id":"@pageant_final.piercings_no","title":"You never got your ears pierced."}],"content":{"content":"Jewelry? Ugh again, but slightly less so. You have the old jade pendant with a carved ox, representing your zodiac sign.","type":"paragraph"}},"pageant_meetup.socialize_ashley":{"id":"pageant_meetup.socialize_ashley","viewIf":{"$code":"return ((Q[\'ashley\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'ashley\'] = 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"options":[{"id":"@pageant_meetup.socialize_ashley_2","title":"\\"I guess.\\""}],"content":{"content":[{"type":"paragraph","content":"You find Ashley at the front of the room, taking a break from talking to people. Does she recognize you?"},{"type":"paragraph","content":["\\"",{"type":"insert","insert":0},"?\\" Apparently she did. \\"What are you doing here?\\""]},{"type":"paragraph","content":"\\"Um, pageant, I guess.\\""},{"type":"paragraph","content":"\\"Wait. Seriously?\\""}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"scioly_invitational.medal_ceremony_disease_none":{"id":"scioly_invitational.medal_ceremony_disease_none","viewIf":{"$code":"return ((Q[\'disease\'] || 0)===0);"},"goTo":[{"id":"scioly_invitational.medal_ceremony_protein"}],"content":[{"type":"paragraph","content":"Unfortunately, your school\'s name is not called."},{"type":"paragraph","content":"\\"It\'s okay,\\" the captain says. \\"We can always prepare better next time. I think we got top 10 at least.\\""},{"type":"paragraph","content":"\\"There are only 20 teams.\\""},{"type":"paragraph","content":"He chuckles. \\"Hey, better than nothing.\\""}]},"skip.w9_scioly_2":{"id":"skip.w9_scioly_2","onArrival":[{"$code":"Q[\'scioly\'] = 3;\\nQ[\'medal_count\'] = 2;\\nQ[\'invitational\'] = 1;\\nQ[\'study_party\'] = 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 2;"}],"goTo":[{"id":"skip.w9_research_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.seems_right":{"id":"scioly_study_party.seems_right","goTo":[{"id":"scioly_study_party.roxy_confession"}],"content":[{"type":"paragraph","content":"\\"Um, sort of, I guess? Maybe? But maybe it\'s just the neurotransmitters that are out of balance.\\""},{"type":"paragraph","content":"\\"Oh. I\'ve felt that way myself, sometimes.\\""}]},"thanksgiving_party.homework_2":{"id":"thanksgiving_party.homework_2","options":[{"id":"@thanksgiving_party.drift","title":"Your mind drifts..."}],"content":[{"type":"paragraph","content":"\\"Um, AP Chem, Calc BC, AP World, AP Lit, AP Spanish, and, uh, PE.\\""},{"type":"paragraph","content":"\\"That\'s not bad. No music or art?\\""},{"type":"paragraph","content":["\\"Um, well, I do play the ",{"type":"emphasis-1","content":"erhu"},".\\""]},{"type":"paragraph","content":"He laughs. \\"That\'s like, the most Asian thing I\'ve ever heard.\\""},{"type":"paragraph","content":"\\"Yeah, I guess,\\" you say. He remains silent. You have a habit of killing off every conversation you\'re ever in."}]},"scioly_2.pq3_correct":{"id":"scioly_2.pq3_correct","options":[{"id":"@scioly_2.proteins_2_final","title":"The quizzing continues."}],"content":[{"type":"paragraph","content":"\\"It, um, binds to specific DNA sequences.\\""},{"type":"paragraph","content":"\\"Sure. Yeah.\\""}]},"aubrey_final.sorry_hold_hand":{"id":"aubrey_final.sorry_hold_hand","options":[{"id":"@aubrey_final.silence_dont_hold_hand","title":"There is a silence."}],"content":[{"type":"paragraph","content":"\\"Um, sorry but...\\" You keep your hands on your lap. Suddenly the situation feels incredibly awkward."},{"type":"paragraph","content":"\\"It\'s okay!\\", Aubrey says. \\"I know you\'re not good with touching!\\""},{"type":"paragraph","content":"\\"Oh. Thanks.\\" But you wonder how she knows that."}]},"birthday.both_party_4":{"id":"birthday.both_party_4","options":[{"id":"@birthday.laugh","title":"Laugh."},{"id":"@birthday.cry","title":"Keep on crying."}],"content":[{"type":"paragraph","content":"Why can\'t you be normal for once? Why the fuck do you have to be like this? Were you always like this, this fucking pathetic? Why would anyone want to be around you if they weren\'t forced to be?"},{"type":"paragraph","content":"You close your eyes and open them. They\'re still there, around you. You can\'t see their faces."},{"type":"paragraph","content":"Aubrey separates first. \\"So, um, do you want the AP Chem prep book my parents bought for you?\\""}]},"christmas_party.dinner":{"id":"christmas_party.dinner","options":[{"id":"@christmas_party.open_eyes","title":"Keep your eyes open."},{"id":"@christmas_party.close_eyes","title":"Close your eyes."}],"content":{"content":"Dinner is a potluck, as usual for these gatherings. Also as usual, before dinner comes a prayer, lead by Wang Laoshi.","type":"paragraph"}},"emily_6.talented":{"id":"emily_6.talented","goTo":[{"id":"emily_6.beautiful"}],"content":{"content":"","type":"paragraph"}},"emily_7.an_optimization_problem":{"id":"emily_7.an_optimization_problem","options":[{"id":"@emily_7.optimization_yeah","title":"Yeah..."}],"content":[{"type":"paragraph","content":"\\"Interpersonal interactions are also an optimization problem,\\" you say. \\"Like right now. I\'m trying to optimize what to say so that you, um, enjoy... um, spending time here. Or at least don\'t hate me forever.\\""},{"type":"paragraph","content":"Emily sort of smiles."},{"type":"paragraph","content":"\\"Or nothing is,\\" she says. \\"Or maybe living life as if it were an optimization problem is a highly suboptimal strategy.\\""},{"type":"paragraph","content":"\\"Yeah, maybe, but how else are we supposed to live?\\""},{"type":"paragraph","content":"She shrugs. \\"I don\'t know how people do it. Like, how do normal people even know what to do in literally any circumstance?\\""},{"type":"paragraph","content":"\\"I mean, same.\\""},{"type":"paragraph","content":"She almost laughs, and shakes her head."},{"type":"paragraph","content":"\\"God, we are such dorks,\\" she says."}]},"miri_date.touching":{"id":"miri_date.touching","onArrival":[{"$code":"Q[\'miri_touch\'] = 1;"}],"options":[{"id":"@miri_date.youre_welcome","title":"\\"You\'re welcome?\\""}],"content":{"content":[{"type":"paragraph","content":"Miri slides closer to you, so that her head leans against your shoulders. Her fingers intertwine with yours. Her hand is warm. Her skin feels nice. You close your eyes for a moment."},{"type":"paragraph","content":"Endorphins are being released, or something like that. That\'s why you feel pleasant right now, or something like that."},{"type":"paragraph","content":["\\"Hey, ",{"type":"insert","insert":0},"?\\""]},{"type":"paragraph","content":"\\"Yeah?\\""},{"type":"paragraph","content":"\\"Thanks.\\""},{"type":"paragraph","content":"\\"For what?\\""},{"type":"paragraph","content":"\\"Just being here, I guess. That\'s enough for now.\\""}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"miri_pageant_prep.miri_interview_practice_final":{"id":"miri_pageant_prep.miri_interview_practice_final","content":{"content":"Miri keeps on asking questions, repeating many of the same ones you\'ve already gone over, but also adding new ones. Fewer weird questions about boyfriends this time. You feel as if you\'re getting better, somehow.","type":"paragraph"}},"pageant_final.piercings_yes":{"id":"pageant_final.piercings_yes","onArrival":[{"$code":"Q[\'piercings\'] = 1;"}],"options":[{"id":"@pageant_final.car","title":"It\'s time to leave."}],"content":{"content":"It was somewhat of an ordeal, but you had your ears pierced a while back.","type":"paragraph"}},"pageant_meetup.socialize_ashley_2":{"id":"pageant_meetup.socialize_ashley_2","options":[{"id":"@pageant_meetup.socialize_ashley_3","title":"\\"Are you sure?\\""}],"content":[{"type":"paragraph","content":"\\"I guess.\\""},{"type":"paragraph","content":"\\"Huh.\\" An awkward pause. You avert her withering gaze. \\"I mean, I\'m probably not doing it this year.\\""},{"type":"paragraph","content":"\\"Um, yeah.\\""},{"type":"paragraph","content":"\\"Great. Maybe we can meet up sometime.\\""}]},"scioly_invitational.medal_ceremony_protein":{"id":"scioly_invitational.medal_ceremony_protein","options":[{"id":"@scioly_invitational.medal_ceremony_protein_gold","title":"Gold!"},{"id":"@scioly_invitational.medal_ceremony_protein_silver","title":"Silver!"},{"id":"@scioly_invitational.medal_ceremony_protein_bronze","title":"Bronze!"}],"content":[{"type":"paragraph","content":"There\'s some more waiting. Your next event is Protein Modeling."},{"type":"paragraph","content":"Aubrey glances in your direction. \\"I think we did well,\\" she whispers. \\"We\'ll probably get a medal.\\" You are not so confident."}]},"skip.w9_scioly_3":{"id":"skip.w9_scioly_3","onArrival":[{"$code":"Q[\'scioly\'] = -1;"}],"goTo":[{"id":"skip.w9_research_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.seems_wrong":{"id":"scioly_study_party.seems_wrong","goTo":[{"id":"scioly_study_party.roxy_confession"}],"content":[{"type":"paragraph","content":"\\"Okay, bargin bin Freud. It\'s just the neurotransmitters acting up. Not everything has a deep psychological reason rooted in trauma or whatever.\\" Was that unnecessarily mean? Oh God it was. Why can\'t you just stop talking?"},{"type":"paragraph","content":"\\"Oh, well, it was a guess,\\" David says, shrugging. \\"I\'ve felt that way sometimes myself. Sorry.\\""},{"type":"paragraph","content":"\\"No, I mean... it\'s not, like, that wrong.\\""}]},"thanksgiving_party.drift":{"id":"thanksgiving_party.drift","options":[{"id":"@thanksgiving_party.out","title":"You\'re glad to be out of there."}],"content":{"content":[{"type":"paragraph","content":["You try to focus on the homework, but you can\'t. You think about ",{"type":"emphasis-1","content":"things"},", but mostly about how awkward the current moment is. You feel as if you should say something to break the silence because it\'s awkward but you don\'t know if it\'s actually a good idea and maybe he really wants to be doing whatever his computer thing is and probably doesn\'t even want you to be here and honestly you don\'t even want to be here and you\'re all only here because of the machinations of your parents and..."]},{"type":"paragraph","content":["\\"",{"type":"insert","insert":0},", ---, ",{"type":"emphasis-1","content":"food is ready!"},"\\", your mom shouts."]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"scioly_2.pq3_no_idea":{"id":"scioly_2.pq3_no_idea","viewIf":{"$code":"return ((Q[\'proteins\'] || 0) <= 2);"},"options":[{"id":"@scioly_2.proteins_2_final","title":"The quizzing continues."}],"content":[{"type":"paragraph","content":"\\"Um... I don\'t know?\\""},{"type":"paragraph","content":"\\"It recognizes and binds to specific DNA sequences.\\""}]},"aubrey_final.silence_dont_hold_hand":{"id":"aubrey_final.silence_dont_hold_hand","options":[{"id":"@aubrey_final.have_to_leave","title":"It\'s time to leave."}],"content":{"content":"She is silent. You are silent. The two of you sit next to each other, not touching. It\'s a slightly awkward moment, but not that much more awkward than the rest of the date thus far.","type":"paragraph"}},"birthday.cry":{"id":"birthday.cry","goTo":[{"id":"birthday.okay"}],"content":{"content":"You cry, but start laughing at the same time. Your throat hurts.","type":"paragraph"}},"christmas_party.open_eyes":{"id":"christmas_party.open_eyes","goTo":[{"id":"christmas_party.start_eating"}],"content":{"content":"Most of the others have their eyes closed, including your parents and Kevin. Emily\'s eyes are still open. She looks at you. You bow your head. Wang Laoshi\'s words wash over you.","type":"paragraph"}},"emily_6.beautiful":{"id":"emily_6.beautiful","options":[{"id":"@emily_6.sit_next","title":"\\"And she\'s sitting next to me...\\""},{"id":"@emily_6.so_yeah","title":"\\"So yeah...\\""}],"content":{"content":"\\"Well, she\'s beautiful, talented, kind, basically everything I\'ve always admired. I... um, I think I love her very much. And I wish I could ... like, be with her, you know...\\"","type":"paragraph"}},"emily_7.optimization_yeah":{"id":"emily_7.optimization_yeah","onArrival":[{"$code":"Q[\'loneliness\'] = (Q[\'loneliness\'] || 0) - 1;"}],"options":[{"id":"@emily_7.and_you_are_happy","title":"And you\'re happy too...?"},{"id":"@emily_7.worries","title":"But you feel... worried...?"}],"content":[{"type":"paragraph","content":"\\"This is why I, uh, ...\\" You know how to finish the sentence, but don\'t really have the energy to."},{"type":"paragraph","content":"\\"Like me?\\""},{"type":"paragraph","content":"\\"Oh my God. You can\'t just say things like that!\\""},{"type":"paragraph","content":"Emily laughs. She seems genuinely happy at this moment."}]},"miri_date.youre_welcome":{"id":"miri_date.youre_welcome","options":[{"id":"@miri_date.another_pause","title":"Another pause."}],"content":[{"type":"paragraph","content":"\\"Um, you\'re welcome?\\""},{"type":"paragraph","content":"\\"Yeah. Sure.\\" Miri\'s hands are still on top of yours."}]},"miri_pageant_prep.hang":{"id":"miri_pageant_prep.hang","viewIf":{"$code":"return (((((Q[\'miri_hang\'] || 0)===0) && ((Q[\'miri\'] || 0) > 2)) && ((Q[\'miri_practice\'] || 0) > 0)) && ((Q[\'gym\'] || 0) > 0));"},"onArrival":[{"$code":"Q[\'miri_hang\'] = (Q[\'miri_hang\'] || 0) + 1;"}],"options":[{"id":"@miri_pageant_prep.because","title":"Just because. No reason."},{"id":"@miri_pageant_prep.lonely","title":"You\'re lonely as heck."},{"id":"@miri_pageant_prep.like_her","title":"You like her."}],"content":[{"type":"paragraph","content":"\\"Wait, I thought you wanted to practice for the pageant?\\", she says."},{"type":"paragraph","content":"\\"Maybe we can... like, take a break or something like that?\\" You try your best to keep your voice from being too serious."},{"type":"paragraph","content":"\\"Oh, no, that\'s not what I meant at all! If you want to just..., like, hang out or whatever, that\'s fine too.\\""},{"type":"paragraph","content":"Anyway, why did you want to hang out with Miri?"}]},"pageant_final.piercings_no":{"id":"pageant_final.piercings_no","onArrival":[{"$code":"Q[\'percings\'] = 0;"}],"options":[{"id":"@pageant_final.car","title":"It\'s time to leave."}],"content":{"content":"How many girls in the pageants don\'t have earrings, mom says, or something like that. Unfortunately you do not have piercings, so clip-ons it is. Mom has some unobtrusive ones with glass crystals.","type":"paragraph"}},"pageant_meetup.socialize_ashley_3":{"id":"pageant_meetup.socialize_ashley_3","options":[{"id":"@pageant_meetup.social_continue","title":"Anyway..."}],"content":[{"type":"paragraph","content":"\\"Are you sure?\\""},{"type":"paragraph","content":"\\"Yeah I\'m sure. Look, just talk to me after lunch one of these days. I promise, okay?\\""},{"type":"paragraph","content":"\\"Um, thanks...\\""},{"type":"paragraph","content":"She glances away from you, shifting her attention to another girl. The conversation is over."}]},"scioly_invitational.medal_ceremony_protein_gold":{"id":"scioly_invitational.medal_ceremony_protein_gold","viewIf":{"$code":"return ((Q[\'protein\'] || 0) >= 2);"},"onArrival":[{"$code":"Q[\'medal_count\'] = (Q[\'medal_count\'] || 0) + 1;\\nQ[\'gold_count\'] = (Q[\'gold_count\'] || 0) + 1;"}],"goTo":[{"id":"scioly_invitational.medal_ceremony_fossils"}],"content":{"content":"You got a gold medal! Aubrey gives you a hug before running up to the stage, with you half-jogging behind her.","type":"paragraph"}},"skip.w9_research_status":{"id":"skip.w9_research_status","options":[{"id":"@skip.w9_research_1","title":"You\'ve been working in the lab regularly."},{"id":"@skip.w9_research_2","title":"You\'ve started on research."},{"id":"@skip.w9_research_3","title":"You haven\'t been involved in research."}],"content":{"content":"Research status:","type":"paragraph"}},"scioly_study_party.roxy_confession":{"id":"scioly_study_party.roxy_confession","options":[{"id":"@scioly_study_party.roxy_confession_2","title":"\\"What?\\""}],"content":{"content":[{"type":"paragraph","content":"The nascent conversation ceases. In the semi-distance the game continues as the captain willed. They sound happy, but perhaps you imagine a cloud hanging over their laughs. Great job ruining everything once more. You notice some people glancing in your direction. Aubrey smiles at you. You look away."},{"type":"paragraph","content":["\\"Hey, ",{"type":"insert","insert":0},"?\\" David breaks the silence. His voice is even quieter than usual, just barely above a whisper. \\"There\'s something I\'ve been meaning to talk to you about. I was wondering if now is a good time.\\""]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"thanksgiving_party.out":{"id":"thanksgiving_party.out","options":[{"id":"@thanksgiving_party.eat_research_known","title":"You fill your plate and sit next to him."},{"id":"@thanksgiving_party.eat_research_unknown","title":"You fill your plate and sit next to him."}],"content":[{"type":"paragraph","content":"The two of you head downstairs, following the fragrance of steamed rice and myriad oils and sauces. Some of the younger children have already started filling their plates. Your reluctant companion fills his plate first, and then starts to head upstairs before his father calls after him."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"---, come eat with us down here.\\""}," He turns around with a sigh and heads to the living room sofas."]}]},"scioly_2.proteins_2_final":{"id":"scioly_2.proteins_2_final","content":{"content":"The quizzing continues. At the end, Aubrey tells you to study more. You can\'t really disagree.","type":"paragraph"}},"aubrey_final.have_to_leave":{"id":"aubrey_final.have_to_leave","content":[{"type":"paragraph","content":"The sun has already set. You have homework. She has homework."},{"type":"paragraph","content":"Aubrey gets up first. \\"It\'s been a good time,\\" she says. \\"We should hang out more. Like, as friends.\\""},{"type":"paragraph","content":"\\"Yeah...\\""},{"type":"paragraph","content":"You head back by train together, your feelings left unsaid, or perhaps unknown even to yourself."}]},"aubrey_final":{"id":"aubrey_final","type":"scene","title":"Aubrey","subtitle":"A date...?","newPage":true,"viewIf":{"$code":"return ((((Q[\'week\'] || 0)===11) && ((Q[\'aubrey_date\'] || 0)===1)) && ((Q[\'week_progress\'] || 0) < 3));"},"onArrival":[{"$code":"Q[\'aubrey_date\'] = 2;"}],"tags":["top","weekend","aubrey","social"],"maxVisits":1,"options":[{"id":"@aubrey_final.date_beginning","title":"To answer, you must go back in time."}],"content":[{"type":"paragraph","content":"Aubrey had originally sent you a list of potential locations for the date. Then, realizing that you are really bad at making choices, she unilaterally decided that you two were going to go downtown and just wander around. Which is basically what you would have chosen for a date. Which is a positive sign. Probably."},{"type":"paragraph","content":"Now the two of you are sitting in a brick-covered, concrete-lined downtown plaza, by the Brutalist city hall. The sun is about to set. Tourists and workers are swarming about."},{"type":"paragraph","content":"\\"So, how was the date?\\", Aubrey asks."}],"countVisitsMax":1},"birthday.laugh":{"id":"birthday.laugh","goTo":[{"id":"birthday.okay"}],"content":{"content":"You start laughing. Oh god, why? And for some reason you can\'t stop. Your throat hurts.","type":"paragraph"}},"christmas_party.close_eyes":{"id":"christmas_party.close_eyes","goTo":[{"id":"christmas_party.start_eating"}],"content":{"content":"You close your eyes and clasp your hands, as usual, letting Wang Laoshi\'s words wash over you.","type":"paragraph"}},"emily_6.sit_next":{"id":"emily_6.sit_next","onArrival":[{"$code":"Q[\'emily_date\'] = 1;\\nQ[\'emily\'] = 7;\\nQ[\'growth_points\'] = (Q[\'growth_points\'] || 0) + 1;"}],"options":[{"id":"@emily_6.ohgod","title":"Oh God..."}],"content":[{"type":"paragraph","content":"\\"And that girl is sitting next to me right now. Sorry.\\""},{"type":"paragraph","content":"It takes a moment for what you said to process through your mind."},{"type":"paragraph","content":"Oh God oh god oh god oh god oh god oh god...."}]},"emily_7.and_you_are_happy":{"id":"emily_7.and_you_are_happy","content":[{"type":"paragraph","content":"And you\'re happy too? To be in this moment with Emily, to have one moment of something akin to companionship free from the vissicitudes of the world just for this one moment. Or something like that."},{"type":"paragraph","content":"For some reason you want to cry, but no tears come. It\'s an irrational reaction."}]},"miri_date.another_pause":{"id":"miri_date.another_pause","options":[{"id":"@miri_date.videogames","title":"Play videogames?"},{"id":"@miri_date.tv","title":"Watch TV?"}],"content":[{"type":"paragraph","content":"\\"Okay, so, I\'m going to decare the deep conversation to be over now,\\" she says after another pause of indeterminate length. \\"That was kind of depressing. Do you want to do something fun next?\\""},{"type":"paragraph","content":"\\"Um, sure...?\\""},{"type":"paragraph","content":"\\"Okay, so, we could play video games? There\'s an old Wii, if that\'s what you\'re into. And an Xbox. Or we could watch TV?\\""}]},"miri_pageant_prep.because":{"id":"miri_pageant_prep.because","goTo":[{"id":"miri_pageant_prep.anyway"}],"content":{"content":"You don\'t need a reason to want to hang out with somebody... right? You can relate to other people without treating them as a way to gain advantage... right?","type":"paragraph"}},"pageant_final.car":{"id":"pageant_final.car","options":[{"id":"@pageant_final.pageant_introductions","title":"Introductions."}],"content":[{"type":"paragraph","content":"The regional pageant is held in the basement conference rooms of a mid-tier hotel in Cambridge. Your parents are driving you, dad in the driver\'s seat and mom sitting shotgun, Kevin and you in the back. The ride is quiet save the monotone voice of the NPR news reporter."},{"type":"paragraph","content":"At the hotel there is the submission of paperwork; yours is already in order."},{"type":"paragraph","content":"\\"Good luck,\\" dad says. Kevin echoes him. Mom gives you a hug. You wave them goodbye."},{"type":"paragraph","content":"Then you are led towards a back room, where the other pageant contestants sit in waiting. Some of them smile at you. You make your best attempt to smile back, or something like that. Some of them chat amongst themselves. One girl talks to you. You don\'t really know what to say in response, as usual, so she smiles and walks away."},{"type":"paragraph","content":"You close your eyes. Soon enough it is time."}]},"pageant_meetup.socialize_none":{"id":"pageant_meetup.socialize_none","viewIf":{"$code":"return ((Q[\'sit_emily\'] || 0)===0);"},"options":[{"id":"@pageant_meetup.leave_early","title":"Yeah."},{"id":"@pageant_meetup.social","title":"Um, not really."}],"content":{"content":"You normally can\'t stand social events and interactions and the like. But if you want to do well in the pageant, maybe it\'s best if you talk to someone who\'s done it before.","type":"paragraph"}},"scioly_invitational.medal_ceremony_protein_silver":{"id":"scioly_invitational.medal_ceremony_protein_silver","viewIf":{"$code":"return ((Q[\'protein\'] || 0)===1);"},"onArrival":[{"$code":"Q[\'medal_count\'] = (Q[\'medal_count\'] || 0) + 1;\\nQ[\'silver_count\'] = (Q[\'silver_count\'] || 0) + 1;"}],"goTo":[{"id":"scioly_invitational.medal_ceremony_fossils"}],"content":{"content":"You got a silver medal! Aubrey gives you a brief hug before running up to the stage, with you half-jogging behind her.","type":"paragraph"}},"skip.w9_research_1":{"id":"skip.w9_research_1","onArrival":[{"$code":"Q[\'research\'] = 6;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 4;"}],"goTo":[{"id":"skip.w9_emily_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.roxy_confession_2":{"id":"scioly_study_party.roxy_confession_2","options":[{"id":"@scioly_study_party.process_confession","title":"It takes a moment for the statement to process."}],"content":[{"type":"paragraph","content":"\\"What? I mean, I guess that\'s fine?\\" You glance over at him. He doesn\'t look nervous or any different from usual, but you\'re a poor judge of character."},{"type":"paragraph","content":"\\"I\'m kind of not a boy, if that makes any sense.\\""},{"type":"paragraph","content":"\\"Oh.\\""}]},"thanksgiving_party.eat_research_known":{"id":"thanksgiving_party.eat_research_known","viewIf":{"$code":"return ((Q[\'research\'] || 0) > 0);"},"options":[{"id":"@thanksgiving_party.party_conversations","title":"And it goes on and on."},{"id":"@thanksgiving_party.party_conversations_known","title":"And it goes on and on."}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"How have you been progressing with the research?\\""},", Professor Chen asks."]},{"type":"paragraph","content":"\\"Um, a little bit...\\""},{"type":"paragraph","content":["He laughs and pats you on the back. ",{"type":"emphasis-1","content":"\\"It\'s fine, it\'s fine. Stella said good things about you.\\""}]}]},"scioly_2.david":{"id":"scioly_2.david","viewIf":{"$code":"return (((Q[\'david_scioly\'] || 0)===0) && ((Q[\'roxana_seen\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'david_scioly\'] = (Q[\'david_scioly\'] || 0) + 1;\\nQ[\'fossils\'] = (Q[\'fossils\'] || 0) + 1;"}],"options":[{"id":"@scioly_2.david_wiki","title":"So you go to the computer lab and read some wikipedia."}],"content":[{"type":"paragraph","content":"David Nguyen is a quiet and awkward kid. Well, almost as awkward as you (there are a lot of awkward people in Science Olympiad but you\'re probably near the top in that department, but maybe David has you beat). Besides that, you don\'t know him very well, but apparently he\'s good at fossils."},{"type":"paragraph","content":"\\"Um, fossils,\\" you say."},{"type":"paragraph","content":"\\"Right,\\" he says, before going back to looking at his cell phone. \\"Sorry, I have to go to work right now. I\'ll share my notes with you later.\\""},{"type":"paragraph","content":"With that, he gets up and leaves the room. Well, that was helpful."}]},"birthday.okay":{"id":"birthday.okay","options":[{"id":"@birthday.water","title":"\\"Yeah.\\""}],"content":[{"type":"paragraph","content":"\\"Are you okay?\\", Aubrey asks. Miri\'s started to laugh too."},{"type":"paragraph","content":"\\"No, but I\'ve never been okay. And like, that\'s the one constant fact that\'s existed throughout my whole life or something like that, like it\'s that i\'ve never been okay and i don\'t get why people always ask that and...\\""},{"type":"paragraph","content":"\\"Hey. It\'s fine,\\" Miri says. \\"Want some water?\\""}]},"christmas_party.start_eating":{"id":"christmas_party.start_eating","options":[{"id":"@christmas_party.aubrey_ask_em","title":"Aubrey asks Emily..."},{"id":"@christmas_party.aubrey_ask_karen","title":"Aubrey asks you..."}],"content":[{"type":"paragraph","content":["Now it is time to start eating. The younger children go first, your brother among them. Then it is the teenagers. Emily picks the meat away, taking only the vegetables and rice. \\"Are you a vegetarian?\\", Aubrey asks. \\"Trying, at least,\\" Emily replies. \\"Wow,\\" some adults say. ",{"type":"emphasis-1","content":"\\"How can a child be like this?\\""},""]},{"type":"paragraph","content":"The three of you carry your paper plates and plastic sporks back up to Aubrey\'s room."}]},"emily_6.so_yeah":{"id":"emily_6.so_yeah","onArrival":[{"$code":"Q[\'emily\'] = 7;"}],"options":[{"id":"@emily_6.aubrey","title":"Aubrey"},{"id":"@emily_6.miri","title":"Miri"},{"id":"@emily_6.emily","title":"Emily"},{"id":"@emily_6.no_one","title":"No one in particular"}],"content":[{"type":"paragraph","content":"\\"So, um, yeah. That\'s the story of my life right now. I have a, uh, crush. On an unspecified person whom you probably might or might not know but most likely not. Sorry.\\""},{"type":"paragraph","content":"Okay. Let\'s be honest here. Who were you thinking about?"}]},"emily_7.worries":{"id":"emily_7.worries","content":[{"type":"paragraph","content":"You\'re worried that this moment won\'t last, that you\'ll be separated by the vissicitudes of the world, that she\'ll change and you\'ll change and nothing like this moment will occur again."},{"type":"paragraph","content":"For some reason you want to cry, but no tears come. It\'s an irrational reaction."}]},"emily_7":{"id":"emily_7","type":"scene","title":"Emily","subtitle":"Inevitably awkward moments","newPage":true,"viewIf":{"$code":"return (((((Q[\'emily\'] || 0)===7) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'stress\'] || 0) < 15)) && ((((Q[\'week\'] || 0) < 10) || ((Q[\'week\'] || 0)===11))));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'emily\'] = (Q[\'emily\'] || 0) + 1;\\nQ[\'pageant_interview\'] = (Q[\'pageant_interview\'] || 0) + 1;\\nQ[\'weekly_emily\'] = 1;"}],"maxVisits":1,"tags":["top","social"],"options":[{"id":"@emily_7.wait_1","title":"Let her continue."},{"id":"@emily_7.real_question","title":"Let her continue."}],"content":[{"type":"paragraph","content":"\\"Do you think we\'d be friends if I weren\'t at least adequate at performing femininity?\\""},{"type":"paragraph","content":"\\"What?\\""},{"type":"paragraph","content":"Emily is apparently in a logic-bomb-dropping mood today. Despite your interjection, which was more for stalling than anything else, you understood her the first time and are now trying to process it in your head."},{"type":"paragraph","content":"\\"So like, sorry for the awkward question,\\" Emily begins, \\"but like, I expend so much fucking effort into, like, my physical presentation, and like...\\" She pauses for a bit, glancing around the Commons. She fidgets, as if searching for something to say."}],"countVisitsMax":1},"miri_date.videogames":{"id":"miri_date.videogames","options":[{"id":"@miri_date.kiss","title":"It\'s time to leave..."},{"id":"@miri_date.no_kiss","title":"It\'s time to leave..."}],"content":[{"type":"paragraph","content":"\\"Let\'s just play the videogames.\\""},{"type":"paragraph","content":"\\"Sure, great!\\""},{"type":"paragraph","content":"You have approximately an hour before her brother gets home, so you play a few rounds of Super Smash Bros Brawl. Miri wins every round; it\'s usually not even close."},{"type":"paragraph","content":"\\"You can\'t just keep on flying up and doing the brick thing!\\", she says. \\"It might work against AI and noobs but an actually good player can destroy you easily!\\""},{"type":"paragraph","content":"\\"Are you implying that you\'re an actually good player?\\""},{"type":"paragraph","content":"Miri laughs, and punches you in the arm. \\"Maybe we can play more, once you\'re done with all that... stuff.\\""}]},"miri_pageant_prep.lonely":{"id":"miri_pageant_prep.lonely","goTo":[{"id":"miri_pageant_prep.anyway"}],"content":{"content":"You\'re lonely, and she\'s the only person whom you know would voluntarily be with you at this moment. Not that she\'s your friend of last resort, definitely not; she\'s pretty great.","type":"paragraph"}},"pageant_final.pageant_introductions":{"id":"pageant_final.pageant_introductions","onArrival":[{"$code":"Q[\'introduction_score\'] = (((Q[\'pageant_appearance\'] || 0) / 4) + ((Q[\'pageant_interview\'] || 0) / 2));"}],"options":[{"id":"@pageant_final.introduction_correct","title":"Pronounce your last name correctly."},{"id":"@pageant_final.introduction_wrong","title":"Pronounce your last name incorrectly, the way most non-Asian people do."}],"content":{"content":"The first step in any pageant is the introduction. Here, you\'re supposed to walk on stage in front of the judges and parents (fortunately you don\'t see your family there), and say your name and a brief statement about yourself, while making a pose. You\'re one of the last ones up; from a seat by the side of the stage, you watch no more than ten girls before you walk and do their thing. They all seem so elegant, so prepared, and you do not expect to live up to them.","type":"paragraph"}},"pageant_meetup.socialize_none_emily":{"id":"pageant_meetup.socialize_none_emily","viewIf":{"$code":"return (((Q[\'sit_emily\'] || 0)===1) && ((Q[\'emily\'] || 0)===0));"},"options":[{"id":"@pageant_meetup.socialize_emily_2","title":"\\"Yeah...\\""}],"content":[{"type":"paragraph","content":"You can\'t stand social events and interactions and the like, so you decide to leave."},{"type":"paragraph","content":"\\"Wait!\\" Emily calls out to you before you stand up. \\"Um, hi, but, can I talk to you about something?\\""},{"type":"paragraph","content":"You freeze, and turn to look at her. \\"Um, sure,\\" you manage to say."},{"type":"paragraph","content":"\\"You\'re doing the pageant, right?\\""}]},"scioly_invitational.medal_ceremony_protein_bronze":{"id":"scioly_invitational.medal_ceremony_protein_bronze","viewIf":{"$code":"return ((Q[\'protein\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'medal_count\'] = (Q[\'medal_count\'] || 0) + 1;\\nQ[\'bronze_count\'] = (Q[\'bronze_count\'] || 0) + 1;"}],"goTo":[{"id":"scioly_invitational.medal_ceremony_fossils"}],"content":{"content":"You got a bronze medal! Aubrey gives you a high-five before running up to the stage, with you half-jogging behind her. You feel as if she is somewhat disappointed at the result, and is also blaming you for it. But that\'s just a supposition.","type":"paragraph"}},"skip.w9_research_2":{"id":"skip.w9_research_2","onArrival":[{"$code":"Q[\'research\'] = 3;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 2;"}],"goTo":[{"id":"skip.w9_emily_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.process_confession":{"id":"scioly_study_party.process_confession","onArrival":[{"$code":"Q[\'loneliness\'] = (Q[\'loneliness\'] || 0) - 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) - 1;\\nQ[\'roxana_seen\'] = 1;\\nQ[\'growth_points\'] = (Q[\'growth_points\'] || 0) + 1;"}],"options":[{"id":"@scioly_study_party.krishna_walks_over","title":"It\'s then that Krishna walks over."}],"content":[{"type":"paragraph","content":"It takes a moment for the statement to process. Then you can\'t help but smile."},{"type":"paragraph","content":"\\"Yeah I get it. That\'s, uh, pretty cool,\\" you say, hoping it sounds sincere. \\"Do you, um, have different pronouns or names?\\""},{"type":"paragraph","content":"\\"I guess \'they\' would be fine for now, but don\'t use it in public. And as for my name... I was thinking of \'Roxana\' with one N, or maybe \'Roxy\' for short. But again, don\'t use it in public.\\""},{"type":"paragraph","content":"\\"Oh, uh, hi Roxana Nguyen. That\'s, uh, sounds nice.\\""},{"type":"paragraph","content":"\\"But again, please never utter that name in public. Ever.\\" Even as they\'re whispering that to you, they\'re smiling. And you\'re smiling too."},{"type":"paragraph","content":"\\"I mean, yeah, of course.\\""}]},"thanksgiving_party.eat_research_unknown":{"id":"thanksgiving_party.eat_research_unknown","viewIf":{"$code":"return ((Q[\'research\'] || 0)===0);"},"options":[{"id":"@thanksgiving_party.party_conversations","title":"And it goes on and on."},{"id":"@thanksgiving_party.party_conversations_known","title":"And it goes on and on."}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Qiuyi, I heard your studies are very good,\\""}," Professor Chen says. ",{"type":"emphasis-1","content":"\\"Your parents say that you like to study biology. Would you like to come and work for me?\\""}," He uses the same voice on you that he uses on the five year-olds."]},{"type":"paragraph","content":["\\"Um, ",{"type":"emphasis-1","content":"I don\'t know?\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Haha. It\'ll be good on your college applications.\\""},""]},{"type":"paragraph","content":{"type":"emphasis-1","content":"\\"Oh.\\""}}]},"scioly_2.david_wiki":{"id":"scioly_2.david_wiki","content":[{"type":"paragraph","content":"Fossils is a knowledge-based event: the more you\'ve memorized about everything, the better you\'ll do. So you study. The most important part of the event is identification: you have to identify the names of two pages\' worth of fossil organisms. That part\'s not too difficult; only the brachiopods are sort of indistinct, and occasionally they\'ll drop something obscure like horse teeth, which look weirdly like coral for some reason. Then there\'s the general knowledge components, a grab bag of basically anything related to paleontology. There\'s the ordered list of geographical time periods, taphonomy (how fossils are formed), geographical events like orogenies (when mountain ranges form), and so on."},{"type":"paragraph","content":"You keep on reading Wikipedia, making sure to follow the external links on the bottom of the page, until you have to go home."}]},"birthday.water":{"id":"birthday.water","options":[{"id":"@birthday.group_hug","title":"Group hug."}],"content":[{"type":"paragraph","content":"\\"Yeah. Thanks.\\""},{"type":"paragraph","content":"Miri goes to the fridge and gets a cup of water, handing it to you. Your throat feels a little better now."},{"type":"paragraph","content":"\\"Group hug?\\", Miri says, eyeing you and Aubrey."}]},"christmas_party.aubrey_ask_em":{"id":"christmas_party.aubrey_ask_em","viewIf":{"$code":"return ((Q[\'come_out_christmas_party\'] || 0)===1);"},"options":[{"id":"@christmas_party.anywhere_else","title":"You wish you were anywhere but here."}],"content":[{"type":"paragraph","content":"\\"So, can you tell me more about the whole transgender thing?\\""},{"type":"paragraph","content":"Emily, of course, stares at Aubrey for a few tense moments. \\"Fine. What do you want to know?\\""},{"type":"paragraph","content":"\\"So like, you\'re a boy who wants to be a girl, right?\\""},{"type":"paragraph","content":"Emily visibly rolls her eyes once more and shakes her head."},{"type":"paragraph","content":"\\"Sorry! Is that a bad question?\\", Aubrey continues."},{"type":"paragraph","content":"\\"Ugh. I mean, sorry, just forget I ever mentioned that. Can we go back to the game?\\""},{"type":"paragraph","content":"Aubrey seems hurt by Emily\'s reaction. \\"Once we\'re done eating, maybe,\\" she says."}]},"emily_6.aubrey":{"id":"emily_6.aubrey","goTo":[{"id":"emily_6.emily_response"}],"content":{"content":"Okay. That\'s fine.","type":"paragraph"}},"miri_date.kiss":{"id":"miri_date.kiss","viewIf":{"$code":"return ((Q[\'miri_touch\'] || 0)===1);"},"options":[{"id":"@miri_date.less_awkward","title":"You aren\'t feeling so awkward anymore..."},{"id":"@miri_date.nonono","title":"Oh no oh no oh no..."}],"content":[{"type":"paragraph","content":"\\"So, can we kiss?\\", Miri asks as you\'re about to leave."},{"type":"paragraph","content":"Oh. Um."}]},"miri_pageant_prep.like_her":{"id":"miri_pageant_prep.like_her","goTo":[{"id":"miri_pageant_prep.anyway"}],"onArrival":[{"$code":"Q[\'miri_like\'] = (Q[\'miri_like\'] || 0) + 1;"}],"content":{"content":"What\'s that supposed to mean? What does it mean that you \\"like\\" her? Would she be open to... never mind. You just hope she doesn\'t notice you surreptitiously glancing in her direction all the time.","type":"paragraph"}},"pageant_final.introduction_correct":{"id":"pageant_final.introduction_correct","onArrival":[{"$code":"Q[\'name_correct\'] = 1;"}],"goTo":[{"id":"pageant_final.introduction_end"}],"content":{"content":"","type":"paragraph"}},"pageant_meetup.leave_early":{"id":"pageant_meetup.leave_early","onArrival":[{"$code":"Q[\'loneliness\'] = (Q[\'loneliness\'] || 0) + 1;"}],"content":{"content":"No, you\'d rather not socialize with these people. What\'s the point?","type":"paragraph"}},"scioly_invitational.medal_ceremony_fossils":{"id":"scioly_invitational.medal_ceremony_fossils","options":[{"id":"@scioly_invitational.medal_ceremony_fossils_gold","title":"Gold!"},{"id":"@scioly_invitational.medal_ceremony_fossils_silver","title":"Silver!"},{"id":"@scioly_invitational.medal_ceremony_fossils_bronze","title":"Bronze!"}],"content":{"content":"The next event of yours to be announced is Fossils.","type":"paragraph"}},"skip.w9_research_3":{"id":"skip.w9_research_3","onArrival":[{"$code":"Q[\'research\'] = -1;"}],"goTo":[{"id":"skip.w9_emily_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.krishna_walks_over":{"id":"scioly_study_party.krishna_walks_over","content":[{"type":"paragraph","content":"\\"Hey David, how\'s your feelings jam going? Do you like that reference?\\""},{"type":"paragraph","content":"\\"Oh shut up,\\" Roxana (David?) says. Then, to you, \\"I hope you feel better.\\""},{"type":"paragraph","content":"The party is practically over after that. Aubrey walks over and touches you on the shoulder as she heads out. Roxana smiles and waves at you prior to leaving, which is more in terms of interaction than they\'ve ever had with you in the previous three years in which the two of you were acquainted."},{"type":"paragraph","content":"\\"Good luck,\\" the captain says as you finally get ready to leave."},{"type":"paragraph","content":"There was not much studying done here, or much partying."},{"type":"paragraph","content":"But... in the end, things turned out okay. Maybe human interactions are worthwhile after all."}]},"thanksgiving_party.party_conversations":{"id":"thanksgiving_party.party_conversations","viewIf":{"$code":"return ((Q[\'meet_emily\'] || 0)===0);"},"options":[{"id":"@thanksgiving_party.listen_more","title":"Keep on eating. And listening."}],"content":{"type":"paragraph","content":["The conversations continue. --- is accosted by another parent asking about his college application plans. You lose track of him after a while. Someone asks you about why you\'re entering a beauty pageant, because apparently it\'s a low-tier extracurricular. ",{"type":"emphasis-1","content":"\\"But for Chinese kids it\'s different because not many Chinese kids do this,\\""}," your mom argues. ",{"type":"emphasis-1","content":"\\"And she doesn\'t have other specialties.\\""}]}},"scioly_2.david2":{"id":"scioly_2.david2","viewIf":{"$code":"return (((Q[\'david_scioly\'] || 0)===1) && ((Q[\'roxana_seen\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'david_scioly\'] = (Q[\'david_scioly\'] || 0) + 1;\\nQ[\'fossils\'] = (Q[\'fossils\'] || 0) + 1;"}],"options":[{"id":"@scioly_2.david_what","title":"\\"What are you looking at?\\""}],"content":[{"type":"paragraph","content":"\\"Um, should we study fossils?\\""},{"type":"paragraph","content":"David Nguyen is looking at his cell phone, as always. Did he hear you?"}]},"birthday.group_hug":{"id":"birthday.group_hug","content":[{"type":"paragraph","content":"\\"Before I forget, I have a gift too,\\" Miri says."},{"type":"paragraph","content":"She hands you a gift card and a Madoka Magica DVD set."},{"type":"paragraph","content":"\\"What\'s that?\\", Aubrey asks."},{"type":"paragraph","content":"\\"Oh boy do I have news for you,\\" Miri says with a smirk. \\"Let\'s put it on.\\""},{"type":"paragraph","content":"Everything is fine once more. Miri shows some anime, which Aubrey promptly ignores while she tries to study for an AP World test. And then you and Miri get roped into studying as well. Somehow it became a study-birthday-party. Just as well. You\'d have it no other way."},{"type":"paragraph","content":"Academics might be the one way in which you can relate to other humans, but this time it works. Or something like that."},{"type":"paragraph","content":"By the time the two of them have to leave, you\'ve finally grown comfortable. Blissful, even. It\'s not a bad feeling. You could get used to this."}]},"birthday":{"id":"birthday","type":"scene","title":"Birthday","subtitle":"A party?","viewIf":{"$code":"return ((Q[\'week\'] || 0)===3);"},"onArrival":[{"$code":"Q[\'birthday_party\'] = 1;"}],"tags":["weekend"],"options":[{"id":"@birthday.invite_miri","title":"Invite Miri."},{"id":"@birthday.invite_aubrey","title":"Invite Aubrey."},{"id":"@birthday.no_invite","title":"Don\'t invite anyone."}],"content":{"content":"It\'s your 17th birthday this Sunday, November 9. Normally you\'re not much one for birthdays, but your parents said that they wanted you to celebrate or something like that, have some fun, do something besides sit in your room. They say that you have friends, that you should invite them over for once.","type":"paragraph"}},"christmas_party.aubrey_ask_karen":{"id":"christmas_party.aubrey_ask_karen","viewIf":{"$code":"return ((Q[\'come_out_christmas_party\'] || 0)===0);"},"options":[{"id":"@christmas_party.anywhere_else_2","title":"You wish you were anywhere but here."}],"content":{"content":[{"type":"paragraph","content":["\\"So, uh, ",{"type":"insert","insert":0},"...\\" Aubrey trails off."]},{"type":"paragraph","content":"\\"Yeah?\\""},{"type":"paragraph","content":"\\"You\'re, like, gay, right?\\""},{"type":"paragraph","content":"You stare at your plate of food."},{"type":"paragraph","content":"\\"I mean, what\'s it to you?\\""},{"type":"paragraph","content":"\\"Nothing. --- knows, right?\\""},{"type":"paragraph","content":"Emily nods. Respectfully, Aubrey should have thought harder before outing you to a potential stranger, but it\'s not like she really knows about the etiquette of such matters."},{"type":"paragraph","content":"\\"So like, do the two of you, like, have a thing going on?\\""}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"emily_6.miri":{"id":"emily_6.miri","goTo":[{"id":"emily_6.emily_response"}],"content":{"content":"Okay. That\'s fine.","type":"paragraph"}},"miri_date.less_awkward":{"id":"miri_date.less_awkward","options":[{"id":"@miri_date.do_kiss","title":"Do it."},{"id":"@miri_date.dont_kiss_1","title":"Your heart is beating super fast."}],"content":{"type":"paragraph","content":["You\'re feeling less awkward about physical contact, and you really do ",{"type":"emphasis-1","content":"like"}," her, so..."]}},"miri_pageant_prep.anyway":{"id":"miri_pageant_prep.anyway","options":[{"id":"@miri_pageant_prep.walk_around","title":"Just walk around?"}],"content":[{"type":"paragraph","content":"\\"where do you want to go?\\", Miri asks. \\"Wait. If you don\'t know, how about let\'s go downtown, and like, just walk around?\\""},{"type":"paragraph","content":"\\"Um. Sure. I guess. Like an impromptu trip downtown for no reason other than to wander about aimlessly?\\""},{"type":"paragraph","content":"\\"Yeah. Exactly.\\""},{"type":"paragraph","content":"The two of you take the Orange Line to downtown, sitting without talking. Miri looks at something on her cell phone; you look out the window until the train enters the tunnel. What even is there to do here, and why did you go on a weekday? It\'s rush hour, when the commuters are getting out of their office towers and onto their cars and trains heading home. The commute back will be packed."}]},"pageant_final.introduction_wrong":{"id":"pageant_final.introduction_wrong","onArrival":[{"$code":"Q[\'name_correct\'] = 0;"}],"goTo":[{"id":"pageant_final.introduction_end"}],"content":{"content":"","type":"paragraph"}},"pageant_meetup.socialize_end":{"id":"pageant_meetup.socialize_end","content":{"content":"It\'s time for you to leave, to go back home to do homework or whatever. Quietly you open the door and walk outside.","type":"paragraph"}},"pageant_meetup":{"id":"pageant_meetup","type":"scene","title":"Pageant Prep","subtitle":"The mandatory meeting","newPage":true,"viewIf":{"$code":"return (((Q[\'week\'] || 0)===1) && ((Q[\'class_visited\'] || 0)===-1));"},"onArrival":[{"$code":"Q[\'pageant_prep\'] = (Q[\'pageant_prep\'] || 0) + 1;\\nQ[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'mandatory_meeting_calm\'] = 0;\\nQ[\'class_visited\'] = 1;\\nQ[\'introspection\'] = 1;"}],"priority":2,"tags":["top","pageant_prep"],"options":[{"id":"@pageant_meetup.starting","title":"You took the train and bus to get there."}],"content":{"content":"There\'s a mandatory meeting for pageant contestants today. Well, not technically mandatory, just highly recommended, especially for new contestants. It\'s probably important.","type":"paragraph"}},"scioly_invitational.medal_ceremony_fossils_gold":{"id":"scioly_invitational.medal_ceremony_fossils_gold","viewIf":{"$code":"return ((Q[\'fossils\'] || 0) >= 2);"},"onArrival":[{"$code":"Q[\'medal_count\'] = (Q[\'medal_count\'] || 0) + 1;\\nQ[\'bronze_count\'] = (Q[\'bronze_count\'] || 0) + 1;"}],"goTo":[{"id":"scioly_invitational.medal_ceremony_cell"}],"content":{"content":{"type":"paragraph","content":["You got a gold medal in Fossils! ",{"type":"conditional","content":"Roxana ","predicate":0},{"type":"conditional","content":"David ","predicate":1}," walks up to the stage behind you."]},"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'roxana_seen\'] || 0)===1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'roxana_seen\'] || 0)===0);"}}]}},"skip.w9_emily_status":{"id":"skip.w9_emily_status","options":[{"id":"@skip.w9_emily_1","title":"You\'re good friends with Emily."},{"id":"@skip.w9_emily_2","title":"You\'re dating... ish?"},{"id":"@skip.w9_emily_3","title":"You have not interacted much."}],"content":{"content":"Relationship with Emily:","type":"paragraph"}},"scioly_study_party.eye_contact_none":{"id":"scioly_study_party.eye_contact_none","options":[{"id":"@scioly_study_party.cry_again","title":"Why do you feel like crying again?"}],"content":[{"type":"paragraph","content":["Think rationally for a moment: why would anyone be concerned about you if you haven\'t even let anyone know that something was wrong? Why would you expect people to read your mind? Should you really expect other people to help you if you can\'t even bother to talk to them? And why would you be so hypocritical about the emotional literacy of this group? As if you have a nonzero amount of emotional literacy? As if you ever ask your friends about how ",{"type":"emphasis-1","content":"they"}," feel (which friends)?"]},{"type":"paragraph","content":"God, you should really just disappear forever."}]},"thanksgiving_party.party_conversations_known":{"id":"thanksgiving_party.party_conversations_known","viewIf":{"$code":"return ((Q[\'meet_emily\'] || 0)===1);"},"options":[{"id":"@thanksgiving_party.listen_more","title":"Keep on eating. and listening."}],"content":{"type":"paragraph","content":["The conversations continue. Emily is accosted by another parent asking about her college application plans. You lose track of her after a while. Someone asks you about why you\'re entering a beauty pageant, because apparently it\'s a low-tier extracurricular. ",{"type":"emphasis-1","content":"\\"But for Chinese kids it\'s different because not many Chinese kids do this,\\""}," your mom argues. ",{"type":"emphasis-1","content":"\\"And she doesn\'t have other specialties.\\""}]}},"scioly_2.david_what":{"id":"scioly_2.david_what","options":[{"id":"@scioly_2.david_talk_about_fossils","title":"Talk about fossils?"}],"content":[{"type":"paragraph","content":"\\"Um, what are you looking at?\\""},{"type":"paragraph","content":["He shows you the pictures of various archetypal Burgess Shale organisms: ",{"type":"emphasis-1","content":"Opabinia"},", ",{"type":"emphasis-1","content":"Anomalocaris"},", ",{"type":"emphasis-1","content":"Wiwaxia"},", and so on."]},{"type":"paragraph","content":"\\"No, I heard you,\\" he says. \\"Sorry. I just got a bit caught up with, uh, some hypotheses regarding the Cambrian explosion.\\""}]},"christmas_party.anywhere_else":{"id":"christmas_party.anywhere_else","goTo":[{"id":"christmas_party.end_scrabble"}],"content":[{"type":"paragraph","content":"The conversation dies, replaced by an awkward lull. Aubrey and Emily are not looking at each other. Sounds of Chinese adults talking/yelling filters from downstairs. You wish you were anywhere but here."},{"type":"paragraph","content":"Soon enough the three of you are finished eating. Everyone returns to the game of Scrabble."}]},"emily_6.emily":{"id":"emily_6.emily","goTo":[{"id":"emily_6.emily_response"}],"content":{"content":"Really? Why couldn\'t you just say so? Of course, you know why. Anyway...","type":"paragraph"}},"miri_date.nonono":{"id":"miri_date.nonono","options":[{"id":"@miri_date.do_kiss","title":"Do it."},{"id":"@miri_date.dont_kiss_1","title":"Your heart is beating super fast."}],"content":{"content":"Wait, shouldn\'t you be excited about this? Isn\'t this what you want?","type":"paragraph"}},"miri_pageant_prep.walk_around":{"id":"miri_pageant_prep.walk_around","options":[{"id":"@miri_pageant_prep.college_apps","title":"College apps?"},{"id":"@miri_pageant_prep.self_improvement","title":"Self-improvement?"}],"content":[{"type":"paragraph","content":"It always feels pleasant just walking around the city, as if there were no burdens in the world."},{"type":"paragraph","content":"Miri starts to talk, after you cross the street towards the Public Garden. \\"Hey, I was wondering,...\\""},{"type":"paragraph","content":"\\"Um, what are you wondering?\\""},{"type":"paragraph","content":"\\"Just, what are you hoping to get out of the pageant? Like, what are you hoping to accomplish by doing this?\\""}]},"pageant_final.introduction_end":{"id":"pageant_final.introduction_end","options":[{"id":"@pageant_final.interview","title":"Interview."}],"content":{"content":[{"type":"paragraph","content":["\\"My name is ",{"type":"insert","insert":0}," Zhao. I am 17 years old, from --- High School.\\""]},{"type":"paragraph","content":[{"type":"conditional","content":"Surprisingly, you don\'t do terribly. Not extremely well, but you fit in with the rest of the girls, and don\'t stand out like an absolute loser. ","predicate":1},""]},{"type":"paragraph","content":[{"type":"conditional","content":"As you would expect, you kind of fail at your introduction. Your gestures are all wrong. Your words are too monotone. Your facial expression is a mistake. You see your failure reflected in the faces of the judges. ","predicate":2},""]},{"type":"paragraph","content":"After the introduction, you are herded back to the waiting room to prepare for the interview."}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'introduction_score\'] || 0) >= 5);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'introduction_score\'] || 0) < 5);"}}]}},"scioly_invitational.medal_ceremony_fossils_silver":{"id":"scioly_invitational.medal_ceremony_fossils_silver","viewIf":{"$code":"return ((Q[\'fossils\'] || 0)===1);"},"onArrival":[{"$code":"Q[\'medal_count\'] = (Q[\'medal_count\'] || 0) + 1;\\nQ[\'silver_count\'] = (Q[\'silver_count\'] || 0) + 1;"}],"goTo":[{"id":"scioly_invitational.medal_ceremony_cell"}],"content":{"content":{"type":"paragraph","content":["You got a silver medal in Fossils! ",{"type":"conditional","content":"Roxana ","predicate":0},{"type":"conditional","content":"David ","predicate":1}," walks up to the stage behind you."]},"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'roxana_seen\'] || 0)===1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'roxana_seen\'] || 0)===0);"}}]}},"skip.w9_emily_1":{"id":"skip.w9_emily_1","onArrival":[{"$code":"Q[\'emily\'] = 7;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 5;"}],"goTo":[{"id":"skip.w9_miri_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.cry_again":{"id":"scioly_study_party.cry_again","options":[{"id":"@scioly_study_party.follow_aubrey","title":"Follow Aubrey."},{"id":"@scioly_study_party.keep_playing","title":"Don\'t go."}],"content":{"content":{"type":"paragraph","content":["\\"Hey, ",{"type":"insert","insert":0},"? Let\'s go somewhere else for a minute.\\" You realize Aubrey tugging on your shoulder."]},"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"thanksgiving_party.listen_more":{"id":"thanksgiving_party.listen_more","options":[{"id":"@thanksgiving_party.listen_more_2","title":"And more."}],"content":[{"type":"paragraph","content":"As the adults shuffle about and you get seconds, you overhear more."},{"type":"paragraph","content":["You overhear your parents and the Chens talk about you. Actually, just the moms. ",{"type":"emphasis-1","content":"\\"Your daughter works so hard!\\""}," ",{"type":"emphasis-1","content":"\\"Aiya, not really.\\""}," ",{"type":"emphasis-1","content":"\\"Does she have a boyfriend?\\""}," ",{"type":"emphasis-1","content":"\\" No, no, of course not. She\'s a bookworm. Does your son have a girlfriend?\\""}," Laughter. ",{"type":"emphasis-1","content":"\\"I don\'t know. I guess not. He doesn\'t like to talk either.\\""}]}]},"scioly_2.david_talk_about_fossils":{"id":"scioly_2.david_talk_about_fossils","options":[{"id":"@scioly_2.david_its_fine","title":"It\'s fine..."}],"content":[{"type":"paragraph","content":"\\"So what are the hypotheses?\\", you ask, trying to provoke conversation with perhaps the only Science Olympiad team member who\'s more awkward than you."},{"type":"paragraph","content":["\\"Um... it\'s kind of a long story...\\" He rolls his eyes, but continues. \\"So this is about the relationship between the Ediacaran biota and the Cambrian ones. The Ediacaran period was immediately before the Cambrian, around 600 to 540 million years ago. The Ediacaran period had a bunch of, you know, really weird life forms. So did the Cambrian, but at least they were recognizable as arthropods or molluscs and stuff like that. But the Ediacaran life was stranger; they looked like weird leaf-like blobs with asymmetrical segmentation, like ",{"type":"emphasis-1","content":"Dickinsonia"},", or things that sort of rememble worms but aren\'t actually like worms at all, like ",{"type":"emphasis-1","content":"Spriggina"},", or that kind of thing. They might not even have been animals.\\" He pauses. \\"You should already know all this, right?\\""]},{"type":"paragraph","content":"You nod, and David continues. \\"So the question here is, why did the Ediacaran life disappear, and what relationship did that have with the Cambrian explosion. Some people think that the Ediacaran life forms all died out in a mass extinction, like the other five mass extinctions, because of something abiogenic. Others think that the Cambrian animals gradually replaced the Ediacaran ones, outcompeted them. Or the change over is just a preservation artifact. Actually there could be a lot of preservation artifacts that make us misunderstand the nature of early animal life...\\" Here David takes a break, and glances sheepishly at you and then back at his phone."},{"type":"paragraph","content":"\\"Sorry. I\'ve been talking a lot. I get... sort of interested in this stuff.\\""}]},"christmas_party.anywhere_else_2":{"id":"christmas_party.anywhere_else_2","options":[{"id":"@christmas_party.push_aubrey","title":"Push the matter."},{"id":"@christmas_party.drop_aubrey","title":"Let it drop."}],"content":[{"type":"paragraph","content":"\\"What do you mean by \'thing\'?\\", you respond."},{"type":"paragraph","content":"\\"Forget it,\\" Aubrey says. \\"Let\'s go back to scrabble.\\""}]},"emily_6.no_one":{"id":"emily_6.no_one","goTo":[{"id":"emily_6.emily_response"}],"content":{"content":"Okay. That\'s fine.","type":"paragraph"}},"miri_date.do_kiss":{"id":"miri_date.do_kiss","options":[{"id":"@miri_date.now_kiss","title":"It happens."}],"content":[{"type":"paragraph","content":["You hear Palpatine\'s voice in your head telling you to ",{"type":"emphasis-1","content":"do it"},". You listen to the voice."]},{"type":"paragraph","content":"\\"Okay,\\" you say. \\"But, like, this is the first time I\'ve...\\""},{"type":"paragraph","content":"\\"Me too!\\" Miri smiles and closes her eyes. You do too. She holds your waist and pulls you in. You lean down."}]},"miri_pageant_prep.college_apps":{"id":"miri_pageant_prep.college_apps","options":[{"id":"@miri_pageant_prep.what_worry","title":"You\'ve had this conversation before."}],"content":[{"type":"paragraph","content":"\\"Uh, college apps?\\""},{"type":"paragraph","content":"\\"Seriously? Is that literally all you care about? Is there literally nothing else in life?\\""},{"type":"paragraph","content":"\\"I mean, like... yeah?\\""},{"type":"paragraph","content":"\\"Do you actually want to do the pageant?\\""},{"type":"paragraph","content":"\\"I... um, don\'t know? Like, it\'s just something that I do.\\""},{"type":"paragraph","content":"Miri sighs. \\"I sometimes worry about you, you know.\\""}]},"pageant_final.interview":{"id":"pageant_final.interview","onArrival":[{"$code":"Q[\'interview_score\'] = 0;\\nQ[\'pageant_score\'] = (Q[\'pageant_score\'] || 0) + (Q[\'introduction_score\'] || 0);"}],"options":[{"id":"@pageant_final.interview_avert","title":"Avert their gazes."},{"id":"@pageant_final.interview_stare","title":"Stare back at them."},{"id":"@pageant_final.interview_look","title":"Look back at them, expression soft."}],"content":[{"type":"paragraph","content":"To say that you\'re nervous would be am understatement, even more so than usual."},{"type":"paragraph","content":"The room is in the hotel\'s basement, with patterned carpet and blank walls, devoid of all decorations except the folding tables and chairs. You are sitting in your dress before a panel of three adults, on a hard, uncomfortable folding chair. They are staring at you, their gazes piercing."}]},"scioly_invitational.medal_ceremony_fossils_bronze":{"id":"scioly_invitational.medal_ceremony_fossils_bronze","viewIf":{"$code":"return ((Q[\'fossils\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'medal_count\'] = (Q[\'medal_count\'] || 0) + 1;\\nQ[\'bronze_count\'] = (Q[\'bronze_count\'] || 0) + 1;"}],"goTo":[{"id":"scioly_invitational.medal_ceremony_cell"}],"content":{"content":{"type":"paragraph","content":["You got a bronze medal in Fossils! To be honest it\'s somewhat better than you expected; ",{"type":"conditional","content":"Roxana ","predicate":0},{"type":"conditional","content":"David ","predicate":1}," could handle things quite well."]},"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'roxana_seen\'] || 0)===1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'roxana_seen\'] || 0)===0);"}}]}},"skip.w9_emily_2":{"id":"skip.w9_emily_2","onArrival":[{"$code":"Q[\'emily\'] = 7;\\nQ[\'emily_date\'] = 1;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 5;"}],"goTo":[{"id":"skip.w9_miri_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.follow_aubrey":{"id":"scioly_study_party.follow_aubrey","onArrival":[{"$code":"Q[\'aubrey\'] = (Q[\'aubrey\'] || 0) + 1;\\nQ[\'aubrey_scioly_study_party\'] = 1;"}],"options":[{"id":"@scioly_study_party.umm_nothing","title":"\\"Nothing?\\""}],"content":{"content":[{"type":"paragraph","content":"\\"Okay,\\" you croak."},{"type":"paragraph","content":"No one says anything as the two of you make your way to an empty couch."},{"type":"paragraph","content":["\\"Hey ",{"type":"insert","insert":0},", what\'s up?\\""]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"thanksgiving_party.listen_more_2":{"id":"thanksgiving_party.listen_more_2","options":[{"id":"@thanksgiving_party.done_eating","title":"You\'re done eating."},{"id":"@thanksgiving_party.done_eating_known","title":"You\'re done eating."}],"content":[{"type":"paragraph","content":"Now they\'re speaking in hushed tones, but you\'re good at eavesdropping."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Hey, have you ever thought that your daughter might be homosexual?\\""}," ",{"type":"emphasis-1","content":"\\"Of course not! She can\'t be!\\""}," ",{"type":"emphasis-1","content":"\\"Our son might be gay.\\""}," ",{"type":"emphasis-1","content":"\\"What? Really?\\""}," ",{"type":"emphasis-1","content":"\\"He always likes to try and look like a girl, likes to look at the women\'s section in stores.\\""}," ",{"type":"emphasis-1","content":"\\"No way!\\""}]}]},"scioly_2.david_its_fine":{"id":"scioly_2.david_its_fine","onArrival":[{"$code":"Q[\'loneliness\'] = (Q[\'loneliness\'] || 0) - 1;"}],"content":[{"type":"paragraph","content":"\\"It\'s fine,\\" you say. \\"I like, uh, Paleozoic life too. It\'s very, um, relevant to fossils.\\""},{"type":"paragraph","content":"It appears as if he doesn\'t want to talk any more, as he turns away and returns to his phone. Of course there is also the possibility that he actually would like to talk and you have just killed the conversation. But, there\'s nothing you can do about that. Or is there? Maybe you should try to talk to him. Or maybe he doesn\'t want to talk."},{"type":"paragraph","content":["Instead you read web pages on fossils by yourself. You sit next to him in the half-empty classroom, neither of you talking much. You try to remember the distinctions between ",{"type":"emphasis-1","content":"Juresania"}," and ",{"type":"emphasis-1","content":"Leptaena"},", two brachiopods that look way too similar. Once in a while you glance over at what David is working on. He\'s also reading about fossils and taking notes. But maybe you shouldn\'t bother him."]},{"type":"paragraph","content":"When it comes time to leave, David leaves without saying another word to you. But he did wave. Okay. That\'s fine. You leave by yourself too."}]},"christmas_party.push_aubrey":{"id":"christmas_party.push_aubrey","goTo":[{"id":"christmas_party.end_scrabble"}],"content":[{"type":"paragraph","content":"\\"No, really, what do you mean?\\""},{"type":"paragraph","content":"\\"I mean, in your words, are the two of you pursuing a romantic relationship,\\" she sounds in a forced robotic monotone, enounciating every word."},{"type":"paragraph","content":"\\"Why would you think that?\\""},{"type":"paragraph","content":"Aubrey sighs. \\"You know what, forget about it.\\""}]},"emily_6.emily_response":{"id":"emily_6.emily_response","options":[{"id":"@emily_6.emily_parents","title":"Sit and wait."}],"content":[{"type":"paragraph","content":"\\"Oh, well, thanks for telling me your story,\\" Emily responds. \\"I do wonder who this girl is, though...\\""},{"type":"paragraph","content":"\\"You wouldn\'t know her anyway... Sorry.\\""},{"type":"paragraph","content":"\\"It\'s okay!\\" She smiles. \\"I hope you, uh, have good luck with your crush.\\""},{"type":"paragraph","content":"She looks away. There\'s nothing more to talk about."}]},"miri_date.now_kiss":{"id":"miri_date.now_kiss","onArrival":[{"$code":"Q[\'miri_kiss\'] = 1;"}],"options":[{"id":"@miri_date.next_time","title":"\\"Yeah. Next time.\\""}],"content":[{"type":"paragraph","content":"It happens, and then it\'s over. Miri releases you. You open your eyes."},{"type":"paragraph","content":"Part of you expected more climactic feelings for your first romantic kiss. You imagined overwhelming waves of emotions roiling over you like nothing you\'ve felt before, an ecstasy like the ones described in novels. But instead what you felt was... Maybe it was the overwhelming nervousness?"},{"type":"paragraph","content":"But it felt good. It was very good. You can\'t help but smile. Miri is smiling too, somehow more so than usual."},{"type":"paragraph","content":"\\"You should have taken off your glasses,\\" she says. \\"Haven\'t you watched any movies?\\""},{"type":"paragraph","content":"\\"Um, I don\'t watch movies.\\""},{"type":"paragraph","content":"\\"Right. Well. Maybe next time. We can practice more.\\""}]},"miri_pageant_prep.self_improvement":{"id":"miri_pageant_prep.self_improvement","options":[{"id":"@miri_pageant_prep.what_worry","title":"You\'ve had this conversation before."}],"content":[{"type":"paragraph","content":"\\"Uh, self-improvement or whatever?\\""},{"type":"paragraph","content":"\\"Are you serious?\\", Miri says, but she already knows what your answer will be."},{"type":"paragraph","content":"\\"Maybe? I mean that\'s what my dad says and sometimes he\'s... not wrong?\\""},{"type":"paragraph","content":"\\"But is that what you want?\\""},{"type":"paragraph","content":"\\"Um, I guess?\\""},{"type":"paragraph","content":"Miri sighs. \\"I sometimes worry about you, you know.\\""}]},"pageant_final.interview_avert":{"id":"pageant_final.interview_avert","goTo":[{"id":"pageant_final.interview_questions"}],"content":{"content":"You look away, as is your instinct. Out of the corner of your eyes you can perhaps see one of them frown.","type":"paragraph"}},"scioly_invitational.medal_ceremony_cell":{"id":"scioly_invitational.medal_ceremony_cell","options":[{"id":"@scioly_invitational.medal_ceremony_cell_gold","title":"Gold!"},{"id":"@scioly_invitational.medal_ceremony_cell_bronze","title":"Bronze!"},{"id":"@scioly_invitational.medal_ceremony_cell_none","title":"No medal :("}],"content":[{"type":"paragraph","content":"There is more waiting. Your school is not doing so well in the medal standings; only one other event has received a medal, and that was a bronze."},{"type":"paragraph","content":"The last of your events to be announced is Cell Biology."}]},"skip.w9_emily_3":{"id":"skip.w9_emily_3","onArrival":[{"$code":"Q[\'emily\'] = 6;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 2;"}],"goTo":[{"id":"skip.w9_miri_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.umm_nothing":{"id":"scioly_study_party.umm_nothing","options":[{"id":"@scioly_study_party.be_honest","title":"Be honest."},{"id":"@scioly_study_party.hide_feelings","title":"Hide your feelings."}],"content":[{"type":"paragraph","content":"\\"Um... Nothing. Nothing is up.\\""},{"type":"paragraph","content":"\\"Are you sure? You looked like you were crying. How have you been feeling?\\""}]},"thanksgiving_party.done_eating":{"id":"thanksgiving_party.done_eating","viewIf":{"$code":"return ((Q[\'meet_emily\'] || 0)===0);"},"options":[{"id":"@thanksgiving_party.tell","title":"Tell --- about the conversation."},{"id":"@thanksgiving_party.dont_tell","title":"Don\'t tell --- about the conversation."}],"content":[{"type":"paragraph","content":"You\'re done eating, so you throw away your paper plate and put your chopsticks in the sink, and head upstairs again, back to ---\'s room."},{"type":"paragraph","content":"\\"What were they talking about down there?\\", --- asks."}]},"scioly_2.roxana":{"id":"scioly_2.roxana","viewIf":{"$code":"return ((Q[\'roxana_seen\'] || 0)===1);"},"onArrival":[{"$code":"Q[\'david_scioly\'] = (Q[\'david_scioly\'] || 0) + 1;\\nQ[\'fossils\'] = (Q[\'fossils\'] || 0) + 1;"}],"content":[{"type":"paragraph","content":"\\"So um... hi...\\""},{"type":"paragraph","content":"\\"Can you act like nothing\'s changed?\\", Roxana says."},{"type":"paragraph","content":"\\"Oh, um. Okay.\\""},{"type":"paragraph","content":"\\"Can we go over fossil identification now?\\""},{"type":"paragraph","content":"\\"Um, sure.\\""}]},"christmas_party.drop_aubrey":{"id":"christmas_party.drop_aubrey","goTo":[{"id":"christmas_party.end_scrabble"}],"content":[{"type":"paragraph","content":"\\"Alright, let\'s, uh, move on,\\" you say. You\'re glad to be rid of that topic."},{"type":"paragraph","content":"Soon enough the three of you are finished eating. Everyone returns to the game of scrabble."}]},"emily_6.ohgod":{"id":"emily_6.ohgod","options":[{"id":"@emily_6.look_at_her","title":"Look at her."},{"id":"@emily_6.dont_look","title":"Don\'t look at her."},{"id":"@emily_6.run_away","title":"Run away."}],"content":[{"type":"paragraph","content":"You take a deep but hopefully non-noticeable breath."},{"type":"paragraph","content":"Did you just ask Emily out? She\'s not saying anything; how long has it been? Seconds? Minutes? It feels noticeably colder, or perhaps you had just ignored the coming evening chill in your rambling. Why did you say that, anyway? You meant it, right? You had to have meant it. And it\'s true, isn\'t it? Why did you say that? What force brought you to say those specific words which you\'ve wanted to say for a while but never had the chance to?"},{"type":"paragraph","content":"Out of the corner of your eyes you see Emily turn towards you."}]},"miri_date.next_time":{"id":"miri_date.next_time","content":[{"type":"paragraph","content":"\\"Yeah. Next time...\\""},{"type":"paragraph","content":"Miri waves as you leave. Her brother\'s car pulls up by the sidewalk. You walk home."}]},"miri_pageant_prep.what_worry":{"id":"miri_pageant_prep.what_worry","options":[{"id":"@miri_pageant_prep.nothing_wrong","title":"Nothing\'s wrong."}],"content":[{"type":"paragraph","content":"You\'ve had this conversation with Miri before. In fact it constitutes a good portion of your \\"serious\\" conversations with her."},{"type":"paragraph","content":"\\"Is something wrong?\\", she continues. \\"You\'ve seemed kind of down lately. Would you like to talk about it?\\""}]},"pageant_final.interview_stare":{"id":"pageant_final.interview_stare","onArrival":[{"$code":"Q[\'interview_score\'] = (Q[\'interview_score\'] || 0) + 1;"}],"goTo":[{"id":"pageant_final.interview_questions"}],"content":{"content":"You reciprocate their stares, your expression probably somewhere between blank and murderous. They don\'t shift.","type":"paragraph"}},"scioly_invitational.medal_ceremony_cell_gold":{"id":"scioly_invitational.medal_ceremony_cell_gold","viewIf":{"$code":"return ((Q[\'cell\'] || 0) >= 2);"},"onArrival":[{"$code":"Q[\'medal_count\'] = (Q[\'medal_count\'] || 0) + 1;\\nQ[\'gold_count\'] = (Q[\'gold_count\'] || 0) + 1;"}],"goTo":[{"id":"scioly_invitational.medal_end"}],"content":{"content":"You won a gold medal in Cell Biology. Krishna offers you a high five, and then pulls away, running to the front stage.","type":"paragraph"}},"skip.w9_miri_status":{"id":"skip.w9_miri_status","options":[{"id":"@skip.w9_miri_1","title":"You\'ve spent some time with Miri."},{"id":"@skip.w9_miri_2","title":"You\'re dating Miri."},{"id":"@skip.w9_miri_3","title":"You have not interacted much."}],"content":{"content":"Relationship with Miri:","type":"paragraph"}},"scioly_study_party.be_honest":{"id":"scioly_study_party.be_honest","options":[{"id":"@scioly_study_party.aubrey_reminisce","title":"Let Aubrey reminisce."}],"content":[{"type":"paragraph","content":"You\'ve forgotten how to use words."},{"type":"paragraph","content":["You ",{"type":"emphasis-1","content":"want"}," to \'talk about your feelings\', whatever that\'s supposed to mean, but it\'s as if the word-producing part of your brain (you\'re not a neuroscientist so you don\'t know what that\'s actually called) isn\'t functioning right now."]},{"type":"paragraph","content":"What is that part of the brain called, anyway?"},{"type":"paragraph","content":"\\"Hey um, what do you call the part of the brain that makes words?\\""},{"type":"paragraph","content":"\\"That\'s Broca\'s Area.\\""},{"type":"paragraph","content":"\\"Oh, um, thanks. Uh, I think mine isn\'t working. Sorry.\\""},{"type":"paragraph","content":"Aubrey makes a seemingly forced chortle. \\"That\'s impossible, since you obviously don\'t have aphasia. Man, you\'re really acting like you were back in middle school.\\""}]},"thanksgiving_party.tell":{"id":"thanksgiving_party.tell","options":[{"id":"@thanksgiving_party.because_gay","title":"\\"Because I\'m also a gay and I would like to find solidarity.\\""},{"id":"@thanksgiving_party.for_no_reason","title":"\\"For no reason in particular.\\""}],"content":[{"type":"paragraph","content":"\\"Um, your mom thought you were gay or something.\\""},{"type":"paragraph","content":"--- laughs, a strange and possibly nervous laugh. \\"Why would you tell me that?\\""}]},"scioly_2.krishna":{"id":"scioly_2.krishna","viewIf":{"$code":"return ((Q[\'krishna_scioly\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'krishna_scioly\'] = (Q[\'krishna_scioly\'] || 0) + 1;\\nQ[\'cell\'] = (Q[\'cell\'] || 0) + 1;"}],"options":[{"id":"@scioly_2.cell_bio","title":"Cell Biology is another memorization event..."}],"content":[{"type":"paragraph","content":"Krishna Rao is notable for being the only other gay in Science Olympiad. That you know of, anyway. He\'s one of the approximately two people you\'ve come out to (and that was on accident). Also, he\'s a genius who\'s probably going to MIT, and interested in biology as well, which would make him a competitor."},{"type":"paragraph","content":"\\"Um, cell biology,\\" you say. \\"We should start, like, studying.\\""},{"type":"paragraph","content":"\\"Yeah.\\""}]},"christmas_party.end_scrabble":{"id":"christmas_party.end_scrabble","options":[{"id":"@christmas_party.follow_aubrey","title":"Follow Aubrey downstairs."},{"id":"@christmas_party.stay_with_emily","title":"Stay with Emily."}],"content":[{"type":"paragraph","content":"The game proceeds, the air taut with tension. Emily and Aubrey do not look at each other. Emily still gives you the occasional furtive glance, but you attempt to avoid returning them. From below, some of the adults have begun singing Christian songs with piano accompaniment."},{"type":"paragraph","content":"\\"I\'m going to go downstairs,\\" Aubrey says, and leaves without explicating further."},{"type":"paragraph","content":"Now you\'re left alone with Emily."}]},"emily_6.look_at_her":{"id":"emily_6.look_at_her","goTo":[{"id":"emily_6.emily_speak_1"}],"content":{"content":"You turn your head. Slowly but surely. She has an unreadable expression (smile? cringe? somewhere in between?) as she starts to speak.","type":"paragraph"}},"miri_date.dont_kiss_1":{"id":"miri_date.dont_kiss_1","options":[{"id":"@miri_date.do_kiss","title":"Do it."},{"id":"@miri_date.dont_kiss_2","title":"No. You can\'t do it."}],"content":[{"type":"paragraph","content":"You need to calm down for a moment. Take some deep breaths. They don\'t help much, if at all."},{"type":"paragraph","content":"\\"Oh, you don\'t have to,\\" Miri says. \\"If you don\'t want to, that\'s fine.\\""}]},"miri_pageant_prep.nothing_wrong":{"id":"miri_pageant_prep.nothing_wrong","options":[{"id":"@miri_pageant_prep.tell_her","title":"Tell her?"},{"id":"@miri_pageant_prep.dont_tell_her","title":"Don\'t tell her?"}],"content":[{"type":"paragraph","content":"You take a long breath. \\"No. Um, nothing\'s wrong.\\" Not technically a lie, just an extreme misdirection."},{"type":"paragraph","content":"\\"What do you mean?\\", she says, glancing into your eyes. The two of you are sitting on a bench overlooking a small artificial lake. No one else is close by; it\'s an overcast day too cold for tourists or joggers, and you can see her breath forming clouds between you."},{"type":"paragraph","content":"\\"You can tell me anything,\\" Miri continues. \\"We\'re friends, right?\\""}]},"pageant_final.interview_look":{"id":"pageant_final.interview_look","viewIf":{"$code":"return ((Q[\'pageant_interview\'] || 0) >= 3);"},"onArrival":[{"$code":"Q[\'interview_score\'] = (Q[\'interview_score\'] || 0) + 2;"}],"goTo":[{"id":"pageant_final.interview_questions"}],"content":{"content":"You attempt a gentle smile, even in the face of their hard gazes. It works, maybe. One of them smiles back. The other two are implacable.","type":"paragraph"}},"scioly_invitational.medal_ceremony_cell_bronze":{"id":"scioly_invitational.medal_ceremony_cell_bronze","viewIf":{"$code":"return ((Q[\'cell\'] || 0)===1);"},"onArrival":[{"$code":"Q[\'medal_count\'] = (Q[\'medal_count\'] || 0) + 1;\\nQ[\'bronze_count\'] = (Q[\'bronze_count\'] || 0) + 1;"}],"goTo":[{"id":"scioly_invitational.medal_end"}],"content":{"content":"So you won a bronze medal in Cell Biology. Krishna offers you a high five, and then pulls away, running to the front stage.","type":"paragraph"}},"skip.w9_miri_1":{"id":"skip.w9_miri_1","onArrival":[{"$code":"Q[\'miri\'] = 5;\\nQ[\'gym\'] = 2;\\nQ[\'miri_practice\'] = 2;\\nQ[\'miri_hang\'] = 1;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 2;\\nQ[\'pageant_interview\'] = (Q[\'pageant_interview\'] || 0) + 2;"}],"goTo":[{"id":"skip.w9_parents_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.hide_feelings":{"id":"scioly_study_party.hide_feelings","goTo":[{"id":"scioly_study_party.be_honest"}],"content":{"content":"","type":"paragraph"}},"thanksgiving_party.because_gay":{"id":"thanksgiving_party.because_gay","goTo":[{"id":"thanksgiving_party.for_no_reason"}],"content":{"content":"You can\'t just say things like that.","type":"paragraph"}},"scioly_2.cell_bio":{"id":"scioly_2.cell_bio","options":[{"id":"@scioly_2.cell_bio_split","title":"\\"Um, it doesn\'t matter?\\""}],"content":[{"type":"paragraph","content":"Cell bio is yet another event where you just have to memorize as much about the relevant topics as possible. The topics in question being, obviously, cell biology. It\'s like an AP bio exam, only harder, or something like that. You do a lot of those events because you\'re good at memorizing boatloads of useless information."},{"type":"paragraph","content":"\\"How do you want to split up the topics?\\", Krishna asks."}]},"christmas_party.follow_aubrey":{"id":"christmas_party.follow_aubrey","options":[{"id":"@christmas_party.correct_aubrey","title":"Correct her naming."},{"id":"@christmas_party.yes_you_did","title":"\\"Yes, you did.\\""},{"id":"@christmas_party.shrug","title":"Just shrug."}],"content":{"content":[{"type":"paragraph","content":"You wave apologetically to Emily before exiting the room and following Aubrey downstairs. The sounds of singing grow louder. Aubrey is not joining them, but hanging back in the periphery. She notices you, and waves."},{"type":"paragraph","content":["\\"Hey, ",{"type":"insert","insert":0},",\\" she begins. \\"Did I make a fool of myself with ---?\\""]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"emily_6.dont_look":{"id":"emily_6.dont_look","goTo":[{"id":"emily_6.emily_speak_1"}],"content":{"content":"You don\'t look at her, but she starts to speak.","type":"paragraph"}},"miri_date.dont_kiss_2":{"id":"miri_date.dont_kiss_2","options":[{"id":"@miri_date.hug","title":"Go for the hug."},{"id":"@miri_date.no_hug","title":"Actually you just don\'t want any form of physical contact."}],"content":[{"type":"paragraph","content":"\\"Um, sorry...\\""},{"type":"paragraph","content":"\\"No, it\'s fine! I know you\'re nervous about physical contact so... maybe next time? Is a hug fine?\\""}]},"miri_pageant_prep.tell_her":{"id":"miri_pageant_prep.tell_her","options":[{"id":"@miri_pageant_prep.it_happens","title":"You can tell where this is going."}],"content":[{"type":"paragraph","content":"Tell her... what? Exactly? What does \'what\'s wrong with you\' even mean?"},{"type":"paragraph","content":"\\"Um... I don\'t know,\\" is what you say after a long pause."},{"type":"paragraph","content":"\\"Come on. It\'s fine.\\""}]},"pageant_final.interview_questions":{"id":"pageant_final.interview_questions","options":[{"id":"@pageant_final.interview_college","title":"To do better in the college application process."},{"id":"@pageant_final.interview_scholarship","title":"To win a scholarship."},{"id":"@pageant_final.interview_obligation","title":"To fulfill your obligations to your parents."},{"id":"@pageant_final.interview_comfort_zone","title":"To expand your horizons."},{"id":"@pageant_final.interview_total_fail","title":"Fuck."}],"content":{"content":[{"type":"paragraph","content":["\\"Hello, ",{"type":"insert","insert":0},". How are you doing today?\\", opens one of the interviewers."]},{"type":"paragraph","content":[{"type":"conditional","content":"\\"I\'m doing well, thank you,\\" you answer with the appropriate smile and eye contact. ","predicate":1},""]},{"type":"paragraph","content":[{"type":"conditional","content":"\\"Um, I\'m doing well,\\" you answer, with perhaps a bit too much hesitation. ","predicate":2},""]},{"type":"paragraph","content":["Now the real questions begin. \\"Tell me, ",{"type":"insert","insert":3},", what made you decide to enter the pageant?\\""]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_interview\'] || 0) >= 5);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_interview\'] || 0) <= 4);"}},{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"scioly_invitational.medal_ceremony_cell_none":{"id":"scioly_invitational.medal_ceremony_cell_none","viewIf":{"$code":"return ((Q[\'cell\'] || 0)===0);"},"goTo":[{"id":"scioly_invitational.medal_end"}],"content":{"content":"You glance over at Krishna, who looks vaguely disappointed. He shrugs.","type":"paragraph"}},"skip.w9_miri_2":{"id":"skip.w9_miri_2","onArrival":[{"$code":"Q[\'miri\'] = 6;\\nQ[\'gym\'] = 2;\\nQ[\'miri_practice\'] = 2;\\nQ[\'miri_hang\'] = 2;\\nQ[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 2;\\nQ[\'pageant_interview\'] = (Q[\'pageant_interview\'] || 0) + 2;"}],"goTo":[{"id":"skip.w9_parents_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.aubrey_reminisce":{"id":"scioly_study_party.aubrey_reminisce","options":[{"id":"@scioly_study_party.aubrey_reminisce_2","title":"\\"But...\\""}],"content":{"content":[{"type":"paragraph","content":"It is only now that you remember the fact that Aubrey Gao knows enough about you to destroy you."},{"type":"paragraph","content":["\\"Do you remember middle school, ",{"type":"insert","insert":0},"?\\""]},{"type":"paragraph","content":"\\"No, nothing. It\'s, like, I don\'t remember it.\\""},{"type":"paragraph","content":"\\"That\'s too bad. I think you were kind of funny back then. Remember when you made up that space station where-\\""},{"type":"paragraph","content":"\\"No. I don\'t remember.\\""},{"type":"paragraph","content":"\\"And like you were the-\\""},{"type":"paragraph","content":"\\"Stop it. I don\'t remember.\\""},{"type":"paragraph","content":"\\"Oh. Haha. You don\'t have to be embarrassed by it!\\""}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"thanksgiving_party.for_no_reason":{"id":"thanksgiving_party.for_no_reason","options":[{"id":"@thanksgiving_party.tell_secret","title":"\\"Sure...\\""}],"content":[{"type":"paragraph","content":"\\"Because, um...\\", you start, but you don\'t know what to say. You glance around the room. Suddenly it feels warmer. You feel the clothes clinging to your skin. You notice the palpable human/laundry odor probably from --- but maybe from you (you can\'t tell). You realize that your stomach is gurgling from all the food you ate. And most of all you feel ---\'s gaze upon you, like some sort of death ray. You close your eyes as you can\'t bear to look."},{"type":"paragraph","content":"\\"Sorry,\\" you manage to say. You open your eyes again. Did he notice?"},{"type":"paragraph","content":"--- sighs. \\"It\'s fine. Can I tell you something, like a deep and dark secret?\\""}]},"scioly_2.cell_bio_split":{"id":"scioly_2.cell_bio_split","options":[{"id":"@scioly_2.cell_bio_questions","title":"You look at the cell bio study guide."}],"content":[{"type":"paragraph","content":"\\"Um, it doesn\'t matter? We could both study, like, everything, as much as possible.\\""},{"type":"paragraph","content":"\\"But shouldn\'t we at least try to avoid too much duplication?\\""},{"type":"paragraph","content":"\\"Sure, I guess. What do you want to do?\\""},{"type":"paragraph","content":"Krishna glances at you, shaking his head. \\"How did I know this would happen? Okay. I\'ll do this.\\" He circles some items on the event rules sheet, and hands it to you. \\"You do these. I\'ll do the rest.\\""},{"type":"paragraph","content":"\\"Um... thanks.\\""},{"type":"paragraph","content":"\\"It\'s fine.\\""}]},"christmas_party.correct_aubrey":{"id":"christmas_party.correct_aubrey","viewIf":{"$code":"return ((Q[\'come_out_christmas_party\'] || 0)===1);"},"goTo":[{"id":"christmas_party.aubrey_sits_down"}],"content":[{"type":"paragraph","content":"\\"Her name is Emily,\\" you say. Immediately you somewhat regret making that comment; would Emily actually want you to bring more attention to that?"},{"type":"paragraph","content":"\\"What? Oh. That.\\" Aubrey sighs."}]},"emily_6.emily_speak_1":{"id":"emily_6.emily_speak_1","options":[{"id":"@emily_6.disagree","title":"\\"You\'re wrong...\\""},{"id":"@emily_6.doesnt_matter","title":"\\"It doesn\'t matter...\\""}],"content":[{"type":"paragraph","content":"\\"Okay, so just making sure, you\'re... asking me out, right?\\""},{"type":"paragraph","content":"You... nod, or try to make some gesture with your head to that effect."},{"type":"paragraph","content":"\\"Okay. Um, wow. Thanks, I guess.\\""},{"type":"paragraph","content":"When she sees that you probably look dumbfounded, she sighs and starts to speak again."},{"type":"paragraph","content":"\\"Um... thanks, but, uh, sorry but I think you\'re setting your expectations too high. Your description of me was objectively incorrect. I\'m not exactly a good person, you know, right?\\""}]},"miri_date.hug":{"id":"miri_date.hug","onArrival":[{"$code":"Q[\'miri_hug\'] = 1;"}],"content":[{"type":"paragraph","content":"\\"Um, sure. A hug is good.\\""},{"type":"paragraph","content":"She approaches you and wraps her arms around your waist. You hug her back, or something like that. It\'s a few seconds before she lets go."},{"type":"paragraph","content":"\\"Well, see you next time.\\""},{"type":"paragraph","content":"\\"Yeah. Next time...\\""},{"type":"paragraph","content":"She waves as you leave. Her brother\'s car pulls up by the sidewalk. You walk home."}]},"miri_pageant_prep.dont_tell_her":{"id":"miri_pageant_prep.dont_tell_her","options":[{"id":"@miri_pageant_prep.it_happens","title":"You can tell where this is going."}],"content":[{"type":"paragraph","content":"You wouldn\'t even begin to know what to say. What does \'what\'s wrong with you\' even mean?"},{"type":"paragraph","content":"\\"No,\\" is what you say after a long breath."},{"type":"paragraph","content":"\\"Come on. It\'s fine.\\""}]},"pageant_final.interview_total_fail":{"id":"pageant_final.interview_total_fail","viewIf":{"$code":"return ((Q[\'pageant_interview\'] || 0) <= 4);"},"onArrival":[{"$code":"Q[\'pageant_total_failure\'] = 1;"}],"options":[{"id":"@pageant_final.interview_cry","title":"All you can do is cry."}],"content":[{"type":"paragraph","content":"\\"Um...\\""},{"type":"paragraph","content":"Your brain freezes. You can\'t think. Inchoate images expand to fill every part of your brain, drowning out every coherent sentence. Noise."},{"type":"paragraph","content":"You blink. Close your eyes. Open them again. Breathe. It doesn\'t work. Your heart is pounding. Your mind is exploding."},{"type":"paragraph","content":"\\"Um, I...\\""},{"type":"paragraph","content":"No. You can\'t do this."}]},"scioly_invitational.medal_end":{"id":"scioly_invitational.medal_end","content":{"content":[{"type":"paragraph","content":["Soon enough the medal ceremony is over. As a whole, your school got ",{"type":"insert","insert":0}," gold medals, ",{"type":"insert","insert":1}," silver medals, and ",{"type":"insert","insert":2}," bronze medals."]},{"type":"paragraph","content":[{"type":"conditional","content":"You won four gold medals here. In fact, all of the gold medals that your school got, you had some part in. This feels as if it should be some kind of great achievement. ","predicate":3},""]},{"type":"paragraph","content":"The captain congratulates you on a job well done. The crowd disperses. It\'s time for you to go home."}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'gold_count\'] || 0);"}},{"type":"insert","fn":{"$code":"return (Q[\'silver_count\'] || 0);"}},{"type":"insert","fn":{"$code":"return ((Q[\'bronze_count\'] || 0) + 1);"}},{"type":"predicate","fn":{"$code":"return (((((Q[\'disease\'] || 0)===2) && ((Q[\'protein\'] || 0)===2)) && ((Q[\'fossils\'] || 0)===2)) && ((Q[\'cell\'] || 0)===2));"}}]}},"scioly_invitational":{"id":"scioly_invitational","type":"scene","title":"Science Olympiad","subtitle":"The first competition of the year...","newPage":true,"viewIf":{"$code":"return (((Q[\'scioly\'] || 0) >= 2) && ((Q[\'week\'] || 0)===8));"},"onArrival":[{"$code":"Q[\'invitational\'] = 1;\\nQ[\'medal_count\'] = 0;\\nQ[\'gold_count\'] = 0;\\nQ[\'silver_count\'] = 0;\\nQ[\'bronze_count\'] = 0;"}],"tags":["weekend"],"options":[{"id":"@scioly_invitational.not_ready","title":"No. Not at all."}],"content":{"content":[{"type":"paragraph","content":["The first Science Olympiad tournament of the year is an invitational contest at MIT. You have a full schedule with four events, from the morning to the afternoon, with just a short 30-minute break for lunch. You\'ve prepared ",{"type":"conditional","content":"as best as you could, given the circumstances ","predicate":0},{"type":"conditional","content":"... not as well as you could have, probably ","predicate":1},"."]},{"type":"paragraph","content":"At 8:30AM the team is already assembled in your assigned room. It\'s several hours earlier than you usually get up on weekends, so you\'re not exactly awake, as you essentially sleepwalked onto the bus and onto your destination. At least you didn\'t get lost in the tangle of classrooms. Nearly everyone else is here already. Some of the other students have cups of coffee, like the captain for example."},{"type":"paragraph","content":"The captain speaks to you as soon as he notices you."},{"type":"paragraph","content":["\\"",{"type":"insert","insert":2},"!\\" he exclaims with what must be false enthusiasm. \\"Ready to dominate?\\""]}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return (((Q[\'scioly\'] || 0) > 4) && ((Q[\'study_party\'] || 0)===1));"}},{"type":"predicate","fn":{"$code":"return (((Q[\'scioly\'] || 0) <= 4) || ((Q[\'study_party\'] || 0)===0));"}},{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"skip.w9_miri_3":{"id":"skip.w9_miri_3","onArrival":[{"$code":"Q[\'miri\'] = 1;"}],"goTo":[{"id":"skip.w9_parents_status"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.aubrey_reminisce_2":{"id":"scioly_study_party.aubrey_reminisce_2","options":[{"id":"@scioly_study_party.more_lonely","title":"Somehow you feel even more lonely after the party..."},{"id":"@scioly_study_party.less_lonely","title":"But you can make the positive feelings from Aubrey last..."}],"content":[{"type":"paragraph","content":"\\"But I am. I can\'t help being like this or whatever. It\'s just...\\""},{"type":"paragraph","content":"What were you even going to say? Did you even have anything to say?"},{"type":"paragraph","content":"\\"Look, it\'s okay,\\" Aubrey says as she pats your hair. \\"Don\'t listen to people like Krishna, okay?\\" She holds you closer now, wrapping her arm around you and pulling your head on her shoulder. Oh God this must be the closest you\'ve ever been."},{"type":"paragraph","content":"Surprisingly enough, you don\'t end up crying. Or talking. Even as she attempts to calm you, your mind spins through the potential implications of this moment. Is Aubrey okay with your presence here? Why is she attempting to comfort you? Pity? Does she secretly despise you? Does she have any awareness of the fact that you\'ve had a crush on her for years and possibly still do? Would she despise you more if she found out?"},{"type":"paragraph","content":"But these worries dissipate eventually, so all that\'s left in your mind is a warm glow. Probably because of the endorphins released into your brain due to prolonged physical contact which doesn\'t feel bad at all..."},{"type":"paragraph","content":"...Wait, is that how endorphins even work, you think as Aubrey releases you. Soon enough the party ends. No one pays you much attention, except some people who mouth \\"sorry\\" or something like that at Aubrey and/or you. It\'s time to go back home again."}]},"thanksgiving_party.dont_tell":{"id":"thanksgiving_party.dont_tell","options":[{"id":"@thanksgiving_party.tell_secret","title":"\\"Sure...\\""}],"content":[{"type":"paragraph","content":"\\"Um, not much, really. Just... school and stuff. I guess.\\""},{"type":"paragraph","content":"\\"Really?\\" --- looks at you curiously."},{"type":"paragraph","content":"What are you supposed to say in a situation like this? Is this a battlefield within the Chen household in which you have become an unwitting player? You should be on ---\'s side, right? Right? What if you\'ve done something wrong? Did he overhear the conversation as well, and is just testing you? Is that something that normal people do? And did you just fail that test?"},{"type":"paragraph","content":"\\"Um...\\" You take far too long blinking, and completely forget your train of thought."},{"type":"paragraph","content":"--- sighs. \\"It\'s fine. Can I tell you something, like a deep and dark secret?\\""}]},"scioly_2.cell_bio_questions":{"id":"scioly_2.cell_bio_questions","content":{"content":"You had thought that you knew a lot about cell biology already, but you do not know enough. The topics can get very detailed, well beyond what was covered in AP Bio.","type":"paragraph"}},"christmas_party.yes_you_did":{"id":"christmas_party.yes_you_did","goTo":[{"id":"christmas_party.aubrey_sits_down"}],"content":[{"type":"paragraph","content":"\\"Yeah... you kind of did...\\""},{"type":"paragraph","content":"\\"Well, sorry about that.\\" Aubrey sighs."}]},"emily_6.disagree":{"id":"emily_6.disagree","goTo":[{"id":"emily_6.noise"}],"content":{"content":"\\"Um, that\'s wrong... you\'re, uh, better than you think...\\"","type":"paragraph"}},"miri_date.no_hug":{"id":"miri_date.no_hug","onArrival":[{"$code":"Q[\'miri_hug\'] = 0;"}],"content":[{"type":"paragraph","content":"\\"Um, sorry...\\""},{"type":"paragraph","content":"\\"It\'s okay! Maybe next time.\\""},{"type":"paragraph","content":"\\"Yeah. Next time...\\""},{"type":"paragraph","content":"She looks slightly sad as you leave. Her brother\'s car pulls up by the sidewalk. You walk home."}]},"miri_pageant_prep.it_happens":{"id":"miri_pageant_prep.it_happens","options":[{"id":"@miri_pageant_prep.upset","title":"For some reason, you\'re feeling kind of upset."}],"content":[{"type":"paragraph","content":"You\'ve seen this happen before and you\'ve tried to avert it. Miri thinks that talking about stuff will make it better. You know that it just makes everything worse. Besides, how do you even describe the \\"stuff\\" that\'s going on right now? Can you even put it into words?"},{"type":"paragraph","content":"\\"Sorry,\\" you say. \\"Why do you always ask what\'s wrong with me? Why don\'t you talk about your own problems?\\""},{"type":"paragraph","content":"\\"Come on!\\", Miri says. \\"Now\'s not the time for this.\\""}]},"pageant_final.interview_cry":{"id":"pageant_final.interview_cry","options":[{"id":"@pageant_final.over","title":"It\'s over."}],"content":[{"type":"paragraph","content":"You feel your eyes become wet. Fuck. You\'ve failed. You\'ve failed for real. You\'ve failed your parents. You\'ve failed the judges. You\'ve failed yourself. You\'ve failed everyone who ever relied upon you, everyone who ever believed that you could ever do anything good with yourself."},{"type":"paragraph","content":"You can\'t do this. You can\'t do this. You can\'t do this. Why did you think that you could ever do a pageant? Why did you think that you could ever stand up in front of a bunch of strangers while wearing a skimpy and scratchy dress, while smiling and making poses and speaking as if you\'re not just a person, but an exemplar of a particular ideal of womanhood that you never subscribed to in the first place?"},{"type":"paragraph","content":"Why did you think you could do this?"},{"type":"paragraph","content":"\\"Would you like to go back?\\", one of the judges says in a moment of kindness. You nod."}]},"skip.w9_parents_status":{"id":"skip.w9_parents_status","options":[{"id":"@skip.w9_parents_1","title":"You\'ve interacted a lot with your parents."},{"id":"@skip.w9_parents_2","title":"You haven\'t interacted so much with them."},{"id":"@skip.w9_parents_3","title":"You\'ve been avoiding them."}],"content":{"content":"Relationship with parents:","type":"paragraph"}},"scioly_study_party.more_lonely":{"id":"scioly_study_party.more_lonely","content":{"content":"","type":"paragraph"}},"thanksgiving_party.tell_secret":{"id":"thanksgiving_party.tell_secret","options":[{"id":"@thanksgiving_party.secret_2","title":"\\"Um...\\""}],"content":[{"type":"paragraph","content":"\\"Sure...\\" is all you manage to say."},{"type":"paragraph","content":"\\"Okay. Like. So, my parents think I\'m gay, right? But like, that\'s not exactly wrong.\\" --- sighs. \\"Look. Okay. This is going to sound dumb as fuck but, like, I\'m actually a girl. I\'m trans.\\""},{"type":"paragraph","content":"He-no, she, buries her face in her hands, and coughs. \\"Look, I\'ll show you,\\" she says, her voice changing somehow. She coughs again, and enters the closet."}]},"scioly_2.krishna2":{"id":"scioly_2.krishna2","viewIf":{"$code":"return ((Q[\'krishna_scioly\'] || 0) > 0);"},"onArrival":[{"$code":"Q[\'krishna_scioly\'] = (Q[\'krishna_scioly\'] || 0) + 1;\\nQ[\'cell\'] = (Q[\'cell\'] || 0) + 1;"}],"options":[{"id":"@scioly_2.glycolysis","title":"Glycolysis"},{"id":"@scioly_2.krebs","title":"Krebs cycle"},{"id":"@scioly_2.etp","title":"Electron transport chain"}],"content":{"content":"\\"Here\'s a question,\\" Krishna says as soon as he sees you. \\"In aerobic respiration, the greatest ATP production occurs in which stage of the process?\\"","type":"paragraph"}},"christmas_party.shrug":{"id":"christmas_party.shrug","goTo":[{"id":"christmas_party.aubrey_sits_down"}],"content":{"content":"You just make some sort of awkward shrug. Aubrey sighs.","type":"paragraph"}},"emily_6.doesnt_matter":{"id":"emily_6.doesnt_matter","goTo":[{"id":"emily_6.noise"}],"content":[{"type":"paragraph","content":"\\"It doesn\'t matter... I mean, it doesn\'t matter what kind of person you are because - wait, it does matter but, um, ...\\""},{"type":"paragraph","content":"Congratulations. You\'ve failed once more at not being awkward, and at a moment like this."}]},"miri_date.no_kiss":{"id":"miri_date.no_kiss","viewIf":{"$code":"return ((Q[\'miri_touch\'] || 0)===0);"},"options":[{"id":"@miri_date.yeah_fun","title":"\\"Yeah...\\""},{"id":"@miri_date.no_fun","title":"Not really but you can\'t say that."}],"content":{"content":"\\"So, was this fun?\\", Miri asks.","type":"paragraph"}},"miri_pageant_prep.upset":{"id":"miri_pageant_prep.upset","options":[{"id":"@miri_pageant_prep.regret","title":"You regret your words instantly."}],"content":[{"type":"paragraph","content":"\\"Have you considered the possibility that nothings wrong and I\'m just like this?\\""},{"type":"paragraph","content":"\\"That\'s it then, huh? Sorry I ever bothered.\\""},{"type":"paragraph","content":"She turns away."}]},"pageant_final.interview_college":{"id":"pageant_final.interview_college","viewIf":{"$code":"return ((Q[\'pageant_interview\'] || 0) >= 2);"},"onArrival":[{"$code":"Q[\'interview_score\'] = (Q[\'interview_score\'] || 0) + ((Q[\'pageant_interview\'] || 0) - 4);"}],"options":[{"id":"@pageant_final.interview_2","title":"The questions continue."}],"content":{"content":[{"type":"paragraph","content":[{"type":"conditional","content":"\\"One reason is that I would like to show the college admissions committee that I am capable of success at something beyond academics.\\" ","predicate":0},""]},{"type":"paragraph","content":[{"type":"conditional","content":"\\"Um, I would like to show my college admissions committee that, um, I\'m not just the kind of person who\'s only good at academics.\\" ","predicate":1},""]},{"type":"paragraph","content":"\\"But you\'re here, and we\'re not your college admissions committee,\\" the interviewer replies. You realize that you gave the wrong answer, but it is too late."}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_interview\'] || 0) >= 6);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_interview\'] || 0) <= 5);"}}]}},"skip.w9_parents_1":{"id":"skip.w9_parents_1","onArrival":[{"$code":"Q[\'family\'] = 6;\\nQ[\'dad_viewed\'] = 1;\\nQ[\'argument_viewed\'] = 1;\\nQ[\'stories_viewed\'] = 2;\\nQ[\'bravery_viewed\'] = 1;\\nQ[\'argument_viewed\'] = 1;"}],"goTo":[{"id":"skip.end_skip"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.less_lonely":{"id":"scioly_study_party.less_lonely","content":{"content":"","type":"paragraph"}},"thanksgiving_party.secret_2":{"id":"thanksgiving_party.secret_2","options":[{"id":"@thanksgiving_party.its_okay","title":"\\"Um...\\""}],"content":[{"type":"paragraph","content":"\\"Wait, um, you don\'t have to...\\""},{"type":"paragraph","content":"\\"But I want to.\\" Her voice is muffled by the closet door. \\"God, I\'ve spent so much fucking time on this shit I have to... God, I\'m so ridiculous right now...\\""},{"type":"paragraph","content":"There\'s shuffling from the closet. From downstairs come the sounds of obedient children playing the piano, and the ever-present chatter of adults speaking in Chinese."},{"type":"paragraph","content":"\\"Oh yeah, by the way, my name\'s Emily. Other trans girls all pick fucking unique names but I just pick a fucking generic name like Emily.\\""}]},"scioly_2.glycolysis":{"id":"scioly_2.glycolysis","viewIf":{"$code":"return ((Q[\'cell\'] || 0) <= 2);"},"goTo":[{"id":"scioly_2.is_this_a_joke"}],"content":{"content":"\\"Um, glycolysis?\\"","type":"paragraph"}},"christmas_party.aubrey_sits_down":{"id":"christmas_party.aubrey_sits_down","options":[{"id":"@christmas_party.confess_to_aubrey","title":"Confess to Aubrey."},{"id":"@christmas_party.silent_with_aubrey","title":"Continue in silence."}],"content":[{"type":"paragraph","content":"She sits down on the couch, and glances at you. You sit down next to her."},{"type":"paragraph","content":"\\"So, I\'m really an idiot, huh?\\", she says, her expression in between a smile and a grimace."},{"type":"paragraph","content":"\\"Um... no... you\'re not?\\""},{"type":"paragraph","content":"She shrugs. \\"Too bad. I\'m a tactless idiot who can\'t socialize my way out of a paper bag. Do you know how I broke up with Edwin?\\""},{"type":"paragraph","content":"You shake your head."},{"type":"paragraph","content":"\\"He said that I didn\'t care about anyone except myself, much less him. He said that I was willfully blind to other people\'s struggles. In those exact words.\\""},{"type":"paragraph","content":"Aubrey shrugs. \\"And here we are.\\""}]},"emily_6.noise":{"id":"emily_6.noise","options":[{"id":"@emily_6.turn_away","title":"Turn away."},{"id":"@emily_6.return_stare","title":"Return her stare."}],"content":[{"type":"paragraph","content":"Emily makes a weird noise that sounds vaguely like a chortle. She glances at you for approximately three-fourths of a second, and then glances at a squirrel in a tree in the distance. You stare intently at that same squirrel. Then you hear a deep inward breath."},{"type":"paragraph","content":"\\"I think you\'re amazing too, but... can we hold off until... at the very least after graduating from high school?\\" Her voice is barely above a whisper. \\"I mean,...\\""},{"type":"paragraph","content":"You sneak a glance at Emily. She\'s looking intently at you."}]},"miri_date.yeah_fun":{"id":"miri_date.yeah_fun","options":[{"id":"@miri_date.hug","title":"Go for the hug."},{"id":"@miri_date.no_hug","title":"Actually you just don\'t want any form of physical contact."}],"content":[{"type":"paragraph","content":"\\"Yeah...\\""},{"type":"paragraph","content":"\\"Well, it could have gone better,\\" she says, sensing some hesitation. \\"If you want to do this again, we can think of something better to do.\\" A pause, as you put on your shoes. \\"So, is a hug okay?\\""}]},"miri_pageant_prep.regret":{"id":"miri_pageant_prep.regret","options":[{"id":"@miri_pageant_prep.cry_for_no_reason","title":"Cry for no reason."}],"content":[{"type":"paragraph","content":"You regret your words instantly. You lied. Of course something\'s wrong with you; it\'s the fact that you fuck up every time words come out of your mouth. You fucked up. Why would Miri ever talk to you again? Why would she not regret making your acquaintance? You should disappear forever, retreat from social life, never talk to anyone ever again."},{"type":"paragraph","content":"\\"Are you crying?\\", Miri asks in a neutral tone, but it\'s a rhetorical question."}]},"pageant_final.interview_scholarship":{"id":"pageant_final.interview_scholarship","viewIf":{"$code":"return ((Q[\'pageant_interview\'] || 0) >= 2);"},"onArrival":[{"$code":"Q[\'interview_score\'] = (Q[\'interview_score\'] || 0) + ((Q[\'pageant_interview\'] || 0) - 4);"}],"options":[{"id":"@pageant_final.interview_2","title":"The questions continue."}],"content":{"content":[{"type":"paragraph","content":[{"type":"conditional","content":"\\"I need a way to pay for college, and well, the pageant has a great record of providing scholarships to young women.\\" ","predicate":0},""]},{"type":"paragraph","content":[{"type":"conditional","content":"\\"I need to pay for college somehow... and the pageant provides great scholarships.\\" ","predicate":1},""]},{"type":"paragraph","content":"\\"Yes, I see,\\" the interviewer answers, giving you a noncommittal look."}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_interview\'] || 0) >= 6);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_interview\'] || 0) <= 5);"}}]}},"skip.w9_parents_2":{"id":"skip.w9_parents_2","onArrival":[{"$code":"Q[\'family\'] = 3;\\nQ[\'stories_viewed\'] = 2;"}],"goTo":[{"id":"skip.end_skip"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.keep_playing":{"id":"scioly_study_party.keep_playing","options":[{"id":"@scioly_study_party.follow_aubrey","title":"Okay..."},{"id":"@scioly_study_party.dont_follow_aubrey","title":"No..."}],"content":[{"type":"paragraph","content":"\\"No, um, I\'m fine...\\" You try to approximate a smile."},{"type":"paragraph","content":"\\"Are you sure...? We can go somewhere else if you\'d like.\\""}]},"thanksgiving_party.its_okay":{"id":"thanksgiving_party.its_okay","options":[{"id":"@thanksgiving_party.look_nice","title":"\\"Um,..., you look nice?\\""}],"content":[{"type":"paragraph","content":"\\"It\'s, uh, okay...\\" Truth be told you have no idea how to respond."},{"type":"paragraph","content":"\\"No, it\'s not,\\" she says. \\"Anyway I\'m almost done. Here. How do I look.\\""},{"type":"paragraph","content":"She emerges from the closet looking way more like a girl than you ever have. She wears a black sweater with a skirt. And breasts or something like that. She looks... pretty? cute? beautiful? brave? better than you?"},{"type":"paragraph","content":"\\"Sorry I couldn\'t put on makeup. I fucking hate my facial structure but...\\""}]},"scioly_2.krebs":{"id":"scioly_2.krebs","viewIf":{"$code":"return ((Q[\'cell\'] || 0) <= 2);"},"goTo":[{"id":"scioly_2.is_this_a_joke"}],"content":{"content":"\\"Um, Krebs cycle?\\"","type":"paragraph"}},"christmas_party.confess_to_aubrey":{"id":"christmas_party.confess_to_aubrey","viewIf":{"$code":"return (((Q[\'emily_date\'] || 0)===0) && ((Q[\'miri_date\'] || 0) < 2));"},"options":[{"id":"@christmas_party.confess_to_aubrey_2","title":"You\'re sure."},{"id":"@christmas_party.silent_with_aubrey","title":"No. You\'re not."}],"content":[{"type":"paragraph","content":"This is a now-or-never moment. There is no better time to do something like this. There is also no worse time to do something like this, which is why you have to do it at this moment."},{"type":"paragraph","content":"Are you sure you want to do this?"}]},"emily_6.return_stare":{"id":"emily_6.return_stare","goTo":[{"id":"emily_6.turn_away"}],"content":{"content":"This somehow feels both more and less awkward than before.","type":"paragraph"}},"miri_date.no_fun":{"id":"miri_date.no_fun","options":[{"id":"@miri_date.hug","title":"Go for the hug."},{"id":"@miri_date.no_hug","title":"Actually you just don\'t want any form of physical contact."}],"content":[{"type":"paragraph","content":"You can\'t just say that you didn\'t have fun. So what can you say? You think..."},{"type":"paragraph","content":"\\"Well, it could have gone better,\\" she says, as if interpreting your silence as an answer. \\"If you want to do this again, we can think of something better to do.\\" A pause, as you put on your shoes. \\"So, is a hug okay?\\""}]},"miri_pageant_prep.cry_for_no_reason":{"id":"miri_pageant_prep.cry_for_no_reason","options":[{"id":"@miri_pageant_prep.why_bother","title":"Why does Miri even bother with you?"}],"content":[{"type":"paragraph","content":"\\"No... it\'s just that... um...\\" You are crying as you try to hide your face. Crying for no reason, your evolved aptitude for emotional manipulation kicks into high gear for no purpose at all."},{"type":"paragraph","content":"God, why are you like this? Why do your words fail you at the most inopportune times? Why are you such an inherently horrible person who doesn\'t deserve even a modicum of companionship?"}]},"pageant_final.interview_obligation":{"id":"pageant_final.interview_obligation","viewIf":{"$code":"return ((Q[\'pageant_interview\'] || 0) >= 2);"},"onArrival":[{"$code":"Q[\'interview_score\'] = (Q[\'interview_score\'] || 0) + ((Q[\'pageant_interview\'] || 0) - 3);"}],"options":[{"id":"@pageant_final.interview_2","title":"The questions continue."}],"content":{"content":[{"type":"paragraph","content":[{"type":"conditional","content":"\\"My parents were the ones who discovered the pageant and told me about it,\\" you answer, which is when you realize that it is the wrong answer. ","predicate":0},""]},{"type":"paragraph","content":[{"type":"conditional","content":"\\"My parents signed me up originally,\\" you answer, which is when you realize that it is the wrong answer. ","predicate":1},""]},{"type":"paragraph","content":"\\"But what about you? Why do you want to do the pageant?\\""},{"type":"paragraph","content":[{"type":"conditional","content":"\\"My parents may have signed me up originally, but I followed through because I wanted to prove myself, that I\'m able to succeed at whatever life throws at me.\\" Is this a nice save? The interviewer gives a noncommittal look. ","predicate":2},""]},{"type":"paragraph","content":{"type":"conditional","content":"\\"Um... I didn\'t want to challenge my parents.\\" The interviewer frowns.","predicate":3}}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_interview\'] || 0) >= 5);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_interview\'] || 0) <= 4);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_interview\'] || 0) >= 5);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_interview\'] || 0) <= 4);"}}]}},"skip.w9_parents_3":{"id":"skip.w9_parents_3","onArrival":[{"$code":"Q[\'family\'] = 0;"}],"goTo":[{"id":"skip.end_skip"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.dont_follow_aubrey":{"id":"scioly_study_party.dont_follow_aubrey","options":[{"id":"@scioly_study_party.eye_contact_david","title":"David Nguyen is staring at you again."},{"id":"@scioly_study_party.fuck_up","title":"Forget about it."}],"content":[{"type":"paragraph","content":"\\"No, um, it\'s fine.\\""},{"type":"paragraph","content":"\\"Okayyyy...\\" Aubrey seems unconvinced, but she sits down."}]},"thanksgiving_party.look_nice":{"id":"thanksgiving_party.look_nice","options":[{"id":"@thanksgiving_party.ask_self","title":"Ask her about herself."},{"id":"@thanksgiving_party.party_say_nothing","title":"Say nothing."}],"content":[{"type":"paragraph","content":"\\"Like, but, would I pass? I mean, would people see me as a girl if I just walked outside?\\""},{"type":"paragraph","content":"\\"I..., um, probably? But, like, walking outside right now... might be bad?\\""},{"type":"paragraph","content":"She smiles, laughing softly as she covers her mouth. It\'s the first time she\'s seemed happy since you saw her. \\"Thanks. I try, like, a lot.\\""},{"type":"paragraph","content":"There\'s an awkward pause, as she stands there, not exactly looking at you. Maybe this is where you should say something."}]},"scioly_2.is_this_a_joke":{"id":"scioly_2.is_this_a_joke","options":[{"id":"@scioly_2.mitochondria","title":"Mitochondria and chloroplasts."}],"content":[{"type":"paragraph","content":"\\"Are you serious? Weren\'t you in AP Bio?\\""},{"type":"paragraph","content":"\\"Um. Haha. I was just kidding.\\""},{"type":"paragraph","content":"Krishna sighs. \\"Just study more next time. Okay, next question. What are two organelles that originated from endosymbiosis?\\""},{"type":"paragraph","content":"This question is easy."}]},"christmas_party.confess_to_aubrey_2":{"id":"christmas_party.confess_to_aubrey_2","options":[{"id":"@christmas_party.confess_to_aubrey_3","title":"You\'re sure that you wish to confess your affections for Aubrey Gao, the human in front of you right now."},{"id":"@christmas_party.silent_with_aubrey","title":"No. You\'re not."}],"content":{"content":"You\'re sure... right? Right??? You take deep breaths and hope nobody notices your heart rate.","type":"paragraph"}},"emily_6.turn_away":{"id":"emily_6.turn_away","options":[{"id":"@emily_6.hug","title":"Hug?"}],"content":[{"type":"paragraph","content":"\\"What I mean is,\\" Emily continues, while continuing to stare in your general vicinity, \\"It\'s that I want to be independent first, like, from my parents. And I want to be able to be more... openly... you know. And able to do more physical transitioning than now. Is that coherent?\\""},{"type":"paragraph","content":"\\"Yeah. I mean, I\'m good at waiting.\\""},{"type":"paragraph","content":"Emily takes off her glasses and rubs her eyes. \\"God, I need to stop smearing my eyeliner. Anyway, so my answer is yes. In one and a half years, if we\'re still alive, and the world still exists, I\'ll be your, um, official girlfriend. If that\'s what you still want at that time. I\'m not going to date anyone else until at least then. Probably forever. Think of this as a contract if you would like.\\""},{"type":"paragraph","content":"You smile, or make some facial gestures towards that effect. Emily reciprocates, or something like that."}]},"miri_date.tv":{"id":"miri_date.tv","options":[{"id":"@miri_date.kiss","title":"It\'s time to leave..."},{"id":"@miri_date.no_kiss","title":"It\'s time to leave..."}],"content":[{"type":"paragraph","content":"\\"Maybe we could watch something?\\""},{"type":"paragraph","content":"\\"Sure, great! What should we watch? Wait, I know!\\""},{"type":"paragraph","content":"You have approximately an hour before her brother gets home. Miri puts on some recent anime series. In all honesty it\'s kind of forgettable, and you let her know."},{"type":"paragraph","content":"\\"So this series sucks, right?\\", she says. \\"We should have watched something better.\\""},{"type":"paragraph","content":"\\"Yeah, but it was nice just... being here. With you.\\""},{"type":"paragraph","content":"\\"Oh shush.\\" She punches you in the arm, probably affectionately."}]},"miri_pageant_prep.why_bother":{"id":"miri_pageant_prep.why_bother","options":[{"id":"@miri_pageant_prep.sorry_2","title":"Sorry...?"}],"content":{"content":[{"type":"paragraph","content":"It\'s a good question, isn\'t it? But applies to more than just Miri; why does any human being voluntarily interact with you? You, with no discernable positive qualities whose only goal in social interaction is the emotionally manipulative offloading of your banal burdens upon the handful of people who give a fuck. And even then..."},{"type":"paragraph","content":["\\"Hey. ",{"type":"insert","insert":0},".\\" Miri\'s words take you out of your mental loop."]},{"type":"paragraph","content":"\\"Oh. Um.\\" You stare at the grass."},{"type":"paragraph","content":"\\"Hey. Sorry I got kinda upset.\\""},{"type":"paragraph","content":"\\"Oh.\\" For some reason you feel like crying even more."}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"pageant_final.interview_comfort_zone":{"id":"pageant_final.interview_comfort_zone","onArrival":[{"$code":"Q[\'interview_score\'] = (Q[\'interview_score\'] || 0) + ((Q[\'pageant_interview\'] || 0) + 1);"}],"viewIf":{"$code":"return ((Q[\'pageant_interview\'] || 0) >= 5);"},"options":[{"id":"@pageant_final.interview_comfort_zone_2","title":"\\"... which is something I would like to disprove.\\""},{"id":"@pageant_final.interview_comfort_zone_3","title":"\\"... which has a grain of truth to it, but...\\""}],"content":[{"type":"paragraph","content":"This was one of the most common example questions in the pageant preparation sites. But you still have to act as if you just thought up the answer on the spot."},{"type":"paragraph","content":"\\"So much of my life has been focused around academics. People often see me as some kind of robotic nerd...\\""}]},"skip.end_skip":{"id":"skip.end_skip","content":{"content":"Alright, skipping now...","type":"paragraph"}},"skip":{"id":"skip","type":"scene","title":"Skip to later weeks","subtitle":"Debug","viewIf":{"$code":"return (((Q[\'debug_mode\'] || 0)===1) && ((Q[\'week\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'first_name\'] = \\"Karen\\";"}],"tags":["top","debug"],"options":[{"id":"@skip.skip_5","title":"Skip to week 5 (before Thanksgiving)"},{"id":"@skip.skip_9","title":"Skip to week 9 (before Christmas)"}],"content":{"content":"","type":"paragraph"}},"scioly_study_party.fuck_up":{"id":"scioly_study_party.fuck_up","content":[{"type":"paragraph","content":"This was a once-in-a-lifetime opportunity that you just squandered."},{"type":"paragraph","content":"But despite yourself, you have fun. The game is fun. You forget what you were upset about, at least for a while. At least until you get home, when the feelings rush back. You\'re alone and lying on your bed and you replay the memories in your head countless times until eventually you fall asleep. Tomorrow, it\'s going to be fine. Right?"}]},"thanksgiving_party.ask_self":{"id":"thanksgiving_party.ask_self","options":[{"id":"@thanksgiving_party.really_boring","title":"\\"I\'m... really boring?\\""}],"content":[{"type":"paragraph","content":"\\"So, um, can you tell me about...\\" and you forget what you were going to say. If you even knew in the first place."},{"type":"paragraph","content":"Emily chuckles to herself. \\"What, like, do you want to know my whole trans experience? Sure. What is there to say? I mean, I\'m not that interesting.\\""},{"type":"paragraph","content":"She pauses for a moment and glances at you. You look away; you realize that you were staring. \\"What about you? Can you tell me about yourself?\\""}]},"scioly_2.etp":{"id":"scioly_2.etp","options":[{"id":"@scioly_2.mitochondria","title":"Mitochondria and chloroplasts."}],"content":[{"type":"paragraph","content":"\\"The electron transport chain.\\""},{"type":"paragraph","content":"\\"Yeah. This was too easy. Maybe we should try a harder question.\\""},{"type":"paragraph","content":"\\"Yeah...\\""},{"type":"paragraph","content":"\\"Okay, next question. What are two organelles that originated from endosymbiosis?\\""},{"type":"paragraph","content":"This is an easy question."}]},"christmas_party.confess_to_aubrey_3":{"id":"christmas_party.confess_to_aubrey_3","options":[{"id":"@christmas_party.confess_to_aubrey_4","title":"\\"I like you...\\""},{"id":"@christmas_party.silent_with_aubrey","title":"It\'s not too late to back down."}],"content":[{"type":"paragraph","content":"Okay. You\'re ready to do this. Well, no you\'re not, but you won\'t ever be more ready."},{"type":"paragraph","content":"\\"Um... hey?\\""},{"type":"paragraph","content":"\\"Yeah?\\""},{"type":"paragraph","content":"\\"I don\'t think you\'re a bad person.\\""},{"type":"paragraph","content":"\\"Oh. Thanks for the vote of confidence.\\""},{"type":"paragraph","content":"\\"No, really, I mean, um, I think you\'re an excellent person, and, um,..., um...\\""},{"type":"paragraph","content":"No one is around. No one is listening."}]},"emily_6.hug":{"id":"emily_6.hug","options":[{"id":"@emily_6.wipe_away","title":"Just make sure to hide it."}],"content":[{"type":"paragraph","content":"\\"Um, would physical contact be appropriate in this situation?\\""},{"type":"paragraph","content":"\\"Of course.\\""},{"type":"paragraph","content":"The two of you make some sort of awkward but affectionate physical contact. It\'s a good feeling while it lasts."},{"type":"paragraph","content":"Besides, you have a sort-of girlfriend now. You can\'t help but smile to yourself on the train ride home."}]},"miri_date.awkwardness":{"id":"miri_date.awkwardness","onArrival":[{"$code":"Q[\'miri_awkwardness\'] = 1;"}],"options":[{"id":"@miri_date.sneak_glance","title":"Stare at Miri."},{"id":"@miri_date.wait_awkwardness","title":"Wait."}],"content":[{"type":"paragraph","content":"There is an awkward silence. You feel as if you should say something right now, but your mind is blank, somewhat more so than usual. Suddenly you become aware of the humming of the refrigerator, the buzzing of cars outside, the bare branches of the tree by the window blown by the wind."},{"type":"paragraph","content":"You are aware of Miri breathing next to you."}]},"miri_pageant_prep.sorry_2":{"id":"miri_pageant_prep.sorry_2","options":[{"id":"@miri_pageant_prep.sorry_3","title":"\\"Unspecific and generic statements of support.\\""},{"id":"@miri_pageant_prep.just_go_away","title":"\\"Just... I don\'t know...\\""}],"content":[{"type":"paragraph","content":"\\"I should, um, be sorry,\\" you say, as you try and fail to hold back your tears. You\'re not sure if you\'re sad or upset or what you\'re feeling anymore. \\"Sorry, this is emotionally manipulative as fuck...\\""},{"type":"paragraph","content":"\\"It\'s normal, okay? You can trust me. Really. Not to be cliche and all but I\'m here for you.\\""},{"type":"paragraph","content":"\\"That\'s the problem, isn\'t it?\\""},{"type":"paragraph","content":"\\"What\'s the problem?\\""}]},"pageant_final.interview_comfort_zone_2":{"id":"pageant_final.interview_comfort_zone_2","options":[{"id":"@pageant_final.interview_2","title":"The questions continue."}],"content":[{"type":"paragraph","content":"\\"... which is something I would like to disprove. I would like to expand my horizons, to explore something beyond my comfort zone, and the pageant provides that opportunity.\\""},{"type":"paragraph","content":"The interviewer smiles. It seems that you gave the correct answer."}]},"scioly_study_party.aubrey":{"id":"scioly_study_party.aubrey","viewIf":{"$code":"return ((Q[\'aubrey_party_viewed\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'aubrey_party_viewed\'] = 1;"}],"options":[{"id":"@scioly_study_party.conversation","title":"Look for another group."}],"content":[{"type":"paragraph","content":"Aubrey is in a circle with most of the other girls in the team and some of the boys. You stand near them, hovering around Aubrey in the hopes that she would acknowledge you without you having to bear the burden of initiating contact."},{"type":"paragraph","content":"Are they playing Apples to Apples again? Yes. Aubrey doesn\'t look at you, or doesn\'t notice you. It\'s getting awkward standing by yourself."}]},"thanksgiving_party.really_boring":{"id":"thanksgiving_party.really_boring","options":[{"id":"@thanksgiving_party.hear_footsteps","title":"Until you hear footsteps on the stairs."}],"content":[{"type":"paragraph","content":"\\"I\'m, uh, a really boring human.\\""},{"type":"paragraph","content":"\\"Yeah. Well.\\" She pauses. \\"Like, what do you do for fun?\\""},{"type":"paragraph","content":"\\"Nothing. Homework. Reading miscellaneous internet articles. And, uh, other stuff. And, what about you?\\""},{"type":"paragraph","content":"\\"Well, that\'s not too different from me.\\" She looks at you and smiles. You look away, but you\'re smiling too. It\'s awkward, of course, but somehow it doesn\'t feel so wrong."}]},"scioly_2.mitochondria":{"id":"scioly_2.mitochondria","options":[{"id":"@scioly_2.cell_easy","title":"What are the functions of microtubules?"},{"id":"@scioly_2.cell_hard","title":"Describe the overall reaction that happens in Photosystem I."}],"content":[{"type":"paragraph","content":"\\"Mitochondria and chloroplasts.\\""},{"type":"paragraph","content":"\\"Maybe this was too easy. Can you ask me a question now?\\""}]},"christmas_party.confess_to_aubrey_4":{"id":"christmas_party.confess_to_aubrey_4","options":[{"id":"@christmas_party.ca5","title":"Oh."},{"id":"@christmas_party.confess_to_aubrey_5","title":"Shit."}],"content":[{"type":"paragraph","content":"\\"And, um, I, um, like you...\\" is what you manage to say."},{"type":"paragraph","content":"\\"Oh.\\" She does not exactly sound surprised."},{"type":"paragraph","content":"\\"Sorry...\\", you begin."},{"type":"paragraph","content":"\\"No, don\'t be sorry! I\'ve been thinking about this for a while. Do you think I never guessed how you felt?\\""}]},"emily_6.wipe_away":{"id":"emily_6.wipe_away","content":{"content":"At home, you make a conscious effort to avoid presenting any gesture of what has transpired. It seems to work. No one says a thing.","type":"paragraph"}},"miri_date.sneak_glance":{"id":"miri_date.sneak_glance","goTo":[{"id":"miri_date.do_something_fun"}],"content":[{"type":"paragraph","content":"You slowly turn towards her. She has an unreadable expression as she meets your gaze. Not smiling. A little sad? You don\'t know."},{"type":"paragraph","content":"You turn away."}]},"miri_pageant_prep.sorry_3":{"id":"miri_pageant_prep.sorry_3","options":[{"id":"@miri_pageant_prep.pull_away","title":"Pull away."},{"id":"@miri_pageant_prep.let_her_hold","title":"Let her hold your hand."}],"content":[{"type":"paragraph","content":"\\"Okay, so, like... you make these..., like, unspecific and generic statements of support without background comprehension. You say you care about me but like... a substantial part of me distrusts that, and like, any statement of affection more generally. Or, um... fuck, I don\'t know what\'s wrong with me...\\""},{"type":"paragraph","content":"You have no idea what you\'re talking about anymore. But for some reason Miri looks as if she\'s still listening. She looks as if she\'s not going to hate you forever. Of courses you cannot be sure of that; you have no idea what she\'s thinking, and you\'re still uncertain what kind of relationship you actually have but..."},{"type":"paragraph","content":"\\"Hey, it\'s okay,\\" Miri says. \\"I\'m sorry that I haven\'t been as aware as I should have.\\" You\'re still crying. She takes your hand."}]},"pageant_final.interview_comfort_zone_3":{"id":"pageant_final.interview_comfort_zone_3","options":[{"id":"@pageant_final.interview_2","title":"The questions continue."}],"content":[{"type":"paragraph","content":"\\"...which has a grain of truth to it, to be honest.\\" You smile, hoping the judges would understand it as a mildly self-deprecating joke. They do not react. \\"Nevertheless, I would like to expand my horizons, to explore something beyond my comfort zone, and the pageant provides that opportunity.\\""},{"type":"paragraph","content":"The interviewer smiles. It seems that you gave the correct answer."}]},"scioly_study_party.captain":{"id":"scioly_study_party.captain","viewIf":{"$code":"return ((Q[\'captain_party_viewed\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'captain_party_viewed\'] = 1;"}],"options":[{"id":"@scioly_study_party.conversation","title":"Look for another group."}],"content":{"content":[{"type":"paragraph","content":"The captain is one of the few people who is actually doing something productive. You walk towards him."},{"type":"paragraph","content":["\\"Glad you could come, ",{"type":"insert","insert":0},"! We\'re working on the bridge right now, but once we\'re done we can do Disease.\\""]},{"type":"paragraph","content":"After waving at you he turns his attention back to glueing pieces of balsa wood together in the rough shape of a truss. You are left standing awkwardly."}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"thanksgiving_party.party_say_nothing":{"id":"thanksgiving_party.party_say_nothing","options":[{"id":"@thanksgiving_party.um_emily","title":"\\"Um, Emily?\\""}],"content":[{"type":"paragraph","content":"Or maybe not."},{"type":"paragraph","content":"\\"Um, why are you staring at me?\\", Emily asks."},{"type":"paragraph","content":"\\"Oh. Sorry,\\" you say, and you look away."},{"type":"paragraph","content":"Emily sits on the bed, not looking at you. You feel awkward, a bit more than usual. Maybe you should say something to break the tension."}]},"scioly_2.cell_easy":{"id":"scioly_2.cell_easy","options":[{"id":"@scioly_2.end_cell_questions","title":"The quzzing continues."}],"content":[{"type":"paragraph","content":"\\"What are the functions of microtubules?\\", you ask."},{"type":"paragraph","content":"\\"Stabilizing cell structure and shape, and cell motility, like how amoebas move. Oh yeah, they also position chromosomes during mitosis.\\""},{"type":"paragraph","content":"\\"There\'s also transportation, with kinesins that move along microtubules.\\""},{"type":"paragraph","content":"\\"Yeah. I knew that.\\""}]},"christmas_party.ca5":{"id":"christmas_party.ca5","goTo":[{"id":"christmas_party.confess_to_aubrey_5"}],"content":{"content":"","type":"paragraph"}},"emily_6.run_away":{"id":"emily_6.run_away","goTo":[{"id":"emily_6.emily_speak_1"}],"content":[{"type":"paragraph","content":"Yes. Running away is always a possibility, perhaps even a desirable one. You would escape. You could escape all of this, this whole mess of anxiety and this whole morasse of tangled emotions that consumes your free time with ruminations and useless self-pitying angst."},{"type":"paragraph","content":"But you don\'t run away. You can\'t really bring yourself to."},{"type":"paragraph","content":"Then Emily begins to speak."}]},"emily_6":{"id":"emily_6","type":"scene","title":"Emily","subtitle":"Friends...?","newPage":true,"viewIf":{"$code":"return ((((((Q[\'emily\'] || 0)===6) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'stress\'] || 0) < 15)) && ((Q[\'week\'] || 0) < 10)) && ((Q[\'thanksgiving\'] || 0)===1));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"maxVisits":1,"tags":["top","social"],"options":[{"id":"@emily_6.right","title":"Right..."},{"id":"@emily_6.or","title":"Or something else..."}],"content":{"content":"You and Emily Chen are friends now. Right?","type":"paragraph"},"countVisitsMax":1},"miri_date.wait_awkwardness":{"id":"miri_date.wait_awkwardness","goTo":[{"id":"miri_date.do_something_fun"}],"content":{"content":"It goes on and on. You listen to Miri\'s breathing.","type":"paragraph"}},"miri_pageant_prep.pull_away":{"id":"miri_pageant_prep.pull_away","viewIf":{"$code":"return ((Q[\'stress\'] || 0) >= 4);"},"options":[{"id":"@miri_pageant_prep.go_away","title":"Run away."},{"id":"@miri_pageant_prep.sit_back_down","title":"Sit back down."},{"id":"@miri_pageant_prep.fuck_you_miri","title":"\\"Fuck off.\\""}],"content":{"content":[{"type":"paragraph","content":"You pull your hand away. This feels wrong. Everything feels wrong, as if the pressure within you has built up to an unmanageable level, and it\'s looking for a vent to be released. You\'re so fucked up. You don\'t deserve this. You deserve far worse."},{"type":"paragraph","content":["\\"Hey, ",{"type":"insert","insert":0},"? What\'s up?\\""]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"pageant_final.interview_2":{"id":"pageant_final.interview_2","options":[{"id":"@pageant_final.interview_2_fail","title":"Oh shit oh fuck."},{"id":"@pageant_final.interview_2_okay","title":"You\'ve thought about this question."}],"content":{"content":"\\"Now, tell me about yourself,\\" the interviewer asks now.","type":"paragraph"}},"scioly_study_party.krishna":{"id":"scioly_study_party.krishna","viewIf":{"$code":"return ((Q[\'krishna_party_viewed\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'krishna_party_viewed\'] = 1;"}],"options":[{"id":"@scioly_study_party.intp","title":"INTP"},{"id":"@scioly_study_party.infp","title":"INFP"},{"id":"@scioly_study_party.actually","title":"Actually there is no empirical scientific basis for the MBTI."}],"content":{"content":[{"type":"paragraph","content":"Krishna, David, and a bunch of the other nerdy Asian boys are clearly not focused on work right now."},{"type":"paragraph","content":"For some reason they\'re talking about the MBTI. That stands for Myers-Briggs Type Indicator, by the way. It\'s become one of Krishna\'s obsessions lately. And now he\'s roping David into the conversation too, David who usually doesn\'t talk to anyone else."},{"type":"paragraph","content":["\\"Hey, ",{"type":"insert","insert":0},", what\'s your type?\\", Krishna asks."]},{"type":"paragraph","content":"Of course you\'ve taken the MBTI before."}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"thanksgiving_party.um_emily":{"id":"thanksgiving_party.um_emily","options":[{"id":"@thanksgiving_party.hear_footsteps","title":"And you hear footsteps on the stairs."}],"content":[{"type":"paragraph","content":"She looks at you and smiles. \\"Can you, like, keep on saying that?\\""},{"type":"paragraph","content":"\\"Saying what?\\""},{"type":"paragraph","content":"\\"My name. Actually, nevermind. It\'s, uh, sort of a big deal but also sort of not.\\""},{"type":"paragraph","content":"\\"Uh, hi, Emily.\\" As you say that, she smiles again."},{"type":"paragraph","content":"\\"Wait, stop,\\" Emily says."}]},"scioly_2.cell_hard":{"id":"scioly_2.cell_hard","options":[{"id":"@scioly_2.end_cell_questions","title":"The quzzing continues."}],"content":[{"type":"paragraph","content":"\\"Describe the overall reaction that happens in Photosystem I,\\" you ask."},{"type":"paragraph","content":"\\"Oh man. I literally remember nothing about plants.\\""},{"type":"paragraph","content":"\\"Um. Sorry.\\""},{"type":"paragraph","content":"He sighs. \\"God, just keep going.\\""}]},"christmas_party.confess_to_aubrey_5":{"id":"christmas_party.confess_to_aubrey_5","onArrival":[{"$code":"Q[\'aubrey_date\'] = 1;"}],"options":[{"id":"@christmas_party.ca6","title":"Take a deep breath."}],"content":[{"type":"paragraph","content":"Aubrey continues. \\"It\'s been going on for a long time, ever since I heard from Miri that you were, you know. I\'ve seen how you acted, like, around me. It\'s kind of obvious.\\""},{"type":"paragraph","content":"A pause. Thankfully, she does not pause for long. \\"And I\'ve wondered, what would I do if you actually confessed? Now, I\'m pretty sure I\'m straight. But like, that\'s not working out either. Ha. So like, I don\'t make any promises, but maybe we could try something out. Just for now.\\""}]},"miri_date.do_something_fun":{"id":"miri_date.do_something_fun","options":[{"id":"@miri_date.um_sure_fun","title":"\\"Sure?\\""}],"content":{"content":[{"type":"paragraph","content":["\\"Hey, ",{"type":"insert","insert":0},"?\\", Miri says suddenly."]},{"type":"paragraph","content":"\\"Yeah?\\""},{"type":"paragraph","content":"\\"Do you want to, like, do something fun?\\""}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"miri_pageant_prep.go_away":{"id":"miri_pageant_prep.go_away","goTo":[{"id":"miri_pageant_prep.sit_back_down"}],"content":{"content":"Part of you wants to run away, but you don\'t have the energy to go anywhere. Your legs begin to buckle.","type":"paragraph"}},"pageant_final.interview_2_fail":{"id":"pageant_final.interview_2_fail","options":[{"id":"@pageant_final.interview_end","title":"There are more questions."}],"content":{"content":[{"type":"paragraph","content":"\\"Um...\\""},{"type":"paragraph","content":"You despise open-ended questions with the force of a thousand suns. Now is no exception. You have read this question in the practice guides, but it still catches you off guard."},{"type":"paragraph","content":["\\"Okay, so, my name is ",{"type":"insert","insert":0}," Zhao,\\" you begin, ",{"type":"conditional","content":"pronouncing it in the proper Mandarin way ","predicate":1},{"type":"conditional","content":"pronouncing it in the (incorrect) Americanized way ","predicate":2},". Try to recover. Just say the very basic facts. \\"I was born in Changchun, in China. I\'m 17 years old. And... I\'m a junior in high school.\\""]},{"type":"paragraph","content":"The interviewer sighs."}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}},{"type":"predicate","fn":{"$code":"return (((Q[\'name_correct\'] || 0)) !== 0);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'name_correct\'] || 0)===0);"}}]}},"scioly_study_party.intp":{"id":"scioly_study_party.intp","goTo":[{"id":"scioly_study_party.david_intp"}],"content":[{"type":"paragraph","content":"\\"Uh, INTP.\\""},{"type":"paragraph","content":"\\"Of course.\\""},{"type":"paragraph","content":"\\"I usually get INFP though. But INTP fits better. Or, like, I guess.\\""}]},"thanksgiving_party.done_eating_known":{"id":"thanksgiving_party.done_eating_known","viewIf":{"$code":"return ((Q[\'meet_emily\'] || 0)===1);"},"options":[{"id":"@thanksgiving_party.tell_failure","title":"\\"That I\'m a failure at everything I do?\\""},{"id":"@thanksgiving_party.tell_gay","title":"\\"That they think you\'re gay or whatever?\\""}],"content":[{"type":"paragraph","content":"You\'re done eating, so you throw away your paper plate and put your chopsticks in the sink, and head upstairs again, back to Emily\'s room."},{"type":"paragraph","content":"\\"What were they talking about down there?\\", Emily asks."}]},"scioly_2.end_cell_questions":{"id":"scioly_2.end_cell_questions","content":{"content":"So the two of you go over some more questions, with you quizzing Krishna and him quizzing you in turn. It goes alright; you might actually be learning things.","type":"paragraph"}},"christmas_party.ca6":{"id":"christmas_party.ca6","options":[{"id":"@christmas_party.shrink_away","title":"Shrink away."}],"content":[{"type":"paragraph","content":"You\'re pretty sure your stomach is about to explode right now. That would be inconvenient."},{"type":"paragraph","content":"\\"Um..., so...\\""},{"type":"paragraph","content":"\\"Like, I\'m just saying, this probably won\'t work out, but I wouldn\'t mind going on a date or two with you. Just to see how it turns out.\\" You glance at her. She is smiling, just barely. You\'re still too nervous to cry."},{"type":"paragraph","content":"\\"So um... can we...\\""},{"type":"paragraph","content":"\\"Yeah. We\'ll talk later, okay? Someone\'s coming.\\""}]},"miri_date.um_sure_fun":{"id":"miri_date.um_sure_fun","options":[{"id":"@miri_date.videogames","title":"Play videogames?"},{"id":"@miri_date.tv","title":"Watch TV?"}],"content":[{"type":"paragraph","content":"\\"Um, sure...?\\""},{"type":"paragraph","content":"\\"Okay, so, we could play video games? There\'s an old Wii, if that\'s what you\'re into. And an Xbox. Or we could watch TV?\\""}]},"miri_date":{"id":"miri_date","type":"scene","title":"Miri","subtitle":"A date?","newPage":true,"viewIf":{"$code":"return ((((((((Q[\'week\'] || 0)===11) || ((Q[\'week\'] || 0)===9)) || ((Q[\'week\'] || 0)===8))) && ((Q[\'miri\'] || 0) > 4)) && ((Q[\'weekly_miri\'] || 0)===0)) && ((Q[\'miri_date\'] || 0)===2));"},"onArrival":[{"$code":"Q[\'miri_date\'] = 3;\\nQ[\'growth_points\'] = (Q[\'growth_points\'] || 0) + 1;"}],"tags":["top","miri"],"options":[{"id":"@miri_date.stare_at_miri","title":"Stare at Miri."},{"id":"@miri_date.um","title":"Take a deep breath..."}],"content":[{"type":"paragraph","content":"When Miri invites you over to her house after school, it is one of the very few times when she is alone at home."},{"type":"paragraph","content":"\\"Alright. We have one hour by ourselves. What are we gonna do?\\""}]},"miri_pageant_prep.sit_back_down":{"id":"miri_pageant_prep.sit_back_down","options":[{"id":"@miri_pageant_prep.not_sure_if_want","title":"\\"I don\'t know.\\""}],"content":[{"type":"paragraph","content":"\\"Sorry,\\" you say, and sit back down. \\"I\'ve been... kind of on edge lately. I\'m just so tired of everything.\\""},{"type":"paragraph","content":"\\"Hey, it\'s okay,\\" Miri says, gentler than you deserve. \\"Do you not, like, want to be touched right now?\\""}]},"pageant_final.interview_2_okay":{"id":"pageant_final.interview_2_okay","viewIf":{"$code":"return ((Q[\'pageant_interview\'] || 0) >= 5);"},"options":[{"id":"@pageant_final.interview_end","title":"There are more questions."}],"content":{"content":[{"type":"paragraph","content":"This was another one of the most common questions. You\'ve rehearsed the answer, but you still have to sound as if you\'re just starting out."},{"type":"paragraph","content":["\\"Well, my name is ",{"type":"insert","insert":0}," Zhao,\\" you begin, ",{"type":"conditional","content":"pronouncing it in the proper Mandarin way ","predicate":1},{"type":"conditional","content":"pronouncing it in the (incorrect) Americanized way ","predicate":2},". \\"I\'m a junior in high school, and I\'m interested in science, especially biology. I was born in China and first came to America when I was 8 years old, so I would be one of the rare immigrants to participate in the pageant.\\""]},{"type":"paragraph","content":"The interviewer nods."}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}},{"type":"predicate","fn":{"$code":"return (((Q[\'name_correct\'] || 0)) !== 0);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'name_correct\'] || 0)===0);"}}]}},"scioly_study_party.infp":{"id":"scioly_study_party.infp","goTo":[{"id":"scioly_study_party.david_intp"}],"content":[{"type":"paragraph","content":"\\"Uh, INFP?\\""},{"type":"paragraph","content":"\\"Eh...\\""},{"type":"paragraph","content":"\\"That\'s what I got on tests at least. Most of the time. Sometimes I get INTP though.\\""}]},"thanksgiving_party.tell_failure":{"id":"thanksgiving_party.tell_failure","options":[{"id":"@thanksgiving_party.what_mean","title":"\\"What does that expression even mean, par for the course?\\""}],"content":[{"type":"paragraph","content":"\\"That I\'m a failure at everything I do. That we both are. Or something like that.\\""},{"type":"paragraph","content":"Emily shrugs. \\"Par for the course, I guess.\\""}]},"scioly_2.edwin":{"id":"scioly_2.edwin","viewIf":{"$code":"return ((Q[\'edwin_scioly\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'edwin_scioly\'] = (Q[\'edwin_scioly\'] || 0) + 1;\\nQ[\'disease\'] = (Q[\'disease\'] || 0) + 1;"}],"options":[{"id":"@scioly_2.disease_detectives","title":"\\"Um, sure...\\""}],"content":[{"type":"paragraph","content":"The captain was Aubrey\'s boyfriend last year. Your parents first heard it from Aubrey\'s parents on Wechat before you ever knew of it (you aren\'t embedded deep enough in the school\'s rumor networks). Sometime later they apparently broke up; you never found out how or why. Nor do you care."},{"type":"paragraph","content":"The distinguishing characteristics for the captain are that he\'s overly enthusiastic and obviously loves science."},{"type":"paragraph","content":"\\"Are you ready to work on Disease Detectives?\\", he asks."}]},"christmas_party.shrink_away":{"id":"christmas_party.shrink_away","options":[{"id":"@christmas_party.party_over","title":"The party is over."}],"content":[{"type":"paragraph","content":"An adult Chinese woman sits on the couch."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Liyun, how are you these days? Are you applying to colleges?\\""},""]},{"type":"paragraph","content":"Then Aubrey\'s mom arrives. Then they have a discussion about SATs and college, which you tune out. Typical. You still can\'t get your mind off of what had just taken place. It\'s all the better when the adults mostly ignore you."},{"type":"paragraph","content":"Emily comes downstairs. Aubrey gets up, and you follow her to get more drinks from the counter. Not much conversation is to be had. You wonder if Aubrey is treating you differently; you really can\'t tell."},{"type":"paragraph","content":"In the background, the adults are talking. Aubrey\'s mom and that woman are talking about college apps again. The woman\'s daughter is also in high school but decided not to come here. The younger children are glued to their electronic devices; the girls are playing some dress-up game on the ipad, while the boys are playing Minecraft. Typical."}]},"miri_pageant_prep.not_sure_if_want":{"id":"miri_pageant_prep.not_sure_if_want","goTo":[{"id":"miri_pageant_prep.sitting_sorry_4"}],"content":[{"type":"paragraph","content":"\\"Um, I don\'t know. That\'s kind of the problem though. That I don\'t know, like, anything.\\""},{"type":"paragraph","content":"\\"Oh? Do you want to talk about that?\\""},{"type":"paragraph","content":"\\"No! That\'s the thing! I don\'t know what I want to talk about because I just, like, don\'t know! I just, can\'t come up with the words for any of this stuff. Something\'s going on but I don\'t know what.\\""},{"type":"paragraph","content":"\\"Oh, okay... well, if you do, let me know.\\""},{"type":"paragraph","content":"There are no more words."}]},"pageant_final.interview_end":{"id":"pageant_final.interview_end","onArrival":[{"$code":"Q[\'pageant_score\'] = (Q[\'pageant_score\'] || 0) + (Q[\'interview_score\'] || 0);"}],"options":[{"id":"@pageant_final.platform","title":"Platform"}],"content":{"content":[{"type":"paragraph","content":"There are more questions from the entire panel. You go through them as you practiced, or didn\'t practice."},{"type":"paragraph","content":[{"type":"conditional","content":"Overall, the interview seems to have gone as well as it could have. You didn\'t exhibit your usual foibles and follies. ","predicate":0},""]},{"type":"paragraph","content":[{"type":"conditional","content":"The interview process... did not go well. You exhibited most of your usual flaws when it comes to social interaction; the constant use of filler words, alternating between seeming too rehearsed and too uncertain... ","predicate":1},""]},{"type":"paragraph","content":"Anyway, you\'re escorted back to the waiting room. The next section is where you explain your platform."}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_interview\'] || 0) >= 6);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_interview\'] || 0) < 6);"}}]}},"scioly_study_party.actually":{"id":"scioly_study_party.actually","options":[{"id":"@scioly_study_party.conversation","title":"Join a different group."}],"content":[{"type":"paragraph","content":"\\"Um, actually there\'s no empirical basis for the MBTI. It\'s practically pseudoscience based upon individual intuition and not actual evidence. Like a horoscope essentially.\\""},{"type":"paragraph","content":"\\"So, you\'re INTP?\\", Krishna says."},{"type":"paragraph","content":"\\"No. I mean, like... the MBTI isn\'t real... it literally doesn\'t matter...\\""},{"type":"paragraph","content":"\\"But it can be useful in interpreting human behavior.\\""},{"type":"paragraph","content":"The boys re-enter their own conversation, purposefully or inadvertently leaving you out of their circle."}]},"thanksgiving_party.what_mean":{"id":"thanksgiving_party.what_mean","options":[{"id":"@thanksgiving_party.talk_after_dinner","title":"Talk to Emily?"},{"id":"@thanksgiving_party.homework_after_dinner","title":"Try to do homework?"}],"content":[{"type":"paragraph","content":"\\"What does that expression even mean, par for the course?\\", you ask. To keep the conversation flowing in the only way you know."},{"type":"paragraph","content":"\\"Well, a par is like in golf. It\'s supposed to be the average score, I guess? So it must mean that something\'s typical. Expected.\\""},{"type":"paragraph","content":"\\"Oh. Yeah I guess.\\""},{"type":"paragraph","content":"The conversation dies down as Emily returns to doing her homework, or whatever she\'s doing at her computer."}]},"scioly_2.disease_detectives":{"id":"scioly_2.disease_detectives","options":[{"id":"@scioly_2.disease_answer1","title":"Host, agent, environment"},{"id":"@scioly_2.disease_answer2","title":"CDC, WHO, NIH"},{"id":"@scioly_2.disease_answer3","title":"Mumps, Measles, Rubella"},{"id":"@scioly_2.disease_answer4","title":"Bacteria, Viruses, Fungi"}],"content":[{"type":"paragraph","content":"Disease Detectives is a study event about, you guessed it, epidemiology. It\'s a mix of general knowledge questions about epidemiology, and some more in-depth case studies."},{"type":"paragraph","content":"\\"Let\'s look at some tests from past years,\\" the captain says. \\"How many of these questions do you know?\\""},{"type":"paragraph","content":"The first question: What is the epidemiologic triad?"}]},"christmas_party.silent_with_aubrey":{"id":"christmas_party.silent_with_aubrey","options":[{"id":"@christmas_party.get_out_with_aubrey","title":"Get out of there?"}],"content":[{"type":"paragraph","content":"There is a pause. A long pause interrupted by the conversations of the adults, who are now in the room with you. One woman sits next to Aubrey."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Liyun, how are you these days? Are you applying to colleges?\\""},""]},{"type":"paragraph","content":["Another woman approaches, Aubrey(Liyun)\'s mom, leaning against the couch. ",{"type":"emphasis-1","content":"\\"She\'s only in the third year of high school. Next year she\'ll apply for colleges.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"But she\'s taken the SATs, right?\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Yes,\\""}," Liyun\'s mom says. ",{"type":"emphasis-1","content":"\\"Can you tell auntie what score you got?\\""},""]},{"type":"paragraph","content":["Aubrey makes a barely perceptible sigh. ",{"type":"emphasis-1","content":"\\"2300.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"What\'s the highest?\\""},", the woman asks."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"2400\\""},", Aubrey says."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Wow! That\'s great!\\""}," She turns to you. ",{"type":"emphasis-1","content":"\\"Who is this?\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"This is Zhao Qiuyi, Old Zhao\'s daughter,\\""}," Aubrey\'s mom says. ",{"type":"emphasis-1","content":"\\"She is also very good at studying.\\""},""]},{"type":"paragraph","content":"You and Aubrey glance at each other."}]},"miri_pageant_prep.fuck_you_miri":{"id":"miri_pageant_prep.fuck_you_miri","viewIf":{"$code":"return ((Q[\'stress\'] || 0) >= 6);"},"onArrival":[{"$code":"Q[\'miri_escape\'] = 1;\\nQ[\'trauma_points\'] = (Q[\'trauma_points\'] || 0) + 1;"}],"options":[{"id":"@miri_pageant_prep.fu_nod","title":"Nod."}],"content":[{"type":"paragraph","content":"The very fact that you desired to say that to Miri makes you despise yourself, slightly more than usual."},{"type":"paragraph","content":"Of course you won\'t say anything like that. You won\'t say anything at all. You can\'t say anything at all."},{"type":"paragraph","content":"You feel like crying again for some reason. And you do, harder than before, and you don\'t know why. Your legs start to carry you, not in any particular direction but just away from here. Miri gets up, following you."},{"type":"paragraph","content":"\\"Hey, let\'s just... let\'s go home. Is that okay? We can go home separately.\\""}]},"pageant_final.platform":{"id":"pageant_final.platform","onArrival":[{"$code":"Q[\'pageant_score\'] = (Q[\'pageant_score\'] || 0) + (Q[\'pageant_platform\'] || 0);"}],"options":[{"id":"@pageant_final.platform_good","title":"Yeah, kind of."},{"id":"@pageant_final.platform_bad","title":"No, of course not."}],"content":[{"type":"paragraph","content":"The platform review is a speech in front of the judges where you\'re supposed to expound on your platform."},{"type":"paragraph","content":"...You did practice the speech, right?"}]},"scioly_study_party.david_intp":{"id":"scioly_study_party.david_intp","options":[{"id":"@scioly_study_party.conversation","title":"Join a different group."}],"content":[{"type":"paragraph","content":"\\"I think INTP definitely fits you better. By the way, David\'s also an INTP, along with like half the team.\\""},{"type":"paragraph","content":"\\"Oh. That\'s, uh, predictable, I guess.\\""},{"type":"paragraph","content":"The boys re-enter their own conversation, purposefully or inadvertently leaving you out of their circle."}]},"scioly_study_party":{"id":"scioly_study_party","type":"scene","title":"Science Olympiad","subtitle":"The only study party","newPage":true,"viewIf":{"$code":"return (((((Q[\'week\'] || 0)===7) && ((Q[\'scioly\'] || 0) > 1)) && ((Q[\'stress\'] || 0) < 15)) && ((Q[\'study_party\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'scioly\'] = (Q[\'scioly\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'study_party\'] = 1;"}],"tags":["top","weekend"],"options":[{"id":"@scioly_study_party.knock","title":"Knock on the door."}],"content":{"content":"The Science Olympiad study party is being hosted at the captain\'s house. It\'s about a 20-minute walk from yours, in one of the \\"nicer\\" parts of town. You were given excuse from the usual Bible study groups to attend; your parents are very concerned about your extracurricular performance and what it means for college apps. They probably assumed that the \\"study\\" part will take precedence over the \\"party\\" part. Of course they\'re mistaken, but why correct them?","type":"paragraph"}},"thanksgiving_party.tell_gay":{"id":"thanksgiving_party.tell_gay","options":[{"id":"@thanksgiving_party.dont_know_what_to_say","title":"You don\'t know what to say."}],"content":[{"type":"paragraph","content":"\\"Um, your mom thought you were gay. Or something like that.\\""},{"type":"paragraph","content":"Emily chuckles. \\"They still think being trans is like being ultra-gay or whatever. I mean, not that I\'m not ultra-gay, but, like,...\\" She trails off there and smiles strangely to herself. \\"Sorry.\\""}]},"scioly_2.disease_answer1":{"id":"scioly_2.disease_answer1","options":[{"id":"@scioly_2.disease_questions_2","title":"The questions continue."}],"content":[{"type":"paragraph","content":"\\"Host, agent, environment.\\""},{"type":"paragraph","content":"\\"Yep, that\'s right. That was a really easy question.\\""}]},"christmas_party.get_out_with_aubrey":{"id":"christmas_party.get_out_with_aubrey","goTo":[{"id":"christmas_party.aubrey_is_sorry"}],"content":[{"type":"paragraph","content":["You and Aubrey stand up almost in unison. ",{"type":"emphasis-1","content":"\\"Aiya, daughters don\'t want to hear old lady\'s talking,\\""}," the woman says, and laughs."]},{"type":"paragraph","content":"The two of you walk to the kitchen and fill your cups with more drinks. Soon Emily comes downstairs to join you."}]},"miri_pageant_prep.fu_nod":{"id":"miri_pageant_prep.fu_nod","content":[{"type":"paragraph","content":"You nod. \\"Alright then,\\" she says. \\"Hope I\'ll see you later.\\" And she walks off."},{"type":"paragraph","content":"You sit back down. You can\'t go home like this. A few people pass you by, some staring, none stopping. Eventually your tears stop. The sun has set and it\'s too cold to be outside for so long."}]},"pageant_final.platform_good":{"id":"pageant_final.platform_good","viewIf":{"$code":"return (((Q[\'pageant_platform\'] || 0) > 2) && ((Q[\'platform_doc_completed\'] || 0)===1));"},"onArrival":[{"$code":"Q[\'pageant_score\'] = (Q[\'pageant_score\'] || 0) + 1;"}],"options":[{"id":"@pageant_final.gown","title":"The next section is evening wear."}],"content":{"content":"Yes, you did write down a speech and practice it at home. You talk about the benefits of basic scientific research and why more people should care about it, and how you\'re going to bring science to the masses. Or something like that. It kind of works.","type":"paragraph"}},"thanksgiving_party.dont_know_what_to_say":{"id":"thanksgiving_party.dont_know_what_to_say","options":[{"id":"@thanksgiving_party.talk_after_dinner","title":"Talk to Emily?"},{"id":"@thanksgiving_party.homework_after_dinner","title":"Try to do homework?"}],"content":{"content":"The conversation dies down as Emily returns to doing her homework, or whatever she\'s doing at her computer.","type":"paragraph"}},"scioly_2.disease_answer2":{"id":"scioly_2.disease_answer2","goTo":[{"id":"scioly_2.disease_wrong_answer_1"}],"content":{"content":"\\"CDC, WHO, NIH?\\"","type":"paragraph"}},"christmas_party.aubrey_is_sorry":{"id":"christmas_party.aubrey_is_sorry","options":[{"id":"@christmas_party.party_over","title":"The party is over."}],"content":{"content":[{"type":"paragraph","content":"\\"I\'m sorry,\\" Aubrey says."},{"type":"paragraph","content":[{"type":"conditional","content":"\\"Oh. Apology accepted, I guess.\\" Aubrey smiles at her. ","predicate":0},""]},{"type":"paragraph","content":[{"type":"conditional","content":"\\"For what?\\" ","predicate":1},""]},{"type":"paragraph","content":[{"type":"conditional","content":"\\"Never mind,\\" Aubrey says. ","predicate":2},""]},{"type":"paragraph","content":"In the background, the adults are talking. Aubrey\'s mom and that woman are talking about college apps again. The woman\'s daughter is also in high school but decided not to come here. The younger children are glued to their electronic devices; the girls are playing some dress-up game on the ipad, while the boys are playing Minecraft. Typical."},{"type":"paragraph","content":"Aubrey and Emily aren\'t talking very much. Or at all. You aren\'t either."}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'come_out_christmas_party\'] || 0)===1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'come_out_christmas_party\'] || 0)===0);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'come_out_christmas_party\'] || 0)===0);"}}]}},"miri_pageant_prep.let_her_hold":{"id":"miri_pageant_prep.let_her_hold","onArrival":[{"$code":"Q[\'growth_points\'] = (Q[\'growth_points\'] || 0) + 1;\\nQ[\'miri_like\'] = (Q[\'miri_like\'] || 0) + 1;"}],"options":[{"id":"@miri_pageant_prep.sitting_sorry_4","title":"You sit there for a while."}],"content":[{"type":"paragraph","content":"It\'s not such a bad feeling, Miri\'s mitten over your bare hand. She continues speaking. \\"I\'m going to try to be more understanding in the future, okay? And there\'s nothing wrong with you.\\""},{"type":"paragraph","content":"\\"Everything is wrong with me.\\""},{"type":"paragraph","content":"She chuckles for some reason. \\"I knew you would say that.\\""},{"type":"paragraph","content":"\\"Well fuck me for being so predictable.\\""},{"type":"paragraph","content":"She\'s laughing now. And you don\'t feel like crying anymore."}]},"pageant_final.platform_bad":{"id":"pageant_final.platform_bad","onArrival":[{"$code":"Q[\'pageant_score\'] = (Q[\'pageant_score\'] || 0) - 5;"}],"options":[{"id":"@pageant_final.gown","title":"The next section is evening wear."}],"content":[{"type":"paragraph","content":"Nope. You didn\'t write a speech at all. You either forgot that it was part of the competition, or remembered but never got around to it. Oh well."},{"type":"paragraph","content":"You are not particularly good at making up speeches on the spot either. You had some general ideas about what to say, but they\'re lost among a tangle of filler words."}]},"thanksgiving_party.talk_after_dinner":{"id":"thanksgiving_party.talk_after_dinner","options":[{"id":"@thanksgiving_party.quiet","title":"It\'s quiet for a while."}],"content":[{"type":"paragraph","content":"Somehow, this moment feels familiar, perhaps because it\'s the recapitulation of every social interaction you\'ve ever had. You want to talk to Emily, but you don\'t know what to talk about, or if she wants to talk to you or would rather do homework. And besides, there\'s the awkwardness of... you know."},{"type":"paragraph","content":"Whatever. Maybe you should do homework instead, which obviously you have a ton of. So you do."}]},"scioly_2.disease_answer3":{"id":"scioly_2.disease_answer3","goTo":[{"id":"scioly_2.disease_wrong_answer_1"}],"content":{"content":"\\"Mumps, measles, rubella?\\"","type":"paragraph"}},"christmas_party.stay_with_emily":{"id":"christmas_party.stay_with_emily","options":[{"id":"@christmas_party.help_clean_up","title":"Help clean up."}],"content":[{"type":"paragraph","content":"Emily is silent. And so are you, for the moment."},{"type":"paragraph","content":"\\"So, uh, I guess I won?\\", she says."},{"type":"paragraph","content":"\\"Um, yeah, I guess you did.\\""},{"type":"paragraph","content":"For some reason, Emily starts laughing. \\"God, this was so awkward,\\" she says, and starts clearing the Scrabble board. \\"Did she really leave us alone in her room? What the hell is she thinking?\\""}]},"miri_pageant_prep.sitting_sorry_4":{"id":"miri_pageant_prep.sitting_sorry_4","options":[{"id":"@miri_pageant_prep.go_home_5","title":"Soon enough you\'re on the train home."}],"content":{"content":"\\"I should wash my face,\\" you say eventually. Miri is still holding your hand as you get up.","type":"paragraph"}},"pageant_final.gown":{"id":"pageant_final.gown","onArrival":[{"$code":"Q[\'pageant_score\'] = (Q[\'pageant_score\'] || 0) + (Q[\'pageant_appearance\'] || 0);"}],"options":[{"id":"@pageant_final.gown_2_no_practice","title":"Unfortunately, you had never put on the gown before."},{"id":"@pageant_final.gown_2","title":"You\'ve had at least a little bit of practice with the gown..."}],"content":{"content":[{"type":"paragraph","content":"This section is open to the parents, and there will be parents watching. You hope your parents didn\'t bother to read the part of the info packet where they could watch. But they definitely want to see you in a beautiful dress or something like that, or at least mom does."},{"type":"paragraph","content":"Fortunately, they haven\'t been in the audience so far. That\'s one less anxiety source, out of at least ten."},{"type":"paragraph","content":["In the changing room you put on your gown, with the help of one of the other contestants (it wasn\'t as awkward as it could have been; you helped her in turn). ",{"type":"conditional","content":"Your gown is a simple black gown with a white bowtie belt. ","predicate":0}," ",{"type":"conditional","content":"Your gown is a simple deep green strapless pleated dress, with a soft texture. ","predicate":1}," ",{"type":"conditional","content":"Your gown is a somewhat simple-looking light blue V-neck dress with a belt of shiny stones. ","predicate":2}," ",{"type":"conditional","content":"Your gown is a very fancy, shiny blood-red strapless dress. ","predicate":3}," ",{"type":"conditional","content":"When you tried it on before, you had never realized how revealing the top was. Or maybe it\'s just the eyes that are now all upon you.","predicate":4}]}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'ball_gown\'] || 0)===1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'ball_gown\'] || 0)===2);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'ball_gown\'] || 0)===3);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'ball_gown\'] || 0)===4);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'try_on_ball_gown\'] || 0)===1);"}}]}},"thanksgiving_party.homework_after_dinner":{"id":"thanksgiving_party.homework_after_dinner","options":[{"id":"@thanksgiving_party.quiet","title":"It\'s quiet for a while."}],"content":[{"type":"paragraph","content":"Yes, you should do homework. Of course there\'s plenty of homework that\'s been assigned over Thanksgiving. AP World is the most pressing, with a full chapter of assigned reading, but you also have problem sets in AP Calc and AP Chem."},{"type":"paragraph","content":"You take out your books from your backpack once more, but as usual you can\'t focus."}]},"scioly_2.disease_answer4":{"id":"scioly_2.disease_answer4","goTo":[{"id":"scioly_2.disease_wrong_answer_1"}],"content":{"content":"\\"Bacteria, viruses, fungi?\\"","type":"paragraph"}},"christmas_party.help_clean_up":{"id":"christmas_party.help_clean_up","options":[{"id":"@christmas_party.ask_emily_sat","title":"Ask Emily what her SAT was."},{"id":"@christmas_party.dont_ask_sat","title":"Why would you randomly ask someone that???"}],"content":[{"type":"paragraph","content":"You and Emily clean up the board game and cups and paper plates, and bring the trash downstairs."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Her SAT, what did she get?\\""},", you overhear a woman say. Aubrey is sitting on a couch, next to a woman you do not recognize, who is talking to Aubrey\'s mom."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"2300,\\""}," Aubrey replies. Emily seems to grimace."]}]},"miri_pageant_prep.go_home_5":{"id":"miri_pageant_prep.go_home_5","content":[{"type":"paragraph","content":"Miri doesn\'t make much conversation on the trip home. You\'re not sure if it\'s a good silence or a bad silence."},{"type":"paragraph","content":"You make sure to clean your face before entering your parents\' sight."}]},"pageant_final.gown_2_no_practice":{"id":"pageant_final.gown_2_no_practice","goTo":[{"id":"pageant_final.gown_final"}],"viewIf":{"$code":"return ((Q[\'try_on_ball_gown\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'pageant_score\'] = (Q[\'pageant_score\'] || 0) - 5;"}],"content":{"content":[{"type":"paragraph","content":"You are not used to the sensation of walking in a long dress. It feels strange; the fabric folds between your legs and makes walking uncomfortable. You almost trip. You barely pay attention to the audience or the judges. How does your face look right now? What are you supposed to do with your arms? Does it even matter anymore?"},{"type":"paragraph","content":["It\'s an ordeal, ",{"type":"conditional","content":"made only slightly better by your confidence in the other facets of your preparation. ","predicate":0},{"type":"conditional","content":"unvarnished in its illustration of your ineptitude. ","predicate":1}," There is polite clapping for you as you finish. The judges\' faces are impassive as usual, but perhaps there are hints of cringes and winces."]}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_appearance\'] || 0) > 10);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_appearance\'] || 0) <= 10);"}}]}},"thanksgiving_party.quiet":{"id":"thanksgiving_party.quiet","options":[{"id":"@thanksgiving_party.want_clothes","title":"\\"Sure...?\\""},{"id":"@thanksgiving_party.what_clothes","title":"\\"What...?\\""}],"content":{"content":"It\'s quiet until Emily stands up and walks to her closet. \\"Hey, like, do you want some of my clothes? You\'re doing the pageant, right? And you need clothes and your current wardrobe is entirely inadequate?\\"","type":"paragraph"}},"scioly_2.disease_wrong_answer_1":{"id":"scioly_2.disease_wrong_answer_1","options":[{"id":"@scioly_2.disease_questions_2","title":"The questions continue."}],"content":[{"type":"paragraph","content":"\\"Is that a joke?\\""},{"type":"paragraph","content":"\\"Um, ... yeah. I mean, it was.\\""},{"type":"paragraph","content":"The captain sighs. \\"Host, agent, environment. You\'d better know that.\\""},{"type":"paragraph","content":"\\"Yeah. Of course. Sorry.\\""},{"type":"paragraph","content":"\\"That\'s fine. Let\'s go over some more stuff.\\""}]},"christmas_party.ask_emily_sat":{"id":"christmas_party.ask_emily_sat","goTo":[{"id":"christmas_party.aubrey_is_sorry"}],"content":[{"type":"paragraph","content":"\\"Um, what did you get?\\", you ask Emily, trying to seem as nonchalant as possible."},{"type":"paragraph","content":"\\"2190,\\" she replies. \\"Yeah, it\'s not that good. What about you?\\""},{"type":"paragraph","content":"\\"I haven\'t taken it yet.\\""},{"type":"paragraph","content":"\\"Oh.\\""},{"type":"paragraph","content":"Aubrey sees you and Emily, and she gets up, walking towards you."}]},"miri_pageant_prep.just_go_away":{"id":"miri_pageant_prep.just_go_away","options":[{"id":"@miri_pageant_prep.pull_away","title":"Pull away."},{"id":"@miri_pageant_prep.let_her_hold","title":"Let her hold your hand."}],"content":[{"type":"paragraph","content":"\\"Just... God, I don\'t even know. I don\'t even know what I\'m thinking. Just that, like, everything\'s wrong, and...\\""},{"type":"paragraph","content":"\\"Hey, it\'s okay,\\" Miri says, and places her hand on top of yours. \\"You don\'t have to talk if you don\'t want to.\\""}]},"pageant_final.gown_2":{"id":"pageant_final.gown_2","goTo":[{"id":"pageant_final.gown_final"}],"viewIf":{"$code":"return ((Q[\'try_on_ball_gown\'] || 0)===1);"},"content":{"content":[{"type":"paragraph","content":"You\'ve only tried on the ball gown a couple of times, but it\'s enough to get a sense of how it feels, and how to move within it. You\'re not comfortable, and maybe you\'ll never be, but you won\'t trip over yourself, at least."},{"type":"paragraph","content":["Overall... ",{"type":"conditional","content":"you do surprisingly well on the evening gown section. Your posture, your dress, even your facial expression were all exactly as practiced. The judges\' faces look impassive as usual, but there was some clapping from the audience. ","predicate":0},{"type":"conditional","content":"you do okay on the evening gown presentation, in your opinion. You didn\'t fail utterly. There is polite clapping for you at the end, and the judges look impassive as usual. ","predicate":1},{"type":"conditional","content":"you do horribly on the evening gown presentation, as one would expect. You barely avoid tripping over the hem of the dress as you walk down the makeshift stage. Maybe there were winces from the crowd, or maybe you just imagined them.","predicate":2}]}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_appearance\'] || 0) > 10);"}},{"type":"predicate","fn":{"$code":"return (((Q[\'pageant_appearance\'] || 0) <= 10) && ((Q[\'pageant_appearance\'] || 0) > 6));"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_appearance\'] || 0) <= 6);"}}]}},"thanksgiving_party.want_clothes":{"id":"thanksgiving_party.want_clothes","goTo":[{"id":"thanksgiving_party.ball_gown"}],"content":{"content":"\\"Sure... I guess?\\"","type":"paragraph"}},"scioly_2.disease_questions_2":{"id":"scioly_2.disease_questions_2","content":[{"type":"paragraph","content":"Next the captain starts feeding you slightly more difficult questions. What are Koch\'s Postulates? What are Hill\'s Criteria for Causation? What are the false positive and false negative rates for a given statistical test, given the population size? Given this particular scenario, what is the relative risk? And so on."},{"type":"paragraph","content":"You don\'t know this stuff nearly as well as you should."}]},"christmas_party.dont_ask_sat":{"id":"christmas_party.dont_ask_sat","goTo":[{"id":"christmas_party.aubrey_is_sorry"}],"content":[{"type":"paragraph","content":"Instead of talking about the SAT, you should be talking like a normal person. Except you have no idea what normal people are supposed to do, in this situation or any situation."},{"type":"paragraph","content":"Aubrey sees you and Emily, and she gets up, walking towards you."}]},"miri_pageant_prep.hang_2":{"id":"miri_pageant_prep.hang_2","viewIf":{"$code":"return ((((Q[\'miri_hang\'] || 0)===1) && ((Q[\'miri_practice\'] || 0) > 0)) && ((Q[\'gym\'] || 0) > 0));"},"onArrival":[{"$code":"Q[\'miri_hang\'] = (Q[\'miri_hang\'] || 0) + 1;"}],"options":[{"id":"@miri_pageant_prep.stay_here","title":"Stay around here?"}],"content":[{"type":"paragraph","content":"\\"Sure, we can hang out,\\" Miri says. \\"We\'ve done enough pageant practicing. Where do you want to go? Or, do you want to go downtown again?\\""},{"type":"paragraph","content":"\\"Um...\\""},{"type":"paragraph","content":"When you begin to hesitate, Miri continues, \\"Actually let\'s just stay around town.\\""},{"type":"paragraph","content":"\\"Sure, that\'s fine I guess.\\""}]},"pageant_final.gown_final":{"id":"pageant_final.gown_final","options":[{"id":"@pageant_final.athletic","title":"Athletic wear"}],"content":{"content":"Anyway, it\'s over now. You walk back to the changing room, take off your dress with assistance, and prepare for the next section.","type":"paragraph"}},"thanksgiving_party.what_clothes":{"id":"thanksgiving_party.what_clothes","goTo":[{"id":"thanksgiving_party.ball_gown"}],"content":{"content":"\\"What...? I mean, doesn\'t the pageant need, like,...\\"","type":"paragraph"}},"scioly_2.edwin2":{"id":"scioly_2.edwin2","viewIf":{"$code":"return ((Q[\'edwin_scioly\'] || 0)===1);"},"onArrival":[{"$code":"Q[\'edwin_scioly\'] = (Q[\'edwin_scioly\'] || 0) + 1;\\nQ[\'disease\'] = (Q[\'disease\'] || 0) + 1;"}],"options":[{"id":"@scioly_2.disease_part2","title":"He hands you a study packet."}],"content":{"content":[{"type":"paragraph","content":"The captain is sitting in his usual spot, hunched over a practice packet."},{"type":"paragraph","content":["\\"Hey ",{"type":"insert","insert":0},". Ready for Disease Detectives?\\""]},{"type":"paragraph","content":"\\"Yeah, I guess.\\""},{"type":"paragraph","content":"\\"That\'s not good enough. You have to be absolutely ready if we\'re going to win. We\'re up against schools where every other kid\'s parent is a professor at MIT or Harvard, and we don\'t have nearly the resources or connections that they do, so we absolutely have to work harder.\\""},{"type":"paragraph","content":"Huh. A new motivational speech."},{"type":"paragraph","content":"\\"Well, my mom\'s a research associate,\\" you say with a shrug. \\"Is that good enough?\\""},{"type":"paragraph","content":"The captain stares at you for a moment. \\"That\'s not the point. The point is, we have to work harder. What we\'re doing right now isn\'t good enough. Let\'s start right now.\\""}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"christmas_party.party_over":{"id":"christmas_party.party_over","options":[{"id":"@christmas_party.merry_christmas","title":"\\"Merry Christmas.\\""}],"content":[{"type":"paragraph","content":"It is not long before your parents collect you and Kevin to leave. You wave goodbye to Emily and Aubrey; hopefully the two of them won\'t get into any more trouble."},{"type":"paragraph","content":"Not long after you get home, it is officially Christmas. \\"Merry Christmas,\\" dad says as the TV announces the same. \\"Merry Christmas,\\" mom answers."}]},"miri_pageant_prep.stay_here":{"id":"miri_pageant_prep.stay_here","options":[{"id":"@miri_pageant_prep.care_really","title":"\\"Really?\\""},{"id":"@miri_pageant_prep.care_thanks","title":"\\"Thanks?\\""}],"content":[{"type":"paragraph","content":"Your town has a little business district with a public square, near the school and the T stop. Of course it\'s absolutely filled with high school students and other miscellaneous acquaintances, so it\'s not your favorite place to be. Not that you really have a favorite place to begin with."},{"type":"paragraph","content":"\\"So, uh, sorry about last time,\\" Miri says. \\"I can be a little pushy sometimes.\\""},{"type":"paragraph","content":"\\"It\'s fine...\\""},{"type":"paragraph","content":"\\"Hey, like, I really care about you, you know.\\""}]},"pageant_final.athletic":{"id":"pageant_final.athletic","options":[{"id":"@pageant_final.athletic_results","title":"You just have to walk around and make poses..."},{"id":"@pageant_final.athletic_failure","title":"You can\'t do this anymore."}],"content":{"content":"This section is also open to parents, but as before, you don\'t see them here. Some other pageants would require a swimsuit section; out of a desire to not objectify teenagers, this pageant does not, thank God. But you still have to wear clothes that show off too much of your extremities, like gym shorts and a tank top or t-shirt. It is bad, but not as bad as it could have been.","type":"paragraph"}},"thanksgiving_party.ball_gown":{"id":"thanksgiving_party.ball_gown","onArrival":[{"$code":"Q[\'appearance\'] = (Q[\'appearance\'] || 0) + 1;\\nQ[\'has_gown\'] = 1;"}],"options":[{"id":"@thanksgiving_party.hear_footsteps_2","title":"And you hear footsteps coming up the stairs."}],"content":[{"type":"paragraph","content":"\\"Oh, I have a ball gown,\\" she says, and she\'s already inside the closet. \\"I don\'t know if it fits you but I think we\'re pretty similar in height at least.\\""},{"type":"paragraph","content":"Emily tosses a violet dress in your direction, and it drapes over your head."},{"type":"paragraph","content":"\\"Thanks, I guess.\\" You quickly shove it in your backpack."},{"type":"paragraph","content":"\\"Want anything else?\\", she asks. \\"I don\'t want my parents to find any of my dresses. They know they\'re there, they just don\'t know where to look. Not yet.\\""},{"type":"paragraph","content":"\\"Um...\\""}]},"scioly_2.disease_part2":{"id":"scioly_2.disease_part2","content":[{"type":"paragraph","content":"\\"Here, I printed this out,\\" he says. \\"Memorize every single word on these pages. Memorize all of the case studies. Go on the CDC epidemiology case studies website and memorize everything on that site.\\""},{"type":"paragraph","content":"Along with the captain, you study in silence. You pore over the packet for the remainder of the meeting, until your brain becomes immersed in talk of case definitions and etiologies and odds ratios. At home tonight, you spend at least three hours on https://www.cdc.gov/eis/casestudies.html. It\'s quite fascinating."}]},"scioly_2":{"id":"scioly_2","type":"scene","title":"Science Olympiad","subtitle":"A regular meeting","newPage":true,"viewIf":{"$code":"return ((((((((Q[\'week\'] || 0) >= 1) && ((Q[\'week\'] || 0) < 8)) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'scioly\'] || 0) >= 1)) && ((Q[\'scioly\'] || 0) <= 4)) && ((Q[\'weekly_scioly\'] || 0)===0)) && ((Q[\'stress\'] || 0) < 15));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'scioly\'] = (Q[\'scioly\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;\\nQ[\'weekly_scioly\'] = 1;"}],"tags":["top","scioly"],"options":[{"id":"@scioly_2.aubrey","title":"Meet with Aubrey Gao for Protein Modeling."},{"id":"@scioly_2.aubrey2","title":"Keep studying with Aubrey for Protein Modeling."},{"id":"@scioly_2.david","title":"Meet with David Nguyen for Fossils."},{"id":"@scioly_2.david2","title":"Keep studying with David for Fossils."},{"id":"@scioly_2.roxana","title":"Study with Roxana Nguyen for Fossils."},{"id":"@scioly_2.krishna","title":"Meet with Krishna Rao for Cell Biology."},{"id":"@scioly_2.krishna2","title":"Keep studying with Krishna for Cell Biology."},{"id":"@scioly_2.edwin","title":"Meet with the captain for Disease Detectives."},{"id":"@scioly_2.edwin2","title":"Keep studying with the captain for Disease Detectives."}],"content":{"content":"During Science Olympiad meetings, you\'re supposed to meet with your event partners and make plans for studying. Or something like that.","type":"paragraph"}},"christmas_party.merry_christmas":{"id":"christmas_party.merry_christmas","content":{"content":"\\"Merry Christmas,\\" you say. Kevin is already too tired to stay awake. Mom puts him to bed. Dad fell asleep on the couch. You turn off the TV and the light, and head back to your room.","type":"paragraph"}},"christmas_party":{"id":"christmas_party","type":"scene","title":"A Christmas Party","subtitle":"The Gao Household, December 24","newPage":true,"viewIf":{"$code":"return (((Q[\'week\'] || 0)===10) && ((Q[\'christmas_party\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'christmas_party\'] = 1;\\nQ[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;"}],"tags":["top","christmas"],"options":[{"id":"@christmas_party.not_long","title":"It\'s not a long drive."}],"content":[{"type":"paragraph","content":"Every year, your family\'s Bible study group holds a Christmas gathering at the Gao household, since they have the largest house of any family in the group. The whole Saturday church group usually comes, plus a bunch of other families you don\'t know too well."},{"type":"paragraph","content":"As with all of these gatherings, it\'s a potluck. As with all of these gatherings, your mom made a northwestern-style spicy cumin lamb noodle soup. As with all of these gatherings, the ordeal begins with you and Kevin riding in the back seat of your family\'s Toyota Camry."}]},"miri_pageant_prep.care_really":{"id":"miri_pageant_prep.care_really","goTo":[{"id":"miri_pageant_prep.care_2"}],"onArrival":[{"$code":"Q[\'loneliness\'] = (Q[\'loneliness\'] || 0) - 1;"}],"content":[{"type":"paragraph","content":"\\"Really?\\""},{"type":"paragraph","content":"\\"Yeah. Really. I know you don\'t really believe it when people say things like that, but I mean it.\\""}]},"pageant_final.athletic_failure":{"id":"pageant_final.athletic_failure","viewIf":{"$code":"return (((Q[\'pageant_appearance\'] || 0) <= 6) && ((Q[\'try_on_ball_gown\'] || 0)===0));"},"onArrival":[{"$code":"Q[\'pageant_total_failure\'] = 1;"}],"options":[{"id":"@pageant_final.knock","title":"There is a knock at the door."}],"content":[{"type":"paragraph","content":["It starts in the dressing room. There\'s a full-length mirror, where you can see your entire body. And then it finally dawns upon you that you\'re ",{"type":"emphasis-1","content":"doing this"},". You\'re in the pageant where you\'re supposed to show off your body to a bunch of strangers who judge you, and for what? For a pittance of a scholarship? For a slightly nonzero chance at improving your college apps, in the opinion of your parents who didn\'t even grow up in this country?"]},{"type":"paragraph","content":["Why are you even here, letting others ",{"type":"emphasis-1","content":"look"}," at you like this, letting strangers gaze upon your forlorn expressions and misshapen body as if you\'re an automaton who exists for the sake of others\' gazes?"]},{"type":"paragraph","content":"Your eyes feel wet. You can\'t do this anymore."}]},"thanksgiving_party.hear_footsteps_2":{"id":"thanksgiving_party.hear_footsteps_2","options":[{"id":"@thanksgiving_party.confront","title":"Confront Emily\'s mom."},{"id":"@thanksgiving_party.no_confront","title":"Don\'t say anything."}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"---, where are you?\\""}," Emily\'s mom enters the room, shouting. Emily emerges from the closet clutching a handful of clothes. She quickly tosses them back in."]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"---, how many times have we told you to not do this? Chen Song, come up here!\\""},""]},{"type":"paragraph","content":"Emily stays still, looking away from the door."}]},"miri_pageant_prep.care_thanks":{"id":"miri_pageant_prep.care_thanks","goTo":[{"id":"miri_pageant_prep.care_2"}],"onArrival":[{"$code":"Q[\'loneliness\'] = (Q[\'loneliness\'] || 0) - 1;"}],"content":[{"type":"paragraph","content":"\\"Um, thanks?\\""},{"type":"paragraph","content":"\\"Like, I know you don\'t really believe it when people say things like that, but I mean it.\\""}]},"pageant_final.knock":{"id":"pageant_final.knock","options":[{"id":"@pageant_final.knock_2","title":"More knocks."}],"content":{"content":[{"type":"paragraph","content":["\\"Hey, are you there, ",{"type":"insert","insert":0},"? It\'s starting soon.\\""]},{"type":"paragraph","content":"You\'re crying. You can\'t open the door. You turn away from the mirror but it is unavoidable, as if the mirror is warping itself around the room, encompassing everything you can see."}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"thanksgiving_party.hear_footsteps":{"id":"thanksgiving_party.hear_footsteps","options":[{"id":"@thanksgiving_party.confront","title":"Confront Emily\'s mom."},{"id":"@thanksgiving_party.no_confront","title":"Don\'t say anything."}],"content":[{"type":"paragraph","content":"\\"Oh, shit. I have to change,\\" Emily says, but the door already opens, and Emily\'s mom enters."},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"---, how many times have we told you to not do this? Chen Song, come up here!\\""},""]},{"type":"paragraph","content":"Emily stays still, looking away from the door."}]},"miri_pageant_prep.care_2":{"id":"miri_pageant_prep.care_2","options":[{"id":"@miri_pageant_prep.lull_conversation","title":"There is a lull in the conversation."}],"content":[{"type":"paragraph","content":"\\"Um... thanks?\\""},{"type":"paragraph","content":"\\"Sure...\\""}]},"pageant_final.knock_2":{"id":"pageant_final.knock_2","options":[{"id":"@pageant_final.over","title":"It\'s over."}],"content":{"content":"More knocks. You\'re sitting on the floor now, hugging your knees. Your face must be disgusting. The door unlocks. Voices. Someone takes your arm. You surrender yourself.","type":"paragraph"}},"thanksgiving_party.confront":{"id":"thanksgiving_party.confront","options":[{"id":"@thanksgiving_party.professor_chen_arrives","title":"And soon Professor Chen arrives."}],"content":{"content":"You want to say something, but your brain and your mouth refuse. You open your mouth, but you can\'t call up the words from your head.","type":"paragraph"}},"miri_pageant_prep.lull_conversation":{"id":"miri_pageant_prep.lull_conversation","options":[{"id":"@miri_pageant_prep.miri_what","title":"What?"},{"id":"@miri_pageant_prep.miri_the","title":"The?"},{"id":"@miri_pageant_prep.miri_ffff","title":"????"}],"content":[{"type":"paragraph","content":"\\"Is this a good time?\\", Miri says, breaking a long pause."},{"type":"paragraph","content":"\\"Good time for what?\\""},{"type":"paragraph","content":"Miri stares at you, her deep brown eyes wide open with an intense expression. She sighs, and turns away."},{"type":"paragraph","content":"\\"I kind of like you. Not kind of. I really do. In like, a romantic way, I guess.\\""},{"type":"paragraph","content":"It takes a while for your mind to process the words."}]},"pageant_final.over":{"id":"pageant_final.over","options":[{"id":"@epilogue","title":"Epilogues"}],"content":{"content":"Your parents pick you up. Neither mom nor dad say much. They must be disappointed, but perhaps they developed some sympathy after seeing their daughter with tear streaks on her face. Soon you\'re home. It\'s over.","type":"paragraph"}},"thanksgiving_party.no_confront":{"id":"thanksgiving_party.no_confront","options":[{"id":"@thanksgiving_party.professor_chen_arrives","title":"And soon Professor Chen arrives."}],"content":{"content":"You look away, ignoring her mother, trying to look as small as possible. Both of them are silent as footsteps pound closer.","type":"paragraph"}},"miri_pageant_prep.miri_what":{"id":"miri_pageant_prep.miri_what","goTo":[{"id":"miri_pageant_prep.miri_ffff"}],"content":{"content":"","type":"paragraph"}},"pageant_final.athletic_results":{"id":"pageant_final.athletic_results","viewIf":{"$code":"return (((Q[\'pageant_appearance\'] || 0) > 6) || ((Q[\'try_on_ball_gown\'] || 0)===1));"},"onArrival":[{"$code":"Q[\'pageant_score\'] = (Q[\'pageant_score\'] || 0) + (Q[\'pageant_appearance\'] || 0);"}],"options":[{"id":"@pageant_final.talent","title":"Talent"}],"content":{"content":[{"type":"paragraph","content":[{"type":"conditional","content":"You do well on the athletic wear section. ","predicate":0},""]},{"type":"paragraph","content":[{"type":"conditional","content":"You do okay on this. ","predicate":1},""]},{"type":"paragraph","content":"Now, you have to change again."}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_appearance\'] || 0) > 10);"}},{"type":"predicate","fn":{"$code":"return (((Q[\'pageant_appearance\'] || 0) <= 10) && ((Q[\'pageant_appearance\'] || 0) > 6));"}}]}},"thanksgiving_party.professor_chen_arrives":{"id":"thanksgiving_party.professor_chen_arrives","options":[{"id":"@thanksgiving_party.coward","title":"You\'re a fucking coward."}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"---, you did this again,\\""}," Professor Chen says. ",{"type":"emphasis-1","content":"\\"You\'re already a man. You shouldn\'t be doing this anymore.\\""},""]},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Qiuyi, we\'re sorry,\\""}," he says to you. ",{"type":"emphasis-1","content":"\\"Go downstairs.\\""},""]},{"type":"paragraph","content":"You look away from them, shrink back into a corner, pretend you aren\'t there, pretend you aren\'t hearing or seeing anything. \\"Um...\\" You\'re dumbfounded. You block out the yelling from your mind. You don\'t hear the shouts, the screaming, Emily\'s voice rising but her parents\' voices rising more, the Chinese profanities you don\'t even understand."},{"type":"paragraph","content":"You close your eyes and only open them when the door slams shut."}]},"miri_pageant_prep.miri_the":{"id":"miri_pageant_prep.miri_the","goTo":[{"id":"miri_pageant_prep.miri_ffff"}],"content":{"content":"","type":"paragraph"}},"pageant_final.talent":{"id":"pageant_final.talent","onArrival":[{"$code":"Q[\'pageant_score\'] = (Q[\'pageant_score\'] || 0) + (3 * (Q[\'pageant_talent\'] || 0));"}],"options":[{"id":"@pageant_final.pageant_wait_for_results","title":"Wait."}],"content":{"content":[{"type":"paragraph","content":"The next section is the talent, another open segment where each of the contestants shows off one of their special talents."},{"type":"paragraph","content":["You play a traditional Chinese tune on the ",{"type":"emphasis-1","content":"erhu"},", a traditional Chinese violin-like instrument. You\'ve changed into a ",{"type":"emphasis-1","content":"qipao"}," for this occasion; apparently the pageant organizers love this sort of thing."]},{"type":"paragraph","content":[{"type":"conditional","content":"Unfortunately you\'re severely out of practice. From the first note, it is clear that you have no idea what you\'re doing. Your only hope is for the novelty of the instrument to sway the judges, or something like that. ","predicate":0}," ",{"type":"conditional","content":"You\'ve only practiced a couple of times in the past few weeks, so you\'re out of practice, but you hope the novelty of the exercise will carry you through. There is no sign from the judges as to your success. ","predicate":1}," ",{"type":"conditional","content":"You\'ve practiced somewhat adequately, enough that you\'ve memorized your piece and can play it through in its entirety, without extremely noticeable errors. ","predicate":2},""]},{"type":"paragraph","content":"Soon enough it\'s over. You change back into your original dress. You\'re shunted back to the waiting room. The pageant is over. Now comes the wait."}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_talent\'] || 0) < 1);"}},{"type":"predicate","fn":{"$code":"return (((Q[\'pageant_talent\'] || 0)===1) || ((Q[\'pageant_talent\'] || 0)===2));"}},{"type":"predicate","fn":{"$code":"return ((Q[\'pageant_talent\'] || 0) > 2);"}}]}},"thanksgiving_party.coward":{"id":"thanksgiving_party.coward","options":[{"id":"@thanksgiving_party.please_dont_1","title":"\\"Wait! Um, please don\'t?\\""},{"id":"@thanksgiving_party.please_dont_2","title":"\\"Wait! Um, please don\'t?\\""}],"content":{"content":"\\"Time to drink bleach,\\" Emily says, her voice flat. She stands up and starts to walk towards the door.","type":"paragraph"}},"miri_pageant_prep.miri_ffff":{"id":"miri_pageant_prep.miri_ffff","options":[{"id":"@miri_pageant_prep.miri_why","title":"\\"Why...?\\""}],"content":[{"type":"paragraph","content":"\\"Um...\\""},{"type":"paragraph","content":"You have no idea how to respond, somewhat more so than usual. Instead you stare off into the distance, as usual. A certain tree is particularly enticing. It is a coniferous tree, whereas the dominant biome around here is broadleaf forest. It looks out of place. Just as you must do."},{"type":"paragraph","content":"\\"Yeah. So that\'s that,\\" Miri says. \\"You don\'t have to like, respond right now or whatever. But, like,...\\""}]},"pageant_final.pageant_wait_for_results":{"id":"pageant_final.pageant_wait_for_results","options":[{"id":"@pageant_final.wave_back","title":"Wave back."},{"id":"@pageant_final.pretend_didnt","title":"Pretend you didn\'t see them."}],"content":{"content":"Now, all the pageant contestants are called back to the stage. The contestants, you among them, stand in a semicircle facing the audience (of course they won\'t let you sit). You look for your family among them. They\'re there. They wave at you.","type":"paragraph"}},"thanksgiving_party.please_dont_1":{"id":"thanksgiving_party.please_dont_1","viewIf":{"$code":"return ((Q[\'has_gown\'] || 0)===0);"},"options":[{"id":"@thanksgiving_party.leave_now","title":"Go downstairs."},{"id":"@thanksgiving_party.leave_later","title":"Stay here, at least for a little while."}],"content":{"content":[{"type":"paragraph","content":"\\"Wait! Um, please don\'t?\\""},{"type":"paragraph","content":"\\"Okay. I was just kidding.\\" She sighs. \\"Fuck. What do I do now.\\" She paces about the room, still wearing her girl clothes. You notice the red in her eyes."},{"type":"paragraph","content":"\\"Sorry...\\""},{"type":"paragraph","content":"\\"What the fuck are you sorry for? If you weren\'t here they would have been way worse.\\""},{"type":"paragraph","content":"Emily sighs before she ducks back into the closet, and emerges in her pajamas again. You hear your mom calling for you from downstairs."},{"type":"paragraph","content":["\\"",{"type":"insert","insert":0},", ",{"type":"emphasis-1","content":"come down!\\""},", she shouts. ",{"type":"emphasis-1","content":"\\"We\'re going to leave now!\\""}]}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"miri_pageant_prep.miri_why":{"id":"miri_pageant_prep.miri_why","options":[{"id":"@miri_pageant_prep.miri_yeah_date","title":"\\"Yeah...?\\""},{"id":"@miri_pageant_prep.miri_maybe_date","title":"\\"Maybe...?\\""},{"id":"@miri_pageant_prep.miri_no_date","title":"\\"Um, sorry but...?\\""},{"id":"@miri_pageant_prep.miri_already_dating","title":"\\"I already...\\""}],"content":[{"type":"paragraph","content":"\\"Why...?\\" is all you manage to say."},{"type":"paragraph","content":"\\"Why what?\\""},{"type":"paragraph","content":"\\"Why do you want to,... you know...\\""},{"type":"paragraph","content":"Miri sighs, and rests her hands on her lap. \\"Okay. Do you need a reason for liking someone? This shit\'s irrational.\\" She picks a dry leaf off the ground. \\"So will you answer me?\\""}]},"pageant_final.wave_back":{"id":"pageant_final.wave_back","goTo":[{"id":"pageant_final.pretend_didnt"}],"content":{"content":"You wave back and smile.","type":"paragraph"}},"thanksgiving_party.please_dont_2":{"id":"thanksgiving_party.please_dont_2","viewIf":{"$code":"return ((Q[\'has_gown\'] || 0)===1);"},"options":[{"id":"@thanksgiving_party.hear_mom","title":"You hear your mom calling for you from downstairs."}],"content":[{"type":"paragraph","content":"\\"Wait! Um, please don\'t?\\""},{"type":"paragraph","content":"\\"Okay. I was just kidding.\\" She sighs. \\"Fuck. What do I do now.\\" She paces about the room, still in her pajamas. You notice the red in her eyes."},{"type":"paragraph","content":"\\"Sorry...\\""},{"type":"paragraph","content":"\\"What the fuck are you sorry for? If you weren\'t here they would have been way worse.\\""},{"type":"paragraph","content":"\\"Oh.\\""}]},"miri_pageant_prep.miri_yeah_date":{"id":"miri_pageant_prep.miri_yeah_date","viewIf":{"$code":"return ((Q[\'emily_date\'] || 0)===0);"},"options":[{"id":"@miri_pageant_prep.miri_yeah_date_2","title":"\\"Actually I like you too...\\""},{"id":"@miri_pageant_prep.miri_maybe_date_2","title":"\\"Maybe I would be...\\""},{"id":"@miri_pageant_prep.miri_no_date_2","title":"\\"I\'m not really interested...\\""}],"content":{"content":"\\"Yeah...\\"","type":"paragraph"}},"pageant_final.pretend_didnt":{"id":"pageant_final.pretend_didnt","options":[{"id":"@pageant_final.pageant_success","title":"And the winner is..."},{"id":"@pageant_final.pageant_fail","title":"And the winner is..."}],"content":{"content":"One of the judges stands up. He starts with all the requisite banalities, talking about how amazing all of the young women here are. How you\'re all special even for getting to this stage, or something like that. He talks a lot. Too much. You\'re tired. You\'re bored.","type":"paragraph"}},"thanksgiving_party.hear_mom":{"id":"thanksgiving_party.hear_mom","options":[{"id":"@thanksgiving_party.leave_now","title":"Go downstairs."},{"id":"@thanksgiving_party.leave_later","title":"Stay here, at least for a little while."}],"content":{"content":{"type":"paragraph","content":["\\"",{"type":"insert","insert":0},", ",{"type":"emphasis-1","content":"come down!\\""},", she shouts. ",{"type":"emphasis-1","content":"\\"We\'re going to leave now!\\""}]},"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"miri_pageant_prep.miri_maybe_date":{"id":"miri_pageant_prep.miri_maybe_date","viewIf":{"$code":"return ((Q[\'emily_date\'] || 0)===0);"},"options":[{"id":"@miri_pageant_prep.miri_yeah_date_2","title":"\\"Actually I like you too...\\""},{"id":"@miri_pageant_prep.miri_maybe_date_2","title":"\\"Maybe I would be...\\""},{"id":"@miri_pageant_prep.miri_no_date_2","title":"\\"I\'m not really interested...\\""}],"content":{"content":"\\"Maybe... \\"","type":"paragraph"}},"pageant_final.pageant_success":{"id":"pageant_final.pageant_success","viewIf":{"$code":"return ((Q[\'pageant_score\'] || 0) >= 50);"},"onArrival":[{"$code":"Q[\'pageant_success\'] = 1;"}],"options":[{"id":"@pageant_final.really_winner","title":"...Really?"}],"content":{"content":{"type":"paragraph","content":["The announcer makes a sweeping arm gesture before announcing. \\"",{"type":"insert","insert":0}," Zhao!\\""]},"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"thanksgiving_party.leave_now":{"id":"thanksgiving_party.leave_now","options":[{"id":"@thanksgiving_party.for_what","title":"\\"For what?\\""}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Okay, wait a little bit!\\""},", you reply."]},{"type":"paragraph","content":"You pack your things and get ready to leave. It\'s far too early. Perhaps Emily\'s parents communicated something about the incident to your parents."},{"type":"paragraph","content":"\\"Um, thanks,\\" Emily says, still in her high voice."}]},"miri_pageant_prep.miri_no_date":{"id":"miri_pageant_prep.miri_no_date","options":[{"id":"@miri_pageant_prep.miri_yeah_date_2","title":"\\"Actually I like you too...\\""},{"id":"@miri_pageant_prep.miri_maybe_date_2","title":"\\"Maybe I would be...\\""},{"id":"@miri_pageant_prep.miri_no_date_2","title":"\\"I\'m not really interested...\\""},{"id":"@miri_pageant_prep.miri_already_dating","title":"\\"I already...\\""}],"content":{"content":"\\"Um, sorry but...\\"","type":"paragraph"}},"pageant_final.really_winner":{"id":"pageant_final.really_winner","options":[{"id":"@pageant_final.cant_believe","title":"It\'s unbelievable."}],"content":{"content":{"type":"paragraph","content":["It\'s you. It\'s really you. Eyes turn in your direction. \\"",{"type":"insert","insert":0}," Zhao, please come up!\\""]},"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"thanksgiving_party.for_what":{"id":"thanksgiving_party.for_what","options":[{"id":"@thanksgiving_party.hug","title":"Somehow this feels like the time for a hug."},{"id":"@thanksgiving_party.leave_for_real","title":"Just leave."}],"content":[{"type":"paragraph","content":"\\"For what?\\""},{"type":"paragraph","content":"\\"Just, for being here, I guess.\\""},{"type":"paragraph","content":"\\"But I didn\'t even do anything.\\""},{"type":"paragraph","content":"\\"Well, I guess I just have low expectations.\\" Emily stands up. \\"God, just don\'t talk about this to anyone. And like, can we just, like, keep talking later?\\""},{"type":"paragraph","content":"\\"Um, sure, I guess.\\" You look at her eyes for a moment before turning away. She stands at almost exactly your height."}]},"miri_pageant_prep.miri_already_dating":{"id":"miri_pageant_prep.miri_already_dating","viewIf":{"$code":"return ((Q[\'emily_date\'] || 0)===1);"},"options":[{"id":"@miri_pageant_prep.tell_miri_about_emily","title":"Tell her..."},{"id":"@miri_pageant_prep.dont_tell_miri_about_emily","title":"Don\'t tell..."}],"content":[{"type":"paragraph","content":"\\"I already... kind of... um, have... something...\\""},{"type":"paragraph","content":"You see Miri looking at you again, eyes wide, smiling broadly for some reason."},{"type":"paragraph","content":"\\"Wait, really?\\", she asks, seemingly surprised."},{"type":"paragraph","content":"\\"It\'s, uh, complicated I guess.\\""},{"type":"paragraph","content":"\\"Would you mind telling me about it?\\""}]},"pageant_final.cant_believe":{"id":"pageant_final.cant_believe","options":[{"id":"@pageant_final.victory","title":"It\'s over. You\'ve won."}],"content":[{"type":"paragraph","content":"It\'s unbelievable. You make small walking motions, but end up having to be led by the host up front. You\'ve forgotten all your pageant postures and facial expressions. They must regret picking you already."},{"type":"paragraph","content":"You don\'t hear much of what follows. The host shakes your hand and puts a sash over you. Your parents run up towards the stage and you run down towards them. Mom hugs you. Dad hugs you both. Kevin joins the cuddle pile. Applause all around, but you barely notice the audience."}]},"thanksgiving_party.hug":{"id":"thanksgiving_party.hug","options":[{"id":"@thanksgiving_party.see_you","title":"\\"Yeah...\\""}],"content":{"content":[{"type":"paragraph","content":"You\'re not habituated to physical contact. Your heart races as you walk next to her and put your arms around her shoulders. She almost jolts backward at first, but she reciprocates, wrapping her arms around you. It\'s a few moments before you let go."},{"type":"paragraph","content":["\\"Uh, thanks... for the hug,\\" Emily says. ",{"type":"conditional","content":"\\"Keep in touch, okay?\\" ","predicate":0},{"type":"conditional","content":"\\"We\'ll meet again, okay?","predicate":1}]}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'meet_emily\'] || 0)===0);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'meet_emily\'] || 0)===1);"}}]}},"miri_pageant_prep.tell_miri_about_emily":{"id":"miri_pageant_prep.tell_miri_about_emily","options":[{"id":"@miri_pageant_prep.tell_miri_about_emily_2","title":"That was weird. Why did you talk like that?"}],"content":{"content":"\\"So, um, like, there\'s this human with whom I happen to be acquainted, and um, we, uh...\\"","type":"paragraph"}},"pageant_final.victory":{"id":"pageant_final.victory","options":[{"id":"@epilogue","title":"Epilogues"}],"content":{"content":"You\'ve won. Mom and dad praise you like never before. Mom is smiling and hugging you all the way home.","type":"paragraph"}},"thanksgiving_party.see_you":{"id":"thanksgiving_party.see_you","options":[{"id":"@thanksgiving_party.leave_for_real","title":"Leave, for real."}],"content":[{"type":"paragraph","content":"\\"Yeah. See you sometime in the, uh, near future I guess.\\""},{"type":"paragraph","content":"\\"And if you dont talk to me I\'ll talk to you whenever I feel like it, okay?\\""},{"type":"paragraph","content":"\\"Yeah, that would be nice.\\""}]},"miri_pageant_prep.tell_miri_about_emily_2":{"id":"miri_pageant_prep.tell_miri_about_emily_2","content":[{"type":"paragraph","content":"That was weird. But you continue anyway. \\"We have, sort of an arrangement I guess. Whereby, uh,... I guess like, neither of us are really ready to be in a relationship right now for family reasons so we might start after graduating. So yeah. Um, sorry.\\""},{"type":"paragraph","content":"Miri is still smiling."},{"type":"paragraph","content":"\\"That sounds complicated and totally in-character, so that\'s great! I\'m happy for you.\\""},{"type":"paragraph","content":"Soon the \\"hanging out\\" session ends in an awkward silence, as usual. The two of you head back to your hometown on the train, leaning against each other as you hold the handrails, buffeted by the evening crowd."}]},"pageant_final.pageant_fail":{"id":"pageant_final.pageant_fail","viewIf":{"$code":"return ((Q[\'pageant_score\'] || 0) < 50);"},"onArrival":[{"$code":"Q[\'pageant_success\'] = 0;"}],"options":[{"id":"@pageant_final.special_award_stem","title":"There\'s an award for STEM excellence..."},{"id":"@pageant_final.no_special_awards","title":"Of course you don\'t win any."}],"content":{"content":"The winner is a name you don\'t remember. You\'ve lost. There is an announcement for the runner-up. Not you. Then there are the special awards.","type":"paragraph"}},"thanksgiving_party.leave_for_real":{"id":"thanksgiving_party.leave_for_real","onArrival":[{"$code":"Q[\'emily\'] = 6;"}],"options":[{"id":"@thanksgiving_party.go_home","title":"As always, it\'s \\"don\'t ask, don\'t tell\\" in the Zhao household."}],"content":{"content":"With that, you pack your backpack and wave Emily goodbye. You feel tears forming in the corner of your eyes, which you try to suppress. When you reach your parents your facial expression is back to normal. They don\'t ask you what\'s wrong, or tell you about what happened with Emily Chen and her parents. Instead they quickly whisk you and your brother into the car. He\'s already asleep.","type":"paragraph"}},"miri_pageant_prep.dont_tell_miri_about_emily":{"id":"miri_pageant_prep.dont_tell_miri_about_emily","content":[{"type":"paragraph","content":"\\"Um, it\'s... I don\'t really want to talk about it. Sorry.\\""},{"type":"paragraph","content":"Miri is still smiling."},{"type":"paragraph","content":"\\"Sure, no problem. I\'m happy for you whatever you want to do.\\""},{"type":"paragraph","content":"Soon the \\"hanging out\\" session ends in an awkward silence, as usual. The two of you head back to your hometown on the train, leaning against each other as you hold the handrails, buffeted by the evening crowd."}]},"pageant_final.special_award_stem":{"id":"pageant_final.special_award_stem","viewIf":{"$code":"return ((((Q[\'pageant_platform\'] || 0) >= 2) && ((Q[\'pageant_appearance\'] || 0) >= 10)) && ((Q[\'pageant_interview\'] || 0) >= 6));"},"onArrival":[{"$code":"Q[\'special_award\'] = 1;"}],"goTo":[{"id":"pageant_final.final"}],"content":{"content":[{"type":"paragraph","content":["\\"And ",{"type":"insert","insert":0}," Zhao, for the award for STEM excellence!\\""]},{"type":"paragraph","content":"You smile and walk up to the host. He hands you a medal. It\'s a consolation prize, but a prize nevertheless. And it comes with a real scholarship."}],"stateDependencies":[{"type":"insert","fn":{"$code":"return (Q[\'first_name\'] || 0);"}}]}},"thanksgiving_party.leave_later":{"id":"thanksgiving_party.leave_later","options":[{"id":"@thanksgiving_party.dont_want_leave","title":"\\"I don\'t know...\\""}],"content":[{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"I\'ll stay here for a little bit!\\""},", you shout."]},{"type":"paragraph","content":"You want to say something to Emily, so you look at her, but you immediately forget what you were going to say. If you even knew in the first place. But maybe Emily can tell how awkward you feel, because she speaks first."},{"type":"paragraph","content":"\\"So, like, you aren\'t going to leave now?\\""},{"type":"paragraph","content":"Normally you would be all too eager to leave these parties, but you don\'t want to leave so soon. You sit on Emily\'s bed, not looking at her, and not wanting to move."}]},"miri_pageant_prep.miri_yeah_date_2":{"id":"miri_pageant_prep.miri_yeah_date_2","viewIf":{"$code":"return ((Q[\'emily_date\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'miri_date\'] = 2;\\nQ[\'loneliness\'] = (Q[\'loneliness\'] || 0) - 2;"}],"options":[{"id":"@miri_pageant_prep.miri_yeah_date_3","title":"\\"Um, okay...\\""}],"content":[{"type":"paragraph","content":"\\"Actually, um, I like you too...\\""},{"type":"paragraph","content":"You see Miri looking at you again, eyes wide, smiling broadly."},{"type":"paragraph","content":"\\"So like, can we like, start dating?\\""},{"type":"paragraph","content":"\\"You mean, like, right now?\\""},{"type":"paragraph","content":"\\"Not like, right now right now. But like, kind of right now?\\""}]},"pageant_final.no_special_awards":{"id":"pageant_final.no_special_awards","viewIf":{"$code":"return ((((Q[\'pageant_platform\'] || 0) < 2) || ((Q[\'pageant_appearance\'] || 0) < 10)) || ((Q[\'pageant_interview\'] || 0) < 6));"},"goTo":[{"id":"pageant_final.final"}],"content":{"content":"Of course you don\'t win any of the special awards.","type":"paragraph"}},"thanksgiving_party.dont_want_leave":{"id":"thanksgiving_party.dont_want_leave","options":[{"id":"@thanksgiving_party.omg","title":"\\"Oh my God. Really?\\""}],"content":{"content":[{"type":"paragraph","content":"\\"I don\'t know... I feel like, I don\'t want to leave right now.\\""},{"type":"paragraph","content":["\\"Oh.\\" She sits on the bed next to you, keeping some distance. ",{"type":"conditional","content":"\\"Hey, wanna talk about the pageant?\\" ","predicate":0},{"type":"conditional","content":"\\"So I heard you were doing a pageant.\\"","predicate":1}]}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'emily\'] || 0) > 0);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'emily\'] || 0)===0);"}}]}},"miri_pageant_prep.miri_yeah_date_3":{"id":"miri_pageant_prep.miri_yeah_date_3","content":[{"type":"paragraph","content":"\\"Um, okay...\\""},{"type":"paragraph","content":"The two of you head back to your hometown on the train, leaning against each other as you hold the handrails, buffeted by the crowd around you, but still sticking together."}]},"pageant_final.final":{"id":"pageant_final.final","options":[{"id":"@epilogue","title":"Epilogues"}],"content":[{"type":"paragraph","content":["It\'s over. Good job, you tried your best, mom says, or something like that. Don\'t worry, dad says, or something like that. I think you did good, Kevin ",{"type":"emphasis-1","content":"di-di"}," says."]},{"type":"paragraph","content":"Your parents take you home in their car."}]},"pageant_final":{"id":"pageant_final","type":"scene","title":"Pageant","subtitle":"This is it.","newPage":true,"viewIf":{"$code":"return ((Q[\'week\'] || 0)===12);"},"onArrival":[{"$code":"Q[\'pageant_score\'] = 0;"}],"priority":3,"tags":["weekend"],"options":[{"id":"@pageant_final.stress_full","title":"But try as you might, you can\'t force yourself up."},{"id":"@pageant_final.preparation","title":"You\'ve tried to get ready for this. Somewhat."}],"content":{"content":"This is it. This is the pageant, the culmination of three months of preparation and a lifetime of anti-preparation.","type":"paragraph"}},"thanksgiving_party.omg":{"id":"thanksgiving_party.omg","options":[{"id":"@thanksgiving_party.thanks_clothes","title":"\\"Thanks...\\""},{"id":"@thanksgiving_party.thanks_clothes_0","title":"\\"Thanks...\\""}],"content":[{"type":"paragraph","content":"You laugh. \\"Oh my God. Really?\\""},{"type":"paragraph","content":"\\"Hey, what\'s wrong?\\""},{"type":"paragraph","content":"\\"It\'s just that... after all that just happened...\\""},{"type":"paragraph","content":"Emily smiles even as she rubs the tears from her eyes. \\"It\'s fine. Here. You need my clothes. And I have to get rid of them before my parents find out. And like, my makeup and stuff too.\\""}]},"miri_pageant_prep.miri_maybe_date_2":{"id":"miri_pageant_prep.miri_maybe_date_2","viewIf":{"$code":"return ((Q[\'emily_date\'] || 0)===0);"},"onArrival":[{"$code":"Q[\'miri_date\'] = 1;"}],"options":[{"id":"@miri_pageant_prep.miri_maybe_date_3","title":"You have no idea what you\'re feeling."}],"content":[{"type":"paragraph","content":"\\"Maybe I would be, um, interested in... that... but, like... maybe not right now?\\""},{"type":"paragraph","content":"You see Miri looking at you again, smiling at least a little."},{"type":"paragraph","content":"\\"So like, what does that mean?\\""},{"type":"paragraph","content":"\\"I\'m not sure... Sorry, I\'m not really sure of anything...\\""},{"type":"paragraph","content":"\\"Hey, that\'s okay. Do you want to forget this conversation ever happened?\\""},{"type":"paragraph","content":"\\"No, it\'s like...\\""}]},"thanksgiving_party.thanks_clothes":{"id":"thanksgiving_party.thanks_clothes","viewIf":{"$code":"return ((Q[\'emily\'] || 0) > 1);"},"onArrival":[{"$code":"Q[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 1;"}],"options":[{"id":"@thanksgiving_party.hug","title":"Somehow this feels like the time for a hug."},{"id":"@thanksgiving_party.leave_for_real","title":"Just leave."}],"content":[{"type":"paragraph","content":"\\"Um, thanks...\\""},{"type":"paragraph","content":"\\"Yeah, no problem. They\'re safer with you than with me. But we\'re gonna have to stay in touch now.\\""},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Zhao Qiuyi, I\'ll say this again, we\'re going to leave now!\\""}," Your mom\'s voice calls again from downstairs."]},{"type":"paragraph","content":"Emily stands next to you, almost close enough to feel her breath. \\"Um...\\""}]},"miri_pageant_prep.miri_maybe_date_3":{"id":"miri_pageant_prep.miri_maybe_date_3","content":[{"type":"paragraph","content":"You sigh, and hold your head. \\"Sorry. Could I think it over for a bit?\\""},{"type":"paragraph","content":"\\"Sure. Thinking is good! Just, don\'t take forever!\\""},{"type":"paragraph","content":"The two of you head back to your hometown on the train, leaning against each other as you hold the handrails, buffeted by the evening crowd."}]},"thanksgiving_party.thanks_clothes_0":{"id":"thanksgiving_party.thanks_clothes_0","viewIf":{"$code":"return ((Q[\'emily\'] || 0) <= 1);"},"onArrival":[{"$code":"Q[\'pageant_appearance\'] = (Q[\'pageant_appearance\'] || 0) + 2;"}],"options":[{"id":"@thanksgiving_party.hug","title":"Somehow this feels like the time for a hug."},{"id":"@thanksgiving_party.leave_for_real","title":"Just leave."}],"content":[{"type":"paragraph","content":"\\"Um, thanks...\\""},{"type":"paragraph","content":"You and Emily go over her clothes. She tells you what each piece is called, when you should wear them, what you should wear them with. She sounds excited, her words so quick that they skip by your ears. Your backpack bulges."},{"type":"paragraph","content":"\\"Where did you get all this?\\", you ask when she finally stops talking."},{"type":"paragraph","content":"\\"Oh, Internet. And, like, goodwill.\\""},{"type":"paragraph","content":[{"type":"emphasis-1","content":"\\"Zhao Qiuyi, I\'ll say this again, we\'re going to leave now!\\""}," Your mom\'s voice calls again from downstairs."]},{"type":"paragraph","content":"Emily stands next to you, almost close enough to feel her breath. \\"Um...\\""}]},"miri_pageant_prep.miri_no_date_2":{"id":"miri_pageant_prep.miri_no_date_2","onArrival":[{"$code":"Q[\'miri_date\'] = -1;\\nQ[\'loneliness\'] = (Q[\'loneliness\'] || 0) + 1;"}],"options":[{"id":"@miri_pageant_prep.miri_no_date_3","title":"\\"Sorry...\\""}],"content":[{"type":"paragraph","content":"\\"I\'m not really interested in, um,... that... right now. Sorry.\\""},{"type":"paragraph","content":"\\"Oh.\\""},{"type":"paragraph","content":"Neither of you are looking at each other, or speaking. The tree is still present in your field of vision. It is still a coniferous tree. You wish you could name the species or the genus."},{"type":"paragraph","content":"It is Miri who breaks the silence."},{"type":"paragraph","content":"\\"Yeah. I guessed that was the case.\\""}]},"thanksgiving_party.go_home":{"id":"thanksgiving_party.go_home","options":[{"id":"@thanksgiving_party.final_party","title":"Close your eyes."}],"content":{"content":"Your mind churns during the car ride home, but you feel incapable of thinking, unable to focus on any idea in particular. So you just... exist, or something like that. So you let the world pass by. Nothing feels real. But then you arrive home, back to your bed and desk and computer and Kevin\'s toys strewn about. And it\'s real and it all exists and you exist and so does Emily and...","type":"paragraph"}},"miri_pageant_prep.miri_no_date_3":{"id":"miri_pageant_prep.miri_no_date_3","content":[{"type":"paragraph","content":"\\"Sorry...\\""},{"type":"paragraph","content":"\\"No. It\'s not your fault.\\""},{"type":"paragraph","content":"\\"Uh... we\'re still friends, right?\\""},{"type":"paragraph","content":"\\"Yeah. Of course.\\""},{"type":"paragraph","content":"It is over. You ride the train back together to your hometown, but become separated amidst the crowds."}]},"miri_pageant_prep":{"id":"miri_pageant_prep","type":"scene","title":"Pageant prep with Miri","subtitle":"After school","newPage":true,"viewIf":{"$code":"return ((((((((((Q[\'week\'] || 0) >= 1) && ((Q[\'week_progress\'] || 0) < 3)) && ((Q[\'miri\'] || 0) >= 1)) && ((Q[\'weekly_miri\'] || 0)===0)) && ((Q[\'stress\'] || 0) < 15)) && ((Q[\'miri_date\'] || 0)===0)) && ((Q[\'class_visited\'] || 0)===1)) && ((Q[\'miri_escape\'] || 0)===0)) && ((Q[\'week\'] || 0) < 10));"},"onArrival":[{"$code":"Q[\'week_progress\'] = (Q[\'week_progress\'] || 0) + 1;\\nQ[\'weekly_miri\'] = 1;\\nQ[\'miri\'] = (Q[\'miri\'] || 0) + 1;\\nQ[\'stress\'] = (Q[\'stress\'] || 0) + 1;"}],"tags":["top","pageant_prep"],"options":[{"id":"@miri_pageant_prep.gym_1","title":"Go to the gym."},{"id":"@miri_pageant_prep.gym_visit_2","title":"Go to the gym again."},{"id":"@miri_pageant_prep.practice","title":"Have a practice interview."},{"id":"@miri_pageant_prep.practice_2","title":"Have another practice interview."},{"id":"@miri_pageant_prep.hang","title":"Just hang out?"},{"id":"@miri_pageant_prep.hang_2","title":"Just hang out again?"}],"content":{"content":[{"type":"paragraph","content":[{"type":"conditional","content":"Miri: hey, if you want to do some stuff for the pageant, i\'m free today. tell me if you wanna go anywhere, okay? ","predicate":0},""]},{"type":"paragraph","content":[{"type":"conditional","content":"Miri: hey, if you want to do some stuff for the pageant, i\'m free today. i just wanted an excuse to get away from my family for a bit. it gets messy here lol. ","predicate":1},""]},{"type":"paragraph","content":"You read over the message. Miri was extremely generous in offering to help you prepare for the pageant, for reasons you still do not entirely understand. She offered a few suggestions for things you could do. You will not let her generosity go to waste."}],"stateDependencies":[{"type":"predicate","fn":{"$code":"return ((Q[\'miri\'] || 0) <= 1);"}},{"type":"predicate","fn":{"$code":"return ((Q[\'miri\'] || 0) > 1);"}}]}},"thanksgiving_party.final_party":{"id":"thanksgiving_party.final_party","content":{"content":"","type":"paragraph"}},"thanksgiving_party":{"id":"thanksgiving_party","type":"scene","title":"Thanksgiving Party","subtitle":"The Chen Household","newPage":true,"viewIf":{"$code":"return ((Q[\'week\'] || 0)===6);"},"onArrival":[{"$code":"Q[\'thanksgiving\'] = 1;"}],"tags":["weekend"],"options":[{"id":"@thanksgiving_party.know_prof","title":"Of course, you know him from your research."},{"id":"@thanksgiving_party.someone","title":"He\'s apparently an academic bigwig or something like that."}],"content":{"content":"It\'s 4:30 PM, and the sun is already starting to fall as your parents pack your brother and you into their gray Toyota Camry. This year the annual \\"Dongbei Laoxiang\\" Thanksgiving party is hosted at Professor Song Chen\'s house, a thirty minute drive.","type":"paragraph"}}},"qualities":{},"qdisplays":{},"tagLookup":{"epilogue":{"credits_and_notes":true,"achievements":true},"ending":{"ending_pageant_success":true,"ending_pageant_failure":true,"epilogue":true},"top":{"1":true,"ending_pageant_success":true,"ending_pageant_failure":true,"family_1":true,"weekend_1":true,"weekend_after_christmas":true,"weekend_final":true,"weekend_pre_christmas":true,"research_pass":true,"stress_1":true,"pageant_prep_self_final":true,"research_2":true,"research_5":true,"scioly_1":true,"scioly_pass":true,"christmas_break":true,"stress_full":true,"stress_2":true,"research_3":true,"family_3":true,"family_2":true,"family_final":true,"family_4":true,"introspect_3":true,"emily_3_online":true,"family_5":true,"research_4":true,"introspect_2":true,"emily_2":true,"research_6":true,"research_1":true,"family_6":true,"introspect_1":true,"scioly_final":true,"classes_1":true,"emily_4":true,"emily_final":true,"epilogue":true,"pageant_prep_self_2":true,"emily_1":true,"research_final":true,"aubrey_final":true,"emily_7":true,"pageant_meetup":true,"skip":true,"emily_6":true,"miri_date":true,"scioly_study_party":true,"scioly_2":true,"christmas_party":true,"miri_pageant_prep":true},"family":{"family_1":true,"family_3":true,"family_2":true,"family_final":true,"family_4":true,"family_5":true,"family_6":true},"enter_weekend":{"weekend_1":true,"weekend_after_christmas":true,"weekend_final":true,"weekend_pre_christmas":true},"research":{"research_pass":true,"research_2":true,"research_5":true,"research_3":true,"research_4":true,"research_6":true,"research_1":true,"research_final":true},"stress":{"stress_1":true,"stress_full":true,"stress_2":true},"weekend":{"weekend_alone":true,"church_2":true,"church_3":true,"shopping_with_mom":true,"church_1":true,"aubrey_final":true,"birthday":true,"scioly_invitational":true,"scioly_study_party":true,"pageant_final":true,"thanksgiving_party":true},"pageant_prep":{"1":true,"pageant_prep_self_final":true,"classes_1":true,"pageant_prep_self_2":true,"pageant_meetup":true,"miri_pageant_prep":true},"scioly":{"scioly_1":true,"scioly_pass":true,"scioly_final":true,"scioly_2":true},"christmas":{"christmas_break":true,"christmas_party":true},"loneliness":{"loneliness_1":true,"loneliness_2":true},"introspect":{"introspect_3":true,"introspect_2":true,"introspect_1":true},"social":{"emily_3_online":true,"emily_2":true,"emily_4":true,"emily_final":true,"emily_1":true,"aubrey_final":true,"emily_7":true,"emily_6":true},"aubrey":{"aubrey_final":true},"debug":{"skip":true},"miri":{"miri_date":true}}}'
},function e(t,a,o){function n(r,s){if(!a[r]){if(!t[r]){var p="function"==typeof require&&require;if(!s&&p)return p(r,!0);if(i)return i(r,!0);var h=new Error("Cannot find module '"+r+"'");throw h.code="MODULE_NOT_FOUND",h}var l=a[r]={exports:{}};t[r][0].call(l.exports,function(e){var a=t[r][1][e];return n(a?a:e)},l,l.exports,e,t,a,o)}return a[r].exports}for(var i="function"==typeof require&&require,r=0;r<o.length;r++)n(o[r]);return n}({1:[function(e,t,a){!function(){"use strict";var e=function(e){if(!e)throw new Error("Assertion failed.")},a=function(e,t){for(var a=0;a<e.length;++a)t(e[a])},o=function(e,t){for(var a in e)t(a,e[a])},n=function(){for(var e={},t=0;t<arguments.length;++t){var a=arguments[t];for(var o in a)e[o]=a[o]}return e},i=function(e){var t=typeof e;return"function"===t||e&&"object"===t||!1},r=function(e){e=e.trim();var t=new Function("state","Q",e);return t.source=e,t},s=function(e,t,o){void 0!==e&&a(e,function(e){try{e.call(t,o,o.qualities)}catch(a){}})},p=function(e,t,a,o){var n=t;if(void 0===e)return n;try{n=!!e.call(a,o,o.qualities)}catch(i){}return n},h=function(e,t,a,o){var n=t;if(void 0===e)return n;try{n=e.call(a,o,o.qualities)}catch(i){}return n},l=function(e,t){var a=function(e,t){return i(t)&&void 0!==t.$code?r(t.$code):t};try{var o=JSON.parse(e,a);return t(null,o)}catch(n){return t(n)}},y=function(e){return[{type:"paragraph",content:e}]},c=function(e){return Math.floor(e)===e&&e>=0&&12>=e?["zero","one","two","three","four","five","six","seven","eight","nine","ten","eleven","twelve"][e]:e.toString()},u=function(e){if(!(Math.floor(e)===e&&e>=0))return e.toString();if(12>=e)return["zeroth","first","second","third","fourth","fifth","sixth","seventh","eighth","ninth","tenth","eleventh","twelfth"][e];if(e=e.toString(),/1[0-9]$/.test(e))return e+"th";var t=e.substr(e.length-1,1);switch(t){case"1":return e+"st";case"2":return e+"nd";case"3":return e+"rd";default:return e+"th"}},d=function(e){if(Math.floor(e)!==e)return e.toString();if(e>3)return"superb+"+(e-3);if(-3>e)return"terrible"+(e+3);switch(e){case 3:return"superb";case 2:return"great";case 1:return"good";case 0:return"fair";case-1:return"mediocre";case-2:return"poor";case-3:return"terrible"}},g=function(e,t){for(var a=0;a<t.content.length;++a){var o=t.content[a],n=o.min,i=o.max;if((void 0===n||e>=n)&&(void 0===i||i>=e))return void 0!==o.output?o.output:e.toString()}return e.toString()},m=function(){};m.prototype.beginGame=function(){},m.prototype.displayContent=function(e){},m.prototype.displayChoices=function(e){},m.prototype.displayGameOver=function(){this.displayContent(y("Game Over"))},m.prototype.removeChoices=function(){},m.prototype.beginOutput=function(){},m.prototype.endOutput=function(){},m.prototype.newPage=function(){},m.prototype.setStyle=function(e){},m.prototype.signal=function(e){},m.makeParentOf=function(e){e.prototype=new m,e.constructor=e};var _=function(e,t){this.ui=e,this.game=t};_.prototype.displayGameOver=function(){return this.ui.displayGameOver(),this},_.prototype.displayChoices=function(){var t=this.getCurrentChoices();return e(t),this.ui.displayChoices(t),this},_.prototype.displaySceneContent=function(){var t=this.getCurrentScene();e(t);var a=t.signal||this.game.sceneSignal;if(void 0!==a&&this.ui.signal({signal:a,event:"scene-display",id:this.state.sceneId}),t.newPage&&(this.ui.newPage(),this.state.currentContent=[]),this.ui.setStyle(t.style),this.ui.removeChoices(),this._runActions(t.onDisplay),void 0!==t.content){var o=this._makeDisplayContent(t.content,!0);this.state.currentContent=this.state.currentContent.concat(o),this.ui.displayContent(o)}return this},_.prototype.choose=function(t){var a=this.choiceCache;if(e(a),a.length<=t)throw new Error("No choice at index "+t+", only "+a.length+" choices are available.");var o=a[t];if(!o.canChoose)throw new Error("Attempted to choose index "+t+", but that choice is unavailable.");var n=o.id;return delete this.choiceCache,this.goToScene(n),this},_.prototype.goToScene=function(e){this.state.sceneIdsSinceGoTo=[],this.ui.beginOutput(),this.__changeScene(e),this.ui.endOutput()},_.prototype.beginGame=function(e){this.random=e?w.fromSeeds(e):w.fromUnique(),this.state={sceneId:null,sceneIdsSinceGoTo:[],rootSceneId:this.game.rootScene||this.game.firstScene||"root",gameOver:!1,visits:{},qualities:{},currentRandomState:null,currentContent:[]},this._setUpQualities(),this.ui.beginGame();var t=this.game.firstScene||this.state.rootSceneId;return this.goToScene(t),this},_.prototype.gameOver=function(){return this.state.gameOver=!0,this.displayGameOver(),this},_.prototype.isGameOver=function(){return this.state.gameOver},_.prototype.getCurrentScene=function(){var t=this.game.scenes[this.state.sceneId];return e(void 0!==t),t},_.prototype.getCurrentChoices=function(){return this.choiceCache},_.prototype.setState=function(e){if(this.state=e,this._setUpQualities(),this.random=w.fromState(this.state.currentRandomState),this.isGameOver())this.displayGameOver();else{var t=this.getCurrentScene();this.choiceCache=this._compileChoices(t),this.ui.newPage(),this.ui.removeChoices(),this.ui.displayContent(this.state.currentContent),this.displayChoices()}return this},_.prototype.getExportableState=function(){return this.state},_.prototype._getQDisplay=function(t,a){switch(a){case"cardinal":case"number":return c(t);case"ordinal":return u(t);case"fudge":return d(t);default:var o=this.game.qdisplays[a];return e(void 0!==o),g(t,o)}},_.prototype._evaluateStateDependencies=function(t){for(var a=[],o=0;o<t.length;++o){var n,i=t[o],r=i.fn;switch(i.type){case"insert":n=this._runExpression(r),n=i.qdisplay?this._getQDisplay(n,i.qdisplay):n.toString();break;default:e("predicate"===i.type),n=this._runPredicate(r)}void 0!==n.stateDependencies&&(n=this._makeDisplayContent(n,!1)),a.push(n)}return a},_.prototype._mergeStateEvalsInArray=function(e,t){Array.isArray(e)||(e=[e]);for(var a=[],o=0;o<e.length;++o)a=a.concat(this._mergeStateEvals(e[o],t));return a},_.prototype._mergeStateEvals=function(e,t){if(void 0===e.type)return[e];var a;switch(e.type){case"conditional":a=t[e.predicate]?this._mergeStateEvalsInArray(e.content,t):[];break;case"insert":a=t[e.insert];break;default:var o={type:e.type};o.content=this._mergeStateEvalsInArray(e.content,t),a=[o]}return a},_.prototype._makeDisplayContent=function(e,t){if(void 0===e.content)return Array.isArray(e)?e:t?[{type:"paragraph",content:e}]:[e];if(void 0===e.stateDependencies&&void 0!==e.type)return[e];var a=e.stateDependencies,o=e.content;if(a&&a.length>0){var n=this._evaluateStateDependencies(a);Array.isArray(o)||(o=[o]),o=this._mergeStateEvalsInArray(o,n)}return o},_.prototype._setUpQualities=function(){var e=this._qualitiesAccessorsPrivate={},t=this.state.qualities,a=this;o(this.game.qualities,function(o,n){var i=n.min,r=n.max,s=n.signal||a.game.qualitySignal,p=n.isValid,h=void 0!==i||void 0!==r||void 0!==s||void 0!==p;h&&(void 0!==t[o]&&(e[o]=t[o]),t.__defineGetter__(o,function(){return e[o]}),t.__defineSetter__(o,function(t){void 0!==i&&i>t&&(t=i),void 0!==r&&t>r&&(t=r);var n=e[o];if(e[o]=t,a._runPredicate(p,!0)||(e[o]=t=n),void 0!==s&&t!==n){var h={signal:s,event:"quality-change",id:o,now:t};void 0!==n&&(h.was=n),a.ui.signal(h)}})),void 0!==n.initial&&void 0===t[o]&&(t[o]=n.initial)})},_.prototype._runActions=function(e){s(e,this,this.state)},_.prototype._runPredicate=function(e,t){return p(e,t,this,this.state)},_.prototype._runExpression=function(e,t){return h(e,t,this,this.state)},_.prototype.__changeScene=function(t){var a=this.game.scenes[t];e(a);var o=this.state.sceneId;if(o){var n=this.getCurrentScene();this._runActions(n.onDeparture);var i=n.signal||this.game.sceneSignal;void 0!==i&&this.ui.signal({signal:i,event:"scene-departure",id:this.state.sceneId,to:t})}this.state.sceneId=t,this.state.sceneIdsSinceGoTo.push(t),a.setRoot&&(this.state.rootSceneId=t),void 0!==a.countVisitsMax&&(void 0===this.state.visits[t]?this.state.visits[t]=1:this.state.visits[t]<a.countVisitsMax&&this.state.visits[t]++),this._runActions(a.onArrival);var r=a.signal||this.game.sceneSignal;if(void 0!==r){var s={signal:r,event:"scene-arrival",id:t};o&&(s.from=o),this.ui.signal(s)}this.state.currentRandomState=this.random.getState(),this.displaySceneContent();var p=!1;if(a.gameOver===!0)p=!0,this.gameOver();else if(a.goTo){for(var h=[],l=0;l<a.goTo.length;++l){var y=a.goTo[l];(void 0===y.predicate||this._runPredicate(y.predicate))&&h.push(y.id)}if(1===h.length)p=!0,this.__changeScene(h[0]);else if(h.length>1){var c=this.random.uint32(),u=c%h.length,d=h[u];p=!0,this.__changeScene(d)}}p||(this.choiceCache=this._compileChoices(a),null===this.choiceCache?a.gameOver!==!1&&this.gameOver():this.displayChoices())},_.prototype.__getChoiceSelectionData=function(e){var t=[];for(var a in e){var o=this.game.scenes[a],n=e[a];n.order=n.order||o.order||0,n.priority=n.priority||o.priority||1,void 0===n.frequency&&(n.frequency=o.frequency,void 0===n.frequency&&(n.frequency=100)),n.selectionPriority=0,t.push(n)}return t},_.prototype.__filterViewable=function(e){var t={};for(var a in e){var o=this.game.scenes[a],n=o.maxVisits;if(void 0!==n){var i=this.state.visits[a]||0;if(i>=n)continue}var r=this._runPredicate(o.viewIf,!0);r&&(t[a]=e[a])}return t},_.prototype.__getChoiceIdsFromOptions=function(t){var i=this,r={};return a(t,function(t){if(i._runPredicate(t.viewIf,!0))if("@"===t.id.substr(0,1)){var a=t.id.substring(1),s=n(t,{id:a});r[a]=s}else{e("#"===t.id.substr(0,1));var p=i.game.tagLookup[t.id.substring(1)];o(p,function(e){void 0===r[e]&&(r[e]=n(t,{id:e}))})}}),r},_.prototype.__filterByPriority=function(t,o,n){e(null===o||null===n||n>=o);var i,r=this,s=[],p=[];t.sort(function(e,t){return t.priority-e.priority});for(var h,l=0;l<t.length;++l){if(i=t[l],i.priority!==h){if(void 0!==h&&(null===o||l>=o))break;s.push.apply(s,p),p=[],h=i.priority}p.push(i)}var y=s.length,c=y+p.length;if(null===n||n>=c)s.push.apply(s,p);else{a(p,function(e){null===e.frequency?e.selectionPriority=0:e.selectionPriority=r.random.random()/e.frequency}),p.sort(function(e,t){return e.selectionPriority-t.selectionPriority});var u=n-y,d=p.slice(0,u);s.push.apply(s,d)}return s},_.prototype.__getChoiceDisplayData=function(t){for(var a=[],o=0,n=0;n<t.length;++n){var i=t[n],r=this.game.scenes[i.id],s=!0;i.chooseIf&&(s=this._runPredicate(i.chooseIf,!0)),s&&r.chooseIf&&(s=this._runPredicate(r.chooseIf,!0));var p=i.title||r.title;e(p);var h=null;s||(h=i.unavailableSubtitle||r.unavailableSubtitle),h||(h=i.subtitle||r.subtitle);var l={id:i.id,canChoose:s,title:this._makeDisplayContent(p,!1)};h&&(l.subtitle=this._makeDisplayContent(h,!1)),a.push(l),s&&++o}return{choices:a,numChoosable:o}},_.prototype._compileChoices=function(t){e(t);var a=t.options,o=[],n=0;if(void 0!==a){var i=this.__getChoiceIdsFromOptions(a);i=this.__filterViewable(i);var r=this.__getChoiceSelectionData(i),s=t.minChoices||null,p=t.maxChoices||null;r=this.__filterByPriority(r,s,p),r.sort(function(e,t){return e.order-t.order});var h=this.__getChoiceDisplayData(r);o=h.choices,n=h.numChoosable}if(0===n){var l=this.state.rootSceneId;if(l!==this.state.sceneId){var y=this.game.scenes[l].chooseIf;(!y||this._runPredicate(y,!0))&&(o.push({id:l,title:"Continue...",canChoose:!0}),++n)}}return n>0?o:null};var w=function(e,t,a,o,n){this.getState=function(){return[e,t,a,o,n]};var i=function(e,t){var a=e>>16&65535,o=65535&e,n=t>>16&65535,i=65535&t,r=a*i+o*n&65535;return(r<<16>>>0)+o*i};this.uint32=function(){var r=(a^a>>>7)>>>0;return a=o,o=n,n=t,t=e,e=e^e<<6^(r^r<<13)>>>0,i(o+o+1,e)>>>0},this.random=function(){return 2.3283064365386963e-10*this.uint32()}},f=1;w.fromUnique=function(){var e=(new Date).getTime();return w.fromSeeds([e,f++])},w.fromTime=function(){return w.fromSeeds([(new Date).getTime()])},w.fromSeeds=function(e){for(var t=886756453,a=88675123,o=123456789,n=362436069,i=521288629,r=function(e){e=e.toString();for(var t=4022871197,a=0;a<e.length;a++){t+=e.charCodeAt(a);var o=.02519603282416938*t;t=o>>>0,o-=t,o*=t,t=o>>>0,o-=t,t+=4294967296*o}return 2.3283064365386963e-10*(t>>>0)},s=0;s<e.length;s++){var p=4294967296*r(e[s]);t^=p,a^=p,o^=p,n^=p,i^=p}return new w(t,a,o,n,i)},w.fromState=function(e){return new w(e[0],e[1],e[2],e[3],e[4])},t.exports={makeFunctionFromSource:r,runActions:s,runPredicate:p,runExpression:h,convertJSONToGame:l,simpleContent:y,getCardinalNumber:c,getOrdinalNumber:u,getUserQDisplay:g,getFudgeDisplay:d,DendryEngine:_,UserInterface:m,NullUserInterface:m,Random:w}}()},{}],2:[function(e,t,a){!function(t){"use strict";var a=e("./content/html"),o=e("../engine"),n=function(e,t){this.game=e,this.$content=t,this._registerEvents(),this.dendryEngine=new o.DendryEngine(this,e)};o.UserInterface.makeParentOf(n),n.prototype.displayContent=function(e){var t=a.convert(e);this.$content.append(t)},n.prototype.displayGameOver=function(){var e=t("<p>").text(this.getGameOverMsg()).addClass("game-over");this.$content.append(e)},n.prototype.displayChoices=function(e){for(var o=t("<ul>").addClass("choices"),n=0;n<e.length;++n){var i,r=e[n],s=a.convertLine(r.title);void 0!==r.subtitle&&(i=a.convertLine(r.subtitle));var p=t("<li>"),h=p;r.canChoose?(h=t("<a>").attr({href:"#","data-choice":n}),p.html(h)):h.addClass("unavailable"),h.html(s),i&&p.append(t("<div>").addClass("subtitle").html(i)),o.append(p)}this.$content.append(o)},n.prototype.newPage=function(){this.$content.empty()},n.prototype.setStyle=function(e){this.$content.removeClass(),void 0!==e&&this.$content.addClass(e)},n.prototype.removeChoices=function(){t(".choices",this.$content).remove(),t(".hidden",this.$content).remove()},n.prototype.beginOutput=function(){t("#read-marker",this.$content).remove(),this.$content.append(t("<div>").attr("id","read-marker"))},n.prototype.endOutput=function(){var e=t("#read-marker");e.length>0},n.prototype.displayBackground=function(e){},n.prototype.removeBackground=function(){},n.prototype.displaySideImage=function(e,t,a){},n.prototype.removeSideImage=function(e){},n.prototype.removeAllImages=function(){},n.prototype.getGameOverMsg=function(){return"Game Over (reload to read again)"},n.prototype._registerEvents=function(){var e=this;this.$content.on("click","ul.choices li a",function(a){a.preventDefault(),a.stopPropagation();var o=parseInt(t(this).attr("data-choice"));return e.dendryEngine.choose(o),!1}),this.$content.on("click","ul.choices li",function(e){return e.preventDefault(),e.stopPropagation(),t("a",this).click(),!1})};var i=function(){o.convertJSONToGame(window.game.compiled,function(e,a){if(e)throw e;var o=new n(a,t("#content"));if(window.dendryUI=o,void 0!==window.dendryModifyUI){var i=window.dendryModifyUI(o);if(i)return}o.dendryEngine.beginGame()})};t(i)}(jQuery)},{"../engine":1,"./content/html":3}],3:[function(e,t,a){!function(){"use strict";var e=function(e){if(void 0===e.type)return e;switch(e.type){case"emphasis-1":return"<em>"+a(e.content)+"</em>";case"emphasis-2":return"<strong>"+a(e.content)+"</strong>";case"hidden":return'<span class="hidden">'+a(e.content)+"</span>";case"line-break":return"<br>";case"insert":case"conditional":throw new Error(e.type+" should have been evaluated by now.")}},a=function(t){if(Array.isArray(t)){for(var a=[],o=0;o<t.length;++o){var n=t[o];a.push(e(n))}return a.join("")}return e(t)},o=function(e){for(var t=[],o=0;o<e.length;++o){var n=e[o];switch(n.type){case"heading":t.push("<h1>"),t.push(a(n.content)),t.push("</h1>");break;case"paragraph":t.push("<p>"),t.push(a(n.content)),t.push("</p>");break;case"quotation":t.push("<blockquote>"),t.push(a(n.content)),t.push("</blockquote>");break;case"attribution":t.push('<blockquote class="attribution">'),t.push(a(n.content)),t.push("</blockquote>");break;case"hrule":t.push("<hr>")}}return t.join("")};t.exports={convert:o,convertLine:a}}()},{}]},{},[2]);