var selectSizeWithoutStatus = 8;
var selectSizeWithStatus = 6;
var numCommands = 0;
var thisCommand = 0;
var commandsList = new Array();
var tmrTick = null;
var tickCount = 0;
var sendNextGameTickerAfter = 0;
var verbButtonCount = 9;
var commandLog = null;
//JS
var is_asl_event=false;
function init() {
	var smusic = getStorage("music");
	if (smusic===null)
		$("#soundMenu").modal({backdrop: 'static',keyboard: false});
	else
		init2(null);
}
function init2(sound) {
    
	if (sound) {
		setStorage("music","on");
		music_on=true;
	} else if (sound===false) {
		setStorage("music","off");
		music_on=false;
	}
    showStatusVisible(false);

    $("#button-restart").button().click(function () {
        $("#button-restart").removeClass("ui-state-focus ui-state-hover");
        uiDoRestart();
    });
    $("#button-undo").button().click(function () {
        $("#button-undo").removeClass("ui-state-focus ui-state-hover");
        uiDoUndo();
    });
    $("#button-wait").button().click(function () {
        $("#button-wait").removeClass("ui-state-focus ui-state-hover");
        uiDoWait();
    });
        $("#button-options").button().click(function () {
        $("#button-options").removeClass("ui-state-focus ui-state-hover");
        $("#gameMore").hide();
        $("#gameOptions").show();
    });
    $("#fontOptions").change(function () {
        var newFont = $("#fontOptions option:selected").text();
        $("#divOutput div span").css("font-family", newFont);
        $("#fontSample").css("font-family", newFont);
        currentFont = newFont;
        set(GetObject("game"), "defaultfont", newFont);
        saveGame();
    });
    $("#fontSize").change(function () {
        var newFontSize = $("#fontSize option:selected").val();
        $("#divOutput div span").css("font-size", newFontSize + "pt");
        $("#fontSample").css("font-size", newFontSize + "pt");
        currentFontSize = newFontSize;
        set(GetObject("game"), "defaultfontsize", parseInt(newFontSize));
        saveGame();
    });

    $(document).on("click", ".elementmenu", function (event) {
        if (!$(this).hasClass("disabled")) {
            event.preventDefault();
            event.stopPropagation();
            // TO DO
			//$(this).jjmenu_popup();
			bindMenuEl($(this));
			//--
			$(this).click();
        		
			//--
            //$(this).blur();
            return false;
        }
    });

    $(document).on("click", ".exitlink", function () {
        if (!$(this).hasClass("disabled")) {
            sendCommand($(this).data("command"));
        }
    });

    $(document).on("click", ".commandlink", function () {
        var $this = $(this);
        if (!$this.hasClass("disabled") && canSendCommand) {
            if ($this.data("deactivateonclick")) {
                $this.addClass("disabled");
                $this.data("deactivated", true);
            }
            sendCommand($this.data("command"));
        }
    });

    worldmodelInitialise();
    if (!loadGame_()) {
        worldModelBeginGame();
    }
}

function extLink(url) {
    window.open(url, "_system");
}

function showStatusVisible(visible) {
    if (visible) {
        $("#statusVars").show();
        $("#statusLabel").show();
    }
    else {
        $("#statusVars").hide();
        $("#statusLabel").hide();
    }
}

var beginningOfCurrentTurnScrollPosition = 0;
var scrollTimeout = null;

function scrollToEnd() {
    if (scrollTimeout != null) {
        clearTimeout(scrollTimeout);
    }

    scrollTimeout = setTimeout(function () {
        scrollTimeout = null;
        scrollToEndNow();
    }, 200);
}

function scrollToEndNow() {
    $('html, body').animate({ scrollTop: beginningOfCurrentTurnScrollPosition - 30 }, 200);
}

function updateLocation(text) {
}

var _waitMode = false;
var _pauseMode = false;
var _waitingForSoundToFinish = false;

var waitButtonId = 0;

function beginWait() {
    if (runningWalkthrough) {
        awaitingCallback = false;
        waitCallback();
        TryFinishTurn();
        return;
    }
    _waitMode = true;
    waitButtonId++;
    addText("<a class=\"cmdlink\" style=\"color:" + currentLinkForeground + ";font-family:" + currentFont + ";font-size:" + currentFontSize + "pt;\" id=\"waitButton" + waitButtonId + "\" >Continue...</a><br/><br/>");
    $("#waitButton" + waitButtonId).click(function () {
        _waitMode = false;
        $(this).hide();
        $("#divCommand").show();
        beginningOfCurrentTurnScrollPosition = $("#gameContent").height();
        window.setTimeout(function () {
            awaitingCallback = false;
            waitCallback();
            TryFinishTurn();
        }, 100);
    });
    $("#divCommand").hide();
}

function beginPause(ms) {
    _pauseMode = true;
    $("#divCommand").hide();
    window.setTimeout(function () {
        endPause()
    }, ms);
}

function endPause() {
    _pauseMode = false;
    $("#divCommand").show();
    window.setTimeout(function () {
        // TO DO
        //$("#fldUIMsg").val("endpause");
        //$("#cmdSubmit").click();
    }, 100);
}

function globalKey(e) {
    if (_waitMode) {
        endWait();
        return;
    }
}

function commandKey(e) {
    switch (keyPressCode(e)) {
        case 13:
            runCommand();
            return false;
        case 38:
            thisCommand--;
            if (thisCommand == 0) thisCommand = numCommands;
            $("#txtCommand").val(commandsList[thisCommand]);
            break;
        case 40:
            thisCommand++;
            if (thisCommand > numCommands) thisCommand = 1;
            $("#txtCommand").val(commandsList[thisCommand]);
            break;
        case 27:
            thisCommand = numCommands + 1;
            $("#txtCommand").val("");
            break;
    }
}

function runCommand() {
    var command = $("#txtCommand").val();
    if (command.length > 0) {
        numCommands++;
        commandsList[numCommands] = command;
        thisCommand = numCommands + 1;
        sendCommand(command);
        $("#txtCommand").val("");
    }
}

function prepareCommand(command) {
    // TO DO
    //$("#fldUITickCount").val(getTickCountAndStopTimer());
    //$("#fldUIMsg").val("command " + command);
}

function showQuestion(title) {
    $("#msgboxCaption").html(title);

    var msgboxOptions = {
        modal: true,
        autoOpen: false,
        buttons: [
            {
                text: "Yes",
                click: function () { msgboxSubmit("yes"); }
            },
            {
                text: "No",
                click: function () { msgboxSubmit("no"); }
            }
        ],
        closeOnEscape: false,
        open: function (event, ui) { $(".ui-dialog-titlebar-close").hide(); }    // suppresses "close" button
    };

    $("#msgbox").dialog(msgboxOptions);
    $("#msgbox").dialog("open");
}

function msgboxSubmit(text) {
    $("#msgbox").dialog("close");
    window.setTimeout(function () {
        // TO DO
        //$("#fldUIMsg").val("msgbox " + text);
        //$("#cmdSubmit").click();
    }, 100);
}

var _menuSelection = "";

function showMenu(title, options, allowCancel) {
    $("#dialogOptions").empty();
    $.each(options, function (key, value) {
        $("#dialogOptions").append(
            $("<option/>").attr("value", key).text(value)
        );
    });

    $("#dialogCaption").html(title);

    var dialogOptions = {
        modal: true,
        autoOpen: false,
        buttons: [{
            text: "Select",
            click: function () { dialogSelect(); }
        }]
    };

    if (allowCancel) {
        dialogOptions.buttons = dialogOptions.buttons.concat([{
            text: "Cancel",
            click: function () { dialogCancel(); }
        }]);
        dialogOptions.close = function (event, ui) { dialogClose(); };
    }
    else {
        dialogOptions.closeOnEscape = false;
        dialogOptions.open = function (event, ui) { $(".ui-dialog-titlebar-close").hide(); };    // suppresses "close" button
    }

    _menuSelection = "";
    $("#dialog").dialog(dialogOptions);

    $("#dialog").dialog("open");
}

function dialogSelect() {
    _menuSelection = $("#dialogOptions").val();
    if (_menuSelection.length > 0) {
        $("#dialog").dialog("close");
        window.setTimeout(function () {
            SetMenuSelection(_menuSelection);
            updateLists();
        }, 100);
    }
}

function dialogCancel() {
    $("#dialog").dialog("close");
}

function dialogClose() {
    if (_menuSelection.length == 0) {
        dialogSendCancel();
    }
}

function dialogSendCancel() {
    window.setTimeout(function () {
        // TO DO
        //$("#fldUIMsg").val("choicecancel");
        //$("#cmdSubmit").click();
    }, 100);
}

function sessionTimeout() {
    disableInterface();
}

function gameFinished() {
    disableInterface();
}

function disableInterface() {
    $("#divCommand").hide();
    $("#gamePanesRunning").hide();
    $("#gamePanesFinished").show();
}

function playWav(filename, sync, looped) {
}

function playMp3(filename, sync, looped) {
    playAudio(filename, "mp3", sync, looped);
}

function playAudio(filename, format, sync, looped) {
//TODO: parameters
	if (music_on) {
		new Audio(filename).play();
	}
}

function stopAudio() {
}

function finishSync() {
    _waitingForSoundToFinish = false;
    window.setTimeout(function () {
        $("#divCommand").show();
        $("#fldUIMsg").val("endwait");
        $("#cmdSubmit").click();
    }, 100);
}

function panesVisible(visible) {
    if (visible) {
        $("#gamePanes").show();
    }
    else {
        $("#gamePanes").hide();
    }
}

function uiShow(element) {
    if (element == "") return;
    $(element).show();
}

function uiHide(element) {
    if (element == "") return;
    $(element).hide();
}

var _compassDirs = ["northwest", "north", "northeast", "west", "east", "southwest", "south", "southeast", "up", "down", "in", "out"];

var lastPaneLinkId = 0;

function updateList(listName, listData) {
    var listElement = "";
    var emptyListLabel = "";

    if (listName == "inventory") {
        listElement = "#inventoryList";
        emptyListLabel = "#inventoryEmpty";
    }

    if (listName == "placesobjects") {
        listElement = "#objectsList";
        emptyListLabel = "#placesObjectsEmpty";
    }

    $(listElement).empty();
    $(listElement).show();
    var listcount = 0;
    var anyItem = false;

    $.each(listData, function (key, value) {
        var splitString = value.split(":");
        var objectDisplayName = splitString[0];
        var objectVerbs = splitString[1];

        if (listName == "inventory" || $.inArray(objectDisplayName, _compassDirs) == -1) {
            listcount++;
            lastPaneLinkId++;
            var paneLinkId = "paneLink" + lastPaneLinkId;
            $(listElement).append(
                "<li id=\"" + paneLinkId + "\" href=\"#\">" + objectDisplayName + "</li>"
            );
            bindMenu(paneLinkId, objectVerbs, objectDisplayName, false);
            anyItem = true;
        }
    });
    $(listElement + " li:last-child").addClass('last-child')
    if (listcount == 0) $(listElement).hide();
    if (anyItem) {
        $(emptyListLabel).hide();
    }
    else {
        $(emptyListLabel).show();
    }
}

function updateCompass(directions) {
    updateDir(directions, "NW", _compassDirs[0]);
    updateDir(directions, "N", _compassDirs[1]);
    updateDir(directions, "NE", _compassDirs[2]);
    updateDir(directions, "W", _compassDirs[3]);
    updateDir(directions, "E", _compassDirs[4]);
    updateDir(directions, "SW", _compassDirs[5]);
    updateDir(directions, "S", _compassDirs[6]);
    updateDir(directions, "SE", _compassDirs[7]);
    updateDir(directions, "U", _compassDirs[8]);
    updateDir(directions, "D", _compassDirs[9]);
    updateDir(directions, "In", _compassDirs[10]);
    updateDir(directions, "Out", _compassDirs[11]);
}

function updateDir(directions, label, dir) {
    $("#cmdCompass" + label).attr("disabled", $.inArray(dir, directions) == -1);
}

function compassClick(direction) {
    sendCommand(direction);
}

function sendCommand(text) {
    if (!gameRunning) return;
	//JS
	if (e_start.cmds.length%50==0)
		clearPast(150)
    //--
	if (awaitingInputCallback) {
        awaitingInputCallback = false;
        awaitingCallback = false;
		//JS
		if (e_start.record) {
			listadd (e_start.cmds, "%"+text);
		}
		
		//--
        getinputCallback(text);
		TryFinishTurn();
        return;
    }
    if (awaitingCallback) return;
    beginningOfCurrentTurnScrollPosition = $("#gameContent").height();

    if (_pauseMode || _waitingForSoundToFinish) return;
    if (_waitMode) {
        endWait();
        return;
    }
    window.setTimeout(function () {
        // TO DO - send tick count
        //prepareCommand(text);

        
                    if (text.substring(0, 6) == "cheat ") {
                runCheatCode(text.substring(6));
            }
            else {
                sendCommandInternal(text);
            }
                }, 100);
}

function sendCommandInternal(command) {
    var start = (new Date).getTime();
    addToCommandLog(command);
    HandleCommand(command);
    var diff = (new Date).getTime() - start;
    TryFinishTurn();
}

function addToCommandLog(command) {
    if (commandLog == null) {
        commandLog = new Array();
    }
    commandLog.push(command);
}

function runCheatCode(code) {
    var walkthrough = window["object_main"];
    if (walkthrough.steps.indexOf("label:" + code) > -1) {
        runWalkthrough("main", 0, 0, code);
    }
    else {
        sendCommandInternal("cheat " + code);
    }
}


function generateSaveLog(fn) {
    var gameElementArray = new Array();
    gameElementArray.push(GetObject("game"));
    generateSaveLogForArray(gameElementArray, fn);
    generateSaveLogForArray(allObjects, fn);
    generateSaveLogForArray(allExits, fn);
    generateSaveLogForArray(allCommands, fn);
    generateSaveLogForArray(allTurnScripts, fn);
    generateSaveLogForArray(allTimers, fn);
    thisTurnModifiedItems = new Array();
}

function generateSaveLogForArray(array, fn) {
    for (var idx in array) {
        var object = array[idx];
        var attrs = object["__modified"];
        if (attrs != undefined) {
            for (var attrIdx in attrs) {
                var attr = attrs[attrIdx];
                fn(object, attr, object[attr]);
            }
        }

        for (var attr in object) {
            var value = object[attr];
            if (typeof value === "object") {
                for (var idx in thisTurnModifiedItems) {
                    var item = thisTurnModifiedItems[idx];

                    if (value === item) {
                        markAttributeModified(object, attr);
                        fn(object, attr, value);
                        break;
                    }
                }
            }
        }
    }
}

function saveGame() {
	return;
    if (!gameRunning) return;
    if (awaitingCallback) return;
    if (runningWalkthrough) return;
    setTimeout(function () {
        var start = (new Date).getTime();
        saveGameInternal();
        var diff = (new Date).getTime() - start;
    }, 250);
}

function saveGameInternal() {
    if (!gameRunning) return;
    if (awaitingCallback) return;
    if (!localStorage) return;
    try {
        localStorageTransactionId = localStorage.getItem("transaction");
        if (localStorageTransactionId == undefined) {
            localStorageTransactionId = 1;
        }
        else {
            localStorageTransactionId = 3 - localStorageTransactionId;
        }

        localStorageSet("output", allOutput);
        localStorageSet("output2", $("#divOutput").html());
        localStorageSet("divCount", _divCount);
        if (commandLog != null) {
            localStorageSet("commandLog", commandLog.join(";"));
        }
        localStorageSet("nextObjectId", nextObjectId);

        // Save all object creations
        var createId = 0;
        for (var idx in createdObjects) {
            createId++;
            localStorageSet("create" + createId, createdObjects[idx]);
        }
        localStorageSet("numCreates", createId);

        // Save all object type additions
        var addTypeId = 0;
        for (var idx in addedTypes) {
            addTypeId++;
            localStorageSet("addtype" + addTypeId, addedTypes[idx]);
        }
        localStorageSet("numAddTypes", addTypeId);

        // Save all object attribute changes
        var changeId = 0;
        generateSaveLog(function (object, attribute, value) {
            var valueType = TypeOf(value);
            if (object.name == "player" && StartsWith(attribute, "currentcommand")) return;
            changeId++;
            var key = "change" + changeId;
            var storeValue = value;
            switch (valueType) {
                case "stringlist":
                    storeValue = value.length;
                    var count = 0;
                    for (var idx in value) {
                        localStorageSet(key + "_" + count, value[idx]);
                        count++;
                    }
                    break;
                case "objectlist":
                    storeValue = value.length;
                    var count = 0;
                    for (var idx in value) {
                        localStorageSet(key + "_" + count, value[idx]._js_name);
                        count++;
                    }
                    break;
                case "stringdictionary":
                case "scriptdictionary":
                    var count = 0;
                    for (var dictKey in value) {
                        localStorageSet(key + "_k" + count, dictKey);
                        localStorageSet(key + "_v" + count, value[dictKey]);
                        count++;
                    }
                    storeValue = count;
                    break;
                case "objectdictionary":
                    var count = 0;
                    for (var dictKey in value) {
                        localStorageSet(key + "_k" + count, dictKey);
                        localStorageSet(key + "_v" + count, value[dictKey]._js_name);
                        count++;
                    }
                    storeValue = count;
                    break;
                case "object":
                    storeValue = value._js_name;
                    break;
                case "null":
                    storeValue = "";
            }

            localStorageSet(key, object._js_name + "." + attribute + "=" + valueType + ":" + storeValue);
        });
        localStorageSet("numChanges", changeId);

        // Save all object destroys
        var destroyId = 0;
        for (var idx in destroyedObjects) {
            destroyId++;
            localStorageSet("destroy" + destroyId, destroyedObjects[idx]);
        }
        localStorageSet("numDestroys", destroyId);

        localStorage.setItem("transaction", localStorageTransactionId);
    }
    catch (err) {
        reportError("Failed to save game: " + err);
    }
}

function loadGame_() {
	return false;
    if (!localStorage) return false;

    localStorageTransactionId = localStorage.getItem("transaction");
    if (localStorageTransactionId == undefined) {
        return false;
    }
    try {
        nextObjectId = parseInt(localStorageGet("nextObjectId"));

        // Load object creations

        var commandLogList = localStorageGet("commandLog");
        if (commandLogList != null) {
            commandLog = commandLogList.split(";");
        }
        addToCommandLog("* loaded game");

        var createCount = localStorageGet("numCreates");
        for (var i = 1; i <= createCount; i++) {
            var data = localStorageGet("create" + i);
            var params = data.split(";");
            // format is name;defaultTypeObject.name;objectType
            switch (params[2]) {
                case "object":
                    var array = allObjects;
                    break;
                case "exit":
                    var array = allExits;
                    break;
                case "timer":
                    break;
                case "turnscript":
                    break;
                default:
                    throw "Unhandled create object type " + params[2];
            }
            if (params[2] == "timer") {
                createtimer(params[0]);
            }
            else if (params[2] == "turnscript") {
                createturnscript(params[0]);
            }
            else {
                createInternal(params[0], array, GetObject(params[1]), params[2]);
                // TODO: Add to objectsNameMap
            }
        }

        // Load object type additions

        var addTypeCount = localStorageGet("numAddTypes");
        for (var i = 1; i <= addTypeCount; i++) {
            var data = localStorageGet("addtype" + i);
            var params = data.split(";");
            // format is object;type
            addTypeToObject(window[params[0]], window[params[1]]);
        }

        // Load object attribute changes

        var changeCount = localStorageGet("numChanges");
        for (var i = 1; i <= changeCount; i++) {
            var data = localStorageGet("change" + i);
            var dotPos = data.indexOf(".");
            var eqPos = data.indexOf("=");
            var colonPos = data.indexOf(":");
            var objectName = data.substring(0, dotPos);
            var attrName = data.substring(dotPos + 1, eqPos);
            var type = data.substring(eqPos + 1, colonPos);
            var valueString = data.substring(colonPos + 1);

            var object = window[objectName];
            var value = valueString;

            switch (type) {
                case "script":
                    eval("_temp_assignfn=" + valueString);
                    value = _temp_assignfn;
                    break;
                case "stringlist":
                    var count = parseInt(valueString);
                    value = new Array();
                    for (var listIdx = 0; listIdx < count; listIdx++) {
                        value.push(localStorageGet("change" + i + "_" + listIdx));
                    }
                    break;
                case "objectlist":
                    var count = parseInt(valueString);
                    value = new Array();
                    for (var listIdx = 0; listIdx < count; listIdx++) {
                        value.push(window[localStorageGet("change" + i + "_" + listIdx)]);
                    }
                    break;
                case "stringdictionary":
                    var count = parseInt(valueString);
                    value = new Object();
                    for (var listIdx = 0; listIdx < count; listIdx++) {
                        var dictKey = localStorageGet("change" + i + "_k" + listIdx);
                        var dictVal = localStorageGet("change" + i + "_v" + listIdx);
                        value[dictKey] = dictVal;
                    }
                    break;
                case "objectdictionary":
                    var count = parseInt(valueString);
                    value = new Object();
                    for (var listIdx = 0; listIdx < count; listIdx++) {
                        var dictKey = localStorageGet("change" + i + "_k" + listIdx);
                        var dictVal = localStorageGet("change" + i + "_v" + listIdx);
                        value[dictKey] = window[dictVal];
                    }
                    break;
                case "scriptdictionary":
                    var count = parseInt(valueString);
                    value = new Object();
                    for (var listIdx = 0; listIdx < count; listIdx++) {
                        var dictKey = localStorageGet("change" + i + "_k" + listIdx);
                        var dictVal = localStorageGet("change" + i + "_v" + listIdx);
                        eval("_temp_assignfn=" + dictVal);
                        value[dictKey] = _temp_assignfn;
                    }
                    break;
                case "object":
                    value = window[valueString];
                    break;
                case "null":
                    value = null;
                    break;
                case "int":
                    value = parseInt(valueString);
                    break;
                case "double":
                    value = parseFloat(valueString);
                    break;
                case "boolean":
                    value = (valueString == "true");
            }

            set(object, attrName, value, false);
        }

        // Load object destroys

        var destroyCount = localStorageGet("numDestroys");
        for (var i = 1; i <= destroyCount; i++) {
            var data = localStorageGet("destroy" + i);
            destroy(data);
        }

        currentFont = GetObject("game").defaultfont;
        $("#fontOptions").val(currentFont);

        currentFontSize = GetObject("game").defaultfontsize.toString();
        $("#fontSize").val(currentFontSize);

        $("#fontSample").css("font-family", currentFont);
        $("#fontSample").css("font-size", currentFontSize + "pt");

        clearScreen();
        _divCount = localStorageGet("divCount");
        $("#divOutput").html(localStorageGet("output2"));
        msg(localStorageGet("output"));

        beginningOfCurrentTurnScrollPosition = $("#gameContent").height();
        scrollToEnd();

        updateLists();
        return true;
    }
    catch (err) {
        reportError("Failed to load game: " + err);
        return false;
    }
}

var localStorageTransactionId;
var lastRead;

function localStorageSet(key, value) {
    localStorage.setItem("c" + localStorageTransactionId + key, value);
}

function localStorageGet(key) {
    lastRead = key;
    return localStorage.getItem("c" + localStorageTransactionId + key);
}

var currentWalkthroughSteps;
var runningWalkthrough = false;
var stepCount;
var walkthroughMaxSteps;
var walkthroughFinishCode;

function runWalkthrough(name, startStep, maxSteps, cheatCode) {
        stepCount = 0;
        walkthroughMaxSteps = maxSteps;
    walkthroughFinishCode = cheatCode;
    var walkthrough = getElement(name);
    if (walkthrough) {
        currentWalkthroughSteps = addWalkthroughSteps(walkthrough);
        currentWalkthroughSteps.splice(0, startStep);
        runningWalkthrough = true;
        runWalkthroughSteps();
    }
    else {
        msg("No walkthrough of that name");
    }
}

function addWalkthroughSteps(walkthrough) {
    var list = new Array();
    if (walkthrough.parent != null) {
        list = list.concat(addWalkthroughSteps(walkthrough.parent));
    }
    list = list.concat(walkthrough.steps);
    return list;
}

var postStep = null;

function runWalkthroughSteps() {
    
    if (currentWalkthroughSteps == null || currentWalkthroughSteps.length == 0 || (walkthroughMaxSteps > 0 && stepCount >= walkthroughMaxSteps)) {
                runningWalkthrough = false;
        saveGame();
        return;
    }

    var step = currentWalkthroughSteps.splice(0, 1)[0];

    if (step == "label:" + walkthroughFinishCode) {
        runningWalkthrough = false;
        saveGame();
        return;
    }

    msg("");
    if (StartsWith(step, "assert:")) {
            }
    else if (StartsWith(step, "label:")) {
        // ignore
    }
    else {
        stepCount++;
                beginningOfCurrentTurnScrollPosition = $("#gameContent").height();
                sendCommandInternal(step);
        scrollToEndNow();
    }
    while (postStep) {
        var fn = postStep;
        postStep = null;
        fn();
    }

    setTimeout(function () {
        runWalkthroughSteps();
    }, 100);
}

function updateStatus(text) {
    if (text.length > 0) {
        showStatusVisible(true);
        $("#statusVars").html(text.replace(/\n/g, "<br/>"));
    }
    else {
        showStatusVisible(false);
    }
}

function setBackground(col) {
    $("#divOutput").css("background-color", col);
    $("#gamePanel").css("background-color", col);
}

function ASLEvent(event, parameter) {
	is_asl_event=true;   // JS
    var fn = window[event];
    fn.apply(null, [parameter]);
	is_asl_event=false;  //JS
}

function disableMainScrollbar() {
    $("#divOutput").css("overflow", "hidden");
}

function stopTimer() {
    clearInterval(tmrTick);
}

function getTickCountAndStopTimer() {
    stopTimer();
    return tickCount;
}

function goUrl(href) {
    window.open(href);
}

function setCompassDirections(directions) {
    _compassDirs = directions;
    $("#cmdCompassNW").attr("title", _compassDirs[0]);
    $("#cmdCompassN").attr("title", _compassDirs[1]);
    $("#cmdCompassNE").attr("title", _compassDirs[2]);
    $("#cmdCompassW").attr("title", _compassDirs[3]);
    $("#cmdCompassE").attr("title", _compassDirs[4]);
    $("#cmdCompassSW").attr("title", _compassDirs[5]);
    $("#cmdCompassS").attr("title", _compassDirs[6]);
    $("#cmdCompassSE").attr("title", _compassDirs[7]);
    $("#cmdCompassU").attr("title", _compassDirs[8]);
    $("#cmdCompassD").attr("title", _compassDirs[9]);
    $("#cmdCompassIn").attr("title", _compassDirs[10]);
    $("#cmdCompassOut").attr("title", _compassDirs[11]);
}

function setInterfaceString(name, text) {
    switch (name) {
        case "InventoryLabel":
            $("#inventoryLabel").html(text);
            break;
        case "PlacesObjectsLabel":
            $("#placesObjectsLabel").html(text);
            break;
        case "CompassLabel":
            $("#compassLabel").html(text);
            break;
        case "InButtonLabel":
            $("#cmdCompassIn").attr("value", text);
            break;
        case "OutButtonLabel":
            $("#cmdCompassOut").attr("value", text);
            break;
        case "EmptyListLabel":
            break;
        case "NothingSelectedLabel":
            break;
    }
}

function updateVerbButtons(list, verbsArray, idprefix) {
    var selectedIndex = list.prop("selectedIndex");
    var verbs = verbsArray[selectedIndex].split("/");
    var count = 1;
    $.each(verbs, function () {
        var target = $("#" + idprefix + count);
        target.attr("value", this);
        target.show();
        count++;
    });
    for (var i = count; i <= verbButtonCount; i++) {
        var target = $("#" + idprefix + i);
        target.hide();
    }
}
var _currentDiv = null;

function setCommandBarStyle(style) {
    var width = $("#txtCommand").width();
    $("#txtCommand").attr("style", style);
    //$("#txtCommand").width(width); //??????????????????????  JS
}

function addText(text) {
    if (_currentDiv == null) {
        createNewDiv("left");
    }

    _currentDiv.append(text);
    scrollToEnd();
}

var _divCount = 0;

function createNewDiv(alignment) {
	var classes = _outputSections.join(" ");
    _divCount++;
    $("<div/>", {
        id: "divOutputAlign" + _divCount,
        style: "text-align: " + alignment,
		"class": classes
    }).appendTo("#divOutput");
    _currentDiv = $("#divOutputAlign" + _divCount);
}

function bindMenu(linkid, verbs, text, inline) {
    var verbsList = verbs.split("/");

    var options = [];
    $.each(verbsList, function (key, value) {
        options = options.concat({ title: value, action: { type: "fn", callback: "doMenuClick('" + value.toLowerCase() + " " + text.replace("'", "\\'") + "');" } });
    });

    $("#" + linkid).jjmenu("both", options, {}, { show: "fadeIn", speed: 100, xposition: "left", yposition: "auto", "orientation": "auto" });
}
function bindMenuEl(el) {
	var verbs = el.data("verbs");
    var text = el.html();
    var elementId = el.data("elementid");
	var id = el.attr("id");
    bindMenu(id, verbs, text, false);
	
	
}
// added from desktop version:
function buildMenuOptions(verbs, text, elementId) {
    var verbsList = verbs.split("/");
    var options = [];
    var metadata = new Object();
    metadata[text] = elementId;
    var metadataString = JSON.stringify(metadata);

    $.each(verbsList, function (key, value) {
        options = options.concat({
            title: value,
            action: {
                callback: function (selectedValue) {
                    sendCommand(selectedValue.toLowerCase() + " " + text, metadataString);
                }
            }
        });
    });

    return options;
}
function doMenuClick(command) {
    $("div[id^=jjmenu]").remove();
    sendCommand(command);
}

function updateObjectLinks(data) {
    $(".elementmenu").each(function (index, e) {
        var $e = $(e);
        var verbs = data[$e.data("elementid")];
        if (verbs) {
            $e.removeClass("disabled");
            $e.data("verbs", verbs);
            // also set attribute so verbs are persisted to savegame
            $e.attr("data-verbs", verbs);
			bindMenuEl($e); // added by vourtram
        } else {
            $e.addClass("disabled");
        }
    });
}

function updateExitLinks(data) {
    $(".exitlink").each(function (index, e) {
        var $e = $(e);
        var exitid = $e.data("elementid");
        var available = $.inArray(exitid, data) > -1;
        if (available) {
            $e.removeClass("disabled");
        } else {
            $e.addClass("disabled");
        }
    });
}

function updateCommandLinks(data) {
    $(".commandlink").each(function (index, e) {
        var $e = $(e);
        var exitid = $e.data("elementid");
        var available = $.inArray(exitid, data) > -1;
        if (available) {
            $e.removeClass("disabled");
        } else {
            $e.addClass("disabled");
        }
    });
}

function disableAllCommandLinks() {
    $(".commandlink").each(function (index, e) {
        $(e).addClass("disabled");
    });
}

function clearScreen() {
    allOutput = "";
    $("#divOutput").html("");
    createNewDiv("left");
    beginningOfCurrentTurnScrollPosition = 0;
}
function clearPast(keep) {
	while ( $("#divOutput").children().length>keep)  {
		$("#divOutput").children().first().remove();
	}
}
function keyPressCode(e) {
    var keynum
    if (window.event) {
        keynum = e.keyCode
    } else if (e.which) {
        keynum = e.which
    }
    return keynum;
}

function AddYouTube(id) {
    var embedHTML = "<object width=\"425\" height=\"344\"><param name=\"movie\" value=\"http://www.youtube.com/v/" + id + "\"></param><param name=\"allowFullScreen\" value=\"true\"></param><param name=\"allowscriptaccess\" value=\"always\"></param><embed src=\"http://www.youtube.com/v/" + id + "\" type=\"application/x-shockwave-flash\" allowscriptaccess=\"always\" allowfullscreen=\"true\" width=\"425\" height=\"344\"></embed></object>";
    addText(embedHTML);
}

function AddVimeo(id) {
    var embedHTML = "<object width=\"400\" height=\"225\"><param name=\"allowfullscreen\" value=\"true\" /><param name=\"allowscriptaccess\" value=\"always\" /><param name=\"movie\" value=\"http://vimeo.com/moogaloop.swf?clip_id=" + id + "&server=vimeo.com&show_title=0&show_byline=0&show_portrait=0&color=00adef&fullscreen=1&autoplay=0&loop=0\" /><embed src=\"http://vimeo.com/moogaloop.swf?clip_id=" + id + "&server=vimeo.com&show_title=0&show_byline=0&show_portrait=0&color=00adef&fullscreen=1&autoplay=0&loop=0\" type=\"application/x-shockwave-flash\" allowfullscreen=\"true\" allowscriptaccess=\"always\" width=\"400\" height=\"225\"></embed></object>";
    addText(embedHTML);
}

function SetMenuBackground(color) {
    var css = getCSSRule("div.jj_menu_item");
    if (css) {
        css.style.backgroundColor = color;
    }
}

function SetMenuForeground(color) {
    var css = getCSSRule("div.jj_menu_item");
    if (css) {
        css.style.color = color;
    }
}

function SetMenuHoverBackground(color) {
    var css = getCSSRule("div.jj_menu_item_hover");
    if (css) {
        css.style.backgroundColor = color;
    }
}

function SetMenuHoverForeground(color) {
    var css = getCSSRule("div.jj_menu_item_hover");
    if (css) {
        css.style.color = color;
    }
}

function SetMenuFontName(font) {
    var css = getCSSRule("div.jjmenu");
    if (css) {
        css.style.fontFamily = font;
    }
}

function SetMenuFontSize(size) {
    // disabled
    //var css = getCSSRule("div.jjmenu");
    //if (css) {
    //    css.style.fontSize = size;
    //}
}

function TurnOffHyperlinksUnderline() {
    var css = getCSSRule("a.cmdlink");
    if (css) {
        css.style.textDecoration = "none";
    }
}

var _outputSections = new Array();

function JsStartOutputSection(name) {
    if ($.inArray(name, _outputSections) == -1) {
        _outputSections.push(name);
        createNewDiv("left");
    }
}

function JsEndOutputSection(name) {
    var index = $.inArray(name, _outputSections);
    if (index != -1) {
        _outputSections.splice(index, 1);
        createNewDiv("left");
    }
}

function JsHideOutputSection(name) {
    EndOutputSection(name);
    $("." + name + " a").attr("onclick", "");
    setTimeout(function () {
        $("." + name).hide(250, function () { $(this).remove(); });
    }, 250);
}

function getCSSRule(ruleName, deleteFlag) {
    ruleName = ruleName.toLowerCase();
    if (document.styleSheets) {
        for (var i = 0; i < document.styleSheets.length; i++) {
            var styleSheet = document.styleSheets[i];
            var ii = 0;
            var cssRule = false;
			try {
				do {
					if (styleSheet.cssRules) {
						cssRule = styleSheet.cssRules[ii];
					} else if (styleSheet.rules) {
						cssRule = styleSheet.rules[ii];
					}
					if (cssRule) {
						if (typeof cssRule.selectorText != "undefined") {
							if (cssRule.selectorText.toLowerCase() == ruleName) {
								if (deleteFlag == 'delete') {
									if (styleSheet.cssRules) {
										styleSheet.deleteRule(ii);
									} else {
										styleSheet.removeRule(ii);
									}
									return true;
								} else {
									return cssRule;
								}
							}
						}
					}
					ii++;
				} while (cssRule)
			} catch(err) {
				//security errors...
			}
        }
    }
    return false;
}

function killCSSRule(ruleName) {
    return getCSSRule(ruleName, 'delete');
}

function addCSSRule(ruleName) {
    if (document.styleSheets) {
        if (!getCSSRule(ruleName)) {
            if (document.styleSheets[0].addRule) {
                document.styleSheets[0].addRule(ruleName, null, 0);
            } else {
                document.styleSheets[0].insertRule(ruleName + ' { }', 0);
            }
        }
    }
    return getCSSRule(ruleName);
}

function uiDoRestart() {
    if (localStorage) {
        //localStorage.clear(); //JS
    }
    window.location.reload();
}

function reportError(errorMessage) {
    alert(errorMessage);
    console.log(errorMessage);
}

// WORLDMODEL ===================================================================================================================

var webPlayer = true;
var tmrTick = null;
var awaitingCallback = false;
var gameRunning = true;
var gameActive = true;

function worldmodelInitialise() {
    resolveObjectReferences();
    GetObject("game").timeelapsed = 0;
    for (var idx in allTimers) {
        var timer = allTimers[idx];
        if (timer.enabled) {
            timer.trigger = timer.interval;
        }
    }
    setObjectChildAttributes();
    if (typeof InitInterface == 'function') {
        InitInterface();
    }
    updateLists();
    tmrTick = setInterval(function () {
        timerTick();
    }, 1000);
}

function worldModelBeginGame() {
    StartGame();
    TryRunOnReadyScripts();
    updateLists();
}

function resolveObjectReferences() {
    for (var item in objectReferences) {
        var objData = objectReferences[item];
        window[objData[0]][objData[1]] = window[objData[2]];
    }
    for (var item in objectListReferences) {
        var objData = objectListReferences[item];
        var parent = window[objData[0]];
        var attribute = objData[1].replace(/ /g, "___SPACE___");
        var itemValue = objData[2];
        if (typeof parent[attribute] == "undefined") {
            parent[attribute] = new Array();
        }
        parent[attribute].push(window[itemValue]);
    }
    for (var item in objectDictionaryReferences) {
        var objData = objectDictionaryReferences[item];
        var parent = window[objData[0]];
        var attribute = objData[1].replace(/ /g, "___SPACE___");
        var itemKey = objData[2];
        var itemValue = objData[3];
        if (typeof parent[attribute] == "undefined") {
            parent[attribute] = new Object();
        }
        parent[attribute][itemKey] = window[itemValue];
    }
}

function setObjectChildAttributes() {
    for (var idx in allObjects) {
        var obj = allObjects[idx];
        if (obj.parent) {
            addChildObject(obj.parent, obj);
        }
    }
}

function addChildObject(parent, child) {
    if (!parent["_children"]) {
        parent["_children"] = new Array();
    }
    parent["_children"].push(child);
}

function updateLists() {
    setTimeout(function () {
        updateListsInternal();
    }, 1000);
}

function updateListsInternal() {
    updateObjectsLists();
    updateExitsList();
    if (typeof UpdateStatusAttributes == "function") {
        UpdateStatusAttributes();
    }
}

function updateObjectsLists() {
    updateObjectsList("GetPlacesObjectsList", "placesobjects");
    updateObjectsList("ScopeInventory", "inventory");
}

function updateObjectsList(scope, listName) {
    var listItems = window[scope]();
    if (scope == "GetPlacesObjectsList") {
        listItems = listItems.concat(ScopeExits());
    }
    var listData = new Array();
    for (var item in listItems) {
        var verbs = (listName == "inventory") ? listItems[item].inventoryverbs : listItems[item].displayverbs;
        if (verbs != undefined) {
            var verbsList = verbs.join("/");
        }
        else {
            var verbsList = "";
        }
        listData.push(GetDisplayAlias(listItems[item]) + ":" + verbsList);
    }
    updateList(listName, listData);
}

function updateExitsList() {
    var listItems = ScopeExits();
    var listData = new Array();
    for (var item in listItems) {
        listData.push(listItems[item].alias);
    }
    updateCompass(listData);
}

function attributeChanged(object, attribute, runscript, oldParent) {
    // TO DO: "Meta" field SortIndex - changed when object moves to a new parent, so it appears at the end of the list
    // of children.
    markAttributeModified(object, attribute);
    if (runscript) {
        var changedScript = "changed" + attribute;
        if (typeof object[changedScript] == "function") {
            object[changedScript](oldParent);
        }
    }
}

var nextObjectId = 0;

function getUniqueId() {
    nextObjectId++;
    return "dynid" + nextObjectId;
}

var transactions = new Array();
var currentTransaction;

function preAttributeChange(object, attribute, newValue) {
    if (currentTransaction != undefined) {
        // store the old value on the undo list
        var oldValue = object[attribute];
        var undoFunction;
        if (attribute == "parent") {
            undoFunction = function () {
                newValue = object[attribute];
                object[attribute] = oldValue;
                objectMoved(object, newValue, oldValue);
            };
        }
        else {
            undoFunction = function () {
                object[attribute] = oldValue;
            };
        }

        currentTransaction.undolist.push(undoFunction);
    }

    var type = TypeOf(newValue);

    // if value requires cloning first then return a clone
    if (type == "stringdictionary" || type == "objectdictionary" || type == "scriptdictionary") {
        var result = new Object();
        for (key in newValue) {
            result[key] = newValue[key];
        }
        return result;
    }
    else if (type == "objectlist" || type == "stringlist") {
        var result = new Array();
        for (idx in newValue) {
            result.push(newValue[idx]);
        }
        return result;
    }

    return newValue;
}

function markAttributeModified(object, attribute) {
    if (object["__modified"] == undefined) {
        object["__modified"] = new Array();
    }
    if (object["__modified"].indexOf(attribute) == -1) {
        object["__modified"].push(attribute);
    }
}

var thisTurnModifiedItems = new Array();

function markModified(item) {
    if (thisTurnModifiedItems.indexOf(item) == -1) {
        thisTurnModifiedItems.push(item);
    }
}

// Javascript magic to support function overloading
// from http://ejohn.org/blog/javascript-method-overloading/
// addMethod - By John Resig (MIT Licensed)

function addMethod(object, name, fn) {
    var old = object[name];
    object[name] = function () {
        if (fn.length == arguments.length)
            return fn.apply(this, arguments);
        else if (typeof old == 'function')
            return old.apply(this, arguments);
    };
}

// Script commands

var objectTag = new XRegExp("\<object (id='(.*?)' )?verbs='(?<verbs>.*?)'\>(?<text>.*?)\<\/object\>");
var colorTag = /\<color color="(.*?)"\>(.*?)\<\/color\>/;
var commandTag = /\<command input="(.*?)"\>(.*?)\<\/command\>/;
var alignTag = /\<align align="(.*?)"\>(.*?)\<\/align\>/;
var fontTag = /\<font size="(.*?)"\>(.*?)\<\/font\>/;
var currentFont = "";
var currentFontSize = "";
var currentForeground = "";
var currentLinkForeground = "";
var nextID = 1;
var allOutput = "";

function msg(text) {
    //%%MIN V540
    OutputText(text);
    //%%END MIN V540

    }

function listadd(list, item) {
    if (currentTransaction != undefined) {
        var undoFunction = function () {
            list.splice(list.length - 1, 1);
        }
        currentTransaction.undolist.push(undoFunction);
    }
    list.push(item);
    markModified(list);
}

function listremove(list, item) {
    var index = list.indexOf(item);
    if (index != -1) {
        if (currentTransaction != undefined) {
            var undoFunction = function () {
                listadd(list, item);
            }
            currentTransaction.undolist.push(undoFunction);
        }

        list.splice(index, 1);
    }
    markModified(list);
}

function dictionaryadd(dictionary, key, item) {
    if (currentTransaction != undefined) {
        var oldValue = dictionary[key];
        if (oldValue != undefined) {
            var undoFunction = function () {
                dictionary[key] = oldValue;
            }
        }
        else {
            var undoFunction = function () {
                delete dictionary[key];
            }
        }
        currentTransaction.undolist.push(undoFunction);
    }
    dictionary[key] = item;
    markModified(dictionary);
}

function dictionaryremove(dictionary, key) {
    if (currentTransaction != undefined) {
        var oldValue = dictionary[key];
        var undoFunction = function () {
            dictionary[key] = oldValue;
        }
        currentTransaction.undolist.push(undoFunction);
    }
    delete dictionary[key];
    markModified(dictionary);
}

function request(requestType, data) {
    switch (requestType) {
        case "UpdateLocation":
            updateLocation(data);
            break;
        case "SetStatus":
            updateStatus(data);
            break;
        case "SetInterfaceString":
            var splitString = data.split("=");
            var element = splitString[0];
            var string = splitString[1];
            setInterfaceString(element, string);
            break;
        case "SetCompassDirections":
            setCompassDirections(data.split(";"));
            break;
        case "Show":
            uiShow(requestShowHide_GetElement(data));
            break;
        case "Hide":
            uiHide(requestShowHide_GetElement(data));
            break;
        case "Foreground":
            currentForeground = data;
            break;
        case "Background":
            setBackground(data);
            break;
        case "LinkForeground":
            currentLinkForeground = data;
            break;
        case "FontName":
            currentFont = data;
            break;
        case "FontSize":
            currentFontSize = data;
            break;
        case "ClearScreen":
            clearScreen();
            break;
        case "SetPanelContents":
            setPanelContents(data);
            break;
        case "Log":
            break;
        case "Speak":
            break;
        default:
            throw "Request not supported: " + requestType + "; " + data;
    }
}

function requestShowHide_GetElement(element) {
    switch (element) {
        case "Panes":
            return "#gamePanes";
        case "Location":
            return "#location";
        case "Command":
            return "#divCommand";
        default:
            return "";
    }
}

function setPanelHeight() {
    setTimeout(function () {
        var height = $("#gamePanel").height();
        if ($("#gamePanel").html() == "") {
            // workaround for IE weirdness where an empty div has height
            height = 0;
            $("#gamePanel").hide();
        }
        else {
            $("#gamePanel").show();
        }
        $("#gamePanelSpacer").height(height);
        scrollToEnd();
    }, 100);
}

function setPanelContents(html) {
    $("#gamePanel").html(html);
    setPanelHeight();
}

function starttransaction(command) {
    var previousTransaction = currentTransaction;
    currentTransaction = new Object();
    transactions.push(currentTransaction);
    currentTransaction.undolist = new Array();
    currentTransaction.previous = previousTransaction;
    currentTransaction.command = command;
}

function undo() {
    if (currentTransaction) {
        var transactionToUndo = currentTransaction;
        if (dynamicTemplates["UndoTurn"]) {
            msg(overloadedFunctions.DynamicTemplate("UndoTurn", transactionToUndo.command));
        }
        else {
            msg("Undo: " + transactionToUndo.command);
        }
        currentTransaction = undefined;
        transactionToUndo.undolist.reverse();
        for (idx in transactionToUndo.undolist) {
            var fn = transactionToUndo.undolist[idx];
            fn();
        }
        currentTransaction = transactionToUndo.previous;
    }
    else {
        if (templates["NothingToUndo"]) {
            msg(templates["NothingToUndo"]);
        }
        else {
            msg("Nothing to undo");
        }
    }
}

function runscriptattribute2(object, attribute) {
    var fn = GetAttribute(object, attribute);
    fn.call(object);
}

function runscriptattribute3(object, attribute, parameters) {
    var fn = GetAttribute(object, attribute);
    fn.call(object, parameters);
}

function invoke(script, parameters) {
    if (parameters) {
        script.apply(null, [parameters["result"]]);
    } else {
        script();
    }
}

function error(message) {
    throw message;
}

function set(object, attribute, value, runscript) {
    if (runscript === undefined) {
        runscript = true;
    }
    attribute = attribute.replace(/ /g, "___SPACE___");
    var changed = (object[attribute] != value);

    value = preAttributeChange(object, attribute, value);
	var oldParent=null;
    if (attribute == "parent") {
        oldParent = object[attribute];
    }

    object[attribute] = value;

    if (changed) {
        if (attribute == "parent") {
            objectMoved(object, oldParent, value);			
        }

        attributeChanged(object, attribute, runscript,oldParent);
		if (attribute == "parent") {            
			UpdateObjectLinks();
        }
    }
}

function objectMoved(object, oldParent, newParent) {
    if (object.elementtype == "object" && object.type == "object") {
        if (oldParent) {
            var idx = oldParent["_children"].indexOf(object);
            if (idx == -1) {
                throw "Object wasn't in room!";
            }
            oldParent["_children"].splice(idx, 1);
        }
        if (newParent) {
            if (!newParent["_children"]) {
                newParent["_children"] = new Array();
            }
            newParent["_children"].push(object);
        }
    }
}

var menuOptions;
var menuCallback;
var finishTurnAfterSelection;

function showmenu_async(title, options, allowCancel, callback) {
    showmenu_async_internal(title, options, allowCancel, callback, true);
}

function showmenu_async_internal(title, options, allowCancel, callback, finishTurn) {
    menuOptions = options;
    menuCallback = callback;
    awaitingCallback = true;
    finishTurnAfterSelection = finishTurn;

    if (runningWalkthrough) {
        var step = currentWalkthroughSteps.splice(0, 1);
        var response = step[0];
        if (response.substring(0, 5) == "menu:") {
            var selection = response.substring(5);
            var selectionKey = "";
            for (var option in options) {
                msg(options[option]);
                if (options[option] == selection) {
                    selectionKey = option;
                }
            }
            if (selectionKey.length == 0) {
                msg("Error running walkthrough - menu response was not present in menu");
            }
            else {
                postStep = function () {
                    msg(" - " + selection);
                    SetMenuSelection(selectionKey);
                };
            }
        }
        else {
            msg("Error running walkthrough - expected menu response");
        }
    }
    else {
        showMenu(title, options, allowCancel);
    }
}

function ask(question, callback) {
    if (runningWalkthrough) {
        var step = currentWalkthroughSteps.splice(0, 1);
        var response = step[0];
        if (response.substring(0, 7) == "answer:") {
            awaitingCallback = true;
            postStep = function () {
                awaitingCallback = false;
                callback(response.substring(7) == "yes");
                TryFinishTurn();
            };
        }
        else {
            msg("Error running walkthrough - expected ask response");
        }
    }
    else {
        var result = confirm(question);
        callback(result);
        TryFinishTurn();
    }
}

var waitCallback;

function wait_async(callback) {
    waitCallback = callback;
    awaitingCallback = true;
    beginWait();
}

var getinputCallback;
var awaitingInputCallback = false;

function getinput_async(callback) {
    getinputCallback = callback;
    awaitingCallback = true;
    awaitingInputCallback = true;
}

function create(name) {
    createInternal(name, allObjects, GetObject("defaultobject"), "object");
}

function createexit(name, from, to) {
    var newExit = createInternal(getUniqueId(), allExits, GetObject("defaultexit"), "exit");
    set(newExit, "alias", name);
    set(newExit, "parent", from);
    set(newExit, "to", to);
    return newExit;
}

function createexit_withtype(name, from, to, type) {
    var newExit = createexit(name, from, to);
    if (type) {
        addTypeToObject(newExit, type);
    }
}

function createtimer(name) {
    createdObjects.push(name + ";;timer");

    if (currentTransaction != undefined) {
        var undoFunction = function () {
            destroy(name);
        }
        currentTransaction.undolist.push(undoFunction);
    }

    newObject = new Object();
    // TODO: Add to object map
    window["object_" + name] = newObject;
    allTimers.push(newObject);
    newObject.elementtype = "timer";
    newObject.name = name;
    newObject["_js_name"] = name;
    return newObject;
}

function createturnscript(name) {
    return createInternal(name, allTurnScripts, "defaultturnscript", "turnscript");
}

var createdObjects = new Array();

function createInternal(name, array, defaultTypeObject, objectType) {

    createdObjects.push(name + ";" + defaultTypeObject.name + ";" + objectType);

    if (currentTransaction != undefined) {
        var undoFunction = function () {
            destroy(name);
        }
        currentTransaction.undolist.push(undoFunction);
    }

    newObject = new Object();
    window[name] = newObject;
    objectsNameMap[name] = newObject;
    elementsNameMap[name] = newObject;
    array.push(newObject);
    newObject.elementtype = "object";
    newObject.name = name;
    newObject["_js_name"] = name;
    newObject.type = objectType;
    addTypeToObject_NoLog(newObject, defaultTypeObject);
    return newObject;
}

var addedTypes = new Array();

function addTypeToObject(object, type) {
    addedTypes.push(object.name + ";" + type.name);
    addTypeToObject_NoLog(object, type);
}

function addTypeToObject_NoLog(object, type) {
    if (type != undefined) {
        for (var attribute in type) {
            if (object[attribute] == undefined) {
                object[attribute] = type[attribute];
            }
        }
    }
}

var destroyedObjects = new Array();

function destroy(name) {
    destroyedObjects.push(name);
    destroyObject(GetObject(name));
}

function destroyObject(object) {
    var childObjects = new Array();
    for (var idx in allObjects) {
        var thisObject = allObjects[idx];
        if (thisObject.parent == object) {
            childObjects.push(thisObject);
        }
    }
    for (var childObject in childObjects) {
        destroyObject(childObjects[childObject]);
    }
    destroyObject_removeFromArray(object, allObjects);
    destroyObject_removeFromArray(object, allExits);
    destroyObject_removeFromArray(object, allCommands);
    destroyObject_removeFromArray(object, allTurnScripts);

    if (currentTransaction != undefined) {
        var undoFunction = function () {
            delete object["__destroyed"];
        }
        currentTransaction.undolist.push(undoFunction);
    }
    object["__destroyed"] = true;
}

function destroyObject_removeFromArray(object, array) {
    var removeIdx = $.inArray(object, array);
    if (removeIdx != -1) {
        if (currentTransaction != undefined) {
            var undoFunction = function () {
                array.push(object);
            }
            currentTransaction.undolist.push(undoFunction);
        }
        array.splice(removeIdx, 1);
    }
}

function insertHtml(filename) {
    addText(embeddedHtml[filename]);
}

function picture(filename) {
    msg("<img src=\"" + filename + "\" onload=\"scrollToEnd();\" /><br />");
}

function playsound(file, wait, loop) {
    // TO DO: support wav format
    playMp3(file, wait, loop);
}

function stopsound() {
    stopAudio();
}

function pauseEvent() {
    gameActive = false;
}

function resumeEvent() {
    gameActive = true;
}

function timerTick() {
    if (!gameRunning) return;
    if (!gameActive) return;
    var tickCount = GetObject("game").timeelapsed + 1;
    set(GetObject("game"), "timeelapsed", tickCount);
    var scriptRan = false;
    for (var idx in allTimers) {
        var timer = allTimers[idx];
        if (timer.enabled) {
            if (tickCount >= timer.trigger) {
                set(timer, "trigger", timer.trigger + timer.interval);
                timer.script();
                scriptRan = true;
            }
        }
    }
    if (scriptRan) {
        saveGame();
        updateLists();
    }
}

function finish() {
    gameRunning = false;
    if (localStorage) {
        //localStorage.clear(); //JS
    }
    $("#divCommand").hide();
}

var onReadyCallback = null;

function on_ready(callback) {
    if (!awaitingCallback) {
        callback();
    }
    else {
        onReadyCallback = callback;
    }
}

function getElement(name) {
    return elementsNameMap[name];
}

function setGameWidth() {
}

function setGamePadding() {
}

function hideBorder() {
}

// Functions

function NewObjectList() {
    return new Array();
}
// Added JS (missing)
function NewList() {
    return new Array();
}
function NewStringList() {
    return new Array();
}

function NewDictionary() {
    return new Object();
}

function NewObjectDictionary() {
    return new Object();
}

function NewStringDictionary() {
    return new Object();
}

function ToString(value) {
    return value.toString();
}

function ToInt(value) {
    return parseInt(value);
}

function ToDouble(value) {
    return parseFloat(value);
}

function Join(array, separator) {
    return array.join(separator);
}

function Split(input, delimiter) {
    return input.split(delimiter);
}

function Trim(input) {
    return $.trim(input);
}

function LengthOf(input) {
    if (input == null) return 0;
    return input.length;
}

function StartsWith(input, text) {
    return input.indexOf(text) == 0;
}

function LCase(text) {
    return text.toLowerCase();
}

function UCase(text) {
    return text.toUpperCase();
}

function CapFirst(text) {
    return text.substring(0, 1).toUpperCase() + text.substring(1);
}

function Left(text, count) {
    return text.substring(0, count);
}

function Right(text, count) {
    return text.substring(text.length - count - 1);
}

function Mid(text, start, count) {
    return text.substr(start - 1, count);
}

function Instr(p1, p2, p3) {
    var input, search;
    if (p3 === undefined) {
        input = p1;
        search = p2;
        return input.indexOf(search) + 1;
    } else {
        var start = p1;
        input = p2;
        search = p3;
        return input.indexOf(search, start - 1) + 1;
    }
}

function Replace(input, text, newText) {
    return input.split(text).join(newText);
}

var regexCache = new Object();

function getRegex(regexString, cacheID) {
    var result = regexCache[cacheID];
    if (result) {
        return result;
    }
    result = new XRegExp(regexString, "i");
    regexCache[cacheID] = result;
    return result;
}

function IsRegexMatch(regexString, input, cacheID) {
    var regex = getRegex(regexString, cacheID);
    return regex.test(input);
}

function GetMatchStrength(regexString, input, cacheID) {
    var regex = getRegex(regexString, cacheID);
    var lengthOfTextMatchedByGroups = 0;
    var matches = regex.exec(input);
    var namedGroups = GetRegexNamedGroups(matches);
    for (var groupIdx in namedGroups) {
        if (matches[namedGroups[groupIdx]] != undefined) {
            lengthOfTextMatchedByGroups += matches[namedGroups[groupIdx]].length;
        }
    }
    return input.length - lengthOfTextMatchedByGroups;
}

function Populate(regexString, input, cacheID) {
    var regex = getRegex(regexString, cacheID);
    var matches = regex.exec(input);
    var result = new Object();
    var namedGroups = GetRegexNamedGroups(matches);
    for (var groupIdx in namedGroups) {
        if (matches[namedGroups[groupIdx]] != undefined) {
            var varName = namedGroups[groupIdx];
            var mapIndex = varName.indexOf("_map_");
            if (mapIndex != -1) {
                varName = varName.substring(mapIndex + 5);
            }
            result[varName] = matches[namedGroups[groupIdx]];
        }
    }
    return result;
}

function GetRegexNamedGroups(matches) {
    var result = new Array();
    for (var prop in matches) {
        if (matches.hasOwnProperty(prop)) {
            if (StartsWith(prop, "object") || prop.indexOf("_map_object") != -1
             || StartsWith(prop, "text") || prop.indexOf("_map_text") != -1
             || StartsWith(prop, "exit") || prop.indexOf("_map_exit") != -1) {
                result.push(prop);
            }
        }
    }
    return result;
}

function GetAttribute(element, attribute) {
    attribute = attribute.replace(/ /g, "___SPACE___");
    return element[attribute];
}

function GetBoolean(element, attribute) {
    if (HasBoolean(element, attribute)) {
        return GetAttribute(element, attribute);
    }
    return false;
}

function GetInt(element, attribute) {
    if (HasInt(element, attribute)) {
        return GetAttribute(element, attribute);
    }
    return 0;
}

function GetObject(element) {
    result = objectsNameMap[element];
    if (result == undefined) return result;
    if (result["__destroyed"]) return null;
    return result;
}

function GetTimer(name) {
    return GetObject(name);
}

function GetString(element, attribute) {
    if (HasString(element, attribute)) {
        return GetAttribute(element, attribute);
    }
    return null;
}

function HasAttribute(element, attribute) {
    return (GetAttribute(element, attribute) != undefined);
}

function HasBoolean(element, attribute) {
    return (TypeOf(GetAttribute(element, attribute)) == "boolean");
}

function HasInt(element, attribute) {
    return (TypeOf(GetAttribute(element, attribute)) == "int");
}

function HasObject(element, attribute) {
    return (TypeOf(GetAttribute(element, attribute)) == "object");
}

function HasString(element, attribute) {
    return (TypeOf(GetAttribute(element, attribute)) == "string");
}

function HasScript(element, attribute) {
    return (TypeOf(GetAttribute(element, attribute)) == "script");
}

function HasDelegateImplementation(element, attribute) {
    return (TypeOf(GetAttribute(element, attribute)) == "script");
}

function GetAttributeNames(element, includeInheritedAttributes) {
    var result = [];
    for (var name in element) {
        result.push(name);
    }
    return result;
}

function AllObjects() {
    return allObjects;
}

function AllExits() {
    return allExits;
}

function AllCommands() {
    return allCommands;
}

function AllTurnScripts() {
    return allTurnScripts;
}

function TypeOf(value) {
    return overloadedFunctions.TypeOf(value);
}

function OverloadedFunctions() {
    addMethod(this, "TypeOf", function (value) {
        var type = typeof value;
        if (type == "function") return "script";
        if (type == "object") {
            if (value == null) return "null";
            if (Object.prototype.toString.call(value) === '[object Array]') {
                // could be an objectlist or stringlist
                var allObjects = true;
                var allStrings = true;

                for (var index in value) {
                    var item = value[index];
                    if (typeof item != "string") allStrings = false;
                    if (typeof item != "object") allObjects = false;
                    if (!allStrings && !allObjects) break;
                }

                if (allStrings) return "stringlist";
                if (allObjects) return "objectlist";
                return "unknown";
            }
            else {
                // could be an object, stringdictionary, objectdictionary or scriptdictionary
                var allObjects = true;
                var allStrings = true;
                var allScripts = true;

                for (var key in value) {
                    var item = value[key];
                    if (typeof item != "string") allStrings = false;
                    if (TypeOf(item) != "object") allObjects = false;
                    if (typeof item != "function") allScripts = false;
                    if (!allStrings && !allObjects && !allScripts) break;
                }

                if (allStrings) {
                    return "stringdictionary";
                }
                if (allObjects) {
                    return "objectdictionary";
                }
                if (allScripts) {
                    return "scriptdictionary";
                }
                return "object";
            }
        }
        if (type == "boolean") return "boolean";
        if (type == "string") return "string";
        if (type == "number") {
            // TO DO: Also need to handle double
            return "int";
        }
        if (type == "undefined") return "null";

        // TO DO: Also valid: Delegate name
    });

    addMethod(this, "TypeOf", function (object, attribute) {
        return TypeOf(GetAttribute(object, attribute));
    });

    addMethod(this, "DynamicTemplate", function (name, arg1) {
        params = new Object();
        params["object"] = arg1;
        params["exit"] = arg1;
        params["text"] = arg1;
        return dynamicTemplates[name](params);
    });

    addMethod(this, "DynamicTemplate", function (name, arg1, arg2) {
        params = new Object();
        params["object1"] = arg1;
        params["object2"] = arg2;
        return dynamicTemplates[name](params);
    });

    addMethod(this, "Eval", function (expression) {
        return eval(expression);
    });

    addMethod(this, "Eval", function (expression, params) {
        for (var varname in params) {
            var varvalue = params[varname];
            eval("var " + varname + "=varvalue");
        }
        return eval(expression);
    });
}

var overloadedFunctions = new OverloadedFunctions();

function DictionaryContains(dictionary, key) {
    return dictionary[key] != undefined;
}

function DictionaryItem(dictionary, key) {
    return dictionary[key];
}

function StringDictionaryItem(dictionary, key) {
    return dictionary[key];
}

function ScriptDictionaryItem(dictionary, key) {
    return dictionary[key];
}

function ObjectDictionaryItem(dictionary, key) {
    return dictionary[key];
}

function DictionaryCount(dictionary) {
    var count = 0;
    for (key in dictionary) {
        count++;
    }
    return count;
}

function ListCombine(list1, list2) {
    return list1.concat(list2);
}

function ListExclude(list, element) {
    var listCopy = list.slice(0);
    var index = listCopy.indexOf(element);
    if (index != -1) {
        listCopy.splice(index, 1);
    }
    return listCopy;
}

function ListContains(list, element) {
    return ($.inArray(element, list) != -1);
}

function ListCount(list) {
    return list.length;
}

function ListItem(list, index) {
    return list[index];
}

function StringListItem(list, index) {
    return list[index];
}

function ObjectListItem(list, index) {
    return list[index];
}

function Template(name) {
    return templates["t_" + name];
}

// TO DO: Need overloads to handle passing function parameters
function RunDelegateFunction(object, attribute) {
    return GetAttribute(object, attribute)();
}

function Contains(parent, child) {
    if (child.parent == null || child.parent == undefined) return false;
    if (child.parent == parent) return true;
    return Contains(parent, child.parent);
}

function ShowMenu() {
    throw "Synchronous ShowMenu function is not supported. Use showmenu_async function instead";
}

function SetMenuSelection(result) {
    if (Object.prototype.toString.call(menuOptions) === '[object Array]') {
        awaitingCallback = false;
        menuCallback(menuOptions[result]);
    }
    else {
        awaitingCallback = false;
        menuCallback(result);
    }
    if (finishTurnAfterSelection) {
        TryFinishTurn();
    }
}

function GetExitByName(parent, name) {
    for (var idx in allExits) {
        var obj = allExits[idx];
        if (obj.parent == parent && obj.alias == name) {
            return obj.name;
        }
    }
}

function GetExitByLink(parent, to) {
    for (var idx in allExits) {
        var obj = allExits[idx];
        if (obj.parent == parent && obj.to == to) {
            return obj.name;
        }
    }
}

function GetFileURL(file) {
    return file;
}

function Ask(question) {
    if (runningWalkthrough) {
        msg("<i>" + question + "</i>");
        var step = currentWalkthroughSteps.splice(0, 1);
        var response = step[0];
        if (response.substring(0, 7) == "answer:") {
            return (response.substring(7) == "yes");
        }
        else {
            msg("Error running walkthrough - expected menu response");
        }
    }
    else {
        return confirm(question);
    }
}

function GetUniqueElementName(prefix) {
    return prefix + getUniqueId();
}

function TryFinishTurn() {
    updateLists();
    TryRunOnReadyScripts();
    if (!awaitingCallback) {
        saveGame();
        if (typeof FinishTurn == "function") {
            FinishTurn();
        }
    }
	if (!mobilecheck())
		$("#txtCommand").focus();  // JS foco
}

function TryRunOnReadyScripts() {
    if (awaitingCallback) return;
    if (onReadyCallback != null) {
        var callback = onReadyCallback;
        onReadyCallback = null;
        callback();
    }
}

function GetDirectChildren(element) {
    if (!element["_children"]) {
        return new Array();
    }
    return element["_children"];
}

function GetAllChildObjects(element) {
    var result = new Array();
    var directChildren = GetDirectChildren(element);
    for (var idx in directChildren) {
        var obj = directChildren[idx];
        result.push(obj);
        result = result.concat(GetAllChildObjects(obj));
    }
    return result;
}

function IsGameRunning() {
    return gameRunning;
}

function IsDefined(variable) {
    return true;
}

function GetRandomInt(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

function SafeXML(input) {
    return input.replace(/&/g, "&").replace(/</g, "<").replace(/>/g, ">");
}

function GetUIOption() {
    return null;
}

function DoesInherit(obj, type) {
    return ListContains(obj._types, type);
}

function Floor(n) {
    return Math.floor(n);
}

var templates = new Object();
var dynamicTemplates = new Object();
var allObjects = new Array();
var allExits = new Array();
var allCommands = new Array();
var allTurnScripts = new Array();
var allTimers = new Array();
var objectReferences = new Array();
var objectListReferences = new Array();
var objectDictionaryReferences = new Array();
var embeddedHtml = new Object();
var objectsNameMap = new Object();
var elementsNameMap = new Object();

var e= elementsNameMap; //JS shortcut

templates.t_HelpThief = "You can stealth walk, pick pockets and play all sorts of dirty tricks with your enemies. <br/>The thief has the following special commands:<br/><br/><b>steal <i>someone</i></b>: You will try to steal money or objects from a victim.<br/><b>hide <i>somewhere</i></b>: You will try to hide from someone.<br/><b>stab <i>someone</i></b>: You will try to sneak and stab someone from behind. A victim aware or wearing armor will be harder to back-stab.<br/><b>climb <i>something</i></b>: You will try to climb something.<br/><b>picklock <i>object/door</i></b>: You will try to pick the door/object's lock.<br/><i>A thief will always try to move silently when he feels necessary.</i>"
templates.t_HelpMage = "You can read, write and practice spells.<br/>Special commands for a Wizard:<br/><b>read <i>something</i></b>: Only wizards are literate and therefore capable of reading and writing.<br/><b>cast <i>spell</i></b>: Wizards can cast spells contained in his book of spells. You can also learn spells found in scrolls and books. Some spells require special items and ingredients.<br/><b>spells</b>: This command lists all the spells you know."
templates.t_HelpWarrior = "You can use swords, shields and armor to subjugate your enemies.<br/>The warrior has the following special commands:<br/><b>fight <i>someone</i></b>: Will start a fight. Better have weapons and armor.<br/><b>throw <i>something</i> at <i>enemy/target</i></b>: Will throw an object/weapon<br/><b>consider <i>someone</i></b>: Will give a hint about how prepared you are to fight someone, and evaluate the enemy's condition during a battle.<br/>  You can also use the <b>look at me</b> command to check your condition during a fight."
templates.t_LanguageId = "en"
templates.t_UnresolvedObject = "I can't see that."
templates.t_UnresolvedLocation = "You can't go there."
templates.t_DefaultObjectDescription = "Nothing out of the ordinary."
templates.t_DefaultSelfDescription = "Looking good."
templates.t_SeeListHeader = "You can see"
templates.t_GoListHeader = "You can go"
templates.t_And = "and"
templates.t_Or = "or"
templates.t_NothingToUndo = "Nothing to undo!"
templates.t_NotCarryingAnything = "You are not carrying anything."
templates.t_CarryingListHeader = "You are carrying"
templates.t_UnrecognisedCommand = "I don't understand your command."
templates.t_YouAreIn = "You are in"
templates.t_LookAt = "Look at"
templates.t_Take = "Take"
templates.t_SpeakTo = "Speak to"
templates.t_Use = "Use"
templates.t_Drop = "Drop"
templates.t_GoTo = "Go to"
templates.t_Go = "Go"
templates.t_SwitchOn = "Switch on"
templates.t_SwitchOff = "Switch off"
templates.t_Open = "Open"
templates.t_Close = "Close"
templates.t_Eat = "Eat"
templates.t_NeutralGender = "it"
templates.t_MaleGender = "he"
templates.t_FemaleGender = "she"
templates.t_SelfGender = "you"
templates.t_NeutralPluralGender = "they"
templates.t_MalePluralGender = "they"
templates.t_FemalePluralGender = "they"
templates.t_NeutralArticle = "it"
templates.t_MaleArticle = "him"
templates.t_FemaleArticle = "her"
templates.t_SelfArticle = "yourself"
templates.t_NeutralPluralArticle = "them"
templates.t_MalePluralArticle = "them"
templates.t_FemalePluralArticle = "them"
templates.t_SelfAlias = "me"
templates.t_SelfAlt = "myself; self"
templates.t_AllObjects = "all; everything"
templates.t_ParserIgnorePrefixes = "the; a; an"
templates.t_CannotDoThat = "You can't do that."
templates.t_Done = "Done."
templates.t_ContainerContentsPrefix = "containing"
templates.t_SurfaceContentsPrefix = "on which there is"
templates.t_LockedExit = "That way is locked."
templates.t_NoKey = "You do not have the key."
templates.t_UnlockMessage = "Unlocked."
templates.t_LockMessage = "Locked."
templates.t_DefaultOops = "There is nothing to correct."
templates.t_VerbObjectSeparator = "with; using"
templates.t_DefaultMultiObjectVerb = "That doesn't work."
templates.t_MultiObjectVerbMenu = "With which object?"
templates.t_UseOnMenu = "On which object?"
templates.t_GiveToMenu = "To which object?"
templates.t_NoObjectsAvailable = "There are no objects available to do that with."
templates.t_Yes = "Yes"
templates.t_No = "No"
templates.t_By = "by"
templates.t_CompassNW = "northwest"
templates.t_CompassN = "north"
templates.t_CompassNE = "northeast"
templates.t_CompassW = "west"
templates.t_CompassE = "east"
templates.t_CompassSW = "southwest"
templates.t_CompassS = "south"
templates.t_CompassSE = "southeast"
templates.t_CompassUp = "up"
templates.t_CompassDown = "down"
templates.t_CompassIn = "in"
templates.t_CompassOut = "out"
templates.t_CompassDirectionPrefix = ""
templates.t_CompassDirectionSuffix = ""
templates.t_UpDownDirectionPrefix = ""
templates.t_UpDownDirectionSuffix = ""
templates.t_InOutDirectionPrefix = ""
templates.t_InOutDirectionSuffix = ""
templates.t_CompassNWShort = "nw"
templates.t_CompassNShort = "n"
templates.t_CompassNEShort = "ne"
templates.t_CompassWShort = "w"
templates.t_CompassEShort = "e"
templates.t_CompassSWShort = "sw"
templates.t_CompassSShort = "s"
templates.t_CompassSEShort = "se"
templates.t_CompassUpShort = "u"
templates.t_CompassDownShort = "d"
templates.t_CompassInShort = ""
templates.t_CompassOutShort = "o"
templates.t_InventoryLabel = "Inventory"
templates.t_StatusLabel = "Status"
templates.t_PlacesObjectsLabel = "Places and Objects"
templates.t_CompassLabel = "Compass"
templates.t_InButtonLabel = "in"
templates.t_OutButtonLabel = "out"
templates.t_EmptyListLabel = "(empty)"
templates.t_NothingSelectedLabel = "(nothing selected)"
templates.t_TypeHereLabel = "Type here..."
templates.t_ContinueLabel = "Continue..."
templates.t_go = "^go to (?<exit>.*)$|^go (?<exit>.*)$|^(?<exit>north|east|south|west|northeast|northwest|southeast|southwest|in|out|up|down|n|e|s|w|ne|nw|se|sw|o|u|d)$"
templates.t_lookdir = "^look (?<exit>north|east|south|west|northeast|northwest|southeast|southwest|out|up|down|n|e|s|w|ne|nw|se|sw|o|u|d)$"
templates.t_look = "^look$|^l$"
templates.t_lookat = "look at; x; examine; exam; ex"
templates.t_take = "take; get; pick up"
templates.t_undo = "^undo$"
templates.t_inventory = "^i$|^inv$|^inventory$"
templates.t_quit = "^quit$"
templates.t_drop = "drop"
templates.t_use = "use"
templates.t_speakto = "speak to; speak with; speak; talk to; talk"
templates.t_open = "open"
templates.t_close = "close"
templates.t_put = "^put (?<object1>.*) (on|in) (?<object2>.*)$"
templates.t_removefrom = "^remove (?<object1>.*) from (?<object2>.*)$"
templates.t_ask = "^ask (?<object>.*) about (?<text>.*)$"
templates.t_tell = "^tell (?<object>.*) about (?<text>.*)$"
templates.t_oops = "^oops (?<text>.*)$"
templates.t_buy = "buy"
templates.t_climb = "climb"
templates.t_drink = "drink"
templates.t_eat = "eat"
templates.t_givesingle = "give"
templates.t_give = "^give (?<object1>.*) to (?<object2>.*)$"
templates.t_hit = "hit"
templates.t_kill = "kill"
templates.t_kiss = "kiss"
templates.t_knock = "knock"
templates.t_lick = "lick"
templates.t_lie = "lie on; lie upon; lie down on; lie down upon"
templates.t_listento = "listen to"
templates.t_lock = "lock"
templates.t_move = "move"
templates.t_pull = "pull"
templates.t_push = "push"
templates.t_read = "read"
templates.t_search = "search"
templates.t_show = "show"
templates.t_sit = "sit on; sit upon; sit down on; sit down upon"
templates.t_smell = "smell; sniff"
templates.t_taste = "taste"
templates.t_throw = "throw"
templates.t_tie = "tie"
templates.t_touch = "touch"
templates.t_turnon = "turn on; turn #object# on; switch on; switch #object# on"
templates.t_turnoff = "turn off; turn #object# off; switch off; switch #object# off"
templates.t_turn = "turn"
templates.t_unlock = "unlock"
templates.t_untie = "untie"
templates.t_useon = "^use (?<object1>.*) (on|with) (?<object2>.*)$"
templates.t_wear = "wear"
templates.t_listen = "^listen$"
templates.t_DefaultListen = "You can't hear much."
templates.t_jump = "^jump$"
templates.t_DefaultJump = "You jump, but nothing happens."
templates.t_sitdown = "^sit$|^sit down$"
templates.t_DefaultSitDown = "No time for lounging about now."
templates.t_liedown = "^lie$|^lie down$"
templates.t_DefaultLieDown = "No time for lounging about now."
templates.t_sleep = "^sleep$|^rest$"
templates.t_DefaultSleep = "No time for lounging about now."
templates.t_wait = "^wait$|^z$"
templates.t_DefaultWait = "Time passes."
templates.t_xyzzy = "^xyzzy$"
templates.t_DefaultXyzzy = "Surprisingly, absolutely nothing happens."
templates.t_help = "^help$|^\?$"
templates.t_save = "^save$"
//JS changed compass
templates.t_DefaultHelp = "<u>Quick Help</u><br/><br/><b>- Objects:</b>  Try LOOK AT..., SPEAK TO..., TAKE..., DROP..., OPEN..., GIVE... TO..., USE... ON/WITH...<br/><b>- Inventory:</b>  See which items you are carrying by typing I, INV or INVENTORY.<br/><b>- Moving around:</b>  Press the direction links, or type GO NORTH, SOUTH, E, GO TO...<br/><b>- Shortcuts:</b>  Press the up arrow and down arrow to scroll through commands you have already typed in. Try X... as a shortcut for LOOK AT..."
templates.t_LanguageSpecificObjectTypes = ""
dynamicTemplates.TakeSuccessful = function(params) { return "You pick " + params["object"].article + " up."; };
dynamicTemplates.TakeUnsuccessful = function(params) { return "You can't take " + params["object"].article + "."; };
dynamicTemplates.FullInventory = function(params) { return WriteVerb(params["object"], "be") + " too heavy to be taken."; };
dynamicTemplates.MaxObjectsInInventory = function(params) { return "You can't carry any more items."; };
dynamicTemplates.MaxObjectsInContainer = function(params) { return "You can't put more items in " + params["object"].article + "."; };
dynamicTemplates.DropSuccessful = function(params) { return "You drop " + params["object"].article + "."; };
dynamicTemplates.DropUnsuccessful = function(params) { return "You can't drop " + params["object"].article + "."; };
dynamicTemplates.AlreadyTaken = function(params) { return "You are already carrying " + params["object"].article + "."; };
dynamicTemplates.NotCarrying = function(params) { return "You are not carrying " + params["object"].article + "."; };
dynamicTemplates.CantUse = function(params) { return "You can't use " + params["object"].article + "."; };
dynamicTemplates.CantGive = function(params) { return "You can't give " + params["object"].article + "."; };
dynamicTemplates.DefaultSpeakTo = function(params) { return WriteVerb(params["object"], "say") + " nothing."; };
dynamicTemplates.ObjectNotOpen = function(params) { return CapFirst(GetDisplayAlias(params["object"])) + " " + Conjugate(params["object"], "be") + " not open."; };
dynamicTemplates.AlreadyOpen = function(params) { return WriteVerb(params["object"], "be") + " already open."; };
dynamicTemplates.AlreadyClosed = function(params) { return WriteVerb(params["object"], "be") + " already closed."; };
dynamicTemplates.CantOpen = function(params) { return "You can't open " + params["object"].article + "."; };
dynamicTemplates.CantClose = function(params) { return "You can't close " + params["object"].article + "."; };
dynamicTemplates.OpenSuccessful = function(params) { return "You open " + params["object"].article + "."; };
dynamicTemplates.CloseSuccessful = function(params) { return "You close " + params["object"].article + "."; };
dynamicTemplates.AlreadyThere = function(params) { return WriteVerb(params["object"], "be") + " already there."; };
dynamicTemplates.ObjectContains = function(params) { return WriteVerb(params["object"], "contain"); };
dynamicTemplates.ContainerFull = function(params) { return WriteVerb(params["object"], "be") + " full."; };
dynamicTemplates.DisambiguateMenu = function(params) { return "Please choose which '" + params["text"] + "' you mean:"; };
dynamicTemplates.UndoTurn = function(params) { return "Undo: " + params["text"]; };
dynamicTemplates.DefaultAsk = function(params) { return WriteVerb(params["object"], "do") + " not reply."; };
dynamicTemplates.DefaultTell = function(params) { return WriteVerb(params["object"], "do") + " not reply."; };
dynamicTemplates.LockedObject = function(params) { return WriteVerb(params["object"], "be") + " locked."; };
dynamicTemplates.AlreadyLocked = function(params) { return WriteVerb(params["object"], "be") + " already locked."; };
dynamicTemplates.AlreadyUnlocked = function(params) { return WriteVerb(params["object"], "be") + " already unlocked."; };
dynamicTemplates.CannotLockOpen = function(params) { return "You cannot lock " + params["object"].article + " when " + params["object"].gender + " " + Conjugate(params["object"], "be") + " open."; };
dynamicTemplates.AlreadySwitchedOn = function(params) { return WriteVerb(params["object"], "be") + " already switched on."; };
dynamicTemplates.AlreadySwitchedOff = function(params) { return WriteVerb(params["object"], "be") + " already switched off."; };
dynamicTemplates.SwitchedOn = function(params) { return "You switch " + params["object"].article + " on."; };
dynamicTemplates.SwitchedOff = function(params) { return "You switch " + params["object"].article + " off."; };
dynamicTemplates.Eaten = function(params) { return "You eat " + params["object"].article + "."; };
dynamicTemplates.ObjectDoesNotContain = function(params) { return CapFirst(GetDisplayAlias(params["object1"])) + " " + Conjugate(params["object1"], "do") + " not contain " + GetDisplayAlias(params["object2"]) + "."; };
dynamicTemplates.YouLooking = function(params) { return "You are looking " + params["text"] +"."; };
dynamicTemplates.LookAtDarkness = function(params) { return "It is too dark to make anything out."; };
dynamicTemplates.DefaultBuy = function(params) { return "You can't buy " + params["object"].article + "."; };
dynamicTemplates.DefaultClimb = function(params) { return "You can't climb " + params["object"].article + "."; };
dynamicTemplates.DefaultDrink = function(params) { return "You can't drink " + params["object"].article + "."; };
dynamicTemplates.DefaultEat = function(params) { return "You can't eat " + params["object"].article + "."; };
dynamicTemplates.DefaultGive = function(params) { return WriteVerb(params["object1"], "do") + " not want " + params["object2"].article + "."; };
dynamicTemplates.DefaultHit = function(params) { return "You can't hit " + params["object"].article + "."; };
dynamicTemplates.DefaultKill = function(params) { return "You can't kill " + params["object"].article + "."; };
dynamicTemplates.DefaultKiss = function(params) { return "You can't kiss " + params["object"].article + "."; };
dynamicTemplates.DefaultKnock = function(params) { return "You can't knock " + params["object"].article + "."; };
dynamicTemplates.DefaultLick = function(params) { return "You can't lick " + params["object"].article + "."; };
dynamicTemplates.DefaultLie = function(params) { return "You can't lie on " + params["object"].article + "."; };
dynamicTemplates.DefaultListenTo = function(params) { return "You listen, but " + params["object"].article + " makes no sound."; };
dynamicTemplates.DefaultLock = function(params) { return "You can't lock " + params["object"].article + "."; };
dynamicTemplates.DefaultMove = function(params) { return "You can't move " + params["object"].article + "."; };
dynamicTemplates.DefaultPull = function(params) { return "You can't pull " + params["object"].article + "."; };
dynamicTemplates.DefaultPush = function(params) { return "You can't push " + params["object"].article + "."; };
dynamicTemplates.DefaultRead = function(params) { return "You can't read " + params["object"].article + "."; };
dynamicTemplates.DefaultSearch = function(params) { return "You can't search " + params["object"].article + "."; };
dynamicTemplates.DefaultShow = function(params) { return "You can't show " + params["object"].article + "."; };
dynamicTemplates.DefaultSit = function(params) { return "You can't sit on " + params["object"].article + "."; };
dynamicTemplates.DefaultSmell = function(params) { return "You sniff, but " + params["object"].article + " doesn't smell of much."; };
dynamicTemplates.DefaultTaste = function(params) { return "You can't taste " + params["object"].article + "."; };
dynamicTemplates.DefaultThrow = function(params) { return "You can't throw " + params["object"].article + "."; };
dynamicTemplates.DefaultTie = function(params) { return "You can't tie " + params["object"].article + "."; };
dynamicTemplates.DefaultTouch = function(params) { return "You can't touch " + params["object"].article + "."; };
dynamicTemplates.DefaultTurnOn = function(params) { return "You can't turn " + params["object"].article + " on."; };
dynamicTemplates.DefaultTurnOff = function(params) { return "You can't turn " + params["object"].article + " off."; };
dynamicTemplates.DefaultTurn = function(params) { return "You can't turn " + params["object"].article + "."; };
dynamicTemplates.DefaultUnlock = function(params) { return "You can't unlock " + params["object"].article + "."; };
dynamicTemplates.DefaultUntie = function(params) { return "You can't untie " + params["object"].article + "."; };
dynamicTemplates.DefaultUseOn = function(params) { return "You can't use " + params["object2"].article + " that way."; };
dynamicTemplates.DefaultWear = function(params) { return "You can't wear " + params["object"].article + "."; };
e_game = {
"elementtype": "object",
"name": "game",
"type": "game",
"gamename": "The Castle of Vourtram",
"gameid": "bd3bbdcf-62e2-4d5e-a4f9-4af041fe080a",
"version": "0.94",
"firstpublished": "2017",
"author": "Alexandre Torres",
"category": "Fantasy",
"css": "",
"debug": true,
"license": "<a rel='license' href='http://creativecommons.org/licenses/by-nc-nd/4.0/'><img alt='Creative Commons License' style='border-width:0' src='images/88x31.png' /></a><br/>",
"description": "<u><b>The Castle of Vourtram</b></u> v{game.version}<br/><br/>{game.license}The Kingdom of Gwalinad is in its last days of existence. The evil wizard Vourtram, aided by an army of demoniac creatures, razed most of the old cities, spreading terror everywhere. When the capital Linwynne fell, the loyal forces of the old King fled to the hidden city of Chuma Huppic, an old stronghold defended by a magical maze that prevents enemy forces from entering. <br/><br/>However, Princess Grardobeth was captured, and many died in the hands of the evil wizard. The princess is kept as a hostage in the high tower of the Castle of Vourtram. Vourtram demands a marriage with the princess followed by the King's abdication, thus making him the new King over Gwalinad.<br/><br/>You are the hero, an orphan born under the sign of the Phoenix who, according to the prophecies, is destined to defeat Vourtram and his evil forces. It is up to you to first develop your skills as a hero, and afterwards depart in the quest to rescue the princess and destroy the evil of ... <b>The Castle of Vourtram</b>.",
"startmsg": true,
"turns": 0,
"difficulty": "Medium",
"cruelty": "Merciful",
"gridmap": false,
"mapscale": 10,
"mapsize": 200,
"feature_asktell": true,
"showborder": false,
"showpanes": true,
"showlocation": true,
"setcustomwidth": false,
"defaultfontsize": 14,
"defaultwebfont": "Lancelot",
"defaultbackground": "#F0F0E0",
"cover": "Vourtram.png",
"backgroundimage": "parch.png",
"setbackgroundopacity": true,
"backgroundopacity": 5,
"setcustompadding": false,
"defaultlinkforeground": "DarkGoldenRod",
"multiplecommands": true,
"skip_command": false,
"web": true,
"publishfileextensions": "*.jpg;*.jpeg;*.png;*.gif;*.js;*.wav;*.mp3;*.htm;*.html;*.svg;*.css",
"autodescription_youarein_useprefix": true,
"start": function() { var css = e_game.css;
var css = Replace(css,"ui-bg_inset-hard_100_F0F0E0_1x100.png",GetFileURL("ui-bg_inset-hard_100_F0F0E0_1x100.png"));
var css = Replace(css,"ui-icons_A0A060_256x240.png",GetFileURL("ui-icons_A0A060_256x240.png"));
var css = Replace(css,"ui-bg_gloss-wave_55_b7b2af_500x100.png",GetFileURL("ui-bg_gloss-wave_55_b7b2af_500x100.png"));
var css = Replace(css,"ui-bg_glass_85_C0C080_1x400.png",GetFileURL("ui-bg_glass_85_C0C080_1x400.png"));
set(e_game, "css", css);
executeJS ("startVourtram"); },
"_js_name": "e_game",
"_types": ["theme_typewriter", "defaultgame"],
"customwidth": 650,
"custompaddingtop": 60,
"defaultfont": "'Courier New', Courier, monospace",
"enablehyperlinks": true,
"echocommand": true,
"echohyperlinks": true,
"showdescriptiononenter": true,
"autodescription": true,
"defaultforeground": "Black",
"menufont": "Arial",
"menufontsize": 9,
"menubackground": "White",
"menuforeground": "Black",
"menuhoverbackground": "LightGrey",
"menuhoverforeground": "Black",
"underlinehyperlinks": true,
"compassdirections": ["northwest", "north", "northeast", "west", "east", "southwest", "south", "southeast", "up", "down", "in", "out"],
"clearframe": true,
"timeelapsed": 0,
"appendobjectdescription": false,
"allobjects": ["all", "everything"],
"parserignoreprefixes": ["the", "a", "an"],
"displayroomdescriptiononstart": true,
"showcommandbar": true,
"custompaddingbottom": 0,
"custompaddingleft": 20,
"custompaddingright": 20,
"showscore": false,
"showhealth": false,
"showtitle": true,
"autodisplayverbs": true,
"autodescription_youarein": 1,
"autodescription_youcansee": 2,
"autodescription_youcango": 3,
"autodescription_description": 4,
"autodescription_youarein_newline": false,
"autodescription_youcansee_newline": false,
"autodescription_youcango_newline": false,
"autodescription_description_newline": false,
"changeroom_newline": true,
"command_newline": false,
"languageid": "en",
"feature_lightdark": false,
"feature_pictureframe": false,
"feature_limitinventory": false,
"deactivatecommandlinks": false,
"changedpov": function(oldvalue) { InitPOV (oldvalue, e_game.pov); }
};
elementsNameMap["game"] = e_game;
objectsNameMap["game"] = e_game;
e_wooden_spear = {
"elementtype": "object",
"name": "wooden_spear",
"parent": e_game,
"type": "object",
"look": "Probably the most ordinary weapon available in the kingdom's armory. But it is well balanced for trowing at unarmored targets.{if wooden_spear.horned:You attached the horn of a demon in the tip.}",
"take": true,
"damage": 0,
"alias": "wooden spear",
"selfuseon": "To start a fight, or throw, use the specific command.",
"horned": false,
"usedefaultprefix": false,
"prefix": "a",
"suffix": "",
"inventoryverbs": ["Look at", "Drop"],
"_js_name": "e_wooden_spear",
"_types": ["Weapon", "defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["wooden_spear"] = e_wooden_spear;
allObjects.push(e_wooden_spear);
objectsNameMap["wooden_spear"] = e_wooden_spear;
e_picklock = {
"elementtype": "object",
"name": "picklock",
"parent": e_game,
"type": "object",
"look": "An indispensable tool of the trade...",
"drop": false,
"dropmsg": "You don't want to loose this precious tool.",
"take": true,
"inventoryverbs": ["Look at"],
"_js_name": "e_picklock",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"use": false,
"givesingle": false,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["picklock"] = e_picklock;
allObjects.push(e_picklock);
objectsNameMap["picklock"] = e_picklock;
e_dagger = {
"elementtype": "object",
"name": "dagger",
"parent": e_game,
"type": "object",
"look": "An easy to conceal weapon, perfect for backstabbing.",
"feature_usegive": true,
"use": true,
"givesingle": true,
"drop": false,
"dropmsg": "I'm not going to drop my dagger here.",
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"take": function() { get_gold_dagger (this); },
"ontake": function() { get_gold_dagger (this); },
"_js_name": "e_dagger",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["dagger"] = e_dagger;
allObjects.push(e_dagger);
objectsNameMap["dagger"] = e_dagger;
e_smallsword = {
"elementtype": "object",
"name": "smallsword",
"parent": e_game,
"type": "object",
"alias": "small sword",
"look": "It is an iron sword with a silvery tilt. The blade is decorated with silvery symbols ... maybe it has some witchcraft.",
"take": true,
"givesingle": true,
"inventoryverbs": ["Look at", "Drop", "Give"],
"selfuseon": "To start a fight, or throw, use the specific command.",
"feature_usegive": true,
"giveto": {"elf_smith": function() { OutputText ("<i>This magical sword belonged to an old friend of mine. Perhaps I could trust you ... but first you must prove yourself. Find my ring and bring it back to me. It is a silver emerald ring, kept by the captain.</i><br/>The smith skillfully fixes your sword. It looks sharper than ever");
set(e_smallsword, "damage", 2);
set(e_smallsword, "alias", "small sword");
set(e_elf_smith, "friend", true); } },
"_js_name": "e_smallsword",
"_types": ["Weapon", "defaultobject"],
"damage": 1,
"visible": true,
"displayverbs": ["Look at", "Take"],
"use": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["smallsword"] = e_smallsword;
allObjects.push(e_smallsword);
objectsNameMap["smallsword"] = e_smallsword;
e_calm_spell = {
"elementtype": "object",
"name": "calm_spell",
"parent": e_game,
"type": "object",
"take": true,
"alias": "calm spell",
"look": "The Calm Spell turns aggressive <b>beasts</b> and <b>monsters </b>into pacific creatures for some time. It also can remove aggressiveness from intelligent beings, especially <b>orcs</b>, but that won't prevent them from defending or using force to achieve their designs ... but they may consider not <b>KILLING</b> you. Creatures under magic command will resist this spell.",
"ObjectNotOpen": "test123",
"listalias": "-- calm spell",
"inventoryverbs": ["Look at", "Cast"],
"_js_name": "e_calm_spell",
"_types": ["Spell", "defaultobject"],
"castspell": true,
"castonobject": true,
"drop": function() { OutputText ("You don't want to rip your book apart."); },
"use": function() { OutputText ("You don't use a spell, you 'cast' it."); },
"read_away": false,
"read": function() { doRead (this); },
"visible": true,
"displayverbs": ["Look at", "Take"],
"givesingle": false,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["calm_spell"] = e_calm_spell;
allObjects.push(e_calm_spell);
objectsNameMap["calm_spell"] = e_calm_spell;
e_dispel_potion = {
"elementtype": "object",
"name": "dispel potion",
"parent": e_game,
"type": "object",
"alias": "dispel magic potion",
"look": "It is a closed ceramic bottle. You better not use it until the time you need it.",
"take": true,
"drop": false,
"dropmsg": "I don't want to loose it.",
"use": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"feature_usegive": true,
"useCmds": ["pour"],
"selfuseon": {"Wolf": function() { OutputText ("The werewolf transforms back to the human form. The spell is broken.<br/>The man says: <i>Thank you for breaking the werewolf curse. My name is Hector and I was a wizard apprentice. One day I was looking for some wolf's claws in the hills, and was suddenly bitten by a werewolf, becoming a cursed monster. Please take this <b>reveal spell</b> as a reward. We will meet again at the Guild!</i>. <br/>The man went his way after this.");
DisableTurnScript (e_wolfTurn);
MakeObjectVisible (e_Hector);
MoveObject (e_Wolf, e_void);
MoveObject (e_Hector, e_guild_mages);
set(e_player, "level", 1);
MoveObject (e_dispel_potion, e_void);
MoveObject (e_reveal_spell, e_spell_book);
MoveObject (e_RedGirl, e_WoodCabin);
MakeObjectVisible (e_RedGirl); } },
"_js_name": "e_dispel_potion",
"_types": ["UseAltType", "defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"givesingle": false,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["dispel potion"] = e_dispel_potion;
allObjects.push(e_dispel_potion);
objectsNameMap["dispel potion"] = e_dispel_potion;
e_fireball_spell = {
"elementtype": "object",
"name": "fireball_spell",
"parent": e_game,
"type": "object",
"take": true,
"inventoryverbs": ["Look at", "Use", "Drop", "cast"],
"alt": ["fireball", "fire"],
"alias": "fireball spell",
"look": "The Fireball Spell creates a deadly ball of fire guided by the will of the caster against a target. To cast the fireball the magic user needs to spent a <b>fire crystal</b>. The fireball power depends on the type of crystal used.",
"listalias": "aliasbla",
"ontake": function() { MoveObject (fireball___SPACE___spell, e_spell_book);
if (e_player.class == "mage") {
OutputText ("You write the spell into your spell book.");
}
else {
OutputText ("The spell just fizzles and disappears.");
} },
"selfuseon": {"__dummyKey": function() {  } },
"_js_name": "e_fireball_spell",
"_types": ["Spell", "defaultobject"],
"castspell": true,
"castonobject": true,
"drop": function() { OutputText ("You don't want to rip your book apart."); },
"use": function() { OutputText ("You don't use a spell, you 'cast' it."); },
"read_away": false,
"read": function() { doRead (this); },
"visible": true,
"displayverbs": ["Look at", "Take"],
"givesingle": false,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["fireball_spell"] = e_fireball_spell;
allObjects.push(e_fireball_spell);
objectsNameMap["fireball_spell"] = e_fireball_spell;
e_kobold = {
"elementtype": "object",
"name": "kobold",
"parent": e_game,
"type": "object",
"alias": "Kobold",
"look": "The Kobold is a little blue creature, as tall as a five-year old kid, with a large nose, white hair and a green outfit. He looks harmless and quite clever ... for a Kobold.",
"speak": "<i>{once:I'm Heinzel the kobold.}{notfirst:Greetings again {player.playername}.} I live here in this dark alley in the company of {command:ask kobold about thieves:thieves} and other people of questionable morality. At least until I recover my {command:ask kobold about ring:ring}.</i>",
"ask": {"thieves thief thug": function() { OutputText ("<i>Hmm ... I sense that you are looking for something. I may be a Kobold, but I am an old and wise one. The man you are looking for, I saw him speaking with a girl a few hours ago. He will meet her at the maze very soon, so we should get there straightaway... but I need to have that {command:ask kobold about ring:ring} first!</i>"); }, "ring": function() { OutputText ("<i>It is an emerald ring with magical powers. A long time ago, someone from this town stole a ring from me. My freedom belongs to who wear this ring. I know that this ring is near here, but Kobolds can't enter anywhere without being invited. If you can return this ring to me, I'm sure I could help you with your quest. Otherwise, I'm cursed to be here waiting for the ring ... forever.</i>");
set(e_kobold_ring, "known", 1); } },
"give": {"kobold_ring": function() { OutputText ("<i>Thank you very much! You gave me back my freedom. Now I will help you at the capture of that thug. Find the thug in the maze and let me deal with him!</i>. The Kobold disappears in the shadows.");
MoveObject (e_outlaw_thug, e_Maze);
MoveObject(e_kobold, e_void);
RemoveObject (e_kobold_ring);
MakeObjectVisible (e_outlaw_thug); } },
"_js_name": "e_kobold",
"_types": ["male", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["kobold"] = e_kobold;
allObjects.push(e_kobold);
objectsNameMap["kobold"] = e_kobold;
e_apport_spell = {
"elementtype": "object",
"name": "apport_spell",
"parent": e_game,
"type": "object",
"alias": "apportation spell",
"alt": ["fetch"],
"take": true,
"drop": false,
"look": "The Apportation (or fetch) spell lets you fetch an object from some distance, and levitate it towards your hand.",
"listalias": "-- apportation spell",
"inventoryverbs": ["Look at", "Cast"],
"_js_name": "e_apport_spell",
"_types": ["Spell", "defaultobject"],
"castspell": true,
"castonobject": true,
"use": function() { OutputText ("You don't use a spell, you 'cast' it."); },
"read_away": false,
"read": function() { doRead (this); },
"visible": true,
"displayverbs": ["Look at", "Take"],
"givesingle": false,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["apport_spell"] = e_apport_spell;
allObjects.push(e_apport_spell);
objectsNameMap["apport_spell"] = e_apport_spell;
e_brigand1 = {
"elementtype": "object",
"name": "brigand1",
"parent": e_game,
"type": "object",
"aggressive": true,
"alias": "brigand",
"exp": 4,
"armour": 0,
"_js_name": "e_brigand1",
"_types": ["male", "Enemy", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"enemy": "yes",
"danger": "death",
"ht": 10,
"stab_level": 0,
"affect_calm": false,
"block_flee": false,
"damage": 2,
"push": function() { if (e_player.parent==e_combat_room) {
if (e_combat.pushed) {
OutputText ("You can only push one time before you combat movement.");
}
else if (savedRandomInt(0,1)==0) {
OutputText ("You successfully push "+this.alias+".");
set(e_combat, "en_red", e_combat.en_red+1);
}
else {
OutputText ("You tried to push "+this.alias+", but ended up losing your balance.");
set(e_combat, "pl_red", e_combat.pl_red+1);
}
set(e_combat, "pushed", true);
}
else {
OutputText ("It doesn't work.");
} },
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["brigand1"] = e_brigand1;
allObjects.push(e_brigand1);
objectsNameMap["brigand1"] = e_brigand1;
e_book_plants = {
"elementtype": "object",
"name": "book_plants",
"parent": e_game,
"type": "object",
"alias": "book about plants",
"look": "Very technical stuff regarding plant classifications and alchemical uses.",
"read": "Very technical stuff regarding plant classifications and alchemical uses such as <i>The term \"gymnosperm\" comes from the Greek composite word \u03b3\u03c5\u03bc\u03bd\u03cc\u03c3\u03c0\u03b5\u03c1\u03bc\u03bf\u03c2 (\u03b3\u03c5\u03bc\u03bd\u03cc\u03c2 gymnos, \"naked\" and \u03c3\u03c0\u03ad\u03c1\u03bc\u03b1 sperma, \"seed\"), meaning \"naked seeds\", after the unenclosed condition of their seeds (called ovules in their unfertilized state)</i>",
"givesingle": true,
"inventoryverbs": ["Look at", "Drop", "Give"],
"take": true,
"_js_name": "e_book_plants",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"use": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["book_plants"] = e_book_plants;
allObjects.push(e_book_plants);
objectsNameMap["book_plants"] = e_book_plants;
e_teleport_spell = {
"elementtype": "object",
"name": "teleport_spell",
"parent": e_game,
"type": "object",
"alias": "teleport spell",
"alt": ["teleport", "teleportation"],
"drop": false,
"take": true,
"inventoryverbs": ["Look at", "Cast"],
"look": "The Teleport spell moves the caster to the position of the teleport orb.",
"listalias": "-- teleport spell",
"castonobject": false,
"_js_name": "e_teleport_spell",
"_types": ["Spell", "defaultobject"],
"castspell": true,
"use": function() { OutputText ("You don't use a spell, you 'cast' it."); },
"read_away": false,
"read": function() { doRead (this); },
"visible": true,
"displayverbs": ["Look at", "Take"],
"givesingle": false,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["teleport_spell"] = e_teleport_spell;
allObjects.push(e_teleport_spell);
objectsNameMap["teleport_spell"] = e_teleport_spell;
e_teleport_orb = {
"elementtype": "object",
"name": "teleport_orb",
"parent": e_game,
"type": "object",
"alias": "teleportation orb",
"look": "It is a red, apple shaped orb. When you cast teleport, you will come back to the place where the orb is.",
"take": true,
"feature_usegive": true,
"use": true,
"useCmds": ["put"],
"selfuseon": {"fruit_stand": function() { if (e_fruit_dealer.blind>0) {
MoveObject (e_teleport_orb, e_pantry);
OutputText ("You place the orb among the apples. After some time, a group of soldiers carries the apples to the castle, with the teleportation orb.");
MoveObject (e_fruit_stand, e_void);
MoveObject (e_fruit_dealer, e_void);
MoveObject (e_sc_apple, e_void);
set(e_fruit_dealer, "blind", 0);
}
else {
OutputText ("The fruit dealer will not let you do that.");
} } },
"_js_name": "e_teleport_orb",
"_types": ["UseAltType", "defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["teleport_orb"] = e_teleport_orb;
allObjects.push(e_teleport_orb);
objectsNameMap["teleport_orb"] = e_teleport_orb;
e_null_key = {
"elementtype": "object",
"name": "null_key",
"parent": e_game,
"type": "object",
"_js_name": "e_null_key",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["null_key"] = e_null_key;
allObjects.push(e_null_key);
objectsNameMap["null_key"] = e_null_key;
e_tourmaline = {
"elementtype": "object",
"name": "tourmaline",
"parent": e_game,
"type": "object",
"alias": "tourmaline stone",
"look": "This Tourmaline stone is very similar to a ruby gem, but much less expensive.",
"inventoryverbs": ["Look at", "Drop", "Give", "Use"],
"feature_usegive": true,
"use": true,
"givesingle": true,
"_js_name": "e_tourmaline",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"take": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["tourmaline"] = e_tourmaline;
allObjects.push(e_tourmaline);
objectsNameMap["tourmaline"] = e_tourmaline;
e_mercenary_leader = {
"elementtype": "object",
"name": "mercenary_leader",
"parent": e_game,
"type": "object",
"alias": "Lareak",
"alt": ["leader", "mercenary"],
"look": "He is a tall middle aged man with a dark leather armor.",
"no_steal": true,
"knows": false,
"feature_usegive": true,
"usedefaultprefix": false,
"suffix": " the mercenary leader",
"speak": function() { if (e_mercenary_leader.knows) {
psay ("If the {ask:leader:resistence} make a good {command:ask leader about offer:offer}, we will join them");
if (e_hall_guard.parent==e_hallway) {
psay ("Did you managed to pass by the {command:ask leader about guard:guard} in the hallway ?");
}
}
else {
OutputText ("<i>You are not supposed to be here, {command:tell leader about rat:rat killer}.</i>");
} },
"tell": {"rat killer": function() { OutputText ("You tell him that you are not a rat killer, and tells all about what you heard behind the curtains.");
OutputText ("Them you tell him that the brigands are willing to make an {command:ask leader about offer:offer} to turn over the mercenaries against Vourtram.");
psay ("Most of us are tired of this {ask:leader:vourtram:tyrant}, including myself. But it will cost you a lot of gold!");
set(e_mercenary_leader, "knows", true); }, "chest gold": function() { OutputText ("<i>A chest of gold could turn my mercenaries against Vourtram.</i>"); } },
"ask": {"offer": function() { if (e_gold_chest.parent==e_void) {
OutputText ("<i>We are only waiting for the order from your leader.</i>");
}
else {
OutputText ("<i>Something like a chest of gold coins would make a good offer.</i>");
} }, "guard": function() { psay ("The only way I know to remove that guard is with a leave order."); }, "chest gold": function() { psay ("A chest of gold could turn my mercenaries against Vourtram."); }, "resistence": function() { psay ("In order to win this war you have to find a way to {ask:leader:defeat:defeat Vourtram}."); }, "defeat vourtram": function() { psay ("Vourtram is virtually immortal. I saw a man trespass his heart with a spear, and the wizard just laughed.");
psay ("It is said that Vourtram placed his soul in a magical {ask:leader:jar}, thus making him immortal."); }, "jar immortality": function() { psay ("The only way to break the immortality spell is to find the soul jar and show it to the wizard."); } },
"give": {"gold_chest": function() { OutputText ("You better leave the gold with Bernard, in the inn. It would be foolish to show the stolen gold INSIDE the castle."); } },
"_js_name": "e_mercenary_leader",
"_types": ["namedmale", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["mercenary_leader"] = e_mercenary_leader;
allObjects.push(e_mercenary_leader);
objectsNameMap["mercenary_leader"] = e_mercenary_leader;
e_banish_spell = {
"elementtype": "object",
"name": "banish_spell",
"parent": e_game,
"type": "object",
"alias": "banish spell",
"take": true,
"drop": false,
"look": "This spell can banish a demon back to his realm. The most experienced the caster, better are the chances of this working.",
"listalias": "-- banish spell",
"inventoryverbs": ["Look at", "Cast"],
"_js_name": "e_banish_spell",
"_types": ["Spell", "defaultobject"],
"castspell": true,
"castonobject": true,
"use": function() { OutputText ("You don't use a spell, you 'cast' it."); },
"read_away": false,
"read": function() { doRead (this); },
"visible": true,
"displayverbs": ["Look at", "Take"],
"givesingle": false,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["banish_spell"] = e_banish_spell;
allObjects.push(e_banish_spell);
objectsNameMap["banish_spell"] = e_banish_spell;
e_lookat = {
"elementtype": "object",
"name": "lookat",
"type": "command",
"pattern": "^look at (?<object>.*)$|^x (?<g2_map_object>.*)$|^examine (?<g3_map_object>.*)$|^exam (?<g4_map_object>.*)$|^ex (?<g5_map_object>.*)$",
"script": function(parameters) { var object = parameters['object'];
if (GetBoolean(object, "hidechildren")) {
set(object, "hidechildren", false);
}
if (overloadedFunctions.TypeOf(object, "look") == "script") {
runscriptattribute2 (object, "look");
}
else {
var lookdesc = "";
if (HasString(object, "look")) {
var lookdesc = object.look;
}
if (LengthOf(lookdesc) == 0) {
var lookdesc = Template("DefaultObjectDescription");
}
if (GetBoolean(object, "switchedon")) {
if (HasString(object, "switchedondesc")) {
var lookdesc = lookdesc + " " + object.switchedondesc;
}
}
else {
if (HasString(object, "switchedoffdesc")) {
var lookdesc = lookdesc + " " + object.switchedoffdesc;
}
}
var isDark = CheckDarkness();
if (isDark && !(GetBoolean(object, "lightsource"))) {
var lookdesc = overloadedFunctions.DynamicTemplate("LookAtDarkness", object);
}
OutputText (lookdesc);
}
ListObjectContents (object); },
"_js_name": "e_lookat",
"_types": ["defaultcommand"]
};
elementsNameMap["lookat"] = e_lookat;
allCommands.push(e_lookat);
objectsNameMap["lookat"] = e_lookat;
e_take = {
"elementtype": "object",
"name": "take",
"type": "command",
"pattern": "^take (?<object>.*)$|^get (?<g2_map_object>.*)$|^pick up (?<g3_map_object>.*)$",
"multiple": function() { var takeList = NewObjectList();
var list_obj = ListExclude(ScopeVisibleNotHeldNotScenery(), e_game.pov);
var list_obj_isarray = (Object.prototype.toString.call(list_obj) === '[object Array]');
for (var iterator_obj in list_obj) {
var obj = list_obj_isarray ? list_obj[iterator_obj] : iterator_obj;
if (list_obj_isarray || iterator_obj!="__dummyKey") { if (obj.parent == e_game.pov.parent) {
listadd (takeList, obj);
} }
}
return (takeList); },
"script": function(parameters) { var object = parameters['object'];
var multiple = parameters['multiple'];
var object_isarray = (Object.prototype.toString.call(object) === '[object Array]');
for (var iterator_obj in object) {
var obj = object_isarray ? object[iterator_obj] : iterator_obj;
if (object_isarray || iterator_obj!="__dummyKey") { DoTake (obj, multiple); }
} },
"_js_name": "e_take",
"_types": ["defaultcommand"]
};
elementsNameMap["take"] = e_take;
allCommands.push(e_take);
objectsNameMap["take"] = e_take;
e_drop = {
"elementtype": "object",
"name": "drop",
"type": "command",
"pattern": "^drop (?<object>.*)$",
"multiple": function() { return (GetDirectChildren(e_game.pov)); },
"script": function(parameters) { var object = parameters['object'];
var multiple = parameters['multiple'];
var object_isarray = (Object.prototype.toString.call(object) === '[object Array]');
for (var iterator_obj in object) {
var obj = object_isarray ? object[iterator_obj] : iterator_obj;
if (object_isarray || iterator_obj!="__dummyKey") { DoDrop (obj, multiple); }
} },
"_js_name": "e_drop",
"_types": ["defaultcommand"]
};
elementsNameMap["drop"] = e_drop;
allCommands.push(e_drop);
objectsNameMap["drop"] = e_drop;
e_use = {
"elementtype": "object",
"name": "use",
"type": "command",
"pattern": "^use (?<object>.*)$",
"script": function(parameters) { var object = parameters['object'];
if (HasScript(object, "use")) {
runscriptattribute2 (object, "use");
}
else {
if (GetBoolean(object, "use")) {
var menu = NewStringDictionary();
var candidates = NewObjectList();
var candidates = CreateUseMenuList (object);
if (ListCount(candidates) == 0) {
OutputText (Template("NoObjectsAvailable"));
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "usemenuobject", object);
if (HasString(object, "usemenuprompt")) {
var menucaption = object.usemenuprompt;
}
else {
var menucaption = Template("UseOnMenu");
}
ShowMenu (menucaption, menu, true, function (result) { if (result != null) {
HandleUseOn (e_game.pov.usemenuobject, GetObject(result));
set(e_game.pov, "usemenuobject", null);
} });
}
}
else {
OutputText (overloadedFunctions.DynamicTemplate("CantUse", object));
}
} },
"_js_name": "e_use",
"_types": ["defaultcommand"]
};
elementsNameMap["use"] = e_use;
allCommands.push(e_use);
objectsNameMap["use"] = e_use;
e_undo = {
"elementtype": "object",
"name": "undo",
"type": "command",
"pattern": "^undo$",
"isundo": true,
"script": function(parameters) { undo(); },
"_js_name": "e_undo",
"_types": ["defaultcommand"]
};
elementsNameMap["undo"] = e_undo;
allCommands.push(e_undo);
objectsNameMap["undo"] = e_undo;
e_inventory = {
"elementtype": "object",
"name": "inventory",
"type": "command",
"pattern": "^i$|^inv$|^inventory$",
"script": function(parameters) { var list = FormatObjectList(Template("CarryingListHeader"), e_game.pov, Template("And"), ".");
if (list == "") {
OutputText (Template("NotCarryingAnything"));
}
else {
OutputText (list);
} },
"_js_name": "e_inventory",
"_types": ["defaultcommand"]
};
elementsNameMap["inventory"] = e_inventory;
allCommands.push(e_inventory);
objectsNameMap["inventory"] = e_inventory;
e_look = {
"elementtype": "object",
"name": "look",
"type": "command",
"pattern": "^look$|^l$",
"script": function(parameters) { ShowRoomDescription(); },
"_js_name": "e_look",
"_types": ["defaultcommand"]
};
elementsNameMap["look"] = e_look;
allCommands.push(e_look);
objectsNameMap["look"] = e_look;
e_lookdir = {
"elementtype": "object",
"name": "lookdir",
"type": "command",
"pattern": "^look (?<exit>north|east|south|west|northeast|northwest|southeast|southwest|out|up|down|n|e|s|w|ne|nw|se|sw|o|u|d)$",
"script": function(parameters) { var exit = parameters['exit'];
if (HasScript(exit, "look")) {
runscriptattribute2 (exit, "look");
}
else {
var message = overloadedFunctions.DynamicTemplate("YouLooking",exit.alias);
if (HasString(exit, "look")) {
if (exit.look != "") {
var message = exit.look;
}
}
if (exit.locked) {
if (HasString(exit,"lockmessage")) {
var lockmessage = exit.lockmessage;
}
else {
var lockmessage = Template("LockedExit");
}
OutputText (message+" "+lockmessage);
}
else {
OutputText (message);
}
} },
"_js_name": "e_lookdir",
"_types": ["defaultcommand"]
};
elementsNameMap["lookdir"] = e_lookdir;
allCommands.push(e_lookdir);
objectsNameMap["lookdir"] = e_lookdir;
e_quit = {
"elementtype": "object",
"name": "quit",
"type": "command",
"pattern": "^quit$",
"script": function(parameters) { request ("Quit", ""); },
"_js_name": "e_quit",
"_types": ["defaultcommand"]
};
elementsNameMap["quit"] = e_quit;
allCommands.push(e_quit);
objectsNameMap["quit"] = e_quit;
e_go = {
"elementtype": "object",
"name": "go",
"type": "command",
"pattern": "^go to (?<exit>.*)$|^go (?<g2_map_exit>.*)$|^(?<g3_map_exit>north|east|south|west|northeast|northwest|southeast|southwest|in|out|up|down|n|e|s|w|ne|nw|se|sw|o|u|d)$",
"unresolved": "You can't go there.",
"script": function(parameters) { var exit = parameters['exit'];
if (exit.visible) {
if (exit.locked) {
OutputText (exit.lockmessage);
}
else if (exit.runscript) {
if (HasScript(exit, "script")) {
runscriptattribute2 (exit, "script");
}
}
else if (exit.lookonly) {
OutputText ("You can't go there.");
}
else {
set(e_game.pov, "parent", exit.to);
}
}
else {
OutputText ("You can't go there.");
} },
"_js_name": "e_go",
"_types": ["defaultcommand"]
};
elementsNameMap["go"] = e_go;
allCommands.push(e_go);
objectsNameMap["go"] = e_go;
e_open = {
"elementtype": "object",
"name": "open",
"type": "command",
"pattern": "^open (?<object>.*)$",
"script": function(parameters) { var object = parameters['object'];
TryOpenClose (true, object); },
"_js_name": "e_open",
"_types": ["defaultcommand"]
};
elementsNameMap["open"] = e_open;
allCommands.push(e_open);
objectsNameMap["open"] = e_open;
e_close = {
"elementtype": "object",
"name": "close",
"type": "command",
"pattern": "^close (?<object>.*)$",
"script": function(parameters) { var object = parameters['object'];
TryOpenClose (false, object); },
"_js_name": "e_close",
"_types": ["defaultcommand"]
};
elementsNameMap["close"] = e_close;
allCommands.push(e_close);
objectsNameMap["close"] = e_close;
e_put = {
"elementtype": "object",
"name": "put",
"type": "command",
"pattern": "^put (?<object1>.*) (on|in) (?<object2>.*)$",
"script": function(parameters) { var object1 = parameters['object1'];
var object2 = parameters['object2'];
if (object1.parent == object2) {
OutputText (overloadedFunctions.DynamicTemplate("AlreadyThere", object1));
}
else if (!(ListContains(ScopeInventory(), object1))) {
OutputText (overloadedFunctions.DynamicTemplate("NotCarrying", object1));
}
else if (!(ListContains(ScopeReachable(), object1))) {
OutputText (overloadedFunctions.DynamicTemplate("ObjectNotOpen", GetBlockingObject(object1)));
}
else if (!(ListContains(ScopeReachable(), object2))) {
OutputText (overloadedFunctions.DynamicTemplate("ObjectNotOpen", GetBlockingObject(object2)));
}
else if (!(object2.container)) {
OutputText (Template("CannotDoThat"));
}
else if (!(object2.isopen)) {
OutputText (overloadedFunctions.DynamicTemplate("ObjectNotOpen", object2));
}
else {
if (GetBoolean(object2, "hidechildren")) {
set(object2, "hidechildren", false);
}
if (HasDelegateImplementation(object2, "addscript")) {
rundelegate (object2, "addscript", object1);
}
else {
set(object1, "parent", object2);
OutputText (Template("Done"));
}
} },
"_js_name": "e_put",
"_types": ["defaultcommand"]
};
elementsNameMap["put"] = e_put;
allCommands.push(e_put);
objectsNameMap["put"] = e_put;
e_removefrom = {
"elementtype": "object",
"name": "removefrom",
"type": "command",
"pattern": "^remove (?<object1>.*) from (?<object2>.*)$",
"script": function(parameters) { var object1 = parameters['object1'];
var object2 = parameters['object2'];
if (!(Contains(object2, object1))) {
OutputText (overloadedFunctions.DynamicTemplate("ObjectDoesNotContain", object2, object1));
}
else {
DoTake (object1, false);
} },
"_js_name": "e_removefrom",
"_types": ["defaultcommand"]
};
elementsNameMap["removefrom"] = e_removefrom;
allCommands.push(e_removefrom);
objectsNameMap["removefrom"] = e_removefrom;
e_givesingle = {
"elementtype": "object",
"name": "givesingle",
"type": "command",
"pattern": "^give (?<object>.*)$",
"script": function(parameters) { var object = parameters['object'];
if (HasScript(object, "givesingle")) {
runscriptattribute2 (object, "givesingle");
}
else {
if (GetBoolean(object, "givesingle")) {
var menu = NewStringDictionary();
var candidates = NewObjectList();
var candidates = CreateGiveMenuList (object);
if (ListCount(candidates) == 0) {
OutputText (Template("NoObjectsAvailable"));
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "givemenuobject", object);
if (HasString(object, "givemenuprompt")) {
var menucaption = object.givemenuprompt;
}
else {
var menucaption = Template("GiveToMenu");
}
ShowMenu (menucaption, menu, true, function (result) { if (result != null) {
HandleGiveTo (e_game.pov.givemenuobject, GetObject(result));
set(e_game.pov, "givemenuobject", null);
} });
}
}
else {
OutputText (overloadedFunctions.DynamicTemplate("CantGive", object));
}
} },
"_js_name": "e_givesingle",
"_types": ["defaultcommand"]
};
elementsNameMap["givesingle"] = e_givesingle;
allCommands.push(e_givesingle);
objectsNameMap["givesingle"] = e_givesingle;
e_give = {
"elementtype": "object",
"name": "give",
"type": "command",
"pattern": "^give (?<object1>.*) to (?<object2>.*)$",
"script": function(parameters) { var object1 = parameters['object1'];
var object2 = parameters['object2'];
HandleGiveTo (object1, object2); },
"_js_name": "e_give",
"_types": ["defaultcommand"]
};
elementsNameMap["give"] = e_give;
allCommands.push(e_give);
objectsNameMap["give"] = e_give;
e_useon = {
"elementtype": "object",
"name": "useon",
"type": "command",
"pattern": "^use (?<object1>.*) (on|with) (?<object2>.*)$",
"script": function(parameters) { var object1 = parameters['object1'];
var object2 = parameters['object2'];
HandleUseOn (object1, object2); },
"_js_name": "e_useon",
"_types": ["defaultcommand"]
};
elementsNameMap["useon"] = e_useon;
allCommands.push(e_useon);
objectsNameMap["useon"] = e_useon;
e_ask = {
"elementtype": "object",
"name": "ask",
"type": "command",
"pattern": "^ask (?<object>.*) about (?<text>.*)$",
"script": function(parameters) { var object = parameters['object'];
var text = parameters['text'];
DoAskTell (object, text, "ask", "askdefault", "DefaultAsk"); },
"_js_name": "e_ask",
"_types": ["defaultcommand"]
};
elementsNameMap["ask"] = e_ask;
allCommands.push(e_ask);
objectsNameMap["ask"] = e_ask;
e_tell = {
"elementtype": "object",
"name": "tell",
"type": "command",
"pattern": "^tell (?<object>.*) about (?<text>.*)$",
"script": function(parameters) { var object = parameters['object'];
var text = parameters['text'];
DoAskTell (object, text, "tell", "telldefault", "DefaultTell"); },
"_js_name": "e_tell",
"_types": ["defaultcommand"]
};
elementsNameMap["tell"] = e_tell;
allCommands.push(e_tell);
objectsNameMap["tell"] = e_tell;
e_oops = {
"elementtype": "object",
"name": "oops",
"type": "command",
"pattern": "^oops (?<text>.*)$",
"isoops": true,
"script": function(parameters) { var text = parameters['text'];
var hasoops = false;
if (HasAttribute(e_game, "unresolvedcommand")) {
if (e_game.unresolvedcommand != null) {
var hasoops = true;
}
}
if (!(hasoops)) {
OutputText (Template("DefaultOops"));
}
else {
dictionaryremove (e_game.unresolvedcommandvarlist, e_game.unresolvedcommandkey);
dictionaryadd (e_game.unresolvedcommandvarlist, e_game.unresolvedcommandkey, text);
HandleSingleCommandPattern ("", e_game.unresolvedcommand, e_game.unresolvedcommandvarlist);
} },
"_js_name": "e_oops",
"_types": ["defaultcommand"]
};
elementsNameMap["oops"] = e_oops;
allCommands.push(e_oops);
objectsNameMap["oops"] = e_oops;
e_speak = {
"elementtype": "object",
"name": "speak",
"displayverb" : "Speak to",// JS VOURTRAM
"type": "command",
"property": "speak",
"isverb": true,
"pattern": "^speak (to|with) (?<object>.*)$|^speak (?<g2_map_object>.*)$|^talk to (?<g3_map_object>.*)$|^talk (?<g4_map_object>.*)$",
"defaulttemplate": "DefaultSpeakTo",
"_js_name": "e_speak",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["speak"] = e_speak;
allCommands.push(e_speak);
objectsNameMap["speak"] = e_speak;
e_buy = {
"elementtype": "object",
"name": "buy",
"type": "command",
"property": "buy",
"isverb": true,
"pattern": "^buy (?<object>.*)$",
"defaulttemplate": "DefaultBuy",
"_js_name": "e_buy",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["buy"] = e_buy;
allCommands.push(e_buy);
objectsNameMap["buy"] = e_buy;
e_climb = {
"elementtype": "object",
"name": "climb",
"type": "command",
"property": "climb",
"isverb": true,
"pattern": "^climb (?<object>.*)$",
"defaulttemplate": "DefaultClimb",
"_js_name": "e_climb",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["climb"] = e_climb;
allCommands.push(e_climb);
objectsNameMap["climb"] = e_climb;
e_drink = {
"elementtype": "object",
"name": "drink",
"type": "command",
"property": "drink",
"isverb": true,
"pattern": "^drink (?<object>.*)$",
"defaulttemplate": "DefaultDrink",
"_js_name": "e_drink",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["drink"] = e_drink;
allCommands.push(e_drink);
objectsNameMap["drink"] = e_drink;
e_eat = {
"elementtype": "object",
"name": "eat",
"type": "command",
"property": "eat",
"isverb": true,
"pattern": "^eat (?<object>.*)$",
"defaulttemplate": "DefaultEat",
"_js_name": "e_eat",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["eat"] = e_eat;
allCommands.push(e_eat);
objectsNameMap["eat"] = e_eat;
e_hit = {
"elementtype": "object",
"name": "hit",
"type": "command",
"property": "hit",
"isverb": true,
"pattern": "^hit (?<object>.*)$",
"defaulttemplate": "DefaultHit",
"_js_name": "e_hit",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["hit"] = e_hit;
allCommands.push(e_hit);
objectsNameMap["hit"] = e_hit;
e_kill = {
"elementtype": "object",
"name": "kill",
"type": "command",
"property": "kill",
"isverb": true,
"pattern": "^kill (?<object>.*)$",
"defaulttemplate": "DefaultKill",
"_js_name": "e_kill",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["kill"] = e_kill;
allCommands.push(e_kill);
objectsNameMap["kill"] = e_kill;
e_kiss = {
"elementtype": "object",
"name": "kiss",
"type": "command",
"property": "kiss",
"isverb": true,
"pattern": "^kiss (?<object>.*)$",
"defaulttemplate": "DefaultKiss",
"_js_name": "e_kiss",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["kiss"] = e_kiss;
allCommands.push(e_kiss);
objectsNameMap["kiss"] = e_kiss;
e_knock = {
"elementtype": "object",
"name": "knock",
"type": "command",
"property": "knock",
"isverb": true,
"pattern": "^knock (?<object>.*)$",
"defaulttemplate": "DefaultKnock",
"_js_name": "e_knock",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["knock"] = e_knock;
allCommands.push(e_knock);
objectsNameMap["knock"] = e_knock;
e_lick = {
"elementtype": "object",
"name": "lick",
"type": "command",
"property": "lick",
"isverb": true,
"pattern": "^lick (?<object>.*)$",
"defaulttemplate": "DefaultLick",
"_js_name": "e_lick",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["lick"] = e_lick;
allCommands.push(e_lick);
objectsNameMap["lick"] = e_lick;
e_lieon = {
"elementtype": "object",
"name": "lieon",
"type": "command",
"property": "lie",
"isverb": true,
"pattern": "^lie on (?<object>.*)$|^lie upon (?<g2_map_object>.*)$|^lie down on (?<g3_map_object>.*)$|^lie down upon (?<g4_map_object>.*)$",
"defaulttemplate": "DefaultLie",
"_js_name": "e_lieon",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["lieon"] = e_lieon;
allCommands.push(e_lieon);
objectsNameMap["lieon"] = e_lieon;
e_listento = {
"elementtype": "object",
"name": "listento",
"type": "command",
"property": "listen",
"isverb": true,
"pattern": "^listen to (?<object>.*)$",
"defaulttemplate": "DefaultListenTo",
"_js_name": "e_listento",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["listento"] = e_listento;
allCommands.push(e_listento);
objectsNameMap["listento"] = e_listento;
e_lock = {
"elementtype": "object",
"name": "lock",
"type": "command",
"property": "lock",
"isverb": true,
"pattern": "^lock (?<object>.*)$",
"defaulttemplate": "DefaultLock",
"_js_name": "e_lock",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["lock"] = e_lock;
allCommands.push(e_lock);
objectsNameMap["lock"] = e_lock;
e_move = {
"elementtype": "object",
"name": "move",
"type": "command",
"property": "move",
"isverb": true,
"pattern": "^move (?<object>.*)$",
"defaulttemplate": "DefaultMove",
"_js_name": "e_move",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["move"] = e_move;
allCommands.push(e_move);
objectsNameMap["move"] = e_move;
e_pull = {
"elementtype": "object",
"name": "pull",
"type": "command",
"property": "pull",
"isverb": true,
"pattern": "^pull (?<object>.*)$",
"defaulttemplate": "DefaultPull",
"_js_name": "e_pull",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["pull"] = e_pull;
allCommands.push(e_pull);
objectsNameMap["pull"] = e_pull;
e_push = {
"elementtype": "object",
"name": "push",
"type": "command",
"property": "push",
"isverb": true,
"pattern": "^push (?<object>.*)$",
"defaulttemplate": "DefaultPush",
"_js_name": "e_push",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["push"] = e_push;
allCommands.push(e_push);
objectsNameMap["push"] = e_push;
e_read = {
"elementtype": "object",
"name": "read",
"type": "command",
"property": "read",
"isverb": true,
"pattern": "^read (?<object>.*)$",
"defaulttemplate": "DefaultRead",
"_js_name": "e_read",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["read"] = e_read;
allCommands.push(e_read);
objectsNameMap["read"] = e_read;
e_search = {
"elementtype": "object",
"name": "search",
"type": "command",
"property": "search",
"isverb": true,
"pattern": "^search (?<object>.*)$",
"defaulttemplate": "DefaultSearch",
"_js_name": "e_search",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["search"] = e_search;
allCommands.push(e_search);
objectsNameMap["search"] = e_search;
e_show = {
"elementtype": "object",
"name": "show",
"type": "command",
"property": "show",
"isverb": true,
"pattern": "^show (?<object>.*)$",
"defaulttemplate": "DefaultShow",
"_js_name": "e_show",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["show"] = e_show;
allCommands.push(e_show);
objectsNameMap["show"] = e_show;
e_siton = {
"elementtype": "object",
"name": "siton",
"type": "command",
"property": "sit",
"isverb": true,
"pattern": "^sit on (?<object>.*)$|^sit upon (?<g2_map_object>.*)$|^sit down on (?<g3_map_object>.*)$|^sit down upon (?<g4_map_object>.*)$",
"defaulttemplate": "DefaultSit",
"_js_name": "e_siton",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["siton"] = e_siton;
allCommands.push(e_siton);
objectsNameMap["siton"] = e_siton;
e_smell = {
"elementtype": "object",
"name": "smell",
"type": "command",
"property": "smell",
"isverb": true,
"pattern": "^smell (?<object>.*)$|^sniff (?<g2_map_object>.*)$",
"defaulttemplate": "DefaultSmell",
"_js_name": "e_smell",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["smell"] = e_smell;
allCommands.push(e_smell);
objectsNameMap["smell"] = e_smell;
e_taste = {
"elementtype": "object",
"name": "taste",
"type": "command",
"property": "taste",
"isverb": true,
"pattern": "^taste (?<object>.*)$",
"defaulttemplate": "DefaultTaste",
"_js_name": "e_taste",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["taste"] = e_taste;
allCommands.push(e_taste);
objectsNameMap["taste"] = e_taste;
e_throw = {
"elementtype": "object",
"name": "throw",
"type": "command",
"property": "throw",
"isverb": true,
"pattern": "^throw (?<object>.*)$",
"defaulttemplate": "DefaultThrow",
"_js_name": "e_throw",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["throw"] = e_throw;
allCommands.push(e_throw);
objectsNameMap["throw"] = e_throw;
e_tie = {
"elementtype": "object",
"name": "tie",
"type": "command",
"property": "tie",
"isverb": true,
"pattern": "^tie (?<object>.*)$",
"defaulttemplate": "DefaultTie",
"_js_name": "e_tie",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["tie"] = e_tie;
allCommands.push(e_tie);
objectsNameMap["tie"] = e_tie;
e_touch = {
"elementtype": "object",
"name": "touch",
"type": "command",
"property": "touch",
"isverb": true,
"pattern": "^touch (?<object>.*)$",
"defaulttemplate": "DefaultTouch",
"_js_name": "e_touch",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["touch"] = e_touch;
allCommands.push(e_touch);
objectsNameMap["touch"] = e_touch;
e_turnon = {
"elementtype": "object",
"name": "turnon",
"type": "command",
"property": "turnon",
"isverb": true,
"pattern": "^turn on (?<object>.*)$|^turn (?<g2_map_object>.*) on$|^switch on (?<g3_map_object>.*)$|^switch (?<g4_map_object>.*) on$",
"defaulttemplate": "DefaultTurnOn",
"_js_name": "e_turnon",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["turnon"] = e_turnon;
allCommands.push(e_turnon);
objectsNameMap["turnon"] = e_turnon;
e_turnoff = {
"elementtype": "object",
"name": "turnoff",
"type": "command",
"property": "turnoff",
"isverb": true,
"pattern": "^turn off (?<object>.*)$|^turn (?<g2_map_object>.*) off$|^switch off (?<g3_map_object>.*)$|^switch (?<g4_map_object>.*) off$",
"defaulttemplate": "DefaultTurnOff",
"_js_name": "e_turnoff",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["turnoff"] = e_turnoff;
allCommands.push(e_turnoff);
objectsNameMap["turnoff"] = e_turnoff;
e_turn = {
"elementtype": "object",
"name": "turn",
"type": "command",
"property": "turn",
"isverb": true,
"pattern": "^turn (?<object>.*)$",
"defaulttemplate": "DefaultTurn",
"_js_name": "e_turn",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["turn"] = e_turn;
allCommands.push(e_turn);
objectsNameMap["turn"] = e_turn;
e_unlock = {
"elementtype": "object",
"name": "unlock",
"type": "command",
"property": "unlock",
"isverb": true,
"pattern": "^unlock (?<object>.*)$",
"defaulttemplate": "DefaultUnlock",
"_js_name": "e_unlock",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["unlock"] = e_unlock;
allCommands.push(e_unlock);
objectsNameMap["unlock"] = e_unlock;
e_untie = {
"elementtype": "object",
"name": "untie",
"type": "command",
"property": "untie",
"isverb": true,
"pattern": "^untie (?<object>.*)$",
"defaulttemplate": "DefaultUntie",
"_js_name": "e_untie",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["untie"] = e_untie;
allCommands.push(e_untie);
objectsNameMap["untie"] = e_untie;
e_wear = {
"elementtype": "object",
"name": "wear",
"type": "command",
"property": "wear",
"isverb": true,
"pattern": "^wear (?<object>.*)$",
"defaulttemplate": "DefaultWear",
"_js_name": "e_wear",
"_types": ["defaultverb", "defaultcommand"],
"separator": "with; using",
"multiobjectmenu": "With which object?",
"multiobjectdefault": "That doesn't work.",
"multiobjectmenuempty": "There are no objects available to do that with.",
"script": function(parameters) { var object = parameters['object'];
if (!(IsDefined("object2"))) {
var object2 = null;
}
switch (overloadedFunctions.TypeOf(object, this.property)) {
case "script":
if (object2 == null) {
runscriptattribute2 (object, this.property);
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "string":
if (object2 == null) {
OutputText (GetString(object, this.property));
}
else {
OutputText (this.multiobjectdefault);
}
break;
case "scriptdictionary":
if (object2 != null) {
HandleMultiVerb (object, this.property, object2, this.multiobjectdefault);
}
else {
var menu = NewStringDictionary();
var objectlist = ListCombine (ScopeReachableInventory(), ScopeReachableNotHeld());
var excludelist = NewObjectList();
listadd (excludelist, e_game.pov);
listadd (excludelist, object);
var candidates = ListExclude(RemoveSceneryObjects(objectlist), excludelist);
if (ListCount(candidates) == 0) {
OutputText (this.multiobjectmenuempty);
}
else {
GenerateMenuChoices (menu, candidates);
set(e_game.pov, "multiverb", this.property);
set(e_game.pov, "multiverbobject", object);
set(e_game.pov, "multiverbobjectdefault", this.multiobjectdefault);
ShowMenu (this.multiobjectmenu, menu, true, function (result) { if (result != null) {
HandleMultiVerb (e_game.pov.multiverbobject, e_game.pov.multiverb, GetObject(result), e_game.pov.multiverbobjectdefault);
set(e_game.pov, "multiverb", null);
set(e_game.pov, "multiverbobject", null);
set(e_game.pov, "multiverbobjectdefault", null);
} });
}
}
break;
case "null":
if (this.defaulttext != null) {
OutputText (this.defaulttext);
}
else if (this.defaulttemplate != null) {
OutputText (overloadedFunctions.DynamicTemplate(this.defaulttemplate, object));
}
else if (this.defaultexpression != null) {
var params = NewDictionary();
dictionaryadd (params, "object", object);
OutputText (overloadedFunctions.Eval(this.defaultexpression, params));
}
else {
error ("No verb response defined");
}
break;
default:
error ("No verb response defined");
} }
};
elementsNameMap["wear"] = e_wear;
allCommands.push(e_wear);
objectsNameMap["wear"] = e_wear;
e_listen = {
"elementtype": "object",
"name": "listen",
"type": "command",
"pattern": "^listen$",
"script": function(parameters) { OutputText (Template("DefaultListen")); },
"_js_name": "e_listen",
"_types": ["defaultcommand"]
};
elementsNameMap["listen"] = e_listen;
allCommands.push(e_listen);
objectsNameMap["listen"] = e_listen;
e_jump = {
"elementtype": "object",
"name": "jump",
"type": "command",
"pattern": "^jump$",
"script": function(parameters) { OutputText (Template("DefaultJump")); },
"_js_name": "e_jump",
"_types": ["defaultcommand"]
};
elementsNameMap["jump"] = e_jump;
allCommands.push(e_jump);
objectsNameMap["jump"] = e_jump;
e_sit = {
"elementtype": "object",
"name": "sit",
"type": "command",
"pattern": "^sit$|^sit down$",
"script": function(parameters) { OutputText (Template("DefaultSitDown")); },
"_js_name": "e_sit",
"_types": ["defaultcommand"]
};
elementsNameMap["sit"] = e_sit;
allCommands.push(e_sit);
objectsNameMap["sit"] = e_sit;
e_lie = {
"elementtype": "object",
"name": "lie",
"type": "command",
"pattern": "^lie$|^lie down$",
"script": function(parameters) { OutputText (Template("DefaultLieDown")); },
"_js_name": "e_lie",
"_types": ["defaultcommand"]
};
elementsNameMap["lie"] = e_lie;
allCommands.push(e_lie);
objectsNameMap["lie"] = e_lie;
e_sleep = {
"elementtype": "object",
"name": "sleep",
"type": "command",
"pattern": "^sleep$|^rest$",
"script": function(parameters) { OutputText (Template("DefaultSleep")); },
"_js_name": "e_sleep",
"_types": ["defaultcommand"]
};
elementsNameMap["sleep"] = e_sleep;
allCommands.push(e_sleep);
objectsNameMap["sleep"] = e_sleep;
e_wait = {
"elementtype": "object",
"name": "wait",
"type": "command",
"pattern": "^wait$|^z$",
"script": function(parameters) { OutputText (Template("DefaultWait")); },
"_js_name": "e_wait",
"_types": ["defaultcommand"]
};
elementsNameMap["wait"] = e_wait;
allCommands.push(e_wait);
objectsNameMap["wait"] = e_wait;
e_xyzzy = {
"elementtype": "object",
"name": "xyzzy",
"type": "command",
"pattern": "^xyzzy$",
"script": function(parameters) { OutputText (Template("DefaultXyzzy")); },
"_js_name": "e_xyzzy",
"_types": ["defaultcommand"]
};
elementsNameMap["xyzzy"] = e_xyzzy;
allCommands.push(e_xyzzy);
objectsNameMap["xyzzy"] = e_xyzzy;
e_help = {
"elementtype": "object",
"name": "help",
"type": "command",
"pattern": "^help$|^\\?$",
"script": function(parameters) { OutputText (Template("DefaultHelp")); },
"_js_name": "e_help",
"_types": ["defaultcommand"]
};
elementsNameMap["help"] = e_help;
allCommands.push(e_help);
objectsNameMap["help"] = e_help;
e_save = {
"elementtype": "object",
"name": "save",
"type": "command",
"pattern": "^save$",
"script": function(parameters) { request ("RequestSave", ""); },
"_js_name": "e_save",
"_types": ["defaultcommand"]
};
elementsNameMap["save"] = e_save;
allCommands.push(e_save);
objectsNameMap["save"] = e_save;
e_clue = {
"elementtype": "object",
"name": "clue",
"type": "command",
"pattern": "^clue$|^clues$|^hint$|^hints$",
"script": function(parameters) { OutputText ("Select the text between the brackets to reveal the clue.");
if (e_player.level<3 && e_player.class!="none") {
invisClue ("What am I doing now?", "You have to perform quests to the guildmasters, in order to increase your score.");
}
if (e_player.level==0) {
if (e_player.class=="none") {
invisClue ("You must pick a profession by finding a guild", "You can train to be a warrior, a mage, or a thief.");
invisClue ("The Warrior's guild is", "North and Northeast.");
invisClue ("The Wizard's guild is", "North and Northwest.");
invisClue ("The Thief's guild is", "North, West, South, West.");
invisClue ("Once in the guild", "Speak to the guildmaster: Derrick, Dashiel or Kadrak.");
}
else if (e_player.isWarrior) {
invisClue ("I'm a warrior, what now?", "Ask Derrick about training.");
invisClue ("Where is the thug?", "Look at the bakery.");
invisClue ("How can I defeat the thug?", "Throw a spear at him.");
}
else if (e_player.isThief) {
invisClue ("I'm a thief, what now?", "Ask Kadrak about training.");
invisClue ("Where can I steal a necklace?", "Look at the bakery.");
invisClue ("But where is the necklace?", "Look at the second floor of the bakery.");
invisClue ("But how can I enter there?", "Climb the tree.");
invisClue ("But I can't get the necklace", "Try to picklock the table.");
invisClue ("But... I still can't get the necklace", "Try to hide under the bed.");
invisClue ("Got the necklace, and now?", "Give the necklace to Kadrak.");
}
else if (e_player.isMage) {
invisClue ("I'm a wizard, what now?", "Ask Dashiel about training.");
invisClue ("Where is the wolf?", "Go to the maze (east of market), then north, then east.");
invisClue ("The wolf tries to kill me", "Cast calm at wolf.");
invisClue ("Where is the fur?", "Look at the lair.");
invisClue ("I can't get the fur!", "Lure the wolf out the lair and then cast calm.");
invisClue ("What do I do with the fur?", "Give to Dashiel. He will give a potion to you. Use the potion with the wolf.");
}
if (e_player.class!="none") {
invisClue ("Finished the quest, what now?", "Ask your guildmaster about training.");
}
}
else if (e_player.level==1) {
if (e_player.isWarrior) {
invisClue ("Where are the hills?", "Go east to the maze, and then go north.");
invisClue ("Found the wolf, but I got stuck", "Pay a visit to the baker. Is anything different?");
invisClue ("Still stuck with the wolf?", "Talk to the red hooded girl in front of the bakery.");
invisClue ("I helped the girl, what now?", "The wolf follows you. Make the wolf sees the red hooded girl.");
invisClue ("Defeated the wolf, what now?", "Give his corpse to Derrick.");
}
else if (e_player.isThief) {
invisClue ("Where is the thug?", "Look at the gray tavern, east and north of the thieves guild.");
invisClue ("I cannot stab the thug", "You need to find a distraction. Look for the yellow hooded girl at the dark alley.");
invisClue ("I need something valuable", "Perhaps someone in the tavern has something of worth.");
invisClue ("How do I steal an object from someone?", "Try to buy a drink.");
invisClue ("I still can't finish the thug", "Steal the ring from the drunk guy, give the ring to the girl, and stab thug.");
}
else if (e_player.isMage) {
invisClue ("Where do I start?", "Start by playing with the new reveal spell. Cast reveal everywhere.");
invisClue ("Can't find anything interesting with reveal", "Try at the dark alley. Talk to the Kobold.");
invisClue ("Who has the Kobold's ring", "Kadrak, at the guild of thieves, west of the dark alley.");
invisClue ("How do I get the Kobold's ring", "Cast reveal at the guild of mages. Give the diamond to Kadrak.");
invisClue ("After giving the ring to the Kobold...", "North, and east four times.");
}
}
else if (e_player.level==2) {
if (e_player.isWarrior) {
invisClue ("Where is the tournament?", "In the courtyard, north of the market. Speak to the referee.");
invisClue ("I can't win the tournament", "fight derrick until he tells you are ready.");
invisClue ("Where can I find protection?", "look at the pile of armor in the courtyard.");
invisClue ("What about headgear?", "Talk to the baker. Give the pot to the dog.");
invisClue ("I am out of money", "Talk to Coriander.");
}
else if (e_player.isThief) {
invisClue ("Can't steal from Dashiel!", "Examine the trash in his laboratory.");
invisClue ("Can't steal from Derrick!", "To prevent the trap, replace the gold dagger with your dagger.");
}
else if (e_player.isMage) {
invisClue ("How do I start?", "Take a look at the board in the courtyard.");
invisClue ("Can't get the paper in the tree?", "You will need the apportation spell, seek Rafaella in the tavern.");
invisClue ("How do I learn the new spell?", "Talk to Rafaella in the tavern. She will make a request.");
invisClue ("Where is the pie?", "Go to the hills, north of the maze. Search the red hooded girl.");
invisClue ("How do I get the pie?", "Go to the courtyard and examine the armour. You will find the red hat. Give it to the girl.");
invisClue ("Got the paper, now what?", "Give it to Dashiel.");
invisClue ("I\u00b4m still lost", "Look board, talk to Raffaella, get hat, give hat to girl, give pie to Raffaella, cast apportation at paper.");
}
}
else if (e_player.level==3) {
invisClue ("What am I doing now?", "You have to get rid of the brigands blocking the way to the castle and meet the King.");
invisClue ("Where should I go?", "Go all way east, then south. You should be able to deal with the Orc now.");
invisClue ("I can't get the bucket", "You have to use the carrots with the bucket.");
if (e_player.isWarrior) {
invisClue ("How do I free the tied man?", "Throw spear at the rope.");
invisClue ("How do I talk to the man?", "You have to wake him up. Perhaps with a bucket of water?");
invisClue ("Where can I fill the bucket?", "At the rapids.");
invisClue ("How do I cross the rapids?", "After cutting the rope, use it with the trees.");
invisClue ("Can't find the Brigand's hideout?", "Talk to Elias. Ask Elias about hideout.");
invisClue ("Cannot enter the hideout?", "Push boulder.");
invisClue ("Removed the brigands? what now?", "Go see the king, north of the courtyard.");
}
else if (e_player.isThief) {
invisClue ("The orc is killing me", "Stab orc.");
invisClue ("How do I free the tied man?", "Climb the tree.");
invisClue ("How do I talk to the man?", "You have to wake him up. Perhaps with a bucket of water?");
invisClue ("Where can I fill the bucket?", "At the rapids.");
invisClue ("How do I cross the rapids?", "After cutting the rope, use it with the trees.");
invisClue ("Can't find the Brigand's hideout?", "Talk to Elias. Ask Elias about hideout.");
invisClue ("Cannot enter the hideout?", "Hide behind bushes. Use the magical word.");
invisClue ("How can I go pass the entrance?", "Climb pallet, turn off lamps, and go.");
invisClue ("Heard the conversation in the cave, what do I do?", "Picklock the chest and replace the potion with water.");
invisClue ("Still lost", "Fill bucket, use bucket with bottle, put bottle in chest, close chest.");
invisClue ("Removed the brigands? what now?", "Go see the king, north of the courtyard.");
}
else if (e_player.isMage) {
invisClue ("The orc is killing me", "Cast calm at orc.");
invisClue ("How do I enter the tower?", "Cast Reveal, cast fetch at lever.");
invisClue ("Where can I get fairy dust?", "At the dark corner, cast reveal. Talk to the fairy.");
invisClue ("Cannot solve the first riddle", "clouds");
invisClue ("Cannot solve the second riddle", "Trow");
invisClue ("How do I free the tied man?", "Cast fetch at the rope to untie it.");
invisClue ("How do I cross the rapids?", "Use your shape plant spell.");
invisClue ("How do I talk to the tied man?", "You have to wake him up. Perhaps with a bucket of water?");
invisClue ("Where can I fill the bucket?", "At the rapids.");
invisClue ("How do I manage the Trow?", "You need the flute. Trade it for the dust. Play the flute and give to the Trow.");
invisClue ("How do I restore the man's memory?", "At Midgaard, the Trow will give you a sword. Give it to the man.");
}
}
else if (e_player.parent==e_battle) {
OutputText ("This is the final showdown! No clues available right now. Use Look, Inventory, and your skills to solve the puzzle.");
}
else if (e_player.level>3) {
invisClue ("What am I doing now?", "You have to enter the castle and find a way to defeat Vourtram.");
invisClue ("I can't walk to the castle", "Take the horse at Sheila's stable.");
invisClue ("I can't find the way back from the castle", "Take the horse at inn.");
invisClue ("Entered the castle, but cannot pass the kitchen!", "Try to get the job of rat killer.");
invisClue ("How to get the job [1]", "Ask Cook About Cooking. While he is out, open cabinet and get trap.");
invisClue ("How to get the job [2]", "Ask Cook About Cooking. Go to the pantry while the cook drinks. Get the wine.");
invisClue ("How to get the job [3]", "Give the wine to the man at the courtyard. Use cheese with trap. Use trap. Give rat to cook.");
invisClue ("What about the music hall?", "There is a secret passage to the dungeon.");
invisClue ("What about the music hall[2]?", "You will need to play a specific tune in the harpsichord.");
invisClue ("What about the music hall[3]?", "If you talked to Amicia, before taking the horse, you will know the tune.");
invisClue ("What about the music hall[4]?", "at the improvised throne room, ask Amicia about harpsichord.");
invisClue ("What about the music hall[5]?", "Talk to the bard and ask for him to play the Pavane. Push wall.");
invisClue ("Can't pass the jailer", "Put herring on the vent on the middle level.");
if (e_player.isWarrior) {
invisClue ("After talking to the king...", "Talk to Derrick. Ask about training.");
invisClue ("How can I enter the castle?", "Find a guard (eastern wall) and drink the disguise potion.");
invisClue ("I'm getting beaten all the time", "Train with Rodney until you can't get anymore experience.");
invisClue ("What about the elf smith?", "Give your sword to him.");
invisClue ("The Captain is unbeatable", "Do you have all the equipment? Helmet, buckler, werewolf jacket, small sword?");
invisClue ("The Captain is unbeatable[2]", "You had better have more than 60 fighting experience to stand a chance.");
invisClue ("The Captain is unbeatable[3]", "If your sword is damaged it won't work.");
invisClue ("The Captain is unbeatable[4]", "Experiment the stances. Ask Derrick about it.");
invisClue ("The Demons are unbeatable", "You will need the elven sword. Give the captain's ring to the elf.");
invisClue ("Can't pass by the wyvern?", "use the horn with the spear and throw it at the wyvern.");
invisClue ("How to get the medallion?", "Talk to the woman in the bedroom. Kill the wyvern and she will help you.");
invisClue ("Can't pass the barred doors in the dungeon", "pull door.");
invisClue ("How to save the princess after releasing her?", "At the music room, look at the great hall, cut ropes...");
invisClue ("How can I defeat the stone god?", "Just push and it will break. You will never win by force.");
invisClue ("Where is the key for the obsidian chamber?", "At the southwestern bedroom, hidden in the paint. The key is in the cupboard of the Captain's Office.");
invisClue ("I'm at the bedroom, but can't find the key?", "At the southwestern bedroom, use the mirror with the opening to reveal the jade key.");
invisClue ("The obsidian chamber is empty!", "You must use the portable portal in the right spot.");
invisClue ("The obsidian chamber is empty[2]!", "Drop the portal at the throne room in the castle and use it there.");
}
else if (e_player.isThief) {
invisClue ("After talking to the king...", "Try to steal money and property. Kadrak can buy the stuff you find.");
invisClue ("How can I enter the castle?", "Climb the sewers at the western wall.");
invisClue ("Entered the throne room, but what now?", "At the dinning room, hide behind the curtains.");
invisClue ("How to remove the guard in the hallway?", "Give the mead to the guard on leave in the courtyard. Give the leave order to the guard at the hallway.");
invisClue ("How can I steal the elf?", "Wait for the moment he is doing loud sounds and take the mead.");
invisClue ("How can I enter the captain's Office?", "Climb the window in the hallway.");
invisClue ("How can I enter the captain's Office[2]?", "Stab the captain from outside the window.");
invisClue ("How can I pass the demon?", "Hide at archway.");
invisClue ("How can I pass the demon[2]?", "Throw rock. You can get the rock at the maze.");
invisClue ("How to steal the treasury?", "You will need the Kadrack's invisibility potion.");
invisClue ("How can I make money?", "The locked bedrooms in the corridor are full of valuable items.");
invisClue ("How can I make money[2]?", "After the arrival of the bard, the dancing couples can also be stolen.");
invisClue ("What can I steal from the southern bedroom?", "open chest, hide at chest, take all in chest, examine the bed while the woman is out.");
invisClue ("What can I steal from the western bedroom?", "When the man knocks the door, use the dress and stab him as soon as possible.");
invisClue ("How can I return from the corridor area?", "One of the rooms has a window. Open and climb. You can now go up by this entrance, instead of passing by the demon.");
invisClue ("Can't pass by the wyvern?", "Give sweeties to him.");
invisClue ("Can't pass by the wyvern[2]?", "Steal sugar from the cook. Get the candies in the Captain's Office.");
invisClue ("Got the medallion, how to escape Vourtram?", "Climb the window!");
invisClue ("Got the medallion, how to escape Vourtram[2]?", "Use medallion. DON\u00b4T BREAK IT.");
invisClue ("Where is the key for the treasury?", "Push the cupboard at the captain's office.");
invisClue ("Can't pass the barred doors in the dungeon", "Get the horn at the throne room and use it with the barred doors.");
invisClue ("How to save the princess after releasing her?", "At the music room, look at the great hall, cut ropes...");
invisClue ("How can I enter the temple in the portable portal?", "examine statues, get rope and climb columns.");
invisClue ("How can I defeat the stone god?", "fill the bucket with water, use bucket with pentagram.");
invisClue ("Can't picklock the keyhole in the temple?", "You will need the key.");
invisClue ("Where is the key for the obsidian chamber?", "At the southwestern bedroom, hidden in the paint.");
invisClue ("I'm at the bedroom, but can't find the key?", "At the southwestern bedroom, use the mirror with the opening to reveal the jade key.");
invisClue ("The obsidian chamber is empty!", "You must use the portable portal in the right spot.");
invisClue ("The obsidian chamber is empty[2]!", "Drop the portal at the throne room in the castle and use it there.");
}
else if (e_player.isMage) {
invisClue ("After talking to the king...", "Talk to Dashiel. Ask about training.");
invisClue ("How can I enter the castle?", "Talk to Eva. Perhaps you can put the teleport orb with the apples.");
invisClue ("Still can't enter the castle?", "Cast blind at Eva. Use orb with stand. Cast teleport.");
invisClue ("How to pass by Medusa", "Cast blind at Medusa. Get the knapsack hidden at the statues and use it with Medusa.");
invisClue ("Stuck in the library?", "Cast reveal.");
invisClue ("Stuck in the library [2]?", "Cast calm at firewall.");
invisClue ("Cannot get that thing in the library?", "Cast apportation at parchment.");
invisClue ("What should I do with the levitation spell?", "Try to cast levitate at the well on the courtyard.");
invisClue ("What about the bookcase?", "Down the well, examine the wall, push the runes, get the book. Use the book with the bookcase.");
invisClue ("What about the dragon?", "You need to find the key. It is at the throne room, cast reveal.");
invisClue ("What about the portal?", "Levitate and use the teleport orb. Get the key that will free the dragon.");
invisClue ("How do I get out?", "Levitate down the well, go to the ramp.");
invisClue ("What do I do with the diary?", "Give it to Dashiel?");
invisClue ("Who is the last wizard?", "Erasmus the cat, you will need to make a potion to turn him back.");
invisClue ("How do I make the potion?", "The recipe is on the blue book. Turn on the cauldron. Put all ingredients at the cauldron.");
invisClue ("Where can I find ashes?", "At the trophy room, look at the armour. Get the burned shield. It will do it.");
invisClue ("Where can I find the other ingredients?", "Cheese from the man at courtyard. Garlic on the pantry. Everything else at the shelf.");
invisClue ("How do I pass the guard at the hall?", "Examine the window. Pull the vines. Blind the guard. Shape the vines.");
invisClue ("How do I pass the demons?", "Erasmus will give you the banish spell.");
invisClue ("Can't pass the barred doors in the dungeon", "Get the horn at the throne room and use it with the barred doors.");
invisClue ("Opened the princess cell. Talked to her. And now?", "Leave the orb in the sewers, meet the princess, teleport both of you, go ramp...");
invisClue ("How do I pass the wyvern?", "cast calm.");
invisClue ("How do I take the medallion?", "cast apportation.");
invisClue ("How can I defeat the stone god?", "cast levitate, fill the bucket with water, use bucket with pentagram.");
invisClue ("Got stuck at the portable portal 'ocean'", "calm the water, shape fern, fetch lever.");
}
invisClue ("I think I am ready to defeat Vourtram...", "stay the night at the inn.");
} 
//JS
$('font.clue').click(function() {
            this.color="black";
        });
},
"_js_name": "e_clue",
"_types": ["defaultcommand"]
};
elementsNameMap["clue"] = e_clue;
allCommands.push(e_clue);
objectsNameMap["clue"] = e_clue;
e_start = {
"elementtype": "object",
"name": "start",
"type": "object",
"usedefaultprefix": false,
"descprefix": "",
"objectslistprefix": "",
"description": "",
"alias": " ",
"callback": false,
"loading": false,
"beforefirstenter": function() { set(e_game, "autodescription_youarein_useprefix", false);
initMultiSave();
if (e_game.startmsg) {
gameStart();
set(e_game, "startmsg", false);
request ("Hide", "Command");
}
executeJS ("restartLoading"); },
"enter": function() { 
set(e_game, "autodescription_youarein_useprefix", true); 
},
"onexit": function() { request ("Show", "Command"); },
"enter": function() { set(e_game, "autodescription_youarein_useprefix", true); },
"_js_name": "e_start",
"_types": ["SaveType", "defaultobject"],
"cmds": [],
"saves": {"__dummyKey": "" },
"record": true,
"savename": "",
"random": [],
"random_play": [],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["start"] = e_start;
allObjects.push(e_start);
objectsNameMap["start"] = e_start;
e_player = {
"elementtype": "object",
"name": "player",
"parent": e_start,
"type": "object",
"statusattributes": {"__dummyKey": "" },
"class": "none",
"level": 0,
"contest": 0,
"fightexp": 0,
"look": "You look at yourself ... you see you looking at yourself.",
"disguise_potion": false,
"deaths": 0,
"isMage": false,
"isWarrior": false,
"isThief": false,
"stance": false,
"dress": false,
"pov_look": function() { if (e_player.parent == e_combat_room) {
OutputText ("You are figthing");
var health = 100*e_combat.pl_ht / ( 10+e_combat.pl_exp);
debmsg ("h="+health+","+e_combat.pl_ht+","+(10+e_combat.pl_exp));
if (health>90) {
OutputText ("You are perfectly healthy");
}
else if (health>70) {
OutputText ("You have a few bruises");
}
else if (health>50) {
OutputText ("You have some bruises and is a bit tired");
}
else if (health>25) {
OutputText ("You have a lot of bruises and is tired");
}
else if (health>10) {
OutputText ("You are wounded and is thinking about fleeing this combat");
}
else {
OutputText ("You are really wounded and should flee as soon as possible");
}
}
else {
if (e_player.disguise_potion) {
OutputText ("You are under the effect of the disguise potion.");
}
if (e_player.dress) {
OutputText ("You are dressed like a noblewoman.");
}
if (e_player.isWarrior) {
OutputText ("You have big biceps, perfect abs, a firm gluteus, and combat reflexes. What more do you need?");
OutputText ("You are perfectly healthy. Look at yourself during a fight to check your wounds.");
}
else if (e_player.isMage) {
OutputText ("You have shaggy hair, simple clothes, and should probably take more sun. Carrying a book is what sets you apart from the beggars. To will is your greatest strength, nothing more is required.");
}
else if (e_player.isThief) {
OutputText ("Despite your bad social position, you manages to look and behave like in the court all the time. You are thin and weak, but you are also very flexible, discreet, and always aware of what happens around you.");
}
else {
OutputText ("You better find some trainment! Right now you are lazy, weak, and uncultured. With this qualities you will never be a hero.");
}
} },
"_js_name": "e_player",
"_types": ["defaultplayer", "defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["player"] = e_player;
objectReferences.push(["e_player", "seekingthug", "e_player"]);
objectReferences.push(["e_player", "bak_room", "e_temple_phoenix"]);
objectReferences.push(["e_player", "last_room", "e_temple_phoenix"]);
allObjects.push(e_player);
objectsNameMap["player"] = e_player;
e_purse = {
"elementtype": "object",
"name": "purse",
"parent": e_player,
"type": "object",
"drop": false,
"dropmsg": "I like my purse",
"coins": 1,
"inventoryverbs": ["Look at"],
"look": function() { var plural = "s";
if (e_purse.coins==1) {
var plural = "";
}
OutputText ("You have "+e_purse.coins+" coin"+plural+"."); },
"_js_name": "e_purse",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"take": false,
"use": false,
"givesingle": false,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["purse"] = e_purse;
allObjects.push(e_purse);
objectsNameMap["purse"] = e_purse;
e_load = {
"elementtype": "object",
"name": "load",
"parent": e_start,
"type": "command",
"pattern": "^load$",
"script": function(parameters) { 
//JS
if (e_start.loading) {
		
	return;
}
if (e_game.web) {
loadGame();
}
else {
OutputText ("Use the File-Open menu in the client version (or CTRL+O).");
} },
"_js_name": "e_load",
"_types": ["defaultcommand"]
};
elementsNameMap["load"] = e_load;
allCommands.push(e_load);
objectsNameMap["load"] = e_load;
e_new_game = {
"elementtype": "object",
"name": "new_game",
"parent": e_start,
"type": "command",
"pattern": "^new$",
"script": function(parameters) { newGame(); },
"_js_name": "e_new_game",
"_types": ["defaultcommand"]
};
elementsNameMap["new_game"] = e_new_game;
allCommands.push(e_new_game);
objectsNameMap["new_game"] = e_new_game;
e_set_name = {
"elementtype": "object",
"name": "set_name",
"parent": e_start,
"type": "command",
"pattern": "^my name is (?<text>.*)$",
"script": function(parameters) { var text = parameters['text'];
set(e_player, "playername", text);
MoveObject (e_player, e_temple_phoenix); },
"_js_name": "e_set_name",
"_types": ["defaultcommand"]
};
elementsNameMap["set_name"] = e_set_name;
allCommands.push(e_set_name);
objectsNameMap["set_name"] = e_set_name;
e_void = {
"elementtype": "object",
"name": "void",
"type": "object",
"description": "TODO:<br/>- usar ditados populates nos puzzles (lavar o carro)<br/>- \u00f3leo para abrir algo tarnish<br/><br/>-atras da porta<br/>-pesos e contrapesos para abrir uma passagem (pedras?)<br/>- mapa de tras de algo que tem que fechar<br/><br/>---<br/>-apresentar problemas antes das solu\u00e7\u00f5es<br/>-mago usa levitate para descer no po\u00e7o. Aprende na lib?<br/>-checar se mago sabe o blind antes de entregar o orb<br/>-warrior usa a po\u00e7\u00e3o de transmuta\u00e7\u00e3o<br/><br/>-Dungeon quando \u00e9 derrotado (warrior)<br/>- espada m\u00e1gica (warrior)<br/>-Capela<br/>-Princesa adormecida acorda com beijo<br/><br/>",
"_js_name": "e_void",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["void"] = e_void;
allObjects.push(e_void);
objectsNameMap["void"] = e_void;
e_pot_helmet = {
"elementtype": "object",
"name": "pot_helmet",
"parent": e_void,
"type": "object",
"alias": "makeshift helmet",
"look": "Ok, it is a cooking pot. But fits perfectly well at your head.",
"loc": "head",
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"feature_usegive": true,
"use": true,
"givesingle": true,
"_js_name": "e_pot_helmet",
"_types": ["Armour", "defaultobject"],
"armour": 1,
"visible": true,
"displayverbs": ["Look at", "Take"],
"take": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["pot_helmet"] = e_pot_helmet;
allObjects.push(e_pot_helmet);
objectsNameMap["pot_helmet"] = e_pot_helmet;
e_disguise_potion2 = {
"elementtype": "object",
"name": "disguise_potion2",
"parent": e_void,
"type": "object",
"alias": "disguise potion",
"potion": true,
"look": "It is a bottle filled with a purple potion. When you drink, you will take the form of the person that you are looking at.",
"take": true,
"inventoryverbs": ["Look at", "Drop", "Drink"],
"useCmds": ["pour", "fill"],
"feature_usegive": true,
"drink": function() { if (e_castle_guard.parent == e_player.parent) {
OutputText ("You drank the potion, and assumed the shape, including the cloths, of the guard. He doesn't seem very happy with this spell...");
set(e_player, "disguise_potion", true);
MoveObject (e_disguise_potion2, e_void);
set(e_castle_guard, "danger", "death");
set(e_castle_guard, "aggressive", true);
attack (e_player.parent, e_castle_guard);
UnlockExit (e_gate_lock);
UnlockExit (e_lobby_exit);
UnlockExit (e_exit_to_forge);
}
else {
OutputText ("You should first find an enemy with compatible height and weight.");
} },
"_js_name": "e_disguise_potion2",
"_types": ["UseAltType", "defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["disguise_potion2"] = e_disguise_potion2;
allObjects.push(e_disguise_potion2);
objectsNameMap["disguise_potion2"] = e_disguise_potion2;
e_combat = {
"elementtype": "object",
"name": "combat",
"type": "object",
"pushed": false,
"_js_name": "e_combat",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["combat"] = e_combat;
allObjects.push(e_combat);
objectsNameMap["combat"] = e_combat;
e_combat_room = {
"elementtype": "object",
"name": "combat_room",
"type": "object",
"descprefix": "",
"objectslistprefix": "You are fighting",
"alias": "FIGHT",
"usedefaultprefix": false,
"description": function() { printCombatRoom(); },
"_js_name": "e_combat_room",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["combat_room"] = e_combat_room;
allObjects.push(e_combat_room);
objectsNameMap["combat_room"] = e_combat_room;
e_flee = {
"elementtype": "object",
"name": "flee",
"parent": e_combat_room,
"type": "command",
"pattern": "^flee$",
"script": function(parameters) { if (e_player.parent==e_combat_room) {
var enemy = GetObject(e_combat_room.enemy);
var action = "Flee.";
fightMenu (enemy, action);
}
else {
OutputText ("You are not in a fight");
} },
"_js_name": "e_flee",
"_types": ["defaultcommand"]
};
elementsNameMap["flee"] = e_flee;
allCommands.push(e_flee);
objectsNameMap["flee"] = e_flee;
e_combat_cmd = {
"elementtype": "object",
"name": "combat_cmd",
"parent": e_combat_room,
"type": "command",
"pattern": "^combat (?<text>.*)$",
"script": function(parameters) { var text = parameters['text'];
set(e_player, "parent", e_combat_room);
if (e_player.parent==e_combat_room) {
var enemy = GetObject(e_combat_room.enemy);
if (text=="normal") {
var action = "Attack and defend.";
fightMenu (enemy, action);
}
else if (text=="full") {
var action = "Full attack.";
fightMenu (enemy, action);
}
else if (text=="defensive") {
var action = "Full defense.";
fightMenu (enemy, action);
}
else {
OutputText ("In the normal combat, you have normal chances to hit and avoid a blow; in the full combat, you have increased chances to hit, and no defense; In the defensive combat, you will only try to defend for a while.");
}
}
else {
OutputText ("You are not in a fight");
} },
"_js_name": "e_combat_cmd",
"_types": ["defaultcommand"]
};
elementsNameMap["combat_cmd"] = e_combat_cmd;
allCommands.push(e_combat_cmd);
objectsNameMap["combat_cmd"] = e_combat_cmd;
e_drop_on_combat = {
"elementtype": "object",
"name": "drop_on_combat",
"parent": e_combat_room,
"type": "command",
"pattern": "^drop (?<object_drop>.*)$",
"script": function(parameters) { var object_drop = parameters['object_drop'];
OutputText ("you cannot drop nothing now"); },
"_js_name": "e_drop_on_combat",
"_types": ["defaultcommand"]
};
elementsNameMap["drop_on_combat"] = e_drop_on_combat;
allCommands.push(e_drop_on_combat);
objectsNameMap["drop_on_combat"] = e_drop_on_combat;
e_fight_on_combat = {
"elementtype": "object",
"name": "fight_on_combat",
"parent": e_combat_room,
"type": "command",
"pattern": "^fight (?<object_en>.*)$",
"script": function(parameters) { var object_en = parameters['object_en'];
OutputText ("You are already fighting"); },
"_js_name": "e_fight_on_combat",
"_types": ["defaultcommand"]
};
elementsNameMap["fight_on_combat"] = e_fight_on_combat;
allCommands.push(e_fight_on_combat);
objectsNameMap["fight_on_combat"] = e_fight_on_combat;
e_stance_cmd = {
"elementtype": "object",
"name": "stance_cmd",
"parent": e_combat_room,
"type": "command",
"pattern": "^stance (?<text1>.*)$",
"script": function(parameters) { var text1 = parameters['text1'];
changeStance (text1); },
"_js_name": "e_stance_cmd",
"_types": ["defaultcommand"]
};
elementsNameMap["stance_cmd"] = e_stance_cmd;
allCommands.push(e_stance_cmd);
objectsNameMap["stance_cmd"] = e_stance_cmd;
e_stance_cmd2 = {
"elementtype": "object",
"name": "stance_cmd2",
"parent": e_combat_room,
"type": "command",
"pattern": "^stance$",
"script": function(parameters) { changeStance (""); },
"_js_name": "e_stance_cmd2",
"_types": ["defaultcommand"]
};
elementsNameMap["stance_cmd2"] = e_stance_cmd2;
allCommands.push(e_stance_cmd2);
objectsNameMap["stance_cmd2"] = e_stance_cmd2;
e_stance = {
"elementtype": "object",
"name": "stance",
"parent": e_combat_room,
"type": "object",
"alias": "none",
"scenery": true,
"usedefaultprefix": false,
"_js_name": "e_stance",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["stance"] = e_stance;
allObjects.push(e_stance);
objectsNameMap["stance"] = e_stance;
e_The_hidden_city = {
"elementtype": "object",
"name": "The hidden city",
"type": "object",
"_js_name": "e_The_hidden_city",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["The hidden city"] = e_The_hidden_city;
allObjects.push(e_The_hidden_city);
objectsNameMap["The hidden city"] = e_The_hidden_city;
e_temple_phoenix = {
"elementtype": "object",
"name": "temple_phoenix",
"parent": e_The_hidden_city,
"type": "object",
"alias": "Temple of Phoenix",
"description": "You are standing in the most important temple of the hidden city of Chuma Huppic. This is the place where people seek peace and comfort in these dark days of exile. The high ceiling is made of glass, and within it the figure of a wild phoenix is depicted.",
"usedefaultprefix": false,
"prefix": "the",
"public_greeting": "An unknown believer silently waves to you.",
"beforeenter": function() { if (e_game.startmsg) {
gameStart();
set(e_game, "startmsg", false);
} },
"_js_name": "e_temple_phoenix",
"_types": ["PublicRoom", "defaultobject"],
"public_level": 3,
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["temple_phoenix"] = e_temple_phoenix;
allObjects.push(e_temple_phoenix);
objectsNameMap["temple_phoenix"] = e_temple_phoenix;
e_sage = {
"elementtype": "object",
"name": "sage",
"parent": e_temple_phoenix,
"type": "object",
"alias": "Coriander",
"look": "He is the Sage of Phoenix. The wise and elderly man that raised you among many other orphans. ",
"usedefaultprefix": false,
"prefix": "",
"suffix": "the sage",
"alt": ["sage"],
"speak": function() { if (e_player.class == "none") {
psay ("My child you have reached the age and is now a young man. You should now seek one of the {ask:coriander:guild:guild masters} and ask him to train you. Choose well because you cannot change your mind later. You can choose the Guild of Warriors, if you prefer to solve problems by force; or you can choose the Guild of Mages, if you prefer to solve problems with magic; or you can choose the Guild of Thieves, if you prefer to solve problems with cunning and trickery..");
}
else if (e_player.level<3) {
OutputText ("<i>Now you have to gain the respect of the guild master by performing tasks for him. I will pray to the gods to protect and rescue you in case of peril.</i>");
}
else {
OutputText ("<i>You now should venture abroad, and learn a way to defeat Vourtram and rescue the princess. I will pray to the gods to protect and rescue you in case or peril.</i>");
}
if (e_purse.coins<1) {
psay ("Here, take this coin, I don't want you to be without any money");
set(e_purse, "coins", 1);
} },
"ask": {"guild master guildmaster guildmasters": function() { OutputText ("<i>There are three guilds in the hidden city. The guild of the warriors is northeast of the main square; the guild of the wizards is northwest of the main square; and the guild of the thieves is located in the dark alley, to the west and south of the main square.</i>"); }, "king": function() { OutputText ("<i>The King's court is located to the north of the courtyard. You must be invited or be an important person to enters the throne room.</i>"); }, "court courtyard": function() { OutputText ("<i>The courtyard is located just in front of the temple, in the main square.</i>"); } },
"_js_name": "e_sage",
"_types": ["male", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["sage"] = e_sage;
allObjects.push(e_sage);
objectsNameMap["sage"] = e_sage;
e_k3 = {
"elementtype": "object",
"name": "k3",
"parent": e_temple_phoenix,
"type": "exit",
"alias": "north",
"_js_name": "e_k3",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k3"] = e_k3;
objectReferences.push(["e_k3", "to", "e_main_square"]);
allExits.push(e_k3);
objectsNameMap["k3"] = e_k3;
e_ceiling1 = {
"elementtype": "object",
"name": "ceiling1",
"parent": e_temple_phoenix,
"type": "object",
"alias": "ceiling",
"look": "It has the figure of the mythical Phoenix, an immortal bird that can be reborn from its own ashes. This is probably the only unbroken window in the whole kingdom.",
"alt": ["roof", "phoenix"],
"scenery": true,
"_js_name": "e_ceiling1",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["ceiling1"] = e_ceiling1;
allObjects.push(e_ceiling1);
objectsNameMap["ceiling1"] = e_ceiling1;
e_believer = {
"elementtype": "object",
"name": "believer",
"parent": e_temple_phoenix,
"type": "object",
"scenery": true,
"alias": "believer",
"look": "You can find many believers in the temple. Many of them are sick or disabled.",
"speak": "The best way you can help them now is by defeating Vourtram.",
"_js_name": "e_believer",
"_types": ["namedmale", "defaultobject"],
"usedefaultprefix": false,
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["believer"] = e_believer;
allObjects.push(e_believer);
objectsNameMap["believer"] = e_believer;
e_main_square = {
"elementtype": "object",
"name": "main_square",
"parent": e_The_hidden_city,
"type": "object",
"alias": "main square",
"description": "You stand in the middle of a crowded square. To the north are the {if courtdoor.locked:closed}{if not courtdoor.locked:open} gates to the courtyard, to the south you see the great Temple of Phoenix. The Guild of Warriors is in the northeast and the Guild of Wizards to the northwest. To the east you see the main street and to the west you see an unpaved street.",
"usedefaultprefix": false,
"prefix": "the",
"suffix": "of Chuma Huppic",
"enter": function() { if (Contains (this,e_outlaw_thug)) {
OutputText ("<b>The thug runs west!</b>");
MoveObject (e_outlaw_thug, e_street_peasants);
}
if (e_player.class!="none") {
UnlockExit (e_courtdoor);
}
if (e_pot.parent == e_player) {
OutputText ("The dog circles you wagging his tail...");
} },
"_js_name": "e_main_square",
"_types": ["PublicRoom", "defaultobject"],
"public_level": 3,
"public_greeting": "An unknown passerby says <i>Hi {player.playername}! Good luck with your quest!</i>",
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["main_square"] = e_main_square;
allObjects.push(e_main_square);
objectsNameMap["main_square"] = e_main_square;
e_k4 = {
"elementtype": "object",
"name": "k4",
"parent": e_main_square,
"type": "exit",
"alias": "south",
"look": "It is a marvelous marble temple",
"to": e_temple_phoenix,
"_js_name": "e_k4",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k4"] = e_k4;
allExits.push(e_k4);
objectsNameMap["k4"] = e_k4;
e_k5 = {
"elementtype": "object",
"name": "k5",
"parent": e_main_square,
"type": "exit",
"alias": "northeast",
"_js_name": "e_k5",
"_types": ["northeastdirection", "defaultexit"],
"alt": ["ne"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k5"] = e_k5;
objectReferences.push(["e_k5", "to", "e_guild_warriors"]);
allExits.push(e_k5);
objectsNameMap["k5"] = e_k5;
e_k6 = {
"elementtype": "object",
"name": "k6",
"parent": e_main_square,
"type": "exit",
"alias": "northwest",
"_js_name": "e_k6",
"_types": ["northwestdirection", "defaultexit"],
"alt": ["nw"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k6"] = e_k6;
objectReferences.push(["e_k6", "to", "e_guild_mages"]);
allExits.push(e_k6);
objectsNameMap["k6"] = e_k6;
e_k7 = {
"elementtype": "object",
"name": "k7",
"parent": e_main_square,
"type": "exit",
"alias": "west",
"_js_name": "e_k7",
"_types": ["westdirection", "defaultexit"],
"alt": ["w"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k7"] = e_k7;
objectReferences.push(["e_k7", "to", "e_street_peasants"]);
allExits.push(e_k7);
objectsNameMap["k7"] = e_k7;
e_k8 = {
"elementtype": "object",
"name": "k8",
"parent": e_main_square,
"type": "exit",
"alias": "east",
"_js_name": "e_k8",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k8"] = e_k8;
objectReferences.push(["e_k8", "to", "e_main_street"]);
allExits.push(e_k8);
objectsNameMap["k8"] = e_k8;
e_courtdoor = {
"elementtype": "object",
"name": "courtdoor",
"parent": e_main_square,
"type": "exit",
"alias": "north",
"locked": true,
"_js_name": "e_courtdoor",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["courtdoor"] = e_courtdoor;
objectReferences.push(["e_courtdoor", "to", "e_courtyard1"]);
allExits.push(e_courtdoor);
objectsNameMap["courtdoor"] = e_courtdoor;
e_fido = {
"elementtype": "object",
"name": "fido",
"parent": e_main_square,
"type": "object",
"alias": "beastly fido",
"usedefaultprefix": false,
"prefix": "a",
"suffix": "mucking through the garbage looking for food here",
"look": "The fido is a small dog that has a foul smell and pieces of rotted meat hanging around his teeth.",
"displayverbs": ["Look at"],
"friend": false,
"alt": ["dog"],
"speak": "<i>GRRRR...</i>",
"give": {"pot": function() { OutputText ("The Fido eats the stew and looks friendly towards you.");
RemoveObject (e_pot);
if (e_guard_helmet.parent==e_castle_guard) {
OutputText ("The pot is cleaner than before, and you realize that it fits perfectly in your head as a <b>makeshift helmet</b>.");
AddToInventory (e_pot_helmet);
} } },
"_js_name": "e_fido",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["fido"] = e_fido;
allObjects.push(e_fido);
objectsNameMap["fido"] = e_fido;
e_garbage1 = {
"elementtype": "object",
"name": "garbage1",
"parent": e_main_square,
"type": "object",
"alias": "garbage",
"visible": true,
"scenery": true,
"look": "You dirty your hands and is just rubbish.",
"_js_name": "e_garbage1",
"_types": ["defaultobject"],
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["garbage1"] = e_garbage1;
allObjects.push(e_garbage1);
objectsNameMap["garbage1"] = e_garbage1;
e_guild = {
"elementtype": "object",
"name": "guild",
"parent": e_main_square,
"type": "object",
"alt": ["temple", "guild of warriors", "guild of wizards", "temple of phoenix"],
"scenery": true,
"look": "An imposing building.",
"_js_name": "e_guild",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["guild"] = e_guild;
allObjects.push(e_guild);
objectsNameMap["guild"] = e_guild;
e_guild_warriors = {
"elementtype": "object",
"name": "guild_warriors",
"parent": e_The_hidden_city,
"type": "object",
"alias": "the main hall of the Guild of the Warriors",
"usedefaultprefix": false,
"description": "You are standing in a large room full of warriors training with all kinds of weapons. The room has few windows and a poor ventilation; the air is heavy and filled with the stink of male sweat and the noise of clashing swords. There is a small door leading northeast.",
"public_level": 2,
"public_greeting": "An apprentice greets you: <i>Hi {player.playername}! Good luck with your quest!</i>",
"enter": function() { if (e_player.class=="thief" && e_player.level>=2) {
UnlockExit (e_lock_wroom);
} },
"_js_name": "e_guild_warriors",
"_types": ["PublicRoom", "defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["guild_warriors"] = e_guild_warriors;
allObjects.push(e_guild_warriors);
objectsNameMap["guild_warriors"] = e_guild_warriors;
e_k9 = {
"elementtype": "object",
"name": "k9",
"parent": e_guild_warriors,
"type": "exit",
"alias": "southwest",
"to": e_main_square,
"_js_name": "e_k9",
"_types": ["southwestdirection", "defaultexit"],
"alt": ["sw"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k9"] = e_k9;
allExits.push(e_k9);
objectsNameMap["k9"] = e_k9;
e_derrick = {
"elementtype": "object",
"name": "derrick",
"parent": e_guild_warriors,
"type": "object",
"usedefaultprefix": false,
"alias": "Derrick",
"alt": ["Derrick", "master"],
"talk_level": 0,
"look": "He is a tall and muscled bald man with a thick grizzled mustache. He has a wooden pegleg in place of his right leg.",
"suffix": ", the weapons' master",
"speak": function() { psay ("{once:I'm Derrick the weapons' master, and this is {command:ask Derrick about Rodney:Rodney}.}{notfirst:Greetings again {player.playername}.}");
if (e_player.class == "none") {
Ask ("<i>Are you sure you want to become a Warrior?</i>", function (result) { if (result) {
set(e_player, "class", "warrior");
set(e_player, "isWarrior", true);
OutputText ("After a long time of intense training, you became an apprentice of warrior. "+Template("HelpWarrior"));
AddToInventory (e_wooden_spear);
UnlockExit (e_hide_hall_exit);
MoveObject (e_brigand1, e_forest_current2);
set(e_sparring, "displayverbs", Split("Look at;Speak to;Fight", ";"));
}
else {
OutputText ("<i>Come back if you change your mind...</i>");
} });
}
else if (e_player.class == "warrior") {
if (e_player.level>=3 && e_jacket.parent==e_derrick) {
AddToInventory (e_jacket);
OutputText ("<i>Here, your werewolf armor is ready! It is light, flexible, and as resistent as steel.</i>");
}
else {
OutputText ("<i>You can ask me about {command:ask Derrick about fighting:fighting}. You can also ask about {command:ask Derrick about training:training} if you need it.</i>");
}
} },
"ask": {"train training": function() { if (e_player.class == "warrior") {
if (e_player.level == 0) {
if (e_derrick.talk_level<=0) {
OutputText ("Derrick teaches you about the art of throwing spears");
set(e_derrick, "talk_level", 1);
}
OutputText ("<i>There is a thug robbing and causing all kinds of troubles in the city. If you can find and capture him, I will train you.</i>");
set(e_player, "seekingthug", e_bakery);
}
else if (e_player.level==1) {
if (e_derrick.talk_level<=1) {
OutputText ("Derrick teaches you about the basic fighting movements.");
set(e_derrick, "talk_level", 2);
}
psay ("Prove you are worthy by hunting the evil {ask:Derrick:wolf} that wanders in the hills. Bring me its corpse. Take this sword to help you in your hunt.");
AddToInventory (e_smallsword);
}
else if (e_player.level==2) {
if (e_derrick.talk_level<=2) {
OutputText ("Derrick teaches you some tricks in order better attack and defend yourself.");
set(e_derrick, "talk_level", 3);
}
OutputText ("<i>Train hard with Rodney and then win the spring contest!</i>");
}
else {
if (e_derrick.talk_level<=3) {
OutputText ("Derrick tells you about fighting stances, but you have a hard time understanding. <i>You need more practical experience on fighting before learning the adanced stances.</i>.");
set(e_derrick, "talk_level", 4);
}
OutputText ("<i>The training is over. Ask me about {command:ask Derrick about stances:stances} if you want to know about then.</i>");
}
}
else {
OutputText ("<i>Sorry, I cannot help you with that.</i>");
} }, "fight fighting": function() { OutputText ("<i>I was the captain of the guard once, but I was betrayed by my lieutenant. After that, I become just an instructor.</i>");
if (e_player.class == "warrior") {
OutputText ("<i>The core of fighting is mastering the basic three {command:ask Derrick about manuevers:manuevers}: normal attack, full defense, and full attack.</i>");
if (e_player.level>2) {
OutputText ("<i>After a long training, the manuevers can be replaced by fighting {command:ask Derrick about stances:stances}.</i>");
}
} }, "manuevers manuever": function() { OutputText ("<i>The normal attack tries to balance between risk and defense. The full attack focuses in a fast and strong blow, but leaving the guard open for a counter-attack. The full defense focus only on preventing the enemy to hit you, in order to recover from dizziness for instance.</i>"); }, "stances stance": function() { OutputText ("<i>There are five possible stances:</i>");
OutputText ("<i>The <b>Eisenport</b> stance is used with a normal attack manuever. It is very effective against any of the other manuevers.</i>");
OutputText ("<i>The <b>Nebenhut</b> stance is used with normal attack manuever with a feint. It is a powerful counter attack.</i>");
OutputText ("<i>The <b>Right vom tag</b> stance is used with a full attack manuever, but allows the attacker to defend itself.</i>");
OutputText ("<i>The <b>Bocca di falcone</b> stance is used with an aggressive full attack manuever, and produces maximum effect against defensive positions.</i>");
OutputText ("<i>The <b>Fool's guard</b> stance is used with a full defense manuever, but is a feint. The harder the attack, the best is the counter-attack.</i>"); }, "wolf werewolf": function() { psay ("Some people think that this wolf in the hills is a werewolf. If this is true, the only weakness of a werewolf are silver and the innocence."); }, "Rodney": function() { psay ("Rodney is here to help the warriors in their training."); } },
"give": {"werewolf corpse": function() { OutputText ("Great Job! I will make a werewolf jacket for you. Meanwhile, your next task will be to participate in the spring festival's warrior contest. If you win the prize, your training will be completed.");
set(e_player, "level", 2);
MoveObject (e_werewolf_corpse, e_void); } },
"_js_name": "e_derrick",
"_types": ["male", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["derrick"] = e_derrick;
allObjects.push(e_derrick);
objectsNameMap["derrick"] = e_derrick;
e_jacket = {
"elementtype": "object",
"name": "jacket",
"parent": e_derrick,
"type": "object",
"alias": "wereworlf-leather jacket",
"take": true,
"look": "It is light, flexible, but super strong jacket made from wereworlf leather.",
"armour": 4,
"_js_name": "e_jacket",
"_types": ["Armour", "defaultobject"],
"loc": "body",
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["jacket"] = e_jacket;
allObjects.push(e_jacket);
objectsNameMap["jacket"] = e_jacket;
e_sparring = {
"elementtype": "object",
"name": "sparring",
"parent": e_guild_warriors,
"type": "object",
"alias": "Rodney",
"look": "He is not a formidable warrior, but may teach you one or two tricks.",
"ht": 8,
"danger": "friend",
"coins": 1,
"usedefaultprefix": false,
"suffix": " the sparring partner.",
"alt": ["sparring"],
"speak": "<i>You can fight with me to improve your fighting skills.</i>",
"_js_name": "e_sparring",
"_types": ["male", "Enemy", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"enemy": "yes",
"exp": 1,
"armour": 0,
"aggressive": false,
"stab_level": 0,
"affect_calm": false,
"block_flee": false,
"damage": 2,
"push": function() { if (e_player.parent==e_combat_room) {
if (e_combat.pushed) {
OutputText ("You can only push one time before you combat movement.");
}
else if (savedRandomInt(0,1)==0) {
OutputText ("You successfully push "+this.alias+".");
set(e_combat, "en_red", e_combat.en_red+1);
}
else {
OutputText ("You tried to push "+this.alias+", but ended up losing your balance.");
set(e_combat, "pl_red", e_combat.pl_red+1);
}
set(e_combat, "pushed", true);
}
else {
OutputText ("It doesn't work.");
} },
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["sparring"] = e_sparring;
allObjects.push(e_sparring);
objectsNameMap["sparring"] = e_sparring;
e_lock_wroom = {
"elementtype": "object",
"name": "lock_wroom",
"parent": e_guild_warriors,
"type": "exit",
"alias": "northeast",
"locked": true,
"lockmessage": "Derrick blocks your way. It is private.",
"_js_name": "e_lock_wroom",
"_types": ["northeastdirection", "defaultexit"],
"alt": ["ne"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["lock_wroom"] = e_lock_wroom;
objectReferences.push(["e_lock_wroom", "to", "e_warrior_room"]);
allExits.push(e_lock_wroom);
objectsNameMap["lock_wroom"] = e_lock_wroom;
e_apprentices2 = {
"elementtype": "object",
"name": "apprentices2",
"parent": e_guild_warriors,
"type": "object",
"scenery": true,
"alias": "apprentices",
"look": "The apprentices are training their skills.",
"speak": "The apprentices are too busy to chat now.",
"alt": ["warrior", "warriors"],
"_js_name": "e_apprentices2",
"_types": ["maleplural", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "they",
"article": "them",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["apprentices2"] = e_apprentices2;
allObjects.push(e_apprentices2);
objectsNameMap["apprentices2"] = e_apprentices2;
e_guild_mages = {
"elementtype": "object",
"name": "guild_mages",
"parent": e_The_hidden_city,
"type": "object",
"alias": "the main hall of the Guild of Mages",
"usedefaultprefix": false,
"description": "It is a large room filled with the smell of incense and mystery. On the walls you can see several magical drawings, and the Dashiel's monogram.",
"public_level": 2,
"public_greeting": "An apprentice greets you: <i>Hi {player.playername}! Good luck with your quest!</i>",
"_js_name": "e_guild_mages",
"_types": ["PublicRoom", "defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["guild_mages"] = e_guild_mages;
allObjects.push(e_guild_mages);
objectsNameMap["guild_mages"] = e_guild_mages;
e_k10 = {
"elementtype": "object",
"name": "k10",
"parent": e_guild_mages,
"type": "exit",
"alias": "southeast",
"to": e_main_square,
"_js_name": "e_k10",
"_types": ["southeastdirection", "defaultexit"],
"alt": ["se"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k10"] = e_k10;
allExits.push(e_k10);
objectsNameMap["k10"] = e_k10;
e_archmage = {
"elementtype": "object",
"name": "archmage",
"parent": e_guild_mages,
"type": "object",
"usedefaultprefix": false,
"alt": ["master", "mage", "Dashiel", "archmage"],
"alias": "Dashiel",
"look": "Dashiel is a white-headed wizard wearing a blue robe with embroidered stars and a blue pointed hat.",
"suffix": ", the archmage of the kingdom",
"speak": function() { psay ("{once:I'm Dashiel the wizard and {command:ask Dashiel about Erasmus:Erasmus} is my cat.}{notfirst:Greetings again {player.playername}.}");
if (e_player.class == "none") {
Ask ("<i>Are you sure you want to become a Wizard?</i>", function (result) { if (result) {
set(e_player, "class", "mage");
set(e_player, "isMage", true);
OutputText ("After a long time of intense study and training, you became an apprentice of magery. "+Template("HelpMage"));
AddToInventory (e_spell_book);
} });
}
else if (e_player.class == "mage") {
OutputText ("<i>Ask me about {command:ask Dashiel about training:training} if you need to improve your status.</i>");
if (e_erasmus_cat.parent==e_guild_mages) {
psay ("{ask:Dashiel:Erasmus} seems interested in you.");
}
} },
"ask": {"train training": function() { if (e_player.class == "mage") {
if (e_player.level == 0) {
OutputText ("<i>Here is your first assignment: In the hill forest you will find an evil werewolf. Bring me some of his fur, so that I can make a dispel potion. </i>");
if (!(Contains (e_spell_book,e_calm_spell))) {
MoveObject (e_calm_spell, e_spell_book);
OutputText ("<i>Take this scroll with the <b>calm spell</b>, I think it may help you deal with his aggressiveness.</i>");
}
}
else if (e_player.level==1) {
OutputText ("<i>Here is your second assignment: There is a thug robbing and causing all kinds of troubles in the city. Can you find and capture him for me?</i>");
}
else if (e_player.level==2) {
OutputText ("<i>This is your last task: There is a spy of Vourtram in the town. The only clue we have is his secret name: White Wolf. Find him, and I will send a guard to capture him.</i>");
}
else {
OutputText ("<i>Training is over. Ask me about {command:ask Dashiel about spells:spells} after you be declared a hero by the king.</i>");
}
}
else {
psay ("Sorry, I cannot help you with that.");
} }, "erasmus": function() { OutputText ("Dashiel says: <i>Erasmus was a great wizard, but a few years ago he tried to create an immortality potion. Unluckily, he picked an untrusted ingredient supplier and the potion had odd results</i>.<br/>Erasmus says: <i>In fact, the {command:ask erasmus about potion:potion} worked... partially. Now I have seven lives to spent.</i><br/>Dashiel comments: <i>Always buy from syndicated suppliers.</i>"); }, "spells spell": function() { if (e_player.class=="mage") {
if (e_player.level<4) {
OutputText ("<i>You must learn by your own... it is the only way to become a powerful mage.</i>");
OutputText ("<i>Well, when you become a hero, come back here and I will teach you a spell.</i>");
}
else {
if (e_teleport_spell.parent==e_game) {
OutputText ("<i>I have a gift for you. This is the teleportation spell and the orb. When you cast the spell, you will come back to the place where the orb is.</i>");
MoveObject (e_teleport_spell, e_spell_book);
AddToInventory (e_teleport_orb);
}
else {
OutputText ("<i>Go into adventure and learn!</i>");
}
}
}
else {
OutputText ("<i>I could not teach you.</i>");
} } },
"give": {"wolf_fur": function() { OutputText ("The archmage takes the fur, tells you to wait a few minutes, and disappears in a puff of smoke. After half an hour, he reappears in a bang and says:<br/><i>Take this dispel magic potion and use it on the werewolf. I hope it will break the enchantment.</i>");
AddToInventory (e_dispel_potion);
set(e_wolf_fur, "parent", e_void); }, "letter": function() { OutputText ("<i>Yes, that's a letter from the spy. Now I can identify him using my seek spell</i><br/>Dashiel leaves with some guards, and they capture the spy. You just completed your last guild quest.");
RemoveObject (e_letter);
set(e_player, "level", 3);
OutputText ("<i>So, are you interested in learning new spells? Do me a favor and deliver this book to Flamel, the Alchemist. He lives in the dark forest near the road, in a small tower. There is a spell in this book that he can decipher for us.</i>");
AddToInventory (e_book_plants); } },
"_js_name": "e_archmage",
"_types": ["male", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["archmage"] = e_archmage;
allObjects.push(e_archmage);
objectsNameMap["archmage"] = e_archmage;
e_erasmus_cat = {
"elementtype": "object",
"name": "erasmus_cat",
"parent": e_guild_mages,
"type": "object",
"alias": "Erasmus",
"look": "It looks like an ordinary black cat with a blue pointed hat attached to its head. You wonder if this cat was some kind of enemy of the archmage in the past... before being the archmage's pet.",
"meows": 0,
"usedefaultprefix": false,
"suffix": ", Dashiel's pet",
"alt": ["cat"],
"feature_usegive": true,
"speak": function() { if (e_erasmus_cat.meows == 2) {
OutputText ("<i>Meow... aren't you too busy to be talking to a cat like me?</i>");
}
if (e_erasmus_cat.meows == 1) {
OutputText ("<i>Meow...Meow...</i>");
set(e_erasmus_cat, "meows", e_erasmus_cat.meows+1);
}
if (e_erasmus_cat.meows == 0) {
OutputText ("<i>Meow...</i>");
set(e_erasmus_cat, "meows", e_erasmus_cat.meows+1);
} },
"ask": {"potion": function() { psay ("The magic immortality potion gave me seven lives... I guess I could {ask:Erasmus:cure} myself, but I am too busy with the {ask:Erasmus:rats} right now."); }, "mouse rat rats": function() { psay ("Yummy!"); }, "cure": function() { psay ("To undo this spell I will need ashes of an oak burned by a blind dragon. I could easily find this ingredient in the old days... but as a cat, I'm too distracted by those little tasty pests."); } },
"give": {"revert_potion": function() { OutputText ("You give the potion to the cat");
psay ("Refreshing beverage... I kind of miss some spider webs...ARRRGH");
OutputText ("After a few seconds he chokes and transforms back into an old man");
MoveObject (e_erasmus_cat, e_void);
MoveObject (e_revert_potion, e_void);
MakeObjectVisible (e_erasmus);
OutputText ("<i>Thank you my boy! In exchange for this favor, please accept this spell as a gift. The banish spell sends any demon back to his realm</i>");
MoveObject (e_banish_spell, e_spell_book); } },
"_js_name": "e_erasmus_cat",
"_types": ["male", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["erasmus_cat"] = e_erasmus_cat;
allObjects.push(e_erasmus_cat);
objectsNameMap["erasmus_cat"] = e_erasmus_cat;
e_fake_diamond = {
"elementtype": "object",
"name": "fake_diamond",
"parent": e_guild_mages,
"type": "object",
"alias": "fake diamond",
"look": "It is a magical fake... ",
"take": true,
"visible": false,
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"feature_usegive": true,
"use": true,
"givesingle": true,
"_js_name": "e_fake_diamond",
"_types": ["defaultobject"],
"displayverbs": ["Look at", "Take"],
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["fake_diamond"] = e_fake_diamond;
allObjects.push(e_fake_diamond);
objectsNameMap["fake_diamond"] = e_fake_diamond;
e_erasmus = {
"elementtype": "object",
"name": "erasmus",
"parent": e_guild_mages,
"type": "object",
"visible": false,
"alias": "Erasmus",
"suffix": "the wizard",
"look": "An old bearded wizard with a cerulean blue robe and a pointed blue hat. He has a wand with a star in the tip. So stereotypical...",
"speak": "He is too busy reading his spell book. Better leave him alone.",
"askdefault": function() { OutputText ("He is too busy reading his spell book."); },
"_js_name": "e_erasmus",
"_types": ["namedmale", "defaultobject"],
"usedefaultprefix": false,
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["erasmus"] = e_erasmus;
allObjects.push(e_erasmus);
objectsNameMap["erasmus"] = e_erasmus;
e_apprentices3 = {
"elementtype": "object",
"name": "apprentices3",
"parent": e_guild_mages,
"type": "object",
"scenery": true,
"alias": "apprentices",
"look": "The apprentices are training their skills.",
"speak": "The apprentices are too busy to chat now.",
"_js_name": "e_apprentices3",
"_types": ["maleplural", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "they",
"article": "them",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["apprentices3"] = e_apprentices3;
allObjects.push(e_apprentices3);
objectsNameMap["apprentices3"] = e_apprentices3;
e_monogram = {
"elementtype": "object",
"name": "monogram",
"parent": e_guild_mages,
"type": "object",
"alias": "monogram",
"scenery": true,
"look": "{if player.isMage:It is a stylised letter D.}{if not player.isMage:Some ancient rune, who knows?}",
"_js_name": "e_monogram",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["monogram"] = e_monogram;
allObjects.push(e_monogram);
objectsNameMap["monogram"] = e_monogram;
e_street_peasants = {
"elementtype": "object",
"name": "street_peasants",
"parent": e_The_hidden_city,
"type": "object",
"alias": "the commoner's street",
"usedefaultprefix": false,
"description": "You are standing in an unpaved street that leads to the houses of simple peasants and lower class workers. This part of the town is also the place for thieves, beggars, and other dangerous types of citizens. To the north you see the Gray Tavern, and to the south a dark alley.",
"enter": function() { if (Contains (this,e_outlaw_thug)) {
OutputText ("<b>The thug runs south!</b>");
MoveObject (e_outlaw_thug, e_dark_alley);
} },
"_js_name": "e_street_peasants",
"_types": ["PublicRoom", "defaultobject"],
"public_level": 3,
"public_greeting": "An unknown passerby says <i>Hi {player.playername}! Good luck with your quest!</i>",
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["street_peasants"] = e_street_peasants;
allObjects.push(e_street_peasants);
objectsNameMap["street_peasants"] = e_street_peasants;
e_k11 = {
"elementtype": "object",
"name": "k11",
"parent": e_street_peasants,
"type": "exit",
"alias": "east",
"to": e_main_square,
"_js_name": "e_k11",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k11"] = e_k11;
allExits.push(e_k11);
objectsNameMap["k11"] = e_k11;
e_k12 = {
"elementtype": "object",
"name": "k12",
"parent": e_street_peasants,
"type": "exit",
"alias": "south",
"_js_name": "e_k12",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k12"] = e_k12;
objectReferences.push(["e_k12", "to", "e_dark_alley"]);
allExits.push(e_k12);
objectsNameMap["k12"] = e_k12;
e_k13 = {
"elementtype": "object",
"name": "k13",
"parent": e_street_peasants,
"type": "exit",
"alias": "north",
"_js_name": "e_k13",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k13"] = e_k13;
objectReferences.push(["e_k13", "to", "e_gray_tavern"]);
allExits.push(e_k13);
objectsNameMap["k13"] = e_k13;
e_houses2 = {
"elementtype": "object",
"name": "houses2",
"parent": e_street_peasants,
"type": "object",
"alias": "houses",
"scenery": true,
"look": "The houses in this area are mostly shacks and ruins.",
"alt": ["house"],
"displayverbs": ["Look at"],
"_js_name": "e_houses2",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["houses2"] = e_houses2;
allObjects.push(e_houses2);
objectsNameMap["houses2"] = e_houses2;
e_dark_alley = {
"elementtype": "object",
"name": "dark_alley",
"parent": e_The_hidden_city,
"type": "object",
"description": "There is a door guarded by a big bouncer to the west. The door leads to stairs, and the stairs leads to darkness... ",
"alias": "dark alley",
"enter": function() { if (Contains (this,e_outlaw_thug)) {
OutputText ("The thug is cornered in this alley!");
} },
"onexit": function() { if (Contains (e_dark_alley,e_outlaw_thug)) {
set(e_outlaw_thug, "parent", e_main_square);
} },
"_js_name": "e_dark_alley",
"_types": ["PublicRoom", "defaultobject"],
"public_level": 3,
"public_greeting": "An unknown passerby says <i>Hi {player.playername}! Good luck with your quest!</i>",
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["dark_alley"] = e_dark_alley;
allObjects.push(e_dark_alley);
objectsNameMap["dark_alley"] = e_dark_alley;
e_k14 = {
"elementtype": "object",
"name": "k14",
"parent": e_dark_alley,
"type": "exit",
"alias": "north",
"to": e_street_peasants,
"_js_name": "e_k14",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k14"] = e_k14;
allExits.push(e_k14);
objectsNameMap["k14"] = e_k14;
e_k15 = {
"elementtype": "object",
"name": "k15",
"parent": e_dark_alley,
"type": "exit",
"alias": "west",
"suffix": "",
"_js_name": "e_k15",
"_types": ["westdirection", "defaultexit"],
"alt": ["w"],
"prefix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k15"] = e_k15;
objectReferences.push(["e_k15", "to", "e_guild_thieves"]);
allExits.push(e_k15);
objectsNameMap["k15"] = e_k15;
e_YellowWoman = {
"elementtype": "object",
"name": "YellowWoman",
"parent": e_dark_alley,
"type": "object",
"alias": "yellow hooded woman",
"look": "What could I say... she is a kind of lower class courtesan. <br/>She has a recent black eye, and some bruises in the face.",
"visible": false,
"alt": ["woman"],
"speak": function() { if (Contains (e_dark_alley,e_YellowWoman)) {
OutputText ("She starts crying, trying to conceal her {command:ask woman about bruises:bruises}");
}
else {
OutputText ("<i>Hey baby... when you will have time to buy me drink ?</i>");
} },
"give": {"drunkring": function() { OutputText ("<i>- It is beautiful! Thank you very much ... don't you want to drink something in my home?<br/>- I would be delighted, but first I need to ask you a favor: go to the tavern and find your boyfriend, the thug. Then, distract him for me. Can I count on you?<br/>- Ok. I will help you.</i><br/>She left in the direction of the Grey Tavern");
MoveObject (e_YellowWoman, e_gray_tavern);
MoveObject (e_drunkring, e_YellowWoman); } },
"ask": {"bruises eye": function() { if (e_drunkguy.visible) {
OutputText ("<i>Give me something valuable and I will help you find that thug.</i>");
}
else {
OutputText ("<i>My boyfriend, that bastard thug! He has stolen all my money.</i>");
OutputText ("As she tells you about her boyfriend, you suspect that he is the man you are looking for.");
OutputText ("You ask her to help you, and she replies:");
OutputText ("<i>Give me something valuable and I will help you find that thug.</i>");
MakeObjectVisible (e_drunkguy);
} } },
"_js_name": "e_YellowWoman",
"_types": ["female", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "she",
"article": "her",
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["YellowWoman"] = e_YellowWoman;
allObjects.push(e_YellowWoman);
objectsNameMap["YellowWoman"] = e_YellowWoman;
e_bouncer = {
"elementtype": "object",
"name": "bouncer",
"parent": e_dark_alley,
"type": "object",
"scenery": true,
"look": "He is menacing. Better not stare too much at him.",
"speak": "He does not want to talk.",
"displayverbs": ["Look at"],
"_js_name": "e_bouncer",
"_types": ["male", "defaultobject"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["bouncer"] = e_bouncer;
allObjects.push(e_bouncer);
objectsNameMap["bouncer"] = e_bouncer;
e_guild_thieves = {
"elementtype": "object",
"name": "guild_thieves",
"parent": e_The_hidden_city,
"type": "object",
"alias": "the Guild of the Thieves",
"usedefaultprefix": false,
"description": "You are standing in a dark hall, filled with shabby furniture and wicked looking people. ",
"public_level": 2,
"public_greeting": "An apprentice greets you: <i>Hi {player.playername}! Let's kick that evil wizard back to hell!</i>",
"onexit": function() { if (e_player.isMage || e_player.isWarrior) {
if (e_purse.coins>0) {
OutputText ("After you exit the room, you realize that your purse seems lighter.");
set(e_purse, "coins", e_purse.coins -1);
}
} },
"_js_name": "e_guild_thieves",
"_types": ["PublicRoom", "defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["guild_thieves"] = e_guild_thieves;
allObjects.push(e_guild_thieves);
objectsNameMap["guild_thieves"] = e_guild_thieves;
e_k16 = {
"elementtype": "object",
"name": "k16",
"parent": e_guild_thieves,
"type": "exit",
"alias": "east",
"to": e_dark_alley,
"_js_name": "e_k16",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k16"] = e_k16;
allExits.push(e_k16);
objectsNameMap["k16"] = e_k16;
e_elder_thief = {
"elementtype": "object",
"name": "elder_thief",
"parent": e_guild_thieves,
"type": "object",
"usedefaultprefix": false,
"look": "He is an old man with a long beard, very few teeths, and an eye patch. He smiles at you, which only makes you feel more scared!",
"displayverbs": ["Look at", "Speak to"],
"alias": "Kadrak",
"suffix": "the elder thief",
"alt": ["thief", "elder thief"],
"feature_usegive": true,
"speak": function() { psay ("{once:I'm Kadrak the elder.}{notfirst:Greetings again {player.playername}.}");
if (e_player.class == "none") {
Ask ("<i>Are you sure you want to become a Thief?</i>", function (result) { if (result) {
set(e_player, "class", "thief");
set(e_player, "isThief", true);
set(e_demon_guard2, "parent", e_void);
UnlockExit (e_corridor2_to_antechamber);
OutputText ("After a long time of street training, robbing, and gambling you became a decent thief. "+Template("HelpThief"));
AddToInventory (e_picklock);
set(e_well_exit, "locked", false);
set(e_exit_to_forge, "locked", false);
set(e_dragon_sewer_exit, "locked", false);
} });
}
else if (e_player.class == "thief") {
OutputText ("<i>Ask me if you need something. Ask about {command:ask Kadrak about training:training} if you need it.</i>");
OutputText ("<i>I can also buy off the product of your work. Just give me your item and I can make an offer for it.</i>");
if (e_invis_potion.parent== e_elder_thief && e_player.level>2) {
OutputText ("<i>If you are interested in something for a big heist, I have an invisibility {command:ask kadrak about potion:potion} for sale for 500 coins.</i>");
}
}
else if (e_player.class == "mage" && e_kobold_ring.visible && e_kobold_ring.parent==e_elder_thief) {
OutputText ("<i>{command:ask Kadrak about ring:Ring}? ah... this ring. How did you know about it? </i>");
} },
"askdefault": function() { OutputText ("You can ask me about training if you are a thief. I can also buy stolen objects."); },
"giveanything": function() { 
var object = arguments[0].object; //JS
if (HasAttribute(object,"worth")) {
set(e_elder_thief, "deal_obj", object);
Ask ("<i>I can pay "+object.worth+" for this "+GetDisplayAlias(object)+". Are you interested?</i>", function (result) { if (result) {
var obj = e_elder_thief.deal_obj;
var val = GetInt(obj,"worth");
MoveObject (obj, e_void);
set(e_purse, "coins", e_purse.coins + val);
OutputText ("You place "+val+" coins at your purse.");
} });
}
else {
OutputText ("<i>I'm not interested on buying this "+GetDisplayAlias(object)+".</i>");
} },
"ask": {"train training": function() { if (e_player.isThief) {
switch (e_player.level) {
case 0:
psay ("Only if you can steal something for me: Let me see... steal a necklace from someone and bring it to me.");
break;
case 1:
psay ("Inside the gray tavern you will find a short thug with a scar in his face. He is operating at my city without paying the proper taxes. You know, for our guild. He is a convicted outlaw, but nobody cares about arresting and executing him. Please, make him ... uh ... disappear.");
break;
case 2:
psay ("This is the last task of your training. It will prove the supremacy of the guild of the thieves over all other guilds in this town. Steal a personal object from Dashiel and Derrick. Bring these items back to me");
break;

}
if (e_player.level>2) {
psay ("The training is over. But if you are interested in something for a big heist, I have an invisibility {command:ask kadrak about potion:potion} for sale.");
}
}
else {
psay ("Sorry, I cannot help you with that.");
} }, "ring": function() { if (e_kobold_ring.parent==e_elder_thief) {
if (e_kobold_ring.visible) {
psay ("It's a nice ring. I could sell it to you, but by the size of your purse, you will never have enough money.");
}
else {
psay ("What are you talking about?");
}
}
else {
psay ("I don't have it anymore...");
} }, "potion": function() { if (e_player.isThief) {
if (e_purse.coins<500) {
psay ("The price is 500 coins, and you do not have enough money.");
}
else {
Ask ("Do you want to pay 500 coins for an invisibilty potion?", function (result) { if (result) {
set(e_invis_potion, "parent", e_player);
set(e_purse, "coins", e_purse.coins-500);
OutputText ("Now, it is only one dose, and it will work just for a few minutes. Good luck!");
} });
}
}
else {
OutputText ("I known NOTHING about such things.");
} } },
"give": {"necklace": function() { psay ("Nice! Now I can give this necklace to another unhappy lady. Take this dagger. You can try to sneak an opponent and backstab him ... well, if he doesn't wear any armor. Ask me about {ask:kadrak:training} when you are ready to the next training task.");
set(e_player, "level", 1);
AddToInventory (e_dagger);
RemoveObject (e_necklace); }, "gold_dagger": function() { psay ("Perfect! This should teach that weapon's master what guild rules the town! Here, take this dagger as a replacement for your previous one.");
AddToInventory (e_dagger);
MoveObject (e_gold_dagger, e_void);
check_thief_quest(); }, "wand": function() { psay ("Amazing! A used wand from the archmage... he will be amazed by our superiority! No magery can stop wits...");
MoveObject (e_wand, e_void);
check_thief_quest(); }, "fake_diamond": function() { psay ("That is something of real value... Take my ring, I hope you will find it useful.");
MoveObject (e_kobold_ring, e_player);
RemoveObject (e_fake_diamond); } },
"_js_name": "e_elder_thief",
"_types": ["male", "defaultobject"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["elder_thief"] = e_elder_thief;
allObjects.push(e_elder_thief);
objectsNameMap["elder_thief"] = e_elder_thief;
e_kobold_ring = {
"elementtype": "object",
"name": "kobold_ring",
"parent": e_elder_thief,
"type": "object",
"alias": "emerald ring",
"take": true,
"look": "It is an emerald ring.{if kobold_ring.known=1: It may be the Kobold's magical ring.}<br/>",
"visible": false,
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"feature_usegive": true,
"use": true,
"givesingle": true,
"known": 0,
"_js_name": "e_kobold_ring",
"_types": ["defaultobject"],
"displayverbs": ["Look at", "Take"],
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["kobold_ring"] = e_kobold_ring;
allObjects.push(e_kobold_ring);
objectsNameMap["kobold_ring"] = e_kobold_ring;
e_invis_potion = {
"elementtype": "object",
"name": "invis_potion",
"parent": e_elder_thief,
"type": "object",
"take": true,
"alias": "invisibility potion",
"look": "It looks like water. {if invis_potion.uses=1:It is full.}{if invis_potion.uses>1:It is 1/{invis_potion.uses} full.}",
"feature_usegive": true,
"uses": 1,
"inventoryverbs": ["Look at", "Drop", "Drink"],
"givesingle": true,
"use": function() { drinkInvisPotion(); },
"drink": function() { drinkInvisPotion(); },
"_js_name": "e_invis_potion",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["invis_potion"] = e_invis_potion;
allObjects.push(e_invis_potion);
objectsNameMap["invis_potion"] = e_invis_potion;
e_apprentices1 = {
"elementtype": "object",
"name": "apprentices1",
"parent": e_guild_thieves,
"type": "object",
"scenery": true,
"alias": "apprentices",
"look": "The apprentices are training their skills.",
"speak": "The apprentices are too busy to chat now.",
"_js_name": "e_apprentices1",
"_types": ["maleplural", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "they",
"article": "them",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["apprentices1"] = e_apprentices1;
allObjects.push(e_apprentices1);
objectsNameMap["apprentices1"] = e_apprentices1;
e_people_thief = {
"elementtype": "object",
"name": "people_thief",
"parent": e_guild_thieves,
"type": "object",
"scenery": true,
"alias": "people",
"look": "They are probably thieves.",
"speak": "They don't talk too much.",
"_js_name": "e_people_thief",
"_types": ["maleplural", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "they",
"article": "them",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["people_thief"] = e_people_thief;
allObjects.push(e_people_thief);
objectsNameMap["people_thief"] = e_people_thief;
e_furniture = {
"elementtype": "object",
"name": "furniture",
"parent": e_guild_thieves,
"type": "object",
"look": "Ordinary furniture for ordinary people.",
"scenery": true,
"_js_name": "e_furniture",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["furniture"] = e_furniture;
allObjects.push(e_furniture);
objectsNameMap["furniture"] = e_furniture;
e_main_street = {
"elementtype": "object",
"name": "main_street",
"parent": e_The_hidden_city,
"type": "object",
"alias": "the main street",
"description": "It is the widest street of Chuma Huppic. To the north you see a large and crowded building. To the south you see a big stable. Many other nice looking houses spread along the street that continues to the east. To the west, you see the Main Square.",
"usedefaultprefix": false,
"enter": function() { if (Contains (this,e_outlaw_thug)) {
OutputText ("<b>The thug runs west!</b>");
MoveObject (e_outlaw_thug, e_main_square);
} },
"_js_name": "e_main_street",
"_types": ["PublicRoom", "defaultobject"],
"public_level": 3,
"public_greeting": "An unknown passerby says <i>Hi {player.playername}! Good luck with your quest!</i>",
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["main_street"] = e_main_street;
allObjects.push(e_main_street);
objectsNameMap["main_street"] = e_main_street;
e_k17 = {
"elementtype": "object",
"name": "k17",
"parent": e_main_street,
"type": "exit",
"alias": "west",
"to": e_main_square,
"_js_name": "e_k17",
"_types": ["westdirection", "defaultexit"],
"alt": ["w"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k17"] = e_k17;
allExits.push(e_k17);
objectsNameMap["k17"] = e_k17;
e_k18 = {
"elementtype": "object",
"name": "k18",
"parent": e_main_street,
"type": "exit",
"alias": "east",
"_js_name": "e_k18",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k18"] = e_k18;
objectReferences.push(["e_k18", "to", "e_city_exit"]);
allExits.push(e_k18);
objectsNameMap["k18"] = e_k18;
e_k19 = {
"elementtype": "object",
"name": "k19",
"parent": e_main_street,
"type": "exit",
"alias": "north",
"_js_name": "e_k19",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k19"] = e_k19;
objectReferences.push(["e_k19", "to", "e_bakery_front"]);
allExits.push(e_k19);
objectsNameMap["k19"] = e_k19;
e_k20 = {
"elementtype": "object",
"name": "k20",
"parent": e_main_street,
"type": "exit",
"alias": "south",
"_js_name": "e_k20",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k20"] = e_k20;
objectReferences.push(["e_k20", "to", "e_stable"]);
allExits.push(e_k20);
objectsNameMap["k20"] = e_k20;
e_houses1 = {
"elementtype": "object",
"name": "houses1",
"parent": e_main_street,
"type": "object",
"alias": "houses",
"scenery": true,
"look": "The houses in this area are ranging from good to very good real state investments. You wonder what this means...",
"alt": ["house"],
"_js_name": "e_houses1",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["houses1"] = e_houses1;
allObjects.push(e_houses1);
objectsNameMap["houses1"] = e_houses1;
e_golden_statue = {
"elementtype": "object",
"name": "golden_statue",
"parent": e_houses1,
"type": "object",
"alias": "golden statue",
"look": "A one feet gold plated statue. Should worth a fortune.",
"take": true,
"worth": 60,
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"feature_usegive": true,
"use": true,
"givesingle": true,
"_js_name": "e_golden_statue",
"_types": ["Treasure", "defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["golden_statue"] = e_golden_statue;
allObjects.push(e_golden_statue);
objectsNameMap["golden_statue"] = e_golden_statue;
e_city_exit = {
"elementtype": "object",
"name": "city_exit",
"parent": e_The_hidden_city,
"type": "object",
"alias": "exit to the maze",
"description": "You are at the end of the main street. A gate leads to the rocky maze that protects the hidden city of Chuma Huppic in the east. The main street leads to the city in the west. Two strong guards keep an eye on who enters and exits the city.",
"usedefaultprefix": false,
"prefix": "the",
"public_greeting": "A guard says <i>Hi {player.playername}! Good luck with your quest!</i>",
"enter": function() { if (e_player.class!="none" && e_exitToMaze.locked==true) {
UnlockExit (e_exitToMaze);
}
if (e_barrier.visible==false && e_player.level==3) {
OutputText ("You hear the voice of Coriander inside your head: <span style=\"color:blue\"><i>The King is expecting you...</i></span>");
} },
"_js_name": "e_city_exit",
"_types": ["PublicRoom", "defaultobject"],
"public_level": 3,
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["city_exit"] = e_city_exit;
allObjects.push(e_city_exit);
objectsNameMap["city_exit"] = e_city_exit;
e_k21 = {
"elementtype": "object",
"name": "k21",
"parent": e_city_exit,
"type": "exit",
"alias": "west",
"to": e_main_street,
"_js_name": "e_k21",
"_types": ["westdirection", "defaultexit"],
"alt": ["w"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k21"] = e_k21;
allExits.push(e_k21);
objectsNameMap["k21"] = e_k21;
e_exitToMaze = {
"elementtype": "object",
"name": "exitToMaze",
"parent": e_city_exit,
"type": "exit",
"alias": "east",
"lockmessage": "You feel it is a better idea to stay in town until you choose a guild. Seek the guild masters for training.",
"locked": true,
"_js_name": "e_exitToMaze",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["exitToMaze"] = e_exitToMaze;
objectReferences.push(["e_exitToMaze", "to", "e_Maze"]);
allExits.push(e_exitToMaze);
objectsNameMap["exitToMaze"] = e_exitToMaze;
e_houses3 = {
"elementtype": "object",
"name": "houses3",
"parent": e_city_exit,
"type": "object",
"alias": "houses",
"scenery": true,
"look": "The houses in this area are just a few, all with large yards.",
"alt": ["house"],
"displayverbs": ["Look at"],
"_js_name": "e_houses3",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["houses3"] = e_houses3;
allObjects.push(e_houses3);
objectsNameMap["houses3"] = e_houses3;
e_guards1 = {
"elementtype": "object",
"name": "guards1",
"parent": e_city_exit,
"type": "object",
"alias": "guards",
"scenery": true,
"prefix": "the",
"suffix": "",
"look": "You see two guards in chain mails. They are busy watching the exit to the maze.",
"speak": "They are too busy to chat now.",
"alt": ["guard"],
"coins": 1,
"displayverbs": ["Look at"],
"_js_name": "e_guards1",
"_types": ["maleplural", "defaultobject"],
"gender": "they",
"article": "them",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["guards1"] = e_guards1;
allObjects.push(e_guards1);
objectsNameMap["guards1"] = e_guards1;
e_maze = {
"elementtype": "object",
"name": "maze",
"parent": e_city_exit,
"type": "object",
"alias": "maze",
"look": "It is a magical maze that protects the city, keeping the invaders out.",
"scenery": true,
"displayverbs": ["Look at"],
"_js_name": "e_maze",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["maze"] = e_maze;
allObjects.push(e_maze);
objectsNameMap["maze"] = e_maze;
e_bakery_front = {
"elementtype": "object",
"name": "bakery_front",
"parent": e_The_hidden_city,
"type": "object",
"alias": " the front of the Bakery",
"description": "You are standing in the front of the bakery. It is a two story building where lives the baker and his family. The first floor is where the bread is sold. You guess that the second floor is the baker's private residence. ",
"descprefix": "You are in",
"usedefaultprefix": false,
"enter": function() { if (Contains (this,e_outlaw_thug)) {
OutputText ("<b>The thug runs south!</b>");
MoveObject (e_outlaw_thug, e_main_street);
} },
"_js_name": "e_bakery_front",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["bakery_front"] = e_bakery_front;
allObjects.push(e_bakery_front);
objectsNameMap["bakery_front"] = e_bakery_front;
e_k22 = {
"elementtype": "object",
"name": "k22",
"parent": e_bakery_front,
"type": "exit",
"alias": "south",
"to": e_main_street,
"_js_name": "e_k22",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k22"] = e_k22;
allExits.push(e_k22);
objectsNameMap["k22"] = e_k22;
e_k23 = {
"elementtype": "object",
"name": "k23",
"parent": e_bakery_front,
"type": "exit",
"alias": "in",
"_js_name": "e_k23",
"_types": ["indirection", "defaultexit"],
"alt": [""],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k23"] = e_k23;
objectReferences.push(["e_k23", "to", "e_bakery"]);
allExits.push(e_k23);
objectsNameMap["k23"] = e_k23;
e_Old_Tree = {
"elementtype": "object",
"name": "Old Tree",
"parent": e_bakery_front,
"type": "object",
"look": "The tree is tall and strong, quite remarkable considering the garbage produced by this bakery.",
"displayverbs": ["Look at"],
"useindividualverblist": false,
"usestandardverblist": true,
"alias": "old tree",
"climb": function() { if (e_player.class=="thief") {
OutputText ("Ok.");
MoveObject (e_player, e_old_treetop);
}
else {
OutputText ("I'm not a children anymore.");
} },
"_js_name": "e_Old_Tree",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["Old Tree"] = e_Old_Tree;
allObjects.push(e_Old_Tree);
objectsNameMap["Old Tree"] = e_Old_Tree;
e_RedGirl = {
"elementtype": "object",
"name": "RedGirl",
"parent": e_bakery_front,
"type": "object",
"alias": "red hooded girl",
"visible": false,
"displayverbs": ["Look at", "Speak to"],
"look": function() { if (e_RedGirl.parent==e_bakery_front) {
OutputText ("She is a young teenager wearing a red hood. She is crying by the tree. ");
}
else {
OutputText ("She is a young teenager wearing a red hood. She smiles at you.");
} },
"speak": function() { if (e_RedGirl.parent==e_bakery_front) {
OutputText ("You ask why is she crying.");
psay ("I need to visit my grandma. She lives in a wooden cabin, in the forest. But I'm not certain of the path, and there is an evil wolf that would not let me get there.");
if (GetBoolean(e_player, "woodcabin")) {
Ask ("are you going to escort the girl to the house?", function (result) { if (result) {
OutputText ("You take the girl to the cabin in the forest. Nothing interesting happens in the way to her house.");
MoveObject (e_RedGirl, e_WoodCabin);
MoveObject (e_player, e_WoodCabin);
} });
}
else {
OutputText ("If only you knew where is this cabin, perhaps you could help her...");
}
}
else if (e_player.class=="mage") {
psay ("Sir, I lost my red {ask:girl:hat} in the city. Could you find it for me? I could not leave my grandma alone.");
}
else {
psay ("Thank you for your help, sir.");
} },
"give": {"red_hat": function() { OutputText ("<i>Oh thank you sir! Do you like apple pies? Here, take one piece for you.</i><br/>She got into the cabin to help her grandma.");
AddToInventory (e_apple_pie);
RemoveObject (e_red_hat);
MakeObjectInvisible (e_RedGirl); } },
"ask": {"hat": function() { psay ("I went to the town courtyard to see the festival, but I forgot my hat somewhere."); }, "pie": function() { if (e_player.class=="mage") {
psay ("It is an apple pie.");
}
else {
psay ("What?");
} } },
"_js_name": "e_RedGirl",
"_types": ["female", "defaultobject"],
"gender": "she",
"article": "her",
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["RedGirl"] = e_RedGirl;
allObjects.push(e_RedGirl);
objectsNameMap["RedGirl"] = e_RedGirl;
e_apple_pie = {
"elementtype": "object",
"name": "apple_pie",
"parent": e_RedGirl,
"type": "object",
"alias": "piece of apple pie",
"eat": "Too many carbs...",
"_js_name": "e_apple_pie",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": true,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["apple_pie"] = e_apple_pie;
allObjects.push(e_apple_pie);
objectsNameMap["apple_pie"] = e_apple_pie;
e_bakery_building = {
"elementtype": "object",
"name": "bakery_building",
"parent": e_bakery_front,
"type": "object",
"scenery": true,
"look": "It is a two story building where lives the baker and his family. The first floor is where the bread is sold. You guess that the second floor is the baker's private residence. ",
"alias": "bakery",
"alt": ["building"],
"_js_name": "e_bakery_building",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["bakery_building"] = e_bakery_building;
allObjects.push(e_bakery_building);
objectsNameMap["bakery_building"] = e_bakery_building;
e_bakery = {
"elementtype": "object",
"name": "bakery",
"parent": e_The_hidden_city,
"type": "object",
"alias": "bakery",
"description": "You are standing inside the baker's shop. The sweet smell of bread contrasts with the dirty walls and the wet flour all over the ground.",
"usedefaultprefix": false,
"descprefix": "You are inside",
"prefix": "the",
"enter": function() { if (e_player.class=="warrior" && e_player.seekingthug==this) {
OutputText ("<b>As you enter the bakery, a sinister man leaves by the door at full speed.</b><br/>The Baker exclaims: <i>Oh my! someone stop that thief! he just robbed me! help!</i>");
set(e_player, "seekingthug", e_bakery_front);
MoveObject (e_outlaw_thug, e_bakery_front);
MakeObjectVisible (e_outlaw_thug);
}
EnableTurnScript (e_bakerTalk); },
"onexit": function() { DisableTurnScript (e_bakerTalk); },
"_js_name": "e_bakery",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["bakery"] = e_bakery;
allObjects.push(e_bakery);
objectsNameMap["bakery"] = e_bakery;
e_k24 = {
"elementtype": "object",
"name": "k24",
"parent": e_bakery,
"type": "exit",
"alias": "out",
"to": e_bakery_front,
"_js_name": "e_k24",
"_types": ["outdirection", "defaultexit"],
"alt": ["o"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k24"] = e_k24;
allExits.push(e_k24);
objectsNameMap["k24"] = e_k24;
e_Baker = {
"elementtype": "object",
"name": "Baker",
"parent": e_bakery,
"type": "object",
"alias": "baker",
"look": "He is fat and sweats a lot... hygiene is not strongly valued around here.",
"buy": "You don't want to buy bread... not from him... disgusting!",
"displayverbs": ["Look at", "Speak to", "Buy"],
"usedefaultprefix": false,
"prefix": "a sweating agitated",
"speak": function() { if (e_player.class=="warrior" && e_player.level>0 && e_pot.parent==e_Baker) {
psay ("Thanks for capturing that thief! Here, take this pot of stew that my wife just prepared for me.");
AddToInventory (e_pot);
}
else {
OutputText ("He is too busy to talk now.");
} },
"useon": {"purse": function() { OutputText ("You would never buy those dirty breads..."); } },
"ask": {"pie pies": function() { psay ("We don't bake these fancy things here..."); } },
"_js_name": "e_Baker",
"_types": ["male", "defaultobject"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["Baker"] = e_Baker;
allObjects.push(e_Baker);
objectsNameMap["Baker"] = e_Baker;
e_pot = {
"elementtype": "object",
"name": "pot",
"parent": e_Baker,
"type": "object",
"alias": "pot with a suspicious stew",
"take": true,
"look": "It is a sturdy iron pot filled with a cold and suspicious stew. Probably unclean pork guts.",
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"feature_usegive": true,
"use": true,
"givesingle": true,
"_js_name": "e_pot",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["pot"] = e_pot;
allObjects.push(e_pot);
objectsNameMap["pot"] = e_pot;
e_bakerTalk = {
"elementtype": "object",
"name": "bakerTalk",
"parent": e_bakery,
"type": "turnscript",
"script": function() { if (e_player.class=="thief") {
var x = GetRandomInt(1,5);
switch (x) {
case 1:
OutputText ("The Baker yells to his wife: <i>Honey, bring me some floor here</i>");
break;
case 2:
OutputText ("The Baker's wife yells to the baker: <i>Sweet, can you buy me a new ring? The only jewelry I have is this old necklace</i>");
break;
case 3:
OutputText ("The Baker yells to his wife <i>Do you think I make gold with this floor honey? </i>");
break;
case 4:
OutputText ("The Baker's wife yells to the baker: <i>Sweet, I need a new dress</i>");
break;
case 5:
OutputText ("The Baker mumbles to himself: <i>dresses, necklaces... </i>");
break;

}
} },
"_js_name": "e_bakerTalk",
"_types": []
};
elementsNameMap["bakerTalk"] = e_bakerTalk;
allTurnScripts.push(e_bakerTalk);
objectsNameMap["bakerTalk"] = e_bakerTalk;
e_old_treetop = {
"elementtype": "object",
"name": "old_treetop",
"parent": e_The_hidden_city,
"type": "object",
"alias": "top of an old tree",
"description": "You are in the top of an old tree. Strong branches reach near an open window to the bedroom.",
"usedefaultprefix": false,
"prefix": "the",
"_js_name": "e_old_treetop",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["old_treetop"] = e_old_treetop;
allObjects.push(e_old_treetop);
objectsNameMap["old_treetop"] = e_old_treetop;
e_k25 = {
"elementtype": "object",
"name": "k25",
"parent": e_old_treetop,
"type": "exit",
"alias": "down",
"to": e_bakery_front,
"_js_name": "e_k25",
"_types": ["downdirection", "defaultexit"],
"alt": ["d"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k25"] = e_k25;
allExits.push(e_k25);
objectsNameMap["k25"] = e_k25;
e_large_window = {
"elementtype": "object",
"name": "large window",
"parent": e_old_treetop,
"type": "exit",
"alias": "in",
"script": function() { OutputText ("you sneaked by the window inside the room");
MoveObject (e_player, e_baker_bedroom); },
"_js_name": "e_large_window",
"_types": ["indirection", "defaultexit"],
"alt": [""],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["large window"] = e_large_window;
objectReferences.push(["e_large_window", "to", "e_baker_bedroom"]);
allExits.push(e_large_window);
objectsNameMap["large window"] = e_large_window;
e_window_bakery = {
"elementtype": "object",
"name": "window_bakery",
"parent": e_old_treetop,
"type": "object",
"alias": "window",
"scenery": true,
"look": "The window to the bedroom is open, and the room seems to be empty.",
"alt": ["bedroom"],
"displayverbs": ["Look at"],
"_js_name": "e_window_bakery",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["window_bakery"] = e_window_bakery;
allObjects.push(e_window_bakery);
objectsNameMap["window_bakery"] = e_window_bakery;
e_baker_bedroom = {
"elementtype": "object",
"name": "baker_bedroom",
"parent": e_The_hidden_city,
"type": "object",
"alias": "bedroom of the baker",
"description": "It is a messy bed room, with dirty clothes everywhere.",
"usedefaultprefix": false,
"prefix": "the",
"_js_name": "e_baker_bedroom",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["baker_bedroom"] = e_baker_bedroom;
allObjects.push(e_baker_bedroom);
objectsNameMap["baker_bedroom"] = e_baker_bedroom;
e_k26 = {
"elementtype": "object",
"name": "k26",
"parent": e_baker_bedroom,
"type": "exit",
"alias": "out",
"to": e_old_treetop,
"_js_name": "e_k26",
"_types": ["outdirection", "defaultexit"],
"alt": ["o"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k26"] = e_k26;
allExits.push(e_k26);
objectsNameMap["k26"] = e_k26;
e_bed = {
"elementtype": "object",
"name": "bed",
"parent": e_baker_bedroom,
"type": "object",
"look": "A large bed for two large citizens. You can't find anything under the bed.",
"displayverbs": ["Look at"],
"hide": function() { if (ListContains(ScopeReachable(), e_necklace)) {
if (e_necklace.hide_on) {
OutputText ("I do not need to hide anymore.");
}
else {
OutputText ("You hide under the bed while the huge baker's wife enters the room. When she starts changing her dress, you decide to close your eyes ... after a few minutes she leaves the room and you get out of your hiding place.");
SetObjectFlagOn (e_necklace, "hide_on");
DisableTurnScript (e_necklaceTimer);
}
}
else {
OutputText ("I do not need to hide now.");
} },
"_js_name": "e_bed",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"useindividualverblist":false,
"usestandardverblist":true,
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["bed"] = e_bed;
allObjects.push(e_bed);
objectsNameMap["bed"] = e_bed;
e_dressing_table = {
"elementtype": "object",
"name": "dressing table",
"parent": e_baker_bedroom,
"type": "object",
"alt": ["drawer"],
"look": "It is just an ordinary dress table with a small wooden door.",
"feature_container": true,
"keycount": 1,
"listchildren": true,
"displayverbs": ["Look at", "Open"],
"useindividualverblist":false,
"usestandardverblist":true,
"picklock": function() { if (e_dressing_table.locked==true) {
OutputText ("You unlock the dressing table.");
set(e_dressing_table, "locked", false);
HelperOpenObject (e_dressing_table);
OutputText("It contains a {object:necklace}.");
}
else {
OutputText ("It is open");
} },
"inventoryverbs": ["Look at", "Use", "Drop", "Open", "Close"],
"key": e_null_key,
"_js_name": "e_dressing_table",
"_types": ["container_lockable", "container_closed", "defaultobject"],
"locked": true,
"nokeymessage": "You do not have the key.",
"unlockmessage": "Unlocked.",
"lockmessage": "Locked.",
"canlockopen": false,
"autoopen": true,
"autounlock": true,
"openscript": function() { if (this.locked) {
if (this.autounlock && AllKeysAvailable(this)) {
runscriptattribute2 (this, "unlock");
if (!(this.isopen)) {
OpenObject (this);
}
}
else {
OutputText (overloadedFunctions.DynamicTemplate("LockedObject", this));
}
}
else {
OpenObject (this);
} },
"closescript": function() { if (this.locked) {
OutputText (overloadedFunctions.DynamicTemplate("LockedObject", this));
}
else {
CloseObject (this);
} },
"lock": function() { if (this.locked) {
OutputText (overloadedFunctions.DynamicTemplate("AlreadyLocked", this));
}
else if (this.isopen && !(this.canlockopen)) {
OutputText (overloadedFunctions.DynamicTemplate("CannotLockOpen", this));
}
else {
if (AllKeysAvailable(this)) {
OutputText (this.lockmessage);
set(this, "locked", true);
}
else {
OutputText (this.nokeymessage);
}
} },
"unlock": function() { if (!(this.locked)) {
OutputText (overloadedFunctions.DynamicTemplate("AlreadyUnlocked", this));
}
else {
if (AllKeysAvailable(this)) {
OutputText (this.unlockmessage);
set(this, "locked", false);
if (this.autoopen && !(this.isopen)) {
TryOpenClose (true, this);
}
}
else {
OutputText (this.nokeymessage);
}
} },
"open": true,
"close": true,
"container": true,
"visible": true,
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["dressing table"] = e_dressing_table;
allObjects.push(e_dressing_table);
objectsNameMap["dressing table"] = e_dressing_table;
e_necklace = {
"elementtype": "object",
"name": "necklace",
"parent": e_dressing_table,
"type": "object",
"hide_on": false,
"look": "It is made of cooper with some colorful stones. It has a dubious value...",
"inventoryverbs": ["Look at", "Drop", "Give"],
"alias": "necklace",
"visible": true,
"displayverbs": ["Look at", "Take"],
"turns": 0,
"givesingle": true,
"useindividualverblist": false,
"usestandardverblist": true,
"feature_usegive": true,
"take": function() { if (e_necklace.hide_on) {
AddToInventory (e_necklace);
OutputText ("You got it!");
}
else {
OutputText ("Before you could think about taking it, someone approaches the room...");
MoveObject (e_necklace, e_baker_bedroom);
EnableTurnScript (e_necklaceTimer);
} },
"_js_name": "e_necklace",
"_types": ["defaultobject"],
"use": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["necklace"] = e_necklace;
allObjects.push(e_necklace);
objectsNameMap["necklace"] = e_necklace;
e_necklaceTimer = {
"elementtype": "object",
"name": "necklaceTimer",
"parent": e_baker_bedroom,
"type": "turnscript",
"script": function() { if (e_necklace.hide_on) {
DisableTurnScript (e_necklaceTimer);
set(e_necklace, "turns", 0);
}
else if (e_necklace.turns<2) {
set(e_necklace, "turns", e_necklace.turns+1);
}
else {
OutputText ("<b>You managed to escape in the last minute, without the necklace...</b>");
MoveObject (e_player, e_old_treetop);
set(e_necklace, "turns", 0);
DisableTurnScript (e_necklaceTimer);
} },
"_js_name": "e_necklaceTimer",
"_types": []
};
elementsNameMap["necklaceTimer"] = e_necklaceTimer;
allTurnScripts.push(e_necklaceTimer);
objectsNameMap["necklaceTimer"] = e_necklaceTimer;
e_clothes = {
"elementtype": "object",
"name": "clothes",
"parent": e_baker_bedroom,
"type": "object",
"alt": ["cloth"],
"look": "I will not touch this!",
"scenery": true,
"displayverbs": ["Look at"],
"_js_name": "e_clothes",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["clothes"] = e_clothes;
allObjects.push(e_clothes);
objectsNameMap["clothes"] = e_clothes;
e_gray_tavern = {
"elementtype": "object",
"name": "gray_tavern",
"parent": e_The_hidden_city,
"type": "object",
"alias": "the gray tavern",
"usedefaultprefix": false,
"description": "You stand inside a noisy and dark tavern filled with lower class harlots, thieves, and other people of low moral fiber. The beer is weak like water and the wine tastes like vinegar.",
"public_greeting": "An unknown customer says <i>Hi {player.playername}! Good luck with your quest!</i>.",
"enter": function() { if (Contains (e_gray_tavern,e_YellowWoman) && Contains (e_gray_tavern,e_outlaw_thug) && e_outlaw_thug.visible) {
OutputText ("The woman and the thug are distracted in some kind of argument...");
} },
"_js_name": "e_gray_tavern",
"_types": ["PublicRoom", "defaultobject"],
"public_level": 3,
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["gray_tavern"] = e_gray_tavern;
allObjects.push(e_gray_tavern);
objectsNameMap["gray_tavern"] = e_gray_tavern;
e_k27 = {
"elementtype": "object",
"name": "k27",
"parent": e_gray_tavern,
"type": "exit",
"alias": "south",
"to": e_street_peasants,
"_js_name": "e_k27",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k27"] = e_k27;
allExits.push(e_k27);
objectsNameMap["k27"] = e_k27;
e_outlaw_thug = {
"elementtype": "object",
"name": "outlaw_thug",
"parent": e_gray_tavern,
"type": "object",
"visible": false,
"look": "He has a huge scar in his face.",
"displayverbs": ["Look at", "Speak to"],
"stablist": ["Kill the bastard! He deserves this", "Deliver him to the authorities"],
"speak": "<i>Get lost, peasant!</i>",
"alias": "outlaw thug",
"alt": ["thug"],
"_js_name": "e_outlaw_thug",
"_types": ["male", "defaultobject"],
"gender": "he",
"article": "him",
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["outlaw_thug"] = e_outlaw_thug;
allObjects.push(e_outlaw_thug);
objectsNameMap["outlaw_thug"] = e_outlaw_thug;
e_drunkguy = {
"elementtype": "object",
"name": "drunkguy",
"parent": e_gray_tavern,
"type": "object",
"alias": "drunk guy",
"visible": false,
"sleep": false,
"look": function() { if (e_drunkguy.sleep) {
OutputText ("He is sleeping over the table.");
}
else {
OutputText ("He is so drunk that he barely can stand up.<br/>He wears a valuable ring in his right hand.");
} },
"speak": function() { if (e_drunkguy.sleep) {
OutputText ("Better leave him sleeping on his chair.");
}
else {
Ask ("<i>Would you buy me a cup of wine, noble sir?<i>", function (result) { if (result) {
set(e_purse, "coins", e_purse.coins-1);
SetObjectFlagOn (e_drunkguy, "sleep");
OutputText ("You spend 1 coin and gave the wine to the drunk fellow. He drank all at once, and fall asleep over the table.");
} });
} },
"_js_name": "e_drunkguy",
"_types": ["male", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["drunkguy"] = e_drunkguy;
allObjects.push(e_drunkguy);
objectsNameMap["drunkguy"] = e_drunkguy;
e_drunkring = {
"elementtype": "object",
"name": "drunkring",
"parent": e_drunkguy,
"type": "object",
"alias": "ring",
"take": true,
"look": "A silver ring with a probably semi-precious stone. Nice, and with some value.",
"use": true,
"givesingle": true,
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"feature_usegive": true,
"_js_name": "e_drunkring",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["drunkring"] = e_drunkring;
allObjects.push(e_drunkring);
objectsNameMap["drunkring"] = e_drunkring;
e_wander_mage = {
"elementtype": "object",
"name": "wander_mage",
"parent": e_gray_tavern,
"type": "object",
"visible": false,
"alias": "Raffaella",
"usedefaultprefix": false,
"suffix": "the wandering wizard",
"look": "She is a tall woman with a dark brown hair and a somewhat tired looking. She wears a worn scarlet dress and is sitting alone.",
"intro": false,
"speak": function() { if (!(e_wander_mage.intro)) {
psay ("Hi, my name is Raffaella. I sense that you are a {command:ask Raffaella about magic:magic} student and that {command:ask Raffaella about Dashiel:Dashiel} is your teacher, alright? I was once his student too... but now I help him bringing information about the {command:ask Raffaella about enemy:enemy} forces.");
set(e_wander_mage, "intro", true);
}
else {
psay ("Hi "+e_player.playername+". How is your {ask:Raffaella:magic:magical trainig} with {ask:Raffaella:Dashiel} going? I'm still researching about the {ask:Raffaella:enemy} forces.");
} },
"ask": {"Dashiel": function() { psay ("Dashiel is a great master to introduce you to the magic arts, but it is really hard to make him teach anything more advanced. I guess that he doesn't want competition."); }, "magic magical training": function() { psay ("I'm a wizard, and yes, I know a few tricks. I'm very good with the {command:ask Raffaella about apportation:apportation} spell."); }, "enemy enemies": function() { psay ("I found out that there is a spy in the city. He calls himself White Wolf. I told Dashiel about him, but he is too lazy to get out that guild."); }, "apportation": function() { if (Got(e_apport_spell)) {
psay ("You already know about that...");
}
else {
psay ("Don't you know the {ask:Raffaella:apportation} spell? This spell lets you grab small objects from distance, and levitate towards you. You know what, I will teach it to you... IF you can bring me a sweet piece of pie. ");
} } },
"give": {"apple_pie": function() { OutputText ("<i>Great! that's exactly what I needed!</i>. After eating the pie, she teaches you how to perform the apportation spell.");
MoveObject (e_apport_spell, e_spell_book);
RemoveObject (e_apple_pie); } },
"_js_name": "e_wander_mage",
"_types": ["female", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "she",
"article": "her",
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["wander_mage"] = e_wander_mage;
allObjects.push(e_wander_mage);
objectsNameMap["wander_mage"] = e_wander_mage;
e_customers = {
"elementtype": "object",
"name": "customers",
"parent": e_gray_tavern,
"type": "object",
"coins": 2,
"usedefaultprefix": false,
"prefix": "a mob of",
"speak": "You're too busy to socialize right now.",
"alt": ["customer", "harlot", "harlots"],
"look": function() { if ((e_player.level==1 && e_player.class=="thief")) {
MakeObjectVisible (e_outlaw_thug);
OutputText ("Sitting in a far table you see the {object:outlaw_thug:thug} you are looking for. He wears a black hood to hide his identity.");

if (e_player.class=="thief") {
MakeObjectVisible (e_YellowWoman);
}
}
else {
OutputText ("You can't find anybody interesting. ");
} },
"_js_name": "e_customers",
"_types": ["maleplural", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "they",
"article": "them",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["customers"] = e_customers;
allObjects.push(e_customers);
objectsNameMap["customers"] = e_customers;
e_k28 = {
"elementtype": "object",
"name": "k28",
"parent": e_gray_tavern,
"type": "command",
"anonymous": true,
"pattern": "^order (?<text>.*)$",
"unresolved": "order what?",
"script": function(parameters) { var text = parameters['text'];
if (text=="beer") {
OutputText ("This beer does not worth a coin.");
}
else if (text=="wine") {
OutputText ("This wine is bad for my stomach. However, it does goes well with a salad.");
}
else {
OutputText ("They don't have it here.");
} },
"_js_name": "e_k28",
"_types": ["defaultcommand"]
};
elementsNameMap["k28"] = e_k28;
allCommands.push(e_k28);
objectsNameMap["k28"] = e_k28;
e_courtyard1 = {
"elementtype": "object",
"name": "courtyard1",
"parent": e_The_hidden_city,
"type": "object",
"alias": "improvised courtyard",
"description": "The courtyard is a big and crowded area, surrounded by several buildings that now host what was left of the king's court. Several warriors are taking part in contests as part of the spring festival. All sorts of weapons and armor pieces are piled in a corner to be used in the contest.",
"_js_name": "e_courtyard1",
"_types": ["PublicRoom", "defaultobject"],
"public_level": 3,
"public_greeting": "An unknown passerby says <i>Hi {player.playername}! Good luck with your quest!</i>",
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["courtyard1"] = e_courtyard1;
allObjects.push(e_courtyard1);
objectsNameMap["courtyard1"] = e_courtyard1;
e_k29 = {
"elementtype": "object",
"name": "k29",
"parent": e_courtyard1,
"type": "exit",
"alias": "south",
"to": e_main_square,
"_js_name": "e_k29",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k29"] = e_k29;
allExits.push(e_k29);
objectsNameMap["k29"] = e_k29;
e_contesters = {
"elementtype": "object",
"name": "contesters",
"parent": e_courtyard1,
"type": "object",
"alias": "contestants",
"look": "They all look tough and ready to kill.",
"usedefaultprefix": false,
"prefix": "the",
"suffix": " of the spring festival",
"speak": "<i>Get lost, peasant!</i>",
"alt": ["warriors"],
"_js_name": "e_contesters",
"_types": ["maleplural", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "they",
"article": "them",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["contesters"] = e_contesters;
allObjects.push(e_contesters);
objectsNameMap["contesters"] = e_contesters;
e_weapons = {
"elementtype": "object",
"name": "weapons",
"parent": e_courtyard1,
"type": "object",
"scenery": true,
"look": "You see small swords, two handed swords, maces, shields, bucklers, spears, axes and a net. The weapons are of poor quality, the good stuff was already taken.",
"takemsg": "You can't take them... they are for the contest.",
"_js_name": "e_weapons",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["weapons"] = e_weapons;
allObjects.push(e_weapons);
objectsNameMap["weapons"] = e_weapons;
e_armor = {
"elementtype": "object",
"name": "armor",
"parent": e_courtyard1,
"type": "object",
"scenery": true,
"takemsg": "You can't take them... they are for the contest.",
"alt": ["armour"],
"look": function() { if (e_buckler.parent==e_armor && e_player.class=="warrior") {
OutputText ("You see breast plates, light jackets, chainmails , helmets, leather caps, gloves, and metal sleeves. All this equipment was heavily worn, broken, or does not fit your size. But you found a nice <b>buckler</b> that you decide to keep.");
MoveObject (e_buckler, e_player);
}
else if (e_player.class=="mage" && e_red_hat.visible==false) {
MakeObjectVisible (e_red_hat);
OutputText ("You found a nice {object:red_hat} among shields and breast plates.");
}
else {
OutputText ("You see breast plates, light jackets, chainmails , helmets, leather caps, gloves, and metal sleeves. All this equipment was heavily worn, broken, or does not fit your size.");
} },
"_js_name": "e_armor",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["armor"] = e_armor;
allObjects.push(e_armor);
objectsNameMap["armor"] = e_armor;
e_buckler = {
"elementtype": "object",
"name": "buckler",
"parent": e_armor,
"type": "object",
"alias": "small buckler",
"look": "An ordinary wooden buckler.",
"take": true,
"loc": "shield",
"inventoryverbs": ["Look at", "Drop"],
"_js_name": "e_buckler",
"_types": ["Armour", "defaultobject"],
"armour": 1,
"visible": true,
"displayverbs": ["Look at", "Take"],
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["buckler"] = e_buckler;
allObjects.push(e_buckler);
objectsNameMap["buckler"] = e_buckler;
e_referee = {
"elementtype": "object",
"name": "referee",
"parent": e_courtyard1,
"type": "object",
"alias": "referee",
"look": "He is an old veteran with old battle scars...",
"usedefaultprefix": false,
"prefix": "the",
"suffix": " of the contest",
"speak": function() { if (e_player.contest>1) {
psay ("The contest is over! you are the champion!");
}
else if (e_player.class=="warrior") {
psay ("The contest works as follows: each warrior will fight three times.<br/>The fee to participate is one coin. If you win three consecutive fights, you get the festival prize.");
if (e_player.level<2) {
psay ("Interested? the contest has not yet started... you will have a few hours to make up your mind!");
}
else if (e_player.contest==1) {
psay ("Go ahead, fight one of them!");
}
else if (e_purse.coins==0) {
psay ("No cash, no fights!");
}
else {
Ask ("<i>Do you want to fight now?</i>", function (result) { if (result) {
set(e_player, "contest", 1);
set(e_purse, "coins", e_purse.coins-1);
set(e_contester1, "visible", true);
set(e_contester2, "visible", true);
set(e_contester3, "visible", true);
psay ("You'll fight Arnold, James, and John! Good luck!");
} });
}
}
else {
OutputText ("This contest is only for warriors! but you can watch it, if it pleases you.");
} },
"_js_name": "e_referee",
"_types": ["male", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["referee"] = e_referee;
allObjects.push(e_referee);
objectsNameMap["referee"] = e_referee;
e_k30 = {
"elementtype": "object",
"name": "k30",
"parent": e_courtyard1,
"type": "exit",
"alias": "north",
"runscript": true,
"script": function() { if (e_player.level>3 || (e_player.level==3 && e_barrier.visible==false)) {
MoveObject (e_player, e_throne);
}
else {
OutputText ("The King's herald blocks your way into the Throne Room: <i>Only nobles and subjects of great value or heroism can claim an audience with the King</i>.");
} },
"_js_name": "e_k30",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k30"] = e_k30;
objectReferences.push(["e_k30", "to", "e_throne"]);
allExits.push(e_k30);
objectsNameMap["k30"] = e_k30;
e_contester1 = {
"elementtype": "object",
"name": "contester1",
"parent": e_courtyard1,
"type": "object",
"alias": "Arnold",
"usedefaultprefix": false,
"suffix": ", the squire",
"visible": false,
"danger": "friend",
"exp": 1,
"look": "He is not that strong.",
"speak": "<i>I'm ready for you!</i>",
"_js_name": "e_contester1",
"_types": ["Enemy", "male", "defaultobject"],
"enemy": "yes",
"ht": 10,
"armour": 0,
"aggressive": false,
"stab_level": 0,
"affect_calm": false,
"block_flee": false,
"damage": 2,
"push": function() { if (e_player.parent==e_combat_room) {
if (e_combat.pushed) {
OutputText ("You can only push one time before you combat movement.");
}
else if (savedRandomInt(0,1)==0) {
OutputText ("You successfully push "+this.alias+".");
set(e_combat, "en_red", e_combat.en_red+1);
}
else {
OutputText ("You tried to push "+this.alias+", but ended up losing your balance.");
set(e_combat, "pl_red", e_combat.pl_red+1);
}
set(e_combat, "pushed", true);
}
else {
OutputText ("It doesn't work.");
} },
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["contester1"] = e_contester1;
allObjects.push(e_contester1);
objectsNameMap["contester1"] = e_contester1;
e_contester2 = {
"elementtype": "object",
"name": "contester2",
"parent": e_courtyard1,
"type": "object",
"danger": "friend",
"ht": 12,
"exp": 2,
"armour": 1,
"visible": false,
"alias": "James",
"usedefaultprefix": false,
"suffix": ", the spearman",
"look": "He looks quite professional",
"speak": "<i>Ha! You are a joke!</i>",
"_js_name": "e_contester2",
"_types": ["male", "Enemy", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"enemy": "yes",
"aggressive": false,
"stab_level": 0,
"affect_calm": false,
"block_flee": false,
"damage": 2,
"push": function() { if (e_player.parent==e_combat_room) {
if (e_combat.pushed) {
OutputText ("You can only push one time before you combat movement.");
}
else if (savedRandomInt(0,1)==0) {
OutputText ("You successfully push "+this.alias+".");
set(e_combat, "en_red", e_combat.en_red+1);
}
else {
OutputText ("You tried to push "+this.alias+", but ended up losing your balance.");
set(e_combat, "pl_red", e_combat.pl_red+1);
}
set(e_combat, "pushed", true);
}
else {
OutputText ("It doesn't work.");
} },
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["contester2"] = e_contester2;
allObjects.push(e_contester2);
objectsNameMap["contester2"] = e_contester2;
e_contester3 = {
"elementtype": "object",
"name": "contester3",
"parent": e_courtyard1,
"type": "object",
"danger": "friend",
"ht": 12,
"exp": 2,
"armour": 2,
"visible": false,
"usedefaultprefix": false,
"alias": "John",
"suffix": ", the berserker",
"look": "If not the stronger, he is the meaner of the three.",
"speak": "<i>What kind of warrior uses this kind of gear? You look like a peasant!</i>",
"_js_name": "e_contester3",
"_types": ["male", "Enemy", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"enemy": "yes",
"aggressive": false,
"stab_level": 0,
"affect_calm": false,
"block_flee": false,
"damage": 2,
"push": function() { if (e_player.parent==e_combat_room) {
if (e_combat.pushed) {
OutputText ("You can only push one time before you combat movement.");
}
else if (savedRandomInt(0,1)==0) {
OutputText ("You successfully push "+this.alias+".");
set(e_combat, "en_red", e_combat.en_red+1);
}
else {
OutputText ("You tried to push "+this.alias+", but ended up losing your balance.");
set(e_combat, "pl_red", e_combat.pl_red+1);
}
set(e_combat, "pushed", true);
}
else {
OutputText ("It doesn't work.");
} },
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["contester3"] = e_contester3;
allObjects.push(e_contester3);
objectsNameMap["contester3"] = e_contester3;
e_board = {
"elementtype": "object",
"name": "board",
"parent": e_courtyard1,
"type": "object",
"alias": "bulletin board",
"look": "You see several notes, you can read them... if you know how to read.",
"displayverbs": ["Look at", "Read"],
"read_away": true,
"read": function() { if (e_player.class=="mage") {
if (e_player.level==2) {
OutputText ("You found an interesting note here: \"<i>Way up high in the tall tall trees <br/>The wind rushes by like a gentle breeze. <br/>Way up from everyone, from all the laughter <br/>and all the fun <br/>I sit as solemn as can be and wish that I <br/>were a tall, tall tree. <br/>In the hills, west of the wooden cabin - W.W.</i>\". ");
MakeObjectVisible (e_letter);
MakeObjectVisible (e_wander_mage);
}
else {
OutputText ("There are so many notes... what are you looking for?");
}
}
else {
OutputText ("Huh... I can't read");
} },
"_js_name": "e_board",
"_types": ["Readable", "defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["board"] = e_board;
allObjects.push(e_board);
objectsNameMap["board"] = e_board;
e_red_hat = {
"elementtype": "object",
"name": "red_hat",
"parent": e_courtyard1,
"type": "object",
"alias": "red hat",
"visible": false,
"take": true,
"look": "It is a small red hat.",
"inventoryverbs": ["Look at", "Drop", "Give"],
"feature_usegive": true,
"givesingle": true,
"_js_name": "e_red_hat",
"_types": ["defaultobject"],
"displayverbs": ["Look at", "Take"],
"use": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["red_hat"] = e_red_hat;
allObjects.push(e_red_hat);
objectsNameMap["red_hat"] = e_red_hat;
e_mouse_house = {
"elementtype": "object",
"name": "mouse_house",
"parent": e_The_hidden_city,
"type": "object",
"alias": "hole in the wall",
"description": "You are now a small mouse. The way back to the guild of the mages is blocked by the huge Erasmus, the archmage's cat. You see another hole leading to northwest.",
"descprefix": "You are in",
"usedefaultprefix": true,
"onexit": function() { OutputText ("When you enter the lab, you regain your natural size. This room is probably spell-proof."); },
"_js_name": "e_mouse_house",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["mouse_house"] = e_mouse_house;
allObjects.push(e_mouse_house);
objectsNameMap["mouse_house"] = e_mouse_house;
e_k31 = {
"elementtype": "object",
"name": "k31",
"parent": e_mouse_house,
"type": "exit",
"alias": "northwest",
"_js_name": "e_k31",
"_types": ["northwestdirection", "defaultexit"],
"alt": ["nw"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k31"] = e_k31;
objectReferences.push(["e_k31", "to", "e_mage_lab"]);
allExits.push(e_k31);
objectsNameMap["k31"] = e_k31;
e_mage_lab = {
"elementtype": "object",
"name": "mage_lab",
"parent": e_The_hidden_city,
"type": "object",
"alias": "magical lab",
"description": "The lab is a dim room, filled with magical symbols, potions, herbs, and all that wizard stuff. There is a round door leading south. ",
"onexit": function() { OutputText ("When you cross to the other side, the door behind you disappear. You can hear Dashiel laughing at you."); },
"_js_name": "e_mage_lab",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["mage_lab"] = e_mage_lab;
allObjects.push(e_mage_lab);
objectsNameMap["mage_lab"] = e_mage_lab;
e_desk = {
"elementtype": "object",
"name": "desk",
"parent": e_mage_lab,
"type": "object",
"look": "The desk is a mess of jars, scrolls, and many other magical stuff. You better not touch anything there, it is certainly magically protected.",
"takemsg": "It's too heavy... and I would not touch it anyway",
"alias": "desk",
"displayverbs": ["Look at"],
"alt": ["jars", "scrolls", "stuff"],
"_js_name": "e_desk",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["desk"] = e_desk;
allObjects.push(e_desk);
objectsNameMap["desk"] = e_desk;
e_painting = {
"elementtype": "object",
"name": "painting",
"parent": e_mage_lab,
"type": "object",
"look": "It is a full body portrait of the archmage. He follows you with his eyes... creepy!",
"takemsg": "I'd ratter leave this alone",
"alias": "large painting",
"_js_name": "e_painting",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["painting"] = e_painting;
allObjects.push(e_painting);
objectsNameMap["painting"] = e_painting;
e_rug = {
"elementtype": "object",
"name": "rug",
"parent": e_mage_lab,
"type": "object",
"look": "It is probably a flying carpet... not going to mess with this",
"takemsg": "Better not mess with this... ",
"alias": "Persian rug",
"_js_name": "e_rug",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["rug"] = e_rug;
allObjects.push(e_rug);
objectsNameMap["rug"] = e_rug;
e_wand = {
"elementtype": "object",
"name": "wand",
"parent": e_mage_lab,
"type": "object",
"look": "I'm sure it belongs to the archmage because it has his monogram. It is broken in two pieces, and hopefully does not work anymore as magical device.",
"visible": false,
"alias": "broken wand",
"take": true,
"takemsg": "I think it should be safe... after all it is broken",
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"feature_usegive": true,
"use": true,
"givesingle": true,
"_js_name": "e_wand",
"_types": ["defaultobject"],
"displayverbs": ["Look at", "Take"],
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["wand"] = e_wand;
allObjects.push(e_wand);
objectsNameMap["wand"] = e_wand;
e_garbage = {
"elementtype": "object",
"name": "garbage",
"parent": e_mage_lab,
"type": "object",
"alias": "garbage can",
"displayverbs": ["Look at"],
"look": function() { if (!(e_wand.visible)) {
MakeObjectVisible (e_wand);
OutputText ("You found a {object:wand} in the garbage.");
}
else {
OutputText ("You see a lot of... garbage.");
} },
"_js_name": "e_garbage",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["garbage"] = e_garbage;
allObjects.push(e_garbage);
objectsNameMap["garbage"] = e_garbage;
e_k32 = {
"elementtype": "object",
"name": "k32",
"parent": e_mage_lab,
"type": "exit",
"alias": "south",
"to": e_guild_mages,
"_js_name": "e_k32",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k32"] = e_k32;
allExits.push(e_k32);
objectsNameMap["k32"] = e_k32;
e_ordinary_bag = {
"elementtype": "object",
"name": "ordinary bag",
"parent": e_mage_lab,
"type": "object",
"take": true,
"inventoryverbs": ["Look at", "Drop"],
"look": function() { OutputText ("It's empty, except for a few coins left in the bottom. You grab 4 coins and place them in your purse. ");
set(e_purse, "coins", e_purse.coins+4);
MakeObjectInvisible (e_ordinary_bag); },
"_js_name": "e_ordinary_bag",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["ordinary bag"] = e_ordinary_bag;
allObjects.push(e_ordinary_bag);
objectsNameMap["ordinary bag"] = e_ordinary_bag;
e_warrior_room = {
"elementtype": "object",
"name": "warrior_room",
"parent": e_The_hidden_city,
"type": "object",
"alias": "weapons master private room",
"usedefaultprefix": false,
"prefix": "the",
"description": "This room is a large office/bedroom. You see a large bed, a desk, a couple chairs and a closet. ",
"beforeenter": function() { if (e_player.class=="thief" && e_player.level>=2) {
OutputText ("You use all your stealth to sneak into the room... and nobody notices.");
} },
"_js_name": "e_warrior_room",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["warrior_room"] = e_warrior_room;
allObjects.push(e_warrior_room);
objectsNameMap["warrior_room"] = e_warrior_room;
e_warrior_room_stuff = {
"elementtype": "object",
"name": "warrior_room_stuff",
"parent": e_warrior_room,
"type": "object",
"scenery": true,
"alias": "bed",
"alt": ["desk", "chairs", "closet. "],
"displayverbs": ["Look at"],
"look": "You can't find anything personal or interesting.",
"_js_name": "e_warrior_room_stuff",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["warrior_room_stuff"] = e_warrior_room_stuff;
allObjects.push(e_warrior_room_stuff);
objectsNameMap["warrior_room_stuff"] = e_warrior_room_stuff;
e_iron_safe = {
"elementtype": "object",
"name": "iron_safe",
"parent": e_warrior_room,
"type": "object",
"alias": "iron safe",
"visible": true,
"isopen": false,
"feature_container": true,
"keycount": 1,
"displayverbs": ["Look at", "Open", "Close"],
"useindividualverblist":false,
"usestandardverblist":true,
"look": function() { if (e_iron_safe.isopen) {
OutputText ("It is open.");
if (e_gold_dagger.parent==this) {
OutputText ("Strange... the base of the safe is loose inside the safe. It may have some sort of weight based mechanism.");
}
}
else {
OutputText ("It is a reinforced iron safe with a key lock. It is closed.");
} },
"picklock": function() { if (e_player.class=="thief") {
if (this.locked) {
OutputText ("It was not easy, but you managed to unlock the safe.");
set(this, "locked", false);
}
else {
OutputText ("It is already unlocked.");
}
}
else {
OutputText ("You do not know how to do this.");
} },
"inventoryverbs": ["Look at", "Use", "Drop", "Open", "Close"],
"key": e_null_key,
"_js_name": "e_iron_safe",
"_types": ["container_lockable", "container_open", "defaultobject"],
"locked": true,
"nokeymessage": "You do not have the key.",
"unlockmessage": "Unlocked.",
"lockmessage": "Locked.",
"canlockopen": false,
"autoopen": true,
"autounlock": true,
"openscript": function() { if (this.locked) {
if (this.autounlock && AllKeysAvailable(this)) {
runscriptattribute2 (this, "unlock");
if (!(this.isopen)) {
OpenObject (this);
}
}
else {
OutputText (overloadedFunctions.DynamicTemplate("LockedObject", this));
}
}
else {
OpenObject (this);
} },
"closescript": function() { if (this.locked) {
OutputText (overloadedFunctions.DynamicTemplate("LockedObject", this));
}
else {
CloseObject (this);
} },
"lock": function() { if (this.locked) {
OutputText (overloadedFunctions.DynamicTemplate("AlreadyLocked", this));
}
else if (this.isopen && !(this.canlockopen)) {
OutputText (overloadedFunctions.DynamicTemplate("CannotLockOpen", this));
}
else {
if (AllKeysAvailable(this)) {
OutputText (this.lockmessage);
set(this, "locked", true);
}
else {
OutputText (this.nokeymessage);
}
} },
"unlock": function() { if (!(this.locked)) {
OutputText (overloadedFunctions.DynamicTemplate("AlreadyUnlocked", this));
}
else {
if (AllKeysAvailable(this)) {
OutputText (this.unlockmessage);
set(this, "locked", false);
if (this.autoopen && !(this.isopen)) {
TryOpenClose (true, this);
}
}
else {
OutputText (this.nokeymessage);
}
} },
"open": true,
"close": true,
"container": true,
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["iron_safe"] = e_iron_safe;
allObjects.push(e_iron_safe);
objectsNameMap["iron_safe"] = e_iron_safe;
e_gold_dagger = {
"elementtype": "object",
"name": "gold_dagger",
"parent": e_iron_safe,
"type": "object",
"look": "It must belong to the Weapon's Master.",
"alias": "gold dagger",
"inventoryverbs": ["Look at", "Drop", "Give"],
"feature_usegive": true,
"givesingle": true,
"take": function() { get_gold_dagger (this); },
"useon": {"dagger": function() { OutputText ("You carefully replace the golden dagger with your own dagger.");
MoveObject (e_gold_dagger, e_player);
MoveObject (e_dagger, e_iron_safe); } },
"_js_name": "e_gold_dagger",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"use": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["gold_dagger"] = e_gold_dagger;
allObjects.push(e_gold_dagger);
objectsNameMap["gold_dagger"] = e_gold_dagger;
e_bag_master = {
"elementtype": "object",
"name": "bag_master",
"parent": e_iron_safe,
"type": "object",
"visible": false,
"alias": "bag",
"look": "It is not in the base of the safe, but glued behind the door.",
"take": function() { OutputText ("You recover your money.");
set(e_purse, "coins", e_purse.coins+e_bag_master.coins);
MakeObjectInvisible (e_bag_master); },
"_js_name": "e_bag_master",
"_types": ["defaultobject"],
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["bag_master"] = e_bag_master;
allObjects.push(e_bag_master);
objectsNameMap["bag_master"] = e_bag_master;
e_k33 = {
"elementtype": "object",
"name": "k33",
"parent": e_warrior_room,
"type": "exit",
"alias": "southwest",
"to": e_guild_warriors,
"_js_name": "e_k33",
"_types": ["southwestdirection", "defaultexit"],
"alt": ["sw"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k33"] = e_k33;
allExits.push(e_k33);
objectsNameMap["k33"] = e_k33;
e_stable = {
"elementtype": "object",
"name": "stable",
"parent": e_The_hidden_city,
"type": "object",
"alias": "stable",
"description": "It is a clean and neat horse stable, filled with healthy looking horses.",
"firstenter": function() { OutputText ("Sheila looks very upset with something..."); },
"_js_name": "e_stable",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["stable"] = e_stable;
allObjects.push(e_stable);
objectsNameMap["stable"] = e_stable;
e_k34 = {
"elementtype": "object",
"name": "k34",
"parent": e_stable,
"type": "exit",
"alias": "north",
"to": e_main_street,
"_js_name": "e_k34",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k34"] = e_k34;
allExits.push(e_k34);
objectsNameMap["k34"] = e_k34;
e_stablemiss = {
"elementtype": "object",
"name": "stablemiss",
"parent": e_stable,
"type": "object",
"alias": "Sheila",
"look": "Sheila is a tall and strong girl with a curled blond hair and deep green eyes. You both know each other from childhood.",
"usedefaultprefix": false,
"suffix": ", the amazon",
"speak": function() { if (e_barrier.visible==true) {
psay ("Hey {player.playername}. Drat! The {command:ask Sheila about brigands:brigands} are ruining my {command:ask Sheila about business:business}! They blockaded the road and I can't rent out my {command:ask Sheila about horses:horses} anymore.");
}
else {
psay ("Thank you {player.playername}! Now you can take a horse any time you need it.");
} },
"askdefault": function() { askHelp(); },
"ask": {"brigands brigand": function() { psay ("With the war, brigands are not afraid of attacking travelers, even at day time. Their {command:ask Sheila about leader:leader} ordered that the King's road be blockaded, and is especially cruel with those still loyal to the King."); }, "leader": function() { psay ("The brigand leader is probably at the services of the dark mage."); }, "Vourtram": function() { psay ("We better not speak his name... the dark mage ruined my business."); }, "bucket": function() { if (e_bucket2.visible) {
psay ("I don't need this bucket anymore. You can have it.");
}
else {
psay ("The horse must eat all the hay in the bucket... but he kind of misses the {command:ask Sheila about carrots:carrots}</i>.");
} }, "carrot carrots": function() { psay ("<i>I used to gather carrots in the forest, but now it is too dangerous.</i>"); }, "horse horses": function() { if (e_barrier.visible) {
psay ("I can't rent out any horse with the brigand blockade. To make it worse, my best stallion refuses to eat the hay.");
}
else {
psay ("Thanks for finishing the blockade! You can take my best horse for free.");
} }, "business": function() { psay ("This war is bad for business."); } },
"_js_name": "e_stablemiss",
"_types": ["namedfemale", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "she",
"article": "her",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["stablemiss"] = e_stablemiss;
allObjects.push(e_stablemiss);
objectsNameMap["stablemiss"] = e_stablemiss;
e_horse = {
"elementtype": "object",
"name": "horse",
"parent": e_stable,
"type": "object",
"alias": "horse",
"displayverbs": ["Look at", "Take", "Speak to"],
"speak": "You say <i>Good boy</i>. The horse looks at you and thinks... <i>What a loser...</i>",
"look": function() { OutputText ("It is a reliable model...");
if (e_bucket1.visible==false) {
OutputText ("He seems disgusted with this {object:bucket1:bucket} of hay.");
set(e_bucket1, "visible", true);
} },
"take": function() { if (e_barrier.visible==true) {
OutputText ("You would not be able to pass the brigands...");
}
else if (e_horse.parent==e_the_base) {
OutputText ("This fast stallion gallops the way to the hidden city in less than an hour.");
set(e_game, "turns", e_game.turns+25);
MoveObject (e_horse, e_stable);
MoveObject (e_player, e_stable);
}
else {
OutputText ("This fast stallion gallops the way to the castle in less than an hour.");
set(e_game, "turns", e_game.turns+25);
set(e_horse, "parent", e_the_base);
MoveObject (e_player, e_the_base);
} },
"give": {"carrots": function() { OutputText ("The horse loves carrots, but I need it to eat the hay."); } },
"_js_name": "e_horse",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["horse"] = e_horse;
allObjects.push(e_horse);
objectsNameMap["horse"] = e_horse;
e_bucket1 = {
"elementtype": "object",
"name": "bucket1",
"parent": e_stable,
"type": "object",
"take": false,
"takemsg": "Sheila stops you: <i>You can't take it. The horse must eat all the hay in the bucket first... it hasn't eaten for days.</i>.",
"visible": false,
"alias": "bucket",
"look": "It is full of hay.",
"_js_name": "e_bucket1",
"_types": ["defaultobject"],
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["bucket1"] = e_bucket1;
allObjects.push(e_bucket1);
objectsNameMap["bucket1"] = e_bucket1;
e_bucket2 = {
"elementtype": "object",
"name": "bucket2",
"parent": e_stable,
"type": "object",
"take": true,
"alias": "bucket",
"visible": false,
"fill": false,
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"feature_usegive": true,
"use": true,
"givesingle": true,
"useCmds": ["fill", "pour"],
"look": function() { if (e_bucket2.fill) {
OutputText ("It is filled with cold water.");
}
else {
OutputText ("It is an empty bucket.");
} },
"selfuseon": {"rapids": function() { OutputText ("You fills the bucket with cold water.");
set(e_bucket2, "fill", true); }, "tied_brigand": function() { if (e_bucket2.fill) {
if (e_tied_brigand.sleep) {
set(e_tied_brigand, "sleep", false);
set(e_tied_brigand, "alias", "Elias");
OutputText ("You throw the water at the man and he wakes up. He says:<br/><i>'Thank you for freeing me, mighty adventurer. I'm {object:tied_brigand:Elias} the brigand... or perhaps the ex-brigand.'</i>");
set(e_bucket2, "fill", false);
}
else {
OutputText ("Why should I do that?");
}
}
else {
OutputText ("It is empty!");
} } },
"_js_name": "e_bucket2",
"_types": ["UseAltType", "defaultobject"],
"displayverbs": ["Look at", "Take"],
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["bucket2"] = e_bucket2;
allObjects.push(e_bucket2);
objectsNameMap["bucket2"] = e_bucket2;
e_throne = {
"elementtype": "object",
"name": "throne",
"parent": e_The_hidden_city,
"type": "object",
"alias": "Throne Room",
"usedefaultprefix": false,
"prefix": "the",
"description": "You are standing in an improvised throne room. Sitting in wooden throne is the King, performing his morning audiences to the public. Around the King you can see the few surviving counselors and royal guard. ",
"descprefix": "You are in",
"beforeenter": function() { var uplev = false;
if (e_player.level==3 && e_barrier.visible==false) {
set(e_player, "level", 4);
var uplev = true;
}
if (e_player.level<4) {
OutputText ("The King's herald blocks your way into the Throne Room: <i>Only nobles and subjects of great value or heroism can claim an audience with the King</i>.");
MoveObject (e_player, e_courtyard1);
}
else if (e_player.level>=4) {
var txmsg = "The King's herald announces your entrance: <i><br/>Mr. "+e_player.playername;
if (e_player.class=="thief") {
var txmsg = txmsg+"  the bounty hunter, the restorer of stolen artwork, the city liberator, proficient in the art of cunning, deception, and trickery;";
}
else if (e_player.class=="warrior") {
var txmsg = txmsg+" the wolf slayer, the bounty hunter, the winner of the spring warrior's contest, and the city liberator;";
}
else if (e_player.class=="mage") {
var txmsg = txmsg+" the werewolf banisher, the spy hunter, the city liberator, the wise, and proficient in the occult arts;";
}
if (uplev) {
OutputText (txmsg+"<BR><span style=\"color:blue\">"+e_player.playername+" is now declared a Hero of Gwalinad by our majesty</span>, King Alden IV, conqueror of Therandra, slayer of the giant snake, and master of Gwalinad.</i><br/>");
playsound ("fanfare10.wav", false, false);
clearPast(100);  //JS
}
else {
OutputText (txmsg+" begs an audience with your majesty, King Alden IV, conqueror of Therandra, slayer of the giant snake, master of Gwalinad.</i><br/>");
}
} },
"_js_name": "e_throne",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["throne"] = e_throne;
allObjects.push(e_throne);
objectsNameMap["throne"] = e_throne;
e_k35 = {
"elementtype": "object",
"name": "k35",
"parent": e_throne,
"type": "exit",
"alias": "south",
"to": e_courtyard1,
"_js_name": "e_k35",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k35"] = e_k35;
allExits.push(e_k35);
objectsNameMap["k35"] = e_k35;
e_king = {
"elementtype": "object",
"name": "king",
"parent": e_throne,
"type": "object",
"alias": "King Alden IV",
"usedefaultprefix": false,
"prefix": "the",
"look": "An old King with no hope and a sad look.",
"speak": "<i>My dear hero! How the king can help you against {command:ask king about Vourtram:Vourtram}, the evil sorcerer?</i>",
"suffix": ", sitting in his improvised throne",
"ask": {"Vourtram": function() { psay ("Vourtram was an apprentice of the former archmage, the master of Dashiel. He sold his {ask:king:soul} to the devil, raising an {ask:king:army} of darkness to conquer the kingdom."); }, "soul": function() { psay ("Vourtram's body has no soul. Because of this, he is immortal. Many tried to harm him, but no one ever was able to even scratch him."); }, "army": function() { psay ("Vourtram's army is formed by demons, traitors, and mercenaries. That's all we know for now."); } },
"_js_name": "e_king",
"_types": ["namedmale", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["king"] = e_king;
allObjects.push(e_king);
objectsNameMap["king"] = e_king;
e_king_minstrel = {
"elementtype": "object",
"name": "king_minstrel",
"parent": e_throne,
"type": "object",
"alias": "Amicia",
"look": "Amicia is grizzled middle aged minstrel, with an oblonged face and an easy smile.",
"usedefaultprefix": false,
"suffix": "the minstrel",
"alt": ["minstrel"],
"speak": "<i>Hi! I heard you are going to the {command:ask Amicia about castle:castle} of {command:ask Amicia about Vourtram:Vourtram}.</i>",
"feature_usegive": true,
"ask": {"castle": function() { psay ("The castle has changed a lot, but I hope they haven\u00b4t messed with the {command:ask Amicia about music hall:music hall}."); }, "music hall": function() { psay ("The music hall has the best {command:ask Amicia about instruments:instruments} of the kingdom."); }, "instruments": function() { psay ("There are the psaltery, the lute and the amazing {command:ask Amicia about harpsichord:harpsichord}."); }, "harpsichord": function() { psay ("I\u00b4d love to play the Pavane again on that harpsichord. It has an unbelievable sound.");
set(e_king_minstrel, "pavane", true); }, "Vourtram": function() { psay ("That monster knows nothing about music."); } },
"give": {"lute": function() { OutputText ("<i>What a beautiful instrument. Thanks {player.playername}.</i>");
MoveObject (e_lute, e_void); } },
"_js_name": "e_king_minstrel",
"_types": ["female", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "she",
"article": "her",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["king_minstrel"] = e_king_minstrel;
allObjects.push(e_king_minstrel);
objectsNameMap["king_minstrel"] = e_king_minstrel;
e_Maze_Area = {
"elementtype": "object",
"name": "Maze_Area",
"type": "object",
"_js_name": "e_Maze_Area",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["Maze_Area"] = e_Maze_Area;
allObjects.push(e_Maze_Area);
objectsNameMap["Maze_Area"] = e_Maze_Area;
e_Maze = {
"elementtype": "object",
"name": "Maze",
"parent": e_Maze_Area,
"type": "object",
"description": "The maze is a two mile wide series of confusing paths in the mountain connecting the valley of the hidden city to the old kingdom, now under the control of the evil wizard. There is small path to the northen hills, and the maze continues east towards the eastern road.",
"usedefaultprefix": false,
"alias": "maze to the hidden city",
"prefix": "the",
"enter": function() { if (e_player.level>0) {
UnlockExit (e_mazeToRoad);
}
if (Contains (e_Maze,e_outlaw_thug)) {
OutputText ("<b>The thug menaces you with his dagger</b>");
OutputText ("The Kobold arrives to help you. He utters some magical words and the outlaw is suddenly grounded and cannot move.<br/>A few moments later, a guard arrives and you receive a reward of 10 coins for his capture.<br/>The Kobold waves a goodbye and disappears in the shadows.");
MoveObject (e_outlaw_thug, e_void);
MoveObject (e_kobold, e_void);
set(e_player, "level", 2);
set(e_purse, "coins", e_purse.coins+10);
} },
"_js_name": "e_Maze",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["Maze"] = e_Maze;
allObjects.push(e_Maze);
objectsNameMap["Maze"] = e_Maze;
e_k36 = {
"elementtype": "object",
"name": "k36",
"parent": e_Maze,
"type": "exit",
"alias": "west",
"to": e_city_exit,
"_js_name": "e_k36",
"_types": ["westdirection", "defaultexit"],
"alt": ["w"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k36"] = e_k36;
allExits.push(e_k36);
objectsNameMap["k36"] = e_k36;
e_red_rock = {
"elementtype": "object",
"name": "red_rock",
"parent": e_Maze,
"type": "object",
"take": true,
"alias": "red rock",
"look": "It is a small red rock. It makes a loud noise when bashed to another rock.",
"inventoryverbs": ["Look at", "Use", "Drop", "Throw"],
"feature_usegive": true,
"use": true,
"givesingle": true,
"useindividualverblist": false,
"usestandardverblist": true,
"throw": function() { if (e_red_rock.parent==e_player) {
OutputText ("You throw the rock and it makes a funny noise. You retrieve the rock, just in case it may be of some use in the future.");
}
else {
OutputText ("You don't have it.");
} },
"selfuseon": {"sewer_entrance": function() { OutputText ("After a few seconds the rock hits the bottom... it is a long way down.");
MoveObject (e_red_rock, e_sewer); } },
"_js_name": "e_red_rock",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["red_rock"] = e_red_rock;
allObjects.push(e_red_rock);
objectsNameMap["red_rock"] = e_red_rock;
e_k37 = {
"elementtype": "object",
"name": "k37",
"parent": e_Maze,
"type": "exit",
"alias": "north",
"_js_name": "e_k37",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k37"] = e_k37;
objectReferences.push(["e_k37", "to", "e_Forested_Hill_1"]);
allExits.push(e_k37);
objectsNameMap["k37"] = e_k37;
e_mazeToRoad = {
"elementtype": "object",
"name": "mazeToRoad",
"parent": e_Maze,
"type": "exit",
"alias": "east",
"locked": true,
"lockmessage": "You don't feel like you are ready to leave the protection of the maze yet...",
"_js_name": "e_mazeToRoad",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["mazeToRoad"] = e_mazeToRoad;
objectReferences.push(["e_mazeToRoad", "to", "e_road1"]);
allExits.push(e_mazeToRoad);
objectsNameMap["mazeToRoad"] = e_mazeToRoad;
e_Forested_Hill_1 = {
"elementtype": "object",
"name": "Forested Hill 1",
"parent": e_Maze_Area,
"type": "object",
"alias": "forested hill",
"description": "The terrain here is rocky and the path is covered with a thin and soft snow. You can climb the hills further north, or go east towards a glade.",
"onexit": function() { wolfFollow (this); },
"enter": function() { checkWolf (this); },
"_js_name": "e_Forested_Hill_1",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["Forested Hill 1"] = e_Forested_Hill_1;
allObjects.push(e_Forested_Hill_1);
objectsNameMap["Forested Hill 1"] = e_Forested_Hill_1;
e_k38 = {
"elementtype": "object",
"name": "k38",
"parent": e_Forested_Hill_1,
"type": "exit",
"alias": "south",
"to": e_Maze,
"_js_name": "e_k38",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k38"] = e_k38;
allExits.push(e_k38);
objectsNameMap["k38"] = e_k38;
e_k39 = {
"elementtype": "object",
"name": "k39",
"parent": e_Forested_Hill_1,
"type": "exit",
"alias": "north",
"_js_name": "e_k39",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k39"] = e_k39;
objectReferences.push(["e_k39", "to", "e_Forested_Hill_2"]);
allExits.push(e_k39);
objectsNameMap["k39"] = e_k39;
e_k40 = {
"elementtype": "object",
"name": "k40",
"parent": e_Forested_Hill_1,
"type": "exit",
"alias": "east",
"_js_name": "e_k40",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k40"] = e_k40;
objectReferences.push(["e_k40", "to", "e_WoodCabin"]);
allExits.push(e_k40);
objectsNameMap["k40"] = e_k40;
e_tall_tree = {
"elementtype": "object",
"name": "tall_tree",
"parent": e_Forested_Hill_1,
"type": "object",
"hidechildren": true,
"isopen": true,
"alias": "tall tree",
"open": false,
"close": false,
"transparent": true,
"look": "A tall and slim tree",
"listchildren": true,
"listchildrenprefix": "in the top of the tree you see",
"displayverbs": ["Look at"],
"_js_name": "e_tall_tree",
"_types": ["surface", "defaultobject"],
"contentsprefix": "on which there is",
"container": true,
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"description": "",
"scenery": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["tall_tree"] = e_tall_tree;
allObjects.push(e_tall_tree);
objectsNameMap["tall_tree"] = e_tall_tree;
e_letter = {
"elementtype": "object",
"name": "letter",
"parent": e_tall_tree,
"type": "object",
"visible": false,
"alias": "letter",
"usedefaultprefix": false,
"suffix": "",
"takemsg": "It is too high. I can't reach it.",
"take": false,
"drop": false,
"dropmsg": "You better not drop this letter now.",
"prefix": "a",
"inventoryverbs": ["Look at", "Drop", "Give", "Read"],
"feature_usegive": true,
"givesingle": true,
"usestandardverblist": true,
"read": function() { if (e_letter.parent == e_player) {
OutputText ("It contains detailed information about the king's troops. It is a letter from the spy to the enemy. <br/>Perhaps Dashiel can discover the author of the letter.");
}
else {
OutputText ("You don't have it.");
} },
"_js_name": "e_letter",
"_types": ["defaultobject"],
"displayverbs": ["Look at", "Take"],
"use": false,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["letter"] = e_letter;
allObjects.push(e_letter);
objectsNameMap["letter"] = e_letter;
e_snow = {
"elementtype": "object",
"name": "snow",
"parent": e_Forested_Hill_1,
"type": "object",
"alt": ["ground", "path", "footprints"],
"scenery": true,
"look": "You can see some human footprints, and also a few large wolf footprints leading north. Too large to normal wolfs, I dare say.  ",
"_js_name": "e_snow",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["snow"] = e_snow;
allObjects.push(e_snow);
objectsNameMap["snow"] = e_snow;
e_Forested_Hill_2 = {
"elementtype": "object",
"name": "Forested Hill 2",
"parent": e_Maze_Area,
"type": "object",
"alias": "forested hill",
"description": "The terrain here is rocky and the path is covered with a thin and soft snow. You can go back south or follow a small trail to the west. All other directions are too difficult to walk without equipment.",
"onexit": function() { wolfFollow (this); },
"enter": function() { checkWolf (this); },
"_js_name": "e_Forested_Hill_2",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["Forested Hill 2"] = e_Forested_Hill_2;
allObjects.push(e_Forested_Hill_2);
objectsNameMap["Forested Hill 2"] = e_Forested_Hill_2;
e_k41 = {
"elementtype": "object",
"name": "k41",
"parent": e_Forested_Hill_2,
"type": "exit",
"alias": "south",
"to": e_Forested_Hill_1,
"_js_name": "e_k41",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k41"] = e_k41;
allExits.push(e_k41);
objectsNameMap["k41"] = e_k41;
e_k42 = {
"elementtype": "object",
"name": "k42",
"parent": e_Forested_Hill_2,
"type": "exit",
"alias": "west",
"_js_name": "e_k42",
"_types": ["westdirection", "defaultexit"],
"alt": ["w"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k42"] = e_k42;
objectReferences.push(["e_k42", "to", "e_wolf_den"]);
allExits.push(e_k42);
objectsNameMap["k42"] = e_k42;
e_snow1 = {
"elementtype": "object",
"name": "snow1",
"parent": e_Forested_Hill_2,
"type": "object",
"alt": ["ground", "path", "footprints", "trail"],
"scenery": true,
"look": "You can see large wolf footprints leading west. They seem fresh.  ",
"_js_name": "e_snow1",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["snow1"] = e_snow1;
allObjects.push(e_snow1);
objectsNameMap["snow1"] = e_snow1;
e_wolf_den = {
"elementtype": "object",
"name": "wolf_den",
"parent": e_Maze_Area,
"type": "object",
"usedefaultprefix": false,
"alias": "front of a huge wolf den",
"description": "Tall trees block the sun light here. This dark corner of the forest is surely scaring you. ",
"onexit": function() { wolfFollow (this);
DisableTurnScript (e_wolfTurn); },
"enter": function() { checkWolf (this);
if (!(GetBoolean(e_player, "wolf"))) {
if (e_player.class=="warrior" && e_smallsword.parent==e_player) {
MakeObjectVisible (e_RedGirl);
}
} },
"_js_name": "e_wolf_den",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["wolf_den"] = e_wolf_den;
allObjects.push(e_wolf_den);
objectsNameMap["wolf_den"] = e_wolf_den;
e_k43 = {
"elementtype": "object",
"name": "k43",
"parent": e_wolf_den,
"type": "exit",
"alias": "east",
"to": e_Forested_Hill_2,
"_js_name": "e_k43",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k43"] = e_k43;
allExits.push(e_k43);
objectsNameMap["k43"] = e_k43;
e_Wolf = {
"elementtype": "object",
"name": "Wolf",
"parent": e_wolf_den,
"type": "object",
"usedefaultprefix": false,
"prefix": "the",
"alias": "evil wolf",
"suffix": "",
"turns": 0,
"calm": 0,
"useindividualverblist": false,
"usestandardverblist": true,
"displayverbs": ["Look at"],
"look": function() { if (e_Wolf.calm>0) {
OutputText ("It is a huge dark wolf of unnatural proportions. It seems he is under the calm spell... ");
}
else {
OutputText ("It is a huge dark wolf of unnatural proportions. It seems it will attack at any moment.");
} },
"_js_name": "e_Wolf",
"_types": ["male", "defaultobject"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["Wolf"] = e_Wolf;
allObjects.push(e_Wolf);
objectsNameMap["Wolf"] = e_Wolf;
e_wolf_lair = {
"elementtype": "object",
"name": "wolf_lair",
"parent": e_wolf_den,
"type": "object",
"close": false,
"open": false,
"hidechildren": true,
"usedefaultprefix": false,
"prefix": "",
"alias": "a lair",
"take": false,
"alt": ["den"],
"inventoryverbs": ["Look at", "Drop", "Close"],
"displayverbs": ["Look at"],
"look": function() { if (e_wolf_fur.visible) {
OutputText ("It is a nasty hole in the ground");
}
else {
OutputText ("It is a nasty hole in the ground. You can see wolf fur all around the place.");
MakeObjectVisible (e_wolf_fur);
} },
"_js_name": "e_wolf_lair",
"_types": ["container_open", "defaultobject"],
"isopen": true,
"container": true,
"visible": true,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["wolf_lair"] = e_wolf_lair;
allObjects.push(e_wolf_lair);
objectsNameMap["wolf_lair"] = e_wolf_lair;
e_wolf_fur = {
"elementtype": "object",
"name": "wolf_fur",
"parent": e_wolf_lair,
"type": "object",
"alias": "wolf's fur",
"visible": false,
"inventoryverbs": ["Look at", "Drop", "Give"],
"feature_usegive": true,
"givesingle": true,
"look": "It is a handful of animal hair.",
"usedefaultprefix": false,
"prefix": "a bunch of",
"alt": ["wolf fur"],
"take": function() { if (e_Wolf.parent==e_player.parent) {
OutputText ("There is no way I could get into the wolf's lair with this beast here.");
}
else {
AddToInventory (e_wolf_fur);
OutputText ("You pick it up.");
} },
"_js_name": "e_wolf_fur",
"_types": ["defaultobject"],
"displayverbs": ["Look at", "Take"],
"use": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["wolf_fur"] = e_wolf_fur;
allObjects.push(e_wolf_fur);
objectsNameMap["wolf_fur"] = e_wolf_fur;
e_Hector = {
"elementtype": "object",
"name": "Hector",
"parent": e_wolf_den,
"type": "object",
"alias": "Hector",
"visible": false,
"look": "He still looks too hairy for a person ... ",
"usedefaultprefix": false,
"suffix": " the wizard",
"speak": "<i>Thank you! I think I will never eat meat again...</i>",
"_js_name": "e_Hector",
"_types": ["male", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["Hector"] = e_Hector;
allObjects.push(e_Hector);
objectsNameMap["Hector"] = e_Hector;
e_reveal_spell = {
"elementtype": "object",
"name": "reveal_spell",
"parent": e_Hector,
"type": "object",
"alias": "reveal spell",
"take": true,
"look": "The Reveal Spell detects magical spells working in the area or subject. It also reveals invisible objects.",
"listalias": "-- reveal spell",
"inventoryverbs": ["Look at", "Cast"],
"castonobject": false,
"_js_name": "e_reveal_spell",
"_types": ["Spell", "defaultobject"],
"castspell": true,
"drop": function() { OutputText ("You don't want to rip your book apart."); },
"use": function() { OutputText ("You don't use a spell, you 'cast' it."); },
"read_away": false,
"read": function() { doRead (this); },
"visible": true,
"displayverbs": ["Look at", "Take"],
"givesingle": false,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["reveal_spell"] = e_reveal_spell;
allObjects.push(e_reveal_spell);
objectsNameMap["reveal_spell"] = e_reveal_spell;
e_WoodCabin = {
"elementtype": "object",
"name": "WoodCabin",
"parent": e_Maze_Area,
"type": "object",
"alias": "front of a wooden cabin",
"description": "You can see an old lady sleeping inside the house. This small glade seems a pretty isolated, although beautiful, place to live.",
"descprefix": "You are in",
"usedefaultprefix": false,
"enter": function() { SetObjectFlagOn (e_player, "woodcabin");
checkWolf (this);
if (e_RedGirl.parent == e_Wolf.parent) {
OutputText ("When the werewolf sees the pure girl he <b>transforms back to the human form</b>. The now human werewolf menaces the girl! <br/>");
OutputText ("You attack him with all your strength. As a human, the beast is no match for you. <b>Finally you killed the monster</b>.");
MoveObject (e_Wolf, e_void);
DisableTurnScript (e_wolfTurn);
MakeObjectVisible (e_werewolf_corpse);
set(e_player, "fightexp", e_player.fightexp+5);
}
if (e_player.class=="mage" && e_RedGirl.parent==e_WoodCabin) {
OutputText ("You smell the sweet aroma of recently baked of apple pies...");
} },
"onexit": function() { wolfFollow (this); },
"_js_name": "e_WoodCabin",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["WoodCabin"] = e_WoodCabin;
allObjects.push(e_WoodCabin);
objectsNameMap["WoodCabin"] = e_WoodCabin;
e_oldlady = {
"elementtype": "object",
"name": "oldlady",
"parent": e_WoodCabin,
"type": "object",
"alias": "old lady",
"scenery": true,
"look": "She is asleep, better not disturb her...",
"displayverbs": ["Look at"],
"_js_name": "e_oldlady",
"_types": ["female", "defaultobject"],
"gender": "she",
"article": "her",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["oldlady"] = e_oldlady;
allObjects.push(e_oldlady);
objectsNameMap["oldlady"] = e_oldlady;
e_k44 = {
"elementtype": "object",
"name": "k44",
"parent": e_WoodCabin,
"type": "exit",
"alias": "west",
"to": e_Forested_Hill_1,
"_js_name": "e_k44",
"_types": ["westdirection", "defaultexit"],
"alt": ["w"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k44"] = e_k44;
allExits.push(e_k44);
objectsNameMap["k44"] = e_k44;
e_werewolf_corpse = {
"elementtype": "object",
"name": "werewolf corpse",
"parent": e_WoodCabin,
"type": "object",
"take": true,
"look": "It turned back to wolf after death.",
"visible": false,
"inventoryverbs": ["Look at", "Drop", "Give"],
"feature_usegive": true,
"givesingle": true,
"_js_name": "e_werewolf_corpse",
"_types": ["defaultobject"],
"displayverbs": ["Look at", "Take"],
"use": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["werewolf corpse"] = e_werewolf_corpse;
allObjects.push(e_werewolf_corpse);
objectsNameMap["werewolf corpse"] = e_werewolf_corpse;
e_sc_cabin = {
"elementtype": "object",
"name": "sc_cabin",
"parent": e_WoodCabin,
"type": "object",
"scenery": true,
"look": "It is a humble wooden cabin in the woods.",
"alt": ["cabin", "house"],
"_js_name": "e_sc_cabin",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["sc_cabin"] = e_sc_cabin;
allObjects.push(e_sc_cabin);
objectsNameMap["sc_cabin"] = e_sc_cabin;
e_road1 = {
"elementtype": "object",
"name": "road1",
"parent": e_Maze_Area,
"type": "object",
"alias": "eastern road",
"description": "The road stretches along the west-east axis of the kingdom. To the north there are impassible mountains and to the south a dense forest. ",
"usedefaultprefix": false,
"prefix": "the",
"public_level": 5,
"_js_name": "e_road1",
"_types": ["PublicRoom", "defaultobject"],
"public_greeting": "An unknown passerby says <i>Hi {player.playername}! Good luck with your quest!</i>",
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["road1"] = e_road1;
allObjects.push(e_road1);
objectsNameMap["road1"] = e_road1;
e_k45 = {
"elementtype": "object",
"name": "k45",
"parent": e_road1,
"type": "exit",
"alias": "west",
"to": e_Maze,
"_js_name": "e_k45",
"_types": ["westdirection", "defaultexit"],
"alt": ["w"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k45"] = e_k45;
allExits.push(e_k45);
objectsNameMap["k45"] = e_k45;
e_k46 = {
"elementtype": "object",
"name": "k46",
"parent": e_road1,
"type": "exit",
"alias": "south",
"_js_name": "e_k46",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k46"] = e_k46;
objectReferences.push(["e_k46", "to", "e_forest1"]);
allExits.push(e_k46);
objectsNameMap["k46"] = e_k46;
e_road_exit2 = {
"elementtype": "object",
"name": "road_exit2",
"parent": e_road1,
"type": "exit",
"alias": "east",
"locked": true,
"lockmessage": "The road is blocked by brigands, armed with long bows... you better not get close.",
"_js_name": "e_road_exit2",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["road_exit2"] = e_road_exit2;
objectReferences.push(["e_road_exit2", "to", "e_road2"]);
allExits.push(e_road_exit2);
objectsNameMap["road_exit2"] = e_road_exit2;
e_barrier = {
"elementtype": "object",
"name": "barrier",
"parent": e_road1,
"type": "object",
"alias": "small camp and a barrier",
"look": "It must be the brigand blockage. They rip off anyone that gets close.",
"usedefaultprefix": false,
"prefix": "a",
"suffix": "just a few miles to the east",
"displayverbs": ["Look at"],
"_js_name": "e_barrier",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["barrier"] = e_barrier;
allObjects.push(e_barrier);
objectsNameMap["barrier"] = e_barrier;
e_road2 = {
"elementtype": "object",
"name": "road2",
"parent": e_Maze_Area,
"type": "object",
"alias": "eastern road",
"usedefaultprefix": false,
"prefix": "the",
"_js_name": "e_road2",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["road2"] = e_road2;
allObjects.push(e_road2);
objectsNameMap["road2"] = e_road2;
e_k47 = {
"elementtype": "object",
"name": "k47",
"parent": e_road2,
"type": "exit",
"alias": "west",
"to": e_road1,
"_js_name": "e_k47",
"_types": ["westdirection", "defaultexit"],
"alt": ["w"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k47"] = e_k47;
allExits.push(e_k47);
objectsNameMap["k47"] = e_k47;
e_dark_forest = {
"elementtype": "object",
"name": "dark_forest",
"type": "object",
"_js_name": "e_dark_forest",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["dark_forest"] = e_dark_forest;
allObjects.push(e_dark_forest);
objectsNameMap["dark_forest"] = e_dark_forest;
e_forest1 = {
"elementtype": "object",
"name": "forest1",
"parent": e_dark_forest,
"type": "object",
"alias": "dark forest",
"turns": 0,
"description": "The path into the dense forest continues to the south, and you can see some light coming from the east.",
"beforeenter": function() { set(this, "turns", 0); },
"_js_name": "e_forest1",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["forest1"] = e_forest1;
allObjects.push(e_forest1);
objectsNameMap["forest1"] = e_forest1;
e_k48 = {
"elementtype": "object",
"name": "k48",
"parent": e_forest1,
"type": "exit",
"alias": "north",
"to": e_road1,
"_js_name": "e_k48",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k48"] = e_k48;
allExits.push(e_k48);
objectsNameMap["k48"] = e_k48;
e_forest1_to_forest_house = {
"elementtype": "object",
"name": "forest1_to_forest_house",
"parent": e_forest1,
"type": "exit",
"alias": "east",
"locked": true,
"lockmessage": "The orc blocks your way.",
"_js_name": "e_forest1_to_forest_house",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["forest1_to_forest_house"] = e_forest1_to_forest_house;
objectReferences.push(["e_forest1_to_forest_house", "to", "e_forest_house"]);
allExits.push(e_forest1_to_forest_house);
objectsNameMap["forest1_to_forest_house"] = e_forest1_to_forest_house;
e_orc1 = {
"elementtype": "object",
"name": "orc1",
"parent": e_forest1,
"type": "object",
"alias": "orc",
"usedefaultprefix": false,
"prefix": "a filthy green",
"suffix": ", ready to attack",
"ht": 12,
"exp": 3,
"armour": 1,
"aggressive": true,
"stab_level": 2,
"affect_calm": true,
"coins": 1,
"rage": false,
"speak": "<i>GRRRRRRRRRR...</i>",
"_js_name": "e_orc1",
"_types": ["Enemy", "male", "defaultobject"],
"enemy": "yes",
"danger": "death",
"block_flee": false,
"damage": 2,
"push": function() { if (e_player.parent==e_combat_room) {
if (e_combat.pushed) {
OutputText ("You can only push one time before you combat movement.");
}
else if (savedRandomInt(0,1)==0) {
OutputText ("You successfully push "+this.alias+".");
set(e_combat, "en_red", e_combat.en_red+1);
}
else {
OutputText ("You tried to push "+this.alias+", but ended up losing your balance.");
set(e_combat, "pl_red", e_combat.pl_red+1);
}
set(e_combat, "pushed", true);
}
else {
OutputText ("It doesn't work.");
} },
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["orc1"] = e_orc1;
allObjects.push(e_orc1);
objectsNameMap["orc1"] = e_orc1;
e_orcAttack = {
"elementtype": "object",
"name": "orcAttack",
"parent": e_forest1,
"type": "turnscript",
"enabled": false,
"script": function() { var room = this.parent;
set(room, "turns", room.turns+1);
if (e_orc1.parent==room && room.turns>=2) {
attack (room, e_orc1);
}
else if (e_orc1.parent==room && e_player.class=="thief") {
OutputText ("<i>You managed to hide yourself until now... </i>");
} },
"_js_name": "e_orcAttack",
"_types": []
};
elementsNameMap["orcAttack"] = e_orcAttack;
allTurnScripts.push(e_orcAttack);
objectsNameMap["orcAttack"] = e_orcAttack;
e_forest1_to_forest_current = {
"elementtype": "object",
"name": "forest1_to_forest_current",
"parent": e_forest1,
"type": "exit",
"alias": "south",
"locked": true,
"lockmessage": "The orc blocks your way.",
"_js_name": "e_forest1_to_forest_current",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["forest1_to_forest_current"] = e_forest1_to_forest_current;
objectReferences.push(["e_forest1_to_forest_current", "to", "e_forest_current"]);
allExits.push(e_forest1_to_forest_current);
objectsNameMap["forest1_to_forest_current"] = e_forest1_to_forest_current;
e_forest2 = {
"elementtype": "object",
"name": "forest2",
"parent": e_dark_forest,
"type": "object",
"alias": "dark forest",
"description": "The forest gets really dense here, and it is not possible to continue further.",
"enter": function() { if (e_tied_brigand.tied) {
psay ("Please help me! I'm tied up here.");
} },
"_js_name": "e_forest2",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["forest2"] = e_forest2;
allObjects.push(e_forest2);
objectsNameMap["forest2"] = e_forest2;
e_tree_forest = {
"elementtype": "object",
"name": "tree_forest",
"parent": e_forest2,
"type": "object",
"look": "It is a somewhat high and slim dead tree.",
"alias": "dead tree",
"displayverbs": ["Look at"],
"useindividualverblist":false,
"usestandardverblist":true,
"climb": function() { if (e_player.class=="thief") {
if (e_tied_brigand.tied) {
OutputText ("You skillfully climb the tree, and cut the rope that ties the man.");
freeTiedMan();
}
else {
OutputText ("You skillfully climb the tree. Then you climbed down. You just lost time.");
}
}
else {
OutputText ("You are too clumsy and the tree is too fragile to climb.");
} },
"_js_name": "e_tree_forest",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["tree_forest"] = e_tree_forest;
allObjects.push(e_tree_forest);
objectsNameMap["tree_forest"] = e_tree_forest;
e_tied_brigand = {
"elementtype": "object",
"name": "tied_brigand",
"parent": e_forest2,
"type": "object",
"alias": "tied man",
"tied": true,
"sleep": false,
"usedefaultprefix": true,
"look": function() { if (this.tied) {
OutputText ("He is tied upside down, a few meters from the ground.");
}
else if (this.sleep) {
OutputText ("He is unconscious due to the fall, but you can't see any blood or severe injure.");
}
else {
OutputText ("He is a brigand that refused to follow Vourtram.");
} },
"speak": function() { if (this.tied) {
OutputText ("<i>The brigands tied me up here... please help me!</i>");
}
else if (this.sleep) {
OutputText ("He can't talk!");
}
else {
psay ("We {command:ask elias about brigand:brigands} were loyal to the king, you know. <br/>But something changed a few weeks ago. Our {command:ask elias about leader:leader} started acting strangely, supporting Vourtram's evil cause. I was already wary, but one day I saw him talking to one of those masked minions of Vourtram, and then I was sure that he is an impostor. Vourtram must have replaced our leader with a double. Unfortunately they caught me, and tied me to this tree to die as a traitor.<br/>If you want to get hid of the brigands, I suggest you find the phoney leader in the brigand's {command:ask elias about hideout:hideout}.");
} },
"ask": {"hideout hide": function() { psay ("The hideout is in the opposite margin of the river. Can't find it? Of course, they camouflaged the path with trees. Just go south and you will discover the path by the trees.");
if (e_sec_path.visible==false) {
MakeExitVisible (e_forest_current2_to_hide_entrance);
if (e_player.class=="warrior" && e_brigand1.parent == e_forest_current2) {
set(e_forest_current2_to_hide_entrance, "locked", true);
}
MakeObjectVisible (e_sec_path);
} }, "leader": function() { psay ("I don't know what happened with the true leader. But the current leader is a double for sure."); }, "brigand brigands": function() { psay ("We are loyal to the king... well, not all of us. But none of us fancy the evil wizard."); } },
"_js_name": "e_tied_brigand",
"_types": ["male", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["tied_brigand"] = e_tied_brigand;
allObjects.push(e_tied_brigand);
objectsNameMap["tied_brigand"] = e_tied_brigand;
e_rope_tie = {
"elementtype": "object",
"name": "rope_tie",
"parent": e_forest2,
"type": "object",
"alias": "rope tying a man",
"cut": "You can't reach it",
"displayverbs": ["Look at"],
"_js_name": "e_rope_tie",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["rope_tie"] = e_rope_tie;
allObjects.push(e_rope_tie);
objectsNameMap["rope_tie"] = e_rope_tie;
e_rope = {
"elementtype": "object",
"name": "rope",
"parent": e_forest2,
"type": "object",
"alias": "long rope",
"take": true,
"visible": false,
"look": "A ten yard long naval rope.",
"feature_usegive": true,
"use": true,
"givesingle": true,
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"useCmds": ["tie"],
"selfuseon": {"tree_river": function() { tie_rope (e_tree_river); } },
"_js_name": "e_rope",
"_types": ["UseAltType", "defaultobject"],
"displayverbs": ["Look at", "Take"],
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["rope"] = e_rope;
allObjects.push(e_rope);
objectsNameMap["rope"] = e_rope;
e_k49 = {
"elementtype": "object",
"name": "k49",
"parent": e_forest2,
"type": "exit",
"alias": "east",
"_js_name": "e_k49",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k49"] = e_k49;
objectReferences.push(["e_k49", "to", "e_forest_current"]);
allExits.push(e_k49);
objectsNameMap["k49"] = e_k49;
e_forest_house = {
"elementtype": "object",
"name": "forest_house",
"parent": e_dark_forest,
"type": "object",
"alias": "front of an old tower",
"description": "The tower has {if in_forest_tower.locked:no doors nor windows, and you can't figure out how to get in.}{if not in_forest_tower.locked:an open magic door.}",
"usedefaultprefix": false,
"_js_name": "e_forest_house",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["forest_house"] = e_forest_house;
allObjects.push(e_forest_house);
objectsNameMap["forest_house"] = e_forest_house;
e_sc_tower = {
"elementtype": "object",
"name": "sc_tower",
"parent": e_forest_house,
"type": "object",
"scenery": true,
"alias": "tower",
"look": "The tower looks old and impregnable.",
"displayverbs": ["Look at"],
"_js_name": "e_sc_tower",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["sc_tower"] = e_sc_tower;
allObjects.push(e_sc_tower);
objectsNameMap["sc_tower"] = e_sc_tower;
e_k50 = {
"elementtype": "object",
"name": "k50",
"parent": e_forest_house,
"type": "exit",
"alias": "west",
"to": e_forest1,
"_js_name": "e_k50",
"_types": ["westdirection", "defaultexit"],
"alt": ["w"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k50"] = e_k50;
allExits.push(e_k50);
objectsNameMap["k50"] = e_k50;
e_lever1 = {
"elementtype": "object",
"name": "lever1",
"parent": e_forest_house,
"type": "object",
"visible": false,
"alias": "lever in the wall",
"look": "A magically concealed lever, but too high to reach.",
"displayverbs": ["Look at", "Push"],
"push": "It is too high to reach.",
"_js_name": "e_lever1",
"_types": ["defaultobject"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["lever1"] = e_lever1;
allObjects.push(e_lever1);
objectsNameMap["lever1"] = e_lever1;
e_in_forest_tower = {
"elementtype": "object",
"name": "in_forest_tower",
"parent": e_forest_house,
"type": "exit",
"alias": "in",
"locked": true,
"lockmessage": "You can't find a way in!",
"_js_name": "e_in_forest_tower",
"_types": ["indirection", "defaultexit"],
"alt": [""],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["in_forest_tower"] = e_in_forest_tower;
objectReferences.push(["e_in_forest_tower", "to", "e_forest_tower"]);
allExits.push(e_in_forest_tower);
objectsNameMap["in_forest_tower"] = e_in_forest_tower;
e_forest_tower = {
"elementtype": "object",
"name": "forest_tower",
"parent": e_dark_forest,
"type": "object",
"alias": "inside the tower",
"description": "The room is full of alchemical tools and ingredients. It has no windows, and all light comes from magical sources in the roof.",
"usedefaultprefix": false,
"descprefix": "You are",
"_js_name": "e_forest_tower",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["forest_tower"] = e_forest_tower;
allObjects.push(e_forest_tower);
objectsNameMap["forest_tower"] = e_forest_tower;
e_alchemist = {
"elementtype": "object",
"name": "alchemist",
"parent": e_forest_tower,
"type": "object",
"alias": "Pierre Flamel",
"usedefaultprefix": false,
"suffix": ", the alchemist",
"look": "Flamel is an old man wearing a pair of huge spectacles and a white smock.",
"speak": function() { psay ("{once:I'm Pierre Flamel, the alchemist.}{notfirst:Hello again {player.playername}.} I can help you with magical {command:ask Flamel about potions:potions}, {command:ask Flamel about monsters:monsters}, and {command:ask Flamel about music:music}.");
if (e_leader.parent==e_forest_tower) {
psay ("I've found a  {command:ask Flamel about man:man} in the forest, with no memory.");
} },
"ask": {"man": function() { psay ("I've found him in the forest, and brought him to my house. He has {ask:flamel:amnesia}."); }, "amnesia": function() { psay ("Amnesia may take weeks to be cured. Familiar people and personal objects may help the patient to recover his memory, but he was naked when I found him. With all those brigands, I could not search around for his friends or belongings."); }, "potions": function() { psay ("I make and sell potions, and I buy ingredients and magical items."); }, "monsters": function() { psay ("I study several monsters of this kingdom, such as {ask:flamel:orcs}, {ask:flamel:trolls}, {ask:flamel:trows}, {ask:flamel:dragons}, and the fearsome {ask:flamel:Medusa}."); }, "trows trow": function() { psay ("A trow is a powerful and mischievous troll like creature that inhabits dark caves and pits. There are accounts about an old and powerful trow in this region. Trows love {ask:flamel:music}, and apart from that their only interest is killing and eating anything they can lay hands on."); }, "trolls troll": function() { psay ("They are dumb but super strong creatures that can only be defeated by fire or the sun light. They eat anything, including stones."); }, "orcs orc": function() { psay ("They are a pest, evil and with a strong desire of harming anyone. They are not inteligent alone, but can be a real threat when organized by an evil power."); }, "dragon dragons": function() { psay ("Dragons are the most powerful creatures of nature. Even a baby dragon can kill a warrior, and they born as wise as the average man. The most powerful dragons don't mess with us, but some went crazy for gold and power... a crazy dragon can only be stoped by an army or a great hero."); }, "music": function() { psay ("I teach music, but that takes months to learn. If you don't have time to learn, I have a magical {ask:flamel:flute} for sale. "); }, "flute": function() { psay ("You only need to blow the magical flute and it will play a song for you. I will trade the flute for some {ask:flamel:dust:fairy dust}."); }, "fairy dust": function() { psay ("The fairies inhabit the dark corners of the forest. If you bring me some fairy dust I will give a magical {ask:flamel:flute} to you."); }, "medusa": function() { psay ("The Medusa was an ancient monster that could turn into stone anything with a stare. She was killed by Perseus, who chopped her head off. He placed the head inside a {ask:flamel:kibisis}, because even after dead, she could still turn anything alive into stone. There is a legend that her head is somewhere near here."); }, "kibisis": function() { psay ("It is a silvery knapsack, the only thing that can block the stare of Medusa."); } },
"give": {"fairy_dust": function() { psay ("Thank you. Here, take my flute as a reward.");
AddToInventory (e_flute);
RemoveObject (e_fairy_dust); }, "book_plants": function() { psay ("Great Stuff... Thank you! Let me see if I can find the spell on this book... yes, it is here.");
OutputText ("After a couple hours, Flamel writes down the spell at you spell book.");
psay ("This is the shape plant spell, that allows you to shape plants and trees to your will.");
RemoveObject (e_book_plants);
set(e_shape_spell, "parent", e_spell_book); } },
"_js_name": "e_alchemist",
"_types": ["male", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["alchemist"] = e_alchemist;
allObjects.push(e_alchemist);
objectsNameMap["alchemist"] = e_alchemist;
e_flute = {
"elementtype": "object",
"name": "flute",
"parent": e_alchemist,
"type": "object",
"alias": "magical flute",
"look": "It plays a tune called \"Winyadepla\".",
"feature_usegive": true,
"use": true,
"givesingle": true,
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"play": function() { play_flute(); },
"_js_name": "e_flute",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"take": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["flute"] = e_flute;
allObjects.push(e_flute);
objectsNameMap["flute"] = e_flute;
e_shape_spell = {
"elementtype": "object",
"name": "shape_spell",
"parent": e_alchemist,
"type": "object",
"alias": "shape plant spell",
"look": "This spell allows the caster to shape plants and bend trees to his will.",
"listalias": "-- shape plant spell",
"inventoryverbs": ["Look at", "Cast"],
"_js_name": "e_shape_spell",
"_types": ["Spell", "defaultobject"],
"castspell": true,
"castonobject": true,
"drop": function() { OutputText ("You don't want to rip your book apart."); },
"use": function() { OutputText ("You don't use a spell, you 'cast' it."); },
"read_away": false,
"read": function() { doRead (this); },
"visible": true,
"displayverbs": ["Look at", "Take"],
"take": false,
"givesingle": false,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["shape_spell"] = e_shape_spell;
allObjects.push(e_shape_spell);
objectsNameMap["shape_spell"] = e_shape_spell;
e_k51 = {
"elementtype": "object",
"name": "k51",
"parent": e_forest_tower,
"type": "exit",
"alias": "out",
"to": e_forest_house,
"_js_name": "e_k51",
"_types": ["outdirection", "defaultexit"],
"alt": ["o"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k51"] = e_k51;
allExits.push(e_k51);
objectsNameMap["k51"] = e_k51;
e_leader = {
"elementtype": "object",
"name": "leader",
"parent": e_forest_tower,
"type": "object",
"alias": "man",
"memory": false,
"feature_usegive": true,
"speak": function() { if (e_leader.memory==false) {
psay ("I'm sorry sir, but I can't remember nothing from my past. Mr. Flamel found me in the forest a few weeks ago, naked and unconscious.");
} },
"askdefault": function() { psay ("I can't remember anything..."); },
"give": {"leader_sword": function() { OutputText ("The man grabs the sword and starts to shake it and cry as he remembers everything: ");
psay ("I remember now. I am Leonard, the true brigand leader. Vourtram sent an impostor to replace me and control our army. Thank you "+e_player.playername+", by helping me regain my memory. Now I should return to our hiding place and unmask the impostor");
OutputText ("You tell Leonard about Elias, and you three head to the hideout.<br/>Leonard kills the impostor, and promises to help you against Vourtram.");
finishBrigands();
RemoveObject (e_leader);
RemoveObject (e_leader_sword);
MoveObject (e_player, e_hide_entrance); } },
"_js_name": "e_leader",
"_types": ["male", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["leader"] = e_leader;
allObjects.push(e_leader);
objectsNameMap["leader"] = e_leader;
e_ingredients1 = {
"elementtype": "object",
"name": "ingredients1",
"parent": e_forest_tower,
"type": "object",
"alias": "ingredients",
"alt": ["tools", "sources", "alchemical ingredients"],
"look": "They are magical items.",
"displayverbs": ["Look at"],
"usedefaultprefix": false,
"_js_name": "e_ingredients1",
"_types": ["plural", "defaultobject"],
"gender": "they",
"article": "them",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["ingredients1"] = e_ingredients1;
allObjects.push(e_ingredients1);
objectsNameMap["ingredients1"] = e_ingredients1;
e_forest3 = {
"elementtype": "object",
"name": "forest3",
"parent": e_dark_forest,
"type": "object",
"alias": "dark forest",
"description": "This maybe the darkest corner of this forest.",
"firstenter": function() { if (e_player.class=="mage") {
OutputText ("You feel a chill in the neck when entering this corner of the forest.");
} },
"_js_name": "e_forest3",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["forest3"] = e_forest3;
allObjects.push(e_forest3);
objectsNameMap["forest3"] = e_forest3;
e_k52 = {
"elementtype": "object",
"name": "k52",
"parent": e_forest3,
"type": "exit",
"alias": "west",
"_js_name": "e_k52",
"_types": ["westdirection", "defaultexit"],
"alt": ["w"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k52"] = e_k52;
objectReferences.push(["e_k52", "to", "e_forest_current"]);
allExits.push(e_k52);
objectsNameMap["k52"] = e_k52;
e_green_fairy = {
"elementtype": "object",
"name": "green_fairy",
"parent": e_forest3,
"type": "object",
"alias": "green fairy",
"look": "A thumb sized fairy lying on a large leaf. She is glowing green.",
"visible": false,
"alt": ["voice"],
"riddle": 0,
"speak": function() { if (e_fairy_dust.parent==e_green_fairy) {
set(e_green_fairy, "riddle", 1);
psay ("Hi nosy noisy giant! Do you want some dust of mine? Only if you can answer ma riddle... <b>I fly, yet I have no wings. I cry, yet I have no eyes. Darkness follows me; lower light I never see.</b>");
getinput_async (function(result) { fairy_response (result); });
}
else {
set(e_green_fairy, "riddle", 2);
psay ("Here is the riddle: <b>What is a throw that catches you, but you can only catch it with a song?</b>");
getinput_async (function(result) { fairy_response (result); });
} },
"askdefault": function() { OutputText ("The fairy flies around you, laughing a lot..."); },
"_js_name": "e_green_fairy",
"_types": ["female", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "she",
"article": "her",
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["green_fairy"] = e_green_fairy;
allObjects.push(e_green_fairy);
objectsNameMap["green_fairy"] = e_green_fairy;
e_fairy_dust = {
"elementtype": "object",
"name": "fairy_dust",
"parent": e_green_fairy,
"type": "object",
"take": true,
"alias": "a bag of fairy dust",
"look": "It contains a handfull of green dust.",
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"feature_usegive": true,
"use": true,
"givesingle": true,
"_js_name": "e_fairy_dust",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["fairy_dust"] = e_fairy_dust;
allObjects.push(e_fairy_dust);
objectsNameMap["fairy_dust"] = e_fairy_dust;
e_blind_spell = {
"elementtype": "object",
"name": "blind_spell",
"parent": e_green_fairy,
"type": "object",
"alias": "blind spell",
"take": true,
"drop": false,
"look": "The blind spell casts a strong light that will blind every creature with eyes for a few seconds.",
"listalias": "-- blind spell",
"inventoryverbs": ["Look at", "Cast"],
"_js_name": "e_blind_spell",
"_types": ["Spell", "defaultobject"],
"castspell": true,
"castonobject": true,
"use": function() { OutputText ("You don't use a spell, you 'cast' it."); },
"read_away": false,
"read": function() { doRead (this); },
"visible": true,
"displayverbs": ["Look at", "Take"],
"givesingle": false,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["blind_spell"] = e_blind_spell;
allObjects.push(e_blind_spell);
objectsNameMap["blind_spell"] = e_blind_spell;
e_forest_current = {
"elementtype": "object",
"name": "forest_current",
"parent": e_dark_forest,
"type": "object",
"alias": "dense forest that stops at some violent rapids on a wide river",
"turns": 0,
"_js_name": "e_forest_current",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["forest_current"] = e_forest_current;
allObjects.push(e_forest_current);
objectsNameMap["forest_current"] = e_forest_current;
e_rapids = {
"elementtype": "object",
"name": "rapids",
"parent": e_forest_current,
"type": "object",
"alias": "violent rapids",
"usedefaultprefix": false,
"displayverbs": ["Look at"],
"look": "It is impossible to cross this river by swimming.",
"useon": {"pot_helmet": function() { OutputText ("It won't work. The pot has a hole in the bottom."); }, "pot": function() { OutputText ("It is full. And I would not waste food."); } },
"_js_name": "e_rapids",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["rapids"] = e_rapids;
allObjects.push(e_rapids);
objectsNameMap["rapids"] = e_rapids;
e_tree_river = {
"elementtype": "object",
"name": "tree_river",
"parent": e_forest_current,
"type": "object",
"alias": "strong trees",
"look": "They are old and strongly rooted to the riverside.",
"usedefaultprefix": false,
"prefix": "some",
"suffix": "",
"displayverbs": ["Look at"],
"useCmds": ["tie"],
"selfuseon": {"rope": function() { tie_rope (e_tree_river); } },
"_js_name": "e_tree_river",
"_types": ["UseAltType", "plural", "defaultobject"],
"gender": "they",
"article": "them",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["tree_river"] = e_tree_river;
allObjects.push(e_tree_river);
objectsNameMap["tree_river"] = e_tree_river;
e_forest_current_to_forest1 = {
"elementtype": "object",
"name": "forest_current_to_forest1",
"parent": e_forest_current,
"type": "exit",
"alias": "north",
"lockmessage": "The Orc blocks your way.",
"to": e_forest1,
"_js_name": "e_forest_current_to_forest1",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["forest_current_to_forest1"] = e_forest_current_to_forest1;
allExits.push(e_forest_current_to_forest1);
objectsNameMap["forest_current_to_forest1"] = e_forest_current_to_forest1;
e_k53 = {
"elementtype": "object",
"name": "k53",
"parent": e_forest_current,
"type": "exit",
"alias": "west",
"to": e_forest2,
"_js_name": "e_k53",
"_types": ["westdirection", "defaultexit"],
"alt": ["w"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k53"] = e_k53;
allExits.push(e_k53);
objectsNameMap["k53"] = e_k53;
e_k54 = {
"elementtype": "object",
"name": "k54",
"parent": e_forest_current,
"type": "exit",
"alias": "east",
"to": e_forest3,
"_js_name": "e_k54",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k54"] = e_k54;
allExits.push(e_k54);
objectsNameMap["k54"] = e_k54;
e_rapids_exit = {
"elementtype": "object",
"name": "rapids_exit",
"parent": e_forest_current,
"type": "exit",
"alias": "south",
"locked": true,
"lockmessage": "You can't cross the violent rapids.",
"_js_name": "e_rapids_exit",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["rapids_exit"] = e_rapids_exit;
objectReferences.push(["e_rapids_exit", "to", "e_forest_current2"]);
allExits.push(e_rapids_exit);
objectsNameMap["rapids_exit"] = e_rapids_exit;
e_swim = {
"elementtype": "object",
"name": "swim",
"parent": e_forest_current,
"type": "command",
"pattern": "^swim$",
"script": function(parameters) { OutputText ("Are you kidding?"); },
"_js_name": "e_swim",
"_types": ["defaultcommand"]
};
elementsNameMap["swim"] = e_swim;
allCommands.push(e_swim);
objectsNameMap["swim"] = e_swim;
e_forest_current2 = {
"elementtype": "object",
"name": "forest_current2",
"parent": e_dark_forest,
"type": "object",
"alias": "opposite riverside",
"description": "The forest seems to block your way to any other direction but the river. To the north you can cross the river back to the northern forest.",
"usedefaultprefix": false,
"prefix": "the",
"beforeenter": function() { set(this, "turns", 0); },
"_js_name": "e_forest_current2",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["forest_current2"] = e_forest_current2;
allObjects.push(e_forest_current2);
objectsNameMap["forest_current2"] = e_forest_current2;
e_k55 = {
"elementtype": "object",
"name": "k55",
"parent": e_forest_current2,
"type": "exit",
"alias": "north",
"to": e_forest_current,
"_js_name": "e_k55",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k55"] = e_k55;
allExits.push(e_k55);
objectsNameMap["k55"] = e_k55;
e_carrots = {
"elementtype": "object",
"name": "carrots",
"parent": e_forest_current2,
"type": "object",
"alias": "wild carrots",
"look": "These are delicious.",
"take": true,
"usedefaultprefix": false,
"prefix": "some",
"eat": "You are not hungry.",
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"feature_usegive": true,
"use": true,
"givesingle": true,
"useCmds": ["put"],
"selfuseon": {"bucket1": function() { 
RemoveObject (e_bucket1);
SetObjectFlagOn (e_bucket2, "visible");
OutputText ("The horse is crazy about these carrots! It eats all the hay. Sheila says <i>Thank you! You can now have the {object:bucket2} if you want.</i>");
RemoveObject (e_carrots); }, "horse": function() { OutputText ("The horse loves carrots, but I would not have nothing to gain..."); } },
"giveto": {"stablemiss": function() { OutputText ("That would not make the horse eat the hay in the bucket ..."); } },
"_js_name": "e_carrots",
"_types": ["UseAltType", "plural", "defaultobject"],
"gender": "they",
"article": "them",
"visible": true,
"displayverbs": ["Look at", "Take"],
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["carrots"] = e_carrots;
allObjects.push(e_carrots);
objectsNameMap["carrots"] = e_carrots;
e_sec_path = {
"elementtype": "object",
"name": "sec_path",
"parent": e_forest_current2,
"type": "object",
"visible": false,
"alias": "secret path leading south",
"look": "This path was concealed, but Elias told you the way.",
"_js_name": "e_sec_path",
"_types": ["defaultobject"],
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["sec_path"] = e_sec_path;
allObjects.push(e_sec_path);
objectsNameMap["sec_path"] = e_sec_path;
e_forest_current2_to_hide_entrance = {
"elementtype": "object",
"name": "forest_current2_to_hide_entrance",
"parent": e_forest_current2,
"type": "exit",
"alias": "south",
"visible": false,
"locked": false,
"lockmessage": "the brigand blocks your way.",
"_js_name": "e_forest_current2_to_hide_entrance",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"scenery": false,
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["forest_current2_to_hide_entrance"] = e_forest_current2_to_hide_entrance;
objectReferences.push(["e_forest_current2_to_hide_entrance", "to", "e_hide_entrance"]);
allExits.push(e_forest_current2_to_hide_entrance);
objectsNameMap["forest_current2_to_hide_entrance"] = e_forest_current2_to_hide_entrance;
e_trees = {
"elementtype": "object",
"name": "trees",
"parent": e_forest_current2,
"type": "object",
"scenery": true,
"look": "You see nothing special.",
"alt": ["forest", "river"],
"displayverbs": ["Look at"],
"_js_name": "e_trees",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["trees"] = e_trees;
allObjects.push(e_trees);
objectsNameMap["trees"] = e_trees;
e_hide_entrance = {
"elementtype": "object",
"name": "hide_entrance",
"parent": e_dark_forest,
"type": "object",
"alias": "hillside",
"description": "You are at the western side of a rocky hill. There is a cave in the hill and a path leading to the west.  There is also a narrow path leading back to the river in the north. A dense forest blocks the way to the south. ",
"_js_name": "e_hide_entrance",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["hide_entrance"] = e_hide_entrance;
allObjects.push(e_hide_entrance);
objectsNameMap["hide_entrance"] = e_hide_entrance;
e_k56 = {
"elementtype": "object",
"name": "k56",
"parent": e_hide_entrance,
"type": "exit",
"alias": "north",
"to": e_forest_current2,
"_js_name": "e_k56",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k56"] = e_k56;
allExits.push(e_k56);
objectsNameMap["k56"] = e_k56;
e_boulder = {
"elementtype": "object",
"name": "boulder",
"parent": e_hide_entrance,
"type": "object",
"alias": "large boulder",
"heard": false,
"displayverbs": ["Look at"],
"push": function() { if (e_player.class=="warrior") {
OutputText ("You push the boulder just enough to enter the cave.");
UnlockExit (e_hide_boulder);
}
else {
OutputText ("It is too heavy for you.");
} },
"_js_name": "e_boulder",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["boulder"] = e_boulder;
allObjects.push(e_boulder);
objectsNameMap["boulder"] = e_boulder;
e_hide_boulder = {
"elementtype": "object",
"name": "hide_boulder",
"parent": e_hide_entrance,
"type": "exit",
"alias": "in",
"locked": true,
"lockmessage": "The boulder blocks your way.",
"_js_name": "e_hide_boulder",
"_types": ["indirection", "defaultexit"],
"alt": [""],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["hide_boulder"] = e_hide_boulder;
objectReferences.push(["e_hide_boulder", "to", "e_hide1"]);
allExits.push(e_hide_boulder);
objectsNameMap["hide_boulder"] = e_hide_boulder;
e_say = {
"elementtype": "object",
"name": "say",
"parent": e_hide_entrance,
"type": "command",
"pattern": "^say (?<text>.*)$",
"script": function(parameters) { var text = parameters['text'];
if (e_player.class=="thief") {
if (text=="iftah ya simsim") {
UnlockExit (e_hide_boulder);
OutputText ("The boulder moves revealing the entrance to the cave.");
}
else if (e_boulder.heard) {
OutputText ("Nothing happens. Perhaps you should try \"say iftah ya simsim\".");
}
else {
OutputText ("Nothing happens.");
}
}
else {
if (text=="iftah ya simsim") {
OutputText ("You tries to say "+text+", but you just can't get the right pronunciation.");
}
else {
OutputText ("You say <i>"+text+"</i>. Nothing happens.");
}
} },
"_js_name": "e_say",
"_types": ["defaultcommand"]
};
elementsNameMap["say"] = e_say;
allCommands.push(e_say);
objectsNameMap["say"] = e_say;
e_bushes = {
"elementtype": "object",
"name": "bushes",
"parent": e_hide_entrance,
"type": "object",
"alias": "bushes",
"look": "The bushes are large and thick, you examine with caution hoping to not find a snake or a bear hiding behind the foliage.",
"usestandardverblist": true,
"displayverbs": ["Look at"],
"hide": function() { if (e_player.class=="thief") {
if (e_boulder.heard) {
OutputText ("You hide but nothing happens.");
}
else {
OutputText ("You hide behind the bushes for a while. Suddenly, a masked man approaches the boulder and says <i>iftah ya simsim</i>. The boulder magically opens and he enters the cave. After a while, the boulder moves and closes the entrance again.");
set(e_boulder, "heard", true);
}
}
else {
OutputText ("what?");
} },
"_js_name": "e_bushes",
"_types": ["plural", "defaultobject"],
"gender": "they",
"article": "them",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["bushes"] = e_bushes;
allObjects.push(e_bushes);
objectsNameMap["bushes"] = e_bushes;
e_k57 = {
"elementtype": "object",
"name": "k57",
"parent": e_hide_entrance,
"type": "exit",
"alias": "west",
"_js_name": "e_k57",
"_types": ["westdirection", "defaultexit"],
"alt": ["w"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k57"] = e_k57;
objectReferences.push(["e_k57", "to", "e_midgard"]);
allExits.push(e_k57);
objectsNameMap["k57"] = e_k57;
e_iftah = {
"elementtype": "object",
"name": "iftah",
"parent": e_hide_entrance,
"type": "command",
"pattern": "^iftah ya simsim$",
"script": function(parameters) { OutputText ("I can't recognize this command. Try to <b>say iftah ya simsim</b>"); },
"_js_name": "e_iftah",
"_types": ["defaultcommand"]
};
elementsNameMap["iftah"] = e_iftah;
allCommands.push(e_iftah);
objectsNameMap["iftah"] = e_iftah;
e_hide1 = {
"elementtype": "object",
"name": "hide1",
"parent": e_dark_forest,
"type": "object",
"alias": "brigand's hideout entrance",
"description": "The cave entrance has a high ceiling, and turns to the right{if impostor.parent=hide_hall:, from where you hear voices}. The cave has only the dim light from oil lamps.{if hide1.climbed: You are balancing on a pallet near the ceiling.}",
"climbed": false,
"usedefaultprefix": false,
"prefix": "the",
"onexit": function() { set(e_hide1, "climbed", false); },
"_js_name": "e_hide1",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["hide1"] = e_hide1;
allObjects.push(e_hide1);
objectsNameMap["hide1"] = e_hide1;
e_k58 = {
"elementtype": "object",
"name": "k58",
"parent": e_hide1,
"type": "exit",
"alias": "out",
"to": e_hide_entrance,
"_js_name": "e_k58",
"_types": ["outdirection", "defaultexit"],
"alt": ["o"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k58"] = e_k58;
allExits.push(e_k58);
objectsNameMap["k58"] = e_k58;
e_ceiling = {
"elementtype": "object",
"name": "ceiling",
"parent": e_hide1,
"type": "object",
"visible": true,
"scenery": true,
"alt": ["roof", "pallet", "pole","poles"],
"look": "In the ceiling you see a pallet supported by poles shored at the walls. Connected to the pallet there are oil lamps that provide a dim light to the room.",
"hidechildren": true,
"displayverbs": ["Look at"],
"_js_name": "e_ceiling",
"_types": ["surface", "defaultobject"],
"isopen": true,
"transparent": true,
"contentsprefix": "on which there is",
"container": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"open": false,
"close": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"description": "",
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["ceiling"] = e_ceiling;
allObjects.push(e_ceiling);
objectsNameMap["ceiling"] = e_ceiling;
e_lamps = {
"elementtype": "object",
"name": "lamps",
"parent": e_ceiling,
"type": "object",
"displayverbs": ["Look at"],
"alt": ["lamp"],
"turnoff": function() { if (e_hide1.climbed==true) {
OutputText ("You silently put down some lamps.");
UnlockExit (e_hide_hall_exit);
}
else {
OutputText ("The lamps are too high.");
} },
"_js_name": "e_lamps",
"_types": ["plural", "defaultobject"],
"gender": "they",
"article": "them",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["lamps"] = e_lamps;
allObjects.push(e_lamps);
objectsNameMap["lamps"] = e_lamps;
e_k59 = {
"elementtype": "object",
"name": "k59",
"parent": e_hide1,
"type": "command",
"anonymous": true,
"pattern": "^climb (?<text>.*)$",
"unresolved": "climb where?",
"script": function(parameters) { var text = parameters['text'];
if (text=="pole" || text=="pallet") {
if (e_player.class=="thief") {
OutputText ("You climb by the pole to the pallet.");
set(e_hide_hall_exit, "lockmessage", "You can walk by the pallet, but there is too much light, they would notice you.");
set(e_hide1, "climbed", true);
}
else {
OutputText ("I'm not very good in climbing, I risk breaking my neck.");
}
}
else {
OutputText ("How can I climb this?");
} },
"_js_name": "e_k59",
"_types": ["defaultcommand"]
};
elementsNameMap["k59"] = e_k59;
allCommands.push(e_k59);
objectsNameMap["k59"] = e_k59;
e_hide_hall_exit = {
"elementtype": "object",
"name": "hide_hall_exit",
"parent": e_hide1,
"type": "exit",
"alias": "north",
"locked": true,
"lockmessage": "You don't think it is a good idea to face those brigands directly.",
"_js_name": "e_hide_hall_exit",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["hide_hall_exit"] = e_hide_hall_exit;
objectReferences.push(["e_hide_hall_exit", "to", "e_hide_hall"]);
allExits.push(e_hide_hall_exit);
objectsNameMap["hide_hall_exit"] = e_hide_hall_exit;
e_k60 = {
"elementtype": "object",
"name": "k60",
"parent": e_hide1,
"type": "command",
"anonymous": true,
"pattern": "^hear$",
"script": function(parameters) { OutputText ("They talk too low."); },
"_js_name": "e_k60",
"_types": ["defaultcommand"]
};
elementsNameMap["k60"] = e_k60;
allCommands.push(e_k60);
objectsNameMap["k60"] = e_k60;
e_midgard = {
"elementtype": "object",
"name": "midgard",
"parent": e_dark_forest,
"type": "object",
"alias": "ruins of an old city",
"description": "This must be ruins of the old city of Midgard. You think you are standing in a kind of temple. The only way out is east. You can also go down, entering the pit.",
"usedefaultprefix": false,
"prefix": "the",
"_js_name": "e_midgard",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["midgard"] = e_midgard;
allObjects.push(e_midgard);
objectsNameMap["midgard"] = e_midgard;
e_bones = {
"elementtype": "object",
"name": "bones",
"parent": e_midgard,
"type": "object",
"alias": "bones",
"look": "You see several bones from animals... and men.",
"usedefaultprefix": false,
"takemsg": "No thanks!",
"displayverbs": ["Look at"],
"_js_name": "e_bones",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["bones"] = e_bones;
allObjects.push(e_bones);
objectsNameMap["bones"] = e_bones;
e_pit = {
"elementtype": "object",
"name": "pit",
"parent": e_midgard,
"type": "object",
"alias": "dark pit",
"look": "It is dark and has a foul smell.",
"displayverbs": ["Look at"],
"beforeenter": function() { set(this, "turns", 0); },
"_js_name": "e_pit",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["pit"] = e_pit;
allObjects.push(e_pit);
objectsNameMap["pit"] = e_pit;
e_Trow = {
"elementtype": "object",
"name": "Trow",
"parent": e_pit,
"type": "object",
"look": "A small but monstrously strong spirit that inhabits dark places.",
"ht": 50,
"exp": 20,
"armour": 20,
"aggressive": true,
"alias": "Trow",
"usedefaultprefix": false,
"prefix": "a monstrously strong",
"speak": "He doesn't understand you.",
"give": {"flute": function() { if (e_Trow.aggressive) {
OutputText ("He doesn't seem interested on the flute ... yet");
}
else {
OutputText ("He takes the flute with a big smile. Then, he searches a bag and takes a fine sword. He gives the sword to you in pay to the flute.");
AddToInventory (e_leader_sword);
RemoveObject (e_flute);
} } },
"_js_name": "e_Trow",
"_types": ["Enemy", "male", "defaultobject"],
"enemy": "yes",
"danger": "death",
"stab_level": 0,
"affect_calm": false,
"block_flee": false,
"damage": 2,
"push": function() { if (e_player.parent==e_combat_room) {
if (e_combat.pushed) {
OutputText ("You can only push one time before you combat movement.");
}
else if (savedRandomInt(0,1)==0) {
OutputText ("You successfully push "+this.alias+".");
set(e_combat, "en_red", e_combat.en_red+1);
}
else {
OutputText ("You tried to push "+this.alias+", but ended up losing your balance.");
set(e_combat, "pl_red", e_combat.pl_red+1);
}
set(e_combat, "pushed", true);
}
else {
OutputText ("It doesn't work.");
} },
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["Trow"] = e_Trow;
allObjects.push(e_Trow);
objectsNameMap["Trow"] = e_Trow;
e_leader_sword = {
"elementtype": "object",
"name": "leader_sword",
"parent": e_Trow,
"type": "object",
"alias": "fine sword",
"look": "It has an unknown emblem with a big L.",
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"feature_usegive": true,
"use": true,
"givesingle": true,
"_js_name": "e_leader_sword",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"take": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["leader_sword"] = e_leader_sword;
allObjects.push(e_leader_sword);
objectsNameMap["leader_sword"] = e_leader_sword;
e_k61 = {
"elementtype": "object",
"name": "k61",
"parent": e_pit,
"type": "exit",
"alias": "up",
"to": e_midgard,
"_js_name": "e_k61",
"_types": ["updirection", "defaultexit"],
"alt": ["u"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k61"] = e_k61;
allExits.push(e_k61);
objectsNameMap["k61"] = e_k61;
e_k62 = {
"elementtype": "object",
"name": "k62",
"parent": e_midgard,
"type": "exit",
"alias": "east",
"to": e_hide_entrance,
"_js_name": "e_k62",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k62"] = e_k62;
allExits.push(e_k62);
objectsNameMap["k62"] = e_k62;
e_k63 = {
"elementtype": "object",
"name": "k63",
"parent": e_midgard,
"type": "exit",
"alias": "down",
"to": e_pit,
"_js_name": "e_k63",
"_types": ["downdirection", "defaultexit"],
"alt": ["d"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k63"] = e_k63;
allExits.push(e_k63);
objectsNameMap["k63"] = e_k63;
e_hide_hall = {
"elementtype": "object",
"name": "hide_hall",
"parent": e_dark_forest,
"type": "object",
"alias": "wide chamber inside the brigand's cave",
"description": "The cave ends in a large hall where the brigands live. Among the stalagmites, you see several crates with the result of their thefts.",
"firstenter": function() { if (e_player.class=="thief") {
OutputText ("You silently enter the room walking by the pallet. You see the impostor leader speaking with a masked figure in a dark robe:<br/><i>You are doing an excellent job Ahriman! Master Vourtram prepared more of the disguise potion, you should drink it as soon as the spell begins to diminish. This should happen this afternoon.</i><br/>The impostor puts the potion in a chest, and leaves the hideout with the other man. The room is empty, and you climb down.<br/>");
MoveObject (e_impostor, e_void);
}
else if (e_impostor.parent == e_hide_hall) {
psay ("Hey, you should not be here!");
set(e_hide_hall, "visited", true);
attack (e_hide_hall, e_impostor);
} },
"beforeenter": function() { set(this, "turns", 0); },
"_js_name": "e_hide_hall",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["hide_hall"] = e_hide_hall;
allObjects.push(e_hide_hall);
objectsNameMap["hide_hall"] = e_hide_hall;
e_k64 = {
"elementtype": "object",
"name": "k64",
"parent": e_hide_hall,
"type": "exit",
"alias": "south",
"to": e_hide1,
"_js_name": "e_k64",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k64"] = e_k64;
allExits.push(e_k64);
objectsNameMap["k64"] = e_k64;
e_chest1 = {
"elementtype": "object",
"name": "chest1",
"parent": e_hide_hall,
"type": "object",
"alias": "chest",
"feature_container": true,
"keycount": 1,
"hidechildren": false,
"displayverbs": ["Look at", "Open","Close"],
"useindividualverblist":false,
"usestandardverblist":true,
"picklock": function() { if (e_player.class=="thief") {
if (e_chest1.locked) {
OutputText ("Piece of cake. You found a bottle and 25 coins in the chest.");
set(e_chest1, "locked", false);
HelperOpenObject (e_chest1);
set(e_purse, "coins", e_purse.coins+25);
}
else {
OutputText ("It is open!");
}
}
else {
OutputText ("You don't know how!");
} },
"onclose": function() { if (e_disguise_potion.parent==e_chest1 && !(e_disguise_potion.potion)) {
MoveObject (e_disguise_potion, e_void);
OutputText ("Fine, the impostor is returning. You climb the pallet and wait for him to drink the<i> fake</i> potion.<br/>After a while, several other brigands return to the hideout bringing Elias as a prisoner... and suddenly the impostor screams and changes back to his original form, fleeing the room.<br/>You reveal yourself and says:<br/><i>He is an impostor, not the real leader. I found Elias and decided to investigate what happened. Vourtram used witchcraft to make you believe in a false leader, making you help him with his domination plans. But I replaced the real disguise potion with water... </i>");
OutputText ("A brigand asked:");
psay ("What happened with the real leader?");
OutputText ("<br/>And then Elias says:<br/><i>I discovered where Leonard, our leader, is. Vourtram's minions tried to kill him near the river, and he felt down the rapids. They thought he was dead, but he was only hurt. He will arrive at any moment.</i><br/>And so Leonard came back, and promised to help you against Vourtram.");
finishBrigands();
} },
"look": function() { if (e_chest1.isopen) {
OutputText ("You better left the chest closed after you end with it.");
}
else {
OutputText ("It is a sturdy chest.");
} },
"inventoryverbs": ["Look at", "Use", "Drop", "Open", "Close"],
"key": e_null_key,
"_js_name": "e_chest1",
"_types": ["container_lockable", "container_closed", "defaultobject"],
"locked": true,
"nokeymessage": "You do not have the key.",
"unlockmessage": "Unlocked.",
"lockmessage": "Locked.",
"canlockopen": false,
"autoopen": true,
"autounlock": true,
"openscript": function() { if (this.locked) {
if (this.autounlock && AllKeysAvailable(this)) {
runscriptattribute2 (this, "unlock");
if (!(this.isopen)) {
OpenObject (this);
}
}
else {
OutputText (overloadedFunctions.DynamicTemplate("LockedObject", this));
}
}
else {
OpenObject (this);
} },
"closescript": function() { if (this.locked) {
OutputText (overloadedFunctions.DynamicTemplate("LockedObject", this));
}
else {
CloseObject (this);
} },
"lock": function() { if (this.locked) {
OutputText (overloadedFunctions.DynamicTemplate("AlreadyLocked", this));
}
else if (this.isopen && !(this.canlockopen)) {
OutputText (overloadedFunctions.DynamicTemplate("CannotLockOpen", this));
}
else {
if (AllKeysAvailable(this)) {
OutputText (this.lockmessage);
set(this, "locked", true);
}
else {
OutputText (this.nokeymessage);
}
} },
"unlock": function() { if (!(this.locked)) {
OutputText (overloadedFunctions.DynamicTemplate("AlreadyUnlocked", this));
}
else {
if (AllKeysAvailable(this)) {
OutputText (this.unlockmessage);
set(this, "locked", false);
if (this.autoopen && !(this.isopen)) {
TryOpenClose (true, this);
}
}
else {
OutputText (this.nokeymessage);
}
} },
"open": true,
"close": true,
"container": true,
"visible": true,
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["chest1"] = e_chest1;
allObjects.push(e_chest1);
objectsNameMap["chest1"] = e_chest1;
e_disguise_potion = {
"elementtype": "object",
"name": "disguise_potion",
"parent": e_chest1,
"type": "object",
"alias": "bottle",
"potion": true,
"look": "It is a bottle filled with a purple liquid. It should be the disguise potion.",
"take": true,
"feature_usegive": true,
"use": true,
"drink": "I don't want to risk any side effect of drinking unknown stuff. Besides, I only drink after 5 PM...",
"useCmds": ["fill", "pour"],
"selfuseon": {"bucket2": function() { if (e_bucket2.fill == true) {
OutputText ("You pour away the potion and fills the bottle with water.");
set(e_disguise_potion, "potion", false);
set(e_disguise_potion, "look", "It is full of water");
}
else {
OutputText ("the bucket is empty.");
} }, "rapids": function() { if (e_disguise_potion.potion == true) {
OutputText ("You pour away the potion and fills the bottle with water.");
set(e_disguise_potion, "potion", false);
set(e_disguise_potion, "look", "It is full of water");
}
else {
OutputText ("the bottle is already filled with water.");
} }, "chest1": function() { if (e_chest1.locked) {
OutputText ("The chest is locked.");
}
else if (!(e_chest1.isopen)) {
OutputText (overloadedFunctions.DynamicTemplate("ObjectNotOpen", e_chest1));
}
else {
MoveObject (e_disguise_potion, e_chest1);
OutputText (Template("Done"));
} } },
"_js_name": "e_disguise_potion",
"_types": ["UseAltType", "defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["disguise_potion"] = e_disguise_potion;
allObjects.push(e_disguise_potion);
objectsNameMap["disguise_potion"] = e_disguise_potion;
e_impostor = {
"elementtype": "object",
"name": "impostor",
"parent": e_hide_hall,
"type": "object",
"alias": "impostor leader",
"usedefaultprefix": false,
"prefix": "the",
"exp": 6,
"armour": 4,
"aggressive": true,
"bolt": false,
"speak": "You have nothing to talk with him.",
"_js_name": "e_impostor",
"_types": ["Enemy", "male", "defaultobject"],
"enemy": "yes",
"danger": "death",
"ht": 10,
"stab_level": 0,
"affect_calm": false,
"block_flee": false,
"damage": 2,
"push": function() { if (e_player.parent==e_combat_room) {
if (e_combat.pushed) {
OutputText ("You can only push one time before you combat movement.");
}
else if (savedRandomInt(0,1)==0) {
OutputText ("You successfully push "+this.alias+".");
set(e_combat, "en_red", e_combat.en_red+1);
}
else {
OutputText ("You tried to push "+this.alias+", but ended up losing your balance.");
set(e_combat, "pl_red", e_combat.pl_red+1);
}
set(e_combat, "pushed", true);
}
else {
OutputText ("It doesn't work.");
} },
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["impostor"] = e_impostor;
allObjects.push(e_impostor);
objectsNameMap["impostor"] = e_impostor;
e_brigands = {
"elementtype": "object",
"name": "brigands",
"parent": e_hide_hall,
"type": "object",
"visible": false,
"alias": "brigands",
"look": "Leonard, Elias, and many other brigands that will help you against Vourtram.",
"speak": "Leonard says: <i>Meet me at the castle's gate in two days.</i>",
"_js_name": "e_brigands",
"_types": ["maleplural", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "they",
"article": "them",
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["brigands"] = e_brigands;
allObjects.push(e_brigands);
objectsNameMap["brigands"] = e_brigands;
e_crates = {
"elementtype": "object",
"name": "crates",
"parent": e_hide_hall,
"type": "object",
"alt": ["crate"],
"scenery": true,
"look": "The crates are full of crops. No gold or jewelry.",
"displayverbs": ["Look at"],
"_js_name": "e_crates",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["crates"] = e_crates;
allObjects.push(e_crates);
objectsNameMap["crates"] = e_crates;
e_the_castle = {
"elementtype": "object",
"name": "the_castle",
"type": "object",
"_js_name": "e_the_castle",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["the_castle"] = e_the_castle;
allObjects.push(e_the_castle);
objectsNameMap["the_castle"] = e_the_castle;
e_the_gate = {
"elementtype": "object",
"name": "the_gate",
"parent": e_the_castle,
"type": "object",
"usedefaultprefix": false,
"prefix": "the",
"alias": "gates to the castle",
"description": "{img:castle.png}<br/>You are in front of the Castle of Vourtram. The Castle gates are to the north, and paths leads to the eastern and western sides of the castle. To the south there is the huge King's Square leading to the streets of the great city of Linwynne.  Guards are inspecting everyone wanting to enter the castle.",
"descprefix": "You are at",
"_js_name": "e_the_gate",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["the_gate"] = e_the_gate;
allObjects.push(e_the_gate);
objectsNameMap["the_gate"] = e_the_gate;
e_castle = {
"elementtype": "object",
"name": "castle",
"parent": e_the_gate,
"type": "object",
"alias": "Castle of Vourtram",
"look": "The castle is located in the edge of a deep cliff. A dark shadow covers the area since Vourtram moved his court of demons here. The only visible entrance is the south gates. ",
"usedefaultprefix": false,
"prefix": "the",
"displayverbs": ["Look at"],
"_js_name": "e_castle",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["castle"] = e_castle;
allObjects.push(e_castle);
objectsNameMap["castle"] = e_castle;
e_k65 = {
"elementtype": "object",
"name": "k65",
"parent": e_the_gate,
"type": "exit",
"alias": "northwest",
"_js_name": "e_k65",
"_types": ["northwestdirection", "defaultexit"],
"alt": ["nw"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k65"] = e_k65;
objectReferences.push(["e_k65", "to", "e_west_wall"]);
allExits.push(e_k65);
objectsNameMap["k65"] = e_k65;
e_k66 = {
"elementtype": "object",
"name": "k66",
"parent": e_the_gate,
"type": "exit",
"alias": "northeast",
"_js_name": "e_k66",
"_types": ["northeastdirection", "defaultexit"],
"alt": ["ne"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k66"] = e_k66;
objectReferences.push(["e_k66", "to", "e_east_wall"]);
allExits.push(e_k66);
objectsNameMap["k66"] = e_k66;
e_k67 = {
"elementtype": "object",
"name": "k67",
"parent": e_the_gate,
"type": "exit",
"alias": "down",
"_js_name": "e_k67",
"_types": ["downdirection", "defaultexit"],
"alt": ["d"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k67"] = e_k67;
objectReferences.push(["e_k67", "to", "e_kings_square"]);
allExits.push(e_k67);
objectsNameMap["k67"] = e_k67;
e_gate_lock = {
"elementtype": "object",
"name": "gate_lock",
"parent": e_the_gate,
"type": "exit",
"alias": "north",
"locked": true,
"lockmessage": "They would not let you in.",
"_js_name": "e_gate_lock",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["gate_lock"] = e_gate_lock;
objectReferences.push(["e_gate_lock", "to", "e_lobby"]);
allExits.push(e_gate_lock);
objectsNameMap["gate_lock"] = e_gate_lock;
e_guards = {
"elementtype": "object",
"name": "guards",
"parent": e_the_gate,
"type": "object",
"alias": "half a dozen guards",
"scenery": true,
"prefix": "",
"suffix": "",
"look": "You can see half a dozen fully armored guards. They carefully select who can enter the castle, always looking for spies. ",
"speak": "You better not talk to them.",
"_js_name": "e_guards",
"_types": ["maleplural", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "they",
"article": "them",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["guards"] = e_guards;
allObjects.push(e_guards);
objectsNameMap["guards"] = e_guards;
e_the_base = {
"elementtype": "object",
"name": "the_base",
"parent": e_the_castle,
"type": "object",
"usedefaultprefix": false,
"prefix": "the",
"alias": "Happy Boar Inn",
"descprefix": "You are in front of",
"description": "This traditional inn serves as a rendezvous point for the loyalists. ",
"enter": function() { if (e_inn_keeper.in_castle) {
if (!(e_old_sage.visible)) {
MakeObjectVisible (e_old_sage);
OutputText ("an old man enters the room and stares at you.");
}
} },
"_js_name": "e_the_base",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["the_base"] = e_the_base;
allObjects.push(e_the_base);
objectsNameMap["the_base"] = e_the_base;
e_k68 = {
"elementtype": "object",
"name": "k68",
"parent": e_the_base,
"type": "exit",
"alias": "east",
"_js_name": "e_k68",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k68"] = e_k68;
objectReferences.push(["e_k68", "to", "e_kings_square"]);
allExits.push(e_k68);
objectsNameMap["k68"] = e_k68;
e_inn_keeper = {
"elementtype": "object",
"name": "inn_keeper",
"parent": e_the_base,
"type": "object",
"alias": "Bernard",
"suffix": "the inn keeper",
"feature_usegive": true,
"in_castle": false,
"look": "Bernard looks like a somewhat fat bourgeois, but in fact is an important supporter of the King.",
"useindividualverblist": false,
"usestandardverblist": true,
"speak": function() { psay ("{once:Welcome {player.playername}! }Leonard will arrive tomorrow with the few warriors still loyal to the king. Meanwhile, go to the castle and try to discover more {ask:Bernard:information} about Vourtram and the hostage princess. When you think you are ready, return here and ask to {command:stay:stay} the night."); },
"staythenight": function() { stayNight(); },
"give": {"gold_chest": function() { OutputText ("You tell Bernard about the mercenary, and gives the gold chest to turn them against Vourtram.");
MoveObject (e_gold_chest, e_void);
if (e_medallion.parent==e_void) {
OutputText ("Bernard says: <i>Great! with the medallion and the mercenaries I think you are ready to strike!</i>");
}
else {
OutputText ("Bernard says: <i>Alright, but without the medallion Vourtram can order Fafnir to attack the mercenaries. They will just flee. We have to prevent this from happening.</i>");
} }, "medallion": function() { OutputText ("Great! with this medallion Vourtram could no longer control the dragons! ");
if (e_player.isThief) {
if (e_gold_chest.parent==e_void) {
OutputText ("We are ready to take the castle!");
}
else {
OutputText ("But we are outnumbered. We need reinforcements to defeat the demons under the control of Vourtram.");
}
}
MoveObject (e_medallion, e_void); } },
"ask": {"information": function() { if (e_inn_keeper.in_castle) {
OutputText ("<i>You managed to enter the castle.</i>");
}
else {
OutputText ("<i>The first thing we must figure out is a way to enter the castle.</i>");
}
if (e_princess.parent==e_void) {
OutputText ("<i>The princess is safe, meaning that Vourtram could no longer use her as a hostage.</i>");
}
else {
OutputText ("<i>We have to bring the princess to safety before the assault, or she will be used as a hostage.</i>");
}
if (e_medallion.parent==e_void) {
OutputText ("<i>Vourtram lost his medallion, and he can no longer use Fafnir to attack us.</i>");
}
else {
OutputText ("<i>Our sources indicate that Vourtram has a secret weapon for an assault against Chuma Huppic. We must take measures to disable this weapon.</i>");
}
if (e_elven_sword.parent==e_player) {
OutputText ("<i>The magic of the Demon Slayer sword should protect us from the demons.</i>");
}
else if (e_banish_spell.parent==e_spell_book) {
OutputText ("<i>Your banish spell should be enough to eliminate the demons.</i>");
}
else if (e_gold_chest.parent==e_void) {
OutputText ("<i>The mercenaries you hired will help us defeating the demons.</i>");
}
else {
OutputText ("<i>And we must take care of the demons summoned by Vourtram.</i>");
OutputText ("<i>We would need a reinforcement of soldiers or some way to neutralize these demons.</i>");
}
if (e_player.isMage && e_diary_vourtram.parent==e_archmage) {
psay ("With the aid of the diary, Dashiel and the others can destroy Vourtram.");
}
else if (e_soul_jar.parent==e_player) {
psay ("With the soul jar we can eliminate Vourtram forever.");
}
else {
psay ("You have to figure out a way to kill Vourtram, or he will come back.");
} } },
"_js_name": "e_inn_keeper",
"_types": ["namedmale", "defaultobject"],
"usedefaultprefix": false,
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["inn_keeper"] = e_inn_keeper;
allObjects.push(e_inn_keeper);
objectsNameMap["inn_keeper"] = e_inn_keeper;
e_old_sage = {
"elementtype": "object",
"name": "old_sage",
"parent": e_the_base,
"type": "object",
"look": "Despite the poor clothes, this old man has an imposing presence.",
"alias": "sage",
"deliver": false,
"visible": false,
"speak": function() { 
if (e_player.level<=3) {
  psay("I need the help of an hero. Do you know someone with this title?")
} else if (e_old_sage.deliver) {
psay ("When you unroll the carpet, a magical portal will appear. You must enter the portal and defeat the {ask:sage:guardian} to free the {ask:sage:prisoners}.");
}
else {
set(e_old_sage, "deliver", true);
MoveObject (e_temple_entrance, e_player);
psay ("Young hero, please help me. All children of my village were kidnapped by Vourtram's demons. They were imprisoned in this magical carpet.");
psay ("When you unroll the carpet, a magical portal will appear. You must enter the portal and defeat the guardian to free the prisoners.");
} },
"ask": {"guardian statue": function() { psay ("The guardian is a dangerous monster, a forgotten god! It feeds on young human blood."); }, "prisoners": function() { psay ("All children of my village were kidnapped by Vourtram's demons. People says that he sometimes send his men to capture young men and woman for an unknown evil purpose."); } },
"_js_name": "e_old_sage",
"_types": ["male", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["old_sage"] = e_old_sage;
allObjects.push(e_old_sage);
objectsNameMap["old_sage"] = e_old_sage;
e_east_wall = {
"elementtype": "object",
"name": "east_wall",
"parent": e_the_castle,
"type": "object",
"alias": "the eastern side of the castle\u00b4s walls",
"usedefaultprefix": false,
"_js_name": "e_east_wall",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["east_wall"] = e_east_wall;
allObjects.push(e_east_wall);
objectsNameMap["east_wall"] = e_east_wall;
e_k69 = {
"elementtype": "object",
"name": "k69",
"parent": e_east_wall,
"type": "exit",
"alias": "southwest",
"to": e_the_gate,
"_js_name": "e_k69",
"_types": ["southwestdirection", "defaultexit"],
"alt": ["sw"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k69"] = e_k69;
allExits.push(e_k69);
objectsNameMap["k69"] = e_k69;
e_a_narrow_path_down_the_cliff = {
"elementtype": "object",
"name": "a narrow path down the cliff",
"parent": e_east_wall,
"type": "exit",
"alias": "down",
"_js_name": "e_a_narrow_path_down_the_cliff",
"_types": ["downdirection", "defaultexit"],
"alt": ["d"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["a narrow path down the cliff"] = e_a_narrow_path_down_the_cliff;
objectReferences.push(["e_a_narrow_path_down_the_cliff", "to", "e_river"]);
allExits.push(e_a_narrow_path_down_the_cliff);
objectsNameMap["a narrow path down the cliff"] = e_a_narrow_path_down_the_cliff;
e_castle_guard = {
"elementtype": "object",
"name": "castle_guard",
"parent": e_east_wall,
"type": "object",
"alias": "guard",
"look": "He is about your height and weight.",
"danger": "friend",
"exp": 6,
"armour": 4,
"ht": 12,
"block_flee": true,
"stance": "none",
"speak": function() { psay ("Keep walking, peasant!"); },
"_js_name": "e_castle_guard",
"_types": ["Enemy", "male", "defaultobject"],
"enemy": "yes",
"aggressive": false,
"stab_level": 0,
"affect_calm": false,
"damage": 2,
"push": function() { if (e_player.parent==e_combat_room) {
if (e_combat.pushed) {
OutputText ("You can only push one time before you combat movement.");
}
else if (savedRandomInt(0,1)==0) {
OutputText ("You successfully push "+this.alias+".");
set(e_combat, "en_red", e_combat.en_red+1);
}
else {
OutputText ("You tried to push "+this.alias+", but ended up losing your balance.");
set(e_combat, "pl_red", e_combat.pl_red+1);
}
set(e_combat, "pushed", true);
}
else {
OutputText ("It doesn't work.");
} },
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["castle_guard"] = e_castle_guard;
allObjects.push(e_castle_guard);
objectsNameMap["castle_guard"] = e_castle_guard;
e_guard_helmet = {
"elementtype": "object",
"name": "guard_helmet",
"parent": e_castle_guard,
"type": "object",
"armour": 2,
"loc": "head",
"take": true,
"alias": "iron helmet",
"look": "It is an iron helmet with the insignia of Vourtram. It fits perfectly on your head.",
"drop": false,
"inventoryverbs": ["Look at", "Drop"],
"ontake": function() { if (e_pot_helmet.parent==e_player) {
OutputText ("You toss away the makeshift helmet. It is ruined after so many blows.");
MoveObject (e_pot_helmet, e_void);
} },
"_js_name": "e_guard_helmet",
"_types": ["Armour", "defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"use": false,
"givesingle": false,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["guard_helmet"] = e_guard_helmet;
allObjects.push(e_guard_helmet);
objectsNameMap["guard_helmet"] = e_guard_helmet;
e_river = {
"elementtype": "object",
"name": "river",
"parent": e_the_castle,
"type": "object",
"alias": "margin of a wide river",
"usedefaultprefix": false,
"prefix": "at the",
"description": "The river is a natural protection for the castle. You can only go up from here.",
"descprefix": "You are",
"_js_name": "e_river",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["river"] = e_river;
allObjects.push(e_river);
objectsNameMap["river"] = e_river;
e_up_the_cliff = {
"elementtype": "object",
"name": "up the cliff",
"parent": e_river,
"type": "exit",
"alias": "up",
"to": e_east_wall,
"_js_name": "e_up_the_cliff",
"_types": ["updirection", "defaultexit"],
"alt": ["u"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["up the cliff"] = e_up_the_cliff;
allExits.push(e_up_the_cliff);
objectsNameMap["up the cliff"] = e_up_the_cliff;
e_river1 = {
"elementtype": "object",
"name": "river1",
"parent": e_river,
"type": "object",
"alias": "river",
"look": "The river is deep and cold.",
"displayverbs": ["Look at"],
"_js_name": "e_river1",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["river1"] = e_river1;
allObjects.push(e_river1);
objectsNameMap["river1"] = e_river1;
e_swim_river = {
"elementtype": "object",
"name": "swim_river",
"parent": e_river,
"type": "command",
"pattern": "^swim$",
"script": function(parameters) { OutputText ("You see no reason to swim."); },
"_js_name": "e_swim_river",
"_types": ["defaultcommand"]
};
elementsNameMap["swim_river"] = e_swim_river;
allCommands.push(e_swim_river);
objectsNameMap["swim_river"] = e_swim_river;
e_west_wall = {
"elementtype": "object",
"name": "west_wall",
"parent": e_the_castle,
"type": "object",
"alias": "the western side of the castle\u00b4s walls",
"usedefaultprefix": false,
"_js_name": "e_west_wall",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["west_wall"] = e_west_wall;
allObjects.push(e_west_wall);
objectsNameMap["west_wall"] = e_west_wall;
e_k70 = {
"elementtype": "object",
"name": "k70",
"parent": e_west_wall,
"type": "exit",
"alias": "southeast",
"to": e_the_gate,
"_js_name": "e_k70",
"_types": ["southeastdirection", "defaultexit"],
"alt": ["se"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k70"] = e_k70;
allExits.push(e_k70);
objectsNameMap["k70"] = e_k70;
e_sewer_entrance = {
"elementtype": "object",
"name": "sewer_entrance",
"parent": e_west_wall,
"type": "object",
"alias": "sewers",
"feature_usegive": false,
"displayverbs": ["Look at"],
"usestandardverblist": true,
"usedefaultprefix": false,
"prefix": "the",
"suffix": "entrance",
"look": function() { OutputText ("The entrance to the sewer system is a small hole in the walls, leading to a deep and dark tunnel connected to the castle\u00b4s draining system.");
if (e_player.class=="thief") {
set(e_sewer_entrance, "displayverbs", Split("Look at;Climb", ";"));
} },
"climb": function() { if (e_player.class=="thief") {
OutputText ("You carefully descend the slippery walls into the dark.");
MoveObject (e_player, e_sewer);
}
else {
OutputText ("I would probably break my neck.");
} },
"useon": {"__dummyKey": function() {  } },
"_js_name": "e_sewer_entrance",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["sewer_entrance"] = e_sewer_entrance;
allObjects.push(e_sewer_entrance);
objectsNameMap["sewer_entrance"] = e_sewer_entrance;
e_kings_square = {
"elementtype": "object",
"name": "kings_square",
"parent": e_the_castle,
"type": "object",
"usedefaultprefix": false,
"prefix": "the",
"alias": "King's Square",
"description": "The main square leads to several streets of Linwynne. To the east you see the Happy Boar Inn, where the last friends to the king meet. Huge marble staircases go up to the castle gates.",
"firstenter": function() { psay ("Good day sir! My name is Eva, what do you want for today? pears, cherries or perhaps fresh oranges? "); },
"_js_name": "e_kings_square",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["kings_square"] = e_kings_square;
allObjects.push(e_kings_square);
objectsNameMap["kings_square"] = e_kings_square;
e_k71 = {
"elementtype": "object",
"name": "k71",
"parent": e_kings_square,
"type": "exit",
"alias": "west",
"to": e_the_base,
"_js_name": "e_k71",
"_types": ["westdirection", "defaultexit"],
"alt": ["w"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k71"] = e_k71;
allExits.push(e_k71);
objectsNameMap["k71"] = e_k71;
e_statue = {
"elementtype": "object",
"name": "statue",
"parent": e_kings_square,
"type": "object",
"alias": "beautiful statue",
"look": "It is a statue of princess Grardobeth, with a lot of creative liberty. You can also notice a missing statue, probably of the King.",
"visible": true,
"displayverbs": ["Look at"],
"_js_name": "e_statue",
"_types": ["defaultobject"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["statue"] = e_statue;
allObjects.push(e_statue);
objectsNameMap["statue"] = e_statue;
e_k72 = {
"elementtype": "object",
"name": "k72",
"parent": e_kings_square,
"type": "exit",
"alias": "up",
"to": e_the_gate,
"_js_name": "e_k72",
"_types": ["updirection", "defaultexit"],
"alt": ["u"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k72"] = e_k72;
allExits.push(e_k72);
objectsNameMap["k72"] = e_k72;
e_fruit_stand = {
"elementtype": "object",
"name": "fruit_stand",
"parent": e_kings_square,
"type": "object",
"look": "You see several fruits for sale, but the apples are the most beautiful you ever saw.",
"alias": "stand",
"listalias": "fruit stand",
"displayverbs": ["Look at"],
"_js_name": "e_fruit_stand",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["fruit_stand"] = e_fruit_stand;
allObjects.push(e_fruit_stand);
objectsNameMap["fruit_stand"] = e_fruit_stand;
e_fruit_dealer = {
"elementtype": "object",
"name": "fruit_dealer",
"parent": e_kings_square,
"type": "object",
"alias": "Eva",
"suffix": "the fruit dealer",
"blind": 0,
"look": "She is a pretty lower class girl.",
"speak": function() { psay ("Do you want pears, cherries or perhaps fresh oranges? All {ask:eva:fruits} for a reasonable price."); },
"ask": {"apple apples": function() { psay ("I'm sorry sir, but all apples are reserved to the castle {ask:eva:staff}. They are coming to get the fruits at any moment."); }, "fruits fruit": function() { psay ("A pear is one coin. Half a dozen oranges for a coin. A dozen cherries also for one coin. {ask:eva:apple:Apples} are not for sale."); }, "staff": function() { psay ("The cook of the castle required all apples for the dessert."); } },
"useon": {"purse": function() { OutputText ("You don't want to buy any fruit... perhaps the apples, but they aren't for sale."); } },
"_js_name": "e_fruit_dealer",
"_types": ["namedfemale", "defaultobject"],
"usedefaultprefix": false,
"displayverbs": ["Look at", "Speak to"],
"gender": "she",
"article": "her",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["fruit_dealer"] = e_fruit_dealer;
allObjects.push(e_fruit_dealer);
objectsNameMap["fruit_dealer"] = e_fruit_dealer;
e_blind_dealer = {
"elementtype": "object",
"name": "blind_dealer",
"parent": e_kings_square,
"type": "turnscript",
"enabled": true,
"script": function() { if (e_fruit_dealer.blind>0 && e_fruit_dealer.parent==e_kings_square) {
DecreaseObjectCounter (e_fruit_dealer, "blind");
if (e_fruit_dealer.blind>0) {
OutputText ("The fruit dealer is under the effect of the blind spell.");
}
} },
"_js_name": "e_blind_dealer",
"_types": []
};
elementsNameMap["blind_dealer"] = e_blind_dealer;
allTurnScripts.push(e_blind_dealer);
objectsNameMap["blind_dealer"] = e_blind_dealer;
e_sc_apple = {
"elementtype": "object",
"name": "sc_apple",
"parent": e_kings_square,
"type": "object",
"alias": "apple",
"scenery": true,
"look": "They look great.",
"takemsg": "You don\u00b4t need any fruits right now.",
"alt": ["apples", "oranges", "cherries", "pears"],
"_js_name": "e_sc_apple",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["sc_apple"] = e_sc_apple;
allObjects.push(e_sc_apple);
objectsNameMap["sc_apple"] = e_sc_apple;
e_k73 = {
"elementtype": "object",
"name": "k73",
"parent": e_kings_square,
"type": "command",
"anonymous": true,
"pattern": "^buy (?<text>.*)$",
"script": function(parameters) { var text = parameters['text'];
OutputText ("I don't need to buy anything right now."); },
"_js_name": "e_k73",
"_types": ["defaultcommand"]
};
elementsNameMap["k73"] = e_k73;
allCommands.push(e_k73);
objectsNameMap["k73"] = e_k73;
e_dragon_lair = {
"elementtype": "object",
"name": "dragon_lair",
"parent": e_the_castle,
"type": "object",
"alias": "huge cave",
"description": "The cave is a dungeon built to imprison a huge dragon. The head of the dragon is stuck inside a hole in the ceiling. There is a river running from the southeast to a steep ramp at the northeast.",
"firstenter": function() { OutputText ("The dragon mentally tells you: <i>Puny mortal! come close to my breath or my claws and I will show what will soon happen to Vourtram and this kingdom!</i>. You reply to the dragon <i>I\u00b4m no Vourtram\u00b4s minions. I\u00b4m "+e_player.playername+", and my mission is to defeat that devil wizard!</i>");
if (e_player.class=="mage") {
OutputText ("However, the Dragon is not convinced: <i>I could not trust a wizard such as you! You are all the same.</i>");
} },
"_js_name": "e_dragon_lair",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["dragon_lair"] = e_dragon_lair;
allObjects.push(e_dragon_lair);
objectsNameMap["dragon_lair"] = e_dragon_lair;
e_dragon_sewer_exit = {
"elementtype": "object",
"name": "dragon_sewer_exit",
"parent": e_dragon_lair,
"type": "exit",
"alias": "southwest",
"locked": true,
"lockmessage": "The passage is too narrow for me.",
"_js_name": "e_dragon_sewer_exit",
"_types": ["southwestdirection", "defaultexit"],
"alt": ["sw"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["dragon_sewer_exit"] = e_dragon_sewer_exit;
objectReferences.push(["e_dragon_sewer_exit", "to", "e_sewer"]);
allExits.push(e_dragon_sewer_exit);
objectsNameMap["dragon_sewer_exit"] = e_dragon_sewer_exit;
e_dragon = {
"elementtype": "object",
"name": "dragon",
"parent": e_dragon_lair,
"type": "object",
"alias": "chained dragon",
"look": "{if chains.parent=dragon_lair:The huge creature is chained to the cave wall. Its neck is attached into a hole in the ceiling, so that you can\u00b4t see his head.}{if chains.parent=void:The huge creature is pretending to be chained here.}",
"alt": ["Fafnir"],
"unchain": "The chains are too strong. You could try to unlock it.",
"usedefaultprefix": false,
"prefix": "a",
"speak": function() { psay ("{once:Greetings adventurer, I\u00b4m Fafnir, prisoner of the evil }{notfirst:Greetings to you, and death to evil }{ask:fafnir:Vourtram}.");
if (e_player.isMage && e_chains.parent==e_dragon_lair) {
psay ("Or perhaps you are just another {ask:fafnir:wizard:treacherous wizard} deserving only my rage?");
} },
"ask": {"vourtram": function() { psay ("Vourtram is a powerful wizard. He managed to stole the dragon\u00b4s heart {ask:fafnir:gem}."); }, "gem heart": function() { psay ("The wizard that possesses this magical gem gains control over the dragons. If you could find and break this gem, I could help you vanquishing Vourtram. The gem is somewhere in this castle."); }, "wizard wizards treachery": function() { if (e_chains.parent==e_dragon_lair) {
psay ("All wizards are treacherous snakes!");
if (e_player.isMage) {
psay ("You say that you are an enemy of Vourtram. I say that you should prove it!");
}
}
else {
psay ("You unchained me, so I trust you, despite you being a wizard...");
} } },
"_js_name": "e_dragon",
"_types": ["male", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["dragon"] = e_dragon;
allObjects.push(e_dragon);
objectsNameMap["dragon"] = e_dragon;
e_lair_to_river = {
"elementtype": "object",
"name": "lair_to_river",
"parent": e_dragon_lair,
"type": "exit",
"alias": "southeast",
"lockmessage": "The dragon yells <i>Get closer to my claws and I will smash you little wizard</i>",
"_js_name": "e_lair_to_river",
"_types": ["southeastdirection", "defaultexit"],
"alt": ["se"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["lair_to_river"] = e_lair_to_river;
objectReferences.push(["e_lair_to_river", "to", "e_sub_river"]);
allExits.push(e_lair_to_river);
objectsNameMap["lair_to_river"] = e_lair_to_river;
e_river_ramp = {
"elementtype": "object",
"name": "river_ramp",
"parent": e_dragon_lair,
"type": "object",
"look": "The ramp leads outside the castle, to the river. It looks safe, but it is impossible to climb back.",
"alias": "ramp",
"usedefaultprefix": false,
"prefix": "a steep",
"suffix": "to the river",
"alt": ["ramp"],
"feature_usegive": true,
"displayverbs": ["Look at", "Use"],
"use": function() { if (e_player.class=="mage" && e_chains.parent==e_dragon_lair) {
OutputText ("The dragon yells <i>Get closer to my claws and I will smash you little wizard</i>. It is not safe to use the ramp.");
}
else if (e_teleport_orb.parent==e_player) {
OutputText ("It is unwise to exit the castle without levaing the teleport orb here. You would not be able to return.");
}
else if (e_princess.parent==e_player.parent) {
OutputText ("You grab the princess...");
psay ("What are you doing? I don't want to get wet! stop!");
OutputText ("You push her into the ramp, and you both emerge at the river.");
savePrincess();
}
else {
OutputText ("Wheeeeeeeeeee! ");
MoveObject (e_player, e_river);
} },
"_js_name": "e_river_ramp",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["river_ramp"] = e_river_ramp;
allObjects.push(e_river_ramp);
objectsNameMap["river_ramp"] = e_river_ramp;
e_chains = {
"elementtype": "object",
"name": "chains",
"parent": e_dragon_lair,
"type": "object",
"alias": "chains",
"look": "the chains are strong, and have a brass lock.",
"feature_container": true,
"close": false,
"picklock": "This looks magical",
"keycount": 1,
"autounlock": true,
"open": true,
"usedefaultprefix": false,
"displayverbs": ["Look at", "Open"],
"openscript": function() { if (this.locked) {
if (this.autounlock && AllKeysAvailable(this)) {
runscriptattribute2 (this, "unlock");
if (!(this.isopen)) {
OpenObject (this);
}
}
else {
OutputText (overloadedFunctions.DynamicTemplate("LockedObject", this));
}
}
else {
OpenObject (this);
}
if (this.isopen && e_chains.parent==e_dragon_lair) {
OutputText ("The dragon says <i>I'm free! Thank you, I misjudged you!</i>");
OutputText ("You say <i>Vourtram was not yet defeated. You better pretend to be a prisoner here for a while.</i>.");
MoveObject (e_brass_key, e_void);
MoveObject (e_chains, e_void);
set(e_dragon, "alias", "Fafnir");
set(e_dragon, "prefix", "");
set(e_dragon, "suffix", "the great");
} },
"inventoryverbs": ["Look at", "Use", "Drop", "Open", "Close"],
"_js_name": "e_chains",
"_types": ["openable", "container_lockable", "plural", "defaultobject"],
"locked": true,
"nokeymessage": "You do not have the key.",
"unlockmessage": "Unlocked.",
"lockmessage": "Locked.",
"canlockopen": false,
"autoopen": true,
"closescript": function() { if (this.locked) {
OutputText (overloadedFunctions.DynamicTemplate("LockedObject", this));
}
else {
CloseObject (this);
} },
"lock": function() { if (this.locked) {
OutputText (overloadedFunctions.DynamicTemplate("AlreadyLocked", this));
}
else if (this.isopen && !(this.canlockopen)) {
OutputText (overloadedFunctions.DynamicTemplate("CannotLockOpen", this));
}
else {
if (AllKeysAvailable(this)) {
OutputText (this.lockmessage);
set(this, "locked", true);
}
else {
OutputText (this.nokeymessage);
}
} },
"unlock": function() { if (!(this.locked)) {
OutputText (overloadedFunctions.DynamicTemplate("AlreadyUnlocked", this));
}
else {
if (AllKeysAvailable(this)) {
OutputText (this.unlockmessage);
set(this, "locked", false);
if (this.autoopen && !(this.isopen)) {
TryOpenClose (true, this);
}
}
else {
OutputText (this.nokeymessage);
}
} },
"gender": "they",
"article": "them",
"visible": true,
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["chains"] = e_chains;
objectReferences.push(["e_chains", "key", "e_brass_key"]);
allObjects.push(e_chains);
objectsNameMap["chains"] = e_chains;
e_sewer = {
"elementtype": "object",
"name": "sewer",
"parent": e_the_castle,
"type": "object",
"alias": "sewers",
"description": "You are in a dark tunnel system with low roof and an awful smell.  You can only crawl inside. There is a light to the northeast.  You can't reach the exit from here, you must find another way out.",
"usedefaultprefix": false,
"prefix": "the",
"_js_name": "e_sewer",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["sewer"] = e_sewer;
allObjects.push(e_sewer);
objectsNameMap["sewer"] = e_sewer;
e_k74 = {
"elementtype": "object",
"name": "k74",
"parent": e_sewer,
"type": "exit",
"alias": "northeast",
"to": e_dragon_lair,
"_js_name": "e_k74",
"_types": ["northeastdirection", "defaultexit"],
"alt": ["ne"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k74"] = e_k74;
allExits.push(e_k74);
objectsNameMap["k74"] = e_k74;
e_sub_river = {
"elementtype": "object",
"name": "sub_river",
"parent": e_the_castle,
"type": "object",
"alias": "subterranean stream",
"description": "The stream ends in a large cave with a profound and clear lake. You can see the light coming from a small hole a few meters above.",
"onexit": function() { if (e_player.class=="mage" && e_player.parent==e_courtyard2) {
OutputText ("you levitate to the hole in the ceiling.");
} },
"_js_name": "e_sub_river",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["sub_river"] = e_sub_river;
allObjects.push(e_sub_river);
objectsNameMap["sub_river"] = e_sub_river;
e_k75 = {
"elementtype": "object",
"name": "k75",
"parent": e_sub_river,
"type": "exit",
"alias": "northwest",
"to": e_dragon_lair,
"_js_name": "e_k75",
"_types": ["northwestdirection", "defaultexit"],
"alt": ["nw"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k75"] = e_k75;
allExits.push(e_k75);
objectsNameMap["k75"] = e_k75;
e_k76 = {
"elementtype": "object",
"name": "k76",
"parent": e_sub_river,
"type": "exit",
"alias": "up",
"_js_name": "e_k76",
"_types": ["updirection", "defaultexit"],
"alt": ["u"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k76"] = e_k76;
objectReferences.push(["e_k76", "to", "e_courtyard2"]);
allExits.push(e_k76);
objectsNameMap["k76"] = e_k76;
e_key_book = {
"elementtype": "object",
"name": "key_book",
"parent": e_sub_river,
"type": "object",
"look": "It is a book with a golden decorated hardcover.<br/>{if player.isMage:The book is The Lesser Key of Solomon. You've read this book when studying magic, it is nothing special.}",
"alias": "golden book",
"visible": false,
"take": true,
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"feature_usegive": true,
"use": true,
"givesingle": true,
"read": "I'm not going to read it again.",
"_js_name": "e_key_book",
"_types": ["defaultobject"],
"displayverbs": ["Look at", "Take"],
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["key_book"] = e_key_book;
allObjects.push(e_key_book);
objectsNameMap["key_book"] = e_key_book;
e_walls = {
"elementtype": "object",
"name": "walls",
"parent": e_sub_river,
"type": "object",
"alias": "glowing walls",
"displayverbs": ["Look at"],
"look": function() { OutputText ("The cave walls contains several small soft light sources. You also find that some of the walls were sculpted, with unknown runes.");
MakeObjectVisible (e_rune_wall); },
"_js_name": "e_walls",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["walls"] = e_walls;
allObjects.push(e_walls);
objectsNameMap["walls"] = e_walls;
e_rune_wall = {
"elementtype": "object",
"name": "rune_wall",
"parent": e_sub_river,
"type": "object",
"alias": "smooth wall with runes",
"look": "You cannot figure out the symbols.",
"visible": false,
"alt": ["wall", "runes", "rune", "symbols"],
"useindividualverblist": false,
"usestandardverblist": true,
"displayverbs": ["Look at"],
"read_away": true,
"push": function() { OutputText ("When you push the wall, it reveals a secret compartment.");
MakeObjectVisible (e_key_book); },
"_js_name": "e_rune_wall",
"_types": ["Readable", "defaultobject"],
"read": function() { doRead (this); },
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["rune_wall"] = e_rune_wall;
allObjects.push(e_rune_wall);
objectsNameMap["rune_wall"] = e_rune_wall;
e_lake = {
"elementtype": "object",
"name": "lake",
"parent": e_sub_river,
"type": "object",
"visible": true,
"scenery": true,
"look": "You see nothing special about it.",
"alt": ["cave", "hole"],
"_js_name": "e_lake",
"_types": ["defaultobject"],
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["lake"] = e_lake;
allObjects.push(e_lake);
objectsNameMap["lake"] = e_lake;
e_lib_entrance = {
"elementtype": "object",
"name": "lib_entrance",
"parent": e_the_castle,
"type": "object",
"alias": "entrance to the western tower",
"description": "The corridor ends in a dark lobby to the western tower. The west wall is made of dark marble, and the rest of the room is made of stone. The light comes from torches in the wall.",
"usedefaultprefix": false,
"prefix": "the",
"_js_name": "e_lib_entrance",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["lib_entrance"] = e_lib_entrance;
allObjects.push(e_lib_entrance);
objectsNameMap["lib_entrance"] = e_lib_entrance;
e_lib_door = {
"elementtype": "object",
"name": "lib_door",
"parent": e_lib_entrance,
"type": "exit",
"alias": "in",
"locked": true,
"lockmessage": "You can\u00b4t enter while the Medusa head stares at you.",
"_js_name": "e_lib_door",
"_types": ["indirection", "defaultexit"],
"alt": [""],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["lib_door"] = e_lib_door;
objectReferences.push(["e_lib_door", "to", "e_lib1"]);
allExits.push(e_lib_door);
objectsNameMap["lib_door"] = e_lib_door;
e_medusa = {
"elementtype": "object",
"name": "medusa",
"parent": e_lib_entrance,
"type": "object",
"alias": "Medusa head",
"speak": "<i>Come closer so that I can SEE YOU BETTER!</i>",
"drop": false,
"blind": 0,
"feature_usegive": true,
"look": function() { if (e_medusa.parent==e_lib_entrance) {
if (e_medusa.blind>0) {
OutputText ("The Medusa head is still blinded.");
}
else {
OutputText ("The Medusa head is over a pedestal guarding the door. You can\u00b4t get closer.");
}
}
else {
OutputText ("Better leave it alone.");
} },
"take": function() { OutputText ("With your bare hands? these snakes may be poisonous."); },
"_js_name": "e_medusa",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"use": false,
"givesingle": false,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["medusa"] = e_medusa;
allObjects.push(e_medusa);
objectsNameMap["medusa"] = e_medusa;
e_statues = {
"elementtype": "object",
"name": "statues",
"parent": e_lib_entrance,
"type": "object",
"alias": "statues",
"listalias": "",
"look": "They seem so real, as if someone was turned into stone. Creepy...",
"feature_container": true,
"hidechildren": true,
"listchildren": true,
"listchildrenprefix": "behind the statues, there is",
"displayverbs": ["Look at"],
"_js_name": "e_statues",
"_types": ["surface", "plural", "defaultobject"],
"isopen": true,
"transparent": true,
"contentsprefix": "on which there is",
"container": true,
"gender": "they",
"article": "them",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"open": false,
"close": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"description": "",
"scenery": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["statues"] = e_statues;
allObjects.push(e_statues);
objectsNameMap["statues"] = e_statues;
e_kibisis = {
"elementtype": "object",
"name": "kibisis",
"parent": e_statues,
"type": "object",
"alt": ["bag", "knapsack", "sack"],
"alias": "silvery knapsack",
"look": "It is a silvery knapsack with bright tassels of gold.",
"feature_container": false,
"open": false,
"close": false,
"feature_usegive": true,
"displayverbs": ["Look at", "Take"],
"medusa": false,
"drop": false,
"dropmsg": "You don't want to lose this.",
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"use": true,
"givesingle": true,
"useCmds": [],
"useindividualverblist": false,
"usestandardverblist": true,
"take": function() { if (e_kibisis.parent==e_statues) {
if (e_medusa.blind>0) {
AddToInventory (e_kibisis);
OutputText ("While Medusa is blind, you get the knapsack.");
}
else {
OutputText ("You can't get close to the statues with the Medusa head staring at you.");
}
}
else {
AddToInventory (e_kibisis);
OutputText ("You got it.");
} },
"selfuseanything": function(params) { //JS error! missing parameter
object = params.object;
if (e_kibisis.medusa) { 
if (HasAttribute(object,"enemy")) {
OutputText ("It may look a good idea to use Medusa to defeat every foe, but it is better not risk get bitten by the venomous snakes in her head.");
}
else {
OutputText ("I don't see how the Medusa head will help you now");
}
}
else {
OutputText ("I don't see how this will work.");
} },
"show": function() { if (e_kibisis.medusa) {
OutputText ("You better 'use Kibisis with someone'. This is too dangerous to show around.");
}
else {
OutputText ("Why?");
} },
"selfuseon": {"medusa": function() { if (e_medusa.blind>0) {
OutputText ("You quickly place the head inside the Kibisis, where it is harmless.");
MoveObject (e_medusa, e_void);
UnlockExit (e_lib_door);
SetObjectFlagOn (e_kibisis, "medusa");
set(e_kibisis, "alias", "Medusa inside a knapsack");
set(e_kibisis, "look", "The knapsack cointains the head of Medusa. You better be careful with it.");
}
else {
OutputText ("You can't get the head, it may turn you into stone.");
} }, "vourtram": function() { OutputText ("That would not defeat Vourtram right now. He is too powerful."); }, "vourtram2": function() { OutputText ("Not yet!"); }, "monster": function() { OutputText ("You quickly remembers the Medusa head, and shows it to the monster that turns into stone!");
OutputText ("<b>Victory! VOURTRAM IS DEAD!</b>");
endGameFinish(); } },
"_js_name": "e_kibisis",
"_types": ["container_open", "defaultobject"],
"isopen": true,
"container": true,
"visible": true,
"gender": "it",
"article": "it",
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["kibisis"] = e_kibisis;
allObjects.push(e_kibisis);
objectsNameMap["kibisis"] = e_kibisis;
e_k77 = {
"elementtype": "object",
"name": "k77",
"parent": e_lib_entrance,
"type": "exit",
"alias": "south",
"_js_name": "e_k77",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k77"] = e_k77;
objectReferences.push(["e_k77", "to", "e_corridor1"]);
allExits.push(e_k77);
objectsNameMap["k77"] = e_k77;
e_blindMedusa = {
"elementtype": "object",
"name": "blindMedusa",
"parent": e_lib_entrance,
"type": "turnscript",
"enabled": true,
"script": function() { if (e_medusa.blind>0 && e_medusa.parent==e_lib_entrance) {
DecreaseObjectCounter (e_medusa, "blind");
if (e_medusa.blind==0) {
OutputText ("Medusa opened her eyes, be careful");
}
} },
"_js_name": "e_blindMedusa",
"_types": []
};
elementsNameMap["blindMedusa"] = e_blindMedusa;
allTurnScripts.push(e_blindMedusa);
objectsNameMap["blindMedusa"] = e_blindMedusa;
e_lib2 = {
"elementtype": "object",
"name": "lib2",
"parent": e_the_castle,
"type": "object",
"alias": "library",
"secret": 1,
"description": "The library is full of books and magical equipments.",
"_js_name": "e_lib2",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["lib2"] = e_lib2;
allObjects.push(e_lib2);
objectsNameMap["lib2"] = e_lib2;
e_k78 = {
"elementtype": "object",
"name": "k78",
"parent": e_lib2,
"type": "exit",
"alias": "out",
"to": e_lib_entrance,
"_js_name": "e_k78",
"_types": ["outdirection", "defaultexit"],
"alt": ["o"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k78"] = e_k78;
allExits.push(e_k78);
objectsNameMap["k78"] = e_k78;
e_firewall = {
"elementtype": "object",
"name": "firewall",
"parent": e_lib2,
"type": "object",
"alias": "fire wall",
"look": "It's a fierce fire barrier with a magical nature.",
"feature_usegive": true,
"usedefaultprefix": false,
"prefix": "a",
"suffix": "blocking your way into the library",
"displayverbs": ["Look at"],
"useon": {"bucket1": function() { OutputText ("It won't work."); }, "bucket2": function() { OutputText ("It won't work."); } },
"_js_name": "e_firewall",
"_types": ["defaultobject"],
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["firewall"] = e_firewall;
allObjects.push(e_firewall);
objectsNameMap["firewall"] = e_firewall;
e_levitation_spell = {
"elementtype": "object",
"name": "levitation_spell",
"parent": e_lib2,
"type": "object",
"alias": "parchment",
"drop": false,
"takemsg": "You can\u00b4t reach it.",
"visible": false,
"look": "It is a magical parchment.",
"inventoryverbs": ["Look at", "Cast"],
"alt": ["levitate", "float"],
"usedefaultprefix": false,
"prefix": "a",
"suffix": "floating near the ceiling",
"castonobject": false,
"_js_name": "e_levitation_spell",
"_types": ["Spell", "defaultobject"],
"castspell": true,
"use": function() { OutputText ("You don't use a spell, you 'cast' it."); },
"read_away": false,
"read": function() { doRead (this); },
"displayverbs": ["Look at", "Take"],
"take": false,
"givesingle": false,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["levitation_spell"] = e_levitation_spell;
allObjects.push(e_levitation_spell);
objectsNameMap["levitation_spell"] = e_levitation_spell;
e_bookcase = {
"elementtype": "object",
"name": "bookcase",
"parent": e_lib2,
"type": "object",
"alias": "book case",
"look": "You feel strange goose bumps when you look at the book case. You see hundreds of books on various subjects: <br/>{command:x history:history}<br/>{command:x geography:geography}<br/>{command:x accounting:accounting}<br/>{command:x programming:programming}<br/>{if magical_books.visible:{command:x magic:magic}}",
"feature_usegive": true,
"alt": ["bookcase", "case"],
"visible": false,
"displayverbs": ["Look at"],
"read": "The entire collection? ",
"read_away": true,
"useon": {"key_book": function() { OutputText ("When you place the book in the bookshelf, a section of magical books appears.");
MoveObject (e_key_book, e_void);
MakeObjectVisible (e_magical_books); } },
"_js_name": "e_bookcase",
"_types": ["Readable", "defaultobject"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["bookcase"] = e_bookcase;
allObjects.push(e_bookcase);
objectsNameMap["bookcase"] = e_bookcase;
e_history_books = {
"elementtype": "object",
"name": "history_books",
"parent": e_lib2,
"type": "object",
"scenery": true,
"alias": "history",
"alt": ["historical", "books"],
"visible": false,
"look": "Tens of books about the history of the kings and their feats. Boring.",
"displayverbs": ["Look at"],
"read": "ALL of them?",
"read_away": true,
"_js_name": "e_history_books",
"_types": ["Readable", "plural", "defaultobject"],
"gender": "they",
"article": "them",
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["history_books"] = e_history_books;
allObjects.push(e_history_books);
objectsNameMap["history_books"] = e_history_books;
e_magical_books = {
"elementtype": "object",
"name": "magical_books",
"parent": e_lib2,
"type": "object",
"visible": false,
"scenery": true,
"alias": "magical books",
"alt": ["magic", "books"],
"feature_container": true,
"hidechildren": true,
"listchildren": true,
"look": "Most of the books are very theoretical for your taste.",
"displayverbs": ["Look at"],
"read": "ALL of them?",
"read_away": true,
"_js_name": "e_magical_books",
"_types": ["Readable", "plural", "surface", "defaultobject"],
"gender": "they",
"article": "them",
"isopen": true,
"transparent": true,
"contentsprefix": "on which there is",
"container": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"open": false,
"close": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"description": "",
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["magical_books"] = e_magical_books;
allObjects.push(e_magical_books);
objectsNameMap["magical_books"] = e_magical_books;
e_immortality_book = {
"elementtype": "object",
"name": "immortality_book",
"parent": e_magical_books,
"type": "object",
"alias": "blue book",
"look": "{if immortality_book.parent=player:The immortality recipe is too complicated, but what calls your attention is the undesired side effects:<br/><br/>\"Using incorrect ingredients may cause several side-effects, such as: nausea, dizziness, fluorescent urine, chocolate crave, death, and turning into a cat. If any of this occurs (except for death), we recommend the following recipe as an antidote:<br/><br/>- a handful of ashes from an oak burned by blind a dragon<br/>- a vial of dragon blood<br/>- a clove of garlic<br/>- a pinch of cheese<br/>- a bottle of coconut water<br/><br/>boil everything in a standard witch cauldron. You can garnish with spider webs.}{if immortality_book.parent<>player:You must hold the book in order to read it.}<br/>",
"take": true,
"usedefaultprefix": false,
"prefix": "a",
"suffix": "entitled how to make the immortality potion",
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"feature_usegive": true,
"use": true,
"givesingle": true,
"_js_name": "e_immortality_book",
"_types": ["Readable", "defaultobject"],
"read_away": false,
"read": function() { doRead (this); },
"visible": true,
"displayverbs": ["Look at", "Take"],
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["immortality_book"] = e_immortality_book;
allObjects.push(e_immortality_book);
objectsNameMap["immortality_book"] = e_immortality_book;
e_diary_vourtram = {
"elementtype": "object",
"name": "diary_vourtram",
"parent": e_magical_books,
"type": "object",
"alias": "diary",
"look": "This is the wizard's diary of Vourtram. It has details about the spells he researched to obtain his dark powers.<br/>Perhaps Dashiel could figure out an strategy against Vourtram.",
"take": true,
"feature_usegive": true,
"givesingle": true,
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"use": function() { OutputText ("It is black magic, better not use it."); },
"giveto": {"archmage": function() { OutputText ("<i>This is a great finding indeed. We could remove the powers of Vourtram by joining the power of four wizards.</i> ");
if (e_erasmus.visible) {
OutputText ("<i>Erasmus, Raffaella, Hector, and me are the four wizards. I will keep the diary, and wait for the final showdown</i>");
MoveObject (e_diary_vourtram, e_archmage);
}
else {
psay ("Raffaella, Hector, and me are three wizards, we need another wizard to perform the ritual.");
} }, "erasmus": function() { OutputText ("<i>I think Dashiel is more indicated to have this book</i> "); } },
"_js_name": "e_diary_vourtram",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["diary_vourtram"] = e_diary_vourtram;
allObjects.push(e_diary_vourtram);
objectsNameMap["diary_vourtram"] = e_diary_vourtram;
e_cauldron = {
"elementtype": "object",
"name": "cauldron",
"parent": e_lib2,
"type": "object",
"alias": "cauldron",
"look": "a standard size witch cauldron kit, with firewood and matches. {if cauldron.switchedon: The fire under the cauldron is lit.}<br/>It contains:<br/>{if oak_shield.parent=cauldron:oak ashes<br/>}{if dragon_blood.parent=cauldron:dragon blood<br/>}{if garlic.parent=cauldron:garlic<br/>}{if cauldron.cheese:a pinch of cheese<br/>}{if coconut_water.parent=cauldron:coconut water}",
"feature_usegive": true,
"feature_switchable": true,
"switchonmsg": "You use a match to turn the fire on.",
"switchoffmsg": "You put the fire off.",
"cheese": false,
"displayverbs": ["Look at", "Switch on", "Switch off"],
"alt": ["matches", "pot", "firewood"],
"useon": {"dragon_blood": function() { add_cauldron (e_dragon_blood); }, "coconut_water": function() { add_cauldron (e_coconut_water); }, "oak_shield": function() { add_cauldron (e_oak_shield); }, "cheese": function() { add_cauldron (e_cheese); }, "garlic": function() { add_cauldron (e_garlic); } },
"inventoryverbs": ["Look at", "Use", "Drop", "Switch on", "Switch off"],
"_js_name": "e_cauldron",
"_types": ["switchable", "defaultobject"],
"switchedon": false,
"turnon": function() { if (ListContains(ScopeReachable(), this)) {
if (this.switchedon) {
OutputText (overloadedFunctions.DynamicTemplate("AlreadySwitchedOn", this));
}
else {
if (HasString(this, "switchonmsg")) {
OutputText (this.switchonmsg);
}
else {
OutputText (overloadedFunctions.DynamicTemplate("SwitchedOn", this));
}
set(this, "switchedon", true);
}
}
else {
OutputText (overloadedFunctions.DynamicTemplate("DefaultTurnOn", this));
} },
"turnoff": function() { if (ListContains(ScopeReachable(), this)) {
if (!(this.switchedon)) {
OutputText (overloadedFunctions.DynamicTemplate("AlreadySwitchedOff", this));
}
else {
if (HasString(this, "switchoffmsg")) {
OutputText (this.switchoffmsg);
}
else {
OutputText (overloadedFunctions.DynamicTemplate("SwitchedOff", this));
}
set(this, "switchedon", false);
}
}
else {
OutputText (overloadedFunctions.DynamicTemplate("DefaultTurnOff", this));
} },
"visible": true,
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["cauldron"] = e_cauldron;
allObjects.push(e_cauldron);
objectsNameMap["cauldron"] = e_cauldron;
e_revert_potion = {
"elementtype": "object",
"name": "revert_potion",
"parent": e_cauldron,
"type": "object",
"look": "It is a revert potion for the side-effects of a bad immortality potion.",
"take": true,
"alias": "revert potion",
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"feature_usegive": true,
"use": true,
"givesingle": true,
"_js_name": "e_revert_potion",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["revert_potion"] = e_revert_potion;
allObjects.push(e_revert_potion);
objectsNameMap["revert_potion"] = e_revert_potion;
e_ingredients = {
"elementtype": "object",
"name": "ingredients",
"parent": e_lib2,
"type": "object",
"look": "Various magical ingredients",
"feature_container": true,
"hidechildren": true,
"listchildren": true,
"listchildrenprefix": "You may be interested in:",
"displayverbs": ["Look at"],
"usedefaultprefix": false,
"_js_name": "e_ingredients",
"_types": ["plural", "surface", "defaultobject"],
"gender": "they",
"article": "them",
"isopen": true,
"transparent": true,
"contentsprefix": "on which there is",
"container": true,
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"open": false,
"close": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"description": "",
"scenery": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["ingredients"] = e_ingredients;
allObjects.push(e_ingredients);
objectsNameMap["ingredients"] = e_ingredients;
e_dragon_blood = {
"elementtype": "object",
"name": "dragon_blood",
"parent": e_ingredients,
"type": "object",
"alias": "dragon blood",
"look": "Looks red.",
"usedefaultprefix": false,
"prefix": "a vial of ",
"alt": ["vial"],
"take": true,
"feature_usegive": true,
"use": true,
"_js_name": "e_dragon_blood",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["dragon_blood"] = e_dragon_blood;
allObjects.push(e_dragon_blood);
objectsNameMap["dragon_blood"] = e_dragon_blood;
e_coconut_water = {
"elementtype": "object",
"name": "coconut_water",
"parent": e_ingredients,
"type": "object",
"alias": "coconut water",
"look": "Brought to you by trained european's swallows.",
"usedefaultprefix": false,
"prefix": "a bottle of ",
"take": true,
"feature_usegive": true,
"use": true,
"_js_name": "e_coconut_water",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["coconut_water"] = e_coconut_water;
allObjects.push(e_coconut_water);
objectsNameMap["coconut_water"] = e_coconut_water;
e_geo_books = {
"elementtype": "object",
"name": "geo_books",
"parent": e_lib2,
"type": "object",
"scenery": true,
"alias": "geography",
"alt": ["books"],
"visible": false,
"look": "There are a dozen books with maps from all over the world. Pretty useless, right now.",
"displayverbs": ["Look at"],
"read": "ALL of them?",
"read_away": true,
"_js_name": "e_geo_books",
"_types": ["Readable", "plural", "defaultobject"],
"gender": "they",
"article": "them",
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["geo_books"] = e_geo_books;
allObjects.push(e_geo_books);
objectsNameMap["geo_books"] = e_geo_books;
e_accounting_books = {
"elementtype": "object",
"name": "accounting_books",
"parent": e_lib2,
"type": "object",
"scenery": true,
"alias": "accounting",
"alt": ["historical", "books"],
"visible": false,
"look": "Tens of books about the accounting of the kings. Beyond boring.",
"displayverbs": ["Look at"],
"read": "ALL of them?",
"read_away": true,
"_js_name": "e_accounting_books",
"_types": ["Readable", "plural", "defaultobject"],
"gender": "they",
"article": "them",
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["accounting_books"] = e_accounting_books;
allObjects.push(e_accounting_books);
objectsNameMap["accounting_books"] = e_accounting_books;
e_computer_books = {
"elementtype": "object",
"name": "computer_books",
"parent": e_lib2,
"type": "object",
"scenery": true,
"alias": "programming",
"alt": ["historical", "books"],
"visible": false,
"look": "A few books about programming languages. What type of witchcraft is programming?",
"displayverbs": ["Look at"],
"read": "ALL of them?",
"read_away": true,
"_js_name": "e_computer_books",
"_types": ["Readable", "plural", "defaultobject"],
"gender": "they",
"article": "them",
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["computer_books"] = e_computer_books;
allObjects.push(e_computer_books);
objectsNameMap["computer_books"] = e_computer_books;
e_lib1 = {
"elementtype": "object",
"name": "lib1",
"parent": e_the_castle,
"type": "object",
"alias": "dark and void room",
"_js_name": "e_lib1",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["lib1"] = e_lib1;
allObjects.push(e_lib1);
objectsNameMap["lib1"] = e_lib1;
e_k79 = {
"elementtype": "object",
"name": "k79",
"parent": e_lib1,
"type": "exit",
"alias": "north",
"_js_name": "e_k79",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k79"] = e_k79;
objectReferences.push(["e_k79", "to", "e_lib12"]);
allExits.push(e_k79);
objectsNameMap["k79"] = e_k79;
e_k80 = {
"elementtype": "object",
"name": "k80",
"parent": e_lib1,
"type": "exit",
"alias": "south",
"_js_name": "e_k80",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k80"] = e_k80;
objectReferences.push(["e_k80", "to", "e_lib12"]);
allExits.push(e_k80);
objectsNameMap["k80"] = e_k80;
e_k81 = {
"elementtype": "object",
"name": "k81",
"parent": e_lib1,
"type": "exit",
"alias": "east",
"_js_name": "e_k81",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k81"] = e_k81;
objectReferences.push(["e_k81", "to", "e_lib12"]);
allExits.push(e_k81);
objectsNameMap["k81"] = e_k81;
e_k82 = {
"elementtype": "object",
"name": "k82",
"parent": e_lib1,
"type": "exit",
"alias": "west",
"_js_name": "e_k82",
"_types": ["westdirection", "defaultexit"],
"alt": ["w"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k82"] = e_k82;
objectReferences.push(["e_k82", "to", "e_lib12"]);
allExits.push(e_k82);
objectsNameMap["k82"] = e_k82;
e_k83 = {
"elementtype": "object",
"name": "k83",
"parent": e_lib1,
"type": "exit",
"alias": "northeast",
"_js_name": "e_k83",
"_types": ["northeastdirection", "defaultexit"],
"alt": ["ne"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k83"] = e_k83;
objectReferences.push(["e_k83", "to", "e_lib12"]);
allExits.push(e_k83);
objectsNameMap["k83"] = e_k83;
e_k84 = {
"elementtype": "object",
"name": "k84",
"parent": e_lib1,
"type": "exit",
"alias": "southwest",
"_js_name": "e_k84",
"_types": ["southwestdirection", "defaultexit"],
"alt": ["sw"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k84"] = e_k84;
objectReferences.push(["e_k84", "to", "e_lib12"]);
allExits.push(e_k84);
objectsNameMap["k84"] = e_k84;
e_k85 = {
"elementtype": "object",
"name": "k85",
"parent": e_lib1,
"type": "exit",
"alias": "southeast",
"_js_name": "e_k85",
"_types": ["southeastdirection", "defaultexit"],
"alt": ["se"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k85"] = e_k85;
objectReferences.push(["e_k85", "to", "e_lib12"]);
allExits.push(e_k85);
objectsNameMap["k85"] = e_k85;
e_k86 = {
"elementtype": "object",
"name": "k86",
"parent": e_lib1,
"type": "exit",
"alias": "northwest",
"_js_name": "e_k86",
"_types": ["northwestdirection", "defaultexit"],
"alt": ["nw"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k86"] = e_k86;
objectReferences.push(["e_k86", "to", "e_lib12"]);
allExits.push(e_k86);
objectsNameMap["k86"] = e_k86;
e_libTurn = {
"elementtype": "object",
"name": "libTurn",
"parent": e_lib1,
"type": "turnscript",
"enabled": true,
"script": function() { doLibTurn(); },
"_js_name": "e_libTurn",
"_types": []
};
elementsNameMap["libTurn"] = e_libTurn;
allTurnScripts.push(e_libTurn);
objectsNameMap["libTurn"] = e_libTurn;
e_lib12 = {
"elementtype": "object",
"name": "lib12",
"parent": e_the_castle,
"type": "object",
"alias": "dark and void room",
"_js_name": "e_lib12",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["lib12"] = e_lib12;
allObjects.push(e_lib12);
objectsNameMap["lib12"] = e_lib12;
e_k87 = {
"elementtype": "object",
"name": "k87",
"parent": e_lib12,
"type": "exit",
"alias": "south",
"to": e_lib1,
"_js_name": "e_k87",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k87"] = e_k87;
allExits.push(e_k87);
objectsNameMap["k87"] = e_k87;
e_k88 = {
"elementtype": "object",
"name": "k88",
"parent": e_lib12,
"type": "exit",
"alias": "north",
"to": e_lib1,
"_js_name": "e_k88",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k88"] = e_k88;
allExits.push(e_k88);
objectsNameMap["k88"] = e_k88;
e_k89 = {
"elementtype": "object",
"name": "k89",
"parent": e_lib12,
"type": "exit",
"alias": "west",
"to": e_lib1,
"_js_name": "e_k89",
"_types": ["westdirection", "defaultexit"],
"alt": ["w"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k89"] = e_k89;
allExits.push(e_k89);
objectsNameMap["k89"] = e_k89;
e_k90 = {
"elementtype": "object",
"name": "k90",
"parent": e_lib12,
"type": "exit",
"alias": "east",
"to": e_lib1,
"_js_name": "e_k90",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k90"] = e_k90;
allExits.push(e_k90);
objectsNameMap["k90"] = e_k90;
e_k91 = {
"elementtype": "object",
"name": "k91",
"parent": e_lib12,
"type": "exit",
"alias": "southwest",
"to": e_lib1,
"_js_name": "e_k91",
"_types": ["southwestdirection", "defaultexit"],
"alt": ["sw"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k91"] = e_k91;
allExits.push(e_k91);
objectsNameMap["k91"] = e_k91;
e_k92 = {
"elementtype": "object",
"name": "k92",
"parent": e_lib12,
"type": "exit",
"alias": "northeast",
"to": e_lib1,
"_js_name": "e_k92",
"_types": ["northeastdirection", "defaultexit"],
"alt": ["ne"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k92"] = e_k92;
allExits.push(e_k92);
objectsNameMap["k92"] = e_k92;
e_k93 = {
"elementtype": "object",
"name": "k93",
"parent": e_lib12,
"type": "exit",
"alias": "northwest",
"to": e_lib1,
"_js_name": "e_k93",
"_types": ["northwestdirection", "defaultexit"],
"alt": ["nw"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k93"] = e_k93;
allExits.push(e_k93);
objectsNameMap["k93"] = e_k93;
e_k94 = {
"elementtype": "object",
"name": "k94",
"parent": e_lib12,
"type": "exit",
"alias": "southeast",
"to": e_lib1,
"_js_name": "e_k94",
"_types": ["southeastdirection", "defaultexit"],
"alt": ["se"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k94"] = e_k94;
allExits.push(e_k94);
objectsNameMap["k94"] = e_k94;
e_libTurn12 = {
"elementtype": "object",
"name": "libTurn12",
"parent": e_lib12,
"type": "turnscript",
"script": function() { doLibTurn(); },
"_js_name": "e_libTurn12",
"_types": []
};
elementsNameMap["libTurn12"] = e_libTurn12;
allTurnScripts.push(e_libTurn12);
objectsNameMap["libTurn12"] = e_libTurn12;
e_pantry = {
"elementtype": "object",
"name": "pantry",
"parent": e_the_castle,
"type": "object",
"alias": "large pantry",
"description": "The room is cool and the air filled with the smell of fresh food. Countless shelves hold supplies for a long siege. Several barrels stores various types of flour. The walls, the floor, and the ceiling are of ancient stones.",
"enter": function() { if (e_cook.parent == e_pantry) {
OutputText ("The cook is drinking from a bottle of wine. You decide to hide outside, watching where the cook hides the bottle.");
MoveObject (e_wine, e_pantry);
OutputText ("He tries to hide the {object:wine} inside a barrel of rye flour, and leaves the room smiling at you.");
MoveObject (e_cook, e_kitchen);
set(e_cook, "drinking", 0);
} },
"_js_name": "e_pantry",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["pantry"] = e_pantry;
allObjects.push(e_pantry);
objectsNameMap["pantry"] = e_pantry;
e_k95 = {
"elementtype": "object",
"name": "k95",
"parent": e_pantry,
"type": "exit",
"alias": "north",
"_js_name": "e_k95",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k95"] = e_k95;
objectReferences.push(["e_k95", "to", "e_corridor1"]);
allExits.push(e_k95);
objectsNameMap["k95"] = e_k95;
e_ptry_shelves = {
"elementtype": "object",
"name": "ptry_shelves",
"parent": e_pantry,
"type": "object",
"scenery": true,
"look": "They are full of goods.",
"alias": "shelves",
"_js_name": "e_ptry_shelves",
"_types": ["plural", "defaultobject"],
"gender": "they",
"article": "them",
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["ptry_shelves"] = e_ptry_shelves;
allObjects.push(e_ptry_shelves);
objectsNameMap["ptry_shelves"] = e_ptry_shelves;
e_ptry_barrels = {
"elementtype": "object",
"name": "ptry_barrels",
"parent": e_pantry,
"type": "object",
"look": "They are full or many different flour types.",
"scenery": true,
"alias": "barrels",
"_js_name": "e_ptry_barrels",
"_types": ["plural", "defaultobject"],
"gender": "they",
"article": "them",
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["ptry_barrels"] = e_ptry_barrels;
allObjects.push(e_ptry_barrels);
objectsNameMap["ptry_barrels"] = e_ptry_barrels;
e_ptry_food = {
"elementtype": "object",
"name": "ptry_food",
"parent": e_pantry,
"type": "object",
"scenery": true,
"alias": "food",
"look": "There are plenty of food here. However, your are not hungry.",
"_js_name": "e_ptry_food",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["ptry_food"] = e_ptry_food;
allObjects.push(e_ptry_food);
objectsNameMap["ptry_food"] = e_ptry_food;
e_ptry_flour = {
"elementtype": "object",
"name": "ptry_flour",
"parent": e_pantry,
"type": "object",
"scenery": true,
"alias": "flour",
"look": "It is just flour.",
"_js_name": "e_ptry_flour",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["ptry_flour"] = e_ptry_flour;
allObjects.push(e_ptry_flour);
objectsNameMap["ptry_flour"] = e_ptry_flour;
e_box = {
"elementtype": "object",
"name": "box",
"parent": e_pantry,
"type": "object",
"alias": "box",
"feature_container": true,
"hidechildren": false,
"look": "Something smells fishy here.",
"displayverbs": ["Look at", "Open"],
"inventoryverbs": ["Look at", "Use", "Drop", "Open", "Close"],
"_js_name": "e_box",
"_types": ["container_closed", "defaultobject"],
"open": true,
"close": true,
"container": true,
"visible": true,
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"listchildren": true,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["box"] = e_box;
allObjects.push(e_box);
objectsNameMap["box"] = e_box;
e_red_herring = {
"elementtype": "object",
"name": "red_herring",
"parent": e_box,
"type": "object",
"alias": "red herring",
"look": "A smelly dried smoked herring.",
"take": true,
"feature_usegive": true,
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"use": true,
"givesingle": true,
"useCmds": ["put"],
"selfuseon": {"vent": function() { OutputText ("You put the herring on the vent, and hears the hound approaching. The dog tries to grab the herring, but did not reach it. The jailer went down the stairs, complaining ...");
psay ("C'mon Shorty! It is not time to play, we have to watch the princess...");
MoveObject (e_jailer, e_void);
MoveObject (e_red_herring, e_void); }, "grate_dungeon": function() { OutputText ("When you approach the red herring to the door, the dog goes crazy. You think it is not advisable to call the attention of the jailer to your presence."); } },
"_js_name": "e_red_herring",
"_types": ["UseAltType", "defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["red_herring"] = e_red_herring;
allObjects.push(e_red_herring);
objectsNameMap["red_herring"] = e_red_herring;
e_garlic = {
"elementtype": "object",
"name": "garlic",
"parent": e_pantry,
"type": "object",
"alias": "clove of garlic",
"take": true,
"feature_usegive": true,
"use": true,
"givesingle": true,
"inventoryverbs": ["Look at", "Use", "Drop", "Give"],
"_js_name": "e_garlic",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["garlic"] = e_garlic;
allObjects.push(e_garlic);
objectsNameMap["garlic"] = e_garlic;
e_corridor1 = {
"elementtype": "object",
"name": "corridor1",
"parent": e_the_castle,
"type": "object",
"alias": "wide corridor",
"description": "A wide corridor made of ancient stone. To the north is the entrance to western tower, to the east is the kitchen, and to the south is the pantry.",
"_js_name": "e_corridor1",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["corridor1"] = e_corridor1;
allObjects.push(e_corridor1);
objectsNameMap["corridor1"] = e_corridor1;
e_k96 = {
"elementtype": "object",
"name": "k96",
"parent": e_corridor1,
"type": "exit",
"alias": "south",
"to": e_pantry,
"_js_name": "e_k96",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k96"] = e_k96;
allExits.push(e_k96);
objectsNameMap["k96"] = e_k96;
e_k97 = {
"elementtype": "object",
"name": "k97",
"parent": e_corridor1,
"type": "exit",
"alias": "north",
"to": e_lib_entrance,
"_js_name": "e_k97",
"_types": ["northdirection", "defaultexit"],
"alt": ["n"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k97"] = e_k97;
allExits.push(e_k97);
objectsNameMap["k97"] = e_k97;
e_k98 = {
"elementtype": "object",
"name": "k98",
"parent": e_corridor1,
"type": "exit",
"alias": "east",
"_js_name": "e_k98",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k98"] = e_k98;
objectReferences.push(["e_k98", "to", "e_kitchen"]);
allExits.push(e_k98);
objectsNameMap["k98"] = e_k98;
e_kitchen = {
"elementtype": "object",
"name": "kitchen",
"parent": e_the_castle,
"type": "object",
"usedefaultprefix": false,
"prefix": "the",
"alias": "kitchen",
"description": "The room is large and bright, with a large cabinet separating the room in two. The large stove is in the western side, and  the eastern side leads to the dining room. ",
"_js_name": "e_kitchen",
"_types": ["defaultobject"],
"visible": true,
"displayverbs": ["Look at", "Take"],
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"gender": "it",
"article": "it",
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_usegive": false,
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["kitchen"] = e_kitchen;
allObjects.push(e_kitchen);
objectsNameMap["kitchen"] = e_kitchen;
e_k99 = {
"elementtype": "object",
"name": "k99",
"parent": e_kitchen,
"type": "exit",
"alias": "west",
"to": e_corridor1,
"_js_name": "e_k99",
"_types": ["westdirection", "defaultexit"],
"alt": ["w"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k99"] = e_k99;
allExits.push(e_k99);
objectsNameMap["k99"] = e_k99;
e_exit_dining = {
"elementtype": "object",
"name": "exit_dining",
"parent": e_kitchen,
"type": "exit",
"alias": "east",
"locked": true,
"lockmessage": "There is a guard blocking this way.",
"_js_name": "e_exit_dining",
"_types": ["eastdirection", "defaultexit"],
"alt": ["e"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["exit_dining"] = e_exit_dining;
objectReferences.push(["e_exit_dining", "to", "e_dining_room"]);
allExits.push(e_exit_dining);
objectsNameMap["exit_dining"] = e_exit_dining;
e_k100 = {
"elementtype": "object",
"name": "k100",
"parent": e_kitchen,
"type": "exit",
"alias": "south",
"_js_name": "e_k100",
"_types": ["southdirection", "defaultexit"],
"alt": ["s"],
"prefix": "",
"suffix": "",
"displayverbs": ["Go"],
"visible": true,
"scenery": false,
"locked": false,
"lockmessage": "That way is locked.",
"lookonly": false,
"runscript": false,
"lightstrength": "",
"grid_length": 1,
"grid_render": false,
"grid_offset_x": 0,
"grid_offset_y": 0
};
elementsNameMap["k100"] = e_k100;
objectReferences.push(["e_k100", "to", "e_courtyard2"]);
allExits.push(e_k100);
objectsNameMap["k100"] = e_k100;
e_cook = {
"elementtype": "object",
"name": "cook",
"parent": e_kitchen,
"type": "object",
"alias": "cook",
"look": "A shorty and chubby guy, wearing cook\u00b4s uniform and a dirty apron. He looks very busy, but is a good person.",
"drinking": 0,
"feature_usegive": true,
"coins": 2,
"speak": function() { psay ("What? I\u00b4m busy... have to {ask:cook:cooking:cook} for hundreds of {ask:cook:soldiers} and thousands of {ask:cook:rats}."); },
"ask": {"rats": function() { psay ("This place is full of rats! And who knows where is the {ask:cook:exterminator} guy ... "); }, "exterminator": function() { psay ("We are paying a coin for five captured rats. Are you interested? Bring me a rat and I will give you the job."); }, "soldiers": function() { psay ("All they do are eating....day and night."); }, "food": function() { psay ("Wait with the others! food, food, food... and {ask:cook:rats}!"); }, "cook cooking": function() { psay ("Cooking all day... gosh! I need supplies! Can you watch this pot for a few moments, please?");
OutputText ("The cooks leaves the kitchen to the pantry.");
MoveObject (e_cook, e_pantry);
set(e_cook, "drinking", 5);
SetObjectFlagOff (e_kit_cabinet, "locked"); } },
"give": {"mouse": function() { psay ("Ok! you did it! The job is yours. Go to the music hall and fetch the rats there.");
OutputText ("The cook talks to the guard, that let you enter the dining room.");
UnlockExit (e_exit_dining);
MoveObject (e_mouse, e_void); } },
"_js_name": "e_cook",
"_types": ["male", "defaultobject"],
"displayverbs": ["Look at", "Speak to"],
"gender": "he",
"article": "him",
"visible": true,
"inventoryverbs": ["Look at", "Use", "Drop"],
"take": false,
"use": false,
"givesingle": false,
"drop": true,
"isopen": false,
"open": false,
"close": false,
"container": false,
"descprefix": "You are in",
"objectslistprefix": "You can see",
"exitslistprefix": "You can go",
"contentsprefix": "containing",
"description": "",
"scenery": false,
"hidechildren": false,
"listchildren": false,
"usedefaultprefix": true,
"volume": 0,
"dark": false,
"lightstrength": "",
"darklevel": false,
"grid_width": 1,
"grid_length": 1,
"grid_fill": "White",
"grid_border": "Black",
"grid_borderwidth": 1,
"grid_bordersides": 15,
"grid_render": false,
"grid_label": "",
"grid_parent_offset_auto": true,
"grid_parent_offset_x": 0,
"grid_parent_offset_y": 0,
"pov_alias": "me",
"pov_alt": ["myself", "self"],
"pov_look": "Looking good.",
"pov_gender": "you",
"pov_article": "yourself",
"feature_container": false,
"feature_switchable": false,
"feature_edible": false,
"feature_player": false,
"feature_lightdark": false,
"visited": false,
"changedparent": function(oldvalue) { if (e_game.pov == this) {
if (IsDefined("oldvalue")) {
OnEnterRoom (oldvalue);
}
else {
OnEnterRoom (null);
}
if (e_game.gridmap) {
MergePOVCoordinates();
}
} },
"changedisopen": function(oldvalue) { if (this.isopen && HasScript(this, "onopen")) {
runscriptattribute2 (this, "onopen");
}
if (!(this.isopen )&& HasScript(this, "onclose")) {
runscriptattribute2 (this, "onclose");
} },
"changedlocked": function(oldvalue) { if (this.locked && HasScript(this, "onlock")) {
runscriptattribute2 (this, "onlock");
}
if (!(this.locked )&& HasScript(this, "onunlock")) {
runscriptattribute2 (this, "onunlock");
} },
"changedswitchedon": function(oldvalue) { if (this.switchedon && HasScript(this, "onswitchon")) {
runscriptattribute2 (this, "onswitchon");
}
if (!(this.switchedon )&& HasScript(this, "onswitchoff")) {
runscriptattribute2 (this, "onswitchoff");
} }
};
elementsNameMap["cook"] = e_cook;
allObjects.push(e_cook);
objectsNameMap["cook"] = e_cook;
e_wine = {
"elementtype": "object",
"name": "wine",
"parent": e_cook,
"type": "object",
"alias": "bo