/* (c) Copyright 1987 Michael Goetz								*/
/*																			*/
/*				File:		  	sort										*/
/*				Returns:	  	void										*/
/*				Parameters:	int mode									*/
/*																			*/
/*																			*/

#include <string.h>
#include <malloc.h>
#include <search.h>

#include "advm.h"
#include "values.h"
#include "string.h"

struct item {
	int keys;
	int auxval;
	int refit;
	char zunref;
	char zname [13];
	};

int comp1(p1,p2)
struct item *p1,*p2;

{
	return (strcmp(p1->zname, p2->zname));
}

int comp2(p1, p2)
struct item *p1, *p2;

{
	return(p1->keys - p2->keys);
}

void sort(mode)
int mode;

{
	struct item *ptr, *ptr2;
	int i;

	if (!(ptr = (struct item *)malloc((symcnt+1)*sizeof(struct item))))
		{
		printf("insufficient memory for sort (%d items)",symcnt+1);
		exit(1);
		}
	for(i=0, ptr2=ptr; i<=symcnt; i++, ptr2++)
		{
		ptr2->keys = keys[i];
		ptr2->auxval = auxval[i];
		ptr2->refit = refit[i];
		ptr2->zunref = zunref[i];
		strcpy(ptr2->zname, zname[i]);
		}
	qsort((char *)ptr, symcnt+1, sizeof(struct item),
		mode ? comp2 : comp1);
	for (i=0, ptr2=ptr; i<=symcnt; i++, ptr2++)
		{
		keys[i] = ptr2->keys;
		auxval[i] = ptr2->auxval;
		refit[i] = ptr2->refit;
		zunref[i] = ptr2->zunref;
		strcpy(zname[i], ptr2->zname);
		}
	free((char *)ptr);
}

