/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ServerProxy
extends Thread
implements ARSPConstants {
    Socket sock;
    MultimediaInputOutputClient cliente;
    VersatileBufferedInputStream br;
    PrintWriter pw;
    InputStream is;
    OutputStream os;
    ArrayList requestedFiles = new ArrayList();
    private String worldDir = null;
    boolean input_thread_flag = false;

    public ServerProxy(Socket s, MultimediaInputOutputClient ioc) {
        this.sock = s;
        this.cliente = ioc;
        try {
            if (s != null) {
                this.br = new VersatileBufferedInputStream(this.sock.getInputStream());
                this.os = new BufferedOutputStream(this.sock.getOutputStream(), 100000);
                this.pw = new PrintWriter(new OutputStreamWriter(this.os)){

                    public void println(String linea) {
                        this.print(linea);
                        this.print("\r\n");
                    }
                };
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
        }
    }

    public void run() {
        try {
            String linea = "Inicial";
            while (true) {
                System.out.println("Last linea: " + linea);
                this.br.mark(500000);
                linea = this.br.readLine();
                System.out.println("Current linea: " + linea);
                this.parseMessage(linea);
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            ioe.printStackTrace();
            return;
        }
    }

    public void parseMessage(String mesg) {
        block102: {
            System.out.println("Command to parse by client-side server proxy: " + mesg);
            StringTokenizer st = new StringTokenizer(mesg, " ");
            String command = st.hasMoreTokens() ? st.nextToken().trim() : "";
            String arguments = st.hasMoreTokens() ? st.nextToken("").trim() : "";
            if (command.equalsIgnoreCase("w")) {
                this.cliente.escribir(StringMethods.textualSubstitution(arguments, "\\n", "\n"));
            } else if (command.equalsIgnoreCase("w_title")) {
                this.cliente.escribirTitulo(arguments);
            } else if (command.equalsIgnoreCase("clear_screen")) {
                this.cliente.borrarPantalla();
            } else if (command.equalsIgnoreCase("midi_init")) {
                try {
                    if (this.cliente.isSoundEnabled()) {
                        // empty if block
                    }
                    this.cliente.getSoundClient().midiInit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (command.equalsIgnoreCase("midi_preload")) {
                try {
                    if (this.cliente.isSoundEnabled()) {
                        // empty if block
                    }
                    this.cliente.getSoundClient().midiPreload(arguments);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (command.equalsIgnoreCase("midi_start")) {
                try {
                    if (this.cliente.isSoundEnabled()) {
                        // empty if block
                    }
                    if (arguments != null && !arguments.equals("")) {
                        this.cliente.getSoundClient().midiStart(arguments);
                        break block102;
                    }
                    this.cliente.getSoundClient().midiStart();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (command.equalsIgnoreCase("midi_open")) {
                try {
                    if (this.cliente.isSoundEnabled()) {
                        // empty if block
                    }
                    this.cliente.getSoundClient().midiOpen(arguments);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (command.equalsIgnoreCase("midi_stop")) {
                if (this.cliente.isSoundEnabled()) {
                    // empty if block
                }
                this.cliente.getSoundClient().midiStop();
            } else if (command.equalsIgnoreCase("midi_close")) {
                if (this.cliente.isSoundEnabled()) {
                    // empty if block
                }
                this.cliente.getSoundClient().midiClose();
            } else if (command.equalsIgnoreCase("audio_preload")) {
                try {
                    if (this.cliente.isSoundEnabled()) {
                        // empty if block
                    }
                    this.cliente.getSoundClient().audioPreload(arguments);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (command.equalsIgnoreCase("audio_unload")) {
                try {
                    if (this.cliente.isSoundEnabled()) {
                        // empty if block
                    }
                    this.cliente.getSoundClient().audioUnload(arguments);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (command.equalsIgnoreCase("audio_stop")) {
                if (this.cliente.isSoundEnabled()) {
                    // empty if block
                }
                this.cliente.getSoundClient().audioStop(arguments);
            } else if (command.equalsIgnoreCase("audio_start")) {
                try {
                    if (this.cliente.isSoundEnabled()) {
                        // empty if block
                    }
                    this.cliente.getSoundClient().audioStart(arguments);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (command.equalsIgnoreCase("force_input")) {
                StringTokenizer argTok = new StringTokenizer(arguments, " ");
                String outputEnabled = argTok.nextToken();
                String inputText = argTok.nextToken("").trim();
                this.cliente.forzarEntrada(inputText, Boolean.valueOf(outputEnabled));
            } else if (command.equalsIgnoreCase("g")) {
                System.out.println("Input get command");
                if (!this.input_thread_flag) {
                    System.out.println("Spawning input-returning thread");
                    this.input_thread_flag = true;
                    Thread th = new Thread(){

                        public void run() {
                            System.out.println("getInput called");
                            String s = ServerProxy.this.cliente.getInput(null);
                            ServerProxy.this.pw.println("gr " + s);
                            ServerProxy.this.pw.flush();
                            ServerProxy.this.input_thread_flag = false;
                        }
                    };
                    th.start();
                }
            } else if (command.equalsIgnoreCase("icon")) {
                if (this.cliente.isGraphicsEnabled()) {
                    StringTokenizer argTok = new StringTokenizer(arguments, " ");
                    String head = argTok.nextToken();
                    String tail = argTok.nextToken("").trim();
                    if (head.equalsIgnoreCase("centered")) {
                        this.cliente.insertCenteredIcon(tail);
                    } else {
                        this.cliente.insertIcon(arguments);
                    }
                }
            } else if (command.equalsIgnoreCase("wait_key_press")) {
                this.cliente.waitKeyPress();
                this.pw.println("key_pressed");
                this.pw.flush();
            } else if (command.equalsIgnoreCase("client_type_request")) {
                this.pw.println("client_type_reply sound images color title :ServerProxy for generic MultimediaInputOutputClient");
                System.out.println("Client type reply sent.\n");
                this.pw.flush();
            } else if (command.equalsIgnoreCase("colorcode_request")) {
                System.out.println("COLORCODE REQUEST COMMAND FOUND!" + this.cliente.getColorCode("description"));
                this.pw.println("colorcode_info_begin");
                this.pw.println("colorcode_info_line description " + this.cliente.getColorCode("description"));
                this.pw.println("colorcode_info_line input " + this.cliente.getColorCode("input"));
                this.pw.println("colorcode_info_line error " + this.cliente.getColorCode("error"));
                this.pw.println("colorcode_info_line information " + this.cliente.getColorCode("information"));
                this.pw.println("colorcode_info_line denial " + this.cliente.getColorCode("denial"));
                this.pw.println("colorcode_info_line action " + this.cliente.getColorCode("action"));
                this.pw.println("colorcode_info_line default " + this.cliente.getColorCode("default"));
                this.pw.println("colorcode_info_end");
                this.pw.flush();
            } else if (command.equalsIgnoreCase("world_dir")) {
                this.worldDir = arguments;
            } else if (command.equalsIgnoreCase("visualconf_init_begin")) {
                String xmlText = "";
                boolean terminamos = false;
                while (!terminamos) {
                    String linea;
                    try {
                        System.out.println("Tryin' to read newline:");
                        linea = this.br.readLine();
                        System.out.println("Line read, " + linea);
                    }
                    catch (IOException ioe) {
                        System.out.println("Exception (0) " + ioe);
                        break;
                    }
                    StringTokenizer sto = new StringTokenizer(linea);
                    String token = sto.nextToken();
                    if (token.equalsIgnoreCase("visualconf_init_line")) {
                        xmlText = String.valueOf(xmlText) + sto.nextToken("").trim();
                        xmlText = String.valueOf(xmlText) + "\n";
                        continue;
                    }
                    if (token.equalsIgnoreCase("visualconf_init_end")) {
                        terminamos = true;
                        continue;
                    }
                    System.out.println("Callin' emergency parseMessage recursion.");
                    this.parseMessage(linea);
                }
                System.out.println("Gonna create 'doc.\n");
                Document d = null;
                try {
                    BufferedReader br2 = new BufferedReader(new StringReader(xmlText));
                    InputSource is = new InputSource(br2);
                    DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    d = db.parse(is);
                }
                catch (ParserConfigurationException pce) {
                    System.out.println(pce);
                }
                catch (SAXException se) {
                    System.out.println(se);
                }
                catch (IOException ioe) {
                    System.out.println("ServerProxy throws: ");
                    System.out.println(ioe);
                    ioe.printStackTrace();
                    System.out.println("When text was " + xmlText);
                }
                System.out.println("Doc " + d + " created.");
                if (d != null) {
                    try {
                        VisualConfiguration vc = new VisualConfiguration(d.getDocumentElement(), this.worldDir);
                        if (this.cliente instanceof ColoredSwingClient) {
                            ((ColoredSwingClient)this.cliente).setVisualConfiguration(vc);
                        }
                        System.out.println("Visconf set.");
                    }
                    catch (XMLtoWorldException vc) {
                        // empty catch block
                    }
                }
                System.out.println("Returnin' from parseMessage()\n");
            } else if (command.equalsIgnoreCase("file_list_begin")) {
                boolean terminamos = false;
                Vector<String> ficheros = new Vector<String>();
                System.out.println("File list begin.");
                while (!terminamos) {
                    String linea;
                    try {
                        linea = this.br.readLine();
                    }
                    catch (IOException ioe) {
                        System.out.println(ioe);
                        ioe.printStackTrace();
                        break;
                    }
                    StringTokenizer sto = new StringTokenizer(linea);
                    String token = sto.nextToken();
                    if (token.equalsIgnoreCase("file_list_line")) {
                        ficheros.add(sto.nextToken("").trim());
                        continue;
                    }
                    if (token.equalsIgnoreCase("file_list_end")) {
                        terminamos = true;
                        this.requestUserSelectedFiles(ficheros);
                        continue;
                    }
                    System.out.println("Callin' emergency parseMessage recursion.");
                    this.parseMessage(linea);
                }
            } else if (command.equalsIgnoreCase("file_header_line")) {
                System.out.println("File header line.");
                StringTokenizer argTok = new StringTokenizer(arguments, " ");
                String remoteName = argTok.nextToken();
                int byteSize = Integer.valueOf(argTok.nextToken());
                boolean ficheroDeseado = false;
                int i = 0;
                while (i < this.requestedFiles.size()) {
                    StringTokenizer st2 = new StringTokenizer((String)this.requestedFiles.get(i));
                    String filename = st2.nextToken();
                    if (filename.equals(remoteName)) {
                        ficheroDeseado = true;
                        break;
                    }
                    ++i;
                }
                char[] charArray = new char[byteSize];
                byte[] byteArray = new byte[byteSize];
                try {
                    int lei = 0;
                    System.out.println("LASTREAD: " + mesg);
                    System.out.println("Reading file from socket.");
                    System.out.println("To read " + byteArray.length + " bytes from input stream.");
                    while (lei < byteArray.length) {
                        lei += this.br.read(byteArray, lei, byteSize - lei);
                        System.out.println(String.valueOf(lei) + " bytes read.");
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return;
                }
                System.out.println("Writin' actual file.");
                try {
                    FileOutputStream fos = new FileOutputStream(remoteName);
                    OutputStreamWriter osw = new OutputStreamWriter(fos);
                    fos.write(byteArray);
                    fos.flush();
                    fos.close();
                    this.cliente.escribir(String.valueOf(this.cliente.getColorCode("information")) + "Descargado con \u00e9xito " + remoteName + " (" + byteSize + " bytes)\n" + this.cliente.getColorCode("reset"));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            } else if (command.equalsIgnoreCase("unrecognized_message")) {
                System.out.println("Protocol error!");
            } else {
                System.out.println("I'm the ServerProxy and I can't recognize " + command);
                this.pw.println("unrecognized_message " + command);
                this.pw.flush();
            }
        }
    }

    public void requestServerFiles(List fnames) {
        int i = 0;
        while (i < fnames.size()) {
            String fName = (String)fnames.get(i);
            this.pw.println("get_file " + fName);
            this.pw.flush();
            ++i;
        }
        this.requestedFiles.addAll(fnames);
    }

    public void requestUserSelectedFiles(final Vector ficheros) {
        final JDialog jd = new JDialog();
        jd.setModal(true);
        jd.setTitle("Ficheros");
        jd.setSize(500, 500);
        jd.getContentPane().setLayout(new BorderLayout());
        final JList jl = new JList(ficheros);
        int i = 0;
        while (i < ficheros.size()) {
            StringTokenizer st1 = new StringTokenizer((String)ficheros.get(i));
            String fileName = st1.nextToken();
            File theFile = new File(fileName);
            if (!theFile.exists()) {
                jl.setSelectedValue(ficheros.get(i), false);
            }
            ++i;
        }
        jd.getContentPane().add((Component)new JLabel("El servidor ofrece los siguientes ficheros:"), "North");
        jd.getContentPane().add((Component)new JScrollPane(jl), "Center");
        JPanel jp = new JPanel();
        JButton b1 = new JButton("Descargar todos");
        JButton b2 = new JButton("Descargar seleccionados");
        JButton b3 = new JButton("No descargar ninguno");
        b1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerProxy.this.requestServerFiles(ficheros);
                jd.dispose();
            }
        });
        b2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vector seleccionados = new Vector();
                int i = 0;
                while (i < ficheros.size()) {
                    if (jl.isSelectedIndex(i)) {
                        seleccionados.add(ficheros.get(i));
                    }
                    ++i;
                }
                ServerProxy.this.requestServerFiles(seleccionados);
                jd.dispose();
            }
        });
        b3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                jd.dispose();
            }
        });
        jp.add(b1);
        jp.add(b2);
        jp.add(b3);
        jd.getContentPane().add((Component)jp, "South");
        System.out.println("Size of list: " + ficheros.size());
        jd.pack();
        jd.setVisible(true);
    }
}

