/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import micromod.MicroMod;
import micromod.Module;
import micromod.ModuleLoader;
import micromod.output.JavaSoundOutputDevice;
import micromod.output.PCM16StreamOutputDevice;
import micromod.output.converters.AudioFormatConverter;
import micromod.output.converters.SS16LEAudioFormatConverter;
import micromod.resamplers.LinearResampler;
import micromod.resamplers.Resampler;

public class ModTest {
    PlayerThread pt;

    boolean playMOD(File f, int iRepeat, int soundId, int iNotify) throws Exception {
        JavaSoundOutputDevice out = new JavaSoundOutputDevice((AudioFormatConverter)new SS16LEAudioFormatConverter(), 44100, 1000);
        Module module = ModuleLoader.read((DataInput)new DataInputStream(new FileInputStream(f)));
        MicroMod microMod = new MicroMod(module, (PCM16StreamOutputDevice)out, (Resampler)new LinearResampler());
        MODThread mt = new MODThread(microMod, out, iRepeat, soundId, iNotify);
        this.pt = mt;
        this.pt.setVolume(65536);
        mt.start();
        return true;
    }

    class MODThread
    extends Thread
    implements PlayerThread {
        int soundId;
        int iNotify;
        int iRepeat;
        boolean running;
        boolean stopped;
        JavaSoundOutputDevice out;
        MicroMod mm;

        MODThread(MicroMod mm, JavaSoundOutputDevice out, int iRepeat, int soundId, int iNotify) {
            this.mm = mm;
            this.out = out;
            this.soundId = soundId;
            this.iNotify = iNotify;
            this.iRepeat = iRepeat;
            this.running = false;
            this.stopped = false;
        }

        public synchronized void setVolume(int vol) {
            SourceDataLine l = this.out.getLine();
            FloatControl ctl = (FloatControl)l.getControl(FloatControl.Type.MASTER_GAIN);
            double gain = (double)vol / 65536.0;
            float dB = (float)(Math.log(gain) / Math.log(10.0) * 20.0);
            if (ctl != null) {
                ctl.setValue(dB);
            }
        }

        public synchronized void stopPlaying() {
            if (!this.stopped) {
                this.running = false;
                this.stopped = true;
                this.out.stop();
                this.out.close();
            }
        }

        synchronized void donePlaying() {
            ModTest.this.pt = null;
        }

        public void run() {
            this.out.start();
            int i = 0;
            while (!(this.stopped || this.iRepeat != -1 && i >= this.iRepeat)) {
                this.running = true;
                this.mm.setCurrentPatternPos(0);
                while (this.running && this.mm.getSequenceLoopCount() == 0) {
                    MODThread mODThread = this;
                    synchronized (mODThread) {
                        System.out.println("Real Time.");
                        this.mm.doRealTimePlayback();
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                ++i;
            }
            MODThread mODThread = this;
            synchronized (mODThread) {
                if (!this.stopped) {
                    this.running = false;
                    this.out.stop();
                    this.out.close();
                    this.donePlaying();
                }
            }
        }
    }
}

