/*
 * Decompiled with CFR 0.152.
 */
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;

public class CodeRunner {
    private final int INIT = 0;
    private final int DATA = 1;
    private final int CODE = 2;
    private final int NONE = -1;
    private final int MAXSEGMENT = 1024;
    private String[] r = new String[100];
    private String exc = new String();
    private String obj = new String();
    private String[] a = new String[10];
    private String[] v = new String[10];
    private String ra;
    private int program_counter;
    private String[][] segmento = new String[3][];
    int[] cont = new int[3];
    private World ourWorld;
    private Stack asmStack;
    boolean continue_flag = false;

    public CodeRunner(String theCode, World theWorld) throws EVASyntaxException {
        this.ourWorld = theWorld;
        StringTokenizer lineas = new StringTokenizer(theCode, "\n");
        this.segmento = new String[3][1024];
        int cursegment = -1;
        while (lineas.hasMoreTokens()) {
            String lineaActual = lineas.nextToken();
            StringTokenizer palabrasEnLinea = new StringTokenizer(lineaActual, " ");
            if (!palabrasEnLinea.hasMoreTokens()) continue;
            String primeraPalabra = palabrasEnLinea.nextToken().trim();
            if (primeraPalabra.equalsIgnoreCase(".INIT")) {
                cursegment = 0;
                continue;
            }
            if (primeraPalabra.equalsIgnoreCase(".DATA")) {
                cursegment = 1;
                continue;
            }
            if (primeraPalabra.equalsIgnoreCase(".CODE")) {
                cursegment = 2;
                continue;
            }
            if (cursegment == -1) {
                throw new EVASyntaxException("Lines of code without a segment");
            }
            this.segmento[cursegment][this.cont[cursegment]] = lineaActual;
            int n = cursegment;
            this.cont[n] = this.cont[n] + 1;
        }
    }

    public boolean runCode(String theCode, String routine, String dataSegment) throws EVASyntaxException, EVASemanticException {
        this.addToDataSegment(dataSegment);
        return this.runCode(theCode, routine);
    }

    public boolean runCode(String theCode, String routine) throws EVASyntaxException, EVASemanticException {
        int curlimit = this.cont[0];
        int i = 0;
        while (i < curlimit) {
            StringTokenizer initTokenizer = new StringTokenizer(this.segmento[0][i], ":");
            if (initTokenizer.countTokens() < 2) {
                throw new EVASyntaxException("Too few tokens with : at INIT segment, line " + i + " (" + this.segmento[0][i] + ")");
            }
            String reg = initTokenizer.nextToken().trim();
            String string = initTokenizer.nextToken().trim();
            ++i;
        }
        this.program_counter = this.getLine(routine, 2);
        if (this.program_counter == -1) {
            return false;
        }
        while (this.runNextInstruction()) {
        }
        if (!this.continue_flag) {
            return true;
        }
        this.continue_flag = false;
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean runNextInstruction() throws EVASyntaxException, EVASemanticException {
        block135: {
            block138: {
                block129: {
                    block137: {
                        block136: {
                            instruccion = this.segmento[2][this.program_counter];
                            st = new StringTokenizer(instruccion, " \t,");
                            if (!st.hasMoreTokens()) break block135;
                            codop = st.nextToken().trim();
                            if (codop.charAt(codop.length() - 1) == ':') {
                                codop = st.hasMoreTokens() != false ? st.nextToken().trim() : "nop";
                            }
                            if (codop.equalsIgnoreCase("end")) {
                                return false;
                            }
                            if (codop.equalsIgnoreCase("continue") || codop.equalsIgnoreCase("resume")) {
                                this.continue_flag = true;
                                return false;
                            }
                            if (!codop.equalsIgnoreCase("nop") && !codop.equalsIgnoreCase("noop") && !codop.equalsIgnoreCase("skip")) break block136;
                            ++this.program_counter;
                            break block135;
                        }
                        if (!codop.equalsIgnoreCase("ld") && !codop.equalsIgnoreCase("load")) break block137;
                        if (st.countTokens() < 2) {
                            throw new EVASyntaxException("Invalid instruction format, code line " + this.program_counter);
                        }
                        reg = st.nextToken().trim();
                        label = st.nextToken().trim();
                        try {
                            this.setReg(reg, this.getMem(label));
                        }
                        catch (EVASyntaxException e) {
                            throw new EVASyntaxException(String.valueOf(e.getMessage()) + ", line " + this.program_counter);
                        }
                        ++this.program_counter;
                        break block135;
                    }
                    if (!codop.equalsIgnoreCase("li") && !codop.equalsIgnoreCase("loadi")) break block138;
                    if (st.countTokens() < 2) {
                        throw new EVASyntaxException("Invalid instruction format, code line " + this.program_counter);
                    }
                    reg = st.nextToken().trim();
                    val = "";
                    block40: while (true) {
                        try {
                            val = String.valueOf(val) + st.nextToken("\u00e7");
                            val = String.valueOf(val) + "\u00e7";
                        }
                        catch (NoSuchElementException e) {
                            val = val.substring(0, val.length() - 1);
lbl41:
                            // 2 sources

                            while (val.charAt(0) == ',' || val.charAt(0) == ' ' || val.charAt(0) == '\t') {
                                break block40;
                            }
                            break block129;
                        }
                    }
                    val = val.substring(1);
                    ** GOTO lbl41
                }
                try {
                    this.setReg(reg, val);
                }
                catch (EVASyntaxException e) {
                    throw new EVASyntaxException(String.valueOf(e.getMessage()) + ", line " + this.program_counter);
                }
                ++this.program_counter;
                break block135;
            }
            if (codop.equalsIgnoreCase("sd") || codop.equalsIgnoreCase("store") || codop.equalsIgnoreCase("stor")) {
                if (st.countTokens() < 2) {
                    throw new EVASyntaxException("Invalid instruction format, code line " + this.program_counter);
                }
                reg = st.nextToken().trim();
                label = st.nextToken().trim();
                try {
                    this.setMem(label, this.getReg(reg));
                }
                catch (EVASyntaxException e) {
                    throw new EVASyntaxException(String.valueOf(e.getMessage()) + ", line " + this.program_counter);
                }
                ++this.program_counter;
            } else if (codop.equalsIgnoreCase("mov") || codop.equalsIgnoreCase("mv") || codop.equalsIgnoreCase("move")) {
                if (st.countTokens() < 2) {
                    throw new EVASyntaxException("Invalid instruction format, code line " + this.program_counter);
                }
                rt = st.nextToken().trim();
                rs = st.nextToken().trim();
                try {
                    this.setReg(rt, this.getReg(rs));
                }
                catch (EVASyntaxException e) {
                    throw new EVASyntaxException(String.valueOf(e.getMessage()) + ", line " + this.program_counter);
                }
                ++this.program_counter;
            } else if (codop.equalsIgnoreCase("add") || codop.equalsIgnoreCase("sub") || codop.equalsIgnoreCase("mult") || codop.equalsIgnoreCase("mul") || codop.equalsIgnoreCase("div")) {
                if (st.countTokens() < 3) {
                    throw new EVASyntaxException("Invalid instruction format, code line " + this.program_counter);
                }
                rd = st.nextToken().trim();
                rs = st.nextToken().trim();
                rt = st.nextToken().trim();
                try {
                    operando1 = Integer.valueOf(this.getReg(rs));
                    operando2 = Integer.valueOf(this.getReg(rt));
                    try {
                        if (codop.equalsIgnoreCase("add")) {
                            this.setReg(rd, String.valueOf(operando1 + operando2));
                        }
                        if (codop.equalsIgnoreCase("sub")) {
                            this.setReg(rd, String.valueOf(operando1 - operando2));
                        }
                        if (codop.equalsIgnoreCase("mul") || codop.equalsIgnoreCase("mult")) {
                            this.setReg(rd, String.valueOf(operando1 * operando2));
                        }
                        if (codop.equalsIgnoreCase("div")) {
                            this.setReg(rd, String.valueOf(operando1 / operando2));
                            if (operando2 == 0) {
                                this.setReg("$Exc", "DivisionByZero");
                                this.setReg(rd, "0");
                            }
                        }
                    }
                    catch (EVASyntaxException e) {
                        throw new EVASyntaxException(String.valueOf(e.getMessage()) + ", line " + this.program_counter);
                    }
                }
                catch (NumberFormatException en) {
                    this.setReg("$Exc", "NotANumber");
                    this.setReg(rd, "0");
                }
                ++this.program_counter;
            } else if (codop.equalsIgnoreCase("and") || codop.equalsIgnoreCase("or")) {
                if (st.countTokens() < 3) {
                    throw new EVASyntaxException("Invalid instruction format, code line " + this.program_counter);
                }
                rd = st.nextToken().trim();
                rs = st.nextToken().trim();
                rt = st.nextToken().trim();
                try {
                    operando1 = Integer.valueOf(this.getReg(rs));
                    operando2 = Integer.valueOf(this.getReg(rt));
                    try {
                        if (codop.equalsIgnoreCase("and")) {
                            this.setReg(rd, String.valueOf(operando1 & operando2));
                        }
                        if (codop.equalsIgnoreCase("or")) {
                            this.setReg(rd, String.valueOf(operando1 | operando2));
                        }
                    }
                    catch (EVASyntaxException e) {
                        throw new EVASyntaxException(String.valueOf(e.getMessage()) + ", line " + this.program_counter);
                    }
                }
                catch (NumberFormatException en) {
                    this.setReg("$Exc", "NotANumber");
                    this.setReg(rd, "0");
                }
                ++this.program_counter;
            } else if (codop.equalsIgnoreCase("fadd") || codop.equalsIgnoreCase("fsub") || codop.equalsIgnoreCase("fmult") || codop.equalsIgnoreCase("fmul") || codop.equalsIgnoreCase("fdiv")) {
                if (st.countTokens() < 3) {
                    throw new EVASyntaxException("Invalid instruction format, code line " + this.program_counter);
                }
                rd = st.nextToken().trim();
                rs = st.nextToken().trim();
                rt = st.nextToken().trim();
                try {
                    operando1 = Double.valueOf(this.getReg(rs));
                    operando2 = Double.valueOf(this.getReg(rt));
                    try {
                        if (codop.equalsIgnoreCase("fadd")) {
                            this.setReg(rd, String.valueOf(operando1 + operando2));
                        }
                        if (codop.equalsIgnoreCase("fsub")) {
                            this.setReg(rd, String.valueOf(operando1 - operando2));
                        }
                        if (codop.equalsIgnoreCase("fmul") || codop.equalsIgnoreCase("fmult")) {
                            this.setReg(rd, String.valueOf(operando1 * operando2));
                        }
                        if (codop.equalsIgnoreCase("fdiv")) {
                            this.setReg(rd, String.valueOf(operando1 / operando2));
                            if (operando2 == 0.0) {
                                this.setReg("$Exc", "DivisionByZero");
                                this.setReg(rd, "0");
                            }
                        }
                    }
                    catch (EVASyntaxException e) {
                        throw new EVASyntaxException(String.valueOf(e.getMessage()) + ", line " + this.program_counter);
                    }
                }
                catch (NumberFormatException en) {
                    this.setReg("$Exc", "NotANumber");
                    this.setReg(rd, "0");
                }
                ++this.program_counter;
            } else if (codop.equalsIgnoreCase("addi") || codop.equalsIgnoreCase("subi") || codop.equalsIgnoreCase("multi") || codop.equalsIgnoreCase("muli") || codop.equalsIgnoreCase("divi")) {
                if (st.countTokens() < 3) {
                    throw new EVASyntaxException("Invalid instruction format, code line " + this.program_counter);
                }
                rd = st.nextToken().trim();
                rs = st.nextToken().trim();
                imm = st.nextToken().trim();
                try {
                    operando1 = Integer.valueOf(this.getReg(rs));
                    operando2 = Integer.valueOf(imm);
                    try {
                        if (codop.equalsIgnoreCase("addi")) {
                            this.setReg(rd, String.valueOf(operando1 + operando2));
                        }
                        if (codop.equalsIgnoreCase("subi")) {
                            this.setReg(rd, String.valueOf(operando1 - operando2));
                        }
                        if (codop.equalsIgnoreCase("muli") || codop.equalsIgnoreCase("multi")) {
                            this.setReg(rd, String.valueOf(operando1 * operando2));
                        }
                        if (codop.equalsIgnoreCase("divi")) {
                            this.setReg(rd, String.valueOf(operando1 / operando2));
                            if (operando2 == 0) {
                                this.setReg("$Exc", "DivisionByZero");
                                this.setReg(rd, "0");
                            }
                        }
                    }
                    catch (EVASyntaxException e) {
                        throw new EVASyntaxException(String.valueOf(e.getMessage()) + ", line " + this.program_counter);
                    }
                }
                catch (NumberFormatException en) {
                    this.setReg("$Exc", "NotANumber");
                    this.setReg(rd, "0");
                }
                ++this.program_counter;
            } else if (codop.equalsIgnoreCase("faddi") || codop.equalsIgnoreCase("fsubi") || codop.equalsIgnoreCase("fmulti") || codop.equalsIgnoreCase("fmuli") || codop.equalsIgnoreCase("fdivi")) {
                if (st.countTokens() < 3) {
                    throw new EVASyntaxException("Invalid instruction format, code line " + this.program_counter);
                }
                rd = st.nextToken().trim();
                rs = st.nextToken().trim();
                imm = st.nextToken().trim();
                try {
                    operando1 = Double.valueOf(this.getReg(rs));
                    operando2 = Double.valueOf(imm);
                    try {
                        if (codop.equalsIgnoreCase("faddi")) {
                            this.setReg(rd, String.valueOf(operando1 + operando2));
                        }
                        if (codop.equalsIgnoreCase("fsubi")) {
                            this.setReg(rd, String.valueOf(operando1 - operando2));
                        }
                        if (codop.equalsIgnoreCase("fmuli") || codop.equalsIgnoreCase("fmulti")) {
                            this.setReg(rd, String.valueOf(operando1 * operando2));
                        }
                        if (codop.equalsIgnoreCase("fdivi")) {
                            this.setReg(rd, String.valueOf(operando1 / operando2));
                            if (operando2 == 0.0) {
                                this.setReg("$Exc", "DivisionByZero");
                                this.setReg(rd, "0");
                            }
                        }
                    }
                    catch (EVASyntaxException e) {
                        throw new EVASyntaxException(String.valueOf(e.getMessage()) + ", line " + this.program_counter);
                    }
                }
                catch (NumberFormatException en) {
                    this.setReg("$Exc", "NotANumber");
                    this.setReg(rd, "0");
                }
                ++this.program_counter;
            } else if (codop.equalsIgnoreCase("bne") || codop.equalsIgnoreCase("beq") || codop.equalsIgnoreCase("bge") || codop.equalsIgnoreCase("bgt") || codop.equalsIgnoreCase("ble") || codop.equalsIgnoreCase("blt")) {
                if (st.countTokens() < 3) {
                    throw new EVASyntaxException("Invalid instruction format, code line " + this.program_counter);
                }
                r1 = st.nextToken().trim();
                r2 = st.nextToken().trim();
                label = st.nextToken().trim();
                condition = false;
                try {
                    operando1 = Integer.valueOf(this.getReg(r1));
                    operando2 = Integer.valueOf(this.getReg(r2));
                    if (codop.equalsIgnoreCase("bne")) {
                        condition = operando1 != operando2;
                    } else if (codop.equalsIgnoreCase("beq")) {
                        condition = operando1 == operando2;
                    } else if (codop.equalsIgnoreCase("bge")) {
                        condition = operando1 >= operando2;
                    } else if (codop.equalsIgnoreCase("bgt")) {
                        condition = operando1 > operando2;
                    } else if (codop.equalsIgnoreCase("ble")) {
                        condition = operando1 <= operando2;
                    } else if (codop.equalsIgnoreCase("blt")) {
                        condition = operando1 < operando2;
                    }
                }
                catch (NumberFormatException en) {
                    if (codop.equalsIgnoreCase("beq")) {
                        condition = this.getReg(r1).equals(this.getReg(r2));
                    }
                    if (codop.equalsIgnoreCase("bne")) {
                        condition = this.getReg(r1).equals(this.getReg(r2)) == false;
                    }
                    this.setReg("$Exc", "NotANumber");
                    condition = false;
                }
                if (condition) {
                    direccion_salto = this.getLine(label, 2);
                    if (direccion_salto < 0) {
                        ++this.program_counter;
                        throw new EVASyntaxException("Jump address not found, code line " + this.program_counter);
                    }
                    this.program_counter = direccion_salto;
                } else {
                    ++this.program_counter;
                }
            } else if (codop.equalsIgnoreCase("j") || codop.equalsIgnoreCase("goto")) {
                if (!st.hasMoreTokens()) {
                    throw new EVASyntaxException("Invalid instruction format, code line " + this.program_counter);
                }
                label = st.nextToken();
                direccion_salto = this.getLine(label, 2);
                if (direccion_salto < 0) {
                    ++this.program_counter;
                    throw new EVASyntaxException("Jump address not found, code line " + this.program_counter);
                }
                this.program_counter = direccion_salto;
            } else if (codop.equalsIgnoreCase("jal")) {
                if (!st.hasMoreTokens()) {
                    throw new EVASyntaxException("Invalid instruction format, code line " + this.program_counter);
                }
                label = st.nextToken();
                direccion_salto = this.getLine(label, 2);
                if (direccion_salto < 0) {
                    ++this.program_counter;
                    throw new EVASyntaxException("Jump address not found, code line " + this.program_counter);
                }
                this.setReg("$ra", String.valueOf(this.program_counter));
                this.program_counter = direccion_salto;
            } else if (codop.equalsIgnoreCase("return")) {
                try {
                    direccion_salto = Integer.valueOf(this.getReg("$ra"));
                }
                catch (NumberFormatException nf) {
                    throw new EVASyntaxException("Invalid call to return, code line " + this.program_counter);
                }
                this.program_counter = direccion_salto;
            } else if (codop.equalsIgnoreCase("push")) {
                if (st.countTokens() < 1) {
                    throw new EVASyntaxException("Invalid instruction format, code line " + this.program_counter);
                }
                reg = st.nextToken().trim();
                try {
                    content = this.getReg(reg);
                }
                catch (EVASyntaxException e) {
                    throw new EVASyntaxException(String.valueOf(e.getMessage()) + ", line " + this.program_counter);
                }
                this.asmStack.push(content);
                ++this.program_counter;
            } else if (codop.equalsIgnoreCase("pop")) {
                if (st.countTokens() < 1) {
                    throw new EVASyntaxException("Invalid instruction format, code line " + this.program_counter);
                }
                reg = st.nextToken().trim();
                content = (String)this.asmStack.pop();
                try {
                    this.setReg(reg, content);
                }
                catch (EVASyntaxException e) {
                    throw new EVASyntaxException(String.valueOf(e.getMessage()) + ", line " + this.program_counter);
                }
                ++this.program_counter;
            } else {
                if (codop.equalsIgnoreCase("exc") || codop.equalsIgnoreCase("exception") || codop.equalsIgnoreCase("throw")) {
                    throw new EVASemanticException(this.exc, this.program_counter);
                }
                if (codop.equalsIgnoreCase("fun") || codop.equalsIgnoreCase("function")) {
                    instructionParameters = "";
                    while (st.hasMoreTokens()) {
                        instructionParameters = st.nextToken();
                    }
                    try {
                        this.execFunction(instructionParameters);
                    }
                    catch (EVASyntaxException e) {
                        throw new EVASyntaxException(String.valueOf(e.getMessage()) + ", line " + this.program_counter);
                    }
                    ++this.program_counter;
                } else {
                    throw new EVASyntaxException("Unidentified instruction [" + codop + "]" + ", code line " + this.program_counter);
                }
            }
        }
        return true;
    }

    private void setReg(String reg, String val) throws EVASyntaxException {
        String actual = reg;
        if (reg.charAt(0) != '$') {
            throw new EVASyntaxException("Register must start with dollar sign");
        }
        if ((actual = actual.substring(1, actual.length())).substring(0, 2).equalsIgnoreCase("ra")) {
            this.ra = val;
        } else if (actual.charAt(0) == 'r') {
            actual = actual.substring(1, actual.length());
            try {
                int regnum = Integer.valueOf(actual);
                this.r[regnum] = val;
            }
            catch (NumberFormatException NumExc) {
                throw new EVASyntaxException("Wrong register format.");
            }
        } else if (actual.charAt(0) == 'v') {
            actual = actual.substring(1, actual.length());
            try {
                int regnum = Integer.valueOf(actual);
                this.v[regnum] = val;
            }
            catch (NumberFormatException NumExc) {
                throw new EVASyntaxException("Wrong register format");
            }
        } else if (actual.charAt(0) == 'a') {
            actual = actual.substring(1, actual.length());
            try {
                int regnum = Integer.valueOf(actual);
                this.a[regnum] = val;
            }
            catch (NumberFormatException NumExc) {
                throw new EVASyntaxException("Wrong register format");
            }
        } else if (actual.substring(0, 3).equalsIgnoreCase("exc")) {
            this.exc = val;
        } else if (actual.substring(0, 3).equalsIgnoreCase("obj")) {
            this.obj = val;
        } else {
            throw new EVASyntaxException("Wrong register format");
        }
    }

    private String getReg(String reg) throws EVASyntaxException {
        String actual = reg;
        if (reg.charAt(0) != '$') {
            throw new EVASyntaxException("Register must start with dollar sign");
        }
        if ((actual = actual.substring(1, actual.length())).substring(0, 2).equalsIgnoreCase("ra")) {
            return this.ra;
        }
        if (actual.charAt(0) == 'r') {
            actual = actual.substring(1, actual.length());
            try {
                int regnum = Integer.valueOf(actual);
                return this.r[regnum];
            }
            catch (NumberFormatException NumExc) {
                throw new EVASyntaxException("Wrong register format");
            }
        }
        if (actual.charAt(0) == 'v') {
            actual = actual.substring(1, actual.length());
            try {
                int regnum = Integer.valueOf(actual);
                return this.v[regnum];
            }
            catch (NumberFormatException NumExc) {
                throw new EVASyntaxException("Wrong register format");
            }
        }
        if (actual.charAt(0) == 'a') {
            actual = actual.substring(1, actual.length());
            try {
                int regnum = Integer.valueOf(actual);
                return this.a[regnum];
            }
            catch (NumberFormatException NumExc) {
                throw new EVASyntaxException("Wrong register format");
            }
        }
        if (actual.substring(0, 3).equalsIgnoreCase("exc")) {
            return this.exc;
        }
        if (actual.substring(0, 3).equalsIgnoreCase("obj")) {
            return this.obj;
        }
        throw new EVASyntaxException("Wrong register format");
    }

    private int getLine(String toSearch, int elsegmento) {
        int i = 0;
        while (i < this.cont[elsegmento]) {
            String label;
            StringTokenizer st = new StringTokenizer(this.segmento[elsegmento][i], ":");
            if (st.countTokens() > 1 && (label = st.nextToken().trim()).equalsIgnoreCase(toSearch)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String getMem(String toSearch) throws EVASyntaxException {
        int l = this.getLine(toSearch, 1);
        if (l < 0) {
            throw new EVASyntaxException("Line " + toSearch + " doesn't exist in data segment");
        }
        StringTokenizer st = new StringTokenizer(this.segmento[1][l], ":");
        if (st.countTokens() > 1) {
            st.nextToken();
            return st.nextToken().trim();
        }
        return "";
    }

    private void setMem(String toSearch, String value) throws EVASyntaxException {
        int l = this.getLine(toSearch, 1);
        if (l < 0) {
            throw new EVASyntaxException("Line " + toSearch + " doesn't exist in data segment");
        }
        StringTokenizer st = new StringTokenizer(this.segmento[1][l], ":");
        this.segmento[1][l] = String.valueOf(st.nextToken()) + ": " + value.trim();
    }

    private void addMem(String toSearch, String value) {
        int l = this.getLine(toSearch, 1);
        if (l >= 0) {
            StringTokenizer st = new StringTokenizer(this.segmento[1][l], ":");
            this.segmento[1][l] = String.valueOf(st.nextToken()) + ": " + value.trim();
        } else {
            this.segmento[1][this.cont[1]] = String.valueOf(toSearch.trim()) + ": " + value.trim();
            this.cont[1] = this.cont[1] + 1;
        }
    }

    private void addToDataSegment(String stringToAdd) {
        StringTokenizer st = new StringTokenizer(stringToAdd, "\n");
        while (st.hasMoreTokens()) {
            StringTokenizer linest = new StringTokenizer(st.nextToken(), ":");
            String label = linest.nextToken();
            String content = "";
            while (linest.hasMoreTokens()) {
                content = String.valueOf(content) + linest.nextToken();
            }
            this.addMem(label, content);
        }
    }

    private void execFunction(String functionToExec) throws EVASyntaxException {
        if (functionToExec.equalsIgnoreCase("escribir")) {
            this.ourWorld.escribir(this.getReg("$a0"));
        } else if (functionToExec.equalsIgnoreCase("newline")) {
            this.ourWorld.escribir("\n");
        } else if (functionToExec.equalsIgnoreCase("getstate")) {
            int objid;
            try {
                objid = Integer.valueOf(this.getReg("$Obj"));
            }
            catch (NumberFormatException nfe) {
                this.setReg("$Exc", "NotANumber");
                return;
            }
            Entity ourObject = this.ourWorld.getObject(objid);
            if (ourObject == null) {
                this.setReg("$Exc", "NotAnIDNumber");
                return;
            }
            this.setReg("$v0", String.valueOf(ourObject.getState()));
        } else if (functionToExec.equalsIgnoreCase("setstate")) {
            long newtuleft;
            int newstate;
            int objid;
            try {
                objid = Integer.valueOf(this.getReg("$Obj"));
                newstate = Integer.valueOf(this.getReg("$a0"));
                newtuleft = Long.valueOf(this.getReg("$a1"));
            }
            catch (NumberFormatException nfe) {
                this.setReg("$Exc", "NotANumber");
                return;
            }
            Entity ourObject = this.ourWorld.getObject(objid);
            if (ourObject == null) {
                this.setReg("$Exc", "NotAnIDNumber");
                return;
            }
            ourObject.setNewState(newstate, newtuleft);
        } else if (functionToExec.equalsIgnoreCase("getrelationshipstate")) {
            int objid2;
            int objid1;
            try {
                objid1 = Integer.valueOf(this.getReg("$Obj"));
                objid2 = Integer.valueOf(this.getReg("$a0"));
            }
            catch (NumberFormatException nfe) {
                this.setReg("$Exc", "NotANumber");
                return;
            }
            Mobile ourObject1 = (Mobile)this.ourWorld.getObject(objid1);
            Entity ourObject2 = this.ourWorld.getObject(objid2);
            if (ourObject1 == null || ourObject2 == null) {
                this.setReg("$Exc", "NotAnIDNumber");
                return;
            }
            this.setReg("$v0", String.valueOf(ourObject1.getRelationshipState(ourObject2)));
        } else if (functionToExec.equalsIgnoreCase("setrelationshipstate")) {
            int newstate;
            int objid2;
            int objid1;
            try {
                objid1 = Integer.valueOf(this.getReg("$Obj"));
                objid2 = Integer.valueOf(this.getReg("$a0"));
                newstate = Integer.valueOf(this.getReg("$a1"));
            }
            catch (NumberFormatException nfe) {
                this.setReg("$Exc", "NotANumber");
                return;
            }
            Mobile ourObject1 = (Mobile)this.ourWorld.getObject(objid1);
            Entity ourObject2 = this.ourWorld.getObject(objid2);
            if (ourObject1 == null || ourObject2 == null) {
                this.setReg("$Exc", "NotAnIDNumber");
                return;
            }
            ourObject1.setRelationshipState(ourObject2, newstate);
            long prueba = (long)ourObject1.getRelationshipState(ourObject2) * (long)Math.pow(2.0, 32.0);
        } else if (functionToExec.equalsIgnoreCase("waitkeypress")) {
            int objid1;
            try {
                objid1 = Integer.valueOf(this.getReg("$Obj"));
            }
            catch (NumberFormatException nfe) {
                this.setReg("$Exc", "NotANumber");
                return;
            }
            Player ourObject1 = (Player)this.ourWorld.getObject(objid1);
            if (ourObject1 == null) {
                this.setReg("$Exc", "NotAnIDNumber");
                return;
            }
            ourObject1.waitKeyPress();
        } else if (functionToExec.equalsIgnoreCase("force")) {
            String s;
            int objid1;
            try {
                objid1 = Integer.valueOf(this.getReg("$Obj"));
                s = this.getReg("$a0");
            }
            catch (NumberFormatException nfe) {
                this.setReg("$Exc", "NotANumber");
                return;
            }
            Player ourObject1 = (Player)this.ourWorld.getObject(objid1);
            if (ourObject1 == null) {
                this.setReg("$Exc", "NotAnIDNumber");
                return;
            }
            ourObject1.forceCommand(s);
        } else if (functionToExec.equalsIgnoreCase("clearscreen")) {
            int objid1;
            try {
                objid1 = Integer.valueOf(this.getReg("$Obj"));
            }
            catch (NumberFormatException nfe) {
                this.setReg("$Exc", "NotANumber");
                return;
            }
            Player ourObject1 = (Player)this.ourWorld.getObject(objid1);
            if (ourObject1 == null) {
                this.setReg("$Exc", "NotAnIDNumber");
                return;
            }
            ourObject1.borrarPantalla();
        } else if (functionToExec.equalsIgnoreCase("makerandomvalidmove")) {
            int objid1;
            try {
                objid1 = Integer.valueOf(this.getReg("$Obj"));
            }
            catch (NumberFormatException nfe) {
                this.setReg("$Exc", "NotANumber");
                return;
            }
            Mobile ourObject1 = (Mobile)this.ourWorld.getObject(objid1);
            if (ourObject1 == null) {
                this.setReg("$Exc", "NotAnIDNumber");
                return;
            }
            ourObject1.makeRandomValidMove();
        } else {
            if (functionToExec.equalsIgnoreCase("issubstringof")) {
                String s1 = this.getReg("$a0");
                String s2 = this.getReg("$a1");
                this.setReg("$v0", String.valueOf(StringMethods.isSubstringOf(s1, s2)));
                return;
            }
            if (functionToExec.equalsIgnoreCase("referstoentity")) {
                int objid1;
                try {
                    objid1 = Integer.valueOf(this.getReg("$a0"));
                }
                catch (NumberFormatException nfe) {
                    this.setReg("$Exc", "NotANumber");
                    return;
                }
                Entity ourObject1 = this.ourWorld.getObject(objid1);
                if (ourObject1 == null) {
                    this.setReg("$Exc", "NotAnIDNumber");
                    return;
                }
                String s = this.getReg("$Obj");
                String plurString = this.getReg("$a1");
                boolean plural = plurString == null ? false : plurString.equalsIgnoreCase("true");
                this.setReg("$v0", String.valueOf(ParserMethods.refersToEntity(s, ourObject1, plural)));
            } else if (functionToExec.equalsIgnoreCase("referstoentities")) {
                boolean plural1;
                int objid2;
                int objid1;
                try {
                    objid1 = Integer.valueOf(this.getReg("$a0"));
                    objid2 = Integer.valueOf(this.getReg("$a1"));
                }
                catch (NumberFormatException nfe) {
                    this.setReg("$Exc", "NotANumber");
                    return;
                }
                Entity ourObject1 = this.ourWorld.getObject(objid1);
                Entity ourObject2 = this.ourWorld.getObject(objid2);
                if (ourObject1 == null || ourObject2 == null) {
                    this.setReg("$Exc", "NotAnIDNumber");
                    return;
                }
                String s = this.getReg("$Obj");
                String plurString1 = this.getReg("$a2");
                String plurString2 = this.getReg("$a3");
                boolean bl = plurString1 == null ? false : (plural1 = plurString1.equalsIgnoreCase("true"));
                boolean plural2 = plurString2 == null ? false : plurString2.equalsIgnoreCase("true");
                this.setReg("$v0", String.valueOf(ParserMethods.refersToEntities(s, ourObject1, ourObject2, plural1, plural2)));
            } else if (functionToExec.equalsIgnoreCase("giveitem")) {
                int objid2;
                int objid1;
                try {
                    objid1 = Integer.valueOf(this.getReg("$Obj"));
                    objid2 = Integer.valueOf(this.getReg("$a0"));
                }
                catch (NumberFormatException nfe) {
                    this.setReg("$Exc", "NotANumber");
                    return;
                }
                Mobile ourMobile = null;
                try {
                    ourMobile = (Mobile)this.ourWorld.getObject(objid1);
                }
                catch (ClassCastException cce) {
                    Room ourRoom = (Room)this.ourWorld.getObject(objid1);
                    Item ourItem = (Item)this.ourWorld.getObject(objid2);
                    if (ourRoom == null || ourItem == null) {
                        this.setReg("$Exc", "NotAnIDNumber");
                        return;
                    }
                    try {
                        ourRoom.addItem(ourItem);
                    }
                    catch (WeightLimitExceededException wlee) {
                        this.setReg("$Exc", "WeightLimitExceeded");
                    }
                    catch (VolumeLimitExceededException vlee) {
                        this.setReg("$Exc", "VolumeLimitExceeded");
                    }
                }
                Item ourItem = (Item)this.ourWorld.getObject(objid2);
                if (ourMobile == null || ourItem == null) {
                    this.setReg("$Exc", "NotAnIDNumber");
                    return;
                }
                try {
                    ourMobile.addItem(ourItem);
                }
                catch (WeightLimitExceededException wlee) {
                    this.setReg("$Exc", "WeightLimitExceeded");
                }
                catch (VolumeLimitExceededException vlee) {
                    this.setReg("$Exc", "VolumeLimitExceeded");
                }
            } else if (functionToExec.equalsIgnoreCase("removeitem")) {
                int objid2;
                int objid1;
                try {
                    objid1 = Integer.valueOf(this.getReg("$Obj"));
                    objid2 = Integer.valueOf(this.getReg("$a0"));
                }
                catch (NumberFormatException nfe) {
                    this.setReg("$Exc", "NotANumber");
                    return;
                }
                Mobile ourMobile = null;
                Item ourItem = (Item)this.ourWorld.getObject(objid2);
                try {
                    ourMobile = (Mobile)this.ourWorld.getObject(objid1);
                }
                catch (ClassCastException cce) {
                    Room ourRoom = (Room)this.ourWorld.getObject(objid1);
                    if (ourRoom == null || ourItem == null) {
                        this.setReg("$Exc", "NotAnIDNumber");
                        return;
                    }
                    this.setReg("$v0", String.valueOf(ourRoom.removeItem(ourItem)));
                }
                if (ourMobile == null || ourItem == null) {
                    this.setReg("$Exc", "NotAnIDNumber");
                    return;
                }
                this.setReg("$v0", String.valueOf(ourMobile.removeItem(ourItem)));
            } else if (functionToExec.equalsIgnoreCase("hasitem")) {
                int objid2;
                int objid1;
                try {
                    objid1 = Integer.valueOf(this.getReg("$Obj"));
                    objid2 = Integer.valueOf(this.getReg("$a0"));
                }
                catch (NumberFormatException nfe) {
                    this.setReg("$Exc", "NotANumber");
                    return;
                }
                Mobile ourMobile = null;
                Item ourItem = (Item)this.ourWorld.getObject(objid2);
                try {
                    ourMobile = (Mobile)this.ourWorld.getObject(objid1);
                }
                catch (ClassCastException cce) {
                    Room ourRoom = (Room)this.ourWorld.getObject(objid1);
                    if (ourRoom == null || ourItem == null) {
                        this.setReg("$Exc", "NotAnIDNumber");
                        return;
                    }
                    this.setReg("$v0", String.valueOf(ourRoom.hasItem(ourItem)));
                }
                if (ourMobile == null || ourItem == null) {
                    this.setReg("$Exc", "NotAnIDNumber");
                    return;
                }
                this.setReg("$v0", String.valueOf(ourMobile.hasItem(ourItem)));
            } else {
                throw new EVASyntaxException("Unrecognized or unsupported function: " + functionToExec);
            }
        }
    }
}

