/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.sql.SQLException;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.Util;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.server.HsqlSocketRequestHandler;
import org.hsqldb.server.Server;

public class HsqlServerFactory {
    private HsqlServerFactory() {
    }

    public static HsqlSocketRequestHandler createHsqlServer(String string, boolean bl, boolean bl2) throws SQLException {
        HsqlProperties hsqlProperties = new HsqlProperties();
        hsqlProperties.setProperty("server.database.0", string);
        hsqlProperties.setProperty("server.trace", bl);
        hsqlProperties.setProperty("server.silent", bl2);
        Server server = new Server();
        try {
            server.setProperties(hsqlProperties);
        }
        catch (Exception exception) {
            throw new SQLException("Failed to set server properties: " + exception);
        }
        if (!server.openDatabases()) {
            Throwable throwable = server.getServerError();
            if (throwable instanceof HsqlException) {
                throw Util.sqlException((HsqlException)throwable);
            }
            throw Util.sqlException(Error.error(458));
        }
        server.setState(1);
        return server;
    }
}

