/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.hsqldb.DatabaseURL;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.Util;
import org.hsqldb.persist.HsqlProperties;

public class JDBCDriver
implements Driver {
    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        return JDBCDriver.getConnection(string, properties);
    }

    public static Connection getConnection(String string, Properties properties) throws SQLException {
        final HsqlProperties hsqlProperties = DatabaseURL.parseURL(string, true, false);
        if (hsqlProperties == null) {
            throw Util.invalidArgument();
        }
        if (hsqlProperties.isEmpty()) {
            return null;
        }
        hsqlProperties.addProperties(properties);
        long l = DriverManager.getLoginTimeout();
        if (l == 0L) {
            return new JDBCConnection(hsqlProperties);
        }
        String string2 = hsqlProperties.getProperty("connection_type");
        if (DatabaseURL.isInProcessDatabaseType(string2)) {
            return new JDBCConnection(hsqlProperties);
        }
        final JDBCConnection[] jDBCConnectionArray = new JDBCConnection[1];
        final SQLException[] sQLExceptionArray = new SQLException[1];
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    jDBCConnectionArray[0] = new JDBCConnection(hsqlProperties);
                }
                catch (SQLException sQLException) {
                    sQLExceptionArray[0] = sQLException;
                }
            }
        };
        thread.start();
        long l2 = System.currentTimeMillis();
        try {
            thread.join(1000L * l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            thread.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sQLExceptionArray[0] != null) {
            throw sQLExceptionArray[0];
        }
        if (jDBCConnectionArray[0] != null) {
            return jDBCConnectionArray[0];
        }
        throw Util.sqlException(1351);
    }

    @Override
    public boolean acceptsURL(String string) {
        if (string == null) {
            return false;
        }
        return string.regionMatches(true, 0, "jdbc:hsqldb:", 0, "jdbc:hsqldb:".length());
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        if (!this.acceptsURL(string)) {
            return new DriverPropertyInfo[0];
        }
        String[] stringArray = new String[]{"true", "false"};
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[6];
        if (properties == null) {
            properties = new Properties();
        }
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("user", null);
        driverPropertyInfo.value = properties.getProperty("user");
        driverPropertyInfo.required = true;
        driverPropertyInfoArray[0] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("password", null);
        driverPropertyInfo.value = properties.getProperty("password");
        driverPropertyInfo.required = true;
        driverPropertyInfoArray[1] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("get_column_name", null);
        driverPropertyInfo.value = properties.getProperty("get_column_name", "true");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[2] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("ifexists", null);
        driverPropertyInfo.value = properties.getProperty("ifexists", "false");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[3] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("default_schema", null);
        driverPropertyInfo.value = properties.getProperty("default_schema", "false");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[4] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("shutdown", null);
        driverPropertyInfo.value = properties.getProperty("shutdown", "false");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[5] = driverPropertyInfo;
        return driverPropertyInfoArray;
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    static {
        try {
            DriverManager.registerDriver(new JDBCDriver());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

